package org.codehaus.modello.plugin.java;

/*
 * Copyright 2001-2006 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.util.List;

/**
 * Test Interface used by {@link JavaGeneratorTest#testBiDirectionalJavaGenerator()} to ensure that
 * interface overrides can be used. 
 *
 * @author <a href="mailto:joakim@erdfelt.com">Joakim Erdfelt</a>
 * @version $Id: Role.java 1094 2009-01-02 22:06:17Z hboutemy $
 */
public interface Role
{
    public String getName();
    
    public void setName(String name);
    
    public void setRoles(List roles);
    
    public List getRoles();
    
    public void addRole(Role role);
    
    public void removeRole(Role role);
    
    public void setPermission(Permission permission);
    
    public Permission getPermission();
}
