/*
  Copyright (C) 2008 Jan Friederich, André Gaul

        This file is part of mmpong.

        mmpong is free software: you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version.

        mmpong is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with mmpong.  If not, see <http://www.gnu.org/licenses/>.
*/


#ifndef __GUI_H__
#define __GUI_H__

#include <CEGUI.h>
#include <RendererModules/OpenGLGUIRenderer/openglrenderer.h>
#include <CEGUILogger.h>
#include "clientstate.h"

class dummyLogger : public CEGUI::Logger {
public:
	dummyLogger() : CEGUI::Logger() {};
	~dummyLogger() {};
	void logEvent(const CEGUI::String& message, CEGUI::LoggingLevel level = CEGUI::Standard) {};
	void setLogFilename(const CEGUI::String& filename, bool append = false) {};
};

class GUI {
private:
	bool visible;
	ClientState *state;
	CEGUI::OpenGLRenderer *renderer;
	dummyLogger *log;
	CEGUI::System *sys;
	double last_time;
	void handle_mouse_down(Uint8 button);
	void handle_mouse_up(Uint8 button);

	// gui elements
	CEGUI::Window *win_config;
	CEGUI::Editbox *edit_server, *edit_port;
	CEGUI::Checkbox *check_sexy, *check_sound, *check_full;

	
	// gui actions
	bool on_sexy(const CEGUI::EventArgs &e);
	bool on_sound(const CEGUI::EventArgs &e);
	bool on_full(const CEGUI::EventArgs &e);
	bool on_quit(const CEGUI::EventArgs &e);
	bool on_cancel(const CEGUI::EventArgs &e);
	bool on_connect(const CEGUI::EventArgs &e);

	// dialog elements
	CEGUI::Window *win_dialog;
	CEGUI::Window *stext_dialog;

	// dialog actions
	bool on_dialog_ok(const CEGUI::EventArgs &e);
	
public:
	GUI(std::string resbase, int w, int h, bool _visible, ClientState *_state); 
	void resize_init();
	void resize_finish(int w, int h);
	void set_full(bool _full);
	void set_visible(bool _visible) { visible = _visible; };
	bool get_visible() { return visible; };
	int handle_event(SDL_Event &e);
	void render();
	void show_dialog(const std::string &title, const std::string &message);
};

#endif
