C **************************** LICENSE START ***********************************
C
C Copyright 2012 ECMWF and INPE. This software is distributed under the terms
C of the Apache License version 2.0. In applying this license, ECMWF does not
C waive the privileges and immunities granted to it by virtue of its status as
C an Intergovernmental Organization or submit itself to any jurisdiction.
C
C ***************************** LICENSE END ************************************

      FUNCTION PML(PSLN,KL,FVERTB,NVERT)
C
C
C        P. VITERBO   E.C.M.W.F   26/06/90
C
C     PURPOSE
C     -------
C
C*    COMPUTES THE PRESSURE AT MODEL LEVEL KL GIVEN THE VERTICAL
C*    COORDINATE TABLE AND LOG(PS).
C
C
C     PARAMETERS
C     ----------
C
C     KL       MODEL LEVEL WHERE THE PRESSURE IS CALCULATED
C     NVERT    LENGTH OF THE ARRAY FVERTB(FROM THE MARS DECOGB ROUTINE)
C     PSLN     LOGARITHM OF THE SURFACE PRESSURE
C     FVERTB   VERTICAL COORDINATE ARRAY
C
      DIMENSION FVERTB(*)
C
      ILEVP1=NVERT/2
      ZPS=EXP(PSLN)
C
      ZPHALF1=FVERTB(KL  )+FVERTB(KL  +ILEVP1)*ZPS
      ZPHALF2=FVERTB(KL+1)+FVERTB(KL+1+ILEVP1)*ZPS
C
      PML = (ZPHALF1+ZPHALF2)*.5
c      WRITE(*,'('' LEVEL '',I3,
c     1          '' A='',2G15.4,'', B='',2g15.4,'', PS ='',G15.4
c     1        ,'' PRESSURE ='',G15.4)')KL,FVERTB(KL),FVERTB(KL+1),
c     1        FVERTB(KL+ILEVP1),FVERTB(KL+1+ILEVP1),ZPS,PML

      RETURN
      END

