
/*******************************  LICENSE  *******************************

 * (C) Copyright 1996-2016 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \fileNetcdfInterpretorAttributes.h
    \brief Definition of NetcdfInterpretor Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 
*/
   

#ifndef NetcdfInterpretorAttributes_H
#define NetcdfInterpretorAttributes_H

#include "magics.h"
namespace magics {

class XmlNode;
class NetcdfInterpretorAttributes 
{
public:
//  --  constructor
    NetcdfInterpretorAttributes();
    
//  --  destructor
    virtual ~NetcdfInterpretorAttributes();
    
    virtual void set(const std::map<std::string, std::string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const NetcdfInterpretorAttributes&);
    virtual bool accept(const std::string&);

    void setTag(const std::string& tag) { tag_ = tag; }

public:
	//  --  method
	virtual void print(std::ostream&) const;
	virtual void toxml(std::ostream& out) const;
	//  --  members:
	string tag_;
	string path_;
	stringarray dimension_;
	string time_variable_;
	string level_variable_;
	string number_variable_;
	string time_dimension_;
	string level_dimension_;
	string number_dimension_;
	string dimension_method_;
	string latitude_;
	string longitude_;
	string speed_;
	string direction_;
	string field_;
	string x_component_;
	string y_component_;
	string colour_component_;
	bool automatic_scaling_;
	double scaling_;
	double offset_;
	string missing_attribute_;
	string reference_;
	double suppress_below_;
	double suppress_above_;
	string x_;
	string x2_;
	string y_;
	string y2_;
	string aux_x_;
	string geo_x_convention_;
	string geo_y_convention_;
	string aux_y_;
	string primary_index_;
	string interpretation_;
	bool ignore_missing_;
	 

private:
	friend ostream& operator<<(ostream& s,const NetcdfInterpretorAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif

