/*
    VLDocking Framework 2.1
    Copyright VLSOLUTIONS, 2004-2006

    email : info@vlsolutions.com
------------------------------------------------------------------------
This software is distributed under the CeCILL license, a GNU GPL-compatible
license adapted to french law.
French and English license headers are provided at the begining of
the source files of this software application.
------------------------------------------------------------------------
LICENCE CeCILL (FRENCH VERSION).
------------------------------------------------------------------------
Ce logiciel est un programme informatique servant  amliorer les interfaces
homme-machine d'applications Java bases sur Swing, en leur apportant un
ensemble de fonctions relatives au dockage des composants.

Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA
sur le site "http://www.cecill.info".

En contrepartie de l'accessibilit au code source et des droits de copie,
de modification et de redistribution accords par cette licence, il n'est
offert aux utilisateurs qu'une garantie limite.  Pour les mmes raisons,
seule une responsabilit restreinte pse sur l'auteur du programme,  le
titulaire des droits patrimoniaux et les concdants successifs.

A cet gard  l'attention de l'utilisateur est attire sur les risques
associs au chargement,   l'utilisation,   la modification et/ou au
dveloppement et  la reproduction du logiciel par l'utilisateur tant
donn sa spcificit de logiciel libre, qui peut le rendre complexe 
manipuler et qui le rserve donc  des dveloppeurs et des professionnels
avertis possdant  des  connaissances  informatiques approfondies.  Les
utilisateurs sont donc invits  charger  et  tester  l'adquation  du
logiciel  leurs besoins dans des conditions permettant d'assurer la
scurit de leurs systmes et ou de leurs donnes et, plus gnralement,
 l'utiliser et l'exploiter dans les mmes conditions de scurit.

Le fait que vous puissiez accder  cet en-tte signifie que vous avez
pris connaissance de la licence CeCILL, et que vous en avez accept les
termes.

------------------------------------------------------------------------
CeCILL License (ENGLISH VERSION)
------------------------------------------------------------------------

This software is a computer program whose purpose is to enhance Human-Computer
Interfaces written in Java with the Swing framework, providing them a set of
functions related to component docking.

This software is governed by the CeCILL  license under French law and
abiding by the rules of distribution of free software.  You can  use,
modify and/ or redistribute the software under the terms of the CeCILL
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info".

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability.

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or
data to be ensured and,  more generally, to use and operate it in the
same conditions as regards security.

The fact that you are presently reading this means that you have had
knowledge of the CeCILL license and that you accept its terms.

*/


package com.vlsolutions.swing.docking.event;

import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockingDesktop;

/** An abstract event class describing a docking action.
 *<p> 
 * This event is used to explain a dockable action : it doesn't contain any information 
 * about the current state of a dockable, but describes precisely what we want to do 
 * with it (for example, detach it, or left-split another dockable).
 *<p>
 * The DockingActionDockableEvent abstract subclass is used as a superclass for all events 
 * associated to a single dockable.
 *<p>
 * Concrete sub classes are used for every type of docking action (split, tab...)
 * 
 * @since 2.1 
 *
 * @author Lilian Chamontin, VLSolutions
 */
public abstract class DockingActionEvent implements Cloneable {
  
  /* action descriptors : allow for fast switch/case tests */
  /** Field associated to a closing action */
  public static final int ACTION_CLOSE = 0;
  /** Field associated to an addDockable action */
  public static final int ACTION_ADD_DOCKABLE = 1;
  
  /** Field associated to a split dockable action */
  public static final int ACTION_SPLIT_DOCKABLE = 2;
  
  /** Field associated to a split component action */
  public static final int ACTION_SPLIT_COMPONENT = 3;
  
  /** Field associated to a multipurpose (API internals) splut container action */
  public static final int ACTION_SPLIT_DOCKABLE_CONTAINER = 4;

  /** Field associated to a createTab action */
  public static final int ACTION_CREATE_TAB = 5;
  
  /** A multipurpose action used to describe maximize, hide and detach actions */
  public static final int ACTION_STATE_CHANGE = 6;
  
  
  private int initialState;
  private int nextState;
  private int actionType;
  private DockingDesktop desktop;
  
  /** Constructs a new DockingActionEvent 
   * 
   * @param targetDesktop the desktop that will receive the action .
   * @param initialState  the initial (before action) DockableState (DockableState.STATE_FLOATING...)
   * @param nextState     the next (after action) DockableState (DockableState.STATE_DOCKED...)
   * @param actionType    a field defining the type of action used (ACTION_CLOSE...)
   */
  public DockingActionEvent(DockingDesktop targetDesktop, int initialState, int nextState, int actionType) {
    this.desktop = targetDesktop;
    this.initialState = initialState;
    this.nextState = nextState;
    this.actionType = actionType;
  }

  /** Returns one of the DockableState states reflecting the state of the dockable before the action */
  public int getInitialDockableState() {
    return initialState;
  }

  /** Returns one of the DockableState states reflecting the state of the dockable after the action */
  public int getNextDockableState() {
    return nextState;
  }

  /** Returns a field describing the action (ACTION_CLOSE...).
   */
  public int getActionType() {
    return actionType;
  }

  /** Returns the desktop used as a receiver (target) of the docking action.
   *<p>
   * The desktop used as a source (on multi-desktop applications) can be retrieved by asking for 
   * the current dockable state (to the DockingContext).
   */
  public DockingDesktop getDesktop(){
    return desktop;
  }
  
  /** Overriden clone method */
  public Object clone(){
    try {
      return super.clone();
    } catch (CloneNotSupportedException e){
      e.printStackTrace();
      throw new RuntimeException(e);
    }
  }
  
  
}
