/*
 * Decompiled with CFR 0.152.
 */
package org.boehn.kmlframework.coordinates;

import org.boehn.kmlframework.coordinates.CartesianCoordinate;
import org.boehn.kmlframework.coordinates.Coordinate;
import org.boehn.kmlframework.kml.AltitudeModeEnum;
import org.boehn.kmlframework.kml.Point;

public class EarthCoordinate
extends Point
implements Coordinate {
    public static double EARTHRADIUS = 6372795.477598;

    public EarthCoordinate() {
    }

    public EarthCoordinate(Double longitude, Double latitude) {
        super(longitude, latitude);
    }

    public EarthCoordinate(Double longitude, Double latitude, Double altitude) {
        super(longitude, latitude, altitude);
    }

    public EarthCoordinate(Boolean extrude, AltitudeModeEnum altitudeMode, Double longitude, Double latitude, Double altitude) {
        super(extrude, altitudeMode, longitude, latitude, altitude);
    }

    public double getRadius() {
        return this.getAltitude() + EARTHRADIUS;
    }

    public CartesianCoordinate toCartesianCoordinate() {
        CartesianCoordinate cartesianCoordinate = new CartesianCoordinate();
        cartesianCoordinate.setX(this.getRadius() * Math.sin(1.5707963267948966 - this.getLatitude() * (Math.PI / 180)) * Math.cos(this.getLongitude() * (Math.PI / 180)));
        cartesianCoordinate.setY(this.getRadius() * Math.sin(1.5707963267948966 - this.getLatitude() * (Math.PI / 180)) * Math.sin(this.getLongitude() * (Math.PI / 180)));
        cartesianCoordinate.setZ(this.getRadius() * Math.cos(1.5707963267948966 - this.getLatitude() * (Math.PI / 180)));
        return cartesianCoordinate;
    }

    public double distanceTo(EarthCoordinate earthCoordinate) {
        return this.toCartesianCoordinate().distanceTo(earthCoordinate.toCartesianCoordinate());
    }

    public String toString() {
        return "[longitude: " + this.getLongitude() + ", latitude: " + this.getLatitude() + ", altitude: " + this.getAltitude() + "]";
    }

    public EarthCoordinate toEarthCoordinate(EarthCoordinate earthCoordinate, Double rotation, CartesianCoordinate localReferenceCoordinate, CartesianCoordinate scale) {
        return this;
    }
}

