#!/usr/bin/env python
import gettext
from gettext import gettext as _

gettext.textdomain("weblive-install-packages")
import thread, socket, sys, apt, glob, os, string

from weblive import WebLive
wl=WebLive('https://weblive.stgraber.org/weblive/json',False)

import pygtk
pygtk.require("2.0")
import gtk
import apt.progress.gtk2

progress = apt.progress.gtk2.GtkAptProgress()
cache = apt.Cache(progress.open)

# Make sure we are allowed to install packages and package isn't blacklisted
wanted_packages=sys.argv[1:]
packages=[]
serverid=socket.gethostname()
servers=wl.list_everything()
if serverid in servers and servers[serverid]['autoinstall']:
    for package in wanted_packages:
        if not package in cache:
            for desktop in glob.glob("/usr/share/app-install/desktop/*.desktop"):
                xdg_package=None
                xdg_exec=None
                for line in map(string.strip, open(desktop)):
                    if line.startswith("Exec="):
                        xdg_exec=line.split("=")[1].split()[0]

                    if line.startswith("X-AppInstall-Package="):
                        xdg_package=line.split("=")[1]

                if xdg_package and xdg_exec and xdg_exec in package:
                    wanted_packages.remove(package)
                    wanted_packages.append(xdg_package)
                    break

    for package in servers[serverid]['packages']:
        if package[0] in wanted_packages:
            try:
                packages.append(package[0])
                cache[package[0]].mark_install()
            except:
                print _("Failed to install package: %s") % package[0]

# Create GTK window
win = gtk.Window()
win.connect("destroy", lambda a: sys.exit(1))
win.set_title("Installing packages")
win.set_resizable(False)
win.set_position(gtk.WIN_POS_CENTER)
win.set_type_hint(gtk.gdk.WINDOW_TYPE_HINT_MENU)

label = gtk.Label()
label.set_markup(_("We are currently installing the package you requested: <b>%s</b>\nPlease wait, this can take some time.") % ",".join(packages))

vbox = gtk.VBox(False, 12)
vbox.set_border_width(12)
vbox.pack_start(label)
vbox.pack_start(progress)

win.add(vbox)
win.show_all()

# Apply the changes
progress.hide_terminal()
progress.show()
cache.commit(progress.fetch, progress.install)

# Cleanup
for path in glob.glob("/var/cache/apt/archives/*.deb"):
    os.unlink(path)
