#include "tool_helper_line_width_setting.hpp"
#include "nlohmann/json.hpp"
#include "imp/imp_interface.hpp"

namespace horizon {

ToolHelperLineWidthSetting::ToolHelperLineWidthSetting(Core *c, ToolID tid) : ToolBase(c, tid)
{
}

void ToolHelperLineWidthSetting::Settings::load_from_json(const json &j)
{
    width = j.value("width", 0);
}

json ToolHelperLineWidthSetting::Settings::serialize() const
{
    json j;
    j["width"] = width;
    return j;
}

void ToolHelperLineWidthSetting::ask_line_width()
{
    auto r = imp->dialogs.ask_datum("Enter width", settings.width);
    if (r.first) {
        settings.width = std::max(r.second, (int64_t)0);
        apply_settings();
    }
}

} // namespace horizon
