%
% Function run_tests
%
%  Runs the complete set of tests for FreeMat
%  This file is autogenerated by helpgen (the help compiler)
%  Any changes will be lost!

% Copyright (c) 2002-2007 Samit Basu
% Licensed under the GPL

function run_tests
   run_path = pwd;
   myloc = which('run_tests');
   [pth,name,sfx] = fileparts(myloc);
   cd(pth);
   testlist = filelist('bbtest_*.m');
   testlist = [testlist;filelist('wbtest_*.m')];
   testlist = [testlist;filelist('test_*.m')];
   exclude_list = {'bbtest_csvread','bbtest_source','bbtest_import'};
   spath = getpath;
   failed = {};
   quiet quiet;
   for i=1:numel(testlist);
     cd(run_path);
     save run_tests.dat run_path testlist failed spath
     if (~any(strcmp(testlist{i}(1:end-2),exclude_list)))
       success = eval(testlist{i}(1:end-2),'0');
     else
       success = 1;
     end
     cd(run_path);
     load run_tests.dat
     setpath(spath);
     if (isempty(success) || ~success) failed = [failed,testlist(i)]; end;
     printf('Completed test %s\n',testlist{i}(1:end-2));
     close all
   end
   printf('****************************************\n');
   printf('*  Test Summary                        *\n');
   printf('****************************************\n');
   printf('\n');
   printf('Number of tests: %d\n',numel(testlist));
   if (numel(failed) == 0)
     printf('*** ALL TESTS PASSED ***\n');
   else
     printf('Failed tests: %d\n',numel(failed));
     for i=1:numel(failed)
        printf('   Test %s failed\n',failed{i});
     end
   end
   quiet normal;
   

function list = filelist(pattern)
   q = dir(pattern);
   list = {};
   for i=1:numel(q)
      if (~q(i).isdir)
         list = [list;{q(i).name}];
      end
   end
      
