# Enki

Enki is an open source robot simulator written in C++.
It provides collision and limited physics support for robots evolving on a flat surface.
On a contemporary desktop computer, Enki is able to simulate groups of robots hundred times faster than real-time.

© 1999-2017 Stéphane Magnenat and others ([full list](AUTHORS))

## Supported robots

This section presents the robots available in the standard distribution, alongside their supported features. Enki is extensible: users can add their own custom robots.

### Khepera

* IR sensors
* Linear camera
* Wheel encoders

### S-bot

* Omnidirectional camera
* Light ring
* Simplified sound communication

### Alice

* IR sensors
* IR communication
* Linear camera

### E-puck

* IR sensors
* Bluetooth communication
* Linear camera
* Scanner turret
* Light ring
* Wheel encoders

### Thymio 2

* IR proximity and ground sensors
* 27 LEDs and realistically-textured hull
* BackEMF speed meters

## License

Enki is free software released under the [GNU General Public License version 2](LICENSE).
We kindly ask the authors of any publication arising from research using this software to add a reference to it as explained in the documentation.

## Source distribution

This section explains how to compile Enki from the source distribution.

### Prerequisites

To compile Enki and programs who depend on it, you need:
* a working and fairly recent c++ compiler
* [CMake](https://cmake.org/)
* A build environment compatible with CMake.

In addition, if you want the support for the viewer and Python bindings, you need:
* [Qt 5](https://qt.io)
* [Python](https://www.python.org/) with development support
* [Boost.Python](http://www.boost.org/doc/libs/1_65_1/libs/python/doc/html/)

### Compilation under Unix

Those short instructions assume that you want to use "make" to build Enki.
If you want to use another build environment, such as Microsoft Visual Studio, please refer to [cmake documentation](https://cmake.org/documentation/).
Once you have downloaded and extracted the source distribution, you can create the Makefiles by running:

	cmake .

and then build Enki by running:

	make

You can also change the build options by running:

	ccmake .

or

	cmake-gui .

prior to cmake.

### Use

To use the library with a project using CMake, add these lines in your project:

	find_package(enki REQUIRED)

Then you can include the Enki directory with:

	include_directories(${enki_INCLUDE_DIR})

And link to the library, and optionally its viewer, by:

	target_link_libraries(YOUR_TARGET ${enki_VIEWER_LIBRARIES} ${enki_LIBRARY} ...)

Inside your code, include Enki and the viewer using:

	#include <enki/PhysicalEngine.h>
	#include <viewer/Viewer.h>


## Documentation

HTML documentation (including examples and cookbooks) can be generated by the
`doc` target of the build system.  Doxygen tool can be downloaded from
http://www.doxygen.org/

## Contribute

If you want to contribute to Enki, please open an issue to discuss your idea or submit a pull request with a prototype.

## Projects using Enki

* Enki can be used in the [Webots mobile robots simulator](http://www.cyberbotics.com/) to provide fast 2D.
* Enki the base of the [Aseba Playground](http://aseba.io) robot simulator and in the [Thymio VPL background simulation](https://github.com/aseba-community/thymio-vpl2/).
* Several research projects (Google scholar citations [1](https://scholar.google.ch/scholar?cites=16751866430169972002), [2](https://scholar.google.ch/scholar?cites=3374045595950005828), [3](https://scholar.google.ch/scholar?cites=6874965545282527171)).
