/*
  DB Mixer
  ========
  Description: 
    a DJ Mixer style GUI interface to the DBMix system.

	Copyright (c) 1999, 2000 Robert Michael S Dean

	Author: Robert Michael S Dean
	Version: 1.0


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public Licensse as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

 */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/shm.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <limits.h>
#include <fcntl.h>
#include <signal.h>
#include <gtk/gtk.h>

#include "dbmixer.h"
#include <dbdebug.h>

int debug_level;
GtkWidget* window;

int shmid, sysshmid;
dbfsd_data * sysdata;
local_channel * local_channels;

int channel_index;
int msg_q_id;

extern int standalone_flag;

GtkWidget * opt;


void test_channel_menu_select(GtkWidget *w, gpointer * data)
{
	Debug("bonk %d",data);

	channel_index = (int)data;
	msg_q_id = local_channels[channel_index].msg_q_id;
}


GtkWidget* test_make_channel_menu()
{
	GtkWidget * menu;
	GtkWidget * item;
	gint i;

	menu = gtk_menu_new();
		
	/* add options to channel selector */
	for(i = 0; i < sysdata->num_channels;i++)
	{
		item = make_menu_item (local_channels[i].channel_name,
							   GTK_SIGNAL_FUNC(test_channel_menu_select),
							   (gpointer *)i);
		gtk_menu_append (GTK_MENU (menu), item);
	}

	return menu;
}


void refresh_menu()
{
	GtkWidget * tempwidget;
	
	tempwidget = gtk_option_menu_get_menu(GTK_OPTION_MENU(opt));
	gtk_option_menu_remove_menu(GTK_OPTION_MENU(opt));
	tempwidget = test_make_channel_menu();
	
	gtk_menu_set_active(GTK_MENU(tempwidget), channel_index);
	gtk_option_menu_set_menu(GTK_OPTION_MENU(opt),tempwidget);
}


void button_clicked(GtkWidget *w, gint * data)
{
	dbfsd_msg msg;

	Debug("button clicked %d",data);

	if ((int)data == DBMSG_NONE)
	{
		refresh_menu();
		return;
	}

	msg.msg_type = (int)data;

	switch ((int)data)
	{
		case DBMSG_REWIND:
		case DBMSG_FFORWARD:
			msg.data = 5;
		break;
		default:
			break;
	}

	if(msgsnd(msg_q_id, &msg,sizeof(dbfsd_msg) - sizeof(long int),IPC_NOWAIT) == 0)
	{
		Debug("dbmsg_text: Message sent.");
	}
	else
	{
	    Error("dbmsg_test: Message failure.");
	}
}


void test_make_button(int value, char * str, GtkWidget * box)
{
	GtkWidget * button;
	GtkWidget * label;

	button = (GtkWidget *)gtk_button_new();
	label = gtk_label_new(str);
	gtk_container_add(GTK_CONTAINER(button),label);

	gtk_box_pack_start(GTK_BOX(box),GTK_WIDGET(button),TRUE,TRUE,5);
	gtk_signal_connect (GTK_OBJECT(button), "clicked", 
						GTK_SIGNAL_FUNC(button_clicked),(gpointer *)value);
	gtk_widget_show(label);
	gtk_widget_show(button);
}



void dbmsg_test_init()
{
	GtkWidget * main_box;
	GtkWidget * menu;
	GtkWidget * vbox;
	GtkWidget * selector_box;
	GtkWidget * row_box1;
	GtkWidget * row_box2;
	GtkWidget * label;
	GtkWidget * separator;

	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_signal_connect (GTK_OBJECT (window), "destroy",
						GTK_SIGNAL_FUNC(dbmixer_exit),
						NULL);

	gtk_widget_realize(window);

	main_box = gtk_hbox_new(FALSE,5);
	gtk_widget_show(main_box);
	vbox = gtk_vbox_new(FALSE,5);
	gtk_widget_show(vbox);
	selector_box = gtk_hbox_new(FALSE,5);
	gtk_widget_show(selector_box);
	row_box1 = gtk_hbox_new(FALSE,5);
	gtk_widget_show(row_box1);
	row_box2 = gtk_hbox_new(FALSE,5);
	gtk_widget_show(row_box2);	

	gtk_window_set_title (GTK_WINDOW (window), "DBMix IPC Message Test Program");

	label = (GtkWidget *) gtk_label_new("Channel:");
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(selector_box),label,FALSE,FALSE,10);
		
	opt = gtk_option_menu_new();
  	menu = test_make_channel_menu();
	gtk_option_menu_set_menu (GTK_OPTION_MENU (opt), menu);
	gtk_box_pack_start (GTK_BOX (selector_box), opt, FALSE, FALSE, 5);
	gtk_widget_show (opt);
	test_make_button(DBMSG_NONE,"Update Channels",selector_box);

		
	test_make_button(DBMSG_PAUSE,"PAUSE",row_box1);
	test_make_button(DBMSG_UNPAUSE,"UNPAUSE",row_box1);
	test_make_button(DBMSG_PLAY,"PLAY",row_box1);
	test_make_button(DBMSG_STOP,"STOP",row_box1);
	test_make_button(DBMSG_EJECT,"EJECT",row_box1);

	test_make_button(DBMSG_REWIND,"REW",row_box2);
	test_make_button(DBMSG_FFORWARD,"FFWD",row_box2);
	test_make_button(DBMSG_PREV,"PREV",row_box2);
	test_make_button(DBMSG_NEXT,"NEXT",row_box2);

	gtk_box_pack_start(GTK_BOX(vbox),selector_box,FALSE,FALSE,0);
	separator = gtk_hseparator_new();
	gtk_widget_show(separator);
	gtk_box_pack_start(GTK_BOX(vbox),separator,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),row_box1,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),row_box2,FALSE,FALSE,0);

	gtk_box_pack_start(GTK_BOX(main_box),vbox,FALSE,FALSE,0);

/* 	gtk_box_pack_start (GTK_BOX (main_box), label, FALSE, FALSE, 10); */

	gtk_container_add(GTK_CONTAINER(window),main_box);
	gtk_widget_show(window);

}




static gint standalone_cleanup(GtkWidget* window, GdkEventAny* e, gpointer data)
{
	Debug("Got delete_event... calling cleanup()...");
	cleanup();

	return TRUE;
}


int main( int argc, char *argv[] )
{
	debug_level = 0;
	channel_index = 0;

	standalone_flag = 1;

#ifdef DBMIX_DEBUG
	debug_level = 1;
	printf("Debugging is on.\n");
#else
	debug_level = 0;
#endif	

    gtk_init(&argc, &argv);

	Channel_Init();

	msg_q_id = local_channels[0].msg_q_id;

	dbmsg_test_init();

	gtk_signal_connect(GTK_OBJECT(window),"delete_event",
					   GTK_SIGNAL_FUNC(standalone_cleanup),NULL);
	gtk_main();

	return(0);
}
