#include "basesocket"

Basesocket *Basesocket::accept() {
    int f;

    int size;
    struct sockaddr_in claddr;

    debugmsg("About to accept client on server socket " << _fd << '\n');
    size = sizeof(claddr);
    if ( (f = ::accept(_fd, (struct sockaddr *)&claddr,
		       (socklen_t *)&size)) >= 0 ) {
	Basesocket *ret = new Basesocket(f);
	ret->_clientaddr = claddr;
	debugmsg("Client " << inet2string(ret->_clientaddr.sin_addr) <<
		 " accepted as basesocket " << f << '\n');
	return ret;
    }

    if (EMFILE_SLEEP && errno == EMFILE) {
	warnmsg("Out of file descriptors while accepting network "
		"connection, taking a short nap\n");
	sleep(1);
    }
    throw Error(string("Failed to accept client: ") +
		strerror(errno));
}
	
	
