/*
 * Copyright © 2013 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *     Antti Kaijanmäki <antti.kaijanmaki@canonical.com>
 */

#ifndef PLATFORM_TEST_WIFI_LINK
#define PLATFORM_TEST_WIFI_LINK

#include <services/nm.h>

#include <com/ubuntu/connectivity/networking/wifi/link.h>

namespace platform {
namespace nmofono {
namespace wifi {
    class Link;
}
}
}

class platform::nmofono::wifi::Link : public com::ubuntu::connectivity::networking::wifi::Link
{
public:

    Link(org::freedesktop::NetworkManager::Interface::Device dev,
         org::freedesktop::NetworkManager::Interface::NetworkManager nm);
    ~Link();

    // public API
    void enable();
    void disable();

    Type type() const;
    const core::Property<std::uint32_t>& characteristics();
    const core::Property<Status>& status();
    Id id() const;
    std::string name() const;

    const core::Property<std::set<std::shared_ptr<com::ubuntu::connectivity::networking::wifi::AccessPoint>>>& accessPoints();
    void connect_to(std::shared_ptr<com::ubuntu::connectivity::networking::wifi::AccessPoint> accessPoint);
    const core::Property<std::shared_ptr<com::ubuntu::connectivity::networking::wifi::AccessPoint>>& activeAccessPoint();


    // private API

    void updateDeviceState(std::uint32_t new_state);
    void updateActiveConnection(const core::dbus::types::ObjectPath &path);

    void setFlightMode(bool value);

    core::Property<std::uint32_t> m_characteristics;
    core::Property<Status> m_status;
    core::Property<std::set<std::shared_ptr<com::ubuntu::connectivity::networking::wifi::AccessPoint>>> m_accessPoints;
    core::Property<std::shared_ptr<com::ubuntu::connectivity::networking::wifi::AccessPoint>> m_activeAccessPoint;

    org::freedesktop::NetworkManager::Interface::Device m_dev;
    org::freedesktop::NetworkManager::Interface::Device::Wireless m_wireless;
    org::freedesktop::NetworkManager::Interface::NetworkManager m_nm;

    bool m_disabled;
    bool m_flightMode;
    std::uint32_t m_lastState;
    std::string m_name;
    std::shared_ptr<org::freedesktop::NetworkManager::Interface::ActiveConnection> m_activeConnection;
};

#endif
