% make_hilb.m
% David Rowe May 2015
%
% creates Hilber Transformer FIR coeffs

graphics_toolkit ("gnuplot");

ht_n = 100;
imp = [1 zeros(1,ht_n-1)];
ht_coeff = fftshift(hilbert(imp)) .* hanning(ht_n)';

figure(1)
subplot(211)
plot(real(ht_coeff))
subplot(212)
plot(imag(ht_coeff))

figure(2)
plot(20*log10(abs(fft(ht_coeff))))

% test it

n=1:8000;
w = 2*pi/4;
x = cos(n*w);
figure(3)
y = filter(ht_coeff,1,x);
figure(3)
subplot(211)
plot(y(800:8000))
subplot(212)
plot(20*log10(abs(fft(y(800:8000)))))

% save coeffs to a C header file

f=fopen("../src/ht_coeff.h","wt");
fprintf(f,"/* Hilbert Transform FIR filter coeffs */\n");
fprintf(f,"/* Generated by make_hilb Octave script */\n");

fprintf(f,"\n#define HT_N %d\n\n", ht_n);

fprintf(f,"COMP ht_coeff[]={\n");
for r=1:ht_n
  if r < ht_n
    fprintf(f, "  {%f,%f},\n",  real(ht_coeff(r)), imag(ht_coeff(r)));
  else
    fprintf(f, "  {%f,%f}\n};", real(ht_coeff(r)), imag(ht_coeff(r)));
  end
end

fclose(f);
