//
// vr4300/opcodes_priv.h: VR4300 opcode types and info.
//
// CEN64: Cycle-Accurate Nintendo 64 Emulator.
// Copyright (C) 2015, Tyler J. Stachecki.
//
// This file is subject to the terms and conditions defined in
// 'LICENSE', which is part of this source code package.
//

#ifndef __vr4300_opcodes_priv_h__
#define __vr4300_opcodes_priv_h__
#include "common.h"
#include "vr4300/opcodes.h"

#define INFO1(x) (OPCODE_INFO_##x)
#define INFO2(x,y) (INFO1(x) | OPCODE_INFO_##y)
#define INFO3(x,y,z) (INFO2(x,y) | OPCODE_INFO_##z)
#define INFO4(x,y,z,a) (INFO3(x,y,z) | OPCODE_INFO_##a)
#define INFO5(x,y,z,a,b) (INFO4(x,y,z,a) | OPCODE_INFO_##b)
#define INVALID VR4300_BUILD_OP(INVALID, INVALID, INFO1(NONE))

#ifdef VR4300_BUSY_WAIT_DETECTION
#define BEQ VR4300_BUILD_OP(BEQ, BEQ_BEQL_BNE_BNEL_BWDETECT, INFO3(BRANCH, NEEDRS, NEEDRT))
#define BEQL VR4300_BUILD_OP(BEQL, BEQ_BEQL_BNE_BNEL_BWDETECT, INFO3(BRANCH, NEEDRS, NEEDRT))
#define BNE VR4300_BUILD_OP(BNE, BEQ_BEQL_BNE_BNEL_BWDETECT, INFO3(BRANCH, NEEDRS, NEEDRT))
#define BNEL VR4300_BUILD_OP(BNEL, BEQ_BEQL_BNE_BNEL_BWDETECT, INFO3(BRANCH, NEEDRS, NEEDRT))
#define J VR4300_BUILD_OP(J, J_JAL_BWDETECT, INFO1(BRANCH))
#define JAL VR4300_BUILD_OP(JAL, J_JAL_BWDETECT, INFO1(BRANCH))
#else
#define BEQ VR4300_BUILD_OP(BEQ, BEQ_BEQL_BNE_BNEL, INFO3(BRANCH, NEEDRS, NEEDRT))
#define BEQL VR4300_BUILD_OP(BEQL, BEQ_BEQL_BNE_BNEL, INFO3(BRANCH, NEEDRS, NEEDRT))
#define BNE VR4300_BUILD_OP(BNE, BEQ_BEQL_BNE_BNEL, INFO3(BRANCH, NEEDRS, NEEDRT))
#define BNEL VR4300_BUILD_OP(BNEL, BEQ_BEQL_BNE_BNEL, INFO3(BRANCH, NEEDRS, NEEDRT))
#define J VR4300_BUILD_OP(J, J_JAL, INFO1(BRANCH))
#define JAL VR4300_BUILD_OP(JAL, J_JAL, INFO1(BRANCH))
#endif

#define ADD VR4300_BUILD_OP(ADD, ADD_SUB, INFO2(NEEDRS, NEEDRT))
#define ADDI VR4300_BUILD_OP(ADDI, ADDI_SUBI, INFO1(NEEDRS))
#define ADDIU VR4300_BUILD_OP(ADDIU, ADDIU_LUI_SUBIU, INFO1(NEEDRS))
#define ADDU VR4300_BUILD_OP(ADDU, ADDU_SUBU, INFO2(NEEDRS, NEEDRT))
#define AND VR4300_BUILD_OP(AND, AND_OR_XOR, INFO2(NEEDRS, NEEDRT))
#define ANDI VR4300_BUILD_OP(ANDI, ANDI_ORI_XORI, INFO1(NEEDRS))
#define BGEZ VR4300_BUILD_OP(BGEZ, BGEZ_BGEZL_BLTZ_BLTZL, INFO2(BRANCH, NEEDRS))
#define BGEZAL VR4300_BUILD_OP(BGEZAL, BGEZAL_BGEZALL_BLTZAL_BLTZALL, INFO2(BRANCH, NEEDRS))
#define BGEZALL VR4300_BUILD_OP(BGEZALL, BGEZAL_BGEZALL_BLTZAL_BLTZALL, INFO2(BRANCH, NEEDRS))
#define BGEZL VR4300_BUILD_OP(BGEZL, BGEZ_BGEZL_BLTZ_BLTZL, INFO2(BRANCH, NEEDRS))
#define BGTZ VR4300_BUILD_OP(BGTZ, BGTZ_BGTZL_BLEZ_BLEZL, INFO2(BRANCH, NEEDRS))
#define BGTZL VR4300_BUILD_OP(BGTZL, BGTZ_BGTZL_BLEZ_BLEZL, INFO2(BRANCH, NEEDRS))
#define BLEZ VR4300_BUILD_OP(BLEZ, BGTZ_BGTZL_BLEZ_BLEZL, INFO2(BRANCH, NEEDRS))
#define BLEZL VR4300_BUILD_OP(BLEZL, BGTZ_BGTZL_BLEZ_BLEZL, INFO2(BRANCH, NEEDRS))
#define BLTZ VR4300_BUILD_OP(BLTZ, BGEZ_BGEZL_BLTZ_BLTZL, INFO2(BRANCH, NEEDRS))
#define BLTZAL VR4300_BUILD_OP(BLTZAL, BGEZAL_BGEZALL_BLTZAL_BLTZALL, INFO2(BRANCH, NEEDRS))
#define BLTZALL VR4300_BUILD_OP(BLTZALL, BGEZAL_BGEZALL_BLTZAL_BLTZALL, INFO2(BRANCH, NEEDRS))
#define BLTZL VR4300_BUILD_OP(BLTZL, BGEZ_BGEZL_BLTZ_BLTZL, INFO2(BRANCH, NEEDRS))
#define BREAK VR4300_BUILD_OP(BREAK, INVALID, INFO1(NONE))
#define DADD VR4300_BUILD_OP(DADD, DADD_DSUB, INFO2(NEEDRS, NEEDRT))
#define DADDI VR4300_BUILD_OP(DADDI, DADDI_DSUBI, INFO1(NEEDRS))
#define DADDIU VR4300_BUILD_OP(DADDIU, DADDIU_DSUBIU, INFO1(NEEDRS))
#define DADDU VR4300_BUILD_OP(DADDU, DADDU_DSUBU, INFO2(NEEDRS, NEEDRT))
#define DDIV VR4300_BUILD_OP(DDIV, DDIV, INFO2(NEEDRS, NEEDRT))
#define DDIVU VR4300_BUILD_OP(DDIVU, DDIVU, INFO2(NEEDRS, NEEDRT))
#define DIV VR4300_BUILD_OP(DIV, DIV_DIVU, INFO2(NEEDRS, NEEDRT))
#define DIVU VR4300_BUILD_OP(DIVU, DIV_DIVU, INFO2(NEEDRS, NEEDRT))
#define DMULT VR4300_BUILD_OP(DMULT, DMULT, INFO2(NEEDRS, NEEDRT))
#define DMULTU VR4300_BUILD_OP(DMULTU, DMULTU, INFO2(NEEDRS, NEEDRT))
#define DSLL VR4300_BUILD_OP(DSLL, DSLL_DSLL32, INFO1(NEEDRT))
#define DSLLV VR4300_BUILD_OP(DSLLV, DSLLV, INFO2(NEEDRS, NEEDRT))
#define DSLL32 VR4300_BUILD_OP(DSLL32, DSLL_DSLL32, INFO1(NEEDRT))
#define DSRA VR4300_BUILD_OP(DSRA, DSRA_DSRA32, INFO1(NEEDRT))
#define DSRAV VR4300_BUILD_OP(DSRAV, DSRAV, INFO2(NEEDRS, NEEDRT))
#define DSRA32 VR4300_BUILD_OP(DSRA32, DSRA_DSRA32, INFO1(NEEDRT))
#define DSRL VR4300_BUILD_OP(DSRL, DSRL_DSRL32, INFO1(NEEDRT))
#define DSRLV VR4300_BUILD_OP(DSRLV, DSRLV, INFO2(NEEDRS, NEEDRT))
#define DSRL32 VR4300_BUILD_OP(DSRL32, DSRL_DSRL32, INFO1(NEEDRT))
#define DSUB VR4300_BUILD_OP(DSUB, DADD_DSUB, INFO2(NEEDRS, NEEDRT))
#define DSUBU VR4300_BUILD_OP(DSUBU, DADDU_DSUBU, INFO2(NEEDRS, NEEDRT))
#define JALR VR4300_BUILD_OP(JALR, JALR_JR, INFO2(BRANCH, NEEDRS))
#define JR VR4300_BUILD_OP(JR, JALR_JR, INFO2(BRANCH, NEEDRS))
#define LB VR4300_BUILD_OP(LB, LOAD_STORE, INFO2(NEEDRS, LOAD))
#define LBU VR4300_BUILD_OP(LBU, LOAD_STORE, INFO2(NEEDRS, LOAD))
#define LD VR4300_BUILD_OP(LD, LD_SD, INFO2(NEEDRS, LOAD))
#define LDL VR4300_BUILD_OP(LDL, LDL_LDR, INFO3(NEEDRS, NEEDRT, LOAD))
#define LDR VR4300_BUILD_OP(LDR, LDL_LDR, INFO3(NEEDRS, NEEDRT, LOAD))
#define LH VR4300_BUILD_OP(LH, LOAD_STORE, INFO2(NEEDRS, LOAD))
#define LHU VR4300_BUILD_OP(LHU, LOAD_STORE, INFO2(NEEDRS, LOAD))
#define LL VR4300_BUILD_OP(LL, INVALID, INFO1(NONE))
#define LLD VR4300_BUILD_OP(LLD, INVALID, INFO1(NONE))
#define LUI VR4300_BUILD_OP(LUI, ADDIU_LUI_SUBIU, INFO1(NONE))
#define LW VR4300_BUILD_OP(LW, LOAD_STORE, INFO2(NEEDRS, LOAD))
#define LWL VR4300_BUILD_OP(LWL, LWL_LWR, INFO3(NEEDRS, NEEDRT, LOAD))
#define LWR VR4300_BUILD_OP(LWR, LWL_LWR, INFO3(NEEDRS, NEEDRT, LOAD))
#define LWU VR4300_BUILD_OP(LWU, LOAD_STORE, INFO2(NEEDRS, LOAD))
#define MFHI VR4300_BUILD_OP(MFHI, MFHI_MFLO, INFO1(NONE))
#define MFLO VR4300_BUILD_OP(MFLO, MFHI_MFLO, INFO1(NONE))
#define MTHI VR4300_BUILD_OP(MTHI, MTHI_MTLO, INFO1(NEEDRS))
#define MTLO VR4300_BUILD_OP(MTLO, MTHI_MTLO, INFO1(NEEDRS))
#define MULT VR4300_BUILD_OP(MULT, MULT_MULTU, INFO2(NEEDRS, NEEDRT))
#define MULTU VR4300_BUILD_OP(MULTU, MULT_MULTU, INFO2(NEEDRS, NEEDRT))
#define NOR VR4300_BUILD_OP(NOR, NOR, INFO2(NEEDRS, NEEDRT))
#define OR VR4300_BUILD_OP(OR, AND_OR_XOR, INFO2(NEEDRS, NEEDRT))
#define ORI VR4300_BUILD_OP(ORI, ANDI_ORI_XORI, INFO1(NEEDRS))
#define SB VR4300_BUILD_OP(SB, LOAD_STORE, INFO3(NEEDRS, NEEDRT, STORE))
#define SC VR4300_BUILD_OP(SC, INVALID, INFO1(NONE))
#define SCD VR4300_BUILD_OP(SCD, INVALID, INFO1(NONE))
#define SD VR4300_BUILD_OP(SD, LD_SD, INFO3(NEEDRS, NEEDRT, STORE))
#define SDL VR4300_BUILD_OP(SDL, SDL_SDR, INFO3(NEEDRS, NEEDRT, STORE))
#define SDR VR4300_BUILD_OP(SDR, SDL_SDR, INFO3(NEEDRS, NEEDRT, STORE))
#define SH VR4300_BUILD_OP(SH, LOAD_STORE, INFO3(NEEDRS, NEEDRT, STORE))
#define SLL VR4300_BUILD_OP(SLL, SLL_SLLV, INFO1(NEEDRT))
#define SLLV VR4300_BUILD_OP(SLLV, SLL_SLLV, INFO2(NEEDRS, NEEDRT))
#define SLT VR4300_BUILD_OP(SLT, SLT, INFO2(NEEDRS, NEEDRT))
#define SLTI VR4300_BUILD_OP(SLTI, SLTI, INFO1(NEEDRS))
#define SLTIU VR4300_BUILD_OP(SLTIU, SLTIU, INFO1(NEEDRS))
#define SLTU VR4300_BUILD_OP(SLTU, SLTU, INFO2(NEEDRS, NEEDRT))
#define SRA VR4300_BUILD_OP(SRA, SRA, INFO1(NEEDRT))
#define SRAV VR4300_BUILD_OP(SRAV, SRAV, INFO2(NEEDRS, NEEDRT))
#define SRL VR4300_BUILD_OP(SRL, SRL, INFO1(NEEDRT))
#define SRLV VR4300_BUILD_OP(SRLV, SRLV, INFO2(NEEDRS, NEEDRT))
#define SUB VR4300_BUILD_OP(SUB, ADD_SUB, INFO2(NEEDRS, NEEDRT))
#define SUBU VR4300_BUILD_OP(SUBU, ADDU_SUBU, INFO1(NEEDRS))
#define SW VR4300_BUILD_OP(SW, LOAD_STORE, INFO3(NEEDRS, NEEDRT, STORE))
#define SWL VR4300_BUILD_OP(SWL, SWL_SWR, INFO3(NEEDRS, NEEDRT, STORE))
#define SWR VR4300_BUILD_OP(SWR, SWL_SWR, INFO3(NEEDRS, NEEDRT, STORE))
#define SYNC VR4300_BUILD_OP(SYNC, SLL_SLLV, INFO1(NONE))
#define SYSCALL VR4300_BUILD_OP(SYSCALL, INVALID, INFO1(NONE))
#define TEQ VR4300_BUILD_OP(TEQ, INVALID, INFO1(NONE))
#define TEQI VR4300_BUILD_OP(TEQI, INVALID, INFO1(NONE))
#define TGE VR4300_BUILD_OP(TGE, INVALID, INFO1(NONE))
#define TGEI VR4300_BUILD_OP(TGEI, INVALID, INFO1(NONE))
#define TGEIU VR4300_BUILD_OP(TGEIU, INVALID, INFO1(NONE))
#define TGEU VR4300_BUILD_OP(TGEU, INVALID, INFO1(NONE))
#define TLT VR4300_BUILD_OP(TLT, INVALID, INFO1(NONE))
#define TLTI VR4300_BUILD_OP(TLTI, INVALID, INFO1(NONE))
#define TLTIU VR4300_BUILD_OP(TLTIU, INVALID, INFO1(NONE))
#define TLTU VR4300_BUILD_OP(TLTU, INVALID, INFO1(NONE))
#define TNE VR4300_BUILD_OP(TNE, INVALID, INFO1(NONE))
#define TNEI VR4300_BUILD_OP(TNEI, INVALID, INFO1(NONE))
#define XOR VR4300_BUILD_OP(XOR, AND_OR_XOR, INFO2(NEEDRS, NEEDRT))
#define XORI VR4300_BUILD_OP(XORI, ANDI_ORI_XORI, INFO1(NEEDRS))

#define BC0 VR4300_BUILD_OP(BC0, INVALID, INFO1(BRANCH))
#define CFC0 VR4300_BUILD_OP(CFC0, INVALID, INFO1(NONE))
#define CTC0 VR4300_BUILD_OP(CTC0, INVALID, INFO1(NONE))
#define DMFC0 VR4300_BUILD_OP(DMFC0, DMFC0, INFO1(NONE))
#define DMTC0 VR4300_BUILD_OP(DMTC0, DMTC0, INFO1(NEEDRT))
#define LDC0 VR4300_BUILD_OP(LDC0, INVALID, INFO1(LOAD))
#define LWC0 VR4300_BUILD_OP(LWC0, INVALID, INFO1(LOAD))
#define MFC0 VR4300_BUILD_OP(MFC0, MFC0, INFO1(NONE))
#define MTC0 VR4300_BUILD_OP(MTC0, MTC0, INFO1(NEEDRT))
#define SDC0 VR4300_BUILD_OP(SDC0, INVALID, INFO1(STORE))
#define SWC0 VR4300_BUILD_OP(SWC0, INVALID, INFO1(STORE))

#define CACHE VR4300_BUILD_OP(CACHE, CACHE, INFO1(NEEDRS))
#define ERET VR4300_BUILD_OP(ERET, ERET, INFO1(NONE))
#define TLBP VR4300_BUILD_OP(TLBP, TLBP, INFO1(NONE))
#define TLBR VR4300_BUILD_OP(TLBR, TLBR, INFO1(NONE))
#define TLBWI VR4300_BUILD_OP(TLBWI, TLBWI, INFO1(NONE))
#define TLBWR VR4300_BUILD_OP(TLBWR, TLBWR, INFO1(NONE))

#define BC1 VR4300_BUILD_OP(BC1, BC1, INFO2(FPU, BRANCH))
#define CFC1 VR4300_BUILD_OP(CFC1, CFC1, INFO2(FPU, NONE))
#define CTC1 VR4300_BUILD_OP(CTC1, CTC1, INFO2(FPU, NONE))
#define DMFC1 VR4300_BUILD_OP(DMFC1, DMFC1, INFO2(FPU, NEEDFS))
#define DMTC1 VR4300_BUILD_OP(DMTC1, DMTC1, INFO2(FPU, NEEDRT))
#define LDC1 VR4300_BUILD_OP(LDC1, LDC1, INFO3(FPU, NEEDRS, LOAD))
#define LWC1 VR4300_BUILD_OP(LWC1, LWC1, INFO4(FPU, NEEDRS, NEEDFT, LOAD))
#define MFC1 VR4300_BUILD_OP(MFC1, MFC1, INFO2(FPU, NEEDFS))
#define MTC1 VR4300_BUILD_OP(MTC1, MTC1, INFO3(FPU, NEEDFS, NEEDRT))
#define SDC1 VR4300_BUILD_OP(SDC1, SDC1, INFO4(FPU, NEEDRS, NEEDFT, STORE))
#define SWC1 VR4300_BUILD_OP(SWC1, SWC1, INFO4(FPU, NEEDRS, NEEDFT, STORE))

#define CP1_ABS VR4300_BUILD_OP(CP1_ABS, CP1_ABS, INFO3(FPU, FPU, NEEDFS))
#define CP1_ADD VR4300_BUILD_OP(CP1_ADD, CP1_ADD, INFO3(FPU, NEEDFS, NEEDFT))
#define CP1_C_EQ VR4300_BUILD_OP(CP1_C_EQ, CP1_C_EQ_C_SEQ, INFO3(FPU, NEEDFS, NEEDFT))
#define CP1_C_F VR4300_BUILD_OP(CP1_C_F, CP1_C_F_C_SF, INFO3(FPU, NEEDFS, NEEDFT))
#define CP1_C_LE VR4300_BUILD_OP(CP1_C_LE, CP1_C_OLE_C_LE, INFO3(FPU, NEEDFS, NEEDFT))
#define CP1_C_LT VR4300_BUILD_OP(CP1_C_LT, CP1_C_OLT_C_LT, INFO3(FPU, NEEDFS, NEEDFT))
#define CP1_C_NGE VR4300_BUILD_OP(CP1_C_NGE, CP1_C_ULT_C_NGE, INFO3(FPU, NEEDFS, NEEDFT))
#define CP1_C_NGL VR4300_BUILD_OP(CP1_C_NGL, CP1_C_UEQ_C_NGL, INFO3(FPU, NEEDFS, NEEDFT))
#define CP1_C_NGLE VR4300_BUILD_OP(CP1_C_NGLE, CP1_C_UN_C_NGLE, INFO3(FPU, NEEDFS, NEEDFT))
#define CP1_C_NGT VR4300_BUILD_OP(CP1_C_NGT, CP1_C_ULE_C_NGT, INFO3(FPU, NEEDFS, NEEDFT))
#define CP1_C_OLE VR4300_BUILD_OP(CP1_C_OLE, CP1_C_OLE_C_LE, INFO3(FPU, NEEDFS, NEEDFT))
#define CP1_C_OLT VR4300_BUILD_OP(CP1_C_OLT, CP1_C_OLT_C_LT, INFO3(FPU, NEEDFS, NEEDFT))
#define CP1_C_SEQ VR4300_BUILD_OP(CP1_C_SEQ, CP1_C_EQ_C_SEQ, INFO3(FPU, NEEDFS, NEEDFT))
#define CP1_C_SF VR4300_BUILD_OP(CP1_C_SF, CP1_C_F_C_SF, INFO3(FPU, NEEDFS, NEEDFT))
#define CP1_C_UEQ VR4300_BUILD_OP(CP1_C_UEQ, CP1_C_UEQ_C_NGL, INFO3(FPU, NEEDFS, NEEDFT))
#define CP1_C_ULE VR4300_BUILD_OP(CP1_C_ULE, CP1_C_ULE_C_NGT, INFO3(FPU, NEEDFS, NEEDFT))
#define CP1_C_ULT VR4300_BUILD_OP(CP1_C_ULT, CP1_C_ULT_C_NGE, INFO3(FPU, NEEDFS, NEEDFT))
#define CP1_C_UN VR4300_BUILD_OP(CP1_C_UN, CP1_C_UN_C_NGLE, INFO3(FPU, NEEDFS, NEEDFT))
#define CP1_CEIL_L VR4300_BUILD_OP(CP1_CEIL_L, CP1_CEIL_L, INFO3(FPU, FPU, NEEDFS))
#define CP1_CEIL_W VR4300_BUILD_OP(CP1_CEIL_W, CP1_CEIL_W, INFO3(FPU, FPU, NEEDFS))
#define CP1_CVT_D VR4300_BUILD_OP(CP1_CVT_D, CP1_CVT_D, INFO3(FPU, FPU, NEEDFS))
#define CP1_CVT_L VR4300_BUILD_OP(CP1_CVT_L, CP1_CVT_L, INFO3(FPU, FPU, NEEDFS))
#define CP1_CVT_S VR4300_BUILD_OP(CP1_CVT_S, CP1_CVT_S, INFO3(FPU, FPU, NEEDFS))
#define CP1_CVT_W VR4300_BUILD_OP(CP1_CVT_W, CP1_CVT_W, INFO3(FPU, FPU, NEEDFS))
#define CP1_DIV VR4300_BUILD_OP(CP1_DIV, CP1_DIV, INFO3(FPU, NEEDFS, NEEDFT))
#define CP1_FLOOR_L VR4300_BUILD_OP(CP1_FLOOR_L, CP1_FLOOR_L, INFO3(FPU, FPU, NEEDFS))
#define CP1_FLOOR_W VR4300_BUILD_OP(CP1_FLOOR_W, CP1_FLOOR_W, INFO3(FPU, FPU, NEEDFS))
#define CP1_MOV VR4300_BUILD_OP(CP1_MOV, CP1_MOV, INFO3(FPU, FPU, NEEDFS))
#define CP1_MUL VR4300_BUILD_OP(CP1_MUL, CP1_MUL, INFO3(FPU, NEEDFS, NEEDFT))
#define CP1_NEG VR4300_BUILD_OP(CP1_NEG, CP1_NEG, INFO3(FPU, FPU, NEEDFS))
#define CP1_ROUND_L VR4300_BUILD_OP(CP1_ROUND_L, CP1_ROUND_L, INFO3(FPU, FPU, NEEDFS))
#define CP1_ROUND_W VR4300_BUILD_OP(CP1_ROUND_W, CP1_ROUND_W, INFO3(FPU, FPU, NEEDFS))
#define CP1_SQRT VR4300_BUILD_OP(CP1_SQRT, CP1_SQRT, INFO3(FPU, FPU, NEEDFS))
#define CP1_SUB VR4300_BUILD_OP(CP1_SUB, CP1_SUB, INFO3(FPU, NEEDFS, NEEDFT))
#define CP1_TRUNC_L VR4300_BUILD_OP(CP1_TRUNC_L, CP1_TRUNC_L, INFO3(FPU, FPU, NEEDFS))
#define CP1_TRUNC_W VR4300_BUILD_OP(CP1_TRUNC_W, CP1_TRUNC_W, INFO3(FPU, FPU, NEEDFS))

#define BC2 VR4300_BUILD_OP(BC1, INVALID, INFO1(BRANCH))
#define CFC2 VR4300_BUILD_OP(CFC2, INVALID, INFO1(NONE))
#define CTC2 VR4300_BUILD_OP(CTC2, INVALID, INFO1(NONE))
#define DMFC2 VR4300_BUILD_OP(DMFC2, INVALID, INFO1(NONE))
#define DMTC2 VR4300_BUILD_OP(DMTC2, INVALID, INFO1(NONE))
#define LDC2 VR4300_BUILD_OP(LDC2, INVALID, INFO1(NONE))
#define LWC2 VR4300_BUILD_OP(LWC2, INVALID, INFO1(NONE))
#define MFC2 VR4300_BUILD_OP(MFC2, INVALID, INFO1(NONE))
#define MTC2 VR4300_BUILD_OP(MTC2, INVALID, INFO1(NONE))
#define SDC2 VR4300_BUILD_OP(SDC2, INVALID, INFO1(NONE))
#define SWC2 VR4300_BUILD_OP(SWC2, INVALID, INFO1(NONE))

#endif

