#!
#! @ingroup group_sdk_cmake
#!
#! macro get_git_info get the last value of commit count.
#! Set CAMITK_GIT_COMMIT_COUNT variable with the last number of commits
#!
#! Usage:
#! \code
#! get_git_info(dir)
#! \endcode
#!
#! \inparam dir (required) input directory path
#!            
macro(get_git_info dir)
    execute_process(COMMAND ${GIT_EXECUTABLE} rev-list HEAD --count
                    WORKING_DIRECTORY ${CMAKE_SOURCE_DIR}
                    OUTPUT_VARIABLE CAMITK_GIT_COMMIT_COUNT
                    OUTPUT_STRIP_TRAILING_WHITESPACE
    )
       
    execute_process(COMMAND ${GIT_EXECUTABLE} rev-parse --abbrev-ref HEAD
                    WORKING_DIRECTORY ${CMAKE_SOURCE_DIR}
                    OUTPUT_VARIABLE CAMITK_GIT_BRANCH
                    OUTPUT_STRIP_TRAILING_WHITESPACE
    )
    
    execute_process(COMMAND ${GIT_EXECUTABLE} log -1 --format=%h
                    WORKING_DIRECTORY ${CMAKE_SOURCE_DIR}
                    OUTPUT_VARIABLE CAMITK_GIT_ABBREVIATED_HASH
                    OUTPUT_STRIP_TRAILING_WHITESPACE
    )

    execute_process(COMMAND ${GIT_EXECUTABLE} log -1 --format=%H
                    WORKING_DIRECTORY ${CMAKE_SOURCE_DIR}
                    OUTPUT_VARIABLE CAMITK_GIT_HASH
                    OUTPUT_STRIP_TRAILING_WHITESPACE
    )
    
    execute_process(COMMAND ${GIT_EXECUTABLE} log -1 --format=%cd
                    WORKING_DIRECTORY ${CMAKE_SOURCE_DIR}
                    OUTPUT_VARIABLE CAMITK_GIT_COMMITER_DATE
                    OUTPUT_STRIP_TRAILING_WHITESPACE
    )
    
    if(NOT CAMITK_GIT_COMMIT_COUNT) 
      message(WARNING "Unable to find the commit number using git : ${GIT_EXECUTABLE}")
      set(CAMITK_GIT_COMMIT_COUNT "unknown")
      set(CAMITK_GIT_BRANCH "unknown")
      set(CAMITK_GIT_HASH "unknown")
      set(CAMITK_GIT_ABBREVIATED_HASH "unknown")
    endif()

endmacro()