//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Mask/PolygonView.h
//! @brief     Defines PolygonView class
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_MASK_POLYGONVIEW_H
#define BORNAGAIN_GUI_VIEW_MASK_POLYGONVIEW_H

#include "GUI/View/Mask/IShape2DView.h"
#include <QPolygonF>

class PolygonItem;


//! This is a View of polygon mask (represented by PolygonItem) on GraphicsScene.

class PolygonView : public IShape2DView {
    Q_OBJECT

public:
    int type() const override { return MaskEditorHelper::POLYGON; }

    explicit PolygonView(PolygonItem* item);

    MaskItemObject* parameterizedItem() const override;

    void addView(IShape2DView* childView) override;
    bool isClosedPolygon();
    QPointF lastAddedPoint() const;
    QPainterPath shape() const override;

public slots:
    bool closePolygonIfNecessary();
    void onClosePolygonRequest(bool value);

protected slots:
    void update_view() override;

protected:
    void paint(QPainter* painter, const QStyleOptionGraphicsItem*, QWidget*) override;
    QVariant itemChange(GraphicsItemChange change, const QVariant& value) override;
    void mouseMoveEvent(QGraphicsSceneMouseEvent* event) override;

private:
    void update_polygon();
    void update_points();
    void setChildrenVisible(bool value);
    bool makePolygonClosed();

private:
    PolygonItem* m_item;
    QPolygonF m_polygon;
    bool m_block_on_point_update;
    bool m_close_polygon_request;
};

#endif // BORNAGAIN_GUI_VIEW_MASK_POLYGONVIEW_H
