//
// BAGEL - Parallel electron correlation program.
// Filename: _eriroot_50.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot50(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[50] = {1.227572534584943e-02,1.104995276849810e-01,3.070432377239684e-01,6.020995843347335e-01,9.959589629609481e-01,
    1.489011017270010e+00,2.081746780329551e+00,2.774761404004785e+00,3.568757513748134e+00,4.464549235369023e+00,5.463066950997876e+00,6.565362853611610e+00,
    7.772617383554726e+00,9.086146646940419e+00,1.050741093523498e+01,1.203802448844218e+01,1.367976667203497e+01,1.543459477129267e+01,1.730465864749188e+01,
    1.929231755040027e+01,2.140015944324129e+01,2.363102327305128e+01,2.598802471548128e+01,2.847458604447447e+01,3.109447093172170e+01,3.385182517911479e+01,
    3.675122464436349e+01,3.979773195611976e+01,4.299696405948126e+01,4.635517322722129e+01,4.987934497698001e+01,5.357731743907080e+01,5.745792825728169e+01,
    6.153119728068543e+01,6.580855643746800e+01,7.030314278262583e+01,7.503017761677704e+01,8.000746519453865e+01,8.525606133593571e+01,9.080118966333674e+01,
    9.667352957294236e+01,1.029110819489893e+02,1.095619706447716e+02,1.166888373905969e+02,1.243761235796182e+02,1.327430128374924e+02,1.419687011082473e+02,
    1.523487658067936e+02,1.644498400149637e+02,1.797339027478397e+02};
  constexpr double aw[50] = {2.188926295874399e-01,1.984628502541860e-01,1.631300305027832e-01,1.215379868441046e-01,8.205182739122448e-02,
    5.017581267742848e-02,2.777912738593345e-02,1.391566522023190e-02,6.303000285608035e-03,2.579273260059096e-03,9.526921885486120e-04,3.172919710433074e-04,
    9.517162778550828e-05,2.567615938454918e-05,6.221524817777905e-06,1.351797159110391e-06,2.629097483753724e-07,4.568127508484856e-08,7.075857283889764e-09,
    9.747921253871742e-10,1.191300634929084e-10,1.287903825731522e-11,1.227878514410092e-12,1.028874937350992e-13,7.548896877915489e-15,4.829835321703164e-16,
    2.682492164760064e-17,1.286832921121154e-18,5.302316183132282e-20,1.864997675130201e-21,5.561026961659232e-23,1.394841526068801e-24,2.917350072629296e-26,
    5.037791166213254e-28,7.101812226385031e-30,8.067434278709596e-32,7.274572596887510e-34,5.116232604385560e-36,2.748784884356988e-38,1.100470682714277e-40,
    3.185217877835713e-43,6.420725205349163e-46,8.597563954826037e-49,7.191529463464289e-52,3.459477936476291e-55,8.518883081761946e-59,9.019222303694199e-63,
    3.083028990003705e-67,1.972860574879405e-72,5.908067865031421e-79};
  constexpr double x[19200] = {  4.837242770240790e-04, -2.394101458393913e-06,  8.884688620916540e-09, -2.929896910284767e-11,  9.054366606006879e-14,
 -2.684891342141428e-16,  7.735972511156270e-19, -2.182067901888464e-21,  6.054303731684645e-24, -1.657721544321097e-26,  4.489536505537981e-29, -1.204630909496350e-31,
  4.350765692804069e-03, -2.149205294619122e-05,  7.945255237344139e-08, -2.603308559160188e-10,  7.967499413813981e-13, -2.330531962949151e-15,  6.592481568047511e-18,
 -1.815444499811414e-20,  4.885619786487812e-23, -1.287609479055161e-25,  3.326487094701153e-28, -8.424100988992931e-31,  1.207017749965583e-02, -5.939627623312518e-05,
  2.178896040743967e-07, -7.047127623591775e-10,  2.114507298412767e-12, -6.011809258427489e-15,  1.635138990083826e-17, -4.270268882399438e-20,  1.070435792138777e-22,
 -2.564836678603601e-25,  5.819182524655143e-28, -1.226656935146521e-30,  2.361266839720787e-02, -1.155277566739788e-04,  4.188910896747299e-07, -1.328205507919429e-09,
  3.864408102645016e-12, -1.049721166891244e-14,  2.672340357719852e-17, -6.337623111175017e-20,  1.373919342176376e-22, -2.597537528064091e-25,  3.696277301233328e-28,
 -8.742762284082045e-32,  3.893442820257293e-02, -1.890287732491421e-04,  6.747283033024874e-07, -2.082193795547763e-09,  5.801137923795195e-12, -1.473019515260563e-14,
  3.370788008065555e-17, -6.671350174600731e-20,  9.991329927660128e-23, -3.731654125383033e-26, -4.976459169119566e-28,  2.684037319734960e-30,  5.797727967696757e-02,
 -2.787756899598459e-04,  9.755142020968405e-07, -2.906792200696672e-09,  7.639434066509333e-12, -1.758510361299773e-14,  3.359045639644375e-17, -4.286577280014389e-20,
 -2.262589462654015e-23,  4.012355160227350e-25, -1.755964261302399e-27,  5.553608466164563e-30,  8.066888046800526e-02, -3.833957302940473e-04,  1.309543688340752e-06,
 -3.734687881335991e-09,  9.084628114970305e-12, -1.805589368025120e-14,  2.389053266745836e-17,  1.050841869478737e-20, -2.121425306351974e-22,  9.098745316628984e-25,
 -2.710652951195207e-27,  5.972787520289935e-30,  1.069229747405061e-01, -5.012874984775924e-04,  1.663697236843523e-06, -4.495486750045466e-09,  9.864782027185452e-12,
 -1.543351874546849e-14,  4.095982279223537e-18,  8.623839687221116e-20, -4.149919944491635e-22,  1.245333600481457e-24, -2.544776059733874e-27,  2.001419163283912e-30,
  1.366396939564440e-01, -6.306449575433110e-04,  2.023894404837754e-06, -5.120298385548609e-09,  9.761247345550143e-12, -9.445399449389616e-15, -2.397809998469763e-17,
  1.682271299457523e-19, -5.554105746984836e-22,  1.161936749592353e-24, -7.823169609860811e-28, -5.994313755101867e-30,  1.697059061489374e-01, -7.694845241085569e-04,
  2.375582051221725e-06, -5.546279134077070e-09,  8.634597303353253e-12, -3.353123758112744e-16, -5.630007226285022e-17,  2.346701156974782e-19, -5.593413058133522e-22,
  5.272913230144892e-25,  2.324574961621959e-27, -1.471184086685234e-29,  2.059956129154191e-01, -9.156748938029929e-04,  2.704240869133488e-06, -5.720853681707420e-09,
  6.443292905278338e-12,  1.112996427862460e-14, -8.720560288963437e-17,  2.632529550240997e-19, -3.814877722318815e-22, -5.890494008241291e-25,  5.709957388933675e-27,
 -1.902685928618767e-29,  2.453703932307980e-01, -1.066969170155448e-03,  2.995893143412671e-06, -5.605352930730219e-09,  3.253110301699696e-12,  2.373085945255962e-14,
 -1.103654404294247e-16,  2.371130976008403e-19, -2.670589139031183e-23, -1.896221886635701e-24,  7.814531923140082e-27, -1.457002375553502e-29,  2.876798930521414e-01,
 -1.221038834016150e-03,  3.237594509329148e-06, -5.177839378788524e-09, -7.637821674193978e-13,  3.593494095015319e-14, -1.199690353940995e-16,  1.500737790624574e-19,
  4.420997388344484e-22, -2.950757402376984e-24,  7.227540418697359e-27, -5.402443811330323e-31,  3.327623595518555e-01, -1.375509060798692e-03,  3.417892920822784e-06,
 -4.434938541315365e-09, -5.340231865049697e-12,  4.608946514790273e-14, -1.119066630319169e-16,  9.743738245229190e-21,  9.137412797765909e-22, -3.298753714730368e-24,
  3.394017581200601e-27,  1.884145689204704e-29,  3.804452186763150e-01, -1.527994869463098e-03,  3.527239027533482e-06, -3.392553601166637e-09, -1.013512685447539e-11,
  5.264161498902415e-14, -8.472299382334480e-17, -1.624815385956924e-19,  1.255074503388266e-21, -2.646047739830041e-24, -2.938332703020469e-27,  3.534293233185774e-29,
  4.305456945813203e-01, -1.676137570656139e-03,  3.558333684452887e-06, -2.085407044941720e-09, -1.476223634746512e-11,  5.435693082696983e-14, -4.014788258148099e-17,
 -3.347767146710821e-19,  1.347480304200366e-21, -9.948040050649066e-25, -9.782580232712981e-27,  4.011533153269995e-29,  4.828714693446909e-01, -1.817640972139150e-03,
  3.506400333054799e-06, -5.654236733130504e-10, -1.882428862002826e-11,  5.050581838419658e-14,  1.691940208499890e-17, -4.710558889597116e-19,  1.123397488766376e-21,
  1.309065126522411e-24, -1.453559424688252e-26,  2.807717915819325e-29,  5.372213811999508e-01, -1.950306797852699e-03,  3.369372438743248e-06,  1.100960120840280e-09,
 -2.194916497531506e-11,  4.099150632283395e-14,  7.900021924953739e-17, -5.386941817486384e-19,  5.919514240590796e-22,  3.645673385476166e-24, -1.496422467770422e-26,
  1.156923065963457e-30,  5.933861593737675e-01, -2.072068782893940e-03,  3.147988971844123e-06,  2.836409756059852e-09, -2.382483247140173e-11,  2.640003077768181e-14,
  1.371239635689911e-16, -5.160950579599651e-19, -1.548599719854952e-22,  5.295780117173821e-24, -1.017455309880356e-26, -3.143777638639491e-29,  6.511491934441135e-01,
 -2.181024920426409e-03,  2.845793990524430e-06,  4.557019726341368e-09, -2.422969835245508e-11,  7.962841307392033e-15,  1.822418640542712e-16, -3.983367554469689e-19,
 -9.588256561765473e-22,  5.668807629741930e-24, -1.150152130031564e-27, -5.646549905572218e-29,  7.102873349667075e-01, -2.275467358114652e-03,  2.469039625665973e-06,
  6.177100119902981e-09, -2.305544461278892e-11, -1.256585228505962e-14,  2.067303176388244e-16, -1.994874122073542e-19, -1.631972964693343e-21,  4.509460732039361e-24,
  9.411449826216480e-27, -6.224434288926746e-29,  7.705717289450563e-01, -2.353909470981873e-03,  2.026495073770338e-06,  7.614136931974660e-09, -2.032006127671281e-11,
 -3.310337533109796e-14,  2.057221180189823e-16,  4.911771179165656e-20, -2.003840549672486e-21,  2.010068867972457e-24,  1.796318653374464e-26, -4.413973456874151e-29,
  8.317686725454001e-01, -2.415109674419976e-03,  1.529167463791846e-06,  8.793626879216761e-09, -1.616968369454576e-11, -5.148100144550850e-14,  1.780259233069290e-16,
  3.044460979101837e-19, -1.967001864004536e-21, -1.216256532696198e-24,  2.138095114392920e-26, -7.318944020330863e-30,  8.936404982833135e-01, -2.458091585112889e-03,
  9.899435657027667e-07,  9.653491715388646e-09, -1.086887179509858e-11, -6.570401877527659e-14,  1.264602644260377e-16,  5.201079963411355e-19, -1.508145933490472e-21,
 -4.301161775816026e-24,  1.816299670371251e-26,  3.474584383502306e-29,  9.559464787350618e-01, -2.482160188420128e-03,  4.231641435694686e-07,  1.014779948040708e-08,
 -4.780051810622807e-12, -7.419601187710474e-14,  5.752738809186445e-17,  6.557234054194741e-19, -7.155513049841344e-22, -6.377308669118122e-24,  9.076171531215655e-27,
  6.561661492314598e-29,  1.018443749655639e+00, -2.486913727740424e-03, -1.558547786203475e-07,  1.024955959440137e-08,  1.666128996254963e-12, -7.599539468184626e-14,
 -1.953301210108641e-17,  6.852886834241239e-19,  2.399291816380904e-22, -6.844507527624656e-24, -3.031411821167430e-27,  7.282074972752960e-29,  1.080888248218502e+00,
 -2.472251093845627e-03, -7.313374665960996e-07,  9.952413070892005e-09,  8.006905954889693e-12, -7.087802843593016e-14, -9.416014107636739e-17,  6.026898632479704e-19,
  1.145958666934898e-21, -5.558762158887049e-24, -1.420855063792916e-26,  5.327720435392789e-29,  1.143035662931260e+00, -2.438374559335590e-03, -1.287583106181752e-06,
  9.271105241624242e-09,  1.378669063212244e-11, -5.938916763919528e-14, -1.561233827448680e-16,  4.231125137947150e-19,  1.801241029099846e-21, -2.880863994341008e-24,
 -2.081091357040476e-26,  1.471961945510592e-29,  1.204642391629063e+00, -2.385787774295319e-03, -1.809500919067461e-06,  8.240702339535902e-09,  1.859595007005158e-11,
 -4.277977359121360e-14, -1.971290621250181e-16,  1.799972880608205e-19,  2.065505149259502e-21,  4.330099101790262e-25, -2.080561554434905e-26, -2.758157310138653e-29,
  1.265466503805254e+00, -2.315289012912505e-03, -2.283126952335039e-06,  6.914590587302886e-09,  2.210607159016419e-11, -2.285484619230113e-14, -2.121084164416883e-16,
 -8.181825001139378e-20,  1.893543888274074e-21,  3.463757962448887e-24, -1.446978703631892e-26, -5.733711498273641e-29,  1.325268703409346e+00, -2.227959736120880e-03,
 -2.696104178205692e-06,  5.361372298041600e-09,  2.409696259209940e-11, -1.753138313605862e-15, -1.999668977368470e-16, -3.152768406131626e-19,  1.344264203296955e-21,
  5.408972954623538e-24, -4.221414021333785e-27, -6.405196004623031e-29,  1.383813288127737e+00, -2.125148611079332e-03, -3.038108649679497e-06,  3.660843118268038e-09,
  2.447480028348075e-11,  1.831318199077406e-14, -1.636691708923536e-16, -4.805866503367743e-19,  5.626318328322303e-22,  5.818698029576488e-24,  6.335375833490775e-27,
 -4.709348906464971e-29,  1.440869101065204e+00, -2.008451203225619e-03, -3.301206200648359e-06,  1.899293437382505e-09,  2.327826744641670e-11,  3.532495971067335e-14,
 -1.096513937493616e-16, -5.529469599653800e-19, -2.601017901901448e-22,  4.712299358881757e-24,  1.376130623620373e-26, -1.530694093929849e-29,  1.496210470667354e+00,
 -1.879685629465040e-03, -3.480126504443376e-06,  1.644212542665325e-10,  2.067270068542565e-11,  4.769379952925455e-14, -4.667124755115993e-17, -5.268656314061208e-19,
 -9.365896877780803e-22,  2.542810699081422e-24,  1.599574189314197e-26,  1.743017738656544e-29,  1.549618134668091e+00, -1.740864530460972e-03, -3.572444138644123e-06,
 -1.459829607537200e-09,  1.693273255113232e-11,  5.444028754445271e-14,  1.569511553414698e-17, -4.162145958669395e-19, -1.330077117194371e-21,  2.712112155887951e-26,
  1.297509087919655e-26,  3.848043907522030e-29,  1.600880143813987e+00, -1.594163784687872e-03, -3.578659551673161e-06, -2.898185068296679e-09,  1.241511590009572e-11,
  5.529000429143327e-14,  6.863977929934407e-17, -2.501527080695251e-19, -1.385069902166280e-21, -2.095361979497248e-24,  6.455836103489849e-27,  4.160295986174805e-29,
  1.649792741111109e+00, -1.441888445626743e-03, -3.502176375841952e-06, -4.088402652426441e-09,  7.524368288743355e-12,  5.067592818184885e-14,  1.055133448686044e-16,
 -6.598295850255032e-20, -1.134420904869960e-21, -3.291812992366714e-24, -8.297199327442749e-28,  2.877170427704755e-29,  1.696161212361442e+00, -1.286436435031578e-03,
 -3.349175255774243e-06, -4.984805297393718e-09,  2.674570649864461e-12,  4.164867562720032e-14,  1.227795655958158e-16,  9.931891590339585e-20, -6.822583347608072e-22,
 -3.377885813507535e-24, -6.298512776452408e-27,  8.162584713664672e-30,  1.739800703807056e+00, -1.130260568469117e-03, -3.128388124715963e-06, -5.560763810712909e-09,
 -1.748973548006933e-12,  2.970864065119966e-14,  1.203796640713262e-16,  2.169214702815559e-19, -1.690890526607730e-22, -2.532011355663096e-24, -8.452537239236344e-27,
 -1.034613716268578e-29,  1.780537002782736e+00, -9.758295233496373e-04, -2.850780523923326e-06, -5.809970531296642e-09, -5.424504928075450e-12,  1.658470538955020e-14,
  1.014637790679706e-16,  2.715480337210799e-19,  2.698074362447655e-22, -1.188646116199814e-24, -7.272787845648694e-27, -1.977779289153397e-29,  1.818207277393934e+00,
 -8.255883835843582e-04, -2.529152982844396e-06, -5.746423319364455e-09, -8.121647542850077e-12,  3.991288892998613e-15,  7.156529703698675e-17,  2.633715111566601e-19,
  5.402897118082490e-22,  1.411372826010987e-25, -3.975194537108702e-27, -1.859923084456312e-29,  1.852660771390813e+00, -6.819194081494596e-04, -2.177675527406309e-06,
 -5.403121406653039e-09, -9.719663325649920e-12, -6.601927123068031e-15,  3.739576675449432e-17,  2.061748545065410e-19,  6.096417297755775e-22,  1.051589223395904e-24,
 -3.087431400344909e-28, -1.029483738856652e-29,  1.883759450610050e+00, -5.471036726984925e-04, -1.811371939509131e-06, -4.829557557273458e-09, -1.021442674257823e-11,
 -1.415557887629039e-14,  5.504318966398692e-18,  1.224722913603667e-19,  5.066588364100962e-22,  1.361936599317711e-24,  2.249516332261122e-27, -6.436090188594379e-31,
  1.911378597629823e+00, -4.232842235624925e-04, -1.445572348729284e-06, -4.088168983345738e-09, -9.713559162831047e-12, -1.817637077544367e-14, -1.893637581184225e-17,
  3.699648398988732e-20,  3.034208882432117e-22,  1.137816190211805e-24,  3.044506827921989e-27,  5.573218327404039e-30,  1.935407351713340e+00, -3.124313615670611e-04,
 -1.095354013774521e-06, -3.249977347895933e-09, -8.420354793613503e-12, -1.874830076017064e-14, -3.298856666425249e-17, -2.970939141338570e-20,  8.616506740783971e-23,
  6.187392696438579e-25,  2.336134872567260e-27,  6.667980597634929e-30,  1.955749192007936e+00, -2.163106377528788e-04, -7.749906841921706e-07, -2.389701389186574e-09,
 -6.608259468608619e-12, -1.647715342833106e-14, -3.630032528686681e-17, -6.597312394767943e-20, -7.444880315137593e-23,  9.128369731781728e-26,  9.649548997027849e-28,
  4.075607760012322e-30,  1.972322364664368e+00, -1.364540880263693e-04, -4.974306687196065e-07, -1.580660501192582e-09, -4.588614647160858e-12, -1.235876608526251e-14,
 -3.090242145153833e-17, -7.085482065442262e-20, -1.439623943573041e-22, -2.350664503994690e-25, -1.855368861575661e-28,  6.953031225207343e-31,  1.985060266612995e+00,
 -7.413512179987534e-05, -2.738225349684600e-07, -8.898010906721047e-10, -2.675052437620788e-12, -7.592649271855819e-15, -2.051742866220442e-17, -5.288716931752559e-20,
 -1.296209230698004e-22, -2.992297647418171e-25, -6.375702122662555e-28, -1.196975664587325e-30,  1.993911882447792e+00, -3.034700023786644e-05, -1.131040888005351e-07,
 -3.731647326694571e-10, -1.148241096558143e-12, -3.370325812843055e-15, -9.544637337323607e-18, -2.623923593721585e-20, -7.024760126370166e-23, -1.833815133876069e-25,
 -4.666884654043922e-28, -1.155877525858283e-30,  1.998843556463378e+00, -5.778841423838362e-06, -2.164566023567140e-08, -7.201395864381933e-11, -2.243977244226227e-13,
 -6.704888943513339e-16, -1.945111355665605e-18, -5.519105040290291e-21, -1.538823048960809e-23, -4.229161638401003e-26, -1.148143611396204e-28, -3.083660083905046e-31,
  4.742878337256337e-04, -2.324406073717475e-06,  8.541619192643374e-09, -2.789224032290527e-11,  8.535470863322302e-14, -2.506346219249185e-16,  7.151243743425489e-19,
 -1.997542169109297e-21,  5.488611358702357e-24, -1.488303160962067e-26,  3.991854902787809e-29, -1.060801513854729e-31,  4.266049238063145e-03, -2.086871517970601e-05,
  7.640355932766831e-08, -2.479473150779159e-10,  7.516812185954245e-13, -2.178239827877487e-15,  6.105365728076029e-18, -1.666271569686905e-20,  4.445163986226971e-23,
 -1.161677204478600e-25,  2.976988431378467e-28, -7.481729328505078e-31,  1.183602587031380e-02, -5.768641946854957e-05,  2.096321438066408e-07, -6.718216125269671e-10,
  1.998100561924991e-12, -5.633345308306856e-15,  1.520231347442834e-17, -3.942064012165424e-20,  9.821643256544527e-23, -2.342544765441387e-25,  5.303160265878111e-28,
 -1.120284063145631e-30,  2.315716014750603e-02, -1.122393464342777e-04,  4.033167898502406e-07, -1.268020279339076e-09,  3.660736280118658e-12, -9.876656126125087e-15,
  2.500903519778300e-17, -5.912646304276733e-20,  1.283057526726000e-22, -2.450728248905019e-25,  3.637892871031628e-28, -1.739218619863989e-31,  3.818895271417431e-02,
 -1.837293363228435e-04,  6.502893057301416e-07, -1.991689093545610e-09,  5.514474467170526e-12, -1.394326185384594e-14,  3.188443514101693e-17, -6.354138927530038e-20,
  9.823885639222989e-23, -5.499168620538982e-26, -3.892391343038489e-28,  2.254443143899459e-30,  5.687756712681262e-02, -2.711090508894491e-04,  9.413546159583642e-07,
 -2.787331479643309e-09,  7.295696116288301e-12, -1.679340450072129e-14,  3.238215590672725e-17, -4.337177946350388e-20, -9.388581259866453e-24,  3.356915891572839e-25,
 -1.525880318246070e-27,  4.915350662448569e-30,  7.915596986213222e-02, -3.730962020288939e-04,  1.265587742328491e-06, -3.592191534611345e-09,  8.729263963529618e-12,
 -1.747972764442836e-14,  2.409450652929039e-17,  4.223526763738917e-21, -1.812763701530558e-22,  8.065956539885763e-25, -2.456020993700477e-27,  5.598174351885784e-30,
  1.049441060025883e-01, -4.881910441464142e-04,  1.610688248276031e-06, -4.340113464933412e-09,  9.557282694579342e-12, -1.530769895363906e-14,  6.331341701151320e-18,
  7.365650075221214e-20, -3.719696497853821e-22,  1.145449845021607e-24, -2.446087913678095e-27,  2.458274165343270e-30,  1.341491110232149e-01, -6.146969361201809e-04,
  1.963381572999231e-06, -4.965659393491835e-09,  9.566955935372244e-12, -9.966319475513533e-15, -1.951032179044043e-17,  1.511167397846310e-19, -5.142034390393856e-22,
  1.125831614798600e-24, -1.011951663824498e-27, -4.485205723030294e-30,  1.666655591625344e-01, -7.507437414624569e-04,  2.309855169853392e-06, -5.408250444596104e-09,
  8.614900894014049e-12, -1.609669378640682e-15, -4.997691943109741e-17,  2.170916309439028e-19, -5.388354130365724e-22,  6.079530183055597e-25,  1.723647577064489e-27,
 -1.263354363847542e-29,  2.023757489048467e-01, -8.943137990598961e-04,  2.636216165279338e-06, -5.616091435930272e-09,  6.645552697078377e-12,  9.124085284162074e-15,
 -8.000830968762695e-17,  2.507485230820791e-19, -3.987801975599638e-22, -3.769602960763903e-25,  4.905397283725075e-27, -1.753130613531242e-29,  2.411500261292349e-01,
 -1.043270161955732e-03,  2.928956409178373e-06, -5.549647890132486e-09,  3.701776798565020e-12,  2.116160136427106e-14, -1.037480774851403e-16,  2.352253504356218e-19,
 -8.949925921388994e-23, -1.596603468435417e-24,  7.163670068236217e-27, -1.494473578647033e-29,  2.828471454898830e-01, -1.195386768368510e-03,  3.175410327977687e-06,
 -5.184465286311200e-09, -7.352769687870920e-14,  3.310761136182626e-14, -1.155844811279534e-16,  1.625770306623135e-19,  3.410624272287482e-22, -2.663016757282169e-24,
  7.138718850568154e-27, -3.393302180672434e-30,  3.273146705805856e-01, -1.348380177916550e-03,  3.364190942814713e-06, -4.513153712212112e-09, -4.445261448526339e-12,
  4.341017446527587e-14, -1.112421393394345e-16,  3.711111611054259e-20,  7.976168440400327e-22, -3.147810335292533e-24,  4.119431473845642e-27,  1.421223511442931e-29,
  3.743894134015215e-01, -1.499942477280061e-03,  3.485589793705029e-06, -3.546404917532657e-09, -9.102973502730368e-12,  5.055811893445297e-14, -8.872466842525883e-17,
 -1.238629975360595e-19,  1.158064185498422e-21, -2.733773395104161e-24, -1.480059285084684e-27,  3.093652048179151e-29,  4.238979135864968e-01, -1.647774933780026e-03,
  3.531927322715757e-06, -2.312961170269999e-09, -1.368546746460417e-11,  5.328573345145314e-14, -4.892386185723413e-17, -2.923024468529555e-19,  1.305045301372952e-21,
 -1.351253771972529e-24, -8.052311083000676e-27,  3.841526776294276e-29,  4.756569577621046e-01, -1.789621953127315e-03,  3.497841510499173e-06, -8.585137082412741e-10,
 -1.781115878618089e-11,  5.075771105450798e-14,  4.239418152963640e-18, -4.344628923379580e-19,  1.160364024533900e-21,  7.532208942747814e-25, -1.323716157199417e-26,
  3.075019988920359e-29,  5.294741392950089e-01, -1.923304879478746e-03,  3.380504214530299e-06,  7.564300501867178e-10, -2.111158499267312e-11,  4.270876798032955e-14,
  6.420088434644660e-17, -5.177671272438576e-19,  7.124526690150849e-22,  3.050192005107888e-24, -1.476049983738313e-26,  7.931018935887841e-30,  5.851484585384863e-01,
 -2.046755162539994e-03,  3.179756694787472e-06,  2.459610330018745e-09, -2.326509476511025e-11,  2.951721127654819e-14,  1.226320104983528e-16, -5.180813112448597e-19,
  2.815181793953231e-23,  4.863627704698234e-24, -1.137181270422573e-26, -2.303111314633187e-29,  6.424709635134305e-01, -2.158046408404901e-03,  2.898158190957154e-06,
  4.170852398569577e-09, -2.402762402658135e-11,  1.219952591267603e-14,  1.706894696630272e-16, -4.257675760665203e-19, -7.561592552596035e-22,  5.574902315980614e-24,
 -3.499358736808803e-27, -5.018796172504716e-29,  7.012254307515902e-01, -2.255424828743033e-03,  2.540944078747929e-06,  5.806470042722635e-09, -2.325762867244774e-11,
 -7.677101178694692e-15,  2.004384384129457e-16, -2.490457928509934e-19, -1.463515207454080e-21,  4.831272933443688e-24,  6.685277438927807e-27, -6.140731023740741e-29,
  7.611890857896709e-01, -2.337337607448101e-03,  2.115893012779775e-06,  7.283988011279149e-09, -2.093268122233124e-11, -2.815671511011403e-14,  2.062115380211555e-16,
 -1.371261956593054e-20, -1.919029287738260e-21,  2.687948107241338e-24,  1.588913129416128e-26, -4.985655928311683e-29,  8.221333625323741e-01, -2.402458715502423e-03,
  1.633105478838506e-06,  8.526909895577985e-09, -1.715592392769320e-11, -4.711323265130087e-14,  1.856637870680197e-16,  2.409657178046728e-19, -1.995498915148621e-21,
 -3.705762269563043e-25,  2.082748310793651e-26, -1.769161506471258e-29,  8.838247004013450e-01, -2.449711724092616e-03,  1.104699237399829e-06,  9.469246879379507e-09,
 -1.215145087508620e-11, -6.249980758809216e-14,  1.403253771510393e-16,  4.695128789769780e-19, -1.649570447020933e-21, -3.547201811282272e-24,  1.945653855295879e-26,
  2.397879054651485e-29,  9.460253778568617e-01, -2.478289193330377e-03,  5.444301429271211e-07,  1.005952849849572e-08, -6.248692557189187e-12, -7.259782842396541e-14,
  7.553309421794040e-17,  6.292280452834855e-19, -9.379197140827326e-22, -5.958293308993900e-24,  1.182772447869008e-26,  5.918494237293879e-29,  1.008494380522079e+00,
 -2.487668249567810e-03, -3.275033671489717e-08,  1.026403946077894e-08,  1.430909295553262e-13, -7.623329074741363e-14, -2.746135808114465e-19,  6.890068724085429e-19,
 -7.879612985149127e-24, -6.901282026421935e-24,  1.989158747296408e-28,  7.367548240004552e-29,  1.070988301758690e+00, -2.477622008376121e-03, -6.111870081535388e-07,
  1.006906610654990e-08,  6.568134470036817e-12, -7.293141295325664e-14, -7.680227420254155e-17,  6.360537352417161e-19,  9.362001830435420e-22, -6.077806322435512e-24,
 -1.168645981064563e-26,  6.112581941146504e-29,  1.133262273141650e+00, -2.448226552727336e-03, -1.175046166012088e-06,  9.481990583954129e-09,  1.256243052079492e-11,
 -6.298755127082796e-14, -1.434860047189118e-16,  4.789336570441847e-19,  1.682732788207125e-21, -3.696983915569044e-24, -1.991203011409107e-26,  2.611662155049492e-29,
  1.195070921863576e+00, -2.399863236523421e-03, -1.708856342104181e-06,  8.531137568660446e-09,  1.769349049735466e-11, -4.744291452135464e-14, -1.911626063651293e-16,
  2.461800422570295e-19,  2.065846776724927e-21, -4.206368337700972e-25, -2.180402742288380e-26, -1.760474009487453e-29,  1.256169351671914e+00, -2.333216151871233e-03,
 -2.198045664387759e-06,  7.264353713691747e-09,  2.159791894312440e-11, -2.796598096050412e-14, -2.135330985932329e-16, -1.934629519124461e-20,  2.007223306442841e-21,
  2.835676061833962e-24, -1.690212622523718e-26, -5.291850265351025e-29,  1.316314143509875e+00, -2.249264673675823e-03, -2.629456411937269e-06,  5.746379528858989e-09,
  2.401321860292827e-11, -6.653237396953615e-15, -2.081634100921789e-16, -2.691829735124755e-19,  1.535260524292355e-21,  5.182884727195743e-24, -7.101668124976870e-27,
 -6.661166813165709e-29,  1.375264371602351e+00, -2.149271076234539e-03, -2.991817568478995e-06,  4.055152071236197e-09,  2.480070469360442e-11,  1.422587445039959e-14,
 -1.768417227094048e-16, -4.591861450970822e-19,  7.761458679611841e-22,  6.028351078573618e-24,  4.090795791488885e-27, -5.484330112312377e-29,  1.432782630307836e+00,
 -2.034763302318290e-03, -3.276157128838525e-06,  2.277249445729643e-09,  2.395719204053163e-11,  3.250675606673925e-14, -1.252241822376326e-16, -5.584511685107834e-19,
 -8.073691149863442e-23,  5.246667049302421e-24,  1.289126910541036e-26, -2.433924159314304e-29,  1.488636066654804e+00, -1.907513054231765e-03, -3.476137603207091e-06,
  5.027495382864916e-10,  2.161416351748439e-11,  4.639336506181123e-14, -6.182842713341772e-17, -5.552469591421973e-19, -8.333626552088487e-22,  3.196212882629238e-24,
  1.662837652147603e-26,  1.111570964052372e-29,  1.542597413104390e+00, -1.769509466825850e-03, -3.588300565758490e-06, -1.180179023126403e-09,  1.802433631569914e-11,
  5.467231721928525e-14,  3.446112327973674e-18, -4.586579797940338e-19, -1.319353393468552e-21,  5.796689653373726e-25,  1.464227693487075e-26,  3.710150420259253e-29,
  1.594446014739267e+00, -1.622928712462880e-03, -3.612209146754848e-06, -2.690609779371621e-09,  1.353679601343334e-11,  5.684823144344248e-14,  6.100402841892011e-17,
 -2.956283943563590e-19, -1.455404564138391e-21, -1.799535978112431e-24,  8.358783430027872e-27,  4.480148763576346e-29,  1.643968844780021e+00, -1.470099975414724e-03,
 -3.550480978411453e-06, -3.959767725258457e-09,  8.563038740450438e-12,  5.318186645381808e-14,  1.031397553097803e-16, -1.041843468128667e-19, -1.253204132312877e-21,
 -3.298104175977451e-24,  5.546180657242297e-28,  3.418726865946210e-29,  1.690961502083835e+00, -1.313468315898146e-03, -3.408708151340319e-06, -4.935187374666816e-09,
  3.537223280329153e-12,  4.462617522952949e-14,  1.252362201783306e-16,  7.549314466083770e-20, -8.082984141353290e-22, -3.621295599498671e-24, -5.837403405724163e-27,
  1.290958690208577e-29,  1.735229184094362e+00, -1.155555019663369e-03, -3.195265070104915e-06, -5.583834976904452e-09, -1.125421163621746e-12,  3.266994019769383e-14,
  1.263635398800399e-16,  2.099860722302739e-19, -2.664317420756680e-22, -2.878630720942274e-24, -8.862706086685690e-27, -8.185618621999373e-30,  1.776587628594519e+00,
 -9.989160955106093e-04, -2.921009541178805e-06, -5.893974146352151e-09, -5.067838775437934e-12,  1.911201026133359e-14,  1.091811545719412e-16,  2.794393501511521e-19,
  2.215680495022892e-22, -1.497176792391789e-24, -8.158480677105003e-27, -2.042631033582467e-29,  1.814864017573763e+00, -8.460996381689233e-04, -2.598886797362857e-06,
 -5.875635210184934e-09, -8.024038654383101e-12,  5.799306094471858e-15,  7.918228471457152e-17,  2.807097481383125e-19,  5.423052497640261e-22, -3.490208249681426e-26,
 -4.843351211214409e-27, -2.087462596553812e-29,  1.849897836567380e+00, -6.996028156528590e-04, -2.243450265818120e-06, -5.559641561230852e-09, -9.842247738480488e-12,
 -5.632914633147374e-15,  4.344745106316341e-17,  2.262857973019412e-19,  6.471616087360795e-22,  1.029531087814248e-24, -8.107453544040205e-28, -1.257176106284132e-29,
  1.881541682971207e+00, -5.618292667653116e-04, -1.870316531329141e-06, -4.995244900659306e-09, -1.049592985345366e-11, -1.398044653022770e-14,  9.168020482482489e-18,
  1.394871412285675e-19,  5.572984306573952e-22,  1.451023200984577e-24,  2.196235486931592e-27, -1.822059431124485e-30,  1.909662017110518e+00, -4.350477043383018e-04,
 -1.495574953590083e-06, -4.246518469870234e-09, -1.008154156647124e-11, -1.861727710584038e-14, -1.775821348468280e-17,  4.738531948341397e-20,  3.466336648899852e-22,
  1.264527057442952e-24,  3.291509517495064e-27,  5.637696351255648e-30,  1.934139850333231e+00, -3.213525117047369e-04, -1.135174609990385e-06, -3.387746046764131e-09,
 -8.803303745729789e-12, -1.954967590176864e-14, -3.377834709053140e-17, -2.657709407538345e-20,  1.101943152684324e-22,  7.182629150467204e-25,  2.645341021653105e-27,
  7.394734411910341e-30,  1.954871365417689e+00, -2.226270916956198e-04, -8.043125237528944e-07, -2.498117853722928e-09, -6.946665619704635e-12, -1.737079410004514e-14,
 -3.818037659564554e-17, -6.829509470024192e-20, -7.042287468474715e-23,  1.336597097835939e-25,  1.158741994468477e-27,  4.748037145712523e-30,  1.971768467504236e+00,
 -1.405106722338845e-04, -5.168473909233302e-07, -1.656096718882510e-09, -4.843369972479493e-12, -1.312475985675928e-14, -3.295213360711920e-17, -7.559838388353337e-20,
 -1.525503616378316e-22, -2.418052274276495e-25, -1.495582040830736e-28,  9.485981223047588e-31,  1.984759276297695e+00, -7.636915186342322e-05, -2.847620523009574e-07,
 -9.338440203322004e-10, -2.831952019279914e-12, -8.103316490028296e-15, -2.205799470381346e-17, -5.721242171769583e-20, -1.408651598987810e-22, -3.258103075823946e-25,
 -6.920620576666337e-28, -1.280036012344822e-30,  1.993788655973118e+00, -3.127006238203353e-05, -1.176945621631322e-07, -3.920885429984892e-10, -1.217999175512820e-12,
 -3.608473738859571e-15, -1.031182560414818e-17, -2.859649164191382e-20, -7.719797457393511e-23, -2.031066799260157e-25, -5.206012468038668e-28, -1.297520089415306e-30,
  1.998820089206524e+00, -5.955525447806767e-06, -2.253182080577528e-08, -7.571419044419465e-11, -2.382871400277737e-13, -7.190830691704885e-16, -2.106775582858224e-18,
 -6.036802003624506e-21, -1.699677349522704e-23, -4.716755610399176e-26, -1.292899331573128e-28, -3.505729602890908e-31,  4.651247878090363e-04, -2.257389106230154e-06,
  8.214943911518058e-09, -2.656575266786565e-11,  8.050921612867753e-14, -2.341234485639419e-16,  6.615736899060952e-19, -1.830179959338490e-21,  4.980473694762217e-24,
 -1.337582167060375e-26,  3.553334242310344e-29, -9.352778786727770e-32,  4.183778274642222e-03, -2.026918697889280e-05,  7.349894066792143e-08, -2.362611283418409e-10,
  7.095447333820804e-13, -2.037152769349944e-15,  5.658111343430412e-18, -1.530494045918783e-20,  4.047624253347998e-23, -1.048929316670862e-25,  2.666459731505351e-28,
 -6.650331066562371e-31,  1.160858400443934e-02, -5.604107470787333e-05,  2.017584473066875e-07, -6.407338839620255e-10,  1.888994607908666e-12, -5.281387617605199e-15,
  1.414129736648378e-17, -3.640864545913751e-20,  9.015348885071568e-23, -2.139982136622764e-25,  4.832118817566401e-28, -1.022140957158818e-30,  2.271456084705874e-02,
 -1.090726961720176e-04,  3.884455627080548e-07, -1.210996706695747e-09,  3.469073590774268e-12, -9.295849871446648e-15,  2.340966880573919e-17, -5.515904866951011e-20,
  1.197430265610652e-22, -2.306947097904326e-25,  3.546478817840133e-28, -2.383255176082494e-31,  3.746429071935605e-02, -1.786211439430479e-04,  6.269093566459663e-07,
 -1.905647445211516e-09,  5.243119210405762e-12, -1.319903201755216e-14,  3.014896930043128e-17, -6.043223879594670e-20,  9.600177792830619e-23, -6.868981948366070e-26,
 -2.983463820160274e-28,  1.886507181190088e-30,  5.580798352815411e-02, -2.637100466971466e-04,  9.085960770357112e-07, -2.673245473542681e-09,  6.967501246926105e-12,
 -1.603082887039937e-14,  3.116527517427222e-17, -4.349022296312301e-20,  1.648213297777681e-24,  2.788079936475221e-25, -1.322493146367885e-27,  4.339494309464016e-30,
  7.768356476860258e-02, -3.631415772890338e-04,  1.223308018490814e-06, -3.455288619629558e-09,  8.385458394899070e-12, -1.690066971356625e-14,  2.413578633835604e-17,
 -1.131203450603926e-21, -1.539489316913147e-22,  7.131676312647944e-25, -2.218205300341758e-27,  5.210452363911933e-30,  1.030167866287434e-01, -4.755112872363085e-04,
  1.559514311356538e-06, -4.189637240090741e-09,  9.252808498335260e-12, -1.513230577835251e-14,  8.233147117452477e-18,  6.239458511097161e-20, -3.324676283885113e-22,
  1.049871257295732e-24, -2.330563094755957e-27,  2.771523958814295e-30,  1.317213636473271e-01, -5.992256482821491e-04,  1.904705431716033e-06, -4.814206745445442e-09,
  9.363280349835395e-12, -1.038561417231393e-14, -1.550338103321048e-17,  1.353025341504415e-19, -4.744460830691246e-22,  1.081796964529155e-24, -1.180528434053173e-27,
 -3.214421018105587e-30,  1.636991341567436e-01, -7.325221557319099e-04,  2.245781927082943e-06, -5.270732715374100e-09,  8.571195427304504e-12, -2.738100413438613e-15,
 -4.413637304653504e-17,  2.002113323275003e-19, -5.158368273767532e-22,  6.663516813587280e-25,  1.210058389616331e-27, -1.074254888705902e-29,  1.988402489136399e-01,
 -8.734918213337277e-04,  2.569466731507976e-06, -5.508404708932075e-09,  6.809393605284398e-12,  7.286684144081849e-15, -7.316778329184579e-17,  2.378068155536478e-19,
 -4.090006630410313e-22, -1.957188957134384e-25,  4.167936090710880e-27, -1.598559171717776e-29,  2.370233884735156e-01, -1.020103855599970e-03,  2.862729539597686e-06,
 -5.487166659768325e-09,  4.100640887514683e-12,  1.875030842897916e-14, -9.721011733007040e-17,  2.314957460050618e-19, -1.419778699753045e-22, -1.323230988042961e-24,
  6.505009704609444e-27, -1.493834422107207e-29,  2.781160109991838e-01, -1.170232310725857e-03,  3.113211052957633e-06, -5.180493665000432e-09,  5.612589846167016e-13,
  3.038935635851710e-14, -1.108935495374620e-16,  1.720119065576440e-19,  2.502912271510194e-22, -2.381158906679726e-24,  6.937764329123641e-27, -5.647313248276463e-30,
  3.219746323031510e-01, -1.321684425820350e-03,  3.309634535084804e-06, -4.577476923365775e-09, -3.603657438885348e-12,  4.075561309576704e-14, -1.098624982466088e-16,
  6.085466586837926e-20,  6.874008998020108e-22, -2.971778784114695e-24,  4.652064342347452e-27,  1.008219087384335e-29,  3.684451400071498e-01, -1.472230386284142e-03,
  3.442192039780762e-06, -3.684079996519255e-09, -8.113364711006340e-12,  4.839120520491583e-14, -9.168888120555297e-17, -8.838843819819596e-20,  1.058898954194491e-21,
 -2.767046269082458e-24, -2.154802590022338e-28,  2.655897618822527e-29,  4.173631437545178e-01, -1.619634179215264e-03,  3.502892938325310e-06, -2.523469427482372e-09,
 -1.263213327425375e-11,  5.201801909911053e-14, -5.653140729451042e-17, -2.513782148877538e-19,  1.251004053287457e-21, -1.640186218941027e-24, -6.411283799809022e-27,
  3.608761209658409e-29,  4.685543634289756e-01, -1.761685197169097e-03,  3.485862981634505e-06, -1.135369547162743e-09, -1.679595068846233e-11,  5.071769490240620e-14,
 -7.402336395882581e-18, -3.969968990864183e-19,  1.178280322678331e-21,  2.513316410573960e-25, -1.184591346027411e-26,  3.231575145696573e-29,  5.218350573126055e-01,
 -1.896230214034254e-03,  3.387583108590818e-06,  4.255569295997888e-10, -2.024316198657660e-11,  4.407829308519725e-14,  5.003828328069620e-17, -4.933248929551954e-19,
  8.117322745243176e-22,  2.468510081753037e-24, -1.428200929343566e-26,  1.364071574162950e-29,  5.770124920524631e-01, -2.021205329911002e-03,  3.207058555539838e-06,
  2.092246551460998e-09, -2.264649266442348e-11,  3.228656460348711e-14,  1.081640310740503e-16, -5.144686321667703e-19,  1.948323394172124e-22,  4.390881046733386e-24,
 -1.220715850249609e-26, -1.502097706518351e-29,  6.338854561952856e-01, -2.134667457506802e-03,  2.945910529324535e-06,  3.788580817223317e-09, -2.374364702450023e-11,
  1.615046538009990e-14,  1.584591725191052e-16, -4.467847440591459e-19, -5.584963743553104e-22,  5.392761235167585e-24, -5.557298095151279e-27, -4.327284178500300e-29,
  6.922448188894111e-01, -2.234824901609227e-03,  2.608384759970381e-06,  5.433378555447383e-09, -2.336365696856957e-11, -2.955387691782873e-15,  1.928359857573937e-16,
 -2.930491076920089e-19, -1.285421972795915e-21,  5.045234074923373e-24,  4.029910668378137e-27, -5.905865232437419e-29,  7.518741351387955e-01, -2.320066566662947e-03,
  2.201273618468701e-06,  6.944828682948574e-09, -2.144639132340388e-11, -2.321909115800242e-14,  2.049832560143866e-16, -7.345500589788696e-20, -1.811363759319091e-21,
  3.278335050947753e-24,  1.360101536046536e-26, -5.386594095972559e-29,  8.125502987228829e-01, -2.388989316436344e-03,  1.733751124353928e-06,  8.245121265161731e-09,
 -1.805312008496263e-11, -4.258355962373317e-14,  1.915159747765183e-16,  1.770553949890800e-19, -1.994057422601670e-21,  4.441203415173116e-25,  1.983924394443886e-26,
 -2.703822063401314e-29,  8.740442435656531e-01, -2.440423005326966e-03,  1.217123015481203e-06,  9.265011041445988e-09, -1.336673538929168e-11, -5.898031963230227e-14,
  1.527146146352667e-16,  4.148355109760522e-19, -1.763036203428444e-21, -2.751077354405216e-24,  2.026935613283720e-26,  1.295554866451324e-29,  9.361216939458509e-01,
 -2.473452704142707e-03,  6.644970311237311e-07,  9.948038186916209e-09, -7.681112450453418e-12, -7.057719986562075e-14,  9.269972502564165e-17,  5.958789094025124e-19,
 -1.143294884683327e-21, -5.435336714642046e-24,  1.426229852386881e-26,  5.125276054554062e-29,  9.985439634876312e-01, -2.487437655291054e-03,  9.038157632662639e-08,
  1.025413778693077e-08, -1.380079245771933e-12, -7.600863300939110e-14,  1.897674667373649e-17,  6.847874535241342e-19, -2.554028704813074e-22, -6.828693217082103e-24,
  3.421858005401511e-27,  7.248631269961481e-29,  1.061068802357305e+00, -2.482026514211775e-03, -4.897761164252381e-07,  1.016239319534964e-08,  5.092532861503758e-12,
 -7.455777344442233e-14, -5.860685718081824e-17,  6.624264861165198e-19,  7.096512296431505e-22, -6.489504514231822e-24, -8.852732864447121e-27,  6.739900676496135e-29,
  1.123451291519612e+00, -2.457168466459918e-03, -1.060098450825358e-06,  9.672729025625234e-09,  1.126935998101327e-11, -6.626433732659269e-14, -1.293430880759151e-16,
  5.305003682228361e-19,  1.535611709627096e-21, -4.467187210656908e-24, -1.851745681058031e-26,  3.718754540640329e-29,  1.185444782279663e+00, -2.413119853748123e-03,
 -1.604816229260291e-06,  8.806395752047184e-09,  1.669935004287677e-11, -5.194065052216327e-14, -1.833475502548613e-16,  3.118751990244882e-19,  2.034847095708284e-21,
 -1.305110856040908e-24, -2.233932665919511e-26, -6.578108716247214e-30,  1.246801878659959e+00, -2.350445997891849e-03, -2.108819379302507e-06,  7.605167360233995e-09,
  2.098734539676825e-11, -3.308992801259242e-14, -2.131611683230152e-16,  4.638326102685566e-20,  2.096592299675679e-21,  2.114732619641146e-24, -1.909945686600173e-26,
 -4.666024565966769e-29,  1.307275459442931e+00, -2.270017979047266e-03, -2.558199865780782e-06,  6.129252602879106e-09,  2.382961354452972e-11, -1.173388291529634e-14,
 -2.149851110735417e-16, -2.171298786608987e-19,  1.716021045520111e-21,  4.839809500996667e-24, -1.005859292342960e-26, -6.750094768674068e-29,  1.366619735957940e+00,
 -2.173004203587638e-03, -2.940766245693048e-06,  4.454004566258583e-09,  2.504175409426555e-11,  9.830394640980457e-15, -1.893183988032436e-16, -4.308504151689782e-19,
  9.955107670554872e-22,  6.141584712220906e-24,  1.519523801869432e-27, -6.189009818785548e-29,  1.424591340918796e+00, -2.060856686696407e-03, -3.246509334075949e-06,
  2.665596987577226e-09,  2.457600603544866e-11,  2.931362218405300e-14, -1.408678935399002e-16, -5.579154090969323e-19,  1.171415103371221e-22,  5.738124528187066e-24,
  1.161223766045865e-26, -3.385922913400704e-29,  1.480950442837310e+00, -1.935292074059461e-03, -3.467999305162843e-06,  8.559131299476765e-10,  2.252591759017301e-11,
  4.472001732273650e-14, -7.773047040664855e-17, -5.799443440977873e-19, -7.062280134126281e-22,  3.868989753687318e-24,  1.695526475611523e-26,  3.537323810078265e-30,
  1.535461879765347e+00, -1.798267534216458e-03, -3.600696291600569e-06, -8.830420295582386e-10,  1.911754493146401e-11,  5.459616745392468e-14, -9.983420043153807e-18,
 -5.004272067760460e-19, -1.287555520849130e-21,  1.197323373372973e-24,  1.622104731493989e-26,  3.443612998505814e-29,  1.587896305369411e+00, -1.651951765986035e-03,
 -3.643159162095689e-06, -2.464848686680981e-09,  1.468770368002102e-11,  5.820767678579928e-14,  5.206515568516850e-17, -3.431694386079561e-19, -1.513687079186990e-21,
 -1.424959180416131e-24,  1.038849876400829e-26,  4.733009319813182e-29,  1.638031339636238e+00, -1.498691481241314e-03, -3.597140606610653e-06, -3.814116587304045e-09,
  9.651169436074006e-12,  5.561757357417417e-14,  9.964335685439662e-17, -1.461792656567723e-19, -1.371159202463349e-21, -3.244204206233464e-24,  2.180881763244853e-27,
  3.974562435133258e-29,  1.685652715864646e+00, -1.340973839081983e-03, -3.467560842294220e-06, -4.871287641561898e-09,  4.459959073792044e-12,  4.765416536259942e-14,
  1.269679976816305e-16,  4.749786719225319e-20, -9.427170781406236e-22, -3.841882484930618e-24, -5.152393326889489e-27,  1.833918318150227e-29,  1.730555415037798e+00,
 -1.181385419678946e-03, -3.262357028921646e-06, -5.596447766550786e-09, -4.412242560597595e-13,  3.577215884036025e-14,  1.321077176759150e-16,  1.997330870840084e-19,
 -3.765232639926988e-22, -3.239548224131228e-24, -9.162145745606447e-27, -5.297661616501592e-30,  1.772544778211214e+00, -1.022568431062710e-03, -2.992210661047465e-06,
 -5.971856598875088e-09, -4.658757403681175e-12,  2.182699868521797e-14,  1.170961568809117e-16,  2.856024053241675e-19,  1.615779269204933e-22, -1.841600723320047e-24,
 -9.064662123939912e-27, -2.069174101725238e-29,  1.811437587215306e+00, -8.671749360772407e-04, -2.670160558201212e-06, -6.002985978372018e-09, -7.888402009793563e-12,
  7.795957835755776e-15,  8.728464434025229e-17,  2.980041845033525e-19,  5.373339973385579e-22, -2.476882826913819e-25, -5.812898346604983e-27, -2.319948603390649e-29,
  1.847063103777522e+00, -7.178199658488036e-04, -2.311114348548960e-06, -5.717959939132955e-09, -9.943953188122967e-12, -4.511769648403639e-15,  5.007890250648925e-17,
  2.475805941123255e-19,  6.835010153159208e-22,  9.853018295087598e-25, -1.419485947529700e-27, -1.514882592302978e-29,  1.879264057142685e+00, -5.770344468299615e-04,
 -1.931276264054998e-06, -5.165403329863447e-09, -1.077301148049855e-11, -1.371148229937930e-14,  1.333130292621880e-17,  1.581732544350555e-19,  6.110935488201517e-22,
  1.536860180783426e-24,  2.084945179970205e-27, -3.287536318794924e-30,  1.907897570449696e+00, -4.472189074792579e-04, -1.547513364344424e-06, -4.410824581774549e-09,
 -1.045803495018694e-11, -1.902625635107055e-14, -1.626910506244106e-17,  5.923185984493456e-20,  3.945862737722124e-22,  1.401143071575762e-24,  3.538923133761783e-27,
  5.586601372899526e-30,  1.932836016603945e+00, -3.305989448964270e-04, -1.176685725850361e-06, -3.531771147336556e-09, -9.202462180507188e-12, -2.036886303446951e-14,
 -3.446910208127557e-17, -2.261608473787834e-20,  1.380368750844239e-22,  8.308080997661024e-25,  2.987543424427054e-27,  8.166970164318390e-30,  1.953967795490827e+00,
 -2.291834177659877e-04, -8.349684456824680e-07, -2.612094272595862e-09, -7.303400981361027e-12, -1.831032016303966e-14, -4.012339912123652e-17, -7.046227159902247e-20,
 -6.472450048399655e-23,  1.844067924333376e-25,  1.384217635391682e-27,  5.517856890631231e-30,  1.971198027507183e+00, -1.447262816328292e-04, -5.371943185891775e-07,
 -1.735734299325815e-09, -5.113948023952003e-12, -1.394157182499596e-14, -3.513854730159645e-17, -8.062034310790499e-20, -1.613521907541717e-22, -2.468660541501712e-25,
 -1.012280683654742e-28,  1.258391372423545e-30,  1.984449171421312e+00, -7.869285559241426e-05, -2.962454908112245e-07, -9.804811008712483e-10, -2.999444704764567e-12,
 -8.652452136558728e-15, -2.372485212529561e-17, -6.191322792141172e-20, -1.531064120677460e-22, -3.546436925142234e-25, -7.502111497690496e-28, -1.362927718528944e-30,
  1.993661662336811e+00, -3.223077599879241e-05, -1.225189785059157e-07, -4.121676095742480e-10, -1.292709817155888e-12, -3.865852025072337e-15, -1.114824059002108e-17,
 -3.118794969303310e-20, -8.489882003182595e-23, -2.251181930591527e-25, -5.811382091321097e-28, -1.457347468214045e-30,  1.998795900748356e+00, -6.139480220641131e-06,
 -2.346375031012969e-08, -7.964464380761327e-11, -2.531884434441129e-13, -7.717371143939605e-16, -2.283683159166057e-18, -6.608896373441764e-21, -1.879173636963683e-23,
 -5.266143787075026e-26, -1.457570733870846e-28, -3.990444531756535e-31,  4.562246819428092e-04, -2.192923162907275e-06,  7.903731990424335e-09, -2.531421937439229e-11,
  7.598146521693023e-14, -2.188430464010639e-16,  6.124894234412048e-19, -1.678242804597500e-21,  4.523566919616911e-24, -1.203345664406654e-26,  3.166477446532191e-29,
 -8.255890345580897e-32,  4.103859822373821e-03, -1.969234604079188e-05,  7.073060240938929e-08, -2.252271219874153e-10,  6.701256549898368e-13, -1.906357611963189e-15,
  5.247153038005397e-18, -1.406811640932680e-20,  3.688523405411000e-23, -9.479005197865485e-26,  2.390325256140486e-28, -5.916255031125254e-31,  1.138759985992845e-02,
 -5.445725645891807e-05,  1.942475572653756e-07, -6.113368928376881e-10,  1.786679847176680e-12, -4.953910777882326e-15,  1.316111199281840e-17, -3.364335272606472e-20,
  8.278687497215044e-23, -1.955420900233779e-25,  4.402519066964977e-28, -9.318448414470301e-31,  2.228439446936635e-02, -1.060223298581987e-04,  3.742405954976891e-07,
 -1.156948856436127e-09,  3.288652018684874e-12, -8.752125846145920e-15,  2.191763119562494e-17, -5.145743551492876e-20,  1.116906987919080e-22, -2.167333866314000e-25,
  3.430797591937175e-28, -2.848591431525763e-31,  3.675969385130957e-02, -1.736959338487627e-04,  6.045363411787476e-07, -1.823830637811325e-09,  4.986239046467217e-12,
 -1.249541720748044e-14,  2.849948815201038e-17, -5.740189393985691e-20,  9.333325724649047e-23, -7.905973005743621e-26, -2.224387072936518e-28,  1.572036604865282e-30,
  5.476748035566690e-02, -2.565677228081341e-04,  8.771755616372143e-07, -2.564290160496736e-09,  6.654265768591407e-12, -1.529746010287022e-14,  2.994972556633204e-17,
 -4.328673234660938e-20,  1.077769062202315e-23,  2.295706259009664e-25, -1.143143439667009e-27,  3.822053649969206e-30,  7.625031197221176e-02, -3.535187116347988e-04,
  1.182638506515837e-06, -3.323793939886431e-09,  8.053232245255440e-12, -1.632232448359994e-14,  2.403888365701319e-17, -5.663467701815263e-21, -1.298177997448576e-22,
  6.289096871100313e-25, -1.997533216261165e-27,  4.820470241528781e-30,  1.011393788191943e-01, -4.632337814975598e-04,  1.510116983118194e-06, -4.044002164209659e-09,
  8.952273781712587e-12, -1.491491358423455e-14,  9.836805033847685e-18,  5.234259750030984e-20, -2.963202689138644e-22,  9.591531850879532e-25, -2.203910830516254e-27,
  2.968185820409538e-30,  1.293545740359224e-01, -5.842165558511541e-04,  1.847826909138823e-06, -4.666074916852358e-09,  9.152145406134670e-12, -1.071391361009565e-14,
 -1.192167371789479e-17,  1.207340040296966e-19, -4.363824616769310e-22,  1.032073410033635e-24, -1.297935984574211e-27, -2.154977100822156e-30,  1.608045807543551e-01,
 -7.148065686469366e-04,  2.183353980808901e-06, -5.134087365693261e-09,  8.506285224051468e-12, -3.731945147669644e-15, -3.875788294495840e-17,  1.840968205971530e-19,
 -4.910861273888056e-22,  7.058153596313391e-25,  7.755279306127676e-28, -9.039631111851269e-30,  1.953869770858936e-01, -8.531986282856182e-04,  2.504024083059335e-06,
 -5.398381715333295e-09,  6.938098699083713e-12,  5.609076095136366e-15, -6.669326241474784e-17,  2.246368883058134e-19, -4.132109774752745e-22, -4.261171476465356e-26,
  3.498709502717852e-27, -1.443652321712835e-29,  2.329883613102808e-01, -9.974642602207295e-04,  2.797289171791932e-06, -5.418680924155783e-09,  4.452838826659035e-12,
  1.649449253945105e-14, -9.079865324590246e-17,  2.262392100188968e-19, -1.850883711006037e-22, -1.076105043487305e-24,  5.853539741915852e-27, -1.463022972221262e-29,
  2.734844996908594e-01, -1.145575088075148e-03,  3.051118602912389e-06, -5.166794176577176e-09,  1.142826131162974e-12,  2.778653491865412e-14, -1.059775936406248e-16,
  1.787027186242900e-19,  1.694998079007388e-22, -2.109160365831471e-24,  6.649656203166417e-27, -7.365493200868654e-30,  3.167404995608859e-01, -1.295427987605986e-03,
  3.254385297223599e-06, -4.628757182187569e-09, -2.814761726761530e-12,  3.814174839823923e-14, -1.078664345193421e-16,  8.117646503707319e-20,  5.838631579218837e-22,
 -2.777926286911091e-24,  5.014198633225380e-27,  6.462607334083772e-30,  3.626110105250306e-01, -1.444871819866988e-03,  3.397235745575974e-06, -3.806271575112770e-09,
 -7.167727005295057e-12,  4.616471047206273e-14, -9.370434499142135e-17, -5.609694375529620e-20,  9.594002715243922e-22, -2.753554428549241e-24,  8.591913138912059e-28,
  2.232037029113157e-29,  4.109404567938810e-01, -1.591735519604530e-03,  3.471432707160643e-06, -2.717336706220461e-09, -1.160588741477133e-11,  5.058126962181933e-14,
 -6.301875930113447e-17, -2.123372685790538e-19,  1.187716733967155e-21, -1.865673011845438e-24, -4.883378104402595e-27,  3.329978826668618e-29,  4.615633038118114e-01,
 -1.733857282543140e-03,  3.470659568071642e-06, -1.396003282321175e-09, -1.578425169662148e-11,  5.041091369235189e-14, -1.798965559094932e-17, -3.592358153665094e-19,
  1.179144174738552e-21, -1.938282628435892e-25, -1.040783674306199e-26,  3.290078263887034e-29,  5.143043624439971e-01, -1.869114561173136e-03,  3.390775738527423e-06,
  1.087794719977918e-10, -1.935069029390262e-11,  4.511646814507775e-14,  3.660142306459573e-17, -4.660365937363020e-19,  8.904734984698992e-22,  1.910674805713989e-24,
 -1.357601811616757e-26,  1.827311527973309e-29,  5.689791340500194e-01, -1.995454543510532e-03,  3.230013203531260e-06,  1.735204681834135e-09, -2.197596457129425e-11,
  3.471048706207226e-14,  9.386927900283017e-17, -5.058002472310450e-19,  3.439760474509261e-22,  3.891610684299314e-24, -1.270222342110613e-26, -7.590288813959561e-30,
  6.253941997823399e-01, -2.110924753795053e-03,  2.989105425951310e-06,  3.411468882610332e-09, -2.338363050512929e-11,  1.980152408473827e-14,  1.457278521119267e-16,
 -4.615968973631351e-19, -3.687977798682582e-22,  5.134513757563364e-24, -7.302047009922770e-27, -3.599607226019437e-29,  6.833476574003778e-01, -2.213703379146164e-03,
  2.671341247730704e-06,  5.059335768752295e-09, -2.337717202735204e-11,  1.569732192500193e-15,  1.840822391516114e-16, -3.312504705466790e-19, -1.101509439749448e-21,
  5.155445738715146e-24,  1.507255695385329e-27, -5.541258802891398e-29,  7.426296087772566e-01, -2.302128892917202e-03,  2.282538248154881e-06,  6.598237849655447e-09,
 -2.186177713578398e-11, -1.833061109820451e-14,  2.021334887328354e-16, -1.294300116302603e-19, -1.684129678823129e-21,  3.774171784576106e-24,  1.117399746804982e-26,
 -5.617696721620363e-29,  8.030227010886611e-01, -2.374728515166093e-03,  1.830932188115638e-06,  7.949709267178082e-09, -1.885846306436131e-11, -3.793487593941870e-14,
  1.955836694236310e-16,  1.136520525241683e-19, -1.964094287983448e-21,  1.211417776415605e-24,  1.846669506341773e-26, -3.512696015756637e-29,  8.643027244040623e-01,
 -2.430245024762303e-03,  1.326981669948907e-06,  9.041909397354779e-09, -1.450878274298474e-11, -5.518224518158426e-14,  1.635264010233374e-16,  3.569911325385892e-19,
 -1.847373136546596e-21, -1.932135076849919e-24,  2.059820805872618e-26,  2.038847123520405e-30,  9.262392680427196e-01, -2.467661417787470e-03,  7.830899284991888e-07,
  9.813974512284955e-09, -9.069079178838291e-12, -6.815650206390726e-14,  1.088435321243184e-16,  5.562770802214112e-19, -1.328178322366556e-21, -4.822355871963852e-24,
  1.632012966454677e-26,  4.211194652820126e-29,  9.885964376041301e-01, -2.486222894788287e-03,  2.132486743885588e-07,  1.021992638305712e-08, -2.894150121758353e-12,
 -7.532425209314469e-14,  3.799964225346022e-17,  6.727138446791489e-19, -4.980104389031637e-22, -6.628827017760136e-24,  6.548231899902311e-27,  6.930017273410657e-29,
  1.051133634030010e+00, -2.485455656893708e-03, -3.673879532760809e-07,  1.023187440372067e-08,  3.588826467660962e-12, -7.573941478358126e-14, -3.977656623137630e-17,
  6.813349179072734e-19,  4.703832597717088e-22, -6.782850855768589e-24, -5.782050439602082e-27,  7.186322175648445e-29,  1.113606395399256e+00, -2.465181999599490e-03,
 -9.429881107319060e-07,  9.842272976274052e-09,  9.914262116771364e-12, -6.918492416951230e-14, -1.138262998774278e-16,  5.769272763901200e-19,  1.361883200619225e-21,
 -5.172046345804029e-24, -1.664998912138960e-26,  4.754926394820569e-29,  1.175767301397603e+00, -2.425531214850729e-03, -1.497571389491170e-06,  9.065038864258442e-09,
  1.561727877383230e-11, -5.622889324361201e-14, -1.737117282781073e-16,  3.760657403540607e-19,  1.971740100936645e-21, -2.201052074172289e-24, -2.237201580745992e-26,
  5.185254681755976e-30,  1.237366939541599e+00, -2.366945848434872e-03, -2.015565324030148e-06,  7.935393114749682e-09,  2.027453281346686e-11, -3.818256502304625e-14,
 -2.109127925808276e-16,  1.145409685911157e-19,  2.158496438444536e-21,  1.311931774327008e-24, -2.098209733306973e-26, -3.863217440750373e-29,  1.298154931276838e+00,
 -2.290182911860348e-03, -2.482369849480589e-06,  6.508366704334677e-09,  2.354287975059671e-11, -1.696011801677491e-14, -2.202703644447960e-16, -1.595129305825284e-19,
  1.882297306545186e-21,  4.378211412330687e-24, -1.301421487479674e-26, -6.652432154787139e-29,  1.357881015021694e+00, -2.196309716658686e-03, -2.884908505171009e-06,
  4.855994589404719e-09,  2.519196787475393e-11,  5.145791676231315e-15, -2.009029311201270e-16, -3.954502263503938e-19,  1.217028535035878e-21,  6.146045285827126e-24,
 -1.340363596707433e-27, -6.790802409664353e-29,  1.416296182102432e+00, -2.086694084703025e-03, -3.212144136169713e-06,  3.063314270702056e-09,  2.512720784307452e-11,
  2.574595074807271e-14, -1.564053694493688e-16, -5.507751597779902e-19,  3.316897119811769e-22,  6.169955142332715e-24,  9.908247562661270e-27, -4.360887930940333e-29,
  1.473153860340295e+00, -1.962988790332639e-03, -3.455536687829311e-06,  1.223376088308323e-09,  2.340033467515954e-11,  4.265720439554566e-14, -9.426342896338992e-17,
 -6.001840514303540e-19, -5.547217076385224e-22,  4.547811614029510e-24,  1.692181945826998e-26, -5.249261757815202e-30,  1.528211138827033e+00, -1.827110207716855e-03,
 -3.609421533558845e-06, -5.684437895175538e-10,  2.020591341453744e-11,  5.418381040777880e-14, -2.456481713005737e-17, -5.408111986009044e-19, -1.232417364752597e-21,
  1.875371927878318e-24,  1.765157246692398e-26,  3.034169446877852e-29,  1.581230026187635e+00, -1.681211268064217e-03, -3.671288698957528e-06, -2.220467672577463e-09,
  1.586354606665837e-11,  5.933641766736890e-14,  4.177116326095303e-17, -3.923438944672516e-19, -1.556998828385787e-21, -9.672142013828592e-25,  1.251070784091623e-26,
  4.896816258749389e-29,  1.631978733407268e+00, -1.527648973196689e-03, -3.641946368920492e-06, -3.650670611821835e-09,  1.078707769893635e-11,  5.795483256698706e-14,
  9.491864079088307e-17, -1.919046664747061e-19, -1.485943921533379e-21, -3.120353556517149e-24,  4.052064162646551e-27,  4.529132852478270e-29,  1.680232971126461e+00,
 -1.368946861006270e-03, -3.525556148775639e-06, -4.792137674454221e-09,  5.443604260801160e-12,  5.071381854788638e-14,  1.278545345060441e-16,  1.507990188456030e-20,
 -1.084524281537277e-21, -4.030092983423061e-24, -4.213738194248380e-27,  2.443362487906069e-29,  1.725777250220267e+00, -1.207752969913877e-03, -3.329532586867575e-06,
 -5.597609665210501e-09,  3.063702646397951e-13,  3.900838257437771e-14,  1.375135226269644e-16,  1.857472355396281e-19, -4.997906650870132e-22, -3.609667415443928e-24,
 -9.316827148058583e-27, -1.591042593793372e-30,  1.768406173511330e+00, -1.046793998467234e-03, -3.064305273058788e-06, -6.042748975518702e-09, -4.193463855708646e-12,
  2.473378931932315e-14,  1.251549351683033e-16,  2.896403778747946e-19,  8.853451178278537e-23, -2.222368281867473e-24, -9.972054325903225e-27, -2.046160411422268e-29,
  1.807925705662557e+00, -8.888264969116012e-04, -2.742948154676535e-06, -6.127836366263801e-09, -7.710848664215886e-12,  9.992851811944049e-15,  9.586781494023717e-17,
  3.150092907378735e-19,  5.239796881939264e-22, -5.013042683520936e-25, -6.884772171497004e-27, -2.551467972782752e-29,  1.844154407692624e+00, -7.365860538912785e-04,
 -2.380687247011283e-06, -5.877717368549070e-09, -1.002159522088729e-11, -3.224185018848785e-15,  5.732261412955776e-17,  2.700078491822145e-19,  7.177817216704443e-22,
  9.143642437277195e-25, -2.148424483157477e-27, -1.803643986401757e-29,  1.876924622200324e+00, -5.927355472822283e-04, -1.994304302170836e-06, -5.339946420475331e-09,
 -1.104367123771787e-11, -1.333612341135777e-14,  1.804235441912808e-17,  1.786292626535249e-19,  6.678822760532876e-22,  1.616861562518856e-24,  1.902036776360343e-27,
 -5.085169732762385e-30,  1.906083595329097e+00, -4.598136076142806e-04, -1.601459855126972e-06, -4.581217966742631e-09, -1.084232274916162e-11, -1.939533854744199e-14,
 -1.442605779517473e-17,  7.269347771090163e-20,  4.476342809201303e-22,  1.547569034300079e-24,  3.780908376586732e-27,  5.384559690654455e-30,  1.931494521863204e+00,
 -3.401844900417404e-04, -1.219964005600702e-06, -3.682314713982140e-09, -9.618160619009696e-12, -2.120319286930171e-14, -3.503584702586752e-17, -1.769657846518782e-20,
  1.701857465541117e-22,  9.577329730115801e-25,  3.364608715700981e-27,  8.978040524507415e-30,  1.953037500963835e+00, -2.359905605565583e-04, -8.670269595831964e-07,
 -2.731931335365318e-09, -7.679397990954153e-12, -1.929718458080665e-14, -4.212426228214074e-17, -7.241606142536683e-20, -5.702844284051313e-23,  2.448815742422314e-25,
  1.645921396875131e-27,  6.396765907439059e-30,  1.970610393363673e+00, -1.491085639145091e-04, -5.585234211766105e-07, -1.819834717974740e-09, -5.401398609031623e-12,
 -1.481257708193666e-14, -3.746954364299211e-17, -8.592647500873420e-20, -1.702979554350769e-22, -2.497020643092878e-25, -3.782643326133811e-29,  1.635621798522510e-30,
  1.984129584385142e+00, -8.111071181639702e-05, -3.083050231803209e-07, -1.029888145224057e-09, -3.178331043282999e-12, -9.243217071796552e-15, -2.552897548945685e-17,
 -6.702281824370910e-20, -1.664284083574882e-22, -3.858755077303874e-25, -8.119676674712322e-28, -1.443625110254680e-30,  1.993530747100153e+00, -3.323106946120937e-05,
 -1.275916893405278e-07, -4.334843428084419e-10, -1.372774788629104e-12, -4.144203596355055e-15, -1.206078891973009e-17, -3.403899487915793e-20, -9.343741453966951e-23,
 -2.496977057689027e-25, -6.491510644575791e-28, -1.637752623005543e-30,  1.998770961255679e+00, -6.331083225986736e-06, -2.444431129406816e-08, -8.382217892590594e-11,
 -2.691866174299189e-13, -8.288358431419096e-16, -2.477444185194970e-18, -7.241725450988286e-21, -2.079686794838898e-23, -5.885872092962284e-26, -1.645129077738660e-28,
 -4.547832091648036e-31,  4.475775538671168e-04, -2.130888050085875e-06,  7.607113686380110e-09, -2.413274781976556e-11,  7.174787836495017e-14, -2.046912243166693e-16,
  5.674617603703520e-19, -1.540182411024025e-21,  4.112312398671455e-24, -1.083659971863397e-26,  2.824795100247564e-29, -7.296161951092306e-32,  4.026205264151043e-03,
 -1.913713270305900e-05,  6.809097261611970e-08, -2.148034180065356e-10,  6.332265891590254e-13, -1.785022537518362e-15,  4.869270226937133e-18, -1.294059238707233e-20,
  3.363880220153689e-23, -8.572970644733299e-26,  2.144570750000381e-28, -5.267590132051165e-31,  1.117283300970113e-02, -5.293214161474482e-05,  1.870798209657308e-07,
 -5.835257938983422e-10,  1.690685515328732e-12, -4.649055284187739e-15,  1.225515213704054e-17, -3.110348492285764e-20,  7.605468763546587e-23, -1.787271199965732e-25,
  4.011001850352814e-28, -8.489647195751023e-31,  2.186620631688252e-02, -1.030830572459251e-04,  3.606672346700462e-07, -1.105702666381513e-09,  3.118755084810592e-12,
 -8.242995637562756e-15,  2.052570621111545e-17, -4.800554816588367e-20,  1.041321972260837e-22, -2.032712745918254e-25,  3.297919827915400e-28, -3.170137215080637e-31,
  3.607444597622075e-02, -1.689458494872021e-04,  5.831209244013576e-07, -1.746013456916895e-09,  4.743042124817719e-12, -1.183038172311783e-14,  2.693360906575084e-17,
 -5.446235501742627e-20,  9.034286800177330e-23, -8.665596039468290e-26, -1.593255410730663e-28,  1.303826739414665e-30,  5.375505191226743e-02, -2.496716172828992e-04,
  8.470329182849318e-07, -2.460230858667370e-09,  6.355406559056409e-12, -1.459316473030887e-14,  2.874370684715691e-17, -4.281811815378914e-20,  1.825841613303687e-23,
  1.870681554939535e-25, -9.853537371714134e-28,  3.358782276564804e-30,  7.485490979342480e-02, -3.442149798191928e-04,  1.143515418171755e-06, -3.197522511274487e-09,
  7.732539903680519e-12, -1.574774324328012e-14,  2.382544427144542e-17, -9.470398218469424e-21, -1.085651950492147e-22,  5.531366668763364e-25, -1.793915877879944e-27,
  4.436388538099055e-30,  9.931030162866099e-02, -4.513445453029619e-04,  1.462438574454430e-06, -3.903138863255176e-09,  8.656449651809326e-12, -1.466228334141120e-14,
  1.117471740821174e-17,  4.339606469369503e-20, -2.633457525200934e-22,  8.736451941544443e-25, -2.070739659653472e-27,  3.071341495925451e-30,  1.270469219142031e-01,
 -5.696554391710584e-04,  1.792705497628596e-06, -4.521369240959815e-09,  8.935271746210923e-12, -1.096101114459081e-14, -8.731107798284873e-18,  1.073540504053570e-19,
 -4.001827046648820e-22,  9.785294036633060e-25, -1.372903218061454e-27, -1.281215999253357e-30,  1.579799012113521e-01, -6.975838652767787e-04,  2.122558913717475e-06,
 -4.998632732655162e-09,  8.422752883711926e-12, -4.602029900518725e-15, -3.381932036459907e-17,  1.687938510568007e-19, -4.652100366290463e-22,  7.293418346930292e-25,
  4.118590324819787e-28, -7.520527226254440e-30,  1.920138393558413e-01, -8.334236628093549e-04,  2.439912986006852e-06, -5.286559540334512e-09,  7.034775589787175e-12,
  4.082421138728539e-15, -6.058859316932623e-17,  2.114153872278753e-19, -4.123749129456223e-22,  8.508223125443943e-26,  2.897034734321259e-27, -1.292020729026133e-29,
  2.290428508183853e-01, -9.753448080455678e-04,  2.732702981915966e-06, -5.344912644253393e-09,  4.761446506151173e-12,  1.439063774560579e-14, -8.455238390951617e-17,
  2.197404841698684e-19, -2.197674565316339e-22, -8.546938092203275e-25,  5.220960252529848e-27, -1.409047068532145e-29,  2.689506250532568e-01, -1.121413793177438e-03,
  2.989244680238781e-06, -5.144199596277440e-09,  1.673530381352244e-12,  2.530366135613628e-14, -1.009090341768669e-16,  1.829625130338028e-19,  9.827599180777687e-23,
 -1.850054855771010e-24,  6.296541554940649e-27, -8.612892343960138e-30,  3.116105049840929e-01, -1.269615794122532e-03,  3.198594714038147e-06, -4.667830538288607e-09,
 -2.077620070663438e-12,  3.558224950292543e-14, -1.053466780223580e-16,  9.829920862307208e-20,  4.875278224508642e-22, -2.572624240651376e-24,  5.228217218345208e-27,
  3.347446585969357e-30,  3.568855870799562e-01, -1.417878515185636e-03,  3.350902456472372e-06, -3.913691516786308e-09, -6.267031524915629e-12,  4.390033549968707e-14,
 -9.486009227067479e-17, -2.697370066992108e-20,  8.611166535907255e-22, -2.700745188026911e-24,  1.752021781434492e-27,  1.830547601148508e-29,  4.046288467652074e-01,
 -1.564097570570610e-03,  3.437743613601819e-06, -2.895022023169591e-09, -1.060984617747597e-11,  4.900170552244552e-14, -6.844245518946979e-17, -1.754398476416338e-19,
  1.117381479882266e-21, -2.032598061737679e-24, -3.485440867954099e-27,  3.020354443414283e-29,  4.546832931781370e-01, -1.706163231017067e-03,  3.452425426575629e-06,
 -1.640512365112010e-09, -1.478114368869525e-11,  4.986271325951253e-14, -2.752160727538197e-17, -3.216923638413838e-19,  1.165021518725360e-21, -5.812086338332702e-25,
 -8.963079019805406e-27,  3.264254337297377e-29,  5.068821575384732e-01, -1.841988328372690e-03,  3.390253345415183e-06, -1.935695875060135e-10, -1.844061666310560e-11,
  4.584159380512649e-14,  2.396093336501563e-17, -4.365440583066719e-19,  9.496872353845639e-22,  1.384842896201361e-24, -1.268951290621179e-26,  2.185264138932817e-29,
  5.610491195945517e-01, -1.969537071988526e-03,  3.248749259440262e-06,  1.389260540945823e-09, -2.126036639331803e-11,  3.679477062317908e-14,  7.988133243689802e-17,
 -4.926500377155433e-19,  4.748665405286347e-22,  3.378873985800049e-24, -1.288570878478893e-26, -8.774652912718104e-31,  6.169985767875066e-01, -2.086854488917558e-03,
  3.027811896514402e-06,  3.040684651272929e-09, -2.295367841559652e-11,  2.314273110987343e-14,  1.326652863600998e-16, -4.705002861066459e-19, -1.895746729511518e-22,
  4.812928889832728e-24, -8.723394464244430e-27, -2.861269887392367e-29,  6.745359608815320e-01, -2.192096155708612e-03,  2.729810873243538e-06,  4.685788993740416e-09,
 -2.330236877832038e-11,  5.872594505995910e-15,  1.743417067358789e-16, -3.635222914527897e-19, -9.154039019499502e-22,  5.168289464023394e-24, -8.307657043067129e-28,
 -5.070666905960495e-29,  7.334581068541270e-01, -2.283557844075171e-03,  2.359607123727330e-06,  6.245778759677173e-09, -2.218020179714180e-11, -1.352885715740215e-14,
  1.977759710360269e-16, -1.810668310666358e-19, -1.540812994562804e-21,  4.171380516811488e-24,  8.681487114110367e-27, -5.685881765557290e-29,  7.935536788053328e-01,
 -2.359704657117469e-03,  1.924494078644846e-06,  7.642160273859840e-09, -1.956999925531332e-11, -3.320973763218917e-14,  1.978935671219616e-16,  5.163822580312826e-20,
 -1.907578738500174e-21,  1.917105312664767e-24,  1.676915772543102e-26, -4.178761098246881e-29,  8.546036575166538e-01, -2.419199188615780e-03,  1.434056019022592e-06,
  8.801156230270518e-09, -1.557240643021467e-11, -5.114440122215267e-14,  1.726852066719237e-16,  2.969212882005892e-19, -1.902106193635034e-21, -1.109537346399213e-24,
  2.045539481890681e-26, -8.429986001246619e-30,  9.163818940545698e-01, -2.460928197022251e-03,  8.999424817666405e-07,  9.658111344401634e-09, -1.040485062100473e-11,
 -6.536230670657374e-14,  1.237990862983249e-16,  5.111271403104692e-19, -1.489612366982111e-21, -4.135389357292904e-24,  1.795517550444604e-26,  3.209185450771616e-29,
  9.786557334563130e-01, -2.484027250274901e-03,  3.355604164921781e-07,  1.016162402133984e-08, -4.389999769944569e-12, -7.418824818068802e-14,  5.657704059127669e-17,
  6.530157440701544e-19, -7.312107657221115e-22, -6.307272618966196e-24,  9.492611926798539e-27,  6.424017775920768e-29,  1.041186712043580e+00, -2.487902769816319e-03,
 -2.443110713302959e-07,  1.027713196620124e-08,  2.066044891454213e-12, -7.646365000130394e-14, -2.052544776399535e-17,  6.924418630179804e-19,  2.228078628267081e-22,
 -6.950013251186816e-24, -2.557933255418528e-27,  7.435183870450546e-29,  1.103731331271081e+00, -2.472250884800990e-03, -8.239751934902337e-07,  9.989688731478991e-09,
  8.504578496880374e-12, -7.171815976603834e-14, -9.709109545202117e-17,  6.174041650898537e-19,  1.164231608065816e-21, -5.793379894900146e-24, -1.434903477166500e-26,
  5.683268165087150e-29,  1.166041910221443e+00, -2.437072503122659e-03, -1.387329499096818e-06,  9.305695889048320e-09,  1.445189952601841e-11, -6.026456619700158e-14,
 -1.623116878032023e-16,  4.377215645460738e-19,  1.876481731673624e-21, -3.087810868924432e-24, -2.187746183547443e-26,  1.732477996287602e-29,  1.227867517899211e+00,
 -2.382684017303047e-03, -1.918420339573029e-06,  8.253402630434496e-09,  1.946056272352395e-11, -4.319814338691441e-14, -2.067327122036369e-16,  1.842033818849135e-19,
  2.190233869067154e-21,  4.413811062486555e-25, -2.247511424659602e-26, -2.898054752787703e-29,  1.288954985351793e+00, -2.309723093043638e-03, -2.402021460522896e-06,
  6.882050534626673e-09,  2.315048650831427e-11, -2.229325481730318e-14, -2.238705116940797e-16, -9.686372130136475e-20,  2.029843633441872e-21,  3.799830410753924e-24,
 -1.588311588631581e-26, -6.354107861474646e-29,  1.349049996356427e+00, -2.219149038643307e-03, -2.824215603663801e-06,  5.259623741749077e-09,  2.524579373325830e-11,
  1.958547541721392e-16, -2.113971543498003e-16, -3.529814739075433e-19,  1.436587326829204e-21,  6.031189947722794e-24, -4.436404757281402e-27, -7.257145527222339e-29,
  1.407898253968068e+00, -2.112237326324012e-03, -3.172955835566169e-06,  3.469259776562555e-09,  2.560334749050041e-11,  2.180856869364217e-14, -1.716445623670182e-16,
 -5.365346279917606e-19,  5.604535048439930e-22,  6.525045211730685e-24,  7.775761482357293e-27, -5.328220959612931e-29,  1.465246718638715e+00, -1.990567932880159e-03,
 -3.438582002749160e-06,  1.604477928445763e-09,  2.422948461496700e-11,  4.019137032013359e-14, -1.112915570362127e-16, -6.151855900742486e-19, -3.788981123079662e-22,
  5.217231084415955e-24,  1.647717044038734e-26, -1.512976754261766e-29,  1.520844911917262e+00, -1.856007287153379e-03, -3.614267448050925e-06, -2.365170255927602e-10,
  2.128244475803456e-11,  5.340815313009480e-14, -4.024851793078566e-17, -5.790295487974706e-19, -1.151886955798263e-21,  2.606591528860122e-24,  1.886836602146700e-26,
  2.470554599055322e-29,  1.574446277951586e+00, -1.710683754693347e-03, -3.696372082579321e-06, -1.957106475870552e-09,  1.705938044242641e-11,  6.020143931363239e-14,
  3.008347725763010e-17, -4.426241591929927e-19, -1.582289221436598e-21, -4.234528041879857e-25,  1.468113995545771e-26,  4.948309450901716e-29,  1.625809593180992e+00,
 -1.556956753366257e-03, -3.684680210904835e-06, -3.468682746440051e-09,  1.196849137889495e-11,  6.016292422606176e-14,  8.886296597284195e-17, -2.412169199261094e-19,
 -1.594864342925270e-21, -2.916820419639128e-24,  6.163520471922369e-27,  5.063246492105730e-29,  1.674700412774932e+00, -1.397379773975881e-03, -3.582505203463614e-06,
 -4.696759001722702e-09,  6.488579080734483e-12,  5.378333741740585e-14,  1.277688748362660e-16, -2.197652102863060e-20, -1.232364903645571e-21, -4.175208085276405e-24,
 -2.993131008580688e-27,  3.114429217854453e-29,  1.720892540598185e+00, -1.234657772073638e-03, -3.396648160165098e-06, -5.586285347894540e-09,  1.119952577301701e-12,
  4.236918830002412e-14,  1.424704902638009e-16,  1.676027788235093e-19, -6.364520652986901e-22, -3.982451984490528e-24, -9.288834676639632e-27,  3.018805557404399e-30,
  1.764169507824799e+00, -1.071599594555316e-03, -3.137203972793895e-06, -6.105721026721486e-09, -3.668092649836250e-12,  2.783507035049124e-14,  1.332919427448499e-16,
  2.911146639671090e-19,  1.134145269534528e-24, -2.639055522011047e-24, -1.085611592048041e-26, -1.960925241568102e-29,  1.804326043848973e+00, -9.110662996290776e-04,
 -2.817215424040042e-06, -6.249483044226839e-09, -7.487259197047544e-12,  1.240139857200150e-14,  1.049197130695264e-16,  3.314325031898334e-19,  5.006990689921715e-22,
 -7.998132842969781e-25, -8.056919726185537e-27, -2.774302647510539e-29,  1.841169521920461e+00, -7.559164125771306e-04, -2.452183807269775e-06, -6.038501395443340e-09,
 -1.007169557538476e-11, -1.755094360718845e-15,  6.520922114948781e-17,  2.934853453577464e-19,  7.489523787386112e-22,  8.116357520534862e-25, -3.011311732325242e-27,
 -2.123699120455365e-29,  1.874521361039140e+00, -6.089493231157857e-04, -2.059452572533294e-06, -5.518753668100295e-09, -1.130564569822796e-11, -1.284061811397429e-14,
  2.335203746461226e-17,  2.009470177541775e-19,  7.273993159885182e-22,  1.687856263202484e-24,  1.631838695268926e-27, -7.263499772066479e-30,  1.904218365165923e+00,
 -4.728481636290635e-04, -1.657488193608446e-06, -4.757816474643369e-09, -1.123351831749853e-11, -1.971546774718723e-14, -1.218151406036891e-17,  8.793882075264522e-20,
  5.061252274827748e-22,  1.703443018563138e-24,  4.009916230826133e-27,  4.989074033755276e-30,  1.930113980886790e+00, -3.501236018589724e-04, -1.265089268119386e-06,
 -3.839643638472464e-09, -1.005066989645638e-11, -2.204935105053614e-14, -3.544973502218633e-17, -1.167221825837045e-20,  2.071840871327727e-22,  1.100463487335449e-24,
  3.778033751905965e-27,  9.817632646379032e-30,  1.952079455675460e+00, -2.430600274256096e-04, -9.005602737817998e-07, -2.857944875793587e-09, -8.075616774627048e-12,
 -2.033269627309608e-14, -4.417604158240802e-17, -7.408664586916653e-20, -4.695723071532106e-23,  3.166327954027567e-25,  1.948924817352197e-27,  7.397224230199589e-30,
  1.970004882321611e+00, -1.536655953674722e-04, -5.808899088930225e-07, -1.908676797542659e-09, -5.706840940191521e-12, -1.574134153528393e-14, -3.995313104446819e-17,
 -9.151998165878022e-20, -1.792959628128835e-22, -2.496474123854477e-25,  4.388977552790759e-29,  2.093172664982588e-30,  1.983800129146728e+00, -8.362746540803786e-05,
 -3.209750108306494e-07, -1.082254295483115e-09, -3.369477512097090e-12, -9.879047018572245e-15, -2.748230810253575e-17, -7.257718560948883e-20, -1.809200596920276e-22,
 -4.196473793033865e-25, -8.771784299852083e-28, -1.519429772720957e-30,  1.993395747874888e+00, -3.427299002213326e-05, -1.329280748533746e-07, -4.561278695087298e-10,
 -1.458632432406014e-12, -4.445445991067751e-15, -1.305712866459844e-17, -3.717797386830500e-20, -1.029118139203252e-22, -2.771631342878716e-25, -7.256035272360914e-28,
 -1.841439406705556e-30,  1.998745239338254e+00, -6.530735680854911e-06, -2.547657704451737e-08, -8.826507944661961e-11, -2.863747422592048e-13, -8.908049290849589e-16,
 -2.689857324837189e-18, -7.942438107754356e-21, -2.303921860241231e-23, -6.585768056918646e-26, -1.859023663502830e-28, -5.189641800766888e-31,  4.391739085438736e-04,
 -2.071170303462117e-06,  7.324275770187259e-09, -2.301680679122852e-11,  6.778682691654279e-14, -1.915751260608592e-16,  5.261218402977832e-19, -1.414618346362682e-21,
  3.741783061423147e-24, -9.768332560696816e-27,  2.522662434078183e-29, -6.455399606162418e-32,  3.950730103473950e-03, -1.860254592114676e-05,  6.557296347410209e-08,
 -2.049511676996003e-10,  5.986660307522749e-13, -1.672389246829287e-15,  4.521551400634706e-18, -1.191191970265251e-20,  3.070151543278543e-23, -7.759757504101761e-26,
  1.925672005246066e-28, -4.693937643451141e-31,  1.096405401245282e-02, -5.146305938285455e-05,  1.802367998403802e-07, -5.572029850125936e-10,  1.600576499933091e-12,
 -4.365113226338077e-15,  1.141738144822998e-17, -2.876965693524081e-20,  6.990050982493056e-23, -1.634073662372322e-25,  3.654404087520703e-28, -7.730434302354595e-31,
  2.145956191155020e-02, -1.002499571528692e-04,  3.476928482524725e-07, -1.057095149129754e-09,  2.958714382625613e-12, -7.766138681928510e-15,  1.922711997431568e-17,
 -4.478788382166911e-20,  9.704845642321458e-23, -1.903653948741269e-25,  3.153518273888810e-28, -3.376703979642942e-31,  3.540786161394405e-02, -1.643634183870143e-04,
  5.626163992753571e-07, -1.671983035210888e-09,  4.512776711854040e-12, -1.120195070081416e-14,  2.544865960782932e-17, -5.162241909118724e-20,  8.712172359326847e-23,
 -9.195150133430910e-26, -1.071133884166861e-28,  1.075563033449912e-30,  5.276973340381885e-02, -2.430117382873641e-04,  8.181107558245316e-07, -2.360842184649177e-09,
  6.070345009252822e-12, -1.391763067355697e-14,  2.755393912530062e-17, -4.213342299920563e-20,  2.431788575081583e-23,  1.504845776183307e-25, -8.468358323183382e-28,
  2.945348830452828e-30,  7.349610604711845e-02, -3.352182580387021e-04,  1.105877178732508e-06, -3.076290540345353e-09,  7.423279714015954e-12, -1.517948929257789e-14,
  2.351453293124564e-17, -1.263935159452490e-20, -8.989785960724225e-23,  4.851734757961338e-25, -1.606955031600250e-27,  4.064186658878024e-30,  9.752802912090193e-02,
 -4.398300550084731e-04,  1.416422298445320e-06, -3.766966665964425e-09,  8.365979539288266e-12, -1.438043280816273e-14,  1.227644405230161e-17,  3.545649936154580e-20,
 -2.333527591558320e-22,  7.935317536634374e-25, -1.934721536454746e-27,  3.100549002563925e-30,  1.247966432305100e-01, -5.555284072494180e-04,  1.739299584407883e-06,
 -4.380169043778756e-09,  8.714192194556639e-12, -1.113590166308448e-14, -5.899256574523967e-18,  9.510114112806999e-20, -3.659556946156577e-22,  9.227063403381682e-25,
 -1.413066545962480e-27, -5.691855995598287e-31,  1.552231500215401e-01, -6.808410446231686e-04,  2.063380729328395e-06, -4.864647534729160e-09,  8.322969882737759e-12,
 -5.358636695872478e-15, -2.929754039203084e-17,  1.543297877350415e-19, -4.387332045030570e-22,  7.396059172100140e-25,  1.111268136981183e-28, -6.177332225669470e-30,
  1.887187842427553e-01, -8.141561946184187e-04,  2.377152053886042e-06, -5.173426965150309e-09,  7.102354548671635e-12,  2.697842927816986e-15, -5.485309268233815e-17,
  1.982896765811999e-19, -4.073591348010215e-22,  1.900276508412935e-25,  2.360847596177633e-27, -1.146357426660886e-29,  2.251847904768973e-01, -9.537384237159464e-04,
  2.669030275401864e-06, -5.266535177142266e-09,  5.029460837835708e-12,  1.243439163601441e-14, -7.850245138119061e-17,  2.122547267342707e-19, -2.469249684821152e-22,
 -6.580563745423143e-25,  4.616093231489351e-27, -1.337984044565852e-29,  2.645124075285394e-01, -1.097746264500551e-03,  2.927691222949722e-06, -5.113504362314030e-09,
  2.155801980956695e-12,  2.294361548525590e-14, -9.575172648036242e-17,  1.850895642253415e-19,  3.611364345049386e-23, -1.606047415042525e-24,  5.897712557749382e-27,
 -9.453866586855912e-30,  3.065828638402888e-01, -1.244251604191431e-03,  3.142404337983151e-06, -4.695515705123539e-09, -1.391026587670813e-12,  3.308863653857135e-14,
 -1.023895215711132e-16,  1.124588682566407e-19,  3.987057399706410e-22, -2.361358250188469e-24,  5.315929494997412e-27,  7.172999347879980e-31,  3.512673876983844e-01,
 -1.391260791435434e-03,  3.303365096207662e-06, -4.007063866979624e-09, -5.411836700215168e-12,  4.161765460332934e-14, -9.524408683756822e-17, -9.585633945467259e-22,
  7.653351561626675e-22, -2.615675571010802e-24,  2.474291454046345e-27,  1.457602128392624e-29,  3.984272363823472e-01, -1.536737394702320e-03,  3.402016851725002e-06,
 -3.057030136456991e-09, -9.646615562434555e-12,  4.730411074948511e-14, -7.286536150359897e-17, -1.408787818614501e-19,  1.042010039125686e-21, -2.146390801941579e-24,
 -2.228032987226569e-27,  2.693257194423964e-29,  4.479137488056081e-01, -1.678626517125808e-03,  3.431353073353653e-06, -1.869071505176497e-09, -1.379120252643749e-11,
  4.909829703058372e-14, -3.601068644388952e-17, -2.848128502819872e-19,  1.137988662644397e-21, -9.112429377671662e-25, -7.545650153284675e-27,  3.168173613423144e-29,
  4.995684265781211e-01, -1.814880538935462e-03,  3.386190556622910e-06, -4.812576476104248e-10, -1.751900631428845e-11,  4.627345408186786e-14,  1.216996709846506e-17,
 -4.054524285503789e-19,  9.906445371579111e-22,  8.973225368045123e-25, -1.166771313550282e-26,  2.443402041232627e-29,  5.532230487891301e-01, -1.943486119645045e-03,
  3.263403999987839e-06,  1.055081349478981e-09, -2.050640745305374e-11,  3.854821814485654e-14,  6.631744892636695e-17, -4.756075214155447e-19,  5.872354672221964e-22,
  2.864471342671668e-24, -1.279144694305500e-26,  5.022323173051061e-30,  6.086998261477683e-01, -2.062492248004100e-03,  3.062112381518566e-06,  2.677297139664885e-09,
 -2.246005409167746e-11,  2.616808201531932e-14,  1.194319027035228e-16, -4.738641065676719e-19, -2.287385249653013e-23,  4.440967484138535e-24, -9.821753630559813e-27,
 -2.134957933419611e-29,  6.658116004181314e-01, -2.170039078709321e-03,  2.783807916502945e-06,  4.314114531907697e-09, -2.314391572585215e-11,  9.931513459557028e-15,
  1.637808818648003e-16, -3.898489659505654e-19, -7.304670921250740e-22,  5.092010481219004e-24, -2.942971685260461e-27, -4.518957577567363e-29,  7.243620953287823e-01,
 -2.264387241617040e-03,  2.432419070883618e-06,  5.888986991448162e-09, -2.240375156437537e-11, -8.848502855671013e-15,  1.920388405703653e-16, -2.279079978588237e-19,
 -1.384994479648245e-21,  4.468743100672470e-24,  6.192681269485924e-27, -5.603223777281852e-29,  7.841462253069843e-01, -2.343947252635269e-03,  2.014300200524589e-06,
  7.323985149323081e-09, -2.018661779800821e-11, -2.844977107399898e-14,  1.984961191970507e-16, -8.174278965168732e-21, -1.826947243548427e-21,  2.549476032287523e-24,
  1.481203574124825e-26, -4.691405609724904e-29,  8.449504684659305e-01, -2.407308596922066e-03,  1.538141924310755e-06,  8.544042507230886e-09, -1.655321227025884e-11,
 -4.690710000821155e-14,  1.801419751461209e-16,  2.355718104555198e-19, -1.927437774948013e-21, -3.016634974958547e-25,  1.986751363765670e-26, -1.814445017412893e-29,
  9.065533102375528e-01, -2.453267996221077e-03,  1.014798349103166e-06,  9.481341966710691e-09, -1.168125414142231e-11, -6.222490889340619e-14,  1.374219225073331e-16,
  4.612187525205418e-19, -1.625246333865734e-21, -3.392020003558403e-24,  1.913642524639664e-26,  2.154374897971688e-29,  9.687257638715109e-01, -2.480856315326031e-03,
  4.570297563738838e-07,  1.007959384825288e-08, -5.858719749307849e-12, -7.261383702480766e-14,  7.450031800227130e-17,  6.260627125874254e-19, -9.507735166178977e-22,
 -5.872906740269793e-24,  1.217655681613452e-26,  5.749934936357009e-29,  1.031231973689152e+00, -2.489363510454237e-03, -1.208376820945754e-07,  1.029793433885556e-08,
  5.334194228477302e-13, -7.672302634085753e-14, -1.074974775522111e-18,  6.955551781662507e-19, -2.844312190919295e-23, -6.986625410772424e-24,  7.303971618585742e-28,
  7.477342011219750e-29,  1.093829906466160e+00, -2.478360977849128e-03, -7.033302170382357e-07,  1.011416642600006e-08,  7.048334636662035e-12, -7.383688494350733e-14,
 -7.931431755454582e-17,  6.512168539279301e-19,  9.459635932127928e-22, -6.314899563284745e-24, -1.166961450707165e-26,  6.470000471297054e-29,  1.156272135596907e+00,
 -2.447720627752154e-03, -1.274314214615104e-06,  9.527076584243517e-09,  1.320868075948084e-11, -6.400629561106070e-14, -1.492327258568480e-16,  4.958232125922143e-19,
  1.749785123447607e-21, -3.944080630773124e-24, -2.084769436197429e-26,  2.944614918755866e-29,  1.218306721747257e+00, -2.397629990823641e-03, -1.817540672865175e-06,
  8.557592247842969e-09,  1.854744274874010e-11, -4.808990783734294e-14, -2.005926545411198e-16,  2.543692864863886e-19,  2.189662806349363e-21, -4.799657226912505e-25,
 -2.351169123939710e-26, -1.792766760090596e-29,  1.279678192514807e+00, -2.328602665156243e-03, -2.317230068778084e-06,  7.248598682327187e-09,  2.265071125593051e-11,
 -2.769123151405421e-14, -2.256536667654351e-16, -2.984803177645327e-20,  2.154539812485308e-21,  3.109928034132386e-24, -1.857512503562237e-26, -5.847780441632812e-29,
  1.340128622176101e+00, -2.241483436186670e-03, -2.758677295193054e-06,  5.663308851983630e-09,  2.519820264263640e-11, -4.990884784499078e-15, -2.206046843650325e-16,
 -3.035772719857293e-19,  1.649736950904898e-21,  5.788857440256732e-24, -7.702095035417404e-27, -7.557036025415857e-29,  1.399398810906673e+00, -2.137447452759099e-03,
 -3.128853142122084e-06,  3.882173814343243e-09,  2.599711871111469e-11,  1.751106924035721e-14, -1.863807346361739e-16, -5.147864128929615e-19,  8.003634223651741e-22,
  6.786421536802838e-24,  5.225640514006237e-27, -6.253213702486895e-29,  1.457229560918915e+00, -2.017992923422919e-03, -3.416976196932505e-06,  1.998429298396581e-09,
  2.500520047880728e-11,  3.731247855557523e-14, -1.286573658063371e-16, -6.241794884178613e-19, -1.794029544195696e-22,  5.859885037098426e-24,  1.557686609548844e-26,
 -2.592602224901068e-29,  1.513363044793211e+00, -1.884926909918301e-03, -3.615027473529525e-06,  1.124893248327041e-10,  2.233961379791880e-11,  5.224356151209038e-14,
 -5.696223352861200e-17, -6.142408629659857e-19, -1.044220598950071e-21,  3.381051856502141e-24,  1.980185583227166e-26,  1.745656736545159e-29,  1.567544258911140e+00,
 -1.740343940573626e-03, -3.718179811506391e-06, -1.674489246506380e-09,  1.826959577715088e-11,  6.076898956422563e-14,  1.697967618921369e-17, -4.933837324778242e-19,
 -1.586439490355425e-21,  2.071959430258011e-25,  1.684517264971075e-26,  4.863849071871077e-29,  1.619522552381665e+00, -1.586597344207004e-03, -3.725115352329564e-06,
 -3.267447340559503e-09,  1.319249968527175e-11,  6.220872428047494e-14,  8.137897207751478e-17, -2.938806378838311e-19, -1.694881653271528e-21, -2.624238531055365e-24,
  8.501350173126770e-27,  5.554032706212894e-29,  1.669053219242847e+00, -1.426263412310403e-03, -3.638207371962661e-06, -4.584170083006798e-09,  7.594836893714432e-12,
  5.683781042933596e-14,  1.265786879396283e-16, -6.383741957562861e-20, -1.384478168637190e-21, -4.265429773691135e-24, -1.465199302642422e-27,  3.838537423775307e-29,
  1.715899139098140e+00, -1.262098728808633e-03, -3.463547499176525e-06, -5.561399702558610e-09,  2.001896918593205e-12,  4.584235816142822e-14,  1.468561752162917e-16,
  1.448710630413768e-19, -7.864621099258461e-22, -4.349777798913262e-24, -9.036784005271852e-27,  8.603914907426861e-30,  1.759832448796888e+00, -1.096991255215839e-03,
 -3.210805820267201e-06, -6.159780314838048e-09, -3.078741290879353e-12,  3.113180478125287e-14,  1.414287716841822e-16,  2.895453874725991e-19, -1.018925206060770e-22,
 -3.090141458640174e-24, -1.168644183095201e-26, -1.799508343622186e-29,  1.800636225393845e+00, -9.339060149872210e-04, -2.892919360650908e-06, -6.367154964854355e-09,
 -7.213289569679137e-12,  1.503261464599957e-14,  1.144193502862679e-16,  3.469295565123767e-19,  4.658049595553904e-22, -1.147122633652289e-24, -9.323446021836051e-27,
 -2.978663371599352e-29,  1.838106158532795e+00, -7.758264727046871e-04, -2.525613581956690e-06, -6.199841463881268e-09, -1.009046751694667e-11, -8.872764454500788e-17,
  7.376655743461712e-17,  3.178941885632983e-19,  7.757687656149505e-22,  6.714846375768716e-25, -4.021774078262930e-27, -2.474190675135691e-29,  1.872052188713399e+00,
 -6.256929383179595e-04, -2.126771329363948e-06, -5.701666086052705e-09, -1.155638399020207e-11, -1.220996416195445e-14,  2.931364951674964e-17,  2.252079303658630e-19,
  7.892534072376300e-22,  1.746002780559731e-24,  1.256482465821818e-27, -9.873680155189161e-30,  1.902300086752951e+00, -4.863395299521164e-04, -1.715673470357742e-06,
 -4.940722256416558e-09, -1.163054208758733e-11, -1.997638871148789e-14, -9.483040798378666e-18,  1.051473874154859e-19,  5.703877183938006e-22,  1.868061428893564e-24,
  4.216353367893406e-27,  4.349556860497483e-30,  1.928692949334124e+00, -3.604313864966249e-04, -1.312144558672616e-06, -4.004028576600067e-09, -1.050018729540430e-11,
 -2.290327970896115e-14, -3.567757004347176e-17, -4.378434139265623e-21,  2.496273452670806e-22,  1.260475096156287e-24,  4.228762623546379e-27,  1.067074886435625e-29,
  1.951092586255307e+00, -2.504039188211360e-04, -9.356444796150174e-07, -2.990466289368963e-09, -8.493041809412817e-12, -2.141797309492381e-14, -4.626967983919183e-17,
 -7.539119523646914e-20, -3.407385303882620e-23,  4.014232118459859e-25,  2.298861464072103e-27,  8.532283293005351e-30,  1.969380778418758e+00, -1.584059076553296e-04,
 -6.043524476501604e-07, -2.002557849154948e-09, -6.031467475529481e-12, -1.673162401591926e-14, -4.259736271015708e-17, -9.740072124884506e-20, -1.882280721681875e-22,
 -2.458945526454770e-25,  1.477789172121220e-28,  2.646182716914966e-30,  1.983460400119622e+00, -8.624814545120984e-05, -3.342921703905160e-07, -1.137783123015320e-09,
 -3.573822252632165e-12, -1.056367675885345e-14, -2.959784166139855e-17, -7.861524824120408e-20, -1.966752345085674e-22, -4.560921958374368e-25, -9.455535710397935e-28,
 -1.586794985190714e-30,  1.993256493830718e+00, -3.535871237620099e-05, -1.385446281321079e-07, -4.801946470309870e-10, -1.550761345833051e-12, -4.771690431179554e-15,
 -1.414575730664472e-17, -4.063656191305715e-20, -1.134322424284630e-22, -3.078734223425827e-25, -8.115857882782345e-28, -2.071459163155700e-30,  1.998718701950369e+00,
 -6.738864292147924e-06, -2.656384947661332e-08, -9.299318882479030e-11, -3.048548600921157e-13, -9.581157170289061e-16, -2.922934080405968e-18, -8.719108201042588e-21,
 -2.554963794114697e-23, -7.377148074395220e-26, -2.103264362411601e-28, -5.929661491977544e-31,  4.310046921167914e-04, -2.013662752812450e-06,  7.054457370611954e-09,
 -2.196219674568906e-11,  6.407845385509257e-14, -1.794103014766563e-16,  4.881373361578206e-19, -1.300318518700440e-21,  3.407622256771415e-24, -8.813834437093774e-27,
  2.255197658922042e-29, -5.717958180225776e-32,  3.877353737500068e-03, -1.808763953652324e-05,  6.316993641767345e-08, -1.956343088207305e-10,  5.662769649049092e-13,
 -1.567765930593022e-15,  4.201362339298742e-18, -1.097272026094781e-20,  2.804181464288316e-23, -7.029255951137247e-26,  1.730532764141732e-28, -4.186213721441903e-31,
  1.076104382228588e-02, -5.004748191018972e-05,  1.737011858789532e-07, -5.322775602727903e-10,  1.515950440968874e-12, -4.100515252409464e-15,  1.064228185647563e-17,
 -2.662420733583067e-20,  6.427295541254513e-23, -1.494491375244615e-25,  3.329766501263440e-28, -7.036140705838144e-31,  2.106404595006505e-02, -9.751836180742575e-05,
  3.352866974574731e-07, -1.010973649179723e-09,  2.807906325945367e-12, -7.319391850289756e-15,  1.801552386566782e-17, -4.178957847898274e-20,  9.041873750345746e-23,
 -1.780524565497898e-25,  3.002113298616616e-28, -3.492013484315315e-31,  3.475928444279992e-02, -1.599415317170170e-04,  5.429785422955956e-07, -1.601538220698308e-09,
  4.294729911547920e-12, -1.060821605690209e-14,  2.404175938678996e-17, -4.888822594874268e-20,  8.374520831338325e-23, -9.534891967425128e-26, -6.416874163199493e-29,
  8.817274483063531e-31,  5.181059910216974e-02, -2.365785424551349e-04,  7.903543323891932e-07, -2.265907954538583e-09,  5.798510257431461e-12, -1.327040025306533e-14,
  2.638586694184810e-17, -4.127486235442371e-20,  2.915582083026501e-23,  1.190916089248889e-25, -7.254915403193319e-28,  2.577465078444752e-30,  7.217269607211220e-02,
 -3.265169062969255e-04,  1.069664407620953e-06, -2.959916246229593e-09,  7.125303136904673e-12, -1.461969669120311e-14,  2.312289615208248e-17, -1.524868546664996e-20,
 -7.354649369617869e-23,  4.243656664751208e-25, -1.436029325464194e-27,  3.708090529114035e-30,  9.579108855202730e-02, -4.286772372270787e-04,  1.372012394146042e-06,
 -3.635395531404343e-09,  8.081393394230017e-12, -1.407470270205336e-14,  1.316887364973897e-17,  2.843161594868536e-20, -2.061457729669294e-22,  7.188667187547371e-25,
 -1.798737923625421e-27,  3.072247208097925e-30,  1.226020288258914e-01, -5.418219054001289e-04,  1.687566746136968e-06, -4.242530523618031e-09,  8.490267318946923e-12,
 -1.124682283137108e-14, -3.395457092835475e-18,  8.391109072459030e-20, -3.337600731640432e-22,  8.658606802395364e-25, -1.425050357599348e-27,  3.137158101335059e-33,
  1.525324334064818e-01, -6.645652464085575e-04,  2.005800307513764e-06, -4.732374161476743e-09,  8.209107664508958e-12, -6.011484695708586e-15, -2.516885291988251e-17,
  1.407166861206773e-19, -4.120896018073705e-22,  7.389731893282121e-25, -1.341871003351649e-28, -4.999642830397589e-30,  1.854998034488310e-01, -7.953853671959499e-04,
  2.315754310312084e-06, -5.059427304632246e-09,  7.143588802362488e-12,  1.446527972862493e-15, -4.948232585222200e-17,  1.853809040990702e-19, -3.989361288419502e-22,
  2.747853636113917e-25,  1.887074145766412e-27, -1.008582097996091e-29,  2.214121429651723e-01, -9.326375889427181e-04,  2.606322562102627e-06, -5.184174663938733e-09,
  5.259784773071316e-12,  1.062073686659953e-14, -7.267325535051253e-17,  2.040085860382362e-19, -2.674311445709308e-22, -4.849497541945567e-25,  4.045285828327869e-27,
 -1.255013427616964e-29,  2.601678777765687e-01, -1.074569562476363e-03,  2.866550870741797e-06, -5.075463648658708e-09,  2.592114113489621e-12,  2.070784291415092e-14,
 -9.056141185339054e-17,  1.853648236354258e-19, -1.755954039509000e-23, -1.378627383962026e-24,  5.469680873666220e-27, -9.950182338239656e-30,  3.016557785648065e-01,
 -1.219338083167943e-03,  3.085946019961583e-06, -4.712610369061129e-09, -7.535651623239824e-13,  3.067043884034218e-14, -9.907454001447891e-17,  1.238983694561037e-19,
  3.175257432731444e-22, -2.148761757892461e-24,  5.298062696490290e-27, -1.457064649908978e-30,  3.457548918415683e-01, -1.365027619298890e-03,  3.254787858914207e-06,
 -4.087118588178984e-09, -4.602330427062394e-12,  3.933415559885879e-14, -9.494206935286278e-17,  2.204582657889248e-20,  6.730975017187162e-22, -2.504903270539902e-24,
  3.039538041249302e-27,  1.117334769615783e-29,  3.923344831285868e-01, -1.509670549935956e-03,  3.364437324419974e-06, -3.203903618464377e-09, -8.718321379233172e-12,
  4.551170275480828e-14, -7.635487265883212e-17, -1.087857227979055e-19,  9.634124630197081e-22, -2.212791064287506e-24, -1.116253641604156e-27,  2.360133538427795e-29,
  4.412539971390150e-01, -1.651269084867147e-03,  3.407632505384677e-06, -2.081924613803174e-09, -1.281850397538071e-11,  4.814242607807271e-14, -4.348095861450191e-17,
 -2.489776387358332e-19,  1.100083312719408e-21, -1.185601502224626e-24, -6.183399775806007e-27,  3.015682948989012e-29,  4.923630402612444e-01, -1.787818809599428e-03,
  3.378764221740334e-06, -7.541459214575344e-10, -1.659151737838659e-11,  4.643291012775255e-14,  1.265334320456887e-18, -3.733228831122395e-19,  1.014811640365431e-21,
  4.526686358740730e-25, -1.055289394610783e-26,  2.609520744929850e-29,  5.455013911642029e-01, -1.917333762350382e-03,  3.274122070738030e-06,  7.332285346919837e-10,
 -1.972059421449752e-11,  3.998224800101929e-14,  5.327832125938480e-17, -4.552642749925137e-19,  6.812140325672172e-22,  2.358778228035862e-24, -1.245655773786993e-26,
  1.005421462328525e-29,  6.004990458574661e-01, -2.037872907059045e-03,  3.092101545090570e-06,  2.322274395712139e-09, -2.190910332912595e-11,  2.887529159881586e-14,
  1.061769441314665e-16, -4.721156092901615e-19,  1.297218560132816e-22,  4.031383715675594e-24, -1.060680312189122e-26, -1.440037121221919e-29,  6.571763040370269e-01,
 -2.147567816560002e-03,  2.833362711335052e-06,  3.945610735994592e-09, -2.290687515793234e-11,  1.372879247672443e-14,  1.525652355271524e-16, -4.103174193130714e-19,
 -5.497369089597468e-22,  4.936281710741170e-24, -4.799158805445013e-27, -3.910990396154879e-29,  7.153439040117224e-01, -2.244651323328710e-03,  2.500931119649936e-06,
  5.529359366742535e-09, -2.253517444123617e-11, -4.321005670649205e-15,  1.850614370055417e-16, -2.696108090338219e-19, -1.220250338628745e-21,  4.667690026631193e-24,
  3.770512391247439e-27, -5.385948555868999e-29,  7.748032139159657e-01, -2.327486832066804e-03,  2.100232168110261e-06,  6.996705944574940e-09, -2.070802645769878e-11,
 -2.369512821953835e-14,  1.974633562993326e-16, -6.505785285529775e-20, -1.725009677063517e-21,  3.099513743100054e-24,  1.266399972776999e-26, -5.046354517496935e-29,
  8.353464872477618e-01, -2.394597919722975e-03,  1.639051134078948e-06,  8.271922997218268e-09, -1.744762196222302e-11, -4.251151468395391e-14,  1.858739447895959e-16,
  1.738716994511572e-19, -1.924209651605313e-21,  4.744279784756314e-25,  1.887367596628111e-26, -2.684378403997692e-29,  8.967571909994358e-01, -2.444697775711234e-03,
  1.127412576076096e-06,  9.284669396889634e-09, -1.289175584579172e-11, -5.877779765104713e-14,  1.495906426885283e-16,  4.074064649229830e-19, -1.733381094958523e-21,
 -2.610759076841225e-24,  1.984851063628194e-26,  1.082475131422158e-29,  9.588104147410056e-01, -2.476717960054631e-03,  5.773748511447446e-07,  9.974339162550253e-09,
 -7.291715087675453e-12, -7.061910219387354e-14,  9.157304143977847e-17,  5.923539809985181e-19, -1.152842180002517e-21, -5.337555365734387e-24,  1.453148336886327e-26,
  4.933090519135421e-29,  1.021273368938540e+00, -2.489835882567896e-03,  2.738114580044036e-09,  1.029419858050132e-08, -9.997230952739158e-13, -7.651545408840042e-14,
  1.835009347013053e-17,  6.906327586377842e-19, -2.786456664247601e-22, -6.891947109201324e-24,  3.991439902268711e-27,  7.311620478970671e-29,  1.083905980505722e+00,
 -2.483500335322961e-03, -5.813326300871899e-07,  1.021502871112999e-08,  5.554055236905548e-12, -7.551841223717608e-14, -6.069123964747389e-17,  6.777659046441034e-19,
  7.109291141649097e-22, -6.722802275784547e-24, -8.680622124992834e-27,  7.086097177183629e-29,  1.146461593058586e+00, -2.457454347561842e-03, -1.158764123597805e-06,
  9.727984701957781e-09,  1.189389564261123e-11, -6.741509409259271e-14, -1.345882492817842e-16,  5.493863456173695e-19,  1.593131946780801e-21, -4.748589312595028e-24,
 -1.929253874730433e-26,  4.113765526966272e-29,  1.208687778533928e+00, -2.411754581657719e-03, -1.713101591070729e-06,  8.846397937525169e-09,  1.753812009336776e-11,
 -5.281076813472036e-14, -1.924932451529376e-16,  3.239791915499010e-19,  2.155297350592979e-21, -1.432699554807339e-24, -2.403639164930801e-26, -5.767407792362011e-30,
  1.270327265706553e+00, -2.346786455979501e-03, -2.228091646119677e-06,  7.606285070284366e-09,  2.204270273424752e-11, -3.310905943991314e-14, -2.255083978569052e-16,
  4.074024196267158e-20,  2.252520546028556e-21,  2.317415071807259e-24, -2.099851633515925e-26, -5.133870046409995e-29,  1.331118989669841e+00, -2.263274171281212e-03,
 -2.688302794966655e-06,  6.065391103905440e-09,  2.504478294859935e-11, -1.038124345074426e-14, -2.283348982765151e-16, -2.475173021157439e-19,  1.851784508385875e-21,
  5.413811263243842e-24, -1.105793604767971e-26, -7.662695934314068e-29,  1.390799264506540e+00, -2.162284837322999e-03, -3.079760576179168e-06,  4.300681598527462e-09,
  2.630145710397563e-11,  1.286808453821907e-14, -2.003992075826390e-16, -4.852309987994006e-19,  1.047750555236348e-21,  6.937860735476909e-24,  2.284739557556773e-27,
 -7.098072336321800e-29,  1.449103079162062e+00, -2.045225951382084e-03, -3.390570479577368e-06,  2.404308782099468e-09,  2.571915413299026e-11,  3.401452791067402e-14,
 -1.461822068568733e-16, -6.264272659406418e-19,  4.246302826415977e-23,  6.456808609913831e-24,  1.418575789114417e-26, -3.739309728111111e-29,  1.505765513945615e+00,
 -1.913835574945665e-03, -3.611498774702723e-06,  4.782019226772515e-10,  2.336940197671457e-11,  5.066642504304406e-14, -7.460939239156555e-17, -6.455542106747449e-19,
 -9.080828030244229e-22,  4.185991976614031e-24,  2.038047212102823e-26,  8.577016557657760e-30,  1.560523272148137e+00, -1.770164692730481e-03, -3.736479635096657e-06,
 -1.372435334329750e-09,  1.948790209554628e-11,  6.100499993808064e-14,  2.456279375837231e-18, -5.438962537614843e-19, -1.566341339801925e-21,  9.232111619265784e-25,
  1.893788588095689e-26,  4.620457926068843e-29,  1.613116318024639e+00, -1.616551420905711e-03, -3.763016846855936e-06, -3.046310740630524e-09,  1.445550656744893e-11,
  6.405686219754053e-14,  7.237730084610404e-17, -3.495579228544985e-19, -1.782632383599334e-21, -2.234009456557416e-24,  1.104080570748213e-26,  5.975102068840286e-29,
  1.663289608910395e+00, -1.455586958191996e-03, -3.692450262875017e-06, -4.453394284050826e-09,  8.761800727717880e-12,  5.984910108843469e-14,  1.241478486072599e-16,
 -1.106054835399477e-19, -1.538661325341973e-21, -4.288032978403096e-24,  3.907211156286489e-28,  4.602768028776851e-29,  1.710794905618714e+00, -1.290073440540623e-03,
 -3.530061233585046e-06, -5.521841747971701e-09,  2.954302811024704e-12,  4.941259203194121e-14,  1.505361964042034e-16,  1.171298905339111e-19, -9.494524615388483e-22,
 -4.701807186955426e-24, -8.516525335715013e-27,  1.521668564633191e-29,  1.755392641621274e+00, -1.122974160118538e-03, -3.284997591310134e-06, -6.203871915113840e-09,
 -2.421507953339444e-12,  3.462290805485165e-14,  1.494730188360963e-16,  2.844131761604104e-19, -2.217366755751171e-22, -3.572762710199568e-24, -1.242623963541939e-26,
 -1.546885143851384e-29,  1.796853827981812e+00, -9.573569314900506e-04, -2.970007282098686e-06, -6.480009844234748e-09, -6.884381262994630e-12,  1.789689093927558e-14,
  1.243353220910514e-16,  3.610999993164660e-19,  4.174748596537727e-22, -1.546811004066197e-24, -1.067364576641835e-26, -3.152434031551667e-29,  1.834961967762602e+00,
 -7.963317178524565e-04, -2.600980102984042e-06, -6.361203871888831e-09, -1.007380252389887e-11,  1.791308533397551e-15,  8.301853918476588e-17,  3.430723215608467e-19,
  7.967742353047407e-22,  4.877456572316814e-25, -5.192756113484201e-27, -2.852814172421333e-29,  1.869514950830440e+00, -6.429839505613919e-04, -2.196308664031789e-06,
 -5.888481403090685e-09, -1.179302222875215e-11, -1.142785436478105e-14,  3.598257044277202e-17,  2.514785356680615e-19,  8.529015817618264e-22,  1.786699347100975e-24,
  7.558132517868755e-28, -1.296823497053877e-29,  1.900326897856470e+00, -5.003052663300622e-04, -1.776091891121882e-06, -5.130018478979431e-09, -1.203209638997292e-11,
 -2.016652633454394e-14, -6.273036139927861e-18,  1.245087076632009e-19,  6.407175619892032e-22,  2.040289821265534e-24,  4.388204647913850e-27,  3.406353856045950e-30,
  1.927229921090676e+00, -3.711236275040116e-04, -1.361216186512442e-06, -4.175742646525639e-09, -1.096682058939832e-11, -2.376006677276226e-14, -3.568127331350267e-17,
  4.369253982764654e-21,  2.981645916323126e-22,  1.439266174144195e-24,  4.716954230424540e-27,  1.151647380840279e-29,  1.950075769688163e+00, -2.580349600982056e-04,
 -9.723597403725449e-07, -3.129842889440770e-09, -8.932677559441812e-12, -2.255388605768898e-14, -4.839359500060584e-17, -7.623183550976702e-20, -1.787364384411003e-23,
  5.012525258988656e-25,  2.701947454536305e-27,  9.815317165685626e-30,  1.968737330604504e+00, -1.633385163700507e-04, -6.289733880840745e-07, -2.101794875171478e-09,
 -6.376547779882497e-12, -1.778737612881838e-14, -4.541023035592882e-17, -1.035642751871333e-19, -1.969441258919684e-22, -2.374675426407262e-25,  2.784214450134519e-28,
  3.312396842423124e-30,  1.983109970997735e+00, -8.897808479520134e-05, -3.482957539270666e-07, -1.196693824333330e-09, -3.792381309999334e-12, -1.130116629561613e-14,
 -3.188970032758577e-17, -8.517900213470934e-20, -2.137923362527546e-22, -4.953278338408594e-25, -1.016624594617131e-27, -1.641108106863730e-30,  1.993112805167162e+00,
 -3.649054792616479e-05, -1.444590471281365e-07, -5.057891394737386e-10, -1.649684464042845e-12, -5.125263131931236e-15, -1.533611061958682e-17, -4.445017687919995e-20,
 -1.251226645915129e-22, -3.422339173931155e-25, -9.083306606816420e-28, -2.331250078969022e-30,  1.998691314285111e+00, -6.955923163064314e-06, -2.770967874279891e-08,
 -9.802806130710372e-11, -3.247389416498800e-13, -1.031290656081282e-15, -3.178926478064703e-18, -9.580865176402284e-21, -2.836335342299343e-23, -8.273060635912785e-26,
 -2.382519366620606e-28, -6.784095013420647e-31,  4.230612675482423e-04, -1.958264118580628e-06,  6.796946159028610e-09, -2.096502276219805e-11,  6.060451412363914e-14,
 -1.681198775475784e-16,  4.532085452775297e-19, -1.196182076029336e-21,  3.105973329150025e-24, -7.960106301132725e-27,  2.018158310053902e-29, -5.070365748506031e-32,
  3.805999244481953e-03, -1.759151881259238e-05,  6.087567004040064e-08, -1.868193440201477e-10,  5.359056014192679e-13, -1.470520960580204e-15,  3.906317801858529e-18,
 -1.011456993984555e-20,  2.563156664658689e-23, -6.372518208472319e-26,  1.556430720266982e-28, -3.736478154298158e-31,  1.056359323454420e-02, -4.868301555139461e-05,
  1.674567243283244e-07, -5.086648074660202e-10,  1.436435080231289e-12, -3.853818691362107e-15,  9.924807498329692e-18, -2.465104429155561e-20,  5.912524303937055e-23,
 -1.367301688002551e-25,  3.034335116556024e-28, -6.402120288299886e-31,  2.067926131975518e-02, -9.488384218720553e-05,  3.234198169005247e-07, -9.671951504470709e-10,
  2.665749100814904e-12, -6.900739462350366e-15,  1.688497599175560e-17, -3.899644962961410e-20,  8.422128157092119e-23, -1.663530442283788e-25,  2.847277639985758e-28,
 -3.535546106522057e-31,  3.412808588387501e-02, -1.556734249698051e-04,  5.241654765898642e-07, -1.534488966236966e-09,  4.088226285679022e-12, -1.004734064043991e-14,
  2.270988777781711e-17, -4.626372281006547e-20,  8.027533362852820e-23, -9.719008301893123e-26, -2.908498740441625e-29,  7.175107015146581e-31,  5.087676059297615e-02,
 -2.303629141324594e-04,  7.637114458402098e-07, -2.175221038280797e-09,  5.539341810010961e-12, -1.265089860616040e-14,  2.524383845173379e-17, -4.027866426801907e-20,
  3.294719004473769e-23,  9.224115370546391e-26, -6.194086858496492e-28,  2.250976615637453e-30,  7.088352083087612e-02, -3.180997509601050e-04,  1.034819890030858e-06,
 -2.848220545028305e-09,  6.838422798184993e-12, -1.407012295845721e-14,  2.266520357637935e-17, -1.736851170802543e-20, -5.926486951426881e-23,  3.700869298603749e-25,
 -1.280363351518697e-27,  3.370930535806166e-30,  9.409805858655640e-02, -4.178734602011056e-04,  1.329154228564513e-06, -3.508327759758373e-09,  7.803120600002950e-12,
 -1.374981871217135e-14,  1.387639862051793e-17,  2.223539554742472e-20, -1.815292472711917e-22,  6.496023205557560e-25, -1.665008464270655e-27,  3.000141580288785e-30,
  1.204614230776018e-01, -5.285227206635140e-04,  1.637464010401914e-06, -4.108489388358464e-09,  8.264700146452196e-12, -1.130129814270879e-14, -1.190863417986082e-18,
  7.371851163007637e-20, -3.036137908055794e-22,  8.090026943172402e-25, -1.414554532549103e-27,  4.557437081247792e-31,  1.499059087053213e-01, -6.487437743750578e-04,
  1.949795821615174e-06, -4.602021783451813e-09,  8.083148994349970e-12, -6.569721941385609e-15, -2.140941231194658e-17,  1.279540200983997e-19, -3.856333364118691e-22,
  7.295181773453509e-25, -3.311056571251158e-28, -3.975477806397717e-30,  1.823549322780565e-01, -7.771002403797562e-04,  2.255727717636558e-06, -4.944961225276676e-09,
  7.161056632803824e-12,  3.198072233890493e-16, -4.446879783353321e-17,  1.727869477383992e-19, -3.877885899958363e-22,  3.417783154879706e-25,  1.471941273713058e-27,
 -8.799739473966159e-30,  2.177229018133980e-01, -9.120344026309048e-04,  2.544624113452439e-06, -5.098411631028011e-09,  5.455215558366517e-12,  8.944143550782965e-15,
 -6.708323216907749e-17,  1.952016234578832e-19, -2.821074311657708e-22, -3.339201317210498e-25,  3.512793805041422e-27, -1.164472619853410e-29,  2.559150796412723e-01,
 -1.051880041993086e-03,  2.805907439375415e-06, -5.030792897099541e-09,  2.984956123023132e-12,  1.859654374482424e-14, -8.538622853184248e-17,  1.840501933543907e-19,
 -6.335823611998901e-23, -1.168676913473976e-24,  5.026323018148165e-27, -1.015967164997063e-29,  2.968274429811105e-01, -1.194876879490045e-03,  3.029342180546646e-06,
 -4.719888135375650e-09, -1.636476376944074e-13,  2.833535788739298e-14, -9.547447252032670e-17,  1.328622488895925e-19,  2.439644545434764e-22, -1.938667030428448e-24,
  5.193899409757888e-27, -3.211609631251939e-30,  3.403465456596217e-01, -1.339186690968901e-03,  3.205326172319012e-06, -4.154585961967971e-09, -3.838371183402202e-12,
  3.706530479129703e-14, -9.403662247353960e-17,  4.216649339028005e-20,  5.852194720575524e-22, -2.374413460631427e-24,  3.462722102904967e-27,  8.121266561907696e-30,
  3.863493851719079e-01, -1.482911141571678e-03,  3.325183234665912e-06, -3.336215428754888e-09, -7.826641528654230e-12,  4.364604364243986e-14, -7.898128970040652e-17,
 -7.923773636851349e-20,  8.831896591577323e-22, -2.237647645131520e-24, -1.505932370774151e-28,  2.030490329464006e-29,  4.347032798670558e-01, -1.624111371041975e-03,
  3.381450417669785e-06, -2.279376887628225e-09, -1.186663518017944e-11,  4.701916340512461e-14, -4.996623711028723e-17, -2.145030519376689e-19,  1.053264445062046e-21,
 -1.406948482529902e-24, -4.898218801054701e-27,  2.819956089035321e-29,  4.852657616572056e-01, -1.760829337151095e-03,  3.368152326528391e-06, -1.012182771744903e-09,
 -1.566338317362425e-11,  4.634152342246879e-14, -8.731188676744211e-18, -3.406673767669052e-19,  1.023789196084551e-21,  5.381901367370855e-26, -9.383514878141932e-27,
  2.693060437411865e-29,  5.378844903012607e-01, -1.891110893613382e-03,  3.281054237707526e-06,  4.241613730435351e-10, -1.890918194571509e-11,  4.111049723195643e-14,
  4.084819094233718e-17, -4.322019908982525e-19,  7.572797510464187e-22,  1.870648011349021e-24, -1.191976335446453e-26,  1.419946518229920e-29,  5.923971959926818e-01,
 -2.013030540035732e-03,  3.117885057846721e-06,  1.976482759424064e-09, -2.130718280621841e-11,  3.126550763134804e-14,  9.303704991156712e-17, -4.657254395908408e-19,
  2.670798503021404e-22,  3.596384664594873e-24, -1.109595649896907e-26, -7.922711884801409e-30,  6.486316576734610e-01, -2.124717734083271e-03,  2.878520674835707e-06,
  3.581492345434766e-09, -2.259662383356255e-11,  1.725066642240502e-14,  1.408564977143601e-16, -4.251060060719735e-19, -3.758838963423297e-22,  4.711767695670765e-24,
 -6.379877337850089e-27, -3.270638656390261e-29,  7.064057251874266e-01, -2.224384599702501e-03,  2.565117977940396e-06,  5.168343890807550e-09, -2.257781342882547e-11,
  2.562335333767259e-17,  1.769911046766035e-16, -3.059457049308242e-19, -1.050061778442526e-21,  4.772016476972894e-24,  1.470059496624300e-27, -5.053345034248598e-29,
  7.655273940547759e-01, -2.310354799766991e-03,  2.182189862246328e-06,  6.661843062734111e-09, -2.113471715487290e-11, -1.898399825268219e-14,  1.948863783056258e-16,
 -1.183794634974113e-19, -1.604850763557934e-21,  3.560968770393074e-24,  1.039426986419802e-26, -5.245302478034103e-29,  8.257949422700761e-01, -2.381093267134719e-03,
  1.736611970090993e-06,  7.986203113427247e-09, -1.825288404201987e-11, -3.799905612921905e-14,  1.898838987943635e-16,  1.127135164428030e-19, -1.893846913802889e-21,
  1.203457182649609e-24,  1.752330843949085e-26, -3.432093399297063e-29,  8.869971390660768e-01, -2.435236405585291e-03,  1.237552849125678e-06,  9.069195686615332e-09,
 -1.403051878863924e-11, -5.505708290668843e-14,  1.602084364832515e-16,  3.505884472054162e-19, -1.812991220178665e-21, -1.810420079452928e-24,  2.009161686614757e-26,
  2.822208100019147e-31,  9.489135360076535e-01, -2.471622282849719e-03,  6.963207098668959e-07,  9.846497638019453e-09, -8.680798425583827e-12, -6.822666037444406e-14,
  1.076144163895277e-16,  5.525048699232360e-19, -1.334032536008492e-21, -4.715549954978905e-24,  1.650104847096634e-26,  4.003573733423539e-29,  1.011314851040199e+00,
 -2.489320244159543e-03,  1.261221193547279e-07,  1.026599102061704e-08, -2.524067975171013e-12, -7.584423481815460e-14,  3.752593411259986e-17,  6.777833890041231e-19,
 -5.231148841775772e-22, -6.668884821884410e-24,  7.134944710149675e-27,  6.944853151710647e-29,  1.073963456165341e+00, -2.487659279552451e-03, -4.582691770276713e-07,
  1.029173800328142e-08,  4.030670596363219e-12, -7.674492779567742e-14, -4.143212391274272e-17,  6.965824723800639e-19,  4.634225134109736e-22, -7.006278911617883e-24,
 -5.462411598584909e-27,  7.508705262756557e-29,  1.136613979199950e+00, -2.466254385730110e-03, -1.040931541119871e-06,  9.907330445834025e-09,  1.051456767222176e-11,
 -7.045502068876593e-14, -1.185184482430506e-16,  5.974861795234108e-19,  1.408758213147014e-21, -5.480821320743155e-24, -1.723998695438611e-26,  5.198833839950127e-29,
  1.199014029534854e+00, -2.425030078803909e-03, -1.605296815726480e-06,  9.118310348747213e-09,  1.643648118841687e-11, -5.731400975452530e-14, -1.824653330841479e-16,
  3.919376386251004e-19,  2.086386953032697e-21, -2.395471661389806e-24, -2.400813232435081e-26,  7.143438128146733e-30,  1.260905056889606e+00, -2.364240144083695e-03,
 -2.134722928925944e-06,  7.953377336887682e-09,  2.132653432960117e-11, -3.849935596881063e-14, -2.233471806441838e-16,  1.139893532774608e-19,  2.320307100075436e-21,
  1.434843087332965e-24, -2.306359538023415e-26, -4.221280114097555e-29,  1.322023350703663e+00, -2.284482660412140e-03, -2.613121624807457e-06,  6.464146649803561e-09,
  2.478183169345649e-11, -1.593757390036547e-14, -2.344071305261419e-16, -1.852337979539678e-19,  2.037908651966830e-21,  4.904226005028408e-24, -1.441323137528306e-26,
 -7.551284065793128e-29,  1.382101185963211e+00, -2.186709317380311e-03, -3.025619823116597e-06,  4.723297936874355e-09,  2.650964304249990e-11,  7.899485864473213e-15,
 -2.134786458969979e-16, -4.476953795579416e-19,  1.298385353723776e-21,  6.964552385446404e-24, -1.003022154755223e-27, -7.823275976499239e-29,  1.440868118899052e+00,
 -2.072228062353197e-03, -3.359227919562525e-06,  2.821060993058566e-09,  2.636294194347696e-11,  3.029604754222125e-14, -1.636674414913831e-16, -6.212432385767369e-19,
  2.846938328427831e-22,  6.987866242942518e-24,  1.228094406598680e-26, -4.921958932667770e-29,  1.498052433083335e+00, -1.942698178623530e-03, -3.603483781280742e-06,
  8.601154887501556e-10,  2.436334374761409e-11,  4.865575466651122e-14, -9.306795164047915e-17, -6.720438290396037e-19, -7.426490238734083e-22,  5.005790827034784e-24,
  2.053325045116750e-26, -1.886037032216277e-30,  1.553382733003571e+00, -1.800117013275641e-03, -3.751037761224325e-06, -1.050870177169470e-09,  2.070732892253463e-11,
  6.087557364556293e-14, -1.346847516783528e-17, -5.933372937554189e-19, -1.518990364161181e-21,  1.720277644902551e-24,  2.088462292708968e-26,  4.197079967471777e-29,
  1.606589678231887e+00, -1.646797748735708e-03, -3.798142273236148e-06, -2.804682602282542e-09,  1.575318794856782e-11,  6.566994882083762e-14,  6.177960702194674e-17,
 -4.077985079816299e-19, -1.854464225594445e-21, -1.738766455743219e-24,  1.374482230941828e-26,  6.296944214338412e-29,  1.657407846901242e+00, -1.485337847994059e-03,
 -3.745009839728554e-06, -4.303468882326809e-09,  9.988298020847372e-12,  6.278577978452766e-14,  1.203384130858294e-16, -1.623054374515077e-19, -1.692240138984232e-21,
 -4.229593795333607e-24,  2.588550665963310e-27,  5.389300990029184e-29,  1.705577712451929e+00, -1.318578098855081e-03, -3.596006470421540e-06, -5.466469537786881e-09,
  3.978930573886919e-12,  5.306122445201294e-14,  1.533645719234607e-16,  8.397486184315100e-20, -1.124668350907158e-21, -5.026897951520992e-24, -7.682185469603132e-27,
  2.288159153444489e-29,  1.750847712666210e+00, -1.149552531444574e-03, -3.359653029201633e-06, -6.236878772629720e-09, -1.692535879364153e-12,  3.830489922824017e-14,
  1.573172225722279e-16,  2.751624861519141e-19, -3.594583217724442e-22, -4.082449612826894e-24, -1.303193671413270e-26, -1.187334457661586e-29,  1.792976385052201e+00,
 -9.814298744972487e-04, -3.048415954233514e-06, -6.587130844489534e-09, -6.495776419627271e-12,  2.100372339153301e-14,  1.346241761493756e-16,  3.734830923918901e-19,
  3.537664956838050e-22, -2.001914885773394e-24, -1.209092842046370e-26, -3.280946151655685e-29,  1.831734537894206e+00, -8.174476330939177e-04, -2.678280092505858e-06,
 -6.521986528654107e-09, -1.001725886225549e-11,  3.901921638563013e-15,  9.298385835343493e-17,  3.688074255818269e-19,  8.102811626560278e-22,  2.537612131138105e-25,
 -6.535795756229164e-27, -3.255407462814469e-29,  1.866907422013960e+00, -6.608402917364211e-04, -2.268109954719645e-06, -6.078948843852246e-09, -1.201235695392705e-11,
 -1.047663218142357e-14,  4.341577380496104e-17,  2.798051831249379e-19,  9.176201389676427e-22,  1.804491756853239e-24,  1.073670896937828e-28, -1.659924812053484e-29,
  1.898296864778689e+00, -5.147635457764544e-04, -1.838820527186775e-06, -5.325765617585123e-09, -1.243663779342614e-11, -2.027285835516461e-14, -2.488465686119597e-18,
  1.462210258245491e-19,  7.173604170486001e-22,  2.218457771304370e-24,  4.510613325949636e-27,  2.089807765514101e-30,  1.925723325505980e+00, -3.822168120356505e-04,
 -1.412393745247389e-06, -4.355059853401256e-09, -1.145056974089849e-11, -2.461382189730668e-14, -3.541730172292639e-17,  1.477695882926980e-20,  3.534987124531250e-22,
  1.638320985937276e-24,  5.241690340778250e-27,  1.232649682056733e-29,  1.949027830747998e+00, -2.659665348636796e-04, -1.010790484056144e-06, -3.276438184077788e-09,
 -9.395542897681835e-12, -2.374099342474116e-14, -5.053322728072235e-17, -7.649334239130586e-20,  2.224669705407106e-24,  6.183808652690425e-25,  3.164987397011016e-27,
  1.125962261549048e-29,  1.968073750743673e+00, -1.684729514762020e-04, -6.548190093790351e-07, -2.206725833615239e-09, -6.743432355228888e-12, -1.891273921875445e-14,
 -4.839952916347301e-17, -1.100008207567541e-19, -2.052553386438063e-22, -2.231907537899220e-25,  4.412430403815039e-28,  4.112557562733861e-30,  1.982748393498494e+00,
 -9.182294110992762e-05, -3.630277441462997e-07, -1.259222521096212e-09, -4.026255416270014e-12, -1.209592908197619e-14, -3.437322884502111e-17, -9.231365605738373e-20,
 -2.323736223497460e-22, -5.374489993889502e-25, -1.089691757846462e-27, -1.676421319606110e-30,  1.992964492546813e+00, -3.767095481852080e-05, -1.506903351399243e-07,
 -5.330245627417380e-10, -1.755973593761384e-12, -5.508729129622640e-15, -1.663867387683702e-17, -4.865844679806029e-20, -1.381225626442847e-22, -3.807024280667451e-25,
 -1.017231510641829e-27, -2.624678870313940e-30,  1.998663039660665e+00, -7.182395863895686e-06, -2.891788475023864e-08, -1.033931292895455e-10, -3.461499685049685e-13,
 -1.110909443326568e-15, -3.460358683062663e-18, -1.053804466543098e-20, -3.152064398537832e-23, -9.288572188271387e-26, -2.702231144720689e-28, -7.772014368615488e-31,
  4.153353918107242e-04, -1.904878637731502e-06,  6.551074843835857e-09, -2.002166992161272e-11,  5.734823062336263e-14, -1.576338177597141e-16,  4.210649291397525e-19,
 -1.101224408136253e-21,  2.833418419437604e-24, -7.195733213504458e-27,  1.807852806001784e-29, -4.501005979137542e-32,  3.736593184564025e-03, -1.711333721702746e-05,
  5.868433054720304e-08, -1.784751385626686e-10,  5.074102287969386e-13, -1.380077222668827e-15,  3.634256288652422e-18, -9.329895375080250e-21,  2.344567159456398e-23,
 -5.781618577120434e-26,  1.400970542592647e-28, -3.337785854723891e-31,  1.037150236537504e-02, -4.736739273205569e-05,  1.614881421763959e-07, -4.862857461128850e-10,
  1.361685837568124e-12, -3.623696731192438e-15,  9.260342770393047e-18, -2.283550463438913e-20,  5.441479950562185e-23, -1.251388047340651e-25,  2.765558246570609e-28,
 -5.823836098678576e-31,  2.030482817124188e-02, -9.234219428336296e-05,  3.120649028415925e-07, -9.256256309765167e-10,  2.531699812587518e-12, -6.508303757203760e-15,
  1.582992172872918e-17, -3.639502030966342e-20,  7.843382626158200e-23, -1.552750572169212e-25,  2.691806901376435e-28, -3.523253167963524e-31,  3.351366376044353e-02,
 -1.515526597116410e-04,  5.061375422092585e-07, -1.470655741724629e-09,  3.892626406255589e-12, -9.517560908507615e-15,  2.144993963996471e-17, -4.375105898728934e-20,
  7.676276727899632e-23, -9.776463621996389e-26, -6.530308257694905e-31,  5.787311622213556e-31,  4.996736510480280e-02, -2.243561454919979e-04,  7.381323261890084e-07,
 -2.088583176404084e-09,  5.292291635235627e-12, -1.205845807542704e-14,  2.413126240619430e-17, -3.917581668654734e-20,  3.584496381899806e-23,  6.935800129074258e-26,
 -5.268537659405238e-28,  1.961924521960201e-30,  6.962746507851347e-02, -3.099560675704217e-04,  1.001288541075077e-06, -2.741027613554757e-09,  6.562419539523549e-12,
 -1.353219623006701e-14,  2.215426867856719e-17, -1.906141744736146e-20, -4.682872123682896e-23,  3.217441210236995e-25, -1.139082304011269e-27,  3.054438865061071e-30,
  9.244756754949225e-02, -4.074065244374144e-04,  1.287794379309123e-06, -3.385659506184804e-09,  7.531501688929082e-12, -1.340994930695454e-14,  1.442109008605251e-17,
  1.678803322912677e-20, -1.593108145115160e-22,  5.856133414838323e-25, -1.535203236656817e-27,  2.895563754746697e-30,  1.183732225249091e-01, -5.156179852571571e-04,
  1.588948086939452e-06, -3.978063264214817e-09,  8.038550008804727e-12, -1.130618079096659e-14,  7.415366552726435e-19,  6.445798146124094e-20, -2.755023257008820e-22,
  7.529316474778744e-25, -1.386444391528920e-27,  8.065809937189819e-31,  1.473417836778536e-01, -6.333641163926266e-04,  1.895343119335994e-06, -4.473769279582168e-09,
  7.946899392185816e-12, -7.041925569127392e-15, -1.799553545671096e-17,  1.160310738609394e-19, -3.596487599196348e-22,  7.130453305205288e-25, -4.861035775714127e-28,
 -3.092004293410588e-30,  1.792822498929884e-01, -7.592898288526409e-04,  2.197075672040682e-06, -4.830389517455240e-09,  7.157164949260259e-12, -6.907779968899874e-16,
 -3.980256614594111e-17,  1.605852047042147e-19, -3.745148245678901e-22,  3.932688861980439e-25,  1.111231700397881e-27, -7.612913025474636e-30,  2.141150928214278e-01,
 -8.919206366270226e-04,  2.483972499381989e-06, -5.009782755827022e-09,  5.618435855237096e-12,  7.398703461265120e-15, -6.174559039656089e-17,  1.860079807456369e-19,
 -2.917203117567840e-22, -2.033793033191956e-25,  3.021136981055594e-27, -1.069927332755001e-29,  2.517520728346598e-01, -1.029673421077043e-03,  2.745836398222005e-06,
 -4.980167748222406e-09,  3.336810384888684e-12,  1.660884851241429e-14, -8.026726090697300e-17,  1.813874999393617e-19, -1.019194873537750e-22, -9.765726187544232e-25,
  4.579074378790241e-27, -1.013535138138106e-29,  2.920960462194730e-01, -1.170868698921102e-03,  2.972706114293399e-06, -4.718096059120838e-09,  3.804512689797265e-13,
  2.608943137640356e-14, -9.165524140035017e-17,  1.395922334297984e-19,  1.778740235675258e-22, -1.734168061678324e-24,  5.021040811416454e-27, -4.586406781253215e-30,
  3.350407669653135e-01, -1.313744490208757e-03,  3.155126724218555e-06, -4.210191637396435e-09, -3.119527638410307e-12,  3.482463193696019e-14, -9.260643826823445e-17,
  5.955323600721888e-20,  5.023123653041998e-22, -2.229576456944397e-24,  3.759519344071540e-27,  5.428944125581029e-30,  3.804706870661924e-01, -1.456471877212085e-03,
  3.284425762781041e-06, -3.454562015672109e-09, -6.972839687343696e-12,  4.172698799155917e-14, -8.081638594758924e-17, -5.226402429445801e-20,  8.027325824330152e-22,
 -2.226750890838440e-24,  6.722243067279682e-28,  1.711956745433414e-29,  4.282607598938203e-01, -1.597172334480040e-03,  3.352989514215374e-06, -2.461787114499512e-09,
 -1.093871082183062e-11,  4.575166119996490e-14, -5.550833022799114e-17, -1.816444177612350e-19,  9.993807369199126e-22, -1.578710502666212e-24, -3.706413278986362e-27,
  2.593158896057004e-29,  4.782762518979519e-01, -1.733936893402820e-03,  3.354532988306596e-06, -1.255396820797172e-09, -1.473940169314550e-11,  4.602121193518288e-14,
 -1.781142941209059e-17, -3.079452398390473e-19,  1.019256959154493e-21, -2.977403809337268e-25, -8.193635623056144e-27,  2.704483151793403e-29,  5.303725686525457e-01,
 -1.864847180449508e-03,  3.284356187066024e-06,  1.282413429776770e-10, -1.807813426514884e-11,  4.194843123592051e-14,  2.909527179612139e-17, -4.069822815506451e-19,
  8.162008672195842e-22,  1.407378216847534e-24, -1.121990734295828e-26,  1.747042587513520e-29,  5.843951020878182e-01, -1.987998335664383e-03,  3.139578377564607e-06,
  1.640687221229504e-09, -2.066059453927240e-11,  3.334299539493400e-14,  8.013523886765915e-17, -4.551936021316922e-19,  3.884928723821039e-22,  3.147352996149416e-24,
 -1.131275234720011e-26, -2.037387460715596e-30,  6.401791066202890e-01, -2.101523775939522e-03,  2.919341276398208e-06,  3.222886078125075e-09, -2.221877545214019e-11,
  2.048718245710047e-14,  1.288102667566494e-16, -4.344722655070496e-19, -2.111831600355033e-22,  4.429705633180468e-24, -7.675813658246391e-27, -2.619984906227970e-29,
  6.975496128024413e-01, -2.203621715013787e-03,  2.624971390944494e-06,  4.807330793203462e-09, -2.253553593031636e-11,  4.166974121033389e-15,  1.679800794812922e-16,
 -3.367919302847901e-19, -8.777358291096165e-22,  4.787544492984603e-24, -6.625560802302960e-28, -4.626660714712310e-29,  7.563213880418739e-01, -2.292583288255689e-03,
  2.260091336586231e-06,  6.320903050539613e-09, -2.146792235246815e-11, -1.435218260458751e-14,  1.908725980158652e-16, -1.676078575816440e-19, -1.469730706169955e-21,
  3.930329048655846e-24,  8.070116008759967e-27, -5.295301645059521e-29,  8.162989548612701e-01, -2.366822054554046e-03,  1.830669855913155e-06,  7.688325678764418e-09,
 -1.896707259960172e-11, -3.341077417398807e-14,  1.921988937510573e-16,  5.293581695995897e-20, -1.838287099483563e-21,  1.872286505244570e-24,  1.587367229948220e-26,
 -4.042736475610487e-29,  8.772766780518695e-01, -2.424904560013831e-03,  1.345000615441075e-06,  8.836110383472456e-09, -1.509244940396205e-11, -5.110089316818679e-14,
  1.692040000397649e-16,  2.916848772189680e-19, -1.863724802672426e-21, -1.009509542056443e-24,  1.988073156965347e-26, -9.760582482446931e-30,  9.390389328724600e-01,
 -2.465581549228390e-03,  8.136007640002650e-07,  9.696834097845260e-09, -1.001827667127005e-11, -6.546324882797194e-14,  1.224623129354314e-16,  5.072303316943858e-19,
 -1.491513572896844e-21, -4.023200050019804e-24,  1.804293253425941e-26,  2.994786638127293e-29,  1.001360367111993e+00, -2.487819301115636e-03,  2.490218199335004e-07,
  1.021352620490714e-08, -4.030419944300649e-12, -7.471798848224466e-14,  5.623384843232252e-17,  6.572634066034174e-19, -7.573345681028615e-22, -6.323871996532218e-24,
  1.007537041654517e-26,  6.391517975061318e-29,  1.064006270305965e+00, -2.490830450172381e-03, -3.344321850871422e-07,  1.034390217550169e-08,  2.487415846247062e-12,
 -7.750380572662883e-14, -2.175838235449981e-17,  7.073407185197087e-19,  2.080671715506404e-22, -7.157914829347084e-24, -2.103820739288102e-27,  7.722272744379731e-29,
  1.126733063604658e+00, -2.474103534302379e-03, -9.210811624516642e-07,  1.006414195455882e-08,  9.078403465782831e-12, -7.309380097891601e-14, -1.011882958413004e-16,
  6.392810483320579e-19,  1.199614021081686e-21, -6.121737973201006e-24, -1.473574932104417e-26,  6.160690623752761e-29,  1.189288923657000e+00, -2.437430392354167e-03,
 -1.494337776807962e-06,  9.371889737299748e-09,  1.524733685614332e-11, -6.155402861663633e-14, -1.705706588443624e-16,  4.571377340560171e-19,  1.982975269500421e-21,
 -3.345619810929391e-24, -2.340268792949920e-26,  2.039779125466172e-29,  1.251414553312946e+00, -2.380930424990810e-03, -2.037261403251404e-06,  8.288151981159327e-09,
  2.050324595569580e-11, -4.381295637481331e-14, -2.191095053678012e-16,  1.888841489755453e-19,  2.354935997605289e-21,  4.782472163397223e-25, -2.468652062932525e-26,
 -3.127730581794130e-29,  1.312844110872935e+00, -2.305070639932408e-03, -2.533184322596407e-06,  6.857798649377902e-09,  2.440644115556277e-11, -2.161805551549096e-14,
 -2.386549828403433e-16, -1.173136089427517e-19,  2.203289878972301e-21,  4.262086866944605e-24, -1.766862722256148e-26, -7.206552968757778e-29,  1.373306307940393e+00,
 -2.210680336863546e-03, -2.966391021650802e-06,  5.148433592509010e-09,  2.661540775741577e-11,  2.630498900119369e-15, -2.253948424749267e-16, -4.021500522268844e-19,
  1.547540921352238e-21,  6.853792106230382e-24, -4.576256812324429e-27, -8.389239752054435e-29,  1.432525683585862e+00, -2.098959259427697e-03, -3.322825057267775e-06,
  3.247496116711912e-09,  2.692818004743159e-11,  2.616055639643660e-14, -1.808962406222411e-16, -6.080176613033930e-19,  5.445455610676976e-22,  7.432299149714593e-24,
  9.854620313125352e-27, -6.103165544260210e-29,  1.490224059449116e+00, -1.971478063364493e-03, -3.590791812329660e-06,  1.257586104866708e-09,  2.531258518573506e-11,
  4.619380385394582e-14, -1.121896660570484e-16, -6.927671100225154e-19, -5.477074772347063e-22,  5.822051590426900e-24,  2.019291417571559e-26, -1.381049970150968e-29,
  1.546122176553586e+00, -1.830170032352148e-03, -3.761620194456090e-06, -7.098361321175898e-10,  2.192023414963517e-11,  6.034753931697513e-14, -3.075194699885203e-17,
 -6.407893617160351e-19, -1.441593412609300e-21,  2.590917435618277e-24,  2.260214844331622e-26,  3.576030433133964e-29,  1.599941509986156e+00, -1.677313126497432e-03,
 -3.830242566196812e-06, -2.542047846274787e-09,  1.708045425623990e-11,  6.700887943837535e-14,  4.952182673378134e-17, -4.680313213147765e-19, -1.906489556089234e-21,
 -1.132892855319689e-24,  1.656278310201042e-26,  6.487605939515094e-29,  1.651406252250799e+00, -1.515501679955410e-03, -3.795650647273184e-06, -4.133455124969067e-09,
  1.127249450830962e-11,  6.561310806992965e-14,  1.150130167153494e-16, -2.188686069505458e-19, -1.842049121612638e-21, -4.076303801051113e-24,  5.133204693707186e-27,
  6.174961519232612e-29,  1.700245450137182e+00, -1.347607376931121e-03, -3.661186457316292e-06, -5.394116141178191e-09,  5.077131280239364e-12,  5.676595364739168e-14,
  1.551844003634758e-16,  4.503279167845700e-20, -1.310902693713855e-21, -5.311561697457421e-24, -6.487599311074717e-27,  3.158580072921183e-29,  1.746195273517701e+00,
 -1.176729526659890e-03, -3.434632105078805e-06, -6.257622826777475e-09, -8.880649998599020e-13,  4.217152794462087e-14,  1.648379178214040e-16,  2.612067780014915e-19,
 -5.159235048175719e-22, -4.612850318520281e-24, -1.345298423065687e-26, -7.049699461649631e-30,  1.789001387826171e+00, -1.006135118178900e-03, -3.128070678025197e-06,
 -6.687523543847689e-09, -6.042538773641168e-12,  2.436140315870590e-14,  1.452286738453713e-16,  3.835543359296211e-19,  2.726418528988721e-22, -2.514670150822173e-24,
 -1.355165525472214e-26, -3.346809176812888e-29,  1.828421395371580e+00, -8.391896471454247e-04, -2.757502609947870e-06, -6.681513548186557e-09, -9.916052676681109e-12,
  6.260390077183584e-15,  1.036744692691844e-16,  3.948292579674533e-19,  8.143544415104172e-22, -3.754469233254796e-26, -8.060105613603522e-27, -3.675480868150924e-29,
  1.864227304454366e+00, -6.792802438229673e-04, -2.342217250878784e-06, -6.272763477884311e-09, -1.221081781049682e-11, -9.337260936577423e-15,  5.167117595235757e-17,
  3.102077442903607e-19,  9.824723061518509e-22,  1.792982072005792e-24, -7.135572149478845e-28, -2.081584696672181e-29,  1.896207979892647e+00, -5.297331603377956e-04,
 -1.903937018505826e-06, -5.527997284925939e-09, -1.284234683928052e-11, -2.028078224800646e-14,  1.939355964592365e-18,  1.704893642693248e-19,  8.004903431479285e-22,
  2.400236153810445e-24,  4.565422223306066e-27,  3.194340911901086e-31,  1.924171524526643e+00, -3.937281571378328e-04, -1.465770112467173e-06, -4.542253200534449e-09,
 -1.195130597431843e-11, -2.545753785877005e-14, -3.483601814570535e-17,  2.707413074175599e-20,  4.163850431172523e-22,  1.859059597970392e-24,  5.800612678009551e-27,
  1.306335846512527e-29,  1.947947539295487e+00, -2.742127198746740e-04, -1.051025598880071e-06, -3.430632052516721e-09, -9.882664095501560e-12, -2.497946313023376e-14,
 -5.267051759011732e-17, -7.604053535071097e-20,  2.688876414330179e-23,  7.553521004494732e-25,  3.695359122483411e-27,  1.287784758902193e-29,  1.967389211494553e+00,
 -1.738192897675065e-04, -6.819597786297064e-07, -2.317710963214648e-09, -7.133556375308549e-12, -2.011203769113155e-14, -5.157268803081927e-17, -1.166937732185716e-19,
 -2.129264671735726e-22, -2.016523000692234e-25,  6.426558685567022e-28,  5.070837005144639e-30,  1.982375196018542e+00, -9.478871956703138e-05, -3.785330658632889e-07,
 -1.325623673275301e-09, -4.276637359773573e-12, -1.295276240775641e-14, -3.706508408537844e-17, -1.000677396237061e-19, -2.525241885759568e-22, -5.825167104455494e-25,
 -1.163758260163989e-27, -1.685119052164682e-30,  1.992811356486796e+00, -3.890254882003728e-05, -1.572589106885044e-07, -5.620237061124909e-10, -1.870254451455339e-12,
 -5.924918942123305e-15, -1.806510698104416e-17, -5.330573792788142e-20, -1.525889453884249e-22, -4.237960360447019e-25, -1.139862060958359e-27, -2.956084063609755e-30,
  1.998633839397990e+00, -7.418797683299979e-06, -3.019258079461719e-08, -1.091138890173871e-10, -3.692231461869745e-13, -1.197615979402173e-15, -3.770063149627728e-18,
 -1.160236237985649e-20, -3.506762543588036e-23, -1.044110360929998e-25, -3.068754208871278e-28, -8.915901836732552e-31,  4.078191945206389e-04, -1.853415716505774e-06,
  6.316217946966980e-09, -1.912878087615551e-11,  5.429416422727524e-14, -1.478882596837514e-16,  3.914620469146729e-19, -1.014563976581385e-21,  2.586925214246433e-24,
 -6.510679494138445e-27,  1.621064880643309e-29, -3.999849192900090e-32,  3.669065412992247e-03, -1.665229343108143e-05,  5.659044452747667e-08, -1.705727355069222e-10,
  4.806601757803063e-13, -1.295907022267683e-15,  3.383217525578965e-18, -8.611882536557835e-21,  2.146171754814955e-23, -5.249531010952500e-26,  1.262042990122550e-28,
 -2.984058057283567e-31,  1.018458016272794e-02, -4.609846436254063e-05,  1.557810819537029e-07, -4.650667026083776e-10,  1.291383593798386e-12, -3.408928557854071e-15,
  8.644664155636828e-18, -2.116422515635195e-20,  5.010289225156107e-23, -1.145732021096606e-25,  2.521080286810397e-28, -5.296920318292554e-31,  1.994038304430289e-02,
 -8.988942622877837e-05,  3.011962089024255e-07, -8.861394618017609e-10,  2.405251818873780e-12, -6.140335837345488e-15,  1.484517380605673e-17, -3.397252847447648e-20,
  7.303401003422265e-23, -1.448165258510481e-25,  2.537861307037909e-28, -3.468154207304468e-31,  3.291544102835771e-02, -1.475731063422036e-04,  4.888571733317871e-07,
 -1.409868969806453e-09,  3.707325366942973e-12, -9.017188389831979e-15,  2.025877084765088e-17, -4.135092027580906e-20,  7.324857753623738e-23, -9.731737210501061e-26,
  2.216466516115032e-29,  4.617607347843559e-31,  4.908159391606255e-02, -2.185499174978867e-04,  7.135695304038986e-07, -2.005804766959898e-09,  5.056825805096932e-12,
 -1.149233907089315e-14,  2.305074540513084e-17, -3.799273077843656e-20,  3.798261174039878e-23,  4.993286418003916e-26, -4.462624129388944e-28,  1.706584693121099e-30,
  6.840345559987625e-02, -3.020755639713171e-04,  9.690173638154669e-07, -2.638165347529991e-09,  6.297048577266943e-12, -1.300705735618854e-14,  2.160124980339433e-17,
 -2.038314807219383e-20, -3.603449049123202e-23,  2.787803443349314e-25, -1.011254731490639e-27,  2.759494681141498e-30,  9.083829171706700e-02, -3.972646527509741e-04,
  1.247880700157462e-06, -3.267282116246267e-09,  7.266798943608922e-12, -1.305875937138451e-14,  1.482287004628388e-17,  1.201579574606614e-20, -1.393037029876673e-22,
  5.267171080609050e-25, -1.410539845034349e-27,  2.767800768876116e-30,  1.163358744846206e-01, -5.030951782888590e-04,  1.541975571256876e-06, -3.851253890002788e-09,
  7.812745508790135e-12, -1.126769758121582e-14,  2.426934077846925e-18,  5.606496685902059e-20, -2.493857005951830e-22,  6.982673930713497e-25, -1.344839710619412e-27,
  1.071603209232612e-30,  1.448383157330391e-01, -6.184139616575189e-04,  1.842416069601177e-06, -4.347767982055589e-09,  7.801998489794675e-12, -7.436108890944503e-15,
 -1.490395725903752e-17,  1.049290228400732e-19, -3.343597883104237e-22,  6.911115234310245e-25, -6.050827726772015e-28, -2.336098595603037e-30,  1.762798794252786e-01,
 -7.419431368039855e-04,  2.139797465745692e-06, -4.716035800715703e-09,  7.134154038336732e-12, -1.593423828670930e-15, -3.547177722010956e-17,  1.488351963993255e-19,
 -3.596347981337075e-22,  4.313453852109475e-25,  8.004894253033332e-28, -6.528771721348390e-30,  2.105867752630784e-01, -8.722877872580591e-04,  2.424399103277659e-06,
 -4.918782754100115e-09,  5.752007371454458e-12,  5.978247158790557e-15, -5.666899729127386e-17,  1.765782034985731e-19, -2.969776391228912e-22, -9.166755202476541e-26,
  2.571421677769497e-27, -9.742501976836244e-30,  2.476769353537474e-01, -1.007944845756787e-03,  2.686405346532801e-06, -4.924224315035680e-09,  3.650132561382137e-12,
  1.474298066736005e-14, -7.523910905679916e-17,  1.775980514309306e-19, -1.338862106155082e-22, -8.022788147714961e-25,  4.137153329654778e-27, -9.924922649028361e-30,
  2.874597763437233e-01, -1.147313376248773e-03,  2.916142320436085e-06, -4.707952708467119e-09,  8.805623180932248e-13,  2.393719545602916e-14, -8.767608264683246e-17,
  1.443236689887949e-19,  1.190074575035700e-22, -1.537690777250748e-24,  4.795274978603196e-27, -5.623478970630151e-30,  3.298359499284068e-01, -1.288706361973298e-03,
  3.104327544629707e-06, -4.254652298610874e-09, -2.445116401806823e-12,  3.262383055112804e-14, -9.072576877082708e-17,  7.437244321631180e-20,  4.248054980015717e-22,
 -2.075131167815819e-24,  3.945738075642909e-27,  3.093687682828045e-30,  3.746970852280205e-01, -1.430364123960900e-03,  3.242328823190807e-06, -3.559556963435666e-09,
 -6.157799707009453e-12,  3.977266284804856e-14, -8.193216034062139e-17, -2.785258144017144e-20,  7.232268548369524e-22, -2.185698242915964e-24,  1.358440134448716e-27,
  1.410404921175080e-29,  4.219255271829258e-01, -1.570469490413222e-03,  3.322427909661778e-06, -2.629560269640711e-09, -1.003739311659271e-11,  4.436198902812017e-14,
 -6.015538662016181e-17, -1.505999957632425e-19,  9.401470251031293e-22, -1.704862876470787e-24, -2.619201828235210e-27,  2.346220614920009e-29,  4.713940758740839e-01,
 -1.707164827873968e-03,  3.338083534807919e-06, -1.483889945560311e-09, -1.382393161950932e-11,  4.549394155386363e-14, -2.597931790343307e-17, -2.755614484159740e-19,
  1.002924781701615e-21, -6.017921592613967e-25, -7.012590189378965e-27,  2.654723326987075e-29,  5.229657325184311e-01, -1.838571028631944e-03,  3.284187380697993e-06,
 -1.542629368356514e-10, -1.723309037034795e-11,  4.251296685112457e-14,  1.807243403229165e-17, -3.801382704935172e-19,  8.589805732098689e-22,  9.747314427510903e-25,
 -1.039470580590254e-26,  1.990507283486486e-29,  5.764934588254106e-01, -1.962808524000111e-03,  3.157305540235010e-06,  1.315552777356613e-09, -1.997552686009294e-11,
  3.511480243624318e-14,  6.758027309183479e-17, -4.410363688857839e-19,  4.936453092541743e-22,  2.694634243557217e-24, -1.128524652575216e-26,  3.170787991137521e-30,
  6.318199574266913e-01, -2.078020358492296e-03,  2.955896961196802e-06,  2.870827440622946e-09, -2.177910605127558e-11,  2.343202771715876e-14,  1.165739718572107e-16,
 -4.387400143674766e-19, -5.750084221908568e-23,  4.101517640145095e-24, -8.686859931389689e-27, -1.978705503012790e-29,  6.887774821982593e-01, -2.182397313933145e-03,
  2.680499399870755e-06,  4.447644718877179e-09, -2.241266080123375e-11,  8.082319020213334e-15,  1.581825308557277e-16, -3.621308637423376e-19, -7.063390050379534e-22,
  4.721750607281602e-24, -2.590796289110635e-27, -4.128039516256831e-29,  7.471876884684512e-01, -2.274205013698002e-03,  2.333872581865914e-06,  5.975367152004892e-09,
 -2.170956361944610e-11, -9.832738185419779e-15,  1.855428274075313e-16, -2.123176188469192e-19, -1.322988584899915e-21,  4.206697201867964e-24,  5.754670692463132e-27,
 -5.207961696822142e-29,  8.068615343252427e-01, -2.351812864271956e-03,  1.921087686916840e-06,  7.379757805857690e-09, -1.958907436409947e-11, -2.878679496245404e-14,
  1.928685299078951e-16, -4.691958163108615e-21, -1.759898058413703e-21,  2.470181803187454e-24,  1.398724108267092e-26, -4.507470719059051e-29,  8.675992454699656e-01,
 -2.413724603164702e-03,  1.449552060322772e-06,  8.586678347335392e-09, -1.607323171789414e-11, -4.694875839437364e-14,  1.765318529663315e-16,  2.316166770210407e-19,
 -1.885882040487594e-21, -2.256599307598091e-25,  1.924430466601975e-26, -1.901683473990097e-29,  9.291903572702910e-01, -2.458610118494010e-03,  9.289583431074012e-07,
  9.526231972284875e-09, -1.129702871730469e-11, -6.235924602645546e-14,  1.359757976919586e-16,  4.573262191629749e-19, -1.623068291243306e-21, -3.278207745372224e-24,
  1.912995463163314e-26,  1.941876181643975e-29,  9.914138487878628e-01, -2.485338086636631e-03,  3.711481547094195e-07,  1.013716414179239e-08, -5.509807952076183e-12,
 -7.315048157939464e-14,  7.426429896837280e-17,  6.294693150830195e-19, -9.770799776961716e-22, -5.866615363248546e-24,  1.273509661516037e-26,  5.672987464816882e-29,
  1.054038384526538e+00, -2.493008841728189e-03, -2.101177930538008e-07,  1.037127859156079e-08,  9.337248450918335e-13, -7.778782656756325e-14, -1.898444015947580e-18,
  7.098663256339259e-19, -5.031200455718703e-23, -7.173962437383292e-24,  1.301223699558406e-27,  7.719313277407477e-29,  1.116822680382222e+00, -2.480986747391753e-03,
 -7.994885847811732e-07,  1.019757561366788e-08,  7.593713684505799e-12, -7.530339140914390e-14, -8.278490985126713e-17,  6.740342695089470e-19,  9.692978891981461e-22,
 -6.654463389638603e-24, -1.184197666640070e-26,  6.964034014367084e-29,  1.179516010676604e+00, -2.448931191570689e-03, -1.380452689573146e-06,  9.605780537747636e-09,
  1.397639267628453e-11, -6.548707341192948e-14, -1.569018126327880e-16,  5.184871859015429e-19,  1.845934816393358e-21, -4.259882314123719e-24, -2.221455991615275e-26,
  3.355442835768545e-29,  1.241858873113200e+00, -2.396825176481265e-03, -1.935865104653139e-06,  8.608910076151641e-09,  1.957487298769422e-11, -4.899959494903870e-14,
 -2.127645228945451e-16,  2.643245112929432e-19,  2.354079277588416e-21, -5.331655351289301e-25, -2.579317441402346e-26, -1.879642720600286e-29,  1.303583827882939e+00,
 -2.325000336512300e-03, -2.448562999150871e-06,  7.244530641165038e-09,  2.391657854055601e-11, -2.737708863463788e-14, -2.409306315803834e-16, -4.449588548415326e-20,
  2.343253205853462e-21,  3.493473384559445e-24, -2.071934987578052e-26, -6.620340472380219e-29,  1.364416525840706e+00, -2.234157098763177e-03, -2.902053965546548e-06,
  5.574403356691308e-09,  2.661304077962409e-11, -2.908277287623293e-15, -2.359249469603550e-16, -3.487235845033943e-19,  1.790081367049429e-21,  6.595675394711342e-24,
 -8.356492723918193e-27, -8.758226307635277e-29,  1.424076938547821e+00, -2.125378617404354e-03, -3.281253512444691e-06,  3.682291048086104e-09,  2.740660832861207e-11,
  2.161697157817547e-14, -1.976360441523546e-16, -5.862405779646968e-19,  8.185254968084148e-22,  7.769382052147812e-24,  6.916661581231768e-27, -7.240126012686737e-29,
  1.482280799914572e+00, -2.000137079475695e-03, -3.573240774972545e-06,  1.669825552890669e-09,  2.620795515360596e-11,  4.326670081391955e-14, -1.317999057171892e-16,
 -7.067857724994325e-19, -3.237555915024198e-22,  6.613817789530795e-24,  1.929936246198454e-26, -2.699119034525765e-29,  1.538741265091460e+00, -1.860291012301384e-03,
 -3.767994202974855e-06, -3.495030729050565e-10,  2.311832460660649e-11,  5.938906705809092e-14, -4.932459973819137e-17, -6.852505503924774e-19, -1.331688225346885e-21,
  3.524180964325191e-24,  2.400047883516956e-26,  2.744592413302755e-29,  1.593170787097152e+00, -1.708072337189650e-03, -3.859062994176848e-06, -2.257979161126144e-09,
  1.843141981709052e-11,  6.803321791524867e-14,  3.555765523074661e-17, -5.295580703413487e-19, -1.934658432001280e-21, -4.130829447083546e-25,  1.942965087836157e-26,
  6.513684783394468e-29,  1.645283205439372e+00, -1.546062124165610e-03, -3.844126164819155e-06, -3.942449343758150e-09,  1.261182840570176e-11,  6.829308572627313e-14,
  1.080377107378931e-16, -2.801170513916967e-19, -1.984424750018921e-21, -3.814378354228099e-24,  8.018167964344410e-27,  6.930938639592322e-29,  1.694796033758350e+00,
 -1.377154317583974e-03, -3.725390324418091e-06, -5.303596786502365e-09,  6.249771489441972e-12,  6.050059164590921e-14,  1.558289474292221e-16, -2.275472399610595e-23,
 -1.506429839706070e-21, -5.540487944916155e-24, -4.888173891296128e-27,  4.126894449142409e-29,  1.741432925463315e+00, -1.204507125440454e-03, -3.509780297046962e-06,
 -6.264867022536284e-09, -4.491229993767120e-15,  4.621338070219082e-14,  1.718948656568965e-16,  2.419358613260415e-19, -6.917315325437013e-22, -5.155452270245243e-24,
 -1.363193583561024e-26, -8.446151138499101e-31,  1.784926287700876e+00, -1.031482290025846e-03, -3.208884342284336e-06, -6.780113293464131e-09, -5.519581201192166e-12,
  2.797666400108038e-14,  1.560759668275505e-16,  3.907229237363934e-19,  1.720013640199608e-22, -3.086205854787340e-24, -1.502391983310781e-26, -3.329828966590346e-29,
  1.825020005152120e+00, -8.615730674286494e-04, -2.838628133406908e-06, -6.839029725378465e-09, -9.765052324758019e-12,  8.884181122727886e-15,  1.150938537708638e-16,
  4.208015118223725e-19,  8.067983570089941e-22, -3.935514541411336e-25, -9.771435256714413e-27, -4.103692327053670e-29,  1.861472226565940e+00, -6.983224095593350e-04,
 -2.418668587231725e-06, -6.469560127533711e-09, -1.238443978316766e-11, -7.989310892830839e-15,  6.080679395409258e-17,  3.426722339480301e-19,  1.046272693013517e-21,
  1.744742661391935e-24, -1.733697124879705e-27, -2.566082528835796e-29,  1.894058159159133e+00, -5.452335242759446e-04, -1.971519223783563e-06, -5.736715554423610e-09,
 -1.324709506597035e-11, -2.017397760383599e-14,  7.084919173106552e-18,  1.975228263986695e-19,  8.901835944528155e-22,  2.582495397495465e-24,  4.530682846006004e-27,
 -1.996692722756422e-30,  1.922572809724360e+00, -4.056756359356167e-04, -1.521441424598227e-06, -4.737592442706639e-09, -1.246874792197808e-11, -2.628293626919263e-14,
 -3.388101491996325e-17,  4.151518713776450e-20,  4.876279179276662e-22,  2.102771642905563e-24,  6.389476241821907e-27,  1.367839201123338e-29,  1.946833607432802e+00,
 -2.827883215074637e-04, -1.093158630162405e-06, -3.592820796325128e-09, -1.039506612933770e-11, -2.626898176851527e-14, -5.478330848571934e-17, -7.471534491396378e-20,
  5.688333834951286e-23,  9.150159871691258e-25,  4.300968589831262e-27,  1.468119774217472e-29,  1.966682844052844e+00, -1.793881894629056e-04, -7.104706264571905e-07,
 -2.435134166896298e-09, -7.548443242688661e-12, -2.138976777300708e-14, -5.493655808790036e-17, -1.236181551549186e-19, -2.196665571871373e-22, -1.711614249571549e-25,
  8.902196846099552e-28,  6.215306485150936e-30,  1.981989882195233e+00, -9.788179728262822e-05, -3.948598151582925e-07, -1.396171615210995e-09, -4.544819984321791e-12,
 -1.387688001541423e-14, -3.998332910384749e-17, -1.084931722745840e-19, -2.743505236884364e-22, -6.305448323987832e-25, -1.237448150809645e-27, -1.657507912890879e-30,
  1.992653186704896e+00, -4.018811511413429e-05, -1.641867277535936e-07, -5.929198388471474e-10, -1.993212265956864e-12, -6.376958417416913e-15, -1.962838531730077e-17,
 -5.844175117897077e-20, -1.686986169994767e-22, -4.720987383991483e-25, -1.277998113021694e-27, -3.330319675768367e-30,  1.998603672689086e+00, -7.665678077899574e-06,
 -3.153819954354424e-08, -1.152181068566055e-10, -3.941072654855456e-13, -1.292126253056059e-15, -4.111222010744837e-18, -1.278711518743151e-20, -3.905716749592784e-23,
 -1.175082686569987e-25, -3.489519056124238e-28, -1.024230103667163e-30,  4.005051579111317e-04, -1.803789607920390e-06,  6.091788837511557e-09, -1.828323539664367e-11,
  5.142809633522249e-14, -1.388249219130643e-16,  3.641788349640144e-19, -9.354107363169253e-22,  2.363800553021884e-24, -5.896111860038788e-27,  1.454988923647469e-29,
 -3.558224298648380e-32,  3.603348904864588e-03, -1.620762856811563e-05,  5.458887384964531e-08, -1.630851867132810e-10,  4.555348695828912e-13, -1.217527500611264e-15,
  3.151422359767334e-18, -7.954395683603146e-21,  1.965967631535934e-23, -4.770021963877515e-26,  1.137789309466808e-28, -2.669970582881970e-31,  1.000264394667050e-02,
 -4.487419276161975e-05,  1.503220404268378e-07, -4.449389193068647e-10,  1.225232661975988e-12, -3.208390368404741e-15,  8.073905493095074e-18, -1.962502521096890e-20,
  4.615429004788848e-23, -1.049405616795371e-25,  2.298733333835487e-28, -4.817214072795137e-31,  1.958557804359908e-02, -8.752174623235947e-05,  2.907894487473888e-07,
 -8.486188470552930e-10,  2.285932238816334e-12, -5.795207092453740e-15,  1.392589229440940e-17, -3.171692495400060e-20,  6.799968467384064e-23, -1.349679103847105e-25,
  2.387083374703881e-28, -3.380837101717188e-31,  3.233286457347684e-02, -1.437289278100294e-04,  4.722887820938078e-07, -1.351968485577444e-09,  3.531751275420421e-12,
 -8.544610161942113e-15,  1.913323520213109e-17, -3.906281158052693e-20,  6.976573003840670e-23, -9.605462693845292e-26,  4.025693363359226e-29,  3.634577436098811e-31,
  4.821866083642945e-02, -2.129362817017056e-04,  6.899778399179564e-07, -1.926704629357391e-09,  4.832425751493177e-12, -1.095174785223258e-14,  2.200421165810801e-17,
 -3.675182827407473e-20,  3.947635657723309e-23,  3.351582692725374e-26, -3.762285169959302e-28,  1.481490230894319e-30,  6.721045951347547e-02, -2.944483637889557e-04,
  9.379554023587527e-07, -2.539465727716730e-09,  6.042044866057285e-12, -1.249559739935288e-14,  2.101583265663322e-17, -2.138324862009096e-20, -2.669798907229858e-23,
  2.406765306836496e-25, -8.959255062796576e-28,  2.486324808076894e-30,  8.926895364826468e-02, -3.874364798451846e-04,  1.209362371582932e-06, -3.153083300076967e-09,
  7.009205966459767e-12, -1.269945976784234e-14,  1.509967859276232e-17,  7.850812691966931e-21, -1.213285003463035e-22,  4.726898804284063e-25, -1.291866728049297e-27,
  2.624392160461868e-30,  1.143478756628525e-01, -4.909421259425001e-04,  1.496503123136600e-06, -3.728049110944817e-09,  7.588096613389729e-12, -1.119149225484190e-14,
  3.888733912078450e-18,  4.847654030639625e-20, -2.252044257442873e-22,  6.454784667575670e-25, -1.293200413935104e-27,  1.264868109795068e-30,  1.423938110940683e-01,
 -6.038812152445388e-04,  1.790986877563036e-06, -4.224144240936768e-09,  7.649931189672609e-12, -7.759733941112428e-15, -1.211203191855170e-17,  9.462272948250980e-20,
 -3.099384003534049e-22,  6.650490909113415e-25, -6.933692861067302e-28, -1.694768037960654e-30,  1.733459879547456e-01, -7.250491890221368e-04,  2.083888717247855e-06,
 -4.602189145411915e-09,  7.094103234248597e-12, -2.396023739760723e-15, -3.146313277673279e-17,  1.375809735607954e-19, -3.435965324695237e-22,  4.579158782636647e-25,
  5.351818294292556e-28, -5.547507744169921e-30,  2.071360428923659e-01, -8.531271228429264e-04,  2.365929613755970e-06, -4.825866351311829e-09,  5.858366674307162e-12,
  4.676445269084386e-15, -5.185821292333965e-17,  1.670411482027238e-19, -2.985270072624935e-22,  2.895671811853377e-27,  2.163627736599982e-27, -8.797024566218743e-30,
  2.436877656456199e-01, -9.866889511353273e-04,  2.627674484633499e-06, -4.863559747252377e-09,  3.927334969715196e-12,  1.299640529657513e-14, -7.033046378359838e-17,
  1.728826702528032e-19, -1.598938916440849e-22, -6.454314412040106e-25,  3.707800447243052e-27, -9.570572710629501e-30,  2.829168236966280e-01, -1.124209944253744e-03,
  2.859746853893625e-06, -4.690146708655115e-09,  1.338593305197723e-12,  2.188184271778237e-14, -8.358976550045901e-17,  1.472827186289914e-19,  6.704135016715958e-23,
 -1.351066737983196e-24,  4.530530455677497e-27, -6.365077398915897e-30,  3.247304694931426e-01, -1.264076581175037e-03,  3.053058136373515e-06, -4.288671919765540e-09,
 -1.814237648754624e-12,  3.047286940602730e-14, -8.846403957446295e-17,  8.680163395323374e-20,  3.529689126290905e-22, -1.915189445786063e-24,  4.036855334017157e-27,
  1.103540639150756e-30,  3.690272331812524e-01, -1.404597967271949e-03,  3.199048894120478e-06, -3.651825191262737e-09, -5.382060129586296e-12,  3.779947541980831e-14,
 -8.239977443929977e-17, -5.956633948405063e-21,  6.456616626205484e-22, -2.119790646950638e-24,  1.916521629340787e-27,  1.130111018383778e-29,  4.156966044551391e-01,
 -1.544018949286083e-03,  3.289938617731531e-06, -2.783140457168581e-09, -9.164914863267716e-12,  4.287100033799197e-14, -6.396036003859385e-17, -1.215155379408546e-19,
  8.771280806606452e-22, -1.789737453194428e-24, -1.643292587231121e-27,  2.088698948697254e-29,  4.646187079059964e-01, -1.680535077504358e-03,  3.318979667279073e-06,
 -1.697830256228022e-09, -1.292089414724972e-11,  4.478145395627971e-14, -3.324935786871047e-17, -2.438663551232450e-19,  9.764903843979305e-22, -8.591957414879079e-25,
 -5.864884610244592e-27,  2.554722326045945e-29,  5.156639771458719e-01, -1.812309556852828e-03,  3.280709973923712e-06, -4.231703042581471e-10, -1.637933962284731e-11,
  4.282211448025616e-14,  7.818098965366149e-18, -3.521679473811182e-19,  8.868028198846349e-22,  5.770013647280489e-25, -9.479742789650861e-27,  2.156142781431903e-29,
  5.686928340005287e-01, -1.937492312561894e-03,  3.171197972820916e-06,  1.001646675226791e-09, -1.925800222202099e-11,  3.659041231973643e-14,  5.546637207287186e-17,
 -4.237743756959343e-19,  5.825729800682366e-22,  2.247387194670044e-24, -1.104447482784205e-26,  7.650706802403217e-30,  6.235553802119865e-01, -2.054241270418867e-03,
  2.988272042432360e-06,  2.526258701874259e-09, -2.128348331052311e-11,  2.608231246897119e-14,  1.042852010452575e-16, -4.382862224357136e-19,  8.370617545785073e-23,
  3.738465080833461e-24, -9.420955297448422e-27, -1.363646893652382e-29,  6.800911103653255e-01, -2.160745914423459e-03,  2.731725514027934e-06,  4.090538095687255e-09,
 -2.221388446266560e-11,  1.175462593168985e-14,  1.477518181989238e-16, -3.820374429522502e-19, -5.386447114639494e-22,  4.583377562485782e-24, -4.287883089793698e-27,
 -3.579550660068298e-29,  7.381286561486629e-01, -2.255253133805304e-03,  2.403487157982151e-06,  5.626680738305721e-09, -2.186219376571773e-11, -5.455691564820073e-15,
  1.790282927624849e-16, -2.521902217845178e-19, -1.167951665906577e-21,  4.391587598862247e-24,  3.505124031751968e-27, -4.998524194760550e-29,  7.974855735549029e-01,
 -2.336095304752796e-03,  2.007746044444885e-06,  7.061978071331166e-09, -2.011856498407870e-11, -2.416580460252570e-14,  1.919628364440002e-16, -5.948183330108784e-20,
 -1.661388311219441e-21,  2.988968130549804e-24,  1.192907226724318e-26, -4.823343013415674e-29,  8.579681862135168e-01, -2.401720467896561e-03,  1.551018935465249e-06,
  8.322227118300755e-09, -1.696934919045741e-11, -4.264099230726370e-14,  1.821720724783046e-16,  1.712852495844916e-19, -1.880374492172703e-21,  5.248736996937464e-25,
  1.822241979391401e-26, -2.724593709640066e-29,  9.193714996618846e-01, -2.450724359019178e-03,  1.042148040916192e-06,  9.335683592694859e-09, -1.251057300580891e-11,
 -5.894813801551110e-14,  1.480371172451824e-16,  4.036489532851171e-19, -1.727132793701159e-21, -2.499051478667417e-24,  1.975048983609539e-26,  8.801455983285107e-30,
  9.814792029747351e-01, -2.481883926717993e-03,  4.922172334374399e-07,  1.003740590467156e-08, -6.953585590100515e-12, -7.116036134933629e-14,  9.142068635257761e-17,
  5.949266389676260e-19, -1.178529269757476e-21, -5.309720400533775e-24,  1.504722981714796e-26,  4.816444887188546e-29,  1.044063775694794e+00, -2.494191826947120e-03,
 -8.562414190400108e-08,  1.037377641286349e-08, -6.208792870386658e-13, -7.759529417824048e-14,  1.791655781212621e-17,  7.041408018417774e-19, -3.068233915219434e-22,
 -7.054472425467083e-24,  4.657348062794609e-27,  7.500759087569722e-29,  1.106886719355279e+00, -2.486891222080829e-03, -6.764387131467053e-07,  1.030692501547125e-08,
  6.069323351184469e-12, -7.706047322176347e-14, -6.351433528248521e-17,  7.011335243192776e-19,  7.219675115716734e-22, -7.064903234686794e-24, -8.635191322977028e-27,
  7.579106375788843e-29,  1.169698933940664e+00, -2.459510034887290e-03, -1.263885459873064e-06,  9.818725343071439e-09,  1.263020457538609e-11, -6.907197807678767e-14,
 -1.415814519625894e-16,  5.749350255710831e-19,  1.676974754577644e-21, -5.115171750865233e-24, -2.045807159712951e-26,  4.615687237532142e-29,  1.232241260259067e+00,
 -2.411893621538193e-03, -1.830712227138872e-06,  8.913993333044065e-09,  1.854446098294065e-11, -5.400864300211439e-14, -2.043131224263443e-16,  3.391474389233572e-19,
  2.316150770602026e-21, -1.577480412578814e-24, -2.632287771711842e-26, -5.115407931918552e-30,  1.294245209239762e+00, -2.344234641381186e-03, -2.359351727273806e-06,
  7.622501120361634e-09,  2.331115676218171e-11, -3.316579085697631e-14, -2.411090050092652e-16,  3.233493865951766e-20,  2.453418574109995e-21,  2.608701265244980e-24,
 -2.345904207237770e-26, -5.793781833634882e-29,  1.355433898447902e+00, -2.257098726814673e-03, -2.832609198145967e-06,  5.999435838061076e-09,  2.649749671656782e-11,
 -8.680957300128935e-15, -2.448520588706709e-16, -2.877139598825413e-19,  2.020574650516673e-21,  6.183758696266336e-24, -1.224943989087938e-26, -8.896422355251617e-29,
  1.415523214441440e+00, -2.151444409780194e-03, -3.234421568195363e-06,  4.123992254961776e-09,  2.779020191569283e-11,  1.667994966447765e-14, -2.136416893533832e-16,
 -5.555256231930943e-19,  1.102406585578806e-21,  7.979174627180802e-24,  3.496743356608804e-27, -8.285888041455839e-29,  1.474223216800125e+00, -2.028635660869839e-03,
 -3.550658923772737e-06,  2.095896893608036e-09,  2.704004910481707e-11,  3.986507762371962e-14, -1.516981082878724e-16, -7.131899687740286e-19, -7.208609180512952e-23,
  7.357935148518783e-24,  1.780344774164462e-26, -4.113491182879745e-29,  1.531239795568660e+00, -1.890445364067619e-03, -3.769929910280215e-06,  2.982144359911460e-11,
  2.429268953075713e-11,  5.797034100283421e-14, -6.908780478133236e-17, -7.256471717170708e-19, -1.187272699069157e-21,  4.505425736272097e-24,  2.498543528633488e-26,
  1.696691935572846e-29,  1.586276588348423e+00, -1.739048107110414e-03, -3.884344289766685e-06, -1.952149929380029e-09,  1.979938078171842e-11,  6.870166616470676e-14,
  1.986216847064368e-17, -5.915494912212350e-19, -1.934852288335349e-21,  4.210721270116236e-25,  2.226561088878319e-26,  6.341660555045477e-29,  1.639037156278860e+00,
 -1.577000835928321e-03, -3.890179299230119e-06, -3.729595111790993e-09,  1.400294625052218e-11,  7.078457125645870e-14,  9.928524408732815e-17, -3.457477335315673e-19,
 -2.115215152774095e-21, -3.430563730900479e-24,  1.122299621670428e-26,  7.622747365794407e-29,  1.689227409692285e+00, -1.407210219606551e-03, -3.788392919422859e-06,
 -5.193717247652199e-09,  7.497153279280940e-12,  6.423484593163682e-14,  1.551231970235021e-16, -5.145383438556235e-20, -1.708941642141085e-21, -5.696651979514568e-24,
 -2.843214650416557e-27,  5.181241268212022e-29,  1.736558264439641e+00, -1.232886010943650e-03, -3.584927899380263e-06, -6.257318334404065e-09,  9.615661938374341e-13,
  5.041747137318011e-14,  1.783305226385827e-16,  2.167257276007638e-19, -8.871323055307639e-22, -5.699313784496526e-24, -1.350488982318479e-26,  6.880307748160538e-30,
  1.780748499040919e+00, -1.057480267662981e-03, -3.290756447550626e-06, -6.863743073866331e-09, -4.921700766145793e-12,  3.185428518727962e-14,  1.670757193136379e-16,
  3.943304773197892e-19,  4.973000459228275e-23, -3.716188885597253e-24, -1.646631918826825e-26, -3.207054131715806e-29,  1.821527771335288e+00, -8.846130075178234e-04,
 -2.921627574346828e-06, -6.993694952887007e-09, -9.558776787782129e-12,  1.179072442712956e-14,  1.272350532196088e-16,  4.463133310669552e-19,  7.851484741000501e-22,
 -8.217765932521930e-25, -1.167069220167458e-26, -4.527277711666380e-29,  1.858639741772771e+00, -7.179856773230538e-04, -2.497497221999549e-06, -6.668906830703829e-09,
 -1.252883539274758e-11, -6.410969143057661e-15,  7.087968054786752e-17,  3.771422461413601e-19,  1.107548834674679e-21,  1.651241539427850e-24, -2.981454823780216e-27,
 -3.116623815184078e-29,  1.891845239636841e+00, -5.612846742175311e-04, -2.041644811181700e-06, -5.951885733719676e-09, -1.364840925085155e-11, -1.993426582064000e-14,
  1.302858516530064e-17,  2.275309755542526e-19,  9.863869515396805e-22,  2.761143654298002e-24,  4.380144486962896e-27, -4.962210347727957e-30,  1.920925399219769e+00,
 -4.180780035040961e-04, -1.579507022404311e-06, -4.941341432243784e-09, -1.300243451837183e-11, -2.708029652238569e-14, -3.248839363387792e-17,  5.838098977613063e-20,
  5.680744910717301e-22,  2.370530310089544e-24,  7.001604892389240e-27,  1.410933609361877e-29,  1.945684686509372e+00, -2.917089138014651e-04, -1.137287976933098e-06,
 -3.763417036099536e-09, -1.093376201652507e-11, -2.760864818180644e-14, -5.684465813066026e-17, -7.233352782258560e-20,  9.308148773781941e-23,  1.100547728112570e-24,
  4.990163875918292e-27,  1.667835878850675e-29,  1.965953735752712e+00, -1.851909270749067e-04, -7.404312395601067e-07, -2.559404450100604e-09, -7.989707866416145e-12,
 -2.275058061566464e-14, -5.849715116860892e-17, -1.307386438831441e-19, -2.251180350763623e-22, -1.296990211430409e-25,  1.192824315681081e-27,  7.578437096374707e-30,
  1.981591929366564e+00, -1.011089496692581e-04, -4.120595077553945e-07, -1.471162224998902e-09, -4.832204863452700e-12, -1.487394699078716e-14, -4.314752840119473e-17,
 -1.176452775786837e-19, -2.979585156396300e-22, -6.814829425372804e-25, -1.308904179433267e-27, -1.581311977715356e-30,  1.992489761416502e+00, -4.153062110423999e-05,
 -1.714974074471987e-07, -6.258577114086604e-10, -2.125598013260243e-12, -6.868302171485861e-15, -2.134295836525753e-17, -6.412219571409983e-20, -1.866507370589762e-22,
 -5.262699969872149e-25, -1.433641167406387e-27, -3.752797470327828e-30,  1.998572496455034e+00, -7.923623340030302e-06, -3.295952163128520e-08, -1.217360486636266e-10,
 -4.209662318517701e-13, -1.395237290073197e-15, -4.487414531298043e-18, -1.410741395036008e-20, -4.354996616889466e-23, -1.324113334722197e-25, -3.973227570461910e-28,
 -1.178260011368150e-30,  3.933860980489774e-04, -1.755919112049287e-06,  5.877236999875833e-09, -1.748213170738912e-11,  4.873692266262090e-14, -1.303905725654108e-16,
  3.390151906785909e-19, -8.630559448078006e-22,  2.161649959846335e-24, -5.344246525489707e-27,  1.307174577902191e-29, -3.168625109574106e-32,  3.539379590618174e-03,
 -1.577862358510996e-05,  5.267479249614893e-08, -1.559873982121788e-10,  4.319229811470235e-13, -1.144496507392697e-15,  2.937254793843964e-18, -7.351905462805433e-21,
  1.802163541289725e-23, -4.337556539770681e-26,  1.026570215929973e-28, -2.390856881710265e-31,  9.825518977057758e-03, -4.369264505231447e-05,  1.450983117938844e-07,
 -4.258381946731470e-10,  1.162958930315244e-12, -3.021047179436363e-15,  7.544526386815139e-18, -1.820679973696473e-20,  4.253695069815471e-23, -9.615639656564636e-26,
  2.096527404865177e-28, -4.380791920294721e-31,  1.924008006114842e-02, -8.523555126568597e-05,  2.808217052494441e-07, -8.129533025836655e-10,  2.173299629096337e-12,
 -5.471401101716929e-15,  1.306756477897984e-17, -2.961686264550067e-20,  6.330915300019178e-23, -1.257139706872949e-25,  2.240695435450499e-28, -3.269876297643514e-31,
  3.176540407241637e-02, -1.400145642317784e-04,  4.563986487601323e-07, -1.296803020438016e-09,  3.365363744439580e-12, -8.098288532206089e-15,  1.807021406663149e-17,
 -3.688529515637016e-20,  6.634037015086039e-23, -9.414981876793787e-26,  5.438395502923982e-29,  2.811066127831326e-31,  4.737781075944639e-02, -2.075076428467304e-04,
  6.673141610802416e-07, -1.851109750793804e-09,  4.618589194196847e-12, -1.043585162611469e-14,  2.099300727478439e-17, -3.547206036509554e-20,  4.042720048925900e-23,
  1.971024582760907e-26, -3.154926556202846e-28,  1.283441176458589e-30,  6.604748264068917e-02, -2.870649903050917e-04,  9.080536910497038e-07, -2.444765106003174e-09,
  5.797127754857104e-12, -1.199849096326299e-14,  2.040639544275471e-17, -2.210566170622721e-20, -1.865302659373623e-23,  2.069518609688064e-25, -7.921408158121750e-28,
  2.234666749801617e-30,  8.773832055874539e-02, -3.779110415418166e-04,  1.172189938078031e-06, -3.042948161151081e-09,  6.758856297663658e-12, -1.233485295987446e-14,
  1.526763456844086e-17,  4.230820053077778e-21, -1.052143839669147e-22,  4.232801614414650e-25, -1.179734106441035e-27,  2.471394808711304e-30,  1.124077707687658e-01,
 -4.791470003283440e-04,  1.452487622347568e-06, -3.608424685865079e-09,  7.365305890426959e-12, -1.108266774560510e-14,  5.148608253368602e-18,  4.163192230198031e-20,
 -2.028844910504574e-22,  5.949068469161012e-25, -1.234407344200346e-27,  1.398662156725090e-30,  1.400066239100680e-01, -5.897540102593333e-04,  1.741026369893782e-06,
 -4.103001812495769e-09,  7.492038528579154e-12, -8.019728279914475e-15, -9.597887608962452e-18,  8.508228033414457e-20, -2.865123087083933e-22,  6.359886494982930e-25,
 -7.557261908095094e-28, -1.155458063057360e-30,  1.704787863707640e-01, -7.085970586691532e-04,  2.029341770662833e-06, -4.489106597773157e-09,  7.038937285241325e-12,
 -3.106138796042726e-15, -2.776229175250783e-17,  1.268533143137998e-19, -3.267826173527742e-22,  4.747077327054005e-25,  3.108244945140158e-28, -4.666856068866093e-30,
  2.037610247674121e-01, -8.344297273653360e-04,  2.308584492444084e-06, -4.731450305571805e-09,  5.939822881562766e-12,  3.486895186118043e-15, -4.731467042014718e-17,
  1.575059143290590e-19, -2.969557498372304e-22,  8.197183166979743e-26,  1.796859636310822e-27, -7.880149238958212e-30,  2.397826845356927e-01, -9.658999187241912e-04,
  2.569697076846582e-06, -4.798733038638359e-09,  4.170772786692980e-12,  1.136596410015683e-14, -6.556467521113094e-17,  1.674221053474462e-19, -1.805601293646375e-22,
 -5.054123175990591e-25,  3.296521089904231e-27, -9.109009396983233e-30,  2.784653839751130e-01, -1.101556699808026e-03,  2.803607691120473e-06, -4.665335716061781e-09,
  1.756503719706531e-12,  1.992537405558108e-14, -7.944288068891991e-17,  1.486842453405681e-19,  2.159594173110594e-23, -1.175607304402647e-24,  4.238896756317876e-27,
 -6.852354588270441e-30,  3.197226855230199e-01, -1.239858420235351e-03,  3.001439647255157e-06, -4.312938571638871e-09, -1.225808434019851e-12,  2.838011154995232e-14,
 -8.588560617117385e-17,  9.702471840495140e-20,  2.869356213542287e-22, -1.753256781284499e-24,  4.047661818849158e-27, -5.603738971089555e-31,  3.634597465639155e-01,
 -1.379182270891524e-03,  3.154734913594227e-06, -3.731997702175460e-09, -4.645848307795814e-12,  3.582214415630983e-14, -8.228866518261384e-17,  1.349926144238316e-20,
  5.708418686340377e-22, -2.033957014220377e-24,  2.356500390837895e-27,  8.739408559025360e-30,  4.095729527231005e-01, -1.517835459326484e-03,  3.255689122085127e-06,
 -2.923004239768287e-09, -8.323104802530702e-12,  4.129823422773280e-14, -6.697960804034156e-17, -9.448926257387454e-20,  8.117288736557976e-22, -1.837854483211807e-24,
 -7.815014640118859e-28,  1.828724848864075e-29,  4.579495373633060e-01, -1.654068182726781e-03,  3.297394707489169e-06, -1.897445145576298e-09, -1.203377988125555e-11,
  4.390503111632577e-14, -3.964510826618884e-17, -2.131566603667473e-19,  9.416040574061326e-22, -1.071695351668294e-24, -4.770280130298668e-27,  2.415051039893373e-29,
  5.084671919133128e-01, -1.786088579276981e-03,  3.274087800266801e-06, -6.783812998323459e-10, -1.552180306175672e-11,  4.289464372732614e-14, -1.642704081292341e-18,
 -3.235292117099118e-19,  9.009811685676437e-22,  2.171140452010625e-25, -8.507708369215515e-27,  2.251214680711963e-29,  5.609936727218157e-01, -1.912079831848055e-03,
  3.181393337742456e-06,  6.994414382902038e-10, -1.851383197330239e-11,  3.778139536947729e-14,  4.387324137934423e-17, -4.039220801686388e-19,  6.556186169917556e-22,
  1.813493446035519e-24, -1.062303956115419e-26,  1.138165705988824e-29,  6.153864113591504e-01, -2.030219582261247e-03,  3.016561575899791e-06,  2.190027961330679e-09,
 -2.073780056359549e-11,  2.843831753375675e-14,  9.207039494128160e-17, -4.335280684186214e-19,  2.113789988834618e-22,  3.351352426716505e-24, -9.892781448862831e-27,
 -7.885853142792031e-30,  6.714921366917307e-01, -2.138701787558624e-03,  2.778687810406883e-06,  3.737185682706388e-09, -2.194420739235634e-11,  1.517050845190960e-14,
  1.368380088503189e-16, -3.966701308613804e-19, -3.770946564648601e-22,  4.382047152993538e-24, -5.736574893540226e-27, -3.002345346672289e-29,  7.291465186315855e-01,
 -2.235761109170858e-03,  2.468905704960604e-06,  5.276243705343930e-09, -2.192893397777313e-11, -1.247824822663992e-15,  1.714676597265353e-16, -2.870123132591793e-19,
 -1.007853216134493e-21,  4.488659581987467e-24,  1.371342100934855e-27, -4.684873443791171e-29,  7.881738452110237e-01, -2.319699868808449e-03,  2.090543258677785e-06,
  6.736464149342701e-09, -2.055597551463671e-11, -1.958458738994384e-14,  1.895698517865402e-16, -1.108367104676955e-19, -1.545713673089351e-21,  3.423082307243728e-24,
  9.764296697999345e-27, -4.992888358693695e-29,  8.483867465344298e-01, -2.388917528437487e-03,  1.649229233964062e-06,  8.044134033445217e-09, -1.777809431248825e-11,
 -3.821808772964866e-14,  1.861294810453971e-16,  1.115537943459944e-19, -1.848667624691175e-21,  1.227636131084411e-24,  1.686459794370909e-26, -3.426040393983148e-29,
  9.095859811858260e-01, -2.441942553083637e-03,  1.152936958784684e-06,  9.126279492287057e-09, -1.365312399166434e-11, -5.526594412732124e-14,  1.585530981240575e-16,
  3.470942966349585e-19, -1.802813058031555e-21, -1.704366966969177e-24,  1.990819963469106e-26, -1.564651724669646e-30,  9.715603027746742e-01, -2.477466392103783e-03,
  6.119519956851496e-07,  9.914887674799893e-09, -8.353525317151979e-12, -6.877080345778857e-14,  1.075227663263401e-16,  5.542754488548843e-19, -1.358359548110749e-21,
 -4.668214927924045e-24,  1.695787167831552e-26,  3.853535879581471e-29,  1.034086426414055e+00, -2.494379165453569e-03,  3.875045168571650e-08,  1.035145714086215e-08,
 -2.166894929893428e-12, -7.693004817052379e-14,  3.745715800179332e-17,  6.903014240155803e-19, -5.566455353280071e-22, -6.803277477768541e-24,  7.871434088102951e-27,
  7.075880707839205e-29,  1.096929116949400e+00, -2.491806466166003e-03, -5.522240677718770e-07,  1.039162840940922e-08,  4.514473103834779e-12, -7.834686299709016e-14,
 -4.359782749803005e-17,  7.201070433713963e-19,  4.622299041720794e-22, -7.342266257382807e-24, -5.203514164045793e-27,  7.983160797716390e-29,  1.159841422566984e+00,
 -2.469146490495439e-03, -1.144894426449582e-06,  1.000957805781699e-08,  1.121612001504818e-11, -7.227086650997746e-14, -1.247607718303479e-16,  6.254981260873465e-19,
  1.478620236545337e-21, -5.889375280563270e-24, -1.816758942343622e-26,  5.775403955893726e-29,  1.222565078851453e+00, -2.426106487389370e-03, -1.722000538427971e-06,
  9.201800280198864e-09,  1.741606519498091e-11, -5.878988894458161e-14, -1.937893460417385e-16,  4.121522334562539e-19,  2.240393068010829e-21, -2.630680917773341e-24,
 -2.623173398447321e-26,  9.350338115109778e-30,  1.284831109239135e+00, -2.362737286963458e-03, -2.265666749419083e-06,  7.989859164361888e-09,  2.259009431323141e-11,
 -3.893259069558328e-14, -2.390916961332640e-16,  1.121610280554889e-19,  2.529853481221617e-21,  1.622301170985724e-24, -2.578405109521488e-26, -4.738133908204270e-29,
  1.346360647905609e+00, -2.279464435443004e-03, -2.758078979253257e-06,  6.421684940286565e-09,  2.626449916162525e-11, -1.464657007951134e-14, -2.519700843340288e-16,
 -2.195959425616447e-19,  2.233428092297897e-21,  5.615651326467338e-24, -1.614718604545791e-26, -8.776071737509604e-29,  1.406866010183192e+00, -2.177114248245000e-03,
 -3.182255709677885e-06,  4.571020475317675e-09,  2.807128870244373e-11,  1.137014501750403e-14, -2.286591950340705e-16, -5.156329129488947e-19,  1.391270346742923e-21,
  8.043345308492399e-24, -3.541941403054521e-28, -9.191063712960113e-29,  1.466052033363638e+00, -2.056932915039756e-03, -3.522886664712805e-06,  2.534711486295559e-09,
  2.779932530552481e-11,  3.598468010784274e-14, -1.716589427035743e-16, -7.111249078306359e-19,  2.051427046869418e-22,  8.029567748597120e-24,  1.567088302475580e-26,
 -5.585963281229460e-29,  1.523617706944040e+00, -1.920596676814013e-03, -3.767202005221043e-06,  4.276826567412378e-10,  2.543384798331715e-11,  5.606427985726728e-14,
 -8.991205776793865e-17, -7.608506353117136e-19, -1.006940103388884e-21,  5.516211918291025e-24,  2.546193472988516e-26,  4.345602024141038e-30,  1.579258105788768e+00,
 -1.770211074627250e-03, -3.905823937056615e-06, -1.624347427202626e-09,  2.117680331493053e-11,  6.897262143922639e-14,  2.435504569323634e-18, -6.530449353852958e-19,
 -1.902998835265146e-21,  1.366496893902979e-24,  2.497637496347205e-26,  5.939568656590846e-29,  1.632666632137153e+00, -1.608297373669360e-03, -3.933543029861635e-06,
 -3.494096402978882e-09,  1.544164197679792e-11,  7.304348640595672e-14,  8.863878120594054e-17, -4.153173105800198e-19, -2.229809849063353e-21, -2.912743644960217e-24,
  1.471086864916871e-26,  8.210510814624511e-29,  1.683537562813923e+00, -1.437764523215851e-03, -3.849954751052537e-06, -5.063283542636714e-09,  8.818930324593053e-12,
  6.793414447468070e-14,  1.528859238150701e-16, -1.094385345958653e-19, -1.915489198565378e-21, -5.761525197340764e-24, -3.187233625133459e-28,  6.302872577190824e-29,
  1.731568886465477e+00, -1.261865445717365e-03, -3.659889374746104e-06, -6.233631933830157e-09,  2.013189083944029e-12,  5.476682259864045e-14,  1.839698239327974e-16,
  1.849511787295761e-19, -1.101934408021302e-21, -6.230822202082698e-24, -1.300239201601790e-26,  1.623694585119706e-29,  1.776465402398342e+00, -1.084137067760916e-03,
 -3.373572107892944e-06, -6.937171978123589e-09, -4.243622160220616e-12,  3.599664908705618e-14,  1.781182175909321e-16,  3.936514691257479e-19, -9.624294346236739e-23,
 -4.402420344868550e-24, -1.782678198322688e-26, -2.952997007586821e-29,  1.817942038097653e+00, -9.083243064364857e-04, -3.006461225302479e-06, -7.144578651474727e-09,
 -9.291399103022096e-12,  1.499713542592066e-14,  1.400784602715741e-16,  4.708706722605710e-19,  7.466705300206002e-22, -1.329650215701307e-24, -1.375230549562994e-26,
 -4.929454240878114e-29,  1.855727327447865e+00, -7.382891795962110e-04, -2.578730794024369e-06, -6.870297861805554e-09, -1.263916736592427e-11, -4.579078082972228e-15,
  8.194460168722357e-17,  4.135091198428862e-19,  1.164500364211093e-21,  1.502786784413702e-24, -4.486306047844964e-27, -3.734779581680821e-29,  1.889566976998891e+00,
 -5.779072657682066e-04, -2.114390782781513e-06, -6.173430543536246e-09, -1.404343283885517e-11, -1.954146954972413e-14,  1.985653545572754e-17,  2.607191033717770e-19,
  1.088879857821460e-21,  2.930944432001759e-24,  4.082742041167848e-27, -8.692223674871552e-30,  1.919227434503899e+00, -4.309548221686467e-04, -1.640069361921866e-06,
 -5.153755003073879e-09, -1.355169429728105e-11, -2.783826698369796e-14, -3.058600681302073e-17,  7.798007033741463e-20,  6.586050430399766e-22,  2.663082358211992e-24,
  7.627234378745253e-27,  1.427760472862452e-29,  1.944499363972337e+00, -3.009908780680569e-04, -1.183517086205426e-06, -3.942849419584262e-09, -1.149973985056528e-11,
 -2.899684943745384e-14, -5.882205708237875e-17, -6.868100771388833e-20,  1.364767084104809e-22,  1.315463045897905e-24,  5.771594125987416e-27,  1.887405853398835e-29,
  1.965200927515569e+00, -1.912394366882413e-04, -7.719263708278055e-07, -2.690957408475949e-09, -8.459059534315370e-12, -2.419925842330578e-14, -6.225931844544578e-17,
 -1.380072398516073e-19, -2.288438816003287e-22, -7.486040372820538e-26,  1.560894643752950e-27,  9.197619356021779e-30,  1.981180786921592e+00, -1.044773788574094e-04,
 -4.301873482899391e-07, -1.550914738370623e-09, -5.140311695344884e-12, -1.595011693712402e-14, -4.657884259442488e-17, -1.275827230286375e-19, -3.234507617223679e-22,
 -7.351946320916196e-25, -1.375660984228554e-27, -1.441052745979267e-30,  1.992320846578154e+00, -4.293323032034243e-05, -1.792163823231397e-07, -6.609946620001642e-10,
 -2.268235359719935e-12, -7.402771068764396e-15, -2.322492836653359e-17, -7.040954958031550e-20, -2.066697058111096e-22, -5.870542688739184e-25, -1.609043824897465e-27,
 -4.229525100063647e-30,  1.998540265192893e+00, -8.193259505688037e-06, -3.446170715886455e-08, -1.287007351214870e-10, -4.499807857156454e-13, -1.507837323350185e-15,
 -4.902671587571479e-18, -1.558045353496377e-20, -4.861579964850476e-23, -1.493918770351404e-25, -4.530086302346179e-28, -1.357397542626333e-30,  3.864551472080130e-04,
 -1.709727297291032e-06,  5.672045516068870e-09, -1.672276943849505e-11,  4.620855710166030e-14, -1.225365524897892e-16,  3.157898243286635e-19, -7.968631821801751e-22,
  1.978342300459817e-24, -4.848216847725021e-27,  1.175479203930276e-29, -2.824545621387729e-32,  3.477096201511190e-03, -1.536459687229714e-05,  5.084366517460706e-08,
 -1.492559886106864e-10,  4.097216487952778e-13, -1.076408881354014e-15,  2.739245918291643e-18, -6.799425065638970e-21,  1.653156168006462e-23, -3.947216235748584e-26,
  9.269388525265169e-29, -2.142623871397683e-31,  9.653038046735936e-03, -4.255198699540257e-05,  1.400979350250360e-07, -4.077045518762559e-10,  1.104308161602806e-12,
 -2.845945358851432e-15,  7.053283474139758e-18, -1.689942186182064e-20,  3.922173435194909e-23, -8.814384157274759e-26,  1.912639845776499e-28, -3.983974805444824e-31,
  1.890357004263881e-02, -8.302741645191985e-05,  2.712713456949051e-07, -7.790391704767717e-10,  2.066941817163645e-12, -5.167506007570414e-15,  1.226598693229579e-17,
 -2.766167910473301e-20,  5.894134586459587e-23, -1.170352805500689e-25,  2.099580310904467e-28, -3.142182122703558e-31,  3.121255091310131e-02, -1.364247183657736e-04,
  4.411548179433373e-07, -1.244229710005119e-09,  3.207652395857588e-12, -7.676760083214988e-15,  1.706663987634596e-17, -3.481619085363923e-20,  6.299291976109074e-23,
 -9.174823487309533e-26,  6.519479765547836e-29,  2.123639917220836e-31,  4.655831828314251e-02, -2.022567422561733e-04,  6.455374287293969e-07, -1.778855020121766e-09,
  4.414830790764841e-12, -9.943791307806699e-15,  2.001799090153144e-17, -3.416936518872696e-20,  4.092274003363457e-23,  8.167117039226099e-27, -2.629303098506839e-28,
  1.109504968806317e-30,  6.491356793864612e-02, -2.799163507489057e-04,  8.792652006569651e-07, -2.353904422113264e-09,  5.562005014700948e-12, -1.151622575422022e-14,
  1.978015787643733e-17, -2.258928147136509e-20, -1.175003924832083e-23,  1.771633236694598e-25, -6.989666976154995e-28,  2.003900067535310e-30,  8.624520273837204e-02,
 -3.686777637594710e-04,  1.136315333930290e-06, -2.936760094256823e-09,  6.515831158595552e-12, -1.196737487031563e-14,  1.534118856393925e-17,  1.098871527453966e-21,
 -9.079992057915232e-23,  3.782193916198167e-25, -1.074453970008775e-27,  2.313616551497646e-30,  1.105141511352590e-01, -4.676983171714038e-04,  1.409886303721380e-06,
 -3.492345921285227e-09,  7.144978913933621e-12, -1.094582700066190e-14,  6.226562225808134e-18,  3.547287743482891e-20, -1.823415235980972e-22,  5.467896000508285e-25,
 -1.170837121036676e-27,  1.483642376909193e-30,  1.376751553235849e-01, -5.760207178200568e-04,  1.692504252449311e-06, -3.984424076595902e-09,  7.329528171230966e-12,
 -8.222505020211772e-15, -7.340541433021023e-18,  7.627429066999447e-20, -2.641718217310934e-22,  6.048811616883945e-25, -7.963778726228865e-28, -7.062660352524257e-31,
  1.676765291287547e-01, -6.925758919802252e-04,  1.976146065398388e-06, -4.377015598857735e-09,  6.970433222992201e-12, -3.730976863648707e-15, -2.435421359385411e-17,
  1.166717144846641e-19, -3.095166567949376e-22,  4.832715062302157e-25,  1.230744656579265e-28, -3.882749915003322e-30,  2.004598859069903e-01, -8.161865405020302e-04,
  2.252379417318131e-06, -4.635915454390041e-09,  5.998556951612701e-12,  2.403194497413783e-15, -4.303700231504064e-17,  1.480637553554296e-19, -2.927922034008121e-22,
  1.471727267445206e-25,  1.469562665270454e-27, -7.004654958735157e-30,  2.359598369339786e-01, -9.455715301164092e-04,  2.512519903487817e-06, -4.730266034226324e-09,
  4.382732817582307e-12,  9.847996895645380e-15, -6.096030554631242e-17,  1.613777380002365e-19, -1.964766792534145e-22, -3.814137802848544e-25,  2.907322481357166e-27,
 -8.571667222141573e-30,  2.741036610470130e-01, -1.079351267003862e-03,  2.747805105934859e-06, -4.634145773824480e-09,  2.136282367175745e-12,  1.806874296626037e-14,
 -7.527617936061808e-17,  1.487302942766351e-19, -1.774746363604478e-23, -1.012175919626843e-24,  3.930695396202030e-27, -7.124386514195925e-30,  3.148109466783556e-01,
 -1.216054215113836e-03,  2.949585077445783e-06, -4.328121741959372e-09, -6.785935776068965e-13,  2.635243766161719e-14, -8.304963314582832e-17,  1.052279564481559e-19,
  2.267228732715778e-22, -1.592265218786571e-24,  3.992003750110884e-27, -1.921794990627655e-30,  3.579932078940461e-01, -1.354124737389919e-03,  3.109528235197058e-06,
 -3.800706871664862e-09, -3.949113704774410e-12,  3.385374911867910e-14, -8.166582262962653e-17,  3.061354423725381e-20,  4.994023874748137e-22, -1.932703488660129e-24,
  2.689394810079191e-27,  6.435468512271246e-30,  4.035534766493952e-01, -1.491932452236207e-03,  3.219841024727147e-06, -3.049654388055912e-09, -7.513414616050703e-12,
  3.966184914218539e-14, -6.927163344699404e-17, -6.957704755687681e-20,  7.451904416393513e-22, -1.853779497678930e-24, -3.337985385938348e-29,  1.573012251807430e-29,
  4.513858742084668e-01, -1.627783309232036e-03,  3.273498927335063e-06, -2.083014484382431e-09, -1.116566008342903e-11,  4.288529580576021e-14, -4.519770681070802e-17,
 -1.836774035011662e-19,  8.998401759459139e-22, -1.241734403013206e-24, -3.744023194058630e-27,  2.245619449751370e-29,  5.013751655695829e-01, -1.759932595936783e-03,
  3.264485426826577e-06, -9.198721692242501e-10, -1.466502134065572e-11,  4.274977588418139e-14, -1.029716442096699e-17, -2.946364895194871e-19,  9.029117819617931e-22,
 -1.032449434990446e-25, -7.507867075220808e-27,  2.283949153348259e-29,  5.533963018122242e-01, -1.886600089938874e-03,  3.188034417771499e-06,  4.093185587409232e-10,
 -1.774857808567048e-11,  3.870106347787873e-14,  3.286637616371109e-17, -3.819786856647691e-19,  7.133850704205666e-22,  1.399520347797603e-24, -1.005385859080545e-26,
  1.436930236681011e-29,  6.073139565520775e-01, -2.005987565007824e-03,  3.040870229535808e-06,  1.862889230878563e-09, -2.014791614647259e-11,  3.050321466168394e-14,
  8.004389637718829e-17, -4.249105169046441e-19,  3.248357474884998e-22,  2.950284903169743e-24, -1.012238983965025e-26, -2.641529490756431e-30,  6.629820641778381e-01,
 -2.116298844787386e-03,  2.821437974855823e-06,  3.388680283563329e-09, -2.160886218361053e-11,  1.832012004507115e-14,  1.255856922195216e-16, -4.062598677721320e-19,
 -2.237739542077332e-22,  4.127888996055125e-24, -6.928604749054011e-27, -2.415965547360345e-29,  7.202433692593049e-01, -2.215762568961203e-03,  2.530115344858454e-06,
  4.925401907547198e-09, -2.191340737991784e-11,  2.767468066932627e-15,  1.630041417878059e-16, -3.166715276693174e-19, -8.457608110128670e-22,  4.503404190858324e-24,
 -6.050763083276379e-28, -4.286542053066675e-29,  7.789289984684783e-01, -2.302657791853377e-03,  2.169395326613947e-06,  6.404681051973268e-09, -2.090245026930316e-11,
 -1.507762492864921e-14,  1.857929823608995e-16, -1.582567824247847e-19, -1.415983744466851e-21,  3.769529219792790e-24,  7.555831509801562e-27, -5.023518139572603e-29,
  8.388580685412247e-01, -2.375342468283641e-03,  1.744027710197886e-06,  7.753813285545227e-09, -1.849756634552589e-11, -3.372013747595379e-14,  1.884323387749465e-16,
  5.323068704260206e-20, -1.792709800333925e-21,  1.870301383808339e-24,  1.522736489583167e-26, -3.992970302594837e-29,  8.998373462102324e-01, -2.432284792292503e-03,
  1.261105815738898e-06,  8.899196896981746e-09, -1.471963683235682e-11, -5.135061626653601e-14,  1.674559482438082e-16,  2.885759433943255e-19, -1.849879775664250e-21,
 -9.123519129482017e-25,  1.962112392772914e-26, -1.136749556300431e-29,  9.616609786252619e-01, -2.472097237283654e-03,  7.300837889990214e-07,  9.770373337250261e-09,
 -9.701904852340193e-12, -6.600908286743933e-14,  1.224096211289218e-16,  5.082531037440337e-19, -1.513824278044992e-21, -3.958994429831248e-24,  1.842775110455103e-26,
  2.818840242458988e-29,  1.024110315484395e+00, -2.493572997876610e-03,  1.627093177127011e-07,  1.030453339099134e-08, -3.694951926276030e-12, -7.580137191290790e-14,
  5.649986937443015e-17,  6.686368384546709e-19, -7.951608053506699e-22, -6.427829869810975e-24,  1.085619134319509e-26,  6.461780475283048e-29,  1.086953846839538e+00,
 -2.495724352030288e-03, -4.271430117308384e-07,  1.045127451177332e-08,  2.938713165135337e-12, -7.914982896552045e-14, -2.326773401534481e-17,  7.306359990534119e-19,
  1.950149193978850e-22, -7.479462955155243e-24, -1.643318808176228e-27,  8.161584617158395e-29,  1.149947283182976e+00, -2.477822246254361e-03, -1.023750951499282e-06,
  1.017731599974787e-08,  9.742205512638281e-12, -7.504981176477527e-14, -1.066172459597135e-16,  6.692865985655195e-19,  1.254163004566828e-21, -6.562145371862232e-24,
 -1.539681838712037e-26,  6.792147411040530e-29,  1.212833806798013e+00, -2.439436159095958e-03, -1.609946601630589e-06,  9.470802308028899e-09,  1.619473420514401e-11,
 -6.329434356022656e-14, -1.812610625128067e-16,  4.821280949735785e-19,  2.126940395211233e-21, -3.667377628740819e-24, -2.549539266968530e-26,  2.413066588855324e-29,
  1.275344525246618e+00, -2.380473024410418e-03, -2.167646492510760e-06,  8.344760916266131e-09,  2.175436235412664e-11, -4.462391059663779e-14, -2.348104748320499e-16,
  1.938478655256184e-19,  2.569221685181049e-21,  5.528200816766023e-25, -2.759797653546931e-26, -3.475117531863592e-29,  1.337199159001740e+00, -2.301213706863382e-03,
 -2.678508104465418e-06,  6.839242963761436e-09,  2.591063941035330e-11, -2.075937810803084e-14, -2.570887352634681e-16, -1.450237838597701e-19,  2.423043386558363e-21,
  4.893500894499541e-24, -1.993132026022047e-26, -8.377535970060573e-29,  1.398106995296104e+00, -2.202345234227653e-03, -3.124702095006653e-06,  5.021677331278339e-09,
  2.824267107497120e-11,  5.714369769151858e-15, -2.424301628889166e-16, -4.664900776047331e-19,  1.679580303842603e-21,  7.946037346163796e-24, -4.563326892592538e-27,
 -9.905948962837188e-29,  1.457768138900098e+00, -2.084986727580758e-03, -3.489778385304537e-06,  2.985027643638652e-09,  2.847621291262516e-11,  3.162694060690145e-14,
 -1.914342467776159e-16, -6.998194005797820e-19,  5.048579842594828e-22,  8.602869785249005e-24,  1.288607827016939e-26, -7.069866399208049e-29,  1.515875087386529e+00,
 -1.950706761661855e-03, -3.759591561241250e-06,  8.434699575415484e-10,  2.653181106391805e-11,  5.364729408565614e-14, -1.116357286024163e-16, -7.896986872402830e-19,
 -7.900155127972553e-22,  6.534343909319061e-24,  2.533798889326713e-26, -1.029730517577927e-29,  1.572114653126963e+00, -1.801529769882055e-03, -3.923237618130712e-06,
 -1.274486118973980e-09,  2.255532381405397e-11,  6.880482168038531e-14, -1.669349780252605e-17, -7.129559673694295e-19, -1.835207698401201e-21,  2.416071975522003e-24,
  2.745429377879420e-26,  5.278994358665302e-29,  1.626170246479562e+00, -1.639929122652155e-03, -3.973941217111434e-06, -3.235231688637344e-09,  1.692280100626419e-11,
  7.502311489353579e-14,  7.599602897315169e-17, -4.882282448364469e-19, -2.323193044520218e-21, -2.250640073991371e-24,  1.842634905273017e-26,  8.649638829824818e-29,
  1.677724524159727e+00, -1.468804695535808e-03, -3.909822057079574e-06, -4.911113000005721e-09,  1.021402101939308e-11,  7.155951728839432e-14,  1.489323391849487e-16,
 -1.740496602922212e-19, -2.122434289686568e-21, -5.715406539908680e-24,  2.709351206203540e-27,  7.465172204039996e-29,  1.726462393581375e+00, -1.291443142648123e-03,
 -3.734462763976041e-06, -6.192416633862353e-09,  3.153076277517252e-12,  5.924004656142303e-14,  1.886203624606261e-16,  1.460015279998938e-19, -1.335405271817354e-21,
 -6.733499066848794e-24, -1.205090123751058e-26,  2.729670642425233e-29,  1.772074348193011e+00, -1.111459726901740e-03, -3.457201038977661e-06, -6.999074463300876e-09,
 -3.480050442860774e-12,  4.040325376414991e-14,  1.890725203889881e-16,  3.878957995135668e-19, -2.678687833963285e-22, -5.140387630417627e-24, -1.904154199886372e-26,
 -2.540082489536517e-29,  1.814260090968004e+00, -9.327214392698914e-04, -3.093077641269359e-06, -7.290654302483078e-09, -8.956755877428896e-12,  1.851988284744530e-14,
  1.535893695992270e-16,  4.938877740440489e-19,  6.883686879611660e-22, -1.924218744063631e-24, -1.600232580031860e-26, -5.288824869652320e-29,  1.852732384032421e+00,
 -7.592522443454062e-04, -2.662390393550761e-06, -7.073146323401076e-09, -1.271012241495711e-11, -2.469209076190324e-15,  9.405242017148588e-17,  4.516007711990782e-19,
  1.214956672869668e-21,  1.288499927969729e-24, -6.277932731181735e-27, -4.419788962280709e-29,  1.887221043070961e+00, -5.951225660324750e-04, -2.189832925397276e-06,
 -6.401223657020128e-09, -1.442888458366641e-11, -1.897327508859752e-14,  2.766057080734404e-17,  2.972821775350989e-19,  1.197229626354770e-21,  3.085314154216249e-24,
  3.602109925697391e-27, -1.331232212432343e-29,  1.917476977160093e+00, -4.443264859344448e-04, -1.703233884928715e-06, -5.375075332328790e-09, -1.411561072810464e-11,
 -2.854365760738123e-14, -2.809267026696998e-17,  1.006494771441932e-19,  7.601188246114726e-22,  2.980709345719113e-24,  8.252727718752380e-27,  1.408521730335919e-29,
  1.943276160055488e+00, -3.106514440358394e-04, -1.231954642414991e-06, -4.131562101453949e-09, -1.209394715944401e-11, -3.043111673470012e-14, -6.067653716885098e-17,
 -6.350982420630102e-20,  1.881953260024210e-22,  1.563626222760795e-24,  6.653995645263416e-27,  2.126717645376396e-29,  1.964423411136673e+00, -1.975463517915811e-04,
 -8.050461675644756e-07, -2.830256757268069e-09, -8.958304225195969e-12, -2.574068203721294e-14, -6.622635771181197e-17, -1.453604900035180e-19, -2.303125922864407e-22,
 -3.789425229145358e-27,  2.006618530897353e-27,  1.111568242797685e-29,  1.980755874532722e+00, -1.079947443608622e-04, -4.493025222693772e-07, -1.635773718963705e-09,
 -5.470788463743353e-12, -1.711207139049893e-14, -5.030012007195186e-17, -1.383673602291988e-19, -3.509229993543988e-22, -7.914301508611247e-25, -1.434488012660241e-27,
 -1.217288917686657e-30,  1.992146195073072e+00, -4.439931753507834e-05, -1.873710546570916e-07, -6.985018404318096e-10, -2.422028399518269e-12, -7.984594256939069e-15,
 -2.529225163540770e-17, -7.737391835775166e-20, -2.290084111899515e-22, -6.552915843403015e-25, -1.806736706748025e-27, -4.767136264037704e-30,  1.998506930810432e+00,
 -8.475255527216129e-06, -3.605033043030309e-08, -1.361482263019825e-10, -4.813504399167771e-13, -1.630917365933359e-15, -5.361538300974196e-18, -1.722582638905287e-20,
 -5.433500145465188e-23, -1.687658384434087e-25, -5.172085427560237e-28, -1.566053053408433e-30,  3.797057373184761e-04, -1.665141240985333e-06,  5.475728743637639e-09,
 -1.600263404280435e-11,  4.383184462253724e-14, -1.152183471351814e-16,  2.943383472074211e-19, -7.362604296417259e-22,  1.811978878559693e-24, -4.401958612212217e-27,
  1.058027039527707e-29, -2.520339724089418e-32,  3.416440124414498e-03, -1.496490200731678e-05,  4.909122755596237e-08, -1.428691593459180e-10,  3.888357725543575e-13,
 -1.012893095876893e-15,  2.556059529801254e-18, -6.292453496811600e-21,  1.517509264428899e-23, -3.594626794983244e-26,  8.376172026133708e-29, -1.921678853114475e-31,
  9.485041098594153e-03, -4.145047722874242e-05,  1.353096450216411e-07, -3.904819334343016e-10,  1.049044435294086e-12, -2.682205815489437e-15,  6.597204296332984e-18,
 -1.569365428974510e-20,  3.618214090895220e-23, -8.083300573839404e-26,  1.745404367132266e-28, -3.623334443253356e-31,  1.857574229486459e-02, -8.089408511035292e-05,
  2.621179426107828e-07, -7.467791670703952e-10,  1.966473882372323e-12, -4.882207349244528e-15,  1.151724364600712e-17, -2.584137428607772e-20,  5.487595008638603e-23,
 -1.089094482447697e-25,  1.964347931611631e-28, -3.003292178543346e-31,  3.067381717180179e-02, -1.329543418925712e-04,  4.265270005852516e-07, -1.194113625777288e-09,
  3.058135388970559e-12, -7.278634217397966e-15,  1.611951450795684e-17, -3.285274389260406e-20,  5.973901379986583e-23, -8.897116320037770e-26,  7.324272166422435e-29,
  1.552108925322052e-31,  4.575948639557530e-02, -1.971766419799034e-04,  6.246085130151810e-07, -1.709782953245944e-09,  4.220682551964997e-12, -9.474692254832917e-15,
  1.907961233178162e-17, -3.285707038503166e-20,  4.103878689282514e-23, -1.420085659510995e-27, -2.175402144875465e-28,  9.570102767827530e-31,  6.380779399506613e-02,
 -2.729937210287036e-04,  8.515447823261346e-07, -2.266729360413613e-09,  5.336376309750395e-12, -1.104912874746215e-14,  1.914331529449677e-17, -2.286846403727926e-20,
 -5.854746522225266e-24,  1.509046385021719e-25, -6.155023922124637e-28,  1.793151354189797e-30,  8.478845201317017e-02, -3.597264513268886e-04,  1.101691898938909e-06,
 -2.834401566076231e-09,  6.280166394139923e-12, -1.159913316705007e-14,  1.533326752721240e-17, -1.596970026746818e-21, -7.793352165575949e-23,  3.372304413908314e-25,
 -9.761504404770964e-28,  2.154820367395985e-30,  1.086656533509478e-01, -4.565849324948663e-04,  1.368656873591539e-06, -3.379769145476084e-09,  6.927633869758156e-12,
 -1.078511209894423e-14,  7.141009318421927e-18,  2.994398932034780e-20, -1.634842183219836e-22,  5.012776595015821e-25, -1.104430562477735e-27,  1.528985790888920e-30,
  1.353978525021009e-01, -5.626699550813368e-04,  1.645389342318072e-06, -3.868476089524674e-09,  7.163484478708656e-12, -8.373985198662113e-15, -5.319980803954665e-18,
  6.816300205092208e-20, -2.429759305027399e-22,  5.725188639236001e-25, -8.190420172377557e-28, -3.360804461369905e-31,  1.649375139136109e-01, -6.769749301199270e-04,
  1.924288477471415e-06, -4.266116290697620e-09,  6.890227569972289e-12, -4.277379404590767e-15, -2.122344868391792e-17,  1.070461745400112e-19, -2.920695147669177e-22,
  4.849880236774122e-25, -3.220277936916585e-29, -3.189862456131247e-30,  1.972308277938958e-01, -7.983883942026379e-04,  2.197325701458601e-06, -4.539608761710047e-09,
  6.036622320106044e-12,  1.419002413557043e-15, -3.902151410729400e-17,  1.387899333551813e-19, -2.865079238851411e-22,  2.000378931247502e-25,  1.179706099277677e-27,
 -6.179513780428676e-30,  2.322173933338136e-01, -9.256972170947486e-04,  2.456183699775859e-06, -4.658644598500804e-09,  4.565424564142992e-12,  8.438450119845929e-15,
 -5.653165885011788e-17,  1.548925068552303e-19, -2.082036554763138e-22, -2.724940560994752e-25,  2.542938912679844e-27, -7.985033595581078e-30,  2.698298695213611e-01,
 -1.057590657250950e-03,  2.692412051025063e-06, -4.597171002875787e-09,  2.479927793124595e-12,  1.631199126630578e-14, -7.112494709951671e-17,  1.476090913448384e-19,
 -5.143162164561523e-23, -8.612567822560149e-25,  3.614587178096365e-27, -7.217494427509956e-30,  3.099935940332371e-01, -1.192665429558197e-03,  2.897599516137264e-06,
 -4.334870130044539e-09, -1.712340630866144e-13,  2.439537102162879e-14, -8.001007719743291e-17,  1.115965758586790e-19,  1.722520718259736e-22, -1.434614875020976e-24,
  3.882608734078127e-27, -3.007564048843476e-30,  3.526261710930410e-01, -1.329431968829708e-03,  3.063562637212153e-06, -3.858582260200850e-09, -3.291560025548948e-12,
  3.190579783132996e-14, -8.059521986501949e-17,  4.550246196342069e-20,  4.318239922562637e-22, -1.820084068812250e-24,  2.926719794186550e-27,  4.395656756095198e-30,
  3.976370297167006e-01, -1.466322091401745e-03,  3.182549766789531e-06, -3.163614070943912e-09, -6.736946961459190e-12,  3.797858501948810e-14, -7.089597232806006e-17,
 -4.679767833078349e-20,  6.785904609945694e-22, -1.842005052453916e-24,  6.041735385198169e-28,  1.326918266093407e-29,  4.449269544431112e-01, -1.601698274773859e-03,
  3.247458958896514e-06, -2.254864026805683e-09, -1.031920155997565e-11,  4.174204676562562e-14, -4.994446101315843e-17, -1.556247605969358e-19,  8.526752038454336e-22,
 -1.372281392906391e-24, -2.797184982661021e-27,  2.055468000129039e-29,  4.943875914965559e-01, -1.733864790393364e-03,  3.252067282581227e-06, -1.147688720299170e-09,
 -1.381314852633974e-11,  4.240690554869407e-14, -1.814344226198537e-17, -2.658587774813278e-19,  8.940313222514061e-22, -3.834864095813221e-25, -6.505736240343776e-27,
  2.263083639516120e-29,  5.459009343737954e-01, -1.861080935832925e-03,  3.191268048686573e-06,  1.315727478232651e-10, -1.696752169420690e-11,  3.936413507798095e-14,
  2.249759769686416e-17, -3.584205747645976e-19,  7.566880369624414e-22,  1.010730310306011e-24, -9.369101110012786e-27,  1.664126295353264e-29,  5.993387941204589e-01,
 -1.981576617698622e-03,  3.061311159584171e-06,  1.545503441335498e-09, -1.951959853836839e-11,  3.228276818749457e-14,  6.830733722945931e-17, -4.128946954495194e-19,
  4.237428477315890e-22,  2.544481257323602e-24, -1.013382886424479e-26,  2.020925519930253e-30,  6.545622610862150e-01, -2.093570533054153e-03,  2.860040298643272e-06,
  3.046029591162957e-09, -2.121324422029286e-11,  2.119699952431257e-14,  1.141321124373287e-16, -4.110984356282223e-19, -8.039911898703666e-23,  3.831197379197429e-24,
 -7.863850325560284e-27, -1.837817191833953e-29,  7.114211667520414e-01, -2.195291181785242e-03,  2.587118987333436e-06,  4.575439673941450e-09, -2.181967040636871e-11,
  6.570257109774234e-15,  1.537827563063291e-16, -3.411501948320245e-19, -6.845164946355990e-22,  4.442801807023760e-24, -2.391313742110396e-27, -3.823762224236221e-29,
  7.697535563272673e-01, -2.285000911368244e-03,  2.244235693234093e-06,  6.068070104627472e-09, -2.115979730105389e-11, -1.067676045989264e-14,  1.807482233067917e-16,
 -2.013429957624013e-19, -1.275371551964244e-21,  4.027752539026665e-24,  5.362399821182673e-27, -4.926746830817378e-29,  8.293851852326358e-01, -2.361023144558563e-03,
  1.835276245008428e-06,  7.452703108757361e-09, -1.912665782966937e-11, -2.918629194320919e-14,  1.891306038916501e-16, -2.944697353579191e-21, -1.714851189179451e-21,
  2.442902329817553e-24,  1.337171618860445e-26, -4.418109650037161e-29,  8.901290553196343e-01, -2.421772864677855e-03,  1.366449916509952e-06,  8.655687598179400e-09,
 -1.570583991957032e-11, -4.724142611711087e-14,  1.747034643464454e-16,  2.290046092433959e-19, -1.868742553404818e-21, -1.402184950024548e-25,  1.892021556905994e-26,
 -2.033388633962987e-29,  9.517850097086463e-01, -2.465790327242730e-03,  8.463538502237707e-07,  9.604745766950032e-09, -1.099158431305564e-11, -6.290607945524831e-14,
  1.359421160732742e-16,  4.576748468597948e-19, -1.642809722422555e-21, -3.200215867569382e-24,  1.943316142118690e-26,  1.748257036616393e-29,  1.014139408416383e+00,
 -2.491777825467100e-03,  2.859592300317988e-07,  1.023336592747948e-08, -5.195918683477159e-12, -7.422379905526262e-14,  7.483131050170400e-17,  6.395785052465072e-19,
 -1.018080694275825e-21, -5.938901811602763e-24,  1.353341893586058e-26,  5.682494540957388e-29,  1.076964910409735e+00, -2.498639156087880e-03, -3.014979192668468e-07,
  1.048560657380812e-08,  1.351791999683621e-12, -7.946230478865869e-14, -2.763087952487440e-18,  7.325626475314182e-19, -7.456307381100660e-23, -7.473361695254552e-24,
  1.944519504410701e-27,  8.108608608207973e-29,  1.140020391248259e+00, -2.485521207765488e-03, -9.007378734003934e-07,  1.032105073954220e-08,  8.217161576828067e-12,
 -7.737943270242464e-14, -8.735168330575252e-17,  7.055271596354563e-19,  1.007584254253034e-21, -7.115643768256456e-24, -1.221717334885659e-26,  7.628190509855411e-29,
  1.203051028887008e+00, -2.451856826150216e-03, -1.494784806493363e-06,  9.719559322514796e-09,  1.488647735059722e-11, -6.747505197651992e-14, -1.668298443665928e-16,
  5.478832898582057e-19,  1.976853432521786e-21, -4.661632755765921e-24, -2.411104372517543e-26,  3.872008335574985e-29,  1.265788593268681e+00, -2.397407800447780e-03,
 -2.065451380904916e-06,  8.685386708112639e-09,  2.080601733887492e-11, -5.018492810199664e-14, -2.282302665378553e-16,  2.761655808922928e-19,  2.568921461744325e-21,
 -5.775606823042531e-25, -2.881624935734072e-26, -2.036708355618565e-29,  1.327951977732412e+00, -2.322306474081443e-03, -2.593964558037709e-06,  7.250155229155328e-09,
  2.543346758976484e-11, -2.696931692126927e-14, -2.600385324199947e-16, -6.482871448259450e-20,  2.583986626212235e-21,  4.024336175653302e-24, -2.347692124954240e-26,
 -7.691140051402808e-29,  1.389248011627174e+00, -2.227094121858891e-03, -3.061727935013021e-06,  5.474153910360734e-09,  2.829774973611989e-11, -2.543585993573472e-16,
 -2.546967301661206e-16, -4.082104435180066e-19,  1.961286804400761e-21,  7.674739929926855e-24, -9.036337315397495e-27, -1.038297672275225e-28,  1.449372593393874e+00,
 -2.112753881388199e-03, -3.451204290095290e-06,  3.445451104741824e-09,  2.906123097672256e-11,  2.679949449921078e-14, -2.107557821454452e-16, -6.786155539551509e-19,
  8.230504185248364e-22,  9.051805472221564e-24,  9.455669867783032e-27, -8.511052558495524e-29,  1.508012181273106e+00, -1.980735710380627e-03, -3.746887952882988e-06,
  1.276409362153176e-09,  2.757615951807994e-11,  5.070006546900236e-14, -1.340644668284959e-16, -8.110209584822405e-19, -5.366877057338768e-22,  7.534084729292668e-24,
  2.452932737860817e-26, -2.672989223594745e-29,  1.564845674183509e+00, -1.832970606705010e-03, -3.936320818633697e-06, -9.026208404289551e-10,  2.392576289668825e-11,
  6.815807647264701e-14, -3.746382548591805e-17, -7.700746151111214e-19, -1.727925184518281e-21,  3.558137362003812e-24,  2.958040841460779e-26,  4.337336818127827e-29,
  1.619546707701356e+00, -1.671871225852947e-03, -4.011089585281037e-06, -2.952368875310281e-09,  1.844035133502527e-11,  7.667450463847432e-14,  6.127372474755646e-17,
 -5.637170400899445e-19, -2.390023684818684e-21, -1.436596341055648e-24,  2.229354590156077e-26,  8.891973489108815e-29,  1.671786379047251e+00, -1.500316117179302e-03,
 -3.967727013555236e-06, -4.736046730614978e-09,  1.168051991436694e-11,  7.506754881399755e-14,  1.430773537040932e-16, -2.452320843041248e-19, -2.325415190549036e-21,
 -5.537892150036526e-24,  6.251465634135563e-27,  8.632849489207199e-29,  1.721236400314414e+00, -1.321615131472209e-03, -3.808429169514275e-06, -6.132241744861819e-09,
  4.383451308759593e-12,  6.381093570128937e-14,  1.920730533660692e-16,  9.929959545592120e-20, -1.586165535726054e-21, -7.187876861931223e-24, -1.057491783174575e-26,
  4.007437102961276e-29,  1.767572660885790e+00, -1.139454174328497e-03, -3.541496542546865e-06, -7.048040526118078e-09, -2.625733965849463e-12,  4.507018233071838e-14,
  1.997847175343483e-16,  3.762140426931970e-19, -4.668874858536973e-22, -5.922780206147986e-24, -2.003436983059059e-26, -1.939382693740053e-29,  1.810479158478325e+00,
 -9.578184185692110e-04, -3.181412456626278e-06, -7.430794188998250e-09, -8.548364058137300e-12,  2.237439461335432e-14,  1.677152951655968e-16,  5.146790765254533e-19,
  6.070058867592150e-22, -2.611767498219103e-24, -1.839627075698388e-26, -5.578823861423174e-29,  1.849652234365017e+00, -7.808943386053508e-04, -2.748489541645504e-06,
 -7.276776332325987e-09, -1.273588690472177e-11, -5.577881826830776e-17,  1.072481475176664e-16,  4.911691628965269e-19,  1.256334314706182e-21,  9.963306117715921e-25,
 -8.385015974382904e-27, -5.167710540738862e-29,  1.884805023408625e+00, -6.129524414184631e-04, -2.268045179801569e-06, -6.635082555651464e-09, -1.480101449960360e-11,
 -1.820510180121655e-14,  3.653771953921389e-17,  3.373972358909148e-19,  1.310739021730990e-21,  3.216101418705339e-24,  2.896160469185058e-27, -1.895658101600891e-29,
  1.915672005490581e+00, -4.582142436953426e-04, -1.769108842284067e-06, -5.605527713111979e-09, -1.469298321386467e-11, -2.918121342180390e-14, -2.491735886541585e-17,
  1.267550826303794e-19,  8.735143067835071e-22,  3.323054679833334e-24,  8.859648471480567e-27,  1.341141638328232e-29,  1.942013524300636e+00, -3.207087324819551e-04,
 -1.282714749015537e-06, -4.330013948572864e-09, -1.271727215879337e-11, -3.190795851822970e-14, -6.236166134033864e-17, -5.653368145412729e-20,  2.495090384798073e-22,
  1.849247763373626e-24,  7.645882868552158e-27,  2.384829063562193e-29,  1.963620126399024e+00, -2.041250498090325e-04, -8.398865182647687e-07, -2.977795891978680e-09,
 -9.489346171903633e-12, -2.737978810509894e-14, -7.039953581137609e-17, -1.527161901199162e-19, -2.288805964128698e-22,  8.689697701789904e-26,  2.544197054818664e-27,
  1.338138303392407e-29,  1.980316580260499e+00, -1.116691961751145e-04, -4.694685126791987e-07, -1.726111197590625e-09, -5.825422408757758e-12, -1.836706136739139e-14,
 -5.433598241794381e-17, -1.500639338329191e-19, -3.804594304810517e-22, -8.497920520088003e-25, -1.481195372547013e-27, -8.856862974902915e-31,  1.991965545833583e+00,
 -4.593248520697819e-05, -1.959909701844417e-07, -7.385655627835506e-10, -2.587970283153320e-12, -8.618456333812403e-15, -2.756496542508820e-17, -8.509400401646373e-20,
 -2.539518763262820e-22, -7.319292247399300e-25, -2.029556429027646e-27, -5.372907400892729e-30,  1.998472442447606e+00, -8.770326738086828e-06, -3.773141829750546e-08,
 -1.441179391631526e-10, -5.152956643676135e-13, -1.765584398181336e-15, -5.869146148993056e-18, -1.906588726375661e-20, -6.080019108222347e-23, -1.909012321300925e-25,
 -5.913332887050288e-28, -1.809467323556789e-30,  3.731315844178758e-04, -1.622091787881129e-06,  5.287830172511948e-09, -1.531938254034679e-11,  4.159648229587229e-14,
 -1.083952017502440e-16,  2.745115683328734e-19, -6.807330737806270e-22,  1.660866382074840e-24, -4.000110482832599e-27,  9.531740653614589e-30, -2.251101557353337e-32,
  3.357355265280035e-03, -1.457892566142357e-05,  4.741346800399303e-08, -1.368065757107775e-10,  3.691773722404385e-13, -9.536082314021822e-16,  2.386479248419847e-18,
 -5.826925120946706e-21,  1.393935223616704e-23, -3.275894880563495e-26,  7.574755021825384e-29, -1.724866019630339e-31,  9.321374864900025e-03, -4.038646188308136e-05,
  1.307228272943393e-07, -3.741179197293635e-10,  9.969487197422665e-13, -2.529017787012925e-15,  6.173563536143444e-18, -1.458106872827353e-20,  3.339406993897455e-23,
 -7.416036892545272e-26,  1.593300032433017e-28, -3.295691441194625e-31,  1.825630383175172e-02, -7.883245941317813e-05,  2.533421998269404e-07, -7.160819621283443e-10,
  1.871536275969535e-12, -4.614281341246606e-15,  1.081769083701164e-17, -2.414658484273417e-20,  5.109349695048658e-23, -1.013120947581718e-25,  1.835390234564876e-28,
 -2.857614122257852e-31,  3.014873464351307e-02, -1.295986224575973e-04,  4.124864814182188e-07, -1.146327330091065e-09,  2.916357981999879e-12, -6.902591313887922e-15,
  1.522592334948819e-17, -3.099176493500257e-20,  5.659029855725641e-23, -8.591945209392213e-26,  7.899850057591886e-29,  1.079103603074497e-31,  4.498064522231603e-02,
 -1.922607096733155e-04,  6.044901295483592e-07, -1.643743413491466e-09,  4.035694060512496e-12, -9.027673243552837e-15,  1.817798054355956e-17, -3.154624667499181e-20,
  4.084081107051502e-23, -9.320114026539235e-27, -1.784330867934687e-28,  8.235362604788074e-31,  6.272927358326617e-02, -2.662887309186138e-04,  8.248491099676634e-07,
 -2.183090455200073e-09,  5.119936176076405e-12, -1.059738930150920e-14,  1.850115907034583e-17, -2.297349569147182e-20, -8.468552206003029e-25,  1.278047315935919e-25,
 -5.408895737823590e-28,  1.601377323436894e-30,  8.336696025222938e-02, -3.510472767061643e-04,  1.068274385406227e-06, -2.735754790628012e-09,  6.051858683291296e-12,
 -1.123194218319164e-14,  1.525541057304256e-17, -3.903951195731845e-21, -6.647362725562722e-23,  3.000342603211089e-25, -8.848017572884870e-28,  1.997901364052901e-30,
  1.068609579071667e-01, -4.457960384402032e-04,  1.328757609440721e-06, -3.270643034977907e-09,  6.713710397449094e-12, -1.060424148088945e-14,  7.908852980618966e-18,
  2.499283605604707e-20, -1.462171403140185e-22,  4.584519994560335e-25, -1.036754492539403e-27,  1.542539682174966e-30,  1.331732076410135e-01, -5.496905914976814e-04,
  1.599649776187433e-06, -3.755206479405683e-09,  6.994878112286100e-12, -8.479621752637807e-15, -3.517216710863540e-18,  6.071119689212855e-20, -2.229576667902463e-22,
  5.395548109176660e-25, -8.269663797078771e-28, -3.466152235057025e-32,  1.622600812209877e-01, -6.617835284166490e-04,  1.873753633850702e-06, -4.156583705374710e-09,
  6.799823745130402e-12, -4.751814664561588e-15, -1.835438149164084e-17,  9.797879121117078e-20, -2.746652634046827e-22,  4.810776866154162e-25, -1.588879230852750e-28,
 -2.582047317977401e-30,  1.940720887385408e-01, -7.810260460174823e-04,  2.143430687341055e-06, -4.442845345527161e-09,  6.055946655680916e-12,  5.280904466936903e-16,
 -3.526260699916762e-17,  1.297454909943410e-19, -2.785205922501271e-22,  2.420187147176924e-25,  9.249359778793722e-28, -5.410549126743018e-30,  2.285535511170808e-01,
 -9.062701082870149e-04,  2.400723579935577e-06, -4.584319909816038e-09,  4.720973337749262e-12,  7.132972946138717e-15, -5.228928259806042e-17,  1.480919882761273e-19,
 -2.162655680337166e-22, -1.776239407238991e-25,  2.205040746300242e-27, -7.371052578296682e-30,  2.656422370844085e-01, -1.036271326311909e-03,  2.637494541371925e-06,
 -4.554973584978810e-09,  2.789431329424124e-12,  1.465437554729570e-14, -6.701939968035555e-17,  1.454944791612768e-19, -7.991086026144926e-23, -7.230187083104568e-25,
  3.297703630086358e-27, -7.164817205182683e-30,  3.052689644394197e-01, -1.169692717362570e-03,  2.845580402017495e-06, -4.333809875826374e-09,  2.977270602761184e-13,
  2.251320182576293e-14, -7.681575616099383e-17,  1.163120027658580e-19,  1.233670900671707e-22, -1.282220961384032e-24,  3.730982537894415e-27, -3.846159874793554e-30,
  3.473571657667886e-01, -1.305109527168555e-03,  3.016964378969211e-06, -3.906246928614499e-09, -2.672675906124900e-12,  2.998830313062525e-14, -7.913738096041405e-17,
  5.829540107153274e-20,  3.684498468051714e-22, -1.699689118066065e-24,  3.080082088540474e-27,  2.618085452977541e-30,  3.918224192010552e-01, -1.441015322067624e-03,
  3.143964416318692e-06, -3.265421499222411e-09, -5.994484009377987e-12,  3.626375036860624e-14, -7.191222806381123e-17, -2.613801408011537e-20,  6.128476424631838e-22,
 -1.806856297206353e-24,  1.136335949128781e-27,  1.094540280501404e-29,  4.385719454382280e-01, -1.575829580381149e-03,  3.219437282094684e-06, -2.413359078527866e-09,
 -9.496684513847375e-12,  4.049412667882643e-14, -5.392752648924659e-17, -1.291494485963320e-19,  8.014717003321425e-22, -1.466670991487512e-24, -1.937076176329413e-27,
  1.852632798291650e-29,  4.875040729676868e-01, -1.707907034075232e-03,  3.236996860822973e-06, -1.361940123875598e-09, -1.296995116207479e-11,  4.188535269856826e-14,
 -2.518938426681619e-17, -2.375189491340345e-19,  8.757802227283802e-22, -6.239643394793087e-25, -5.522948416766589e-27,  2.197480592016663e-29,  5.385076744823486e-01,
 -1.835549031110092e-03,  3.191244105732969e-06, -1.335833633354787e-10, -1.617563819270874e-11,  3.978641536457247e-14,  1.280578069451220e-17, -3.336952422448669e-19,
  7.865098413094199e-22,  6.511287360248086e-25, -8.599321512136980e-27,  1.824257142996027e-29,  5.914615786563534e-01, -1.957017203958459e-03,  3.078004903906165e-06,
  1.238440278265396e-09, -1.885847759094618e-11,  3.378502576576881e-14,  5.694933689520150e-17, -3.979472875999617e-19,  5.080805639428258e-22,  2.142140463668646e-24,
 -9.953828283530149e-27,  6.054819742630468e-30,  6.462339629948129e-01, -2.070549738080138e-03,  2.894570643703244e-06,  2.710154114559710e-09, -2.076284586380145e-11,
  2.379787565836206e-14,  1.026056303764356e-16, -4.115266289337829e-19,  5.168223625298026e-23,  3.502125453937702e-24, -8.549308700740006e-27, -1.282809143474628e-29,
  7.026817352981477e-01, -2.174380532459236e-03,  2.639934552032694e-06,  4.227573430895097e-09, -2.165214329907930e-11,  1.014408862947778e-14,  1.439477816546447e-16,
 -3.605173333557716e-19, -5.266895363002972e-22,  4.314967354699148e-24, -3.963448599760618e-27, -3.316604380807225e-29,  7.606499134813726e-01, -2.266761528629439e-03,
  2.315014905334018e-06,  5.728038763793852e-09, -2.133043284312098e-11, -6.410930735844894e-15,  1.745613219042913e-16, -2.397977115555106e-19, -1.127029184019016e-21,
  4.199433378267209e-24,  3.236915627867276e-27, -4.717314853655101e-29,  8.199710160786498e-01, -2.345988450061643e-03,  1.922854058754042e-06,  7.142253264560492e-09,
 -1.966503069134711e-11, -2.465426291385135e-14,  1.882938336896571e-16, -5.631345423465318e-20, -1.617756241960308e-21,  2.937959002496263e-24,  1.136060722338037e-26,
 -4.699770715797015e-29,  8.804644787680072e-01, -2.410430134646072e-03,  1.468779971326203e-06,  8.397065403147184e-09, -1.660825515199804e-11, -4.297835428529785e-14,
  1.802786683927846e-16,  1.692682498998991e-19, -1.860405575551219e-21,  5.962861155898557e-25,  1.784742374146065e-26, -2.823841210113683e-29,  9.419361156766017e-01,
 -2.458561552799405e-03,  9.605146751850682e-07,  9.418996962627214e-09, -1.221607292066406e-11, -5.949573137541789e-14,  1.480047908457627e-16,  4.034129505261893e-19,
 -1.743869052028806e-21, -2.410668260248225e-24,  1.996618534030520e-26,  6.773975585877341e-30,  1.004177648054864e+00, -2.489000475508461e-03,  4.082121578198488e-07,
  1.013845902078666e-08, -6.661004436230055e-12, -7.221682430328450e-14,  9.225203961078923e-17,  6.036883299778130e-19, -1.221558086607426e-21, -5.350164252280997e-24,
  1.583679653419362e-26,  4.767763015341347e-29,  1.066966327084634e+00, -2.500547583410566e-03, -1.755933061048161e-07,  1.049452463993879e-08, -2.364582309486614e-13,
 -7.928299535507786e-14,  1.767496335774325e-17,  7.258939264754087e-19, -3.413499662687891e-22, -7.324889878451500e-24,  5.458587225527611e-27,  7.827557402075616e-29,
  1.130064682010509e+00, -2.492229583572424e-03, -7.761478379103169e-07,  1.044003748804893e-08,  6.650226467952686e-12, -7.923541245342367e-14, -6.718466875518042e-17,
  7.335836162890827e-19,  7.434521017511802e-22, -7.535202699448265e-24, -8.715284185032056e-27,  8.252385692630453e-29,  1.193220429291451e+00, -2.463344620581894e-03,
 -1.376766216464428e-06,  9.946734748095645e-09,  1.349821600918264e-11, -7.128789278617069e-14, -1.506300172104549e-16,  6.082749442562777e-19,  1.792123230437199e-21,
 -5.587846460541053e-24, -2.209848948866601e-26,  5.260012181223529e-29,  1.256166582820706e+00, -2.413508931897241e-03, -1.959263441254989e-06,  9.009958580666400e-09,
  1.974821775379005e-11, -5.556040084763696e-14, -2.193514740882555e-16,  3.578144488694892e-19,  2.527206851364873e-21, -1.743587040644788e-24, -2.937049004808139e-26,
 -4.643387168025438e-30,  1.318621809124582e+00, -2.342703308390344e-03, -2.504539981829197e-06,  7.652436082221829e-09,  2.483157380551666e-11, -3.322255322714282e-14,
 -2.606756604606434e-16,  1.998916918831295e-20,  2.711167612673391e-21,  3.020235164890686e-24, -2.665728375312125e-26, -6.718657831178684e-29,  1.380291074391561e+00,
 -2.251317491526549e-03, -2.993322758133823e-06,  5.926541328899863e-09,  2.823064725367129e-11, -6.496894243084238e-15, -2.652069797796984e-16, -3.411073637730969e-19,
  2.229962652070268e-21,  7.221121364583941e-24, -1.365893777018602e-26, -1.057939401478730e-28,  1.440866631664895e+00, -2.140190190483242e-03, -3.407052218745464e-06,
  3.914437490953861e-09,  2.954511704670575e-11,  2.151662057512631e-14, -2.293388258806135e-16, -6.469986710336009e-19,  1.154784083279677e-21,  9.351099663654205e-24,
  5.411482584149051e-27, -9.849491568049023e-29,  1.500029395920820e+00, -2.010641969749076e-03, -3.728890854641701e-06,  1.725557352293972e-09,  2.855613701820562e-11,
  4.720833188178425e-14, -1.569713800310678e-16, -8.236685739610772e-19, -2.481298911684220e-22,  8.486565498226675e-24,  2.296449982078104e-26, -4.460030447269707e-29,
  1.557450751348044e+00, -1.864497888000878e-03, -3.944810589695806e-06, -5.089596366003583e-10,  2.527815481960542e-11,  6.699407802390844e-14, -5.977911980727935e-17,
 -8.230868410323307e-19, -1.578105206091000e-21,  4.776098300280309e-24,  3.122754227051966e-26,  3.100256708984449e-29,  1.612794828219916e+00, -1.704096523428566e-03,
 -4.044696889102239e-06, -2.644980954892328e-09,  1.998722376696128e-11,  7.794698133734664e-14,  4.441241359258835e-17, -6.408455039183849e-19, -2.424744889834441e-21,
 -4.664222073145694e-25,  2.621488982778827e-26,  8.887457440359853e-29,  1.665721275644032e+00, -1.532281971126784e-03, -4.023388102218144e-06, -4.536963519538009e-09,
  1.321560903699044e-11,  7.841041632195834e-14,  1.351394863744537e-16, -3.227793028872750e-19, -2.519332094384749e-21, -5.208497271305884e-24,  1.030053823044029e-26,
  9.761420253609068e-29,  1.715888540684618e+00, -1.352375621509192e-03, -3.881552330265000e-06, -6.051645471895291e-09,  5.705962099860581e-12,  6.844807614517731e-14,
  1.941033782233476e-16,  4.432413691138511e-20, -1.852080676743099e-21, -7.571475689028361e-24, -8.499865985610552e-27,  5.451006396559903e-29,  1.762957643676908e+00,
 -1.168125096596862e-03, -3.626294499402673e-06, -7.082576972520941e-09, -1.675538315072078e-12,  4.998953262079327e-14,  2.100763793296794e-16,  3.577059181896779e-19,
 -6.947178723207318e-22, -6.738982078832195e-24, -2.071620170917443e-26, -1.121697199595696e-29,  1.806596414228470e+00, -9.836286860438711e-04, -3.271387140833623e-06,
 -7.563764471974641e-09, -8.059446246702689e-12,  2.657459672534080e-14,  1.823830725218707e-16,  5.324520263470920e-19,  4.991393857284424e-22, -3.397352449301238e-24,
 -2.089674526084014e-26, -5.767258467858406e-29,  1.846484123253408e+00, -8.032350035163341e-04, -2.837033073600191e-06, -7.480414837764754e-09, -1.271012534379856e-11,
  2.687783180704931e-15,  1.215686260420226e-16,  5.318764289954580e-19,  1.285595902181249e-21,  6.131274628509838e-25, -1.083362040786472e-26, -5.970412627637471e-29,
  1.882316414934137e+00, -6.314193400414001e-04, -2.349098919908556e-06, -6.874760660076340e-09, -1.515555731416961e-11, -1.720998369141943e-14,  4.658960816935263e-17,
  3.812139729757236e-19,  1.428385616245448e-21,  3.313351522526181e-24,  1.916778739564965e-27, -2.576420578896539e-29,  1.913810411053374e+00, -4.726402208155962e-04,
 -1.837805062644633e-06, -5.845315665941675e-09, -1.528228336559977e-11, -2.973336868741381e-14, -2.095840354188354e-17,  1.566911517382637e-19,  9.996625006271609e-22,
  3.688910541069901e-24,  9.423679431529007e-27,  1.210903808296570e-29,  1.940709831905619e+00, -3.311817992726663e-04, -1.335917098623652e-06, -4.538677417242543e-09,
 -1.337052141455994e-11, -3.342266780728434e-14, -6.382238329243264e-17, -4.742309928720286e-20,  3.218471245398304e-22,  2.176867344048651e-24,  8.755116668428012e-27,
  2.659653220795559e-29,  1.962789958003470e+00, -2.109896994811055e-04, -8.765494182370072e-07, -3.134099466524695e-09, -1.005418844532242e-11, -2.912151361459564e-14,
 -7.477751043438791e-17, -1.599694791365156e-19, -2.237717745022044e-22,  2.011946549911382e-25,  3.190114810507978e-27,  1.604981995606312e-29,  1.979862258520786e+00,
 -1.155094105143897e-04, -4.907534433410633e-07, -1.822328993796463e-09, -6.206151848361496e-12, -1.972295084654765e-14, -5.871289939510290e-17, -1.627396194858370e-19,
 -4.121266590207277e-22, -9.096921947971597e-25, -1.510394384565090e-27, -4.158825464230208e-31,  1.991778622894898e+00, -4.753658138105846e-05, -2.051080089545492e-07,
 -7.813888119757332e-10, -2.767152845979180e-12, -9.309550298078509e-15, -3.006544362080449e-17, -9.365819743700385e-20, -2.818213477261485e-22, -8.180345284481053e-25,
 -2.280673879472554e-27, -6.054753269187766e-30,  1.998436746283522e+00, -9.079238640296584e-06, -3.951149253386315e-08, -1.526530022089431e-10, -5.520603526272230e-13,
 -1.913076414663381e-15, -6.431296107717781e-18, -2.112617806925692e-20, -6.811831041998475e-23, -2.162273964716689e-25, -6.770455299438945e-28, -2.093878325455978e-30,
  3.667266740347545e-04, -1.580513325086571e-06,  5.107920445581109e-09, -1.467083046701590e-11,  3.949294761771644e-14, -1.020297752062073e-16,  2.561739754293099e-19,
 -6.298177218557149e-22,  1.523493172461505e-24, -3.637927506479762e-27,  8.594777401225202e-30, -2.012563332681425e-32,  3.299787920700867e-03, -1.420608564631853e-05,
  4.580661067283739e-08, -1.310492576822565e-10,  3.506650031153083e-13, -8.982412407314261e-16,  2.229396968148948e-18, -5.399164756987861e-21,  1.281278788460824e-23,
 -2.987552451029744e-26,  6.855142587214505e-29, -1.549411270034568e-31,  9.161892527467720e-03, -3.935836954730693e-05,  1.263274758859541e-07, -3.585634694030139e-10,
  9.478175631449298e-13, -2.385633171867734e-15,  5.779861407072159e-18, -1.355397265834008e-20,  3.083560153513399e-23, -6.806822215327428e-26,  1.454940433062728e-28,
 -2.998108949463903e-31,  1.794497375660410e-02, -7.683959161406579e-05,  2.449258834119418e-07, -6.868617870527952e-10,  1.781793071208068e-12, -4.362588579571932e-15,
  1.016393800781856e-17, -2.256855611808973e-20,  4.757541919521846e-23, -9.421763254929892e-26,  1.712926301009863e-28, -2.708627697476739e-31,  2.963685392271768e-02,
 -1.263529714331196e-04,  3.990060316300563e-07, -1.100750453781691e-09,  2.781891133514689e-12, -6.547380592002845e-15,  1.438304578724991e-17, -2.922974656054063e-20,
  5.355511100487983e-23, -8.267657289655554e-26,  8.286199294822566e-29,  6.897018240088608e-32,  4.422115083300338e-02, -1.875026041815314e-04,  5.851467529215251e-07,
 -1.580593329823375e-09,  3.859432525828099e-12, -8.601853926575462e-15,  1.731292245853987e-17, -3.024601787931335e-20,  4.038522276622948e-23, -1.576820809162532e-26,
 -1.448208984803268e-28,  7.068988415210425e-31,  6.167715227549105e-02, -2.597933497104579e-04,  7.991366216525195e-07, -2.102843151869431e-09,  4.912376566016372e-12,
 -1.016107953524104e-14,  1.785818449115808e-17, -2.293102054345482e-20,  3.381175796923855e-24,  1.075259089806914e-25, -4.743183343197639e-28,  1.427429875407957e-30,
  8.197965791977462e-02, -3.426307686908127e-04,  1.036018957597614e-06, -2.640702310753948e-09,  5.830871083220339e-12, -1.086735468534201e-14,  1.511789582300548e-17,
 -5.864948976909094e-21, -5.628867891574831e-23,  2.663549952061528e-25, -8.002750289712671e-28,  1.845039044786675e-30,  1.050987878631859e-01, -4.353211583514282e-04,
  1.290147444454395e-06, -3.164909805499363e-09,  6.503577707474603e-12, -1.040654517053830e-14,  8.545571959176554e-18,  2.057008485544271e-20, -1.304429877809443e-22,
  4.183374680237211e-25, -9.690570094967299e-28,  1.530967915261172e-30,  1.309997569447553e-01, -5.370717535083584e-04,  1.555253196871064e-06, -3.644649191846649e-09,
  6.824575146914554e-12, -8.544424486952589e-15, -1.914313672851774e-18,  5.388095254452182e-20, -2.041287846087102e-22,  5.065208924433482e-25, -8.229680635797320e-28,
  2.073232811767130e-31,  1.596426138665205e-01, -6.469911731853403e-04,  1.824524201245208e-06, -4.048569834818483e-09,  6.700599550965290e-12, -5.160376182713941e-15,
 -1.573143176746974e-17,  8.946516445259198e-20, -2.574867678007564e-22,  4.726112385276656e-25, -2.605797908998231e-28, -2.052690602783173e-30,  1.909819441153950e-01,
 -7.640902093678371e-04,  2.090698116995669e-06, -4.345910469841167e-09,  6.058334531771423e-12, -2.756164722656101e-16, -3.175315239667983e-17,  1.209789225198867e-19,
 -2.691973889378267e-22,  2.744680861837423e-25,  7.027004360144633e-28, -4.701024453198779e-30,  2.249665356794972e-01, -8.872830724923875e-04,  2.346169445168569e-06,
 -4.507709850268636e-09,  4.851415177000783e-12,  5.927001740172821e-15, -4.824043745652947e-17,  1.410855782097009e-19, -2.211488942642727e-22, -9.572548713622184e-26,
  1.894424591004551e-27, -6.747571999972186e-30,  2.615390066136324e-01, -1.015389228273974e-03,  2.583112036329154e-06, -4.508083997308070e-09,  3.066762573758689e-12,
  1.309448398676722e-14, -6.298508936089282e-17,  1.425457168716760e-19, -1.036407925139435e-22, -5.973734225764019e-25,  2.985792612676754e-27, -6.996087552444261e-30,
  3.006353936454818e-01, -1.147135982463898e-03,  2.793617802592472e-06, -4.325543183536016e-09,  7.298212391493260e-13,  2.070910897578680e-14, -7.351048763088352e-17,
  1.195496504342795e-19,  7.985083354471503e-23, -1.136563729958629e-24,  3.547364096816485e-27, -4.466513406389088e-30,  3.421847012463592e-01, -1.281161994042602e-03,
  2.969852298515137e-06, -3.944314231529959e-09, -2.091763952191302e-12,  2.810986987370412e-14, -7.734907222318391e-17,  6.913075052299672e-20,  3.095021799866645e-22,
 -1.574648422682990e-24,  3.160856604619081e-27,  1.094383552937135e-30,  3.861084109414338e-01, -1.416021922958104e-03,  3.104227517595516e-06, -3.355625026589817e-09,
 -5.286516018693692e-12,  3.453123081239132e-14, -7.237924761262796e-17, -7.557963245126254e-21,  5.487291219758413e-22, -1.752418678687986e-24,  1.569832402215678e-27,
  8.788378920144356e-30,  4.323199511317676e-01, -1.550192445370045e-03,  3.189591786537464e-06, -2.558898469967304e-09, -8.700022728525879e-12,  3.915932066683723e-14,
 -5.719268691300235e-17, -1.043605530253843e-19,  7.474677365098584e-22, -1.528462710901186e-24, -1.167706557186911e-27,  1.644074892532275e-29,  4.807241283769044e-01,
 -1.682079896699974e-03,  3.219435995915930e-06, -1.562792737480151e-09, -1.213881198020125e-11,  4.120414569714942e-14, -3.145123530522790e-17, -2.098941474405168e-19,
  8.495715345925821e-22, -8.258203942902881e-25, -4.577268975265381e-27,  2.095808721753255e-29,  5.312165219796690e-01, -1.810029829470977e-03,  3.188114548675853e-06,
 -3.860141745795942e-10, -1.537757853717103e-11,  3.998449584436303e-14,  3.817730119302898e-18, -3.082166731311381e-19,  8.039555191951997e-22,  3.235426128422060e-25,
 -7.772791698483540e-27,  1.923123073581974e-29,  5.836828448670780e-01, -1.932338797282715e-03,  3.091078301797725e-06,  9.421807483492920e-10, -1.817000199179925e-11,
  3.502000530484394e-14,  4.604548167135743e-17, -3.805310957290462e-19,  5.781046554566993e-22,  1.750359134312024e-24, -9.610586001712561e-27,  9.439600725195991e-30,
  6.379982752203338e-01, -2.047268696004474e-03,  2.925115389185824e-06,  2.381886125683501e-09, -2.026319489023141e-11,  2.612243883246479e-14,  9.112451542453877e-17,
 -4.079225839727262e-19,  1.714814644814532e-22,  3.150423141621057e-24, -8.997947481218055e-27, -7.631501554784033e-30,  6.940267651241450e-01, -2.153064005279901e-03,
  2.688594121124377e-06,  3.882946435635381e-09, -2.141554095010198e-11,  1.347593942598275e-14,  1.336404577867552e-16, -3.749193367488015e-19, -3.745419538970957e-22,
  4.128798171490500e-24, -5.306215746807724e-27, -2.784234084130072e-29,  7.516203347344013e-01, -2.247972273681194e-03,  2.381700148669143e-06,  5.385951362952660e-09,
 -2.141732106800437e-11, -2.305965895025421e-15,  1.673649591225755e-16, -2.734227940368586e-19, -9.740117430218450e-22,  4.288232244696272e-24,  1.225266988429815e-27,
 -4.412264402837373e-29,  8.106183631558181e-01, -2.330268174205598e-03,  2.006657776806642e-06,  6.823912986524577e-09, -2.011308295527574e-11, -2.015988126938162e-14,
  1.860088041054902e-16, -1.063057633465772e-19, -1.504313323608233e-21,  3.350508951781490e-24,  9.256582968970041e-27, -4.841417710615464e-29,  8.708468904241693e-01,
 -2.398281416973780e-03,  1.567922763564946e-06,  8.124693358118234e-09, -1.742420612224940e-11, -3.860149464007083e-14,  1.841889124222139e-16,  1.102139591407906e-19,
 -1.826407471286186e-21,  1.283275588034057e-24,  1.645344946083723e-26, -3.490941017951303e-29,  9.321179487353770e-01, -2.450428735476565e-03,  1.072331263944082e-06,
  9.214217203193182e-09, -1.336958436739625e-11, -5.581445014087078e-14,  1.585071549917672e-16,  3.463751324204696e-19, -1.816233803335666e-21, -1.609148184532832e-24,
  2.003423113888502e-26, -3.599245368157715e-30,  9.942289453687111e-01, -2.485250052965923e-03,  5.291869517189348e-07,  1.002045421998585e-08, -8.081854835104917e-12,
 -6.980452672617714e-14,  1.085799943079563e-16,  5.616429659008054e-19, -1.402282492468260e-21, -4.677665672453037e-24,  1.771407557306325e-26,  3.751547859751385e-29,
  1.056962124592514e+00, -2.501448777319530e-03, -4.973394371189375e-08,  1.047808596233804e-08, -1.816237226499040e-12, -7.861637217976205e-14,  3.780776530170873e-17,
  7.108003924024791e-19, -6.002974592634453e-22, -7.038975758619984e-24,  8.800901918721034e-27,  7.330627105679162e-29,  1.120084141147887e+00, -2.497935956586839e-03,
 -6.502815262817092e-07,  1.053368286558541e-08,  5.051070487829022e-12, -8.059892496473514e-14, -4.635247961768365e-17,  7.529737096336559e-19,  4.667972334796772e-22,
 -7.809870760082396e-24, -4.989746768369316e-27,  8.641713798353257e-29,  1.183345783540383e+00, -2.473877745135466e-03, -1.256157240923036e-06,  1.015110962478079e-08,
  1.203771919750338e-11, -7.469234435745752e-14, -1.328268779308493e-16,  6.622384459967620e-19,  1.575642688614677e-21, -6.421665750183393e-24, -1.950018869545602e-26,
  6.526346672162623e-29,  1.246481891104562e+00, -2.428745276192758e-03, -1.849285696086345e-06,  9.316757936250331e-09,  1.858522385901042e-11, -6.069553830070958e-14,
 -2.082115345940269e-16,  4.374539105319520e-19,  2.443285651899981e-21, -2.917659291307797e-24, -2.921238549673711e-26,  1.192488199794547e-29,  1.309211514302421e+00,
 -2.362365609830016e-03, -2.410349944789117e-06,  8.044086101420397e-09,  2.410465698327733e-11, -3.946215616722207e-14, -2.588865148295185e-16,  1.082748158312790e-19,
  2.800021667347792e-21,  1.898292375446082e-24, -2.934919359246274e-26, -5.474299189772833e-29,  1.371238372503165e+00, -2.274971933009415e-03, -2.919499536752174e-06,
  6.376843252745823e-09,  2.803632874055177e-11, -1.296817407911572e-14, -2.737206865073506e-16, -2.657037428744503e-19,  2.478967348899632e-21,  6.581777396128847e-24,
 -1.829959536816713e-26, -1.046001895317349e-28,  1.432251666950671e+00, -2.167250648229760e-03, -3.357229422015316e-06,  4.390296884859052e-09,  2.991896365233143e-11,
  1.579958523442820e-14, -2.468865895711661e-16, -6.046262648103428e-19,  1.494242546477502e-21,  9.477291085463427e-24,  8.126533964891352e-28, -1.102148061728145e-28,
  1.491927307988947e+00, -2.040382432176210e-03, -3.705412304264605e-06,  2.189796333216338e-09,  2.946075902794647e-11,  4.316365741691932e-14, -1.800980928754634e-16,
 -8.265473489093359e-19,  7.339805893249905e-23,  9.360405199564565e-24,  2.059024801837259e-26, -6.343346528526643e-29,  1.549929613986055e+00, -1.896073825837652e-03,
 -3.948447460540502e-06, -9.387599530728280e-11,  2.660179384450849e-11,  6.527728309412796e-14, -8.350496126714817e-17, -8.705916837223294e-19, -1.383391905481316e-21,
  6.048176675286172e-24,  3.226448831281146e-26,  1.564183857344058e-29,  1.605913533789160e+00, -1.736575502277610e-03, -4.074466271523296e-06, -2.312662202539210e-09,
  2.155532358285639e-11,  7.878877920596753e-14,  2.538141649916806e-17, -7.184960065594168e-19, -2.421724499727347e-21,  6.597284355489108e-25,  3.007076659669357e-26,
  8.586356925837033e-29,  1.659527433974013e+00, -1.564683135235004e-03, -4.076510653076552e-06, -4.312795125390284e-09,  1.481547097124620e-11,  8.153603004342286e-14,
  1.249454332601541e-16, -4.063099138608412e-19, -2.698357809214477e-21, -4.707439334861465e-24,  1.482786350319648e-26,  1.079710286608443e-28,  1.710416475766574e+00,
 -1.383716861425158e-03, -3.953578307087406e-06, -5.949144977079795e-09,  7.121573272082108e-12,  7.311449892639364e-14,  1.944733057642431e-16, -1.936426963283208e-20,
 -2.130154072153167e-21, -7.858911535876677e-24, -5.755800080759121e-27,  7.044995401956466e-29,  1.758226583761715e+00, -1.197475794252616e-03, -3.711412385107547e-06,
 -7.101109963506458e-09, -6.245320096217592e-13,  5.514881290930516e-14,  2.197432950931586e-16,  3.314325706385297e-19, -9.523293854017685e-22, -7.574560079623654e-24,
 -2.098533025087519e-26, -5.903591311638817e-31,  1.802608979404347e+00, -1.010164994070745e-03, -3.362907697792028e-06, -7.688220749008833e-09, -7.482965946637082e-12,
  3.113238033429235e-14,  1.974957782382404e-16,  5.463013076377009e-19,  3.611749244788472e-22, -4.284233187401702e-24, -2.345089408206119e-26, -5.816018514628787e-29,
  1.843225217324664e+00, -8.262937800306028e-04, -2.928015922206584e-06, -7.683183125138119e-09, -1.262596281373830e-11,  5.788806675609525e-15,  1.370398044998580e-16,
  5.732797386170726e-19,  1.299212827986392e-21,  1.247829618695975e-25, -1.364509828974738e-26, -6.814400474962608e-29,  1.879752623655740e+00, -6.505462679700097e-04,
 -2.433062132983439e-06, -7.119938698146321e-09, -1.548768372563415e-11, -1.595846947105701e-14,  5.792154002251707e-17,  4.288432482681602e-19,  1.548752489218135e-21,
  3.365062221157863e-24,  6.097022706889250e-28, -3.387441015024543e-29,  1.911889995116922e+00, -4.876274386143984e-04, -1.909435658154774e-06, -6.094615310208456e-09,
 -1.588160616870715e-11, -3.017998203167836e-14, -1.610271354954838e-17,  1.908789251562681e-19,  1.139371788932416e-21,  4.075958312391723e-24,  9.913378207063759e-27,
  1.000075181767279e-29,  1.939363379893523e+00, -3.420906807048193e-04, -1.391687127413953e-06, -4.758037040690774e-09, -1.405439336734211e-11, -3.496910048306260e-14,
 -6.499376596931976e-17, -3.580018712033762e-20,  4.068076918748301e-22,  2.551316489655621e-24,  9.988316294917575e-27,  2.947559671538908e-29,  1.961931732303319e+00,
 -2.181553112464873e-04, -9.151433541812097e-07, -3.299724971074302e-09, -1.065493228102466e-11, -3.097072516054782e-14, -7.935563289887581e-17, -1.669882264364462e-19,
 -2.140536856446992e-22,  3.438092657905401e-25,  3.963425692583065e-27,  1.918271088340994e-29,  1.979392227903308e+00, -1.195246284102262e-04, -5.132304512934887e-07,
 -1.924861233610622e-09, -6.615078886356343e-12, -2.118826187175749e-14, -6.345924802743376e-17, -1.764633410546692e-19, -4.459658953424185e-22, -9.702981010244975e-25,
 -1.515202918317268e-27,  2.298948306301723e-31,  1.991585134374111e+00, -4.921571919097704e-05, -2.147565951522483e-07, -8.271929012125501e-10, -2.960777359684156e-12,
 -1.006363701903644e-14, -3.281868492583609e-17, -1.031658093463646e-19, -3.129788647007156e-22, -9.148088155550173e-25, -2.563621647509749e-27, -6.821190842624494e-30,
  1.998399785327557e+00, -9.402811048468356e-06, -4.139761671085793e-08, -1.618006521341529e-10, -5.919146103702222e-13, -2.074779616912682e-15, -7.054554654988316e-18,
 -2.343592354756772e-20, -7.641302384312761e-23, -2.452460027477047e-25, -7.763079811662198e-28, -2.426723540393484e-30,  3.604852474419443e-04, -1.540343572246910e-06,
  4.935595529227891e-09, -1.405493991658062e-11,  3.751243340713067e-14, -9.608782828109873e-17,  2.392023789101889e-19, -5.830967282590914e-22,  1.398508480345585e-24,
 -3.311205869773408e-27,  7.756708970528048e-30, -1.801007955436052e-32,  3.243686657021546e-03, -1.384582909111481e-05,  4.426709986023939e-08, -1.255794796763257e-10,
  3.332232235634967e-13, -8.465044769967917e-16,  2.083802494832267e-18, -5.005847678581724e-21,  1.178502639865190e-23, -2.726507864664723e-26,  6.208485361842940e-29,
 -1.392874219764601e-31,  9.006453397311039e-03, -3.836470655820147e-05,  1.221141542876217e-07, -3.437726798173057e-10,  9.014618928269856e-13, -2.251361356069677e-15,
  5.413803997870266e-18, -1.260534280297470e-20,  2.848679654336536e-23, -6.250415057048364e-26,  1.329063215015160e-28, -2.727883219281180e-31,  1.764148267835971e-02,
 -7.491267581091342e-05,  2.368517571464666e-07, -6.590380701083004e-10,  1.696930335213618e-12, -4.126068156873688e-15,  9.552831612708175e-18, -2.109911272887163e-20,
  4.430408301016157e-23, -8.759988048551539e-26,  1.597039377599865e-28, -2.559052643529994e-31,  2.913774353173387e-02, -1.232130123590052e-04,  3.860598264642748e-07,
 -1.057269295866570e-09,  2.654330148849726e-12, -6.211817759818906e-15,  1.358816271982019e-17, -2.756295968293145e-20,  5.063905581325355e-23, -7.931125112568101e-26,
  8.517217510019724e-29,  3.711014769144374e-32,  4.348038410419793e-02, -1.828962618019055e-04,  5.665445336118669e-07, -1.520196415309378e-09,  3.691482703070532e-12,
 -8.196360979626184e-15,  1.648403357237174e-17, -2.896383229097702e-20,  3.972050836442605e-23, -2.096994245669511e-26, -1.160067949775473e-28,  6.051351817291256e-31,
  6.065060711269517e-02, -2.534998723367307e-04,  7.743674605050472e-07, -2.025847830505036e-09,  4.713389009933037e-12, -9.740172255209185e-15,  1.721818720387092e-17,
 -2.276442974550776e-20,  6.925301466190521e-24,  8.976184344262388e-26, -4.150306402419761e-28,  1.270106415407721e-30,  8.062551267239461e-02, -3.344678011346053e-04,
  1.004883184735324e-06, -2.549127495820825e-09,  5.617137967689604e-12, -1.050669070527564e-14,  1.492985829636977e-17, -7.518788185827088e-21, -4.725693175974013e-23,
  2.359238453874529e-25, -7.223547819375212e-28,  1.697827395582951e-30,  1.033779075323577e-01, -4.251501412379328e-04,  1.252786038540027e-06, -3.062506278464500e-09,
  6.297542014655171e-12, -1.019499792548595e-14,  9.065307343063757e-18,  1.662952182097185e-20, -1.160643952702289e-22,  3.809145364069288e-25, -9.023164654768275e-28,
  1.499890034968588e-30,  1.288760795920297e-01, -5.248028278114084e-04,  1.512166919746836e-06, -3.536825093798540e-09,  6.653345679808499e-12, -8.572985522456480e-15,
 -4.944005808897102e-19,  4.763425563812119e-20, -1.864838217379359e-22,  4.738442584439539e-25, -8.094735787289995e-28,  3.982977081136458e-31,  1.570835364322176e-01,
 -6.325874963372594e-04,  1.776581150773712e-06, -3.942205580821398e-09,  6.593814645203424e-12, -5.508785677228711e-15, -1.333921878658315e-17,  8.149563207508254e-20,
 -2.406808665958451e-22,  4.605213641902030e-25, -3.405811046769036e-28, -1.594986803221879e-30,  1.879587064841160e-01, -7.475715809497340e-04,  2.039128478545441e-06,
 -4.249061487753925e-09,  6.045470834603912e-12, -9.980073155200081e-16, -2.848482118379566e-17,  1.125277317294850e-19, -2.588586562738583e-22,  2.986345920361350e-25,
  5.103506984280252e-28, -4.052160865663079e-30,  2.214546013890162e-01, -8.687287588119644e-04,  2.292546374511084e-06, -4.429200463976756e-09,  4.958693344421829e-12,
  4.815833645579932e-15, -4.438953307812605e-17,  1.339677309057994e-19, -2.233009110115931e-22, -2.570348714109328e-26,  1.611183352363091e-27, -6.128807266752988e-30,
  2.575184380819482e-01, -9.949398664790769e-04,  2.529317817570081e-06, -4.457001461200313e-09,  3.313857107524815e-12,  1.163034337610804e-14, -5.904331247785722e-17,
  1.389075767269740e-19, -1.230700210561713e-22, -4.840278790918260e-25,  2.683370081878560e-27, -6.737569308980129e-30,  2.960912191801605e-01, -1.124994436743856e-03,
  2.741794707853816e-06, -4.310647301116563e-09,  1.126633375595097e-12,  1.898527785857137e-14, -7.013328235035808e-17,  1.214772090392502e-19,  4.143998461195377e-23,
 -9.987392536025419e-25,  3.340726934461948e-27, -4.897078999644398e-30,  3.371072703913569e-01, -1.257593029622342e-03,  2.922337946034255e-06, -3.973385061177907e-09,
 -1.547967978619423e-12,  2.627778772761009e-14, -7.528310182822114e-17,  7.815229484516028e-20,  2.550986352486155e-22, -1.447645685710427e-24,  3.179937060158810e-27,
 -1.887015216158762e-31,  3.804937339007866e-01, -1.391350558876914e-03,  3.063474996508755e-06, -3.434778705493641e-09, -4.613269554411719e-12,  3.279351575743883e-14,
 -7.235443341876968e-17,  9.004815146244102e-21,  4.868600872864171e-22, -1.682485647765777e-24,  1.912464722332273e-27,  6.817692476937142e-30,  4.261700170796388e-01,
 -1.524800845577592e-03,  3.158075403686655e-06, -2.691908867119979e-09, -7.930785497920027e-12,  3.775428274771866e-14, -5.978824514835540e-17, -8.132961657097069e-20,
  6.917710628478640e-22, -1.561318415774946e-24, -4.902635722645636e-28,  1.435663035974796e-29,  4.740471964147129e-01, -1.656402662186755e-03,  3.199544213674702e-06,
 -1.750464021549074e-09, -1.132273764689290e-11,  4.038183497777009e-14, -3.695237431659544e-17, -1.832170850757059e-19,  8.167653272351376e-22, -9.908317147344320e-25,
 -3.682738993356813e-27,  1.966291999997055e-29,  5.240273773326486e-01, -1.784547563668890e-03,  3.182032529043512e-06, -6.256558153226623e-10, -1.457765633815965e-11,
  3.997547632636719e-14, -4.450831817453927e-18, -2.823620760494305e-19,  8.102121639750876e-22,  2.972197737253572e-26, -6.915023222319618e-27,  1.967405257480158e-29,
  5.760030116298818e-01, -1.907569834830279e-03,  3.100663448480056e-06,  6.571203763102996e-10, -1.745940297352580e-11,  3.599938443565516e-14,  3.565855081529209e-17,
 -3.610968692974024e-19,  6.343059030919634e-22,  1.375094844797234e-24, -9.132689924054688e-27,  1.217750485878855e-29,  6.298561755781199e-01, -2.023758913487081e-03,
  2.951770371122999e-06,  2.061969553071585e-09, -1.971979775804640e-11,  2.817308758892263e-14,  7.979605823388358e-17, -4.006905679104289e-19,  2.783503585068636e-22,
  2.785222347480585e-24, -9.227498691132175e-27, -2.882888155873045e-30,  6.854578135177350e-01, -2.131374674311317e-03,  2.733143035230857e-06,  3.542624606044604e-09,
 -2.111480519092449e-11,  1.655611899021944e-14,  1.229969611526100e-16, -3.845697566383084e-19, -2.300064663816379e-22,  3.893637597658700e-24, -6.412470055579793e-27,
 -2.244307186369170e-29,  7.426669539472563e-01, -2.228665974438077e-03,  2.444274679953324e-06,  5.043120850707144e-09, -2.142391051470199e-11,  1.615543927734000e-15,
  1.592960172963566e-16, -3.021154229704623e-19, -8.192113650547106e-22,  4.299490470950249e-24, -6.344935502871796e-28, -4.030020654317822e-29,  8.013299078389658e-01,
 -2.313892863998925e-03,  2.086601353863132e-06,  6.499119525273724e-09, -2.047190719984048e-11, -1.573671440144445e-14,  1.823769286195966e-16, -1.524466114557289e-19,
 -1.377544909001861e-21,  3.678047214747653e-24,  7.119643145128017e-27, -4.851038945086203e-29,  8.612794622309053e-01, -2.385352846077231e-03,  1.663721663684270e-06,
  7.839970934370417e-09, -1.815181464527712e-11, -3.415048598920588e-14,  1.864645055124750e-16,  5.263200127899763e-20, -1.768748603353626e-21,  1.909026117735023e-24,
  1.479530466333598e-26, -4.023192528037937e-29,  9.223340861301398e-01, -2.441411522945410e-03,  1.181582231004346e-06,  8.991583413325474e-09, -1.444708022302934e-11,
 -5.190051188602962e-14,  1.673843772701843e-16,  2.874829600373244e-19, -1.859803344186608e-21, -8.138666503601163e-25,  1.965894045924096e-26, -1.333027950108640e-29,
  9.842971704604657e-01, -2.480537878970950e-03,  6.486109463344490e-07,  9.880122660330632e-09, -9.450639212830000e-12, -6.701511611189311e-14,  1.236534520318972e-16,
  5.142153844403615e-19, -1.557555102450048e-21, -3.939236809682634e-24,  1.912857980195049e-26,  2.670391770948960e-29,  1.046956329220131e+00, -2.501344313902710e-03,
  7.577702034561554e-08,  1.043650357328450e-08, -3.377890913740441e-12, -7.747255911747454e-14,  5.740366848955641e-17,  6.876105642794493e-19, -8.466036988326394e-22,
 -6.624334806098005e-24,  1.188068244442309e-26,  6.638207477261143e-29,  1.110082795154656e+00, -2.502631340995736e-03, -5.234458005590325e-07,  1.060155091710150e-08,
  3.429682754475928e-12, -8.145695835016741e-14, -2.510258896914685e-17,  7.633816913584957e-19,  1.829713974433518e-22, -7.932816344083470e-24, -1.147279743986128e-27,
  8.782421777362872e-29,  1.173430949999740e+00, -2.483436590167205e-03, -1.133238144923884e-06,  1.033159555482250e-08,  1.051352433645779e-11, -7.765219863561161e-14,
 -1.136141073250338e-16,  7.088154120671923e-19,  1.331145540962433e-21, -7.140873687490967e-24, -1.638022574048894e-26,  7.623843556214451e-29,  1.236738036515153e+00,
 -2.443087396199489e-03, -1.735741346142860e-06,  9.604143046215048e-09,  1.732237968917343e-11, -6.553690078109189e-14, -1.948856239463943e-16,  5.137342830820112e-19,
  2.317388605024055e-21, -4.070700480468682e-24, -2.831683401278741e-26,  2.878128451468647e-29,  1.299724106788878e+00, -2.381255798958665e-03, -2.311533999804833e-06,
  8.423110293813444e-09,  2.325357922855203e-11, -4.562887237456236e-14, -2.545917781684230e-16,  1.987378875814229e-19,  2.846686378823630e-21,  6.803681842256330e-25,
 -3.143850539843819e-26, -3.985081589347421e-29,  1.362092268155653e+00, -2.298014236988363e-03, -2.840295651868447e-06,  6.822990307491344e-09,  2.771071691500829e-11,
 -1.961756940337310e-14, -2.800152524129509e-16, -1.827358980537913e-19,  2.701636024157911e-21,  5.758846422667165e-24, -2.281345624294800e-26, -9.999905686547097e-29,
  1.423529293867438e+00, -2.193889589501717e-03, -3.301664269493799e-06,  4.871200642026109e-09,  3.017436054538591e-11,  9.676871079469254e-15, -2.630954243288688e-16,
 -5.513549761073943e-19,  1.834814151612607e-21,  9.409849351864426e-24, -4.253344595277701e-27, -1.196242298428593e-28,  1.483706669485358e+00, -2.069912543015941e-03,
 -3.676278809599618e-06,  2.667831955023516e-09,  3.027893673779136e-11,  3.856416559223626e-14, -2.031567777941823e-16, -8.186538580471557e-19,  4.244735739783518e-22,
  1.012254629131043e-23,  1.737687632277695e-26, -8.263464211807848e-29,  1.542282146733722e+00, -1.927658577409313e-03, -3.946977492849912e-06,  3.420798056638290e-10,
  2.788529884718010e-11,  6.297585299238884e-14, -1.084667731142196e-16, -9.111263523228917e-19, -1.142307949980743e-21,  7.347351780402065e-24,  3.256128399139489e-26,
 -2.612758571143576e-30,  1.598901872992743e+00, -1.769276257248126e-03, -4.100096818152432e-06, -1.955144720439160e-09,  2.313551602474164e-11,  7.914779201423711e-14,
  4.183863636611865e-18, -7.953717436287487e-19, -2.375427231522243e-21,  1.936486394905710e-24,  3.372025047763294e-26,  7.942036663202204e-29,  1.653203155344043e+00,
 -1.597498079844151e-03, -4.126787578814467e-06, -4.062542941776517e-09,  1.647520588947364e-11,  8.438829078628389e-14,  1.123352854757356e-16, -4.952449196343672e-19,
 -2.855979584468662e-21, -4.016583856729744e-24,  1.977909742214463e-26,  1.167726705355647e-28,  1.704817901816221e+00, -1.415628996992701e-03, -4.024235299598347e-06,
 -5.823248217996959e-09,  8.630452002891881e-12,  7.776738638112079e-14,  1.929339845336897e-16, -9.209400820631151e-20, -2.416426834217862e-21, -8.022169957086829e-24,
 -2.281971440002635e-27,  8.762662853242187e-29,  1.753376758175247e+00, -1.227508030781169e-03, -3.796648324865424e-06, -7.101989030338396e-09,  5.319154410438853e-13,
  6.053031196267971e-14,  2.285546157301974e-16,  2.964332448563972e-19, -1.240095743557880e-21, -8.410774120895432e-24, -2.072834531235019e-26,  1.273447468836645e-29,
  1.798513925791192e+00, -1.037439276595459e-03, -3.455863315654984e-06, -7.802704266411283e-09, -6.811674220888140e-12,  3.605699315279595e-14,  2.129295152752498e-16,
  5.552051525653532e-19,  1.894431546690345e-22, -5.273202126332788e-24, -2.598777987671685e-26, -5.681044126407307e-29,  1.839872605192596e+00, -8.500901244727213e-04,
 -3.021421797554161e-06, -7.884088079025052e-09, -1.247597264558781e-11,  9.275082165975375e-15,  1.536735741133162e-16,  6.148150673910684e-19,  1.293134839773634e-21,
 -4.835270691022983e-25, -1.683344326259485e-26, -7.679490395668032e-29,  1.877110962495783e+00, -6.703567584868409e-04, -2.519998491527373e-06, -7.370215278405704e-09,
 -1.579194991050578e-11, -1.441854886150115e-14,  7.064121969663649e-17,  4.803432356857652e-19,  1.669950106970366e-21,  3.356939807338347e-24, -1.085326346736777e-27,
 -4.341905081025048e-29,  1.909908465041992e+00, -5.031998312120705e-04, -1.984115657728053e-06, -6.353568910917585e-09, -1.648861566923338e-11, -3.049805353035105e-14,
 -1.022505561698347e-17,  2.297639177257033e-19,  1.293342477421223e-21,  4.480455922868823e-24,  1.028876777534575e-26,  6.875357627287671e-30,  1.937972383098190e+00,
 -3.534564400023206e-04, -1.450156148670591e-06, -4.988587455754431e-09, -1.476944710285921e-11, -3.653942102497001e-14, -6.579954893372113e-17, -2.123308431633704e-20,
  5.061671135311179e-22,  2.977653932767641e-24,  1.135007416481313e-26,  3.242874160150686e-29,  1.961044213831152e+00, -2.256377907758806e-04, -9.557837075867574e-07,
 -3.475264286837542e-09, -1.129377481301444e-11, -3.293212983991762e-14, -8.412511058498131e-17, -1.736076003095752e-19, -1.986100940796879e-22,  5.202649031805312e-25,
  4.886046254370762e-27,  2.284844282012635e-29,  1.978905768829654e+00, -1.237246974134889e-04, -5.369780906355221e-07, -2.034177077912444e-09, -7.054483034870407e-12,
 -2.277222081314837e-14, -6.860534876572891e-17, -1.913048050999345e-19, -4.819830020113552e-22, -1.030466225565420e-24, -1.486883610782017e-27,  1.098505908604367e-30,
  1.991384771367702e+00, -5.097429812262333e-05, -2.249739279533150e-07, -8.762193193521161e-10, -3.170166545207023e-12, -1.088711205335644e-14, -3.585263763770149e-17,
 -1.137284557042349e-19, -3.478323493411474e-22, -1.023602365605438e-24, -2.882318910821944e-27, -7.681257025799925e-30,  1.998361499193116e+00, -9.741922628791120e-06,
 -4.339744811386379e-08, -1.716126779657906e-10, -6.351579119221666e-13, -2.252248085859891e-15, -7.746364789958408e-18, -2.602861047955428e-20, -8.582755157676637e-23,
 -2.785441817204207e-25, -8.914414228048001e-28, -2.816885825791477e-30,  3.544017887207246e-04, -1.501523385801367e-06,  4.770475021308661e-09, -1.346980857617874e-11,
  3.564678862467261e-14, -9.053794272206491e-17,  2.234847001929956e-19, -5.401933453203597e-22,  1.284704130890850e-24, -3.016217366696082e-27,  7.006392013819611e-30,
 -1.613194204660773e-32,  3.189002196497671e-03, -1.349763073980690e-05,  4.279158551422101e-08, -1.203806784376082e-10,  3.167821098111947e-13, -7.981334573871120e-16,
  1.948774242029821e-18, -4.643963956333983e-21,  1.084674636940428e-23, -2.490002866484676e-26,  5.626942111252997e-29, -1.253106445170271e-31,  8.854922612529867e-03,
 -3.740405259168874e-05,  1.180739591174522e-07, -3.297025659245295e-10,  8.577059134177705e-13, -2.125564490074198e-15,  5.073285393157039e-18, -1.172876469884820e-20,
  2.632951466146487e-23, -5.742055742336900e-26,  1.214520069162695e-28, -2.482532125923606e-31,  1.734557215979042e-02, -7.304904020773337e-05,  2.291035222215523e-07,
 -6.325350967757551e-10,  1.616654614623772e-12, -3.903732166864782e-15,  8.981439258766018e-18, -1.973062845138195e-20,  4.126280039184619e-23, -8.143254459266329e-26,
  1.487707155989531e-28, -2.410988063570002e-31,  2.865098909401253e-02, -1.201745700238256e-04,  3.736233674957328e-07, -1.015776444500916e-09,  2.533293375146804e-12,
 -5.894782512802111e-15,  1.283866161717892e-17, -2.598753294222779e-20,  4.784549453449119e-23, -7.587972391799292e-26,  8.621582465609750e-29,  1.123338538441188e-32,
  4.275774963587865e-02, -1.784358831978246e-04,  5.486512182507536e-07, -1.462422887798075e-09,  3.531446700788025e-12, -7.810333120484503e-15,  1.569072147522607e-17,
 -2.770569983514030e-20,  3.888823504730092e-23, -2.510468334501723e-26, -9.137572008729464e-29,  5.164872682129810e-31,  5.964884532888573e-02, -2.474009059670072e-04,
  7.505034155088921e-07, -1.951969797620531e-09,  4.522666441712967e-12, -9.334556694875794e-15,  1.658434927424653e-17, -2.249421458840159e-20,  9.870981905103502e-24,
  7.423546363651148e-26, -3.623218478360348e-28,  1.128188185965866e-30,  7.930352800120673e-02, -3.265495817590466e-04,  9.748260284754647e-07, -2.460914964870053e-09,
  5.410569416413550e-12, -1.015106364809179e-14,  1.469939901713418e-17, -8.900550839486535e-21, -3.926614704532517e-23,  2.084818846237705e-25, -6.507662272877176e-28,
  1.557385293391495e-30,  1.016971211914685e-01, -4.152731557183906e-04,  1.216633837239828e-06, -2.963364833815108e-09,  6.095853329523481e-12, -9.972250293896403e-15,
  9.480949695020506e-18,  1.312803041489664e-20, -1.029853477397372e-22,  3.461292086742918e-25, -8.372845245916782e-28,  1.454011062572239e-30,  1.268007966904947e-01,
 -5.128734633808348e-04,  1.470358080758015e-06, -3.431743443757661e-09,  6.481871928777248e-12, -8.569504812567076e-15,  7.583339290692901e-19,  4.193349560889944e-20,
 -1.700035987203415e-22,  4.418621483355826e-25, -7.885583938679418e-28,  5.457998864395007e-31,  1.545813146585043e-01, -6.185622879639408e-04,  1.729903999948986e-06,
 -3.837602586171882e-09,  6.480617918052026e-12, -5.802399476227392e-15, -1.116269327986354e-17,  7.405634536879464e-20, -2.243631274795187e-22,  4.456146358992095e-25,
 -4.018949169801636e-28, -1.202150211370907e-30,  1.850007256064639e-01, -7.314608654577596e-04,  1.988719329774616e-06, -4.152529725225338e-09,  6.018924749194222e-12,
 -1.644759672765850e-15, -2.544837104041460e-17,  1.044198701279118e-19, -2.477817030058195e-22,  3.156602906535215e-25,  3.452208369742365e-28, -3.463585287440844e-30,
  2.180160323898483e-01, -8.505996337232851e-04,  2.239874997903028e-06, -4.349147460194799e-09,  5.044656193110808e-12,  3.794690130031641e-15, -4.073852885089883e-17,
  1.268192181474837e-19, -2.231295426124889e-22,  3.352944071973581e-26,  1.354855888923061e-27, -5.525801732183559e-30,  2.535788102642081e-01, -9.749183414550815e-04,
  2.476159360539231e-06, -4.402194570824560e-09,  3.532606256831669e-12,  1.025951642689302e-14, -5.521151089721041e-17,  1.347106771511424e-19, -1.386336166814345e-22,
 -3.825304947615164e-25,  2.393871773512984e-27, -6.412117877881107e-30,  2.916347830092481e-01, -1.103266655437997e-03,  2.690187334250321e-06, -4.289673817707398e-09,
  1.489783092089105e-12,  1.734301296084841e-14, -6.671857915621453e-17,  1.222533780973623e-19,  7.837928881662939e-24, -8.695094013828701e-25,  3.118816309730987e-27,
 -5.165134353803025e-30,  3.321233531601815e-01, -1.234405430276097e-03,  2.874525747789771e-06, -3.994045511966726e-09, -1.040298352967767e-12,  2.449812761389570e-14,
 -7.298821321094456e-17,  8.550612023293035e-20,  2.052679353298902e-22, -1.320941640998340e-24,  3.147552940312948e-27, -1.247893312617882e-30,  3.749770845154927e-01,
 -1.367008833858318e-03,  3.021836116569807e-06, -3.503438289336652e-09, -3.974735017446863e-12,  3.106174003493432e-14, -7.189318238693405e-17,  2.363054480225034e-20,
  4.277349627166942e-22, -1.600523983441513e-24,  2.172702093765364e-27,  5.044331927894453e-30,  4.201211353483089e-01, -1.499667554271055e-03,  3.125035805145817e-06,
 -2.812839443639041e-09, -7.190220770339682e-12,  3.629448751606554e-14, -6.176403083730789e-17, -6.009484744549018e-20,  6.353573411299796e-22, -1.568898994281918e-24,
  9.641131630054572e-29,  1.232199241094119e-29,  4.674726411707083e-01, -1.630893349476149e-03,  3.177478153887396e-06, -1.925216607721936e-09, -1.052436993324209e-11,
  3.943633654295312e-14, -4.172209723431480e-17, -1.576780775483287e-19,  7.786484398162013e-22, -1.121266456783570e-24, -2.849914183738093e-27,  1.816523385515047e-29,
  5.169400465308230e-01, -1.759125239326316e-03,  3.173151562047312e-06, -8.525106797892337e-10, -1.377984026983240e-11,  3.977671155441839e-14, -1.199420482726289e-17,
 -2.564698557069590e-19,  8.065122268247840e-22, -2.295430568418699e-25, -6.048463910155581e-27,  1.964290560216894e-29,  5.684223862149769e-01, -1.882737679417718e-03,
  3.106896691233481e-06,  3.835729331783173e-10, -1.673166416139934e-11,  3.673619800445280e-14,  2.583895314108159e-17, -3.400764413640576e-19,  6.773690549633266e-22,
  1.021169516535250e-24, -8.548195802341371e-27,  1.428985815003877e-29,  6.218085174446808e-01, -2.000051096284275e-03,  2.974639826094812e-06,  1.751060741712622e-09,
 -1.913808813282856e-11,  2.995465756668362e-14,  6.871598798043268e-17, -3.902504751065236e-19,  3.719557639111926e-22,  2.414870569962071e-24, -9.259254077760287e-27,
  1.350235711523732e-30,  6.769763062749072e-01, -2.109345201086292e-03,  2.773638945746896e-06,  3.207593415639152e-09, -2.075503949999688e-11,  1.937812661825710e-14,
  1.121466737715046e-16, -3.897385696050372e-19, -9.467611056402028e-23,  3.618964915245540e-24, -7.282416137472640e-27, -1.712512649540825e-29,  7.337917734997063e-01,
 -2.208875530710583e-03,  2.502737165894838e-06,  4.700801563902655e-09, -2.135406849320907e-11,  5.334318051051495e-15,  1.504929929591521e-16, -3.258619720978229e-19,
 -6.653024745864190e-22,  4.239907229993336e-24, -2.312563914857196e-27, -3.589523632453045e-29,  7.921082080469043e-01, -2.296893686171838e-03,  2.162615865026155e-06,
  6.169287415962986e-09, -2.074324199147201e-11, -1.141574716992428e-14,  1.775115567164280e-16, -1.943586917688929e-19, -1.240521406067484e-21,  3.920386871848757e-24,
  5.005416559325621e-27, -4.740378469507320e-29,  8.517652591942644e-01, -2.371671741783479e-03,  1.756036990090005e-06,  7.544321358844490e-09, -1.878998628467093e-11,
 -2.966398180113432e-14,  1.871569277206233e-16, -2.757674872635761e-21, -1.689809276930224e-21,  2.464178742497754e-24,  1.293380585927144e-26, -4.414775712814913e-29,
  9.125880230645085e-01, -2.431531276156959e-03,  1.288060772142703e-06,  8.752346932635934e-09, -1.544430105007785e-11, -4.779343928369602e-14,  1.745973781957109e-16,
  2.276509243489451e-19, -1.875113908992307e-21, -4.191075073004860e-26,  1.887455910567189e-26, -2.215461217300449e-29,  9.743861438470505e-01, -2.474877416877942e-03,
  7.662214623578205e-07,  9.718356050825200e-09, -1.076012811032404e-11, -6.388041471502377e-14,  1.373334441526327e-16,  4.622543969796996e-19, -1.685341508594545e-21,
 -3.153850051483780e-24,  2.005996704152772e-26,  1.561717733274921e-29,  1.036952956119404e+00, -2.500238181594457e-03,  2.006399140288381e-07,  1.037014305177682e-08,
 -4.912022458896579e-12, -7.586711217696700e-14,  7.624232123652561e-17,  6.568009183305015e-19, -1.075843587876623e-21, -6.093112473896288e-24,  1.461772886453549e-26,
  5.777795802981264e-29,  1.100064701529268e+00, -2.506309224073607e-03, -3.959517877568709e-07,  1.064336726997716e-08,  1.796252614850374e-12, -8.180252661933164e-14,
 -3.688882216287628e-18,  7.646661701126752e-19, -1.025057538201908e-22, -7.901568719480796e-24,  2.701514957410754e-27,  8.670676735332956e-29,  1.163479860910421e+00,
 -2.492003838021383e-03, -1.008301411647355e-06,  1.048724627106481e-08,  8.934844423880037e-12, -8.013620370016099e-14, -9.321043172165823e-17,  7.471792014794344e-19,
  1.063114328953924e-21, -7.726216061162127e-24, -1.282222281929047e-26,  8.511230210599522e-29,  1.226938651502097e+00, -2.456507717657411e-03, -1.618872744967270e-06,
  9.870566125963300e-09,  1.596607697766232e-11, -7.003330451616577e-14, -1.794864473179635e-16,  5.853301608688184e-19,  2.150805274686227e-21, -5.173132162830317e-24,
 -2.668413638752706e-26,  4.533185920867282e-29,  1.290162748040658e+00, -2.399337508192092e-03, -2.208255517508726e-06,  8.787537031594341e-09,  2.228040375488231e-11,
 -5.166199162757303e-14, -2.477498684944399e-16,  2.899778967002838e-19,  2.848165289377164e-21, -6.073861876394851e-25, -3.282573204479796e-26, -2.290500969644716e-29,
  1.352855295623137e+00, -2.320401593552460e-03, -2.755773674059945e-06,  7.262856265639449e-09,  2.725079869880251e-11, -2.638938055246740e-14, -2.838916626450923e-16,
 -9.315105304388835e-20,  2.891487408704202e-21,  4.760444971295295e-24, -2.704738745854190e-26, -9.186727507722320e-29,  1.414701290695876e+00, -2.220060866146443e-03,
 -3.240307861803066e-06,  5.355190508153004e-09,  3.030354020421013e-11,  3.184271889447197e-15, -2.776607352055619e-16, -4.872641135893663e-19,  2.169217942621387e-21,
  9.132307003740740e-24, -9.671009564905276e-27, -1.261008063146722e-28,  1.475368413309748e+00, -2.099186424830283e-03, -3.641333475216291e-06,  3.158192531272372e-09,
  3.099961509431754e-11,  3.341521145554452e-14, -2.258332248591031e-16, -7.991134155710775e-19,  8.004692394159123e-22,  1.073929972017738e-23,  1.332329333496114e-26,
 -1.015009784602020e-28,  1.534508397615213e+00, -1.959210297959142e-03, -3.940154464465395e-06,  7.981705380066110e-10,  2.911669716927897e-11,  6.006263477513374e-14,
 -1.344485119367697e-16, -9.431973377172660e-19, -8.544409122090710e-22,  8.641532548929642e-24,  3.199548795718791e-26, -2.351228053727894e-29,  1.591759026866310e+00,
 -1.802164465577695e-03, -4.121285311103191e-06, -1.572315087119986e-09,  2.471762800497971e-11,  7.897244417950090e-14, -1.913836153884069e-17, -8.700030015006177e-19,
 -2.280617361489845e-21,  3.352451295441673e-24,  3.700317205353762e-26,  6.914238371218373e-29,  1.646746832166904e+00, -1.630702772082131e-03, -4.173900316907433e-06,
 -3.785295937992595e-09,  1.818875503941513e-11,  8.690748022534434e-14,  9.716835861394829e-17, -5.887869440169475e-19, -2.985077815480445e-21, -3.120545039269038e-24,
  2.507058729636081e-26,  1.233157379121625e-28,  1.699090558968584e+00, -1.448099927985046e-03, -4.093233616175320e-06, -5.672467655574010e-09,  1.023184872535427e-11,
  8.235785333695261e-14,  1.892292967190751e-16, -1.740501983724032e-19, -2.705890992077913e-21, -8.031079514127632e-24,  1.967757598357436e-27,  1.056404537371684e-28,
  1.748405440255773e+00, -1.258221874216489e-03, -3.881780206417872e-06, -7.083492760418842e-09,  1.798022715797189e-12,  6.611045465915175e-14,  2.362525313584791e-16,
  2.517469170411170e-19, -1.557631860267454e-21, -9.224143503729222e-24, -1.982203074431657e-26,  2.895040840526540e-29,  1.794308279325115e+00, -1.065462509064023e-03,
 -3.550124976080753e-06, -7.905638979393421e-09, -6.038169299420943e-12,  4.135435277631471e-14,  2.285301330665849e-16,  5.580245042960501e-19, -1.969789727427653e-23,
 -6.361809540328556e-24, -2.841582350183771e-26, -5.312660726146505e-29,  1.836423297984740e+00, -8.746433131160605e-04, -3.117221761010491e-06, -8.082013300954548e-09,
 -1.225217086351354e-11,  1.317448088624394e-14,  1.714641380176693e-16,  6.557801548338315e-19,  1.262770285999801e-21, -1.226986063802638e-24, -2.040203164374025e-26,
 -8.537357900335699e-29,  1.874388649257389e+00, -6.908748334573718e-04, -2.609966307154057e-06, -7.625096645706915e-09, -1.606224589606929e-11, -1.255561445226492e-14,
  8.485705340957569e-17,  5.357029346001023e-19,  1.789529616620004e-21,  3.272168553170437e-24, -3.234023625010275e-27, -5.451247869949760e-29,  1.907863430602541e+00,
 -5.193822591175410e-04, -2.061961557485887e-06, -6.622277510233852e-09, -1.710048483580982e-11, -3.066142557135094e-14, -3.187430881072563e-18,  2.738115712008200e-19,
  1.462109036920117e-21,  4.896865631227215e-24,  1.049977039186048e-26,  2.484424626317980e-30,  1.936534969961759e+00, -3.653012147774126e-04, -1.511461459486904e-06,
 -5.230830887285947e-09, -1.551606568053866e-11, -3.812381196396597e-14, -6.615055623515297e-17, -3.230142331101754e-21,  6.218865157300917e-22,  3.461064822412825e-24,
  1.284192479540222e-26,  3.537258112297870e-29,  1.960126101604928e+00, -2.334539958068944e-04, -9.985931765074925e-07, -3.661345189194229e-09, -1.197300481150547e-11,
 -3.501016411707702e-14, -8.907200437400349e-17, -1.796236924269411e-19, -1.761093741129018e-22,  7.370244153888841e-25,  5.983044125489873e-27,  2.712177358649807e-29,
  1.978402121037792e+00, -1.281201166618693e-04, -5.620807704492179e-07, -2.150783676195883e-09, -7.526835768376041e-12, -2.448480513371648e-14, -7.418346977687866e-17,
 -2.073331754335989e-19, -5.201358581087313e-22, -1.088659180360867e-24, -1.414400760066024e-27,  2.247927416591787e-30,  1.991177206760145e+00, -5.281702721650162e-05,
 -2.358002357231225e-07, -9.287317796109216e-10, -3.396778003174214e-12, -1.178708074087475e-14, -3.919856557785410e-17, -1.254716147796393e-19, -3.868412525790022e-22,
 -1.145930300631758e-24, -3.241091334122596e-27, -8.644360447993179e-30,  1.998321823852370e+00, -1.009751587549404e-05, -4.551929530414078e-08, -1.821459190070619e-10,
 -6.821226782568129e-13, -2.447226324048382e-15, -8.515174614163519e-18, -2.894266559039385e-20, -9.652802012743562e-23, -3.168102020336555e-25, -1.025194668096143e-27,
 -3.274992729727921e-30,  3.484710125816914e-04, -1.463996576265556e-06,  4.612200585206581e-09, -1.291365966529959e-11,  3.388846452949778e-14, -8.535126782276872e-17,
  2.089188879471629e-19, -5.007674228303094e-22,  1.180998473659999e-24, -2.749652257505419e-27,  6.334016588332390e-30, -1.446292583009154e-32,  3.135687310040514e-03,
 -1.316099136039377e-05,  4.137690979992916e-08, -1.154373683475473e-10,  3.012768132162084e-13, -7.528848386394053e-16,  1.823470870399205e-18, -4.310786645709256e-21,
  9.989565109868323e-24, -2.275574721797438e-26,  5.103559443848637e-29, -1.128215132086778e-31,  8.707170853266895e-03, -3.647505653432967e-05,  1.141984863500220e-07,
 -3.163128560331876e-10,  8.163860953334220e-13, -2.007653175089452e-15,  4.756371407064803e-18, -1.091837782207979e-20,  2.434724896712818e-23, -5.277422701185597e-26,
  1.110267256150792e-28, -2.259782458961075e-31,  1.705699419571470e-02, -7.124613984305492e-05,  2.216657608707705e-07, -6.072816934771610e-10,  1.540691527415676e-12,
 -3.694660577747127e-15,  8.447034753195875e-18, -1.845599596704163e-20,  3.843582623151782e-23, -7.568958921795285e-26,  1.384826460472417e-28, -2.266027944427027e-31,
  2.817619254989441e-02, -1.172336601499138e-04,  3.616734093312193e-07, -9.761704184066350e-10,  2.418420947466615e-12, -5.595215936000437e-15,  1.213203956425637e-17,
 -2.449951767895914e-20,  4.517595947530114e-23, -7.242767425292605e-26,  8.623502454425198e-29, -9.598660063638352e-33,  4.205267471902938e-02, -1.741159209370041e-04,
  5.314360732235861e-07, -1.407149194423224e-09,  3.378943698116441e-12, -7.442925159594096e-15,  1.493224316373012e-17, -2.647639900173236e-20,  3.792393752893608e-23,
 -2.832868519126882e-26, -7.038577004805810e-29,  4.393852656038751e-31,  5.867110312813438e-02, -2.414893570770337e-04,  7.275078625772163e-07, -1.881079251104945e-09,
  4.339904729353689e-12, -8.944052303199254e-15,  1.595931583670461e-17, -2.213828589719275e-20,  1.229419709684331e-23,  6.069681334586814e-26, -3.155407526090916e-28,
  1.000468922806327e-30,  7.801274191856108e-02, -3.188676410801896e-04,  9.458078257117732e-07, -2.375950943575479e-09,  5.211055107745648e-12, -9.801403884550974e-15,
  1.443368561011559e-17, -1.004187424620901e-20, -3.221319875395226e-23,  1.837820441914625e-25, -5.851940584889486e-28,  1.424449621005584e-30,  1.000552718151886e-01,
 -4.056806835372936e-04,  1.181652119841693e-06, -2.867414259007112e-09,  5.898711649381669e-12, -9.740657592388006e-15,  9.804224998144429e-18,  1.002553006659038e-20,
 -9.111226752848877e-23,  3.139013204033934e-25, -7.745237378119304e-28,  1.397240805141897e-30,  1.247725702256378e-01, -5.012735723681916e-04,  1.429793767532669e-06,
 -3.329403236466563e-09,  6.310755822392370e-12, -8.537815395100577e-15,  1.858658432265037e-18,  3.674185449636454e-20, -1.546582121841184e-22,  4.108351642062499e-25,
 -7.619850628618718e-28,  6.565228836510213e-31,  1.521344547896655e-01, -6.049055070711874e-04,  1.684471033391814e-06, -3.734854948942319e-09,  6.362054711522759e-12,
 -6.046217770416560e-15, -9.187241313141499e-18,  6.713019944155651e-20, -2.086221721487130e-22,  4.285834328840899e-25, -4.472291251787640e-28, -8.675724373529913e-31,
  1.821063883693555e-01, -7.157487978096047e-04,  1.939465599490191e-06, -4.056522297368884e-09,  5.980154185291293e-12, -2.221320891805051e-15, -2.263389520423250e-17,
  9.667505264017442e-20, -2.362046357646346e-22,  3.265813138753862e-25,  2.046892715662274e-28, -2.933712865628389e-30,  2.146491432640396e-01, -8.328880152429384e-04,
  2.188171851055086e-06, -4.267877740904939e-09,  5.111056210986495e-12,  2.858771336171859e-15, -3.728729944880197e-17,  1.197083800108752e-19, -2.210040091407804e-22,
  8.303334879079334e-26,  1.124556764442881e-27, -4.946869054463571e-30,  2.497184222578684e-01, -9.553193959082225e-04,  2.423678697439452e-06, -4.344102070627042e-09,
  3.724848704151112e-12,  8.979189576410485e-15, -5.150366145879302e-17,  1.300719990299217e-19, -1.507481529450714e-22, -2.923113975545050e-25,  2.119800132924659e-27,
 -6.039330924127466e-30,  2.872644339757611e-01, -1.081950630084324e-03,  2.638865435364439e-06, -4.263148243187441e-09,  1.820908189808256e-12,  1.578284446448382e-14,
 -6.329650989243189e-17,  1.220269841011414e-19, -2.127408382074229e-23, -7.493497727166695e-25,  2.888212688643793e-27, -5.296278959059023e-30,  3.272314199524287e-01,
 -1.211601184816613e-03,  2.826513195721419e-06, -4.006864935008054e-09, -5.676553912369798e-13,  2.277583972807222e-14, -7.050905820615510e-17,  9.133800731222900e-20,
  1.599645975020450e-22, -1.196403305915118e-24,  3.073144149245628e-27, -2.102174998172854e-30,  3.695571308317983e-01, -1.343003344485579e-03,  2.979433480287902e-06,
 -3.562157667806386e-09, -3.370693216640938e-12,  2.934573758039447e-14, -7.104844194714165e-17,  3.641334033804195e-20,  3.717295625328927e-22, -1.509654242234162e-24,
  2.359334156433752e-27,  3.472103946355399e-30,  4.141722492393363e-01, -1.474804185221552e-03,  3.090615162633548e-06, -2.922156929695144e-09, -6.479279030255218e-12,
  3.479420422374119e-14, -6.317052608124812e-17, -4.066532846082292e-20,  5.790717569338553e-22, -1.554779755319687e-24,  5.953650462309047e-28,  1.037476896252641e-29,
  4.609997571440220e-01, -1.605568737688329e-03,  3.153391062848484e-06, -2.087352569346355e-09, -9.745999729232120e-12,  3.838480392181735e-14, -4.579446514110525e-17,
 -1.334276430547527e-19,  7.364192434179164e-22, -1.219750344522245e-24, -2.086172506897767e-27,  1.653337848058452e-29,  5.099542459958103e-01, -1.733784635112043e-03,
  3.161624764644809e-06, -1.066641879939351e-09, -1.298775128778154e-11,  3.940558385207646e-14, -1.881560873866606e-17, -2.308386903307611e-19,  7.941012098739625e-22,
 -4.542962970097780e-25, -5.192348937782263e-27,  1.921145679438467e-29,  5.609411686448253e-01, -1.857868589357674e-03,  3.109917672967464e-06,  1.217745992228350e-10,
 -1.599149735160124e-11,  3.724454820187003e-14,  1.662533746842212e-17, -3.178771700857141e-19,  7.081325182939852e-22,  6.923063791843161e-25, -7.883871268728013e-27,
  1.581325602004462e-29,  6.138560330890918e-01, -1.976175086224988e-03,  2.993835348774190e-06,  1.449729992463468e-09, -1.852338094976879e-11,  3.147413988738681e-14,
  5.796817151826421e-17, -3.770282224276723e-19,  4.522490597660382e-22,  2.046811833094714e-24, -9.116910930612623e-27,  5.025702036356020e-30,  6.685835395408665e-01,
 -2.087007740020692e-03,  2.810150836064302e-06,  2.878755808211957e-09, -2.034144695890391e-11,  2.193847061701100e-14,  1.012107558522861e-16, -3.907412840364850e-19,
  3.019557899511293e-23,  3.314119683543361e-24, -7.922669558546798e-27, -1.202263042735499e-29,  7.249966642447518e-01, -2.188633793847418e-03,  2.557100941842052e-06,
  4.360183058073742e-09, -2.121201470608145e-11,  8.834394848716862e-15,  1.410936038393828e-16, -3.447303242436615e-19, -5.146988754267266e-22,  4.117207358155891e-24,
 -3.787443481481423e-27, -3.109447050726020e-29,  7.829556960355017e-01, -2.279302291475050e-03,  2.234649172955949e-06,  5.835798570306950e-09, -2.092941759154170e-11,
 -7.225128365715680e-15,  1.715352289167791e-16, -2.317626394267136e-19, -1.096281229132869e-21,  4.079453629446362e-24,  2.963694303164839e-27, -4.524082298287398e-29,
  8.423072349145905e-01, -2.357266472818035e-03,  1.844746219701674e-06,  7.239179258734060e-09, -1.933838573107433e-11, -2.517916702172522e-14,  1.863367040146053e-16,
 -5.531620749179565e-20, -1.592262462842393e-21,  2.941842165227939e-24,  1.093112507062886e-26, -4.665286489848664e-29,  9.028831660860880e-01, -2.420810949333510e-03,
  1.391575481890986e-06,  8.497820885812754e-09, -1.635778518192017e-11, -4.353338814276066e-14,  1.801323533344832e-16,  1.677668009539700e-19, -1.863289535479853e-21,
  6.912206630270962e-25,  1.772588540767665e-26, -2.985819965351583e-29,  9.644996280595826e-01, -2.468284186756829e-03,  8.817671934492894e-07,  9.536156507248128e-09,
 -1.200375990564151e-11, -6.043528811615129e-14,  1.495055765618399e-16,  4.066628629829892e-19, -1.784300995078741e-21, -2.340963275920751e-24,  2.050424792356734e-26,
  4.621679416486988e-30,  1.026955999725120e+00, -2.498136746127185e-03,  3.245603431582708e-07,  1.027951755467262e-08, -6.409597871219325e-12, -7.382070013579875e-14,
  9.411862563269080e-17,  6.189819437181414e-19, -1.284083929139375e-21, -5.460402373292418e-24,  1.694524761809736e-26,  4.782575385610374e-29,  1.090033938826116e+00,
 -2.508965592500982e-03, -2.681129256484119e-07,  1.065902136684930e-08,  1.610479859325909e-13, -8.163476452842006e-14,  1.763327635438279e-17,  7.568629511987791e-19,
 -3.841053910486282e-22, -7.718085292872135e-24,  6.446564948765424e-27,  8.312696032081392e-29,  1.153496513035902e+00, -2.499564553776992e-03, -8.816499753503232e-07,
  1.061726762183520e-08,  7.311463213273837e-12, -8.211861798848754e-14, -7.185561581665007e-17,  7.766570252070445e-19,  7.766603594909181e-22, -8.162124686069185e-24,
 -8.926278445501913e-27,  9.155199288974357e-29,  1.217087474819319e+00, -2.468980677613172e-03, -1.498940172640102e-06,  1.011458968854667e-08,  1.452370110632143e-11,
 -7.413671034814907e-14, -1.621630837507410e-16,  6.509743876878672e-19,  1.945883483977273e-21, -6.195915699368804e-24, -2.434105733258629e-26,  6.097235019235054e-29,
  1.280530742221942e+00, -2.416575770895531e-03, -2.100701289790838e-06,  9.135437452715301e-09,  2.118841473140200e-11, -5.750028623967159e-14, -2.383596130953796e-16,
  3.805142638648693e-19,  2.802470511026878e-21, -1.935222203584982e-24, -3.343132653167851e-26, -4.414599777676142e-30,  1.343530159255606e+00, -2.342091796147563e-03,
 -2.666021940312675e-06,  7.694275852467513e-09,  2.665472050240316e-11, -3.322347289754783e-14, -2.851802758210118e-16,  1.902033260484093e-21,  3.042443614886335e-21,
  3.600881789077712e-24, -3.084596971517945e-26, -8.022683970863373e-29,  1.405769620939930e+00, -2.245718034868233e-03, -3.173135519391688e-06,  5.840190071552268e-09,
  3.029952376737378e-11, -3.635161767915661e-15, -2.902834922224758e-16, -4.126745173678909e-19,  2.489669765852320e-21,  8.633349544508993e-24, -1.529862746968889e-26,
 -1.290815251795638e-28,  1.466913658265816e+00, -2.128157018654886e-03, -3.600438122323073e-06,  3.659230769214026e-09,  3.161192344799987e-11,  2.772996713522271e-14,
 -2.477909880478660e-16, -7.672187640863294e-19,  1.195551756737732e-21,  1.117757893254579e-23,  8.461356657167812e-27, -1.192417208617919e-28,  1.526608585912593e+00,
 -1.990685211636046e-03, -3.927742166312682e-06,  1.273463362361916e-09,  3.028352833434652e-11,  5.651616275039922e-14, -1.611923115780482e-16, -9.653173384896112e-19,
 -5.206187188925194e-22,  9.893998099324008e-24,  3.045928171764085e-26, -4.663889917587503e-29,  1.584484318592650e+00, -1.835203376161627e-03, -4.137728181871793e-06,
 -1.164230833661900e-09,  2.629046840569249e-11,  7.821267765394962e-14, -4.449994869287059e-17, -9.407603596092597e-19, -2.132588931034784e-21,  4.889488534711913e-24,
  3.974372151432503e-26,  5.472759742000506e-29,  1.640156958150660e+00, -1.664270588587085e-03, -4.217519994089238e-06, -3.480249753694517e-09,  1.994883348163455e-11,
  8.903079775970771e-14,  7.932956269116841e-17, -6.859026287316451e-19, -3.078046870260094e-21, -2.007920824819193e-24,  3.058637886284811e-26,  1.268393273535544e-28,
  1.693232240507327e+00, -1.481115165520928e-03, -4.160265820035432e-06, -5.495335900837924e-09,  1.192397437885066e-11,  8.683082471808856e-14,  1.831003503465942e-16,
 -2.652400066179573e-19, -2.992423807542511e-21, -7.854017524542318e-24,  7.018731911320807e-27,  1.239436349710662e-28,  1.743309906755615e+00, -1.289615531957258e-03,
 -3.966564872235594e-06, -7.043836359605051e-09,  3.177472947737494e-12,  7.185915774371363e-14,  2.425526298971014e-16,  1.964393775585299e-19, -1.903616785033974e-21,
 -9.986111778272187e-24, -1.813643056866596e-26,  4.816575209901962e-29,  1.789989024227367e+00, -1.094244557104647e-03, -3.645544034395927e-06, -7.995329680122629e-09,
 -5.154970707428021e-12,  4.702628140208717e-14,  2.441099744009320e-16,  5.535059245312857e-19, -2.697306734914561e-22, -7.543490518090986e-24, -3.062049553415989e-26,
 -4.656408080684902e-29,  1.832874230274525e+00, -8.999723349238835e-04, -3.215372692348281e-06, -8.275710203994575e-09, -1.194601913892077e-11,  1.751448187780832e-14,
  1.903838967852796e-16,  6.953170618812958e-19,  1.202981731016469e-21, -2.120635915980051e-24, -2.433970594947926e-26, -9.350010325519055e-29,  1.871582804763173e+00,
 -7.121249558243097e-04, -2.703017356559926e-06, -7.883985607062930e-09, -1.629174361706148e-11, -1.033247021262786e-14,  1.006759475969877e-16,  5.948227785180422e-19,
  1.904388341773999e-21,  3.091211465230991e-24, -5.906510819091665e-27, -6.723801910805507e-29,  1.905752400260011e+00, -5.362005188488304e-04, -2.143090776801541e-06,
 -6.900792548188423e-09, -1.771382930032278e-11, -3.064047044737779e-14,  5.161398479593801e-18,  3.235008319926784e-19,  1.645967784144106e-21,  5.317416393578854e-24,
  1.048450832780556e-26, -3.460321456342347e-30,  1.935049178140875e+00, -3.776482652143675e-04, -1.575746413558854e-06, -5.485273997197820e-09, -1.629441325575767e-11,
 -3.971014315014055e-14, -6.594293907714668e-17,  1.876603417837006e-20,  7.561138254379556e-22,  4.006712831447986e-24,  1.446101058106795e-26,  3.818947791789403e-29,
  1.959176025199887e+00, -2.416217964239470e-04, -1.043702214887424e-06, -3.858632763474622e-09, -1.269499594232296e-11, -3.720885636713183e-14, -9.417603275128402e-17,
 -1.847860597765936e-19, -1.449683803294139e-22,  1.001620859060551e-24,  7.282902654962399e-27,  3.208301795118794e-29,  1.977880480879081e+00, -1.327220855965740e-04,
 -5.886292295953249e-07, -2.275229360673232e-09, -8.034816010813432e-12, -2.633678976488167e-14, -8.022778798659261e-17, -2.246152920536206e-19, -5.603184020014296e-22,
 -1.142843331122075e-24, -1.283879040236846e-27,  3.749697556125273e-30,  1.990962093935483e+00, -5.474895040581199e-05, -2.472790561402217e-07, -9.850184956629770e-10,
 -3.642219237715251e-12, -1.277144262682854e-14, -4.289146023593228e-17, -1.385363741895428e-19, -4.305227845670295e-22, -1.283489108663460e-24, -3.644682520332713e-27,
 -9.720040587585709e-30,  1.998280691370121e+00, -1.047060257272649e-05, -4.777218201508354e-08, -1.934628238104144e-10, -7.331783382995297e-13, -2.661675124228041e-15,
 -9.370586483791925e-18, -3.222225026658849e-20, -1.087074308526341e-22, -3.608522290493846e-25, -1.180829096103750e-27, -3.813781510232640e-30,  3.426878528921855e-04,
 -1.427709737572812e-06,  4.460434499610907e-09, -1.238483269707864e-11,  3.223046565427344e-14, -8.050129162213763e-17,  1.954119478547379e-19, -4.645115903469971e-22,
  1.086422235763640e-24, -2.508569387509513e-27,  5.730937417084333e-30, -1.297830245236824e-32,  3.083696716116473e-03, -1.283543625751947e-05,  4.002009464158619e-08,
 -1.107350635026206e-10,  2.866471561116236e-13, -7.105345828929316e-16,  1.707123769149608e-18, -4.003843383727373e-21,  9.205938397891949e-24, -2.081022855472185e-26,
  4.632166467260953e-29, -1.016531410473651e-31,  8.563074072653181e-03, -3.557643261544770e-05,  1.104797999023487e-07, -3.035658030887593e-10,  7.773502457504904e-13,
 -1.897082521928225e-15,  4.461284781543560e-18, -1.016882576461408e-20,  2.252497551105335e-23, -4.852592440511605e-26,  1.015356706254348e-28, -2.057556582848580e-31,
  1.677551071941825e-02, -6.950154975446325e-05,  2.145238836658424e-07, -5.832109330301043e-10,  1.468784453744989e-12, -3.497996454362138e-15,  7.947083994574453e-18,
 -1.726859689681405e-20,  3.580834370167260e-23, -7.034551899582358e-26,  1.288233303773068e-28, -2.125356769615244e-31,  2.771297141248117e-02, -1.143864796479415e-04,
  3.501878904942405e-07, -9.383553279443992e-10,  2.309373587447262e-12, -5.312117853587865e-15,  1.146590466055394e-17, -2.309494072260950e-20,  4.263050308440934e-23,
 -6.899188606037580e-26,  8.543363826710683e-29, -2.618802933421043e-32,  4.136460835187077e-02, -1.699310676278435e-04,  5.148698115459248e-07, -1.354257741234201e-09,
  3.233609589466897e-12, -7.093311221610044e-15,  1.420773693975528e-17, -2.527965712087627e-20,  3.685789936107554e-23, -3.077785600197160e-26, -5.256027620865170e-29,
  3.724311105313720e-31,  5.771664451237298e-02, -2.357584189871778e-04,  7.053457061817239e-07, -1.813051222787599e-09,  4.164803947469347e-12, -8.568420797342845e-15,
  1.534526324407608e-17, -2.171226218828861e-20,  1.426238475218972e-23,  4.892093156257889e-26, -2.740885546949221e-28,  8.857757570732341e-31,  7.675222568873660e-02,
 -3.114138214891323e-04,  9.177902674544489e-07, -2.294123562564617e-09,  5.018467762993367e-12, -9.458480027780036e-15,  1.413904473651158e-17, -1.097123550148977e-20,
 -2.600362137782376e-23,  1.615904214279347e-25, -5.252974912791405e-28,  1.299453311791263e-30,  9.845123983716339e-02, -3.963635127357116e-04,  1.147803037877787e-06,
 -2.774580503475096e-09,  5.706272590269635e-12, -9.502306845493440e-15,  1.004577843942142e-17,  7.284884496775576e-21, -8.035482839430122e-23,  2.841314361018150e-25,
 -7.144401093303232e-28,  1.332802166643135e-30,  1.227901020080419e-01, -4.899933300177334e-04,  1.390441135078718e-06, -3.229794430186933e-09,  6.140526090017925e-12,
 -8.481408116575373e-15,  2.820325314387669e-18,  3.202360830955094e-20, -1.404095773171561e-22,  3.809590584148997e-25, -7.312392948147973e-28,  7.363667610672586e-31,
  1.497415028797570e-01, -5.916072906276876e-04,  1.640259503660091e-06, -3.634040822875168e-09,  6.239073830802351e-12, -6.244896061484648e-15, -7.398763990363067e-18,
  6.069763197654187e-20, -1.935235769617935e-22,  4.100175552548878e-25, -4.790069074838029e-28, -5.849355424746772e-31,  1.792741186237060e-01, -7.004261630456733e-04,
  1.891359867524215e-06, -3.961223851226656e-09,  5.930510523718324e-12, -2.732894761176991e-15, -2.003103610268593e-17,  8.930595150621432e-20, -2.243301285477544e-22,
  3.323306083900851e-25,  8.622480125214466e-29, -2.460068648574902e-30,  2.113522795619599e-01, -8.155861043237377e-04,  2.137449711927336e-06, -4.185690935469370e-09,
  5.159550067142790e-12,  2.003302076635666e-15, -3.403396574991409e-17,  1.126923446118950e-19, -2.172560879372287e-22,  1.238262663945375e-25,  9.190871234144311e-28,
 -4.398007556278294e-30,  2.459355948294312e-01, -9.361374568511129e-04,  2.371912770140744e-06, -4.283133753443463e-09,  3.892363763869755e-12,  7.786251636646426e-15,
 -4.793064895021404e-17,  1.250955388287737e-19, -1.598080857177340e-22, -2.127169503799555e-25,  1.862863146301507e-27, -5.635761628804780e-30,  2.829785300333123e-01,
 -1.061043818970618e-03,  2.587892616115453e-06, -4.231569835683695e-09,  2.121650173445212e-12,  1.430462822613085e-14, -5.989318428562650e-17,  1.209364282241660e-19,
 -4.622745358922627e-23, -6.384947029408214e-25,  2.654413476627887e-27, -5.314100674883766e-30,  3.224299347294746e-01, -1.189181529143708e-03,  2.778391058207562e-06,
 -4.012394351280145e-09, -1.288507924315399e-13,  2.111485137990050e-14, -6.788623676171438e-17,  9.579127707467566e-20,  1.190825177744510e-22, -1.075537240480751e-24,
  2.965284601528003e-27, -2.771775127657712e-30,  3.642325164292644e-01, -1.319339733034470e-03,  2.936383070807621e-06, -3.611485718226503e-09, -2.800740769465095e-12,
  2.765410447110043e-14, -6.987037235871464e-17,  4.745761305809248e-20,  3.191137132076151e-22, -1.412643856837470e-24,  2.481184993744667e-27,  2.098982777797348e-30,
  4.083222578381336e-01, -1.450221237466767e-03,  3.054949965064246e-06, -3.020341045991825e-09, -5.798637498110431e-12,  3.326649043853152e-14, -6.405810782094706e-17,
 -2.302512924966848e-20,  5.236333552052734e-22, -1.522383542939980e-24,  1.011106366086036e-27,  8.543620831321443e-30,  4.546277741454420e-01, -1.580444395069978e-03,
  3.127432353220554e-06, -2.237207935216785e-09, -8.989583348281454e-12,  3.724352684745678e-14, -4.920723134207514e-17, -1.105795155527907e-19,  6.911769738094166e-22,
 -1.289146485530859e-24, -1.396065875010948e-27,  1.482737684092920e-29,  5.030696074782720e-01, -1.708546308747092e-03,  3.147604160289457e-06, -1.268167688811880e-09,
 -1.220466412803827e-11,  3.887930240825835e-14, -2.492606964468112e-17, -2.057275694701812e-19,  7.742099695098446e-22, -6.452862235013497e-25, -4.362683583034228e-27,
  1.845244880884876e-29,  5.535594561590941e-01, -1.832987695742724e-03,  3.109868427882502e-06, -1.281115310989884e-10, -1.524332392850465e-11,  3.753933106609619e-14,
  8.045340891236479e-18, -2.948776432801878e-19,  7.275498857096091e-22,  3.911938178433675e-25, -7.164607051426416e-27,  1.679581245360848e-29,  6.059993372399446e-01,
 -1.952159806440673e-03,  3.009474872167877e-06,  1.158463791104975e-09, -1.788083215944161e-11,  3.274039543428393e-14,  4.762456721082076e-17, -3.614471810049265e-19,
  5.194321644424425e-22,  1.687512113169722e-24, -8.825507062303062e-27,  8.124302722657413e-30,  6.602806820135089e-01, -2.064393851741478e-03,  2.842758023603434e-06,
  2.556931074491381e-09, -1.987927214233023e-11,  2.423645690337668e-14,  9.030102190226766e-17, -3.879282040310153e-19,  1.436851710765254e-22,  2.988065930019572e-24,
 -8.345213041572802e-27, -7.245248562580040e-30,  7.162833659321203e-01, -2.167973452586692e-03,  2.607393202763211e-06,  4.022384998437856e-09, -2.100225523410102e-11,
  1.210308664555600e-14,  1.312326284600195e-16, -3.588610044060670e-19, -3.695227567856979e-22,  3.939813695333714e-24, -5.045664511275241e-27, -2.607530532384550e-29,
  7.738746767275015e-01, -2.261150682101799e-03,  2.302665481494442e-06,  5.499993274287397e-09, -2.103329725037535e-11, -3.189982850047912e-15,  1.645769598352933e-16,
 -2.644748382452415e-19, -9.477592316061192e-22,  4.159029375332922e-24,  1.037347539776878e-27, -4.218812507730188e-29,  8.329082276660430e-01, -2.342166319193642e-03,
  1.929744052926850e-06,  6.925978774460962e-09, -1.979740304998004e-11, -2.073132921758741e-14,  1.840910161262839e-16, -1.044937597954697e-19, -1.478984548595758e-21,
  3.337600591890316e-24,  8.848506031154000e-27, -4.779252482669646e-29,  8.932228269641526e-01, -2.409274964030664e-03,  1.491951018059044e-06,  8.229367349651693e-09,
 -1.718487539084893e-11, -3.916055185319684e-14,  1.839997710884101e-16,  1.086738322120516e-19, -1.825977841583755e-21,  1.371992930341396e-24,  1.626592514569518e-26,
 -3.628261457264427e-29,  9.546413196066073e-01, -2.460775669295862e-03,  9.950094651033386e-07,  9.334625412340453e-09, -1.317569567304206e-11, -5.671703979322214e-14,
  1.600812305123589e-16,  3.483753374969415e-19, -1.853792366996638e-21, -1.519877238853600e-24,  2.047309931578689e-26, -5.939271034412875e-30,  1.016969424341253e+00,
 -2.495048701331098e-03,  4.472509242085683e-07,  1.016528121429052e-08, -7.862044303112483e-12, -7.135869529435467e-14,  1.108462543435217e-16,  5.748808117181017e-19,
 -1.467979346413212e-21, -4.743664738607502e-24,  1.881199419333090e-26,  3.689751303750525e-29,  1.079994596633403e+00, -2.510598942975302e-03, -1.402429934809727e-07,
  1.064856674316993e-08, -1.465707013707035e-12, -8.095890364900025e-14,  3.861198530800039e-17,  7.401827923176999e-19, -6.564474808128918e-22, -7.388642781142073e-24,
  9.982680634046995e-27,  7.724348513317925e-29,  1.143484957975842e+00, -2.506106261408112e-03, -7.535953449094204e-07,  1.072102579544800e-08,  5.653620317597575e-12,
 -8.357966137575057e-14, -4.980589394571685e-17,  7.967478235065173e-19,  4.773800380546796e-22, -8.437301107375270e-24, -4.805077997257234e-27,  9.532082359142159e-29,
  1.207188343201759e+00, -2.480482862272915e-03, -1.376220419045035e-06,  1.033490189309410e-08,  1.300355963521441e-11, -7.780307333375526e-14, -1.430988854521979e-16,
  7.094914054627287e-19,  1.705990795860180e-21, -7.111611405863679e-24, -2.134064355320997e-26,  7.511721924987689e-29,  1.270831530229569e+00, -2.432937206368417e-03,
 -1.989080899229119e-06,  9.464945025582195e-09,  1.998211777159950e-11, -6.308300403164598e-14, -2.264620209392479e-16,  4.688205009752464e-19,  2.708736705172590e-21,
 -3.270687199487236e-24, -3.320032954513038e-26,  1.501537627757866e-29,  1.334119730650726e+00, -2.363043449259996e-03, -2.571154908479308e-06,  8.115063967248317e-09,
  2.592186942599482e-11, -4.005604785844165e-14, -2.837462527317937e-16,  1.010895466158017e-19,  3.149053123022156e-21,  2.300617256702069e-24, -3.405819050266753e-26,
 -6.525749328316878e-29,  1.396736434111204e+00, -2.270814556433028e-03, -3.100148119952280e-06,  6.324018533214245e-09,  3.015626427740945e-11, -1.073133889126208e-14,
 -3.006771893855057e-16, -3.281614966204785e-19,  2.788085920842806e-21,  7.907800790670489e-24, -2.097169918479173e-26, -1.280998102583803e-28,  1.458343713474639e+00,
 -2.156776242099035e-03, -3.553475373091549e-06,  4.169127998312954e-09,  3.210533682934040e-11,  2.152989491937323e-14, -2.686766083595279e-16, -7.224680543847906e-19,
  1.602728217746022e-21,  1.140628725417215e-23,  2.859131827130492e-27, -1.350073255347708e-28,  1.518583109714961e+00, -2.022037701112248e-03, -3.909516792635155e-06,
  1.766822987583335e-09,  3.137296779240115e-11,  5.232165550318182e-14, -1.883992367970796e-16, -9.760474914069832e-19, -1.430639752241755e-22,  1.106413441015559e-23,
  2.786712046104590e-26, -7.139731664743445e-29,  1.577077223207298e+00, -1.868353815227964e-03, -4.149123659309595e-06, -7.311364312641054e-10,  2.784186920325821e-11,
  7.682104568749683e-14, -7.176796340655319e-17, -1.005875633256180e-18, -1.927418269857734e-21,  6.522203579588866e-24,  4.175572961556595e-26,  3.601368628754273e-29,
  1.633432138817001e+00, -1.698172238479611e-03, -4.257308826030183e-06, -3.146726775405851e-09,  2.174687513036006e-11,  9.069305568485587e-14,  5.873620402170317e-17,
 -7.853096290415306e-19, -3.126962301620258e-21, -6.726278021981864e-25,  3.617628333655457e-26,  1.265537581815425e-28,  1.687240802701347e+00, -1.514657691362680e-03,
 -4.225007074920244e-06, -5.290423339049214e-09,  1.370387636982616e-11,  9.112503283091265e-14,  1.742909680178614e-16, -3.654563113833042e-19, -3.268752106663821e-21,
 -7.458875859842018e-24,  1.286871788840065e-26,  1.418290826494133e-28,  1.738087445625022e+00, -1.321685179518170e-03, -4.050737414759175e-06, -6.981181296614061e-09,
  4.673277256025235e-12,  7.773920393950312e-14,  2.471450949263395e-16,  1.296361464100625e-19, -2.275607106798372e-21, -1.066286111537034e-23, -1.553929094479258e-26,
  7.037079755932135e-29,  1.785553107766711e+00, -1.123794013782367e-03, -3.741950784930683e-06, -8.069961438478993e-09, -4.154609470720210e-12,  5.306966395766096e-14,
  2.594447677684175e-16,  5.402892499378347e-19, -5.638129400389914e-22, -8.806608635736224e-24, -3.246250691408127e-26, -3.654504028193347e-29,  1.829222261467676e+00,
 -9.260957716015445e-04, -3.315815650621056e-06, -8.463789235806784e-09, -1.154843823017309e-11,  2.232159445487576e-14,  2.103788465295477e-16,  7.323949081173209e-19,
  1.108102581250088e-21, -3.178706029074062e-24, -2.861618399794331e-26, -1.006826491883046e-28,  1.868690451203638e+00, -7.341319721639987e-04, -2.799195569633445e-06,
 -8.146169630829844e-09, -1.647284571668860e-11, -7.709399700429961e-15,  1.182005212020966e-16,  6.574921142299832e-19,  2.010669018090937e-21,  2.791666238387284e-24,
 -9.175579382844540e-27, -8.163047485300523e-29,  1.903572777408514e+00, -5.536813477811803e-04, -2.227621007223705e-06, -7.189106372699993e-09, -1.832463475280852e-11,
 -3.040176902214454e-14,  1.498616792594085e-17,  3.793151492982499e-19,  1.844887559562103e-21,  5.731596301640327e-24,  1.016751621597823e-26, -1.128829516886528e-29,
  1.933512949919240e+00, -3.905220226721028e-04, -1.643160451824873e-06, -5.752423992197439e-09, -1.710438515214583e-11, -4.128359684001736e-14, -6.505625159593808e-17,
  4.538451559989828e-20,  9.111794483342333e-22,  4.619531741403118e-24,  1.619837819397269e-26,  4.071832891869622e-29,  1.958192540572202e+00, -2.501601389186810e-04,
 -1.091249488132733e-06, -4.067830689264611e-09, -1.346219697254759e-11, -3.953165807671632e-14, -9.940915017161829e-17, -1.887890327673410e-19, -1.033114053316868e-22,
  1.322798623755513e-24,  8.817734423619434e-27,  3.781649508242206e-29,  1.977339998412573e+00, -1.375425566349801e-04, -6.167210513553758e-07, -2.408107095524080e-09,
 -8.581326536522857e-12, -2.833979188736734e-14, -8.677429251819146e-17, -2.432133160655401e-19, -6.023405706957225e-22, -1.190362453165498e-24, -1.077944193735831e-27,
  5.691848242531959e-30,  1.990739065382883e+00, -5.677547420899095e-05, -2.594575451329048e-07, -1.045394712182043e-09, -3.908264471718552e-12, -1.384898638563904e-14,
 -4.697050471222659e-17, -1.530813868928198e-19, -4.794587452842261e-22, -1.438173378411509e-24, -4.098252181873385e-27, -1.091759815042367e-29,  1.998238029614767e+00,
 -1.086226979558409e-05, -5.016591816375627e-08, -2.056320784727399e-10, -7.887359452784480e-13, -2.897801299626939e-15, -1.032353029831531e-17, -3.591819375763293e-20,
 -1.225903687865794e-22, -4.116208088192245e-25, -1.362220964321287e-27, -4.448545065625774e-30,  3.370474518638363e-04, -1.392612087586831e-06,  4.314858314601336e-09,
 -1.188177498861520e-11,  3.066630513166099e-14, -7.596363415565226e-17,  1.828790731896266e-19, -4.311478647261793e-22,  1.000106054863851e-24, -2.290352594444878e-27,
  5.189527634785771e-30, -1.165643661526629e-32,  3.032986985402421e-03, -1.252051388114509e-05,  3.871833016188220e-08, -1.062602059751313e-10,  2.728372625905293e-13,
 -6.708762947965607e-16,  1.599030289622218e-18, -3.720891009595010e-21,  8.489071502947740e-24, -1.904379438685408e-26,  4.207282462172285e-29, -9.165827544501658e-32,
  8.422513242736565e-03, -3.470695678175449e-05,  1.069104023978496e-07, -2.914260102071416e-10,  7.404566549603483e-13, -1.793348548890619e-15,  4.186391714462791e-18,
 -9.475210999810535e-21,  2.084901669369621e-23, -4.464002957572429e-26,  9.289277115599839e-29, -1.873958915297946e-31,  1.650089313559521e-02, -6.781295855098428e-05,
  2.076640802242160e-07, -5.602598603024701e-10,  1.400693319023364e-12, -3.312941508944372e-15,  7.479231695175129e-18, -1.616227245098060e-20,  3.336644083914051e-23,
 -6.537558849393315e-26,  1.197719112032163e-28, -1.989828532401202e-31,  2.726095806140741e-02, -1.116293974084736e-04,  3.391458682633675e-07, -9.022405549817649e-10,
  2.205831455194387e-12, -5.044544161344378e-15,  1.083797608960145e-17, -2.176984690487463e-20,  4.020799219504397e-23, -6.560165863765104e-26,  8.398288990503129e-29,
 -3.921920110310548e-32,  4.069302030239706e-02, -1.658762446278973e-04,  4.989245229479467e-07, -1.303636628986974e-09,  3.095096572043497e-12, -6.760687259212320e-15,
  1.351624959697944e-17, -2.411830716965577e-20,  3.571584021375542e-23, -3.257022031084519e-26, -3.748059791076319e-29,  3.143826795452057e-31,  5.678476015810636e-02,
 -2.302015598647610e-04,  6.839833217853937e-07, -1.747765502485164e-09,  3.997069424461821e-12, -8.207376673288972e-15,  1.474395955771497e-17, -2.122972902632236e-20,
  1.583530280368251e-23,  3.870579042721472e-26, -2.374170453909430e-28,  7.829839537613409e-31,  7.552108260195567e-02, -3.041802665148971e-04,  8.907363744461187e-07,
 -2.215323103917249e-09,  4.832666186746972e-12, -9.122918085439518e-15,  1.382104677246220e-17, -1.171422086894644e-20, -2.055112063697324e-23,  1.416870513807370e-25,
 -4.707221633931345e-28,  1.182590359797325e-30,  9.688394193898198e-02, -3.873127305487867e-04,  1.115049645092772e-06, -2.684787347187314e-09,  5.518652500030022e-12,
 -9.259041747840883e-15,  1.021525529723545e-17,  4.871787723186269e-21, -7.062654357318590e-23,  2.567065360318523e-25, -6.573111403235851e-28,  1.263328438108126e-30,
  1.208521326227527e-01, -4.790231737130257e-04,  1.352267507416173e-06, -3.132899064450503e-09,  5.971644864376066e-12, -8.403455625685811e-15,  3.656104731890107e-18,
  2.774435354966648e-20, -1.272135713841433e-22,  3.523751265229480e-25, -6.975635671425920e-28,  7.904975395361464e-31,  1.474010440654164e-01, -5.786579610819290e-04,
  1.597245813538505e-06, -3.535223907515465e-09,  6.112534309266852e-12, -6.402758268713717e-15, -5.783736476808072e-18,  5.473730376901998e-20, -1.791133641013746e-22,
  3.904153321226453e-25, -4.993813160045143e-28, -3.482891461628081e-31,  1.765023769480216e-01, -6.854838140710168e-04,  1.844392624286337e-06, -3.866798230739626e-09,
  5.871243580427373e-12, -3.184432932335665e-15, -1.762916722735871e-17,  8.231927145986412e-20, -2.123290636291058e-22,  3.337422518960406e-25, -1.258028803056894e-29,
 -2.039554324584658e-30,  2.081238182124698e-01, -7.986860136336508e-04,  2.087717918825498e-06, -4.102860927601686e-09,  5.191699501424325e-12,  1.223570291845062e-15,
 -3.097519224053849e-17,  1.058181998412284e-19, -2.121818285956286e-22,  1.568735860485202e-25,  7.370280717747391e-28, -3.883280311630480e-30,  2.422286715979507e-01,
 -9.173666749523044e-04,  2.320893771716543e-06, -4.219671454098523e-09,  4.036866142851168e-12,  6.677363723323835e-15, -4.450061935078980e-17,  1.198730587319836e-19,
 -1.661832780238640e-22, -1.430389225685868e-25,  1.624102840116949e-27, -5.215171689489750e-30,  2.787754402827280e-01, -1.040543195063637e-03,  2.537326647707698e-06,
 -4.195411645062171e-09,  2.393641706164253e-12,  1.290763876712839e-14, -5.653098627401353e-17,  1.191094123078125e-19, -6.735830278147502e-23, -5.369787491177780e-25,
  2.421926263170743e-27, -5.239981189119647e-30,  3.177173579199770e-01, -1.167146999130325e-03,  2.730243607875962e-06, -4.011165192161205e-09,  2.773728695167622e-13,
  1.951816320478281e-14, -6.515639106404330e-17,  9.900505184361842e-20,  8.246731299976024e-23, -9.595250263473969e-25,  2.831646273097834e-27, -3.277340727812482e-30,
  3.590018641325364e-01, -1.296022740139351e-03,  2.892794328934676e-06, -3.651963552826416e-09, -2.264314168841534e-12,  2.599426890637413e-14, -6.840610397530095e-17,
  5.687488253274069e-20,  2.700639322697994e-22, -1.311910514653881e-24,  2.546884431440601e-27,  9.183610123246253e-31,  4.025700203810926e-01, -1.425928141324447e-03,
  3.018170888096433e-06, -3.107880325043419e-09, -5.148724284370032e-12,  3.172320252175907e-14, -6.447640307748909e-17, -7.137244442621973e-21,  4.696414856534878e-22,
 -1.474930149145636e-24,  1.349218594134855e-27,  6.848898553940872e-30,  4.483558620771153e-01, -1.555534711203543e-03,  3.099747228103535e-06, -2.375147479027857e-09,
 -8.256760607754332e-12,  3.602785463749988e-14, -5.200085695202555e-17, -8.921393273182760e-20,  6.439151309661848e-22, -1.332449775010246e-24, -7.816946489265284e-28,
  1.309862261324530e-29,  4.962856829201494e-01, -1.683429608306636e-03,  3.131240050088533e-06, -1.457256038515850e-09, -1.143351255362506e-11,  3.821472918677590e-14,
 -3.034331881770175e-17, -1.813566437385826e-19,  7.480316576045442e-22, -8.038382875991188e-25, -3.572333770192276e-27,  1.743552197330625e-29,  5.462772477563544e-01,
 -1.808118986743067e-03,  3.106892532798109e-06, -3.659906896161249e-10, -1.449126156327809e-11,  3.763598225092083e-14,  1.164404583770060e-19, -2.714245731467484e-19,
  7.366541446661859e-22,  1.195695259761045e-25, -6.412988868531788e-27,  1.729362873006243e-29,  5.982389308552445e-01, -1.928033214635772e-03,  3.021681678281893e-06,
  8.776676357691611e-10, -1.721540418029414e-11,  3.376387077692566e-14,  3.774540309734197e-17, -3.439207307532281e-19,  5.739215967259338e-22,  1.342425097360368e-24,
 -8.410473018396344e-27,  1.064688412484214e-29,  6.520687774775530e-01, -2.041534424436945e-03,  2.871549153799186e-06,  2.242854623372468e-09, -1.937374748163504e-11,
  2.627395419576739e-14,  7.951911201810195e-17, -3.816741217119961e-19,  2.451822157945891e-22,  2.649199204108889e-24, -8.566306293295058e-27, -2.877746897347850e-30,
  7.076534880750459e-01, -2.146926925606643e-03,  2.653654139216872e-06,  3.688453097170865e-09, -2.072951792187653e-11,  1.513088584423130e-14,  1.210400061416966e-16,
 -3.684575071467150e-19, -2.315852342907925e-22,  3.716535670873870e-24, -6.081257892269214e-27, -2.100041587475406e-29,  7.648673265648491e-01, -2.242471083096752e-03,
  2.366644787010177e-06,  5.163162151696977e-09, -2.105821538984511e-11,  6.677120864828042e-16,  1.567696132683384e-16, -2.924030926077033e-19, -7.977250559833966e-22,
  4.164460226846091e-24, -7.383668427327113e-28, -3.842377537004905e-29,  8.235709570267119e-01, -2.326401334640008e-03,  2.010942339504190e-06,  6.606142278119071e-09,
 -2.016811194188349e-11, -1.635348937971753e-14,  1.805211320419375e-16, -1.498346147872015e-19, -1.352967395098929e-21,  3.649435034597645e-24,  6.744234077163120e-27,
 -4.765472640769680e-29,  8.836102170807368e-01, -2.396949078500051e-03,  1.589028612010377e-06,  7.948384507215087e-09, -1.792371392471293e-11, -3.471459562695366e-14,
  1.862329022544913e-16,  5.115516257185524e-20, -1.765274002961961e-21,  1.989114102050729e-24,  1.455338743442112e-26, -4.132714199701665e-29,  9.448148413409966e-01,
 -2.452371200182185e-03,  1.105723354973985e-06,  9.114951496470237e-09, -1.427086169600046e-11, -5.276478438313436e-14,  1.689981384090076e-16,  2.883358956909070e-19,
 -1.893857296749597e-21, -7.091333365320295e-25,  1.999254724046879e-26, -1.575872321519903e-29,  1.006997154951276e+00, -2.490985006414545e-03,  5.684329287222359e-07,
  1.002822103310452e-08, -9.261339362318543e-12, -6.851068597675824e-14,  1.262606424313947e-16,  5.253213254586234e-19, -1.624845908774667e-21, -3.962074314561117e-24,
  2.018364928928838e-26,  2.538748424806907e-29,  1.069950765540060e+00, -2.511210277087398e-03, -1.265415107161412e-08,  1.061221935711073e-08, -3.073952775723862e-12,
 -7.978613115574217e-14,  5.900361500808617e-17,  7.150042000501511e-19, -9.144517619211073e-22, -6.923559262915951e-24,  1.321362164420197e-26,  6.930257458440915e-29,
  1.133449292205662e+00, -2.511619004569749e-03, -6.244556399782605e-07,  1.079805364031376e-08,  3.971888425728053e-12, -8.450585113637853e-14, -2.732896809159875e-17,
  8.071352410693915e-19,  1.711931536188936e-22, -8.545131414778193e-24, -5.793754503044767e-28,  9.629019186357839e-29,  1.197245182514471e+00, -2.490993132805217e-03,
 -1.251005190365281e-06,  1.053033061683454e-08,  1.141479441932410e-11, -8.099313089620640e-14, -1.225084662924594e-16,  7.598287641528667e-19,  1.435438304689582e-21,
 -7.895404754168503e-24, -1.776075812748963e-26,  8.722868234972239e-29,  1.261068682989856e+00, -2.448390198846871e-03, -1.873625854358350e-06,  9.774274960715180e-09,
  1.866722021678058e-11, -6.835089197522333e-14, -2.121410519823502e-16,  5.533614926322674e-19,  2.567299771352144e-21, -4.579685547148222e-24, -3.210607180368658e-26,
  3.470862749040189e-29,  1.324627044990716e+00, -2.383216177992397e-03, -2.471313273818532e-06,  8.523036073417311e-09,  2.505293777884548e-11, -4.682053786640401e-14,
 -2.794944243084641e-16,  2.029161568224256e-19,  3.206707376021805e-21,  8.859463836333168e-25, -3.654451261458043e-26, -4.730108083383642e-29,  1.387604065696234e+00,
 -2.295304004872903e-03, -3.021373257019461e-06,  6.804406724969244e-09,  2.986878390188380e-11, -1.804751499574299e-14, -3.085750695926365e-16, -2.345607124650818e-19,
  3.056319424101036e-21,  6.957438660233248e-24, -2.650798349734336e-26, -1.228214842558673e-28,  1.449660082122688e+00, -2.184995163872725e-03, -3.500350668466747e-06,
  4.685901047707924e-09,  3.246984534795878e-11,  1.484508243330796e-14, -2.881258719605180e-16, -6.646005228142958e-19,  2.013944339140967e-21,  1.139780748345876e-23,
 -3.377317131693000e-27, -1.479269545503388e-28,  1.510432553070382e+00, -2.053220416616041e-03, -3.885269400782744e-06,  2.276906968045765e-09,  3.237197032561012e-11,
  4.747198011209818e-14, -2.157312841087775e-16, -9.740440563102362e-19,  2.744838065802097e-22,  1.210848190296822e-23,  2.416355746624747e-26, -9.701580845325773e-29,
  1.569537377245871e+00, -1.901574209950788e-03, -4.155174104759368e-06, -2.734784405602378e-10,  2.935874942310971e-11,  7.475389935776056e-14, -1.007583520336629e-16,
 -1.063471155810450e-18, -1.662231224913754e-21,  8.217662149807563e-24,  4.284968152147222e-26,  1.301722373716987e-29,  1.626571102303761e+00, -1.732375698509922e-03,
 -4.292921762721665e-06, -2.784196972162175e-09,  2.357299335639714e-11,  9.182754132966734e-14,  3.534506898778441e-17, -8.854697413500924e-19, -3.123797177200594e-21,
  8.847146882754392e-25,  4.165542102370329e-26,  1.216789896836268e-28,  1.681114175197265e+00, -1.548707820859448e-03, -4.287115714155636e-06, -5.056357731392952e-09,
  1.556731587847570e-11,  9.517315868275711e-14,  1.625542033997538e-16, -4.742408362330669e-19, -3.526456366404786e-21, -6.814306022243950e-24,  1.948077797989716e-26,
  1.584265297473583e-28,  1.732735364491507e+00, -1.354424784144154e-03, -4.134010600880763e-06, -6.893647229172582e-09,  6.287626125591028e-12,  8.370565654703229e-14,
  2.496969095188913e-16,  5.056142947290663e-20, -2.669847238106701e-21, -1.121533492571108e-23, -1.190205654649164e-26,  9.540081422193372e-29,  1.780997445695735e+00,
 -1.154118025375356e-03, -3.839153028871368e-06, -8.127600624766047e-09, -3.029735883795982e-12,  5.947553484774149e-14,  2.742708133391870e-16,  5.169210966299499e-19,
 -9.045770867338927e-22, -1.013344233090625e-23, -3.377681032160761e-26, -2.248090220280266e-29,  1.825464177695298e+00, -9.530316641189734e-04, -3.418474131406767e-06,
 -8.644711415306039e-09, -1.104983411619146e-11,  2.762066450827165e-14,  2.313635049911710e-16,  7.657935642447065e-19,  9.719813301754137e-22, -4.413745602901997e-24,
 -3.317682068008359e-26, -1.063035154834357e-28,  1.865708510737254e+00, -7.569210441626627e-04, -2.898535569896891e-06, -8.410808141475296e-09, -1.659713643384891e-11,
 -4.644309111555500e-15,  1.375256415641539e-16,  7.233633884990714e-19,  2.103655289360345e-21,  2.348207289247949e-24, -1.311408835721422e-26, -9.765407626078706e-29,
  1.901321856611786e+00, -5.718524233108144e-04, -2.315669440337302e-06, -7.487141536255270e-09, -1.892817786974847e-11, -2.990778655325710e-14,  2.646507432512164e-17,
  4.417303086850193e-19,  2.058400837066188e-21,  6.125572922525553e-24,  9.457938898600879e-27, -2.136926914985974e-29,  1.931924127425592e+00, -4.039481383309196e-04,
 -1.713859081349745e-06, -6.032783870127470e-09, -1.794554996048738e-11, -4.282624463370599e-14, -6.335136381099286e-17,  7.733170328453758e-20,  1.089583114871015e-21,
  5.303940260004785e-24,  1.803683076080741e-26,  4.274355927301208e-29,  1.957174125619808e+00, -2.590891133536669e-04, -1.141382343037535e-06, -4.289682339054031e-09,
 -1.427711823848286e-11, -4.198123785192205e-14, -1.047338628899744e-16, -1.912616271940297e-19, -4.892392223983097e-23,  1.710661450483255e-24,  1.062340490834763e-26,
  4.440794134011279e-29,  1.976779774280109e+00, -1.425942921305178e-04, -6.464612210683367e-07, -2.550058195574420e-09, -9.169511237885117e-12, -3.050631252637448e-14,
 -9.386061248046288e-17, -2.631816545374297e-19, -6.459031835539529e-22, -1.227782273959873e-24, -7.749225560032997e-28,  8.182402890800113e-30,  1.990507731186290e+00,
 -5.890239801993275e-05, -2.723868178612007e-07, -1.110205520239813e-09, -4.196873476475301e-12, -1.502949656178274e-14, -5.147959557835856e-17, -1.692850553540270e-19,
 -5.343029519218483e-22, -1.612092087389983e-24, -4.607354352351119e-27, -1.224554822513243e-29,  1.998193761944062e+00, -1.127368651068752e-05, -5.271117886551857e-08,
 -2.187293137842065e-10, -8.492534314780958e-13, -3.158091904510153e-15, -1.138646515586481e-17, -4.008909084074557e-20, -1.384385995337372e-22, -4.702358648406505e-25,
 -1.573985461688007e-27, -5.197677670108219e-30,  3.315451498571806e-04, -1.358655318969967e-06,  4.175171605452761e-09, -1.140303385408868e-11,  2.918996395457884e-14,
 -7.171586047653313e-17,  1.712428650288741e-19, -4.004246325758449e-22,  9.212694810436070e-25, -2.092672569638927e-27,  4.703051872295584e-30, -1.047837879606082e-32,
  2.983516450826703e-03, -1.221579452436005e-05,  3.746896394786285e-08, -1.020000997239702e-10,  2.597952209805912e-13, -6.337197127949332e-16,  1.498547651175310e-18,
 -3.459892869956577e-21,  7.832840165217200e-24, -1.743883436583871e-26,  3.824035905716656e-29, -8.270689110786441e-32,  8.285374114456760e-03, -3.386546329771657e-05,
  1.034832079442714e-07, -2.798602693072260e-10,  7.055733116327810e-13, -1.695984888255610e-15,  3.930189595004561e-18, -8.833053815535360e-21,  1.930691722935497e-23,
 -4.108420357740764e-26,  8.501992109284933e-29, -1.707262549694707e-31,  1.623292187823148e-02, -6.617816236696452e-05,  2.010732730948436e-07, -5.383692366430722e-10,
  1.336193462860331e-12, -3.138751960768937e-15,  7.041288913558097e-18, -1.513129493714222e-20,  3.109708066923412e-23, -6.075595348687138e-26,  1.113043786620501e-28,
 -1.860031920904240e-31,  2.681979907242798e-02, -1.089589455997561e-04,  3.285274572437086e-07, -8.677404507045398e-10,  2.107493054447253e-12, -4.791604170734999e-15,
  1.024608312250690e-17, -2.052033293037134e-20,  3.790635517200850e-23, -6.228001378376534e-26,  8.202616648750192e-29, -4.927553974422395e-32,  4.003740021498037e-02,
 -1.619465912991030e-04,  4.835736070882639e-07, -1.255179395903004e-09,  2.963072689266437e-12, -6.444272964723616e-15,  1.285675951182100e-17, -2.299442395027476e-20,
  3.451951951276925e-23, -3.380810756081084e-26, -2.477959514582291e-29,  2.641387511016400e-31,  5.587476634020090e-02, -2.248125111830146e-04,  6.633884992804878e-07,
 -1.685106546899218e-09,  3.836412593424787e-12, -7.860596348783899e-15,  1.415681815096212e-17, -2.070247195378516e-20,  1.706581911365630e-23,  2.987031716207626e-26,
 -2.050262563276233e-28,  6.910267937951579e-31,  7.431844679093963e-02, -2.971594102934158e-04,  8.646104700994051e-07, -2.139442201975230e-09,  4.653497943886119e-12,
 -8.795218668325826e-15,  1.348458316769663e-17, -1.229377914622249e-20, -1.577706432680039e-23,  1.238662562541834e-25, -4.211094264932314e-28,  1.073869632250079e-30,
  9.535232986798665e-02, -3.785197160942173e-04,  1.083355919864111e-06, -2.597956991281244e-09,  5.335933091273794e-12, -9.012485725281850e-15,  1.032137840286744e-17,
  2.754634315625046e-21, -6.184516830192146e-23,  2.315046637183390e-25, -6.033098289914531e-28,  1.190949888048677e-30,  1.189574403840021e-01, -4.683538012623866e-04,
  1.315240466414508e-06, -3.038692275961551e-09,  5.804513812868770e-12, -8.306835483031245e-15,  4.377824009065218e-18,  2.387117087218009e-20, -1.150218266627402e-22,
  3.251793088142841e-25, -6.619880584733750e-28,  8.234095571308045e-31,  1.451117018114117e-01, -5.660480324905016e-04,  1.555405681087185e-06, -3.438454832270864e-09,
  5.983211898677840e-12, -6.523811035746832e-15, -4.329249472042202e-18,  4.922667382542429e-20, -1.654211040869658e-22,  3.701940871052469e-25, -5.102526048555161e-28,
 -1.520987431296251e-31,  1.737896603450531e-01, -6.709126873994049e-04,  1.798552510818192e-06, -3.773390061147734e-09,  5.803506700831665e-12, -3.580630358565848e-15,
 -1.541754650945265e-17,  7.571671111832626e-20, -2.003439959424243e-22,  3.315568736624357e-25, -9.398775557835436e-29, -1.668666128853663e-30,  2.049621678229460e-01,
 -7.821797938629566e-04,  2.038982670283059e-06, -4.019637362328560e-09,  5.208972914405038e-12,  5.149587572797992e-16, -2.810645243152658e-17,  9.912410479503155e-20,
 -2.060435867423328e-22,  1.830808613512494e-25,  5.768181539662912e-28, -3.405157601556797e-30,  2.385960200665284e-01, -8.990009612025728e-04,  2.270649475598504e-06,
 -4.154070116101127e-09,  4.160002016543905e-12,  5.649020967149056e-15, -4.121931111364760e-17,  1.144849001539256e-19, -1.702174852871431e-22, -8.253875151332658e-26,
  1.404012118000293e-27, -4.788805765769634e-30,  2.746535468219807e-01, -1.020445291424103e-03,  2.487219780912683e-06, -4.155120742649639e-09,  2.638495852757099e-12,
  1.159065508674820e-14, -5.322887467645227e-17,  1.166628953716315e-19, -8.500097297317636e-23, -4.446743096308946e-25,  2.194368074187150e-27, -5.093013213956408e-30,
  3.130921491175630e-01, -1.145497481630818e-03,  2.682148862719978e-06, -4.003688336578172e-09,  6.523245517445399e-13,  1.798794257526790e-14, -6.235234302090258e-17,
  1.011128905421522e-19,  4.992736814564349e-23, -8.492595080681400e-25,  2.678995778791232e-27, -3.639282959162817e-30,  3.538637795138812e-01, -1.273056256717353e-03,
  2.848770260931163e-06, -3.684122139596243e-09, -1.760712399098389e-12,  2.437256598785759e-14, -6.669957813588954e-17,  6.478099029192005e-20,  2.246758338125648e-22,
 -1.209533618376429e-24,  2.564691743971665e-27, -7.982199576964508e-32,  3.969143604368744e-01, -1.401933305255474e-03,  2.980402711516483e-06, -3.185268316437594e-09,
 -4.529742188077263e-12,  3.017502028177180e-14, -6.447375132167088e-17,  7.052700640762977e-21,  4.175838009459459e-22, -1.415400340979862e-24,  1.616016724046368e-27,
  5.303684899319381e-30,  4.421831355777863e-01, -1.530852931978854e-03,  3.070476365848264e-06, -2.501559809123013e-09, -7.548874213167031e-12,  3.475214207535696e-14,
 -5.421762095217727e-17, -6.938107728539804e-20,  5.955184082316826e-22, -1.352696433307882e-24, -2.430871677171213e-28,  1.138994062395933e-29,  4.896019492620448e-01,
 -1.658452688290247e-03,  3.112680449371212e-06, -1.634119128594829e-09, -1.067689782099707e-11,  3.742823089724071e-14, -3.509072506239428e-17, -1.579087397563068e-19,
  7.167031731684464e-22, -9.317325907072749e-25, -2.831200764540670e-27,  1.622556235519694e-29,  5.390944487853785e-01, -1.783285298461883e-03,  3.101134316707918e-06,
 -5.918315016343824e-10, -1.373911578633835e-11,  3.755024415097993e-14, -7.153123754753255e-18, -2.478307848063441e-19,  7.365251879845552e-22, -1.216812345465821e-25,
 -5.649017772115468e-27,  1.736759191820565e-29,  5.905752050636250e-01, -1.903822264128175e-03,  3.030583445846127e-06,  6.076693719753554e-10, -1.653183697367051e-11,
  3.455632074268508e-14,  2.837954729750213e-17, -3.248459775978761e-19,  6.163119548706655e-22,  1.015993193545991e-24, -7.896819492271694e-27,  1.261114117681251e-29,
  6.439487476371781e-01, -2.018459603251820e-03,  2.896621196332623e-06,  1.937178572777943e-09, -1.883004450045453e-11,  2.805514271198489e-14,  6.895594313709580e-17,
 -3.723686601494608e-19,  3.343659630550416e-22,  2.305197292189718e-24, -8.605400965962714e-27,  1.019368451244877e-30,  6.991085112327400e-01, -2.125526261166192e-03,
  2.695936030702902e-06,  3.359356067108871e-09, -2.039869007464994e-11,  1.791132876227696e-14,  1.106392149031213e-16, -3.737761761045497e-19, -1.023776638339946e-22,
  3.456283594111192e-24, -6.895012129080029e-27, -1.601374264747351e-29,  7.559356928660171e-01, -2.223295818522925e-03,  2.426582239310886e-06,  4.826539133166171e-09,
 -2.100791393219448e-11,  4.329189034275962e-15,  1.482474244741454e-16, -3.155404993405975e-19, -6.487324030704813e-22,  4.102344316960663e-24, -2.336129164029642e-27,
 -3.412919713893626e-29,  8.142980210569871e-01, -2.310002210156436e-03,  2.088269873207514e-06,  6.281069815432316e-09, -2.045222124535617e-11, -1.207609581637203e-14,
  1.757397317041930e-16, -1.909795162282584e-19, -1.217234614406308e-21,  3.877569622752740e-24,  4.671925609830946e-27, -4.636233980851670e-29,  8.740484423514671e-01,
 -2.383860253584275e-03,  1.682666425630971e-06,  7.656293969865483e-09, -1.857322661512598e-11, -3.023413097568794e-14,  1.868859492001327e-16, -4.079152413532147e-21,
 -1.683636521035132e-21,  2.533712318986873e-24,  1.265015277775102e-26, -4.494798902826437e-29,  9.350237352663292e-01, -2.443091856102537e-03,  1.213698666502306e-06,
  8.878398338908159e-09, -1.528497935715757e-11, -4.861881449543855e-14,  1.762203493277708e-16,  2.274768259380919e-19, -1.905183071821375e-21,  7.402504681879208e-26,
  1.910112410269630e-26, -2.457665800189803e-29,  9.970430683050034e-01, -2.485958810501654e-03,  6.878378222195385e-07,  9.869247431149168e-09, -1.060009000284311e-11,
 -6.530992420914817e-14,  1.402213883820840e-16,  4.712018983628973e-19, -1.752710480636333e-21, -3.135829217650362e-24,  2.104339187828910e-26,  1.369380869932822e-29,
  1.059906527154346e+00, -2.510803080623483e-03,  1.143449905810686e-07,  1.055035401686514e-08, -4.653910954537990e-12, -7.813333615538872e-14,  7.857734895054057e-17,
  6.818615857314545e-19, -1.153475895227671e-21, -6.336762803044748e-24,  1.605567003508969e-26,  5.962468524933572e-29,  1.123393646904831e+00, -2.516095391403432e-03,
 -4.945535632908692e-07,  1.084805497339366e-08,  2.277045026524255e-12, -8.489021409537374e-14, -4.698717026365317e-18,  8.076952241472537e-19, -1.358304076695146e-22,
 -8.483911699384512e-24,  3.626914003335468e-27,  9.444547969615204e-29,  1.187261998425038e+00, -2.500492737745620e-03, -1.123599355659132e-06,  1.069985599910392e-08,
  9.767278754869966e-12, -8.367310842308907e-14, -1.006338476242340e-16,  8.010856156903314e-19,  1.139368844226399e-21, -8.526048796915801e-24, -1.370137050092080e-26,
  9.684393461637309e-29,  1.251245894054702e+00, -2.462905068663514e-03, -1.754588494569797e-06,  1.006174314251819e-08,  1.725059084789743e-11, -7.324722552518387e-14,
 -1.955233132773890e-16,  6.326326580793371e-19,  2.379734946871049e-21, -5.827664395902287e-24, -3.015266032558777e-26,  5.394789155865769e-29,  1.315055296540637e+00,
 -2.402570837577001e-03, -2.366663835269121e-06,  8.916029471745914e-09,  2.404996858849042e-11, -5.344860947811431e-14, -2.723734055567796e-16,  3.057552507640914e-19,
  3.211840850359667e-21, -6.116021169994820e-25, -3.818393442135298e-26, -2.685668480631643e-29,  1.378375036269681e+00, -2.319140285153779e-03, -2.936866193462670e-06,
  7.279015251813231e-09,  2.943330167267104e-11, -2.552085355758607e-14, -3.137374042958849e-16, -1.329660724763279e-19,  3.286421636831530e-21,  5.791578496675485e-24,
 -3.171405010028665e-26, -1.130769929364299e-28,  1.440864464480039e+00, -2.212764194079574e-03, -3.440994186991741e-06,  5.207411879193535e-09,  3.269612871440877e-11,
  7.714416039112853e-15, -3.057710151469651e-16, -5.936281566742834e-19,  2.420237193660546e-21,  1.112952789198717e-23, -1.010394995373884e-26, -1.571531065859289e-28,
  1.502157692662047e+00, -2.084184404828120e-03, -3.854808413039468e-06,  2.802163446658386e-09,  3.326743215008330e-11,  4.196855225478106e-14, -2.428147384606904e-16,
 -9.581083487897926e-19,  7.266892846395626e-22,  1.298209180939996e-23,  1.933077475247054e-26, -1.225588120720019e-28,  1.561864588258460e+00, -1.934820631452555e-03,
 -4.155588522046631e-06,  2.080805564491922e-10,  3.082720359252827e-11,  7.197264717106145e-14, -1.312333872871004e-16, -1.111597715922282e-18, -1.335475002367849e-21,
  9.935424832671387e-24,  4.284140370385251e-26, -1.402999495000011e-29,  1.619572710398925e+00, -1.766846162377535e-03, -4.324008387071544e-06, -2.392299214278997e-09,
  2.541596054423505e-11,  9.236705068471040e-14,  9.159595824993916e-18, -9.845897506531777e-19, -3.060688132556517e-21,  2.655418844365458e-24,  4.680566694572305e-26,
  1.114925676508677e-28,  1.674850371949496e+00, -1.583243071416877e-03, -4.346234056588779e-06, -4.791845748304170e-09,  1.750864963911771e-11,  9.890214202551125e-14,
  1.476598810229477e-16, -5.908481861479933e-19, -3.756024771121995e-21, -5.891249933051453e-24,  2.677618285781893e-26,  1.727085757739810e-28,  1.727250999852988e+00,
 -1.387825924434196e-03, -4.216074454183114e-06, -6.779326398498677e-09,  8.021729699637521e-12,  8.970534070818807e-14,  2.498552353674119e-16, -4.141691690421218e-20,
 -3.081085230147515e-21, -1.159953361831505e-23, -7.107545603116364e-27,  1.228970737735691e-28,  1.776318928406851e+00, -1.185222105773863e-03, -3.936934665345609e-06,
 -8.166197806358596e-09, -1.773246183816177e-12,  6.622810246170666e-14,  2.882826425099075e-16,  4.818753765266191e-19, -1.293892479296145e-21, -1.149915371700972e-23,
 -3.437278816987978e-26, -3.804024257945720e-30,  1.821596694269381e+00, -9.807973648930757e-04, -3.523252225479820e-06, -8.816780405217283e-09, -1.044013925774725e-11,
  3.343405374631233e-14,  2.532154058264842e-16,  7.940893017995960e-19,  7.880609543783230e-22, -5.835534810814615e-24, -3.793681174970703e-26, -1.096080509807894e-28,
  1.862633804388968e+00, -7.805175677932230e-04, -3.001061057880262e-06, -8.676919056200157e-09, -1.665533624323473e-11, -1.092962520413683e-15,  1.587341905573831e-16,
  7.919229793123287e-19,  2.177667237638766e-21,  1.732652748715553e-24, -1.779128239101634e-26, -1.151754042631165e-28,  1.898996819856694e+00, -5.907423553058261e-04,
 -2.407351859380116e-06, -7.794738775744245e-09, -1.951894079722993e-11, -2.911655388613275e-14,  3.978934703904151e-17,  5.111984335033054e-19,  2.285472683991237e-21,
  6.481543065929200e-24,  8.247827355614159e-27, -3.410951107529268e-29,  1.930280447657806e+00, -4.179535314257266e-04, -1.788003791317880e-06, -6.326846669424256e-09,
 -1.881708266293527e-11, -4.431657248014618e-14, -6.066822377005606e-17,  1.153963827119326e-19,  1.293968791525998e-21,  6.063460679024257e-24,  1.994825359833779e-26,
  4.398218109533217e-29,  1.956119175465374e+00, -2.684300249342395e-04, -1.194257289451006e-06, -4.524971625118464e-09, -1.514231356581518e-11, -4.455923144436527e-14,
 -1.101012407973967e-16, -1.917558899947094e-19,  2.079905960978246e-23,  2.176822733098829e-24,  1.273951261421927e-26,  5.194050065479766e-29,  1.976198856344383e+00,
 -1.478909259769024e-04, -6.779627300757415e-07, -2.701776327657696e-09, -9.802773176067973e-12, -3.284977288419544e-14, -1.015257465121699e-16, -2.845629855986500e-19,
 -6.905666144399513e-22, -1.250699734008897e-24, -3.478727310380862e-28,  1.135352178265441e-29,  1.990267677387227e+00, -6.113594726649406e-05, -2.861223253640059e-07,
 -1.179828991758723e-09, -4.510212666482064e-12, -1.632387359658980e-14, -5.646792930867489e-17, -1.873479625463716e-19, -5.957892305645833e-22, -1.807583471379385e-24,
 -5.177886480787623e-27, -1.371083128664106e-29,  1.998147806863164e+00, -1.170611084430456e-05, -5.541959246236072e-08, -2.328379022022224e-10, -9.152415983995369e-13,
 -3.445353684454782e-15, -1.257361440384419e-17, -4.480259514300599e-20, -1.565577334608018e-22, -5.380191715922463e-25, -1.821627392023732e-27, -6.083344027329331e-30,
  3.261764757634474e-04, -1.325793459657170e-06,  4.041090816331796e-09, -1.094724942078297e-11,  2.779585379553581e-14, -6.773731141649609e-17,  1.604326322276769e-19,
 -3.721139636287280e-22,  8.492112644569001e-25, -1.913453454537346e-27,  4.265555993523259e-30, -9.427514239374593e-33,  2.935245122652035e-03, -1.192086910398354e-05,
  3.626949107845613e-08, -9.794284967212432e-11,  2.474727750803458e-13, -5.988893393252707e-16,  1.405087448482082e-18, -3.218998509378827e-21,  7.231720359154343e-24,
 -1.597957692519408e-26,  3.478093396349413e-29, -7.468408938130144e-32,  8.151546990795372e-03, -3.305084155616129e-05,  1.001915167748165e-07, -2.688374117879064e-10,
  6.725771810971083e-13, -1.604559773762311e-15,  3.691295835126798e-18, -8.238255029962503e-21,  1.788733158647338e-23, -3.782908441538241e-26,  7.784626559870410e-29,
 -1.555896254053965e-31,  1.597138599195367e-02, -6.459505917289895e-05,  1.947390746048905e-07, -5.174833017627463e-10,  1.275074587884083e-12, -2.974734685556138e-15,
  6.631221370802147e-18, -1.417034030183758e-20,  2.898806675862451e-23, -5.646377536476465e-26,  1.033946158640471e-28, -1.736343996872766e-31,  2.638915458085373e-02,
 -1.063718114427229e-04,  3.183137714612876e-07, -8.347740505221531e-10,  2.014074190551743e-12, -4.552457987429378e-15,  9.688163277571667e-18, -1.934257399825082e-20,
  3.572278889133506e-23, -5.904472464502447e-26,  7.968314605321366e-29, -5.685354625498693e-32,  3.939725675890476e-02, -1.581374547850789e-04,  4.687917098096364e-07,
 -1.208784768010372e-09,  2.837221341206708e-12, -6.143313171188901e-15,  1.222819618032231e-17, -2.190944216321330e-20,  3.328726583801655e-23, -3.458009235932858e-26,
 -1.413574277956348e-29,  2.207248981645088e-31,  5.498600390093946e-02, -2.195852566279403e-04,  6.435303875956623e-07, -1.624963376294476e-09,  3.682551672539922e-12,
 -7.527726095273259e-15,  1.358494513379701e-17, -2.014068527044118e-20,  1.800063175833418e-23,  2.225251754863160e-26, -1.764617606414360e-28,  6.089016686666993e-31,
  7.314348208914100e-02, -2.903439672619507e-04,  8.393781512707298e-07, -2.066376003975060e-09,  4.480801710415409e-12, -8.475772425646530e-15,  1.313393693944044e-17,
 -1.273045860401026e-20, -1.160996673193333e-23,  1.079366676078581e-25, -3.761034862465861e-28,  9.731591226070499e-31,  9.385538928464385e-02, -3.699761329085065e-04,
  1.052686780964603e-06, -2.514010578161746e-09,  5.158165631412900e-12, -8.764063181844705e-15,  1.037202181267922e-17,  9.043792692518572e-22, -5.393295141986272e-23,
  2.083986866217199e-25, -5.525250861800970e-28,  1.117370205258499e-30,  1.171048402981367e-01, -4.579761685207623e-04,  1.279327929012737e-06, -2.947143220042994e-09,
  5.639479816499215e-12, -8.194152276513687e-15,  4.996410862012131e-18,  2.037273638401873e-20, -1.037832173316555e-22,  2.994301097603709e-25, -6.253588131080172e-28,
  8.389885773769282e-31,  1.428721371342161e-01, -5.537682153907034e-04,  1.514714288695093e-06, -3.343772438966433e-09,  5.851805264537587e-12, -6.611758850348457e-15,
 -3.023035914357204e-18,  4.414248107264771e-20, -1.524626544528756e-22,  3.496998752598190e-25, -5.132871661248509e-28,  8.728594131086518e-33,  1.711345018791946e-01,
 -6.567038170516213e-04,  1.753826540326421e-06, -3.681126251341975e-09,  5.728361910665932e-12, -3.925924104224829e-15, -1.338544429792859e-17,  6.949581678911315e-20,
 -1.884924083389377e-22,  3.264277950612383e-25, -1.600995640381876e-28, -1.343670019770753e-30,  2.018657688787624e-01, -7.660594577042010e-04,  1.991247307032345e-06,
 -3.936247122774281e-09,  5.212747530294026e-12, -1.270292133758951e-16, -2.542226410055557e-17,  9.264033254560696e-20, -1.990722648361591e-22,  2.032894139786504e-25,
  4.368166138880506e-28, -2.964820611270412e-30,  2.350360325123270e-01, -8.810340210001412e-04,  2.221203551593601e-06, -4.086658911672229e-09,  4.263346261676794e-12,
  4.697606552329385e-15, -3.809036311591505e-17,  1.090008326259313e-19, -1.722276328118444e-22, -3.046737536647998e-26,  1.202639319263588e-27, -4.365673089281526e-30,
  2.706112464194512e-01, -1.000746244129245e-03,  2.437619055617265e-06, -4.111118609726853e-09,  2.857796966920775e-12,  1.035203926706378e-14, -5.000268236393783e-17,
  1.137032373239834e-19, -9.948280413018147e-23, -3.613252281849264e-25,  1.974566263962289e-27, -4.890004974598550e-30,  3.085527695784105e-01, -1.124232263518721e-03,
  2.634178837141003e-06, -3.990453414905310e-09,  9.973489807928864e-13,  1.652561329316120e-14, -5.950326520350500e-17,  1.022417566259234e-19,  2.124358292609929e-23,
 -7.453806423185731e-25,  2.513216271024086e-27, -3.877277368162154e-30,  3.488168541899251e-01, -1.250443374922036e-03,  2.804407572739387e-06, -3.708480272850425e-09,
 -1.289118024222176e-12,  2.279431542663971e-14, -6.479146058591047e-17,  7.129370262763988e-20,  1.829760060985914e-22, -1.107271844527134e-24,  2.542366063332128e-27,
 -9.080870817853715e-31,  3.913540698992070e-01, -1.378244163212156e-03,  2.941764279892982e-06, -3.253000168263923e-09, -3.941691881560692e-12,  2.863148331547971e-14,
 -6.409676684322312e-17,  1.961301840681265e-20,  3.678453141999889e-22, -1.346512675597842e-24,  1.818251083629402e-27,  3.914860034057104e-30,  4.361086585234721e-01,
 -1.506411196855892e-03,  3.039755661900127e-06, -2.616852775921878e-09, -6.866990019032648e-12,  3.342971548563900e-14, -5.590082750951483e-17, -5.110456726353165e-20,
  5.467626063290118e-22, -1.352888582335266e-24,  2.214299018083094e-28,  9.735930965686588e-30,  4.830178131777140e-01, -1.633632529943310e-03,  3.092070588050266e-06,
 -1.799008192162385e-09, -9.937099854595502e-12,  3.653555601742509e-14, -3.919627714505160e-17, -1.355313996659165e-19,  6.812908755971916e-22, -1.031089858254145e-24,
 -2.146457661864108e-27,  1.488153711054665e-29,  5.320108755607440e-01, -1.758508311875541e-03,  3.092738130187789e-06, -8.056609543255551e-10, -1.299037599179246e-11,
  3.729795574242853e-14, -1.376338326337338e-17, -2.243741860167700e-19,  7.282610301834104e-22, -3.324188901407748e-25, -4.889962706888488e-27,  1.708057568356639e-29,
  5.830084452464279e-01, -1.879552872340359e-03,  3.036311340654784e-06,  3.487229466178474e-10, -1.583462456494101e-11,  3.513054185719538e-14,  1.956503802089992e-17,
 -3.045986327952692e-19,  6.473399826456376e-22,  7.116781779896917e-25, -7.308468789045728e-27,  1.404830509276830e-29,  6.359213952150836e-01, -1.995198727671266e-03,
  2.918078452966416e-06,  1.640473079916026e-09, -1.825323018659935e-11,  2.958625285304620e-14,  5.869141950797752e-17, -3.604074389743608e-19,  4.111774787006898e-22,
  1.962913499885518e-24, -8.484103676552474e-27,  4.408340900648266e-30,  6.906497886795840e-01, -2.103803044128181e-03,  2.734302308342545e-06,  3.035983548496624e-09,
 -2.001475924458987e-11,  2.044082396134540e-14,  1.001459351229038e-16, -3.751159640793033e-19,  1.692733146438009e-23,  3.167815715530377e-24, -7.493585680017128e-27,
 -1.123783044580310e-29,  7.470816936679290e-01, -2.203657193061395e-03,  2.482487424327637e-06,  4.491295450729270e-09, -2.088647796250659e-11,  7.778895541847384e-15,
  1.391437150643112e-16, -3.339578778480241e-19, -5.030796894374759e-22,  3.980213569795365e-24, -3.736541073076411e-27, -2.948192216698332e-29,  8.050918940196493e-01,
 -2.293000139699955e-03,  2.161672064699776e-06,  5.952129369136456e-09, -2.065202096357590e-11, -7.926782718486682e-15,  1.698682037524055e-16, -2.276654315374012e-19,
 -1.074764526522883e-21,  4.024256626789668e-24,  2.679179277332817e-27, -4.406459433733584e-29,  8.645404986875672e-01, -2.370036516359528e-03,  1.772739758026755e-06,
  7.354528435093801e-09, -1.913309695209523e-11, -2.575623914347273e-14,  1.860318498480527e-16, -5.640235890957474e-20, -1.583798412835012e-21,  2.999413391780325e-24,
  1.061883379072049e-26, -4.715492659161305e-29,  9.252714558138858e-01, -2.432960333562047e-03,  1.318740750107038e-06,  8.626291491928546e-09, -1.621458242037456e-11,
 -4.431997536061136e-14,  1.817376174390019e-16,  1.666988101471261e-19, -1.889047382103810e-21,  8.141090466850139e-25,  1.784762638453633e-26, -3.218752652310279e-29,
  9.871109843311645e-01, -2.479985365333009e-03,  8.052086824778375e-07,  9.689383622459772e-09, -1.187159984396764e-11, -6.179272332790295e-14,  1.526140201817127e-16,
  4.134723543419964e-19, -1.850334971056879e-21, -2.285452831218825e-24,  2.139168006696114e-26,  2.200982972306717e-30,  1.049865944235803e+00, -2.509383287634855e-03,
  2.404512447908124e-07,  1.046349898629750e-08, -6.196195085912341e-12, -7.602275148758041e-14,  9.711933409532208e-17,  6.414292753769448e-19, -1.369435662500742e-21,
 -5.645229958681320e-24,  1.844053789699783e-26,  4.858773207615178e-29,  1.113322177638644e+00, -2.519530622949595e-03, -3.642143336956513e-07,  1.087090680925500e-08,
  5.799411736359198e-13, -8.473236987913589e-14,  1.781022868586209e-17,  7.984979809371190e-19, -4.376484856828232e-22, -8.256873817554310e-24,  7.691746448922307e-27,
  8.988581474904460e-29,  1.177242866655348e+00, -2.508965410800658e-03, -9.943190532300746e-07,  1.084262123208711e-08,  8.071501401076484e-12, -8.581532322470942e-14,
 -7.773986129325826e-17,  8.325371109473430e-19,  8.236135000110814e-22, -8.986675164345136e-24, -9.280721183248836e-27,  1.035987971969171e-28,  1.241366971532003e+00,
 -2.476454233750256e-03, -1.632240672374358e-06,  1.032578425251561e-08,  1.574019917303115e-11, -7.771881740195124e-14, -1.767766480171505e-16,  7.051996328360373e-19,
  2.148850762549834e-21, -6.980870944490581e-24, -2.737604049145014e-26,  7.200908043956884e-29,  1.305407833312393e+00, -2.421069720787189e-03, -2.257399102755669e-06,
  9.291925136099501e-09,  2.291638013250744e-11, -5.987125436427383e-14, -2.623787769726603e-16,  4.078851676690445e-19,  3.162104487823512e-21, -2.156142036019119e-24,
 -3.888062285093254e-26, -4.566040488437885e-30,  1.369052049723019e+00, -2.342277857566427e-03, -2.846710585409305e-06,  7.745454578775379e-09,  2.884734825895614e-11,
 -3.308316049953444e-14, -3.159585942197876e-16, -2.471897038417067e-20,  3.470919847628415e-21,  4.427367619564001e-24, -3.639311828489849e-26, -9.888718139852863e-29,
  1.431958760127508e+00, -2.240033289350277e-03, -3.375362631199157e-06,  5.731380030608613e-09,  3.277573243204713e-11,  1.855712794772151e-16, -3.212487392798203e-16,
 -5.098615973547492e-19,  2.811942372440745e-21,  1.058532638867909e-23, -1.714085681238761e-26, -1.619113301780119e-28,  1.493759503928701e+00, -2.114879257855451e-03,
 -3.817962129394464e-06,  3.340831630666178e-09,  3.404637009964899e-11,  3.582213873743607e-14, -2.692449556342283e-16, -9.272383602867504e-19,  1.206596448777264e-21,
  1.364016895997923e-23,  1.339527933700187e-26, -1.469524332668716e-28,  1.554058844110834e+00, -1.968046858529103e-03, -4.150085225321609e-06,  7.126496441973569e-10,
  3.223261590740888e-11,  6.844506224308713e-14, -1.629002971693637e-16, -1.148281103642012e-18, -9.471821376596260e-22,  1.162795955147359e-23,  4.156222392203536e-26,
 -4.465092016016087e-29,  1.612435969745354e+00, -1.801546006266947e-03, -4.350215070574809e-06, -1.970862744499385e-09,  2.726321003586266e-11,  9.224509286166974e-14,
 -1.976310379972743e-17, -1.080631562894163e-18, -2.930249016603034e-21,  4.621465320098089e-24,  5.137939869277683e-26,  9.538607320737455e-29,  1.668447502661708e+00,
 -1.618238038559500e-03, -4.401989492036692e-06, -4.495696334530202e-09,  1.952071981132384e-11,  1.022336841898731e-13,  1.294031101762642e-16, -7.142125493488480e-19,
 -3.946967384799849e-21, -4.664745386935855e-24,  3.462785812222313e-26,  1.835093814577268e-28,  1.721631726997955e+00, -1.421877607358208e-03, -4.296596025571231e-06,
 -6.636300657254901e-09,  9.875648613783884e-12,  9.567642153137104e-14,  2.472521313930374e-16, -1.467367603576321e-19, -3.502405175506140e-21, -1.176715174063376e-23,
 -1.059341065562909e-27,  1.522682834100902e-28,  1.771514427852975e+00, -1.217109939782833e-03, -4.035054330081023e-06, -8.183592830053634e-09, -3.784292450198710e-13,
  7.330372529724671e-14,  3.011313639282682e-16,  4.335820080453654e-19, -1.732591187524587e-21, -1.287079581728634e-23, -3.403606181276587e-26,  1.999013491823873e-29,
  1.817616458759627e+00, -1.009409374871509e-03, -3.630032686880193e-06, -8.978135383444979e-09, -9.708871626211755e-12,  3.978068230183893e-14,  2.757692328741273e-16,
  8.156436563263311e-19,  5.495017862808817e-22, -7.449755697903000e-24, -4.277501297097522e-26, -1.096986520527741e-28,  1.859463051298922e+00, -8.049470789009206e-04,
 -3.106783028754007e-06, -8.943364639245695e-09, -1.663726228446439e-11,  2.990671091756767e-15,  1.818919677816285e-16,  8.624587535315034e-19,  2.225962277343058e-21,
  9.142041098813528e-25, -2.326780235522353e-26, -1.339310194863484e-28,  1.896594732852406e+00, -6.103806706892914e-04, -2.502781578199657e-06, -8.111643573737489e-09,
 -2.009051939975112e-11, -2.798136481325011e-14,  5.516230873592528e-17,  5.881274057308869e-19,  2.524345137357169e-21,  6.777018968517991e-24,  6.410695367955411e-27,
 -4.994355890566558e-29,  1.928579537315885e+00, -4.325664365122525e-04, -1.865761893276942e-06, -6.635088569600009e-09, -1.971768770930989e-11, -4.572895038014197e-14,
 -5.682349166296854e-17,  1.604537323685121e-19,  1.527083795699432e-21,  6.900218586533001e-24,  2.189032665316474e-26,  4.406885739532069e-29,  1.955025997446032e+00,
 -2.782054692690070e-04, -1.250040490197742e-06, -4.774523514420831e-09, -1.606035668571787e-11, -4.726593995375957e-14, -1.154485789912747e-16, -1.897335063457182e-19,
  1.089099882774739e-22,  2.734550970899332e-24,  1.520915250158239e-26,  6.048879037300615e-29,  1.975596236070597e+00, -1.534470302409546e-04, -7.113472294387582e-07,
 -2.864011806208372e-09, -1.048479328388706e-11, -3.538454272642633e-14, -1.098096659067419e-16, -3.073831633369088e-19, -7.357118542142975e-22, -1.253509658036013e-24,
  2.365808787287623e-28,  1.536637632236517e-29,  1.990018464208704e+00, -6.348280973855493e-05, -3.007242709265098e-07, -1.254679671474273e-09, -4.850678741187805e-12,
 -1.774426877558973e-14, -6.199066043725072e-17, -2.074955667871576e-19, -6.647398973498379e-22, -2.027227073710228e-24, -5.815996936453702e-27, -1.531769533105164e-29,
  1.998100077652132e+00, -1.216089809464491e-05, -5.830383871704638e-08, -2.480498572992734e-10, -9.872709554006932e-13, -3.762758627616897e-15, -1.390124007250685e-17,
 -5.013694564575407e-20, -1.773051749062264e-22, -6.165334867437737e-25, -2.111724535092918e-27, -7.132300945750717e-30,  3.209371379264772e-04, -1.293982742245375e-06,
  3.912348186740484e-09, -1.051314801381099e-11,  2.647878304865963e-14, -6.400895027843930e-17,  1.503837624437123e-19, -3.460092164915314e-22,  7.833007697013373e-25,
 -1.750843553607478e-27,  3.871771188673989e-30, -8.489260167953533e-33,  2.888134608280965e-03, -1.163534801810349e-05,  3.511754485430906e-08, -9.407730551221132e-11,
  2.358250415180898e-13, -5.662231962615833e-16,  1.318110697231105e-18, -2.996525481717737e-21,  6.680725816515763e-24, -1.465188678541984e-26,  3.165597222153574e-29,
 -6.748826392064247e-32,  8.020926512288851e-03, -3.226203308477821e-05,  9.702899161380295e-08, -2.583281702848021e-10,  6.413535412757314e-13, -1.518673284005725e-15,
  3.468437696164733e-18, -7.687062139502704e-21,  1.657992187661608e-23, -3.484801032347782e-26,  7.130754378271046e-29, -1.418432006895768e-31,  1.571608273546205e-02,
 -6.306164342033573e-05,  1.886497464654500e-07, -4.975495518331907e-10,  1.217139782831691e-12, -2.820243636188312e-15,  6.247138519628711e-18, -1.327446182698183e-20,
  2.702800570801496e-23, -5.247728815318284e-26,  9.601522983889114e-29, -1.618974311220344e-31,  2.596869767698204e-02, -1.038648294358407e-04,  3.084868697802457e-07,
 -8.032648052286607e-10,  1.925306980364607e-12, -4.326313942220148e-15,  9.162259821879439e-18, -1.823284436240047e-20,  3.365393150793775e-23, -5.590919139469725e-26,
  7.705334187229290e-29, -6.237518835771858e-32,  3.877211681679008e-02, -1.544443802865270e-04,  4.545546623427479e-07, -1.164356417517755e-09,  2.717240771429886e-12,
 -5.857078822390981e-15,  1.162945667597153e-17, -2.086425861298212e-20,  3.203444056347409e-23, -3.496271142525256e-26, -5.267843585188752e-30,  1.832803848560186e-31,
  5.411783726257074e-02, -2.145140214431813e-04,  6.243794406032170e-07, -1.567229461499890e-09,  3.535212197755986e-12, -7.208388899252922e-15,  1.302918124434880e-17,
 -1.955315882322513e-20,  1.868092375644761e-23,  1.570771180528283e-26, -1.513117730243379e-28,  5.356732563310832e-31,  7.199538092971905e-02, -2.837269220944184e-04,
  8.150062573223132e-07, -1.996022295447034e-09,  4.314409331985212e-12, -8.164873866190188e-15,  1.277284676276136e-17, -1.304262746499481e-20, -7.984976935360515e-24,
  9.372099940806936e-26, -3.353567786714311e-28,  8.802220903007785e-31,  9.239213863998445e-02, -3.616739213809651e-04,  1.023008097472266e-06, -2.432868647863463e-09,
  4.985374725113164e-12, -8.515019026428535e-15,  1.037428046329832e-17, -7.056081584377540e-22, -4.681676550108307e-23,  1.872593046201040e-25, -5.049789981540269e-28,
  1.043933490528346e-30,  1.152931830372267e-01, -4.478814864365584e-04,  1.244498213912899e-06, -2.858215904700879e-09,  5.476840217084689e-12, -8.067758667085195e-15,
  5.521939114139587e-18,  1.721938970994817e-20, -9.344508086904770e-23,  2.751554462140949e-25, -5.883631487736995e-28,  8.405737186487469e-31,  1.406810478083805e-01,
 -5.418094205406191e-04,  1.475146417327427e-06, -3.251204967723328e-09,  5.718941873682631e-12, -6.670019652801515e-15, -1.853485372635635e-18,  3.946114389005461e-20,
 -1.402425617525424e-22,  3.292164454302685e-25, -5.099371964081298e-28,  1.388359283054521e-31,  1.685354702617228e-01, -6.428483467522054e-04,  1.710200302182224e-06,
 -3.590117413771144e-09,  5.646785061823651e-12, -4.224494950143696e-15, -1.152224885549811e-17,  6.365073573815328e-20, -1.768697375740048e-22,  3.189275808834758e-25,
 -2.128509136490645e-28, -1.060739993765029e-30,  1.988330938512513e-01, -7.503170016466427e-04,  1.944512576477813e-06, -3.852895768523247e-09,  5.204312019768752e-12,
 -7.067493687623338e-16, -2.291639636114673e-17,  8.639023913902905e-20, -1.914696686855837e-22,  2.182742152028288e-25,  3.153541386872647e-28, -2.562426890189814e-30,
  2.315471267452133e-01, -8.634593857622029e-04,  2.172575868229622e-06, -4.017742397796838e-09,  4.348400697752619e-12,  3.819438651493288e-15, -3.511559861810860e-17,
  1.034809151630859e-19, -1.725037349430193e-22,  1.391886917872882e-26,  1.019680432894782e-27, -3.952825449591366e-30,  2.666469520204221e-01, -9.814418327399746e-04,
  2.388566604885696e-06, -4.063801659636983e-09,  3.053093079250570e-12,  9.189807963778738e-15, -4.686540924458446e-17,  1.103264911604852e-19, -1.111200511223983e-22,
 -2.865763869117628e-25,  1.764657688702822e-27, -4.645550547276530e-30,  3.040976845267406e-01, -1.103350078686928e-03,  2.586399799889437e-06, -3.971928350930786e-09,
  1.313812641595930e-12,  1.513194086630818e-14, -5.663487651259205e-17,  1.025112774685603e-19, -3.822151450572246e-24, -6.483100725985321e-25,  2.339348283024876e-27,
 -4.009899248970988e-30,  3.438596689168713e-01, -1.228186437931458e-03,  2.759796826586041e-06, -3.725542868679411e-09, -8.486167064062415e-13,  2.126390056515005e-14,
 -6.271911680037493e-17,  7.653068244868687e-20,  1.449331739090079e-22, -1.006585052832481e-24,  2.487077409582766e-27, -1.580561998577660e-30,  3.858879127899089e-01,
 -1.354867222143431e-03,  2.902368502053969e-06, -3.311569573144525e-09, -3.384394270889475e-12,  2.710103673346113e-14, -6.338999303696394e-17,  3.062282840058120e-20,
  3.207180890332785e-22, -1.270711235292619e-24,  1.962857516443735e-27,  2.684144635838255e-30,  4.301314483752976e-01, -1.482220577977917e-03,  3.007716023789401e-06,
 -2.721449207948633e-09, -6.211917785861558e-12,  3.207285666325040e-14, -5.709411067651877e-17, -3.438490855812144e-20,  4.983170002369746e-22, -1.335933266276848e-24,
  6.148812268827810e-28,  8.163522872926976e-30,  4.765326157196719e-01, -1.608984965327545e-03,  3.069552472640456e-06, -1.952208459200200e-09, -9.216090641613671e-12,
  3.555173550410593e-14, -4.269162912628740e-17, -1.143393140624504e-19,  6.427802214458878e-22, -1.104267765960703e-24, -1.522827350247265e-27,  1.345576453539441e-29,
  5.250262599793735e-01, -1.733808555376240e-03,  3.081847675432225e-06, -1.007559333546297e-09, -1.224821541156036e-11,  3.689486583848083e-14, -1.972165925315284e-17,
 -2.012975955760692e-19,  7.129529442091930e-22, -5.131392497376529e-25, -4.150326610668239e-27,  1.649508241419027e-29,  5.755388352315581e-01, -1.855249896381610e-03,
  3.038999153035092e-06,  1.010124957034975e-10, -1.512799675767299e-11,  3.550012009682354e-14,  1.132974105816703e-17, -2.835290196109395e-19,  6.678501849535122e-22,
  4.320156754897529e-25, -6.667731325458942e-27,  1.499988716073236e-29,  6.279874072862562e-01, -1.971780276766894e-03,  2.936031585358187e-06,  1.353228327481998e-09,
 -1.764822864026143e-11,  3.087529980256720e-14,  4.879437751120142e-17, -3.461841858828521e-19,  4.757886474999830e-22,  1.628309875510700e-24, -8.225220717276769e-27,
  7.271995719805757e-30,  6.822785484310976e-01, -2.081788310564859e-03,  2.768826598245307e-06,  2.719144954042652e-09, -1.958275774805118e-11,  2.271845193307263e-14,
  8.966699814013490e-17, -3.728083646118334e-19,  1.254663923409203e-22,  2.859522754576038e-24, -7.888530537658880e-27, -6.772436520321941e-30,  7.383071180295738e-01,
 -2.183587379620309e-03,  2.534383580904078e-06,  4.158534659697913e-09, -2.069827182019722e-11,  1.100444702551741e-14,  1.295888357591554e-16, -3.477951238557101e-19,
 -3.627820757121779e-22,  3.806222157100232e-24, -4.927815557838537e-27, -2.464948200187436e-29,  7.959549246312548e-01, -2.275426688942964e-03,  2.231110502877014e-06,
  5.620648021048043e-09, -2.077032410900200e-11, -3.930193252578252e-15,  1.630339821837836e-16, -2.597229828082655e-19, -9.284217352784934e-22,  4.093515115833574e-24,
  8.066077720778026e-28, -4.092837978361074e-29,  8.550892680056754e-01, -2.355506822709302e-03,  1.859141106908850e-06,  7.044519832449204e-09, -1.960373117584166e-11,
 -2.131605035232363e-14,  1.837598357765706e-16, -1.052783495143639e-19, -1.468677322560504e-21,  3.382324426855787e-24,  8.520532316964132e-27, -4.800580019020485e-29,
  9.155613636165243e-01, -2.422000821755297e-03,  1.420671168614965e-06,  8.360005427471418e-09, -1.705702199638808e-11, -3.990906060138043e-14,  1.855642625589069e-16,
  1.068531159442294e-19, -1.847248358818924e-21,  1.497745437402877e-24,  1.628861085917906e-26, -3.844458808749068e-29,  9.772046579210324e-01, -2.473081927147409e-03,
  9.203014842700166e-07,  9.489754012871940e-09, -1.306992407054033e-11, -5.799782106171505e-14,  1.633511046928776e-16,  3.531103509423560e-19, -1.917215791124338e-21,
 -1.431119458561077e-24,  2.124529481313701e-26, -8.735967429844844e-30,  1.039833051000488e+00, -2.506959229792091e-03,  3.653686495794679e-07,  1.035232888325914e-08,
 -7.691913083897331e-12, -7.348150170558058e-14,  1.144363328171896e-16,  5.945020176200013e-19, -1.558903043010156e-21, -4.868323508967769e-24,  2.031748148892668e-26,
  3.660798022521458e-29,  1.103239053959554e+00, -2.521922504953018e-03, -2.337636050712777e-07,  1.086665948312476e-08, -1.108630111580605e-12, -8.403848395014073e-14,
  3.992788704909095e-17,  7.798042755066057e-19, -7.284217926103127e-22, -7.872011870964949e-24,  1.149983669296608e-26,  8.281776258157814e-29,  1.167191922873208e+00,
 -2.516397453017328e-03, -8.634896790204909e-07,  1.095794140549184e-08,  6.338439678592360e-12, -8.739867051203866e-14, -5.410893798273799e-17,  8.536537695271009e-19,
  4.945219253888319e-22, -9.265432247710164e-24, -4.630553805328726e-27,  1.072462311631049e-28,  1.231435829392491e+00, -2.489012359747322e-03, -1.506872224674063e-06,
  1.056496876200014e-08,  1.414503496755859e-11, -8.171697924209976e-14, -1.561076230458433e-16,  7.697370275112385e-19,  1.878637340684153e-21, -8.007621452183525e-24,
 -2.384350762284615e-26,  8.819725121252425e-29,  1.295688150907043e+00, -2.438676761154375e-03, -2.143736640842686e-06,  9.648669763352928e-09,  2.165696797227281e-11,
 -6.601994388093959e-14, -2.495551787718918e-16,  5.075304297108775e-19,  3.056502988634638e-21, -3.708555518405007e-24, -3.856969308994071e-26,  1.881057179538005e-29,
  1.359637990585646e+00, -2.364671966914643e-03, -2.751018954621674e-06,  8.201306827497261e-09,  2.810986437598222e-11, -4.066178446674663e-14, -3.150738432838820e-16,
  8.861146394625949e-20,  3.603099564000191e-21,  2.889746117046625e-24, -4.035384061328438e-26, -8.048007806738973e-29,  1.422945069335687e+00, -2.266752171622071e-03,
 -3.303440847808413e-06,  6.255397866081542e-09,  3.270124181952498e-11, -7.685196942594822e-15, -3.342088503078592e-16, -4.139285800011461e-19,  3.178952524754921e-21,
  9.756925771922588e-24, -2.427661389197365e-26, -1.615522130746824e-28,  1.485239166549080e+00, -2.145253282234546e-03, -3.774581216893641e-06,  3.890945256068032e-09,
  3.469611559514462e-11,  2.905352786903360e-14, -2.945925918909691e-16, -8.806801775206064e-19,  1.705667437085235e-21,  1.403995601590559e-23,  6.433180730568384e-27,
 -1.690234458071274e-28,  1.546120321987169e+00, -2.001204463275330e-03, -4.138394642820292e-06,  1.239099298496608e-09,  3.355980076126437e-11,  6.414660580779948e-14,
 -1.954113126472380e-16, -1.171576785134539e-18, -4.992120069475271e-22,  1.324148418373558e-23,  3.887024560772533e-26, -7.810325640040769e-29,  1.605160043147246e+00,
 -1.836434772656886e-03, -4.371187385627130e-06, -1.519928416288289e-09,  2.910086381993586e-11,  9.139725849117403e-14, -5.130565402991974e-17, -1.171333067588907e-18,
 -2.725926691709141e-21,  6.754441813195951e-24,  5.510587895322957e-26,  7.292799500879411e-29,  1.661903784704847e+00, -1.653664281827365e-03, -4.453995857319229e-06,
 -4.166845744390581e-09,  2.159475602419379e-11,  1.050849659665851e-13,  1.076136698795352e-16, -8.429191413022215e-19, -4.087999800971270e-21, -3.115972891428220e-24,
  4.285497887018813e-26,  1.895585315266811e-28,  1.715874970659877e+00, -1.456566084302901e-03, -4.375219384736514e-06, -6.462661265009474e-09,  1.184811764303027e-11,
  1.015481130555857e-13,  2.415107609685833e-16, -2.655861466214840e-19, -3.925089711619846e-21, -1.166662389089543e-23,  6.307188591090950e-27,  1.826556918833381e-28,
  1.766580805276329e+00, -1.249783175819215e-03, -4.133244109816765e-06, -8.177522417217358e-09,  1.160865922757891e-12,  8.066985905958292e-14,  3.124239415419826e-16,
  3.704649575372150e-19, -2.220159753285536e-21, -1.420643253725427e-23, -3.253240112642402e-26,  4.928962662248401e-29,  1.813520054753366e+00, -1.038883164836400e-03,
 -3.738674921762674e-06, -9.126745019831762e-09, -8.845214310709264e-12,  4.667492730991343e-14,  2.988107051732876e-16,  8.285970361543749e-19,  2.493567298139845e-22,
 -9.256412645230401e-24, -4.752765615189512e-26, -1.055365787006574e-28,  1.856192868378422e+00, -8.302351438408165e-04, -3.215697816666073e-06, -9.208836785552825e-09,
 -1.653179703040684e-11,  7.653937235581802e-15,  2.070416425559663e-16,  9.340246325895282e-19,  2.240648626479720e-21, -1.400845066836486e-25, -2.958915583026998e-26,
 -1.534898784151962e-28,  1.894112541409275e+00, -6.307977888635698e-04, -2.602068209942031e-06, -8.437491204752835e-09, -2.063552573130039e-11, -2.645050347537681e-14,
  7.279778632804255e-17,  6.728548853598544e-19,  2.772354945350023e-21,  6.984065608876849e-24,  3.800562725697202e-27, -6.932003969270905e-29,  1.926818907448982e+00,
 -4.478164491022814e-04, -1.947306270842503e-06, -6.957960672977869e-09, -2.064551091139170e-11, -4.703304412656624e-14, -5.160808289954060e-17,  2.134677094365956e-19,
  1.791717369570212e-21,  7.814297357688210e-24,  2.380253702938316e-26,  4.253905290760895e-29,  1.953892805794184e+00, -2.884394115675434e-04, -1.308908254703452e-06,
 -5.039204114702482e-09, -1.703381102232297e-11, -5.009996719731044e-14, -1.206966580401254e-16, -1.845505015586659e-19,  2.189707595514420e-22,  3.398899832665814e-24,
  1.807836445473359e-26,  7.011040013730572e-29,  1.974970844630804e+00, -1.592781872364728e-04, -7.467457370147729e-07, -3.037576192074406e-09, -1.121954952882350e-11,
 -3.812595738232548e-14, -1.187527563006058e-16, -3.316447328593829e-19, -7.804922797509052e-22, -1.229120246833985e-24,  1.019646410163043e-27,  2.041682495105064e-29,
  1.989759624126866e+00, -6.595017542127456e-05, -3.162580707126920e-07, -1.335212469641318e-09, -5.220925189917489e-12, -1.930423590813041e-14, -6.810963902937269e-17,
 -2.299811740933644e-19, -7.420745938630186e-22, -2.273850989754834e-24, -6.527934032173784e-27, -1.706613362056453e-29,  1.998050481959741e+00, -1.263950957481339e-05,
 -6.137775848840304e-08, -2.644668502901343e-10, -1.065979538842444e-12, -4.113896645408274e-15, -1.538796383420256e-17, -5.618277159321374e-20, -2.010996213575752e-22,
 -7.076297936330645e-25, -2.452151175801637e-27, -8.376908209273023e-30,  3.158230155703985e-04, -1.263181481662827e-06,  3.788690754181925e-09, -1.009953606043559e-11,
  2.523392579219150e-14, -6.051322385017506e-17,  1.410371565074993e-19, -3.219229029799639e-22,  7.229703785683767e-25, -1.603189629677886e-27,  3.517030458508538e-30,
 -7.650804294124133e-33,  2.842148036487002e-03, -1.135886007515442e-05,  3.401088817562550e-08, -9.039300984143288e-11,  2.248102508529670e-13, -5.355716933700365e-16,
  1.237123362181245e-18, -2.790943048777393e-21,  6.175352408509861e-24, -1.344308588791462e-26,  2.883110478969712e-29, -6.102949796198744e-32,  7.893411454147535e-03,
 -3.149802873523602e-05,  9.398963563926986e-08, -2.483050506239381e-10,  6.117953713830552e-13, -1.437954818979967e-15,  3.260443019006650e-18, -7.176038579861351e-21,
  1.537526524524131e-23, -3.211676825592177e-26,  6.534548482925406e-29, -1.293573175412349e-31,  1.546681720575403e-02, -6.157600099954410e-05,  1.827941619486060e-07,
 -4.785185326576847e-10,  1.162204614660512e-12, -2.674676517067310e-15,  5.887283332903253e-18, -1.243906505909318e-20,  2.520626778584477e-23, -4.877583593289564e-26,
  8.913820637535105e-29, -1.508001081611736e-31,  2.555811383177465e-02, -1.014349740039786e-04,  2.990297044527466e-07, -7.731403275976723e-10,  1.840938912896218e-12,
 -4.112426088214829e-15,  8.666518770049435e-18, -1.718753284114145e-20,  3.169600612456265e-23, -5.288318548437934e-26,  7.421914183718788e-29, -6.619855540605032e-32,
  3.816152471095951e-02, -1.508631018115488e-04,  4.408394233596575e-07, -1.121802729533568e-09,  2.602843538166125e-12, -5.584867580598640e-15,  1.105941944446654e-17,
 -1.985932052665358e-20,  3.077384335750358e-23, -3.502198028519823e-26,  2.069704825911750e-30,  1.510460939296188e-31,  5.326965348162239e-02, -2.095932622020769e-04,
  6.059073644291136e-07, -1.511802603431807e-09,  3.394127427883216e-12, -6.902190378675372e-15,  1.249013879422223e-17, -1.894744483834005e-20,  1.914295640465445e-23,
  1.010688855950881e-26, -1.292041610878329e-28,  4.704744799335443e-31,  7.087336328427042e-02, -2.773015198896982e-04,  7.914628378681423e-07, -1.928281594807935e-09,
  4.154147620880271e-12, -7.862733713567484e-15,  1.240456511523536e-17, -1.324667817793492e-20, -4.843378804744059e-24,  8.105563572690105e-26, -2.985339112671898e-28,
  7.947463525794794e-31,  9.096162808343337e-02, -3.536052911293427e-04,  9.942866935544043e-07, -2.354451536928836e-09,  4.817561722597035e-12, -8.266436577258450e-15,
  1.033453569130337e-17, -2.099693169637745e-21, -4.042814042385793e-23,  1.679574243217950e-25, -4.606413354901139e-28,  9.716825728933381e-31,  1.135213539254931e-01,
 -4.380612176035635e-04,  1.210720098754808e-06, -2.771869944040590e-09,  5.316847654658755e-12, -7.929775318648552e-15,  5.963675806036129e-18,  1.438316672790855e-20,
 -8.395421055873572e-23,  2.523585331261359e-25, -5.515523912838931e-28,  8.310168452105868e-31,  1.385371675600072e-01, -5.301627616405648e-04,  1.436676567097331e-06,
 -3.160771151148444e-09,  5.585183567117865e-12, -6.701740663859434e-15, -8.096482799983061e-19,  3.515908778738106e-20, -1.287561551279190e-22,  3.089734127807509e-25,
 -5.014604256995744e-28,  2.424212642438972e-31,  1.659911693904056e-01, -6.293375405609585e-04,  1.667658149374538e-06, -3.500459202402661e-09,  5.559670922420002e-12,
 -4.480271288556748e-15, -9.817552082977248e-18,  5.817287644233779e-20, -1.655521608094568e-22,  3.095547571861409e-25, -2.540086530210018e-28, -8.160650267426066e-31,
  1.958626472226098e-01, -7.349444257232138e-04,  1.898776880173392e-06, -3.769768929014181e-09,  5.184869483254505e-12, -1.228400773024814e-15, -2.058205066427117e-17,
  8.039115633352562e-20, -1.834109064110588e-22,  2.287435744686268e-25,  2.107727341383526e-28, -2.197339263885167e-30,  2.281277467447051e-01, -8.462704421735776e-04,
  2.124782781089014e-06, -3.947601693264619e-09,  4.416593201042889e-12,  3.010810834792894e-15, -3.229528515013681e-17,  9.797635174890832e-20, -1.713093230750570e-22,
  5.134579593128364e-26,  8.545593084889417e-28, -3.555623728288325e-30,  2.627590940965245e-01, -9.625275183625850e-04,  2.340099952071582e-06, -4.013541870626632e-09,
  3.225889645468095e-12,  8.101696977402848e-15, -4.382750539238966e-17,  1.066188095470155e-19, -1.202147950710781e-22, -2.199994096370023e-25,  1.566183679437912e-27,
 -4.372147682991590e-30,  2.997253652764664e-01, -1.082849152966036e-03,  2.538872536212448e-06, -3.948559114616815e-09,  1.603091423519060e-12,  1.380711287005918e-14,
 -5.376965496883468e-17,  1.020332554325560e-19, -2.551968727389754e-23, -5.582837846927763e-25,  2.161644007745429e-27, -4.054374334864152e-30,  3.389907964891919e-01,
 -1.206287088406784e-03,  2.715022616219388e-06, -3.735799560041018e-09, -4.382151426332948e-13,  1.978484734945178e-14, -6.051663921740830e-17,  8.060780509483228e-20,
  1.104685167724938e-22, -9.086590443323913e-25,  2.405352221265312e-27, -2.112265695785228e-30,  3.805146288721089e-01, -1.331808109363686e-03,  2.862322385096760e-06,
 -3.361466064294322e-09, -2.857511865772759e-12,  2.559108416570455e-14, -6.239563995110605e-17,  4.016924202530314e-20,  2.764112022193929e-22, -1.190162451555204e-24,
  2.056752344122724e-27,  1.609087650057763e-30,  4.242504803679132e-01, -1.458291120725676e-03,  2.974483215288831e-06, -2.815782981669746e-09, -5.584232099485727e-12,
  3.069280234014464e-14, -5.784083438910018e-17, -1.920283917824209e-20,  4.507486553842516e-22, -1.304594951663445e-24,  9.413202229577126e-28,  6.692672107540204e-30,
  4.701456368618860e-01, -1.584524704657399e-03,  3.045264507369885e-06, -2.094034348837623e-09, -8.515549389123142e-12,  3.449100556435633e-14, -4.561121791304924e-17,
 -9.441702903257145e-20,  6.020689266369369e-22, -1.153768912266202e-24, -9.628841312723996e-28,  1.199355818988974e-29,  5.181402541165667e-01, -1.709205412431596e-03,
  3.068605396932326e-06, -1.197655188841582e-09, -1.151549458878570e-11,  3.635646988245894e-14, -2.504158639637563e-17, -1.788093037477157e-19,  6.916645697901679e-22,
 -6.648637848659464e-25, -3.441906312604232e-27,  1.567133725208751e-29,  5.681664615715262e-01, -1.830937115329709e-03,  3.038782485960686e-06, -1.353433148038185e-10,
 -1.441590572653196e-11,  3.567919564030249e-14,  3.692104002938350e-18, -2.619591451534366e-19,  6.787627475317094e-22,  1.786877602672394e-25, -5.994921744102339e-27,
  1.551460722212632e-29,  6.201473588153625e-01, -1.948231822114892e-03,  2.950596670214865e-06,  1.075857081025456e-09, -1.701978802617269e-11,  3.193181933832048e-14,
  3.932273716052995e-17, -3.300838713290396e-19,  5.285694356390172e-22,  1.306426590744120e-24, -7.851908749942106e-27,  9.611123633391175e-30,  6.739958955961108e-01,
 -2.059512470057087e-03,  2.799591756206455e-06,  2.409569168372085e-09, -1.910771141882434e-11,  2.474574289321138e-14,  7.929961141683763e-17, -3.672077630448204e-19,
  2.226689120967549e-22,  2.539252364148687e-24, -8.095280074943908e-27, -2.694272365664087e-30,  7.296136267723006e-01, -2.163118313431239e-03,  2.582306763943842e-06,
  3.829288672937632e-09, -2.044787660596396e-11,  1.399653330125039e-14,  1.197083621034972e-16, -3.572518446121861e-19, -2.295544257597089e-22,  3.588852367291321e-24,
 -5.905225457517760e-27, -1.978455401750480e-29,  7.868893348308227e-01, -2.257313667948280e-03,  2.296562415845616e-06,  5.287904069479505e-09, -2.081040564204243e-11,
 -1.078654721212684e-16,  1.553679841366857e-16, -2.870718455162555e-19, -7.808987178026764e-22,  4.090838490831929e-24, -9.127522282328040e-28, -3.712982596351643e-29,
  8.456975147874605e-01, -2.340300919965896e-03,  1.941780091348356e-06,  6.727688092072207e-09, -1.998621555456966e-11, -1.694638379725709e-14,  1.801728247287517e-16,
 -1.502661577849667e-19, -1.341287774506077e-21,  3.680933082840979e-24,  6.412875620775491e-27, -4.759942258616433e-29,  9.058967198007252e-01, -2.410238870740949e-03,
  1.519328205968067e-06,  8.080950499379957e-09, -1.781045973639187e-11, -3.542624106994823e-14,  1.877375652393751e-16,  4.872621596824617e-20, -1.782023453318641e-21,
  2.113934720813615e-24,  1.448576984347737e-26, -4.326109443501935e-29,  9.673277711241806e-01, -2.465267648856575e-03,  1.032886240030514e-06,  9.271571822545834e-09,
 -1.418991138202630e-11, -5.396572388636376e-14,  1.723727007112320e-16,  2.910981995760102e-19, -1.953559885083979e-21, -5.920314730976106e-25,  2.063573946365591e-26,
 -1.880483168170338e-29,  1.029811843657011e+00, -2.503541571704116e-03,  4.888101733261036e-07,  1.021765601484684e-08, -9.132759866867249e-12, -7.054107029158836e-14,
  1.303587888313071e-16,  5.419727493165310e-19, -1.719179132839467e-21, -4.027062857428627e-24,  2.165454521896446e-26,  2.411980440430455e-29,  1.093148448994525e+00,
 -2.523271443049363e-03, -1.035253963455655e-07,  1.083553468289972e-08, -2.778063213402798e-12, -8.282109290443890e-14,  6.139414396444912e-17,  7.520562540711192e-19,
 -1.002679375954122e-21, -7.341720431957802e-24,  1.494714283710153e-26,  7.354343421045437e-29,  1.157113352288107e+00, -2.522777798470362e-03, -7.314437813500839e-07,
  1.104531025000996e-08,  4.579424139822610e-12, -8.840897842012758e-14, -3.003543240477945e-17,  8.641150903697900e-19,  1.587732959753656e-22, -9.355918166895299e-24,
  1.093314380335004e-28,  1.076685029677219e-28,  1.221456478201844e+00, -2.500556497090114e-03, -1.378789248469039e-06,  1.077801848710068e-08,  1.247500927106675e-11,
 -8.519841015512803e-14, -1.337579611092259e-16,  8.250648080724739e-19,  1.574169742351951e-21, -8.879519020194361e-24, -1.965163713919040e-26,  1.018821338278629e-28,
  1.285899885556413e+00, -2.455357729876943e-03, -2.025918148364253e-06,  9.984297668784780e-09,  2.027788348858764e-11, -7.182781959142837e-14, -2.339971955541036e-16,
  6.029066751134902e-19,  2.895487692226776e-21, -5.227826266398370e-24, -3.722173391161247e-26,  4.242702004314009e-29,  1.350135920423378e+00, -2.386278874410860e-03,
 -2.649932890489576e-06,  8.644148994811403e-09,  2.722127963659259e-11, -4.818066962382417e-14, -3.109651537611241e-16,  2.052570562107779e-19,  3.677278918534380e-21,
  1.211044660744757e-24, -4.341958700534114e-26, -5.829655121337934e-29,  1.413825693544157e+00, -2.292870559100818e-03, -3.225243248389253e-06,  6.776948565640124e-09,
  3.246644972658478e-11, -1.583347674970449e-14, -3.443232917065300e-16, -3.067833573824243e-19,  3.511020999731574e-21,  8.645029082254736e-24, -3.127491440805447e-26,
 -1.556022143242569e-28,  1.476598069210848e+00, -2.175253687629541e-03, -3.724541138382455e-06,  4.450339254193733e-09,  3.520452041045318e-11,  2.169403325146877e-14,
 -3.184112455057822e-16, -8.179770373188582e-19,  2.213892535356385e-21,  1.414279056965499e-23, -1.426538281238496e-27, -1.875513381547110e-28,  1.538049397004689e+00,
 -2.034242919593927e-03, -4.120262229563518e-06,  1.786053571111472e-09,  3.479316960458050e-11,  5.906173036931897e-14, -2.283653492259464e-16, -1.179631731875308e-18,
  4.546291130147876e-24,  1.471727394714181e-23,  3.466221113761237e-26, -1.133732955497845e-28,  1.597744260901165e+00, -1.871469174437826e-03, -4.386572769109388e-06,
 -1.039769261784380e-09,  3.091378911657480e-11,  8.976273796899450e-14, -8.528457297472745e-17, -1.254240942665652e-18, -2.442389771029270e-21,  9.014793492211010e-24,
  5.770048822552751e-26,  4.392977529084038e-29,  1.655217555467619e+00, -1.689490222908084e-03, -4.501855121604797e-06, -3.804384016970514e-09,  2.372029409168710e-11,
  1.073695995882531e-13,  8.216609979244643e-17, -9.751827430263005e-19, -4.167303967028170e-21, -1.234483994883702e-24,  5.121942570126142e-26,  1.895320449288717e-28,
  1.709978216405994e+00, -1.491874668047910e-03, -4.451565866260759e-06, -6.256531543280285e-09,  1.393636514612631e-11,  1.072405553105876e-13,  2.322532097411232e-16,
 -3.978440441681452e-19, -4.338528464653489e-21, -1.124464019309035e-23,  1.501248907512912e-26,  2.129060402012073e-28,  1.761514919786381e+00, -1.283241208736302e-03,
 -4.231208364633624e-06, -8.145630607931438e-09,  2.850041536442626e-12,  8.828400035842809e-14,  3.217236804158363e-16,  2.909906160643598e-19, -2.754402689059485e-21,
 -1.545446535050904e-23, -2.961423287729441e-26,  8.430134239999334e-29,  1.809304006362861e+00, -1.069232980353117e-03, -3.849012913362392e-06, -9.260402910881832e-09,
 -7.838118632303395e-12,  5.412537326635069e-14,  3.220703704168721e-16,  8.308688960695312e-19, -1.191921824507544e-22, -1.124800609124265e-23, -5.198237698802714e-26,
 -9.595490253365658e-29,  1.852819770435788e+00, -8.564072337558651e-04, -3.327784959818697e-06, -9.471841888240100e-09, -1.632686810096283e-11,  1.294485795877242e-14,
  2.341956779051364e-16,  1.005402713291756e-18,  2.212620784256233e-21, -1.464541412555128e-24, -3.677742927833237e-26, -1.732111502089378e-28,  1.891547067936898e+00,
 -6.520249865394109e-04, -2.705316246760728e-06, -8.771790179775206e-09, -2.114548549827346e-11, -2.446701931442592e-14,  9.291770862782461e-17,  7.656160521653369e-19,
  3.025723333119751e-21,  7.068514399782216e-24,  2.517882812372169e-28, -9.267960277539761e-29,  1.924995947924560e+00, -4.637345688771685e-04, -2.032815021926682e-06,
 -7.295879279391826e-09, -2.159803897818905e-11, -4.819316752156898e-14, -4.478467562856028e-17,  2.754910657694050e-19,  2.090612961319528e-21,  8.802917814012510e-24,
  2.560141312513755e-26,  3.881057541051286e-29,  1.952717715993644e+00, -2.991572697824265e-04, -1.371047530502033e-06, -5.319920215430590e-09, -1.806519153417220e-11,
 -5.305778595698977e-14, -1.257465474607763e-16, -1.754398894137924e-19,  3.551188939884297e-22,  4.186807749338971e-24,  2.139513666239204e-26,  8.083401242586325e-29,
  1.974321548708277e+00, -1.654010674806938e-04, -7.842994015680583e-07, -3.223347199865017e-09, -1.201133626640307e-11, -4.109031898248691e-14, -1.283950545561236e-16,
 -3.573187267872029e-19, -8.237741114124302e-22, -1.168607392305917e-24,  2.052031262558312e-27,  2.674194250253856e-29,  1.989490659775640e+00, -6.854578020770330e-05,
 -3.327948637580699e-07, -1.421927004078417e-09, -5.623892014288496e-12, -2.101890173716880e-14, -7.489423536730746e-17, -2.550891961331641e-19, -8.288192565996218e-22,
 -2.550531534238249e-24, -7.319813792866365e-27, -1.894972450637390e-29,  1.997998921360078e+00, -1.314352238416846e-05, -6.465647639175036e-08, -2.822013605306806e-10,
 -1.152081866156432e-12, -4.502836598628757e-15, -1.705514302419900e-17, -6.304523040295407e-20, -2.284324356081184e-22, -8.135044399448203e-25, -2.852351094654475e-27,
 -9.856374351538046e-30,  3.108301507011193e-04, -1.233349960532717e-06,  3.669879427083849e-09, -9.705294469470499e-12,  2.405679339965997e-14, -5.723393630232884e-17,
  1.323387193224538e-19, -2.996847813827793e-22,  6.677087607035901e-25, -1.469014320618412e-27,  3.197195805164234e-30, -6.900878754001024e-33,  2.797249985795340e-03,
 -1.109105148955193e-05,  3.294740551825840e-08, -8.688015026354407e-11,  2.143895102696365e-13, -5.067965988090538e-16,  1.161672317677029e-18, -2.600857559700691e-21,
  5.711528595608571e-24, -1.234179493259931e-26,  2.627568786986228e-29, -5.522816314763722e-32,  7.768904534275119e-03, -3.075786604261479e-05,  9.106777192508143e-08,
 -2.387422131642901e-10,  5.838027889368090e-13, -1.362060789095659e-15,  3.066231774799583e-18, -6.702035810284244e-21,  1.426476989433242e-23, -2.961336551409156e-26,
  5.990725460624401e-29, -1.180143399783219e-31,  1.522340198192719e-02, -6.013630449008020e-05,  1.771617704614424e-07, -4.603436468490011e-10,  1.110096284777816e-12,
 -2.537471695267601e-15,  5.550022776313979e-18, -1.165988401503848e-20,  2.351294664986564e-23, -4.533988704697700e-26,  8.273542060340991e-29, -1.403400790986801e-31,
  2.515710035113583e-02, -9.907935254696594e-05,  2.899260726212026e-07, -7.443321536105966e-10,  1.760731959256581e-12, -3.910091774773335e-15,  8.199185509215943e-18,
 -1.620315413563443e-20,  2.984493974713411e-23, -4.997348125214628e-26,  7.124841184495686e-29, -6.862705577551042e-32,  3.756504146589636e-02, -1.473895333784807e-04,
  4.276240237755095e-07, -1.081036577326470e-09,  2.493755976442982e-12, -5.326004131498345e-15,  1.051695579927028e-17, -1.889470173448162e-20,  2.951606636464200e-23,
 -3.481473096819601e-26,  8.091134479628160e-30,  1.233534779951959e-31,  5.244086134329223e-02, -2.048176569953517e-04,  5.880870662438507e-07, -1.458584807035624e-09,
  3.259038639858942e-12, -6.608723866632286e-15,  1.196823419959553e-17, -1.833000669161115e-20,  1.941860551310395e-23,  5.335178685535880e-27, -1.098034527587911e-28,
  4.125058121389093e-31,  6.977667564028370e-02, -2.710612566220420e-04,  7.687171195494263e-07, -1.863057221104845e-09,  3.999839919404190e-12, -7.569489932823158e-15,
  1.203191092351027e-17, -1.335721595680314e-20, -2.132108364789795e-24,  6.979008480631113e-26, -2.653144454882686e-28,  7.163678270812841e-31,  8.956293840118398e-02,
 -3.457627133554306e-04,  9.664903487807703e-07, -2.278679725533958e-09,  4.654707785244348e-12, -8.019253943885328e-15,  1.025851658573315e-17, -3.300123962009126e-21,
 -3.470322131464367e-23,  1.503660019654778e-25, -4.194416721124401e-28,  9.014094569125527e-31,  1.117882719403858e-01, -4.285070723903531e-04,  1.177962868701244e-06,
 -2.688061237411736e-09,  5.159714517638276e-12, -7.782109689721237e-15,  6.330128807918427e-18,  1.183780376386711e-20, -7.525765185845204e-23,  2.310229111770467e-25,
 -5.153620692485565e-28,  8.127385099058464e-31,  1.364392652511845e-01, -5.188195571409880e-04,  1.399279065231879e-06, -3.072481221893709e-09,  5.451031815980683e-12,
 -6.709814211509864e-15,  1.187681127575768e-19,  3.121301064408738e-20, -1.179913597933463e-22,  2.891536494469800e-25, -4.889394131476353e-28,  3.232519036622808e-31,
  1.635002378494861e-01, -6.161627920676671e-04,  1.626183370393421e-06, -3.412233569971235e-09,  5.467838169828733e-12, -4.696934863422848e-15, -8.261217968528349e-18,
  5.305148354702882e-20, -1.545991401888012e-22,  2.987405067038564e-25, -2.851737982190452e-28, -6.059296595785951e-31,  1.929529654356742e-01, -7.199337513437087e-04,
  1.854036504875147e-06, -3.687033646910052e-09,  5.155540707679764e-12, -1.696014111746981e-15, -1.841201787761789e-17,  7.465520768043803e-20, -1.750467722421946e-22,
  2.353402317725614e-25,  1.214562876580665e-28, -1.868320665297936e-30,  2.247763631844459e-01, -8.294604591853791e-04,  2.077837406958790e-06, -3.876495663751903e-09,
  4.469277566322575e-12,  2.268026527244988e-15, -2.962837069858157e-17,  9.253032654856552e-20, -1.688822669275338e-22,  8.251189676849668e-26,  7.064964942406941e-28,
 -3.177987607770147e-30,  2.589461218476410e-01, -9.439984793655389e-04,  2.292252299776995e-06, -3.960687508748966e-09,  3.377644519098286e-12,  7.085219176289303e-15,
 -4.089714154189842e-17,  1.026569361569286e-19, -1.270527129797999e-22, -1.611146803859124e-25,  1.380179073536519e-27, -4.080347750943143e-30,  2.954342911773776e-01,
 -1.062727246936881e-03,  2.491652611834762e-06, -3.920769659947037e-09,  1.866559821579075e-12,  1.255081406268392e-14, -5.092706111215411e-17,  1.009113930495478e-19,
 -4.410448946794712e-23, -4.753824012439043e-25,  1.983630363061552e-27, -4.026425657809457e-30,  3.342088044473908e-01, -1.184746315486321e-03,  2.670163757335408e-06,
 -3.739723566252442e-09, -5.685743197858522e-14,  1.835990211851709e-14, -5.821491714306273e-17,  8.363778971244349e-20,  7.946506391719903e-23, -8.144319074896269e-25,
  2.303047474166449e-27, -2.518523091765473e-30,  3.752329370747313e-01, -1.309071619525424e-03,  2.821727098829556e-06, -3.403172644702689e-09, -2.360569032554478e-12,
  2.410804615633283e-14, -6.115339619376042e-17,  4.834486639701191e-20,  2.350606833288128e-22, -1.106759283168345e-24,  2.106669129192816e-27,  6.839754870562782e-31,
  4.184646915334935e-01, -1.434631885335375e-03,  2.940177745726982e-06, -2.900295425375359e-09, -4.984293164545170e-12,  2.929975694555281e-14, -5.818358393091772e-17,
 -5.522510475815050e-21,  4.045282292472337e-22, -1.261460287959612e-24,  1.205539240866952e-27,  5.337144588681388e-30,  4.638560999274208e-01, -1.560265366441013e-03,
  3.019341171481601e-06, -2.224824915377290e-09, -7.836879020241236e-12,  3.336675067427559e-14, -4.799145918975509e-17, -7.582182134849155e-20,  5.599632216016013e-22,
 -1.182161072810722e-24, -4.673639424548704e-28,  1.053318122277032e-29,  5.113524347820281e-01, -1.684717133878318e-03,  3.053151932136662e-06, -1.376120378869558e-09,
 -1.079476788274769e-11,  3.569786990903590e-14, -2.974216112987084e-17, -1.570842386383779e-19,  6.654149095647576e-22, -7.890338519612225e-25, -2.773926542080767e-27,
  1.466582178900204e-29,  5.608913178797087e-01, -1.806637218796037e-03,  3.035797996390216e-06, -3.602867702555957e-10, -1.370201712808467e-11,  3.568224659206669e-14,
 -3.338021496964633e-18, -2.401807542559542e-19,  6.810443147985002e-22, -4.739171416819867e-26, -5.308104311536256e-27,  1.564560156154082e-29,  6.124017163675581e-01,
 -1.924579988141579e-03,  2.961894288134472e-06,  8.086977330736673e-10, -1.637245275821721e-11,  3.276660946740589e-14,  3.032383104651769e-17, -3.124769021288097e-19,
  5.700546338428147e-22,  1.001382902487672e-24, -7.386946913845760e-27,  1.144160846512006e-29,  6.658028150242931e-01, -2.037005235716797e-03,  2.826688903567961e-06,
  2.107905030954889e-09, -1.859459296991159e-11,  2.652643915644246e-14,  6.913084557941091e-17, -3.586824092352269e-19,  3.082349347917489e-22,  2.214174011847884e-24,
 -8.132147375757697e-27,  9.422917617360670e-31,  7.210027536300592e-01, -2.142281593013865e-03,  2.626304965899540e-06,  3.504514777815663e-09, -2.014002996960996e-11,
  1.674878501224291e-14,  1.096215584719104e-16, -3.625776135507651e-19, -1.048044095128703e-22,  3.336646423199249e-24, -6.670366996998920e-27, -1.502140819247734e-29,
  7.778972190486217e-01, -2.238693008517961e-03,  2.358020043235077e-06,  4.955120138596091e-09, -2.077593973139502e-11,  3.521822025247495e-15,  1.470022010668829e-16,
 -3.097144503897136e-19, -6.346682798499450e-22,  4.022885656610710e-24, -2.453672848049432e-27, -3.284653886192131e-29,  8.363678831865998e-01, -2.324449210696850e-03,
  2.020583244081366e-06,  6.405430650946992e-09, -2.028226709650539e-11, -1.267745141787417e-14,  1.753847259358430e-16, -1.910217174126700e-19, -1.204658388029122e-21,
  3.895934884387754e-24,  4.348390867087048e-27, -4.606739525178580e-29,  8.962806808130899e-01, -2.397701256169821e-03,  1.614567220500732e-06,  7.790560103692876e-09,
 -1.847385002087490e-11, -3.091053706978346e-14,  1.883157687923504e-16, -6.972868608603136e-21, -1.695960918997277e-21,  2.654204065252291e-24,  1.250331975791038e-26,
 -4.660855248363346e-29,  9.574839257928357e-01, -2.456563463699062e-03,  1.142747988398577e-06,  9.036126142580766e-09, -1.522723277195713e-11, -4.973804818761212e-14,
  1.796461770029424e-16,  2.284007980632265e-19, -1.960239624907070e-21,  2.141286333728927e-25,  1.960711750278873e-26, -2.774651429462297e-29,  1.019806271227903e+00,
 -2.499143233032349e-03,  6.104993079111110e-07,  1.006042031967213e-08, -1.051109864372697e-11, -6.723670099970093e-14,  1.447432418948551e-16,  4.848084558359206e-19,
 -1.848340118355477e-21, -3.143362547212358e-24,  2.243891270337293e-26,  1.155554061307897e-29,  1.083054529084570e+00, -2.523580421521203e-03,  2.617994258700980e-08,
  1.077792144584368e-08, -4.418064572236096e-12, -8.109880817269916e-14,  8.196364376590319e-17,  7.158632183456891e-19, -1.255467968323598e-21, -6.682265317157580e-24,
  1.794471978825908e-26,  6.244386120846783e-29,  1.147011379018360e+00, -2.528098062821034e-03, -5.985188879344324e-07,  1.110440466621735e-08,  2.805997528026813e-12,
 -8.883922295941594e-14, -5.819654125228479e-18,  8.638169064843119e-19, -1.768242908400084e-22, -9.257387227304894e-24,  4.796904817892952e-27,  1.048822253130928e-28,
  1.211433015333199e+00, -2.511066203583347e-03, -1.248312199978384e-06,  1.096382042262362e-08,  1.074083854992631e-11, -8.812598781982315e-14, -1.100000042167690e-16,
  8.701809007883627e-19,  1.241469336014392e-21, -9.572557962484183e-24, -1.492270402947643e-26,  1.125308931677186e-28,  1.276046806393457e+00, -2.471080424322904e-03,
 -1.904208278157813e-06,  1.029695214683780e-08,  1.878658849799831e-11, -7.723088963230071e-14, -2.158489486766342e-16,  6.922677635274121e-19,  2.680998571270480e-21,
 -6.672522803420526e-24, -3.484573486755270e-26,  6.539094029130986e-29,  1.340549073307922e+00, -2.407056090053406e-03, -2.543622966549563e-06,  9.071577256970115e-09,
  2.618356897812896e-11, -5.556154171892747e-14, -3.035663978242371e-16,  3.232877567565722e-19,  3.689061884782804e-21, -5.697903889212108e-25, -4.543770414941064e-26,
 -3.298335016940618e-29,  1.404603134895566e+00, -2.318338407680006e-03, -3.140814998366392e-06,  7.293426718843989e-09,  3.206651361868802e-11, -2.418734049913312e-14,
 -3.512952994990835e-16, -1.897058087618026e-19,  3.798101057694563e-21,  7.260146167188185e-24, -3.788334055119235e-26, -1.438094926715966e-28,  1.467837813586466e+00,
 -2.204826794583553e-03, -3.667744481197252e-06,  5.016659780720439e-09,  3.556017057146749e-11,  1.378579815747679e-14, -3.402464112693803e-16, -7.390136560172540e-19,
  2.719976002883262e-21,  1.391624375585069e-23, -1.000130015926955e-26, -2.013317704258842e-28,  1.529846650347144e+00, -2.067109735333501e-03, -4.095451456971332e-06,
  2.351885149791631e-09,  3.591692331980753e-11,  5.318512103457031e-14, -2.613115029016145e-16, -1.170751897179203e-18,  5.580266827452637e-22,  1.599344388729046e-23,
  2.888526767502028e-26, -1.491870348606095e-28,  1.590188132066440e+00, -1.906603121307708e-03, -4.396023426329702e-06, -5.309099041958572e-10,  3.268568664736574e-11,
  8.728596745617554e-14, -1.214455270694238e-16, -1.326756253686787e-18, -2.075936992041625e-21,  1.135150084033873e-23,  5.887685380476877e-26,  8.510583922268725e-30,
  1.648387285085437e+00, -1.725681058543035e-03, -4.545159396590256e-06, -3.407582586207016e-09,  2.588511623289257e-11,  1.089988290859812e-13,  5.299026297374136e-17,
 -1.108835891943525e-18, -4.172871190749909e-21,  9.794788344715542e-25,  5.942488383117758e-26,  1.821215793626911e-28,  1.703939022752473e+00, -1.527783552847428e-03,
 -4.525234604960564e-06, -6.016092428375552e-09,  1.613593206329558e-11,  1.126648991917530e-13,  2.191099947249869e-16, -5.430191298287040e-19, -4.730190235288915e-21,
 -1.044817819287100e-23,  2.501949305059319e-26,  2.415573637026633e-28,  1.756313637824462e+00, -1.317480953780927e-03, -4.328622694416881e-06, -8.085482391233847e-09,
  4.693541508707366e-12,  9.609265955640207e-14,  3.285522211037456e-16,  1.937272760530422e-19, -3.331087137739154e-21, -1.655328036929812e-23, -2.503022659837611e-26,
  1.249760687803574e-28,  1.804964783546328e+00, -1.100471629929638e-03, -3.960853102926924e-06, -9.376724872329426e-09, -6.676433735505696e-12,  6.213341440523627e-14,
  3.452175194499673e-16,  8.201665775002026e-19, -5.625273603783309e-22, -1.340748286868296e-23, -5.587312679095579e-26, -7.968639801875266e-29,  1.849340170840407e+00,
 -8.834885810447824e-04, -3.443004882468993e-06, -9.730685494766546e-09, -1.600944262118424e-11,  1.891131113411929e-14,  2.633281696397558e-16,  1.075063832185845e-18,
  2.131528971141282e-21, -3.093742696803035e-24, -4.482106655623551e-26, -1.921988094986495e-28,  1.888895008106877e+00, -6.740943503798560e-04, -2.812623430878584e-06,
 -9.113904017629317e-09, -2.161073167521200e-11, -2.196857130769009e-14,  1.157487023357032e-16,  8.665041678418061e-19,  3.279317600586650e-21,  6.989192432539633e-24,
 -4.419911658842473e-27, -1.204227099745273e-28,  1.923107921731188e+00, -4.803532395440388e-04, -2.122470974180518e-06, -7.649214446561396e-09, -2.257198549907859e-11,
 -4.916757511470811e-14, -3.608526181882011e-17,  3.476620459460574e-19,  2.426347343672773e-21,  9.859410657492784e-24,  2.717492208027930e-26,  3.216414189921987e-29,
  1.951498738795376e+00, -3.103860016502319e-04, -1.436656385270544e-06, -5.617618144470538e-09, -1.915691707284468e-11, -5.613322143779547e-14, -1.304758932236954e-16,
 -1.614921542499210e-19,  5.221364448674991e-22,  5.117145976978929e-24,  2.520779381546575e-26,  9.264313467578315e-29,  1.973647145977453e+00, -1.718335140044517e-04,
 -8.241603276239108e-07, -3.422273914073332e-09, -1.286478341541200e-11, -4.429487639804759e-14, -1.387752273054114e-16, -3.843343438302602e-19, -8.640631542605865e-22,
 -1.060796322086461e-24,  3.395915204042613e-27,  3.462741464929209e-29,  1.989211041668026e+00, -7.127795390810549e-05, -3.504120770363711e-07, -1.515372446143398e-09,
 -6.062839064303786e-12, -2.290515726854543e-14, -8.242225986130980e-17, -2.831386930170493e-19, -9.261148823706701e-22, -2.860581499193676e-24, -8.197275889081288e-27,
 -2.095266973512906e-29,  1.997945290868006e+00, -1.367464021871969e-05, -6.815653816682789e-08, -3.013779795574139e-10, -1.246379205750172e-12, -4.934197109536733e-15,
 -1.892731194262681e-17, -7.084654461672832e-20, -2.598812854022348e-22, -9.367683736665617e-25, -3.323671566957208e-27, -1.161829453103555e-29,  3.059547404519493e-04,
 -1.204450321691176e-06,  3.555688122525181e-09, -9.329373445372225e-12,  2.294320855511484e-14, -5.415613468757529e-17,  1.242389012571308e-19, -2.791401525998868e-22,
  6.170549071558340e-25, -1.346996278740005e-27,  2.908594683846701e-30, -6.229564465182846e-33,  2.753406416756205e-03, -1.083158493928230e-05,  3.192509546246005e-08,
 -8.352951512811918e-11,  2.045265859257188e-13, -4.797701018385591e-16,  1.091341696174286e-18, -2.424999328301853e-21,  5.285571248732416e-24, -1.133779304930365e-26,
  2.396237777508525e-29, -5.001369390896254e-32,  7.647312231530303e-03, -3.004062674375576e-05,  8.825802425436351e-08, -2.296153627891491e-10,  5.572825310229642e-13,
 -1.290672497896916e-15,  2.884808360880325e-18, -6.262167957713952e-21,  1.324059893961512e-23, -2.731782255235476e-26,  5.494494956373321e-29, -1.077076216611803e-31,
  1.498565678742754e-02, -5.874080868573008e-05,  1.717425643549141e-07, -4.429809740256290e-10,  1.060652844813994e-12, -2.408105332496192e-15,  5.233838929194744e-18,
 -1.093295868117437e-20,  2.193881889503663e-23, -4.215103032151967e-26,  7.677902969390478e-29, -1.305072342942945e-31,  2.476536585723805e-02, -9.679519886491072e-05,
  2.811605706019037e-07, -7.167755175420827e-10,  1.684461730289069e-12, -3.718649305839136e-15,  7.758601157105054e-18, -1.527635668619089e-20,  2.809646128264793e-23,
 -4.718439110356528e-26,  6.819672298489982e-29, -6.991734896431013e-32,  3.698224410502311e-02, -1.440197606496746e-04,  4.148875141953260e-07, -1.041975106226230e-09,
  2.389717656712202e-12, -5.079840237591956e-15,  1.000093943576974e-17, -1.797016825553661e-20,  2.826980315753716e-23, -3.438979014915677e-26,  1.298306735542653e-29,
  9.961450348769543e-32,  5.163089049427903e-02, -2.001820960223552e-04,  5.708926045911644e-07, -1.407482151275531e-09,  3.129695329819422e-12, -6.327574762388505e-15,
  1.146371657888667e-17, -1.770635137535157e-20,  1.953584484290537e-23,  1.290447849856613e-27, -9.280790226670616e-29,  3.610333730939561e-31,  6.870459001625642e-02,
 -2.649998698601236e-04,  7.467394721401487e-07, -1.800255338442164e-09,  3.851307454948181e-12, -7.285217555153269e-15,  1.165731714389430e-17, -1.338723220984504e-20,
  1.967074093873426e-25,  5.978634106340304e-26, -2.353947521718105e-28,  6.446892722206409e-31,  8.819517998513009e-02, -3.381389132140132e-04,  9.395877945549773e-07,
 -2.205474138107341e-09,  4.496776637941835e-12, -7.774278986423247e-15,  1.015135720976632e-17, -4.327177946500638e-21, -2.958266835797636e-23,  1.343614438152106e-25,
 -3.812794429801780e-28,  8.336987036344121e-31,  1.100928887298728e-01, -4.192110047124280e-04,  1.146196357288416e-06, -2.606742580294950e-09,  5.005617028579477e-12,
 -7.626473683709062e-15,  6.629094218888069e-18,  9.558719047646298e-21, -6.730333173072327e-23,  2.111167147010877e-25, -4.801297340079433e-28,  7.877798875491633e-31,
  1.343861440588442e-01, -5.077713312335968e-04,  1.362928162441486e-06, -2.986337838644565e-09,  5.316932662509730e-12, -6.696893377817512e-15,  9.414104369253582e-19,
  2.760009402664674e-20, -1.079302581767657e-22,  2.698999181417484e-25, -4.733000550390435e-28,  3.846854748925599e-31,  1.610613483755425e-01, -6.033156322707592e-04,
  1.585758346501715e-06, -3.325509946341351e-09,  5.372034253742160e-12, -4.877927969322176e-15, -6.843436042002663e-18,  4.827413522774504e-20, -1.440557289839398e-22,
  2.868551993229330e-25, -3.077871014563302e-28, -4.267727303709453e-31,  1.901026167759568e-01, -7.052770373431322e-04,  1.810285837793223e-06, -3.604839667686080e-09,
  5.117367621220373e-12, -2.113443502158856e-15, -1.639881357503623e-17,  6.919004917262675e-20, -1.665060709640254e-22,  2.386435105010682e-25,  4.585325510292141e-29,
 -1.573697823500421e-30,  2.214914738529821e-01, -8.130226128773532e-04,  2.031749883767935e-06, -3.804662103902858e-09,  4.507734002944369e-12,  1.587428074942546e-15,
 -2.711269692353984e-17,  8.717880789541752e-20, -1.654358898611348e-22,  1.080814087397510e-25,  5.745675232168447e-28, -2.822625069158233e-30,  2.552065042655083e-01,
 -9.258496448205630e-04,  2.245052809691243e-06, -3.905563922284229e-09,  3.509764018841443e-12,  6.137716100246105e-15, -3.808046494056081e-17,  9.850875637142552e-20,
 -1.319015775803713e-22, -1.094099391570596e-25,  1.207254177645354e-27, -3.778925241201485e-30,  2.912229513942984e-01, -1.042981696631068e-03,  2.444790636697213e-06,
 -3.888962023829438e-09,  2.105581585843860e-12,  1.136229606804209e-14, -4.812376650978224e-17,  9.924119743711239e-20, -5.983254852516444e-23, -3.995588432353155e-25,
  1.808177011277374e-27, -3.940198667101079e-30,  3.295122576009154e-01, -1.163564500206212e-03,  2.625293490049783e-06, -3.737770812016404e-09,  2.965600931630689e-13,
  1.699110728901914e-14, -5.584174091240247e-17,  8.572911594157967e-20,  5.177612800296755e-23, -7.246209207443729e-25,  2.185347865033344e-27, -2.814499987210813e-30,
  3.700415387302941e-01, -1.286661760968026e-03,  2.780678066757857e-06, -3.437163730797709e-09, -1.892971039647469e-12,  2.265742226962617e-14, -5.970030630970223e-17,
  5.524562267756974e-20,  1.967391958280776e-22, -1.022131150309124e-24,  2.119033432717539e-27, -9.935190700196411e-32,  4.127729845577583e-01, -1.411250989235175e-03,
  2.904914800469342e-06, -2.975432053081578e-09, -4.412267227823195e-12,  2.790291652424934e-14, -5.816374369773801e-17,  6.705535408774142e-21,  3.600368413485437e-22,
 -1.208913756601957e-24,  1.412815236292573e-27,  4.105338503942599e-30,  4.576631758906959e-01, -1.536219509988752e-03,  2.991912749564969e-06, -2.344939566355514e-09,
 -7.181223623527374e-12,  3.219146491833243e-14, -4.987002511804793e-17, -5.858664995808979e-20,  5.171767541265338e-22, -1.192009826826060e-24, -3.547093222572825e-29,
  9.106047617599510e-30,  5.046623080183016e-01, -1.660360854374738e-03,  3.035625620854120e-06, -1.543165242082308e-09, -1.008829254908310e-11,  3.493365689689809e-14,
 -3.384682964485642e-17, -1.362656169249408e-19,  6.351650222991753e-22, -8.874114420332434e-25, -2.153229298752127e-27,  1.353021795720675e-29,  5.537133092005556e-01,
 -1.782371801340983e-03,  3.030182691544803e-06, -5.738164798793220e-10, -1.298970533591510e-11,  3.552389299074722e-14, -9.758515614106148e-18, -2.184542675859081e-19,
  6.756819941583843e-22, -2.459839609322753e-25, -4.622953812863573e-27,  1.544797308363007e-29,  6.047508419635779e-01, -1.900850419604933e-03,  2.970048651478694e-06,
  5.520177514447962e-10, -1.571054075984511e-11,  3.339148178698356e-14,  2.183488100383087e-17, -2.937143733600630e-19,  6.009111283910707e-22,  7.164046658745918e-25,
 -6.852137787386814e-27,  1.279146824751618e-29,  6.577001742182178e-01, -2.014295561887060e-03,  2.850216473193082e-06,  1.814722526641191e-09, -1.804828021087422e-11,
  2.806624814920941e-14,  5.923736364596104e-17, -3.476061676954165e-19,  3.821089006707464e-22,  1.890683066514414e-24, -8.019372265534736e-27,  4.103749936351054e-30,
  7.124759067815232e-01, -2.121108388295777e-03,  2.666437208151100e-06,  3.185093593262166e-09, -1.977956891576030e-11,  1.925760648330159e-14,  9.944011662416799e-17,
 -3.640621527464798e-19,  1.036530411667757e-23,  3.057970506765518e-24, -7.230295168130395e-27, -1.047362473378969e-29,  7.689805439550198e-01, -2.219596646877263e-03,
  2.415489931871889e-06,  4.623457297224010e-09, -2.067093649052154e-11,  6.943648906526850e-15,  1.380674858910489e-16, -3.277283428805611e-19, -4.919472165495359e-22,
  3.897169454049472e-24, -3.798646120810164e-27, -2.825078267753296e-29,  8.271028946765114e-01, -2.307982618642812e-03,  2.095493682804740e-06,  6.079112791632338e-09,
 -2.049417898655795e-11, -8.536626640089342e-15,  1.695177322515879e-16, -2.272970835771816e-19, -1.061756391030982e-21,  4.030002906618223e-24,  2.373253026790753e-27,
 -4.356540002692559e-29,  8.867162937926122e-01, -2.384415841797422e-03,  1.706260846189939e-06,  7.490278205639855e-09, -1.904691209944119e-11, -2.639934245695208e-14,
  1.873757672739573e-16, -5.962232385187661e-20, -1.591907642064445e-21,  3.112658095040043e-24,  1.040552359612909e-26, -4.851244816488595e-29,  9.476766367064380e-01,
 -2.446991961613936e-03,  1.249687625111564e-06,  8.784768636128359e-09, -1.617839722344035e-11, -4.535687302514884e-14,  1.851654355044275e-16,  1.659453049569238e-19,
 -1.938729606989927e-21,  9.716532238734162e-25,  1.821363044284229e-26, -3.536196659307787e-29,  1.009820226707212e+00, -2.493779298363647e-03,  7.301715337687461e-07,
  9.881678108252761e-09, -1.182002970294983e-11, -6.360674949783504e-14,  1.574740501311834e-16,  4.240249998079169e-19, -1.945255794650454e-21, -2.239274177952392e-24,
  2.267639469310655e-26, -6.734197365393059e-31,  1.072961443541454e+00, -2.522854966006969e-03,  1.550377051575418e-07,  1.069437021451686e-08, -6.018770270378959e-12,
 -7.889590764996606e-14,  1.014102175687555e-16,  6.719829527857138e-19, -1.482479697444999e-21, -5.913115997568473e-24,  2.042175777623120e-26,  4.995878377987311e-29,
  1.136890255299080e+00, -2.532352574313359e-03, -4.650552922131696e-07,  1.113508697026788e-08,  1.029770882901670e-12, -8.868959796627016e-14,  1.823821688020464e-17,
  8.528722468333832e-19, -5.055376197215064e-22, -8.974721035205176e-24,  9.293793167096627e-27,  9.903599882186259e-29,  1.201369614720773e+00, -2.520523651136782e-03,
 -1.115773839377495e-06,  1.112143860213655e-08,  8.953914197936129e-12, -9.046944028302635e-14, -8.513133193611363e-17,  9.042887552346670e-19,  8.873283225210961e-22,
 -1.006805743260342e-23, -9.799762301510514e-27,  1.197359370317682e-28,  1.266132806989094e+00, -2.485814846079254e-03, -1.778893205612325e-06,  1.058490591530391e-08,
  1.719178614703522e-11, -8.216919936712163e-14, -1.953023590328472e-16,  7.739533517629785e-19,  2.416451155172215e-21, -8.002362411038456e-24, -3.149015892925818e-26,
  8.680799203024967e-29,  1.330880850360040e+00, -2.426962603155810e-03, -2.432288360739701e-06,  9.481231980691085e-09,  2.500028423978914e-11, -6.272520248887363e-14,
 -2.928672396155710e-16,  4.406563955900426e-19,  3.635557039302689e-21, -2.408332243359638e-24, -4.628817774971861e-26, -5.372893881374267e-30,  1.395280094786614e+00,
 -2.343106160841612e-03, -3.050232944282221e-06,  7.802161317270323e-09,  3.149809764872407e-11, -3.266820416143793e-14, -3.548683763910286e-16, -6.428928943142371e-20,
  4.030708057011954e-21,  5.623031394822775e-24, -4.384396873485052e-26, -1.261807633695791e-28,  1.458960217441635e+00, -2.233918260359605e-03, -3.604123144812180e-06,
  5.587377703687369e-09,  3.575260409676811e-11,  5.381870848954208e-15, -3.596455813827194e-16, -6.440533806558294e-19,  3.211598709278566e-21,  1.333622912174892e-23,
 -1.905720320572548e-26, -2.092485375264337e-28,  1.521512876821595e+00, -2.099750608526549e-03, -4.063746842486222e-06,  2.934713689708106e-09,  3.691526842845060e-11,
  4.652282980099967e-14, -2.937544911385477e-16, -1.143473288567019e-18,  1.152911337427046e-21,  1.700718649111643e-23,  2.154781180577779e-26, -1.840412951553731e-28,
  1.582491355582087e+00, -1.941787770304434e-03, -4.399199458335106e-06,  5.855711211334941e-12,  3.439921285323542e-11,  8.391837196926351e-14, -1.594600462095424e-16,
 -1.386193207461117e-18, -1.624907781514354e-21,  1.370229808973101e-23,  5.836170080413219e-26, -3.284471980359180e-29,  1.641411589483461e+00, -1.762198690854635e-03,
 -4.583493282903617e-06, -2.975922641530723e-09,  2.807521785453774e-11,  1.098829868025234e-13,  2.008207306093048e-17, -1.241329385870537e-18, -4.092928528536967e-21,
  3.512692534218439e-24,  6.711938462650169e-26,  1.661215127654210e-28,  1.697755033988663e+00, -1.564269640070137e-03, -4.595803395144278e-06, -5.739610893707382e-09,
  1.844049503269344e-11,  1.177236401504956e-13,  2.017312881223477e-16, -7.001889585465953e-19, -5.085678033983092e-21, -9.227075318839513e-24,  3.622005372655060e-26,
  2.668432834848995e-28,  1.750973843547972e+00, -1.352496612995163e-03, -4.425133089664925e-06, -7.994580849010041e-09,  6.694621994150513e-12,  1.040304027603737e-13,
  3.323933599038211e-16,  7.741610151095580e-20, -3.943582547045448e-21, -1.743134734378710e-23, -1.853836250125806e-26,  1.709256959628199e-28,  1.800498808310369e+00,
 -1.132610256130833e-03, -4.073972251547872e-06, -9.473148536621571e-09, -5.349065566683941e-12,  7.069171517227619e-14,  3.678544969310783e-16,  7.940051716041400e-19,
 -1.086212119493424e-21, -1.570601286568593e-23, -5.887671596264357e-26, -5.541051831407768e-29,  1.845750382799155e+00, -9.115040165491968e-04, -3.561296392839040e-06,
 -9.983457015157070e-09, -1.556554004209456e-11,  2.560000056519775e-14,  2.943655742741714e-16,  1.141127888423637e-18,  1.985797261974556e-21, -5.060928297485788e-24,
 -5.366262061450294e-26, -2.092554135077277e-28,  1.886152927732498e+00, -6.970387157085206e-04, -2.924078896605957e-06, -9.463031294111811e-09, -2.202029591619749e-11,
 -1.888736803683682e-14,  1.415174728653800e-16,  9.754230761562637e-19,  3.526386079736271e-21,  6.697224341764519e-24, -1.041475838263182e-26, -1.528647474399090e-28,
  1.921151959130589e+00, -4.977063842343143e-04, -2.216461051738201e-06, -8.018276609881018e-09, -2.356316220386629e-11, -4.990769774935477e-14, -2.520885082876460e-17,
  4.311965803122527e-19,  2.801168499434700e-21,  1.097194764002605e-23,  2.837600999224510e-26,  2.172407819077914e-29,  1.950233773877484e+00, -3.221541955201501e-04,
 -1.505944470213571e-06, -5.933281774818261e-09, -2.031125147419167e-11, -5.931683881783244e-14, -1.347346277232287e-16, -1.416335142502236e-19,  7.255192893942361e-22,
  6.210686314186373e-24,  2.956255069167104e-26,  1.054542062972005e-28,  1.972946360233029e+00, -1.785946335167184e-04, -8.664924647392438e-07, -3.635382307357556e-09,
 -1.378487496190820e-11, -4.775777691756684e-14, -1.499292252978164e-16, -4.125660262244851e-19, -8.994149771831620e-22, -8.917575677447212e-25,  5.127266983043707e-27,
  4.441574026633820e-29,  1.988920205715927e+00, -7.415567302178854e-05, -3.691940520084336e-07, -1.616152931932951e-09, -6.541383430006043e-12, -2.498187239970431e-14,
 -9.078098600163857e-17, -3.144871868902987e-19, -1.035225589230651e-21, -3.207521749936544e-24, -9.164986814554711e-27, -2.304576185042104e-29,  1.997889478409090e+00,
 -1.423470534596740e-05, -7.189606472877609e-08, -3.221348913759276e-10, -1.349771375084848e-12, -5.413228869301356e-15, -2.103270069549319e-17, -7.972901791666246e-20,
 -2.961265332747589e-22, -1.080531193646038e-24, -3.879772740951066e-27, -1.372055216283335e-29,  3.011931298457363e-04, -1.176446467361430e-06,  3.445902963772636e-09,
 -8.970787700350332e-12,  2.188928145206600e-14, -5.126600489489406e-17,  1.166922846767120e-19, -2.601483362414218e-22,  5.705928351545848e-25, -1.235952687949735e-27,
  2.647964472863464e-30, -5.628121652246177e-33,  2.710584607871584e-03, -1.058013868119534e-05,  3.094206373246987e-08, -8.033245260693132e-11,  1.951877031976591e-13,
 -4.543739589105856e-16,  1.025749585145023e-18, -2.262210846471102e-21,  4.894146228740014e-24, -1.042189344247764e-26,  2.186675628117582e-29, -4.532351491566068e-32,
  7.528544613616192e-03, -2.934543444396091e-05,  8.555529920461080e-08, -2.209016468682914e-10,  5.321474761134479e-13, -1.223494201424991e-15,  2.715254573652075e-18,
 -5.853788781990516e-21,  1.229560137317398e-23, -2.521198513687652e-26,  5.041513464083382e-29, -9.834054319595937e-32,  1.475340816968036e-02, -5.738784637656023e-05,
  1.665270478169338e-07, -4.263891031081061e-10,  1.013722467675856e-12, -2.286088722738556e-15,  4.937320717290355e-18, -1.025461380194691e-20,  2.047530399587592e-23,
 -3.919195756545375e-26,  7.124176947463521e-29, -1.212856723642250e-31,  2.438262979543177e-02, -9.457986693867762e-05,  2.727185507882840e-07, -6.904091401534722e-10,
  1.611916680147407e-12, -3.537475687979134e-15,  7.343198741260071e-18, -1.440392768438451e-20,  2.644618179307460e-23, -4.451821825130328e-26,  6.510925440133654e-29,
 -7.028618168644141e-32,  3.641272498012074e-02, -1.407500329754793e-04,  4.026099149020224e-07, -1.004539526183320e-09,  2.290480844548815e-12, -4.845754584212379e-15,
  9.510254241273524e-18, -1.708523464730789e-20,  2.704211787908766e-23, -3.378901544687547e-26,  1.690785422974895e-29,  7.931253999753909e-32,  5.083919061246344e-02,
 -1.956816725733821e-04,  5.542991412933989e-07, -1.358404656567220e-09,  3.005855333722831e-12, -6.058324238878794e-15,  1.097669285047062e-17, -1.708114728345286e-20,
  1.951918096502026e-23, -2.117995530357506e-27, -7.794665971390424e-29,  3.153861756066139e-31,  6.765640301339057e-02, -2.591113297590224e-04,  7.255013742432955e-07,
 -1.739784980239074e-09,  3.708370509600011e-12, -7.009937417314459e-15,  1.128287369000547e-17, -1.334826359029677e-20,  2.186187682611037e-24,  5.091818814084533e-26,
 -2.084891329075979e-28,  5.792950363963774e-31,  8.685749183224308e-02, -3.307268622240709e-04,  9.135487071930648e-07, -2.134756402231343e-09,  4.343717035651548e-12,
 -7.532202950189574e-15,  1.001764978023371e-17, -5.199304026485655e-21, -2.501151299113369e-23,  1.198246405164109e-25, -3.460322341695371e-28,  7.689645198402483e-31,
  1.084341876472484e-01, -4.101652075057871e-04,  1.115390980326578e-06, -2.527864212579043e-09,  4.854698988251112e-12, -7.464400169966986e-15,  6.867702987154031e-18,
  7.522976355312831e-21, -6.004054661952429e-23,  1.925962712610920e-25, -4.461105885182808e-28,  7.578504042144925e-31,  1.323766406511263e-01, -4.970098141146616e-04,
  1.327598118641520e-06, -2.902336935540565e-09,  5.183281351095751e-12, -6.665407323399436e-15,  1.667295158042005e-18,  2.429816822928889e-20, -9.855042534051898e-23,
  2.513207853851608e-25, -4.553290637383017e-28,  4.296953421033838e-31,  1.586732072942630e-01, -5.907877362530369e-04,  1.546364695328255e-06, -3.240346340277730e-09,
  5.272940103510037e-12, -5.026461774267150e-15, -5.554761901300617e-18,  4.382717046899675e-20, -1.339546472262123e-22,  2.742146536557590e-25, -3.231367972457930e-28,
 -2.752282305020039e-31,  1.873102011928369e-01, -6.909663943689807e-04,  1.767517566705245e-06, -3.523320672800992e-09,  5.071316881006768e-12, -2.484361309761299e-15,
 -1.453479361635409e-17,  6.399953691219681e-20, -1.578978501848535e-22,  2.391722421611837e-25, -1.750722768615304e-29, -1.311496982558796e-30,  2.182716039791598e-01,
 -7.969500092972795e-04,  1.986527616405771e-06, -3.732318907093339e-09,  4.533170162866806e-12,  9.654209599535533e-16, -2.474519039792875e-17,  8.195131302470416e-20,
 -1.611602941872519e-22,  1.286795170594447e-25,  4.577515820931021e-28, -2.491239866004616e-30,  2.515387310679716e-01, -9.080757257441579e-04,  2.198526872552042e-06,
 -3.848474391154039e-09,  3.623599967887405e-12,  5.256403613554444e-15, -3.538183920562481e-17,  9.423388589163774e-20, -1.350103694433182e-22, -6.435575179621930e-26,
  1.047669030483627e-27, -3.475056811642566e-30,  2.870898465276530e-01, -1.023609452128784e-03,  2.398332526655846e-06, -3.853516563758224e-09,  2.321501709517986e-12,
  1.024044155943819e-14, -4.537388280757474e-17,  9.711003209903830e-20, -7.295623966386026e-23, -3.306632241663208e-25,  1.637566253626262e-27, -3.808248353415805e-30,
  3.248997203726879e-01, -1.142741459262988e-03,  2.580479690567260e-06, -3.730379271782984e-09,  6.231755222442873e-13,  1.567987420586645e-14, -5.342193275056828e-17,
  8.698519500295945e-20,  2.723277296655384e-23, -6.397491911106004e-25,  2.056781040631677e-27, -3.014845762931849e-30,  3.649391206289173e-01, -1.264581801245001e-03,
  2.739265079960005e-06, -3.463903390760653e-09, -1.454021836186187e-12,  2.124385544060609e-14, -5.807070496693838e-17,  6.096886758244614e-20,  1.614652787645150e-22,
 -9.376581894752019e-25,  2.099871282345930e-27, -7.507855472944391e-31,  4.071742314657757e-01, -1.388155649786574e-03,  2.868804208649438e-06, -3.041639620856499e-09,
 -3.868146428501042e-12,  2.651050181363466e-14, -5.782115513431398e-17,  1.754162007468704e-20,  3.175736455172384e-22, -1.149122767291986e-24,  1.568691737432510e-27,
  3.001106542700936e-30,  4.515659875457133e-01, -1.512398669878349e-03,  2.963105111572634e-06, -2.454754065064971e-09, -6.549486508945778e-12,  3.097672967040306e-14,
 -5.128520482192795e-17, -4.272310612255389e-20,  4.743316995972440e-22, -1.185823210179434e-24,  3.348291445996586e-28,  7.737110555469021e-30,  4.980693135259118e-01,
 -1.636152612548964e-03,  3.016162071663058e-06, -1.699033930341014e-09, -9.398039958051274e-12,  3.407781441013681e-14, -3.738262753235145e-17, -1.164669647764448e-19,
  6.018081425958168e-22, -9.619883226600398e-25, -1.584501412188097e-27,  1.231072068302651e-29,  5.466322563912305e-01, -1.758161362296014e-03,  3.022073281046539e-06,
 -7.759827033243209e-10, -1.228205238624472e-11,  3.521872182260401e-14, -1.557410761853078e-17, -1.970084970904327e-19,  6.636607890241793e-22, -4.174285880410701e-25,
 -3.952716028551839e-27,  1.497671822045219e-29,  5.971949970512161e-01, -1.877067755881805e-03,  2.975186775646242e-06,  3.060174522768995e-10, -1.503812557271026e-11,
  3.381902576311047e-14,  1.388359324317302e-17, -2.741243473727963e-19,  6.219065625799043e-22,  4.538732119173222e-25, -6.267837790156471e-27,  1.369795136695959e-29,
  6.496887264794701e-01, -1.991411589406223e-03,  2.870279273574558e-06,  1.530514604924807e-09, -1.747351925170113e-11,  2.937259159809424e-14,  4.968536902020835e-17,
 -3.343511559082501e-19,  4.444506074826075e-22,  1.574341519972109e-24, -7.778246721493144e-27,  6.775406774868432e-30,  7.040343707350616e-01, -2.099629356084019e-03,
  2.702772613244106e-06,  2.871827913644974e-09, -1.937137623304487e-11,  2.152198158371004e-14,  8.926716694099036e-17, -3.620257146181000e-19,  1.151470026923440e-22,
  2.760815021400853e-24, -7.596585062012838e-27, -6.232991296414708e-30,  7.601411486669052e-01, -2.200056412258307e-03,  2.468992166942515e-06,  4.294010186873802e-09,
 -2.049967925106743e-11,  1.014550149188810e-14,  1.286915686670483e-16, -3.412575579881854e-19, -3.546710562345426e-22,  3.721754322753823e-24, -4.937519684609646e-27,
 -2.350380376376430e-29,  8.179049462283607e-01, -2.290932457733596e-03,  2.166470670915964e-06,  5.750058887488476e-09, -2.062476204455989e-11, -4.548277580039647e-15,
  1.626996665955597e-16, -2.589373803074516e-19, -9.154212335126115e-22,  4.087515081723904e-24,  5.264182708460991e-28, -4.026446339408032e-29,  8.772064924951823e-01,
 -2.370411440976910e-03,  1.794299047208039e-06,  7.181547385441910e-09, -1.953009328793903e-11, -2.192800717346892e-14,  1.850105617396821e-16, -1.086943388854632e-19,
 -1.472876876468900e-21,  3.485934982925211e-24,  8.254448525261218e-27, -4.904592242703686e-29,  9.379093252029858e-01, -2.436577259608947e-03,  1.353522573228208e-06,
  8.518900090733165e-09, -1.704075469123563e-11, -4.086411812619042e-14,  1.889495960397048e-16,  1.046030785854483e-19, -1.891028935556478e-21,  1.667159324878966e-24,
  1.651684692850736e-26, -4.151565853814964e-29,  9.998575386011793e-01, -2.487466915920995e-03,  8.475756436551530e-07,  9.682589808522200e-09, -1.305344587842429e-11,
 -5.969200217333686e-14,  1.684644033279182e-16,  3.606617883891297e-19, -2.009581356879720e-21, -1.336264849390708e-24,  2.239013114434405e-26, -1.219329631405671e-29,
  1.062873314584650e+00, -2.521103090732198e-03,  2.827407200855660e-07,  1.058558508226119e-08, -7.570854432218748e-12, -7.624182775789869e-14,  1.195307353367228e-16,
  6.212993713094341e-19, -1.680153796652255e-21, -5.056175017080192e-24,  2.232767705481043e-26,  3.656419390146347e-29,  1.126754250601703e+00, -2.535538386992323e-03,
 -3.313938265641744e-07,  1.113740483401365e-08, -7.377202944246229e-13, -8.796743947165149e-14,  4.184414797697416e-17,  8.316057382427125e-19, -8.209069279320294e-22,
 -8.518168385386631e-24,  1.347090300602304e-26,  9.040089974667515e-29,  1.191270516220275e+00, -2.528913715526059e-03, -9.815170461622753e-07,  1.125012376984287e-08,
  7.126159951708753e-12, -9.220588000045401e-14, -5.946869130479678e-17,  9.268187946008305e-19,  5.191044702585670e-22, -1.035337564499065e-23, -4.440645027213852e-27,
  1.232358980958896e-28,  1.256161896201277e+00, -2.499533366588964e-03, -1.650278959284408e-06,  1.084658026922928e-08,  1.550332891774547e-11, -8.658794446096311e-14,
 -1.725940920689445e-16,  8.464351458254979e-19,  2.106666856146568e-21, -9.179778263691462e-24, -2.724201608503300e-26,  1.058279834369371e-28,  1.321134813378584e+00,
 -2.445959108631036e-03, -2.316156173360032e-06,  9.870823027661308e-09,  2.367655901600986e-11, -6.959290240529158e-14, -2.789157127809327e-16,  5.552497189586137e-19,
  3.515549467034506e-21, -4.256133792709573e-24, -4.589111852889875e-26,  2.354983860675113e-29,  1.385859471406412e+00, -2.367125005834161e-03, -2.953606252115536e-06,
  8.300440871083489e-09,  3.075949542173164e-11, -4.119189667449247e-14, -3.548347616640363e-16,  6.758327701422487e-20,  4.200289403300235e-21,  3.764668209102231e-24,
 -4.890532961105970e-26, -1.030054432132948e-28,  1.449967316806496e+00, -2.262473321576057e-03, -3.533640345720684e-06,  6.159805573905001e-09,  3.577252774139700e-11,
 -3.453973989925102e-15, -3.761692576717487e-16, -5.337657449133680e-19,  3.675754277312962e-21,  1.238895571959501e-23, -2.831457187995728e-26, -2.103499096280207e-28,
  1.513049091741744e+00, -2.132109607884022e-03, -4.024956977739443e-06,  3.532407777913395e-09,  3.777265451581699e-11,  3.909325518746428e-14, -3.251621046853557e-16,
 -1.096634063604726e-18,  1.778643861855239e-21,  1.769740942704943e-23,  1.272849426464322e-26, -2.162563658606009e-28,  1.574653831130258e+00, -1.976971602172027e-03,
 -4.395772189099469e-06,  5.694488242032674e-10,  3.603613762161820e-11,  7.962016609298473e-14, -1.989240658917400e-16, -1.429850798472798e-18, -1.090073679568958e-21,
  1.599453330453410e-23,  5.591198756286037e-26, -7.924081382025862e-29,  1.634289243658626e+00, -1.799001677812871e-03, -4.616436559016791e-06, -2.509123772990711e-09,
  3.027480602885313e-11,  1.099332055713190e-13, -1.648599589061567e-17, -1.369747722873874e-18, -3.916444803964375e-21,  6.336846929687072e-24,  7.390203698065906e-26,
  1.405317931473931e-28,  1.691423993682812e+00, -1.601306372124990e-03, -4.662829907648313e-06, -5.425471133641282e-09,  2.084169901094804e-11,  1.223112414070342e-13,
  1.797998050701307e-16, -8.679424799646483e-19, -5.388886386421240e-21, -7.537133471440525e-24,  4.842208257996132e-26,  2.867216907717957e-28,  1.745492450161175e+00,
 -1.388279435711213e-03, -4.520355310666384e-06, -7.870388118746075e-09,  8.855103859828287e-12,  1.120190106407765e-13,  3.326990164086052e-16, -5.894653646287917e-20,
 -4.582514208481804e-21, -1.800791567507303e-23, -9.922740887394911e-27,  2.213368031702392e-28,  1.795902461862128e+00, -1.165658089613720e-03, -4.188115313463696e-06,
 -9.546935747583511e-09, -3.845167955910744e-12,  7.978254228968654e-14,  3.895117521819236e-16,  7.497409584304385e-19, -1.694525172542982e-21, -1.810067531426300e-23,
 -6.061192131827135e-26, -2.182362689679273e-29,  1.842046621325283e+00, -9.404777859952111e-04, -3.682573999475403e-06, -1.022801481261071e-08, -1.498026787410767e-11,
  3.305519035231870e-14,  3.271763433773639e-16,  1.201325757734032e-18,  1.762708045072314e-21, -7.395888003236124e-24, -6.318451943463644e-26, -2.228388067526035e-28,
  1.883317259924864e+00, -7.208915893667943e-04, -3.039761062505223e-06, -9.818183950609853e-09, -2.236179998900538e-11, -1.515023555781620e-14,  1.704447328284516e-16,
  1.092030844609692e-18,  3.758270421660181e-21,  6.135486197527043e-24, -1.794390237586676e-26, -1.901757633016038e-28,  1.919125051679289e+00, -5.158294351577470e-04,
 -2.314975468525718e-06, -8.403301017148712e-09, -2.456633440355488e-11, -5.035732624814439e-14, -1.181947143025564e-17,  5.273745080024816e-19,  3.216782976839115e-21,
  1.212199776139596e-23,  2.901532686135312e-26,  6.440918295374592e-30,  1.948920603134627e+00, -3.344921647770107e-04, -1.579133453450209e-06, -6.267929484994734e-09,
 -2.153023132037916e-11, -6.259522028538426e-14, -1.383400403982253e-16, -1.146020068908387e-19,  9.715432463683648e-22,  7.489949720919436e-24,  3.449995189023744e-26,
  1.190875962834320e-28,  1.972217836139748e+00, -1.857048949531349e-04, -9.114725647310136e-07, -3.863781045270818e-09, -1.477696614275307e-11, -5.149798094404875e-14,
 -1.618885328164104e-16, -4.418173539761164e-19, -9.273251900404576e-22, -6.442028450487827e-25,  7.338536793410126e-27,  5.651507362578229e-29,  1.988617550528443e+00,
 -7.718861879156659e-05, -3.892327398411765e-07, -1.724933607460035e-09, -7.063541380010023e-12, -2.727013640868580e-14, -1.000682835192680e-16, -3.495347129090437e-19,
 -1.157545250879785e-21, -3.595029008812078e-24, -1.022593572022590e-26, -2.518092503954168e-29,  1.997831364239030e+00, -1.482571188654278e-05, -7.589492517179007e-08,
 -3.446255553941951e-10, -1.463270316582913e-12, -5.945910473199240e-15, -2.340384630519498e-17, -8.985862736090946e-20, -3.379709682649756e-22, -1.248503374995176e-24,
 -4.537130303208111e-27, -1.623367416726416e-29,  2.965418049478232e-04, -1.149303964524168e-06,  3.340321533054056e-09, -8.628612031172349e-12,  2.089138797746432e-14,
 -4.855077703362020e-17,  1.096572108631035e-19, -2.425813065183455e-22,  5.279468840221511e-25, -1.134823859845645e-27,  2.412403892473554e-30, -5.088842914955772e-33,
  2.668753094952455e-03, -1.033640572006935e-05,  2.999651670855930e-08, -7.728083283397035e-11,  1.863413632380478e-13, -4.304987152123791e-16,  9.645450369994996e-19,
 -2.111436190209458e-21,  4.534233183961974e-24, -9.585833118639422e-27,  1.996700016542079e-29, -4.110210214194878e-32,  7.412515174023852e-03, -2.867145242224121e-05,
  8.295476941259424e-08, -2.125795605695121e-10,  5.083162030610530e-13, -1.160251328736717e-15,  2.556723196498359e-18, -5.474470745537713e-21,  1.142324946565297e-23,
 -2.327935416296319e-26,  4.627842188984183e-29, -8.982562385841097e-32,  1.452648919610756e-02, -5.607582437196794e-05,  1.615062077096466e-07, -4.105289758631020e-10,
  9.691627699102210e-13, -2.170965821335356e-15,  4.659156221605358e-18, -9.621438938128127e-21,  1.911442507258256e-23, -3.644643582179997e-26,  6.609717293514535e-29,
 -1.126552964718459e-31,  2.400862196535947e-02, -9.243082504518703e-05,  2.645860810208796e-07, -6.651750292737300e-10,  1.542897353984936e-12, -3.365984471530558e-15,
  6.951499271532748e-18, -1.358279576369649e-20,  2.488965975085711e-23, -4.197563906703784e-26,  6.202241671248806e-29, -6.991627674675772e-32,  3.585609113178754e-02,
 -1.375767558285068e-04,  3.907721682819701e-07, -9.686549129390115e-10,  2.195809965181392e-12, -4.623152456093113e-15,  9.043800642367082e-18, -1.623921231465765e-20,
  2.583867938763893e-23, -3.304820592004406e-26,  2.000653239543744e-29,  6.199413690809348e-32,  5.006523061190044e-02, -1.913116743903599e-04,  5.382828949569222e-07,
 -1.311266150842189e-09,  2.887284879586589e-12, -5.800552385904921e-15,  1.050714972039268e-17, -1.645832880360464e-20,  1.939004361261560e-23, -4.970581723337062e-27,
 -6.497707542266697e-29,  2.749527936725844e-31,  6.663143490276988e-02, -2.533898303274955e-04,  7.049753788026848e-07, -1.681558056117061e-09,  3.570849424914728e-12,
 -6.743623922653615e-15,  1.091036609899084e-17, -1.325053746910388e-20,  3.875109099468562e-24,  4.307046906389714e-26, -1.843303673688851e-28,  5.197625060498577e-31,
  8.554904057417471e-02, -3.235197707471310e-04,  8.883436981232650e-07, -2.066449070192038e-09,  4.195464969729681e-12, -7.293612871290383e-15,  9.861493932899195e-18,
 -5.933259740248666e-21, -2.093898245300910e-23,  1.066417007989527e-25, -3.135625659349664e-28,  7.074822859495218e-31,  1.068111828045498e-01, -4.013621079546186e-04,
  1.085517763570028e-06, -2.451374309515938e-09,  4.707075200384189e-12, -7.297258399839752e-15,  7.052466312272541e-18,  5.709234993035689e-21, -5.342033160174915e-23,
  1.754091166879323e-25, -4.134911173024786e-28,  7.243709660715519e-31,  1.304096243640006e-01, -4.865269416020790e-04,  1.293263278915401e-06, -2.820468499928789e-09,
  5.050426657021611e-12, -6.617576178231938e-15,  2.304828581966786e-18,  2.128583785460307e-20, -8.982606383309057e-23,  2.334958588106731e-25, -4.356902662745849e-28,
  4.608985862031184e-31,  1.563345539327335e-01, -5.785709287602814e-04,  1.507983401686082e-06, -3.156790367278926e-09,  5.171174660227023e-12, -5.145525478879703e-15,
 -4.386146671365167e-18,  3.969605346655041e-20, -1.243181378900466e-22,  2.610860572922091e-25, -3.323678174856190e-28, -1.481517485993021e-31,  1.845743500663127e-01,
 -6.769939977258260e-04,  1.725722865619027e-06, -3.442595454780114e-09,  5.018283538232534e-12, -2.812255522500157e-15, -1.281225201590586e-17,  5.908432514345201e-20,
 -1.493135170837973e-22,  2.373882236555976e-25, -7.000464903033903e-29, -1.079554880591836e-30,  2.151153064700088e-01, -7.812357053896599e-04,  1.942175508617037e-06,
 -3.659665215114084e-09,  4.546722608791951e-12,  3.984936774881316e-16, -2.252203305137052e-17,  7.687162799251285e-20, -1.562238262678718e-22,  1.448893289230424e-25,
  3.549715484736553e-28, -2.184716371430569e-30,  2.479413135125261e-01, -8.906712442209290e-04,  2.152696367658620e-06, -3.789701016709271e-09,  3.720447590073907e-12,
  4.438412001911454e-15, -3.280406738184144e-17,  8.988427941035567e-20, -1.366088944434029e-22, -2.541816793680186e-26,  9.013997239914019e-28, -3.174502113747155e-30,
  2.830334900838053e-01, -1.004607114076498e-03,  2.352319761601311e-06, -3.814792313694832e-09,  2.515639645924510e-12,  9.183822977814153e-15, -4.268918760669752e-17,
  9.459728743329103e-20, -8.372102785373730e-23, -2.684649521117465e-25,  1.473562394895674e-27, -3.641573998995108e-30,  3.203697589720171e-01, -1.122276487054818e-03,
  2.535785089485072e-06, -3.717968516150743e-09,  9.241494455920098e-13,  1.442705259967958e-14, -5.097749764097230e-17,  8.750376455872172e-20,  5.650337367303039e-24,
 -5.601713979676442e-25,  1.921246420963412e-27, -3.133430532498878e-30,  3.599243578921711e-01, -1.242834311660409e-03,  2.697572430438885e-06, -3.483843856934273e-09,
 -1.042940531962311e-12,  1.987119730688838e-14, -5.629619968261986e-17,  6.561180176471789e-20,  1.292120166832216e-22, -8.544885702050708e-25,  2.054746868645353e-27,
 -1.281334253535777e-30,  4.016672771364995e-01, -1.365352227147994e-03,  2.831950444341629e-06, -3.099363495037562e-09, -3.351767910859058e-12,  2.512979863567296e-14,
 -5.719384808303982e-17,  2.705443267269117e-20,  2.773637903597378e-22, -1.084030758808275e-24,  1.678796436455662e-27,  2.024548749923857e-30,  4.455636135332011e-01,
 -1.488813391992976e-03,  2.933039539061743e-06, -2.554656824737899e-09, -5.942348563386489e-12,  2.973320563769546e-14, -5.227534669575384e-17, -2.822429837533771e-20,
  4.319616570019668e-22, -1.166007719667449e-24,  6.465357260871909e-28,  6.445383559639533e-30,  4.915728290013229e-01, -1.612107374394959e-03,  2.994893783180092e-06,
 -1.843999936338685e-09, -8.725708538241679e-12,  3.314364217635125e-14, -4.037937996188791e-17, -9.777440442113113e-20,  5.661629012561887e-22, -1.014904789334460e-24,
 -1.070525118378182e-27,  1.104767060019698e-29,  5.396479004939505e-01, -1.734025310544274e-03,  3.011605585127880e-06, -9.668826871830144e-10, -1.158185021119325e-11,
  3.478113323753816e-14, -2.079549477297533e-17, -1.760410277687440e-19,  6.459445195314688e-22, -5.625470561906088e-25, -3.308250911841681e-27,  1.428504085117733e-29,
  5.897343465666913e-01, -1.853255611699332e-03,  2.977437697187147e-06,  7.083402241278658e-11, -1.435902302903853e-11,  3.406238843142487e-14,  6.488843920199630e-18,
 -2.540091041011333e-19,  6.338800654663517e-22,  2.153904956838004e-25, -5.652612036136288e-27,  1.420479950598207e-29,  6.417691142588747e-01, -1.968380598262236e-03,
  2.886987578140830e-06,  1.255699547815372e-09, -1.687489271924523e-11,  3.045435583683434e-14,  4.053074632950283e-17, -3.192813394570611e-19,  4.956046445237178e-22,
  1.269851757553004e-24, -7.430339847161130e-27,  8.958935669059472e-30,  6.956793085369123e-01, -2.077874562999939e-03,  2.735389468265377e-06,  2.565442377516966e-09,
 -1.892033102172787e-11,  2.354325904879776e-14,  7.919655344331932e-17, -3.568098927823260e-19,  2.090113797707039e-22,  2.452633053432125e-24, -7.784368180512601e-27,
 -2.369442966617898e-30,  7.513807453871256e-01, -2.180103921851333e-03,  2.518559550672165e-06,  3.967803142627236e-09, -2.026666332475588e-11,  1.311827649897966e-14,
  1.189973234804459e-16, -3.505033577528101e-19, -2.244793692168764e-22,  3.504973168428877e-24, -5.866909945357113e-27, -1.875140183974969e-29,  8.087763090053341e-01,
 -2.273330305022409e-03,  2.233489078914697e-06,  5.419544607832484e-09, -2.067728347631477e-11, -7.336626769052335e-16,  1.550614420923350e-16, -2.858757864909453e-19,
 -7.683085501958301e-22,  4.074254437226598e-24, -1.160865835495673e-27, -3.634263059772346e-29,  8.677540937720994e-01, -2.355717678278801e-03,  1.878589032822841e-06,
  6.865797536376603e-09, -1.992452444045299e-11, -1.752948278235562e-14,  1.813265671935837e-16, -1.537589912579294e-19, -1.341959102510078e-21,  3.773078892615282e-24,
  6.108036667156043e-27, -4.832195413578652e-29,  9.281853133386089e-01, -2.425344867412274e-03,  1.454087292098201e-06,  8.239957020599223e-09, -1.781248699883410e-11,
 -3.630095922244930e-14,  1.910412118893889e-16,  4.517428319484738e-20, -1.819572906910552e-21,  2.289827140475233e-24,  1.458289318848933e-26, -4.613571998851638e-29,
  9.899219628942914e-01, -2.480225186286323e-03,  9.624749144909936e-07,  9.464406933957712e-09, -1.420607420542195e-11, -5.553497907794407e-14,  1.776566344215703e-16,
  2.957571074181610e-19, -2.041724319242238e-21, -4.545613475745882e-25,  2.161862406695488e-26, -2.268156327580670e-29,  1.052794227519023e+00, -2.518335231005970e-03,
  4.089911402322494e-07,  1.045241439035640e-08, -9.065626593663570e-12, -7.317057090972342e-14,  1.361482907653156e-16,  5.647973673553896e-19, -1.845749307712336e-21,
 -4.134943729284201e-24,  2.363321135186842e-26,  2.274906345078535e-29,  1.116607640736199e+00, -2.537655276149652e-03, -1.978736499693205e-07,  1.111158894364733e-08,
 -2.485156935876171e-12, -8.668700823256708e-14,  6.471602762848038e-17,  8.005418453508980e-19, -1.116931181991357e-21, -7.902870552140849e-24,  1.721348047251707e-26,
  7.935455178956909e-29,  1.181140014645923e+00, -2.536224048251728e-03, -8.458925324652888e-07,  1.134932069376197e-08,  5.269880126779312e-12, -9.332018575239441e-14,
 -3.334142161739459e-17,  9.374429341170101e-19,  1.444946596603402e-22, -1.042236797191813e-23,  9.887819538665126e-28,  1.229283919775770e-28,  1.246138188389637e+00,
 -2.512210878540195e-03, -1.518689531219631e-06,  1.108056258923472e-08,  1.373210520830895e-11, -9.043849539834207e-14, -1.480012473650753e-16,  9.083600318339322e-19,
  1.757748033885642e-21, -1.017140903477308e-23, -2.222392176275788e-26,  1.216898358411604e-28,  1.311314677577228e+00, -2.464008226605557e-03, -2.195480441828606e-06,
  1.023815491419105e-08,  2.221908555506844e-11, -7.608775756224848e-14, -2.618193002620891e-16,  6.649440311537986e-19,  3.329615096283833e-21, -6.062454496078726e-24,
 -4.421253156038304e-26,  5.269191154421344e-29,  1.376344356241864e+00, -2.390347133720053e-03, -2.851076733156882e-06,  8.785540307950434e-09,  2.985072940088677e-11,
 -4.966992320810990e-14, -3.510430666688682e-16,  2.037750417371587e-19,  4.299585115661546e-21,  1.725758502156678e-24, -5.283509165879346e-26, -7.486394720852676e-29,
  1.440861367145569e+00, -2.290437052007914e-03, -3.456292398029733e-06,  6.731118020094363e-09,  3.561202747041657e-11, -1.264768609277682e-14, -3.894025745498391e-16,
 -4.092421929263231e-19,  4.099150729072229e-21,  1.107259183560678e-23, -3.745686895324862e-26, -2.039241786971026e-28,  1.504456537041065e+00, -2.164129377354930e-03,
 -3.978917509737850e-06,  4.142590842936993e-09,  3.847402929705938e-11,  3.092791893514978e-14, -3.549746574208116e-16, -1.029444619600176e-18,  2.422543319270364e-21,
  1.800768076627953e-23,  2.582432843321000e-27, -2.440500954296810e-28,  1.566675669639885e+00, -2.012100525042304e-03, -4.385427662291808e-06,  1.158493179610416e-09,
  3.757753820809267e-11,  7.436216422638232e-14, -2.393586451939540e-16, -1.455096349646422e-18, -4.749860366200464e-22,  1.814674789764821e-23,  5.133359646430978e-26,
 -1.293471086651339e-28,  1.627019195114599e+00, -1.836045206585831e-03, -4.643567212872003e-06, -2.007172353260785e-09,  3.246633469261461e-11,  1.090633760461194e-13,
 -5.655506955840405e-17, -1.490841886022992e-18, -3.633706488756300e-21,  9.406801753429430e-24,  7.933455688409878e-26,  1.046722928821275e-28,  1.684943758830174e+00,
 -1.638863577664567e-03, -4.725853296680848e-06, -5.072208308361708e-09,  2.332900557799756e-11,  1.263150851079458e-13,  1.530452129564033e-16, -1.044329473359753e-18,
 -5.622279284601010e-21, -5.343704411043241e-24,  6.133859038235348e-26,  2.989334440325567e-28,  1.739866412212254e+00, -1.424817475154495e-03, -4.613874542520889e-06,
 -7.710350442754382e-09,  1.117510995748141e-11,  1.199668093616889e-13,  3.288976569290605e-16, -2.160161755183119e-19, -5.235454870407708e-21, -1.819445858823988e-23,
  9.858387307881518e-28,  2.748869542418747e-28,  1.791172092779080e+00, -1.199622186318629e-03, -4.302993357563188e-06, -9.595178285367410e-09, -2.154368160444008e-12,
  8.937599103736670e-14,  4.096440474152413e-16,  6.846210754404003e-19, -2.389911999119728e-21, -2.053217887619881e-23, -6.064226535446774e-26,  2.226377808852066e-29,
  1.838225005985566e+00, -9.704333442619203e-04, -3.806725053006427e-06, -1.046197208221800e-08, -1.423788530537114e-11,  4.131717806573926e-14,  3.615595415982218e-16,
  1.252965240252396e-18,  1.448573275515798e-21, -1.012224198689624e-23, -7.319308702813383e-26, -2.310271402372701e-28,  1.880384302593007e+00, -7.456870546377970e-04,
 -3.159735252908321e-06, -1.017816388499810e-08, -2.262135015709006e-11, -1.067885098055873e-14,  2.027374209417983e-16,  1.215673928879723e-18,  3.964102515060846e-21,
  5.238317883339757e-24, -2.722137616258156e-26, -2.323021888341100e-28,  1.917024046145801e+00, -5.347593560152101e-04, -2.418206720361746e-06, -8.804429717277024e-09,
 -2.557505966075136e-11, -5.045175259838271e-14,  4.455336383632790e-18,  6.375180485048701e-19,  3.674082255208161e-21,  1.328247826429670e-23,  2.885327451277048e-26,
 -1.492144495058243e-29,  1.947556883583091e+00, -3.474320455647113e-04, -1.656457409492341e-06, -6.622609841299281e-09, -2.281557800417230e-11, -6.595011550259161e-14,
 -1.410711501549075e-16, -7.892157594627351e-20,  1.267321850945217e-21,  8.978884535077013e-24,  4.004984757625710e-26,  1.332297536842625e-28,  1.971460133572230e+00,
 -1.931862359655255e-04, -9.592912101468899e-07, -4.108667549835545e-09, -1.584679846427730e-11, -5.553512884881095e-14, -1.746779135553480e-16, -4.718010584470922e-19,
 -9.445959390147077e-22, -2.967653340926630e-25,  1.014174603144464e-26,  7.140836670485060e-29,  1.988302434466347e+00, -8.038724112192695e-05, -4.106284733584140e-07,
 -1.842447384842648e-09, -7.633775391076811e-12, -2.979352702215091e-14, -1.103938676219199e-16, -3.887280465042775e-19, -1.294601681730419e-21, -4.026850148963461e-24,
 -1.138045029635062e-26, -2.728386099545290e-29,  1.997770820307072e+00, -1.544982056450171e-05, -8.017493133718913e-08, -3.690206227364247e-10, -1.588015745437034e-12,
 -6.539060204348875e-15, -2.607831382556772e-17, -1.014293100085295e-19, -3.863636060589853e-22, -1.445120831363047e-24, -5.315653778655682e-27, -1.924375262045635e-29,
  2.919973863858947e-04, -1.122989956059195e-06,  3.238752175376655e-09, -8.301977230360242e-12,  1.994614970147054e-14, -4.599863932958212e-17,  1.030954431034275e-19,
 -2.263224701539640e-22,  4.887775321517048e-25, -1.042659649691220e-27,  2.199330450421681e-30, -4.604925750329603e-33,  2.627881613698757e-03, -1.010009302781114e-05,
  2.908675537628732e-08, -7.436701285979092e-11,  1.779581744078449e-13, -4.080429945355145e-16,  9.074053604476849e-19, -1.971711491097963e-21,  4.203094089245541e-24,
 -8.822175041531249e-27,  1.824358943193217e-29, -3.730016074585693e-32,  7.299140677494137e-03, -2.801788156601778e-05,  8.045185793434142e-08, -2.046288589496886e-10,
  4.857125841914028e-13, -1.100688849501225e-15,  2.408432146600191e-18, -5.121985991331548e-21,  1.061758200086363e-23, -2.150493156733428e-26,  4.249908657523554e-29,
 -8.208370613917937e-32,  1.430473916559794e-02, -5.480321974970421e-05,  1.566714862207217e-07, -3.953637409041788e-10,  9.268401816846055e-13, -2.062310952087250e-15,
  4.398125528206857e-18, -9.030269762998284e-21,  1.784877079737074e-23, -3.389927218974419e-26,  6.131972538894492e-29, -1.045931072819386e-31,  2.364308207497339e-02,
 -9.034565018838362e-05,  2.567499062795026e-07, -6.410182920770746e-10,  1.477215677873414e-12, -3.203623686688433e-15,  6.582107764488096e-18, -1.281003181017852e-20,
  2.342245363844165e-23, -3.955602542956842e-26,  5.896523472707674e-29, -6.896140534801535e-32,  3.531196367941446e-02, -1.344964836090949e-04,  3.793560935853538e-07,
 -9.342500177034098e-10,  2.105481075908977e-12, -4.411465277015890e-15,  8.600500699745453e-18, -1.543125082843351e-20,  2.466396466893791e-23, -3.219790124404021e-26,
  2.240143989654438e-29,  4.726162282090236e-32,  4.930849788163513e-02, -1.870675753930535e-04,  5.228210960877996e-07, -1.265984135251453e-09,  2.773758581907703e-12,
 -5.553840859397659e-15,  1.005497291013031e-17, -1.584118907822990e-20,  1.916713540613802e-23, -7.338556345017226e-27, -5.368215954331025e-29,  2.391776671453918e-31,
  6.562902874691610e-02, -2.478297809712250e-04,  6.851350786236423e-07, -1.625489343903817e-09,  3.438565460422354e-12, -6.486211921564118e-15,  1.054131030481528e-17,
 -1.310310466844636e-20,  5.298290569396222e-24,  3.613834373955402e-26, -1.626698186598643e-28,  4.656708358533283e-31,  8.426901953677388e-02, -3.165110805540731e-04,
  8.639443016309923e-07, -2.000475807149929e-09,  4.051945637649699e-12, -7.059002845261960e-15,  9.686542229965803e-18, -6.544242416164333e-21, -1.731830248276205e-23,
  9.470444011740643e-26, -2.837233983646472e-28,  6.494151986881346e-31,  1.052229181454697e-01, -3.927943625202889e-04,  1.056548364814451e-06, -2.377219420287474e-09,
  4.562834598877494e-12, -7.126268351092416e-15,  7.189319497143476e-18,  4.097689603179814e-21, -4.739573036417137e-23,  1.594965016747406e-25, -3.824009104776811e-28,
  6.885128352167385e-31,  1.284839963805769e-01, -4.763148541809082e-04,  1.259898140550482e-06, -2.740717283212742e-09,  4.918674922451991e-12, -6.555425414050326e-15,
  2.861829896264568e-18,  1.854257397218412e-20, -8.172896143199112e-23,  2.164803975848437e-25, -4.149396415800394e-28,  4.805851566158838e-31,  1.540441600114263e-01,
 -5.666571887814290e-04,  1.470594936485562e-06, -3.074880206398066e-09,  5.067299219359060e-12, -5.237896066662874e-15, -3.328957059960913e-18,  3.586568196868216e-20,
 -1.151596168300034e-22,  2.476934987423849e-25, -3.364919085937034e-28, -4.263548220952791e-32,  1.818937259252565e-01, -6.633520987900012e-04,  1.684891566687477e-06,
 -3.362769033358667e-09,  4.959094733608326e-12, -3.100429280382467e-15, -1.122350299519446e-17,  5.444239861473674e-20, -1.408288241119613e-22,  2.337000113067542e-25,
 -1.129208226623327e-28, -8.756081494058067e-31,  2.120211620685358e-01, -7.658727281240036e-04,  1.898696181254127e-06, -3.586882541398864e-09,  4.549458640544897e-12,
 -1.167662410825993e-16, -2.043881312697510e-17,  7.195847926204437e-20, -1.507746236310060e-22,  1.572502927683417e-25,  2.651263885040806e-28, -1.903282100734635e-30,
  2.444127850974492e-01, -8.736305604940352e-04,  2.107579911530954e-06, -3.729505639048975e-09,  3.801544155835824e-12,  3.680820921481858e-15, -3.034859784993044e-17,
  8.550484473036605e-20, -1.369078110703852e-22,  7.931115606390039e-27,  7.681968391586029e-28, -2.881780574373299e-30,  2.790524098034289e-01, -9.859709681585651e-04,
  2.306789638694330e-06, -3.773127439375041e-09,  2.689283646085475e-12,  8.190755897390766e-15, -4.007934420576082e-17,  9.177464448019251e-20, -9.236291904497422e-23,
 -2.126720989722679e-25,  1.317478763129465e-27, -3.449689126010692e-30,  3.159209434028686e-01, -1.102168395957689e-03,  2.491267494440328e-06, -3.700939438092299e-09,
  1.200654385121393e-12,  1.323299624284485e-14, -4.852778835254816e-17,  8.737647773545796e-20, -1.316594573125555e-23, -4.860981774171352e-25,  1.782053758207177e-27,
 -3.183163250339064e-30,  3.549959166710191e-01, -1.221421210671443e-03,  2.655679060785826e-06, -3.497424291449051e-09, -6.588765700277917e-13,  1.854257345108971e-14,
 -5.440569432692999e-17,  6.927014523198591e-20,  9.991504751463352e-23, -7.735577940491126e-25,  1.988725008922334e-27, -1.702611302891531e-30,  3.962509426460638e-01,
 -1.342846267007797e-03,  2.794452657508200e-06, -3.149045319462337e-09, -2.862832070174583e-12,  2.376720392670887e-14, -5.631783843188734e-17,  3.531879108547166e-20,
  2.395665050527937e-22, -1.015356912114461e-24,  1.748692611927996e-27,  1.172754507961727e-30,  4.396550922210996e-01, -1.465473270776505e-03,  2.901832594139857e-06,
 -2.645045496990627e-09, -5.360286637944838e-12,  2.847063733179658e-14, -5.287837997034882e-17, -1.506762152997052e-20,  3.905159378659032e-22, -1.134834758457856e-24,
  9.033652058083062e-28,  5.244546783609293e-30,  4.851721743755902e-01, -1.588239059487416e-03,  2.971949817710100e-06, -1.978361839328908e-09, -8.072738062063788e-12,
  3.214369807029342e-14, -4.286896849560967e-17, -8.024911282368604e-20,  5.289692870454714e-22, -1.048378680368889e-24, -6.124387087193434e-28,  9.775454829633522e-30,
  5.327599070800902e-01, -1.709981973812500e-03,  2.998913998490616e-06, -1.146656060705672e-09, -1.089160573746284e-11,  3.422520771754897e-14, -2.543847994592398e-17,
 -1.557191548450120e-19,  6.234601708317230e-22, -6.825492349515104e-25, -2.698141578737832e-27,  1.342304402155327e-29,  5.823689630608856e-01, -1.829436563925057e-03,
  2.976931741322710e-06, -1.534542793026201e-10, -1.367678215974718e-11,  3.413507137179168e-14, -3.385710475927398e-19, -2.336432880972249e-19,  6.377155460416340e-22,
  1.855710024166730e-27, -5.023004386562977e-27,  1.435975953557221e-29,  6.339418726817277e-01, -1.945228967410594e-03,  2.900456245863902e-06,  9.906238065392375e-10,
 -1.625679291976624e-11,  3.132164753429762e-14,  3.181936780511456e-17, -3.027471146060954e-19,  5.360694138410126e-22,  9.810591057896982e-25, -6.996835600938127e-27,
  1.066972227823886e-29,  6.874117642726237e-01, -2.055873415909831e-03,  2.764374288848340e-06,  2.266583892713779e-09, -1.843126366839151e-11,  2.532492342457055e-14,
  6.931235787180255e-17, -3.487690481412132e-19,  2.916858610368559e-22,  2.140217163233950e-24, -7.811386023603101e-27,  1.068121593952373e-30,  7.427009204507099e-01,
 -2.159770482496229e-03,  2.564236740262477e-06,  3.645787276262016e-09, -1.997653708510053e-11,  1.585574634858643e-14,  1.091012997649534e-16, -3.557146568249515e-19,
 -1.027108032642868e-22,  3.255171226281114e-24, -6.589448372184299e-27, -1.412077147566749e-29,  7.997191275559884e-01, -2.255207878286217e-03,  2.296538758204382e-06,
  5.088790116514945e-09, -2.065540413449161e-11,  2.889114594853365e-15,  1.467346860619773e-16, -3.081269044259500e-19, -6.228451807395990e-22,  3.997096866530872e-24,
 -2.665199488079533e-27, -3.197740382832816e-29,  8.583617945999016e-01, -2.340364852321352e-03,  1.959055041171659e-06,  6.544435328462781e-09, -2.023196898549538e-11,
 -1.323403362382390e-14,  1.764408498900549e-16, -1.944853674588669e-19, -1.202238780749911e-21,  3.975342443468817e-24,  4.018542112492988e-27, -4.648462448040843e-29,
  9.185078185916656e-01, -2.413321549692262e-03,  1.551233626810817e-06,  7.949398505581827e-09, -1.849258750377246e-11, -3.170729105927334e-14,  1.915040950335329e-16,
 -1.162456306733266e-20, -1.727138123167303e-21,  2.831526975734567e-24,  1.247970500653152e-26, -4.921106895703468e-29,  9.800171754781927e-01, -2.472075042384371e-03,
  1.074648119283376e-06,  9.228458496915557e-09, -1.527350361594205e-11, -5.117923754397627e-14,  1.850218585932704e-16,  2.303248756117239e-19, -2.042789376487311e-21,
  3.874159934115754e-25,  2.041324682054531e-26, -3.187703798541016e-29,  1.042728221210387e+00, -2.514564161883427e-03,  5.335021096758498e-07,  1.029583986598016e-08,
 -1.049511651478121e-11, -6.972004522325942e-14,  1.511146539590355e-16,  5.035358243489910e-19, -1.977387216360361e-21, -3.173665100372518e-24,  2.433047544310527e-26,
  8.992664546938206e-30,  1.106454697006676e+00, -2.538705716221247e-03, -6.483007713480591e-08,  1.105804844623276e-08, -4.201571595902847e-12, -8.486913829754393e-14,
  8.658902970669460e-17,  7.603874927303325e-19, -1.388232805690251e-21, -7.148199843018582e-24,  2.042534994900691e-26,  6.635994394499760e-29,  1.170982448557088e+00,
 -2.542445129795576e-03, -7.092564834070215e-07,  1.141867299827806e-08,  3.397601822089595e-12, -9.380522270831936e-14, -7.084576251078155e-18,  9.360816420649572e-19,
 -2.287030949444090e-22, -1.027556658276505e-23,  6.321730770427728e-27,  1.188737444598379e-28,  1.236065893056096e+00, -2.523824931330050e-03, -1.384464788719084e-06,
  1.128562187722577e-08,  1.188990655307536e-11, -9.367930455952623e-14, -1.218359043994541e-16,  9.585883775176905e-19,  1.376902020224967e-21, -1.094943229350615e-23,
 -1.658925863872576e-26,  1.337623380117598e-28,  1.301424303460404e+00, -2.481074712952260e-03, -2.070540856677650e-06,  1.058115137367180e-08,  2.063606318886487e-11,
 -8.213617342875233e-14, -2.417444145370833e-16,  7.676634598205742e-19,  3.080169211284407e-21, -7.776175914222605e-24, -4.126791281670292e-26,  8.090611686437256e-29,
  1.366738029539725e+00, -2.412726000713680e-03, -2.742818838418963e-06,  9.254749250735398e-09,  2.877362330317195e-11, -5.801089842111945e-14, -3.434047542432317e-16,
  3.419420193893144e-19,  4.322960837149962e-21, -4.442974724188820e-25, -5.543271917026107e-26, -4.261796744800743e-29,  1.431644843469633e+00, -2.317754633597460e-03,
 -3.372110229453902e-06,  7.298375424189648e-09,  3.526476709822621e-11, -2.211567318029901e-14, -3.989671738333490e-16, -2.719980673437406e-19,  4.468664821603012e-21,
  9.398507275365990e-24, -4.614280690985619e-26, -1.895685247599372e-28,  1.495736686520553e+00, -2.195751364181300e-03, -3.925494026178320e-06,  4.762651256728586e-09,
  3.900510679286332e-11,  2.207199287386311e-14, -3.826163313877290e-16, -9.415522970030295e-19,  3.070027910105996e-21,  1.788935158674096e-23, -8.656273073464476e-27,
 -2.656314017178683e-28,  1.558557203318758e+00, -2.047118006643854e-03, -4.367870270398239e-06,  1.771305737992169e-09,  3.900402899489966e-11,  6.812754432820488e-14,
 -2.802131700778674e-16, -1.459459123616119e-18,  2.137468065281110e-22,  2.007101824979802e-23,  4.450055474939041e-26, -1.813994933086945e-28,  1.619600577352696e+00,
 -1.873281092492939e-03, -4.664464809380730e-06, -1.470349030807486e-09,  3.463058126899062e-11,  1.071923270343871e-13, -9.987121821208678e-17, -1.601081461311428e-18,
 -3.236946798031065e-21,  1.265940747401194e-23,  8.295796397175599e-26,  5.830201930167584e-29,  1.678312314591983e+00, -1.676907331302621e-03, -4.784396225476765e-06,
 -4.678544544423509e-09,  2.588956383228503e-11,  1.296167851699490e-13,  1.212598120613433e-16, -1.226821021160184e-18, -5.767304390255991e-21, -2.625651945410073e-24,
  7.458005851492957e-26,  3.010956779841575e-28,  1.734092738867473e+00, -1.462095343561655e-03, -4.705245376375970e-06, -7.511927516207325e-09,  1.365279125218445e-11,
  1.277682359433995e-13,  3.204054478428066e-16, -3.939985072864754e-19, -5.886684023140989e-21, -1.789701149598475e-23,  1.428582962480060e-26,  3.296723440563870e-28,
  1.786304026262778e+00, -1.234507148371266e-03, -4.418281580425794e-06, -9.614807488326733e-09, -2.670286693898892e-13,  9.942813927886580e-14,  4.276283146025423e-16,
  5.958520250966705e-19, -3.172357248314932e-21, -2.292278704266338e-23, -5.848371877664074e-26,  7.780019823627821e-29,  1.834281564517175e+00, -1.001393126125891e-03,
 -3.933606725608160e-06, -1.068268400701803e-08, -1.332190016194905e-11,  5.042048402414358e-14,  3.972326035650769e-16,  1.292904181008123e-18,  1.029015469675492e-21,
 -1.325405539359248e-23, -8.340133867877743e-26, -2.314995104842637e-28,  1.877350216364190e+00, -7.714596559905357e-04, -3.284051028574526e-06, -1.054153790081333e-08,
 -2.278343825563713e-11, -5.390186018759090e-15,  2.385789406858781e-16,  1.345311542191930e-18,  4.130497727147697e-21,  3.931632069118519e-24, -3.845216405783929e-26,
 -2.788683004431580e-28,  1.914845638355713e+00, -5.545346554385571e-04, -2.526348344862861e-06, -9.221690828577011e-09, -2.658150897602586e-11, -5.011688322758019e-14,
  2.402529375614084e-17,  7.629603895264610e-19,  4.172796703607438e-21,  1.441557837736937e-23,  2.759165678652304e-26, -4.379025035755736e-29,  1.946140139869077e+00,
 -3.610078973929616e-04, -1.738163147882968e-06, -6.998395729576955e-09, -2.416859139207510e-11, -6.935744810377451e-14, -1.426623283805689e-16, -3.287453727317205e-20,
  1.620848499011906e-21,  1.070230737738978e-23,  4.622447339260987e-26,  1.473845417588497e-28,  1.970671721511917e+00, -2.010621779340913e-04, -1.010153916842673e-06,
 -4.371334278974475e-09, -1.700051146910573e-11, -5.988934650340893e-14, -1.883125329977948e-16, -5.021143245942472e-19, -9.471741706859838e-22,  1.768516428876545e-25,
  1.367197553105365e-26,  8.966221401151650e-29,  1.987974172428008e+00, -8.376282901031197e-05, -4.334908247637464e-07, -1.969502495686151e-09, -8.257046868517721e-12,
 -3.257841089742535e-14, -1.218806679465271e-16, -4.325650069306099e-19, -1.448056943819158e-21, -4.506669963336108e-24, -1.262483639018392e-26, -2.924418439490097e-29,
  1.997707709557159e+00, -1.610937511057854e-05, -8.476005695638072e-08, -3.955101217900017e-10, -1.725293216346398e-12, -7.200466654894030e-15, -2.909954885457050e-17,
 -1.146680879330998e-19, -4.424284513052236e-22, -1.675696977263084e-24, -6.239448386043848e-27, -2.285607445484477e-29,  2.875566232144220e-04, -1.097473077265596e-06,
  3.141013349545356e-09, -7.990066304201935e-12,  1.905041551113784e-14, -4.359865971117938e-17,  9.697186219423630e-20, -2.112655706456120e-22,  4.527776736757779e-25,
 -9.586074675161438e-28,  2.006443117610202e-30, -4.170361897210360e-33,  2.587941045308348e-03, -9.870920809424581e-06,  2.821116968057880e-08, -7.158380419276740e-11,
  1.700106972821854e-13, -3.869128510613366e-16,  8.540336650789446e-19, -1.842156360342474e-21,  3.898245105768736e-24, -8.124221265890827e-27,  1.667904941054359e-29,
 -3.387390526797508e-32,  7.188341013496998e-03, -2.738395842683186e-05,  7.804222362201418e-08, -1.970304753026437e-10,  4.642654096803198e-13, -1.044569775881900e-15,
  2.269659129752412e-18, -4.794289051501568e-21,  9.873152789598699e-24, -1.987508089978687e-26,  3.904471759090244e-29, -7.504321087780435e-32,  1.408800333455453e-02,
 -5.356857631684629e-05,  1.520147552076358e-07, -3.808586174151454e-10,  8.866293609514785e-13, -1.959726679816486e-15,  4.153094084866561e-18, -8.478170556171716e-21,
  1.667145866591969e-23, -3.153627350146315e-26,  5.688496837469727e-29, -9.707424850438451e-32,  2.328575931623040e-02, -8.832202282784661e-05,  2.491974125612607e-07,
 -6.178869583968691e-10,  1.414694289045020e-12, -3.049873875099882e-15,  6.233709267004335e-18, -1.208284826535232e-20,  2.204016388701168e-23, -3.725771601349343e-26,
  5.596052280943753e-29, -6.755075757618699e-32,  3.477997723922915e-02, -1.315059128036959e-04,  3.683443439200673e-07, -9.012570851949001e-10,  2.019281348857794e-12,
 -4.210150040355717e-15,  8.179302133068538e-18, -1.466037317566581e-20,  2.352143528357393e-23, -3.126408260365980e-26,  2.419852099407543e-29,  3.476645979858159e-32,
  4.856849755690584e-02, -1.829450277579049e-04,  5.078919438168173e-07, -1.222479650358210e-09,  2.665059387508546e-12, -5.317775099150694e-15,  9.619963938036622e-18,
 -1.523246217508603e-20,  1.886674460778741e-23, -9.284958727376841e-27, -4.386820921991111e-29,  2.075572036353820e-31,  6.464854955462156e-02, -2.424257983112920e-04,
  6.659550720676480e-07, -1.571496468957781e-09,  3.311341522578071e-12, -6.237602800614937e-15,  1.017698386337521e-17, -1.291396030992535e-20,  6.486951332131071e-24,
  3.002654923591277e-26, -1.432772051768882e-28,  4.166074506456023e-31,  8.301664782912621e-02, -3.096944574984886e-04,  8.403229605276295e-07, -1.936761549539969e-09,
  3.913075197980721e-12, -6.828784246872076e-15,  9.496042085982205e-18, -7.046013773065876e-21, -1.410648612087841e-23,  8.391067121147713e-26, -2.563625608006304e-28,
  5.948366447288558e-31,  1.036684665384740e-01, -3.844548518137748e-04,  1.028455091022380e-06, -2.305344858775435e-09,  4.422043098497762e-12, -6.952514041014152e-15,
  7.283664006561612e-18,  2.670002686924503e-21, -4.192198305548772e-23,  1.447954583696033e-25, -3.529228704414517e-28,  6.512323000039125e-31,  1.265986889152542e-01,
 -4.663658955456658e-04,  1.227477411921810e-06, -2.663063449394124e-09,  4.788293810696747e-12, -6.480799636104108e-15,  3.345556387100899e-18,  1.604877817153681e-20,
 -7.422929342819711e-23,  2.003093470893734e-25, -3.935390694027271e-28,  4.907471281953143e-31,  1.518008290197013e-01, -5.550386532222039e-04,  1.434179364576057e-06,
 -2.994645489164920e-09,  4.961821574220175e-12, -5.306148437793415e-15, -2.374987489694533e-18,  3.232064592661897e-20, -1.064851309857040e-22,  2.342230842723401e-25,
 -3.363982049634456e-28,  4.398564851554849e-32,  1.792670221226794e-01, -6.500330351015368e-04,  1.645012319084515e-06, -3.283933712524590e-09,  4.894513383701640e-12,
 -3.352002202535486e-15, -9.760948998178775e-18,  5.006954362447445e-20, -1.325057144695467e-22,  2.284668938380946e-25, -1.474371033509561e-28, -6.973641383193217e-31,
  2.089877794384108e-01, -7.508540919304884e-04,  1.856090177235886e-06, -3.514135862657432e-09,  4.542378407178084e-12, -5.836596081558077e-16, -1.849065803366612e-17,
  6.722615510818481e-20, -1.449421973316083e-22,  1.662577767986081e-25,  1.871168780656439e-28, -1.646648861510994e-30,  2.409517021584793e-01, -8.569478981107119e-04,
  2.063193095453380e-06, -3.668130770674902e-09,  3.868068279108356e-12,  2.980689612069114e-15, -2.801571310384320e-17,  8.113405059076475e-20, -1.360989834034931e-22,
  3.620677547590282e-26,  6.476362718837446e-28, -2.600339952507062e-30,  2.751451488560051e-01, -9.676970175662389e-04,  2.261775519628183e-06, -3.728839775960168e-09,
  2.843686111520254e-12,  7.259347214707565e-15, -3.755211291732983e-17,  8.870640958546312e-20, -9.910656125167877e-23, -1.629481584580977e-25,  1.170241073614060e-27,
 -3.240716139068158e-30,  3.115518493146090e-01, -1.082415554810049e-03,  2.446980015070667e-06, -3.679674138002272e-09,  1.453865497733769e-12,  1.209762452634722e-14,
 -4.608967958641063e-17,  8.668865825012628e-20, -2.941617721743914e-23, -4.176188251216559e-25,  1.641968159394674e-27, -3.175877700334291e-30,  3.501524566726338e-01,
 -1.200343806038487e-03,  2.613658727243334e-06, -3.505069784215044e-09, -3.009236029479530e-13,  1.726044766238620e-14, -5.242544623402970e-17,  7.203705765219129e-20,
  7.347985385894641e-23, -6.956090714496964e-25,  1.906354101929921e-27, -2.026415240346295e-30,  3.909240284408115e-01, -1.320642542962632e-03,  2.756404731219253e-06,
 -3.191120967025828e-09, -2.400919834385648e-12,  2.242827590069860e-14, -5.522698483311894e-17,  4.241366093432233e-20,  2.042830961906896e-22, -9.446011720314704e-25,
  1.783761801315493e-27,  4.404791393770815e-31,  4.338394254341821e-01, -1.442386987378434e-03,  2.869596027589258e-06, -2.726323853151396e-09, -4.803591737151319e-12,
  2.719786810830409e-14, -5.313141172164133e-17, -3.217370977756051e-21,  3.503648909969892e-22, -1.094416461634545e-24,  1.109530490363246e-27,  4.143598081644394e-30,
  4.788666159432467e-01, -1.564560569607196e-03,  2.947455524540822e-06, -2.102439287772635e-09, -7.440324921241362e-12,  3.108975685554615e-14, -4.488466818466754e-17,
 -6.392987071525301e-20,  4.908869758205420e-22, -1.064644837773436e-24, -2.099966068436153e-28,  8.522623750983577e-30,  5.259678705488859e-01, -1.686048612032645e-03,
  2.984131008842729e-06, -1.315480333232501e-09, -1.021354843708523e-11,  3.356459357406652e-14, -2.952314197837016e-17, -1.361812689198189e-19,  5.970855139879768e-22,
 -7.789453635694327e-25, -2.128852970440084e-27,  1.243677543949640e-29,  5.750988308670268e-01, -1.805632144013064e-03,  2.973799840623041e-06, -3.668238067451930e-10,
 -1.299467997940069e-11,  3.405074620718820e-14, -6.595145819062294e-18, -2.132728644559460e-19,  6.343178854558901e-22, -1.864510061278084e-25, -4.393410456072237e-27,
  1.421239875503256e-29,  6.262074332199109e-01, -1.921982141484331e-03,  2.910803878324226e-06,  7.355652290052382e-10, -1.562339980167402e-11,  3.198555848408019e-14,
  2.358753752067658e-17, -2.850808758528024e-19,  5.664666915369411e-22,  7.109785044189787e-25, -6.497989311240068e-27,  1.193414455178044e-29,  6.792326658318475e-01,
 -2.033654599811219e-03,  2.789820892449047e-06,  1.975822744667278e-09, -1.790891549692387e-11,  2.687235738887123e-14,  5.968865351075027e-17, -3.382624922788031e-19,
  3.631291656760674e-22,  1.829613096828114e-24, -7.697095537263554e-27,  4.050329485951820e-30,  7.341031357503306e-01, -2.139086999394750e-03,  2.606079356387986e-06,
  3.328838478694206e-09, -1.963404607371582e-11,  1.835439244863458e-14,  9.911252258777686e-17, -3.571784306363595e-19,  9.593232828249861e-24,  2.980482486575880e-24,
 -7.112916009226631e-27, -9.718566717022710e-30,  7.907354194866862e-01, -2.236596918945045e-03,  2.355623839319757e-06,  4.758954278535945e-09, -2.056311542816972e-11,
  6.305096369434290e-15,  1.378495681482416e-16, -3.257788693052518e-19, -4.811954527988718e-22,  3.863699701494198e-24, -3.970858870120535e-27, -2.733920624935416e-29,
  8.490321696546342e-01, -2.324383800822204e-03,  2.035638001671046e-06,  6.218834530173361e-09, -2.045476684938391e-11, -9.069014358675523e-15,  1.704783694046891e-16,
 -2.306401446457001e-19, -1.056719248515450e-21,  4.095934488930067e-24,  2.031362234459305e-27, -4.370001797631581e-29,  9.088799491225595e-01, -2.400535186106970e-03,
  1.644831002008473e-06,  7.648693438504582e-09, -1.908083057152441e-11, -2.712124643625530e-14,  1.904208357843891e-16, -6.516995161955779e-20, -1.616744977632878e-21,
  3.286839553949065e-24,  1.027446401786034e-26, -5.078599115471803e-29,  9.701467650758080e-01, -2.463039122029825e-03,  1.183890373806549e-06,  8.976137089573962e-09,
 -1.625219884461038e-11, -4.666869205531269e-14,  1.905589891061893e-16,  1.653334692581019e-19, -2.014504774611441e-21,  1.173512037333425e-24,  1.883539304078560e-26,
 -3.958615130369163e-29,  1.032679278912235e+00, -2.509804904035099e-03,  6.559992927461257e-07,  1.011696451175092e-08, -1.185214525993484e-11, -6.593135456205192e-14,
  1.643119541566080e-16,  4.386197701733775e-19, -2.074061916506151e-21, -2.196483302346493e-24,  2.443207174096462e-26, -4.256235478882645e-30,  1.096299675489725e+00,
 -2.538694841572326e-03,  6.740752502282483e-08,  1.097736429625281e-08, -5.876475367222661e-12, -8.254076324014619e-14,  1.072204212261275e-16,  7.120098275283060e-19,
 -1.630195780209673e-21, -6.276948473834873e-24,  2.303213188119198e-26,  5.194047682170598e-29,  1.160802188869990e+00, -2.547570303811011e-03, -5.719681547209776e-07,
  1.145802544577119e-08,  1.521914385490580e-12, -9.366189590734638e-14,  1.896804602314949e-17,  9.229033370689307e-19, -5.928289559691089e-22, -9.920075088417537e-24,
  1.139756356845169e-26,  1.112895358931400e-28,  1.225949303978165e+00, -2.534355849114195e-03, -1.247958212998980e-06,  1.146072202995607e-08,  9.989278093487837e-12,
 -9.627667020513638e-14, -9.443868163778118e-17,  9.962259752159243e-19,  9.722210404434630e-22, -1.149267038628894e-23, -1.051569024646555e-26,  1.415778792177069e-28,
  1.291467687879505e+00, -2.497125658388514e-03, -1.941641188686939e-06,  1.089787886734506e-08,  1.893711854517474e-11, -8.766923643905112e-14, -2.189142352357046e-16,
  8.614386472997743e-19,  2.771444003740445e-21, -9.347811890990700e-24, -3.712334272043776e-26,  1.070504616280326e-28,  1.357043954725572e+00, -2.434216588100046e-03,
 -2.629039307736785e-06,  9.705401216221674e-09,  2.753184438702697e-11, -6.612211833669022e-14, -3.318991650673408e-16,  4.795898490594906e-19,  4.266695161928993e-21,
 -2.688913401162678e-24, -5.654128709156770e-26, -7.381839888775621e-30,  1.422320439341183e+00, -2.344371638403614e-03, -3.281160594670743e-06,  7.858550642025166e-09,
  3.472616941068151e-11, -3.176581851241015e-14, -4.045329256571242e-16, -1.239594423212718e-19,  4.771831683901656e-21,  7.391973921453536e-24, -5.402122951569074e-26,
 -1.672450606559072e-28,  1.486891250138961e+00, -2.226916069477117e-03, -3.864584793495841e-06,  5.389756796316841e-09,  3.935264317752788e-11,  1.258453268035865e-14,
 -4.075082163232662e-16, -8.330971153383003e-19,  3.704951840299300e-21,  1.730469200230294e-23, -2.067649717553794e-26, -2.793090422385425e-28,  1.550298995098093e+00,
 -2.081965235924721e-03, -4.342826472111075e-06,  2.405891339551616e-09,  4.029602553843472e-11,  6.091350241054942e-14, -3.208712882563420e-16, -1.440731307288961e-18,
  9.662803750271354e-22,  2.167605551093907e-23,  3.537348817893337e-26, -2.332342688942924e-28,  1.612032723311046e+00, -1.910657806193639e-03, -4.678714179010817e-06,
 -8.992546375064280e-10,  3.674676884318230e-11,  1.042461937332780e-13, -1.460785481125261e-16, -1.696727426687543e-18, -2.721003953364105e-21,  1.601309839296738e-23,
  8.431446811277584e-26,  1.734134764879515e-30,  1.671527789560345e+00, -1.715399831297890e-03, -4.837967335419587e-06, -4.243426770130061e-09,  2.850811138752181e-11,
  1.320938881085177e-13,  8.431511556303926e-17, -1.412285569407609e-18, -5.804954281526246e-21,  6.204737142614631e-25,  8.765173115518452e-26,  2.908324020346824e-28,
  1.728168508162828e+00, -1.500093968632230e-03, -4.793992169369055e-06, -7.272626271127078e-09,  1.628404716997363e-11,  1.353037062807890e-13,  3.066403519028025e-16,
 -5.925414581860982e-19, -6.517049396626470e-21, -1.701953026141504e-23,  2.997815297150423e-26,  3.831577298395171e-28,  1.781294574539948e+00, -1.270314829624981e-03,
 -4.533617461183194e-06, -9.602608361221842e-09,  1.825453725189780e-12,  1.098791754067205e-13,  4.427637224558839e-16,  4.806893896184250e-19, -4.038689428523937e-21,
 -2.517467224394961e-23, -5.361865484896333e-26,  1.453359222709487e-28,  1.830212237410824e+00, -1.033378292254087e-03, -4.063042846898560e-06, -1.088723677133500e-08,
 -1.221520507599542e-11,  6.039173884066796e-14,  4.338184833210329e-16,  1.317534666339684e-18,  4.893831084124998e-22, -1.679175431072433e-23, -9.341143679319571e-26,
 -2.215416204892423e-28,  1.874211023009873e+00, -7.982442612407368e-04, -3.412739207577605e-06, -1.090661115808247e-08, -2.283085415856813e-11,  8.027886741417438e-16,
  2.781171451747053e-16,  1.479430372126169e-18,  4.241261759495664e-21,  2.133593409107530e-24, -5.181546377063925e-26, -3.290560969539347e-28,  1.912586367004506e+00,
 -5.751953894646087e-04, -2.639593414814402e-06, -9.654974803463418e-09, -2.757627013244039e-11, -4.926834562287000e-14,  4.733710851934077e-17,  9.050018833702268e-19,
  4.711065166552952e-21,  1.547024868702615e-23,  2.486540984836791e-26, -8.177472929656678e-29,  1.944667756369808e+00, -3.752558060609693e-04, -1.824510460524041e-06,
 -7.396376618055683e-09, -2.559002202381100e-11, -7.278615976280784e-14, -1.427961355505549e-16,  2.552692416007834e-20,  2.041012932639074e-21,  1.268502077361804e-23,
  5.300911211049663e-26,  1.608116238552726e-28,  1.969850971465852e+00, -2.093579501045153e-04, -1.064282312901323e-06, -4.653175159097528e-09, -1.824464986383057e-11,
 -6.458097283604607e-14, -2.027943119951769e-16, -5.322083996226465e-19, -9.299566456677720e-22,  8.088729684466048e-25,  1.809121935120900e-26,  1.119344236434288e-28,
  1.987632032339261e+00, -8.732758821755484e-05, -4.579395592694097e-07, -2.106990937895234e-09, -8.938875214533750e-12, -3.565427840170894e-14, -1.346663173528719e-16,
 -4.815986830667687e-19, -1.619701801150591e-21, -5.037914927480791e-24, -1.394951395104018e-26, -3.090224182215652e-29,  1.997641885159776e+00, -1.680692052861015e-05,
 -8.967668484474349e-08, -4.243059548820052e-10, -1.876555019463035e-12, -7.939041638777170e-15, -3.251788729964322e-17, -1.298412074267181e-19, -5.074993234184548e-22,
 -1.946608705212930e-24, -7.337755371004207e-27, -2.719963717626259e-29,  2.832163871029239e-04, -1.072723377397100e-06,  3.046933022852327e-09, -7.692110972464544e-12,
  1.820124474171125e-14, -4.134071434826619e-17,  9.125419102122786e-20, -1.973137050462273e-22,  4.196693009942806e-25, -8.819016892561211e-28,  1.831689544298719e-30,
 -3.779841264160182e-33,  2.548903364934164e-03, -9.648621812629752e-06,  2.736823325484605e-08, -6.892444271966358e-11,  1.624733020501106e-13, -3.670211772939025e-16,
  8.041566339179474e-19, -1.721966165200148e-21,  3.617431389732729e-24, -7.485935781129573e-27,  1.525772250832839e-29, -3.078442968519076e-32,  7.080039057260048e-03,
 -2.676895338922037e-05,  7.572174744551875e-08, -1.897664452840806e-10,  4.439080406489848e-13, -9.916737870744593e-16,  2.139736757009098e-18, -4.489501125815285e-21,
  9.184983958880274e-24, -1.837740124291096e-26,  3.588589914455997e-29, -6.863946047120432e-32,  1.387613265669776e-02, -5.237050126963085e-05,  1.475282921224138e-07,
 -3.669807679148930e-10,  8.484126486059018e-13, -1.862841836618450e-15,  3.923006531644777e-18, -7.962417848794214e-21,  1.557609978475075e-23, -2.934420270089138e-26,
  5.276956211522117e-29, -9.007285224666564e-32,  2.293641196130766e-02, -8.635772188807459e-05,  2.419165928157952e-07, -5.957318144458725e-10,  1.355165904550459e-12,
 -2.904246216514850e-15,  5.905064916774551e-18, -1.139859723462313e-20,  2.073846585043352e-23, -3.507824422555676e-26,  5.302588150583456e-29, -6.579271202648166e-32,
  3.425977936903197e-02, -1.286018754787176e-04,  3.577203653798735e-07, -8.696116798594453e-10,  1.937008566016276e-12, -4.018688654258130e-15,  7.779181434189701e-18,
 -1.392550574992212e-20,  2.241369017363702e-23, -3.026878700868561e-26,  2.548935455076155e-29,  2.420328305172182e-32,  4.784475182134963e-02, -1.789398543366670e-04,
  4.934745642236009e-07, -1.180677143530678e-09,  2.560978480874845e-12, -5.091946170310176e-15,  9.201854734954768e-18, -1.463439579528209e-20,  1.850302432153009e-23,
 -1.086550883579675e-26, -3.536260948290208e-29,  1.796357964695838e-31,  6.368938346796069e-02, -2.371726982759121e-04,  6.474109290611786e-07, -1.519499872764150e-09,
  3.189002779156368e-12, -5.997669861611756e-15,  9.818453950288687e-18, -1.269015362844772e-20,  7.469042621251979e-24,  2.464867434591895e-26, -1.259401277794387e-28,
  3.721727268272984e-31,  8.179116946165986e-02, -3.030637843118298e-04,  8.174530100804213e-07, -1.875232636973598e-09,  3.778762330753498e-12, -6.603294984793042e-15,
  9.292874300895521e-18, -7.451017627222592e-21, -1.126411501235913e-23,  7.416433604688823e-26, -2.313262804478343e-28,  5.437488591733507e-31,  1.021469288906756e-01,
 -3.763366753490930e-04,  1.001210911024480e-06, -2.235695050796282e-09,  4.284746189255553e-12, -6.776955853402517e-15,  7.340407562883027e-18,  1.409232230090375e-21,
 -3.695664673307996e-23,  1.312404880184744e-25, -3.251019817587297e-28,  6.133013527378826e-31,  1.247526644045941e-01, -4.566726107016784e-04,  1.195976063944797e-06,
 -2.587483165719643e-09,  4.659515790822081e-12, -6.395375750955502e-15,  3.762730111288484e-18,  1.378582316222320e-20, -6.729628925231699e-23,  1.850008492395647e-25,
 -3.718688046134478e-28,  4.931072694818773e-31,  1.496033955782710e-01, -5.437076197575739e-04,  1.398716442311551e-06, -2.916108123847210e-09,  4.855199954421834e-12,
 -5.352665752281927e-15, -1.516465613990715e-18,  2.904544234769670e-20, -9.829464003870893e-23,  2.208276285547607e-25, -3.328639155312259e-28,  1.141346518936097e-31,
  1.766929624730908e-01, -6.370292392348277e-04,  1.606072735549222e-06, -3.206170078876584e-09,  4.825241825446152e-12, -3.569913194901627e-15, -8.417136322424657e-18,
  4.595976231606932e-20, -1.243940232574807e-22,  2.220029192457432e-25, -1.746343618222655e-28, -5.425559539647330e-31,  2.060137951821092e-01, -7.361728145477582e-04,
  1.814356153617348e-06, -3.441574674863021e-09,  4.526417240972186e-12, -1.005365945219153e-15, -1.667235050901039e-17,  6.268507633053801e-20, -1.388390124083983e-22,
  1.723635581339296e-25,  1.198655585215892e-28, -1.414133926985119e-30,  2.375566443686423e-01, -8.406173672124075e-04,  2.019548711766029e-06, -3.605800536801882e-09,
  3.921139774557967e-12,  2.335082782333786e-15, -2.580470170749154e-17,  7.680451898002480e-20, -1.343560865078557e-22,  5.990377020204319e-26,  5.391628772792165e-28,
 -2.332713849830408e-30,  2.713102669083587e-01, -9.497810135156048e-04,  2.217307071024169e-06, -3.682227432605491e-09,  2.980059860900942e-12,  6.387538384839637e-15,
 -3.511355225041096e-17,  8.544990065669170e-20, -1.041639043534264e-22, -1.189263580827781e-25,  1.032446247947904e-27, -3.021496981499863e-30,  3.072610597024165e-01,
 -1.063015925594686e-03,  2.402971288501762e-06, -3.654535947867679e-09,  1.684952467986702e-12,  1.102047979131699e-14, -4.367774696167612e-17,  8.551919550487666e-20,
 -4.330180422275869e-23, -3.547221151377963e-25,  1.503258858848918e-27, -3.122274131406736e-30,  3.453926335212922e-01, -1.179602835626248e-03,  2.571580173501942e-06,
 -3.507190562736223e-09,  3.186790015457467e-14,  1.602668449031575e-14, -5.037915038896119e-17,  7.400228014636657e-20,  4.978831263707147e-23, -6.212140375954504e-25,
  1.811665594904081e-27, -2.264397106459111e-30,  3.856853173418732e-01, -1.298745098344337e-03,  2.717895361828541e-06, -3.226018759549777e-09, -1.965508912446811e-12,
  2.111778701429687e-14, -5.395289734052943e-17,  4.842042674365971e-20,  1.715646863577793e-22, -8.730533879311312e-25,  1.789114637897094e-27, -1.792534895271732e-31,
  4.281155820298551e-01, -1.419562348389055e-03,  2.836436722680711e-06, -2.798898953708554e-09, -4.272386816517410e-12,  2.592286401984571e-14, -5.307039457512969e-17,
  7.372825685475961e-21,  3.118059457524691e-22, -1.046689760884878e-24,  1.269549569646872e-27,  3.147515849301241e-30,  4.726553703725613e-01, -1.541083819391787e-03,
  2.921532309954740e-06, -2.216569232154115e-09, -6.829438074180485e-12,  2.999278397531386e-14, -4.646055647360839e-17, -4.883563221535184e-20,  4.524956535329470e-22,
 -1.065904816019501e-24,  1.381795245300046e-28,  7.312174054139422e-30,  5.192713183653297e-01, -1.662241434341291e-03,  2.967386768670412e-06, -1.473566529370231e-09,
 -9.549639932470869e-12,  3.281241384919113e-14, -3.307304991336968e-17, -1.175385878435561e-19,  5.676397728090302e-22, -8.534651014639041e-25, -1.604925349121692e-27,
  1.136759232582871e-29,  5.679238502880133e-01, -1.781862835692410e-03,  2.968172905850165e-06, -5.693011562751813e-10, -1.231571976961510e-11,  3.382308933400857e-14,
 -1.228385544043451e-17, -1.931147875743030e-19,  6.245922118871751e-22, -3.497816056583950e-25, -3.776039488951239e-27,  1.381225314164548e-29,  6.185661274839331e-01,
 -1.898664604086932e-03,  2.918152017467501e-06,  4.907366028524250e-10, -1.497866350637437e-11,  3.245794243609412e-14,  1.586254627553644e-17, -2.665935381932421e-19,
  5.875125118098543e-22,  4.618405342845034e-25, -5.952702910828959e-27,  1.278691486668225e-29,  6.711428279068566e-01, -2.011246023069121e-03,  2.811829488637743e-06,
  1.693654312026329e-09, -1.735790321492441e-11,  2.819260069608117e-14,  5.038946606192148e-17, -3.256475278300918e-19,  4.235033879092706e-22,  1.526067786689931e-24,
 -7.461852923784646e-27,  6.565312217070597e-30,  7.255887305125239e-01, -2.118083892035718e-03,  2.644153072972861e-06,  3.017756288571682e-09, -1.924398070722406e-11,
  2.061321288738496e-14,  8.913155869445308e-17, -3.552103633964300e-19,  1.116774775611498e-22,  2.688642104043193e-24, -7.449317936929100e-27, -5.630086195282233e-30,
  7.818270755907116e-01, -2.217529080856425e-03,  2.410761966675314e-06,  4.431129871856442e-09, -2.040467692227198e-11,  9.502411671545912e-15,  1.285328628135934e-16,
 -3.389845572715811e-19, -3.452384865851773e-22,  3.682202565352534e-24, -5.069362611050725e-27, -2.258603950053753e-29,  8.397676694197974e-01, -2.307805768799754e-03,
  2.108295086805657e-06,  5.890327259389072e-09, -2.059577458780692e-11, -5.058712962580538e-15,  1.635692926383533e-16, -2.620839225771029e-19, -9.082574413473454e-22,
  4.139729147710256e-24,  1.842679865656075e-28, -4.014726308661466e-29,  8.993046995955031e-01, -2.387014630406321e-03,  1.734766465905338e-06,  7.339308334530529e-09,
 -1.957773204490597e-11, -2.257877757018775e-14,  1.878901039003721e-16, -1.149376340301433e-19, -1.491561191361575e-21,  3.652979183306924e-24,  8.031318350793932e-27,
 -5.095273416216202e-29,  9.603142266877626e-01, -2.453141634371871e-03,  1.290013815363126e-06,  8.708884849722417e-09, -1.713950101478464e-11, -4.204696457247065e-14,
  1.942931955433217e-16,  1.016871448039204e-19, -1.959134275640541e-21,  1.890177163763568e-24,  1.695343417226762e-26, -4.568539706940457e-29,  1.022651319492510e+00,
 -2.504074617983504e-03,  7.762222513845205e-07,  9.916999473510699e-09, -1.313038173813760e-11, -6.184805756098726e-14,  1.756535821343972e-16,  3.711726402186681e-19,
 -2.135623276528352e-21, -1.226656552903020e-24,  2.396934286887574e-26, -1.659723194205367e-29,  1.086146806502729e+00, -2.537630390807600e-03,  1.985177491977157e-07,
  1.087028065335692e-08, -7.499974220275923e-12, -7.973433495018434e-14,  1.263936901171398e-16,  6.564100527594228e-19, -1.839072498497903e-21, -5.314411432254578e-24,
  2.498331026410908e-26,  3.665291381477642e-29,  1.150603627371177e+00, -2.551595792028604e-03, -4.343874584164256e-07,  1.146742365020536e-08, -3.446905236962149e-13,
 -9.289903755258612e-14,  4.449074659813212e-17,  8.983162421003722e-19, -9.405917702573570e-22, -9.369187716448309e-24,  1.606843067081018e-26,  1.005364707952586e-28,
  1.215792787907169e+00, -2.543786830170406e-03, -1.109534493398509e-06,  1.160503260657632e-08,  8.043355383317611e-12, -9.820533597677841e-14, -6.617150542589218e-17,
  1.020648358196020e-18,  5.524273273036707e-22, -1.178740978154613e-23, -4.197388734699749e-27,  1.448568305651108e-28,  1.281448954319604e+00, -2.512130673886581e-03,
 -1.809107442455358e-06,  1.118656859918894e-08,  1.713319857947664e-11, -9.262403411362642e-14, -1.936049243636324e-16,  9.444635624898173e-19,  2.409393609615205e-21,
 -1.073150927053583e-23, -3.189390551667738e-26,  1.300495540384300e-28,  1.347265771790947e+00, -2.454775657935568e-03, -2.509976465480666e-06,  1.013490323293973e-08,
  2.613091323004620e-11, -7.391123279303441e-14, -3.165768348093643e-16,  6.141387901873501e-19,  4.129204366630438e-21, -4.946271120356976e-24, -5.605762796188413e-26,
  2.952440984323352e-29,  1.412891064734770e+00, -2.370234318927918e-03, -3.183546951360866e-06,  8.408558444041246e-09,  3.399357416224779e-11, -4.149877352863577e-14,
 -4.058290584106109e-16,  3.256599597734216e-20,  4.997348410578716e-21,  5.092226799820583e-24, -6.074806881936619e-26, -1.373182194968807e-28,  1.477922177258112e+00,
 -2.257563319942207e-03, -3.796123294792464e-06,  6.020873538927903e-09,  3.950471405305180e-11,  2.538381282321060e-15, -4.290827420689734e-16, -7.047549476516052e-19,
  4.310052496160862e-21,  1.622985012086274e-23, -3.309705071427565e-26, -2.836093610807088e-28,  1.541901847370820e+00, -2.116581314596069e-03, -4.310048547338134e-06,
  3.059941848818470e-09,  4.143404005032048e-11,  5.273273012521065e-14, -3.606597341131185e-16, -1.397072804596466e-18,  1.769479341615846e-21,  2.287100327827340e-23,
  2.401579833895842e-26, -2.823581318243451e-28,  1.604315178634065e+00, -1.948120531591452e-03, -4.685909403945929e-06, -2.948337542577112e-10,  3.879273718342569e-11,
  1.001609249274021e-13, -1.947146268467299e-16, -1.773926061217838e-18, -2.083977148045854e-21,  1.936845877424716e-23,  8.297412275878077e-26, -6.406438228271683e-29,
  1.664588471470000e+00, -1.754299298831171e-03, -4.886064177499155e-06, -3.766065841020671e-09,  3.116691340843994e-11,  1.336219776615361e-13,  4.217882573955202e-17,
 -1.596985361543405e-18, -5.716478440493581e-21,  4.376279252304991e-24,  9.995747607372022e-26,  2.659421388424043e-28,  1.722090882221451e+00, -1.538790354557628e-03,
 -4.879609836848727e-06, -6.990039136514044e-09,  1.906224693580409e-11,  1.424398581155941e-13,  2.870392886610212e-16, -8.106249830611195e-19, -7.103969088059851e-21,
 -1.546835555024672e-23,  4.793793440576051e-26,  4.321615515233243e-28,  1.776140048469758e+00, -1.307044027203317e-03, -4.648599115622997e-06, -9.555238767104728e-09,
  4.130311648836664e-12,  1.206515606043073e-13,  4.542745749803544e-16,  3.365506219210110e-19, -4.981838137735799e-21, -2.716897503275035e-23, -4.551735366052367e-26,
  2.248377412144850e-28,  1.826012883561355e+00, -1.066408449396952e-03, -4.194820622512743e-06, -1.107243910767695e-08, -1.090025901462827e-11,  7.124725888813821e-14,
  4.708325704223358e-16,  1.322782999994626e-18, -1.846744509683282e-22, -2.071735480003866e-23, -1.026981538909270e-25, -1.980879553621630e-28,  1.870962604472757e+00,
 -8.260758985817823e-04, -3.545808559717623e-06, -1.127139935281489e-08, -2.274461541468326e-11,  7.990081118167273e-15,  3.214498074266881e-16,  1.615950447968872e-18,
  4.277135338463988e-21, -2.439206599415121e-25, -6.744218961287921e-26, -3.814639125407064e-28,  1.910242607486463e+00, -5.967831507619697e-04, -2.758132727251627e-06,
 -1.010400740453540e-08, -2.854813334608631e-11, -4.781061789733179e-14,  7.487276738303429e-17,  1.064850961196477e-18,  5.284908359010327e-21,  1.637937327348795e-23,
  2.023516051173840e-26, -1.306362803572623e-28,  1.943136968879619e+00, -3.902139881517855e-04, -1.915772263095582e-06, -7.817648580812804e-09, -2.707991840911817e-11,
 -7.619687273451990e-14, -1.410953576879598e-16,  9.856919887983911e-20,  2.537578544157130e-21,  1.495049873027398e-23,  6.034971964866432e-26,  1.724497488797159e-28,
  1.968996150369555e+00, -2.181006234666763e-04, -1.121915395231256e-06, -4.955692083083103e-09, -1.958616424995560e-11, -6.963018892303454e-14, -2.181073364160811e-16,
 -5.613513566634647e-19, -8.865561627981391e-22,  1.638610201252831e-24,  2.359251693500301e-26,  1.389787926988561e-28,  1.987275231316687e+00, -9.109472698938147e-05,
 -4.841056959847816e-07, -2.255897923125135e-09, -9.685403958900498e-12, -3.905411551507662e-14, -1.489047553836378e-16, -5.364413531273277e-19, -1.811441616832319e-21,
 -5.623469600916152e-24, -1.533648122748484e-26, -3.203156151550814e-29,  1.997573189666590e+00, -1.754522346527641e-05, -9.495388616699227e-08, -4.556447551344365e-10,
 -2.043444391539059e-12, -8.764999534039958e-15, -3.639175370333998e-17, -1.472615074187144e-19, -5.831621052641900e-22, -2.265524258628583e-24, -8.646114535916254e-27,
 -3.243277421174475e-29,  };
  constexpr double w[19200] = {  6.218744110310599e-02, -1.612658189081749e-04,  4.358626929424168e-07, -1.217219478912463e-09,  3.479636105559668e-12,
 -1.009888319133585e-14,  2.956666474409280e-17, -8.692604496420499e-20,  2.558531317038882e-22, -7.524740416545892e-25,  2.208735479937350e-27, -6.466385390237101e-30,
  6.200939615429494e-02, -2.192801217118969e-04,  9.022549397108891e-07, -3.785414677171466e-09,  1.557289982665915e-11, -6.245781030829301e-14,  2.447514225297103e-16,
 -9.401732588749116e-19,  3.550282272692212e-21, -1.320860456486174e-23,  4.850031032200594e-26, -1.760028463342531e-28,  6.165547948604001e-02, -3.340987903697785e-04,
  1.986041250606089e-06, -1.106329369096215e-08,  5.798448434081593e-11, -2.899398368287502e-13,  1.396646794370884e-15, -6.523441645952061e-18,  2.968174988553130e-20,
 -1.320178827721835e-22,  5.755473834283761e-25, -2.464714813133290e-27,  6.112997985878631e-02, -5.033396648551433e-04,  3.979735249446670e-06, -2.791694027611405e-08,
  1.800315229608740e-10, -1.090649117194437e-12,  6.288336328822965e-15, -3.480897160819315e-17,  1.861541748884772e-19, -9.663251480663321e-22,  4.886821155141807e-24,
 -2.414526132673253e-26,  6.043918862975717e-02, -7.235220332282217e-04,  7.298989935264225e-06, -6.301846803609056e-08,  4.904231644979296e-10, -3.533602609362339e-12,
  2.395950854617111e-14, -1.545621516110086e-16,  9.560660158058574e-19, -5.703805620591200e-21,  3.296762271523888e-23, -1.852644558838709e-25,  5.959123635745461e-02,
 -9.901728598018195e-04,  1.245651099379529e-05, -1.302660553005877e-07,  1.205306888609599e-09, -1.018670002313700e-11,  8.018104981793471e-14, -5.954581900708167e-16,
  4.210952229522216e-18, -2.855213809829470e-20,  1.866031858934179e-22, -1.180371034639433e-24,  5.859588574487905e-02, -1.297960742602212e-03,  2.002989500985191e-05,
 -2.503263649668716e-07,  2.720645973322318e-09, -2.667461438081746e-11,  2.412474097130929e-13, -2.042728932452876e-15,  1.636481758544799e-17, -1.250126635336197e-19,
  9.161024163569452e-22, -6.470216336270416e-24,  5.746428934430472e-02, -1.640851646803660e-03,  3.062537900284461e-05, -4.520515161132387e-07,  5.711941585375537e-09,
 -6.436863463620389e-11,  6.632129724156561e-13, -6.351768213269592e-15,  5.721096065866849e-17, -4.888472482340092e-19,  3.989041635185305e-21, -3.124816852459941e-23,
  5.620872158385250e-02, -2.012279697991267e-03,  4.483968848870504e-05, -7.735194724823857e-07,  1.126090195070541e-08, -1.446843921913944e-10,  1.685778381321355e-12,
 -1.813596034558422e-14,  1.824677756805382e-16, -1.733196326812983e-18,  1.565602874393644e-20, -1.352541332584699e-22,  5.484229528155108e-02, -2.405325951425788e-03,
  6.322221594755170e-05, -1.262471873847848e-06,  2.100379337280519e-08, -3.054697523801420e-10,  3.998411409805671e-12, -4.802556263010253e-14,  5.366442156521182e-16,
 -5.635767140164016e-18,  5.606225843493573e-20, -5.314818850155303e-22,  5.337867287842456e-02, -2.812898083348543e-03,  8.623965397314464e-05, -1.975973888871729e-06,
  3.729058913683195e-08, -6.098657610395113e-10,  8.914537159899588e-12, -1.188855119270777e-13,  1.467789667804688e-15, -1.695940766152068e-17,  1.849220570400272e-19,
 -1.915214264279438e-21,  5.183178217791803e-02, -3.227904351726808e-03,  1.142449637065998e-04, -2.979190803640618e-06,  6.333857606410748e-08, -1.157790109645602e-09,
  1.879533087740547e-11, -2.768989105706768e-13,  3.759394469204649e-15, -4.757760716046682e-17,  5.662329859089860e-19, -6.380713191472427e-21,  5.021554548660451e-02,
 -3.643415896181049e-03,  1.474522057601178e-04, -4.343258025290548e-06,  1.033597550743148e-07, -2.099817533943247e-09,  3.766459286876052e-11, -6.100954485969462e-13,
  9.068724559973859e-15, -1.251901404976484e-16,  1.619834738182111e-18, -1.978611417587843e-20,  4.854362979769675e-02, -4.052812421053193e-03,  1.859183311017090e-04,
 -6.142306262251278e-06,  1.626390484722262e-07, -3.652735666027240e-09,  7.204693222286007e-11, -1.277478557972993e-12,  2.070452671005593e-14, -3.105604741536206e-16,
  4.352718849210435e-18, -5.743088933357336e-20,  4.682922414786505e-02, -4.449907451038113e-03,  2.295325601722727e-04, -8.449783207129500e-06,  2.475406236367565e-07,
 -6.115489517169618e-09,  1.320401617368826e-10, -2.552151380406884e-12,  4.492564107157230e-14, -7.295352081148123e-16,  1.103755645671522e-17, -1.567912443471331e-19,
  4.508484861966484e-02, -4.829050580762145e-03,  2.780135066266889e-04, -1.133427949270457e-05,  3.654228334425675e-07, -9.883670800579310e-09,  2.325980734950125e-10,
 -4.881472684643260e-12,  9.298531357100152e-14, -1.629045210992511e-15,  2.651845572502963e-17, -4.043008209284808e-19,  4.332219776492318e-02, -5.185205376305665e-03,
  3.309137610093727e-04, -1.485511420266845e-05,  5.244482375471792e-07, -1.546025364303022e-08,  3.949526988038179e-10, -8.965996797618457e-12,  1.841673140603295e-13,
 -3.469478240390129e-15,  6.057736498054592e-17, -9.882832927249742e-19,  4.155201958731029e-02, -5.514002754960214e-03,  3.876312670081320e-04, -1.905796025655724e-05,
  7.332834061380583e-07, -2.346002119809763e-08,  6.480497913416564e-10, -1.585654368531795e-11,  3.500374304729622e-13, -7.068489542173172e-15,  1.319789061546878e-16,
 -2.297483280850073e-18,  3.978402972776204e-02, -5.811770709878359e-03,  4.474265187287052e-04, -2.397079146495339e-05,  1.000692910266573e-06, -3.460514848863131e-08,
  1.029814604783825e-09, -2.706514274881330e-11,  6.400436105914105e-13, -1.381225917657090e-14,  2.749957274094095e-16, -5.094021082326482e-18,  3.802685920734978e-02,
 -6.075542115243909e-03,  5.094443934014331e-04, -2.960041221608933e-05,  1.335042064045664e-06, -4.970975546486699e-08,  1.588016383790223e-09, -4.468097296961458e-11,
  1.128419737246839e-12, -2.594780793887845e-14,  5.493415522604628e-16, -1.079983417550826e-17,  3.628803303997481e-02, -6.303043018845911e-03,  5.727393135318848e-04,
 -3.592979083485020e-05,  1.743732532905762e-06, -6.965192953989300e-08,  2.380469735934967e-09, -7.147724857659395e-11,  1.922072640442022e-12, -4.696250965225913e-14,
  1.054416040224283e-15, -2.194409461106973e-17,  3.457397625191598e-02, -6.492664292767534e-03,  6.363024018003066e-04, -4.291636331949526e-05,  2.232602858413707e-06,
 -9.533270151877357e-08,  3.474308965458162e-09, -1.109900251334561e-10,  3.168769150218955e-12, -8.204295644787269e-14,  1.948483784074662e-15, -4.282124953948416e-17,
  3.289004333737017e-02, -6.643419774345552e-03,  6.990893410555101e-04, -5.049141090135008e-05,  2.805331461206971e-06, -1.276226619100246e-07,  4.944104830854204e-09,
 -1.675460939981064e-10,  5.064524078672447e-12, -1.385843107873324e-13,  3.472758365887300e-15, -8.039915272636774e-17,  3.124056692297446e-02, -6.754894105678945e-03,
  7.600477663012419e-04, -5.856054837441766e-05,  3.462882229615517e-06, -1.672982103870039e-07,  6.868665237192083e-09, -2.462155437994594e-10,  7.858681665499444e-12,
 -2.266941906959983e-13,  5.979265023778805e-15, -1.454874798745438e-16,  2.962892138172028e-02, -6.827183396598966e-03,  8.181431789260259e-04, -6.700529572636333e-05,
  4.203032160532083e-06, -2.149707033442782e-07,  9.326470065055042e-09, -3.526661459716428e-10,  1.185486517963608e-11, -3.596049444563166e-13,  9.959814163187878e-15,
 -2.541226284864228e-16,  2.805759729117590e-02, -6.860831624399016e-03,  8.723825681172581e-04, -7.568564778374816e-05,  5.020016789799468e-06, -2.710128632086616e-07,
  1.238982805945637e-08, -4.929021167790759e-10,  1.740583661471184e-11, -5.538799551623730e-13,  1.607155596435491e-14, -4.290447173900661e-16,  2.652828293170619e-02,
 -6.856765377244808e-03,  9.218351336926430e-04, -8.444350877541457e-05,  5.904322716804905e-06, -3.354876123167760e-07,  1.611799776526348e-08, -6.728791888453806e-10,
  2.490045056691979e-11, -8.292801935572700e-13,  2.515267592700594e-14, -7.010398933648120e-16,  2.504194942580870e-02, -6.816229180042500e-03,  9.656497136180884e-04,
 -9.310682308961197e-05,  6.842648000142428e-06, -4.080848965314189e-07,  2.054966846660771e-08, -8.980008563419594e-10,  3.474136880364505e-11, -1.208154219313869e-12,
  3.822025067521536e-14, -1.109810681442058e-15,  2.359893659025411e-02, -6.740723242001891e-03,  1.003068716047441e-03, -1.014942109840616e-04,  7.818041328628872e-06,
 -4.880720119260847e-07,  2.569533275366130e-08, -1.172516069742980e-09,  4.731304629015422e-11, -1.714235151626109e-12,  5.644163197763062e-14, -1.703942025153119e-15,
  2.219903707313293e-02, -6.631945060425267e-03,  1.033438530646452e-03, -1.094199084133028e-04,  8.810220461517676e-06, -5.742624298350573e-07,  3.153018201649232e-08,
 -1.498854915470826e-09,  6.294066859809208e-11, -2.370776292006904e-12,  8.107149443802380e-14, -2.539482136127560e-15,  2.084157684846379e-02, -6.491735926601989e-03,
  1.056216541194637e-03, -1.166988123528945e-04,  9.796060265761136e-06, -6.650071647470048e-07,  3.798820500125502e-08, -1.876953901160658e-09,  8.184211303236562e-11,
 -3.198033453495001e-12,  1.133492824215918e-13, -3.676689106875010e-15,  1.952549061826079e-02, -6.322033022993491e-03,  1.070974977855127e-03, -1.231514452400887e-04,
  1.075023144687486e-05, -7.582114195117391e-07,  4.495815751142477e-08, -2.303634222731606e-09,  1.040764601313562e-10, -4.210201635398019e-12,  1.543563824889622e-13,
 -5.174634837364739e-15,  1.824939110876270e-02, -6.124827486873449e-03,  1.077401932457875e-03, -1.286086722166641e-04,  1.164596332273398e-05, -8.513776777134086e-07,
  5.228199452029630e-08, -2.772102822814649e-09,  1.294938941899817e-10, -5.412025752387899e-12,  2.048387108000794e-13, -7.083620600000669e-15,  1.701163163271273e-02,
 -5.902128550269013e-03,  1.075299915084831e-03, -1.329160303852587e-04,  1.245589810699880e-05, -9.416747176638910e-07,  5.975621727353514e-08, -3.271645629391938e-09,
  1.576927810577932e-10, -6.795413968038743e-12,  2.650078816911613e-13, -9.435733015756145e-15,  1.581036161719849e-02, -5.655933651462294e-03,  1.064582358100818e-03,
 -1.359375579528657e-04,  1.315300035467169e-05, -1.026030326717894e-06,  6.713639684234021e-08, -3.787574265992498e-09,  1.879900962441252e-10, -8.336469014244841e-12,
  3.343416353898484e-13, -1.223431537585922e-14,  1.464357506503261e-02, -5.388204248305241e-03,  1.045268478430286e-03, -1.375590408194640e-04,  1.371148351325677e-05,
 -1.101243923501879e-06,  7.414490705064954e-08, -4.301471799915006e-09,  2.194110461407090e-10, -9.993398731038064e-12,  4.114103737813306e-13, -1.544357808571331e-14,
  1.350915212878871e-02, -5.100846944671164e-03,  1.017476894717644e-03, -1.376906230830311e-04,  1.410771581153916e-05, -1.164113958507079e-06,  8.048165275728067e-08,
 -4.791760715973824e-09,  2.507026118922698e-10, -1.170575619085107e-11,  4.937600265651161e-13, -1.897993326397335e-14,  1.240489413469691e-02, -4.795699463438276e-03,
  9.814183675008329e-04, -1.362687546670444e-04,  1.432106978351065e-05, -1.211573946350844e-06,  8.583733519568413e-08, -5.234589098863317e-09,  2.803738828951656e-10,
 -1.339538299076119e-11,  5.778807880137024e-13, -2.270681583114885e-14,  1.132855250457205e-02, -4.474520956522363e-03,  9.373879919364153e-04, -1.332574728315865e-04,
  1.433468326900790e-05, -1.240830343957609e-06,  8.990857550984960e-08, -5.605001481782508e-09,  3.067635763606444e-10, -1.496928658418316e-11,  6.592857589034111e-13,
 -2.643466456201945e-14,  1.027785209466680e-02, -4.138986128398034e-03,  8.857571277801993e-04, -1.286490340945497e-04,  1.413610441397666e-05, -1.249495256463446e-06,
  9.241403983131473e-08, -5.878331885368913e-09,  3.281322994341290e-10, -1.632448432295246e-11,  7.327131624585203e-13, -2.992733494449496e-14,  9.250509508135366e-03,
 -3.790682658205995e-03,  8.269653035494824e-04, -1.224639288083921e-04,  1.371779865978268e-05, -1.235707126740092e-06,  9.311058960859637e-08, -6.031731230809156e-09,
  3.427742116874741e-10, -1.735461371651326e-11,  7.924514039081472e-13, -3.291550786298215e-14,  8.244246950294808e-03, -3.431111431498032e-03,  7.615122838026454e-04,
 -1.147503223553755e-04,  1.307750162635192e-05, -1.198233119570633e-06,  9.180842991664547e-08, -6.045722321987839e-09,  3.491401340229410e-10, -1.795786873983170e-11,
  8.327694795715918e-13, -3.511671271186950e-14,  7.256802191625204e-03, -3.061689131713815e-03,  6.899504425286102e-04, -1.055829749388472e-04,  1.221840785916932e-05,
 -1.136547801499051e-06,  8.838425102324218e-08, -5.905665163005980e-09,  3.459621617659878e-10, -1.804560852599234e-11,  8.484184368626328e-13, -3.626052774041448e-14,
  6.285935194912462e-03, -2.683752792153491e-03,  6.128775439079742e-04, -9.506169680225049e-05,  1.114919138300847e-05, -1.050883881322965e-06,  8.279145370774370e-08,
 -5.603014929691983e-09,  3.323687580410135e-10, -1.755082969378404e-11,  8.351553833343869e-13, -3.611652327893017e-14,  5.329431978858255e-03, -2.298565978354003e-03,
  5.309299976464404e-04, -8.330939834020578e-05,  9.883859732409042e-06, -9.422521465902673e-07,  7.506671061191686e-08, -5.136264935721728e-09,  3.079793195564352e-10,
 -1.643562371169489e-11,  7.902324703187869e-13, -3.452175789742300e-14,  4.385106433161853e-03, -1.907326398892442e-03,  4.447766405613688e-04, -7.046979723765716e-05,
  8.441448666263177e-06, -8.124292511455606e-07,  6.533233458471474e-08, -4.511486994864823e-09,  2.729683957917147e-10, -1.469677327665196e-11,  7.127913080973506e-13,
 -3.140428620900423e-14,  3.450801568127877e-03, -1.511175146753467e-03,  3.551131515263390e-04, -5.670485652734731e-05,  6.845571056084944e-06, -6.639137017120132e-07,
  5.379419378247964e-08, -3.742410760250105e-09,  2.280920736567174e-10, -1.236878235891389e-11,  6.041094953685055e-13, -2.679930121340330e-14,  2.524396389959880e-03,
 -1.111209918688782e-03,  2.626576823667570e-04, -4.219210535710075e-05,  5.123847318861420e-06, -4.998528624113973e-07,  4.073527022899071e-08, -2.850023518745068e-09,
  1.746725570388217e-10, -9.523885872205548e-12,  4.676608058626975e-13, -2.085526886272011e-14,  1.603867489143851e-03, -7.085236126914777e-04,  1.681527928546534e-04,
 -2.712272289122949e-05,  3.307337657168499e-06, -3.239539946043219e-07,  2.650596052348288e-08, -1.861760173126713e-09,  1.145438675645367e-10, -6.269059843286243e-12,
  3.089793809638663e-13, -1.382895474846630e-14,  6.883485774872795e-04, -3.046857447104172e-04,  7.247301525024587e-05, -1.171650943030057e-05,  1.431963732332367e-06,
 -1.405767621679619e-07,  1.152751084490856e-08, -8.114490182253607e-10,  5.003086230828482e-11, -2.743974939732714e-12,  1.355194876658028e-13, -6.077662429288012e-15,
  6.154926043813268e-02, -1.578364125424583e-04,  4.215835616665473e-07, -1.163123378809138e-09,  3.284561970345322e-12, -9.417589657820486e-15,  2.724340372071599e-17,
 -7.915565933222816e-20,  2.302881409440935e-22, -6.695582642831789e-25,  1.943176655641106e-27, -5.625337110157616e-30,  6.114642991235424e-02, -2.122396391758162e-04,
  8.582847497315915e-07, -3.545931098719877e-09,  1.438041617972287e-11, -5.688726291185594e-14,  2.199481970492677e-16, -8.338125898404022e-19,  3.107904704579297e-21,
 -1.141494870903572e-23,  4.138414867776728e-26, -1.482982495125518e-28,  6.035004187379082e-02, -3.187261558591877e-04,  1.858662610795983e-06, -1.018017131489095e-08,
  5.250662428874104e-11, -2.585090986313478e-13,  1.226603862759757e-15, -5.645428384159925e-18,  2.531864349042472e-20, -1.110258666360215e-22,  4.773182623077238e-25,
 -2.016104610213217e-27,  5.917824228749993e-02, -4.727944335278669e-04,  3.661320848682695e-06, -2.520305944669028e-08,  1.596521417865385e-10, -9.507825709945665e-13,
  5.392109845083954e-15, -2.937289836859285e-17,  1.546432448944476e-19, -7.905475028425019e-22,  3.938239698956429e-24, -1.917292405388369e-26,  5.765727642047307e-02,
 -6.680267802628960e-04,  6.587614093993483e-06, -5.570724219984234e-08,  4.251679411489394e-10, -3.007231164083774e-12,  2.003094311429662e-14, -1.270140471426629e-16,
  7.726246423726112e-19, -4.534745487548484e-21,  2.579497724932443e-23, -1.427028936480350e-25,  5.582039212029686e-02, -8.964605305942420e-04,  1.100262839908342e-05,
 -1.125118674885966e-07,  1.019540684684652e-09, -8.448102637301628e-12,  6.524991393842764e-14, -4.758089461090631e-16,  3.305789306865145e-18, -2.203185710288161e-20,
  1.415878181478382e-22, -8.809997106689066e-25,  5.370649002482780e-02, -1.149035826304197e-03,  1.727052374323881e-05, -2.107678141000460e-07,  2.240709212612880e-09,
 -2.151577698752251e-11,  1.907532408832336e-13, -1.584511348815361e-15,  1.246065386495664e-17, -9.348850828958382e-20,  6.731656325697147e-22, -4.673545725552170e-24,
  5.135860402568207e-02, -1.416085946812945e-03,  2.570926861829377e-05, -3.701515474338434e-07,  4.570338155921632e-09, -5.039406568142379e-11,  5.085532385868115e-13,
 -4.774300330259233e-15,  4.218135682936596e-17, -3.537464916121837e-19,  2.834548614633475e-21, -2.181374294482385e-23,  4.882230156662230e-02, -1.687834609199572e-03,
  3.654968572867562e-05, -6.144577708214844e-07,  8.733848724402740e-09, -1.097131937468430e-10,  1.251135668979107e-12, -1.318520378207744e-14,  1.300437645347327e-16,
 -1.211652057341003e-18,  1.074172272747006e-20, -9.112013292640405e-23,  4.614409242676974e-02, -1.954866417462538e-03,  4.990302673111506e-05, -9.704969606356011e-07,
  1.575438128462653e-08, -2.238770183364665e-10,  2.866450976507381e-12, -3.370831071986737e-14,  3.690529299856221e-16, -3.799944417984999e-18,  3.708222324162026e-20,
 -3.450458681448589e-22,  4.336992712688285e-02, -2.208541284818854e-03,  6.574013007040944e-05, -1.466321483635595e-06,  2.698834016973159e-08, -4.310717760671637e-10,
  6.160824874527009e-12, -8.040735353987361e-14,  9.722960966763753e-16, -1.101053685387165e-17,  1.177359769396720e-19, -1.196446046904563e-21,  4.054385322240790e-02,
 -2.441330474927176e-03,  8.388377209883246e-05, -2.128921233920086e-06,  4.412971453755004e-08, -7.875851708726762e-10,  1.249712787297240e-11, -1.801278888473378e-13,
  2.394554751481879e-15, -2.969334998388808e-17,  3.464724286651883e-19, -3.830012374538479e-21,  3.770688114273502e-02, -2.647060022287225e-03,  1.040143039203987e-04,
 -2.981625507603787e-06,  6.917251733162343e-08, -1.371822951144492e-09,  2.404734889015983e-11, -3.810272887403689e-13,  5.544713805852842e-15, -7.498670000155663e-17,
  9.511258543646769e-19, -1.139533188880032e-20,  3.489609272470581e-02, -2.821055762490931e-03,  1.256872713970647e-04, -4.041506040166013e-06,  1.043253775508660e-07,
 -2.287215682978359e-09,  4.408607648949919e-11, -7.646089214227249e-13,  1.213109630873741e-14, -1.782532263723557e-16,  2.448964018544970e-18, -3.169181641380162e-20,
  3.214400695853971e-02, -2.960192163426819e-03,  1.483606027351808e-04, -5.317088297507281e-06,  1.518788916319059e-07, -3.663122218963357e-09,  7.729565208087857e-11,
 -1.461433678386965e-12,  2.518463234957072e-14, -4.006469433762194e-16,  5.942053077806433e-18, -8.279110935427001e-20,  2.947820027985761e-02, -3.062853899363406e-03,
  1.714282202100463e-04, -6.806644351094901e-06,  2.140336580314160e-07, -5.652905179604326e-09,  1.300376807939446e-10, -2.669977369698113e-12,  4.979694629501069e-14,
 -8.547800319426509e-16,  1.364185915238440e-17, -2.040250261931400e-19,  2.692116420489194e-02, -3.128824178803230e-03,  1.942566294552775e-04, -8.497268859034322e-06,
  2.927036491792637e-07, -8.428595368547579e-09,  2.105329331041568e-10, -4.677141732523522e-12,  9.408713513754490e-14, -1.737050137895254e-15,  2.974101384963387e-17,
 -4.760699233854890e-19,  2.449037198605206e-02, -3.159117001075457e-03,  2.162211406292272e-04, -1.036484327059450e-05,  3.893144713987247e-07, -1.217195704293449e-08,
  3.288864020193852e-10, -7.877837789018331e-12,  1.703693754987851e-13, -3.372629632320777e-15,  6.176920728307364e-17, -1.055328703056816e-18,  2.219851858777834e-02,
 -3.155771787944347e-03,  2.367388116441089e-04, -1.237488844207490e-05,  5.046182330066076e-07, -1.706225904612809e-08,  4.968995144204474e-10, -1.279005401282916e-11,
  2.964347095350983e-13, -6.273620861810535e-15,  1.225649671986152e-16, -2.229075333843470e-18,  2.005389457573610e-02, -3.121628420458309e-03,  2.552958744118834e-04,
 -1.448420804912553e-05,  6.385458108030641e-07, -2.326156721614053e-08,  7.276285469637913e-10, -2.006115760563834e-11,  4.967910057195682e-13, -1.120828078462316e-14,
  2.329485077561420e-16, -4.498250090456743e-18,  1.806085408727868e-02, -3.060098947809297e-03,  2.714681984094614e-04, -1.664314721262064e-05,  7.901134673506018e-07,
 -3.089881191421053e-08,  1.034676087148578e-09, -3.046110529129299e-11,  8.036373103010120e-13, -1.927558892332906e-14,  4.250777644154078e-16, -8.693528101289413e-18,
  1.622033930473815e-02, -2.974949534430117e-03,  2.849341544112771e-04, -1.879824076088953e-05,  9.573947059195414e-07, -4.005417207866639e-08,  1.431237406146040e-09,
 -4.485893437702673e-11,  1.257298743838953e-12, -3.197517640241883e-14,  7.463034724488159e-16, -1.612643161718365e-17,  1.453042807269050e-02, -2.870102994806153e-03,
  2.954799756487437e-04, -2.089500652116237e-05,  1.137560958855874e-06, -5.074540158695176e-08,  1.928960523477732e-09, -6.418040569271405e-11,  1.905832720171140e-12,
 -5.125849690891778e-14,  1.263118134785294e-15, -2.877016337500904e-17,  1.298687675717857e-02, -2.749468915670509e-03,  3.029983105564070e-04, -2.288064919028209e-05,
  1.326987303001670e-06, -6.291758891081769e-08,  2.536711397447849e-09, -8.934685359976650e-11,  2.803550180613285e-12, -7.954410681128610e-14,  2.064546191428008e-15,
 -4.945446522673840e-17,  1.158363646841815e-02, -2.616805194845921e-03,  3.074810858462851e-04, -2.470647422320006e-05,  1.521412905932437e-06, -7.643750892752289e-08,
  3.259358376793470e-09, -1.211978842837003e-10,  4.008282888809844e-12, -1.196791050831125e-13,  3.264096792805391e-15, -8.204607563123229e-17,  1.031332679653463e-02,
 -2.475612059824035e-03,  3.090080428098448e-04, -2.632986112980275e-05,  1.716141102676331e-06, -9.109324971121541e-08,  4.096698710404331e-09, -1.604031612643317e-10,
  5.577365460530479e-12, -1.748310491714616e-13,  4.999258317268355e-15, -1.315733391352663e-16,  9.167656814722034e-03, -2.329057401804321e-03,  3.077323870558848e-04,
 -2.771570322273363e-05,  1.906261318102904e-06, -1.065992502203611e-07,  5.042642829342804e-09, -2.073706993695520e-10,  7.562473599202652e-12, -2.483004415939165e-13,
  7.427518941192942e-15, -2.042433089746702e-16,  8.137787998263328e-03, -2.179930625046287e-03,  3.038649309225315e-04, -2.883727845447616e-05,  2.086874562987588e-06,
 -1.226063453264875e-07,  6.084750221232616e-09, -2.621604761886910e-10,  1.000364384388905e-11, -3.432529530655088e-13,  1.071809964662309e-14, -3.072959305141640e-16,
  7.214637733159527e-03, -2.030621153304024e-03,  2.976579451417192e-04, -2.967656729734455e-05,  2.253305709460921e-06, -1.387159525680012e-07,  7.204177289315927e-09,
 -3.244125065244711e-10,  1.292296603355334e-11, -4.623819724436869e-13,  1.503900407955873e-14, -4.486459939615187e-16,  6.389125195784951e-03, -1.883117193416234e-03,
  2.893897103733618e-04, -3.022407445556505e-05,  2.401288739722585e-06, -1.544972017355436e-07,  8.376057528782302e-09, -3.932977240595930e-10,  1.631855929281442e-11,
 -6.075242923869751e-13,  2.053960065801581e-14, -6.362816657793302e-16,  5.652363609461065e-03, -1.739020240562376e-03,  2.793505053397724e-04, -3.047823946526996e-05,
  2.527115090103782e-06, -1.695056311734965e-07,  9.570293229936181e-09, -4.674981708708538e-10,  2.015949340927926e-11, -7.792628233561126e-13,  2.732968808423440e-14,
 -8.774185923426947e-16,  4.995804316463591e-03, -1.599571017790421e-03,  2.678305156979637e-04, -3.044453672866002e-05,  2.627739496344766e-06, -1.833020561199292e-07,
  1.075270099538660e-08, -5.452203630713831e-10,  2.438228813994901e-11, -9.765582304796840e-13,  3.545674980088947e-14, -1.177448196660249e-15,  4.411338868858263e-03,
 -1.465682972623242e-03,  2.551099180188423e-04, -3.013436948965832e-05,  2.700841868907300e-06, -1.954703360038679e-07,  1.188642480023862e-08, -6.242426393150123e-10,
  2.888951390102587e-11, -1.196454716222516e-12,  4.488374876568383e-14, -1.538762603901110e-15,  3.891365575621548e-03, -1.337980014418455e-03,  2.414511999516201e-04,
 -2.956385688062330e-05,  2.744847294498667e-06, -2.056329960193048e-07,  1.293351269580418e-08, -7.019942073347913e-10,  3.355084126297906e-11, -1.433902901032035e-12,
  5.547022620243907e-14, -1.959579416344048e-15,  3.428826781458789e-03, -1.216835791754828e-03,  2.270936273964125e-04, -2.875260108989478e-05,  2.758909022318308e-06,
 -2.134639526057416e-07,  1.385654736840976e-08, -7.756608545489693e-10,  3.820666605489714e-11, -1.681734805243565e-12,  6.695954835322943e-14, -2.432919362035877e-15,
  3.017222716973344e-03, -1.102412421205446e-03,  2.122496631075732e-04, -2.772250558259485e-05,  2.742861144497291e-06, -2.186979111884094e-07,  1.462022581873991e-08,
 -8.423101740105803e-10,  4.267419948647141e-11, -1.930813093432087e-12,  7.897484219317831e-14, -2.945901518803298e-15,  2.650607154633846e-03, -9.946971466495568e-04,
  1.971030752770760e-04, -2.649669753916163e-05,  2.697148635401580e-06, -2.211363110942997e-07,  1.519279739304081e-08, -8.990278548995385e-10,  4.675568708032508e-11,
 -2.170360514395834e-12,  9.102548150045985e-14, -3.479509539738281e-15,  2.323569414144631e-03, -8.935359065953741e-04,  1.818084433838579e-04, -2.509859018249308e-05,
  2.622742579701515e-06, -2.206499588971664e-07,  1.554728949916754e-08, -9.430561519534694e-10,  5.024823135973843e-11, -2.388457824505185e-12,  1.025249945934798e-13,
 -4.008946713020247e-15,  2.031206547894544e-03, -7.986632035314105e-04,  1.664917647855955e-04, -2.355110483213360e-05,  2.521047955318019e-06, -2.171786995708206e-07,
  1.566247355714714e-08, -9.719260224103030e-10,  5.295455936201045e-11, -2.572681528152958e-12,  1.128200794351683e-13, -4.504640389345157e-15,  1.769088847266461e-03,
 -7.097280016214368e-04,  1.512518818345752e-04, -2.187605921011548e-05,  2.393810428188720e-06, -2.107286166815378e-07,  1.552354723215832e-08, -9.835754570256459e-10,
  5.469400686465614e-11, -2.710838440698340e-12,  1.212291763037503e-13, -4.933883663222650e-15,  1.533221173190907e-03, -6.263156315374078e-04,  1.361624789335365e-04,
 -2.009371812207955e-05,  2.243027441377487e-06, -2.013673288723789e-07,  1.512253044401172e-08, -9.764480355381471e-10,  5.531298780952372e-11, -2.791743881796129e-12,
  1.270879165463575e-13, -5.263023384922402e-15,  1.320002046332676e-03, -5.479658626637950e-04,  1.212744361243728e-04, -1.822249517750999e-05,  2.070867599653694e-06,
 -1.892179669170093e-07,  1.445839038374580e-08, -9.495674908601364e-10,  5.469427341891812e-11, -2.805985158483899e-12,  1.297978773515634e-13, -5.460029197728377e-15,
  1.126181941226025e-03, -4.741874244088000e-04,  1.066183659468620e-04, -1.627878946501160e-05,  1.879601088435270e-06, -1.744523845417809e-07,  1.353692386266190e-08,
 -9.025858674549637e-10,  5.276450914701145e-11, -2.746612179061586e-12,  1.288745333405776e-13, -5.497218695803258e-15,  9.488218158100062e-04, -4.044693319843830e-04,
  9.220720011420499e-05, -1.427693868280146e-05,  1.671542714083803e-06, -1.572840898844536e-07,  1.237043351838130e-08, -8.358045408915831e-10,  4.949953419243494e-11,
 -2.609702244110616e-12,  1.239901675392886e-13, -5.353877547289567e-15,  7.852525722455390e-04, -3.382894104730909e-04,  7.803873007592902e-05, -1.222926972432697e-05,
  1.449008172110904e-06, -1.379612962499427e-07,  1.097723803895544e-08, -7.501688114549073e-10,  4.492722265976602e-11, -2.394755522504857e-12,  1.150077993680181e-13,
 -5.018506095808444e-15,  6.330358932469052e-04, -2.751204304674116e-04,  6.409804083656222e-05, -1.014622887963256e-05,  1.214283393269881e-06, -1.167603949799665e-07,
  9.381056537888658e-09, -6.472379432941478e-10,  3.912772452307232e-11, -2.104890400794354e-12,  1.020028731904678e-13, -4.490447471394154e-15,  4.899267905427655e-04,
 -2.144343080879139e-04,  5.035981703598274e-05, -8.036577345982085e-06,  9.696064277401555e-07, -9.398007326055134e-08,  7.610305575796238e-09, -5.291334540202456e-10,
  3.223114190555225e-11, -1.746822832180115e-12,  8.527046725130947e-14, -3.780705147451064e-15,  3.538386870722306e-04, -1.557050914581979e-04,  3.679059234938216e-05,
 -5.907651044130961e-06,  7.171622416731155e-07, -6.993633640226467e-08,  5.697352765441868e-09, -3.984697306959456e-10,  2.441285715931490e-11, -1.330631605998412e-12,
  6.531711875565543e-14, -2.911838671660961e-15,  2.228176509247500e-04, -9.841405391869081e-05,  2.335165620539653e-05, -3.765787078338090e-06,  4.591028481433215e-07,
 -4.495982071660907e-08,  3.677863843937879e-09, -2.582783024985067e-10,  1.588727426732208e-11, -8.693499323724170e-13,  4.283883652608422e-14, -1.916968716143712e-15,
  9.515574329542652e-05, -4.211485148444929e-05,  1.001635531204221e-05, -1.619125713554778e-06,  1.978623212701805e-07, -1.942198420780056e-08,  1.592446932759413e-09,
 -1.120831959933088e-10,  6.909833802858502e-12, -3.789314301922732e-13,  1.871257920893961e-14, -8.391132405020624e-16,  6.092457297025792e-02, -1.545186946580644e-04,
  4.079352965134098e-07, -1.112042415090724e-09,  3.102573280074516e-12, -8.789533295734336e-15,  2.512669491155083e-17, -7.215757381576854e-20,  2.075255059781447e-22,
 -5.965605019804967e-25,  1.711983516937166e-27, -4.901210993214532e-30,  6.031093983126112e-02, -2.055397390413443e-04,  8.170774587550678e-07, -3.324667329922339e-09,
  1.329362391166301e-11, -5.187779762196306e-14,  1.979342141253109e-16, -7.406274963426510e-19,  2.725255774783270e-21, -9.882986547598473e-24,  3.538195840620583e-26,
 -1.252191214819034e-28,  5.910412181637112e-02, -3.043316041964663e-04,  1.741375613134176e-06, -9.379879434000402e-09,  4.761848136077337e-11, -2.308794832373304e-13,
  1.079299048643773e-15, -4.895664475961168e-18,  2.164503541672389e-20, -9.359500843601242e-23,  3.968628606043209e-25, -1.653604309634038e-27,  5.734378971140280e-02,
 -4.446715890653927e-04,  3.373605260165554e-06, -2.279398897416430e-08,  1.418667612095252e-10, -8.307072878539924e-13,  4.634877991178348e-15, -2.485084262100433e-17,
  1.288269568786916e-19, -6.486739766723781e-22,  3.183797852161194e-24, -1.527510307168146e-26,  5.508649481920230e-02, -6.178885765513195e-04,  5.958039961111589e-06,
 -4.936075255198665e-08,  3.695565000417821e-10, -2.566515455146584e-12,  1.679749528393321e-14, -1.047145950406937e-16,  6.265267068180180e-19, -3.618359974928773e-21,
  2.025959773460937e-23, -1.103561666960149e-25,  5.240241639393096e-02, -8.135750679401790e-04,  9.745049884080679e-06, -9.747015072381403e-08,  8.652182817645015e-10,
 -7.030718360516404e-12,  5.329639562142517e-14, -3.816925282088692e-16,  2.605887831862362e-18, -1.707386001065025e-20,  1.079146027263844e-22, -6.606281106658278e-25,
  4.937147600852001e-02, -1.020410178179796e-03,  1.494298403907704e-05, -1.781245607756295e-07,  1.852801093119807e-09, -1.742797078885144e-11,  1.514981816789258e-13,
 -1.234800125099271e-15,  9.533963318846732e-18, -7.026645618145281e-20,  4.972385627632266e-22, -3.394029065686703e-24,  4.607913620368412e-02, -1.227008445690179e-03,
  2.167497266037886e-05, -3.044688845810549e-07,  3.674422564716543e-09, -3.965145382700789e-11,  3.920013774804667e-13, -3.608121055170134e-15,  3.127537707934915e-17,
 -2.574735408500295e-19,  2.026274445423221e-21, -1.532178426226882e-23,  4.261220587473880e-02, -1.422712244483185e-03,  2.994719236741666e-05, -4.907563728522383e-07,
  6.812222797868403e-09, -8.368345070154173e-11,  9.342008171841138e-13, -9.646044719489188e-15,  9.328020111964579e-17, -8.526713688676498e-19,  7.420167569540499e-21,
 -6.181537456856145e-23,  3.905494720648801e-02, -1.598258375520087e-03,  3.963301049919747e-05, -7.508077487676999e-07,  1.189473421827483e-08, -1.651905483259866e-10,
  2.069269663825937e-12, -2.382839348101954e-14,  2.556575008608929e-16, -2.581311755955544e-18,  2.471544237601584e-20, -2.257554901055780e-22,  3.548572469306631e-02,
 -1.746269440380672e-03,  5.047471995958313e-05, -1.096152424279326e-06,  1.967986543810744e-08, -3.070491652949244e-10,  4.291347318603752e-12, -5.482094414302087e-14,
  6.493572324885788e-16, -7.208097234188611e-18,  7.559714070731489e-20, -7.538821615373799e-22,  3.197436484571391e-02, -1.861544410920670e-03,  6.210181523605150e-05,
 -1.534133982500492e-06,  3.100967350093665e-08, -5.404180277193056e-10,  8.382922899860496e-12, -1.182291334391652e-13,  1.539119668424623e-15, -1.870300615237416e-17,
  2.139885954725799e-19, -2.320760191082517e-21,  2.858031578866768e-02, -1.941146779765466e-03,  7.406242455637634e-05, -2.066295369230008e-06,  4.673717028007634e-08,
 -9.049163063572973e-10,  1.550395420006555e-11, -2.403270446436913e-13,  3.424097776482818e-15, -4.537084955053843e-17,  5.641917807628517e-19, -6.630651414191793e-21,
  2.535161887390948e-02, -1.984309627240508e-03,  8.586294994099858e-05, -2.687325938517214e-06,  6.763139415325329e-08, -1.447507820892566e-09,  2.726752190178205e-11,
 -4.626122828963173e-13,  7.185556252277936e-15, -1.034396607016561e-16,  1.393139487991595e-18, -1.768356776474705e-20,  2.232463779265914e-02, -1.992192584520409e-03,
  9.701033979000757e-05, -3.384762360356134e-06,  9.427241919987714e-08, -2.219848531831285e-09,  4.577982363634931e-11, -8.467233836748388e-13,  1.428522327974939e-14,
 -2.226423957676163e-16,  3.237059109242177e-18, -4.424004052111199e-20,  1.952443993208228e-02, -1.967534845446175e-03,  1.070517019504959e-04, -4.139510449593932e-06,
  1.269514694362968e-07, -3.274109417302824e-09,  7.362122659468631e-11, -1.478904323873785e-12,  2.700681076135651e-14, -4.542187462448808e-16,  7.107156496975771e-18,
 -1.042717511783615e-19,  1.696569253382593e-02, -1.914251031212333e-03,  1.156069783430746e-04, -4.927122990824297e-06,  1.655919188172019e-07, -4.657590967390576e-09,
  1.137494720809655e-10, -2.472902183499548e-12,  4.871745848906566e-14, -8.814362426433429e-16,  1.479878727676985e-17, -2.324235019083893e-19,  1.465392245884197e-02,
 -1.837013713516262e-03,  1.223918694599216e-04, -5.719656028126554e-06,  2.097044716723189e-07, -6.406730169961273e-09,  1.693162258519077e-10, -3.970047705282335e-12,
  8.410788085820536e-14, -1.632145268627869e-15,  2.932035233181031e-17, -4.916264991410289e-19,  1.258699079195390e-02, -1.740859230318582e-03,  1.272298153321502e-04,
 -6.487852150446808e-06,  2.583847658068599e-07, -8.541296288059532e-09,  2.434026453777602e-10, -6.135387180520107e-12,  1.393541479817182e-13, -2.892075742002182e-15,
  5.543871398172769e-17, -9.898403442493784e-19,  1.075664846476989e-02, -1.630843819422971e-03,  1.300533384181802e-04, -7.203373019526855e-06,  3.103551246339036e-07,
 -1.105962701702145e-08,  3.386957068963079e-10, -9.149149506615179e-12,  2.221356681798574e-13, -4.916682789947816e-15,  1.003062895209912e-16, -1.902298571228617e-18,
  9.150062255827766e-03, -1.511766727166743e-03,  1.308962365313665e-04, -7.840823169365441e-06,  3.640455626761631e-07, -1.393565371544699e-08,  4.571411522925581e-10,
 -1.319351105162934e-11,  3.414479095702575e-13, -8.038571607678494e-15,  1.740938501598083e-16, -3.498478916216335e-18,  7.751227737523076e-03, -1.387967212010500e-03,
  1.298788755343697e-04, -8.379362939328726e-06,  4.177036863067667e-07, -1.711822237696651e-08,  5.996177108774532e-10, -1.843545205271912e-11,  5.071673487126124e-13,
 -1.266714080578274e-14,  2.905096552752898e-16, -6.171330946974831e-18,  6.542213361928667e-03, -1.263194226459485e-03,  1.271891559746114e-04, -8.803785415623010e-06,
  4.695197252114079e-07, -2.053288572010438e-08,  7.656784601936638e-10, -2.500731506030276e-11,  7.293591830681092e-13, -1.927731600607609e-14,  4.670509984991647e-16,
 -1.046427629931540e-17,  5.504205176166728e-03, -1.140541546814806e-03,  1.230616692278858e-04, -9.105014583956862e-06,  5.177519595881950e-07, -2.408598791211583e-08,
  9.533982576170907e-10, -3.298729746178307e-11,  1.017360708275311e-12, -2.838523064372503e-14,  7.248212617201759e-16, -1.708956300318462e-17,  4.618342874921098e-03,
 -1.022437347253826e-03,  1.177572149718795e-04, -9.280055906301845e-06,  5.608391343009538e-07, -2.767055356870961e-08,  1.159352368742642e-09, -4.238238859161358e-11,
  1.378717060059309e-12, -4.051040710575789e-14,  1.087764952107062e-15, -2.693026942904524e-17,  3.866354191038730e-03, -9.106754932305122e-04,  1.115443375440115e-04,
 -9.331486850245068e-06,  5.974895314067213e-07, -3.117327829601610e-08,  1.378733452755955e-09, -5.311612173931021e-11,  1.818082094120991e-12, -5.612616579674035e-14,
  1.581229959882686e-15, -4.101820286850104e-17,  3.231005903454887e-03, -8.064757751914621e-04,  1.046839627344833e-04, -9.266609096509902e-06,  6.267404425474275e-07,
 -3.448182635943954e-08,  1.605595376248031e-09, -6.502296791030409e-11,  2.336217389203366e-12, -7.560225509271078e-14,  2.229856908652247e-15, -6.048155881569758e-17,
  2.696396450923920e-03, -7.105614467933936e-04,  9.741766665340683e-05, -9.096396323706110e-06,  6.479860483167177e-07, -3.749167275763251e-08,  1.833196244486636e-09,
 -7.785035205810736e-11,  2.929221682222360e-12, -9.914559481530943e-14,  3.054907323849072e-15, -8.645961472923915e-17,  2.248118048463857e-03, -6.232443029114565e-04,
  8.995964415382134e-05, -8.834365066433506e-06,  6.609755035960624e-07, -4.011186033890615e-08,  2.054402076880933e-09, -9.126828226171835e-11,  3.588100816425076e-12,
 -1.267461447591826e-13,  4.071255666834519e-15, -1.199866161667904e-16,  1.873316214430645e-03, -5.445097231714604e-04,  8.249209693963638e-05, -8.495476503238272e-06,
  6.657858954517164e-07, -4.226924172868492e-08,  2.262107988217936e-09, -1.048856253618548e-10,  4.298748294533921e-12, -1.581349777959044e-13,  5.284362499089302e-15,
 -1.618526441773048e-16,  1.560672625916019e-03, -4.740963004982329e-04,  7.516353761408138e-05, -8.095150004386743e-06,  6.627764796076366e-07, -4.391100018794924e-08,
  2.449635530451942e-09, -1.182712955755485e-10,  5.042355997503470e-12, -1.927605950107352e-13,  6.687597101669805e-15, -2.124546100756606e-16,  1.300334023904437e-03,
 -4.115666563891732e-04,  6.808939450953851e-05, -7.648440150342587e-06,  6.525312294478770e-07, -4.500545628802114e-08,  2.611071866960043e-09, -1.309781517022236e-10,
  5.796222427408486e-12, -2.297875314706690e-13,  8.260275125223694e-15, -2.716545171131406e-16,  1.083806131843664e-03, -3.563676937259818e-04,  6.135428165456840e-05,
 -7.169401810147956e-06,  6.357964254739863e-07, -4.554134113225621e-08,  2.741526870563469e-09, -1.425672649113865e-10,  6.534880495398280e-12, -2.681187079812281e-13,
  9.966718058850461e-15, -3.386638535095550e-16,  9.038277110166522e-04, -3.078798082211109e-04,  5.501534298670087e-05, -6.670645382141132e-06,  6.134190396082466e-07,
 -4.552583643267952e-08,  2.837296014122539e-09, -1.526304008860860e-10,  7.231434920102606e-12, -3.064402257420212e-13,  1.175653510038229e-14, -4.119719355080814e-16,
  7.542362762352349e-04, -2.654554801606688e-04,  4.910616483712000e-05, -6.163067698074008e-06,  5.862903164983580e-07, -4.498174333973690e-08,  2.895928198676533e-09,
 -1.608089869210885e-10,  7.858984212735904e-12, -3.432848162763847e-13,  1.356619168338090e-14, -4.893322218411252e-16,  6.298338260383920e-04, -2.284482424530490e-04,
  4.364085436588770e-05, -5.655733501282882e-06,  5.552974837096262e-07, -4.394415106959455e-08,  2.916207041627364e-09, -1.668084090527679e-10,  8.392004230629611e-12,
 -3.771083014281433e-13,  1.532178444113136e-14, -5.678146064782473e-16,  5.262582894618966e-04, -1.962333298148928e-04,  3.861798766784872e-05, -5.155877177779830e-06,
  5.212851366067917e-07, -4.245694454738880e-08,  2.898060815341275e-09, -1.704071042461758e-10,  8.807586828386707e-12, -4.063723979791962e-13,  1.694281173797349e-14,
 -6.439243897349406e-16,  4.398642692795435e-04, -1.682214222058823e-04,  3.402422866314612e-05, -4.668993460714295e-06,  4.850266742644033e-07, -4.056943149871247e-08,
  2.842419946992117e-09, -1.714604892779674e-10,  9.086453823823103e-12, -4.296270673001488e-13,  1.834662987756177e-14, -7.137811423307660e-16,  3.676150342597954e-04,
 -1.438668640862726e-04,  2.983750233816897e-05, -4.198987913622983e-06,  4.472052757979956e-07, -3.833329742510878e-08,  2.751041989454205e-09, -1.699002372482655e-10,
  9.213698168992831e-12, -4.455862656480378e-13,  1.945322856528498e-14, -7.733440905479306e-16,  3.069865184676587e-04, -1.226716213982577e-04,  2.602967088570757e-05,
 -3.748361958377995e-06,  4.084033137323974e-07, -3.580002327518533e-08,  2.626322782663413e-09, -1.657297396837042e-10,  9.179235962967503e-12, -4.531921940635658e-13,
  2.018994808371193e-14, -8.186658125795650e-16,  2.558832507772262e-04, -1.041860711049715e-04,  2.256870895870736e-05, -3.318412067942755e-06,  3.690987760064166e-07,
 -3.301883381921998e-08,  2.471109820685747e-09, -1.590167691885481e-10,  8.977980819960865e-12, -4.516647250230872e-13,  2.049579062930861e-14, -8.461534449477755e-16,
  2.125655887480337e-04, -8.800753353161108e-05,  1.942040642368747e-05, -2.909427749860798e-06,  3.296671625739836e-07, -3.003518988552823e-08,  2.288530303519660e-09,
 -1.498843980908141e-10,  8.609773524436584e-12, -4.405343415390963e-13,  2.032503974755293e-14, -8.528163643234958e-16,  1.755872999623509e-04, -7.377727589243358e-05,
  1.654964635237239e-05, -2.520877603990961e-06,  2.903873795127436e-07, -2.688979691203217e-08,  2.081842576077592e-09, -1.385011596881049e-10,  8.079113690162410e-12,
 -4.196584473669182e-13,  1.964998240728009e-14, -8.364811991470224e-16,  1.437423622404753e-04, -6.117654869499646e-05,  1.392131545331364e-05, -2.151576761164059e-06,
  2.514503178775135e-07, -2.361807563263065e-08,  1.854316089569537e-09, -1.250712938197704e-10,  7.394746355712058e-12, -3.892221414587754e-13,  1.846261532406029e-14,
 -7.959585538496108e-16,  1.160197939738113e-04, -4.992207182159827e-05,  1.150090653588624e-05, -1.799832284707444e-06,  2.129690291845512e-07, -2.025002662061613e-08,
  1.609141959297960e-09, -1.098257310394612e-10,  6.569156086956623e-12, -3.497254150716200e-13,  1.677529982351745e-14, -7.311503891198684e-16,  9.156534080889746e-05,
 -3.976126705574550e-05,  9.254870515540923e-06, -1.463565673876077e-06,  1.749896606349299e-07, -1.681041677565389e-08,  1.349373811763229e-09, -9.301427026703199e-11,
  5.618015850564540e-12, -3.019592169651929e-13,  1.462040026806179e-14, -6.430919920993768e-16,  6.964891537902828e-05, -3.046744232421537e-05,  7.150771849975735e-06,
 -1.140413681093044e-06,  1.375025838252383e-07, -1.331922186748734e-08,  1.077897096030277e-09, -7.489922626788898e-11,  4.559630057112965e-12, -2.469730149086122e-13,
  1.204899730690896e-14, -5.339274412918364e-16,  4.963685432512209e-05, -2.183509581952285e-05,  5.157304275391299e-06, -8.278114321470411e-07,  1.004535552175097e-07,
 -9.792285243565322e-09,  7.974253805315014e-10, -5.575075461168630e-11,  3.414406991506699e-12, -1.860366846805193e-13,  9.128820378139570e-15, -4.068225930053940e-16,
  3.096895870984765e-05, -1.367581160436719e-05,  3.244303135388506e-06, -5.230765704283175e-07,  6.375663605514388e-08, -6.242330099620423e-09,  5.105352187719880e-10,
 -3.584488249197521e-11,  2.204444381553598e-12, -1.206024837334015e-13,  5.941724762577436e-15, -2.658304549941678e-16,  1.315740785589074e-05, -5.822721971999898e-06,
  1.384680268419674e-06, -2.238040843984755e-07,  2.734626541303750e-08, -2.683961265881056e-09,  2.200370156752071e-10, -1.548530994858256e-11,  9.545444266086108e-13,
 -5.234062095243324e-14,  2.584414378659880e-15, -1.158777453928632e-16,  6.031294181518430e-02, -1.513077595725230e-04,  3.948829377653843e-07, -1.063775476415585e-09,
  2.932653163277609e-12, -8.210006532127431e-15,  2.319611752725082e-17, -6.584757024436344e-20,  1.872317303583399e-22, -5.322037193726684e-25,  1.510402209809165e-27,
 -4.276733284730173e-30,  5.950160644257773e-02, -1.991591647490891e-04,  7.784242165718050e-07, -3.120018566335895e-09,  1.230194199671494e-11, -4.736669203896864e-14,
  1.783659588695008e-16, -6.588491804144665e-19,  2.393669839669704e-21, -8.571977467743504e-24,  3.030875973386544e-26, -1.059503724558860e-28,  5.791396237261558e-02,
 -2.908382232960927e-04,  1.633240488595915e-06, -8.653562280996250e-09,  4.324921177946883e-11, -2.065459881137198e-13,  9.514319293545031e-16, -4.254007070047002e-18,
  1.854465776298563e-20, -7.908472580670784e-23,  3.307891389480257e-25, -1.359859026501547e-27,  5.561740155631146e-02, -4.187394952456160e-04,  3.113167285635426e-06,
 -2.065121854698165e-08,  1.263109435118615e-10, -7.273749911141311e-13,  3.993426160692338e-15, -2.107869365535822e-17,  1.076138518399710e-19, -5.338083265783377e-22,
  2.581794156398263e-24, -1.220908476690762e-26,  5.270665467499917e-02, -5.724968172009037e-04,  5.399562777937875e-06, -4.383754470224130e-08,  3.220313145164024e-10,
 -2.196409147352924e-12,  1.412765044190704e-14, -8.660253583354052e-17,  5.097538945430092e-19, -2.897339822884047e-21,  1.597097576499500e-23, -8.567204159617596e-26,
  4.929694789069478e-02, -7.400681492706707e-04,  8.654044344514486e-06, -8.468554582940434e-08,  7.365757637157099e-10, -5.870970173168634e-12,  4.368966477338886e-14,
 -3.073592597528592e-16,  2.062397989492042e-18, -1.328708507642728e-20,  8.260951676939145e-23, -4.976331483814312e-25,  4.551606367228325e-02, -9.089375858526312e-04,
  1.297246499306991e-05, -1.510818286798658e-07,  1.537969443937641e-09, -1.417463945878196e-11,  1.208404765257111e-13, -9.666222798521007e-16,  7.329091392202454e-18,
 -5.307175791168779e-20,  3.691574669953812e-22, -2.477787713642111e-24,  4.149609784992817e-02, -1.067280839739167e-03,  1.834948728067925e-05, -2.515436054637627e-07,
  2.967840667006275e-09, -3.135069400047343e-11,  3.036962384281986e-13, -2.741200753819370e-15,  2.331613831323237e-17, -1.884626149606122e-19,  1.456939839981173e-21,
 -1.082658222635113e-23,  3.736567212409442e-02, -1.204957803602805e-03,  2.466056721004704e-05, -3.940180683676893e-07,  5.342514667040475e-09, -6.419284054749557e-11,
  7.016659686335824e-13, -7.099862184156882e-15,  6.732986712319403e-17, -6.039214733599480e-19,  5.159671900053135e-21, -4.221996931115822e-23,  3.324323780576677e-02,
 -1.314232316841634e-03,  3.166434477439378e-05, -5.844354118999601e-07,  9.037941913579623e-09, -1.226894541639847e-10,  1.503894649101434e-12, -1.696126290967450e-14,
  1.783645941697123e-16, -1.766263021872982e-18,  1.659553617992328e-20, -1.488284318999389e-22,  2.923191943885402e-02, -1.390166861665529e-03,  3.902430153363004e-05,
 -8.252890554399353e-07,  1.445566043172851e-08, -2.203489971332416e-10,  3.012075603801590e-12, -3.766904073006115e-14,  4.371427887130370e-16, -4.757204336120472e-18,
  4.894209456380363e-20, -4.790207216590457e-22,  2.541612988273436e-02, -1.430689311603662e-03,  4.634501904449712e-05, -1.114547596303328e-06,  2.197139398668524e-08,
 -3.739550804126971e-10,  5.671525582750687e-12, -7.827937305995647e-14,  9.980617328078226e-16, -1.188658356378542e-17,  1.333705324742100e-19, -1.419251665847187e-21,
  2.185997524726296e-02, -1.436371690872119e-03,  5.321613797200959e-05, -1.445153156756781e-06,  3.187284134433513e-08, -6.025563055100632e-10,  1.009127725503101e-11,
 -1.530475504128826e-13,  2.135196835171819e-15, -2.772301186978649e-17,  3.380110113246945e-19, -3.897117548725293e-21,  1.860728687450388e-02, -1.409991243647496e-03,
  5.925647813576751e-05, -1.805245208433991e-06,  4.429720885275643e-08, -9.256329647946704e-10,  1.704236545059410e-11, -2.828597195861786e-13,  4.301626104132907e-15,
 -6.067135330924809e-17,  8.011017209566249e-19, -9.974846346611769e-21,  1.568298688642785e-02, -1.355959234268958e-03,  6.415163926147212e-05, -2.179100761256245e-06,
  5.918074675379944e-08, -1.360575050315005e-09,  2.742468724474073e-11, -4.962209236893618e-13,  8.196577047886071e-15, -1.251615373273579e-16,  1.784038458712985e-18,
 -2.391710184145162e-20,  1.309542126361508e-02, -1.279703240047579e-03,  6.768035518617451e-05, -2.548640440719381e-06,  7.623129667215739e-08, -1.919804318604210e-09,
  4.219735454499195e-11, -8.293334364981620e-13,  1.482893616641810e-14, -2.443722966185752e-16,  3.748907660506901e-18, -5.395684425092821e-20,  1.083927754754812e-02,
 -1.187077157812197e-03,  6.972735342311043e-05, -2.895249186081977e-06,  9.493086553368025e-08, -2.608018505233283e-09,  6.227481133924174e-11, -1.324831303871418e-12,
  2.556005639811775e-14, -4.531991954335728e-16,  7.461288528709860e-18, -1.149753332045240e-19,  8.898733121007214e-03, -1.083854024564883e-03,  7.028290786239758e-05,
 -3.201619490880527e-06,  1.145695334113679e-07, -3.420080159784461e-09,  8.839953873830844e-11, -2.028905946493923e-12,  4.210569179246220e-14, -8.009240433152785e-16,
  1.411216010999855e-17, -2.322178552114102e-19,  7.250540459837453e-03, -9.753346432795196e-04,  6.943122014378870e-05, -3.453346264397391e-06,  1.343060467774109e-07,
 -4.339995822794820e-09,  1.210096235958205e-10, -2.986850983343738e-12,  6.647834052998279e-14, -1.352821368890762e-15,  2.544317192469133e-17, -4.459540706369236e-19,
  5.866832642850146e-03, -8.660838844178574e-04,  6.733097393945807e-05, -3.640072442409442e-06,  1.532456850253519e-07, -5.341248211474065e-09,  1.601235760242725e-10,
 -4.237414517384242e-12,  1.008584109415683e-13, -2.189835293169578e-15,  4.384920644651296e-17, -8.166579581839150e-19,  4.717512254933562e-03, -7.597892093956466e-04,
  6.419182698872912e-05, -3.756081304812080e-06,  1.705234222694744e-07, -6.388499410697227e-09,  2.052641145900642e-10, -5.806684361846269e-12,  1.473949438094752e-13,
 -3.405556236282886e-15,  7.242416347009135e-17, -1.429870834033715e-18,  3.772159361253774e-03, -6.592238892299089e-04,  6.025035135209847e-05, -3.800331102832514e-06,
  1.853803860047963e-07, -7.440436630096107e-09,  2.554370701127387e-10, -7.702451063352107e-12,  2.079518322641102e-13, -5.100058601204153e-15,  1.149137873802328e-16,
 -2.399518150271456e-18,  3.001453068031075e-03, -5.662907994309956e-04,  5.574821297084146e-05, -3.776010320690649e-06,  1.972238326579899e-07, -8.453340563503440e-09,
  3.091723201139155e-10, -9.910025452610999e-12,  2.838299677608852e-13, -7.370698225835995e-15,  1.755459682551324e-16, -3.868210752286422e-18,  2.378143583267401e-03,
 -4.821208833818765e-04,  5.091443570435760e-05, -3.689745764597650e-06,  2.056645430799582e-07, -9.384857869820531e-09,  3.646229431703329e-10, -1.239031078182647e-11,
  3.755056110356582e-13, -1.030061158222028e-14,  2.587251231032996e-16, -6.003108884996812e-18,  1.877637852965170e-03, -4.072021950211588e-04,  4.595263483955310e-05,
 -3.550617343353623e-06,  2.105297238738867e-07, -1.019746538233779e-08,  4.197090440482769e-10, -1.508057899436190e-11,  4.824275737596942e-13, -1.394625809116503e-14,
  3.686010813191745e-16, -8.986349032460128e-18,  1.478273956377997e-03, -3.415195025661541e-04,  4.103328388867968e-05, -3.369126660205296e-06,  2.118532965399239e-07,
 -1.086121027149596e-08,  4.722859960185532e-10, -1.789795580203034e-11,  6.029094163693418e-13, -1.832574597650775e-14,  5.085497598917277e-16, -1.299982413048286e-17,
  1.161360704788877e-03, -2.846895140748933e-04,  3.629048005579481e-05, -3.156239572205424e-06,  2.098482447534397e-07, -1.135546551331645e-08,  5.203143102800209e-10,
 -2.074518005656580e-11,  7.341389709908452e-13, -2.340976449293962e-14,  6.806266066681329e-16, -1.820515010905071e-17,  9.110527500410017e-04, -2.360818988520831e-04,
  3.182231905680600e-05, -2.922585387004086e-06,  2.048671914748993e-07, -1.166961467474080e-08,  5.620100236192505e-10, -2.351786162411018e-11,  8.723091145028292e-13,
 -2.911667120340276e-14,  8.850682147456502e-16, -2.472073546104749e-17,  7.141211140131910e-04, -1.949207798918051e-04,  2.769385407720595e-05, -2.677856185349119e-06,
  1.973576294274847e-07, -1.180273872379262e-08,  5.959595130100122e-10, -2.611227997469559e-11,  1.012854849922807e-12, -3.531270108378287e-14,  1.119918487765379e-15,
 -3.259874265022066e-17,  5.596669309039628e-04, -1.603649253700583e-04,  2.394164547733802e-05, -2.430415397728461e-06,  1.878174931775672e-07, -1.176249547489478e-08,
  6.211895577955992e-10, -2.843276203390914e-11,  1.150766270891934e-12, -4.181749735369470e-14,  1.380842262390856e-15, -4.180516568136372e-17,  4.388141688295753e-04,
 -1.315673826995678e-04,  2.057904794093008e-05, -2.187098936105336e-06,  1.767554101308233e-07, -1.156344807094724e-08,  6.371907116241782e-10, -3.039783086166919e-11,
  1.280937655935817e-12, -4.841437322451204e-14,  1.661163840252835e-15, -5.220611536049312e-17,  3.444063061521520e-04, -1.077168563780388e-04,  1.760157509384248e-05,
 -1.953176026653724e-06,  1.646583769197993e-07, -1.122511374656554e-08,  6.438983016299971e-10, -3.194457589771563e-11,  1.398510906605690e-12, -5.486405537521322e-14,
  1.952135660470413e-15, -6.356270267930059e-17,  2.707229598662521e-04, -8.806390356473964e-05,  1.499188493138916e-05, -1.732429636329197e-06,  1.519680837267064e-07,
 -1.076997809215838e-08,  6.416397991144889e-10, -3.303099814057538e-11,  1.499176284191251e-12, -6.092024771381742e-14,  2.243409858040155e-15, -7.553577270158425e-17,
  2.132254625409272e-04, -7.193521475900581e-05,  1.272411365469893e-05, -1.527316146035370e-06,  1.390658547163188e-07, -1.022166766790658e-08,  6.310595940540321e-10,
 -3.363637086934993e-11,  1.579403120118865e-12, -6.634523790731416e-14,  2.523658818253325e-15, -8.770039178556239e-17,  1.683352540724039e-04, -5.873905864898384e-05,
  1.076743503368110e-05, -1.339168401743322e-06,  1.262652837677999e-07, -9.603409998284173e-09,  6.130325018063446e-10, -3.375988483209790e-11,  1.636585434839237e-12,
 -7.092393350260988e-14,  2.781274393448177e-15, -9.956868949067677e-17,  1.332454378851773e-04, -4.796456618196210e-05,  9.088832055663105e-06, -1.168413294527268e-06,
  1.138111290565407e-07, -8.936847122063430e-09,  5.885760852134591e-10, -3.341799310992815e-11,  1.669099754090185e-12, -7.447509192022972e-14,  3.005071008033251e-15,
 -1.106186334139679e-16,  1.057636310875594e-04, -3.917703464381982e-05,  7.655139438993299e-06, -1.014782823613383e-06,  1.018828367001927e-07, -8.241215466785734e-09,
  5.587696727559383e-10, -3.264093180416995e-11,  1.676282907110888e-12, -7.685900395294785e-14,  3.184924702606619e-15, -1.203257230777503e-16,  8.418299713787337e-05,
 -3.201093343236876e-05,  6.434455680869659e-06, -8.775049598178317e-07,  9.060111178917181e-08, -7.532865229277234e-09,  5.246853649738031e-10, -3.146888010033144e-11,
  1.658345034771697e-12, -7.798140540261901e-14,  3.312295548559416e-15, -1.281944798185921e-16,  6.717780499682039e-05, -2.616184051184975e-05,  5.397039319569920e-06,
 -7.554668405094829e-07,  8.003615768622150e-08, -6.825067571152955e-09,  4.873338095318494e-10, -2.994815769462592e-11,  1.616237028100117e-12, -7.779384475754312e-14,
  3.380601031148864e-15, -1.337869390212020e-16,  5.371977791346184e-05, -2.137815736453115e-05,  4.515803556192956e-06, -6.473475994956516e-07,  7.021648416838064e-08,
 -6.128046253124739e-09,  4.476253995822190e-10, -2.812776214025294e-11,  1.551492419414095e-12, -7.629107325402213e-14,  3.385429070107693e-15, -1.367460034595589e-16,
  4.301169853219067e-05, -1.745314766114386e-05,  3.766512763466469e-06, -5.517214683273175e-07,  6.113748218173206e-08, -5.449168980113749e-09,  4.063459661708888e-10,
 -2.605644431737463e-11,  1.466062049701338e-12, -7.350622512970398e-14,  3.324598082531784e-15, -1.368123409358837e-16,  3.443509436748346e-05, -1.421761673179600e-05,
  3.127768712355735e-06, -4.671338579950005e-07,  5.276923778923106e-08, -4.793239446923082e-09,  3.641450222603221e-10, -2.378042291907200e-11,  1.362156515150017e-12,
 -6.950462494686848e-14,  3.198085732465607e-15, -1.338343548125761e-16,  2.750924921096283e-05, -1.153338522072732e-05,  2.580857097469539e-06, -3.921542012220699e-07,
  4.506328821329534e-08, -4.162840827029607e-09,  3.215341150285624e-10, -2.134175860970114e-11,  1.242107316341069e-12, -6.437701871492572e-14,  3.007856785209957e-15,
 -1.277714986653941e-16,  2.185921401584421e-05, -9.287598825057059e-06,  2.109508382988479e-06, -3.254096789126063e-07,  3.795820051863963e-08, -3.558692786631370e-09,
  2.788927484494304e-10, -1.877734986412383e-11,  1.108253510013162e-12, -5.823290877958398e-14,  2.757623867294736e-15, -1.186917650316414e-16,  1.719089115213917e-05,
 -7.387844621650034e-06,  1.699612366030806e-06, -2.656038172555455e-07,  3.138397985240734e-08, -2.979995301470502e-09,  2.364795294498290e-10, -1.611847565717492e-11,
  9.628569988914452e-13, -5.119451318888794e-14,  2.452573755349544e-15, -1.067645182095843e-16,  1.327162116807254e-05, -5.758002468252218e-06,  1.338913711922174e-06,
 -2.115235294232817e-07,  2.526539661883116e-08, -2.424742588992857e-09,  1.944465587129475e-10, -1.339079272048397e-11,  8.080466865900821e-13, -4.339169900310489e-14,
  2.099087351738539e-15, -9.224996910883111e-17,  9.915005691633433e-06, -4.334738939980225e-06,  1.016706248107770e-06, -1.620376598967955e-07,  1.952437251935727e-08,
 -1.889999095226509e-09,  1.528555597328924e-10, -1.061469433795616e-11,  6.457897558289072e-13, -3.495808298879794e-14,  1.704475330751192e-15, -7.548655117076395e-17,
  6.968962222681257e-06, -3.064548062820794e-06,  7.235377152153046e-07, -1.160897223043227e-07,  1.408161183703256e-08, -1.372138365787100e-09,  1.116948944996985e-10,
 -7.805959286147876e-12,  4.778878845308316e-13, -2.602840088903686e-14,  1.276746477878031e-15, -5.687737723880868e-17,  4.306319665832843e-06, -1.901292367898453e-06,
  4.509431200729505e-07, -7.268890460637719e-08,  8.857903185923518e-09, -8.670733675528735e-10,  7.089891885067822e-11, -4.976765755444472e-12,  3.060037306879671e-13,
 -1.673758470933001e-14,  8.244407571918232e-16, -3.687769154607644e-17,  1.819772781674916e-06, -8.052434191063729e-07,  1.914689409815474e-07, -3.094305370392164e-08,
  3.780413924789381e-09, -3.709915271188147e-10,  3.041097453594203e-11, -2.139941238491413e-12,  1.318942906949111e-13, -7.231313612711119e-15,  3.570175210339204e-16,
 -1.600579348412812e-17,  5.971394916689202e-02, -1.481989718973634e-04,  3.823938444441695e-07, -1.018136994022046e-09,  2.773874183904549e-12, -7.674764760408913e-15,
  2.143346613885915e-17, -6.015140202498312e-20,  1.691160436849734e-22, -4.753866642755995e-25,  1.334377783338472e-27, -3.737329029471736e-30,  5.871719208052465e-02,
 -1.930782562962510e-04,  7.421344548375995e-07, -2.930539695997221e-09,  1.139596526879425e-11, -4.329890383357368e-14,  1.609457712273726e-16, -5.869640388360518e-19,
  2.105822944720008e-21, -7.447909593474006e-24,  2.601199694045433e-26, -8.982787650727849e-29,  5.677609986020878e-02, -2.781762126768557e-04,  1.533417256228355e-06,
 -7.993420907909246e-09,  3.933732331490240e-11, -1.850764528904870e-13,  8.402172824804535e-16, -3.703689675213286e-18,  1.592203481943424e-20, -6.697598937380392e-23,
  2.763848664619441e-25, -1.121172702289891e-27,  5.399073184646847e-02, -3.947921316204312e-04,  2.877014782458421e-06, -1.874160991050012e-08,  1.126759977422460e-10,
 -6.382431418040992e-13,  3.448681016227565e-15, -1.792359736036163e-17,  9.013311824237670e-20, -4.405267691441719e-22,  2.099891663954946e-24, -9.789269350826115e-27,
  5.049984816160098e-02, -5.313201474206632e-04,  4.903035117380171e-06, -3.901883916336117e-08,  2.813064859135848e-10, -1.884692863514116e-12,  1.191630690795128e-14,
 -7.184299393266523e-17,  4.160949812573313e-19, -2.327960205302636e-21,  1.263558532973313e-23, -6.676015953568589e-26,  4.646897543048008e-02, -6.747089198435603e-04,
  7.704831088750399e-06, -7.378551484813959e-08,  6.289815352889701e-10, -4.918653496224961e-12,  3.593996044768636e-14, -2.484186254848764e-16,  1.638618063208987e-18,
 -1.038236128019546e-20,  6.350754511474920e-23, -3.765140879932596e-25,  4.207695396019194e-02, -8.120120315129486e-04,  1.129825924027689e-05, -1.285934310000759e-07,
  1.281415899229356e-09, -1.157441964189961e-11,  9.679040831900013e-14, -7.600111603654737e-16,  5.659967283414630e-18, -4.027602152810630e-20,  2.754251445272330e-22,
 -1.818160714918193e-24,  3.750252888756633e-02, -9.317969857017554e-04,  1.559640025381904e-05, -2.087029018254825e-07,  2.407907363836190e-09, -2.490460538560497e-11,
  2.364433865570268e-13, -2.093261240503468e-15,  1.747497003789059e-17, -1.387084486588094e-19,  1.053528341198528e-21, -7.694987277604236e-24,  3.291239459422583e-02,
 -1.025224916449063e-03,  2.040565368820227e-05, -3.179571702046475e-07,  4.212133125578355e-09, -4.951369597903349e-11,  5.300294298740571e-13, -5.256703314289900e-15,
  4.889547602876084e-17, -4.304257345644668e-19,  3.610959750297822e-21, -2.902697967657446e-23,  2.845176078880545e-02, -1.086686642204750e-03,  2.544372484763072e-05,
 -4.576481527069208e-07,  6.909719075957574e-09, -9.170447131685300e-11,  1.100171831071845e-12, -1.215464818213131e-14,  1.253009032901585e-16, -1.217130864203335e-18,
  1.122405566480010e-20, -9.884051785387979e-23,  2.423805834645701e-02, -1.113965468135069e-03,  3.037495338236820e-05, -6.256586535876630e-07,  1.069368916641206e-08,
 -1.592809622934482e-10,  2.129908819381393e-12, -2.608051080322588e-14,  2.965679420359815e-16, -3.164530559778148e-18,  3.194100252662436e-20, -3.068696427556461e-22,
  2.035793124287849e-02, -1.107975039900856e-03,  3.485495761954565e-05, -8.161274505864630e-07,  1.569301975078179e-08, -2.608927428260640e-10,  3.869193392391387e-12,
 -5.226940985355006e-14,  6.527983653783436e-16, -7.620726200383698e-18,  8.386441079869332e-20, -8.757694953546373e-22,  1.686724620030006e-02, -1.072177625935101e-03,
  3.857536052681605e-05, -1.019766739616751e-06,  2.193281405017503e-08, -4.049053255352488e-10,  6.629302455801633e-12, -9.838268423350614e-14,  1.344148967731789e-15,
 -1.710288016597570e-17,  2.044778311592520e-19, -2.313056616669909e-21,  1.379354890406440e-02, -1.011817243039685e-03,  4.130040047790132e-05, -1.224804706756791e-06,
  2.930575785520938e-08, -5.979189961850628e-10,  1.076063804435321e-11, -1.747380197547577e-13,  2.601987233714559e-15, -3.595981868242614e-17,  4.655365700671553e-19,
 -5.686566748057579e-21,  1.114022979036998e-02, -9.331029849034773e-04,  4.288991279322547e-05, -1.418378674819719e-06,  3.756289385072669e-08, -8.431915378184388e-10,
  1.661261502080990e-11, -2.940780462765976e-13,  4.756172350342494e-15, -7.116047157839166e-17,  9.944604356870348e-19, -1.307841985906638e-20,  8.891629652887806e-03,
 -8.424564460378867e-04,  4.330658657279566e-05, -1.588108362290060e-06,  4.632770437886301e-08, -1.139300991064879e-09,  2.447904456951229e-11, -4.707135337541005e-13,
  8.241334624514552e-15, -1.330768991346563e-16,  2.001660383605859e-18, -2.826284534729495e-20,  7.018390183297291e-03, -7.459021690418512e-04,  4.260864034457949e-05,
 -1.723556129867238e-06,  5.513220758878709e-08, -1.479378333688870e-09,  3.453733159208403e-11, -7.189927424724188e-13,  1.358463856274858e-14, -2.360458826995966e-16,
  3.810757080681220e-18, -5.761557464411450e-20,  5.482499781520042e-03, -6.486410324587816e-04,  4.093143986023408e-05, -1.817329272779563e-06,  6.346881693764989e-08,
 -1.851140435033163e-09,  4.679326351368099e-11, -1.051216982290680e-12,  2.136948748752777e-14, -3.984370934320257e-16,  6.885598654503536e-18, -1.111907235440440e-19,
  4.241661333840531e-03, -5.548112740762241e-04,  3.846277835781054e-05, -1.865676498528470e-06,  7.084846650366380e-08, -2.237786190283878e-09,  6.104382599584713e-11,
 -1.475299371043298e-12,  3.217410501277519e-14, -6.419640476557891e-16,  1.184524524405614e-17, -2.038009908265125e-19,  3.252782610940343e-03, -4.674154145295919e-04,
  3.541658038317674e-05, -1.868545292940672e-06,  7.685471106982345e-08, -2.619631076580781e-09,  7.686783142067187e-11, -1.992592566081193e-12,  4.649011534231709e-14,
 -9.900695230860489e-16,  1.945686739379594e-17, -3.558309081947668e-19,  2.474537936322502e-03, -3.883756492405260e-04,  3.200895429450810e-05, -1.829168948091748e-06,
  8.118512364317057e-08, -2.976200147980259e-09,  9.364876001424290e-11, -2.596344032943025e-12,  6.463251485354227e-14, -1.465396510325594e-15,  3.059791579013228e-17,
 -5.934377755568343e-19,  1.869059385548563e-03, -3.186747066690786e-04,  2.843920199187907e-05, -1.753321069191242e-06,  8.367462490172688e-08, -3.288416376701471e-09,
  1.106275485208438e-10, -3.271154034667722e-12,  8.665682269683568e-14, -2.086583501817085e-15,  4.618345577059119e-17, -9.477923673534757e-19,  1.402884324967158e-03,
 -2.585414865519563e-04,  2.487698370041755e-05, -1.648403577514338e-06,  8.429934090958679e-08, -3.540525533040203e-09,  1.269769409724568e-10, -3.993628226541290e-12,
  1.123001262251100e-13, -2.864838301085692e-15,  6.706170505406426e-17, -1.453111369711737e-18,  1.047317932787349e-03, -2.076480851366260e-04,  2.145562223172123e-05,
 -1.522525293869083e-06,  8.316317519560372e-08, -3.721479749376818e-09,  1.418850106187754e-10, -4.734181077407723e-12,  1.409595849707250e-13, -3.800880785643900e-15,
  9.388899694123639e-17, -2.143437761154666e-18,  7.783727335196951e-04, -1.652942922063732e-04,  1.827067634884271e-05, -1.383693318285523e-06,  8.047177924967888e-08,
 -3.825629959682481e-09,  1.546344162638529e-10, -5.459720662958591e-12,  1.717153500005692e-13, -4.882852891369324e-15,  1.270023827243090e-16, -3.048399711677458e-18,
  5.764315905566325e-04, -1.305651134784912e-04,  1.538245527962823e-05, -1.239192430509233e-06,  7.649971559869815e-08, -3.852715905675668e-09,  1.646658187411841e-10,
 -6.136786122720780e-12,  2.033964589568614e-13, -6.085660219532446e-15,  1.663117094082696e-16, -4.188457666348408e-18,  4.257547743616511e-04, -1.024549260029588e-04,
  1.282103540197626e-05, -1.095180996098577e-06,  7.155642711496080e-08, -3.807259152674975e-09,  1.716178508742948e-10, -6.734649967951140e-12,  2.346802236047783e-13,
 -7.371962513905188e-15,  2.112319018318105e-16, -5.570355050874698e-18,  3.139225653856043e-04, -7.995785672005340e-05,  1.059247752767882e-05, -9.564939136990738e-07,
  6.595551560265544e-08, -3.697539379528410e-09,  1.753409047974836e-10, -7.227942171435491e-12,  2.642098676790043e-13, -8.694730721115278e-15,  2.606702986454839e-16,
 -7.183555226296916e-18,  2.312770921980028e-04, -6.212780776525475e-05,  8.685220426102981e-06, -8.266180317396606e-07,  5.999025379675548e-08, -3.534361229105074e-09,
  1.758865749448711e-10, -7.598478456412864e-12,  2.907128654164033e-13, -1.000100988265428e-14,  3.130745525407500e-16, -8.998346061758204e-18,  1.704034469308901e-04,
 -4.811352461354379e-05,  7.075949466286976e-06, -7.077934052217478e-07,  5.391663254150921e-08, -3.329804430681547e-09,  1.734779900485995e-10, -7.836142317879136e-12,
  3.131037363459039e-13, -1.123633310209876e-14,  3.665360514652837e-16, -1.096604015753914e-17,  1.256716531073663e-04, -3.717467307791603e-05,  5.734541911882227e-06,
 -6.011924256179970e-07,  4.794388258434528e-08, -3.096107192745398e-09,  1.684680643612069e-10, -7.938837289988132e-12,  3.305592260755645e-13, -1.234915855072573e-14,
  4.189345183289843e-16, -1.302135103464129e-17,  9.284777146871381e-05, -2.868454112400865e-05,  4.627934899694108e-06, -5.071347675436708e-07,  4.223146363939158e-08,
 -2.844777494483890e-09,  1.612929274302922e-10, -7.911659578417897e-12,  3.425595475029796e-13, -1.329475151609479e-14,  4.681033773762309e-16, -1.508666432518969e-17,
  6.877366344132560e-05, -2.212412963801884e-05,  3.722935167531839e-06, -4.253057568834049e-07,  3.689100713593086e-08, -2.585972285181956e-09,  1.524268042147700e-10,
 -7.765522869620713e-12,  3.488952561293095e-13, -1.403808017844549e-14,  5.119936323103849e-16, -1.707762786689773e-17,  5.110975793936276e-05, -1.707135730719286e-05,
  2.988094599652304e-06, -3.549563375988986e-07,  3.199156876604506e-08, -2.328139822788435e-09,  1.423429133132473e-10, -7.515493783732421e-12,  3.496442265456272e-13,
 -1.455549304472725e-14,  5.488162712778528e-16, -1.890931276305378e-17,  3.813262207074955e-05, -1.318808547754072e-05,  2.394825231697175e-06, -2.950723929749453e-07,
  2.756668389207345e-08, -2.077889747212274e-09,  1.314830249213171e-10, -7.179076927640621e-12,  3.451263954725676e-13, -1.483515053216152e-14,  5.771485787923560e-16,
 -2.050217127846043e-17,  2.857836600754766e-05, -1.020678411729992e-05,  1.917937265707421e-06, -2.445087628707963e-07,  2.362200784069931e-08, -1.840039283328029e-09,
  1.202365570924397e-10, -6.774638334043004e-12,  3.358452615028830e-13, -1.487635451010698e-14,  5.959966835021574e-16, -2.178712389001860e-17,  2.152323358598862e-05,
 -7.917956576324730e-06,  1.535768859481736e-06, -2.020886061046834e-07,  2.014266648462824e-08, -1.617779861476766e-09,  1.089287217030364e-10, -6.320092083803537e-12,
  3.224248178458220e-13, -1.468803455433651e-14,  6.048136540597602e-16, -2.270930758026525e-17,  1.629363999554552e-05, -6.158921192580655e-06,  1.230049094656230e-06,
 -1.666719664507537e-07,  1.709977116600194e-08, -1.412912869197771e-09,  9.781634612679105e-11, -5.831911386438469e-12,  3.055491228420386e-13, -1.428670173487650e-14,
  6.034782452938281e-16, -2.323025905755620e-17,  1.239907330028968e-05, -4.804190016617039e-06,  9.856042330308042e-07, -1.371989303828057e-07,  1.445582609991873e-08,
 -1.226112547376471e-09,  8.708956723504506e-11, -5.324472043616525e-12,  2.859096382070516e-13, -1.369417696356736e-14,  5.922432781864616e-16, -2.332854044115865e-17,
  9.482462606444112e-06, -3.757456907987234e-06,  7.899875402466164e-07, -1.127131011610500e-07,  1.216896021354282e-08, -1.057185153174893e-09,  7.687752882525199e-11,
 -4.809697843590513e-12,  2.641632813147515e-13, -1.293535651897641e-14,  5.716644265589873e-16, -2.299900371569919e-17,  7.283711611860846e-06, -2.945075812017392e-06,
  6.330874144424324e-07, -9.237070510556868e-08,  1.019604995200930e-08, -9.053042610834790e-10,  6.725639480968094e-11, -4.296954739796598e-12,  2.409022040063873e-13,
 -1.203621034058507e-14,  5.425201218777692e-16, -2.225101360951697e-17,  5.613045335219807e-06, -2.310845759550285e-06,  5.067483220410620e-07, -7.543984951111412e-08,
  8.494875441294164e-09, -7.692111927145321e-10,  5.825830639897098e-11, -3.793131614467411e-12,  2.166348280700022e-13, -1.102213547866632e-14,  5.057318711765196e-16,
 -2.110600282048471e-17,  4.331603740688749e-06, -1.811898452173242e-06,  4.044240115205277e-07, -6.129352165055830e-08,  7.025483849716058e-09, -6.473765259907954e-10,
  4.988027213924292e-11, -3.302846600794977e-12,  1.917766994657145e-13, -9.916720037948885e-15,  4.622920915981379e-16, -1.959472779711021e-17,  3.337345620628741e-06,
 -1.415489621824427e-06,  3.208719603527070e-07, -4.939901483595086e-08,  5.750935114482433e-09, -5.381234227326644e-10,  4.209232323661966e-11, -2.828725642500754e-12,
  1.666492321495759e-13, -8.740919462957972e-15,  4.132041292752872e-16, -1.775454401729885e-17,  2.554817806597736e-06, -1.096514411957532e-06,  2.518911000581078e-07,
 -3.930567686785229e-08,  4.637588566916405e-09, -4.397164207822949e-10,  3.484455813579394e-11, -2.371710960334063e-12,  1.414843036671699e-13, -7.512609981046179e-15,
  3.594368539897754e-16, -1.562694547443824e-17,  1.927720990242156e-06, -8.355917835678537e-07,  1.941006511099170e-07, -3.063223316290065e-08,  3.655063702396234e-09,
 -3.504207894685077e-10,  2.807292648861626e-11, -1.931368941270709e-12,  1.164328257407919e-13, -6.246463039440436e-15,  3.018943581575134e-16, -1.325553084794064e-17,
  1.413486566236027e-06, -6.175885627380544e-07,  1.447556031539979e-07, -2.305444594071196e-08,  2.775981105509773e-09, -2.685380164698180e-10,  2.170376710701209e-11,
 -1.506178262941878e-12,  9.157574699456717e-14, -4.954077711055369e-15,  2.413999776238796e-16, -1.068448272887616e-17,  9.792900545160519e-07, -4.304780010451494e-07,
  1.015934806745933e-07, -1.629353626993953e-08,  1.975566757237281e-09, -1.924231092233705e-10,  1.565724648448163e-11, -1.093790367384872e-12,  6.693644934202649e-14,
 -3.644316523885284e-15,  1.786933221142494e-16, -7.957594650192088e-18,  5.990949374863282e-07, -2.644547915136525e-07,  6.270836546005526e-08, -1.010580580060883e-08,
  1.231212604865815e-09, -1.204920045179965e-10,  9.850165489362453e-12, -6.912801059485840e-13,  4.249501600131718e-14, -2.323860077632813e-15,  1.144416332219922e-16,
 -5.117967054869517e-18,  2.517551420461936e-07, -1.113887883992820e-07,  2.648249993233107e-08, -4.279260941913973e-09,  5.227448319807887e-10, -5.129315900810862e-11,
  4.204083201749913e-12, -2.957936549255571e-13,  1.822886449574850e-14, -9.993049178353221e-16,  4.933080115963212e-17, -2.211334390029523e-18,  5.912719525241492e-02,
 -1.451879487106022e-04,  3.704375160891708e-07, -9.749555820396883e-10,  2.625389591842973e-12, -7.179976373310263e-15,  1.982248970073487e-17, -5.500352298803557e-20,
  1.529245492611321e-22, -4.251581496456556e-25,  1.180445518079778e-27, -3.270678033923177e-30,  5.795653477656425e-02, -1.872788113384029e-04,  7.080340787647399e-07,
 -2.754927657029245e-09,  1.056732127062354e-11, -3.962605133988705e-14,  1.454152668983164e-16, -5.236743669599361e-19,  1.855512418295084e-21, -6.482326566915249e-24,
  2.236556425818971e-26, -7.630919159939787e-29,  5.568733692900920e-02, -2.662821334474955e-04,  1.441153893082919e-06, -7.392574575100045e-09,  3.582933480395172e-11,
 -1.661002576900315e-13,  7.432992405101037e-16, -3.230721876127844e-18,  1.369856014754621e-20, -5.684709811268715e-23,  2.314750868432944e-25, -9.267038519922727e-28,
  5.245621321849578e-02, -3.726459045013927e-04,  2.662525233559271e-06, -1.703658072034933e-08,  1.006997919015412e-10, -5.611852990521864e-13,  2.984926674036182e-15,
 -1.527767599281548e-17,  7.568776098275687e-20, -3.645492512229566e-22,  1.712926909283032e-24, -7.873211046996354e-27,  4.845015506994364e-02, -4.938950224644848e-04,
  4.460619101544571e-06, -3.480460521708917e-08,  2.463170620265328e-10, -1.621410231057348e-12,  1.007917826863963e-14, -5.977678016534726e-17,  3.407201249723602e-19,
 -1.876727331166344e-21,  1.003187981547767e-23, -5.221434989554626e-26,  4.388804139105850e-02, -6.164480760617953e-04,  6.876686422484481e-06, -6.446419173480019e-08,
  5.386998607390973e-10, -4.133966460786081e-12,  2.966546689272285e-14, -2.015034674885532e-16,  1.306849245586132e-18, -8.144861872467656e-21,  4.902498939083271e-23,
 -2.861035689391896e-25,  3.900037474065847e-02, -7.274667047467560e-04,  9.870904801314523e-06, -1.098233525948584e-07,  1.071533852225453e-09, -9.487614573203386e-12,
  7.784208647726875e-14, -6.001120851533069e-16,  4.390458988650670e-18, -3.070728204054738e-20,  2.064826926638223e-22, -1.340794488282604e-24,  3.400989906383708e-02,
 -8.164245185232288e-04,  1.330763439952854e-05, -1.738716460445870e-07,  1.962122153652672e-09, -1.987444919948439e-11,  1.849645325834101e-13, -1.606444086177503e-15,
  1.316491155724669e-17, -1.026362768806975e-19,  7.660313434636795e-22, -5.500380241289920e-24,  2.911534424437983e-02, -8.761669374537004e-04,  1.696396276951653e-05,
 -2.578411100912693e-07,  3.338000507715504e-09, -3.839581549170186e-11,  4.026026049921800e-13, -3.914417077983585e-15,  3.571897527875471e-17, -3.086464576716031e-19,
  2.542970711809023e-21, -2.008509633517969e-23,  2.447981319228250e-02, -9.033551243885795e-04,  2.055910460440397e-05, -3.604387891792466e-07,  5.314284604827071e-09,
 -6.896880811861182e-11,  8.099611357942996e-13, -8.767286123140602e-15,  8.861617465493931e-17, -8.445083741792700e-19,  7.644723248916128e-21, -6.611552721860600e-23,
  2.022445416342475e-02, -8.983139942125890e-04,  2.379688026099890e-05, -4.774974391716541e-07,  7.965223129385488e-09, -1.159508740895312e-10,  1.517006530761975e-12,
 -1.819072483878446e-14,  2.027195907691593e-16, -2.121304127385690e-18,  2.100939822023450e-20, -1.981586533032887e-22,  1.642722648212697e-02, -8.644070809641861e-04,
  2.641084831994984e-05, -6.021947146829172e-07,  1.129642673261320e-08, -1.834661916305665e-10,  2.661073251354604e-12, -3.519055274118066e-14,  4.305654209978977e-16,
 -4.927561762370961e-18,  5.319216728702620e-20, -5.451624532902593e-22,  1.312591543625673e-02, -8.071214309719695e-04,  2.820211098116526e-05, -7.258378830643073e-07,
  1.522550420356941e-08, -2.745152457748747e-10,  4.394402308286016e-12, -6.382243364722254e-14,  8.540237984196245e-16, -1.065025987989192e-17,  1.248737088056257e-19,
 -1.386065878369622e-21,  1.032416189091239e-02, -7.330587926839142e-04,  2.906275429896869e-05, -8.390561265276140e-07,  1.957760693630947e-08, -3.900457122645827e-10,
  6.862089476415313e-12, -1.090321172207891e-13,  1.589894336234408e-15, -2.153182089699581e-17,  2.733298372901064e-19, -3.275649440490675e-21,  7.999155795315670e-03,
 -6.490024011571931e-04,  2.898210596322991e-05, -9.331381994319120e-07,  2.409887702016215e-08, -5.282188121804340e-10,  1.017290848347919e-11, -1.761930611051822e-13,
  2.790289690740046e-15, -4.090732208188075e-17,  5.605213055261336e-19, -7.231849958685101e-21,  6.109756190300705e-03, -5.611764221601584e-04,  2.803713952104547e-05,
 -1.001229328973867e-06,  2.848614026445970e-08, -6.840920334013915e-10,  1.436847687581206e-11, -2.703370437859390e-13,  4.634701189145500e-15, -7.333404409257655e-17,
  1.081543223374988e-18, -1.498194566993559e-20,  4.604066624809977e-03, -4.747545482306536e-04,  2.637137941473074e-05, -1.039156833710664e-06,  3.242694467475939e-08,
 -8.498530116205650e-10,  1.939807604143857e-11, -3.951683979877787e-13,  7.311897698444560e-15, -1.245094902372965e-16,  1.971110447337909e-18, -2.924024598901153e-20,
  3.425828892812955e-03, -3.936196772448068e-04,  2.416806341096488e-05, -1.045762420657410e-06,  3.564157070980740e-08, -1.015605135203686e-09,  2.510622898252048e-11,
 -5.520437743870557e-13,  1.099224519355875e-14, -2.008894710440217e-16,  3.404944258446924e-18, -5.395768723077895e-20,  2.519326114458463e-03, -3.203370960801596e-04,
  2.162314862122376e-05, -1.022741915682557e-06,  3.791857815276898e-08, -1.170566300176626e-09,  3.123769618675363e-11, -7.391518026064893e-13,  1.579407543795146e-14,
 -3.089720619778312e-16,  5.592855894214489e-18, -9.445367490002131e-20,  1.832757842062673e-03, -2.562822924572408e-04,  1.892244734277509e-05, -9.740947362540145e-07,
  3.913758770830248e-08, -1.304442399615857e-09,  3.746052377078903e-11, -9.511153530589711e-13,  2.175039663485376e-14, -4.542989622783103e-16,  8.761367145336736e-18,
 -1.573267225939858e-19,  1.320240397500076e-03, -2.018597792491627e-04,  1.622535271957031e-05, -9.053438301991143e-07,  3.927644028729023e-08, -1.408704980454681e-09,
  4.340341468060293e-11, -1.179159715926872e-12,  2.878349800548514e-14, -6.403203379864494e-16,  1.312589521461874e-17, -2.500564377918237e-19,  9.426925980921434e-04,
 -1.567566167650061e-04,  1.365581642260692e-05, -8.226972572247110e-07,  3.840349493351600e-08, -1.477541797165202e-09,  4.870034103065875e-11, -1.411863861837497e-12,
  3.669421185008067e-14, -8.673411041369462e-16,  1.885541702942640e-17, -3.802613097984785e-19,  6.679030569470221e-04, -1.201882456119373e-04,  1.129984784158480e-05,
 -7.322943356863703e-07,  3.665864273627519e-08, -1.508340636439311e-09,  5.303391885237887e-11, -1.636376871809128e-12,  4.516980606351981e-14, -1.131787361173357e-15,
  2.603528229439950e-17, -5.546578962508708e-19,  4.700603548571144e-04, -9.110998495090247e-05,  9.207977883775860e-06, -6.396290846934092e-07,  3.422808671899806e-08,
 -1.501678761735031e-09,  5.616986773853026e-11, -1.839877846418581e-12,  5.381043754745912e-14, -1.425988023645309e-15,  3.463551290187489e-17, -7.778573194018610e-19,
  3.289825335479651e-04, -6.838170852824419e-05,  7.400849837149233e-06, -5.491889764663174e-07,  3.131801637599162e-08, -1.460890369815814e-09,  5.797741825845349e-11,
 -2.011013163618944e-12,  6.216998222699304e-14, -1.738566715776436e-15,  4.449180994130648e-17, -1.051206540135377e-18,  2.292253241035848e-04, -5.088397198940114e-05,
  5.876232059520485e-06, -4.643009595309212e-07,  2.813131788065006e-08, -1.391350128039876e-09,  5.843390570003412e-11, -2.141067154912413e-12,  6.980404210713171e-14,
 -2.055410035316465e-15,  5.530443901560687e-17, -1.371908832040771e-18,  1.591919971361661e-04, -3.759075561635534e-05,  4.616119982225059e-06, -3.871462291451300e-07,
  2.484991414301183e-08, -1.299634010566663e-09,  5.761501540028433e-11, -2.224697814827686e-12,  7.631677347788899e-14, -2.361056764198614e-15,  6.665666452434794e-17,
 -1.732626674100256e-18,  1.103191870175698e-04, -2.760742616759029e-05,  3.593050463046297e-06, -3.188913514557630e-07,  2.162371790471872e-08, -1.192704136325984e-09,
  5.567447369090482e-11, -2.260171528653299e-12,  8.139901951505967e-14, -2.640271200602783e-15,  7.805040682205943e-17, -2.121685503465760e-18,  7.637567453596682e-05,
 -2.018337004391001e-05,  2.775176524197415e-06, -2.598831109686676e-07,  1.856586261103322e-08, -1.077225103701807e-09,  5.281806160224892e-11, -2.249130756642773e-12,
  8.485261658199254e-14, -2.879540877780818e-15,  8.895338474880772e-17, -2.523880009533278e-18,  5.288508558707742e-05, -1.470795555479202e-05,  2.129982640202525e-06,
 -2.098630399246261e-07,  1.575302356446766e-08, -9.590706360162014e-10,  4.927671756356617e-11, -2.196003371268460e-12,  8.659887370737131e-14, -3.068274363608129e-15,
  9.885002760724801e-17, -2.921766970400695e-18,  3.666723432981409e-05, -1.069686367939012e-05,  1.626740782323948e-06, -1.681701774948002e-07,  1.322926743815686e-08,
 -8.430340098618807e-10,  4.528251934291495e-11, -2.107200588093098e-12,  8.667224477057501e-14, -3.199552585099968e-15,  1.072882634370697e-16, -3.297239999117302e-18,
  2.548415654308079e-05, -7.773980731604336e-06,  1.237924970235276e-06, -1.339134387064527e-07,  1.101187706149663e-08, -7.327217049153318e-10,  4.104993377250257e-11,
 -1.990252528272456e-12,  8.520247089594039e-14, -3.270382710717546e-15,  1.139157520840317e-16, -3.633141573000076e-18,  1.777345597829949e-05, -5.652339529645402e-06,
  9.398411224705533e-07, -1.061057401045838e-07,  9.097851472008869e-09, -6.305898362908588e-10,  3.676329961486287e-11, -1.853005190862051e-12,  8.238964808366101e-14,
 -3.281492678477502e-15,  1.185016686321748e-16, -3.914680874301820e-18,  1.245146619648950e-05, -4.116206207420892e-06,  7.127168798882307e-07, -8.375975631095995e-08,
  7.470143421686845e-09, -5.380760906922019e-10,  3.257034541789705e-11, -1.702962522103661e-12,  7.847678652792415e-14, -3.236769340091110e-15,  1.209430214986691e-16,
 -4.130482541514904e-18,  8.770422890702547e-06, -3.005384685337928e-06,  5.404567851143878e-07, -6.594985805376873e-08,  6.103064336514483e-09, -4.557827239878885e-10,
  2.858077355360394e-11, -1.546814375226218e-12,  7.372372545439248e-14, -3.142476009925928e-15,  1.212570391816474e-16, -4.273172551176786e-18,  6.216320035455615e-06,
 -2.202120124369523e-06,  4.102194533297191e-07, -5.184694389106155e-08,  4.966597087817629e-09, -3.836746839055438e-10,  2.486857080078116e-11, -1.390154288662185e-12,
  6.838510888285755e-14, -3.006387278186245e-15,  1.195629330690598e-16, -4.339491936555423e-18,  4.436747249577819e-06, -1.620561423937915e-06,  3.119263330118287e-07,
 -4.073326155491880e-08,  4.029583094339843e-09, -3.212675545506325e-10,  2.147666034348587e-11, -1.237364859893892e-12,  6.269386001990275e-14, -2.836957897451319e-15,
  1.160571738877663e-16, -4.329999362489467e-18,  3.190423476377020e-06, -1.198518373439661e-06,  2.377720711490408e-07, -3.200362950978735e-08,  3.261891517777513e-09,
 -2.677902444218244e-10,  1.842268087196130e-11, -1.091634020558728e-12,  5.685047426721350e-14, -2.642608646888183e-15,  1.109863849824546e-16, -4.248469309635365e-18,
  2.312196103962855e-06, -8.911562891664478e-07,  1.817762887848838e-07, -2.515827966428186e-08,  2.635748716028985e-09, -2.223157187032541e-10,  1.570495812138772e-11,
 -9.550611216478857e-13,  5.101762737648052e-14, -2.431175062778202e-15,  1.046212924898133e-16, -4.101111161370705e-18,  1.688926843868709e-06, -6.662584371945983e-07,
  1.393953650826945e-07, -1.979123586373521e-08,  2.126425348352721e-09, -1.838590831896020e-10,  1.330803773245997e-11, -8.288145455799365e-13,  4.531910517873459e-14,
 -2.209532050490091e-15,  9.723417300163912e-17, -3.895729466623394e-18,  1.242962672463043e-06, -5.007173511193943e-07,  1.071991287880905e-07, -1.557694715059436e-08,
  1.712465778856941e-09, -1.514460512178173e-10,  1.120742063396198e-11, -7.133095066783309e-13,  3.984186884831233e-14, -1.983382737887110e-15,  8.908117094952496e-17,
 -3.640924320914343e-18,  9.208474159783830e-07, -3.779659647703907e-07,  8.260933800657356e-08, -1.225691515908331e-08,  1.375615279772232e-09, -1.241566858593275e-10,
  9.373355784473019e-12, -6.083831919446509e-13,  3.464009964982794e-14, -1.757184684935977e-15,  8.038991538999049e-17, -3.345401361393225e-18,  6.856300803305163e-07,
 -2.861136084153073e-07,  6.369277588949547e-08, -9.627316297790074e-09,  1.100565995488498e-09, -1.011498354114999e-10,  7.773693483938373e-12, -5.134526082066280e-13,
  2.974023473562851e-14, -1.534179857700747e-15,  7.135215670501982e-17, -3.017430448687191e-18,  5.116288347895850e-07, -2.166024415177232e-07,  4.900029475231022e-08,
 -7.528101046922727e-09,  8.746094533425464e-10, -8.167336837889467e-11,  6.375891960682859e-12, -4.276473990007214e-13,  2.514623603990796e-14, -1.316494618852353e-15,
  6.212069847320505e-17, -2.664465718052626e-18,  3.808648345906829e-07, -1.632432667707273e-07,  3.744315582858714e-08, -5.833714101515855e-09,  6.872550481373386e-10,
 -6.506456343295233e-11,  5.148313120886621e-12, -3.499150690212858e-13,  2.084457244586229e-14, -1.105280079936088e-15,  5.280969454150598e-17, -2.292919979696468e-18,
  2.806278963715438e-07, -1.215249346231607e-07,  2.819881277697627e-08, -4.445375371701596e-09,  5.298515770394391e-10, -5.074410287124917e-11,  4.060954192225387e-12,
 -2.790995354431455e-13,  1.680860738467742e-14, -9.008694380978107e-16,  4.349736339531248e-17, -1.908074107332949e-18,  2.018070991959945e-07, -8.811913891261799e-08,
  2.063941170478684e-08, -3.284752743803960e-09,  3.952324388156592e-10, -3.820623554179833e-11,  3.085753344157617e-12, -2.139960076349726e-13,  1.300225558253900e-14,
 -7.029358894526730e-16,  3.423028369643780e-17, -1.514096531594403e-18,  1.377365317899479e-07, -6.052343153601496e-08,  1.427746995642197e-08, -2.288812921546937e-09,
  2.773940336712198e-10, -2.700694428347952e-11,  2.196591738610077e-12, -1.533864340566730e-13,  9.382912864408602e-15, -5.106420011711559e-16,  2.502865182169195e-17,
 -1.114149211753964e-18,  8.338773443447723e-08, -3.680170879029322e-08,  8.724482485007342e-09, -1.405661258184209e-09,  1.712137094925611e-10, -1.675176176326525e-11,
  1.369127529268874e-12, -9.606253375814867e-14,  5.903901806017920e-15, -3.227853543969131e-16,  1.589249850455926e-17, -7.105779763416710e-19,  3.483829286338285e-08,
 -1.541245661876034e-08,  3.663821521068454e-09, -5.919535388782828e-10,  7.230227598059060e-11, -7.093577546531022e-12,  5.813280755343952e-13, -4.089625365515331e-14,
  2.519994325383555e-15, -1.381286803852318e-16,  6.817898403772599e-18, -3.055864437516942e-19,  5.855229735517505e-02, -1.422705430920456e-04,  3.589854300441102e-07,
 -9.340728101262128e-10,  2.486425512919693e-12, -6.722178652526221e-15,  1.834866367735926e-17, -5.034598949699044e-20,  1.384352238445927e-22, -3.806953153248464e-25,
  1.045640050019084e-27, -2.866347485144613e-30,  5.721854268193197e-02, -1.817439599483467e-04,  6.759638574254357e-07, -2.592005930775499e-09,  9.808545997183349e-12,
 -3.630553960244379e-14,  1.315497658411490e-16, -4.678654834742656e-19,  1.637474693389615e-21, -5.651369375182909e-24,  1.926498455992631e-26, -6.495020760181397e-29,
  5.464471845519100e-02, -2.550982466276904e-04,  1.355776045904967e-06, -6.844941886161221e-09,  3.267864239152002e-11, -1.492988934668909e-13,  6.586806196072614e-16,
 -2.823401663832194e-18,  1.180935111801254e-20, -4.835450607507730e-23,  1.943107469027668e-25, -7.678451036538351e-28,  5.100697279919506e-02, -3.521368965800653e-04,
  2.467395285091126e-06, -1.551142202370822e-08,  9.015918321702593e-11, -4.944183408910140e-13,  2.589177419920531e-15, -1.305307297379812e-17,  6.371816476289939e-20,
 -3.024871966329774e-22,  1.401251431304843e-24, -6.351193272896604e-27,  4.654339117638377e-02, -4.598160743523912e-04,  4.065581217344895e-06, -3.111036229538676e-08,
  2.161783986560687e-10, -1.398422672622105e-12,  8.548441379435360e-15, -4.988156410260982e-17,  2.798596169429525e-19, -1.517884524947258e-21,  7.991962909950926e-24,
 -4.098421005136218e-26,  4.152757567265179e-02, -5.643883810164774e-04,  6.152223153207694e-06, -5.646958146403024e-08,  4.627065538028710e-10, -3.485232838266203e-12,
  2.456732045609823e-14, -1.640205749377395e-16,  1.046095550093138e-18, -6.414264420149104e-21,  3.799792180468734e-23, -2.183169916252183e-25,  3.624048907699146e-02,
 -6.534933189964242e-04,  8.649943849349575e-06, -9.410076319512291e-08,  8.991805204072927e-10, -7.806133445869293e-12,  6.285041579936077e-14, -4.758193806805087e-16,
  3.420465068647693e-18, -2.351764756740723e-20,  1.555237926151683e-22, -9.935688617855618e-25,  3.094462440688165e-02, -7.178042998489394e-04,  1.139716271096432e-05,
 -1.454308883351393e-07,  1.605613514349368e-09, -1.593067512581320e-11,  1.453660820474193e-13, -1.238814636064878e-15,  9.967798554241135e-18, -7.634075775262046e-20,
  5.599885651898618e-22, -3.953499571170664e-24,  2.586371290320481e-02, -7.519787992440647e-04,  1.416658035074467e-05, -2.100865050829985e-07,  2.658457298981578e-09,
 -2.992904276756521e-11,  3.074611858860696e-13, -2.931166042186487e-15,  2.624386711479221e-17, -2.226375217033285e-19,  1.801799569370542e-21, -1.398498459960558e-23,
  2.116985565735014e-02, -7.548362267712952e-04,  1.670169739680267e-05, -2.854670951371500e-07,  4.110959016032162e-09, -5.218122742097822e-11,  5.999966439696330e-13,
 -6.364245666030323e-15,  6.308198770081074e-17, -5.898963371090890e-19,  5.242607806461538e-21, -4.453602364579139e-23,  1.697849994695509e-02, -7.288564909408977e-04,
  1.876100937712293e-05, -3.667886699291541e-07,  5.972539475074003e-09, -8.498692714542443e-11,  1.088068646631483e-12, -1.277902908771619e-14,  1.395885629423123e-16,
 -1.432666391834083e-18,  1.392484773454313e-20, -1.289569306620856e-22,  1.335040159302415e-02, -6.792108929949726e-04,  2.015826914360821e-05, -4.476454049853749e-07,
  8.193349112693736e-09, -1.300178474559387e-10,  1.844639684208364e-12, -2.388285595865321e-14,  2.863136213805321e-16, -3.212694056222997e-18,  3.402325045075115e-20,
 -3.422744718839891e-22,  1.029883974431371e-02, -6.125862638051239e-04,  2.078955101850885e-05, -5.209782053235178e-07,  1.065967984250196e-08, -1.877283226905193e-10,
  2.938576068991178e-12, -4.177214830241724e-14,  5.475242525485743e-16, -6.692868681181444e-18,  7.696716048256712e-20, -8.383739975343746e-22,  7.799966086764328e-03,
 -5.360458400963653e-04,  2.064248056755606e-05, -5.802166020051383e-07,  1.320323576679925e-08, -2.568885322161464e-10,  4.418486428537795e-12, -6.870095910400886e-14,
  9.811025711053026e-16, -1.302170023594564e-17,  1.621000987020471e-19, -1.906099423218242e-21,  5.804236024320317e-03, -4.561056467387682e-04,  1.978810437917017e-05,
 -6.203175584516963e-07,  1.562328108741360e-08, -3.344003602448452e-10,  6.295744374597905e-12, -1.066940288940381e-13,  1.654612978875670e-15, -2.377106019996092e-17,
  3.193825014123018e-19, -4.042835027646705e-21,  4.247258163680216e-03, -3.781198266337330e-04,  1.835987985819632e-05, -6.384699534446848e-07,  1.771686393637535e-08,
 -4.154927407263697e-10,  8.531303327714327e-12, -1.570579836854399e-13,  2.636753325538055e-15, -4.088371732946940e-17,  5.912309942920415e-19, -8.035222614603159e-21,
  3.058949768824452e-03, -3.059872625432816e-04,  1.652627872464273e-05, -6.343415842906324e-07,  1.931004795908236e-08, -4.942900693898059e-10,  1.103069693968322e-11,
 -2.198962316559072e-13,  3.984694424415773e-15, -6.649626928098204e-17,  1.032299659831591e-18, -1.502531556852489e-20,  2.170451603716874e-03, -2.421317375830361e-04,
  1.446344645111835e-05, -6.098731202788532e-07,  2.028307967270926e-08, -5.646405652185378e-10,  1.364983156007181e-11, -2.937593241180366e-13,  5.729375928433776e-15,
 -1.026304772610040e-16,  1.706059712508144e-18, -2.653069840952863e-20,  1.518729894499419e-03, -1.876754579297486e-04,  1.233279063915784e-05, -5.687284628038981e-07,
  2.058448481128821e-08, -6.210193643134037e-10,  1.621134188383441e-11, -3.755475405017765e-13,  7.862085518664713e-15, -1.507869333283496e-16,  2.677570612813383e-18,
 -4.438455903978309e-20,  1.049122457293017e-03, -1.427190371300128e-04,  1.026610704262774e-05, -5.155674149833472e-07,  2.023231595771505e-08, -6.593069082211452e-10,
  1.852837211294135e-11, -4.607263128387041e-13,  1.032602924389832e-14, -2.115166674812759e-16,  4.002827899894717e-18, -7.057130957385428e-20,  7.162632051867818e-04,
 -1.066527634783635e-04,  8.358660421301282e-06, -4.553096032608953e-07,  1.930400672528726e-08, -6.772871148826114e-10,  2.043066728898439e-11, -5.438347450525609e-13,
  1.301581022010805e-14, -2.840723559440816e-16,  5.716267555331164e-18, -1.069562989397051e-19,  4.838687161313973e-04, -7.844525566662811e-05,  6.669024506081465e-06,
 -3.925206920145490e-07,  1.791857895689030e-08, -6.747917459905675e-10,  2.178743096704586e-11, -6.191899010815793e-13,  1.578592341941403e-14, -3.662383218715237e-16,
  7.818989703953580e-18, -1.549399156282873e-19,  3.238316177384486e-04, -5.687870390328657e-05,  5.223638758470565e-06, -3.309939985270253e-07,  1.621585120966341e-08,
 -6.535073427514177e-10,  2.252254416807949e-11, -6.816404596056521e-13,  1.846710672170851e-14, -4.544044535921129e-16,  1.027062234345637e-17, -2.150972088731968e-19,
  2.149786340356257e-04, -4.071959678573413e-05,  4.023888488425375e-06, -2.735429853266965e-07,  1.433688936988340e-08, -6.165318443010844e-10,  2.261992781578706e-11,
 -7.272170185261132e-13,  2.088740479655168e-14, -5.438924544853299e-16,  1.298725189881309e-17, -2.868824604194357e-19,  1.417491880495075e-04, -2.882771854320928e-05,
  3.053843695473173e-06, -2.219766303852368e-07,  1.240866525814028e-08, -5.678038465367443e-10,  2.211928073056747e-11, -7.535611290665109e-13,  2.289372496058830e-14,
 -6.294812072431250e-16,  1.584657943638370e-17, -3.684752988567091e-19,  9.295551375632791e-05, -2.021403488915842e-05,  2.287352111229671e-06, -1.772058884391933e-07,
  1.053430742045978e-08, -5.115267834196060e-10,  2.110440844480912e-11, -7.600760654000059e-13,  2.436976493722184e-14, -7.060308848065141e-16,  1.869978667361129e-17,
 -4.568193622198470e-19,  6.070881108483038e-05, -1.406096361835754e-05,  1.693768261150642e-06, -1.394239698166855e-07,  8.788913828275891e-09, -4.516824270255975e-10,
  1.968743616105975e-11, -7.478084458875342e-13,  2.524732901386996e-14, -7.690863741636812e-16,  2.138802975800714e-17, -5.478627447330145e-19,  3.954145790078113e-05,
 -9.718056418434053e-06,  1.242084635179645e-06, -1.083106046620073e-07,  7.219925973427352e-09, -3.916872802976914e-10,  1.799229845864247e-11, -7.191224236323254e-13,
  2.550977111108970e-14, -8.153529139761887e-16,  2.376048503043541e-17, -6.369638774234688e-19,  2.572092764303901e-05, -6.683849458597756e-06,  9.035605619620505e-07,
 -8.322442709877974e-08,  5.850607919487338e-09, -3.342051500463874e-10,  1.614023837078948e-11, -6.772564357526905e-13,  2.518805662154779e-14, -8.429736685445141e-16,
  2.569069738773543e-17, -7.193905341431053e-19,  1.673263933756167e-05, -4.581762632899328e-06,  6.531217936243320e-07, -6.336272115630090e-08,  4.685151267144718e-09,
 -2.810984872645687e-10,  1.423899287703215e-11, -6.258550051526883e-13,  2.435126266294848e-14, -8.515870001996570e-16,  2.708859638835617e-17, -7.908229628849668e-19,
  1.090171022179156e-05, -3.135195223377868e-06,  4.698620434200302e-07, -4.788056844280755e-08,  3.714184180803156e-09, -2.334835879417942e-10,  1.237624897017246e-11,
 -5.685507322819390e-13,  2.309400067709505e-14, -8.421862878352615e-16,  2.790668523045210e-17, -8.477775857494116e-19,  7.123245006191900e-06, -2.144752719362527e-06,
  3.369588869842331e-07, -3.597042009410435e-08,  2.919841291374620e-09, -1.918496257276536e-10,  1.061707829928239e-11, -5.086438246390461e-13,  2.152324476525951e-14,
 -8.168368051395783e-16,  2.814020298203041e-17, -8.878912939771739e-19,  4.674129972239630e-06, -1.468948826083814e-06,  2.412584489368493e-07, -2.690822310729856e-08,
  2.279929475076917e-09, -1.562053338750249e-10,  9.004515442304608e-12, -4.488975044308592e-13,  1.974655539362944e-14, -7.783179344491069e-16,  2.782216873126465e-17,
 -9.100395742171294e-19,  3.084099142681973e-06, -1.008704168855481e-06,  1.727138375676092e-07, -2.007421795251841e-08,  1.771030607872069e-09, -1.262258500656864e-10,
  7.562232795774444e-12, -3.914439809546855e-13,  1.786294704201162e-14, -7.297561056405334e-16,  2.701491896403524e-17, -9.142949462594553e-19,  2.048778228473312e-06,
 -6.953858623423925e-07,  1.237980514411171e-07, -1.495642023788658e-08,  1.370590098651380e-09, -1.013822412023802e-10,  6.298307720000115e-12, -3.377804858777422e-13,
  1.595689051764718e-14, -6.742993543063373e-16,  2.579998352481799e-17, -9.017578459365934e-19,  1.371808869946320e-06, -4.818653691281977e-07,  8.896079147152681e-08,
 -1.114356133653979e-08,  1.058154203388854e-09, -8.104516280151174e-11,  5.209272214129502e-12, -2.888282555338782e-13,  1.409532605137494e-14, -6.148646276850961e-16,
  2.426797933687907e-17, -8.743061834552825e-19,  9.267492394431234e-07, -3.359996158789582e-07,  6.416197624745211e-08, -8.312611880619397e-09,  8.159607474202806e-10,
 -6.456081625647999e-11,  4.283887660219716e-12, -2.450275085700149e-13,  1.232716563775057e-14, -5.539695121400678e-16,  2.250977819955685e-17, -8.343121721070572e-19,
  6.322174416276021e-07, -2.359749009414427e-07,  4.649116238497528e-08, -6.214401203437599e-09,  6.290820841205117e-10, -5.130162056755655e-11,  3.506329185204115e-12,
 -2.064458725890571e-13,  1.068458311358182e-14, -4.936445976280322e-16,  2.060968426184933e-17, -7.843682568727118e-19,  4.357896325776474e-07, -1.670360938015596e-07,
  3.386856432735301e-08, -4.659503631754217e-09,  4.852881327787767e-10, -4.069615231161955e-11,  2.858658287820599e-12, -1.728839575832330e-13,  9.185383281890711e-15,
 -4.354128000977651e-16,  1.864086809275472e-17, -7.270519678080292e-19,  3.036253742451285e-07, -1.192196032242674e-07,  2.481687561590058e-08, -3.505560919418796e-09,
  3.747574653261381e-10, -3.224350502760895e-11,  2.322596027592283e-12, -1.439680633534871e-13,  7.835844401611960e-15, -3.803174930069263e-16,  1.666292756641446e-17,
 -6.647461034742070e-19,  2.138082946079127e-07, -8.579877424130776e-08,  1.829101764834379e-08, -2.646529835072977e-09,  2.897257494305292e-10, -2.551686486232226e-11,
  1.880686280053486e-12, -1.192252821072056e-13,  6.633582132593946e-15, -3.289810877345132e-16,  1.472121049195424e-17, -5.995186969624634e-19,  1.520812169366677e-07,
 -6.222663069368076e-08,  1.355334946840101e-08, -2.003924252680354e-09,  2.241284593201148e-10, -2.016027357306248e-11,  1.516971574105908e-12, -9.814008902092428e-14,
  5.570142519275646e-15, -2.816782115500452e-16,  1.284743117153973e-17, -5.330583466322117e-19,  1.091170692275052e-07, -4.542125263483723e-08,  1.008346297333384e-08,
 -1.519891590046442e-09,  1.732702340121865e-10, -1.588158692102647e-11,  1.217307162458199e-12, -8.019391412588161e-14,  4.633169302978502e-15, -2.384114233166530e-16,
  1.106111226508213e-17, -4.666551604504172e-19,  7.877157924324706e-08, -3.328474224782387e-08,  7.513666917795691e-09, -1.151860759462610e-09,  1.335361881186189e-10,
 -1.244373420574063e-11,  9.694249732404523e-13, -6.489040857838236e-14,  3.808094645243656e-15, -1.989813934523917e-16,  9.371447058036566e-18, -4.012154008626655e-19,
  5.696236197161288e-08, -2.438012900288639e-08,  5.583194575006434e-09, -8.684733340965197e-10,  1.021495318675065e-10, -9.655637082568995e-12,  7.628375505041975e-13,
 -5.176949046944078e-14,  3.079371032168179e-15, -1.630469831854561e-16,  7.779271495501862e-18, -3.372981326004247e-19,  4.094728071969564e-08, -1.771436978395249e-08,
  4.105851234257756e-09, -6.465261909833594e-10,  7.697346844555965e-11, -7.363578179064977e-12,  5.886493050324617e-13, -4.041309826329314e-14,  2.431300823226536e-15,
 -1.301733815791259e-16,  6.278934862568555e-18, -2.751638772643112e-19,  2.885722064643744e-08, -1.259222875079943e-08,  2.947184120147936e-09, -4.686895333380846e-10,
  5.635208139092809e-11, -5.443409602574568e-12,  4.393219267618880e-13, -3.044515213817821e-14,  1.848536448557205e-15, -9.986836206057113e-17,  4.859947704652314e-18,
 -2.148277084843855e-19,  1.939087856051974e-08, -8.517258172024036e-09,  2.008318852721791e-09, -3.218055027067778e-10,  3.898370088641645e-11, -3.793732264994557e-12,
  3.084245521057649e-13, -2.152773061861709e-14,  1.316327986889388e-15, -7.160800043342012e-17,  3.508362665963361e-18, -1.561120033870017e-19,  1.161271118212924e-08,
 -5.123965118874937e-09,  1.214428075696517e-09, -1.956160917787151e-10,  2.382069772924302e-11, -2.330073120259716e-12,  1.903914762899149e-13, -1.335530269022513e-14,
  8.206095163629793e-16, -4.485497474413290e-17,  2.207953848289116e-18, -9.869894173071087e-20,  4.822317573987820e-09, -2.133149969519611e-09,  5.070225907752719e-10,
 -8.190730827250771e-11,  1.000296818023524e-11, -9.812607507348916e-13,  8.040500522213051e-14, -5.655728734586402e-15,  3.484564355915184e-16, -1.909753500134937e-17,
  9.425169169862423e-19, -4.223949409287259e-20,  5.798888890166311e-02, -1.394428289034445e-04,  3.480108927504125e-07, -8.953420942936351e-10,  2.356273968819340e-12,
 -6.298238775803306e-15,  1.699899078378449e-17, -4.612751071583108e-20,  1.254536382635839e-22, -3.412852209292656e-25,  9.274192322449126e-28, -2.515487385414613e-30,
  5.650218896650945e-02, -1.764580515407286e-04,  6.457779887631065e-07, -2.440710890170503e-09,  9.112975852351101e-12, -3.329980972117667e-14,  1.191535646019294e-16,
 -4.185781682618357e-19,  1.447234386480602e-21, -4.934991937508342e-24,  1.662350861291697e-26, -5.538647302828292e-29,  5.364550992610544e-02, -2.445719283646268e-04,
  1.276678066301066e-06, -6.345138641923469e-09,  2.984455845372150e-11, -1.343980753655676e-13,  5.846645918972332e-16, -2.471918186301996e-18,  1.020071967246095e-20,
 -4.121760200123023e-23,  1.634814035813394e-25, -6.377429746770076e-28,  4.963675832657344e-02, -3.331184894395474e-04,  2.289597793144378e-06, -1.414472598459541e-08,
  8.086376404384407e-11, -4.364431987329912e-13,  2.250674126089097e-15, -1.117803031585901e-17,  5.377364739714141e-20, -2.516492438095218e-22,  1.149471724542942e-24,
 -5.138413528923026e-27,  4.476689208942315e-02, -4.287279769452825e-04,  3.712121890663959e-06, -2.786456566852708e-08,  1.901534632665062e-10, -1.209056681986648e-12,
  7.269340170845544e-15, -4.174202099639270e-17,  2.305604747960510e-19, -1.231549678957139e-21,  6.388093291992438e-24, -3.228187252795128e-26,  3.936433697880438e-02,
 -5.177603764230860e-04,  5.516807415054195e-06, -4.959337412558772e-08,  3.985447360550113e-10, -2.947148702252137e-12,  2.041066860554964e-14, -1.339645957127351e-16,
  8.403738032281090e-19, -5.070391608922149e-21,  2.956699146566308e-23, -1.672737220915897e-25,  3.375809353077613e-02, -5.885773822064881e-04,  7.602157590663237e-06,
 -8.088521616971469e-08,  7.571235447008362e-10, -6.445971767338346e-12,  5.094065314436607e-14, -3.787905969230944e-16,  2.676014572094577e-18, -1.809055393779540e-20,
  1.176765550880667e-22, -7.397507446865264e-25,  2.824529517682759e-02, -6.331939930363079e-04,  9.796199998025291e-06, -1.221115988727062e-07,  1.319254279126185e-09,
 -1.282448017545315e-11,  1.147606473227898e-13, -9.598129899469327e-16,  7.584039105095846e-18, -5.707015434500059e-20,  4.115122100516776e-22, -2.857016759973437e-24,
  2.306746040744576e-02, -6.480502275502635e-04,  1.188222740522107e-05, -1.719651933222733e-07,  2.127479982118852e-09, -2.344688502685048e-11,  2.360334855976485e-13,
 -2.206812266104550e-15,  1.939039407772065e-17, -1.615252296112346e-19,  1.284246825041846e-21, -9.797068238817894e-24,  1.839752250173052e-02, -6.338814045689402e-04,
  1.363868290769276e-05, -2.273150732068066e-07,  3.198000141586493e-09, -3.970985489007510e-11,  4.471337505650025e-13, -4.648475682564225e-15,  4.519122355691697e-17,
 -4.147392714090561e-19,  3.619338278366317e-21, -3.020517785063243e-23,  1.433750825263869e-02, -5.948702724715273e-04,  1.488110195049046e-05, -2.835202550868688e-07,
  4.507374132124947e-09, -6.270635198786789e-11,  7.857445091930798e-13, -9.040112369226830e-15,  9.680572583238560e-17, -9.746540568372772e-19,  9.298098541464006e-21,
 -8.455985326471443e-23,  1.092497336129293e-02, -5.373861853048496e-04,  1.549448656432362e-05, -3.351592848659292e-07,  5.986468499608257e-09, -9.283398219399028e-11,
  1.288515871983270e-12, -1.633556496578350e-14,  1.919086215882674e-16, -2.111620268659819e-18,  2.194170322702646e-20, -2.166928085356285e-22,  8.145279385774624e-03,
 -4.686396669857400e-04,  1.544864701468513e-05, -3.769926632991050e-07,  7.524991790243231e-09, -1.294611390420535e-10,  1.981876830254731e-12, -2.757768799606937e-14,
  3.541177338799137e-16, -4.243525892669246e-18,  4.786874466690408e-20, -5.117426208542513e-22,  5.946564673987842e-03, -3.955211553427384e-04,  1.479486455468520e-05,
 -4.049006332140006e-07,  8.986735604995236e-09, -1.707728793695304e-10,  2.871973473108081e-12, -4.370240153672096e-14,  6.112771977581273e-16, -7.951966255897366e-18,
  9.708235750017313e-20, -1.120195569117989e-21,  4.254669696151728e-03, -3.237861113714863e-04,  1.364748097504747e-05, -4.165568772677862e-07,  1.023213179220190e-08,
 -2.138790924793093e-10,  3.936677456696634e-12, -6.528371695934733e-14,  9.914926660775828e-16, -1.395963076626511e-17,  1.839242878283504e-19, -2.284344577077485e-21,
  2.986066605351047e-03, -2.576344127686149e-04,  1.215716290026894e-05, -4.116937449095767e-07,  1.114236256173752e-08, -2.551908560929538e-10,  5.122609543796227e-12,
 -9.227958942381051e-14,  1.517151808983804e-15, -2.305300664849492e-17,  3.269063641122787e-19, -4.359134658942195e-21,  2.057741913237126e-03, -1.996403954346441e-04,
  1.048315400866026e-05, -3.919431471170077e-07,  1.163891195512504e-08, -2.909859043354450e-10,  6.348972377786065e-12, -1.238557361777701e-13,  2.198015060081487e-15,
 -3.594773660047238e-17,  5.472541718035044e-19, -7.815622494167570e-21,  1.393776983366857e-03, -1.509361996793577e-04,  8.770307903477468e-06, -3.603503225413664e-07,
  1.169411442988880e-08, -3.180243541532953e-10,  7.518024564593189e-12, -1.583555033536106e-13,  3.025146635881284e-15, -5.311411654490930e-17,  8.659444098300530e-19,
 -1.321457276070338e-20,  9.289428689943459e-04, -1.115356015337374e-04,  7.134099233658449e-06, -3.207216144757489e-07,  1.133113534705340e-08, -3.340634018795457e-10,
  8.529985333870805e-12, -1.934479783417266e-13,  3.967626233653743e-15, -7.460038983191747e-17,  1.299469309363957e-18, -2.114212081188451e-20,  6.099429556960221e-04,
 -8.069873118946094e-05,  5.654177591123758e-06, -2.769731528046468e-07,  1.061476304121731e-08, -3.381561847592975e-10,  9.298816818591361e-12, -2.264354548112799e-13,
  4.973465415424964e-15, -9.990278810384121e-17,  1.855088679252784e-18, -3.210927638978975e-20,  3.950329896084663e-04, -5.726668137022394e-05,  4.375075678173813e-06,
 -2.326075490545741e-07,  9.636436806351261e-09, -3.306878335253969e-10,  9.765163253447292e-12, -2.546539024857725e-13,  5.975064954976773e-15, -1.279270144499986e-16,
  2.526725561757438e-18, -4.643000677134195e-20,  2.526901943286552e-04, -3.992687786512993e-05,  3.311690970845711e-06, -1.903841946676109e-07,  8.497628266639675e-09,
 -3.131741336537117e-10,  9.903713225558642e-12, -2.758737239270764e-13,  6.898262038425839e-15, -1.570653249493011e-16,  3.292730137324222e-18, -6.410414153751667e-20,
  1.598629235448854e-04, -2.739704845328065e-05,  2.457041673907824e-06, -1.521889637965123e-07,  7.295143460341212e-09, -2.879013729614118e-10,  9.723939835584485e-12,
 -2.886112357545783e-13,  7.672994675424297e-15, -1.853827191095519e-16,  4.116394561524211e-18, -8.473632382925254e-20,  1.001682601468499e-04, -1.853397218698701e-05,
  1.790261548603489e-06, -1.190665232424384e-07,  6.110600310468101e-09, -2.575075291745771e-10,  9.264922732194151e-12, -2.922905858434225e-13,  8.243208326456626e-15,
 -2.108756325759146e-16,  4.949429492663161e-18, -1.075175420100154e-19,  6.225551154430688e-05, -1.238274042797162e-05,  1.283511982936221e-06, -9.135829416090697e-08,
  5.004840683394966e-09, -2.245958713730652e-10,  8.586216075904702e-12, -2.872387374957581e-13,  8.573945466203701e-15, -2.317473954516634e-16,  5.737831012429958e-18,
 -1.312819003061565e-19,  3.843745749643861e-05, -8.184887139231257e-06,  9.071906838471802e-07, -6.888849285215763e-08,  4.016812905372686e-09, -1.914427223035328e-10,
  7.757224781209691e-12, -2.745374074646868e-13,  8.654422024032683e-15, -2.466424870021465e-16,  6.428940876576457e-18, -1.546324306035197e-19,  2.361259454803391e-05,
 -5.362005767921844e-06,  6.333541906438181e-07, -5.115250601493165e-08,  3.165735267000727e-09, -1.598251894033135e-10,  6.847323267945703e-12, -2.557835238952710e-13,
  8.496967736937495e-15, -2.547956422044792e-16,  6.978234810728093e-18, -1.761121407662563e-19,  1.445587064915434e-05, -3.487686475989225e-06,  4.375994879040634e-07,
 -3.747855611744925e-08,  2.455131495119979e-09, -1.309635163523165e-10,  5.918246339338393e-12, -2.328188823040039e-13,  8.132639470130237e-15, -2.560759837373600e-16,
  7.354523398554987e-18, -1.943858108597353e-19,  8.834221991201868e-06, -2.256442222602391e-06,  2.997914387322343e-07, -2.714945952200186e-08,  1.877484050508365e-09,
 -1.055526322637198e-10,  5.019420401229870e-12, -2.074821739999026e-13,  7.604871306294274e-15, -2.509320060452458e-16,  7.542729688786883e-18, -2.083972080887818e-19,
  5.398045109832275e-06, -1.454688627276303e-06,  2.040326196308402e-07, -1.948316941354736e-08,  1.418602219863049e-09, -8.384955631329727e-11,  4.186150810275012e-12,
 -1.814188024218983e-13,  6.962636035220886e-15, -2.402629573538117e-16,  7.544033305429162e-18, -2.174747283318872e-19,  3.303491660578656e-06, -9.361706343495740e-07,
  1.382089349950691e-07, -1.387791262896464e-08,  1.061193244006125e-09, -6.578502185880157e-11,  3.440085808973377e-12, -1.559633228262737e-13,  6.254341041456562e-15,
 -2.252518850522977e-16,  7.373744776313505e-18, -2.213724503549892e-19,  2.028153085339588e-06, -6.024931488975844e-07,  9.335449843832151e-08, -9.830722216268344e-09,
  7.874552376684182e-10, -5.107500077860271e-11,  2.791167416507470e-12, -1.320918172853787e-13,  5.523229419274996e-15, -2.071951713916650e-16,  7.057653762346929e-18,
 -2.202485031837539e-19,  1.251216595339450e-06, -3.884375386454821e-07,  6.299213159898009e-08, -6.938306899954911e-09,  5.807371370714241e-10, -3.931694017749385e-11,
  2.240299544696823e-12, -1.104301540609105e-13,  4.804572693166823e-15, -1.873555367669685e-16,  6.627727438208628e-18, -2.145944219087393e-19,  7.768996929639554e-07,
 -2.513052319266873e-07,  4.253578584502261e-08, -4.887776113504349e-09,  4.264329088429611e-10, -3.006381088145631e-11,  1.782122575841093e-12, -9.129931251588797e-14,
  4.124547585643715e-15, -1.668541924048076e-16,  6.117949496100527e-18, -2.051355206643819e-19,  4.862591906127168e-07, -1.634190270675432e-07,  2.879201068264777e-08,
 -3.442755077618626e-09,  3.123175497558478e-10, -2.287517972342268e-11,  1.407493806270830e-12, -7.477942939233691e-14,  3.500443922282991e-15, -1.466067217928020e-16,
  5.560865571680600e-18, -1.927230097721633e-19,  3.072361510216989e-07, -1.069775843391528e-07,  1.956713619470920e-08, -2.428504769285815e-09,  2.285206390052269e-10,
 -1.734819218096212e-11,  1.105471109420014e-12, -6.077786122240667e-14,  2.941754929504372e-15, -1.272987546640490e-16,  4.985128793243959e-18, -1.782349479081994e-19,
  1.962259779895670e-07, -7.059677916295004e-08,  1.337059620397224e-08, -1.718109339563578e-09,  1.672957206108664e-10, -1.313296750896995e-11,  8.647491784979875e-13,
 -4.909138728719322e-14,  2.451720153792726e-15, -1.093925062418799e-16,  4.414093683852988e-18, -1.624971864152464e-19,  1.268314238161634e-07, -4.702383817717337e-08,
  9.198080092732472e-09, -1.220688790342006e-09,  1.226993676589081e-10, -9.937097481935970e-12,  6.745946568495483e-13, -3.945727577893960e-14,  2.028977649997286e-15,
 -9.315356214418362e-17,  3.865330524100563e-18, -1.462291968604347e-19,  8.304132720393841e-08, -3.164709868233260e-08,  6.377078076793440e-09, -8.718939801593711e-10,
  9.025332247857850e-11, -7.523324285210015e-12,  5.253747493006107e-13, -3.159153460078689e-14,  1.669092818748006e-15, -7.868801335983878e-17,  3.350837157605462e-18,
 -1.300144718961637e-19,  5.511142191932489e-08, -2.153495747777152e-08,  4.459109108668186e-09, -6.265507818613688e-10,  6.663135595148446e-11, -5.703534058920366e-12,
  4.087867601624404e-13, -2.521504071297900e-14,  1.365835907657190e-15, -6.598212534473626e-17,  2.877700480954673e-18, -1.142917268090115e-19,  3.708329275096235e-08,
 -1.482124636597174e-08,  3.145742465177091e-09, -4.531417414018657e-10,  4.939021725324826e-11, -4.331248430949599e-12,  3.178873523917258e-13, -2.006950674981600e-14,
  1.112162503655907e-15, -5.493924538161956e-17,  2.448983916747488e-18, -9.936145626913552e-20,  2.529142851036112e-08, -1.031454418168678e-08,  2.238464618465201e-09,
 -3.297644231994672e-10,  3.674996778262154e-11, -3.293986418314676e-12,  2.470015210231176e-13, -1.592567846112324e-14,  9.009065794740358e-16, -4.541098952722710e-17,
  2.064666925981059e-18, -8.540217403655275e-20,  1.746431668531460e-08, -7.250829596525342e-09,  1.605037417241093e-09, -2.412258991414569e-10,  2.742109401818003e-11,
 -2.506257966523596e-12,  1.915700511181554e-13, -1.258606453498699e-14,  7.252263258084400e-16, -3.722158262599065e-17,  1.722519280585278e-18, -7.249137977971698e-20,
  1.218208723687982e-08, -5.137209638671214e-09,  1.157083185084215e-09, -1.769836083739625e-10,  2.047208703721513e-11, -1.903531470846627e-12,  1.479749721036872e-13,
 -9.884136508684068e-15,  5.788549827894865e-16, -3.018546494411044e-17,  1.418844124935283e-18, -6.062747090078615e-20,  8.548123868696368e-09, -3.653209981153651e-09,
  8.352190369450706e-10, -1.297013273821124e-10,  1.523004450816113e-11, -1.437255987887831e-12,  1.133671185959348e-13, -7.681481197136493e-15,  4.562086622630186e-16,
 -2.411898581021919e-17,  1.149063778492969e-18, -4.975007618340397e-20,  5.989216752508292e-09, -2.588315834806763e-09,  5.992185303109159e-10, -9.424356549686510e-11,
  1.120712867784823e-11, -1.070872412103296e-12,  8.550868261117345e-14, -5.863950040091493e-15,  3.523962723422354e-16, -1.884730406016856e-17,  9.081494217600198e-19,
 -3.975740197254822e-20,  4.133087070729253e-09, -1.802288708705897e-09,  4.214951359186144e-10, -6.697751140631664e-11,  8.046639521861459e-12, -7.766785191028527e-13,
  6.263609709313246e-14, -4.337482326266783e-15,  2.631671726362317e-16, -1.420764590872441e-17,  6.909118053839646e-19, -3.052004886551041e-20,  2.732581900732973e-09,
 -1.199765062317385e-09,  2.827652943945677e-10, -4.528772273846037e-11,  5.483587528873825e-12, -5.333910728224382e-13,  4.334396353562903e-14, -3.024001932353577e-15,
  1.848228568008571e-16, -1.004996369613037e-17,  4.921782516953721e-19, -2.189138954159270e-20,  1.618073239014079e-09, -7.137957986170906e-10,  1.691335136006393e-10,
 -2.723643654282923e-11,  3.315799961582134e-12, -3.242594774427887e-13,  2.648874663400700e-14, -1.857633645506124e-15,  1.141134974750127e-16, -6.236012077493310e-18,
  3.068908314234490e-19, -1.371532250893814e-20,  6.676954185002499e-10, -2.953202407139199e-10,  7.018448042197978e-11, -1.133644574541000e-11,  1.384278552310452e-12,
 -1.357749636203548e-13,  1.112396288053579e-14, -7.823602963306601e-16,  4.819579575372600e-17, -2.641077128025336e-18,  1.303276925799312e-19, -5.839973702493524e-21,
  5.743661860670050e-02, -1.367010867069028e-04,  3.374889037055065e-07, -8.586276934279784e-10,  2.234286631115489e-12, -5.905319302029776e-15,  1.576182649700518e-17,
 -4.230262577684930e-20,  1.138092889522780e-22, -3.063092321732321e-25,  8.236002260499668e-28, -2.210577568150025e-30,  5.580650714803694e-02, -1.714065526495703e-04,
  6.173428185272214e-07, -2.300079762611091e-09,  8.474653543796736e-12, -3.057569292031713e-14,  1.080559168085522e-16, -3.749855064910691e-19,  1.280978994101908e-21,
 -4.316317442518533e-24,  1.436895137283490e-26, -4.731822458381892e-29,  5.268717802824789e-02, -2.346551522151244e-04,  1.203315184363569e-06, -5.888389882263915e-09,
  2.729149511101820e-11, -1.211611311302203e-13,  5.198064254358979e-16, -2.168027302318619e-18,  8.828132949954857e-21, -3.520659173834622e-23,  1.378465955932161e-25,
 -5.309250090350223e-28,  4.833987313477547e-02, -3.154593038382573e-04,  2.127345174444414e-06, -1.291790481335320e-08,  7.265068060797866e-11, -3.859964565898923e-13,
  1.960478741638057e-15, -9.593773541675417e-18,  4.549017655590045e-20, -2.098911195387075e-22,  9.454884166932005e-25, -4.169102545790805e-27,  4.310932709612544e-02,
 -4.003185573241054e-04,  3.395233512601114e-06, -2.500646299835452e-08,  1.676264414443864e-10, -1.047823399756492e-12,  6.197525675414135e-15, -3.502679156251479e-17,
  1.905012850522251e-19, -1.002318513791075e-21,  5.122705979773655e-24, -2.551401979995206e-26,  3.737794264077025e-02, -4.759023077562413e-04,  4.958084959093895e-06,
 -4.366280938339787e-08,  3.442115085744332e-10, -2.499426811603876e-12,  1.701025408565413e-14, -1.097785761297071e-16,  6.774661801048360e-19, -4.022769285951044e-21,
  2.309487991314049e-23, -1.286764471055270e-25,  3.151954958730641e-02, -5.314460577829741e-04,  6.700170238656584e-06, -6.973960772099135e-08,  6.396183382120724e-10,
 -5.341564057146391e-12,  4.144159094698811e-14, -3.027298741730831e-16,  2.102182824160113e-18, -1.397542130289991e-20,  8.943583286772587e-23, -5.533146525014974e-25,
  2.586045998822421e-02, -5.603454770336570e-04,  8.449505984577572e-06, -1.029144666261737e-07,  1.088264444714706e-09, -1.036708852224433e-11,  9.099597067582381e-14,
 -7.470498530789117e-16,  5.797811618649274e-18, -4.287459543187988e-20,  3.039470070648746e-22, -2.075515078932838e-24,  2.065307814339480e-02, -5.607018020306619e-04,
  1.000835071460572e-05, -1.413890404267358e-07,  1.710526062126239e-09, -1.845849294972806e-11,  1.821215487255930e-13, -1.670229781051452e-15,  1.440486120898843e-17,
 -1.178475258176389e-19,  9.206617049651569e-22, -6.904123253753547e-24,  1.606409283537127e-02, -5.348699879953803e-04,  1.119347602598372e-05, -1.819590661987304e-07,
  2.501361832984564e-09, -3.038997894801821e-11,  3.351626304506429e-13, -3.415713326524875e-15,  3.257499563429790e-17, -2.934454278437342e-19,  2.514965488116987e-21,
 -2.062234468070430e-23,  1.217619031604573e-02, -4.882934832383788e-04,  1.187327874991566e-05, -2.204908298894286e-07,  3.423003124502880e-09, -4.656593591159819e-11,
  5.711879862406564e-13, -6.438647361458030e-15,  6.760305479979345e-17, -6.677845997423263e-19,  6.253772720016498e-21, -5.585849976392529e-23,  8.999993930591133e-03,
 -4.280205347093197e-04,  1.199105166865404e-05, -2.526928746486512e-07,  4.405292579930410e-09, -6.676902617612141e-11,  9.067746057135379e-13, -1.125844482169776e-14,
  1.296301112023045e-16, -1.398883035983738e-18,  1.426401808392864e-20, -1.383079352133338e-22,  6.491897450144362e-03, -3.612805471835151e-04,  1.156939577090663e-05,
 -2.749633977814141e-07,  5.354936832350611e-09, -9.001066752054216e-11,  1.347780052761663e-12, -1.836063925868093e-14,  2.309964998312436e-16, -2.713984987317640e-18,
  3.003415055379628e-20, -3.151598349783767e-22,  4.573562425503243e-03, -2.943902356843181e-04,  1.069715673811254e-05, -2.850708926226360e-07,  6.171826103959370e-09,
 -1.145590720599515e-10,  1.883954511260535e-12, -2.805931411304552e-14,  3.844468813726514e-16, -4.902296116155671e-18,  5.870267492625978e-20, -6.647272352474107e-22,
  3.149765687764508e-03, -2.321124413545355e-04,  9.504996499299348e-06, -2.824924787982215e-07,  6.768017927826829e-09, -1.381669928401811e-10,  2.486459679946983e-12,
 -4.035276880654981e-14,  6.002343987559256e-16, -8.282691918432091e-18,  1.070217917672837e-19, -1.304290084366635e-21,  2.122571891427209e-03, -1.774561702974698e-04,
  8.137534151991249e-06, -2.683554029534255e-07,  7.084081079827549e-09, -1.584532536118188e-10,  3.109730722334402e-12, -5.481880297917282e-14,  8.826528418321158e-16,
 -1.314404911588597e-17,  1.827833487547462e-19, -2.391507277664527e-21,  1.401070575272477e-03, -1.318164826183819e-04,  6.729030985299222e-06, -2.450493057413843e-07,
  7.098545555393656e-09, -1.733379399648418e-10,  3.697795584810012e-12, -7.059322315133123e-14,  1.226946633287687e-15, -1.966602676856869e-17,  2.935991600315407e-19,
 -4.114313647004362e-21,  9.068956792154915e-04, -9.531621433291418e-05,  5.386908664773770e-06, -2.156561098273224e-07,  6.828627171867560e-09, -1.814135231542174e-10,
  4.193668932559474e-12, -8.645390661863225e-14,  1.617683247080024e-15, -2.783881644307057e-17,  4.451362845027571e-19, -6.665996263310116e-21,  5.763339145484440e-04,
 -6.721908202143677e-05,  4.184304189290858e-06, -1.833625839481835e-07,  6.323114977365671e-09, -1.821586628415364e-10,  4.549389697513144e-12, -1.009999458537697e-13,
  2.029393253303151e-15, -3.740654803744688e-17,  6.391580532182680e-19, -1.020636560444604e-20,  3.600509117548543e-04, -4.631754607531596e-05,  3.160417302981439e-06,
 -1.509864128879496e-07,  5.650307833451202e-09, -1.759550825650533e-10,  4.734091505189482e-12, -1.128840434846184e-13,  2.429646238559022e-15, -4.785669996536852e-17,
  8.719073696169950e-19, -1.481555218892514e-20,  2.214182123714269e-04, -3.124067011619284e-05,  2.326082323631553e-06, -1.206847907722393e-07,  4.884622528366659e-09,
 -1.639275309478589e-10,  4.738208102138041e-12, -1.210391252919709e-13,  2.783968659949206e-15, -5.846649653878098e-17,  1.133388229795997e-18, -2.045180063956083e-20,
  1.342277477989938e-04, -2.066398107774895e-05,  1.671765731796520e-06, -9.385206666580862e-08,  4.095016573057721e-09, -1.476706621321342e-10,  4.573174687379880e-12,
 -1.248433668829250e-13,  3.061422947220087e-15, -6.840054423930116e-17,  1.407913325784707e-18, -2.692631350486081e-20,  8.033468483630428e-05, -1.342859252778249e-05,
  1.175708919006576e-06, -7.116837282575580e-08,  3.337138497578360e-09, -1.289431351262653e-10,  4.267274392808253e-12, -1.241888806028363e-13,  3.239480629438176e-15,
 -7.683818613373697e-17,  1.675939670525264e-18, -3.390534380127337e-20,  4.754222610536161e-05, -8.589820996364648e-06,  8.107767962996185e-07, -5.274103483602785e-08,
  2.649723778570563e-09, -1.093992917660607e-10,  3.859157218569776e-12, -1.194487910104912e-13,  3.307084729528447e-15, -8.310025775381476e-17,  1.916834271536483e-18,
 -4.094285078558059e-20,  2.786670247086515e-05, -5.418780824127119e-06,  5.493953457751067e-07, -3.828161829636326e-08,  2.054653637735061e-09, -9.040228135669848e-11,
  3.390825628479272e-12, -1.113641308985658e-13,  3.265374973474995e-15, -8.674607768033629e-17,  2.111939901140348e-18, -4.753843149751684e-20,  1.620555198667705e-05,
 -3.377717116251296e-06,  3.665726971448473e-07, -2.727541769955530e-08,  1.559499115477137e-09, -7.293201718511266e-11,  2.901596778150303e-12, -1.008877724508866e-13,
  3.126207944756118e-15, -8.762144510125962e-17,  2.247242444828871e-18, -5.320804256576501e-20,  9.366624326158434e-06, -2.084507051911554e-06,  2.413467521924883e-07,
 -1.911837397477608e-08,  1.161266649706051e-09, -5.757681487616368e-11,  2.423945445117780e-12, -8.902490786990921e-14,  2.909117608092285e-15, -8.585281739256518e-17,
  2.315086671360340e-18, -5.755176237429626e-20,  5.390583826965454e-06, -1.276171751119397e-06,  1.571264530567361e-07, -1.321258995351077e-08,  8.502894053957935e-10,
 -4.458375299319960e-11,  1.981470967335000e-12, -7.670101536533003e-14,  2.637599799496546e-15, -8.179642808131442e-17,  2.314676482727884e-18, -6.030440055093456e-20,
  3.094813536924007e-06, -7.766389521805755e-07,  1.013698090433869e-07, -9.022795368625739e-09,  6.135824769501736e-10, -3.393959131101990e-11,  1.588715638551787e-12,
 -6.467420128636602e-14,  2.335559616011567e-15, -7.595987089415594e-17,  2.251417386020124e-18, -6.136017695597125e-20,  1.775855832922576e-06, -4.707829775932515e-07,
  6.494520326759564e-08, -6.101929301666075e-09,  4.373491330259878e-10, -2.545835532830720e-11,  1.252279811308770e-12, -5.349479117106493e-14,  2.024518475377150e-15,
 -6.891608671362437e-17,  2.135410248693844e-18, -6.076977711495916e-20,  1.020457663819890e-06, -2.848432698601847e-07,  4.140872606843277e-08, -4.095606830248698e-09,
  3.086046310280861e-10, -1.885947726126358e-11,  9.726197490064789e-13, -4.350476310264934e-14,  1.721860054058609e-15, -6.122662090567732e-17,  1.979528013768832e-18,
 -5.871446257036776e-20,  5.883568663755081e-07, -1.723719952906311e-07,  2.633087848127309e-08, -2.734247368949299e-09,  2.160495342717412e-10, -1.382839770802950e-11,
  7.460092656367445e-13, -3.486442888715968e-14,  1.440108064365600e-15, -5.338478322117292e-17,  1.797497028178382e-18, -5.546589761771812e-20,  3.410259359314962e-07,
 -1.045414065198398e-07,  1.673320722848424e-08, -1.819512730750071e-09,  1.503909861054522e-10, -1.005784223514399e-11,  5.663124369258254e-13, -2.759311553802123e-14,
  1.187036165077298e-15, -4.578249753236952e-17,  1.602299232870764e-18, -5.134139889609652e-20,  1.990975810019210e-07, -6.367100066130644e-08,  1.064944346711449e-08,
 -1.209422870888639e-09,  1.043097280620697e-10, -7.271938917690631e-12,  4.263849952052787e-13, -2.161292266516120e-14,  9.663256630768550e-16, -3.869908084609995e-17,
  1.405064898369413e-18, -4.666288866062272e-20,  1.172968569326141e-07, -3.901873023473375e-08,  6.801026297407874e-09, -8.046086659174135e-10,  7.223481607047603e-11,
 -5.237149729708224e-12,  3.190570166070570e-13, -1.678822707627150e-14,  7.784903937893920e-16, -3.230683942627144e-17,  1.214486652626832e-18, -4.172497954946439e-20,
  6.985930789595470e-08, -2.410418512372235e-08,  4.366649273007609e-09, -5.367974548411712e-10,  5.004114936092100e-11, -3.764265050199710e-12,  2.377357313896600e-13,
 -1.295716248390233e-14,  6.218456083991500e-16, -2.668721051401021e-17,  1.036684686261454e-18, -3.677445644649238e-20,  4.213136941871645e-08, -1.503686783710960e-08,
  2.823713103570888e-09, -3.597779931391307e-10,  3.474150947070288e-11, -2.705122059361101e-12,  1.767087944463407e-13, -9.954082136292955e-15,  4.933749673189730e-16,
 -2.185165323247146e-17,  8.754000544500749e-19, -3.200078492956614e-20,  2.576835005292407e-08, -9.487552413269443e-09,  1.842000565900211e-09, -2.426391675251155e-10,
  2.421115486042207e-11, -1.946783270042676e-12,  1.312373859063701e-13, -7.623785339919419e-15,  3.894224687967762e-16, -1.776286583356579e-17,  7.323821455025409e-19,
 -2.753557818557644e-20,  1.600400739909292e-08, -6.062787972231182e-09,  1.213824371560750e-09, -1.648894937930605e-10,  1.696019820389526e-11, -1.404987100373107e-12,
  9.751854033155240e-14, -5.829155375380041e-15,  3.061915612069023e-16, -1.435353335736688e-17,  6.078539867182290e-19, -2.345822733577516e-20,  1.010332621852970e-08,
 -3.927994194682903e-09,  8.088847425420333e-10, -1.130318676427283e-10,  1.195538242647347e-11, -1.017924138559955e-12,  7.257803634308433e-14, -4.454065602252210e-15,
  2.400685526749234e-16, -1.154126103260219e-17,  5.009703489586316e-19, -1.980493445224257e-20,  6.487087965612346e-09, -2.581847923415945e-09,  5.454699306821482e-10,
 -7.821220483305834e-11,  8.485952439673909e-12, -7.408484837537718e-13,  5.413616660170616e-14, -3.403230339026519e-15,  1.878043711069607e-16, -9.239420892666332e-18,
  4.102169131137042e-19, -1.657888318819498e-20,  4.236394582648293e-09, -1.721814695109650e-09,  3.722625741855317e-10, -5.463301594194185e-11,  6.065694306956187e-12,
 -5.416854567044801e-13,  4.047249042246643e-14, -2.600323730517872e-15,  1.465928395103539e-16, -7.364299532711766e-18,  3.337269601607770e-19, -1.375996026353640e-20,
  2.811674114189729e-09, -1.164180295488226e-09,  2.569271103252522e-10, -3.849728373234515e-11,  4.363017757519007e-12, -3.976004698660969e-13,  3.030355178239226e-14,
 -1.985306680170829e-15,  1.140801417160169e-16, -5.839249611547692e-18,  2.695122076079483e-19, -1.131310198690462e-20,  1.892744112301015e-09, -7.965042368117619e-10,
  1.789835063859832e-10, -2.731234301633601e-11,  3.151925412088760e-12, -2.924010077752178e-13,  2.267940501334840e-14, -1.511566359450838e-15,  8.833322126155978e-17,
 -4.596619489104671e-18,  2.156165262399334e-19, -9.194873356612618e-21,  1.287305913570776e-09, -5.493031990789013e-10,  1.253674072171653e-10, -1.943420052051468e-11,
  2.278077521177239e-12, -2.146143575962631e-13,  1.689986756964492e-14, -1.143214399913781e-15,  6.778723829353860e-17, -3.578164230710796e-18,  1.702068745476538e-19,
 -7.358256543519144e-21,  8.782357596031691e-10, -3.791267275581893e-10,  8.766375273518995e-11, -1.377042037339629e-11,  1.635516806335564e-12, -1.560888352766371e-13,
  1.244880150740430e-14, -8.527095732212399e-16,  5.118541656826132e-17, -2.734504996894013e-18,  1.316169171676627e-19, -5.755841777267680e-21,  5.929619105923126e-10,
 -2.583836435669317e-10,  6.037844859353218e-11, -9.586540639796492e-12,  1.150783343149102e-12, -1.109868665993661e-13,  8.943601410374068e-15, -6.188558447447347e-16,
  3.751925816750387e-17, -2.024054138167842e-18,  9.835733283128004e-20, -4.341711318541793e-21,  3.854729856792817e-10, -1.691726099588266e-10,  3.985184616205191e-11,
 -6.379516748312272e-12,  7.720728178098005e-13, -7.506339949609670e-14,  6.096822690877416e-15, -4.251607640978915e-16,  2.597327884375547e-17, -1.411690216470464e-18,
  6.910427990006675e-20, -3.072329421595002e-21,  2.255819852623990e-10, -9.949009891510186e-11,  2.356793339049112e-11, -3.794248846500833e-12,  4.617935698788115e-13,
 -4.514789372727988e-14,  3.687169135220351e-15, -2.585117497487150e-16,  1.587623803705312e-17, -8.673806266647482e-19,  4.267570290976269e-20, -1.906772601328858e-21,
  9.247577654946699e-11, -4.089692346433187e-11,  9.718044445793011e-12, -1.569471996863639e-12,  1.916191385295059e-13, -1.879205030842425e-14,  1.539407580173821e-15,
 -1.082532997855651e-16,  6.667828558695084e-18, -3.653406362737883e-19,  1.802585762439723e-20, -8.076316608970691e-22,  5.689514967292510e-02, -1.340417907251005e-04,
  3.273960308853409e-07, -8.238038004420162e-10,  2.119869225522490e-12, -5.540847580343949e-15,  1.462672604426549e-17, -3.883098981822647e-20,  1.033524481265385e-22,
 -2.752297540165634e-25,  7.323057597443548e-28, -1.945217156354727e-30,  5.513058681059836e-02, -1.665759544011886e-04,  5.905356950295107e-07, -2.169240000189326e-09,
  7.888245982082740e-12, -2.810385373756928e-14,  9.810760921141859e-17, -3.363733948579725e-19,  1.135454633740881e-21, -3.781108973947217e-24,  1.244111988655032e-26,
 -4.049835499546836e-29,  5.176737318725852e-02, -2.253040300292017e-04,  1.135196663578691e-06, -5.470453993819824e-09,  2.498826909013142e-11, -1.093834457306692e-13,
  4.628734570121551e-16, -1.904785914865517e-18,  7.654564449557139e-21, -3.013282352594761e-23,  1.164817285307819e-25, -4.430093753239136e-28,  4.711111882615550e-02,
 -2.990414114357793e-04,  1.979058062804190e-06, -1.181478535263614e-08,  6.538032911138984e-11, -3.420107116891805e-13,  1.711146784805129e-15, -8.252030133431879e-18,
  3.857285742760006e-20, -1.754992249640955e-22,  7.797610103174229e-25, -3.392082618082728e-27,  4.156053844473785e-02, -3.743129468478886e-04,  3.110581827716624e-06,
 -2.248433158105324e-08,  1.480813624324874e-10, -9.101949125763617e-13,  5.296965272302561e-15, -2.947063382032085e-17,  1.578508110418443e-19, -8.182129471744870e-22,
  4.121003257505323e-24, -2.023209631654527e-26,  3.555047173935896e-02, -4.382434774367838e-04,  4.465595027852511e-06, -3.853415483676095e-08,  2.980685705244171e-10,
 -2.125744300160184e-12,  1.421939735847004e-14, -9.024899234337854e-17,  5.479952653142354e-19, -3.202997852792083e-21,  1.810686871657536e-23, -9.937068292927653e-26,
  2.949590320421020e-02, -4.810260027132948e-04,  5.921340365563716e-06, -6.030907567313104e-08,  5.420838466673837e-10, -4.441522941817188e-12,  3.383595731683546e-14,
 -2.428643757599485e-16,  1.657996083354343e-18, -1.084137276582236e-20,  6.826717724919396e-23, -4.157263896162242e-25,  2.374684672408997e-02, -4.974083365205103e-04,
  7.312529297772269e-06, -8.704906313533033e-08,  9.011699875383917e-10, -8.414575596983797e-12,  7.245970591927538e-14, -5.840368541954744e-16,  4.452808586956660e-18,
 -3.236478777697026e-20,  2.256145702707977e-22, -1.515523997173189e-24,  1.856028068250377e-02, -4.869829964436943e-04,  8.464438112683700e-06, -1.167515070898690e-07,
  1.381530737061641e-09, -1.460036494957135e-11,  1.412181300051724e-13, -1.270601408077959e-15,  1.075798628613388e-17, -8.645177990399994e-20,  6.637369036217093e-22,
 -4.893656294349639e-24,  1.409078262197168e-02, -4.534193510643395e-04,  9.231372300687907e-06, -1.463931383493700e-07,  1.966824180941345e-09, -2.338507286935025e-11,
  2.526569094551951e-13, -2.524568809363137e-15,  2.362238076657349e-17, -2.089101480490876e-19,  1.758664514062603e-21, -1.417125302002727e-23,  1.039745839991039e-02,
 -4.030259847349408e-04,  9.527518788291298e-06, -1.724856668736337e-07,  2.615341698256036e-09, -3.479695619178604e-11,  4.178962065858975e-13, -4.616145703723042e-15,
  4.752969809856295e-17, -4.607043763879967e-19,  4.235981009161398e-21, -3.716547457037274e-23,  7.462130853961448e-03, -3.431174463132869e-04,  9.341134138917724e-06,
 -1.918081101315387e-07,  3.264242319398452e-09, -4.836340200580897e-11,  6.427628077385954e-13, -7.816820407391792e-15,  8.822425263566311e-17, -9.338528324097302e-19,
  9.345516339734629e-21, -8.898067557843315e-23,  5.212877683499748e-03, -2.805932896583725e-04,  8.729751126303910e-06, -2.020894554405127e-07,  3.840510693517101e-09,
 -6.308045159146114e-11,  9.239886502272418e-13, -1.232481510504864e-14,  1.519432353018121e-16, -1.750491068463036e-18,  1.900650228559377e-20, -1.957867667565391e-22,
  3.547649609053427e-03, -2.209770482667987e-04,  7.800476240866834e-06, -2.024385037338341e-07,  4.275702524880189e-09, -7.753011346414359e-11,  1.246921826181660e-12,
 -1.817922749221701e-14,  2.440100771512690e-16, -3.050303667234155e-18,  3.582925060808252e-20, -3.981965045028460e-22,  2.354272855563066e-03, -1.679819160764471e-04,
  6.683166256287640e-06, -1.934169358766656e-07,  4.520055606208636e-09, -9.012858115943170e-11,  1.585959156799086e-12, -2.519055676759472e-14,  3.670158120708072e-16,
 -4.964063960011515e-18,  6.290836273031475e-20, -7.523558736506878e-22,  1.524985777197033e-03, -1.235269654599971e-04,  5.504598447467417e-06, -1.767771321170070e-07,
  4.551830555086266e-09, -9.943860543901706e-11,  1.908077899216229e-12, -3.291700834935002e-14,  5.190906374135251e-16, -7.576148353870011e-18,  1.033219068147772e-19,
 -1.326507485291707e-21,  9.652596146445360e-04, -8.805098214966245e-05,  4.369455216648909e-06, -1.549845954269013e-07,  4.379574632596822e-09, -1.044546528517267e-10,
  2.178739349143101e-12, -4.070476800399251e-14,  6.928985253499336e-16, -1.088490665093363e-17,  1.593667340389024e-19, -2.191402623105557e-21,  5.977303733374580e-04,
 -6.095896801992620e-05,  3.350545546462332e-06, -1.306842523549302e-07,  4.037467057087197e-09, -1.047804733628825e-10,  2.368548654090311e-12, -4.778956320495118e-14,
  8.758677993378771e-16, -1.477378423095431e-17,  2.316855574826038e-19, -3.404732334289038e-21,  3.625772369010807e-04, -4.106879195728681e-05,  2.487623151523952e-06,
 -1.062495824305890e-07,  3.575951295131459e-09, -1.006584630701599e-10,  2.458778865323545e-12, -5.343491573241767e-14,  1.051808792403387e-15, -1.900549227269138e-17,
  3.185418401622489e-19, -4.992308067607806e-21,  2.157342467925534e-04, -2.697677386447274e-05,  1.792280353261003e-06, -8.349589051950865e-08,  3.050801599567349e-09,
 -9.285981924798136e-11,  2.444300480023515e-12, -5.706915359322957e-14,  1.203601281896159e-15, -2.324560142000787e-17,  4.155161421291775e-19, -6.931020568029040e-21,
  1.260923641648511e-04, -1.731035512068941e-05,  1.255849386598042e-06, -6.357393874112986e-08,  2.513512122620112e-09, -8.248359678820317e-11,  2.333371417229065e-12,
 -5.838406619266081e-14,  1.316257636313075e-15, -2.711261045920549e-17,  5.158050977067689e-19, -9.139430708760980e-21,  7.250633929025251e-05, -1.087180779197288e-05,
  8.576923215711421e-07, -4.701076554171267e-08,  2.004827304711742e-09, -7.072908855336805e-11,  2.144727669535889e-12, -5.737196909159746e-14,  1.379541842803343e-15,
 -3.024257847220121e-17,  6.111257067830724e-19, -1.148046473875124e-20,  4.108520381305700e-05, -6.696257595153003e-06,  5.721899188596522e-07, -3.384076753912835e-08,
  1.551932453603740e-09, -5.869880988389606e-11,  1.903098127956261e-12, -5.429827309078563e-14,  1.389491477598898e-15, -3.235153972885016e-17,  6.930313558187117e-19,
 -1.377734121011285e-20,  2.298052368190213e-05, -4.052924210927943e-06,  3.736982745246697e-07, -2.376982899196197e-08,  1.168777221205201e-09, -4.726710917319087e-11,
  1.634467161266278e-12, -4.962505028305252e-14,  1.348561841560572e-15, -3.327999429720320e-17,  7.543116277215799e-19, -1.583975335425709e-20,  1.271098627637346e-05,
 -2.415467926403321e-06,  2.394641453227990e-07, -1.632958443933484e-08,  8.584475439504171e-10, -3.702350750285747e-11,  1.362169367960333e-12, -4.391141738945624e-14,
  1.264527522081812e-15, -3.300998110881530e-17,  7.901275280832659e-19, -1.749408596648852e-20,  6.965609019823711e-06, -1.420501767123874e-06,  1.508954307723942e-07,
 -1.099797349073071e-08,  6.164233011141732e-10, -2.827946739174298e-11,  1.104415146720508e-12, -3.771703877757381e-14,  1.148583670186019e-15, -3.165377875410315e-17,
  7.986284844482537e-19, -1.861030797152256e-20,  3.789213785300732e-06, -8.260808079640704e-07,  9.371700818972066e-08, -7.278985041921385e-09,  4.338005642459609e-10,
 -2.111664810399249e-11,  8.733364715750382e-13, -3.152793865833817e-14,  1.013205675260693e-15, -2.942083324552231e-17,  7.809620293089873e-19, -1.911946674075946e-20,
  2.050361772444199e-06, -4.760986304016065e-07,  5.750045865276835e-08, -4.745582702759777e-09,  2.999252002778415e-10, -1.545338677668950e-11,  6.752696890332326e-13,
 -2.571340013910888e-14,  8.702580517850890e-16, -2.657375192306181e-17,  7.407553974868859e-19, -1.901874268728446e-20,  1.105892294991536e-06, -2.725447105581768e-07,
  3.493423261516780e-08, -3.055035585126301e-09,  2.042288300946294e-10, -1.111097665580512e-11,  5.118171929060564e-13, -2.051312771391142e-14,  7.296601942144518e-16,
 -2.338450089748884e-17,  6.832644841332359e-19, -1.836455086564320e-20,  5.958405406707391e-07, -1.553225850816557e-07,  2.106615676560591e-08, -1.946724588731575e-09,
  1.373011370462199e-10, -7.868549655668369e-12,  3.812293023543850e-13, -1.604755799375383e-14,  5.987058528615786e-16, -2.009919091624443e-17,  6.144240809072110e-19,
 -1.725697851038778e-20,  3.213922740647161e-07, -8.832632189903186e-08,  1.263887664879801e-08, -1.230866968190578e-09,  9.135993177922558e-11, -5.502143092503677e-12,
  2.797547596228850e-13, -1.234180732396330e-14,  4.819636072495781e-16, -1.691568812079303e-17,  5.400010977354516e-19, -1.582020382870089e-20,  1.739383989383204e-07,
 -5.023599176650333e-08,  7.562383784375213e-09, -7.740912272480679e-10,  6.031557129861282e-11, -3.808358223145137e-12,  2.027520216253072e-13, -9.354440031441837e-15,
  3.815899258737692e-16, -1.397433602842199e-17,  4.649778875611896e-19, -1.418338639178776e-20,  9.466344971209269e-08, -2.864316929276723e-08,  4.523463998759176e-09,
 -4.853971003205755e-10,  3.960528674307397e-11, -2.615617916174309e-12,  1.454828148969441e-13, -7.004643972497228e-15,  2.978633677225119e-16, -1.135932997256928e-17,
  3.932090431924546e-19, -1.246529210035228e-20,  5.192359180899299e-08, -1.641017920140218e-08,  2.711253209872709e-09, -3.042017966834470e-10,  2.592794693928188e-11,
 -1.786833663761473e-12,  1.035995826509514e-13, -5.194220741002235e-15,  2.297764512646297e-16, -9.107040873773936e-18,  3.273274187146433e-19, -1.076425936287217e-20,
  2.876714863063936e-08, -9.468454829399045e-09,  1.632146196803821e-09, -1.909843562342732e-10,  1.696248042932128e-11, -1.216974833214953e-12,  7.338627516528460e-14,
 -3.823187587780291e-15,  1.755736138696728e-16, -7.217600317556203e-18,  2.688355160393456e-19, -9.153595959476169e-21,  1.613260822376912e-08, -5.514106859986042e-09,
  9.890269514233221e-10, -1.203874085815923e-10,  1.111459400739638e-11, -8.282107231112781e-13,  5.182639642516978e-14, -2.799387567502286e-15,  1.331773935483675e-16,
 -5.666842327447232e-18,  2.183064583465793e-19, -7.681454258924606e-21,  9.176331489351251e-09, -3.247964406953208e-09,  6.045578754300301e-10, -7.635468980395510e-11,
  7.309774078344572e-12, -5.643917429921897e-13,  3.656608374143942e-14, -2.043317356688833e-15,  1.004875220348594e-16, -4.416756728645751e-18,  1.756268900963638e-19,
 -6.373750655444255e-21,  5.304023272181945e-09, -1.938783641187670e-09,  3.735072838460857e-10, -4.882183551675547e-11,  4.834705772316060e-12, -3.858734164504942e-13,
  2.582455916242090e-14, -1.489600661248178e-15,  7.556465057992284e-17, -3.423591995087329e-18,  1.402325218196881e-19, -5.238677604276289e-21,  3.120582600349112e-09,
 -1.174834987841725e-09,  2.336394261584718e-10, -3.152612811679381e-11,  3.221381627430423e-12, -2.651409374807007e-13,  1.828725870272565e-14, -1.086396974403823e-15,
  5.672329915685332e-17, -2.643473420273105e-18,  1.113074253486888e-19, -4.271627237373241e-21,  1.871342616495815e-09, -7.237209278246878e-10,  1.481841821446022e-10,
 -2.058859795484385e-11,  2.165392120779960e-12, -1.833516137328235e-13,  1.300241263238751e-14, -7.937411758981156e-16,  4.256130812057786e-17, -2.035837958819485e-18,
  8.793541702317230e-20, -3.459729791882843e-21,  1.144916786901743e-09, -4.536805971635223e-10,  9.539125917733888e-11, -1.361201711853145e-11,  1.469897529830091e-12,
 -1.277303272391485e-13,  9.291243695289436e-15, -5.814924659356412e-16,  3.194989369632892e-17, -1.565176630595195e-18,  6.920381260853742e-20, -2.785580953206328e-21,
  7.149316468234494e-10, -2.895356997538237e-10,  6.235303962769502e-11, -9.114774304617055e-12,  1.008034027956811e-12, -8.967619815122675e-14,  6.675137866900982e-15,
 -4.273011997628732e-16,  2.400280397961192e-17, -1.201597176186946e-18,  5.426652371920175e-20, -2.230021452760040e-21,  4.554444596876133e-10, -1.880428112083944e-10,
  4.136959976250503e-11, -6.179107205020594e-12,  6.981080801099162e-13, -6.342301318026562e-14,  4.819313349747733e-15, -3.148033083229441e-16,  1.803725101363845e-17,
 -9.206493198181985e-19,  4.237603684644122e-20, -1.774020250369560e-21,  2.955046218053047e-10, -1.240822485764551e-10,  2.781487292257111e-11, -4.234044371826535e-12,
  4.874341863487226e-13, -4.511081440443319e-14,  3.490727350727132e-15, -2.321216268910858e-16,  1.353438152669157e-17, -7.027495005472523e-19,  3.289372341800291e-20,
 -1.399810157953905e-21,  1.945746928222920e-10, -8.289195533663146e-11,  1.888416324427687e-11, -2.922024012213326e-12,  3.418985267326298e-13, -3.215230741208716e-14,
  2.527413899950653e-15, -1.706774975589903e-16,  1.010341165717471e-17, -5.324365265679857e-19,  2.528644951977870e-20, -1.091455911623573e-21,  1.291207480453533e-10,
 -5.567672525187757e-11,  1.285739617003810e-11, -2.017050234598704e-12,  2.392577083021225e-13, -2.280515302949906e-14,  1.816557913230051e-15, -1.242780180668373e-16,
  7.451127408760474e-18, -3.976015794073353e-19,  1.911549989896598e-20, -8.350250194576475e-22,  8.522029217844423e-11, -3.710698142996999e-11,  8.663744959764101e-12,
 -1.374400866787714e-12,  1.648449568548227e-13, -1.588509343294741e-14,  1.279007941561339e-15, -8.843005184160064e-17,  5.356995669944420e-18, -2.887705755249508e-19,
  1.402194759919784e-20, -6.185020895416728e-22,  5.443502324699382e-11, -2.387918794110224e-11,  5.622344440737032e-12, -8.995652256780213e-13,  1.088128920003463e-13,
 -1.057378635393635e-14,  8.584000472030452e-16, -5.983112062204616e-17,  3.653360674596421e-18, -1.984728134304962e-19,  9.711055195163551e-21, -4.315525064374960e-22,
  3.146743700004576e-11, -1.387498841214524e-11,  3.285911923209944e-12, -5.288585915694224e-13,  6.434893437138056e-14, -6.289440249331106e-15,  5.135115928885774e-16,
 -3.599332754779914e-17,  2.209915788358977e-18, -1.207052511699965e-19,  5.937277667959591e-21, -2.652149625604955e-22,  1.281173878717289e-11, -5.665224183135940e-12,
  1.345996883435542e-12, -2.173481393861558e-13,  2.653250781189484e-14, -2.601662815542151e-15,  2.130926436528919e-16, -1.498285701585535e-17,  9.227356046318081e-19,
 -5.055113661379223e-20,  2.493846435474452e-21, -1.117194650210060e-22,  5.636415904050984e-02, -1.314615967559888e-04,  3.177102965554368e-07, -7.907537182583716e-10,
  2.012476512804536e-12, -5.202488602594648e-15,  1.358431004013662e-17, -3.567675357170097e-20,  9.395145500615556e-23, -2.475789389726817e-25,  6.519188570938284e-28,
 -1.713949013863742e-30,  5.447356967566837e-02, -1.619536886603483e-04,  5.652439439292212e-07, -2.047399878735894e-09,  7.348972536566122e-12, -2.585830919848201e-14,
  8.917803957043863e-17, -3.021240980651454e-19,  1.007879111198975e-21, -3.317333158814739e-24,  1.078971725430033e-26, -3.472271854819360e-29,  5.088391384037872e-02,
 -2.164784041325055e-04,  1.071879803212889e-06, -5.087557100821503e-09,  2.290750865993731e-11, -9.888778303188165e-14,  4.128118144559291e-16, -1.676333888676190e-18,
  6.649157415869853e-21, -2.584104222819370e-23,  9.863528015881941e-26, -3.704780030392269e-28,  4.594574462418500e-02, -2.837587789202858e-04,  1.843338442211561e-06,
 -1.082126658795334e-08,  5.893277133957602e-11, -3.035820211213103e-13,  1.496462064788662e-15, -7.113046637242592e-18,  3.278212586750297e-20, -1.471000624344005e-22,
  6.447432812774697e-25, -2.767400819771466e-27,  4.011140225148130e-02, -3.504686019842120e-04,  2.854406562668301e-06, -2.025402435444570e-08,  1.310847348769095e-10,
 -7.924252117263232e-13,  4.538293643886550e-15, -2.486054690938723e-17,  1.311596142675472e-19, -6.698861990943472e-22,  3.325431152360654e-24, -1.609569380367955e-26,
  3.386612909934481e-02, -4.042903967848786e-04,  4.030454559459829e-06, -3.408745953930346e-08,  2.587714615279065e-10, -1.812922624753635e-12,  1.192154201429339e-14,
 -7.442640911920278e-17,  4.447352489190358e-19, -2.559153772109319e-21,  1.424784778643669e-23, -7.703063830313463e-26,  2.766215675644470e-02, -4.364091441276054e-04,
  5.246876957256893e-06, -5.230446435527550e-08,  4.608527213644869e-10, -3.705409716850904e-12,  2.772342348975986e-14, -1.955599140778403e-16,  1.312748312443654e-18,
 -8.444284821176804e-21,  5.232907198379642e-23, -3.137203276264645e-25,  2.186792804541879e-02, -4.428535416819871e-04,  6.349190785332191e-06, -7.388747152329110e-08,
  7.490230718497764e-10, -6.856695075475957e-12,  5.793807535611825e-14, -4.585699095959191e-16,  3.435234425545677e-18, -2.454553075929693e-20,  1.682809437862045e-22,
 -1.112159836629445e-24,  1.673940927776109e-02, -4.245168410106721e-04,  7.186975799885892e-06, -9.681035661018168e-08,  1.120723542442634e-09, -1.160185347028151e-11,
  1.100272211864508e-13, -9.714115033803665e-16,  8.075887750405217e-18, -6.375850269710962e-20,  4.811416365631333e-22, -3.488246624854077e-24,  1.241439225076007e-02,
 -3.860937852987590e-04,  7.649040681888047e-06, -1.183586800794672e-07,  1.554448301169687e-09, -1.809063598755019e-11,  1.915113511324639e-13, -1.876540689565312e-15,
  1.723065359512051e-17, -1.496239846233402e-19,  1.237403453874781e-21, -9.799886250154802e-24,  8.925624616966082e-03, -3.344233307209484e-04,  7.687449753395372e-06,
 -1.357038150320610e-07,  2.010055465700274e-09, -2.616083509487086e-11,  3.076599423201701e-13, -3.330811705827555e-15,  3.363713575466470e-17, -3.199854003864449e-19,
  2.889028462973519e-21, -2.490218790503086e-23,  6.225704782656730e-03, -2.767757029140718e-04,  7.323408930473123e-06, -1.465492651739083e-07,  2.435034538402923e-09,
 -3.527318934134604e-11,  4.588354596824414e-13, -5.466419705845655e-15,  6.048600815897629e-17, -6.280895649091421e-19,  6.169780442633450e-21, -5.769070754677555e-23,
  4.216179282619964e-03, -2.194995546704482e-04,  6.635338190629869e-06, -1.496374201429400e-07,  2.775316523461626e-09, -4.454980660579029e-11,  6.384466974616430e-13,
 -8.339536385976370e-15,  1.007587497976006e-16, -1.138393282175427e-18,  1.212890350245658e-20, -1.226644698163152e-22,  2.774662540255401e-03, -1.672353762686959e-04,
  5.735341445305239e-06, -1.449644960078257e-07,  2.987293958808464e-09, -5.292223305385416e-11,  8.325014696764095e-13, -1.188228863915469e-14,  1.562620624969423e-16,
 -1.915171057671029e-18,  2.206904376055225e-20, -2.407468877361644e-22,  1.776146828944591e-03, -1.226958035125850e-04,  4.742700519108583e-06, -1.336664220399580e-07,
  3.047198514603003e-09, -5.935170027688957e-11,  1.021301250326253e-12, -1.587787735350139e-14,  2.266090960851916e-16, -3.004480698974091e-18,  3.734626302744656e-20,
 -4.383390497506406e-22,  1.107083673522904e-03, -8.687379280464170e-05,  3.761897375232720e-06, -1.176524547830451e-07,  2.955068147541118e-09, -6.305390859090782e-11,
  1.183039116108735e-12, -1.997415415746501e-14,  3.085186651941247e-16, -4.413470306532420e-18,  5.903200296222582e-20, -7.437261387700033e-22,  6.726816759941906e-04,
 -5.948542516572482e-05,  2.869382548131880e-06, -9.912974121873489e-08,  2.732619370780930e-09, -6.365854008707962e-11,  1.298302165406065e-12, -2.373837293701760e-14,
  3.957794189975979e-16, -6.093810810296222e-18,  8.750104568358579e-20, -1.180689758492312e-21,  3.989344090961480e-04, -3.947050409292367e-05,  2.109662489708793e-06,
 -8.016476270606954e-08,  2.416416835714548e-09, -6.125953154231120e-11,  1.354106176712570e-12, -2.674028697713601e-14,  4.800342194687242e-16, -7.936450169538014e-18,
  1.220686092178083e-19, -1.760376431766531e-21,  2.312239783178120e-04, -2.542957137988566e-05,  1.498629481308858e-06, -6.238105252186577e-08,  2.048961024830642e-09,
 -5.635243398538343e-11,  1.346273116022618e-12, -2.863949863308338e-14,  5.522490429032717e-16, -9.782077795030200e-18,  1.608196764448514e-19, -2.473663743950792e-21,
  1.311665046695764e-04, -1.593936511612627e-05,  1.030928333791726e-06, -4.682714843481175e-08,  1.670390723691351e-09, -4.969141487157823e-11,  1.279590939846436e-12,
 -2.925123457777609e-14,  6.044695529198018e-16, -1.144646851574513e-17,  2.007336850049244e-19, -3.286809284257772e-21,  7.293471465073660e-05, -9.739488456953746e-06,
  6.883410704918033e-07, -3.399288203138970e-08,  1.312667376035598e-09, -4.211699498005534e-11,  1.165962337169800e-12, -2.857297098499200e-14,  6.313572442918717e-16,
 -1.275443606919349e-17,  2.381158541942534e-19, -4.142610495026047e-21,  3.981744868244972e-05, -5.813198324966729e-06,  4.471032679268009e-07, -2.392129383688595e-08,
  9.969162616962596e-10, -3.440314559841256e-11,  1.021328743082520e-12, -2.676832295892787e-14,  6.310819609840808e-16, -1.357290792631641e-17,  2.692390837252915e-19,
 -4.967696123425412e-21,  2.137919107167035e-05, -3.396310539212680e-06,  2.831622101858703e-07, -1.635865521687133e-08,  7.335640039126577e-10, -2.715494344215583e-11,
  8.623619060304042e-13, -2.411804282611905e-14,  6.053808522937222e-16, -1.383401896067853e-17,  2.910243049549403e-19, -5.684512870562354e-21,  1.131053551430932e-05,
 -1.946414027407987e-06,  1.752637162475532e-07, -1.089785605103034e-08,  5.243238593154588e-10, -2.076582136537721e-11,  7.037555539488878e-13, -2.095581303063081e-14,
  5.588666210653674e-16, -1.354276635111182e-17,  3.015749432230457e-19, -6.224933102248138e-21,  5.907294967028545e-06, -1.096596865478714e-06,  1.062673286289478e-07,
 -7.089870878470977e-09,  3.649675546400583e-10, -1.542544621323605e-11,  5.565743057562067e-13, -1.760705351269621e-14,  4.978707287310436e-16, -1.276892081117612e-17,
  3.004349813608477e-19, -6.541880883821251e-21,  3.052043238275129e-06, -6.087222718773672e-07,  6.327017965904321e-08, -4.515699591420325e-09,  2.480391354057060e-10,
 -1.115981895353827e-11,  4.277145695914240e-13, -1.434375990349689e-14,  4.291797591224358e-16, -1.162740181168825e-17,  2.885332257124718e-19, -6.616123830542065e-21,
  1.563199066398969e-06, -3.337009517060009e-07,  3.708097764218191e-08, -2.822939916921008e-09,  1.650159367964153e-10, -7.884170023289045e-12,  3.202416488007367e-13,
 -1.136076210732259e-14,  3.589697216222939e-16, -1.025368962853560e-17,  2.678690594751476e-19, -6.457014308251598e-21,  7.954715040468619e-07, -1.810908840720082e-07,
  2.144563354121343e-08, -1.736538820228243e-09,  1.077485199355398e-10, -5.453694078772885e-12,  2.342407209555683e-13, -8.771939620593901e-15,  2.921142757124100e-16,
 -8.780714669878093e-18,  2.410544247740564e-19, -6.097776926666174e-21,  4.031105684771119e-07, -9.752131836693774e-08,  1.227061132962257e-08, -1.053916152104047e-09,
  6.923542996633726e-11, -3.703620315969280e-12,  1.678344110419037e-13, -6.620724104829548e-15,  2.319018621971013e-16, -7.321701954722531e-18,  2.108397251415897e-19,
 -5.587268056085506e-21,  2.039149436352258e-07, -5.224625548798959e-08,  6.963968849526650e-09, -6.327229881794834e-10,  4.389752044592893e-11, -2.475914195724876e-12,
  1.181167611764963e-13, -4.897979463466202e-15,  1.800908610110271e-16, -5.960791066951508e-18,  1.797248051096707e-19, -4.980631376991968e-21,  1.032200627378411e-07,
 -2.791737043018088e-08,  3.930530558704500e-09, -3.767616968551992e-10,  2.753706136032499e-11, -1.633789892281806e-12,  8.187183347079835e-14, -3.561312398877234e-15,
  1.371804677361000e-16, -4.750923009625532e-18,  1.497091882150916e-19, -4.330977336141439e-21,  5.241516285973784e-08, -1.491715351660403e-08,  2.212086113939787e-09,
 -2.231173110086150e-10,  1.713710615782312e-11, -1.067058349184076e-12,  5.604407568217159e-14, -2.551888052838378e-15,  1.027726903373235e-16, -3.717057002579387e-18,
  1.221885732210142e-19, -3.683426209347422e-21,  2.676887425241227e-08, -7.991502931934608e-09,  1.244710341891659e-09, -1.317599490982543e-10,  1.060901824173661e-11,
 -6.916522749876969e-13,  3.799013559663322e-14, -1.806924943179686e-15,  7.592928134376660e-17, -2.862332440331544e-18,  9.797086544194374e-20, -3.071951326128624e-21,
  1.378452415520369e-08, -4.303708626009036e-09,  7.021128354847472e-10, -7.780043894301225e-11,  6.550854094640425e-12, -4.461291260243100e-13,  2.556927807914624e-14,
 -1.267648332287698e-15,  5.546653227047531e-17, -2.175073576480206e-18,  7.736938859787258e-20, -2.518733298098234e-21,  7.175365087886787e-09, -2.335935729255231e-09,
  3.980726088134510e-10, -4.605517580097185e-11,  4.045336594841026e-12, -2.871120054554447e-13,  1.713209457669767e-14, -8.834181125887884e-16,  4.016618511191826e-17,
 -1.635182506771146e-18,  6.033082773100437e-20, -2.035324224868245e-21,  3.785021370840360e-09, -1.281124542498716e-09,  2.274327345774673e-10, -2.740269642989237e-11,
  2.504744340123244e-12, -1.848297696460313e-13,  1.145644143509974e-14, -6.131046383753336e-16,  2.890529529937130e-17, -1.219165123406256e-18,  4.656484632662642e-20,
 -1.624815971187770e-21,  2.028186998975552e-09, -7.117094183813183e-10,  1.312667106366331e-10, -1.642865712146618e-11,  1.558815852430259e-12, -1.193122096212753e-13,
  7.664580066605985e-15, -4.247597253611360e-16,  2.072083299769125e-17, -9.035943521999829e-19,  3.565500989084109e-20, -1.284317080972802e-21,  1.106484850035788e-09,
 -4.014219025805200e-10,  7.671465055656702e-11, -9.947493079638982e-12,  9.773524650225851e-13, -7.740748053091168e-14,  5.141704282514297e-15, -2.944147477378157e-16,
  1.482866374658732e-17, -6.671678425464288e-19,  2.714222785900216e-20, -1.007255450709614e-21,  6.158485295752195e-10, -2.303571706497495e-10,  4.549280109882807e-11,
 -6.095968461153435e-12,  6.186417233794264e-13, -5.057800931964884e-14,  3.465680834649871e-15, -2.045743904703827e-16,  1.061485093347303e-17, -4.916799781827828e-19,
  2.058024636331013e-20, -7.852464819467588e-22,  3.503155931274809e-10, -1.347385369259472e-10,  2.742436621961500e-11, -3.787676729599951e-12,  3.960346758582410e-13,
 -3.334139742867206e-14,  2.351155845145504e-15, -1.427419870832148e-16,  7.613067091006854e-18, -3.622556735363828e-19,  1.556743990521223e-20, -6.094450305023459e-22,
  2.039341949833120e-10, -8.044128617680374e-11,  1.682939031180340e-11, -2.389495784860313e-12,  2.567587264954886e-13, -2.220386329272881e-14,  1.607498913897141e-15,
 -1.001406196948898e-16,  5.477366596388942e-18, -2.671456286079333e-19,  1.176094348906860e-20, -4.714153513735688e-22,  1.215911798071138e-10, -4.905895406547416e-11,
  1.052186683644243e-11, -1.531759621923584e-12,  1.687145206740354e-13, -1.494928180772854e-14,  1.108424634654091e-15, -7.068395781956432e-17,  3.955738653378115e-18,
 -1.973062882219175e-19,  8.879065248182680e-21, -3.636111912582064e-22,  7.424544763953971e-11, -3.056337797979749e-11,  6.701942051690409e-12, -9.977217278471418e-13,
  1.123537856308464e-13, -1.017463878801156e-14,  7.707140693848868e-16, -5.018955785779645e-17,  2.867084463404349e-18, -1.459117318944565e-19,  6.696862799556252e-21,
 -2.795738263491471e-22,  4.636890316678890e-11, -1.942574931069818e-11,  4.343504349747993e-12, -6.594829477323851e-13,  7.572882872526997e-14, -6.991047870642089e-15,
  5.396545087964541e-16, -3.579947165198931e-17,  2.082493218741854e-18, -1.078829347112330e-19,  5.038424557365241e-21, -2.139463954514183e-22,  2.952251029351425e-11,
 -1.255574332951838e-11,  2.854992104136238e-12, -4.409193495824463e-13,  5.149310226711225e-14, -4.833416824102126e-15,  3.792492090634729e-16, -2.556510051513520e-17,
  1.510703081313592e-18, -7.947591684403292e-20,  3.768155099505571e-21, -1.623822501975688e-22,  1.903596748021600e-11, -8.198493961885633e-12,  1.890739942293596e-12,
 -2.962147063079717e-13,  3.508909999675866e-14, -3.340142822824979e-15,  2.657161746628820e-16, -1.815562914299433e-17,  1.087173682158054e-18, -5.794242611969275e-20,
  2.782386138184385e-21, -1.214023694532762e-22,  1.227034311679437e-11, -5.338618525282399e-12,  1.245361780794043e-12, -1.973851570327770e-13,  2.365325824061287e-14,
 -2.277325747622736e-15,  1.832042829860525e-16, -1.265600429967441e-17,  7.660548627353674e-19, -4.126110423901654e-20,  2.001948883201918e-21, -8.823701635893832e-23,
  7.695666385714133e-12, -3.374301816856121e-12,  7.940572604470739e-13, -1.269794158064885e-13,  1.535142787702995e-14, -1.490973419478388e-15,  1.209773085431664e-16,
 -8.427917696034719e-18,  5.143620382390842e-19, -2.792960882649559e-20,  1.365909549879917e-21, -6.067162405798319e-23,  4.392163954612794e-12, -1.936161505082368e-12,
  4.583972336965265e-13, -7.375651494913509e-14,  8.971754359253591e-15, -8.766466630326298e-16,  7.155519627125893e-17, -5.014102257981974e-18,  3.077720447533184e-19,
 -1.680598139359190e-20,  8.264400378945449e-22, -3.690715805583666e-23,  1.775506665367941e-12, -7.850117916448084e-13,  1.864833746604103e-13, -3.010838211569163e-14,
  3.674896484108096e-15, -3.602910912966400e-16,  2.950579165451909e-17, -2.074294623801462e-18,  1.277293836855510e-19, -6.996534079910042e-21,  3.451127424054506e-22,
 -1.545825058028280e-23,  5.584333668345632e-02, -1.289573309627683e-04,  3.084110725056766e-07, -7.593691119239406e-10,  1.911607781746456e-12, -4.888120881484700e-15,
  1.262614634031094e-17, -3.280802346203885e-20,  8.549038272213351e-23, -2.229490607056444e-25,  5.810446340212438e-28, -1.512113103864414e-30,  5.383464599285907e-02,
 -1.575280519456956e-04,  5.413639492478327e-07, -1.933840171496344e-09,  6.852542242234692e-12, -2.381601289690209e-14,  8.115271826562742e-17, -2.717023511889576e-19,
  8.958692849387674e-22, -2.914799705440294e-24,  9.372630606537267e-27, -2.982230126227202e-29,  5.003477224898362e-02, -2.081414844948857e-04,  1.012964674027706e-06,
 -4.736336237819712e-09,  2.102514661801079e-11, -8.952033743924886e-14,  3.687186861246736e-16, -1.477714589671542e-18,  5.786138524014431e-21, -2.220317108834614e-23,
  8.369486171146725e-26, -3.104988297205402e-28,  4.483940254469477e-02, -2.695159115593980e-04,  1.718946566102596e-06, -9.925029627860107e-09,  5.320474192085005e-11,
 -2.699430959721563e-13,  1.311221199881237e-15, -6.143999501184103e-18,  2.792282902409284e-20, -1.235895376834384e-22,  5.344482530024266e-25, -2.263767985228057e-27,
  3.875370783825439e-02, -3.285710547832089e-04,  2.623437947338739e-06, -1.827776711169084e-08,  1.162713971845196e-10, -6.914064332677576e-13,  3.897507727140939e-15,
 -2.102494484005275e-17,  1.092766752089899e-19, -5.500196578169817e-22,  2.691545274162130e-24, -1.284551386171793e-26,  3.231095999644913e-02, -3.736152305764908e-04,
  3.645099064321625e-06, -3.022231874360013e-08,  2.252133438037292e-10, -1.550286080431303e-12,  1.002374123330787e-14, -6.156526221184675e-17,  3.620967817954267e-19,
 -2.051662779241526e-21,  1.125107448846466e-23, -5.993413311479333e-26,  2.599666489875654e-02, -3.968247970764841e-04,  4.661131890680504e-06, -4.548931481271605e-08,
  3.929780099862510e-10, -3.101275874928744e-12,  2.279288773987392e-14, -1.580374275163754e-16,  1.043325686897542e-18, -6.603210967769456e-21,  4.027711084462632e-23,
 -2.377551486375658e-25,  2.019275996039077e-02, -3.954128318832147e-04,  5.530155241361505e-06, -6.292877445689477e-08,  6.248151666139475e-10, -5.608611248244981e-12,
  4.651299845957510e-14, -3.615715290498313e-16,  2.661821934715825e-18, -1.870018987438237e-20,  1.261093950988876e-22, -8.201333727353213e-25,  1.514938416780317e-02,
 -3.713798414614933e-04,  6.125624451970541e-06, -8.060034935628042e-08,  9.130322278841598e-10, -9.260387151001285e-12,  8.612547521158708e-14, -7.462743593900398e-16,
  6.092939575655356e-18, -4.726637580204473e-20,  3.506467003961892e-22, -2.500160582259267e-24,  1.098396909613968e-02, -3.301858261838360e-04,  6.366786435285598e-06,
 -9.614908247164129e-08,  1.234644377332283e-09, -1.406723052426838e-11,  1.459412943729310e-13, -1.402574685739366e-15,  1.264010164639613e-17, -1.077913768785584e-19,
  8.758875279241863e-22, -6.818792300339167e-24,  7.701339536626129e-03, -2.789280876935736e-04,  6.235921046471589e-06, -1.073571225464682e-07,  1.553709053925319e-09,
 -1.978441395516288e-11,  2.278822939354596e-13, -2.418412501860436e-15,  2.395809285174520e-17, -2.237092693427728e-19,  1.983625482880059e-21, -1.679990841866037e-23,
  5.225507735184699e-03, -2.246104380621954e-04,  5.777105608226023e-06, -1.126824585232365e-07,  1.828340953911679e-09, -2.589844313832351e-11,  3.297870532113767e-13,
 -3.849576722738107e-15,  4.176603150969486e-17, -4.255276108700594e-19,  4.103537710275852e-21, -3.768732426918447e-23,  3.433956837519927e-03, -1.729072351305701e-04,
  5.079211317516322e-06, -1.116010818002082e-07,  2.020367219239150e-09, -3.169959036269455e-11,  4.445296250978880e-13, -5.686969612507757e-15,  6.734713223255862e-17,
 -7.463027538899566e-19,  7.803410902941933e-21, -7.749060931384062e-23,  2.187518507049908e-03, -1.275723083786605e-04,  4.250849248345186e-06, -1.046534815237841e-07,
  2.104371144993921e-09, -3.642769476871388e-11,  5.605421858791586e-13, -7.833449393043655e-15,  1.009431848256737e-16, -1.213102642636080e-18,  1.371516283611536e-20,
 -1.468723415615811e-22,  1.352149409244961e-03, -9.042360647550806e-05,  3.395996237595475e-06, -9.321334176635053e-08,  2.073111292246663e-09, -3.944651499125317e-11,
  6.638370620787902e-13, -1.010261323143763e-14,  1.412526749475516e-16, -1.835977775097423e-18,  2.238668858910336e-20, -2.578918210210018e-22,  8.118572240912045e-04,
 -6.170884094660235e-05,  2.596660983750036e-06, -7.908912162009613e-08,  1.937815199380348e-09, -4.038865523206155e-11,  7.410056772044395e-13, -1.224519522254034e-14,
  1.852673452948630e-16, -2.597889346416381e-18,  3.408161452590849e-20, -4.213876569030129e-22,  4.740505920450173e-04, -4.063210739776608e-05,  1.905065782633393e-06,
 -6.410283050056276e-08,  1.723819090876238e-09, -3.922509633972346e-11,  7.822417799387302e-13, -1.399810639921927e-14,  2.285957799643698e-16, -3.449877239816213e-18,
  4.858453681273444e-20, -6.433347526453147e-22,  2.695326588606277e-04, -2.586663773475762e-05,  1.344322652899763e-06, -4.976427992835292e-08,  1.463526939373208e-09,
 -3.624363135331046e-11,  7.834127866779607e-13, -1.514160586720471e-14,  2.662475230186911e-16, -4.314677162856858e-18,  6.508855514167774e-20, -9.211531155474583e-22,
  1.494295503720119e-04, -1.595297967839356e-05,  9.145843887917209e-07, -3.709901605923950e-08,  1.189149307882592e-09, -3.195358401175926e-11,  7.465867513547620e-13,
 -1.554645244164920e-14,  2.936656761539660e-16, -5.099164868980313e-18,  8.222894098717782e-20, -1.241338103617780e-21,  8.089902481278187e-05, -9.551223784912431e-06,
  6.012928615854874e-07, -2.662646697574842e-08,  9.271843510599883e-10, -2.695552585482745e-11,  6.790087180566188e-13, -1.519684186299554e-14,  3.076905937066878e-16,
 -5.712601775266325e-18,  9.828098654830842e-20, -1.579628095577485e-21,  4.283739578753330e-05, -5.562713238501499e-06,  3.829153214019199e-07, -1.844430113538178e-08,
  6.955670811326651e-10, -2.181784878082673e-11,  5.910312309948049e-13, -1.418426647568888e-14,  3.071627145996755e-16, -6.085293568307446e-18,  1.114794025081124e-19,
 -1.904177375990887e-21,  2.222369556118004e-05, -3.158189646713881e-06,  2.367509638085259e-07, -1.236223131656997e-08,  5.033795106769526e-10, -1.698998373670918e-11,
  4.937420554796408e-13, -1.267755194755388e-14,  2.930118402247214e-16, -6.182076085136081e-18,  1.203689162982749e-19, -2.181134654290492e-21,  1.131653871510450e-05,
 -1.751666745792759e-06,  1.424568607807020e-07, -8.037313238800723e-09,  3.523506227102674e-10, -1.276338429341019e-11,  3.969612042601285e-13, -1.088094661095788e-14,
  2.678631668115621e-16, -6.007031047538032e-18,  1.240832776912342e-19, -2.381115881267425e-21,  5.667045166784169e-06, -9.512477254641216e-07,  8.362305553242922e-08,
 -5.081696149528850e-09,  2.391787133529705e-10, -9.274838035581106e-12,  3.080025577050326e-13, -8.993332817874982e-15,  2.353361885077702e-16, -5.598986759813779e-18,
  1.224773118211237e-19, -2.484720934211198e-21,  2.796651631082408e-06, -5.069495568328098e-07,  4.800549934997867e-08, -3.132641786594571e-09,  1.578679092851931e-10,
 -6.537273530306301e-12,  2.312710934489609e-13, -7.178204097091691e-15,  1.992708392171541e-16, -5.020249449191773e-18,  1.160895253120106e-19, -2.485611975181064e-21,
  1.363021844028252e-06, -2.657667334627701e-07,  2.701941037796140e-08, -1.887806652937971e-09,  1.015921186592784e-10, -4.481567627140094e-12,  1.685228199567683e-13,
 -5.548480020011569e-15,  1.630833116232080e-16, -4.342564247247240e-18,  1.059668649500905e-19, -2.390545636410735e-21,  6.575740152279361e-07, -1.373960918748700e-07,
  1.494882802114587e-08, -1.115096320946759e-09,  6.391608601626422e-11, -2.996495109034144e-12,  1.195051387243486e-13, -4.165090968964172e-15,  1.293663723344346e-16,
 -3.634225452038495e-18,  9.341767621799341e-20, -2.216728986475888e-21,  3.147803643002447e-07, -7.022587072722183e-08,  8.151575516154496e-09, -6.473860263812400e-10,
  3.942335964548954e-11, -1.959616983261033e-12,  8.270618979771314e-14, -3.045131485681308e-15,  9.975194617719851e-17, -2.950973613060398e-18,  7.976509894949990e-20,
 -1.987566527077076e-21,  1.498933916046494e-07, -3.558094046545574e-08,  4.393051224073287e-09, -3.704447536634951e-10,  2.390675311423985e-11, -1.257024513588738e-12,
  5.602218722408696e-14, -2.174545374483654e-15,  7.498242017091881e-17, -2.331605141338063e-18,  6.615565835870138e-20, -1.728087079031891e-21,  7.118747289699089e-08,
 -1.791923522136026e-08,  2.346376915144663e-09, -2.095223092218652e-10,  1.429425756427889e-11, -7.932115095413710e-13,  3.724890215780457e-14, -1.521151036176054e-15,
  5.510533663812854e-17, -1.797772064028143e-18,  5.344898145840505e-20, -1.461120413850808e-21,  3.380994778127128e-08, -8.995389950665657e-09,  1.245602182237620e-09,
 -1.174744622175338e-10,  8.451728179546534e-12, -4.938326005986306e-13,  2.438209556071546e-14, -1.045411912835940e-15,  3.970897031250310e-17, -1.356631783326575e-18,
  4.218712512122483e-20, -1.204823956388009e-21,  1.610320010903740e-08, -4.514019623831390e-09,  6.591387950843927e-10, -6.548487663368533e-11,  4.956280925449721e-12,
 -3.042287920671055e-13,  1.575847427041633e-14, -7.079289059351229e-16,  2.813925082876255e-17, -1.004837953946900e-18,  3.262398650417873e-20, -9.716631397975645e-22,
  7.713283925896948e-09, -2.270990744934066e-09,  3.487166466409037e-10, -3.640101311358501e-11,  2.891249274979630e-12, -1.860121035310186e-13,  1.008620657880582e-14,
 -4.737571909891058e-16,  1.966673331624550e-17, -7.326425326081524e-19,  2.478868664095633e-20, -7.685850141121754e-22,  3.726273012988541e-09, -1.148824335988276e-09,
  1.849938869519733e-10, -2.023746143069758e-11,  1.682785061484877e-12, -1.132117970929759e-13,  6.411996566328747e-15, -3.142365564640213e-16,  1.359584677916362e-17,
 -5.273455043497145e-19,  1.855922223771180e-20, -5.979533508332995e-22,  1.820837009887586e-09, -5.860802127198248e-10,  9.870040585062278e-11, -1.128646713084615e-11,
  9.801008363724255e-13, -6.879069558659327e-14,  4.060485651247184e-15, -2.071797483455785e-16,  9.323422934134335e-18, -3.757774059320847e-19,  1.372981339415347e-20,
 -4.588109519533885e-22,  9.025479864742245e-10, -3.024064020887988e-10,  5.311640871712180e-11, -6.332704512778577e-12,  5.728953148185430e-13, -4.185128252373198e-14,
  2.568756702270195e-15, -1.361614329207269e-16,  6.359897030543854e-18, -2.658224556831074e-19,  1.006336742414923e-20, -3.481352802879582e-22,  4.550763377687333e-10,
 -1.582664507942528e-10,  2.891501951519320e-11, -3.584943968187946e-12,  3.370281944257363e-13, -2.556471895212402e-14,  1.627893662888293e-15, -8.944554612107477e-17,
  4.327074065371818e-18, -1.871645300333827e-19,  7.326923881583479e-21, -2.618882856955225e-22,  2.340298286999450e-10, -8.424206376388159e-11,  1.596550585074428e-11,
 -2.053102343876785e-12,  2.000811386185937e-13, -1.572082307925237e-14,  1.036143871341029e-15, -5.888116557382448e-17,  2.943774072253251e-18, -1.314930410807777e-19,
  5.311968865349859e-21, -1.957820241538747e-22,  1.230567778557085e-10, -4.571981684311180e-11,  8.963933566899815e-12, -1.192499493188261e-12,  1.201619800007527e-13,
 -9.755926055933039e-15,  6.639644575641863e-16, -3.893392285560890e-17,  2.007158184618654e-18, -9.238672553011325e-20,  3.843294028873456e-21, -1.457656966010556e-22,
  6.630373456104057e-11, -2.535617596669526e-11,  5.129057273185239e-12, -7.040150623838548e-13,  7.316313191521643e-14, -6.122767721015670e-15,  4.292490392605707e-16,
 -2.591215037097430e-17,  1.374341009531887e-18, -6.504161575781252e-20,  2.780297543996766e-21, -1.082846241056141e-22,  3.667263098445461e-11, -1.439650447019081e-11,
  2.996307236773798e-12, -4.232122836675264e-13,  4.524221472058522e-14, -3.892766226153558e-15,  2.804400796538328e-16, -1.738636519309619e-17,  9.465176931999808e-19,
 -4.595278596083808e-20,  2.014003023497041e-21, -8.037602168759154e-23,  2.084673703560487e-11, -8.378389110688187e-12,  1.789274804023138e-12, -2.593630217746227e-13,
  2.844643655950944e-14, -2.510088406755554e-15,  1.853562068989452e-16, -1.177319093360067e-17,  6.563165295743755e-19, -3.261208738216817e-20,  1.462162091477103e-21,
 -5.966199732932924e-23,  1.218371150459928e-11, -4.999914991652715e-12,  1.092631009506862e-12, -1.621002976030729e-13,  1.819206155642595e-14, -1.641951602267710e-15,
  1.239687866726810e-16, -8.047143944077074e-18,  4.582578864610848e-19, -2.325048933236593e-20,  1.063938427882765e-21, -4.428719674272333e-23,  7.314279962477792e-12,
 -3.056906642835534e-12,  6.816945320606323e-13, -1.032258090701129e-13,  1.182208807102953e-14, -1.088538807681720e-15,  8.381260450041751e-17, -5.546080574206755e-18,
  3.218351643334038e-19, -1.663286593704069e-20,  7.749920172620430e-22, -3.283382149447398e-23,  4.497328857139553e-12, -1.909292949790684e-12,  4.332858779198567e-13,
 -6.678198346760704e-14,  7.783745734627820e-15, -7.292021779053865e-16,  5.710700571821595e-17, -3.842384988890575e-18,  2.266412754812408e-19, -1.190199306747342e-20,
  5.633193227557768e-22, -2.423401381590207e-23,  2.814496137306581e-12, -1.210645777537786e-12,  2.788088037187835e-13, -4.361798794286374e-14,  5.159662061430089e-15,
 -4.904718034904559e-16,  3.896534902763059e-17, -2.658861179626205e-18,  1.590081742235398e-19, -8.463805700061519e-21,  4.059261859713808e-22, -1.769012629245731e-23,
  1.770121793822545e-12, -7.695188346378150e-13,  1.793432776268651e-13, -2.839865319846965e-14,  3.399939645323687e-15, -3.270458050014610e-16,  2.628630718228432e-17,
 -1.814299077031334e-18,  1.097231751179892e-19, -5.904912560962288e-21,  2.862645420331946e-22, -1.260712443677569e-23,  1.089226315288918e-12, -4.773571228033006e-13,
  1.122719529370664e-13, -1.794357461785697e-14,  2.168114432328780e-15, -2.104575459139490e-16,  1.706725963072742e-17, -1.188364924200169e-18,  7.248908129370839e-20,
 -3.934116192263723e-21,  1.923035795750831e-22, -8.537666006594437e-24,  6.134312924362241e-13, -2.703438526392417e-13,  6.398663187367939e-14, -1.029242187033706e-14,
  1.251598362390732e-15, -1.222599144187670e-16,  9.976413404302200e-18, -6.988793952881025e-19,  4.288605622919313e-20, -2.341158562197393e-21,  1.150960499182858e-22,
 -5.138593084090666e-24,  2.461356293231474e-13, -1.088107025572047e-13,  2.584465491219077e-14, -4.172070447118155e-15,  5.091465687679690e-16, -4.990972125934286e-17,
  4.086706304025838e-18, -2.872578188267172e-19,  1.768594482583245e-20, -9.686284673047607e-22,  4.777194189848998e-23, -2.139492933951564e-24,  5.533238494910731e-02,
 -1.265259794672820e-04,  2.994789838424794e-07, -7.295493291263550e-10,  1.816802797388760e-12, -4.595814990943284e-15,  1.174464601745168e-17, -3.019639110341963e-20,
  7.786702575538459e-23, -2.009842940853874e-25,  5.184780048365945e-28, -1.335723773433489e-30,  5.321305122091083e-02, -1.532881363138780e-04,  5.188003285358203e-07,
 -1.827906764080987e-09,  6.395098755532446e-12, -2.195649461828495e-14,  7.393112836100184e-17, -2.446435913326681e-19,  7.973802531726162e-22, -2.564862995212100e-24,
  8.154529588441319e-27, -2.565688210400708e-29,  4.921806168234358e-02, -2.002595254176735e-04,  9.580894897418680e-07, -4.413790037411860e-09,  1.931998597650107e-11,
 -8.114739450771176e-14,  3.298191604866748e-16, -1.304726852204077e-18,  5.043932760732167e-21, -1.911330651980556e-23,  7.116022774502441e-26, -2.607861236061317e-28,
  4.378810764456589e-02, -2.562266682509427e-04,  1.604781086390857e-06, -9.115291545603266e-09,  4.810714339703606e-11, -2.404411703094073e-13,  1.151058100150603e-15,
 -5.317717761007755e-18,  2.383556326361493e-20, -1.040776003085721e-22,  4.441118979023729e-25, -1.856603902213287e-27,  3.748005281903252e-02, -3.084302770895611e-04,
  2.414826400670549e-06, -1.652316071158238e-08,  1.033329529427093e-10, -6.045530642587855e-13,  3.354930495551978e-15, -1.782518069776478e-17,  9.128501656956539e-20,
 -4.528635373525836e-22,  2.184904559543529e-24, -1.028332269389546e-26,  3.087260724163439e-02, -3.458461256628953e-04,  3.303069325297357e-06, -2.685444344627030e-08,
  1.964801782483382e-10, -1.329158141130819e-12,  8.451620276582127e-15, -5.107797138861449e-17,  2.957401023154076e-19, -1.650244803307550e-21,  8.915370595931809e-24,
 -4.680058512383159e-26,  2.448063155582997e-02, -3.616168670845810e-04,  4.151031483564442e-06, -3.966958821672935e-08,  3.360829611612469e-10, -2.603783497740723e-12,
  1.880161685870857e-14, -1.281628811935495e-16,  8.322538483429867e-19, -5.183429114581178e-21,  3.112524568697647e-23, -1.809353762963952e-25,  1.869503769558372e-02,
 -3.540303688445845e-04,  4.831477986298160e-06, -5.377173327215208e-08,  5.230332428959912e-10, -4.604751077275419e-12,  3.748683914827579e-14, -2.862574202717904e-16,
  2.071340352101083e-18, -1.431008619840534e-20,  9.494072857475395e-23, -6.076615907714472e-25,  1.375608209115904e-02, -3.260086977114795e-04,  5.240304792071345e-06,
 -6.736791541004440e-08,  7.469095776446556e-10, -7.423572420155848e-12,  6.772174566553884e-14, -5.760201910291303e-16,  4.619369012860836e-18, -3.521743895137335e-20,
  2.568780907769461e-22, -1.801588992525087e-24,  9.758234437265284e-03, -2.835510762693973e-04,  5.322820789867047e-06, -7.846779572263019e-08,  9.853664767739149e-10,
 -1.099355553938878e-11,  1.117936123323681e-13, -1.053963740955608e-15,  9.324041048340657e-18, -7.809831536697554e-20,  6.236306428913076e-22, -4.773100949572365e-24,
  6.677802057347687e-03, -2.337995023208082e-04,  5.084637153325688e-06, -8.538768026965263e-08,  1.207645601250369e-09, -1.504812078883872e-11,  1.697905933968523e-13,
 -1.766634574088452e-15,  1.717082173528674e-17, -1.574019406017025e-19,  1.370893946573367e-21, -1.140969874110634e-23,  4.411589298341833e-03, -1.833417856520950e-04,
  4.584642916951312e-06, -8.717681344364867e-08,  1.381514482132448e-09, -1.913908324745328e-11,  2.386154939620297e-13, -2.729471718414570e-15,  2.904100734302243e-17,
 -2.903461770165548e-19,  2.749089993490521e-21, -2.480183609116951e-23,  2.815830327138311e-03, -1.371255259933174e-04,  3.914771516593767e-06, -8.381753075076790e-08,
  1.481325056514525e-09, -2.272099949823249e-11,  3.118207197710340e-13, -3.907584905083952e-15,  4.536304360757926e-17, -4.931063570687248e-19,  5.060626073106273e-21,
 -4.935010907145900e-23,  1.738029834772973e-03, -9.806745899336473e-05,  3.175163539201348e-06, -7.614951678511857e-08,  1.494309142647721e-09, -2.527856903251945e-11,
  3.805502836378300e-13, -5.207610827926672e-15,  6.576330022612030e-17, -7.750320138086062e-19,  8.598007004153374e-21, -9.039495823416068e-23,  1.038430276799442e-03,
 -6.722076809436099e-05,  2.452981908203617e-06, -6.557707304737768e-08,  1.422990583833748e-09, -2.645353551389822e-11,  4.354232162475954e-13, -6.487241624241355e-15,
  8.886748837465897e-17, -1.132486479797987e-18,  1.354689071902406e-20, -1.531828249829617e-22,  6.012281013766386e-04, -4.426039152234662e-05,  1.809803529824299e-06,
 -5.368553435394847e-08,  1.283238497946448e-09, -2.612681384741891e-11,  4.687648505008387e-13, -7.582390469554585e-15,  1.123806132654858e-16, -1.544783536526486e-18,
  1.987879378836423e-20, -2.412223077062845e-22,  3.377223470305953e-04, -2.805323914009738e-05,  1.278402795409447e-06, -4.189743570538908e-08,  1.099137273070108e-09,
 -2.443065709574997e-11,  4.764189599347185e-13, -8.344320427764186e-15,  1.334774021354189e-16, -1.974531870801093e-18,  2.727405836902879e-20, -3.544259941132491e-22,
  1.842901120210973e-04, -1.715176705816507e-05,  8.666823691770433e-07, -3.125376277877222e-08,  8.967584292970446e-10, -2.169389837498132e-11,  4.585454184734207e-13,
 -8.674407992229805e-15,  1.494068930200194e-16, -2.373298530738287e-18,  3.511542871555693e-20, -4.877096537276933e-22,  9.783121090456467e-05, -1.013651720572788e-05,
  5.652560150548815e-07, -2.234251765854033e-08,  6.988422115160609e-10, -1.834653172119923e-11,  4.192249637102075e-13, -8.545005668277278e-15,  1.581189984973419e-16,
 -2.691401420045569e-18,  4.257173538238375e-20, -6.307404309488751e-22,  5.059968221996836e-05, -5.802621674237035e-06,  3.555105079614448e-07, -1.534582259172423e-08,
  5.216021816622780e-10, -1.481877219473543e-11,  3.651369442159452e-13, -8.000568956783364e-15,  1.587074412265739e-16, -2.888860044168123e-18,  4.875701216584168e-20,
 -7.692058203002081e-22,  2.554037297209793e-05, -3.224276199264558e-06,  2.161289227822931e-07, -1.015274986831645e-08,  3.738692134547066e-10, -1.146359243561610e-11,
  3.038468575526224e-13, -7.140776929219525e-15,  1.515378008798621e-16, -2.943984539436100e-18,  5.291893845853804e-20, -8.874188131958403e-22,  1.260329372713034e-05,
 -1.742821621556628e-06,  1.273117650825324e-07, -6.486685750320215e-09,  2.580359524170096e-10, -8.516848464860400e-12,  2.422567852552858e-13, -6.093209711744613e-15,
  1.380512075125051e-16, -2.857022170975818e-18,  5.459752954275527e-20, -9.715354769067376e-22,  6.091754735006187e-06, -9.184522789672057e-07,  7.284163146831347e-08,
 -4.012626813200867e-09,  1.719436662329176e-10, -6.093769456385479e-12,  1.855864055333094e-13, -4.985088295901755e-15,  1.203442230967325e-16, -2.648190428061937e-18,
  5.370661994959320e-20, -1.012402751058182e-21,  2.889906189082263e-06, -4.729866983208481e-07,  4.058178178240863e-08, -2.409572829919908e-09,  1.109212898626651e-10,
 -4.210644402397628e-12,  1.369919109837056e-13, -3.921696933125066e-15,  1.006793498814892e-16, -2.351367549254590e-18,  5.052033374100158e-20, -1.007197120279358e-21,
  1.348490617069108e-06, -2.386028141677364e-07,  2.207179011631981e-08, -1.408375651381538e-09,  6.946430483326422e-11, -2.817646770135529e-12,  9.771495942633632e-14,
 -2.975111599531425e-15,  8.106833793870619e-17, -2.005871489525461e-18,  4.557978349730161e-20, -9.594750211078974e-22,  6.203458727024070e-07, -1.182021722084095e-07,
  1.175026694344742e-08, -8.034403156732402e-10,  4.234913740999742e-11, -1.831211162850099e-12,  6.754573180751588e-14, -2.182855304831817e-15,  6.301305835861935e-17,
 -1.648830607871007e-18,  3.955760471533921e-20, -8.778065767614496e-22,  2.820328853611586e-07, -5.765451413078445e-08,  6.139706198227193e-09, -4.486070477471345e-10,
  2.520623734467391e-11, -1.159217747747759e-12,  4.538135502648987e-14, -1.553526096589671e-15,  4.742011563389136e-17, -1.309865336284468e-18,  3.312289857948368e-20,
 -7.735697697569035e-22,  1.270463326658525e-07, -2.776392940330868e-08,  3.157638188268293e-09, -2.458726379259963e-10,  1.469012693623378e-11, -7.168895060393735e-13,
  2.972303553440736e-14, -1.075676417895563e-15,  3.465346007002180e-17, -1.008681167264329e-18,  2.683890282539022e-20, -6.586134785575668e-22,  5.685841217536700e-08,
 -1.323723800901554e-08,  1.603088304342893e-09, -1.326706841028534e-10,  8.408160764105155e-12, -4.344226750814726e-13,  1.903538162713110e-14, -7.268280403711214e-16,
  2.466598618390837e-17, -7.552148624186332e-19,  2.110801751795710e-20, -5.433691492128003e-22,  2.535278484458198e-08, -6.266974125876852e-09,  8.058196857955754e-10,
 -7.069423270222039e-11,  4.740985346749586e-12, -2.587527414378945e-13,  1.195701245827648e-14, -4.807356392142240e-16,  1.715344854705284e-17, -5.514467138941491e-19,
  1.616203733991782e-20, -4.357165805574515e-22,  1.129623370306815e-08, -2.955162192516064e-09,  4.022965810513942e-10, -3.731588139268021e-11,  2.641748244753549e-12,
 -1.519616896406259e-13,  7.389898780918456e-15, -3.122211929899802e-16,  1.169108771629906e-17, -3.939068232549008e-19,  1.208484801987165e-20, -3.406258145355739e-22,
  5.044783582526161e-09, -1.392277191325828e-09,  2.001056891736116e-10, -1.957446906334135e-11,  1.459345420382487e-12, -8.827680878069629e-14,  4.508065196665055e-15,
 -1.997436076952701e-16,  7.833788487668530e-18, -2.761161092995361e-19,  8.851592846221812e-21, -2.603998701774385e-22,  2.265238241255937e-09, -6.574792499977882e-10,
  9.949054979701643e-11, -1.023723429418409e-11,  8.018213172304950e-13, -5.088927629441153e-14,  2.723159730915714e-15, -1.262764331681047e-16,  5.176949718923282e-18,
 -1.905267363363812e-19,  6.370585894243603e-21, -1.952632658699742e-22,  1.025976703362563e-09, -3.122234769017665e-10,  4.960644455105412e-11, -5.355469164720504e-12,
  4.396140685609509e-13, -2.920696997370076e-14,  1.634140885863952e-15, -7.914060586085947e-17,  3.384813906306346e-18, -1.298204659769023e-19,  4.519129244182458e-21,
 -1.440584441422472e-22,  4.702394697451710e-10, -1.495905349414080e-10,  2.488637777587856e-11, -2.811679865336642e-12,  2.413036912868785e-13, -1.674326660090935e-14,
  9.773236355441103e-16, -4.932729072871370e-17,  2.196443834968461e-18, -8.761945005864669e-20,  3.169386193074599e-21, -1.048824676234644e-22,  2.188087090233355e-10,
 -7.254765211604749e-11,  1.260318881105915e-11, -1.486312712957410e-12,  1.330353612577118e-13, -9.618028926819602e-15,  5.843895008224474e-16, -3.067259053283993e-17,
  1.418975156546588e-18, -5.875601161967405e-20,  2.204161775838413e-21, -7.557779102964790e-23,  1.036956663992765e-10, -3.572954574547287e-11,  6.463948811792093e-12,
 -7.936443618681970e-13,  7.390328313838642e-14, -5.553810177082526e-15,  3.504532586746058e-16, -1.908611346359034e-17,  9.153897171822307e-19, -3.926298492371065e-20,
  1.524478802765961e-21, -5.405687872501264e-23,  5.020525368966345e-11, -1.792564257160436e-11,  3.367978023727875e-12, -4.293958006801150e-13,  4.149384899716073e-14,
 -3.233456476194279e-15,  2.114040919633261e-16, -1.191951476211857e-17,  5.913724106743992e-19, -2.621904976800047e-20,  1.051496582876798e-21, -3.848109991481156e-23,
  2.490553518934790e-11, -9.188521775649639e-12,  1.788010323071137e-12, -2.360852750741721e-13,  2.361421706448924e-14, -1.903448101348832e-15,  1.286345784057594e-16,
 -7.491281154105557e-18,  3.836172557019455e-19, -1.754229809702157e-20,  7.251212254908853e-22, -2.733164639867812e-23,  1.269252571052727e-11, -4.825047846485652e-12,
  9.697394551092270e-13, -1.322513606576354e-13,  1.365702422453070e-14, -1.135834984146138e-15,  7.914849270060422e-17, -4.749693554851529e-18,  2.504654095292927e-19,
 -1.178682064373299e-20,  5.010812212241151e-22, -1.941145541951405e-23,  6.660064749823426e-12, -2.601529567670650e-12,  5.385212391867217e-13, -7.565105074695544e-14,
  8.044068498175596e-15, -6.885136679672924e-16,  4.934780279072043e-17, -3.044122837151933e-18,  1.649147753319022e-19, -7.968398083779714e-21,  3.476140524244842e-22,
 -1.381003513773380e-23,  3.604179342914793e-12, -1.442643697900354e-12,  3.067163843618093e-13, -4.426101108870252e-14,  4.833048111326413e-15, -4.246192683198328e-16,
  3.122313049396886e-17, -1.974987717696313e-18,  1.096545456129951e-19, -5.427208830335404e-21,  2.423922658469129e-22, -9.853489044402944e-24,  2.013171703083015e-12,
 -8.234809624948000e-13,  1.793121698072019e-13, -2.650670206445454e-14,  2.964211183389950e-15, -2.666072314331947e-16,  2.006044682577879e-17, -1.297836800018626e-18,
  7.366679467636102e-20, -3.725722245943186e-21,  1.699588677834940e-22, -7.053254301419984e-24,  1.160098362588342e-12, -4.836337968228214e-13,  1.075516150397788e-13,
 -1.624045670689318e-14,  1.854816803936992e-15, -1.703214652518597e-16,  1.307910411895873e-17, -8.632240705219456e-19,  4.996492353676108e-20, -2.575838309795923e-21,
  1.197273838381767e-22, -5.060455866321184e-24,  6.879646101135863e-13, -2.915255081812144e-13,  6.602042932771616e-14, -1.015439311930998e-14,  1.181092072607737e-15,
 -1.104229013865742e-16,  8.630471975412662e-18, -5.795603688521097e-19,  3.411994431955239e-20, -1.788459993440173e-21,  8.449341239029485e-23, -3.628460634855342e-24,
  4.173771564275890e-13, -1.792985939278166e-13,  4.123156023031317e-14, -6.440876510112352e-15,  7.607865313440929e-16, -7.221516633761492e-17,  5.728989702227004e-18,
 -3.903850295118273e-19,  2.331460432563025e-20, -1.239362675903876e-21,  5.936312735719611e-23, -2.583757666225058e-24,  2.558701034937334e-13, -1.111381151542354e-13,
  2.587674777883531e-14, -4.093525765576447e-15,  4.896094179403117e-16, -4.705139677316682e-17,  3.778215092417984e-18, -2.605357809874927e-19,  1.574224368839148e-20,
 -8.464471665266257e-22,  4.099966582758278e-23, -1.804115525102451e-24,  1.543533103232311e-13, -6.761130913900720e-14,  1.589266028971952e-14, -2.538515386958679e-15,
  3.065492747595678e-16, -2.973948648059638e-17,  2.410393647370500e-18, -1.677389267193098e-19,  1.022636355887286e-20, -5.547089315938943e-22,  2.710063022266131e-23,
 -1.202570404905685e-24,  8.573024153663084e-14, -3.777179965154606e-14,  8.937328980784367e-15, -1.437146095704401e-15,  1.747083748124449e-16, -1.706081557854780e-17,
  1.391743095123810e-18, -9.746708079434354e-20,  5.979228252585994e-21, -3.263137560005807e-22,  1.603772365733377e-23, -7.158249697469371e-25,  3.413253762355540e-14,
 -1.508715323407684e-14,  3.582941581251728e-15, -5.782988211691050e-16,  7.056268427815243e-17, -6.915911921406145e-18,  5.662007395694802e-19, -3.979260012320924e-20,
  2.449587666613130e-21, -1.341396100215087e-22,  6.614676844352188e-24, -2.961989704647699e-25,  5.483101793779653e-02, -1.241646786815245e-04,  2.908958205595452e-07,
 -7.012007822364417e-10,  1.727638154520056e-12, -4.323814452001336e-15,  1.093297165228461e-17, -2.781652270221334e-20,  7.099116128707629e-23, -1.813736851136060e-25,
  4.631763380541817e-28, -1.181366878559639e-30,  5.260806297249007e-02, -1.492237665022889e-04,  4.974651916048840e-07, -1.729004095143590e-09,  5.973172029728966e-12,
 -2.026154757765417e-14,  6.742488947889984e-17, -2.205439737063112e-19,  7.106543383599602e-22, -2.260174527829680e-24,  7.105716503731059e-27, -2.210988940354588e-29,
  4.843202482416734e-02, -1.928015369955221e-04,  9.069265306564053e-07, -4.117235861539093e-09,  1.777332719720208e-11, -7.365250070314029e-14,  2.954468397577385e-16,
 -1.153802584014040e-18,  4.404440455971965e-21, -1.648367884269391e-23,  6.062175358615681e-26, -2.194904144013841e-28,  4.278820271007083e-02, -2.438132243750046e-04,
  1.499861909820720e-06, -8.382595975928463e-09,  4.356294453284295e-11, -2.145196829764230e-13,  1.012300616337601e-15, -4.611653461978846e-18,  2.038978230225322e-20,
 -8.784476002476615e-23,  3.699323179594932e-25, -1.526540196916065e-27,  3.628375167600503e-02, -2.898775623518612e-04,  2.226083152036028e-06, -1.496235106966454e-08,
  9.200829160438408e-11, -5.297083886597187e-13,  2.894385547015664e-15, -1.514888867690037e-17,  7.645182390614461e-20, -3.738857696895478e-22,  1.778728515905182e-24,
 -8.257031525681460e-27,  2.954010378258355e-02, -3.206590927940804e-04,  2.998835272513001e-06, -2.391287268626835e-08,  1.718148619530309e-10, -1.142464585823139e-12,
  7.145465848579494e-15, -4.249983664905001e-17,  2.422833132314770e-19, -1.331642756949285e-21,  7.088405696280446e-24, -3.667386968997410e-26,  2.309768973391721e-02,
 -3.302251451936641e-04,  3.705618102066600e-06, -3.468551698367746e-08,  2.882438574154927e-10, -2.192762192297685e-12,  1.555948020003318e-14, -1.042908755897985e-16,
  6.662660294603851e-19, -4.084193302790961e-21,  2.414698645191851e-23, -1.382543743334927e-25,  1.735232521729200e-02, -3.178240177451294e-04,  4.233540452504738e-06,
 -4.609367498616569e-08,  4.393226115981036e-10, -3.794210509096872e-12,  3.032708323900592e-14, -2.275334748318061e-16,  1.618545939696686e-18, -1.099794431754396e-20,
  7.179593589600316e-23, -4.523222031314372e-25,  1.253104484277904e-02, -2.871274960554793e-04,  4.498965334061768e-06, -5.652202212890460e-08,  6.134665364000643e-10,
 -5.976193899832818e-12,  5.348534955082991e-14, -4.466478466340626e-16,  3.518855159912882e-18, -2.636924050946305e-20,  1.891417321505984e-22, -1.305006117108302e-24,
  8.703589197117959e-03, -2.444827550139690e-04,  4.468992867699049e-06, -6.432458091714888e-08,  7.900992624460143e-10, -8.633360312447738e-12,  8.606921354935621e-14,
 -7.961474920756789e-16,  6.915103885718264e-18, -5.689968987790573e-20,  4.465643173690117e-22, -3.360744914113357e-24,  5.817904073630032e-03, -1.969140480047320e-04,
  4.166660999757273e-06, -6.826740786027492e-08,  9.437261743975458e-10, -1.150952647876332e-11,  1.272356176504822e-13, -1.298158420042416e-15,  1.238123664257572e-17,
 -1.114389244872999e-19,  9.534825116432318e-22, -7.799515227753295e-24,  3.745445549284608e-03, -1.505005490192650e-04,  3.659455956195583e-06, -6.784789235968136e-08,
  1.050314430461934e-09, -1.423335060794199e-11,  1.737690855055768e-13, -1.948142019577155e-15,  2.033018871101135e-17, -1.994839920448610e-19,  1.854739535156195e-21,
 -1.643967941695784e-23,  2.324120847050953e-03, -1.094597424876266e-04,  3.037394651916404e-06, -6.337952175606776e-08,  1.093662544233982e-09, -1.640132232499619e-11,
  2.203180145223842e-13, -2.704816582807936e-15,  3.078549065718494e-17, -3.283097108367652e-19,  3.307472278849232e-21, -3.167757021900188e-23,  1.391302189149975e-03,
 -7.595030463786287e-05,  2.389620766739667e-06, -5.583451043860052e-08,  1.069386613683274e-09, -1.768090632258190e-11,  2.604363360298661e-13, -3.490302634580582e-15,
  4.319972845851466e-17, -4.993241565376860e-19,  5.436053456388709e-21, -5.611564132089774e-23,  8.043087719921370e-04, -5.039436406763192e-05,  1.786888209743715e-06,
 -4.653042284746473e-08,  9.852219155894208e-10, -1.789598114582304e-11,  2.881396562029313e-13, -4.203122612326185e-15,  5.641805800521462e-17, -7.049686557517633e-19,
  8.273731212642923e-21, -9.184043823377580e-23,  4.495082951393169e-04, -3.204590025548899e-05,  1.273323410831832e-06, -3.678822057579581e-08,  8.579094807360540e-10,
 -1.706414517970990e-11,  2.994285575847407e-13, -4.741168398353605e-15,  6.884250120776097e-17, -9.277279511772070e-19,  1.171111806184625e-20, -1.394835309086089e-22,
  2.431573820274017e-04, -1.957158855999517e-05,  8.668410591900472e-07, -2.767042137978070e-08,  7.081806380427560e-10, -1.537648491593570e-11,  2.932307562187535e-13,
 -5.026991244151385e-15,  7.877098637940240e-17, -1.142265781337423e-18,  1.547629962387032e-20, -1.973796024134224e-22,  1.274799932750609e-04, -1.150403410759188e-05,
  5.651406786776283e-07, -1.985249246347071e-08,  5.557471340368388e-10, -1.313335499907012e-11,  2.714658135283229e-13, -5.026433395071102e-15,  8.480475383492528e-17,
 -1.320486183254773e-18,  1.916380921182401e-20, -2.612126919573237e-22,  6.486682290928099e-05, -6.521525656246233e-06,  3.536969527555196e-07, -1.362192084523793e-08,
  4.157593469855305e-10, -1.066349138258280e-11,  2.382980955638211e-13, -4.754430643575264e-15,  8.618277843389085e-17, -1.438020716088221e-18,  2.231144175747266e-20,
 -3.244318711259397e-22,  3.208516056451247e-05, -3.573032504674895e-06,  2.130106973965975e-07, -8.962003640086483e-09,  2.973166633126706e-10, -8.253905610701494e-12,
  1.989302476495922e-13, -4.267155995093254e-15,  8.293132003076068e-17, -1.479950477894986e-18,  2.450326452220089e-20, -3.794385425682663e-22,  1.545318884639423e-05,
 -1.896036273256525e-06,  1.237403595129511e-07, -5.668047091355305e-09,  2.037893858946683e-10, -6.107624885132196e-12,  1.583833953488950e-13, -3.644742220780015e-15,
  7.579344452360789e-17, -1.443861366491678e-18,  2.546496990208748e-20, -4.192240419353642e-22,  7.260298567370464e-06, -9.766511787035289e-07,  6.950589764283164e-08,
 -3.455013734472720e-09,  1.342467058978224e-10, -4.332620624970029e-12,  1.206122281260809e-13, -2.971359489185532e-15,  6.598666516624092e-17, -1.339427827351509e-18,
  2.512036004410192e-20, -4.389332857941928e-22,  3.333993556115680e-06, -4.894542133562300e-07,  3.784570789980206e-08, -2.035153534042170e-09,  8.522578595896854e-11,
 -2.954695031720739e-12,  8.810299955038858e-14, -2.318840935665631e-15,  5.488823019469442e-17, -1.185041342899092e-18,  2.359355092395713e-20, -4.368527670219136e-22,
  1.499560012311069e-06, -2.392227902305104e-07,  2.002679736662782e-08, -1.161562641195528e-09,  5.228627042809697e-11, -1.942630316057446e-12,  6.191009163780748e-14,
 -1.737343988403108e-15,  4.375097905183028e-17, -1.002924900312881e-18,  2.116205772475342e-20, -4.145522399851933e-22,  6.621129543632611e-07, -1.143130422986792e-07,
  1.032662092272334e-08, -6.441444707144532e-10,  3.108726391305157e-11, -1.234910054453429e-12,  4.197332624864228e-14, -1.253381767625439e-15,  3.351788455653351e-17,
 -8.143819506222524e-19,  1.818158268536157e-20, -3.762271131718174e-22,  2.876846630228617e-07, -5.354606996601157e-08,  5.202960444164903e-09, -3.480580278209069e-10,
  1.796448752905826e-11, -7.612483229692137e-13,  2.753710454688037e-14, -8.733036912531265e-16,  2.475453176520303e-17, -6.363956867125592e-19,  1.500836791097755e-20,
 -3.275439801929639e-22,  1.233198219169938e-07, -2.465403892650720e-08,  2.568785006614798e-09, -1.837891717998928e-10,  1.011995970076232e-11, -4.564277342395358e-13,
  1.753535598387851e-14, -5.894626107107818e-16,  1.767870845793511e-17, -4.800606029125861e-19,  1.193972567779449e-20, -2.743903060148877e-22,  5.229545909848138e-08,
 -1.118983654616378e-08,  1.246458688764530e-09, -9.512683200389855e-11,  5.574508539905703e-12, -2.670024183327434e-13,  1.087204155687464e-14, -3.866408073230240e-16,
  1.224660605967760e-17, -3.506589583686506e-19,  9.182522217644135e-21, -2.218664689085044e-22,  2.200193694726359e-08, -5.021559894073040e-09,  5.962647258092649e-10,
 -4.841285282664366e-11,  3.012108949203211e-12, -1.528744607991218e-13,  6.583990743796159e-15, -2.472294232890670e-16,  8.255205614678559e-18, -2.488093615441308e-19,
  6.848625704421213e-21, -1.736995686051041e-22,  9.211714544978986e-09, -2.235085225130904e-09,  2.820981243018696e-10, -2.430512340051596e-11,  1.601711975500282e-12,
 -8.595030332266524e-14,  3.907183767293753e-15, -1.546124439137146e-16,  5.432396872587986e-18, -1.720434392657074e-19,  4.969428959430763e-21, -1.320894411580626e-22,
  3.850189919076599e-09, -9.899352427252552e-10,  1.324339013991093e-10, -1.207713135001337e-11,  8.410102157962334e-13, -4.761076039107364e-14,  2.279726820614213e-15,
 -9.488137944239627e-17,  3.501366594739800e-18, -1.163106141745464e-19,  3.519487984138908e-21, -9.788035056707583e-23,  1.611845457513882e-09, -4.377692351758118e-10,
  6.190421943924164e-11, -5.960041803021931e-12,  4.375342717566315e-13, -2.607319973015134e-14,  1.312273618752758e-15, -5.732941715736807e-17,  2.217795552555364e-18,
 -7.713508924406784e-20,  2.440895915359015e-21, -7.090754376288136e-23,  6.781921405309395e-10, -1.939652370514397e-10,  2.891269088427119e-11, -2.931443884889184e-12,
  2.263290383390911e-13, -1.416545206040848e-14,  7.478125795659193e-16, -3.422351740887574e-17,  1.385219339263270e-18, -5.034945064179871e-20,  1.663248087291222e-21,
 -5.038277395796551e-23,  2.878064651978079e-10, -8.641612911844490e-11,  1.354135165938404e-11, -1.442170829028685e-12,  1.168246614429997e-13, -7.662151290713114e-15,
  4.233610543449086e-16, -2.025484220739613e-17,  8.560855129281574e-19, -3.245762963829843e-20,  1.117253997664101e-21, -3.522840521873107e-23,  1.236307811800961e-10,
 -3.885403118728477e-11,  6.382940842899750e-12, -7.122442760240123e-13,  6.038906363973398e-14, -4.140989762530843e-15,  2.389519603004308e-16, -1.192621912417350e-17,
  5.253022147926905e-19, -2.073425043799958e-20,  7.423035763602053e-22, -2.431923502283910e-23,  5.395160234063364e-11, -1.769443592118604e-11,  3.039150758389887e-12,
 -3.544022785489323e-13,  3.137442242287377e-14, -2.244075911338984e-15,  1.349331913983856e-16, -7.010542715042253e-18,  3.211271019839393e-19, -1.316944440023178e-20,
  4.894172607372592e-22, -1.662880958163582e-23,  2.400491853374409e-11, -8.191751115980644e-12,  1.467004794192580e-12, -1.783127250498453e-13,  1.644118429280464e-14,
 -1.223706208891819e-15,  7.649613630312991e-17, -4.128150009514949e-18,  1.962344034654241e-19, -8.344164075182883e-21,  3.212528997016394e-22, -1.129800478543501e-23,
  1.092817592466982e-11, -3.869025237169095e-12,  7.204381161070512e-13, -9.103525367896918e-14,  8.720357375786796e-15, -6.737592134951032e-16,  4.368477100513885e-17,
 -2.443125007281859e-18,  1.202563840622728e-19, -5.290673279233806e-21,  2.105876499089127e-22, -7.650523977517519e-24,  5.107557649835576e-12, -1.870633299278327e-12,
  3.611733159996771e-13, -4.731831284802387e-14,  4.696874626186305e-15, -3.757731891129285e-16,  2.520983407895358e-17, -1.457720547075054e-18,  7.413091291564839e-20,
 -3.367021535478516e-21,  1.382614625261801e-22, -5.178023162774101e-24,  2.458401593396510e-12, -9.287609614376215e-13,  1.854142862944646e-13, -2.511755017921326e-14,
  2.576738286603710e-15, -2.129256723839099e-16,  1.474414313257805e-17, -8.793723194733392e-19,  4.609466727968254e-20, -2.156548860755585e-21,  9.115756104336322e-23,
 -3.511805266178421e-24,  1.221946844662362e-12, -4.748352904223614e-13,  9.773779031475512e-14, -1.365265098899354e-14,  1.443635930734049e-15, -1.228922051958570e-16,
  8.761196744232056e-18, -5.376461512417493e-19,  2.897925323769204e-20, -1.393302341317949e-21,  6.048818433679919e-23, -2.391786630561560e-24,  6.285585215695375e-13,
 -2.505237588056659e-13,  5.301560913410679e-14, -7.614789881446368e-15,  8.276679817719112e-16, -7.238905718714403e-17,  5.299457226899643e-18, -3.337687335846271e-19,
  1.845349483116532e-20, -9.095843525192325e-22,  4.046154121946145e-23, -1.638388031974935e-24,  3.350382170981497e-13, -1.365814945779148e-13,  2.962946292282536e-14,
 -4.363512680486932e-15,  4.861579949514973e-16, -4.356711199180127e-17,  3.266481558260347e-18, -2.105948305650906e-19,  1.191304235884389e-20, -6.005089602077539e-22,
  2.730518169527185e-23, -1.129587408515252e-24,  1.850534594726815e-13, -7.694479524763709e-14,  1.706149047586125e-14, -2.568774836840340e-15,  2.925309127733181e-16,
 -2.678589693959934e-17,  2.051194656310526e-18, -1.350117176528555e-19,  7.793979899602072e-21, -4.007611324722233e-22,  1.858060119735355e-23, -7.834004004227113e-25,
  1.056980668878273e-13, -4.470249795817586e-14,  1.010163279684670e-14, -1.550301789028078e-15,  1.799307734111003e-16, -1.678637380975155e-17,  1.309264143476118e-18,
 -8.774172517262655e-20,  5.155259079165857e-21, -2.696968519452065e-22,  1.271725615911727e-23, -5.451150574108840e-25,  6.208939978648892e-14, -2.663608876776782e-14,
  6.115853600926165e-15, -9.538904773994440e-16,  1.124991507108130e-16, -1.066249930357008e-17,  8.446287191724213e-19, -5.747140829656429e-20,  3.427452579170529e-21,
 -1.819450739033573e-22,  8.703034633261417e-24, -3.782968262330807e-25,  3.706338883994015e-14, -1.608416374326409e-14,  3.741162197735059e-15, -5.912212519738655e-16,
  7.064180964612518e-17, -6.781896510138723e-18,  5.440516785159635e-19, -3.748041671053633e-20,  2.262539033017390e-21, -1.215431670915781e-22,  5.881945210872254e-24,
 -2.585976860732771e-25,  2.190094075419083e-14, -9.588137747537234e-15,  2.252421760544246e-15, -3.595565070616560e-16,  4.339341086453042e-17, -4.207236761015726e-18,
  3.407972343704618e-19, -2.370235292638016e-20,  1.444220002365054e-21, -7.829550465745040e-23,  3.823099199245950e-24, -1.695574050642278e-25,  1.198930473382930e-14,
 -5.280875932881472e-15,  1.249131162854422e-15, -2.007986122364530e-16,  2.440246032945650e-17, -2.382217730314187e-18,  1.942694910194489e-19, -1.360096167927046e-20,
  8.341137098333526e-22, -4.550785134084351e-23,  2.235974450863933e-24, -9.977156878403738e-26,  4.734877340829787e-15, -2.092605257765220e-15,  4.968794951270574e-16,
 -8.018503861227151e-17,  9.782407371930748e-18, -9.586281703191459e-19,  7.846969068779154e-20, -5.513982670669419e-21,  3.393817471545945e-22, -1.858171584690407e-23,
  9.161604934778860e-25, -4.101868128075115e-26,  5.433896091980316e-02, -1.218707063178875e-04,  2.826444561862640e-07, -6.742363857523313e-10,  1.643723992341536e-12,
 -4.070518687780515e-15,  1.018495637908835e-17, -2.564580024977508e-20,  6.478304498812325e-23, -1.638451291603499e-25,  4.142362650565492e-28, -1.046113392214406e-30,
  5.201899819903635e-02, -1.453254426997926e-04,  4.772774735317879e-07, -1.636589322514718e-09,  5.583635826583442e-12, -1.871495654652443e-14,  6.155617964807057e-17,
 -1.990518860634751e-19,  6.341782075813914e-22, -1.994477132370311e-24,  6.201180890431167e-27, -1.908421764788930e-29,  4.767502327119619e-02, -1.857390272287960e-04,
  8.591785477079122e-07, -3.844272468344041e-09,  1.636864764329856e-11, -6.693405979730336e-14,  2.650275774378417e-16, -1.021905336680195e-18,  3.852445332452136e-21,
 -1.424138427513512e-23,  5.174322713927430e-26, -1.851115151570369e-28,  4.183632683465080e-02, -2.322051622887825e-04,  1.403315376906950e-06, -7.718634585583359e-09,
  3.950541279727008e-11, -1.917030774177517e-13,  8.918531510776543e-16, -4.007049465194049e-18,  1.747829783273625e-20, -7.430782729035949e-23,  3.088668232128446e-25,
 -1.258269972850676e-27,  3.515875591803652e-02, -2.727628450634527e-04,  2.055029971124053e-06, -1.357133686578799e-08,  8.207579637136556e-11, -4.650686753530603e-13,
  2.502537547156232e-15, -1.290473689158189e-17,  6.418966653031224e-20, -3.095026724848833e-22,  1.452123770275525e-24, -6.649549542401909e-27,  2.830369515873240e-02,
 -2.977711728168594e-04,  2.727650114083725e-06, -2.133770092641905e-08,  1.505884391135276e-10, -9.844196687821326e-13,  6.057179100556988e-15, -3.546208096538241e-17,
  1.990815337998463e-19, -1.077927129862309e-21,  5.654390423902951e-24, -2.883725270011137e-26,  2.183354939507399e-02, -3.021699088007598e-04,  3.315679196630840e-06,
 -3.040511883483960e-08,  2.478982551400128e-10, -1.852096658641112e-12,  1.291698240814414e-14, -8.514772216671169e-17,  5.352483454224569e-19, -3.229842837877043e-21,
  1.880470993622395e-23, -1.060603537320957e-25,  1.614542408156641e-02, -2.860542153851879e-04,  3.720209571078144e-06, -3.963410568599775e-08,  3.702296196179577e-10,
 -3.137306038723876e-12,  2.462547077999195e-14, -1.815572701007929e-16,  1.269850395790150e-18, -8.488008640166459e-21,  5.453063044094726e-23, -3.382152911798074e-25,
  1.145044677119633e-02, -2.536906184522443e-04,  3.875864399507745e-06, -4.759703758145263e-08,  5.058283647131880e-10, -4.830722599848603e-12,  4.242274084276394e-14,
 -3.478783587919972e-16,  2.692952250550358e-18, -1.983886252324749e-20,  1.399570976377183e-22, -9.501278978844500e-25,  7.792560366388182e-03, -2.116159143689743e-04,
  3.767593287451355e-06, -5.295924865216388e-08,  6.364046295376334e-10, -6.811975984637674e-12,  6.659010871095054e-14, -6.044607894035890e-16,  5.155517736254281e-18,
 -4.167987685130487e-20,  3.215550760767769e-22, -2.379847883503351e-24,  5.092066747126367e-03, -1.666173768467832e-04,  3.430959046624183e-06, -5.485499607040807e-08,
  7.413445275861635e-10, -8.850741781726340e-12,  9.587970040195716e-14, -9.594095676126034e-16,  8.980524923830353e-18, -7.937705722375129e-20,  6.672932183057790e-22,
 -5.365590499292464e-24,  3.197214754053465e-03, -1.242161641850393e-04,  2.937403755401770e-06, -5.311090661138748e-08,  8.032871424687374e-10, -1.065011099919572e-11,
  1.273438608438081e-13, -1.399465171234712e-15,  1.432635549587551e-17, -1.379834787452040e-19,  1.259981238824041e-21, -1.097356577433688e-23,  1.930452650545951e-03,
 -8.792850974645791e-05,  2.371871921110926e-06, -4.824171640616967e-08,  8.129099932230626e-10, -1.192125926717374e-11,  1.567656165764341e-13, -1.885752899598296e-15,
  2.104588068429124e-17, -2.202223137170869e-19,  2.178099988332928e-21, -2.049077029051143e-23,  1.121869283000603e-03, -5.924734465489140e-05,  1.811613980781712e-06,
 -4.124427680367583e-08,  7.710991381270285e-10, -1.246218635800674e-11,  1.796323607648970e-13, -2.357955227505163e-15,  2.860744756425473e-17, -3.243375066131402e-19,
  3.465536467675722e-21, -3.512948583679812e-23,  6.281305260114610e-04, -3.808968382591040e-05,  1.312409084788076e-06, -3.329111781660154e-08,  6.878856857486478e-10,
 -1.221021895722365e-11,  1.923255577326105e-13, -2.747086848265491e-15,  3.613487141356329e-17, -4.427751850185906e-19,  5.098964548991556e-21, -5.556703349668454e-23,
  3.392001470415670e-04, -2.341540409873511e-05,  9.041131758489063e-07, -2.544250025871310e-08,  5.789029166450713e-10, -1.124985987317284e-11,  1.930775026324206e-13,
 -2.992960602413052e-15,  4.257886071124804e-17, -5.625755429954917e-19,  6.967034790729524e-21, -8.145216238871497e-23,  1.768815221890502e-04, -1.379352153898502e-05,
  5.937520614018862e-07, -1.846057605299539e-08,  4.609502420082932e-10, -9.777290927705961e-12,  1.823449608048475e-13, -3.059950763367724e-15,  4.697207405819870e-17,
 -6.677451221307547e-19,  8.874628779609311e-21, -1.110884971085405e-22,  8.918703790019374e-05, -7.802544906233587e-06,  3.726225541771800e-07, -1.275073296979023e-08,
  3.482479267059722e-10, -8.039546759714833e-12,  1.625090420606510e-13, -2.945258673455809e-15,  4.867748072924834e-17, -7.430004230249462e-19,  1.057681350434322e-20,
 -1.414918638783724e-22,  4.354518143067660e-05, -4.247109237374793e-06,  2.240040669139465e-07, -8.405401860265427e-09,  2.503259984510360e-10, -6.272492890715572e-12,
  1.370844034456484e-13, -2.677196708981103e-15,  4.753963917796473e-17, -7.775980959337757e-19,  1.183429294358719e-20, -1.688923263299943e-22,  2.061961900409040e-05,
 -2.229295341554414e-06,  1.293024944163930e-07, -5.301954966547736e-09,  1.716670734692183e-10, -4.656660441078731e-12,  1.097738387980466e-13, -2.305143280396539e-15,
  4.389073562623994e-17, -7.678807333657882e-19,  1.247184654076558e-20, -1.895635906939728e-22,  9.485635153496368e-06, -1.130844892991778e-06,  7.184140193725175e-08,
 -3.208424622031075e-09,  1.126182339855718e-10, -3.298789525754340e-12,  8.368864447236136e-14, -1.885670415125897e-15,  3.842365336752675e-17, -7.177162860318341e-19,
  1.241924464842873e-20, -2.007092673000580e-22,  4.247209922505031e-06, -5.556181055055714e-07,  3.851527537567960e-08, -1.867511165664289e-09,  7.086880957504817e-11,
 -2.236151779791232e-12,  6.091763392021399e-14, -1.469815714081885e-15,  3.199165960687252e-17, -6.368812340842153e-19,  1.172149814951060e-20, -2.011014855105310e-22,
  1.854663869908341e-06, -2.650359057542990e-07,  1.997488215112973e-08, -1.048357967701897e-09,  4.289697733412937e-11, -1.454610103896998e-12,  4.246059905296564e-14,
 -1.094886186451246e-15,  2.540892910299900e-17, -5.381799329815988e-19,  1.051786753794766e-20, -1.912700407645842e-22,  7.915765329415334e-07, -1.230417286052413e-07,
  1.004773115248937e-08, -5.691418474300137e-10,  2.504657520303487e-11, -9.106305352221431e-13,  2.842290612935435e-14, -7.817611078880029e-16,  1.930866439216458e-17,
 -4.343879756009618e-19,  9.000332455388564e-21, -1.732219535936931e-22,  3.309794844382982e-07, -5.573619305151664e-08,  4.915496998521379e-09, -2.996556291897971e-10,
  1.414740670082817e-11, -5.502585869812530e-13,  1.832675050622300e-14, -5.366442933483704e-16,  1.408164281136158e-17, -3.359209656328966e-19,  7.367346235112634e-21,
 -1.498391554532477e-22,  1.359185209661195e-07, -2.470220051558168e-08,  2.345389193394359e-09, -1.534563439491043e-10,  7.753661590490310e-12, -3.219086750451376e-13,
  1.141725603239103e-14, -3.552548207393815e-16,  9.886210437050278e-18, -2.496609195979910e-19,  5.786741973463634e-21, -1.241840358756773e-22,  5.496562943087270e-08,
 -1.074203286900455e-08,  1.094704827578233e-09, -7.666997225797432e-11,  4.135959056418114e-12, -1.828903757706689e-13,  6.893770210084037e-15, -2.275092528760343e-16,
  6.702691290153843e-18, -1.788902749898751e-19,  4.375183273232641e-21, -9.892180944830041e-23,  2.195241743797602e-08, -4.597214771903964e-09,  5.013699879849879e-10,
 -3.748983335041847e-11,  2.154121628208622e-12, -1.012361374348197e-13,  4.047337185803541e-15, -1.414047062692517e-16,  4.402614581982154e-18, -1.239773734357268e-19,
  3.194410859200584e-21, -7.597892330295413e-23,  8.685085073527433e-09, -1.942377436833065e-09,  2.260497381563819e-10, -1.800006782004602e-11,  1.099067473704745e-12,
 -5.477813545089410e-14,  2.318145014540137e-15, -8.558018174719326e-17,  2.810920963881639e-18, -8.337698854914146e-20,  2.259640124176817e-21, -5.645246531560019e-23,
  3.414806475579453e-09, -8.129143574490669e-10,  1.006702525827555e-10, -8.515073049398624e-12,  5.512214558044908e-13, -2.907329117629049e-14,  1.299737607847117e-15,
 -5.060652021401180e-17,  1.750389331330679e-18, -5.459593629775561e-20,  1.553795104303873e-21, -4.071012214864157e-23,  1.338855567602075e-09, -3.381723361156806e-10,
  4.444045195775545e-11, -3.982848515451527e-12,  2.727187072051011e-13, -1.518912343472787e-14,  7.158865103663609e-16, -2.934160443186277e-17,  1.066786923824658e-18,
 -3.492859692129581e-20,  1.042166316191885e-21, -2.859040563995542e-23,  5.253200757205909e-10, -1.403422567759352e-10,  1.951748923273818e-11, -1.848767589335334e-12,
  1.335919548206683e-13, -7.839804952323412e-15,  3.887569719636417e-16, -1.674035544399021e-17,  6.385905595462936e-19, -2.190976162764448e-20,  6.841974135445251e-22,
 -1.962147810923653e-23,  2.070377557586498e-10, -5.832182033582303e-11,  8.560130546423667e-12, -8.548619527465075e-13,  6.503657500875604e-14, -4.012697799332958e-15,
  2.089144388828164e-16, -9.432863171593525e-18,  3.768304031262878e-19, -1.352345846112022e-20,  4.412300768754413e-22, -1.320549174398536e-23,  8.227727559467423e-11,
 -2.436427040497005e-11,  3.763899431888103e-12, -3.952936499409197e-13,  3.158795242988305e-14, -2.044496310330553e-15,  1.115212764612497e-16, -5.269189716911915e-18,
  2.200141120490726e-19, -8.243508381676237e-21,  2.805084663409634e-22, -8.746286978017375e-24,  3.310010793552371e-11, -1.027268909020465e-11,  1.665803616868338e-12,
 -1.835149949518572e-13,  1.536650560395471e-14, -1.040975159297356e-15,  5.936233500265198e-17, -2.928924008974916e-18,  1.275718947991307e-19, -4.980861697307664e-21,
  1.764381252601139e-22, -5.721129766667146e-24,  1.353446990616217e-11, -4.389124135949072e-12,  7.450522668682386e-13, -8.587901752846348e-14,  7.516864491667313e-15,
 -5.317353822639293e-16,  3.163017839553058e-17, -1.626239404264740e-18,  7.373622359924994e-20, -2.994049931342591e-21,  1.101971800363781e-22, -3.709082732714434e-24,
  5.647632796337427e-12, -1.908072202841189e-12,  3.381255859755284e-13, -4.067252541569341e-14,  3.712103646569814e-15, -2.735531043267803e-16,  1.693530989364360e-17,
 -9.053331884793232e-19,  4.264170581361779e-20, -1.797017134629028e-21,  6.858452666893641e-23, -2.391626686184092e-24,  2.414552668187855e-12, -8.473722428957634e-13,
  1.563237719263370e-13, -1.957139255850848e-14,  1.857844886183448e-15, -1.422774807428583e-16,  9.145643594644832e-18, -5.071991466371498e-19,  2.476185973156437e-20,
 -1.080734990776774e-21,  4.268370786040160e-23, -1.538978796217520e-24,  1.061766370980367e-12, -3.859221122477357e-13,  7.390893319200185e-14, -9.604974213938281e-15,
  9.458582914081746e-16, -7.508817156850011e-17,  4.999500561604659e-18, -2.869618259182492e-19,  1.448849438791103e-20, -6.534653295733816e-22,  2.665059027691272e-23,
 -9.914676888862420e-25,  4.819693592159600e-13, -1.809060179355248e-13,  3.586407005237817e-14, -4.824658585502369e-15,  4.915685077560602e-16, -4.034885762282623e-17,
  2.775756185576624e-18, -1.644988097510547e-19,  8.569145940777724e-21, -3.984833178632986e-22,  1.674452204854160e-23, -6.413697916435986e-25,  2.265799242031546e-13,
 -8.756953502799434e-14,  1.791902324755905e-14, -2.488336438636582e-15,  2.615955708021389e-16, -2.214269997034332e-17,  1.569857382553075e-18, -9.581680368358572e-20,
  5.137336634290656e-21, -2.457299423632728e-22,  1.061450862290405e-23, -4.176635624730826e-25,  1.106113798207736e-13, -4.389042870829375e-14,  9.243005251588714e-15,
 -1.321142947080124e-15,  1.429095535425563e-16, -1.244037373406985e-17,  9.065532512388696e-19, -5.684025625017020e-20,  3.128846509575478e-21, -1.535641650069600e-22,
  6.802609713598718e-24, -2.743369054740060e-25,  5.617538768112400e-14, -2.281917842494369e-14,  4.930995233473929e-15, -7.233376789661968e-16,  8.027848444260241e-17,
 -7.166879927043924e-18,  5.353494867589263e-19, -3.438966503784622e-20,  1.938488366717781e-21, -9.737713025385747e-23,  4.412812257757804e-24, -1.819540929803381e-25,
  2.969504964542848e-14, -1.231324491287727e-14,  2.722008866589066e-15, -4.085718939543703e-16,  4.638744648050629e-17, -4.234925091807977e-18,  3.233588912651881e-19,
 -2.122346577075047e-20,  1.221798680685692e-21, -6.265414172455215e-23,  2.897180392894128e-24, -1.218375767280830e-25,  1.631326278674318e-14, -6.885246036356463e-15,
  1.552362545870125e-15, -2.376965137554189e-16,  2.752505546985947e-17, -2.562203002412407e-18,  1.994058527597779e-19, -1.333495957956202e-20,  7.818654289127747e-22,
 -4.082011848094457e-23,  1.921008172660208e-24, -8.218334086444849e-26,  9.266773554932405e-15, -3.969700911880057e-15,  9.100111876435531e-16, -1.417042594420874e-16,
  1.668535999568946e-17, -1.578917058363452e-18,  1.248803007163832e-19, -8.484421003224735e-21,  5.052411889025896e-22, -2.678175719209238e-23,  1.279249590773111e-24,
 -5.552886835502963e-26,  5.380483260880555e-15, -2.332738206947105e-15,  5.420194801215183e-16, -8.556446114118408e-17,  1.021279074359108e-17, -9.794460335827538e-19,
  7.849192941658256e-20, -5.401992755607254e-21,  3.257765181245752e-22, -1.748387505172658e-23,  8.453193041329142e-25, -3.713020193847442e-26,  3.111594211420463e-15,
 -1.361482132382755e-15,  3.196345797001215e-16, -5.099099882439325e-17,  6.149992056917095e-18, -5.959038914310828e-19,  4.824015826842530e-20, -3.353070769059590e-21,
  2.041872014219898e-22, -1.106321093579830e-23,  5.399013122974112e-25, -2.393182927726762e-26,  1.677866789176427e-15, -7.388270597313860e-16,  1.747033719187588e-16,
 -2.807422586663479e-17,  3.410634818643534e-18, -3.328429484385610e-19,  2.713445022895744e-20, -1.899096161757518e-21,  1.164302905261670e-22, -6.350280615198783e-24,
  3.119189462154742e-25, -1.391402799486313e-26,  6.570513078411977e-16, -2.903460358023759e-16,  6.893010583574600e-17, -1.112189560164956e-17,  1.356621698818748e-18,
 -1.329202786498062e-19,  1.087856889673582e-20, -7.643017028571098e-22,  4.703470232828869e-23, -2.574821499176548e-24,  1.269302623263110e-25, -5.682098107744566e-27,
  5.385594978700520e-02, -1.196414730240842e-04,  2.747087728823196e-07, -6.485750436839787e-10,  1.564701031389088e-12, -3.834467806076335e-15,  9.495032335255294e-18,
 -2.366400755329809e-20,  5.917210777173672e-23, -1.481602050498707e-25,  3.708739791062615e-28, -9.274467310725615e-31,  5.144521059428221e-02, -1.415842883845475e-04,
  4.581623337627042e-07, -1.550167127628583e-09,  5.223670305185828e-12, -1.730226115278070e-14,  5.625637660116877e-17, -1.798607237049328e-19,  5.666467627617621e-22,
 -1.762433553926263e-24,  5.419820537270610e-27, -1.649881777229734e-29,  4.694552800853224e-02, -1.790457711952136e-04,  8.145755852671204e-07, -3.592747443501651e-09,
  1.509132541964597e-11, -6.090328751798704e-14,  2.380658074623489e-16, -9.064460618170466e-19,  3.375128684025760e-21, -1.232573434963541e-23,  4.424805441672634e-26,
 -1.564296042803395e-28,  4.092938741049553e-02, -2.213386722791304e-04,  1.314361423103538e-06, -7.116094537586544e-09,  3.587662446447830e-11, -1.715841580180359e-13,
  7.871002826174253e-16, -3.488264973060514e-18,  1.501287881943714e-20, -6.299284131308069e-23,  2.584735667826243e-25, -1.039661043714183e-27,  3.409958420681014e-02,
 -2.569523911437091e-04,  1.899756504673703e-06, -1.232939060813586e-08,  7.334692123601975e-11, -4.091215642011879e-13,  2.168363586210738e-15, -1.101827876793340e-17,
  5.402624754952749e-20, -2.568716271482933e-22,  1.188736729171223e-24, -5.370424279137385e-27,  2.715468711986288e-02, -2.769346681197219e-04,  2.485429169430708e-06,
 -1.907821957797039e-08,  1.322769144943409e-10, -8.502771055471927e-13,  5.147893035735298e-15, -2.967107173799758e-17,  1.640590599238012e-19, -8.752253264550936e-22,
  4.524978607937045e-24, -2.275135041013116e-26,  2.067570145241987e-02, -2.770392022482605e-04,  2.973446046703587e-06, -2.671901558480920e-08,  2.137728477205312e-10,
 -1.568865721992932e-12,  1.075614199692871e-14, -6.974365136447758e-17,  4.314594599279117e-19, -2.563319001184148e-21,  1.469884198544667e-23, -8.167786560040094e-26,
  1.505785451486868e-02, -2.580988417688721e-04,  3.278171210930001e-06, -3.418193841186591e-08,  3.130044253541134e-10, -2.602974188241712e-12,  2.006766393652388e-14,
 -1.454176500929529e-16,  1.000203724320685e-18, -6.577770033095861e-21,  4.159367113327744e-23, -2.540093603940114e-25,  1.049426574374878e-02, -2.248377747966142e-04,
  3.350241743302144e-06, -4.022452480475577e-08,  4.186540423516629e-10, -3.920349455176433e-12,  3.378847575157143e-14, -2.721273933283532e-16,  2.070197480911519e-18,
 -1.499553143415159e-20,  1.040628620957479e-22, -6.951998685052783e-25,  7.002584704159232e-03, -1.838539272636966e-04,  3.188947567627288e-06, -4.378529322747769e-08,
  5.148665894423003e-10, -5.399572355388112e-12,  5.176588600062743e-14, -4.612007430108479e-16,  3.863358077392113e-18, -3.069240083455418e-20,  2.327987757125557e-22,
 -1.694651336214791e-24,  4.476591514827349e-03, -1.416137824932335e-04,  2.838408054654774e-06, -4.429315661973356e-08,  5.853221383730730e-10, -6.841984048657010e-12,
  7.264413485690914e-14, -7.130314084746806e-16,  6.551441924369913e-18, -5.687440781388241e-20,  4.698380658657535e-22, -3.714122132591794e-24,  2.743600530579600e-03,
 -1.030629354212167e-04,  2.370662987957473e-06, -4.180872013319950e-08,  6.179229109641183e-10, -8.016538685346478e-12,  9.389451376847599e-14, -1.011645479554187e-15,
  1.016061747913210e-17, -9.607245120835946e-20,  8.617041675679720e-22, -7.375187201954251e-24,  1.613312029670673e-03, -7.106490131895302e-05,  1.863758880731653e-06,
 -3.695480708051365e-08,  6.081959446740070e-10, -8.723160798011266e-12,  1.123116317638341e-13, -1.323936884994676e-15,  1.449051356260157e-17, -1.487963942932404e-19,
  1.445002357158257e-21, -1.335449142513361e-23,  9.110040805004303e-04, -4.654194414812505e-05,  1.383184761869658e-06, -3.068711579695855e-08,  5.601114258190575e-10,
 -8.849740262556963e-12,  1.248449825467479e-13, -1.605339918352412e-15,  1.909369150152103e-17, -2.123617685497446e-19,  2.227264482587908e-21, -2.217289132728228e-23,
  4.944817947644926e-04, -2.901833095321131e-05,  9.716401518134904e-07, -2.401176651425592e-08,  4.842266041667714e-10, -8.400194192581014e-12,  1.294544163303347e-13,
 -1.810780929740241e-15,  2.334394454292259e-17, -2.805310129025462e-19,  3.170224626181557e-21, -3.392107981541717e-23,  2.582723659617927e-04, -1.726187213297530e-05,
  6.476968325250955e-07, -1.775420314871088e-08,  3.941790704810106e-10, -7.484620426053289e-12,  1.256516046509000e-13, -1.907007991500494e-15,  2.658305213334601e-17,
 -3.443904931402895e-19,  4.184497883008362e-21, -4.802445937261060e-23,  1.299636597757670e-04, -9.817684022292744e-06,  4.107207702732003e-07, -1.243829797573493e-08,
  3.030190174519333e-10, -6.279284417206813e-12,  1.145340987772350e-13, -1.881504241731195e-15,  2.829603182749851e-17, -3.943612773773839e-19,  5.141624152486146e-21,
 -6.317266942290048e-23,  6.308895806828096e-05, -5.349846915035210e-06,  2.483562709120847e-07, -8.278344007499177e-09,  2.205938565155275e-10, -4.974990578897859e-12,
  9.834659543634651e-14, -1.744708305544763e-15,  2.824810093255337e-17, -4.226834694998583e-19,  5.902235640735756e-21, -7.749516974267869e-23,  2.958687650714774e-05,
 -2.798935164065746e-06,  1.435468822813875e-07, -5.247722681288252e-09,  1.524940051357445e-10, -3.733029021572672e-12,  7.978804006208832e-14, -1.525277410004564e-15,
  2.653286882799437e-17, -4.254468068217880e-19,  6.351328854556106e-21, -8.896343544752859e-23,  1.342596842600046e-05, -1.408922295270212e-06,  7.949562364209512e-08,
 -3.176588246903733e-09,  1.003747085838896e-10, -2.660373369488155e-12,  6.133923770730801e-14, -1.260929506308962e-15,  2.352095311287490e-17, -4.034260853734969e-19,
  6.427736036296374e-21, -9.589285120110441e-23,  5.905307774331664e-06, -6.838709894937176e-07,  4.228431883871452e-08, -1.840936295854693e-09,  6.307900139723007e-11,
 -1.805738258265436e-12,  4.481426177476934e-14, -9.886364449784892e-16,  1.973874407215905e-17, -3.615081343863523e-19,  6.137207600681342e-21, -9.736411301561026e-23,
  2.522357901753184e-06, -3.208048492857444e-07,  2.165624643843984e-08, -1.024111936673471e-09,  3.795096016759490e-11, -1.170637780849009e-12,  3.120515940811557e-14,
 -7.373405138670590e-16,  1.572839014167109e-17, -3.070694252525058e-19,  5.545663220921821e-21, -9.341587826795589e-23,  1.048397748716858e-06, -1.457870869064651e-07,
  1.070705793918698e-08, -5.483493252577891e-10,  2.192038522902645e-11, -7.269197980382285e-13,  2.076991514066303e-14, -5.246537020924010e-16,  1.193592041979096e-17,
 -2.479954970091732e-19,  4.757149367854679e-21, -8.495868997225667e-23,  4.249751927233510e-07, -6.434180217330968e-08,  5.123871485846896e-09, -2.833835745050194e-10,
  1.218993699093722e-11, -4.336234601521148e-13,  1.325340993103122e-14, -3.572348706167525e-16,  8.652712011141821e-18, -1.910163018409681e-19,  3.885913691619745e-21,
 -7.347059272797943e-23,  1.684072891816443e-07, -2.765080714425843e-08,  2.379991797712831e-09, -1.417585747082027e-10,  6.545778961647752e-12, -2.492304094014084e-13,
  8.132435586417282e-15, -2.334744404515595e-16,  6.010510378423542e-18, -1.407547667381303e-19,  3.032121757210803e-21, -6.060361873992718e-23,  6.540966306348604e-08,
 -1.160307505628584e-08,  1.076134696179298e-09, -6.884645436612122e-11,  3.404488700684934e-12, -1.384496165677736e-13,  4.813552615789846e-15, -1.469228964553462e-16,
  4.013280133509892e-18, -9.953883326797657e-20,  2.267155659875396e-21, -4.783430984645037e-23,  2.496984774290065e-08, -4.768376007859622e-09,  4.751153884119187e-10,
 -3.256327858216789e-11,  1.720476388207187e-12, -7.457143175825731e-14,  2.757133472278476e-15, -8.931067345313796e-17,  2.584150370389053e-18, -6.777358362429974e-20,
  1.629665527484502e-21, -3.624402079013930e-23,  9.396797339394691e-09, -1.925115907207574e-09,  2.054790880841410e-10, -1.504898484618026e-11,  8.475864090098241e-13,
 -3.907356179635886e-14,  1.533345117717770e-15, -5.261679237186795e-17,  1.609933245249015e-18, -4.457642102400679e-20,  1.129879675937884e-21, -2.644955208462151e-23,
  3.497198448859285e-09, -7.660690170487900e-10,  8.734503079920958e-11, -6.818714031212120e-12,  4.084609165630799e-13, -1.998570338746440e-14,  8.308210363026772e-16,
 -3.014701591578183e-17,  9.737692069272119e-19, -2.841882821305151e-20,  7.581480051738264e-22, -1.865298425445355e-23,  1.291557004977811e-09, -3.015225930234178e-10,
  3.662270350213829e-11, -3.039944294035399e-12,  1.932432713316168e-13, -1.001467684596620e-14,  4.401603768520123e-16, -1.685801097947119e-17,  5.738470268418626e-19,
 -1.762327676599278e-20,  4.940554844200822e-22, -1.275634210712041e-23,  4.750346204801440e-10, -1.178175873649390e-10,  1.520261300704654e-11, -1.338496846684369e-12,
  9.008781443727348e-14, -4.934586843219572e-15,  2.288531730517582e-16, -9.234340562693951e-18,  3.306821743521389e-19, -1.066879010806642e-20,  3.137985213389131e-22,
 -8.489650577168047e-24,  1.746655015547480e-10, -4.587916338802749e-11,  6.272331589992178e-12, -5.843141674212151e-13,  4.154506515448003e-14, -2.400134668992029e-15,
  1.172215664469774e-16, -4.973821455893152e-18,  1.870383544598171e-19, -6.328557411115100e-21,  1.949728246976622e-22, -5.518422712520551e-24,  6.446029263995108e-11,
 -1.787673394140771e-11,  2.582496324787168e-12, -2.539254825261689e-13,  1.902868322357659e-14, -1.156970113915355e-15,  5.938504102397323e-17, -2.644570077237030e-18,
  1.042393208126231e-19, -3.692410375855296e-21,  1.189537369148007e-22, -3.516512466981046e-24,  2.397657254958488e-11, -6.999207772269326e-12,  1.065541992864179e-12,
 -1.103084765616050e-13,  8.692250684305390e-15, -5.549978518051645e-16,  2.987626669611935e-17, -1.393603394227319e-18,  5.746833210775437e-20, -2.127264442949532e-21,
  7.153660817012653e-23, -2.205064919787337e-24,  9.027343141411933e-12, -2.765516390141155e-12,  4.424813098096717e-13, -4.810772135721956e-14,  3.976791320021060e-15,
 -2.660508764136550e-16,  1.498832669888856e-17, -7.308273238716848e-19,  3.146785100589468e-20, -1.214945674460234e-21,  4.257102243858923e-23, -1.365850929518455e-24,
  3.455614239023069e-12, -1.107622527879278e-12,  1.857482677372944e-13, -2.115529222961239e-14,  1.830138038324802e-15, -1.279943734060282e-16,  7.529721010629241e-18,
 -3.829784124388208e-19,  1.718341434825040e-20, -6.906335195985558e-22,  2.516723453967336e-23, -8.389318156368452e-25,  1.350897309371793e-12, -4.516890237173859e-13,
  7.917548849302560e-14, -9.421749652549999e-15,  8.508835924593562e-16, -6.206208975201875e-17,  3.803905111964967e-18, -2.013779730772525e-19,  9.395436094584972e-21,
 -3.923027712301635e-22,  1.483836244665541e-23, -5.129212804741567e-25,  5.417356487127167e-13, -1.883903573981262e-13,  3.442036129742997e-14, -4.268260243208466e-15,
  4.013856587784958e-16, -3.045861440634160e-17,  1.940488923367579e-18, -1.066838741094942e-19,  5.164459750839667e-21, -2.235512791323344e-22,  8.758466111505175e-24,
 -3.133296578468443e-25,  2.238292636066887e-13, -8.071371400335133e-14,  1.532772386095067e-14, -1.975281617023455e-15,  1.929211580107348e-16, -1.519249848534635e-17,
  1.003632574881672e-18, -5.716749157702368e-20,  2.864902753332701e-21, -1.282782957336940e-22,  5.194709286571814e-24, -1.919287678961703e-25,  9.567947934822639e-14,
 -3.567095525241535e-14,  7.020456554738407e-15, -9.376153201512586e-16,  9.485268672716376e-17, -7.731667072851208e-18,  5.282899626185932e-19, -3.110113042122489e-20,
  1.609701929060631e-21, -7.438458863755375e-23,  3.106553432406805e-24, -1.182822948967010e-25,  4.247645167954998e-14, -1.632362924260421e-14,  3.319797069146386e-15,
 -4.581843019267404e-16,  4.787829050238482e-17, -4.028766424533956e-18,  2.839848351988571e-19, -1.723578233176808e-20,  9.190560998359670e-22, -4.372560101587801e-23,
  1.878922223859457e-24, -7.355761297209083e-26,  1.964796279154779e-14, -7.760085355534857e-15,  1.625945022177751e-15, -2.312243294143858e-16,  2.488680428025028e-17,
 -2.155808716908908e-18,  1.563463329226319e-19, -9.757029259936007e-21,  5.346411205250917e-22, -2.612359474633552e-23,  1.152207908748803e-24, -4.627029280601089e-26,
  9.492203411974224e-15, -3.841540820986488e-15,  8.267343551473430e-16, -1.207787397003058e-16,  1.335030467336912e-17, -1.187133445971073e-18,  8.833290771748207e-20,
 -5.652858918856910e-21,  3.174663757662884e-22, -1.589002288250552e-23,  7.175528119162876e-25, -2.948572421207204e-26,  4.794744374097298e-15, -1.982456284568798e-15,
  4.368564480855362e-16, -6.536220632592150e-17,  7.397506249491286e-18, -6.732609518870448e-19,  5.125125698698484e-20, -3.353885333805245e-21,  1.925191708366476e-22,
 -9.844562204216474e-24,  4.539664325544350e-25, -1.903981498034220e-26,  2.529734565848798e-15, -1.065429677336257e-15,  2.396436211590629e-16, -3.660615162922175e-17,
  4.228926312735346e-18, -3.927398305687963e-19,  3.049580665733691e-20, -2.034824222675069e-21,  1.190480994352558e-22, -6.202146962426635e-24,  2.912701867996878e-25,
 -1.243578665244224e-26,  1.387799561132473e-15, -5.936111279067794e-16,  1.358501398228984e-16, -2.111824147827522e-17,  2.482445451107460e-18, -2.345230543274016e-19,
  1.851897438976053e-20, -1.256195780743422e-21,  7.468983398631066e-23, -3.953163988155724e-24,  1.885468229216560e-25, -8.172548958626992e-27,  7.828737115743033e-16,
 -3.390846866528828e-16,  7.870026188645425e-17, -1.240988923918098e-17,  1.479573993596275e-18, -1.417419930633035e-19,  1.134692277646950e-20, -7.801030196975843e-22,
  4.699725936341523e-23, -2.519736491360694e-24,  1.217061832035182e-25, -5.340775887088078e-27,  4.426925806136795e-16, -1.935875878890093e-16,  4.541853916797092e-17,
 -7.240734876718884e-18,  8.727214860864310e-19, -8.450719694512941e-20,  6.836719377542629e-21, -4.749072721633187e-22,  2.890196053211596e-23, -1.565014174741218e-24,
  7.633000806894233e-26, -3.381480234044962e-27,  2.349832065845767e-16, -1.034404077271348e-16,  2.445114631382821e-17, -3.927838308741404e-18,  4.770124002013190e-19,
 -4.653549525714710e-20,  3.792441471892106e-21, -2.653384779559754e-22,  1.626212456029400e-23, -8.866758159670861e-25,  4.353884943182336e-26, -1.941575489623598e-27,
  9.121048470295928e-17, -4.029930114869302e-17,  9.565720582067301e-18, -1.543167180696288e-18,  1.881994287320322e-19, -1.843642420159210e-20,  1.508633998613755e-21,
 -1.059752627812834e-22,  6.520584862671352e-24, -3.568984830392397e-25,  1.759110535576668e-26, -7.873506941687402e-28,  5.338173053683257e-02, -1.174745145934942e-04,
  2.670735924089727e-07, -6.241411820025384e-10,  1.490237898320079e-12, -3.614328998204179e-15,  8.858167345042585e-18, -2.185305514106945e-20,  5.409582507249599e-23,
 -1.341097367511459e-25,  3.324084728373481e-28, -8.232015204855704e-31,  5.088608819718837e-02, -1.379920027294358e-04,  4.400506141236278e-07, -1.469285082361668e-09,
  4.890729034446714e-12, -1.601054948689778e-14,  5.146488608142306e-17, -1.627027269931100e-19,  5.069326752831363e-22, -1.559483392540384e-24,  4.743798307934276e-27,
 -1.428591187343462e-29,  4.624211075981818e-02, -1.726976041479224e-04,  7.728721695444704e-07, -3.360728739904845e-09,  1.392840102139091e-11, -5.548246766579326e-14,
  2.141330281503465e-16, -8.052129876596498e-19,  2.961669733148404e-21, -1.068610087963645e-23,  3.790817343248014e-26, -1.324504724282642e-28,  4.006453512193647e-02,
 -2.111558492908523e-04,  1.232302435325596e-06, -6.568527890425623e-09,  3.262620590871071e-11, -1.538135479025972e-13,  6.958274405224520e-16, -3.042227433979885e-18,
  1.292072018365316e-20, -5.351361543101864e-23,  2.167875786120287e-25, -8.610702069238024e-28,  3.310126108048437e-02, -2.423268034941986e-04,  1.758583982371141e-06,
 -1.121857325809199e-08,  6.566088229908106e-11, -3.605958484489067e-13,  1.882728196786710e-15, -9.428662739612930e-18,  4.558073002509060e-20, -2.137309475143117e-22,
  9.757263530840135e-25, -4.349549498374908e-27,  2.608531451306534e-02, -2.579322601518115e-04,  2.268648933196427e-06, -1.709139258696382e-08,  1.164425195109049e-10,
 -7.361318265973418e-13,  4.386102926860487e-15, -2.489224644491702e-17,  1.355813267362800e-19, -7.127656043107737e-22,  3.632514359872704e-24, -1.800869363547025e-26,
  1.961316819065796e-02, -2.544782971440239e-04,  2.672348286727207e-06, -2.353627947164793e-08,  1.848265442790801e-10, -1.332673400182085e-12,  8.983510983986085e-15,
 -5.730661879474898e-17,  3.489507516201727e-19, -2.041416271797719e-21,  1.153115795784552e-23, -6.313823562666441e-26,  1.407542724327326e-02, -2.334328610471693e-04,
  2.896399545810088e-06, -2.956549724287947e-08,  2.654491771510571e-10, -2.166801689041072e-12,  1.641063078335596e-14, -1.168994762428198e-16,  7.908400766091401e-19,
 -5.117821996159828e-21,  3.185768984020148e-23, -1.915890931478718e-25,  9.645614700876255e-03, -1.998584291527127e-04,  2.905286757830056e-06, -3.411171795899346e-08,
  3.477757736688455e-10, -3.193846510799727e-12,  2.702060024002067e-14, -2.137713754595151e-16,  1.598452695909891e-18, -1.138626363239272e-20,  7.773874954184621e-23,
 -5.111430141108990e-25,  6.315051888959608e-03, -1.603117866956466e-04,  2.709594763797332e-06, -3.634800842592845e-08,  4.183210406009559e-10, -4.299144770241159e-12,
  4.042895771781998e-14, -3.535912803422028e-16,  2.909502080007296e-18, -2.271771571571260e-20,  1.694341682589106e-22, -1.213303970364162e-24,  3.952396422324098e-03,
 -1.208831983768850e-04,  2.358854668070128e-06, -3.593437676535241e-08,  4.644147477200264e-10, -5.316183038840609e-12,  5.533061640298098e-14, -5.328150562447240e-16,
  4.806227071388462e-18, -4.098615052770172e-20,  3.327679881699658e-22, -2.586531319875057e-24,  2.366324098005355e-03, -8.594780998179176e-05,  1.923359832186123e-06,
 -3.309116986769365e-08,  4.780095471969833e-10, -6.069215182463018e-12,  6.964444132265483e-14, -7.357780907879992e-16,  7.251404818361028e-18, -6.732108465375456e-20,
  5.931889838401293e-22, -4.989960111235598e-24,  1.356281193782191e-03, -5.777559837098094e-05,  1.473372824904541e-06, -2.848464419537877e-08,  4.579359926096878e-10,
 -6.424704184613315e-12,  8.100119847077523e-14, -9.358484435136798e-16,  1.004654629831879e-17, -1.012507189256593e-19,  9.655838274879829e-22, -8.767605675965873e-24,
  7.448336326940252e-04, -3.680956234876764e-05,  1.063357632016666e-06, -2.299261902989510e-08,  4.097674478662058e-10, -6.330305528838410e-12,  8.741248876200365e-14,
 -1.101211515559721e-15,  1.284184897719874e-17, -1.401312594191445e-19,  1.442790909341803e-21, -1.410756251071160e-23,  3.923002122206168e-04, -2.227781625962519e-05,
  7.249437042487403e-07, -1.745519478489441e-08,  3.435845506730670e-10, -5.825822710381058e-12,  8.785131633062525e-14, -1.203537467367987e-15,  1.520791104342358e-17,
 -1.792553159107087e-19,  1.988090097829967e-21, -2.088829086490111e-23,  1.983763117508420e-04, -1.283567820556617e-05,  4.680327476910227e-07, -1.249758905697581e-08,
  2.707700230672757e-10, -5.024007868930600e-12,  8.250913158815368e-14, -1.226143753987683e-15,  1.674912708995368e-17, -2.127826571567496e-19,  2.536825624114739e-21,
 -2.858314909123600e-23,  9.642404312191391e-05, -7.055191164461063e-06,  2.868456338438071e-07, -8.461552892776610e-09,  2.011321567959995e-10, -4.072155908335695e-12,
  7.264863273510871e-14, -1.168361935179997e-15,  1.721562086234144e-17, -2.352440869359076e-19,  3.008986728806975e-21, -3.629001748295506e-23,  4.510981197111456e-05,
 -3.707160102651102e-06,  1.672837528098249e-07, -5.431534035040966e-09,  1.412139070910866e-10, -3.111331516889888e-12,  6.015223395441236e-14, -1.044604365388288e-15,
  1.656913453758366e-17, -2.430585324582818e-19,  3.329411623506468e-21, -4.290682736099684e-23,  2.034090701280385e-05, -1.866036326023870e-06,  9.305097642514329e-08,
 -3.314019575678607e-09,  9.396484001116704e-11, -2.247238196766949e-12,  4.697415415290098e-14, -8.790148014427779e-16,  1.497959918846803e-17, -2.354684245217809e-19,
  3.448214305716866e-21, -4.740569545122919e-23,  8.854589717512826e-06, -9.017096525418645e-07,  4.948632874398675e-08, -1.926896084423062e-09,  5.941734282699152e-11,
 -1.538682813923650e-12,  3.469830191934342e-14, -6.982470824091656e-16,  1.276026505266318e-17, -2.145633791593525e-19,  3.353561759246895e-21, -4.910644809400621e-23,
  3.727492315352739e-06, -4.192109482117785e-07,  2.522324505347178e-08, -1.070419170302364e-09,  3.580084129755041e-11, -1.001520704098402e-12,  2.431360010760125e-14,
 -5.251376142716731e-16,  1.027285720166727e-17, -1.844681585186322e-19,  3.072367142345790e-21, -4.784609862940851e-23,  1.520328143284223e-06, -1.879356952779801e-07,
  1.235241063421654e-08, -5.696205679350622e-10,  2.061073627947108e-11, -6.214484623355637e-13,  1.620823621104488e-14, -3.750322277668167e-16,  7.839706418141485e-18,
 -1.500921662196544e-19,  2.659772014811413e-21, -4.398708980614596e-23,  6.020432468547505e-07, -8.143997632686598e-08,  5.827203021591240e-09, -2.911586155707853e-10,
  1.136916388748993e-11, -3.686626121712867e-13,  1.030948292615358e-14, -2.550857282354163e-16,  5.688466655080677e-18, -1.159292498259080e-19,  2.182551086534721e-21,
 -3.827670886019584e-23,  2.319880077918009e-07, -3.419925549717683e-08,  2.655197687751844e-09, -1.433518163760323e-10,  6.026271213023054e-12, -2.097042018582680e-13,
  6.275491651759764e-15, -1.657438898441753e-16,  3.936439582115569e-18, -8.526394171762839e-20,  1.702879740471564e-21, -3.162543421486233e-23,  8.719940607657917e-08,
 -1.395439726664890e-08,  1.171895151532592e-09, -6.818260048662049e-11,  3.078569234882459e-12, -1.147240016508257e-13,  3.666896513479852e-15, -1.031965085910526e-16,
  2.606016358575134e-18, -5.990124149770126e-20,  1.267275887427388e-21, -2.488889851580293e-23,  3.205707043467558e-08, -5.548283666782339e-09,  5.024890976102323e-10,
 -3.142429948242318e-11,  1.520466222312273e-12, -6.055269753152537e-14,  2.063304418252327e-15, -6.176608015289835e-17,  1.655781177348123e-18, -4.032696783450920e-20,
  9.024445180005242e-22, -1.871712453246032e-23,  1.155958896596136e-08, -2.156137533581754e-09,  2.099771845664892e-10, -1.407890463277662e-11,  7.283486870548867e-13,
 -3.093590124410911e-14,  1.121672915992913e-15, -3.565502016478464e-17,  1.013002627778454e-18, -2.610203400557507e-20,  6.169655239910096e-22, -1.349473158480376e-23,
  4.101216312717242e-09, -8.216114892060907e-10,  8.579531092096440e-11, -6.152387694770472e-12,  3.395545541302085e-13, -1.535046284825385e-14,  5.911382340288102e-16,
 -1.991856290064111e-17,  5.987955875391612e-19, -1.629847248291091e-20,  4.063145021108145e-22, -9.359349171606347e-24,  1.436410834344693e-09, -3.080493488680045e-10,
  3.439704927830083e-11, -2.631639329326467e-12,  1.546077818173810e-13, -7.424299278000437e-15,  3.030928473436139e-16, -1.080690415842659e-17,  3.431941278769491e-19,
 -9.852316116285362e-21,  2.586671656711886e-22, -6.266003655253958e-24,  4.984100909486034e-10, -1.140570545645016e-10,  1.358159504357107e-11, -1.105943534666354e-12,
  6.901182136610393e-14, -3.513023252118601e-15,  1.517526472619615e-16, -5.715471354113108e-18,  1.914191586400153e-19, -5.786661782197569e-21,  1.597588253523898e-22,
 -4.063996160362994e-24,  1.719834134520778e-10, -4.186498670016821e-11,  5.302073978759620e-12, -4.584179223114500e-13,  3.031670021847647e-14, -1.632627507284010e-15,
  7.448167714235410e-17, -2.957850305767489e-18,  1.042958048922666e-19, -3.314761569529702e-21,  9.608439525552473e-23, -2.562930078725300e-24,  5.925553856619717e-11,
 -1.529607284019170e-11,  2.054885162615361e-12, -1.881883771851890e-13,  1.316073519776068e-14, -7.482311324499764e-16,  3.598012824109602e-17, -1.503849857679860e-18,
  5.573097554156766e-20, -1.859105696269204e-21,  5.649089410499991e-23, -1.577588652028831e-24,  2.047212663704303e-11, -5.586939891569834e-12,  7.940412130362509e-13,
 -7.684000269680849e-14,  5.669791798776525e-15, -3.395940832725481e-16,  1.717870488146272e-17, -7.542763897991740e-19,  2.932555405201054e-20, -1.025018516877976e-21,
  3.259613396837311e-23, -9.515348938413133e-25,  7.124079161148426e-12, -2.049197879350118e-12,  3.072977846357673e-13, -3.134593314095503e-14,  2.434793762960539e-15,
 -1.533060430434313e-16,  8.141582997233025e-18, -3.748053816662689e-19,  1.525952625440696e-20, -5.578709139509479e-22,  1.853475495597996e-23, -5.646416910405376e-25,
  2.508690375148936e-12, -7.582923564189384e-13,  1.196616406993528e-13, -1.283442298263514e-14,  1.046999216760956e-15, -6.914961546253732e-17,  3.847225234563008e-18,
 -1.853238651997356e-19,  7.885917772206010e-21, -3.009889909462577e-22,  1.042917900026334e-23, -3.309913423326719e-25,  8.982642642160889e-13, -2.844600386078589e-13,
  4.710912162109096e-14, -5.299408722205381e-15,  4.529485438290000e-16, -3.130777940034858e-17,  1.820859968757028e-18, -9.158926535759216e-20,  4.065217721737605e-21,
 -1.616784850185643e-22,  5.831646579952413e-24, -1.924671008440013e-25,  3.286475375317095e-13, -1.087096647480756e-13,  1.884179755149653e-14, -2.217288144307719e-15,
  1.980742522507220e-16, -1.429462208349949e-17,  8.671357802158862e-19, -4.544656165478945e-20,  2.099686260510273e-21, -8.683998811961104e-23,  3.254268963066249e-24,
 -1.114803214110421e-25,  1.234730293162805e-13, -4.253257459627755e-14,  7.693604055803734e-15, -9.446144689751860e-16,  8.797207616449145e-17, -6.612659109740190e-18,
  4.174136089383136e-19, -2.274306072860195e-20,  1.091370584794911e-21, -4.684043252899842e-23,  1.819968338566865e-24, -6.458448216020855e-26,  4.786889181124347e-14,
 -1.711995661691623e-14,  3.222729664910358e-15, -4.117077916554531e-16,  3.986826599453504e-17, -3.113520500719111e-18,  2.040156158195272e-19, -1.152908034528107e-20,
  5.733252864670120e-22, -2.547864447410873e-23,  1.024235307231088e-24, -3.757342827664863e-26,  1.924091106600573e-14, -7.122928798976732e-15,  1.391313768308751e-15,
 -1.844214758345109e-16,  1.851921393338668e-17, -1.498666634725545e-18,  1.016810453542542e-19, -5.945064730154454e-21,  3.056429649772567e-22, -1.403182821738762e-23,
  5.822964001526911e-25, -2.203404209936026e-26,  8.053781229709693e-15, -3.076778812074416e-15,  6.217440890692207e-16, -8.526353673243620e-17,  8.853830004835320e-18,
 -7.404462543849388e-19,  5.188108422107129e-20, -3.130412282193195e-21,  1.659711665738159e-22, -7.852510750543810e-24,  3.356016149808055e-25, -1.306920495718683e-26,
  3.524138224711758e-15, -1.385123975771613e-15,  2.886869054019590e-16, -4.083666368278709e-17,  4.372370261172506e-18, -3.768223366306494e-19,  2.719218992708989e-20,
 -1.688715634961015e-21,  9.209492122962726e-23, -4.479109268083975e-24,  1.966639267004776e-25, -7.862926264989907e-27,  1.616938756511360e-15, -6.518396663576024e-16,
  1.396840214756351e-16, -2.031933430436611e-17,  2.236530879501160e-18, -1.980546271852552e-19,  1.467743929779732e-20, -9.355775768853120e-22,  5.234012203315326e-23,
 -2.609922714148370e-24,  1.174256587790270e-25, -4.808058127607118e-27,  7.792136176236279e-16, -3.212066752946241e-16,  7.054616206011050e-17, -1.051977147033030e-17,
  1.186667244443093e-18, -1.076512053755283e-19,  8.168885482207946e-21, -5.329190439727093e-22,  3.049816511570760e-23, -1.554942641013492e-24,  7.149749907107082e-26,
 -2.990283324867147e-27,  3.942405269002280e-16, -1.656674539065549e-16,  3.717034493439957e-17, -5.663623426489948e-18,  6.526691338774828e-19, -6.046591687644360e-20,
  4.683938436112460e-21, -3.118076633493706e-22,  1.820097995413720e-23, -9.461284822296601e-25,  4.433663998611511e-26, -1.888963587917637e-27,  2.085836710532389e-16,
 -8.907784238214639e-17,  2.034987542571046e-17, -3.157808405636780e-18,  3.705463493338241e-19, -3.494594737945214e-20,  2.754813806060370e-21, -1.865576112669050e-22,
  1.107423856859590e-23, -5.852079773722578e-25,  2.786850540116565e-26, -1.206142351798408e-27,  1.141832853178318e-16, -4.940489459112570e-17,  1.145339087951753e-17,
 -1.803914421269976e-18,  2.148225110336279e-19, -2.055631386849327e-20,  1.643759575072333e-21, -1.128849481008552e-22,  6.793459838924154e-24, -3.638467235694879e-25,
  1.755622606439364e-26, -7.696431677218570e-28,  6.307363342636265e-17, -2.756496837754634e-17,  6.462696176573463e-18, -1.029578850162701e-18,  1.240085106904527e-19,
 -1.199977340433322e-20,  9.701438735353091e-22, -6.734604607991396e-23,  4.095919649706764e-24, -2.216507365971902e-25,  1.080385777374400e-26, -4.783321610650276e-28,
  3.293404485599216e-17, -1.449308985469886e-17,  3.424634669885226e-18, -5.499335333571580e-19,  6.676190029014729e-20, -6.510701805670776e-21,  5.304070485395546e-22,
 -3.709712499535194e-23,  2.272844267416169e-24, -1.238831965105917e-25,  6.081103256919334e-27, -2.710945113528724e-28,  1.266630422164506e-17, -5.595473038065972e-18,
  1.327950429522327e-18, -2.141905401471357e-19,  2.611732659294193e-20, -2.558060358124388e-21,  2.092871052761714e-22, -1.469902359611720e-23,  9.042674772868850e-25,
 -4.948600884505629e-26,  2.438704723982337e-27, -1.091349553087145e-28,  5.291605878630883e-02, -1.153674847060026e-04,  2.597246124628483e-07, -6.008643217969824e-10,
  1.420028708130707e-12, -3.408884368949012e-15,  8.269808822540050e-18, -2.019673891864381e-20,  4.949873445792338e-23, -1.215099746187607e-25,  2.982472537009219e-28,
 -7.315119131047439e-31,  5.034105117692517e-02, -1.345408171296858e-04,  4.228783493933542e-07, -1.393529512119645e-09,  4.582509865683166e-12, -1.482827786378044e-14,
  4.712812979059308e-17, -1.473437160908892e-19,  4.540606358057720e-22, -1.381723474594188e-24,  4.158010017257767e-27, -1.238871313808842e-29,  4.556343612211383e-02,
 -1.666722358025107e-04,  7.338448167418065e-07, -3.146479766325412e-09,  1.286837124826810e-11, -5.060346243108058e-14,  1.928580816478580e-16, -7.163131239944136e-19,
  2.602916136173438e-21, -9.280159660946429e-24,  3.253512250324982e-26, -1.123619096642951e-28,  3.923914158309385e-02, -2.016040728609748e-04,  1.156513561481693e-06,
 -6.070239548226575e-09,  2.971026788536702e-11, -1.380908784493893e-13,  6.161554556411786e-16, -2.657985992194866e-18,  1.114160142590659e-20, -4.555468597374875e-23,
  1.822234386510462e-25, -7.148113453166546e-28,  3.215926310936571e-02, -2.287792959807502e-04,  1.630034269045103e-06, -1.022332628353611e-08,  5.888025848529314e-11,
 -3.184204317061931e-13,  1.638040707345258e-15, -8.086014689055686e-18,  3.854515049063771e-20, -1.782757865269978e-22,  8.029782866408355e-25, -3.532412289668504e-27,
  2.508862819368736e-02, -2.405728660681290e-04,  2.074262757011770e-06, -1.534060233672575e-08,  1.027185287307658e-10, -6.387616329743625e-13,  3.746194278831018e-15,
 -2.093763325368958e-17,  1.123568737859169e-19, -5.821549669676895e-22,  2.924999841926703e-24, -1.430031619517682e-26,  1.863629221282100e-02, -2.341809316193330e-04,
  2.406813225376410e-06, -2.078109170598816e-08,  1.602053917060867e-10, -1.135127207030948e-12,  7.524811993255872e-15, -4.723219244039970e-17,  2.831336443150863e-19,
 -1.631288844815668e-21,  9.078159942200904e-24, -4.898669634748963e-26,  1.318588897287816e-02, -2.116117662033642e-04,  2.565733007764664e-06, -2.564466274727719e-08,
  2.258006543111576e-10, -1.809526934315119e-12,  1.346570653669285e-14, -9.431010851426619e-17,  6.276398620402322e-19, -3.997438272586643e-21,  2.449950166571903e-23,
 -1.451146602800462e-25,  8.890200503782652e-03, -1.781635379674131e-04,  2.527333492445661e-06, -2.902502192206191e-08,  2.899272934511881e-10, -2.611757619077256e-12,
  2.169352289496494e-14, -1.686206232985087e-16,  1.239490936486516e-18, -8.684100596632927e-21,  5.834042199668409e-23, -3.775973743279095e-25,  5.714548241508907e-03,
 -1.402721578282497e-04,  2.310902056756491e-06, -3.029320172537895e-08,  3.412904784077290e-10, -3.437847073366971e-12,  3.171766442905910e-14, -2.723623304351788e-16,
  2.201796400079709e-18, -1.689939172192034e-20,  1.239535744699890e-22, -8.732916576114317e-25,  3.504042533730237e-03, -1.036185261140014e-04,  1.968937855129211e-06,
 -2.928695528981062e-08,  3.702463612425677e-10, -4.151171528627259e-12,  4.236026971036128e-14, -4.002621103508362e-16,  3.545198829119878e-18, -2.970244402192707e-20,
  2.370461824136986e-22, -1.811916677648517e-24,  2.050963782454853e-03, -7.202795701527193e-05,  1.568425143475984e-06, -2.632983520192702e-08,  3.717977399900930e-10,
 -4.620834631343209e-12,  5.195726174079222e-14, -5.383283210078939e-16,  5.206807853302443e-18, -4.746937557926589e-20,  4.109590074380684e-22, -3.398205738832525e-24,
  1.146751718357692e-03, -4.724044113101620e-05,  1.171597935111815e-06, -2.208829176624226e-08,  3.469340636852694e-10, -4.761911243824421e-12,  5.879939801419992e-14,
 -6.659197801746904e-16,  7.012759752528963e-18, -6.937478340062612e-20,  6.497789538212090e-22, -5.797531738993831e-24,  6.130072043460721e-04, -2.930382061669337e-05,
  8.229483509614494e-07, -1.734490696915228e-08,  3.018643540726912e-10, -4.560267977927237e-12,  6.164621401665239e-14, -7.609608037450528e-16,  8.701785552973106e-18,
 -9.317304020179039e-20,  9.418527041661219e-22, -9.046469213990416e-24,  3.135825858460114e-04, -1.723082506719378e-05,  5.449624435176559e-07, -1.278595510984953e-08,
  2.456835558468826e-10, -4.072243380918376e-12,  6.009510085058901e-14, -8.064224782000825e-16,  9.989017322243670e-18, -1.154963187495907e-19,  1.257281361012982e-21,
 -1.297269810625781e-23,  1.536670284980899e-04, -9.624642349246254e-06,  3.410588183852741e-07, -8.872185520640634e-09,  1.875965021913177e-10, -3.401642446266101e-12,
  5.465569057146080e-14, -7.953734411461025e-16,  1.064782847089843e-17, -1.326607748261169e-19,  1.552021057431564e-21, -1.716937747974330e-23,  7.221951774175890e-05,
 -5.117497881234522e-06,  2.022070324427815e-07, -5.810344971245592e-09,  1.347661781165264e-10, -2.665972627605940e-12,  4.652306754081219e-14, -7.325373049085316e-16,
  1.057625335768333e-17, -1.417054469794339e-19,  1.778337667405310e-21, -2.105468695109525e-23,  3.259349261537183e-05, -2.595458473588521e-06,  1.138376972710955e-07,
 -3.600447958020117e-09,  9.133305926831203e-11, -1.966001026501385e-12,  3.717470446544816e-14, -6.319833024318177e-16,  9.821034245826773e-18, -1.412457801796005e-19,
  1.898057439788310e-21, -2.400990364959592e-23,  1.414574586204978e-05, -1.258198764611238e-06,  6.099788730109950e-08, -2.116371364925425e-09,  5.855013503648524e-11,
 -1.368014320393475e-12,  2.796673307518252e-14, -5.122892899741504e-16,  8.552624312549526e-18, -1.318000192238091e-19,  1.893353461774310e-21, -2.554874454878171e-23,
  5.913154736042894e-06, -5.842232735663023e-07,  3.118232857631932e-08, -1.183061524935934e-09,  3.559889378329248e-11, -9.007000683779784e-13,  1.986541755958125e-14,
 -3.913318991333097e-16,  7.006198930548946e-18, -1.154959311581798e-19,  1.770827593751562e-21, -2.545159752951605e-23,  2.384841211759824e-06, -2.604059611875781e-07,
  1.524458558149265e-08, -6.305460857509917e-10,  2.058340856195754e-11, -5.626740458390838e-13,  1.336152130923790e-14, -2.825328219217508e-16,  5.415151227165812e-18,
 -9.533723536053044e-20,  1.557774894704935e-21, -2.381308642925201e-23,  9.297554995355617e-07, -1.116752187686897e-07,  7.145248244560695e-09, -3.212626980030179e-10,
  1.134889258732048e-11, -3.344558784150808e-13,  8.534232304678456e-15, -1.933575708457381e-16,  3.960805135702531e-18, -7.435772809207341e-20,  1.292892031358365e-21,
 -2.099124482795989e-23,  3.511144238035491e-07, -4.618928683235505e-08,  3.219127909197193e-09, -1.568968512848139e-10,  5.983552141592777e-12, -1.897009277077158e-13,
  5.191481207507481e-15, -1.258089215306567e-16,  2.749855532857534e-18, -5.496472896066252e-20,  1.015529775038421e-21, -1.748809230729180e-23,  1.287317771233881e-07,
 -1.847190687911445e-08,  1.397835104009988e-09, -7.365489127842924e-11,  3.025443864580356e-12, -1.029741100671083e-13,  3.016721406347608e-15, -7.806115495308170e-17,
  1.817688844047791e-18, -3.862596271111119e-20,  7.572701707088197e-22, -1.381321324063399e-23,  4.593643823265882e-08, -7.162212695646003e-09,  5.866920191075495e-10,
 -3.333505510051355e-11,  1.471462132974089e-12, -5.365862812015459e-14,  1.679716441080249e-15, -4.633224682235080e-17,  1.147556011307935e-18, -2.588699957553988e-20,
  5.377919821029934e-22, -1.037718090212573e-23,  1.599694467903933e-08, -2.700265041900036e-09,  2.387324336800218e-10, -1.459003333646291e-11,  6.905640458863355e-13,
 -2.692672940133707e-14,  8.990492054829981e-16, -2.639087908341878e-17,  6.941856470434864e-19, -1.659961940642149e-20,  3.649162203833077e-22, -7.438906727950001e-24,
  5.452561746399888e-09, -9.929680151960665e-10,  9.448196194193084e-11, -6.195592270016594e-12,  3.137517375155653e-13, -1.305577448424907e-14,  4.641154064578973e-16,
 -1.447430875468164e-17,  4.037172566580786e-19, -1.021835618661718e-20,  2.373771572753210e-22, -5.105448102752031e-24,  1.824864761319510e-09, -3.573337110283595e-10,
  3.649201619521363e-11, -2.561395786332795e-12,  1.384850590324171e-13, -6.137752863152714e-15,  2.318877114277432e-16, -7.670581201630609e-18,  2.265108021196035e-19,
 -6.059491548374641e-21,  1.485430367598973e-22, -3.366268286254662e-24,  6.017575960982711e-10, -1.262882519284943e-10,  1.380466668729744e-11, -1.034713561488671e-12,
  5.959954024966300e-14, -2.807975289349426e-15,  1.125447346968731e-16, -3.942086832241267e-18,  1.230507521651605e-19, -3.473993943766941e-21,  8.974074266373542e-23,
 -2.139934197080211e-24,  1.962377702120893e-10, -4.399948087380297e-11,  5.134501920960091e-12, -4.100030727215395e-13,  2.510621576773680e-14, -1.254947540491305e-15,
  5.326381334122028e-17, -1.972176439834310e-18,  6.496900267878832e-20, -1.932813775614650e-21,  5.253735189723295e-23, -1.316413909659991e-24,  6.353898637505988e-11,
 -1.517335413964861e-11,  1.885304693214126e-12, -1.600099370852801e-13,  1.039401645474441e-14, -5.501272026194783e-16,  2.467993376663643e-17, -9.643129299203522e-19,
  3.347110824635143e-20, -1.047653889732384e-21,  2.992053549998188e-23, -7.866629316298716e-25,  2.051345012978945e-11, -5.201501068223994e-12,  6.863492281862934e-13,
 -6.176838977004802e-14,  4.247240832256036e-15, -2.375473195838841e-16,  1.124315649713941e-17, -4.627562727824352e-19,  1.689528672261836e-20, -5.554965139437257e-22,
  1.664334630672435e-23, -4.584741136952080e-25,  6.633418669997674e-12, -1.780578773120003e-12,  2.488633628439520e-13, -2.369236002878246e-14,  1.720682570532506e-15,
 -1.014886631448293e-16,  5.057956499151327e-18, -2.188950644727130e-19,  8.391811717784562e-21, -2.893467840760817e-22,  9.080184016790576e-24, -2.616722791531095e-25,
  2.158768685358907e-12, -6.115836940103357e-13,  9.030238746370092e-14, -9.072546069796285e-15,  6.943873995973051e-16, -4.310019531577891e-17,  2.257319255741926e-18,
 -1.025251110486883e-19,  4.119774816503909e-21, -1.487077179333903e-22,  4.879838407446918e-24, -1.468796674949272e-25,  7.105841486583683e-13, -2.118291699707995e-13,
  3.295495116730935e-14, -3.485540189202660e-15,  2.804962605550405e-16, -1.828203891986613e-17,  1.004156460369921e-18, -4.777085782696762e-20,  2.008232807784698e-21,
 -7.575090246795385e-23,  2.594784205190259e-24, -8.143689229373060e-26,  2.378061172286797e-13, -7.437149409355703e-14,  1.215803933990484e-14, -1.350345031086397e-15,
  1.139885162758198e-16, -7.784059354034157e-18,  4.474230989033144e-19, -2.224931560108963e-20,  9.766141451361589e-22, -3.842286508995060e-23,  1.371363490134095e-24,
 -4.479908899600554e-26,  8.134897717874079e-14, -2.660950692736214e-14,  4.558525344463233e-15, -5.302984448801107e-16,  4.684221977784252e-17, -3.343649866768421e-18,
  2.006792831546398e-19, -1.040901787523228e-20,  4.760781817747948e-22, -1.949737045839427e-23,  7.236936371788049e-25, -2.456177297362173e-26,  2.859984258508482e-14,
 -9.755074610665077e-15,  1.746347602866799e-15, -2.122221876779445e-16,  1.956645798772770e-17, -1.456411360754449e-18,  9.105983606256360e-20, -4.915546139729397e-21,
  2.337571681710516e-22, -9.944592791613740e-24,  3.830920583956064e-25, -1.348166621942333e-26,  1.039003755959818e-14, -3.684161991365019e-15,  6.872322746164656e-16,
 -8.700408786509260e-17,  8.350786429344573e-18, -6.465376117957600e-19,  4.200909863922771e-20, -2.354549118021419e-21,  1.161556672076976e-22, -5.121912034909596e-24,
  2.043427653085199e-25, -7.441058078126865e-27,  3.921192754130788e-15, -1.440978443689429e-15,  2.792585990120950e-16, -3.672738437532847e-17,  3.659833193674974e-18,
 -2.939552041536662e-19,  1.979859704952564e-20, -1.149344732829468e-21,  5.867957890645212e-23, -2.675735264087160e-24,  1.103073224581926e-25, -4.147289323852877e-27,
  1.545069311568217e-15, -5.866220578180135e-16,  1.177542270774115e-16, -1.604115530990418e-17,  1.654857941406778e-18, -1.375128910331586e-19,  9.575166691695240e-21,
 -5.742406262759805e-22,  3.026542999265707e-23, -1.423671427571304e-24,  6.050282797781597e-26, -2.343246858278888e-27,  6.385065823924004e-16, -2.496841869341734e-16,
  5.175199756997448e-17, -7.280242695449502e-18,  7.752581853893646e-19, -6.645847640787157e-20,  4.770859947202675e-21, -2.947833927207370e-22,  1.599672048947997e-23,
 -7.742646090805291e-25,  3.383586293982546e-26, -1.346626446871240e-27,  2.777585949262928e-16, -1.115177122851041e-16,  2.379088703523372e-17, -3.445307144546488e-18,
  3.775517448299448e-19, -3.328963470350560e-20,  2.456630112918442e-21, -1.559475935625910e-22,  8.689339312760204e-24, -4.315944433961635e-25,  1.934413903499825e-26,
 -7.891131412367472e-28,  1.274904412118809e-16, -5.238806935723307e-17,  1.146587216608438e-17, -1.703796008707610e-18,  1.915306983824053e-19, -1.731634094182691e-20,
  1.309666351886422e-21, -8.516350565778423e-23,  4.858410605167738e-24, -2.469428217312444e-25,  1.132053715496984e-26, -4.720823998748930e-28,  6.175842381655719e-17,
 -2.589110245291225e-17,  5.793972656159677e-18, -8.805056582461858e-19,  1.012052238672246e-19, -9.352203950493243e-21,  7.226566347289914e-22, -4.798991375292057e-23,
  2.794636278169614e-24, -1.449347949187165e-25,  6.776439555396321e-27, -2.880745477253757e-28,  3.146742109267418e-17, -1.341623909289630e-17,  3.059283633325316e-18,
 -4.738413950352000e-19,  5.549938005351889e-20, -5.224627660251433e-21,  4.111310512548189e-22, -2.779378990042203e-23,  1.647072964332618e-24, -8.689416422568130e-26,
  4.131354059587208e-27, -1.785229989902917e-28,  1.669561766998125e-17, -7.216039278371418e-18,  1.670839525989516e-18, -2.628344441839185e-19,  3.126203190862027e-20,
 -2.987877748353735e-21,  2.386418245118708e-22, -1.636989945722986e-23,  9.840424817080651e-25, -5.264598409275083e-26,  2.537539487262754e-27, -1.111265759873215e-28,
  9.000125381618133e-18, -3.930791313031650e-18,  9.209218475854786e-19, -1.466057218666165e-19,  1.764524775443253e-20, -1.706236620707761e-21,  1.378472702457417e-22,
 -9.562603438482828e-24,  5.811975777955966e-25, -3.143085237481531e-26,  1.531040439305271e-27, -6.774310638492981e-29,  4.619510773123841e-18, -2.032209699361325e-18,
  4.800201261611919e-19, -7.705313624287177e-20,  9.350711572043791e-21, -9.115527178637084e-22,  7.423418267532862e-23, -5.190131972176745e-24,  3.178734429251694e-25,
 -1.731993717187682e-26,  8.499013742541280e-28, -3.787585219769257e-29,  1.759623303198423e-18, -7.772104832336646e-19,  1.844192401179750e-19, -2.974030331244499e-20,
  3.625722540547905e-21, -3.550569152635507e-22,  2.904369405500138e-23, -2.039487413052300e-24,  1.254450796602779e-25, -6.863795968772631e-27,  3.381951823578800e-28,
 -1.513211353482100e-29,  5.245869931414250e-02, -1.133181481583216e-04,  2.526483479075369e-07, -5.786786892389504e-10,  1.353790876840613e-12, -3.217020035181463e-15,
  7.725834012061245e-18, -1.868052816781942e-20,  4.533158095598518e-23, -1.101993049925419e-25,  2.678741523945770e-28, -6.507679008376245e-31,  4.980954978421632e-02,
 -1.312234554549961e-04,  4.065863248379967e-07, -1.322521797396033e-09,  4.296929178552017e-12, -1.374511319400042e-14,  4.319866984740041e-17, -1.335785847195405e-19,
  4.071855506017834e-22, -1.225807629502837e-24,  3.649643308074867e-27, -1.075955544375787e-29,  4.490825440557234e-02, -1.609490834169311e-04,  6.972898212995149e-07,
 -2.948437547236298e-09,  1.190101070637321e-11, -4.620643748533126e-14,  1.739189326537714e-16, -6.381233646585558e-19,  2.291111721841710e-21, -8.072455799146825e-24,
  2.797282672354862e-26, -9.549887765630550e-29,  3.845077930886260e-02, -1.926354594753867e-04,  1.086434267844792e-06, -5.616190934021371e-09,  2.709050127581873e-11,
 -1.241574092939666e-13,  5.464864277139318e-16, -2.326346748113207e-18,  9.625594312910450e-21, -3.885772314898711e-23,  1.534986433963922e-25, -5.947416047263426e-28,
  3.126947148988160e-02, -2.162141965535168e-04,  1.512803415597882e-06, -9.330127956856255e-09,  5.288733649026797e-11, -2.816906922356690e-13,  1.427978191183815e-15,
 -6.949349358445881e-18,  3.266978105439519e-20, -1.490616580510186e-22,  6.625016069670897e-25, -2.876490299186336e-27,  2.415839725039330e-02, -2.246881136250543e-04,
  1.899630221416677e-06, -1.379461495805607e-08,  9.079691654161042e-11, -5.555003195231031e-13,  3.207279941478066e-15, -1.765612895710870e-17,  9.336201152010308e-20,
 -4.768317199626296e-22,  2.362330756352330e-24, -1.139108722056328e-26,  1.773655745672470e-02, -2.158820061547263e-04,  2.172101257626277e-06, -1.839004533903665e-08,
  1.392067495670908e-10, -9.694297826615287e-13,  6.320802212268502e-15, -3.904546303656623e-17,  2.304554189683377e-19, -1.307869671658062e-21,  7.171679076254809e-24,
 -3.814377087735844e-26,  1.237862786144117e-02, -1.922580688719749e-04,  2.278534150490928e-06, -2.230467594584644e-08,  1.926391786060730e-10, -1.515895133610832e-12,
  1.108585145362439e-14, -7.635083954780566e-17,  4.999340922668317e-19, -3.134197246059057e-21,  1.891529893659438e-23, -1.103640175512526e-25,  8.215884106415662e-03,
 -1.592630045949147e-04,  2.205229923152689e-06, -2.477730627152810e-08,  2.425381489392521e-10, -2.143561134605213e-12,  1.748347123232525e-14, -1.335391707603750e-16,
  9.651497899698651e-19, -6.651877151755119e-21,  4.397872747327646e-23, -2.802331383228206e-25,  5.188256249330383e-03, -1.231511531775832e-04,  1.978005763394858e-06,
 -2.534370629490556e-08,  2.795669392197093e-10, -2.760704876027734e-12,  2.499287497903411e-14, -2.107523979679308e-16,  1.674117434329327e-18, -1.263266792181585e-20,
  9.113797205300648e-23, -6.318201318746403e-25,  3.118979912077077e-03, -8.917805904448876e-05,  1.650467316116062e-06, -2.397555506181187e-08,  2.965438873496414e-10,
 -3.257119944441970e-12,  3.259262629814888e-14, -3.022397172111933e-16,  2.628962820025175e-18, -2.164314598032521e-20,  1.698089366350047e-22, -1.276601775091828e-24,
  1.786079724417271e-03, -6.064986659340177e-05,  1.285316191151621e-06, -2.105745794836965e-08,  2.907208567198733e-10, -3.537383284107806e-12,  3.898084529264253e-14,
 -3.961513718728061e-16,  3.760971183761820e-18, -3.367579201876715e-20,  2.864878279617134e-22, -2.328962719244009e-24,  9.749810816536597e-04, -3.884029926483470e-05,
  9.369333264951441e-07, -1.722848935139473e-08,  2.644192655489728e-10, -3.551256561524614e-12,  4.295297125865952e-14, -4.769150486049708e-16,  4.927483761683136e-18,
 -4.785509742235805e-20,  4.402719758998337e-22, -3.860464183783781e-24,  5.077482763187887e-04, -2.347712537716821e-05,  6.410205489752542e-07, -1.317104904496581e-08,
  2.238785820183576e-10, -3.307833423685270e-12,  4.378111133505963e-14, -5.296138431900073e-16,  5.939511838151330e-18, -6.241099449333437e-20,  6.194841834027140e-22,
 -5.845530732453096e-24,  2.524937316092639e-04, -1.342374175791777e-05,  4.126632514404852e-07, -9.435286443249789e-09,  1.770040982254771e-10, -2.868319256078424e-12,
  4.142851239527567e-14, -5.446107361874404e-16,  6.613725780016867e-18, -7.502094156938763e-20,  8.016661811926167e-22, -8.123946840231174e-24,  1.200168748428643e-04,
 -7.275752875455450e-06,  2.505685008873141e-07, -6.350565086651714e-09,  1.310588227094809e-10, -2.322667217182244e-12,  3.651506081703715e-14, -5.204116987830425e-16,
  6.828390638075941e-18, -8.344077601981051e-20,  9.580185112212729e-22, -1.040654846963043e-23,  5.459011749673397e-05, -3.745771938921376e-06,  1.438398963056525e-07,
 -4.026317248275193e-09,  9.113016669437733e-11, -1.761572102439980e-12,  3.007156462701957e-14, -4.636206133932229e-16,  6.559267340534181e-18, -8.617907021156913e-20,
  1.061177137531466e-21, -1.233449354145290e-23,  2.379092303001443e-05, -1.835436652251408e-06,  7.824473798803431e-08, -2.410636328144271e-09,  5.966698272801294e-11,
 -1.254863185028410e-12,  2.320816939402282e-14, -3.862608858188056e-16,  5.881122899959200e-18, -8.292967541102233e-20,  1.093314148049028e-21, -1.357598697349855e-23,
  9.948085944327756e-06, -8.577404361400163e-07,  4.042538671454095e-08, -1.366354886423097e-09,  3.688296104799978e-11, -8.419270191360240e-13,  1.683361623730258e-14,
 -3.018561989535057e-16,  4.937172959569761e-18, -7.459205657944525e-20,  1.051182597809829e-21, -1.392297629715708e-23,  3.997322666026815e-06, -3.830862654192931e-07,
  1.988335301402565e-08, -7.350012146093894e-10,  2.158130054416552e-11, -5.334855502377027e-13,  1.150791725091980e-14, -2.219177651456952e-16,  3.892413307671158e-18,
 -6.290651834227778e-20,  9.461695027967589e-22, -1.334809459345600e-23,  1.546113527550972e-06, -1.638709193155626e-07,  9.332531964212285e-09, -3.761901584783206e-10,
  1.198506592610482e-11, -3.201345878977896e-13,  7.435779037601605e-15, -1.539279501076787e-16,  2.890507719054725e-18, -4.989316362737000e-20,  7.997752215316342e-22,
 -1.200083490473292e-23,  5.767314189865489e-07, -6.729120701148078e-08,  4.190425275007273e-09, -1.836763050869244e-10,  6.334148084910614e-12, -1.824369643973203e-13,
  4.554127623774547e-15, -1.010280453653156e-16,  2.027844479601999e-18, -3.732873821787510e-20,  6.368138799531702e-22, -1.015004545071042e-23,  2.079056173854200e-07,
 -2.658944276030427e-08,  1.804624953519617e-09, -8.578221195226210e-11,  3.194697559173413e-12, -9.901504338620900e-14,  2.651521488129253e-15, -6.292877819468421e-17,
  1.348043800574463e-18, -2.642556957770960e-20,  4.791174958115375e-22, -8.101116936199453e-24,  7.259535703971656e-08, -1.013596376814380e-08,  7.474207053459651e-10,
 -3.842934660907498e-11,  1.542124855797161e-12, -5.133055714995628e-14,  1.471953370341227e-15, -3.731245125940352e-17,  8.517480088953385e-19, -1.775523821727199e-20,
  3.416735110975465e-22, -6.120809321988200e-24,  2.461428169060779e-08, -3.737772976866847e-09,  2.985652462078943e-10, -1.656284705648636e-11,  7.146084004755755e-13,
 -2.549568516153413e-14,  7.815305031370245e-16, -2.112570528836062e-17,  5.131233728689223e-19, -1.135858570940811e-20,  2.316875788823505e-22, -4.391869675734053e-24,
  8.126242816300149e-09, -1.337291411135471e-09,  1.153807089326310e-10, -6.889200372119766e-12,  3.188980575210811e-13, -1.217205264418704e-14,  3.981541508289358e-16,
 -1.145854028954136e-17,  2.956985207423591e-19, -6.941207282602111e-21,  1.498777560652316e-22, -3.002550630592410e-24,  2.620083154341886e-09, -4.656638793895722e-10,
  4.327700551751204e-11, -2.774599578609659e-12,  1.375061981993737e-13, -5.604388624305063e-15,  1.952883128294255e-16, -5.974162860824050e-18,  1.635547936849895e-19,
 -4.065638346622567e-21,  9.280763388791869e-23, -1.962452626687879e-24,  8.277089631665025e-10, -1.583520447585477e-10,  1.580943851658900e-11, -1.085810883548605e-12,
  5.749293426061015e-14, -2.497466998179551e-15,  9.254684623209881e-17, -3.004647532126161e-18,  8.713645646469242e-20, -2.290534035033398e-21,  5.520373391489487e-23,
 -1.230542014960767e-24,  2.571074044220415e-10, -5.277903003174134e-11,  5.645714692843708e-12, -4.144306310722095e-13,  2.339672721123191e-14, -1.081197095625336e-15,
  4.253340573988057e-17, -1.463172185429707e-18,  4.488156950735304e-20, -1.245831549267723e-21,  3.165791549622506e-23, -7.429560415399316e-25,  7.882981882010470e-11,
 -1.730951739583861e-11,  1.978710481225399e-12, -1.548881582210860e-13,  9.303986168862034e-15, -4.565238199765910e-16,  1.903239229296532e-17, -6.926019288466286e-19,
  2.243657323854482e-20, -6.567078386629172e-22,  1.757062812187729e-23, -4.335578610341432e-25,  2.395531077793799e-11, -5.609394157658415e-12,  6.835008667885110e-13,
 -5.692292061914281e-14,  3.630653129413178e-15, -1.887965063263379e-16,  8.326388950072619e-18, -3.199989373590127e-19,  1.093047397395788e-20, -3.368460647926670e-22,
  9.475919754263843e-24, -2.455092493998123e-25,  7.247339857599376e-12, -1.804270734489401e-12,  2.337440757877637e-13, -2.066355931210910e-14,  1.396489767003830e-15,
 -7.680984847689778e-17,  3.577030976131179e-18, -1.449348054416420e-19,  5.211671039658750e-21, -1.688405234822285e-22,  4.986566014432787e-24, -1.354626920035722e-25,
  2.193233625395548e-12, -5.787833283656686e-13,  7.951660273151207e-14, -7.444442076396191e-15,  5.319511681987735e-16, -3.088558599407288e-17,  1.515975273632631e-18,
 -6.464459936762798e-20,  2.442984862104611e-21, -8.306756495621944e-23,  2.571724754505303e-24, -7.314286860838670e-26,  6.672903862055617e-13, -1.861044592482222e-13,
  2.704451487061396e-14, -2.675099511072524e-15,  2.016678278004260e-16, -1.233488861715713e-17,  6.368858679373399e-19, -2.852951670342982e-20,  1.131115602677006e-21,
 -4.029965019657458e-23,  1.305761774983128e-24, -3.882101633493417e-26,  2.052038982083297e-13, -6.030306350718368e-14,  9.244950134587070e-15, -9.638416191463334e-16,
  7.648603992166282e-17, -4.917839706773401e-18,  2.665739442280491e-19, -1.252020401168060e-20,  5.198195194321587e-22, -1.937167423383752e-23,  6.557901752070022e-25,
 -2.034760390855328e-26,  6.413928332904715e-14, -1.980088840462156e-14,  3.193989746156651e-15, -3.501068905101148e-16,  2.917743150763333e-17, -1.967778493132120e-18,
  1.117443592313204e-19, -5.491732452484108e-21,  2.383108126231515e-22, -9.272031281900035e-24,  3.273651819813768e-25, -1.058219539482777e-26,  2.049498454528216e-14,
 -6.626745154305772e-15,  1.121623299285746e-15, -1.289354341363626e-16,  1.125747115752340e-17, -7.945289219407787e-19,  4.716412780964099e-20, -2.420310277203869e-21,
  1.095516045843644e-22, -4.441379289428206e-24,  1.632356876888932e-25, -5.487292832064748e-27,  6.734963378148767e-15, -2.273803853470803e-15,  4.026990478832251e-16,
 -4.841919330770445e-17,  4.417920323498375e-18, -3.255246984880481e-19,  2.015293755027985e-20, -1.077482903163946e-21,  5.076247445366814e-23, -2.139992539113383e-24,
  8.171088310373098e-26, -2.850879314768233e-27,  2.289753276395482e-15, -8.046932987822539e-16,  1.486915785393021e-16, -1.864857407410300e-17,  1.773537429092212e-18,
 -1.360854206500247e-19,  8.765301266325184e-21, -4.871210511487296e-22,  2.383267277236481e-23, -1.042466578497599e-24,  4.126465051935294e-26, -1.491203687721560e-27,
  8.101737891433745e-16, -2.954523874531970e-16,  5.679115064209974e-17, -7.408430441627409e-18,  7.323644195329987e-19, -5.836580659633654e-20,  3.901292068685527e-21,
 -2.248051574062149e-22,  1.139484448030273e-23, -5.159542874905885e-25,  2.112504956462526e-26, -7.889784564571261e-28,  3.000329724549645e-16, -1.131811556576870e-16,
  2.256171195661359e-17, -3.052237190818024e-18,  3.127403029894795e-19, -2.581510860849048e-20,  1.785891864784181e-21, -1.064271148559360e-22,  5.574745112340768e-24,
 -2.606611182291159e-25,  1.101278145812283e-26, -4.240960775526521e-28,  1.169013583386390e-16, -4.547090188931660e-17,  9.370464373592607e-18, -1.310602392816799e-18,
  1.387725900139575e-19, -1.183024069125321e-20,  8.446626957164924e-22, -5.191483142002546e-23,  2.802714939831624e-24, -1.349750363203173e-25,  5.869652945438950e-27,
 -2.324940102069127e-28,  4.813226522209646e-17, -1.924234147217409e-17,  4.085984653001143e-18, -5.889532645698145e-19,  6.424316394150695e-20, -5.638958136282518e-21,
  4.142996464295131e-22, -2.618694860940101e-23,  1.453016710613494e-24, -7.187580364369272e-26,  3.208659200007916e-27, -1.303851304829016e-28,  2.100653920627431e-17,
 -8.603385889065360e-18,  1.876111072189272e-18, -2.777638651155134e-19,  3.111182098414299e-20, -2.802874385925515e-21,  2.112532920447921e-22, -1.369075646468727e-23,
  7.784575998209996e-25, -3.944020697153900e-26,  1.802379706208809e-27, -7.493255716119306e-29,  9.727047049773693e-18, -4.067835020352143e-18,  9.078226982890028e-19,
 -1.375815488212811e-19,  1.577065418743066e-20, -1.453457375655531e-21,  1.120178907356233e-22, -7.419912951723040e-24,  4.310166222702443e-25, -2.229910297323838e-26,
  1.040130716280330e-27, -4.411543549150526e-29,  4.765901610919450e-18, -2.028425750957542e-18,  4.616423929697695e-19, -7.136231328346953e-20,  8.342264005817057e-21,
 -7.838384453195759e-22,  6.156650872038947e-23, -4.154544146815825e-24,  2.457639891885080e-25, -1.294327224888210e-26,  6.143444038217602e-28, -2.650325556925272e-29,
  2.447614847753468e-18, -1.056683868388845e-18,  2.443581723860167e-19, -3.838965658369674e-20,  4.560314610746051e-21, -4.353071541588658e-22,  3.472530754364915e-23,
 -2.379160946041380e-24,  1.428504975589526e-25, -7.633698538639931e-27,  3.675326964429508e-28, -1.607782171944981e-29,  1.286277991233800e-18, -5.614029299039998e-19,
  1.314283722404049e-19, -2.090665672669885e-20,  2.514384401105834e-21, -2.429510284132878e-22,  1.961369707532511e-23, -1.359645971048994e-24,  8.257880229772840e-26,
 -4.462751420352883e-27,  2.172408692405348e-28, -9.605845536245438e-30,  6.484912403383567e-19, -2.851852348868076e-19,  6.733620590550518e-20, -1.080456772294682e-20,
  1.310661821914918e-21, -1.277200259841353e-22,  1.039717057497321e-23, -7.266523510812960e-25,  4.448797709530519e-26, -2.423136883643501e-27,  1.188629369106630e-28,
 -5.295294221001929e-30,  2.445453105917213e-19, -1.079961182021259e-19,  2.562098213060296e-20, -4.130980788021270e-21,  5.035244950226094e-22, -4.929954465331421e-23,
  4.031963404344617e-24, -2.830782938279705e-25,  1.740848795773468e-26, -9.523459817767465e-28,  4.691609606548305e-29, -2.098840406959831e-30,  5.200942562898553e-02,
 -1.113243745463145e-04,  2.458320764826263e-07, -5.575228588633446e-10,  1.291263140728155e-12, -3.037716350456490e-15,  7.222505798827636e-18, -1.729137909034735e-20,
  4.155057250345118e-23, -1.000354110722435e-25,  2.408389019129696e-28, -5.795783260287108e-31,  4.929106245486618e-02, -1.280330976706312e-04,  3.911196757548611e-07,
 -1.255915063275506e-09,  4.032099079254864e-12, -1.275179492955973e-14,  3.963445017172548e-17, -1.212274371561117e-19,  3.655740472057922e-22, -1.088862568389917e-24,
  3.207811252349592e-27, -9.358355877354998e-30,  4.427539510700222e-02, -1.555091215638006e-04,  6.630212898979088e-07, -2.765193544892311e-09,  1.101721694100968e-11,
 -4.223876889222969e-14,  1.570357016867510e-16, -5.692495288592878e-19,  2.019671033649324e-21, -7.033229092497351e-24,  2.409175817168937e-26, -8.131562786231179e-29,
  3.769720374837763e-02, -1.842063780780089e-04,  1.021560970186759e-06, -5.201917017559199e-09,  2.473340822658593e-11, -1.117898328165836e-13,  4.854588482606464e-16,
 -2.039574103054099e-18,  8.331208722151452e-21, -3.321067159006084e-23,  1.295730948954852e-25, -4.959384855700592e-28,  3.042813022767037e-02, -2.045456464071957e-04,
  1.405739004556501e-06, -8.527203094401347e-09,  4.758106642575409e-11, -2.496408445791002e-13,  1.247260828784109e-15, -5.984898965649362e-18,  2.775156606987377e-20,
 -1.249291902101672e-22,  5.479642257805755e-25, -2.348511431974358e-27,  2.328902427473140e-02, -2.101293346093360e-04,  1.742457818166851e-06, -1.242672426097479e-08,
  8.041829297701701e-11, -4.841356959960613e-13,  2.752278457980341e-15, -1.492589931692423e-17,  7.778272816978881e-20, -3.916489248677326e-22,  1.913469531935310e-24,
 -9.101427830125924e-27,  1.690643698671234e-02, -1.993514758039723e-04,  1.964170456190954e-06, -1.630996104374758e-08,  1.212507204276396e-10, -8.300580821992026e-13,
  5.324071588349366e-15, -3.237198041201703e-17,  1.881553299330935e-19, -1.051955730125060e-21,  5.684681495146279e-24, -2.980520744758549e-26,  1.164442802664016e-02,
 -1.750502359791765e-04,  2.028415825577116e-06, -1.945123198122414e-08,  1.648176352195697e-10, -1.273780080102591e-12,  9.156024715381264e-15, -6.202121541062072e-17,
  3.996275792838700e-19, -2.466482621557527e-21,  1.466022171463802e-23, -8.427078064301104e-26,  7.612321709662822e-03, -1.427476216932467e-04,  1.929841681603046e-06,
 -2.121807844675665e-08,  2.035772326295784e-10, -1.765546705646145e-12,  1.414304934992348e-14, -1.061690755365374e-16,  7.545841026287107e-19, -5.116728817190635e-21,
  3.329731248958140e-23, -2.089131148353072e-25,  4.725475683492061e-03, -1.084715568335207e-04,  1.698997987530005e-06, -2.128165993482620e-08,  2.299027354437124e-10,
 -2.226031415229574e-12,  1.977816243579639e-14, -1.638044737653272e-16,  1.278769169932837e-18, -9.488189337513953e-21,  6.733921670411991e-23, -4.594282842092960e-25,
  2.786960687558306e-03, -7.704917553986688e-05,  1.389209371274975e-06, -1.971220634341069e-08,  2.385844764199278e-10, -2.567618780839695e-12,  2.519930314108115e-14,
 -2.293709602707354e-16,  1.959639980543843e-18, -1.585484107075609e-20,  1.223106091246759e-22, -9.045008611128043e-25,  1.562549892491810e-03, -5.130408332709544e-05,
  1.058356134635126e-06, -1.692461483845847e-08,  2.284959268614468e-10, -2.722395998669871e-12,  2.940594720448266e-14, -2.931719193446387e-16,  2.732380585034296e-18,
 -2.403242714458661e-20,  2.009322625129721e-22, -1.606087570640572e-24,  8.333963052881563e-04, -3.210493342023137e-05,  7.534016317594385e-07, -1.351421040202772e-08,
  2.027069513297136e-10, -2.664289008048279e-12,  3.157030563274198e-14, -3.437079160195218e-16,  3.484596327489432e-18, -3.322806292079239e-20,  3.003195747144500e-22,
 -2.588200194844246e-24,  4.231748828200047e-04, -1.892495690826629e-05,  5.024491647106259e-07, -1.006583503612090e-08,  1.671309888198273e-10, -2.415476467067377e-12,
  3.130644417541589e-14, -3.711775572190349e-16,  4.082960294444451e-18, -4.210838479778243e-20,  4.104560764454341e-22, -3.805472703591886e-24,  2.047469289898798e-04,
 -1.053121734161196e-05,  3.147009146176688e-07, -7.012913520177937e-09,  1.284591400040228e-10, -2.035399327051608e-12,  2.877672547656974e-14, -3.706326803620348e-16,
  4.413205832215103e-18, -4.911684224288337e-20,  5.152707353460344e-22, -5.128970252760118e-24,  9.448635008096821e-05, -5.543627999864274e-06,  1.855521058631580e-07,
 -4.582178245300714e-09,  9.230552617196328e-11, -1.599004389788921e-12,  2.459902697123494e-14, -3.433813874481168e-16,  4.416446179088418e-18, -5.293632018993634e-20,
  5.965279585772312e-22, -6.363250636441577e-24,  4.163422789340492e-05, -2.765971713117508e-06,  1.032258628768961e-07, -2.814893777583211e-09,  6.217581129971384e-11,
 -1.174510843444316e-12,  1.961511862728582e-14, -2.961274620290089e-16,  4.105794399949429e-18, -5.290176705891238e-20,  6.392172350044143e-22, -7.294801701714089e-24,
  1.753850837684986e-05, -1.310687461816926e-06,  5.430575608354404e-08, -1.629806441672674e-09,  3.936285295208415e-11, -8.088680689524258e-13,  1.463281020523611e-14,
 -2.384379365320132e-16,  3.557207061535574e-18, -4.918317224106370e-20,  6.361776976602006e-22, -7.754883706381133e-24,  7.072726936641862e-06, -5.910403909595288e-07,
  2.707818300340101e-08, -8.915664214438523e-10,  2.348258388641531e-11, -5.237093524950550e-13,  1.024138250731754e-14, -1.797818326582556e-16,  2.880942677381911e-18,
 -4.267405348456993e-20,  5.899778968206319e-22, -7.670475562351477e-24,  2.734580421760472e-06, -2.541523349264820e-07,  1.282643562264313e-08, -4.619356447062635e-10,
  1.323490888246871e-11, -3.196422122335458e-13,  6.743665232041325e-15, -1.273043265766570e-16,  2.187587670361759e-18, -3.466102674763591e-20,  5.114294443193639e-22,
 -7.081985402483987e-24,  1.015391938855204e-06, -1.044380411810067e-07,  5.785342630505475e-09, -2.272510047572891e-10,  7.065556263960907e-12, -1.844056662889895e-13,
  4.189396414096579e-15, -8.490093972387774e-17,  1.561990980558429e-18, -2.643360454136046e-20,  4.156857202168557e-22, -6.122640433505976e-24,  3.627640635126006e-07,
 -4.110439038890947e-08,  2.490874183523553e-09, -1.064254644687701e-10,  3.582471767021321e-12, -1.008360510045812e-13,  2.462352088151327e-15, -5.348185091957934e-17,
  1.051845726559565e-18, -1.898503679329028e-20,  3.177605514924063e-22, -4.971898356676006e-24,  1.249557880813005e-07, -1.553172431538613e-08,  1.026331500278563e-09,
 -4.757334114963713e-11,  1.729932804795389e-12, -5.241030215795159e-14,  1.373233712327662e-15, -3.191531946232574e-17,  6.700086328291478e-19, -1.288011851114433e-20,
  2.291509546599634e-22, -3.804119311996177e-24,  4.159271090804680e-08, -5.648863051988144e-09,  4.057998978643438e-10, -2.035534561305896e-11,  7.978747480700465e-13,
 -2.596864801497445e-14,  7.288301540042068e-16, -1.809670526385019e-17,  4.049368731124233e-19, -8.279788669188114e-21,  1.563798682660694e-22, -2.751043595743918e-24,
  1.341204036150626e-08, -1.982904479534225e-09,  1.544089377393833e-10, -8.361319240641732e-12,  3.525407649554761e-13, -1.230389385709819e-14,  3.692657365990755e-16,
 -9.780533392417433e-18,  2.329368643028282e-19, -5.059226593379711e-21,  1.013118722822731e-22, -1.886439316236422e-24,  4.201324365445491e-09, -6.737880476374077e-10,
  5.671529546113332e-11, -3.307611472639530e-12,  1.497045840271037e-13, -5.592321433968853e-15,  1.791793884644760e-16, -5.054766577557821e-18,  1.279533182543464e-19,
 -2.948067914607908e-21,  6.251539134317956e-23, -1.230609469476937e-24,  1.282346363319362e-09, -2.223355954177605e-10,  2.017529247475659e-11, -1.264290451394370e-12,
  6.130222696763721e-14, -2.446646299260908e-15,  8.355102722949972e-17, -2.506664774747598e-18,  6.734563642202730e-20, -1.643847450271219e-21,  3.686737688992160e-23,
 -7.663199109061888e-25,  3.826409476230707e-10, -7.149144583410850e-11,  6.975245943907469e-12, -4.686176574137370e-13,  2.429345178552973e-14, -1.034047002420453e-15,
  3.757432932573121e-17, -1.197035763369079e-18,  3.408534306133917e-20, -8.802530129557204e-22,  2.085318684033902e-23, -4.571440997728410e-25,  1.120254361462935e-10,
 -2.248405840070238e-11,  2.352666550890072e-12, -1.690765464700958e-13,  9.352589538261564e-15, -4.237955512155969e-16,  1.635908939390365e-17, -5.525606598007985e-19,
  1.665192582615328e-20, -4.543650113698536e-22,  1.135526815640259e-23, -2.622160086392232e-25,  3.230674020727277e-11, -6.944105707247919e-12,  7.772934712454730e-13,
 -5.962244529014069e-14,  3.512140190415149e-15, -1.691146617733683e-16,  6.923219283285501e-18, -2.475461509516303e-19,  7.883674064275863e-21, -2.269702293218701e-22,
  5.976107065035148e-24, -1.451828143636309e-25,  9.216780091071988e-12, -2.115245668852595e-12,  2.526532550517083e-13, -2.063902527303203e-14,  1.292092791442986e-15,
 -6.599155002460008e-17,  2.860207073269961e-18, -1.080883916143667e-19,  3.632337155487079e-21, -1.101811421102758e-22,  3.052279999396802e-24, -7.790963838256604e-26,
  2.613266470452781e-12, -6.384573386419386e-13,  8.117193078694789e-14, -7.045972033945545e-15,  4.678475491521689e-16, -2.529694095754503e-17,  1.158773260735926e-18,
 -4.620603330252405e-20,  1.635930161743002e-21, -5.220652496073318e-23,  1.519486095459505e-24, -4.069535285515917e-26,  7.400616713211705e-13, -1.919102065113692e-13,
  2.590546874852156e-14, -2.384051171457835e-15,  1.675467864279680e-16, -9.572614849642598e-18,  4.625906104302973e-19, -1.943008088208781e-20,  7.235968874953907e-22,
 -2.425636204534012e-23,  7.406471048591338e-25, -2.078373236528240e-26,  2.104479330910197e-13, -5.775273363814709e-14,  8.256249008543395e-15, -8.037019233483741e-16,
  5.965495875271119e-17, -3.594231507937900e-18,  1.828910914771296e-19, -8.077469965882083e-21,  3.158769911486181e-22, -1.110485517144615e-23,  3.551712699451555e-25,
 -1.042710362282074e-26,  6.043280722888710e-14, -1.749881278617948e-14,  2.642496600362576e-15, -2.714489492709205e-16,  2.123315052514315e-17, -1.346293651522870e-18,
  7.199388919456614e-20, -3.337136881357011e-21,  1.367930549542553e-22, -5.034816721030972e-24,  1.683972609817248e-25, -5.163994772175935e-27,  1.762974624385362e-14,
 -5.370188177016287e-15,  8.543674224472234e-16, -9.238925652193859e-17,  7.598538356546739e-18, -5.059214643013962e-19,  2.837372599462715e-20, -1.377649395075817e-21,
  5.908265188885478e-23, -2.272582940724212e-24,  7.934896204261517e-26, -2.537376971024048e-27,  5.257450290393868e-15, -1.679621175945773e-15,  2.807621620885339e-16,
 -3.188028484890664e-17,  2.750291707861880e-18, -1.918565824473736e-19,  1.126027801800477e-20, -5.715000446289910e-22,  2.559201712885625e-23, -1.026765939363026e-24,
  3.735583331724535e-26, -1.243412373761220e-27,  1.613095299776697e-15, -5.388355878787117e-16,  9.437173708495083e-17, -1.122258055235484e-17,  1.013014162954124e-18,
 -7.386277465598518e-20,  4.526341442900119e-21, -2.396114656759293e-22,  1.118009429426421e-23, -4.669101889554599e-25,  1.766558215593524e-26, -6.108929681298782e-28,
  5.125666464290366e-16, -1.784654100202380e-16,  3.265453190791440e-17, -4.055769279993946e-18,  3.820568565826049e-19, -2.904441328330167e-20,  1.853904399177436e-21,
 -1.021249372707875e-22,  4.953866260962773e-24, -2.148865098242117e-25,  8.437154393625429e-27, -3.024991169737272e-28,  1.697815808582526e-16, -6.142254880837412e-17,
  1.170634246031044e-17, -1.514219711951127e-18,  1.484514493102023e-19, -1.173536648322603e-20,  7.782471401576021e-22, -4.450162359081922e-23,  2.238856340423943e-24,
 -1.006381086800457e-25,  4.091332550800566e-27, -1.517517785985152e-28,  5.899887738654633e-17, -2.210644211041616e-17,  4.374902848892391e-18, -5.875926998610900e-19,
  5.978070136590585e-20, -4.900508195550025e-21,  3.367341638612630e-22, -1.993536975530928e-23,  1.037554478240277e-24, -4.821121268635237e-26,  2.024531785046134e-27,
 -7.750343104405456e-29,  2.163642808626858e-17, -8.369148979316916e-18,  1.714309354822007e-18, -2.383312245064932e-19,  2.508648501313820e-20, -2.126242605266829e-21,
  1.509546837651894e-22, -9.226996791306884e-24,  4.954665927389996e-25, -2.373640637775737e-26,  1.026970405537978e-27, -4.047645775608392e-29,  8.416919902212062e-18,
 -3.349899685575997e-18,  7.078632927308592e-19, -1.015332341300597e-19,  1.102204490482387e-20, -9.629118380434750e-22,  7.042111487834257e-23, -4.431217466560851e-24,
  2.447977471396970e-25, -1.205774362322257e-26,  5.360436467196383e-28, -2.169439729606976e-29,  3.486732433562566e-18, -1.423060365133687e-18,  3.091374873483525e-19,
 -4.559329477644606e-20,  5.087526916329161e-21, -4.566407146383100e-22,  3.429265975129753e-23, -2.214571628510922e-24,  1.254872652805569e-25, -6.336413163681616e-27,
  2.886201028578010e-28, -1.196095430720880e-29,  1.540713942530379e-18, -6.426565593537448e-19,  1.430114120235242e-19, -2.161104683867781e-20,  2.470175468629278e-21,
 -2.270216212392327e-22,  1.744882756222094e-23, -1.152708751360277e-24,  6.678589228374752e-26, -3.446479410996692e-27,  1.603617887742094e-28, -6.785118868805832e-30,
  7.247896093176808e-19, -3.079161091060267e-19,  6.993507174461731e-20, -1.078864060122731e-20,  1.258638229600253e-21, -1.180264452536633e-22,  9.252344792715902e-24,
 -6.231672725377188e-25,  3.679535884339558e-26, -1.934335373254852e-27,  9.164979424995641e-29, -3.947038537558488e-30,  3.598145708023820e-19, -1.551534945391211e-19,
  3.583124789691828e-20, -5.621622866984407e-21,  6.669004824085623e-22, -6.357570235743496e-23,  5.065035581757748e-24, -3.465881448234224e-25,  2.078440876395216e-26,
 -1.109352120741954e-27,  5.334836916102587e-29, -2.331076622630482e-30,  1.841361032000465e-19, -8.031062384130082e-20,  1.878639005885966e-20, -2.986003099307688e-21,
  3.588326828071642e-22, -3.464490735159114e-23,  2.794776695913715e-24, -1.935920325545608e-25,  1.174928146551744e-26, -6.345028552320160e-28,  3.086508961696137e-29,
 -1.363843201052207e-30,  9.111394665013167e-20, -4.005452270718971e-20,  9.453583189692226e-21, -1.516266829282078e-21,  1.838571214668024e-22, -1.790906204736597e-23,
  1.457323722803047e-24, -1.018117186089815e-25,  6.230849093941756e-27, -3.392495538131897e-28,  1.663519125773970e-29, -7.408240956800762e-31,  3.399963672123740e-20,
 -1.501241787523486e-20,  3.560866799807108e-21, -5.740222649366665e-22,  6.995388113212890e-23, -6.847790329958625e-24,  5.599398955041944e-25, -3.930517661708479e-26,
  2.416705377101282e-27, -1.321837374013731e-28,  6.510688276479372e-30, -2.912108729120809e-31,  5.156801956212027e-02, -1.093841323650509e-04,  2.392637886094814e-07,
 -5.373394270329924e-10,  1.232203760877642e-12, -2.870039130106980e-15,  6.756433421679508e-18, -1.601757061932800e-20,  3.811673047605868e-23, -9.089281980682315e-26,
  2.167482168266176e-28, -5.167395166987132e-31,  4.878509405263848e-02, -1.249633465092599e-04,  3.764275246413161e-07, -1.193391212630869e-09,  3.786307186187173e-12,
 -1.184001398263977e-14,  3.639813818324820e-17, -1.101322712974914e-19,  3.285887601587687e-22, -9.684171495764044e-25,  2.823247436048339e-27, -8.151348374356881e-30,
  4.366376095428449e-02, -1.503347467506680e-04,  6.308693914194414e-07, -2.595476793099927e-09,  1.020887584813907e-11, -3.865410423595500e-14,  1.419647502391807e-16,
 -5.084919833457814e-19,  1.782992233665578e-21, -6.137450184156334e-24,  2.078419717095935e-26, -6.936332580105539e-29,  3.697633714456302e-02, -1.762770207483038e-04,
  9.614405906754665e-07, -4.823454709401507e-09,  2.260964707243897e-11, -1.007950616912601e-13,  4.319103107492295e-16, -1.791145622619513e-18,  7.223889080374822e-21,
 -2.843904916816928e-23,  1.096011876792507e-25, -4.144471472706018e-28,  2.963180918250295e-02, -1.936964672322153e-04,  1.307820703826578e-06, -7.804277361207098e-09,
  4.287451990411457e-11, -2.216211703351176e-13,  1.091469271510106e-15, -5.164771867967367e-18,  2.362496034777884e-20, -1.049452556248971e-22,  4.543339215088932e-25,
 -1.922362581956973e-27,  2.247547176929342e-02, -1.967649943072630e-04,  1.600749002800766e-06, -1.121404150972777e-08,  7.136367413018852e-11, -4.228273712631797e-13,
  2.367181285362485e-15, -1.264841879713005e-17,  6.496973715945811e-20, -3.225563197458062e-22,  1.554314782855363e-24, -7.293707983431952e-27,  1.613926320560678e-02,
 -1.843892281531644e-04,  1.779564829830009e-06, -1.449611259454321e-08,  1.058572895865387e-10, -7.125104642847837e-13,  4.496555175839835e-15, -2.691549273065479e-17,
  1.540804117318669e-19, -8.487817729744979e-22,  4.520838410166882e-24, -2.336943118896157e-26,  1.097526427387920e-02, -1.597135995180723e-04,  1.810019962052531e-06,
 -1.700658063046878e-08,  1.414059496925717e-10, -1.073507733242418e-12,  7.585881999682665e-15, -5.054752382551220e-17,  3.205530965683239e-19, -1.948038202452540e-21,
  1.140509517027523e-23, -6.459794901532094e-26,  7.070670896380254e-03, -1.282745516355743e-04,  1.693659985911670e-06, -1.822585139350873e-08,  1.714332503997500e-10,
 -1.459219193252323e-12,  1.148241075753170e-14, -8.472952663397257e-17,  5.922940725586715e-19, -3.952063308334990e-21,  2.531762401792736e-23, -1.564302568401678e-25,
  4.317240041505918e-03, -9.584178249095278e-05,  1.464299024055223e-06, -1.793507056428001e-08,  1.897799805678092e-10, -1.802067753486462e-12,  1.571666497926374e-14,
 -1.278663208487918e-16,  9.811710262322662e-19, -7.159523970957733e-21,  4.999342733908981e-23, -3.357216693871661e-25,  2.499579934886590e-03, -6.682049113431873e-05,
  1.173973144750233e-06, -1.627487639689270e-08,  1.927942209820158e-10, -2.033313558357334e-12,  1.957533504016119e-14, -1.749233517201535e-16,  1.468109340058547e-18,
 -1.167504654797283e-20,  8.856973009705992e-23, -6.443771529694271e-25,  1.373063571108835e-03, -4.359136695338812e-05,  8.755165755456452e-07, -1.366854097145677e-08,
  1.804883821962209e-10, -2.106025938026862e-12,  2.230148356901684e-14, -2.181556801229085e-16,  1.996322512097523e-18, -1.724997525723593e-20,  1.417634996092673e-22,
 -1.114307531412698e-24,  7.160767361108255e-04, -2.667506380146737e-05,  6.090574723450960e-07, -1.065907653190172e-08,  1.562792297981866e-10, -2.010514839836144e-12,
  2.334307582292320e-14, -2.492276284590166e-16,  2.479703466292651e-18, -2.321994925168258e-20,  2.061972093762737e-22, -1.746818071017100e-24,  3.548088899710909e-04,
 -1.534648686301318e-05,  3.962326904902827e-07, -7.740676722670489e-09,  1.255639218077638e-10, -1.775368499076580e-12,  2.253557403210664e-14, -2.619095818056358e-16,
  2.826207884539245e-18, -2.861117753014189e-20,  2.739150494524426e-22, -2.495497054620437e-24,  1.671698292528350e-04, -8.318155418290627e-06,  2.416472263931366e-07,
 -5.248967249348781e-09,  9.389299833807108e-11, -1.454834163979114e-12,  2.013629880642038e-14, -2.541268981734010e-16,  2.967311573546134e-18, -3.240627814022542e-20,
  3.337922487634036e-22, -3.263911845988311e-24,  7.496491118064765e-05, -4.256285825676298e-06,  1.384675742941954e-07, -3.332056107772956e-09,  6.552603683338468e-11,
 -1.109642863822247e-12,  1.670633480605926e-14, -2.284386919120926e-16,  2.880285602410819e-18, -3.386731119143361e-20,  3.746117448996400e-22, -3.924511911357430e-24,
  3.202973818403640e-05, -2.059999952601500e-06,  7.471658676139977e-08, -1.984997363415702e-09,  4.279146332577881e-11, -7.899979626202599e-13,  1.290849099787493e-14,
 -1.908454231506264e-16,  2.593362629389171e-18, -3.277170342029717e-20,  3.886018022738355e-22, -4.354471983084255e-24,  1.305442316088818e-05, -9.448813341450067e-07,
  3.804918109239706e-08, -1.112396362838232e-09,  2.621671341105970e-11, -5.264085782129192e-13,  9.315489322620655e-15, -1.486240867117953e-16,  2.172729334839384e-18,
 -2.945769864028843e-20,  3.738653191196996e-22, -4.474135964932530e-24,  5.082124824246818e-06, -4.115399201749742e-07,  1.832706344345641e-08, -5.878246141507843e-10,
  1.510694316641152e-11, -3.291770376041157e-13,  6.296208963152997e-15, -1.082053617225608e-16,  1.698896645059505e-18, -2.467347839268358e-20,  3.346628509879010e-22,
 -4.271154504179931e-24,  1.892593849480063e-06, -1.705480757794487e-07,  8.368282036512230e-09, -2.936092289758544e-10,  8.208276466389857e-12, -1.936837536703737e-13,
  3.996566881261164e-15, -7.385721159969482e-17,  1.243423447098688e-18, -1.931539386017449e-20,  2.795944848360685e-22, -3.800376191498465e-24,  6.753180701020157e-07,
 -6.738995709701517e-08,  3.630625939398906e-09, -1.389609078165664e-10,  4.216181339920229e-12, -1.075150986563791e-13,  2.389030373272748e-15, -4.739667095083248e-17,
  8.543200182474500e-19, -1.417451532949795e-20,  2.186746739725005e-22, -3.161567420982082e-24,  2.313092441240333e-07, -2.544607217025245e-08,  1.500292579638050e-09,
 -6.247679911616240e-11,  2.052683777149955e-12, -5.645939899881972e-14,  1.348624990548954e-15, -2.867806120602700e-17,  5.526294267017675e-19, -9.779842431350469e-21,
  1.605938413350992e-22, -2.466652653533952e-24,  7.620689115591170e-08, -9.203429330400025e-09,  5.919986100012240e-10, -2.675453820227628e-11,  9.498286064168982e-13,
 -2.812595528822717e-14,  7.209981550767420e-16, -1.640814639938824e-17,  3.375520680396868e-19, -6.363198887490835e-21,  1.110809423334737e-22, -1.810427158711946e-24,
  2.420424308088874e-08, -3.196555628011568e-09,  2.236567593239342e-10, -1.094302146647594e-11,  4.189165922620108e-13, -1.333044773668089e-14,  3.661274323369800e-16,
 -8.903810595772155e-18,  1.952788852561055e-19, -3.916228346136882e-21,  7.258937710078127e-23, -1.253941503138125e-24,  7.429666368002800e-09, -1.069066160649958e-09,
  8.113409310824087e-11, -4.287633694649110e-12,  1.766336348125877e-13, -6.029363850950075e-15,  1.771426185552565e-16, -4.596726812552514e-18,  1.073341589988680e-19,
 -2.287069869173593e-21,  4.495814758591280e-23, -8.222123575251040e-25,  2.210174552473685e-09, -3.453027059491141e-10,  2.834763891229955e-11, -1.614362017119873e-12,
  7.142736756562415e-14, -2.610856398316016e-15,  8.192412264695847e-17, -2.265116956063428e-18,  5.623510696736277e-20, -1.271550154350793e-21,  2.647729454177336e-23,
 -5.120743859557356e-25,  6.391254113776437e-10, -1.080588899158717e-10,  9.570948660108865e-12, -5.860618319584356e-13,  2.779534921274037e-14, -1.086072329701564e-15,
  3.633984869142061e-17, -1.069028212525913e-18,  2.818076488470599e-20, -6.753351708266896e-22,  1.487844705728219e-23, -3.039573663600159e-25,  1.802619947478687e-10,
 -3.287744828331262e-11,  3.133731729824608e-12, -2.058766829621794e-13,  1.044640747090934e-14, -4.355856806864852e-16,  1.551715600244004e-17, -4.849729711198889e-19,
  1.355637716013672e-20, -3.438767167246084e-22,  8.006105937214571e-24, -1.725752797487000e-25,  4.977144483644317e-11, -9.762376537860988e-12,  9.988591649514672e-13,
 -7.025391732221431e-14,  3.806547356958439e-15, -1.690862462226760e-16,  6.402874854914296e-18, -2.122976759732898e-19,  6.284078526163617e-21, -1.685141208448057e-22,
  4.141026157658151e-24, -9.407282851090763e-26,  1.350721852043916e-11, -2.840643298066566e-12,  3.112306313888549e-13, -2.338507597052666e-14,  1.350417961419732e-15,
 -6.379100789636496e-17,  2.563650382594381e-18, -9.004253148068051e-20,  2.818442561499411e-21, -7.979373597362916e-23,  2.067055907971987e-24, -4.942990398169174e-26,
  3.618872343706798e-12, -8.136089902558442e-13,  9.522227863223386e-14, -7.626988399615032e-15,  4.685018414891139e-16, -2.349354383001709e-17,  1.000391528709375e-18,
 -3.716333739765090e-20,  1.228339142760931e-21, -3.666515485620913e-23,  9.999730112461140e-25, -2.514028538480109e-26,  9.617928739332734e-13, -2.304862008163083e-13,
  2.874523416104265e-14, -2.449054034198412e-15,  1.597098342809710e-16, -8.486505809612727e-18,  3.822449362545450e-19, -1.499537530669156e-20,  5.225848818457174e-22,
 -1.642308014100665e-23,  4.709297755172788e-25, -1.243143471609604e-26,  2.548836225536369e-13, -6.491724824068838e-14,  8.606231532008362e-15, -7.782314178020464e-16,
  5.377041712405699e-17, -3.021976964213361e-18,  1.437270638013839e-19, -5.944462194859623e-21,  2.180887464840306e-22, -7.205288135332599e-24,  2.169230644780236e-25,
 -6.004313701865675e-27,  6.772964976764037e-14, -1.828028617063141e-14,  2.569729431946613e-15, -2.460764264922866e-16,  1.797653180150546e-17, -1.066510027702096e-18,
  5.346360988597779e-20, -2.327260159201205e-21,  8.973831215527640e-23, -3.111999041208146e-24,  9.821954025629757e-26, -2.846575303877630e-27,  1.815461995693734e-14,
 -5.177251581518119e-15,  7.697557980489519e-16, -7.787852141523401e-17,  6.002357483402057e-18, -3.751604898942642e-19,  1.978471601583617e-20, -9.047824251965380e-22,
  3.660501077708697e-23, -1.330235010016511e-24,  4.394421339058393e-26, -1.331459591755842e-27,  4.939963047094943e-15, -1.484057923993034e-15,  2.327678481075622e-16,
 -2.482160331487030e-17,  2.013862635504053e-18, -1.323256373551958e-19,  7.326651795545064e-21, -3.513317898301236e-22,  1.488615712885102e-23, -5.658918737575207e-25,
  1.953378537680677e-26, -6.177359366422271e-28,  1.373696757131117e-15, -4.334316391059407e-16,  7.152289288622225e-17, -8.018850401302739e-18,  6.832657825369538e-19,
 -4.709306678659229e-20,  2.731786005586399e-21, -1.370802510489935e-22,  6.071031889044681e-24, -2.409690921626114e-25,  8.675749242408889e-27, -2.858584479282570e-28,
  3.931068975031435e-16, -1.298695216711571e-16,  2.248415240745569e-17, -2.643465102486418e-18,  2.359707774873488e-19, -1.701995215117755e-20,  1.032046861565172e-21,
 -5.407615048997939e-23,  2.498113861035329e-24, -1.033205197270755e-25,  3.872405396933709e-27, -1.326885120525317e-28,  1.165965410015130e-16, -4.020567057819091e-17,
  7.281938935946739e-18, -8.953436846271488e-19,  8.351279182260787e-20, -6.287894576316586e-21,  3.976117878071563e-22, -2.170416684139102e-23,  1.043523107923117e-24,
 -4.487628040144113e-26,  1.747242679069363e-27, -6.213460511851338e-29,  3.610300190150521e-17, -1.295270509047591e-17,  2.446835198276915e-18, -3.137252117989514e-19,
  3.049295042110341e-20, -2.390328850205064e-21,  1.572241815592507e-22, -8.918929415420655e-24,  4.452359959203321e-25, -1.986291562805164e-26,  8.015822802123617e-28,
 -2.951953774180760e-29,  1.175323863397372e-17, -4.372926208102573e-18,  8.588943328617578e-19, -1.144930137527648e-19,  1.156262208945928e-20, -9.410321321677486e-22,
  6.420924852443085e-23, -3.775382445616043e-24,  1.951873114916984e-25, -9.010905562814991e-27,  3.760088360906516e-28, -1.430619806364765e-29,  4.049849924948235e-18,
 -1.557415468465052e-18,  3.170125570208621e-19, -4.379615727228844e-20,  4.581526721147293e-21, -3.859749555504946e-22,  2.724164220219878e-23, -1.655588849594068e-24,
  8.840485779032461e-26, -4.212200749999175e-27,  1.812780873358428e-28, -7.108000460393631e-30,  1.485858149518708e-18, -5.885996659088667e-19,  1.237423776058125e-19,
 -1.765856644884123e-20,  1.907318730932589e-21, -1.658093052777874e-22,  1.206806740816463e-23, -7.558269198321147e-25,  4.156451620943442e-26, -2.038205243911665e-27,
  9.021896181136769e-29, -3.635912139731463e-30,  5.831862380303501e-19, -2.371524080729104e-19,  5.131163344023308e-20, -7.537351117944280e-21,  8.377297797377431e-22,
 -7.490092813523890e-23,  5.603615644634523e-24, -3.605385236501220e-25,  2.035618467331498e-26, -1.024269716466278e-27,  4.649539777942390e-29, -1.920449433109276e-30,
  2.454883042074734e-19, -1.021188432367769e-19,  2.265638723311560e-20, -3.413351684926097e-21,  3.889879840211134e-22, -3.564550149582902e-23,  2.731880598834154e-24,
 -1.799710709001238e-25,  1.039884683621270e-26, -5.352081928958839e-28,  2.483837844726927e-29, -1.048300922852407e-30,  1.106995968528799e-19, -4.693886764263236e-20,
  1.063817805127041e-20, -1.637583648187052e-21,  1.906399149440167e-22, -1.783964147068909e-23,  1.395636840871035e-24, -9.381229282970750e-26,  5.528450287700177e-27,
 -2.900800858028014e-28,  1.371871865034924e-29, -5.897543759741800e-31,  5.304776342900384e-20, -2.284569609593895e-20,  5.268589137308831e-21, -8.254247185385409e-22,
  9.778382773980040e-23, -9.308903219474394e-24,  7.406343868299590e-25, -5.061302879228675e-26,  3.031285795877677e-27, -1.615892379673000e-28,  7.761237397930207e-30,
 -3.387250947500115e-31,  2.640554100782233e-20, -1.150822278936986e-20,  2.689785984542892e-21, -4.271685655453995e-22,  5.129076124537315e-23, -4.948012235569288e-24,
  3.988317811185336e-25, -2.760507004724566e-26,  1.674090569511847e-27, -9.033893986116003e-29,  4.391269690725694e-30, -1.938993368998359e-31,  1.281310891966740e-20,
 -5.630643023287226e-21,  1.328367776473748e-21, -2.129658929616896e-22,  2.581241704236111e-23, -2.513260417283671e-24,  2.044279604230847e-25, -1.427595052496315e-26,
  8.733352078346730e-28, -4.753165728155314e-29,  2.329833245234934e-30, -1.037168616609012e-31,  4.729010150414256e-21, -2.087717636036868e-21,  4.950984610092125e-22,
 -7.979532265266354e-23,  9.722398740304761e-24, -9.515370778547739e-25,  7.779135282315486e-26, -5.459532303412455e-27,  3.356188545206672e-28, -1.835349690850032e-29,
  9.038306266656607e-31, -4.041927562950206e-32,  5.113427088296725e-02, -1.074954834952158e-04,  2.329321409487156e-07, -5.180747127762773e-10,  1.176388894156316e-12,
 -2.713131766334183e-15,  6.324537504905716e-18, -1.484855966690743e-20,  3.499532242701116e-23, -8.266077946305737e-26,  1.952581456082572e-28, -4.612086510846515e-31,
  4.829117423986030e-02, -1.220081969083571e-04,  3.624626521019406e-07, -1.134658264204488e-09,  3.557998686458920e-12, -1.100230638364389e-14,  3.345655270095155e-17,
 -1.001541260867039e-19,  2.956749564552170e-22, -8.623427946659528e-25,  2.488051734077341e-27, -7.110038612901006e-30,  4.307232246554005e-02, -1.454096552662348e-04,
  6.006787969807157e-07, -2.438139041581862e-09,  9.468744518306321e-12, -3.541155480056885e-14,  1.284936496574717e-16, -4.548167312228722e-19,  1.576301517725745e-21,
 -5.364027934274537e-24,  1.796037819275589e-26, -5.927205102579722e-29,  3.628625401308222e-02, -1.688110216570864e-04,  9.056649144442246e-07, -4.477280948641747e-09,
  2.069347308801234e-11, -9.100583418504522e-14,  3.848464555684889e-16, -1.575550351329458e-18,  6.274792070204964e-21, -2.439895697243921e-23,  9.289376774869030e-26,
 -3.470820991424826e-28,  2.887737135080046e-02, -1.835971729007951e-04,  1.218143539055339e-06, -7.152368829254780e-09,  3.869276255343597e-11, -1.970792127847872e-13,
  9.568957580811672e-16, -4.465873094808012e-18,  2.015464897537864e-20, -8.835677430179737e-23,  3.776001097555852e-25, -1.577488443210456e-27,  2.171319808981279e-02,
 -1.844784885819182e-04,  1.472762031181750e-06, -1.013690461824339e-08,  6.344773373706674e-11, -3.700402741083346e-13,  2.040468374332991e-15, -1.074378091016829e-17,
  5.440357556725665e-20, -2.663565810413640e-22,  1.266089730583614e-24, -5.862087625549750e-27,  1.542911689352561e-02, -1.708207758900275e-04,  1.615321838277747e-06,
 -1.291078068884368e-08,  9.262797323871037e-11, -6.131066249696675e-13,  3.807593445054513e-15, -2.244083305645921e-17,  1.265458325348798e-19, -6.869537150106999e-22,
  3.606830677734891e-24, -1.838472390129602e-26,  1.036412992178811e-02, -1.460128630449332e-04,  1.618838226927289e-06, -1.490641584111739e-08,  1.216474914791047e-10,
 -9.073331972227108e-13,  6.304213288622075e-15, -4.132912057100115e-17,  2.579935976653387e-19, -1.543996439852157e-21,  8.905314407984343e-24, -4.970645398346158e-26,
  6.583349108836624e-03, -1.155556073590565e-04,  1.490490663496368e-06, -1.570219110473697e-08,  1.448230139005697e-10, -1.210093513552829e-12,  9.355262411444281e-15,
 -6.786976421984527e-17,  4.667029899485596e-19, -3.064746926037785e-21,  1.933032565222660e-23, -1.176357177903793e-25,  3.956008055388969e-03, -8.493926531670629e-05,
  1.266170899101290e-06, -1.516758356086937e-08,  1.572379978353394e-10, -1.464508002086653e-12,  1.253981817567985e-14, -1.002339368891897e-16,  7.561257468901999e-19,
 -5.426844228271568e-21,  3.728921398842400e-23, -2.465058306115957e-25,  2.249914807549297e-03, -5.816039270587705e-05,  9.959192418902158e-07, -1.349154729860853e-08,
  1.564551768901507e-10, -1.617336298944133e-12,  1.527658029913059e-14, -1.340367825674449e-16,  1.105286287727681e-18, -8.640805114825219e-21,  6.447144506613987e-23,
 -4.615214010538647e-25,  1.211732872481589e-03, -3.719725350479782e-05,  7.275198156048727e-07, -1.109056382346660e-08,  1.432604499628582e-10, -1.637408863753708e-12,
  1.700140040625144e-14, -1.632041593164649e-16,  1.466580874104890e-18, -1.245167243851955e-20,  1.005976060067070e-22, -7.776911759599364e-25,  6.183675282946629e-04,
 -2.227460112279148e-05,  4.949169062999529e-07, -8.452072547107299e-09,  1.211492818909088e-10, -1.525773884625808e-12,  1.736047685366071e-14, -1.817991059049558e-16,
  1.775407131818907e-18, -1.632781274072100e-20,  1.424786149456883e-22, -1.186643599020043e-24,  2.992192590912955e-04, -1.251654374612066e-05,  3.143157580040702e-07,
 -5.988647548605230e-09,  9.492011533955357e-11, -1.313177891259270e-12,  1.632732022966799e-14, -1.860340316499269e-16,  1.969527820789799e-18, -1.957435784829099e-20,
  1.840785679297922e-22, -1.648143760649872e-24,  1.373979822443118e-04, -6.613441165141124e-06,  1.867920383735493e-07, -3.955434207873112e-09,  6.910386017239339e-11,
 -1.047212173508040e-12,  1.419158155287428e-14, -1.755191595411910e-16,  2.009978790513089e-18, -2.154258535121594e-20,  2.178892263011837e-22, -2.093207923704549e-24,
  5.992511705216463e-05, -3.292216046650230e-06,  1.041060831771959e-07, -2.441398147344339e-09,  4.687399845108780e-11, -7.760620737780499e-13,  1.143594304415392e-14,
 -1.531924232732925e-16,  1.893733562677126e-18, -2.184605572293409e-20,  2.372140989445621e-22, -2.440857444124713e-24,  2.484932025169686e-05, -1.547007670469167e-06,
  5.453313908677004e-08, -1.411562063316551e-09,  2.970090603416927e-11, -5.359321071091055e-13,  8.568681430904685e-15, -1.240731948400714e-16,  1.652574582572919e-18,
 -2.048317877088854e-20,  2.383786212696664e-22, -2.623004780962504e-24,  9.808246378838728e-06, -6.874796761721961e-07,  2.690559697173617e-08, -7.662920814269694e-10,
  1.762397293782819e-11, -3.458034282235408e-13,  5.986514128300560e-15, -9.352412149298031e-17,  1.339840137875306e-18, -1.781401774431735e-20,  2.218512987087403e-22,
 -2.606642634676932e-24,  3.689726335265292e-06, -2.894816124448691e-07,  1.253020314610425e-08, -3.915008558083223e-10,  9.817658236252003e-12, -2.090185405131263e-13,
  3.910518846633561e-15, -6.579709996862442e-17,  1.012220990037051e-18, -1.441431905222426e-20,  1.918216345365724e-22, -2.403295241810171e-24,  1.324782348577792e-06,
 -1.157261403544634e-07,  5.520273065418806e-09, -1.886844415740148e-10,  5.147036912790561e-12, -1.186586875166395e-13,  2.394763045276828e-15, -4.332480246668181e-17,
  7.146239517282792e-19, -1.088384600442276e-20,  1.545610989640097e-22, -2.062238194555538e-24,  4.547137914914793e-07, -4.401348864737378e-08,  2.305868588770277e-09,
 -8.599025925321208e-11,  2.545915633116372e-12, -6.343169666911658e-14,  1.378568731875782e-15, -2.677428102262905e-17,  4.728217857555297e-19, -7.691240926439184e-21,
  1.164047168015995e-22, -1.651990424783663e-24,  1.494693840264056e-07, -1.595990331215504e-08,  9.153943071430346e-10, -3.714958809987625e-11,  1.191216988673546e-12,
 -3.201566083791970e-14,  7.480318683085276e-16, -1.557281093856288e-17,  2.940211713282939e-19, -5.101590477509769e-21,  8.218699784525097e-23, -1.239172779364693e-24,
  4.714702147649166e-08, -5.530642959726114e-09,  3.462307566389216e-10, -1.525393516942939e-11,  5.286457309548197e-13, -1.529902067081424e-14,  3.836704670389741e-16,
 -8.549246011293827e-18,  1.723399399715276e-19, -3.185629245930455e-21,  5.456355604865200e-23, -8.730428887146138e-25,  1.430245829780067e-08, -1.836156200508701e-09,
  1.251006171007580e-10, -5.969348532593527e-12,  2.231461485915945e-13, -6.941561802427765e-15,  1.865565514844155e-16, -4.443090178336895e-18,  9.550377770021640e-20,
 -1.878371862955814e-21,  3.416645757554384e-23, -5.795131180161361e-25,  4.183087270432095e-09, -5.856113121458257e-10,  4.330352300571605e-11, -2.232842909662803e-12,
  8.985836260991122e-14, -2.999544333931238e-15,  8.625882415522261e-17, -2.192697203949609e-18,  5.019187373686855e-20, -1.049121768504418e-21,  2.024258181759316e-23,
 -3.635758155826769e-25,  1.182789860292402e-09, -1.799510520992271e-10,  1.440403874160455e-11, -8.008152977248105e-13,  3.462965633840581e-14, -1.238361938955880e-15,
  3.804847053426676e-17, -1.030898823079527e-18,  2.509797157307280e-20, -5.568623980070084e-22,  1.138479421722925e-23, -2.163016772689126e-25,  3.243152887012281e-10,
 -5.344886185838903e-11,  4.619302520703776e-12, -2.763164427805971e-13,  1.281532950836458e-14, -4.901331431509543e-16,  1.606559042045925e-17, -4.633248129668003e-19,
  1.198191532234862e-20, -2.818632858404807e-22,  6.099146886519353e-24, -1.224472902509364e-25,  8.652517488473352e-11, -1.539867094584776e-11,  1.433351633699061e-12,
 -9.205590901594353e-14,  4.570697025440824e-15, -1.866540542110347e-16,  6.517260055022213e-18, -1.997876153897715e-19,  5.481187191729035e-21, -1.365438953878412e-22,
  3.123689358334761e-24, -6.619548551578047e-26,  2.254506953545470e-11, -4.319668938639762e-12,  4.320146764012758e-13, -2.972783775681165e-14,  1.577268016788774e-15,
 -6.866183114853612e-17,  2.549971404122557e-18, -8.297579904194457e-20,  2.411916670943843e-21, -6.355051820385630e-23,  1.535260902425493e-24, -3.430432038946012e-26,
  5.760728826378775e-12, -1.184825372353941e-12,  1.270115640291050e-13, -9.344922760807281e-15,  5.288474789263671e-16, -2.450035442289088e-17,  9.663222604953010e-19,
 -3.333012565249686e-20,  1.025130291258233e-21, -2.853350507599333e-23,  7.270667831372693e-25, -1.711033029093271e-26,  1.450031058048867e-12, -3.192075145257632e-13,
  3.659085842809304e-14, -2.872580162116760e-15,  1.730740600868159e-16, -8.518642599519119e-18,  3.562637972223571e-19, -1.300632450224236e-20,  4.227038793858617e-22,
 -1.241288775782411e-23,  3.332095639542507e-25, -8.249184550819047e-27,  3.613203151092711e-13, -8.489052876252204e-14,  1.038097915164682e-14, -8.677513375829680e-16,
  5.555688634858261e-17, -2.900137453540579e-18,  1.284021795790610e-19, -4.954154677466894e-21,  1.698929212712006e-22, -5.256412004376156e-24,  1.484582316887962e-25,
 -3.861665790277184e-27,  8.960973454265867e-14, -2.240514429856063e-14,  2.915860626844652e-15, -2.589734107521725e-16,  1.758477415208536e-17, -9.718083301480678e-19,
  4.547373221640987e-20, -1.851355133260185e-21,  6.689205460742371e-23, -2.177474817364580e-24,  6.461790749015115e-26, -1.763751185305413e-27,  2.224815789170883e-14,
 -5.902845186761593e-15,  8.155753497732918e-16, -7.679525845256943e-17,  5.519287153566016e-18, -3.223141576616181e-19,  1.591203273608807e-20, -6.824480937781736e-22,
  2.593898045377656e-23, -8.870477167518494e-25,  2.761913817301835e-26, -7.899685680119745e-28,  5.564591480017096e-15, -1.562110426412107e-15,  2.285690499518804e-16,
 -2.276612463943251e-17,  1.728213087145336e-18, -1.064381878163051e-19,  5.533629577837178e-21, -2.495803924784949e-22,  9.962531179123710e-24, -3.573452712771542e-25,
  1.165603671757206e-26, -3.488391001821532e-28,  1.411521466127996e-15, -4.180173263285633e-16,  6.460858056176222e-17, -6.791164822044816e-18,  5.433281101547060e-19,
 -3.521860972166595e-20,  1.924439773668976e-21, -9.110764721768476e-23,  3.812581048709051e-24, -1.431930423047046e-25,  4.885087917477153e-27, -1.527328445582678e-28,
  3.657194072438289e-16, -1.139136858049435e-16,  1.854854435208644e-17, -2.052491855616274e-18,  1.726670535232246e-19, -1.175393410466565e-20,  6.736500462626997e-22,
 -3.340981822747706e-23,  1.462909578575616e-24, -5.742618962379842e-26,  2.045413615679007e-27, -6.669357697751078e-29,  9.751218976348564e-17, -3.184723619594898e-17,
  5.448100387361607e-18, -6.330184268302168e-19,  5.585963860346121e-20, -3.984101770634967e-21,  2.389678569433335e-22, -1.238929070058671e-23,  5.664760414696970e-25,
 -2.319570335300189e-26,  8.609369909636319e-28, -2.922225465854962e-29,  2.696368390651912e-17, -9.204677450806407e-18,  1.649567360680371e-18, -2.007073237055046e-19,
  1.853014227505104e-20, -1.381333755339212e-21,  8.650429578255479e-23, -4.677590008778143e-24,  2.228403720410844e-25, -9.497944348380193e-27,  3.665988093459582e-28,
 -1.292716807548453e-29,  7.793403304519740e-18, -2.771851863847719e-18,  5.188120921425072e-19, -6.591457861910608e-20,  6.349522185198283e-21, -4.934074059762917e-22,
  3.217908783242737e-23, -1.810391946377013e-24,  8.965042481578656e-26, -3.968267485442941e-27,  1.589250299448170e-28, -5.809431569000525e-30,  2.373012405795063e-18,
 -8.764308920365151e-19,  1.707906395463635e-19, -2.258909439156713e-20,  2.263797569549021e-21, -1.828634847290664e-22,  1.238639521911859e-23, -7.231302923910311e-25,
  3.712763385406202e-26, -1.702486861179470e-27,  7.057648788975787e-29, -2.668168765117011e-30,  7.669386443198064e-19, -2.931423556229571e-19,  5.927792734138405e-20,
 -8.135816029798126e-21,  8.456195970940396e-22, -7.079262283254039e-23,  4.965860071880029e-24, -2.999954742958768e-25,  1.592601267005748e-26, -7.545269549692639e-28,
  3.229311344602635e-29, -1.259442769973902e-30,  2.648951405171693e-19, -1.044198000271937e-19,  2.183530896498523e-20, -3.099368480976941e-21,  3.330093402337750e-22,
 -2.880102096766002e-23,  2.085723950395951e-24, -1.299919930797221e-25,  7.114536384864745e-27, -3.472599982301042e-28,  1.530169616817230e-29, -6.139670640797841e-31,
  9.832497424526542e-20, -3.983100759541407e-20,  8.581951351373032e-21, -1.255335862746557e-21,  1.389453616632919e-22, -1.237269931609375e-23,  9.219862968271084e-25,
 -5.909207732605296e-26,  3.323822091777395e-27, -1.666330430463680e-28,  7.537073861675846e-30, -3.102308838893353e-31,  3.935723476262765e-20, -1.632518175086973e-20,
  3.610533176463334e-21, -5.422292215837775e-22,  6.159970235255374e-23, -5.627499182065400e-24,  4.300028883675771e-25, -2.824508135156086e-26,  1.627373584617418e-27,
 -8.352525293719969e-29,  3.865819721852498e-30, -1.627272356674521e-31,  1.698384955871408e-20, -7.186974049338440e-21,  1.625197448065568e-21, -2.496090976037084e-22,
  2.899354890915835e-23, -2.707218064999472e-24,  2.113393442934602e-25, -1.417622085850126e-26,  8.337175704890296e-28, -4.365862520957651e-29,  2.060742044327517e-30,
 -8.842239877158829e-32,  7.844567500497329e-21, -3.373905120076694e-21,  7.769294344588342e-22, -1.215394509953954e-22,  1.437695307728570e-23, -1.366690704930984e-24,
  1.085827936895797e-25, -7.410012721017823e-27,  4.431973609134416e-28, -2.359447967391099e-29,  1.131801907634696e-30, -4.933366056436847e-32,  3.793494356478995e-21,
 -1.652021704019589e-21,  3.857860799794536e-22, -6.121317459861734e-23,  7.343537938054984e-24, -7.078220038514784e-25,  5.700562233247324e-26, -3.942387837686793e-27,
  2.388911240363212e-28, -1.288114849904887e-29,  6.256566775503333e-31, -2.760560735434498e-32,  1.803559025133695e-21, -7.922516956231473e-22,  1.868231346046908e-22,
 -2.993825996944609e-23,  3.627026537169788e-24, -3.529944964597207e-25,  2.870004016097015e-26, -2.003376675942324e-27,  1.225060661288443e-28, -6.664726046677325e-30,
  3.265506386719531e-31, -1.453133441089270e-32,  6.580414703546878e-22, -2.904540150442004e-22,  6.886666817106509e-23, -1.109698203378611e-23,  1.351795275840113e-24,
 -1.322738637808668e-25,  1.081163901180957e-26, -7.586277527194489e-28,  4.662662176231660e-29, -2.549306162570136e-30,  1.255183034469054e-31, -5.612118938586359e-33,
  5.070797693592626e-02, -1.056565780471316e-04,  2.268264133962839e-07, -4.996784834718078e-10,  1.123611113815161e-12, -2.566208135880136e-15,  5.924018900083374e-18,
 -1.377485335864281e-20,  3.215536599790654e-23, -7.524142088399394e-26,  1.760675048158657e-28, -4.120811056573717e-31,  4.780885596520667e-02, -1.191620079572993e-04,
  3.491811980439599e-07, -1.079447961490391e-09,  3.345760388178108e-12, -1.023195975763550e-14,  3.078016603186896e-17, -9.117062448063074e-20,  2.663491335377652e-22,
 -7.688032098373367e-25,  2.195477958089756e-27, -6.210339838621646e-30,  4.250011297303834e-02, -1.407187328239289e-04,  5.723072874977766e-07, -2.292141651882697e-09,
  8.790349092279800e-12, -3.247499931937267e-14,  1.164368939198112e-16, -4.073310511953947e-19,  1.395523471179174e-21, -4.695156199553057e-24,  1.554534821215977e-26,
 -5.073628309484046e-29,  3.562516805966907e-02, -1.617751183436805e-04,  8.538656381951193e-07, -4.160259074099532e-09,  1.896226011575666e-11, -8.227700120903718e-14,
  3.434150504349235e-16, -1.388122491809416e-18,  5.459790569114092e-21, -2.097144962936192e-23,  7.888784921996639e-26, -2.912711413183194e-28,  2.816194384882604e-02,
 -1.741851055202021e-04,  1.135903474866614e-06, -6.563610750950603e-09,  3.497106922651138e-11, -1.755442068827500e-13,  8.404224300773494e-16, -3.869033253869164e-18,
  1.722974580851785e-20, -7.455435343623884e-23,  3.145575262599965e-25, -1.297661624189545e-27,  2.099810156677548e-02, -1.731662516387354e-04,  1.356974279371005e-06,
 -9.178385403196151e-09,  5.651325409942501e-11, -3.244907429063841e-13,  1.762640658768033e-15, -9.146996635633559e-18,  4.566741711277958e-20, -2.205179137388440e-22,
  1.034118864298385e-24, -4.724902277257656e-27,  1.477073209990168e-02, -1.584936245404824e-04,  1.468895623812404e-06, -1.152207076250190e-08,  8.123103878102519e-11,
 -5.288288055804520e-13,  3.232414579688062e-15, -1.876071537828431e-17,  1.042286233127333e-19, -5.576478758177986e-22,  2.886648173862810e-24, -1.451060830177987e-26,
  9.804891952951656e-03, -1.337459046967967e-04,  1.451066149065122e-06, -1.309738589849856e-08,  1.049247163406583e-10, -7.690347613906861e-13,  5.254689381081065e-15,
 -3.389797892966347e-17,  2.083272613369530e-19, -1.227969202653347e-21,  6.978365205858256e-24, -3.839021329038805e-26,  6.143834446572077e-03, -1.043477585375541e-04,
  1.315206539397358e-06, -1.356705559575546e-08,  1.227207857746628e-10, -1.006780709148844e-12,  7.648413600282366e-15, -5.456089965302584e-17,  3.691265372667153e-19,
 -2.385952872472202e-21,  1.481884774221390e-23, -8.883353833370801e-26,  3.635414564951595e-03, -7.549729775963636e-05,  1.098338643354813e-06, -1.287065220429431e-08,
  1.307434638927414e-10, -1.194667546168280e-12,  1.004457795126601e-14, -7.889585777390569e-17,  5.851834877225225e-19, -4.131657871041901e-21,  2.794022117166542e-23,
 -1.818492404043689e-25,  2.032239580287839e-03, -5.080041221631012e-05,  8.480341364431742e-07, -1.122832525390762e-08,  1.274903324256319e-10, -1.292008584679671e-12,
  1.197528561898704e-14, -1.031841881866591e-16,  8.361248512622315e-19, -6.426787872281626e-21,  4.716885200842032e-23, -3.322834325656332e-25,  1.073793195781179e-03,
 -3.187282737051391e-05,  6.071731503466477e-07, -9.039675554215637e-09,  1.142482076194470e-10, -1.279296693248114e-12,  1.302649567481063e-14, -1.227314651311398e-16,
  1.083194440395858e-18, -9.037626610843887e-21,  7.178906554336286e-23, -5.459015822356405e-25,  5.365890757896012e-04, -1.869019299481454e-05,  4.041842213341540e-07,
 -6.736791611838635e-09,  9.441900779359177e-11, -1.164293259188705e-12,  1.298440578200089e-14, -1.333856003394442e-16,  1.278733266072486e-18, -1.155149541401934e-20,
  9.906434706538964e-23, -8.112390750512047e-25,  2.537609808483751e-04, -1.026552049822718e-05,  2.507620397706250e-07, -4.660394120874159e-09,  7.218740701298767e-11,
 -9.773114461460836e-13,  1.190414457024662e-14, -1.329936239797047e-16,  1.381578956056201e-18, -1.348189212129124e-20,  1.245535007459114e-22, -1.096100290029695e-24,
  1.136568564013948e-04, -5.291648776418766e-06,  1.453253139358893e-07, -3.000369371916220e-09,  5.120224591600211e-11, -7.589812026524153e-13,  1.007195087779299e-14,
 -1.220913821829614e-16,  1.371385423357241e-18, -1.442638476732505e-20,  1.432965497267400e-22, -1.352615573943978e-24,  4.825296210013890e-05, -2.564894264367001e-06,
  7.884160636078298e-08, -1.802015529833072e-09,  3.378247199564863e-11, -5.468904200932073e-13,  7.888649047286518e-15, -1.035364145058369e-16,  1.254982073603142e-18,
 -1.420516705714103e-20,  1.514344691216400e-22, -1.530618144408773e-24,  1.943695699951195e-05, -1.171166369313341e-06,  4.012517382177226e-08, -1.012004931736794e-09,
  2.078556420026729e-11, -3.666173845253458e-13,  5.736048898508979e-15, -8.135331574962802e-17,  1.062184713538111e-18, -1.291445112048833e-20,  1.475190149818636e-22,
 -1.594107181059012e-24,  7.436712533923479e-06, -5.047021940824896e-07,  1.919681182324668e-08, -5.326408623026335e-10,  1.195528577742144e-11, -2.292427980545271e-13,
  3.882700317468371e-15, -5.939935559737744e-17,  8.339808793503084e-19, -1.087457572981337e-20,  1.329006275918809e-22, -1.533211236502050e-24,  2.705918414703213e-06,
 -2.056490658137080e-07,  8.651688445871771e-09, -2.633281698016895e-10,  6.443643370639258e-12, -1.340449659620461e-13,  2.453133338669932e-15, -4.041279037696797e-17,
  6.092016066769765e-19, -8.506648238285202e-21,  1.110737018845702e-22, -1.366202081364595e-24,  9.376240762209111e-07, -7.938276156102457e-08,  3.680951671704103e-09,
 -1.225646815094611e-10,  3.262306516016988e-12, -7.348082879827648e-14,  1.450494446391505e-15, -2.569037999756978e-17,  4.151832371230739e-19, -6.199819371616022e-21,
  8.637815341408903e-23, -1.131350799601866e-24,  3.098822946177766e-07, -2.908747129411657e-08,  1.481722565167031e-09, -5.383414503255736e-11,  1.555271151009465e-12,
 -3.785939871228768e-14,  8.047549248691956e-16, -1.530091096544316e-17,  2.647322447803302e-19, -4.222029450463147e-21,  6.268796634952528e-23, -8.732914662327897e-25,
  9.785314884047301e-08, -1.013890981092906e-08,  5.656220673547444e-10, -2.236828358761642e-11,  6.999616743185645e-13, -1.838158514456336e-14,  4.200767455501291e-16,
 -8.561563254261307e-18,  1.583739813852686e-19, -2.694223023960094e-21,  4.258202770259639e-23, -6.302316000699215e-25,  2.958083440076768e-08, -3.369561046938950e-09,
  2.052587130720656e-10, -8.814540281436550e-12,  2.981769570818936e-13, -8.432876140378891e-15,  2.068762412206444e-16, -4.513370062230484e-18,  8.914890038257073e-20,
 -1.615780091571202e-21,  2.715295994718016e-23, -4.265075659040802e-25,  8.579312072533991e-09, -1.070342193395364e-09,  7.099485562741148e-11, -3.303191938937421e-12,
  1.205619345836178e-13, -3.665898118945674e-15,  9.639584535315737e-17, -2.248163657959412e-18,  4.735733395449627e-20, -9.134132929155230e-22,  1.630316749428841e-23,
 -2.714994588199957e-25,  2.393105188010650e-09, -3.258384100437560e-10,  2.347041767298365e-11, -1.180561524393281e-12,  4.640455591048715e-14, -1.514584911089176e-15,
  4.262689797075422e-17, -1.061351597999245e-18,  2.381413654618641e-20, -4.882442192212466e-22,  9.245909000129862e-24, -1.630781187007896e-25,  6.437580904447061e-10,
 -9.534140537068422e-11,  7.438753121543336e-12, -4.036545487140242e-13,  1.705651475992514e-14, -5.966149304775108e-16,  1.794634389050387e-17, -4.764228280462622e-19,
  1.137269726153517e-20, -2.475726299738431e-22,  4.968975539719110e-24, -9.273187558536673e-26,  1.675155751662396e-10, -2.689986047929925e-11,  2.267742256987730e-12,
 -1.324796999366346e-13,  6.007102718228389e-15, -2.248311156874959e-16,  7.217971839989529e-18, -2.040381914903675e-19,  5.175582173380204e-21, -1.194954886884756e-22,
  2.539290691548674e-24, -5.009084976176391e-26,  4.230851374443726e-11, -7.343985331678115e-12,  6.673546338158813e-13, -4.188699153986422e-14,  2.034536932107158e-15,
 -8.135135647215746e-17,  2.783467617818600e-18, -8.367573113510176e-20,  2.252698422618795e-21, -5.510126068428035e-23,  1.238398450219272e-24, -2.579608697264105e-26,
  1.041047854807880e-11, -1.947600709148122e-12,  1.903203179223342e-13, -1.280872529825261e-14,  6.652752555114926e-16, -2.837442677091291e-17,  1.033218574046531e-18,
 -3.298781688818740e-20,  9.414220518067488e-22, -2.436766189933658e-23,  5.786065684228684e-25, -1.271390725586559e-26,  2.506047890676045e-12, -5.038378590662981e-13,
  5.282388420998120e-14, -3.804387081088599e-15,  2.109233371185004e-16, -9.580501798866675e-18,  3.707389821679772e-19, -1.255442810417019e-20,  3.793269463048826e-22,
 -1.037780896656173e-23,  2.600547495454941e-25, -6.021484919137658e-27,  5.928944691857425e-13, -1.277374120457246e-13,  1.433548825523841e-14, -1.102637734166460e-15,
  6.513936843704202e-17, -3.145888525269952e-18,  1.291795302113105e-19, -4.633313713169778e-21,  1.480249456750637e-22, -4.275255223185320e-24,  1.129303573108845e-25,
 -2.752417689358559e-27,  1.385571065461093e-13, -3.189964281213846e-14,  3.823260220552258e-15, -3.134313874281606e-16,  1.969402617172132e-17, -1.009600067837710e-18,
  4.392420387775546e-20, -1.666287980077980e-21,  5.621291631653480e-23, -1.711774475730552e-24,  4.760580643091589e-26, -1.219903023730646e-27,  3.216240438741865e-14,
 -7.890406418515560e-15,  1.007603814639544e-15, -8.786003848230263e-17,  5.860743281757661e-18, -3.183725285456107e-19,  1.465210216794674e-20, -5.870074782753288e-22,
  2.088135677811556e-23, -6.695298587209110e-25,  1.957909032730195e-26, -5.268486690439691e-28,  7.460365682461356e-15, -1.944796829398991e-15,  2.639837996290576e-16,
 -2.443155999461650e-17,  1.726791259726480e-18, -9.922263917819132e-20,  4.822316642115843e-21, -2.037090073447885e-22,  7.629634746196610e-24, -2.572149789744175e-25,
  7.898332114995889e-27, -2.228877194137310e-28,  1.740642563067461e-15, -4.807732822635919e-16,  6.919890901043505e-17, -6.782527897317548e-18,  5.069068032796571e-19,
 -3.075153867840305e-20,  1.575509929636115e-21, -7.005782788026126e-23,  2.758254952565129e-24, -9.762136053215610e-26,  3.143143821526347e-27, -9.288773341339784e-29,
  4.113988844777961e-16, -1.200440473876855e-16,  1.827525397063960e-17, -1.892687108433875e-18,  1.492582855330513e-19, -9.540625705767473e-21,  5.143038712418176e-22,
 -2.403013332961168e-23,  9.928260553634340e-25, -3.682878593623087e-26,  1.241366821843100e-27, -3.835954616804505e-29,  9.924227431170455e-17, -3.050154629335495e-17,
  4.898612021101413e-18, -5.347693632877094e-19,  4.439878649362384e-20, -2.983907821522589e-21,  1.689037182518055e-22, -8.276343251975614e-24,  3.581720202064026e-25,
 -1.390072663710354e-26,  4.896648655260006e-28, -1.579538770270915e-29,  2.463060964301442e-17, -7.949031389151200e-18,  1.343095960151625e-18, -1.541614844776013e-19,
  1.344268317474229e-20, -9.477393049774475e-22,  5.620967579624158e-23, -2.882504345753118e-24,  1.304039588908557e-25, -5.284827237706866e-27,  1.941920816371957e-28,
 -6.527332290724573e-30,  6.341853109520308e-18, -2.142381095565748e-18,  3.797396001738856e-19, -4.570481078605525e-20,  4.175120013390968e-21, -3.080364737275874e-22,
  1.909756572654651e-23, -1.022634764814407e-24,  4.825783111358901e-26, -2.037943874562095e-27,  7.795627024346372e-29, -2.725036011193301e-30,  1.708579960236506e-18,
 -6.022035781557753e-19,  1.116396442859911e-19, -1.404949896741525e-20,  1.340849439031489e-21, -1.032539791151124e-22,  6.674863729551599e-24, -3.723171657858947e-25,
  1.828378483027841e-26, -8.027608363796254e-28,  3.189654873914868e-29, -1.157041643220864e-30,  4.858082384487409e-19, -1.780504286000782e-19,  3.441305160888674e-20,
 -4.514526816054758e-21,  4.488239257377192e-22, -3.597287214492423e-23,  2.418193285493558e-24, -1.401356209052516e-25,  7.143339277257479e-27, -3.252695416076024e-28,
  1.339233038315347e-29, -5.029561114135970e-31,  1.470066718104509e-19, -5.583212993015381e-20,  1.121279484730143e-20, -1.528431661717202e-21,  1.577970819990179e-22,
 -1.312379298627503e-23,  9.147144578633924e-25, -5.491589074756016e-26,  2.897704188665728e-27, -1.364755944695309e-28,  5.807522417376825e-30, -2.252324613616178e-31,
  4.771056012980277e-20, -1.871055061438125e-20,  3.890748364024289e-21, -5.491837684266461e-22,  5.868310146146587e-23, -5.048128965267655e-24,  3.636661418297151e-25,
 -2.254988694804095e-26,  1.228043292919328e-27, -5.965096180885353e-29,  2.616089904560244e-30, -1.044880144359760e-31,  1.671621892471612e-20, -6.744502021163245e-21,
  1.446782091281857e-21, -2.106983005656491e-22,  2.321984612504157e-23, -2.058897531497698e-24,  1.527896891238469e-25, -9.753114035950124e-27,  5.464382933698829e-28,
 -2.728963946870589e-29,  1.229746736562844e-30, -5.043358882028170e-32,  6.350769414304567e-21, -2.626363589733261e-21,  5.789333343816709e-22, -8.665501114747102e-23,
  9.812142779372039e-24, -8.935210719009715e-25,  6.806086668611767e-26, -4.456964302729686e-27,  2.560278475032581e-28, -1.310250172628895e-29,  6.047092879512244e-31,
 -2.538448506552236e-32,  2.618037853318655e-21, -1.105513040513686e-21,  2.494019968979570e-22, -3.821404495512440e-23,  4.428395755553079e-24, -4.125446910447991e-25,
  3.213316190634679e-26, -2.150712168003871e-27,  1.262155596408162e-28, -6.595674635593217e-30,  3.106924234185810e-31, -1.330490034339259e-32,  1.163721392891785e-21,
 -4.998154796343993e-22,  1.149170561229225e-22, -1.794899160672462e-23,  2.119910937900234e-24, -2.012156222807288e-25,  1.596274471034422e-26, -1.087766280080889e-27,
  6.496791792218832e-29, -3.453919746257899e-30,  1.654576895758306e-31, -7.202619860690335e-33,  5.460224574248093e-22, -2.375925851835387e-22,  5.543271125309565e-23,
 -8.787438542226482e-24,  1.053233592053229e-24, -1.014267145260529e-25,  8.161368245395797e-27, -5.639362937077468e-28,  3.414323358959425e-29, -1.839507733553617e-30,
  8.927581807641755e-32, -3.935998538366296e-33,  2.541152289555146e-22, -1.115796403976113e-22,  2.629969774772961e-23, -4.212519895141524e-24,  5.101089839712867e-25,
 -4.962265830625336e-26,  4.032719839954477e-27, -2.813749610927258e-28,  1.719854149223087e-29, -9.352579585733714e-31,  4.580560088155643e-32, -2.037496119721454e-33,
  9.160720948046919e-23, -4.042720427109679e-23,  9.583281806642307e-24, -1.543892215148637e-24,  1.880312585395207e-25, -1.839505266469336e-26,  1.503237225028771e-27,
 -1.054568877109013e-28,  6.480249358385055e-30, -3.542359469400502e-31,  1.743780781259483e-32, -7.795203436423321e-34,  5.028894229717376e-02, -1.038656495360357e-04,
  2.209364692338899e-07, -4.821037031081473e-10,  1.073678064739060e-12, -2.428546214301145e-15,  5.552330892708264e-18, -1.278789613240438e-20,  2.956919452771482e-23,
 -6.854816247700462e-26,  1.589122339632826e-28, -3.685711639772009e-31,  4.733771405909156e-02, -1.164194771243227e-04,  3.365423900948007e-07, -1.027513622442657e-09,
  3.148306529073181e-12, -9.522930964697474e-15,  2.834267000947465e-17, -8.307385388913517e-20,  2.401892831746113e-22, -6.862118865310464e-25,  1.939756159901637e-27,
 -5.431856942597795e-30,  4.194622406721078e-02, -1.362479547427198e-04,  5.456245091367054e-07, -2.156544021550933e-09,  8.167895565687286e-12, -2.981248288028702e-14,
  1.056322398037338e-16, -3.652629322306325e-19,  1.237172824537939e-21, -4.115774371119935e-24,  1.347640017698516e-26, -4.350317147614043e-29,  3.499142037702723e-02,
 -1.551388501547504e-04,  8.057100187695423e-07, -3.869592287673970e-09,  1.739609059153442e-11, -7.448238297837646e-14,  3.068843104226488e-16, -1.224903936218726e-18,
  4.758660012981066e-21, -1.805798990971844e-23,  6.712244381604725e-26, -2.449322211061985e-28,  2.748289213377733e-02, -1.654036787920421e-04,  1.060384961258144e-06,
 -6.031100548806223e-09,  3.165342327786717e-11, -1.566141568146642e-13,  7.394216244575803e-16, -3.358303711643343e-18,  1.475915740620626e-20, -6.304358629556275e-23,
  2.626375368161359e-25, -1.070034998692468e-27,  2.032647166050772e-02, -1.627361270114186e-04,  1.252051977450720e-06, -8.323877572735862e-09,  5.042655092428615e-11,
 -2.851026842176302e-13,  1.525844960234587e-15, -7.805063700671537e-18,  3.842582633225490e-20, -1.830294707747485e-22,  8.468960962261307e-25, -3.818935344285794e-27,
  1.415941442073578e-02, -1.472742013987720e-04,  1.338093108909059e-06, -1.030294373357319e-08,  7.138956478040071e-11, -4.571953480439891e-13,  2.750942914381965e-15,
 -1.572551095130070e-17,  8.608650910323811e-20, -4.540075308318080e-22,  2.317350327233044e-24, -1.148950278317188e-26,  9.292168795354645e-03, -1.227386364685387e-04,
  1.303484073684088e-06, -1.153509354457131e-08,  9.073199259283463e-11, -6.535976255938256e-13,  4.392596585971856e-15, -2.788808224045224e-17,  1.687626943251042e-19,
 -9.799075532573859e-22,  5.487512341476979e-24, -2.975805025677134e-26,  5.746500806611827e-03, -9.444541283120636e-05,  1.163549535743790e-06, -1.175513078906688e-08,
  1.043036224891420e-10, -8.402919412477911e-13,  6.273937721291994e-15, -4.401598826229643e-17,  2.930223795362120e-19, -1.864593757865675e-21,  1.140529802302460e-23,
 -6.735831956964997e-26,  3.350068536841778e-03, -6.729455207363847e-05,  9.556941728651313e-07, -1.095752016594849e-08,  1.090922554599881e-10, -9.781207542187747e-13,
  8.076747318346594e-15, -6.234885704702363e-17,  4.547704979219917e-19, -3.159133612980081e-21,  2.102834195772509e-23, -1.347671382658567e-25,  1.841799614094967e-03,
 -4.452228843007296e-05,  7.247286044391998e-07, -9.380516070112414e-09,  1.043049710945167e-10, -1.036449625746071e-12,  9.428369955326935e-15, -7.979267660439281e-17,
  6.354696145107483e-19, -4.803135160170132e-21,  3.468131442350473e-23, -2.404566595710236e-25,  9.553710812352548e-04, -2.742011077975569e-05,  5.088725288473356e-07,
 -7.400506752432025e-09,  9.152931336392578e-11, -1.004263655505449e-12,  1.003006898160384e-14, -9.276451520561803e-17,  8.042165132464167e-19, -6.594918967065638e-21,
  5.151302586957290e-23, -3.853604140168159e-25,  4.678173101102584e-04, -1.575606895603864e-05,  3.316900797303934e-07, -5.396634050676512e-09,  7.396924214627617e-11,
 -8.932197234220387e-13,  9.765037880475616e-15, -9.841979689847212e-17,  9.263614883970186e-19, -8.221037810536888e-21,  6.929799942848157e-23, -5.580437156219230e-25,
  2.163827827597978e-04, -8.464878724380848e-06,  2.011693039953988e-07, -3.647424078199534e-09,  5.522057721979024e-11, -7.317183280783855e-13,  8.732651561460212e-15,
 -9.567417729013396e-17,  9.753788170980800e-19, -9.346617701617740e-21,  8.484047820179198e-23, -7.339256031364969e-25,  9.460567976999574e-05, -4.260210734157210e-06,
  1.137749396668466e-07, -2.290515477825246e-09,  3.818671417878465e-11, -5.537611877541563e-13,  7.196957459364070e-15, -8.551724905563897e-17,  9.423009884841408e-19,
 -9.730411027224570e-21,  9.492918080494849e-23, -8.805389675714805e-25,  3.912985265743276e-05, -2.012238349123315e-06,  6.013040221698735e-08, -1.339621334758334e-09,
  2.452470908300554e-11, -3.882468324543872e-13,  5.482612105637920e-15, -7.051031875362510e-17,  8.381235141196058e-19, -9.309323638504031e-21,  9.744341461846323e-23,
 -9.675606805683679e-25,  1.532468572382133e-05, -8.935997870116623e-07,  2.975682933719308e-08, -7.313253874983233e-10,  1.466352412245774e-11, -2.528380931024196e-13,
  3.871509770582330e-15, -5.378775992930902e-17,  6.884800922771205e-19, -8.211968906903745e-21,  9.207900362569421e-23, -9.772499687255678e-25,  5.688741726089627e-06,
 -3.737607801282660e-07,  1.381650527234917e-08, -3.734876194359705e-10,  8.181734356840083e-12, -1.533285727398600e-13,  2.540903586605661e-15, -3.806872038196375e-17,
  5.238675223661175e-19, -6.699745053214531e-21,  8.035631653260566e-23, -9.102942736699400e-25,  2.003965987355864e-06, -1.475073656387639e-07,  6.031269375771398e-09,
 -1.788266264682632e-10,  4.270126785500365e-12, -8.680057947506146e-14,  1.553952810707502e-15, -2.506603422909291e-17,  3.702769874412352e-19, -5.070234217697651e-21,
  6.496133586443896e-23, -7.844711290971948e-25,  6.707929308168820e-07, -5.503142083772002e-08,  2.480377898193782e-09, -8.045325216687845e-11,  2.089506279273555e-12,
 -4.598422611034602e-14,  8.878560109566773e-16, -1.539544152960828e-17,  2.437842296388603e-19, -3.569403218775406e-21,  4.879148245023176e-23, -6.273476866118456e-25,
  2.136777124146502e-07, -1.944608338512978e-08,  9.630707804933450e-10, -3.408799459510312e-11,  9.609307448674787e-13, -2.285395046634338e-14,  4.751382717031945e-16,
 -8.843858423878102e-18,  1.499156254756157e-19, -2.344139963614484e-21,  3.414621232036621e-23, -4.669421808721958e-25,  6.488345688866610e-08, -6.521968897947364e-09,
  3.538413516853098e-10, -1.363441540093522e-11,  4.163489963039292e-13, -1.068283355178434e-14,  2.387859824007240e-16, -4.764343600959043e-18,  8.634710334643312e-20,
 -1.440179439034344e-21,  2.233069065054725e-23, -3.244285993058698e-25,  1.881639818693443e-08, -2.080742409360932e-09,  1.233125579638792e-10, -5.160991488824656e-12,
  1.703959747593747e-13, -4.709048632538944e-15,  1.130014381172706e-16, -2.413655618987690e-18,  4.671221961326552e-20, -8.301167604723153e-22,  1.368638116068723e-23,
 -2.110390814407822e-25,  5.222680355544106e-09, -6.329941875440043e-10,  4.086635068122620e-11, -1.853715259057652e-12,  6.605091986186820e-14, -1.962939321144111e-15,
  5.049772744744865e-17, -1.153198026608431e-18,  2.380445798872517e-20, -4.502268619068145e-22,  7.884940261881035e-24, -1.289159258085348e-25,  1.390740149774835e-09,
 -1.841055410526039e-10,  1.291466021865413e-11, -6.335769919498718e-13,  2.432057329512413e-14, -7.760402568754080e-16,  2.137297683672362e-17, -5.211892415604718e-19,
  1.146174061911371e-20, -2.304754665047979e-22,  4.283259376598454e-24, -7.418293906273806e-26,  3.562561169873522e-10, -5.134208188543935e-11,  3.903546117025987e-12,
 -2.066957667761043e-13,  8.532822908357633e-15, -2.918958527477748e-16,  8.594826489668874e-18, -2.235283868587973e-19,  5.231160241113695e-21, -1.117164103646861e-22,
  2.201005492974583e-24, -4.034281050687774e-26,  8.805443231320715e-11, -1.377204279957506e-11,  1.132172337744551e-12, -6.457732417252099e-14,  2.862135068704311e-15,
 -1.048096787342788e-16,  3.295017060358614e-18, -9.128289173001078e-20,  2.270792900610595e-21, -5.145025217875289e-23,  1.073544168773862e-24, -2.080538506415106e-26,
  2.107057591470749e-11, -3.565834338965054e-12,  3.162227745783582e-13, -1.939152356847150e-14,  9.211741050300430e-16, -3.605655526909341e-17,  1.208668658424052e-18,
 -3.562422239313964e-20,  9.409511945037807e-22, -2.259497339124592e-23,  4.988194684815361e-25, -1.021180045326659e-26,  4.899725273031634e-12, -8.946200018841730e-13,
  8.538873424905865e-14, -5.618714649441728e-15,  2.856012923185592e-16, -1.193129456440004e-17,  4.258853990622236e-19, -1.333833518464748e-20,  3.736463295995152e-22,
 -9.498967226277877e-24,  2.216512119211140e-25, -4.788684802625293e-27,  1.111876972255567e-12, -2.184142788907598e-13,  2.238719269820058e-14, -1.577696992288621e-15,
  8.566645589946228e-17, -3.813901753633262e-18,  1.447646263152371e-19, -4.811661100224025e-21,  1.427851398594020e-22, -3.838777319965530e-24,  9.457985967738224e-26,
 -2.154283421742839e-27,  2.473730127450430e-13, -5.213493282383666e-14,  5.725808047969926e-15, -4.313351433647355e-16,  2.497624824144495e-17, -1.183178668759166e-18,
  4.768930354910837e-20, -1.680014601263844e-21,  5.274768281030620e-23, -1.498001800611675e-24,  3.892792501878326e-26, -9.338464412570204e-28,  5.423702616117378e-14,
 -1.223005029867712e-14,  1.436004460411515e-15, -1.154100646569454e-16,  7.114200128272677e-18, -3.580362395613938e-19,  1.530182638445296e-20, -5.705678472027022e-22,
  1.892994305050012e-23, -5.672017680234118e-25,  1.552873832097007e-26, -3.919112956428010e-28,  1.178569276424122e-14, -2.835606271013664e-15,  3.551501827212561e-16,
 -3.039113475018576e-17,  1.990768256186664e-18, -1.062639680678864e-19,  4.808251084908450e-21, -1.894984176791893e-22,  6.634649227340771e-24, -2.094762939629171e-25,
  6.034741412216100e-27, -1.600457502027021e-28,  2.554109842411643e-15, -6.538542423216271e-16,  8.715342899540183e-17, -7.924588071758846e-18,  5.505946849619672e-19,
 -3.111818395660678e-20,  1.488344268347821e-21, -6.190442502902526e-23,  2.283944263559238e-24, -7.588266484699821e-26,  2.297361311802404e-27, -6.394515015330702e-29,
  5.557866937827565e-16, -1.509638980729793e-16,  2.136405725531165e-17, -2.059720734000666e-18,  1.514941745829484e-19, -9.049103254144706e-21,  4.567118787081603e-22,
 -2.001526171582134e-23,  7.769848312757458e-25, -2.712540121948890e-26,  8.618241635280052e-28, -2.514225344327079e-29,  1.223407206457766e-16, -3.515649451168679e-17,
  5.269321830786842e-18, -5.374556230329376e-19,  4.176046313748896e-20, -2.631252113884166e-21,  1.398796818505715e-22, -6.447963317631883e-24,  2.629326244467736e-25,
 -9.630043988075028e-27,  3.206024670175967e-28, -9.788633448850421e-30,  2.745891928107402e-17, -8.323374583272220e-18,  1.317866111195399e-18, -1.418731349621247e-19,
  1.161994474444588e-20, -7.707082582159860e-22,  4.307102580978274e-23, -2.084440843499824e-24,  8.912599135820411e-26, -3.418701338446394e-27,  1.190627274811361e-28,
 -3.798424864368427e-30,  6.337646227511186e-18, -2.020212996823523e-18,  3.369921731723614e-19, -3.819488165389244e-20,  3.289809168551335e-21, -2.291812181540403e-22,
  1.343557006156406e-23, -6.812635180103848e-25,  3.048426968937443e-26, -1.222332862440955e-27,  4.445205778497107e-29, -1.479202109991595e-30,  1.517685712602517e-18,
 -5.071433034863312e-19,  8.887259941391597e-20, -1.057679676611564e-20,  9.556245466518824e-22, -6.975497454655773e-23,  4.279920025905436e-24, -2.268767396216543e-25,
  1.060161409953260e-26, -4.434549324802075e-28,  1.680640972386255e-29, -5.822088836931275e-31,  3.805950852029410e-19, -1.328829579038085e-19,  2.439005337736457e-20,
 -3.039240204859696e-21,  2.872690494989818e-22, -2.191436078648488e-23,  1.403746485061154e-24, -7.760562668821948e-26,  3.778215199983214e-27, -1.644940265815867e-28,
  6.482613579130836e-30, -2.332921073197586e-31,  1.008904107953091e-19, -3.668086061657904e-20,  7.029144190154241e-21, -9.143216378147853e-22,  9.014591863637429e-23,
 -7.166685909065691e-24,  4.779700528481717e-25, -2.748636690728192e-26,  1.390656286187451e-27, -6.286363813573068e-29,  2.570009567832967e-30, -9.585600031573065e-32,
  2.853382582513946e-20, -1.076482852095450e-20,  2.146441343626389e-21, -2.904993642608498e-22,  2.978182183451842e-23, -2.460013766278914e-24,  1.703201730956332e-25,
 -1.015915567804891e-26,  5.326819414996067e-28, -2.493426452522650e-29,  1.054705324947769e-30, -4.066719811825294e-32,  8.685135642253169e-21, -3.387687825085780e-21,
  7.003364405889547e-22, -9.827670698832430e-23,  1.044119004386792e-23, -8.931588003106360e-25,  6.399167610342075e-26, -3.946835433281460e-27,  2.138273367770306e-28,
 -1.033406904758554e-29,  4.509918759788343e-31, -1.792691742959775e-32,  2.866725607283421e-21, -1.151767706685850e-21,  2.459313610589686e-22, -3.565039219519652e-23,
  3.910998918554022e-24, -3.452484308125801e-25,  2.550978239557303e-26, -1.621510005946926e-27,  9.047499866309952e-29, -4.500315360021215e-30,  2.020058252048149e-31,
 -8.253142701442360e-33,  1.031728051731465e-21, -4.253258042061270e-22,  9.342944840434546e-23, -1.393577106786667e-23,  1.572555321955524e-24, -1.427194928195587e-25,
  1.083545445176822e-26, -7.072867873867685e-28,  4.050286681414550e-29, -2.066473290646914e-30,  9.508965214155702e-32, -3.980177490852325e-33,  4.055685022518741e-22,
 -1.708763657808775e-22,  3.845401393497377e-23, -5.877348116221117e-24,  6.794167926406407e-25, -6.314136802525222e-26,  4.906521460749187e-27, -3.276458388020511e-28,
  1.918502020175252e-29, -1.000368751127095e-30,  4.702265038594087e-32, -2.009506839215859e-33,  1.732109769017313e-22, -7.428503047630542e-23,  1.705169058217215e-23,
 -2.658937749803940e-24,  3.135304354009322e-25, -2.971196558734881e-26,  2.353424253590277e-27, -1.601279607859207e-28,  9.549606559167089e-30, -5.069551858297410e-31,
  2.425105475411374e-32, -1.054234914219564e-33,  7.874972719575883e-23, -3.423728873531743e-23,  7.980221238362206e-24, -1.263830381053835e-24,  1.513329073634939e-25,
 -1.455964184827454e-26,  1.170468028562373e-27, -8.080418572315441e-29,  4.887927526594217e-30, -2.631158539958293e-31,  1.275890418437605e-32, -5.620543287592889e-34,
  3.584057266052799e-23, -1.573049044182077e-23,  3.705928379770086e-24, -5.932996898946679e-25,  7.180963101654193e-26, -6.982172179780854e-27,  5.671569097673440e-28,
 -3.955390321905749e-29,  2.416564468532875e-30, -1.313545688832845e-31,  6.430480769636053e-33, -2.859152335339390e-34,  1.275868946326975e-23, -5.629466562749611e-24,
  1.334177126589850e-24, -2.148918343492147e-25,  2.616597089043210e-26, -2.559249294406755e-27,  2.090956614640982e-28, -1.466559581172955e-29,  9.010006716994922e-31,
 -4.924204214513379e-32,  2.423520696752581e-33, -1.083166858571399e-34,  4.987697845014002e-02, -1.021210103644278e-04,  2.152527181752805e-07, -4.653063010730212e-10,
  1.026411239989228e-12, -2.299482320866583e-15,  5.207154383779681e-18, -1.187996986103598e-20,  2.721207621426524e-23, -6.250432490148140e-26,  1.435605349904739e-28,
 -3.299955658324959e-31,  4.687734392796399e-02, -1.137756165566655e-04,  3.245082965133522e-07, -9.786282036146403e-10,  2.964466132788508e-12, -8.869773477037311e-15,
  2.612059723856700e-17, -7.576853500299075e-20,  2.168265646170981e-22, -6.131961175566387e-25,  1.715943671102214e-27, -4.757292256334193e-30,  4.140980142087476e-02,
 -1.319842955520672e-04,  5.205108594930578e-07, -2.030493343855200e-09,  7.596191781877625e-12, -2.739569713140685e-14,  9.593757717362044e-17, -3.279436801560425e-19,
  1.098263899879256e-21, -3.613120943122690e-24,  1.170097178486477e-26, -3.736303400548722e-29,  3.438346878173672e-02, -1.488742893677225e-04,  7.608970427874175e-07,
 -3.602783201366118e-09,  1.597740353101465e-11, -6.751210259940943e-14,  2.746247259324886e-16, -1.082530392386587e-18,  4.154412222889072e-21, -1.557676981946651e-23,
  5.721922007494911e-26, -2.063760041349133e-28,  2.683779706310946e-02, -1.572017141412448e-04,  9.909501561785854e-07, -5.548770872694503e-09,  2.869125187562522e-11,
 -1.399450855687771e-13,  6.516739705641030e-16, -2.920384821031670e-18,  1.266786817421874e-20, -5.342233236287399e-23,  2.197761986491822e-25, -8.844092823675838e-28,
  1.969494617770130e-02, -1.531059620815839e-04,  1.156824475690974e-06, -7.560751365708259e-09,  4.507369123787640e-11, -2.509718212130109e-13,  1.323572168435170e-15,
 -6.674639176392635e-18,  3.240810336990963e-20, -1.522894493100363e-22,  6.953725511075998e-25, -3.095094556803935e-27,  1.359097060701102e-02, -1.370452522171894e-04,
  1.221020657398330e-06, -9.230419016949867e-09,  6.287176561189735e-11, -3.961596871070072e-13,  2.346860317074627e-15, -1.321530488574805e-17,  7.129569071070604e-20,
 -3.706864656446739e-22,  1.865901205928443e-24, -9.125832817478288e-27,  8.821226904147630e-03, -1.128407267964505e-04,  1.173359702456092e-06, -1.018248425580729e-08,
  7.865403392711118e-11, -5.569665993621556e-13,  3.682320535589259e-15, -2.301217360822757e-17,  1.371405918653381e-19, -7.845206774695956e-22,  4.329912397260374e-24,
 -2.314878838166537e-26,  5.386480991072828e-03, -8.567411833438158e-05,  1.031971921738195e-06, -1.021293905890576e-08,  8.890892427861654e-11, -7.035062527160831e-13,
  5.163268599644804e-15, -3.563071607941804e-17,  2.334413426952841e-19, -1.462586596876027e-21,  8.812009241167382e-24, -5.127911823481239e-26,  3.095388677792267e-03,
 -6.014670771374471e-05,  8.340637904568198e-07, -9.358576587330869e-09,  9.133492559359655e-11, -8.036831405516041e-13,  6.518712805583394e-15, -4.946445252308625e-17,
  3.548539003212805e-19, -2.425674758148604e-21,  1.589507225594926e-23, -1.003223954741871e-25,  1.674631271101286e-03, -3.914785255031666e-05,  6.215294771739357e-07,
 -7.865894119524391e-09,  8.566904852405585e-11, -8.348319156322695e-13,  7.454666180822984e-15, -6.197592595049991e-17,  4.851708319654822e-19, -3.606577150180606e-21,
  2.562336727479158e-23, -1.748734513186629e-25,  8.533033967135282e-04, -2.368090458715288e-05,  4.282305219945964e-07, -6.084474188690905e-09,  7.365501443051457e-11,
 -7.920087654916854e-13,  7.759913956203701e-15, -7.046153968706106e-17,  6.001343698574140e-19, -4.837661226789084e-21,  3.716261447596542e-23, -2.735316162645771e-25,
  4.097166443689895e-04, -1.334274650191007e-05,  2.734808185695345e-07, -4.344187737155806e-09,  5.824145807851154e-11, -6.888336059856841e-13,  7.383354167705132e-15,
 -7.302117837622048e-17,  6.748948443268259e-19, -5.884775350676768e-21,  4.876364960099643e-23, -3.862023873999042e-25,  1.854845988069745e-04, -7.016623157393874e-06,
  1.622529989212349e-07, -2.870433525014551e-09,  4.248204705260468e-11, -5.510432078270257e-13,  6.444487946872415e-15, -6.924910934620117e-17,  6.929235195892502e-19,
 -6.521222894962970e-21,  5.816685902445069e-23, -4.946880817267797e-25,  7.922478281056332e-05, -3.450353724448663e-06,  8.961751060170434e-08, -1.759501732373582e-09,
  2.866113302159567e-11, -4.066598768160867e-13,  5.176780694854478e-15, -6.030513816332564e-17,  6.519377013274195e-19, -6.609120665743776e-21,  6.333636256672699e-23,
 -5.773787908179116e-25,  3.194986861194575e-05, -1.589373045244265e-06,  4.617452290710976e-08, -1.002816606868385e-09,  1.793012242210003e-11, -2.776096521667608e-13,
  3.838336941562624e-15, -4.837638976583399e-17,  5.639606866050778e-19, -6.147629835349237e-21,  6.318935304916041e-23, -6.164493660131560e-25,  1.217597764159013e-05,
 -6.870141785714291e-07,  2.223680465245862e-08, -5.325851817289321e-10,  1.042572738356883e-11, -1.757546887452799e-13,  2.634067377905975e-15, -3.585207569597253e-17,
  4.499332817341587e-19, -5.265330280091588e-21,  5.795894770509361e-23, -6.041989559884689e-25,  4.389237222919774e-06, -2.791439149859554e-07,  1.002872223772003e-08,
 -2.641300873401666e-10,  5.647559173699880e-12, -1.034461505187033e-13,  1.677419719589048e-15, -2.461443238020366e-17,  3.320147017725700e-19, -4.164946871948516e-21,
  4.902889596420725e-23, -5.454230679881382e-25,  1.498327039027140e-06, -1.067992798962694e-07,  4.243959132387760e-09, -1.225828723204318e-10,  2.856478441584265e-12,
 -5.674124605161179e-14,  9.937666004130923e-16, -1.569673186518023e-17,  2.272356564545504e-19, -3.051467380463897e-21,  3.836510717013105e-23, -4.548860386949181e-25,
  4.849577235895999e-07, -3.854485029889144e-08,  1.688566831522864e-09, -5.335296682097993e-11,  1.352087395881527e-12, -2.907351908709317e-14,  5.490831753082816e-16,
 -9.321806640961632e-18,  1.446358344151280e-19, -2.076515801372212e-21,  2.785003188431245e-23, -3.515434865933655e-25,  1.490396262644648e-07, -1.314746194439136e-08,
  6.329789986612846e-10, -2.182550844542709e-11,  6.003291553033913e-13, -1.394953284658327e-14,  2.836554265532020e-16, -5.168774967701500e-18,  8.584531481475342e-20,
 -1.316087255021988e-21,  1.880829546071389e-23, -2.524790006505469e-25,  4.356159558710697e-08, -4.246862336560915e-09,  2.240441984886337e-10, -8.411005118372094e-12,
  2.506262000092766e-13, -6.282928882267775e-15,  1.373577065152318e-16, -2.682949089163934e-18,  4.763966656938358e-20, -7.790329604915553e-22,  1.185043390437812e-23,
 -1.690032074543425e-25,  1.213126947242302e-08, -1.301925098635567e-09,  7.505184801753900e-11, -3.061008703620428e-12,  9.862939465280206e-14, -2.663332680697770e-15,
  6.251313301461135e-17, -1.307214913132570e-18,  2.478726982416212e-20, -4.318851025125061e-22,  6.985895602467667e-24, -1.057430536778435e-25,  3.225591908965682e-09,
 -3.796805369795959e-10,  2.385377007239719e-11, -1.054724037204986e-12,  3.668456342759894e-14, -1.065438244470911e-15,  2.681305202615905e-17, -5.995310113263369e-19,
  1.212650435987721e-20, -2.248945287370910e-22,  3.864446889394726e-24, -6.202791148348176e-26,  8.207859126701441e-10, -1.056051821366344e-10,  7.212649046969618e-12,
 -3.450476795618838e-13,  1.293273540041914e-14, -4.033882037005863e-16,  1.087043832573064e-17, -2.595914289003007e-19,  5.594834231551014e-21, -1.103312589834567e-22,
  2.012117116920544e-24, -3.421654509570417e-26,  2.004076067617398e-10, -2.809437972278172e-11,  2.080913022188443e-12, -1.074961977734281e-13,  4.334656234852978e-15,
 -1.449946053859700e-16,  4.178563835149866e-18, -1.064501818866366e-19,  2.442056506315780e-21, -5.115731182760727e-23,  9.892544655094495e-25, -1.780714807097339e-26,
  4.709270132630838e-11, -7.171052776191671e-12,  5.746917883407208e-13, -3.199661857427685e-14,  1.385841749476869e-15, -4.964336189872417e-17,  1.528058085905549e-18,
 -4.147997934781853e-20,  1.011821281195445e-21, -2.249429703599870e-23,  4.608087576397966e-25, -8.772704892693045e-27,  1.068562767243261e-11, -1.762316898942609e-12,
  1.524674267114749e-13, -9.132038882358170e-15,  4.241620578380055e-16, -1.624875086870913e-17,  5.335263796367974e-19, -1.541477171759234e-20,  3.993934443720900e-22,
 -9.413704302290991e-24,  2.041067231968109e-25, -4.105984945945347e-27,  2.350082605224425e-12, -4.185964651140528e-13,  3.900997126892862e-14, -2.508937408109579e-15,
  1.247722440577747e-16, -5.104296014932205e-18,  1.785578894333356e-19, -5.484546793813837e-21,  1.507785416980679e-22, -3.764071346972564e-24,  8.629716517172961e-26,
 -1.832809802161603e-27,  5.030695244933103e-13, -9.651027998615544e-14,  9.667206600276550e-15, -6.664140815885930e-16,  3.542770298673082e-17, -1.545513062632928e-18,
  5.752594994390634e-20, -1.876260517425768e-21,  5.467031845834298e-23, -1.444056302573543e-24,  3.497404126787515e-26, -7.834811767170251e-28,  1.053109741964816e-13,
 -2.170082363635589e-14,  2.331401812026954e-15, -1.719456137227086e-16,  9.755682296189639e-18, -4.531772193807255e-19,  1.792389215961847e-20, -6.200113423897306e-22,
  1.912603321565140e-23, -5.339605761062155e-25,  1.364761777758436e-26, -3.221694385144715e-28,  2.167160077532699e-14, -4.783905727688021e-15,  5.500474406379052e-16,
 -4.332070767103377e-17,  2.618848056800748e-18, -1.293452434416573e-19,  5.428640176563084e-21, -1.989039634473353e-22,  6.488117850640370e-24, -1.912353149100155e-25,
  5.152765420704449e-27, -1.280475254033544e-28,  4.409613524672357e-15, -1.039946001163436e-15,  1.276897382237735e-16, -1.071874909753265e-17,  6.892288586975883e-19,
 -3.613725604901215e-20,  1.607112348571271e-21, -6.228745584612788e-23,  2.145746179873787e-24, -6.669221052823272e-26,  1.892255134094045e-27, -4.944718873549211e-29,
  8.928685892536831e-16, -2.243539071560447e-16,  2.935189222938099e-17, -2.620959355558104e-18,  1.789403762966963e-19, -9.943480234757749e-21,  4.678615388183464e-22,
 -1.915370839904364e-23,  6.959008414500795e-25, -2.277904771531824e-26,  6.797386797690058e-28, -1.865627285643563e-29,  1.811816487628604e-16, -4.837171267931320e-17,
  6.727437687299638e-18, -6.376997746687957e-19,  4.613985252024532e-20, -2.712613701783735e-21,  1.348177790822619e-22, -5.820995655505852e-24,  2.227289392225504e-25,
 -7.667507632980692e-27,  2.403179180536868e-28, -6.918859406101797e-30,  3.713009583904374e-17, -1.050265689799815e-17,  1.549068847675808e-18, -1.555390507685441e-19,
  1.190266594821019e-20, -7.389729957900265e-22,  3.872636533548322e-23, -1.760558323059135e-24,  7.083178996992231e-26, -2.560581597311173e-27,  8.417161859093117e-29,
 -2.538460913520743e-30,  7.749086599642253e-18, -2.315503765216662e-18,  3.612743258443909e-19, -3.833639364320337e-20,  3.096236045129709e-21, -2.025909178212714e-22,
  1.117359038684644e-23, -5.338822509534421e-25,  2.254611468033664e-26, -8.544667610481634e-28,  2.941197923357263e-29, -9.277150348400267e-31,  1.661818754102877e-18,
 -5.229747966620007e-19,  8.608719101495210e-20, -9.630634530855864e-21,  8.190286281045069e-22, -5.635649223149953e-23,  3.264482856093003e-24, -1.636133564754169e-25,
  7.238867417331743e-27, -2.870879932959795e-28,  1.032954947941524e-29, -3.401854593980351e-31,  3.697100675750560e-19, -1.221487463291784e-19,  2.115382695861807e-20,
 -2.488328984031445e-21,  2.222782513758479e-22, -1.604636632673484e-23,  9.740148822245493e-25, -5.109538980977917e-26,  2.363492869250951e-27, -9.789173343406654e-29,
  3.674550690284345e-30, -1.261135433797155e-31,  8.618029142168474e-20, -2.979465632474846e-20,  5.412245641591227e-21, -6.675334309966748e-22,  6.246566589165424e-23,
 -4.718900130626501e-24,  2.994175037782684e-25, -1.640111890403159e-26,  7.913535704134607e-28, -3.415430794566634e-29,  1.334629556447857e-30, -4.763569661055874e-32,
  2.126456698610133e-20, -7.666585896259155e-21,  1.456097852707343e-21, -1.877336235525939e-22,  1.834954835339069e-23, -1.446536136357262e-24,  9.568452585899910e-26,
 -5.458661632523169e-27,  2.740386292230009e-28, -1.229438946944327e-29,  4.989382110095431e-31, -1.847686086802950e-32,  5.610823962725954e-21, -2.102026390906297e-21,
  4.159999319786872e-22, -5.588274225889705e-23,  5.687293494428407e-24, -4.664349892397038e-25,  3.207006894375866e-26, -1.899995727605622e-27,  9.897001094756394e-29,
 -4.603096313844320e-30,  1.934983421095862e-31, -7.415851334277265e-33,  1.598616600482432e-21, -6.200284690546678e-22,  1.273951172019959e-22, -1.776802830382007e-23,
  1.876417307825492e-24, -1.595731844223687e-25,  1.136766669619727e-26, -6.972343328498173e-28,  3.756982941032643e-29, -1.806160732184237e-30,  7.841944457612506e-32,
 -3.101664387965135e-33,  4.961020700426959e-22, -1.984377760553112e-22,  4.216687975394460e-23, -6.083002746001741e-24,  6.641600635011105e-25, -5.835722321566483e-26,
  4.292374318280854e-27, -2.716371813593011e-28,  1.509132070330672e-29, -7.475151055037448e-31,  3.341698481115187e-32, -1.359877898171492e-33,  1.688016900367520e-22,
 -6.935698428191799e-23,  1.517974288817494e-23, -2.255891679871287e-24,  2.536438376890404e-25, -2.293858800574209e-26,  1.735531595022114e-27, -1.129069711677032e-28,
  6.444487886051126e-30, -3.277531172463465e-31,  1.503490703438729e-32, -6.274207508147008e-34,  6.315464235444908e-23, -2.654616036193176e-23,  5.958397451811465e-24,
 -9.083026710027710e-25,  1.047280190323073e-25, -9.708256767872325e-27,  7.525361276319487e-28, -5.013155392852042e-29,  2.928519217075449e-30, -1.523531017464286e-31,
  7.145442821459705e-33, -3.046981352181833e-34,  2.587143539874976e-23, -1.107842404131397e-23,  2.538625001524560e-24, -3.951732895403317e-25,  4.651756756165275e-26,
 -4.400896493442817e-27,  3.480157410990046e-28, -2.364132056965046e-29,  1.407709339679604e-30, -7.461684669946368e-32,  3.564136191292231e-33, -1.547160202425462e-34,
  1.138147187350645e-23, -4.943759582734458e-24,  1.151155103354972e-24, -1.821226464236249e-25,  2.178560857832319e-26, -2.093901224223865e-27,  1.681680173617348e-28,
 -1.159860167186423e-29,  7.009614168516178e-31, -3.769845240585664e-32,  1.826444317067434e-33, -8.038929016482833e-35,  5.060386938374243e-24, -2.220011298182640e-24,
  5.227438713427022e-25, -8.364537627459231e-26,  1.011878210879456e-26, -9.833707985148449e-28,  7.983903591255850e-29, -5.565331585880990e-30,  3.398553675160338e-31,
 -1.846457741126952e-32,  9.035254912469506e-34, -4.015520632643446e-35,  1.777827033082027e-24, -7.842686226231561e-25,  1.858289823775500e-25, -2.992403840628445e-26,
  3.642819688569444e-27, -3.562172088073886e-28,  2.909712413221624e-29, -2.040369812491053e-30,  1.253256234634145e-31, -6.847907130973427e-33,  3.369589928051650e-34,
 -1.505691212849651e-35,  4.947190347848288e-02, -1.004210475892723e-04,  2.097660820733141e-07, -4.492449596284633e-10,  9.816448667108538e-13, -2.178405926873199e-15,
  4.886375704572884e-18, -1.104410540006032e-20,  2.506187981507866e-23, -5.704192643774251e-26,  1.298086812281602e-28, -2.957594608765258e-31,  4.642736033959250e-02,
 -1.112257312678308e-04,  3.130436011641369e-07, -9.325825554547860e-10,  2.793171730738950e-12, -8.267573259894123e-15,  2.409299006937754e-17, -6.917043745475622e-20,
  1.959381719430461e-22, -5.485664796052333e-25,  1.519800014406953e-27, -4.171951471083152e-30,  4.089004095796620e-02, -1.279156470363546e-04,  4.968564894963045e-07,
 -1.913215536368828e-09,  7.070579107357176e-12, -2.519953006862582e-14,  8.722824802045420e-17, -2.947931802650907e-19,  9.762347115475870e-22, -3.176363323789028e-24,
  1.017492156960066e-26, -3.214164347534573e-29,  3.379987816832551e-02, -1.429558011071932e-04,  7.191540496147866e-07, -3.357598612547129e-09,  1.469069172935387e-11,
 -6.127031981562053e-14,  2.460937995760769e-16, -9.581368497480654e-19,  3.632748722521675e-21, -1.345972587143250e-23,  4.886698852691218e-26, -1.742285898328507e-28,
  2.622443444623804e-02, -1.495328572035027e-04,  9.270295807710347e-07, -5.111279273637498e-09,  2.604235789565051e-11, -1.252420707759496e-13,  5.753009485455166e-16,
 -2.544160896412797e-18,  1.089395571800736e-20, -4.536268215883119e-23,  1.843107674064418e-25, -7.326652511027966e-28,  1.910047372298258e-02, -1.442023928685853e-04,
  1.070262314344927e-06, -6.878063356453958e-09,  4.035735887678955e-11, -2.213364604516230e-13,  1.150413695897484e-15, -5.720185730830667e-18,  2.739518730480240e-20,
 -1.270182016168350e-22,  5.724104184491028e-25, -2.515137130481940e-27,  1.306164778997524e-02, -1.277036288369975e-04,  1.116039433512421e-06, -8.284917335739167e-09,
  5.548312789849315e-11, -3.440294110223194e-13,  2.006864419044313e-15, -1.113370354971587e-17,  5.920298527938896e-20, -3.035024697042449e-22,  1.506797936605773e-24,
 -7.270577885052849e-27,  8.387893008399023e-03, -1.039220309690020e-04,  1.058368056988016e-06, -9.008543099818892e-09,  6.834872360103899e-11, -4.758520451840171e-13,
  3.095400093520773e-15, -1.904402670474474e-17,  1.117845886460715e-19, -6.301031140385322e-22,  3.427914480134785e-24, -1.806993645165917e-26,  5.059552669435045e-03,
 -7.788540801865619e-05,  9.175085137012771e-07, -8.896548986305688e-09,  7.600133784154976e-11, -5.907619272593384e-13,  4.262735355582013e-15, -2.893919459933146e-17,
  1.866242461953279e-19, -1.151423414790646e-21,  6.834075131492279e-24, -3.919084201832317e-26,  2.867469144619049e-03, -5.389973458595012e-05,  7.300248951682618e-07,
 -8.017755486933710e-09,  7.671987290448339e-11, -6.626474426596380e-13,  5.280382216612707e-15, -3.939174931658192e-17,  2.779842871430114e-19, -1.870138369745812e-21,
  1.206583387246737e-23, -7.500801407129266e-26,  1.527417824624366e-03, -3.453108626421479e-05,  5.348419364891404e-07, -6.619601482288268e-09,  7.062955108350934e-11,
 -6.751027130827211e-13,  5.918505684179667e-15, -4.834416557529593e-17,  3.720671126823429e-19, -2.720540735771212e-21,  1.902071495804370e-23, -1.277965298107187e-25,
  7.649958219523525e-04, -2.052822229825093e-05,  3.617960220444970e-07, -5.023230148565662e-09,  5.952797970658434e-11, -6.274270388478933e-13,  6.031586336796485e-15,
 -5.377883625517407e-17,  4.500672670592643e-19, -3.566781974584348e-21,  2.695068738591447e-23, -1.951997953013311e-25,  3.604122522773261e-04, -1.134856704471892e-05,
  2.265165038580749e-07, -3.513563527687042e-09,  4.608300718312916e-11, -5.339108735917906e-13,  5.611768629084564e-15, -5.446862862127026e-17,  4.944076388986860e-19,
 -4.236295591733998e-21,  3.451295726911021e-23, -2.688606846619935e-25,  1.598112750196984e-04, -5.845610945497063e-06,  1.315479075877892e-07, -2.271100874206811e-09,
  3.286288711563750e-11, -4.173394484457657e-13,  4.783620443324018e-15, -5.042212639242192e-17,  4.952721183940468e-19, -4.578328866716105e-21,  4.013341335209414e-23,
 -3.355995404490719e-25,  6.673376884486387e-05, -2.810650847222824e-06,  7.100695741196341e-08, -1.359773007859715e-09,  2.164490121197993e-11, -3.005257805736286e-13,
  3.747754183771655e-15, -4.280676618450649e-17,  4.540828051155548e-19, -4.519825590097961e-21,  4.255229982704871e-23, -3.812753419599479e-25,  2.626132191476408e-05,
 -1.263626660152873e-06,  3.569383070755008e-08, -7.557733128001444e-10,  1.319914364733451e-11, -1.998930341553197e-13,  2.706374361038368e-15, -3.343142769369962e-17,
  3.822788605863714e-19, -4.090121770173433e-21,  4.128771890499391e-23, -3.957738352174784e-25,  9.746910772403304e-06, -5.320944465044952e-07,  1.674091378905239e-08,
 -3.907736064210256e-10,  7.469216760725645e-12, -1.231167590776663e-13,  1.806195451779257e-15, -2.408693019335478e-17,  2.964047137036045e-19, -3.403509007239652e-21,
  3.678279172658205e-23, -3.766677901476506e-25,  3.415025169339320e-06, -2.102003536634947e-07,  7.339545936962132e-09, -1.883475492345024e-10,  3.931053931955531e-12,
 -7.038405015985739e-14,  1.116866353621342e-15, -1.605294465394462e-17,  2.122626093351302e-19, -2.612024362302435e-21,  3.018116594430323e-23, -3.297395756824252e-25,
  1.130709912940109e-06, -7.803313614401582e-08,  3.013559685406578e-09, -8.479779796877260e-11,  1.928408822630985e-12, -3.743507555999097e-14,  6.414495910014994e-16,
 -9.921866203949740e-18,  1.407718754310097e-19, -1.853992462578284e-21,  2.287518918230443e-23, -2.663192262136433e-25,  3.542068691951334e-07, -2.726943542671306e-08,
  1.161040807967565e-09, -3.573547590811946e-11,  8.836907195790232e-13, -1.856672163325059e-14,  3.430049753075467e-16, -5.701567588904440e-18,  8.668677536711395e-20,
 -1.220399906764852e-21,  1.606035709580308e-23, -1.990296090098384e-25,  1.051240295397028e-07, -8.986988409204417e-09,  4.205738307334181e-10, -1.412641616591076e-11,
  3.791288303547704e-13, -8.607173443773898e-15,  1.711872601698909e-16, -3.053880579589464e-18,  4.969534355010692e-20, -7.470107624853532e-22,  1.047392216009367e-23,
 -1.380232746013208e-25,  2.960459150238983e-08, -2.798568306949603e-09,  1.435427255709596e-10, -5.249884910614203e-12,  1.526397154192523e-13, -3.738520356621843e-15,
  7.993815493053774e-17, -1.528540601160841e-18,  2.659165149747738e-20, -4.263365431420632e-22,  6.362481426832946e-24, -8.907051768704594e-26,  7.924897268996679e-09,
 -8.251860120868307e-10,  4.626393353555491e-11, -1.838553312200730e-12,  5.780975003369970e-14, -1.525252883684618e-15,  3.501589758449063e-17, -7.168230779861025e-19,
  1.331709786258917e-20, -2.274947257006048e-22,  3.610125666813801e-24, -5.364151962796389e-26,  2.020577846016279e-09, -2.309166705276216e-10,  1.411498313919124e-11,
 -6.082818465401977e-13,  2.064956717430570e-14, -5.860511784705459e-16,  1.442699971801919e-17, -3.158268558606979e-19,  6.259221779333575e-21, -1.138188046668804e-22,
  1.918872114136327e-24, -3.023575750570840e-26,  4.918043609636474e-10, -6.148056920024065e-11,  4.087331139468684e-12, -1.906403817766392e-13,  6.975915755940018e-15,
 -2.126694055958898e-16,  5.606967517850255e-18, -1.311129830249920e-19,  2.769171631916651e-21, -5.355093840626653e-23,  9.582917987429059e-25, -1.599950717888931e-26,
  1.145680710042163e-10, -1.561731183944260e-11,  1.126610255815594e-12, -5.676590765029503e-14,  2.235490927359260e-15, -7.310825220137370e-17,  2.061816159870479e-18,
 -5.144479799056059e-20,  1.156771880100945e-21, -2.376782240171772e-23,  4.510714168064455e-25, -7.973235663140999e-27,  2.561869397445292e-11, -3.796642415572662e-12,
  2.965239070703867e-13, -1.611103244944446e-14,  6.817749416043832e-16, -2.388607654267910e-17,  7.197378970404468e-19, -1.914145798533337e-20,  4.577808461484124e-22,
 -9.984565574866887e-24,  2.007894997580875e-25, -3.754576760864162e-27,  5.517036194231522e-12, -8.863567864909768e-13,  7.478578271232459e-14, -4.373812665062642e-15,
  1.985878529119631e-16, -7.443757943227305e-18,  2.393622758593254e-19, -6.778001222474698e-21,  1.722403529748797e-22, -3.984201533277701e-24,  8.482794139746207e-26,
 -1.676636040938320e-27,  1.148491712753686e-12, -1.994777425788123e-13,  1.814412002104090e-14, -1.140230438237832e-15,  5.546332596874449e-17, -2.221294405652580e-18,
  7.613571132596295e-20, -2.293038892623784e-21,  6.185352278606390e-23, -1.516019989675230e-24,  3.414383683355153e-26, -7.127465392380127e-28,  2.320840494390752e-13,
 -4.346210229345302e-14,  4.252831022270945e-15, -2.866765683907083e-16,  1.491658755465211e-17, -6.374538260536751e-19,  2.326087307005261e-20, -7.442996331551755e-22,
  2.129015577786979e-23, -5.523844580619338e-25,  1.314834697530520e-26, -2.896332255538466e-28,  4.574101561715072e-14, -9.211372335788196e-15,  9.676501436329335e-16,
 -6.984381682839457e-17,  3.881531682134185e-18, -1.767530665862356e-19,  6.858046723182862e-21, -2.328769635211319e-22,  7.056298819983061e-24, -1.936121101057081e-25,
  4.866085902831094e-27, -1.130122652452313e-28,  8.839017309484978e-15, -1.909139104313262e-15,  2.148600601365440e-16, -1.657630122920446e-17,  9.823765917954067e-19,
 -4.760057021559442e-20,  1.961287807318040e-21, -7.059182048117073e-23,  2.263300191465667e-24, -6.560512864695005e-26,  1.739298522984442e-27, -4.254798842767924e-29,
  1.684621889237639e-15, -3.892330163135113e-16,  4.683135300134348e-17, -3.854766125144880e-18,  2.432184496393617e-19, -1.252158795074709e-20,  5.471351949814934e-22,
 -2.084717576143934e-23,  7.064146511440487e-25, -2.160786208907764e-26,  6.036401198841218e-28, -1.553825068862375e-29,  3.187509545433972e-16, -7.857364749707697e-17,
  1.008498418533449e-17, -8.839836353909677e-19,  5.928035046081379e-20, -3.237615120613257e-21,  1.498096332720904e-22, -6.034570519784511e-24,  2.158402712146813e-25,
 -6.958554153115542e-27,  2.046057863499826e-28, -5.535835361506084e-30,  6.031231140456120e-17, -1.581866570122486e-17,  2.161071319006656e-18, -2.013194074074474e-19,
  1.432313191804021e-20, -8.284804728915358e-22,  4.053249504671470e-23, -1.723581777301370e-24,  6.498209604213536e-26, -2.205189217356979e-27,  6.816062245336739e-29,
 -1.936048114695239e-30,  1.150368395383190e-17, -3.201294004964983e-18,  4.644213280189950e-19, -4.588465142925462e-20,  3.456776024624098e-21, -2.113826757969855e-22,
  1.091613361895558e-23, -4.892504751435033e-25,  1.941399108323433e-26, -6.924811742755081e-28,  2.246908107175459e-29, -6.691241600593157e-31,  2.231185082169984e-18,
 -6.568893752669122e-19,  1.009481763188428e-19, -1.055417431727653e-20,  8.401997193068394e-22, -5.421182899134126e-23,  2.949702616150144e-24, -1.390978925702365e-25,
  5.799707712787230e-27, -2.170952137395201e-28,  7.383348099996875e-30, -2.301818702253685e-31,  4.442276358145740e-19, -1.379501924045433e-19,  2.239832300113098e-20,
 -2.472139729056792e-21,  2.074985850442474e-22, -1.409692006941901e-23,  8.065352228424774e-25, -3.994066540606326e-26,  1.746654589790099e-27, -6.849150229352881e-29,
  2.437401000095912e-30, -7.941913401292042e-32,  9.171466172665698e-20, -2.994672696323568e-20,  5.122961612715613e-21, -5.953738921215303e-22,  5.256060278685622e-23,
 -3.751153339524633e-24,  2.251759688911190e-25, -1.168547470627687e-26,  5.348868084309638e-28, -2.192935145878397e-29,  8.150418525293383e-31, -2.770505786598736e-32,
  1.984578516972292e-20, -6.791134983996572e-21,  1.220389117794128e-21, -1.489240615060654e-22,  1.379153208508350e-23, -1.031366031868117e-24,  6.479977796048828e-26,
 -3.515727863130024e-27,  1.680641748526352e-28, -7.188295415378907e-30,  2.784361435560267e-31, -9.853559134077165e-33,  4.550821732540625e-21, -1.626404643310176e-21,
  3.060407835271632e-22, -3.909555198632198e-23,  3.786991724788193e-24, -2.959260046251346e-25,  1.940816553225019e-26, -1.098046834884760e-27,  5.468128257806936e-29,
 -2.434014125013468e-30,  9.802698015507914e-32, -3.603349430062059e-33,  1.118251112577290e-21, -4.158848853041855e-22,  8.166314930640190e-23, -1.088497028189248e-23,
  1.099360679077643e-24, -8.949380181217743e-26,  6.108784529983046e-27, -3.593736067243262e-28,  1.859172115013636e-29, -8.589538190850184e-31,  3.587397041865125e-32,
 -1.366241820270976e-33,  2.976515537367649e-22, -1.147613863384400e-22,  2.342879231653176e-23, -3.246807828404763e-24,  3.407367472308586e-25, -2.879961467949461e-26,
  2.039407983283822e-27, -1.243617152575783e-28,  6.663315267053509e-30, -3.185789308954637e-31,  1.375809353849385e-32, -5.413406532572252e-34,  8.666878489361264e-23,
 -3.450586652801973e-23,  7.295166620320875e-24, -1.047071904423471e-24,  1.137533119877611e-25, -9.946455606526355e-27,  7.281268143667500e-28, -4.586572862958736e-29,
  2.536701215501109e-30, -1.250999685879757e-31,  5.568656075618898e-33, -2.256745641274525e-34,  2.782295295862804e-23, -1.139195380465083e-23,  2.483727897297454e-24,
 -3.676924363670211e-25,  4.118548608690826e-26, -3.710874018055341e-27,  2.797506663065754e-28, -1.813546302823847e-29,  1.031586232108697e-30, -5.228924756075643e-32,
  2.390853556733420e-33, -9.945771707950422e-35,  9.888014775842013e-24, -4.146004793403897e-24,  9.280400012369968e-25, -1.410816796458523e-25,  1.622270003484970e-26,
 -1.499845748962725e-27,  1.159592099694921e-28, -7.705304568951138e-30,  4.490095803223448e-31, -2.330319185135358e-32,  1.090377582989465e-33, -4.639062817173990e-35,
  3.878475208321802e-24, -1.658113337645506e-24,  3.792712744597469e-25, -5.893158335822051e-26,  6.924637871826178e-27, -6.539678879790834e-28,  5.162581156454683e-29,
 -3.501149076500054e-30,  2.081329785254081e-31, -1.101467714559871e-32,  5.253076420814411e-34, -2.276870072420645e-35,  1.648559635947194e-24, -7.154043607324755e-25,
  1.664049480822823e-25, -2.629842800208457e-26,  3.142493085610317e-27, -3.017228686141039e-28,  2.420765088185276e-29, -1.667947207942107e-30,  1.007044101631056e-31,
 -5.410853748644361e-33,  2.619067034824167e-34, -1.151720741989735e-35,  7.152847485905596e-25, -3.136498331582009e-25,  7.381544557820817e-26, -1.180498641186422e-26,
  1.427312524444818e-27, -1.386369984038817e-28,  1.124999959253380e-29, -7.838054401806377e-31,  4.784053823558395e-32, -2.597949234620397e-33,  1.270649197599067e-34,
 -5.644509353360058e-36,  2.478491001371041e-25, -1.093134778529697e-25,  2.589531316002195e-26, -4.168930953024365e-27,  5.073868337203764e-28, -4.960374342353414e-29,
  4.050876421633045e-30, -2.839936697054657e-31,  1.743982063713322e-32, -9.527170054123670e-34,  4.686931036184017e-35, -2.093893991051039e-36,  4.907354177545965e-02,
 -9.876421895363928e-05,  2.044679630737093e-07, -4.338809184088814e-10,  9.392248907445232e-13, -2.064754967854812e-15,  4.588066764605387e-18, -1.027400417027388e-20,
  2.309878084059021e-23, -5.210063426113925e-26,  1.174773983272979e-28, -2.653444015275295e-31,  4.598739629212851e-02, -1.087653990442826e-04,  3.021153983861912e-07,
 -8.891838482107466e-10,  2.633449290364246e-12, -7.711892089539089e-15,  2.224111089625966e-17, -6.320500707129893e-20,  1.772412149712304e-22, -4.912909099639310e-25,
  1.347681681566099e-27, -3.663332076219205e-30,  4.038618533478869e-02, -1.240307438465805e-04,  4.745604078982867e-07, -1.804007194073917e-09,  6.586872500099907e-12,
 -2.320167547713968e-14,  7.939474605801719e-17, -2.653073881437063e-19,  8.688832301310202e-22, -2.796290261254796e-24,  8.861111610990037e-27, -2.769395225357924e-29,
  3.323931177220815e-02, -1.373598286658513e-04,  6.802337493929802e-07, -3.132038780468332e-09,  1.352224082740365e-11, -5.567330118654383e-14,  2.208232004363953e-16,
 -8.492789333438424e-19,  3.181611109189173e-21, -1.165011187437000e-23,  4.180922551586689e-26, -1.473700497925254e-28,  2.564075678876824e-02, -1.423550640525538e-04,
  8.681140016360405e-07, -4.713913616726030e-09,  2.367001591426483e-11, -1.122517531191140e-13,  5.087092235371906e-16, -2.220321061676241e-18,  9.386186602632810e-21,
 -3.859660175254265e-23,  1.548982866250667e-25, -6.083222948070505e-28,  1.854028068134618e-02, -1.359597911417400e-04,  9.914584931850018e-07, -6.266312035185004e-09,
  3.619425016401139e-11, -1.955535254980228e-13,  1.001864412013003e-15, -4.912490876892315e-18,  2.320932669884059e-20, -1.061905578463905e-22,  4.723627891438125e-25,
 -2.049180946673325e-27,  1.256808088872585e-02, -1.191584044237923e-04,  1.021727942733450e-06, -7.449717310601060e-09,  4.906000090938749e-11, -2.994012061579249e-13,
  1.720080548732044e-15, -9.402990941896334e-18,  4.928888577007697e-20, -2.491733556780970e-22,  1.220287076095634e-24, -5.809796258554271e-27,  7.988479448432326e-03,
 -9.586960367141471e-05,  9.565255514415800e-07, -7.987237734016595e-09,  5.953339028055200e-11, -4.075770735695901e-13,  2.609016758515849e-15, -1.580487603443638e-17,
  9.138866653126417e-20, -5.076613699288534e-22,  2.722667727038472e-24, -1.415322226446463e-26,  4.762043080364456e-03, -7.095256506085249e-05,  8.176734326467506e-07,
 -7.769754715031697e-09,  6.514685340205703e-11, -4.975415097667659e-13,  3.530171545568012e-15, -2.358087683754634e-17,  1.497044507902081e-19, -9.096763864631577e-22,
  5.319644804274811e-24, -3.006659773074799e-26,  2.662969441833094e-03, -4.842448416229504e-05,  6.407609113475963e-07, -6.889733182989271e-09,  6.464981791829246e-11,
 -5.482077371499964e-13,  4.292457512334210e-15, -3.148639693079852e-17,  2.186059146778377e-19, -1.447599786655275e-21,  9.196994731842326e-24, -5.632084479814807e-26,
  1.397373690169213e-03, -3.055185861060575e-05,  4.617653858941214e-07, -5.590264508374859e-09,  5.844488106650134e-11, -5.480423277726733e-13,  4.717818023829137e-15,
 -3.786854544793479e-17,  2.865672476767047e-19, -2.061371713885837e-21,  1.418464550795616e-23, -9.383674792641151e-26,  6.883115664066838e-04, -1.785968257599554e-05,
  3.068419903029875e-07, -4.163789755416916e-09,  4.831298244418837e-11, -4.992228150434561e-13,  4.709497064742796e-15, -4.123880605200702e-17,  3.391609684503519e-19,
 -2.642887032782535e-21,  1.964505927484582e-23, -1.400321756574162e-25,  3.183919001477404e-04, -9.693317936621773e-06,  1.884476899817768e-07, -2.854831498879857e-09,
  3.663675377786782e-11, -4.158740410554767e-13,  4.286988296906817e-15, -4.084279323550843e-17,  3.641394846254000e-19, -3.066449166813811e-21,  2.456510124208157e-23,
 -1.882543995393892e-25,  1.383728253862955e-04, -4.893897909339051e-06,  1.071930581731695e-07, -1.806280796285979e-09,  2.555845721166250e-11, -3.178253800583422e-13,
  3.570957083153652e-15, -3.692746382967499e-17,  3.561091244468086e-19, -3.233869749122191e-21,  2.786306842903136e-23, -2.291164627204804e-25,  5.653168107885709e-05,
 -2.302403836982415e-06,  5.658402897490643e-08, -1.057031437761179e-09,  1.644464905472723e-11, -2.234601572159535e-13,  2.730297296377502e-15, -3.058127586496128e-17,
  3.183498006744576e-19, -3.111670999822938e-21,  2.878315542372112e-23, -2.535196123186231e-25,  2.172517274854360e-05, -1.011045360269010e-06,  2.777035772767667e-08,
 -5.733358222368626e-10,  9.781595955875522e-12, -1.449161371184353e-13,  1.921508833867748e-15, -2.326689940134223e-17,  2.609904459131843e-19, -2.741111347219767e-21,
  2.717734881982163e-23, -2.560068162967430e-25,  7.859328241439899e-06, -4.150655426048104e-07,  1.269446452526861e-08, -2.888209217247625e-10,  5.390832660934022e-12,
 -8.689328823524047e-14,  1.247981904593607e-15, -1.630799137246801e-17,  1.967972570064707e-19, -2.217526884473261e-21,  2.353162525605954e-23, -2.367341256808150e-25,
  2.678721607593096e-06, -1.595536497985299e-07,  5.414634093529736e-09, -1.353957918718359e-10,  2.758639056343596e-12, -4.828471437805433e-14,  7.498512708850616e-16,
 -1.055779119550522e-17,  1.368616051137342e-19, -1.652245272823980e-21,  1.874070726990575e-23, -2.010990486818769e-25,  8.610214948094107e-07, -5.752232703573764e-08,
  2.158878041818531e-09, -5.918244876544600e-11,  1.313542754189549e-12, -2.492088361351470e-14,  4.178069065791228e-16, -6.329119921298103e-18,  8.801406716038112e-20,
 -1.136932094063665e-21,  1.376734481792366e-23, -1.573941677243037e-25,  2.612953710380218e-07, -1.948161166584311e-08,  8.061084368233532e-10, -2.416894030154692e-11,
  5.832089377550102e-13, -1.197342252159513e-14,  2.163856186393232e-16, -3.521891651862103e-18,  5.247347795139841e-20, -7.244389837006334e-22,  9.354915059356594e-24,
 -1.138238729865973e-25,  7.496165160754235e-08, -6.209107535483227e-09,  2.824232687873803e-10, -9.240406415942173e-12,  2.419770176097342e-13, -5.367311777699006e-15,
  1.044135085115424e-16, -1.823615597856253e-18,  2.907668482609218e-20, -4.285614206732999e-22,  5.895592542045369e-24, -7.626962753690383e-26,  2.035990497884578e-08,
 -1.865774091386938e-09,  9.303179450828215e-11, -3.314560896260141e-12,  9.403033368393727e-14, -2.250037386606529e-15,  4.705498182862518e-17, -8.808320776661479e-19,
  1.501331893620458e-20, -2.359981171440273e-22,  3.455279782506894e-24, -4.748351290323092e-26,  5.244124648464887e-09, -5.296532508418123e-10,  2.887551625844367e-11,
 -1.118022805152053e-12,  3.430280273791656e-14, -8.842438378586377e-16,  1.985449396138536e-17, -3.978929675092093e-19,  7.242228039184661e-21, -1.212970869938477e-22,
  1.888399678558282e-24, -2.754341546828383e-26,  1.283414013347514e-09, -1.423596512994913e-10,  8.464774041366810e-12, -3.554873793258742e-13,  1.177737427354064e-14,
 -3.266021846291854e-16,  7.864209345651741e-18, -1.685440276895003e-19,  3.272750586594045e-21, -5.834993073306962e-23,  9.651192483773327e-25, -1.492852852971878e-26,
  2.990963436858472e-10, -3.631650184087023e-11,  2.349634643109057e-12, -1.068298555975692e-13,  3.815890665629637e-15, -1.136902008843382e-16,  2.932276310341801e-18,
 -6.713699662263292e-20,  1.389448047175108e-21, -2.634736957976695e-23,  4.626132490009900e-25, -7.582781405426198e-27,  6.654166387680989e-11, -8.816954285662197e-12,
  6.193072731455116e-13, -3.043028935772348e-14,  1.170151864272071e-15, -3.740847957212765e-17,  1.032304759012231e-18, -2.522455697314983e-20,  5.558827665743719e-22,
 -1.120145640524465e-23,  2.086165237218768e-25, -3.620809460438676e-27,  1.417270859143690e-11, -2.043344167880364e-12,  1.554827654921929e-13, -8.242079252659122e-15,
  3.407020574991566e-16, -1.167235229193188e-17,  3.442475877895471e-19, -8.968341007053633e-21,  2.102595330430871e-22, -4.498605019161469e-24,  8.879819000773306e-26,
 -1.630739896244046e-27,  2.899324116469972e-12, -4.535643816652164e-13,  3.731002688503174e-14, -2.130094004017599e-15,  9.451858849555810e-17, -3.465911048760800e-18,
  1.091255816632769e-19, -3.028045354242819e-21,  7.545634458161637e-23, -1.712711144506296e-24,  3.580317320817421e-26, -6.951892582633398e-28,  5.717730866243983e-13,
 -9.679519027386268e-14,  8.590174045400513e-15, -5.273131931034711e-16,  2.508131086308181e-17, -9.831683186977761e-19,  3.301061446820716e-20, -9.746522103054125e-22,
  2.579138508476772e-23, -6.205260765780130e-25,  1.372660008054451e-26, -2.815904394419827e-28,  1.091552272712426e-13, -1.994475515717129e-14,  1.905762582536473e-15,
 -1.255763084381784e-16,  6.393415064216763e-18, -2.675735148049141e-19,  9.569681425792186e-21, -3.003380606323176e-22,  8.431775000351172e-24, -2.148434385690157e-25,
  5.024984629702800e-27, -1.088241114870980e-28,  2.026778717362855e-14, -3.986854229375734e-15,  4.093536287382659e-16, -2.890581801003921e-17,  1.572988637522612e-18,
 -7.019581996200644e-20,  2.671111785301089e-21, -8.901496244434082e-23,  2.648691591623852e-24, -7.140961549333356e-26,  1.764440110877156e-27, -4.030682297618805e-29,
  3.679739574033976e-15, -7.772743548954900e-16,  8.558623624105636e-17, -6.465505179716508e-18,  3.755027841924643e-19, -1.784422838909714e-20,  7.215753738797010e-22,
 -2.550526013999255e-23,  8.035470143211130e-25, -2.290026153592313e-26,  5.972185652918214e-28, -1.437835568424702e-29,  6.571592867124570e-16, -1.486793149605858e-16,
  1.752111166665012e-17, -1.413567133365729e-18,  8.748394287687135e-20, -4.420874840960817e-21,  1.897331002245416e-22, -7.104893835404208e-24,  2.367421439765243e-25,
 -7.124592244357176e-27,  1.959162618280502e-28, -4.966424568120479e-30,  1.162173622596605e-16, -2.808973695628762e-17,  3.535390440236139e-18, -3.040629220278441e-19,
  2.002046241108183e-20, -1.074260803619711e-21,  4.886592567846216e-23, -1.936147165577755e-24,  6.815187280948180e-26, -2.163369489723491e-27,  6.266077565396931e-29,
 -1.670790710826614e-30,  2.050473778216808e-17, -5.280504436712027e-18,  7.082831059885307e-19, -6.481564831555051e-20,  4.532561274737186e-21, -2.578399798206567e-22,
  1.241286925812498e-23, -5.196684138496853e-25,  1.929856024128704e-26, -6.453753269506752e-28,  1.966628282885550e-29, -5.509482082488365e-31,  3.639199569164412e-18,
 -9.958235730165359e-19,  1.420278539830086e-19, -1.380125635194544e-20,  1.023143105868904e-21, -6.159897068500080e-23,  3.133489223403275e-24, -1.384048439635108e-25,
  5.414890208660257e-27, -1.905113947974388e-28,  6.099718336552776e-30, -1.793140224309613e-31,  6.556487270871097e-19, -1.900933020003689e-19,  2.875930902630559e-20,
 -2.961139110793470e-21,  2.322556087332285e-22, -1.477156541528895e-23,  7.925994073892137e-25, -3.687439608134341e-26,  1.517455546964211e-27, -5.608326034218363e-29,
  1.883946469220298e-30, -5.803329665899875e-32,  1.211026964820856e-19, -3.709161485353918e-20,  5.937446071650440e-21, -6.462554054505198e-22,  5.351305984825828e-23,
 -3.588041017168154e-24,  2.026830383108536e-25, -9.913715249048683e-27,  4.283651573034951e-28, -1.660279592529212e-29,  5.841888104062269e-31, -1.882687323243686e-32,
  2.317914225527440e-20, -7.476323297780877e-21,  1.262801228683786e-21, -1.449324800734689e-22,  1.263974828060550e-23, -8.914487599813431e-25,  5.290028426438037e-26,
 -2.714771899327049e-27,  1.229251890275056e-28, -4.986913134758174e-30,  1.834602689521084e-31, -6.174590065696774e-33,  4.649901877683933e-21, -1.574250423196397e-21,
  2.797445331774628e-22, -3.376146717340428e-23,  3.092984866853061e-24, -2.288841087775467e-25,  1.423455546508066e-26, -7.646814495822525e-28,  3.620416215715428e-29,
 -1.534072000917043e-30,  5.888376107030488e-32, -2.065519472316881e-33,  9.893681444912579e-22, -3.503647473491299e-22,  6.529249759999407e-23, -8.261205964787826e-24,
  7.927495315507943e-25, -6.138434859966775e-26,  3.990265938184262e-27, -2.238151987068410e-28,  1.105259568962153e-29, -4.879861281719822e-31,  1.949785890907503e-32,
 -7.112228370009201e-34,  2.259985169766874e-22, -8.340895161105601e-23,  1.624470275562147e-23, -2.147740789413155e-24,  2.151975248416700e-25, -1.738280956956499e-26,
  1.177613120173607e-27, -6.877098223528284e-29,  3.532468065655381e-30, -1.620741527853057e-31,  6.723439097184712e-33, -2.543862705692277e-34,  5.608737333746034e-23,
 -2.149049931987819e-23,  4.357953423037316e-24, -5.999033393261142e-25,  6.254487255275056e-26, -5.252629631162179e-27,  3.696448127033931e-28, -2.240427183391768e-29,
  1.193356161950699e-30, -5.672864414841270e-32,  2.436223469911321e-33, -9.533976285299620e-35,  1.529108117797983e-23, -6.058180172449492e-24,  1.274005063324668e-24,
 -1.818864976154234e-25,  1.965699616026420e-26, -1.710029593549424e-27,  1.245607327848201e-28, -7.808336847803234e-30,  4.298255431648768e-31, -2.110026984098808e-32,
  9.350671447452517e-34, -3.773055811136343e-35,  4.621614781054636e-24, -1.885343304245313e-24,  4.093950547189034e-25, -6.036230953641932e-26,  6.734365913202359e-27,
 -6.044200358893673e-28,  4.539269094931992e-29, -2.931827284631045e-30,  1.661700100690926e-31, -8.393410809524644e-33,  3.824710613092682e-34, -1.585793663757014e-35,
  1.557011342244229e-24, -6.511467701957311e-25,  1.453323769959220e-25, -2.202961888554400e-26,  2.525917066381639e-27, -2.328781777558533e-28,  1.795572778912300e-29,
 -1.189962274036344e-30,  6.916311662539712e-32, -3.580464493170288e-33,  1.671223960042919e-34, -7.093368954143194e-36,  5.836845016871785e-25, -2.491087066882554e-25,
  5.687193929535607e-26, -8.819900249109380e-27,  1.034406958290617e-27, -9.750938016374701e-29,  7.683714434638573e-30, -5.201739839066949e-31,  3.086967007316301e-32,
 -1.630928881811529e-33,  7.765471564212208e-35, -3.360496005629865e-36,  2.393407850638278e-25, -1.037599293305787e-25,  2.410783419623148e-26, -3.805668069479825e-27,
  4.542453026205581e-28, -4.356608959974183e-29,  3.491626039709690e-30, -2.403272457573344e-31,  1.449525297905430e-32, -7.780554674145775e-34,  3.762439158305694e-35,
 -1.652950156014076e-36,  1.012241086999708e-25, -4.436439613357161e-26,  1.043503495568775e-26, -1.667884975806007e-27,  2.015467723243007e-28, -1.956573132189383e-29,
  1.586844202142808e-30, -1.104993769129828e-31,  6.740969763742671e-33, -3.658783532479951e-34,  1.788612863857156e-35, -7.941580186770295e-37,  3.457063591950349e-26,
 -1.524408860522122e-26,  3.610306378550168e-27, -5.810862881082306e-28,  7.070472494952056e-29, -6.910637374865148e-30,  5.642199919783343e-31, -3.954626885518040e-32,
  2.427939500970469e-33, -1.326051480727900e-34,  6.522097338011982e-36, -2.913114427663961e-37,  4.868172376867744e-02, -9.714904916399995e-05,  1.993502140203517e-07,
 -4.191777944404511e-10,  8.990080504014664e-13, -1.958011606921050e-15,  4.310467269147479e-18, -9.563968565030534e-21,  2.130500301822930e-23, -4.762685044322567e-26,
  1.064087343609425e-28, -2.382980687578846e-31,  4.555710196037676e-02, -1.063904519202907e-04,  2.916930058204298e-07, -8.482541502773978e-10,  2.484409210497675e-12,
 -7.198717384156728e-15,  2.054818828666063e-17, -5.780617478341230e-20,  1.604874618254733e-22, -4.404726509422478e-25,  1.196453473893525e-27, -3.220779934380521e-30,
  3.989752070507716e-02, -1.203190959056181e-04,  4.535296768193479e-07, -1.702228441767736e-09,  6.141307864152252e-12, -2.138229360017516e-14,  7.234073961181152e-17,
 -2.390476933100311e-19,  7.743137618982824e-22, -2.465055797974974e-24,  7.728239960413268e-27, -2.389897597324943e-29,  3.270052324586756e-02, -1.320647012745850e-04,
  6.439115859214215e-07, -2.924310584970994e-09,  1.245990406165950e-11, -5.064777368780225e-14,  1.984079314613827e-16, -7.538673391368541e-19,  2.790810437578712e-21,
 -1.010052056691869e-23,  3.583401645925722e-26, -1.248854272879272e-28,  2.508487696878680e-02, -1.356301480641369e-04,  8.137473660737045e-07, -4.352510828630555e-09,
  2.154220548990819e-11, -1.007560615651141e-13,  4.505445924191207e-16, -1.941049357533552e-18,  8.102074694984248e-21, -3.290447569076997e-23,  1.304513699522897e-25,
 -5.061942057555468e-28,  1.801184213007422e-02, -1.283193503176726e-04,  9.196124390818220e-07, -5.717231466445327e-09,  3.251290479122341e-11, -1.730788578008720e-13,
  8.741627548661790e-16, -4.227480821540281e-18,  1.970590868066253e-20, -8.898295140968890e-23,  3.907493884159489e-25, -1.673806878256708e-27,  1.210724699646904e-02,
 -1.113292639416559e-04,  9.368505188209816e-07, -6.710504916873104e-09,  4.346435726078781e-11, -2.611084130003856e-13,  1.477594073704795e-15, -7.960327946969819e-18,
  4.113895266084987e-20, -2.051151514346388e-22,  9.910183576014185e-25, -4.656072119016106e-27,  7.619720483499860e-03, -8.858519172610464e-05,  8.661355264567841e-07,
 -7.096658389602221e-09,  5.197380622711740e-11, -3.499568127462990e-13,  2.204817975484435e-15, -1.315299284285878e-17,  7.493183746859248e-20, -4.102609542581630e-22,
  2.169405003092227e-24, -1.112221163301867e-26,  4.490749149364184e-03, -6.476713331363121e-05,  7.303764172827108e-07, -6.802623482838959e-09,  5.599245736761239e-11,
 -4.202280888012518e-13,  2.932329882278705e-15, -1.927569507840721e-17,  1.204874725065970e-19, -7.211749306357140e-22,  4.155720505889407e-24, -2.315270187967951e-26,
  2.479023831026258e-03, -4.361231765636594e-05,  5.639460238198947e-07, -5.937738091190097e-09,  5.464833167272078e-11, -4.550234367676350e-13,  3.501418892019525e-15,
 -2.525840338492116e-17,  1.725573606561587e-19, -1.124903245087000e-21,  7.038595082081006e-24, -4.246581711383669e-26,  1.282151034608885e-03, -2.711096598422794e-05,
  3.999501985033524e-07, -4.737023855916812e-09,  4.853550300977997e-11, -4.465671447069500e-13,  3.775461055221465e-15, -2.978383443816234e-17,  2.216480405984362e-19,
 -1.568741478522976e-21,  1.062584789683162e-23, -6.922094780649164e-26,  6.214834596543521e-04, -1.559238821367904e-05,  2.612039434678351e-07, -3.464888106426820e-09,
  3.937125983525227e-11, -3.989074931466971e-13,  3.693466560220963e-15, -3.176758326874558e-17,  2.567920004903695e-19, -1.967836093244924e-21,  1.439142522138765e-23,
 -1.009717149700307e-25,  2.824301028553692e-04, -8.313400779387535e-06,  1.574494636314747e-07, -2.329959428979254e-09,  2.926191434454801e-11, -3.254883748599138e-13,
  3.291192628052245e-15, -3.078206267874412e-17,  2.696036131291457e-19, -2.231619330174620e-21,  1.758113585472009e-23, -1.325592160129640e-25,  1.203842589525130e-04,
 -4.116557519056851e-06,  8.777571183313197e-08, -1.443870701908201e-09,  1.998145282287720e-11, -2.433426898321679e-13,  2.680449734196277e-15, -2.719786770814168e-17,
  2.575365115654893e-19, -2.297796829964772e-21,  1.946167520181102e-23, -1.573883003924961e-25,  4.815297020669644e-05, -1.896314063669980e-06,  4.534163873578400e-08,
 -8.263820451928121e-10,  1.256689630244601e-11, -1.671532488845232e-13,  2.001268112185297e-15, -2.198433493793314e-17,  2.246180114532276e-19, -2.156204553865041e-21,
  1.959881724012581e-23, -1.697111375846403e-25,  1.808522847260251e-05, -8.139470518912456e-07,  2.174126612245797e-08, -4.377168414151916e-10,  7.296182131070608e-12,
 -1.057580527111377e-13,  1.373501658414590e-15, -1.630450360252579e-17,  1.794344803443762e-19, -1.850136579014787e-21,  1.801888420861894e-23, -1.668156307580065e-25,
  6.382135495879254e-06, -3.260291509375512e-07,  9.693659981790921e-09, -2.149864907749981e-10,  3.918882884826350e-12, -6.177732887938674e-14,  8.687080258612893e-16,
 -1.112471350493593e-17,  1.316644249937425e-19, -1.456032541775913e-21,  1.517269072229171e-23, -1.499713821756742e-25,  2.117821062869985e-06, -1.220527304034019e-07,
  4.025758765441430e-09, -9.809757798547170e-11,  1.951305993915340e-12, -3.339099645134142e-14,  5.075443253662189e-16, -7.000948190927765e-18,  8.898054124423689e-20,
 -1.053940206809169e-21,  1.173593889009177e-23, -1.236993205817591e-25,  6.614349481245996e-07, -4.276939415566767e-08,  1.559953958415930e-09, -4.166326276675855e-11,
  9.025414486789634e-13, -1.673617287690315e-14,  2.745546299648201e-16, -4.073484702196668e-18,  5.552566255289372e-20, -7.035560667057379e-22,  8.361895083289572e-24,
 -9.388024459829351e-26,  1.946318990297106e-07, -1.405074045168315e-08,  5.649967457783276e-10, -1.650157780401295e-11,  3.885724287273561e-13, -7.795518447220417e-15,
  1.378232777712088e-16, -2.196584612562962e-18,  3.207315336461911e-20, -4.342510274146059e-22,  5.502856002590437e-24, -6.574099961131714e-26,  5.402490362286685e-08,
 -4.334795964469292e-09,  1.916235516580713e-10, -6.107025800233654e-12,  1.560423970280685e-13, -3.381758641734347e-15,  6.434927631751532e-17, -1.100349649728805e-18,
  1.719118752167838e-20, -2.484547282206795e-22,  3.353589179947495e-24, -4.259231592763196e-26,  1.416546502321487e-08, -1.258101802125768e-09,  6.097694843425882e-11,
 -2.116222572378615e-12,  5.857548395355696e-14, -1.369378145996477e-15,  2.800926941431262e-17, -5.132842716116165e-19,  8.571615312674864e-21, -1.321070683143523e-22,
  1.897619012624807e-24, -2.559932687203532e-26,  3.514141464806914e-09, -3.441767539658620e-10,  1.824325705012396e-11, -6.881304901260572e-13,  2.060052920309667e-14,
 -5.188070252647257e-16,  1.139318246454012e-17, -2.235146729353609e-19,  3.985801162699232e-21, -6.544963926183147e-23,  9.996350458293496e-25, -1.431229108770102e-26,
  8.263379034078588e-10, -8.893839745149713e-11,  5.143293360016765e-12, -2.104649117241676e-13,  6.804284392591587e-15, -1.843609847883417e-16,  4.341871219305026e-18,
 -9.109644878263188e-20,  1.733059030254528e-21, -3.029429899317538e-23,  4.915844345578184e-25, -7.464218335535969e-27,  1.845707080352954e-10, -2.176014389104304e-11,
  1.369801325870508e-12, -6.070118839618768e-14,  2.116230973294891e-15, -6.161259865405646e-17,  1.554438293436504e-18, -3.484482786463703e-20,  7.065895607717336e-22,
 -1.313756839528114e-23,  2.263200896741501e-25, -3.641781478756208e-27,  3.925415316212309e-11, -5.054044226790456e-12,  3.455707742964421e-13, -1.655532720659165e-14,
  6.215205801921827e-16, -1.942045706134352e-17,  5.243259039773344e-19, -1.254574679681117e-20,  2.709377293805288e-22, -5.353941951904060e-24,  9.784351913391434e-26,
 -1.667341415174788e-27,  7.971312417199805e-12, -1.117630714183283e-12,  8.283146100666767e-14, -4.282924484690476e-15,  1.729077763992138e-16, -5.791689846537713e-18,
  1.671616076735106e-19, -4.265407063665716e-21,  9.801943352243791e-23, -2.057008198724596e-24,  3.985023374292323e-26, -7.186685086604352e-28,  1.550500485652376e-12,
 -2.360887433510507e-13,  1.892776344735599e-14, -1.054603853675206e-15,  4.572300117557323e-17, -1.639865819037152e-18,  5.054577744762778e-20, -1.374166000725238e-21,
  3.357429066033480e-23, -7.476799443643699e-25,  1.534387487754434e-26, -2.926464381510480e-28,  2.899235369074349e-13, -4.781753229812274e-14,  4.138943868763328e-15,
 -2.481055139186845e-16,  1.153646304299001e-17, -4.425131219193777e-19,  1.455134196422652e-20, -4.211019558225614e-22,  1.092962553042005e-23, -2.580842341601623e-25,
  5.606475957975174e-27, -1.130082874187474e-28,  5.233060455249835e-14, -9.325193988573390e-15,  8.697712606552403e-16, -5.600478656075059e-17,  2.789140917426252e-18,
 -1.142867884790645e-19,  4.005174462159511e-21, -1.232614165443420e-22,  3.395638813698249e-24, -8.495294765960688e-26,  1.952054393818135e-27, -4.155440358058613e-29,
  9.160641912794991e-15, -1.759319637388330e-15,  1.764857196883132e-16, -1.218755122729333e-17,  6.492033061591352e-19, -2.838305802559707e-20,  1.058931980362502e-21,
 -3.462363423793400e-23,  1.011473406253855e-24, -2.678864153338095e-26,  6.505938087759432e-28, -1.461562960430959e-29,  1.563525672947943e-15, -3.228246981511037e-16,
  3.476315331366878e-17, -2.570487875813422e-18,  1.462490125965368e-19, -6.813753589607171e-21,  2.703294681846644e-22, -9.381082822988904e-24,  2.903432766406952e-25,
 -8.133246801429511e-27,  2.085969875878062e-28, -4.941446711426344e-30,  2.617622536814299e-16, -5.796069982616172e-17,  6.686991156725550e-18, -5.285665465465498e-19,
  3.207452542755088e-20, -1.590391859240324e-21,  6.701863538277673e-23, -2.465683107359284e-24,  8.076686350157896e-26, -2.390719892676503e-27,  6.469452363706361e-29,
 -1.614652751320661e-30,  4.327904608178827e-17, -1.025120551610369e-17,  1.264592109045413e-18, -1.066707864290707e-19,  6.893280945776551e-21, -3.632620361586551e-22,
  1.623847636406370e-23, -6.326426879771635e-25,  2.190856411661415e-26, -6.845454444625186e-28,  1.952577573552863e-29, -5.129504392326451e-31,  7.120689261884375e-18,
 -1.799565929862036e-18,  2.368757309106763e-19, -2.128409406927509e-20,  1.462341213525204e-21, -8.177996529340494e-23,  3.872652913304843e-24, -1.595642093582914e-25,
  5.834791704094248e-27, -1.922246763985363e-28,  5.773087742808629e-30, -1.594683950964942e-31,  1.175785730632413e-18, -3.161990771672528e-19,  4.431417692834253e-20,
 -4.233295549208981e-21,  3.086906769903946e-22, -1.829040207279316e-23,  9.161493146695258e-25, -3.986494099804460e-26,  1.537208086810083e-27, -5.332821120928848e-29,
  1.684294849985882e-30, -4.886206353774555e-32,  1.966909134579453e-19, -5.612945105004327e-20,  8.355926000861943e-21, -8.468943324506165e-22,  6.541791645078706e-23,
 -4.099460030770083e-24,  2.168335990860982e-25, -9.948649761553154e-27,  4.039292908213982e-28, -1.473488800151993e-29,  4.887326030932584e-31, -1.487076343766134e-32,
  3.368096732287743e-20, -1.016930061641123e-20,  1.604117567841113e-21, -1.721033702807882e-22,  1.405304073039149e-23, -9.295601076333293e-25,  5.182361636584286e-26,
 -2.502710793952381e-27,  1.068114999972066e-28, -4.090463145698585e-30,  1.422597068243252e-31, -4.533094284493385e-33,  5.970604573379300e-21, -1.901426798328351e-21,
  3.169563149290677e-22, -3.590867415970779e-23,  3.092363081125026e-24, -2.154401008544702e-25,  1.263353424160645e-26, -6.409004362326545e-28,  2.869696388318914e-29,
 -1.151610745098199e-30,  4.192078414246352e-32, -1.396513255115907e-33,  1.109007890944006e-21, -3.713006537145327e-22,  6.521597933340642e-23, -7.780783401597363e-24,
  7.048764301859835e-25, -5.159649390258522e-26,  3.175081173777807e-27, -1.688230245516792e-28,  7.913689140942379e-30, -3.320929273301071e-31,  1.262762538476754e-32,
 -4.389235155846781e-34,  2.186109467372243e-22, -7.667982671788964e-23,  1.414619273628965e-23, -1.772071811833424e-24,  1.683974656823212e-25, -1.291614129370354e-26,
  8.318953811296476e-28, -4.624476181431174e-29,  2.263884969943447e-30, -9.911096387656092e-32,  3.927609017295215e-33, -1.421280839943056e-34,  4.633805908886045e-23,
 -1.696531908354595e-23,  3.276036871612849e-24, -4.294710286243782e-25,  4.267595727952234e-26, -3.419424530600303e-27,  2.298364940556128e-28, -1.331988291724611e-29,
  6.791183663290875e-31, -3.093451568177883e-32,  1.274296467583023e-33, -4.788641770920174e-35,  1.070085952754995e-23, -4.073433599383341e-24,  8.202405696760103e-25,
 -1.121237563014239e-25,  1.160983858717744e-26, -9.685081309253814e-28,  6.771434479458584e-29, -4.078251898813492e-30,  2.158920007209082e-31, -1.020154916046687e-32,
  4.355617410989793e-34, -1.694924401204413e-35,  2.725724093156528e-24, -1.074361977205466e-24,  2.246735703132935e-25, -3.189752481300857e-26,  3.428418553111974e-27,
 -2.966587307339199e-28,  2.149670051830525e-29, -1.340747954358605e-30,  7.344102561364087e-32, -3.587987672974141e-33,  1.582628412445761e-34, -6.357148904376017e-36,
  7.739356659752869e-25, -3.144984793564344e-25,  6.800281104662510e-26, -9.983978184473367e-27,  1.109223810392548e-27, -9.914881529527925e-29,  7.416613274181602e-30,
 -4.771716577680935e-31,  2.694328606422259e-32, -1.355945462205462e-33,  6.156744762251193e-35, -2.543862592432883e-36,  2.466469703071384e-25, -1.028650384292813e-25,
  2.288924436981646e-26, -3.459002278647744e-27,  3.954196677442817e-28, -3.634895102734665e-29,  2.794610797327810e-30, -1.846880458067545e-31,  1.070531153878560e-32,
 -5.527320095274402e-34,  2.573303222677644e-35, -1.089488291632494e-36,  8.819787686787283e-26, -3.757385172758955e-26,  8.560985492338999e-27, -1.324989883289104e-27,
  1.550871490238187e-28, -1.459097481905886e-29,  1.147579325066070e-30, -7.754510232052770e-32,  4.593594236874781e-33, -2.422651311823048e-34,  1.151539594033590e-35,
 -4.974975994650254e-37,  3.483266153075636e-26, -1.508489163514456e-26,  3.500730763760499e-27, -5.519690130041818e-28,  6.580575611855654e-29, -6.304078288152948e-30,
  5.046747130386870e-31, -3.469838713929575e-32,  2.090577348218727e-33, -1.120977081753833e-34,  5.415178091419693e-36, -2.376689338124832e-37,  1.434245569464148e-26,
 -6.282722181168415e-27,  1.476904213190624e-27, -2.359208977202132e-28,  2.849184017316018e-29, -2.764326736907786e-30,  2.240687114193457e-31, -1.559429171975371e-32,
  9.508071166538667e-34, -5.157939785222711e-35,  2.520174522832373e-36, -1.118411577726337e-37,  4.824560769209542e-27, -2.126944318941963e-27,  5.036048891269396e-28,
 -8.103555054773665e-29,  9.857636760494422e-30, -9.632367866788531e-31,  7.862406802434186e-32, -5.509425128392428e-33,  3.381692127908205e-34, -1.846518845335604e-35,
  9.079867312446915e-37, -4.054624385423912e-38,  4.829628565927408e-02, -9.557412639588641e-05,  1.944051109341729e-07, -4.051014163247832e-10,  8.608610308573659e-13,
 -1.857698402397991e-15,  4.051968774284007e-18, -8.908840127517230e-21,  1.966459051173616e-23, -4.357291455907387e-26,  9.646334867133532e-29, -2.142254736546158e-31,
  4.513614371327622e-02, -1.040969590842919e-04,  2.817477934644589e-07, -8.096291429119387e-10,  2.345238261794206e-12, -6.724417745725466e-15,  1.899919421994390e-17,
 -5.291532172532120e-20,  1.454588151467038e-22, -3.953314558299838e-25,  1.063413674885419e-27, -2.835202221584301e-30,  3.942337374309281e-02, -1.167709269198420e-04,
  4.336786882275066e-07, -1.607296576982726e-09,  5.730495739512926e-12, -1.972371587025436e-14,  6.598136962797386e-17, -2.156318598209204e-19,  6.908917568088216e-22,
 -2.175965715855938e-24,  6.749876865038283e-27, -2.065561350570156e-29,  3.218234946371935e-02, -1.270504617399996e-04,  6.099834010544251e-07, -2.732804039297754e-09,
  1.149290748442741e-11, -4.612951754098128e-14,  1.784971768094957e-16, -6.701130631177461e-19,  2.451721075214730e-21, -8.771267465586825e-24,  3.076593029250552e-26,
 -1.060255757263264e-28,  2.455505361855507e-02, -1.293233795972767e-04,  7.635206427052745e-07, -4.023386965867402e-09,  1.963095955549130e-11, -9.056694640735959e-14,
  3.996537963420001e-16, -1.699770850177705e-18,  7.006309157160940e-21, -2.810593923649168e-23,  1.100874073801566e-25, -4.221200255820705e-28,  1.751285616543428e-02,
 -1.212282902739906e-04,  8.540162538019926e-07, -5.223616699306814e-09,  2.925189485501479e-11, -1.534509842138367e-13,  7.641606639293674e-16, -3.645267677119663e-18,
  1.676697687103731e-20, -7.473198551468349e-23,  3.240055402992148e-25, -1.370607196391087e-27,  1.167642573300453e-02, -1.041451264541965e-04,  8.603307471135448e-07,
 -6.054998954864869e-09,  3.857949837134629e-11, -2.281786259896957e-13,  1.272077369093811e-15, -6.754760513911957e-18,  3.442158583045844e-20, -1.692872976607498e-22,
  8.070249907899356e-25, -3.742117677122349e-27,  7.278717818403983e-03, -8.198312409944915e-05,  7.857431220634508e-07, -6.318316008168720e-09,  4.547533982069368e-11,
 -3.012027044177383e-13,  1.867997388569073e-15, -1.097564885661517e-17,  6.161325520101459e-20, -3.325363389791787e-22,  1.733949574779245e-24, -8.768632520262702e-27,
  4.242870328587700e-03, -5.923603273838306e-05,  6.538547638402026e-07, -5.970332863520776e-09,  4.825009138248986e-11, -3.559160120791171e-13,  2.442903497985194e-15,
 -1.580530217816922e-17,  9.728702009004266e-20, -5.736681016871972e-22,  3.257876927898869e-24, -1.789369104629695e-26,  2.313166537743295e-03, -3.937155966940027e-05,
  4.976532500849594e-07, -5.131832379010658e-09,  4.633399017220613e-11, -3.788878023286153e-13,  2.865768540498092e-15, -2.033362953599801e-17,  1.367083915687194e-19,
 -8.774719832778944e-22,  5.407996518112731e-24, -3.214970483249764e-26,  1.179764141389979e-03, -2.412618803219624e-05,  3.474857923255519e-07, -4.027253112881762e-09,
  4.044665197860040e-11, -3.652113592334119e-13,  3.032874051637573e-15, -2.351826926617992e-17,  1.721425068033739e-19, -1.198932508543089e-21,  7.994954181607464e-24,
 -5.129395651427822e-26,  5.630441952156247e-04, -1.365893879712146e-05,  2.231564615155774e-07, -2.894243390041490e-09,  3.221202802774540e-11, -3.200713347511808e-13,
  2.909111584026162e-15, -2.458075632275240e-17,  1.953230562052256e-19, -1.472164698164605e-21,  1.059423922335931e-23, -7.317172260497328e-26,  2.515292319664835e-04,
 -7.158152128382439e-06,  1.320974134674666e-07, -1.909831635332708e-09,  2.347695951002932e-11, -2.559372864348357e-13,  2.538905138209364e-15, -2.331507813987065e-17,
  2.006330274332046e-19, -1.632610539555826e-21,  1.265058039702518e-23, -9.385657568581985e-26,  1.052199184269731e-04, -3.478571055714003e-06,  7.221752975231688e-08,
 -1.159850078728294e-09,  1.570072922824003e-11, -1.872905073755627e-13,  2.022847624471682e-15, -2.014256490297806e-17,  1.873046644259219e-19, -1.642146746971775e-21,
  1.367406614413658e-23, -1.087696209769927e-25,  4.123488600710873e-05, -1.570067197108789e-06,  3.652906986858697e-08, -6.496421168374129e-10,  9.658187096587584e-12,
 -1.257639874407090e-13,  1.475665843388937e-15, -1.590072637061604e-17,  1.594728532210588e-19, -1.503635564416080e-21,  1.343166271311400e-23, -1.143583070177304e-25,
  1.514663760963846e-05, -6.591926114960090e-07,  1.712470122779937e-08, -3.362524571763761e-10,  5.476792005233294e-12, -7.768039439935676e-14,  9.882636145759176e-16,
 -1.150237177655787e-17,  1.242081496665563e-19, -1.257459814361036e-21,  1.203124063405113e-23, -1.094788843057097e-25,  5.218168196568677e-06, -2.578203213871110e-07,
  7.452661203487480e-09, -1.611338652332419e-10,  2.868864682883021e-12, -4.423468598455554e-14,  6.090874894919751e-16, -7.644796189081930e-18,  8.874699734674799e-20,
 -9.632848089683501e-22,  9.858227161599479e-24, -9.574673125982138e-26,  1.687254290840806e-06, -9.407135204228471e-08,  3.015849921601261e-09, -7.161868316746342e-11,
  1.390943651624803e-12, -2.327256213201199e-14,  3.462662093778064e-16, -4.679720103582962e-18,  5.832151845702338e-20, -6.778254587981598e-22,  7.410525834443498e-24,
 -7.672934234318305e-26,  5.124659751071645e-07, -3.206739961731685e-08,  1.136654754032763e-09, -2.957781385116141e-11,  6.254185949539388e-13, -1.133605245426097e-14,
  1.819821997867172e-16, -2.644662924125286e-18,  3.533874861631920e-20, -4.392505743132150e-22,  5.124382274200893e-24, -5.650330798866979e-26,  1.463497084828137e-07,
 -1.022792801362926e-08,  3.996653983908240e-10, -1.137097639329379e-11,  2.613009902356443e-13, -5.122891086804454e-15,  8.861047106959436e-17, -1.382974898251512e-18,
  1.979084878561945e-20, -2.628011565821370e-22,  3.268208984885592e-24, -3.833874639268618e-26,  3.934133419626530e-08, -3.057144170134332e-09,  1.313330188712096e-10,
 -4.076971736780496e-12,  1.016447557984021e-13, -2.152352517049170e-15,  4.006180125822008e-17, -6.707254882380071e-19,  1.026836903093200e-20, -1.455239232019638e-22,
  1.927363092874323e-24, -2.403256732185334e-26,  9.967876644763209e-09, -8.577987027189569e-10,  4.040792323191393e-11, -1.365971612709667e-12,  3.688930107981537e-14,
 -8.425447518296955e-16,  1.685535080096616e-17, -3.023913624074157e-19,  4.947703633400704e-21, -7.476667074210436e-23,  1.053681134027727e-24, -1.395399577278025e-26,
  2.384009414512477e-09, -2.263592810520106e-10,  1.166380847695155e-11, -4.285683922610271e-13,  1.251798392934381e-14, -3.079878651959453e-16,  6.614811372958279e-18,
 -1.270362975281135e-19,  2.219418894145123e-21, -3.573091191161757e-23,  5.353893131987941e-25, -7.524582014431686e-27,  5.391666434009930e-10, -5.629093409917669e-11,
  3.165463648673265e-12, -1.261985003637826e-13,  3.981065578134087e-15, -1.053841571420900e-16,  2.427364644779563e-18, -4.985513842984389e-20,  9.292261307846282e-22,
 -1.592496219687774e-23,  2.535146210433347e-25, -3.778601750380755e-27,  1.155376067494860e-10, -1.322173538563393e-11,  8.096400614244806e-13, -3.496331552103590e-14,
  1.189571203117530e-15, -3.384043665660924e-17,  8.350814849753208e-19, -1.832624152551998e-20,  3.641047535893919e-22, -6.637510080301728e-24,  1.121814011632126e-25,
 -1.772040078670831e-27,  2.351359847762790e-11, -2.940685705106410e-12,  1.956816742968169e-13, -9.138400731491567e-15,  3.348914531516145e-16, -1.022656096887641e-17,
  2.701026228791722e-19, -6.327944232408192e-21,  1.339097659756572e-22, -2.594752256199807e-24,  4.652727176930945e-26, -7.784065377828057e-28,  4.556946462358712e-12,
 -6.210941076817643e-13,  4.482177253560869e-14, -2.260100914395416e-15,  8.909587326336790e-17, -2.917336481991849e-18,  8.239027133262874e-20, -2.058867473296195e-21,
  4.637018868564558e-23, -9.543744589181194e-25,  1.814427877990443e-26, -3.213026771466575e-28,  8.435808049962423e-13, -1.249724059572835e-13,  9.762012757638843e-15,
 -5.306819080448758e-16,  2.247558793310395e-17, -7.882689936264561e-19,  2.378174691330070e-20, -6.333573292908461e-22,  1.517009609162453e-23, -3.314054811724355e-25,
  6.675846926298027e-27, -1.250516453199204e-28,  1.496977587721413e-13, -2.404382441585929e-14,  2.029129789559271e-15, -1.187435688494293e-16,  5.396232529960145e-18,
 -2.024984834498133e-19,  6.520201241525680e-21, -1.849063777444806e-22,  4.706384224625168e-24, -1.090545119126673e-25,  2.326113415805254e-27, -4.606308513801934e-29,
  2.556838162220684e-14, -4.441431324517667e-15,  4.042159390604336e-16, -2.542573791420575e-17,  1.238266517641912e-18, -4.966409541291217e-20,  1.705046197792161e-21,
 -5.144457872618671e-23,  1.390371681693015e-24, -3.414744995993476e-26,  7.707144357964258e-28, -1.612419087400447e-29,  4.222878238297364e-15, -7.914280765992333e-16,
  7.753474383519631e-17, -5.234422439531808e-18,  2.728463966032091e-19, -1.168323492095556e-20,  4.272514947731856e-22, -1.370293003201619e-23,  3.929226265547564e-25,
 -1.022064206799224e-26,  2.439243952044741e-28, -5.387802097677587e-30,  6.780084349433304e-16, -1.367670173628617e-16,  1.439688702453512e-17, -1.041586910488738e-18,
  5.803470746280369e-20, -2.650029374845992e-21,  1.031219843459937e-22, -3.512378179540443e-24,  1.067636151622848e-25, -2.938937844269616e-27,  7.411102295277105e-29,
 -1.727032675041979e-30,  1.064646595121001e-16, -2.305957365616718e-17,  2.603372210673322e-18, -2.015304565081631e-19,  1.198633180970019e-20, -5.829653664632475e-22,
  2.411289327157129e-23, -8.713351973031348e-25,  2.805004175934869e-26, -8.164331465185933e-28,  2.173571274516444e-29, -5.339671984919923e-31,  1.646246678421636e-17,
 -3.819264615201261e-18,  4.615667867761003e-19, -3.816895162250013e-20,  2.419839949206325e-21, -1.251921257703679e-22,  5.497674904229221e-24, -2.105376202003122e-25,
  7.170756730931257e-27, -2.204749097178101e-28,  6.191305148249774e-30, -1.602032203083386e-31,  2.526181480280421e-18, -6.261792887503654e-19,  8.084628508521174e-20,
 -7.129521316318283e-21,  4.810623518997134e-22, -2.643749813964347e-23,  1.231007485480084e-24, -4.990083813585278e-26,  1.796155495791122e-27, -5.827544480838448e-29,
  1.724412515560901e-30, -4.695245508435929e-32,  3.880537813783702e-19, -1.025047237594403e-19,  1.410913890374968e-20, -1.324421221605094e-21,  9.495326385122043e-23,
 -5.534710575736000e-24,  2.728715823569486e-25, -1.169298671041278e-26,  4.442404507778889e-28, -1.519113102260591e-29,  4.731339246394725e-31, -1.354107030207093e-32,
  6.025535140224749e-20, -1.691530042804731e-20,  2.476615382219333e-21, -2.469699431737943e-22,  1.877932941508217e-23, -1.159039933596622e-24,  6.040861495794860e-26,
 -2.732365697484415e-27,  1.094141457935806e-28, -3.938121313586978e-30,  1.289313835369203e-31, -3.873782901279189e-33,  9.559816256709109e-21, -2.843897569607164e-21,
  4.418408243104755e-22, -4.670520567944488e-23,  3.759065478742461e-24, -2.451966657666256e-25,  1.348595152511082e-26, -6.427806841141049e-28,  2.708577369364896e-29,
 -1.024544869074931e-30,  3.520721207912263e-32, -1.108898153739473e-33,  1.568124467929287e-21, -4.928287499809659e-22,  8.103650922378202e-23, -9.058413398941977e-24,
  7.699694055300630e-25, -5.296734956838260e-26,  3.068116798645441e-27, -1.538026904205010e-28,  6.807534794732485e-30, -2.701390558599640e-31,  9.727005857359539e-33,
 -3.206302111987496e-34,  2.693649236655353e-22, -8.914375172893233e-23,  1.546899372190259e-23, -1.823692852661854e-24,  1.633028099905274e-25, -1.181944905906083e-26,
  7.194035817212824e-28, -3.784694018160953e-29,  1.755880175835818e-30, -7.294947729357785e-32,  2.746978260756568e-33, -9.458443861370148e-35,  4.911852608775193e-23,
 -1.705755423083416e-23,  3.113919412890756e-24, -3.860414246221187e-25,  3.631451154402338e-26, -2.757975041600832e-27,  1.759388930840918e-28, -9.689732586387296e-30,
  4.700850617591710e-31, -2.039994856316843e-32,  8.015468140400970e-34, -2.876633106585139e-35,  9.643912851496167e-24, -3.501313445626092e-24,  6.701005550406976e-25,
 -8.707222097128259e-26,  8.577653429104017e-27, -6.815170253423792e-28,  4.543422167119832e-29, -2.612196629810018e-30,  1.321571362200702e-31, -5.974798267366902e-33,
  2.443300282231764e-34, -9.116745778971100e-36,  2.068134790120664e-24, -7.818819961019297e-25,  1.562867639289032e-25, -2.120780026448523e-26,  2.180250231380843e-27,
 -1.806110955102356e-28,  1.254195364660026e-29, -7.503849314813248e-31,  3.946868520788378e-32, -1.853388462946825e-33,  7.865201672670400e-35, -3.042628956251996e-36,
  4.911178364724170e-25, -1.925324674833931e-25,  4.002739071590599e-26, -5.649626885326083e-27,  6.037570191200629e-28, -5.195072752937368e-29,  3.744007107011930e-30,
 -2.322773964844714e-31,  1.265776646759744e-32, -6.153041000696106e-34,  2.700837561116501e-35, -1.079755994404978e-36,  1.307075510434734e-25, -5.289827193566290e-26,
  1.138703185816101e-26, -1.664357609635391e-27,  1.841006722423355e-28, -1.638556223623233e-29,  1.220576220669986e-30, -7.821099883018656e-32,  4.398713023760348e-33,
 -2.205190286600189e-34,  9.975379008700627e-36, -4.106714902845726e-37,  3.931790858848460e-26, -1.635015320950828e-26,  3.626562177660084e-27, -5.462851343167197e-28,
  6.225209433065674e-29, -5.704865766828802e-30,  4.372866416928957e-31, -2.881437316122128e-32,  1.665440750298867e-33, -8.575063032892918e-35,  3.981429347177742e-36,
 -1.681243400387514e-37,  1.338419783562626e-26, -5.691062312586594e-27,  1.293936357421357e-27, -1.998378358230108e-28,  2.334158727127164e-29, -2.191531344830128e-30,
  1.720189795184777e-31, -1.160113206462382e-32,  6.859192778517791e-34, -3.610832682771998e-35,  1.713217928481768e-36, -7.388644356829389e-38,  5.082412986803021e-27,
 -2.198583713091985e-27,  5.095888120671399e-28, -8.024750655745236e-29,  9.555278804741629e-30, -9.142698308944273e-31,  7.310543605531039e-32, -5.020479662735174e-33,
  3.021429463233116e-34, -1.618324444873553e-35,  7.809376225072209e-37, -3.423922001115500e-38,  2.034810868987221e-27, -8.908623305625055e-28,  2.092894814781091e-28,
 -3.341108183413908e-29,  4.032518431869774e-30, -3.910043568136565e-31,  3.167489273267544e-32, -2.203164482592792e-33,  1.342538343703819e-34, -7.278957508827953e-36,
  3.554575305329314e-37, -1.576627310596749e-38,  6.736700759475273e-28, -2.969245807895213e-28,  7.028571271594468e-29, -1.130674522896855e-29,  1.375055168141846e-30,
 -1.343281134277245e-31,  1.096168975156748e-32, -7.679238666541563e-34,  4.712351013948066e-35, -2.572472925222437e-36,  1.264654458629438e-37, -5.645993949696640e-39,
  4.791706917464839e-02, -9.403809901198546e-05,  1.896253274031112e-07, -3.916196713593300e-10,  8.246596915026296e-13, -1.763374838172752e-15,  3.811100375137214e-18,
 -8.303944577909614e-21,  1.816320698434960e-23, -3.989640738333892e-26,  8.751815941216859e-29, -1.927814190084871e-31,  4.472420319711514e-02, -1.018812110932457e-04,
  2.722530274055169e-07, -7.731569570697554e-10,  2.215192365123554e-12, -6.285703516192802e-15,  1.758064837450198e-17, -4.848037882386876e-20,  1.319634139266542e-22,
 -3.551875497237247e-25,  9.462307941506397e-28, -2.498827079207596e-30,  3.896310890156121e-02, -1.133771183859421e-04,  4.149285124447346e-07, -1.518680408761430e-09,
  5.351380508640964e-12, -1.821018760085678e-14,  6.024178220392251e-17, -1.947262971093965e-19,  6.172056527461003e-22, -1.923299088720531e-24,  5.903667660621035e-27,
 -1.787922488548336e-29,  3.168370398076922e-02, -1.222987116902904e-04,  5.782633631368433e-07, -2.556071705667052e-09,  1.061168124947534e-11, -4.206216135960972e-14,
  1.607865539457380e-16, -5.964815556386749e-19,  2.157027281942584e-21, -7.629067697377851e-24,  2.645943911968902e-26, -9.017578523389426e-29,  2.404967801400145e-02,
 -1.234031317634161e-04,  7.170664420424632e-07, -3.723276913552117e-09,  1.791180953259386e-11, -8.152194889324904e-14,  3.550527849007787e-16, -1.490943133597138e-18,
  6.069478594297294e-21, -2.405252368769432e-23,  9.308828223041086e-26, -3.527530007427785e-28,  1.704122120269206e-02, -1.146391642692354e-04,  7.940428932188462e-07,
 -4.779175716731274e-09,  2.635830937191669e-11, -1.362777081220675e-13,  6.692174979835752e-16, -3.149382052956608e-18,  1.429607458017290e-20, -6.290186995770387e-23,
  2.692872338135047e-25, -1.125071700277960e-27,  1.127316470967528e-02, -9.754296316844276e-05,  7.912289963932451e-07, -5.472638908172785e-09,  3.430652478424552e-11,
 -1.997993163554517e-13,  1.097491383546716e-15, -5.744857320205912e-18,  2.887069832980543e-20, -1.400735077155958e-22,  6.589486498492823e-25, -3.015970332533725e-27,
  6.962893898184427e-03, -7.598853150429096e-05,  7.140977830748681e-07, -5.636567752120509e-09,  3.987581850766926e-11, -2.598463925168915e-13,  1.586573510560369e-15,
 -9.182899239494722e-18,  5.080268575814563e-20, -2.703218194305354e-22,  1.390117664010948e-24, -6.934995414666352e-27,  4.015951968526847e-03, -5.427916759845366e-05,
  5.866177960994035e-07, -5.252236790391594e-09,  4.168396183438348e-11, -3.022633397864249e-13,  2.041005704834018e-15, -1.299886253671687e-17,  7.880251677280360e-20,
 -4.578389915353232e-22,  2.562787345207314e-24, -1.387852416975925e-26,  2.163269794220525e-03, -3.562461133443743e-05,  4.402808553541927e-07, -4.447558664576046e-09,
  3.940033807306200e-11, -3.164748806486236e-13,  2.353205760997486e-15, -1.642525316854734e-17,  1.086946966617380e-19, -6.870107395952773e-22,  4.171164671586897e-24,
 -2.443662493789824e-26,  1.088527921396258e-03, -2.152913884822332e-05,  3.028128190529824e-07, -3.434798815873623e-09,  3.382003059255357e-11, -2.997398323330277e-13,
  2.445409466662338e-15, -1.864273281620908e-17,  1.342317941720924e-19, -9.201148179573120e-22,  6.041305348800326e-24, -3.817803728258548e-26,  5.117707385980083e-04,
 -1.200431209080149e-05,  1.913183264136721e-07, -2.426490775136638e-09,  2.645649151815849e-11, -2.578516973409994e-13,  2.300936338794106e-15, -1.910250623277750e-17,
  1.492356664078786e-19, -1.106448924844890e-21,  7.836122993928084e-24, -5.328538849903918e-26,  2.248735629302392e-04, -6.187027572491066e-06,  1.112744511800828e-07,
 -1.572049086593195e-09,  1.891820349564564e-11, -2.021629458882817e-13,  1.967782999242724e-15, -1.774508724418575e-17,  1.500524145416471e-19, -1.200516401776980e-21,
  9.150689807609184e-24, -6.681193001911275e-26,  9.237864030724143e-05, -2.952501471980822e-06,  5.969103551674433e-08, -9.361473351348883e-10,  1.239800075852941e-11,
 -1.448838422230777e-13,  1.534582659821636e-15, -1.499783144535652e-17,  1.369782948431537e-19, -1.180219757148144e-21,  9.663193614583433e-24, -7.561382445211580e-26,
  3.549318112814144e-05, -1.306569803812990e-06,  2.958338944568696e-08, -5.134506992624980e-10,  7.463785040976830e-12, -9.516053702601805e-14,  1.094437588775729e-15,
 -1.156910285401967e-17,  1.139107324599041e-19, -1.055079894248815e-21,  9.263437753196050e-24, -7.755645793479485e-26,  1.276026453404734e-05, -5.369556464187627e-07,
  1.356806828508957e-08, -2.598658793676330e-10,  4.136435092674229e-12, -5.741645459720874e-14,  7.156484205289129e-16, -8.167800545700595e-18,  8.655355981277660e-20,
 -8.604506191138808e-22,  8.088787952532839e-24, -7.235385576646880e-26,  4.294902400196980e-06, -2.052155418532322e-07,  5.767657920544875e-09, -1.215827200886449e-10,
  2.114545383618320e-12, -3.189384138741414e-14,  4.300768660449842e-16, -5.291185115649613e-18,  6.025552300208895e-20, -6.420114451752153e-22,  6.453336855058866e-24,
 -6.159309905551787e-26,  1.354270388544267e-06, -7.303656023310075e-08,  2.275945864378494e-09, -5.267669021050653e-11,  9.989838821055948e-13, -1.634432272263388e-14,
  2.380662468239265e-16, -3.152664294732496e-18,  3.853007029490864e-20, -4.394385916475272e-22,  4.717355030759926e-24, -4.798577781619164e-26,  4.003541822448490e-07,
 -2.423958810885970e-08,  8.349844304357223e-10, -2.117063226055050e-11,  4.369783743488468e-13, -7.742610132034588e-15,  1.216423325187851e-16, -1.731675116449805e-18,
  2.268486847763232e-20, -2.766233067029804e-22,  3.167928218000551e-24, -3.430865079418867e-26,  1.110593936527803e-07, -7.512434409901120e-09,  2.852586571045072e-10,
 -7.906257179748149e-12,  1.773088900297675e-13, -3.397270914347384e-15,  5.749360035470561e-17, -8.787812529843642e-19,  1.232581687491301e-20, -1.605352480650656e-22,
  1.959367322704910e-24, -2.257099764737652e-26,  2.893934611819532e-08, -2.177488649708790e-09,  9.089995869900585e-11, -2.748565894292354e-12,  6.686447046022462e-14,
 -1.383458482813886e-15,  2.518932611675762e-17, -4.129309051311236e-19,  6.194919142950078e-21, -8.609551095321653e-23,  1.118913484031147e-24, -1.369834961852428e-26,
  7.092035684619556e-09, -5.912190213416930e-10,  2.706559913051622e-11, -8.911566803604814e-13,  2.348074627103164e-14, -5.239523716829771e-16,  1.025202855967261e-17,
 -1.800637155602739e-19,  2.886695930666771e-21, -4.277186456883534e-23,  5.914114089114086e-25, -7.688844118467363e-27,  1.636875639396933e-09, -1.506327719078806e-10,
  7.544395795444489e-12, -2.700118808732193e-13,  7.694586603083018e-15, -1.849465568723986e-16,  3.884812897982034e-18, -7.303459491855299e-20,  1.250094735496232e-21,
 -1.973164688113413e-23,  2.900571365461423e-25, -4.001702874513722e-27,  3.564000773034620e-10, -3.608365483923270e-11,  1.972798746065624e-12, -7.661795773160882e-14,
  2.358227078802884e-15, -6.098570251548791e-17,  1.373797408551154e-18, -2.762074412092149e-20,  5.043554259911187e-22, -8.474134853704812e-24,  1.323429895160418e-25,
 -1.936267378847859e-27,  7.334463317887676e-11, -8.144432262796967e-12,  4.850465166644445e-13, -2.040902950508362e-14,  6.775872701197184e-16, -1.883272546838171e-17,
  4.545329585476158e-19, -9.764835610019199e-21,  1.900731377930706e-22, -3.397128931673959e-24,  5.632724070821621e-26, -8.734087479729592e-28,  1.429790416783919e-11,
 -1.736308323967600e-12,  1.124160164278133e-13, -5.116695080474215e-15,  1.830112580757537e-16, -5.461025786675542e-18,  1.410872360534454e-19, -3.236106440055153e-21,
  6.709896046957326e-23, -1.274819763051118e-24,  2.242776564968759e-26, -3.683538949073743e-28,  2.647090901992948e-12, -3.505933689426834e-13,  2.462924908699796e-14,
 -1.210849942941896e-15,  4.660140025221585e-17, -1.491423033536224e-18,  4.120895256297705e-20, -1.008374708063218e-21,  2.225590866598489e-23, -4.491994535719671e-25,
  8.380055521504008e-27, -1.457005919353632e-28,  4.668240486646212e-13, -6.725873266197957e-14,  5.117308508056886e-15, -2.713517922724099e-16,  1.122403369001506e-17,
 -3.848772364437423e-19,  1.136353051260137e-20, -2.964182125479108e-22,  6.959169975752707e-24, -1.491202536912106e-25,  2.948216961762307e-27, -5.423363559910739e-29,
  7.869061172079120e-14, -1.230290065577014e-14,  1.011974894057384e-15, -5.779624553426212e-17,  2.566359430793894e-18, -9.419580730796404e-20,  2.969257354685220e-21,
 -8.250256529095786e-23,  2.058961787341024e-24, -4.680984669778752e-26,  9.802113139090912e-28, -1.906703795002027e-29,  1.272933903523192e-14, -2.154483949028743e-15,
  1.912560542007727e-16, -1.174835035493192e-17,  5.593593282960130e-19, -2.195395771380157e-20,  7.382018307178076e-22, -2.183154955981971e-23,  5.787451461449606e-25,
 -1.395098459758836e-26,  3.092330474639454e-28, -6.357073646975979e-30,  1.985143430114911e-15, -3.628841913826055e-16,  3.470547620779441e-17, -2.289725380069796e-18,
  1.167567187476697e-19, -4.895191185102783e-21,  1.754236836599181e-22, -5.517444257379967e-24,  1.552546663143328e-25, -3.965497420546070e-27,  9.298315219565753e-29,
 -2.018947989087069e-30,  3.000318383603853e-16, -5.909865426721914e-17,  6.078723913626000e-18, -4.301343296445336e-19,  2.346181263720551e-20, -1.049679503108079e-21,
  4.005197571749465e-23, -1.338584645252945e-24,  3.995025420300898e-26, -1.080428751056201e-27,  2.678159974353984e-29, -6.138043023116024e-31,  4.421320351305867e-17,
 -9.362420041093780e-18,  1.033862766325708e-18, -7.834748390516583e-20,  4.565553712705780e-21, -2.177271924472970e-22,  8.836796048194512e-24, -3.135408117187480e-25,
  9.916787511863934e-27, -2.837477613579528e-28,  7.429991173794355e-30, -1.796184489279572e-31,  6.396433330499855e-18, -1.452696976003035e-18,  1.719102644655505e-19,
 -1.393060249607648e-20,  8.661017223494046e-22, -4.397384751783419e-23,  1.896366841578231e-24, -7.136219768495836e-26,  2.389728859470795e-27, -7.228038309943214e-29,
  1.997735933485923e-30, -5.090162386589891e-32,  9.156483262528456e-19, -2.224907644874166e-19,  2.816225760834091e-20, -2.436333234724582e-21,  1.613773303407035e-22,
 -8.711872371219193e-24,  3.987216440860375e-25, -1.589590199827412e-26,  5.630190283654058e-28, -1.798394292148322e-29,  5.241617076620957e-31, -1.406392830872949e-32,
  1.308511283158877e-19, -3.393192228356819e-20,  4.584801326962119e-21, -4.227006467914186e-22,  2.978282552755135e-23, -1.707095851777287e-24,  8.280817513398062e-26,
 -3.493194522002292e-27,  1.307116390658236e-28, -4.404417102623730e-30,  1.352308899206388e-31, -3.817034776192050e-33,  1.885469113083656e-20, -5.204063890813863e-21,
  7.489894775573234e-22, -7.345237758957760e-23,  5.495616415154127e-24, -3.339180713410118e-25,  1.714222654087912e-26, -7.640894813938790e-28,  3.016577500981950e-29,
 -1.070910475930583e-30,  3.459575969694472e-32, -1.026064946742269e-33,  2.770100581951904e-21, -8.114933770011061e-22,  1.241150747257447e-22, -1.292004151210004e-23,
  1.024512228919245e-24, -6.587100895585888e-26,  3.572745831976870e-27, -1.680016957418849e-28,  6.987189602734695e-30, -2.609597538715132e-31,  8.857629180201774e-33,
 -2.756654878994907e-34,  4.201071098232156e-22, -1.302286211983663e-22,  2.111263249146277e-23, -2.327461795463931e-24,  1.951828145234918e-25, -1.325231496692401e-26,
  7.579591551813922e-28, -3.753158510040567e-29,  1.641508397672830e-30, -6.438941775085129e-32,  2.292590326189337e-33, -7.475132817232114e-35,  6.665960380577031e-23,
 -2.179523888970555e-23,  3.734836161122997e-24, -4.348970962567107e-25,  3.847642224977278e-26, -2.752433746279974e-27,  1.656391134150491e-28, -8.618654101545292e-30,
  3.956069829911904e-31, -1.626625624338182e-32,  6.063829079660124e-34, -2.067613811778959e-35,  1.122777800101504e-23, -3.858647995177804e-24,  6.967349306447001e-25,
 -8.544679892616342e-26,  7.953507261072913e-27, -5.978793718588104e-28,  3.776239018226324e-29, -2.059732179413719e-30,  9.899186957836804e-32, -4.256908516116234e-33,
  1.657866520178840e-34, -5.898971507524416e-36,  2.038325740203715e-24, -7.335563638131110e-25,  1.390887995614117e-25, -1.790685302510275e-26,  1.748182971242614e-27,
 -1.376826285545417e-28,  9.100758249190978e-30, -5.189183726113611e-31,  2.604271243839836e-32, -1.168211345810849e-33,  4.741044430454582e-35, -1.756043948598240e-36,
  4.050998623134155e-25, -1.520538293391560e-25,  3.015973967426844e-26, -4.061353427338156e-27,  4.144016843924288e-28, -3.407875206236481e-29,  2.349719442224892e-30,
 -1.396154811546431e-31,  7.294339070060282e-33, -3.403032851092695e-34,  1.435012612465476e-35, -5.517265344559579e-37,  8.948478567459934e-26, -3.488150695413312e-26,
  7.207316444562002e-27, -1.011041999343891e-27,  1.073981358235928e-28, -9.187049799351682e-30,  6.583235161680913e-31, -4.061594341830713e-32,  2.201410447799115e-33,
 -1.064519873393843e-34,  4.648855880220257e-36, -1.849368724429530e-37,  2.227169154656207e-26, -8.974820406130872e-27,  1.922890503466955e-27, -2.797373736334300e-28,
  3.080035454673594e-29, -2.729014404894697e-30,  2.023972325692685e-31, -1.291380743535816e-32,  7.232857550319358e-34, -3.611419960225479e-35,  1.627261667426176e-36,
 -6.673746211882800e-38,  6.309167767974827e-27, -2.615611168117333e-27,  5.782041109907982e-28, -8.680326756691255e-29,  9.858833705592692e-30, -9.005437776372606e-31,
  6.880963369597925e-32, -4.520144633827046e-33,  2.604765766851939e-34, -1.337237807621245e-35,  6.191227599227279e-37, -2.607183134711004e-38,  2.040223871071906e-27,
 -8.657766246505897e-28,  1.964067733051420e-28, -3.026544300154261e-29,  3.527281237902545e-30, -3.304597894358760e-31,  2.588400828873550e-32, -1.742061009483810e-33,
  1.027939024665867e-34, -5.400776508609068e-36,  2.557634916629467e-37, -1.101011877981129e-38,  7.435764831289323e-28, -3.212842431806144e-28,  7.436989434748923e-29,
 -1.169593777504777e-29,  1.390851239230423e-30, -1.329098046032493e-31,  1.061427916014059e-32, -7.280439250394452e-34,  4.376326585223677e-35, -2.341320853906074e-36,
  1.128554844102784e-37, -4.942596013332274e-39,  2.890771186460729e-28, -1.264882451625647e-28,  2.969652532040615e-29, -4.737662604997938e-30,  5.714368640590582e-31,
 -5.537283622772773e-32,  4.482902976773508e-33, -3.116205770233213e-34,  1.897784879093196e-35, -1.028339587688456e-36,  5.018894716143526e-38, -2.224891778281313e-39,
  9.412066008429696e-29, -4.147443814149035e-29,  9.814860200985376e-30, -1.578465738605899e-30,  1.919104448263467e-31, -1.874250703756510e-32,  1.529051981537491e-33,
 -1.070899547087339e-34,  6.569857274576268e-36, -3.585574635366545e-37,  1.762265725825950e-38, -7.865633160141078e-40,  4.754392133391959e-02, -9.253967247797957e-05,
  1.850039107346840e-07, -3.787023644831951e-10,  7.902883593719683e-13, -1.674634179753905e-15,  3.586515846952123e-18, -7.745042886966681e-21,  1.678795811208034e-23,
 -3.655954238053003e-26,  7.946429843913144e-29, -1.736640401199624e-31,  4.432097647947409e-02, -9.973970528320071e-05,  2.631837268433395e-07, -7.386971197218710e-10,
  2.093590113840120e-12, -5.879591741800944e-15,  1.628044596343219e-17, -4.445504235883738e-20,  1.198322696464249e-22, -3.194479210285716e-25,  8.428900074203093e-28,
 -2.205002047726770e-30,  3.851612588357426e-02, -1.101291585486665e-04,  3.972063108355810e-07, -1.435895209800359e-09,  5.001204413778962e-12, -1.682764343259551e-14,
  5.505586136530604e-17, -1.760394548915840e-19,  5.520346044826413e-22, -1.702158897960489e-24,  5.170672244135954e-27, -1.549882412285055e-29,  3.120357107864385e-02,
 -1.177924724497027e-04,  5.485821270198734e-07, -2.392810627183256e-09,  9.807713234690491e-12, -3.839614871479814e-14,  1.450115426978127e-16, -5.316542712765544e-19,
  1.900513000571770e-21, -6.645950360637675e-24,  2.279357717992406e-26, -7.683058930580611e-29,  2.356726229944498e-02, -1.178405664809883e-04,  6.740543101979132e-07,
 -3.449282292944605e-09,  1.636331188654477e-11, -7.348046683572582e-14,  3.159002843489604e-16, -1.309884716545556e-18,  5.267033075072972e-21, -2.062174140608227e-23,
  7.886834043808282e-26, -2.953946520250605e-28,  1.659501587000720e-02, -1.085092537154103e-04,  7.391359860652372e-07, -4.378403618619500e-09,  2.378648315972781e-11,
 -1.212250063046969e-13,  5.871132962606484e-16, -2.726153322188508e-18,  1.221413099608031e-20, -5.305875569094037e-23,  2.243193020381428e-25, -9.257303582044965e-28,
  1.089524938508468e-02, -9.146678115126030e-05,  7.287233790887057e-07, -4.954324144242389e-09,  3.056142745844421e-11, -1.752898825180161e-13,  9.488461928418828e-16,
 -4.896838843304103e-18,  2.427216866358306e-20, -1.161897758170572e-22,  5.394484515592411e-25, -2.437374686407332e-27,  6.669951765547672e-03, -7.053584021521181e-05,
  6.501220205402060e-07, -5.038145414627844e-09,  3.503975407865428e-11, -2.246790024678326e-13,  1.350822143362705e-15, -7.702756514148203e-18,  4.200256768097250e-20,
 -2.203724308424065e-22,  1.117779850006281e-24, -5.501786033352832e-27,  3.807837434836684e-03, -4.982743730106835e-05,  5.274014161572675e-07, -4.631112874884810e-09,
  3.610046550633510e-11, -2.573764214651232e-13,  1.709997685723839e-15, -1.072224803132752e-17,  6.402724845114268e-20, -3.665755452482807e-22,  2.022767482982111e-24,
 -1.080182173857235e-26,  2.027492347823972e-03, -3.230559226959408e-05,  3.904932395063152e-07, -3.864870234928794e-09,  3.360029571051490e-11, -2.651455388691987e-13,
  1.938493746030081e-15, -1.331253114155118e-17,  8.672326067268302e-20, -5.398435137054370e-22,  3.229312515138992e-24, -1.864630969718189e-26,  1.007007737675060e-03,
 -1.926274332465304e-05,  2.646539925830675e-07, -2.938617008073926e-09,  2.837223496471900e-11, -2.468575983090070e-13,  1.978883537987119e-15, -1.483376135659411e-17,
  1.050807557250152e-19, -7.090064567647664e-22,  4.584209491633179e-24, -2.853879899791541e-26,  4.666398362162804e-04, -1.058341417705770e-05,  1.645793228222804e-07,
 -2.041615359596612e-09,  2.181099806903098e-11, -2.085427815541799e-13,  1.827341761910281e-15, -1.490809128333485e-17,  1.145225454635974e-19, -8.353444701979200e-22,
  5.823037794735040e-24, -3.898929236403001e-26,  2.017932476069211e-04, -5.367435985236999e-06,  9.410045489371920e-08, -1.299297572099691e-09,  1.530961011926228e-11,
 -1.603934573937271e-13,  1.532119043536346e-15, -1.356964041637827e-17,  1.127701143785194e-19, -8.872030849255719e-22,  6.653088496443428e-24, -4.781056717780219e-26,
  8.145702982906873e-05, -2.516743900517937e-06,  4.955796459081722e-08, -7.590939878699599e-10,  9.837011144950959e-12, -1.126345606536533e-13,  1.170118708555843e-15,
 -1.122578970668544e-17,  1.007138667050551e-19, -8.529142051417461e-22,  6.867366109222409e-24, -5.286815720453153e-26,  3.070390032982075e-05, -1.092654062414700e-06,
  2.408003733962034e-08, -4.079318308079642e-10,  5.798989235465430e-12, -7.240204771086669e-14,  8.162982599307280e-16, -8.466354947615157e-18,  8.184901721650315e-20,
 -7.448240922128879e-22,  6.428250428975208e-24, -5.292940179691273e-26,  1.081126175510451e-05, -4.398411264234046e-07,  1.081170387669253e-08, -2.020088175066127e-10,
  3.142840765978627e-12, -4.269883033740647e-14,  5.214807954878087e-16, -5.837000879941750e-18,  6.070716808171814e-20, -5.926923650644168e-22,  5.474916405560302e-24,
 -4.814615475161486e-26,  3.557834845706504e-06, -1.643801627977441e-07,  4.492299584408697e-09, -9.233889743299784e-11,  1.568928115475851e-12, -2.315164853883959e-14,
  3.057702601218618e-16, -3.687848661744382e-18,  4.120234905915437e-20, -4.309828366383489e-22,  4.255441044757047e-24, -3.991708346975862e-26,  1.094889079130983e-06,
 -5.710871674603132e-08,  1.729870016177860e-09, -3.902528328092990e-11,  7.227455371946935e-13, -1.156411417703793e-14,  1.649123992690291e-16, -2.140167966113044e-18,
  2.565231510039409e-20, -2.871286763738454e-22,  3.026823424001075e-24, -3.025116340272021e-26,  3.153001012054965e-07, -1.846785934636646e-08,  6.182487291840698e-10,
 -1.527429385273132e-11,  3.077807440731727e-13, -5.331403690544521e-15,  8.197978720280106e-17, -1.143316505065524e-18,  1.468461695147535e-20, -1.756883408020435e-22,
  1.975251364656178e-24, -2.101265588500505e-26,  8.503476400833480e-08, -5.566352745943437e-09,  2.053848108057765e-10, -5.545534195546245e-12,  1.213783693928017e-13,
 -2.272968611015683e-15,  3.763841378945658e-17, -5.634490831412473e-19,  7.746483497318234e-21, -9.896485413693429e-23,  1.185546501009152e-24, -1.341184953010130e-26,
  2.149805018924063e-08, -1.565940458691024e-09,  6.351962892763994e-11, -1.870802789047889e-12,  4.440886695027732e-14, -8.978405574809921e-16,  1.599199919812020e-17,
 -2.567033648631339e-19,  3.774101942279189e-21, -5.143903559312305e-23,  6.560211766064389e-25, -7.885811237491016e-27,  5.100547755419977e-09, -4.118003449318822e-10,
  1.831909811377730e-11, -5.874716228460217e-13,  1.510225594322822e-14, -3.292413544980401e-16,  6.301080935044401e-18, -1.083498342103175e-19,  1.701989975953025e-21,
 -2.472754515896730e-23,  3.354727176714560e-25, -4.281783783372015e-27,  1.137155681249834e-09, -1.013966034809882e-10,  4.935557382808774e-12, -1.720457937287808e-13,
  4.783210913151617e-15, -1.123144042912858e-16,  2.307266172656953e-18, -4.246254486587546e-20,  7.120768649857265e-22, -1.101965104966034e-23,  1.589235956837690e-25,
 -2.152307038310913e-27,  2.386038314611938e-10, -2.341973226698081e-11,  1.244678712803150e-12, -4.708602468610330e-14,  1.413930633599264e-15, -3.572048651295532e-17,
  7.869252467687080e-19, -1.548725516525726e-20,  2.770504429716022e-22, -4.563670435995720e-24,  6.991930617180980e-26, -1.004141138525138e-27,  4.720335730686445e-11,
 -5.084580650204558e-12,  2.944497770120077e-13, -1.207006219108248e-14,  3.909977401506976e-16, -1.061675032210748e-17,  2.505976460822824e-19, -5.269994894498556e-21,
  1.004964893633364e-22, -1.760917695917065e-24,  2.864326091299308e-26, -4.359685931870380e-28,  8.823129015658277e-12, -1.040044901376782e-12,  6.550168898612646e-14,
 -2.905231843280926e-15,  1.014064377109407e-16, -2.956554051130758e-18,  7.470923037483687e-20, -1.677554652201941e-21,  3.407871349082036e-23, -6.348025498731016e-25,
  1.095662495016748e-26, -1.766498976044628e-28,  1.562054906427850e-12, -2.009648143239397e-13,  1.373939117481457e-14, -6.584414832854997e-16,  2.473612698386593e-17,
 -7.736510035612350e-19,  2.091144367308915e-20, -5.010087464956297e-22,  1.083525812689487e-23, -2.144412395854184e-25,  3.925244783805236e-27, -6.700188045538998e-29,
  2.626881980702058e-13, -3.679332474652896e-14,  2.725830153753838e-15, -1.409550969149008e-16,  5.693093103994669e-18, -1.908337798381030e-19,  5.513162315010985e-21,
 -1.408375307816689e-22,  3.240624282878942e-24, -6.810272806306681e-26,  1.321342867723301e-27, -2.386742968008767e-29,  4.210231464406504e-14, -6.404710941389900e-15,
  5.133010468455278e-16, -2.860296313381521e-17,  1.240688189772013e-18, -4.453163454283674e-20,  1.373979572350838e-21, -3.739850362752957e-23,  9.149803962125462e-25,
 -2.040654196170032e-26,  4.194565252438390e-28, -8.013728995783949e-30,  6.456204190362748e-15, -1.064223845702984e-15,  9.211418991722329e-17, -5.524005795560856e-18,
  2.570531367288515e-19, -9.870347612323506e-21,  3.249879745444591e-22, -9.418773511613199e-24,  2.448649101603705e-25, -5.792382249839099e-27,  1.260698874753774e-28,
 -2.546245913067295e-30,  9.514966802772998e-16, -1.695688109683226e-16,  1.582513853473866e-17, -1.019989449297346e-18,  5.086391747084840e-20, -2.087468494930202e-21,
  7.328686847977516e-23, -2.259922330338930e-24,  6.239040030598169e-26, -1.564453539156657e-27,  3.603408694871241e-29, -7.689842849963519e-31,  1.354735865951784e-16,
 -2.604400390508681e-17,  2.616398852308949e-18, -1.810074415420046e-19,  9.662100805786756e-21, -4.234131602200597e-22,  1.583703712414779e-23, -5.192205777011333e-25,
  1.521137820815926e-26, -4.040655613339244e-28,  9.843341189243104e-30, -2.218289693295279e-31,  1.874669339749672e-17, -3.879011252732670e-18,  4.187817777834484e-19,
 -3.105496122440296e-20,  1.772399144174199e-21, -8.285059002477944e-23,  3.298495508082761e-24, -1.148813972185979e-25,  3.568896383287879e-27, -1.003586108787740e-28,
  2.584065463637093e-30, -6.145867691485137e-32,  2.538711948127277e-18, -5.641122856337843e-19,  6.533658793029667e-20, -5.185957952558484e-21,  3.160662029468406e-22,
 -1.574268585158170e-23,  6.664737038633098e-25, -2.463674878584126e-26,  8.109159460645445e-28, -2.412119314891536e-29,  6.559795424912158e-31, -1.645404454881912e-32,
  3.391197439246584e-19, -8.073152716825772e-20,  1.001329045082792e-20, -8.494103292599977e-22,  5.520844616601578e-23, -2.926536934338068e-24,  1.316043163043712e-25,
 -5.158250790428863e-27,  1.797209154732908e-28, -5.649940853430707e-30,  1.621505254208314e-31, -4.286062611612812e-33,  4.508761454208161e-20, -1.147156642443771e-20,
  1.520787733928895e-21, -1.376458641976531e-22,  9.526967340703577e-24, -5.367533123299872e-25,  2.560785041738802e-26, -1.063028927095164e-27,  3.916365190141693e-29,
 -1.299912745033725e-30,  3.933290314675137e-32, -1.094596105901082e-33,  6.027856083377644e-21, -1.634863916197040e-21,  2.311769773675068e-22, -2.228488143315350e-23,
  1.639832202348984e-24, -9.804901706459250e-26,  4.955897205276114e-27, -2.176055074668235e-28,  8.466755767365752e-30, -2.963650341014053e-31,  9.443897476008627e-33,
 -2.764004264442178e-34,  8.197166497305186e-22, -2.363411370868143e-22,  3.556663711506088e-23, -3.644281982049171e-24,  2.845808072117847e-25, -1.802758382035667e-26,
  9.638460609583422e-28, -4.469711322903286e-29,  1.834071415495769e-30, -6.761029350125850e-32,  2.265951581199275e-33, -6.965891125256063e-35,  1.148495527875372e-22,
 -3.509751624393070e-23,  5.607177994136535e-24, -6.093204629821153e-25,  5.039015294018383e-26, -3.375391494300781e-27,  1.905418042419438e-28, -9.316012158742380e-30,
  4.024698678717043e-31, -1.559991151204679e-32,  5.490398218794126e-34, -1.770185545369330e-35,  1.681505770380572e-23, -5.429113754105570e-24,  9.182630174402804e-25,
 -1.055617618989337e-25,  9.223372658054730e-27, -6.518506233085547e-28,  3.876951473985046e-29, -1.994427777571531e-30,  9.054053697154069e-32, -3.683063909792489e-33,
  1.358773075020391e-34, -4.586537919169366e-36,  2.612369573443159e-24, -8.880666614359226e-25,  1.585339901496702e-25, -1.922483988347923e-26,  1.769949275450428e-27,
 -1.316396970195130e-28,  8.228882287776613e-30, -4.443589594263502e-31,  2.114918365816192e-32, -9.009137799788462e-34,  3.476578579115682e-35, -1.226064635453977e-36,
  4.377484947050811e-25, -1.560944212580791e-25,  2.930999989010518e-26, -3.737287297993924e-27,  3.614396224087378e-28, -2.820666284058114e-29,  1.847941510341428e-30,
 -1.044625110305369e-31,  5.198855982106793e-33, -2.313175787903569e-34,  9.313830395309495e-36, -3.423426316680394e-37,  8.046208256627563e-26, -2.997396925052597e-26,
  5.897464054927099e-27, -7.878148394490267e-28,  7.975653631421363e-29, -6.508929179203565e-30,  4.454673629551125e-31, -2.627845126177043e-32,  1.363353683557929e-33,
 -6.317312762648908e-35,  2.646365260952709e-36, -1.010957681997642e-37,  1.649604160660756e-26, -6.391824712058406e-27,  1.312183488774721e-27, -1.828910517745884e-28,
  1.930538786731894e-29, -1.641291267842199e-30,  1.169094439320842e-31, -7.171010113397630e-33,  3.864826027272501e-34, -1.858649194205702e-35,  8.073685487693879e-37,
 -3.195226740896588e-38,  3.830387045253667e-27, -1.536546719977405e-27,  3.275875540637993e-28, -4.742179051847860e-29,  5.196100644659211e-30, -4.582190393009735e-31,
  3.382765116577728e-32, -2.148703811715232e-33,  1.198233324314058e-34, -5.957604445095078e-36,  2.673404442145260e-37, -1.092055362351123e-38,  1.019447256767949e-27,
 -4.212707364043205e-28,  9.279494461686187e-29, -1.388132935831464e-29,  1.571081529155795e-30, -1.430182952193383e-31,  1.089150560600729e-32, -7.131516199123313e-34,
  4.096639091138632e-35, -2.096693681326209e-36,  9.678481848862791e-38, -4.063920205095692e-39,  3.124766289257173e-28, -1.323192644058943e-28,  2.994682991649340e-29,
 -4.603770704935078e-30,  5.352971309533445e-31, -5.003616984322090e-32,  3.910499409484295e-33, -2.626180420538853e-34,  1.546372776392956e-35, -8.107993479174300e-37,
  3.832041359906081e-38, -1.646432155999727e-39,  1.090979742402385e-28, -4.708065810573858e-29,  1.088302414825082e-29, -1.709158130853611e-30,  2.029695747975344e-31,
 -1.936969248935103e-32,  1.544847056474343e-33, -1.058269115861612e-34,  6.353398624382446e-36, -3.394917610096390e-37,  1.634468977508412e-38, -7.150060007121592e-40,
  4.112657723903487e-29, -1.798439213296497e-29,  4.219444631615440e-30, -6.726892937188257e-31,  8.108165555473540e-32, -7.851641325090887e-33,  6.352409712276470e-34,
 -4.412931552509747e-35,  2.685817021512436e-36, -1.454456660470387e-37,  7.094362990592077e-39, -3.143128956315500e-40,  1.315771901567102e-29, -5.796537763650658e-30,
  1.371356425027340e-30, -2.204840623878534e-31,  2.679890089907041e-32, -2.616518570664144e-33,  2.134017445715364e-34, -1.494190563921588e-35,  9.164246212378762e-37,
 -5.000174614694710e-38,  2.456888267990509e-39, -1.096320734290645e-40,  4.717669422535233e-02, -9.107760646258422e-05,  1.805342597354011e-07, -3.663210880413526e-10,
  7.576391824743556e-13, -1.591100623128678e-15,  3.376982079791026e-18, -7.228287693948596e-21,  1.552723459675186e-23, -3.352863359879073e-26,  7.220532948715905e-29,
 -1.566092737108024e-31,  4.392617324931680e-02, -9.766913227481112e-05,  2.545165331577696e-07, -7.061195984276134e-10,  1.979806957165110e-12, -5.503375017506571e-15,
  1.508770609885339e-17, -4.079808966747885e-20,  1.089163594040437e-22, -2.875945879066377e-25,  7.516477344030346e-28, -1.948024756157726e-30,  3.808185730963450e-02,
 -1.070190958242134e-04,  3.804448057587524e-07, -1.358498209979703e-09,  4.677475775616979e-12, -1.556351108533494e-14,  5.036513310159975e-17, -1.593161695684583e-19,
  4.943211432474799e-22, -1.508346753605742e-24,  4.534816692191103e-27, -1.345477188140742e-29,  3.074100034000320e-02, -1.135160598038925e-04,  5.207851974969974e-07,
 -2.241846444650467e-09,  9.073421839821908e-12, -3.508785020971025e-14,  1.309419023359176e-16, -4.744963592252282e-19,  1.676887138066326e-21, -5.798365885765206e-24,
  1.966759611423962e-26, -6.557348739227536e-29,  2.310642889658426e-02, -1.126093558031841e-04,  6.341866046117640e-07, -3.198826379509234e-09,  1.496664339626712e-11,
 -6.632060049079019e-14,  2.814757362911926e-16, -1.152633451498181e-18,  4.578437687481091e-21, -1.771231703254618e-23,  6.694885637927046e-26, -2.478639671944684e-28,
  1.617248116943453e-02, -1.028000386908468e-04,  6.888010474395389e-07, -4.016475473721827e-09,  2.149692829641589e-11, -1.080078133615336e-13,  5.159776800805287e-16,
 -2.364207849298823e-18,  1.045617054281184e-20, -4.485044914000804e-23,  1.872768337702393e-25, -7.634913928185765e-28,  1.054067670006864e-02, -8.586674759640063e-05,
  6.720935793171608e-07, -4.492195477605405e-09,  2.727268458726836e-11, -1.540788646552149e-13,  8.220083371729817e-16, -4.183091240171977e-18,  2.045321503283202e-20,
 -9.661312111976516e-23,  4.427487585019678e-25, -1.975047830106058e-27,  6.397840476957716e-03, -6.556749463888369e-05,  5.928853157022248e-07, -4.511767206352206e-09,
  3.085365641600728e-11, -1.947025492097137e-13,  1.152828341396454e-15, -6.477431733064490e-18,  3.481884949725364e-20, -1.801521961336531e-22,  9.014088629499437e-25,
 -4.377991574459989e-27,  3.616627508159549e-03, -4.582107727863240e-05,  4.751307917293007e-07, -4.092553878536936e-09,  3.134016522154381e-11, -2.197192874597532e-13,
  1.436581213742957e-15, -8.869792193916536e-18,  5.217921349088665e-20, -2.944289307134967e-22,  1.601776042307545e-24, -8.435821235624757e-27,  1.904236531548526e-03,
 -2.935840804974934e-05,  3.471732840284956e-07, -3.367282308889796e-09,  2.873397821636134e-11, -2.227982123242990e-13,  1.601842123833715e-15, -1.082492710439677e-17,
  6.942895065439048e-20, -4.257056247411265e-22,  2.509325777277132e-24, -1.428215797602635e-26,  9.339783138964186e-04, -1.727920688526471e-05,  2.319593857976858e-07,
 -2.521712671588019e-09,  2.387824016518095e-11, -2.039909425559789e-13,  1.607016026566935e-15, -1.184649306258080e-17,  8.257531616470694e-20, -5.485010160433105e-22,
  3.492807686074908e-24, -2.142346335682898e-26,  4.267922620862810e-04, -9.359146719600443e-06,  1.420435041774248e-07, -1.723758197244324e-09,  1.804692078985422e-11,
 -1.693078434330873e-13,  1.457002483580000e-15, -1.168272850757785e-17,  8.825963972358105e-20, -6.334498549446222e-22,  4.346779743960976e-24, -2.866205516126098e-26,
  1.817359373933525e-04, -4.673065846357633e-06,  7.987888248622999e-08, -1.078131087440370e-09,  1.244066218507481e-11, -1.278019953715329e-13,  1.198232238349411e-15,
 -1.042451506063155e-17,  8.515373012603077e-20, -6.588633522766692e-22,  4.861458064567842e-24, -3.438917979648055e-26,  7.212885408082918e-05, -2.154202824637026e-06,
  4.132351658802334e-08, -6.182981675223192e-10,  7.841456634748414e-12, -8.798597839461679e-14,  8.966536009370646e-16, -8.445448109271453e-18,  7.443954999048054e-20,
 -6.197006215422038e-22,  4.907369499931670e-24, -3.717311908011950e-26,  2.668965182475541e-05, -9.181206815171673e-07,  1.969701296135023e-08, -3.257434534010075e-10,
  4.529088745035541e-12, -5.538272687709505e-14,  6.122067569958765e-16, -6.230803884120277e-18,  5.915210481796211e-20, -5.289137358146716e-22,  4.487752466777173e-24,
 -3.634479723556737e-26,  9.210658370683911e-06, -3.622498108725341e-07,  8.663189439613612e-09, -1.579270244545629e-10,  2.401837255951238e-12, -3.194330724262273e-14,
  3.823128522366238e-16, -4.197320554282039e-18,  4.284957540661973e-20, -4.108998691645066e-22,  3.730136135391296e-24, -3.225244677456478e-26,  2.965732367057200e-06,
 -1.324800487923202e-07,  3.520771545514124e-09, -7.057418749783397e-11,  1.171629138954408e-12, -1.691653323544698e-14,  2.188523832517152e-16, -2.587922624422763e-18,
  2.836970066478020e-20, -2.913619004225587e-22,  2.826224371115428e-24, -2.605744922836388e-26,  8.914222148847854e-07, -4.496265851991729e-08,  1.323962558996941e-09,
 -2.911538734483654e-11,  5.266300362938728e-13, -8.241330123828254e-15,  1.150786262337340e-16, -1.463691480169951e-18,  1.720796267577186e-20, -1.890489740936280e-22,
  1.957207372822887e-24, -1.922087822591786e-26,  2.502681141587013e-07, -1.417877885860210e-08,  4.613041171776858e-10, -1.110592377096886e-11,  2.184862543658643e-13,
 -3.700284154034662e-15,  5.569387216190591e-17, -7.609994815753285e-19,  9.583970782265511e-21, -1.125100674098681e-22,  1.241939301077861e-24, -1.297850548007431e-26,
  6.567647514491831e-08, -4.159605745367187e-09,  1.491360200936117e-10, -3.922974010363311e-12,  8.380621653111830e-14, -1.533945519808650e-15,  2.485578680501208e-17,
 -3.644557988023579e-19,  4.911811337689487e-21, -6.155611609500687e-23,  7.238218674986902e-25, -8.042050047989817e-27,  1.612383211452957e-08, -1.136743189435700e-09,
  4.480209133796215e-11, -1.285280387928682e-12,  2.977181097072242e-14, -5.881832589722168e-16,  1.024923478879671e-17, -1.611060465160179e-19,  2.321357107511972e-21,
 -3.102985595095426e-23,  3.883629820041903e-25, -4.584020072933018e-27,  3.707005065244594e-09, -2.897901537524191e-10,  1.252599854898288e-11, -3.912279928698891e-13,
  9.812577207507185e-15, -2.090048831611688e-16,  3.912478541326778e-18, -6.586829575344045e-20,  1.013852565323746e-21, -1.444381658414515e-23,  1.922734351158943e-25,
 -2.409346003746932e-27,  7.990967623865134e-10, -6.902231377466018e-11,  3.264812032542207e-12, -1.108382646826487e-13,  3.006259592121912e-15, -6.895944595042644e-17,
  1.385465603610540e-18, -2.496078926570517e-20,  4.101021737761830e-22, -6.222445009892315e-24,  8.804202123637341e-26, -1.170492517550167e-27,  1.617401748242609e-10,
 -1.538613593141932e-11,  7.947688521515216e-13, -2.928344705197329e-14,  8.578551561254000e-16, -2.117063700489808e-17,  4.561011996039042e-19, -8.786664994151581e-21,
  1.539882869794374e-22, -2.486781994246740e-24,  3.737633905146393e-26, -5.268987810638666e-28,  3.079017305698203e-11, -3.216233346551168e-12,  1.810734451213863e-13,
 -7.230310819855864e-15,  2.285093944484078e-16, -6.061239366768338e-18,  1.399127614673898e-19, -2.880090517080220e-21,  5.380428968302074e-23, -9.242498894002710e-25,
  1.474819340272282e-26, -2.203410076989894e-28,  5.523904286613537e-12, -6.318321323880569e-13,  3.869933600492386e-14, -1.672353411065964e-15,  5.695804686055312e-17,
 -1.622392760109205e-18,  4.009439260663826e-20, -8.812984405424824e-22,  1.753947222377423e-23, -3.203102327634392e-25,  5.423608422135654e-27, -8.583456265535562e-29,
  9.361299960438358e-13, -1.169465418365800e-13,  7.778966631632708e-15, -3.633255393737060e-16,  1.332131522272717e-17, -4.071124423459224e-19,  1.076346475428476e-20,
 -2.524648600662052e-22,  5.349665233445836e-24, -1.038090919947966e-25,  1.864282897784636e-27, -3.123971445199376e-29,  1.502709438393352e-13, -2.045325783726223e-14,
  1.475030490160006e-15, -7.436559574535164e-17,  2.932285590282872e-18, -9.606706905575214e-20,  2.715257418510152e-21, -6.792001761844115e-23,  1.531489570780990e-24,
 -3.156158186286943e-26,  6.008878277679909e-28, -1.065668711614385e-29,  2.292240920310336e-14, -3.391378248588364e-15,  2.647379397290656e-16, -1.438953148113495e-17,
  6.095819187565208e-19, -2.139156523350563e-20,  6.459093724486772e-22, -1.721984053360956e-23,  4.129508405382229e-25, -9.033668586154346e-27,  1.822467918560455e-28,
 -3.419304717325119e-30,  3.335233169843984e-15, -5.351818868589345e-16,  4.515011889693643e-17, -2.642528143157172e-18,  1.201511253668591e-19, -4.512555051882776e-21,
  1.454578942327513e-22, -4.130447582361065e-24,  1.052882872376000e-25, -2.443713463358219e-27,  5.221654227932045e-29, -1.035973501622837e-30,  4.649220123464909e-16,
 -8.073665342301224e-17,  7.349742051043516e-18, -4.626316195139051e-19,  2.255457342218842e-20, -9.058362250783582e-22,  3.114844713461280e-23, -9.415044269399789e-25,
  2.549598808254109e-26, -6.275117074406414e-28,  1.419497978562138e-29, -2.976757374632378e-31,  6.240837218914390e-17, -1.170354240128549e-17,  1.147862303025422e-18,
 -7.761060080971687e-20,  4.052927083829819e-21, -1.739110865506351e-22,  6.374670403817011e-24, -2.049645865127529e-25,  5.892948006206871e-27, -1.537172737937689e-28,
  3.679331068505354e-30, -8.151477067239664e-32,  8.115099921571986e-18, -1.639907069995692e-18,  1.730137279906533e-19, -1.254958744447347e-20,  7.012344924240069e-22,
 -3.211932511537252e-23,  1.253977279502929e-24, -4.285797894348376e-26,  1.307387352460619e-27, -3.612198738755295e-29,  9.143371565633934e-31, -2.138949848013400e-32,
  1.029248063700191e-18, -2.236391810239531e-19,  2.533930408746285e-20, -1.969174557977537e-21,  1.176012315255606e-22, -5.744196055749686e-24,  2.386502108930746e-25,
 -8.663188719463106e-27,  2.801889446263678e-28, -8.194084664267331e-30,  2.192032553317212e-31, -5.411334312123579e-33,  1.283416660150355e-19, -2.991709239630857e-20,
  3.634243093865190e-21, -3.021540206764718e-22,  1.926264804608550e-23, -1.002245345505491e-24,  4.426787282243591e-26, -1.705248436643466e-27,  5.842512959442071e-29,
 -1.807144387745984e-30,  5.105425140648660e-32, -1.329066462355304e-33,  1.587798585019742e-20, -3.961383532392341e-21,  5.149946063239433e-22, -4.573760399277025e-23,
  3.108364393607870e-24, -1.720682245112262e-25,  8.070737409356659e-27, -3.295700078339307e-28,  1.195034449514272e-29, -3.905919953366019e-31,  1.164342604410268e-32,
 -3.193693696383074e-34,  1.969362572186595e-21, -5.245554576323103e-22,  7.283774707303158e-23, -6.898367858140340e-24,  4.990177739779200e-25, -2.934903625455656e-26,
  1.459985078089604e-27, -6.312469632427717e-29,  2.419713389878734e-30, -8.348198681161505e-32,  2.623165608795839e-33, -7.573705538926186e-35,  2.477931693083773e-22,
 -7.027584643029945e-23,  1.040028586053391e-23, -1.048408369453546e-24,  8.058667740276941e-26, -5.027587153102220e-27,  2.648570218000238e-28, -1.210797650350087e-29,
  4.899954333981248e-31, -1.782202287972759e-32,  5.895733439462251e-34, -1.789699420842641e-35,  3.205211892957151e-23, -9.650887955505047e-24,  1.518596718806037e-24,
 -1.625896484225433e-25,  1.325356767985014e-26, -8.754852520255075e-28,  4.875794803760202e-29, -2.352884028370028e-30,  1.003679683529397e-31, -3.842751399383816e-33,
  1.336414115118124e-34, -4.259235305707601e-36,  4.325586044954727e-24, -1.378421743960422e-24,  2.300019339830986e-25, -2.609090629658494e-26,  2.250354083810013e-27,
 -1.570573236897947e-28,  9.228222644294199e-30, -4.691659620916867e-31,  2.105657404398159e-32, -8.471088137606266e-34,  3.091747728070346e-35, -1.032790534585656e-36,
  6.189934672728326e-25, -2.080453956365497e-25,  3.670073302805602e-26, -4.398769134186333e-27,  4.003843864923459e-28, -2.945067598034521e-29,  1.821318518677775e-30,
 -9.733219501702070e-32,  4.585950875211839e-33, -1.934471382693590e-34,  7.394330970360926e-36, -2.583773469169386e-37,  9.557322510394495e-26, -3.375313314177608e-26,
  6.273715195932034e-27, -7.919506728404753e-28,  7.584299788460244e-29, -5.862578879042786e-30,  3.805429258647035e-31, -2.131932199177249e-32,  1.051800971031516e-33,
 -4.640431371707398e-35,  1.853141833065160e-36, -6.757425271593185e-38,  1.621419746026705e-26, -5.992429959518613e-27,  1.169092395348319e-27, -1.548681604730416e-28,
  1.555035796824480e-29, -1.258970252602225e-30,  8.549729146424595e-32, -5.005697288271425e-33,  2.578083708579016e-34, -1.186142034619226e-35,  4.934677560795101e-37,
 -1.872571574680852e-38,  3.078170029405979e-27, -1.185224959845068e-27,  2.416690554177019e-28, -3.345673858889555e-29,  3.508287627619950e-30, -2.963479632110001e-31,
  2.097698719953578e-32, -1.278876475987959e-33,  6.851866788515264e-35, -3.276278744815081e-36,  1.415243004358956e-37, -5.570714765492751e-39,  6.652084932030157e-28,
 -2.655730519663439e-28,  5.632553229359261e-29, -8.111464011259345e-30,  8.842710037465420e-31, -7.759295252418752e-32,  5.700599553622383e-33, -3.603988653919488e-34,
  2.000617987845953e-35, -9.902996987391385e-37,  4.424726699071461e-38, -1.799909012898147e-39,  1.659282723439460e-28, -6.833342757141509e-29,  1.499569406864270e-29,
 -2.234814432045475e-30,  2.520031382371288e-31, -2.285776060812208e-32,  1.734626147048277e-33, -1.131924231852198e-34,  6.480699873832632e-36, -3.306193157979120e-37,
  1.521383550310022e-38, -6.368781554964226e-40,  4.809731561684034e-29, -2.032127425753470e-29,  4.587736050543552e-30, -7.035200109949158e-31,  8.160001655979123e-32,
 -7.609149259486815e-33,  5.932905402438497e-34, -3.975300272280491e-35,  2.335590128783209e-36, -1.221966397873688e-37,  5.763220343041673e-39, -2.471129201113604e-40,
  1.605499601081176e-29, -6.919383423454511e-30,  1.597129290018703e-30, -2.504574070431233e-31,  2.969975019752700e-32, -2.830271828939867e-33,  2.254183841734241e-34,
 -1.542104079519347e-35,  9.245974261858393e-37, -4.934235637828313e-38,  2.372608735260324e-39, -1.036653829940232e-40,  5.859798456314584e-30, -2.560816974540138e-30,
  6.003804083752717e-31, -9.564688679412965e-32,  1.152040080822821e-32, -1.114807476172433e-33,  9.013198990223390e-35, -6.257135598500811e-36,  3.805744575537445e-37,
 -2.059613319466313e-38,  1.003983857777640e-39, -4.445404487607493e-41,  1.840536636795450e-30, -8.106262353283957e-31,  1.917235606260324e-31, -3.081578293822115e-32,
  3.744418967103268e-33, -3.654805512765575e-34,  2.979979924969262e-35, -2.085923465912121e-36,  1.278993327142963e-37, -6.976506469607985e-39,  3.427059716778682e-40,
 -1.528832036756302e-41,  };
  int offset = -50;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 50;
    if (std::isnan(t)) {
      fill_n(rr+offset, 50, 0.5);
      fill_n(ww+offset, 50, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 50; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;

      const double t2 = t * 2.0;
      for (int j=1; j <=50; ++j) {
        const int boxof = it*600+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
