/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.reflect.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.sf.jiapi.JiapiException;
import net.sf.jiapi.reflect.util.Instrumentor;
import net.sf.jiapi.reflect.util.Rule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstrumentationDescriptor {
    private static Logger log = LoggerFactory.getLogger(InstrumentationDescriptor.class);
    private List<Instrumentor> instrumentors = Collections.synchronizedList(new ArrayList());
    private Set<Rule> inclusionRules = new TreeSet(Collections.reverseOrder());
    private Set<Rule> exclusionRules = new TreeSet(Collections.reverseOrder());

    public void addInstrumentor(Instrumentor instrumentor) {
        this.instrumentors.add(instrumentor);
    }

    public List<Instrumentor> getInstrumentors() {
        return this.instrumentors;
    }

    public void addInclusionRule(String rule) throws JiapiException {
        this.inclusionRules.add(new Rule(rule));
    }

    public Set<Rule> getInclusionsRules() {
        return this.inclusionRules;
    }

    public void addExclusionRule(String rule) throws JiapiException {
        this.exclusionRules.add(new Rule(rule));
    }

    public Set<Rule> getExclusionsRules() {
        return this.exclusionRules;
    }

    public boolean match(String className) {
        log.debug("Matching rules to " + className);
        Rule exclusionRule = null;
        Rule inclusionRule = null;
        for (Rule rule : this.inclusionRules) {
            if (!rule.match(className)) continue;
            inclusionRule = rule;
            break;
        }
        if (inclusionRule == null) {
            log.debug("Excluding: " + className + " cause: no match");
            return false;
        }
        for (Rule rule : this.exclusionRules) {
            if (!rule.match(className)) continue;
            exclusionRule = rule;
            break;
        }
        if (exclusionRule == null) {
            log.debug("Including: " + className + " cause: " + inclusionRule + ", no exclusion rule");
            return true;
        }
        if (inclusionRule.isMoreSignificant(exclusionRule)) {
            log.debug("Including: " + className + " cause:\n  include " + inclusionRule + " is more significant than " + exclusionRule);
            return true;
        }
        log.debug("Excluding: " + className + " cause:\n  excluding " + exclusionRule + " is more significant than " + inclusionRule);
        return false;
    }

    public String toString() {
        return this.inclusionRules.toString() + ", " + this.exclusionRules.toString();
    }
}

