/*
 *  acm : an aerial combat simulator for X
 *  Copyright (C) 1991-1998  Riley Rainey
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 dated June, 1991.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program;  if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave., Cambridge, MA 02139, USA.
 */

#ifndef _m61a1_h
#define _m61a1_h

#include "pm.h"
#include "weapon.h"

#ifdef m61a1_IMPORT
	#define EXTERN
#else
	#define EXTERN extern
#endif

/**
	The display routine of this modules saves here the position of the
	LCOS reticule on the HUD. The HUD module then uses this value to
	decide if to draw or not the designator marker.
*/
EXTERN Alib_Point m61a1_lcos_last_pos;

/**
	Creates a new description record for the M61A1 cannon.
*/
EXTERN weapon_Type * m61a1_new(void);

/**
 * The dis_if should invoke this function when a fire DIS PDU arrives involving
 * a cannon burst. This function add a "craft" item carrying the rounds.
 * All units and reference systems are those usual in this program (not the DIS
 * ones).
 * Cannon burst are NOT tracked by the dis_if module, and no state update events
 * are send by the shooter. This implies the disId field of a burst is set to
 * zero because there is no a corresponding tracked entity in the dis_if module,
 * and each remote client is responsible to simulate the dynamics of the burst.
 * @param owner Index of shooter in the ptbl[] array. Ignored, anyway.
 * @param pos Position of the burst.
 * @param vel Velocity of the burst.
 * @param rounds Number of rounds.
 */
EXTERN void m61a1_DISFire(int owner, VPoint *pos, VPoint *vel, int rounds);

#undef EXTERN
#endif
