!{\src2tex{textfont=tt}}
!!****f* ABINIT/rdusps2
!! NAME
!! rdusps2
!! 
!! FUNCTION
!! Read data from USpp code (D. Vanderbilt)
!!
!! COPYRIGHT
!! Copyright (C) 1998-2005 ABINIT group (FJ, MT)
!! This file is distributed under the terms of the 
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~ABINIT/Infos/contributors .
!! 
!! INPUTS
!!  pshead
!!    %basis_size= Number of elements for the paw nl basis
!!    %rho_meshsz= Mesh size for densities inherited from uspp
!!    %shape_type= Shape function type
!!    %wav_meshsz=Mesh size for partial waves and projectors inherited from uspp
!!  usdata
!!    %nval= Number of valence states
!!
!! OUTPUT
!!  pawarray
!!    %coreden4pr2(rho_meshsz)= Core density multiplied by 4Pi.r2
!!    %rvloc(rho_meshsz)= Local (effective) all-electron potential * r
!!    %tcoreden4pr2(rho_meshsz)= Pseudo core density multiplied by 4Pi.r2
!!    %valeden4pr2(rho_meshsz)= Valence density multiplied by 4Pi.r2
!!  pawps
!!    %phi(wav_meshsz,basis_size)= atomic partial waves
!!    %tphi(wav_meshsz,basis_size)= atomic pseudo partial waves
!!    %tproj(wav_meshsz,basis_size)= projectors on partial waves
!!  pshead
!!    %atomic_charge= Total atomic charge
!!    %log_step= Logaritmic step corresponding to radial mesh
!!    %rad_step= Radial step corresponding to radial mesh
!!    %rc_sph= Default PAW sphere radius
!!    %title= Title for pseudopotential
!!    %valence_charge= Valence charge
!!  usdata
!!    %exfact= USpp s code number for the exchange-correlation
!!    %lval(nval)= l angular momentum for each valence state
!!    %occ(nval)= Valence states occupancies
!!    %refkeys(basis_size)= Key for identifying each reference energie
!!    %snl(wav_meshsz,nval)= Radial part of atomic eigenfunction
!!                           for each valence state
!!    %sss(basis_size,basis_size)=<chi(i)|chi(j)> from uspp code
!!
!! PARENTS
!!      uspp2abinit
!!
!! CHILDREN
!!
!! SOURCE

 subroutine rdusps2(pawarray,pawps,pshead,usdata)

 use defs_basis
 use defs_pawps

 implicit none
 
 include "usppcom.inc"

!Arguments ---------------------------------------------
!These types are defined in defs_pawps
 type(pawarray_type) :: pawarray
 type(pawps_type)    :: pawps
 type(pshead_type)   :: pshead
 type(usdata_type)   :: usdata

!Local variables ---------------------------------------
 integer :: ib

! *********************************************************************

 write(unit=pshead%title,fmt='(2a)') &
&      "Paw atomic data extracted from US-psp (D.Vanderbilt): ",&
&      trim(ADJUSTL(ustitle))
 pshead%atomic_charge=uszatm
 pshead%valence_charge=uszval
 usdata%exfact=usexfact
 usdata%refkeys(1:pshead%basis_size)=usrefkey(1:usbassz)
 pshead%rad_step=usradstp
 pshead%log_step=uslogstp
 pshead%rc_sph=usrcsph
 usdata%occ(1:usdata%nval)=usocc(1:usnval)
 usdata%lval(1:usdata%nval)=uslval(1:usnval)

 do ib=1,usnval
  usdata%snl(1:pshead%wav_meshsz,ib)=ussnl(1:usmesh1,ib)
 enddo

 do ib=1,pshead%basis_size
  usdata%sss(1:pshead%basis_size,ib)=ussss(1:usbassz,ib)
  pawps%phi(1:pshead%wav_meshsz,ib)=usphi(1:usmesh1,ib)
  pawps%tphi(1:pshead%wav_meshsz,ib)=ustphi(1:usmesh1,ib)
  pawps%tproj(1:pshead%wav_meshsz,ib)=ustproj(1:usmesh1,ib)
 enddo
 pawarray%coreden4pr2(1:pshead%rho_meshsz)=uscore(1:usmesh2)
 pawarray%tcoreden4pr2(1:pshead%rho_meshsz)=ustcore(1:usmesh2)
 pawarray%valeden4pr2(1:pshead%rho_meshsz)=usvale(1:usmesh2)
 pawarray%rvloc(1:pshead%rho_meshsz)=usvloc(1:usmesh2)

 end subroutine
!!***
