# coding=utf-8
#####################################################
# THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT #
#####################################################
# noqa: E128,E201
from ...aio.asyncclient import AsyncBaseClient
from ...aio.asyncclient import createApiClient
from ...aio.asyncclient import config
from ...aio.asyncclient import createTemporaryCredentials
from ...aio.asyncclient import createSession
_defaultConfig = config


class Notify(AsyncBaseClient):
    """
    The notification service listens for tasks with associated notifications
    and handles requests to send emails and post pulse messages.
    """

    classOptions = {
    }
    serviceName = 'notify'
    apiVersion = 'v1'

    async def ping(self, *args, **kwargs):
        """
        Ping Server

        Respond without doing anything.
        This endpoint is used to check that the service is up.

        This method is ``stable``
        """

        return await self._makeApiCall(self.funcinfo["ping"], *args, **kwargs)

    async def email(self, *args, **kwargs):
        """
        Send an Email

        Send an email to `address`. The content is markdown and will be rendered
        to HTML, but both the HTML and raw markdown text will be sent in the
        email. If a link is included, it will be rendered to a nice button in the
        HTML version of the email

        This method is ``experimental``
        """

        return await self._makeApiCall(self.funcinfo["email"], *args, **kwargs)

    async def pulse(self, *args, **kwargs):
        """
        Publish a Pulse Message

        Publish a message on pulse with the given `routingKey`.

        This method is ``experimental``
        """

        return await self._makeApiCall(self.funcinfo["pulse"], *args, **kwargs)

    async def matrix(self, *args, **kwargs):
        """
        Post Matrix Message

        Post a message to a room in Matrix. Optionally includes formatted message.

        The `roomId` in the scopes is a fully formed `roomId` with leading `!` such
        as `!foo:bar.com`.

        Note that the matrix client used by taskcluster must be invited to a room before
        it can post there!

        This method is ``experimental``
        """

        return await self._makeApiCall(self.funcinfo["matrix"], *args, **kwargs)

    async def slack(self, *args, **kwargs):
        """
        Post Slack Message

        Post a message to a Slack channel.

        The `channelId` in the scopes is a Slack channel ID, starting with a capital C.

        The Slack app can post into public channels by default but will need to be added
        to private channels before it can post messages there.

        This method is ``experimental``
        """

        return await self._makeApiCall(self.funcinfo["slack"], *args, **kwargs)

    async def addDenylistAddress(self, *args, **kwargs):
        """
        Denylist Given Address

        Add the given address to the notification denylist. Addresses in the denylist will be ignored
        by the notification service.

        This method is ``experimental``
        """

        return await self._makeApiCall(self.funcinfo["addDenylistAddress"], *args, **kwargs)

    async def deleteDenylistAddress(self, *args, **kwargs):
        """
        Delete Denylisted Address

        Delete the specified address from the notification denylist.

        This method is ``experimental``
        """

        return await self._makeApiCall(self.funcinfo["deleteDenylistAddress"], *args, **kwargs)

    async def listDenylist(self, *args, **kwargs):
        """
        List Denylisted Notifications

        Lists all the denylisted addresses.

        By default this end-point will try to return up to 1000 addresses in one
        request. But it **may return less**, even if more tasks are available.
        It may also return a `continuationToken` even though there are no more
        results. However, you can only be sure to have seen all results if you
        keep calling `list` with the last `continuationToken` until you
        get a result without a `continuationToken`.

        If you are not interested in listing all the members at once, you may
        use the query-string option `limit` to return fewer.

        This method is ``experimental``
        """

        return await self._makeApiCall(self.funcinfo["listDenylist"], *args, **kwargs)

    funcinfo = {
        "addDenylistAddress": {
            'args': [],
            'input': 'v1/notification-address.json#',
            'method': 'post',
            'name': 'addDenylistAddress',
            'route': '/denylist/add',
            'stability': 'experimental',
        },
        "deleteDenylistAddress": {
            'args': [],
            'input': 'v1/notification-address.json#',
            'method': 'delete',
            'name': 'deleteDenylistAddress',
            'route': '/denylist/delete',
            'stability': 'experimental',
        },
        "email": {
            'args': [],
            'input': 'v1/email-request.json#',
            'method': 'post',
            'name': 'email',
            'route': '/email',
            'stability': 'experimental',
        },
        "listDenylist": {
            'args': [],
            'method': 'get',
            'name': 'listDenylist',
            'output': 'v1/notification-address-list.json#',
            'query': ['continuationToken', 'limit'],
            'route': '/denylist/list',
            'stability': 'experimental',
        },
        "matrix": {
            'args': [],
            'input': 'v1/matrix-request.json#',
            'method': 'post',
            'name': 'matrix',
            'route': '/matrix',
            'stability': 'experimental',
        },
        "ping": {
            'args': [],
            'method': 'get',
            'name': 'ping',
            'route': '/ping',
            'stability': 'stable',
        },
        "pulse": {
            'args': [],
            'input': 'v1/pulse-request.json#',
            'method': 'post',
            'name': 'pulse',
            'route': '/pulse',
            'stability': 'experimental',
        },
        "slack": {
            'args': [],
            'input': 'v1/slack-request.json#',
            'method': 'post',
            'name': 'slack',
            'route': '/slack',
            'stability': 'experimental',
        },
    }


__all__ = ['createTemporaryCredentials', 'config', '_defaultConfig', 'createApiClient', 'createSession', 'Notify']
