/* 	dumpers.c: 
 *
 *	part of the martian_modem
 *
 *	description:
 *		functions to initiate/do dump different core information 
 *
 *	Author: A. Chentsov
 * 	Copying: LGPL
 */

#include <stdio.h>

#include <sys/ioctl.h>

#include <asm/types.h>
#include "../martian.h"

/*#define PREFIX "coredump"*/
#define PREFIX 	NULL
#include "log.h"


void ask_driver_vars (int dev_fd) {
	int result = ioctl (dev_fd, MARTIAN_DUMP_VARS);
	if (result != 0) {
		LOGERR ("Failed to ask device to dump\n");
	}
}

void print_irq_state (int dev_fd) {
	struct martian_irq_state irqstate;
	int result = ioctl (dev_fd, MARTIAN_IRQ_STATE, &irqstate);
	if (result != 0) {
		LOGERR ("Failed to get device irq state\n");
		return;
	}

	LOGQ (Debug, "Irq: string %s, pulses %d\n", irqstate.string, irqstate.count);
	LOGQ (Debug, "Irq: b: %d,  n: %d,  f: %d,  i: %d, o: %d\n",
			irqstate.counts.b,
			irqstate.counts.n,
			irqstate.counts.f,
			irqstate.counts.i,
			irqstate.counts.o
			);

}

#define DUMP_CORE(fmt, var) LOGINFO (fmt, #var, var)
#define DUMP_CORE_COMMON(fmt, var) LOGINFO (fmt, #var, common->var)

void print_core_vars (void ) {
	extern __u16 BaseAddress, BaseAddress2;
	extern __u16 BaseAddressIndex, BaseAddressData;
	extern __u8 BaseValue, dp_bamil_rd7, x_dsp_mars;
	extern __u8 Irq;

	LOGINFO ("Core vars:\n");
	LOGINFO ("Variable\t\t\tValue\n");
	DUMP_CORE ("%s\t\t\t0x%x\n", BaseAddress);
	DUMP_CORE ("%s\t\t\t0x%x\n", BaseAddress2);

	DUMP_CORE ("%s\t\t0x%x\n", BaseAddressIndex);
	DUMP_CORE ("%s\t\t\t0x%x\n", BaseValue);

	DUMP_CORE ("%s\t\t\t0x%x\n", BaseAddressData);
	DUMP_CORE ("%s\t\t\t0x%x\n", dp_bamil_rd7);
	DUMP_CORE ("%s\t\t\t%d\n", x_dsp_mars);

	DUMP_CORE ("%s\t\t\t\t%d\n", Irq);
}

#define DUMP_FIFO(mcb, fifo) \
	LOGINFO (#fifo":\n");					\
	LOGINFO ("\tbuf at 0x%x\n", mcb->io_##fifo##_buff);	\
	LOGINFO ("\trptr -> 0x%x\n", mcb->io_##fifo##_rptr);	\
	LOGINFO ("\twptr -> 0x%x\n", mcb->io_##fifo##_wptr);	\
	LOGINFO ("\tum   =  0x%x\n", mcb->io_##fifo##_buff_um);	

struct martian_common mcb_dump __attribute__ ((aligned (0x1000)));

void print_core_vars_common (struct martian_common *common) {
	LOGINFO ("Core vars (mcb at 0x%x):\n", common);
	LOGINFO ("Variable\t\t\tValue\n");
	DUMP_CORE_COMMON ("%s\t\t\t0x%x\n", BaseAddress);
	DUMP_CORE_COMMON ("%s\t\t\t0x%x\n", BaseAddress2);

	DUMP_CORE_COMMON ("%s\t\t0x%x\n", BaseAddressIndex);
	DUMP_CORE_COMMON ("%s\t\t\t0x%x\n", BaseValue);

	DUMP_CORE_COMMON ("%s\t\t\t0x%x\n", BaseAddressData);
	DUMP_CORE_COMMON ("%s\t\t\t0x%x\n", dp_bamil_rd7);
	DUMP_CORE_COMMON ("%s\t\t\t%d\n", x_dsp_mars);

	DUMP_FIFO (common, dce_rx);
	DUMP_FIFO (common, dce_tx);
	DUMP_FIFO (common, pdm_rx);

	mcb_dump = *common;
	LOGINFO ("mcb dump %d bytes at 0x%x \n", sizeof mcb_dump, &mcb_dump);
}

void dump_common_hex (struct martian_common *mcb) {
	
}
