/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.reference;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.util.BufferedLineReader;
import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.io.FileInputStream;

abstract class AbstractFastaSequenceFile
implements ReferenceSequenceFile {
    protected final File file;
    protected SAMSequenceDictionary sequenceDictionary;

    AbstractFastaSequenceFile(File file) {
        this.file = file;
        File dictionary = AbstractFastaSequenceFile.findSequenceDictionary(file);
        if (dictionary != null) {
            IOUtil.assertFileIsReadable(dictionary);
            try {
                SAMTextHeaderCodec codec = new SAMTextHeaderCodec();
                BufferedLineReader reader = new BufferedLineReader(new FileInputStream(dictionary));
                SAMFileHeader header = codec.decode(reader, dictionary.toString());
                if (header.getSequenceDictionary() != null && header.getSequenceDictionary().size() > 0) {
                    this.sequenceDictionary = header.getSequenceDictionary();
                }
                reader.close();
            }
            catch (Exception e) {
                throw new SAMException("Could not open sequence dictionary file: " + dictionary, e);
            }
        }
    }

    protected static File findSequenceDictionary(File file) {
        String dictionaryName = file.getAbsolutePath();
        String dictionaryNameExt = file.getAbsolutePath();
        boolean fileTypeSupported = false;
        for (String extension : ReferenceSequenceFileFactory.FASTA_EXTENSIONS) {
            if (!dictionaryName.endsWith(extension)) continue;
            dictionaryNameExt = new String(dictionaryName);
            dictionaryNameExt = dictionaryNameExt + ".dict";
            dictionaryName = dictionaryName.substring(0, dictionaryName.lastIndexOf(extension));
            dictionaryName = dictionaryName + ".dict";
            fileTypeSupported = true;
            break;
        }
        if (!fileTypeSupported) {
            throw new IllegalArgumentException("File is not a supported reference file type: " + file.getAbsolutePath());
        }
        File dictionary = new File(dictionaryName);
        if (dictionary.exists()) {
            return dictionary;
        }
        File dictionaryExt = new File(dictionaryNameExt);
        if (dictionaryExt.exists()) {
            return dictionaryExt;
        }
        return null;
    }

    @Override
    public SAMSequenceDictionary getSequenceDictionary() {
        return this.sequenceDictionary;
    }

    @Override
    public String toString() {
        return this.file.getAbsolutePath();
    }

    @Override
    public boolean isIndexed() {
        return false;
    }

    @Override
    public ReferenceSequence getSequence(String contig) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ReferenceSequence getSubsequenceAt(String contig, long start, long stop) {
        throw new UnsupportedOperationException("Index does not appear to exist for" + this.file.getAbsolutePath() + ".  samtools faidx can be used to create an index");
    }
}

