/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.BlockDeviceMappingAttribute;
import com.amazon.aes.webservices.client.ImageAttribute;
import com.amazon.aes.webservices.client.ImageListAttribute;
import com.amazon.aes.webservices.client.ImageListAttributeItem;
import com.amazon.aes.webservices.client.InvalidMapping;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.KernelAttribute;
import com.amazon.aes.webservices.client.LaunchPermissionAttribute;
import com.amazon.aes.webservices.client.ProductCodesAttribute;
import com.amazon.aes.webservices.client.RamdiskAttribute;
import com.amazon.aes.webservices.client.SriovNetSupportAttribute;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.InvalidArgument;
import com.amazon.aes.webservices.client.cmd.InvalidArgumentCombination;
import com.amazon.aes.webservices.client.cmd.MissingArgument;
import com.amazon.aes.webservices.client.cmd.OnlyOneArgumentExpected;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;

public abstract class ImageAttributeBaseCmd
extends BaseCmd {
    public static final String GROUP_ITEM = "group";
    public static final String IMAGE_ID_ITEM = "imageId";
    public static final String IMAGE_ATTRIBUTE = "image attribute";
    private static final Pattern validUserIdRegex = Pattern.compile("^\\d{12}+$");

    protected ImageAttributeBaseCmd(String name, String alias) {
        super(name, alias);
    }

    protected ImageAttributeBaseCmd(String name, String[] alias) {
        super(name, alias);
    }

    protected ImageAttribute.ImageAttributeType getImageAttributeType(Jec2 jec2) {
        if (this.isOptionSet("launch-permission")) {
            return ImageAttribute.ImageAttributeType.launchPermission;
        }
        if (this.isOptionSet("product-code")) {
            return ImageAttribute.ImageAttributeType.productCodes;
        }
        if (this.isOptionSet("kernel")) {
            return ImageAttribute.ImageAttributeType.kernel;
        }
        if (this.isOptionSet("ramdisk")) {
            return ImageAttribute.ImageAttributeType.ramdisk;
        }
        if (this.isOptionSet("block-device-mapping")) {
            return ImageAttribute.ImageAttributeType.blockDeviceMapping;
        }
        if (this.isOptionSet("sriov")) {
            return ImageAttribute.ImageAttributeType.sriovNetSupport;
        }
        throw new MissingArgument("launch-permission");
    }

    protected ImageAttribute getImageAttribute(Jec2 jec2) {
        if (this.isOptionSet("launch-permission")) {
            LaunchPermissionAttribute listAttribute = new LaunchPermissionAttribute();
            this.populateListAttribute((ImageListAttribute)listAttribute);
            return listAttribute;
        }
        if (this.isOptionSet("product-code")) {
            this.assertOptionsNotSet(ATTRIBUTE_OP_ARGS);
            ProductCodesAttribute productCodes = new ProductCodesAttribute();
            for (String productCode : this.getOptionValues("product-code")) {
                productCodes.addImageListAttributeItem(ImageListAttributeItem.ImageListAttributeItemType.productCode, productCode);
            }
            return productCodes;
        }
        if (this.isOptionSet("kernel")) {
            this.assertOptionsNotSet(ATTRIBUTE_OP_ARGS);
            return new KernelAttribute(this.getOptionValue("kernel"));
        }
        if (this.isOptionSet("ramdisk")) {
            this.assertOptionsNotSet(ATTRIBUTE_OP_ARGS);
            return new RamdiskAttribute(this.getOptionValue("ramdisk"));
        }
        if (this.isOptionSet("block-device-mapping")) {
            this.assertOptionsNotSet(ATTRIBUTE_OP_ARGS);
            ArrayList<String> mappingsStrings = new ArrayList<String>(Arrays.asList(this.getOptionValues("block-device-mapping")));
            BlockDeviceMappingAttribute mappings = new BlockDeviceMappingAttribute();
            try {
                for (String mappingsString : mappingsStrings) {
                    mappings.add(mappingsString);
                }
            }
            catch (InvalidMapping e) {
                throw new InvalidArgument("block-device-mapping", ((Object)mappingsStrings).toString());
            }
            return mappings;
        }
        if (this.isOptionSet("sriov")) {
            this.assertOptionsNotSet(ATTRIBUTE_OP_ARGS);
            return new SriovNetSupportAttribute(this.getOptionValue("sriov"));
        }
        throw new MissingArgument("launch-permission");
    }

    protected void populateListAttribute(ImageListAttribute list) {
        String[] itemValues = null;
        String operationName = "";
        this.assertOnlyOneOptionSet(ATTRIBUTE_OP_ARGS);
        if (this.isOptionSet("add")) {
            itemValues = this.getOptionValues("add");
            operationName = "add";
        } else if (this.isOptionSet("remove")) {
            itemValues = this.getOptionValues("remove");
            operationName = "remove";
        } else {
            throw new InvalidArgument(operationName, "(null)");
        }
        for (String itemValue : itemValues) {
            if (itemValue.equals("all")) {
                list.addImageListAttributeItem(ImageListAttributeItem.ImageListAttributeItemType.group, itemValue);
                continue;
            }
            if (validUserIdRegex.matcher(itemValue).matches()) {
                list.addImageListAttributeItem(ImageListAttributeItem.ImageListAttributeItemType.userId, itemValue);
                continue;
            }
            throw new InvalidArgument(operationName, itemValue);
        }
    }

    protected ImageListAttribute.ImageListAttributeOperationType getAttributeListOperationType() {
        if (this.isOptionSet("launch-permission")) {
            this.assertOnlyOneOptionSet(ATTRIBUTE_OP_ARGS);
        }
        if (this.isOptionSet("add")) {
            return ImageListAttribute.ImageListAttributeOperationType.add;
        }
        if (this.isOptionSet("remove")) {
            return ImageListAttribute.ImageListAttributeOperationType.remove;
        }
        if (this.isOptionSet("product-code")) {
            return null;
        }
        throw new OnlyOneArgumentExpected(ATTRIBUTE_OP_ARGS);
    }

    protected String getAmiId() {
        String[] imageIds = this.getNonOptions();
        if (imageIds.length == 0) {
            throw new InvalidArgumentCombination("An AMI ID must be specified.");
        }
        if (imageIds.length > 1) {
            throw new InvalidArgumentCombination("Only one AMI ID may be specified.");
        }
        return imageIds[0];
    }
}

