/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.ext;

import com.google.gwt.core.ext.BadPropertyValueException;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.PropertyOracle;
import com.google.gwt.core.ext.SelectionProperty;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JPackage;
import com.google.gwt.core.ext.typeinfo.JPrimitiveType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.NotFoundException;
import com.google.gwt.dev.resource.Resource;
import com.google.gwt.dev.resource.ResourceOracle;
import com.google.gwt.dev.util.collect.Maps;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.ext.ClientBundleRequirements;
import com.google.gwt.resources.ext.DefaultExtensions;
import com.google.gwt.resources.ext.ResourceContext;
import java.io.File;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceGeneratorUtil {
    private static Map<String, File> namedFiles = Maps.create();
    private static final String[] DEPRECATED_ANNOTATION_NAMES = new String[]{"com.google.gwt.libideas.resources.client.ImmutableResourceBundle$Resource", "com.google.gwt.user.client.ui.ImageBundle$Resource"};
    private static final List<Class<? extends Annotation>> DEPRECATED_ANNOTATION_CLASSES;

    public static void addNamedFile(String resourceName, File file) {
        assert (resourceName != null) : "resourceName";
        assert (file != null) : "file";
        assert (file.isFile() && file.canRead()) : "file does not exist or cannot be read";
        namedFiles = Maps.put(namedFiles, (Object)resourceName, (Object)file);
    }

    public static String baseName(URL resource) {
        String path = resource.getPath();
        return path.substring(path.lastIndexOf(47) + 1);
    }

    public static URL[] findResources(TreeLogger logger, ClassLoader classLoader, ResourceContext context, JMethod method, String[] defaultSuffixes) throws UnableToCompleteException {
        return ResourceGeneratorUtil.findResources(logger, new Locator[]{new ClassLoaderLocator(classLoader)}, context, method, defaultSuffixes);
    }

    public static URL[] findResources(TreeLogger logger, ResourceContext context, JMethod method) throws UnableToCompleteException {
        JClassType returnType = method.getReturnType().isClassOrInterface();
        assert (returnType != null);
        DefaultExtensions annotation = (DefaultExtensions)returnType.findAnnotationInTypeHierarchy(DefaultExtensions.class);
        String[] extensions = annotation != null ? annotation.value() : new String[]{};
        return ResourceGeneratorUtil.findResources(logger, context, method, extensions);
    }

    public static URL[] findResources(TreeLogger logger, ResourceContext context, JMethod method, String[] defaultSuffixes) throws UnableToCompleteException {
        Locator[] locators = ResourceGeneratorUtil.getDefaultLocators(context.getGeneratorContext());
        URL[] toReturn = ResourceGeneratorUtil.findResources(logger, locators, context, method, defaultSuffixes);
        return toReturn;
    }

    public static JMethod getMethodByPath(JClassType rootType, List<String> pathElements, JType expectedReturnType) throws NotFoundException {
        if (pathElements.isEmpty()) {
            throw new NotFoundException("No path specified");
        }
        JMethod currentMethod = null;
        JClassType currentType = rootType;
        for (String pathElement : pathElements) {
            JClassType referenceType = currentType.isClassOrInterface();
            if (referenceType == null) {
                throw new NotFoundException("Cannot resolve member " + pathElement + " on type " + currentType.getQualifiedSourceName());
            }
            currentMethod = null;
            block1: for (JClassType searchType : referenceType.getFlattenedSupertypeHierarchy()) {
                for (JMethod method : searchType.getOverloads(pathElement)) {
                    if (method.getParameters().length != 0) continue;
                    currentMethod = method;
                    break block1;
                }
            }
            if (currentMethod == null) {
                throw new NotFoundException("Could not find no-arg method named " + pathElement + " in type " + currentType.getQualifiedSourceName());
            }
            currentType = currentMethod.getReturnType();
        }
        if (expectedReturnType != null) {
            JPrimitiveType expectedIsPrimitive = expectedReturnType.isPrimitive();
            JClassType expectedIsClassType = expectedReturnType.isClassOrInterface();
            boolean error = false;
            if (expectedIsPrimitive != null) {
                if (!expectedIsPrimitive.equals((Object)currentMethod.getReturnType())) {
                    error = true;
                }
            } else {
                JClassType returnIsClassType = currentMethod.getReturnType().isClassOrInterface();
                if (returnIsClassType == null) {
                    error = true;
                } else if (!expectedIsClassType.isAssignableFrom(returnIsClassType)) {
                    error = true;
                }
            }
            if (error) {
                throw new NotFoundException("Expecting return type " + expectedReturnType.getQualifiedSourceName() + " found " + currentMethod.getReturnType().getQualifiedSourceName());
            }
        }
        return currentMethod;
    }

    public static URL tryFindResource(TreeLogger logger, GeneratorContext genContext, ResourceContext resourceContext, String resourceName) {
        Locator[] locators;
        String locale = ResourceGeneratorUtil.getLocale(logger, genContext);
        for (Locator locator : locators = ResourceGeneratorUtil.getDefaultLocators(genContext)) {
            URL toReturn = ResourceGeneratorUtil.tryFindResource(locator, resourceContext, resourceName, locale);
            if (toReturn == null) continue;
            return toReturn;
        }
        return null;
    }

    private static void addTypeRequirementsForMethod(ResourceContext context, JMethod method) {
        ClientBundleRequirements reqs = context.getRequirements();
        if (reqs != null) {
            reqs.addTypeHierarchy(method.getEnclosingType());
            reqs.addTypeHierarchy((JClassType)method.getReturnType());
        }
    }

    private static void checkForDeprecatedAnnotations(TreeLogger logger, JMethod method) {
        for (Class<? extends Annotation> annotationClass : DEPRECATED_ANNOTATION_CLASSES) {
            if (!method.isAnnotationPresent(annotationClass)) continue;
            logger.log(TreeLogger.WARN, "Deprecated annotation used; expecting " + ClientBundle.Source.class.getCanonicalName() + " but found " + annotationClass.getName() + " instead.  It is likely " + "that undesired operation will occur.");
        }
    }

    private static URL[] findResources(TreeLogger logger, Locator[] locators, ResourceContext context, JMethod method, String[] defaultSuffixes) throws UnableToCompleteException {
        URL[] toReturn;
        logger = logger.branch(TreeLogger.DEBUG, "Finding resources");
        String locale = ResourceGeneratorUtil.getLocale(logger, context.getGeneratorContext());
        ResourceGeneratorUtil.checkForDeprecatedAnnotations(logger, method);
        boolean error = false;
        ClientBundle.Source resourceAnnotation = (ClientBundle.Source)method.getAnnotation(ClientBundle.Source.class);
        if (resourceAnnotation == null) {
            if (defaultSuffixes != null) {
                for (String extension : defaultSuffixes) {
                    logger.log(TreeLogger.SPAM, "Trying default extension " + extension);
                    for (Locator locator : locators) {
                        URL resourceUrl = ResourceGeneratorUtil.tryFindResource(locator, context, ResourceGeneratorUtil.getPathRelativeToPackage(method.getEnclosingType().getPackage(), method.getName() + extension), locale);
                        if (resourceUrl == null) continue;
                        ResourceGeneratorUtil.addTypeRequirementsForMethod(context, method);
                        return new URL[]{resourceUrl};
                    }
                }
            }
            logger.log(TreeLogger.ERROR, "No " + ClientBundle.Source.class.getName() + " annotation and no resources found with default extensions");
            toReturn = null;
            error = true;
        } else {
            String[] resources = resourceAnnotation.value();
            toReturn = new URL[resources.length];
            int tagIndex = 0;
            for (String resource : resources) {
                URL resourceURL = null;
                for (Locator locator : locators) {
                    resourceURL = ResourceGeneratorUtil.tryFindResource(locator, context, ResourceGeneratorUtil.getPathRelativeToPackage(method.getEnclosingType().getPackage(), resource), locale);
                    if (resourceURL == null) {
                        resourceURL = ResourceGeneratorUtil.tryFindResource(locator, context, resource, locale);
                    }
                    if (resourceURL != null) break;
                }
                if (resourceURL == null) {
                    error = true;
                    logger.log(TreeLogger.ERROR, "Resource " + resource + " not found. Is the name specified as Class.getResource()" + " would expect?");
                }
                toReturn[tagIndex++] = resourceURL;
            }
        }
        if (error) {
            throw new UnableToCompleteException();
        }
        ResourceGeneratorUtil.addTypeRequirementsForMethod(context, method);
        return toReturn;
    }

    private static Locator[] getDefaultLocators(GeneratorContext genContext) {
        Locator[] locators = new Locator[]{NamedFileLocator.INSTANCE, new ResourceOracleLocator(genContext.getResourcesOracle()), new ClassLoaderLocator(Thread.currentThread().getContextClassLoader())};
        return locators;
    }

    private static String getLocale(TreeLogger logger, GeneratorContext genContext) {
        String locale;
        try {
            PropertyOracle oracle = genContext.getPropertyOracle();
            SelectionProperty prop = oracle.getSelectionProperty(logger, "locale");
            locale = prop.getCurrentValue();
        }
        catch (BadPropertyValueException e) {
            locale = null;
        }
        return locale;
    }

    private static String getPathRelativeToPackage(JPackage pkg, String path) {
        return pkg.getName().replace('.', '/') + '/' + path;
    }

    private static URL tryFindResource(Locator locator, String resourceName, String locale) {
        URL toReturn = null;
        if (locale != null) {
            String[] localeSegments = locale.split("_");
            int lastDot = resourceName.lastIndexOf(".");
            String prefix = lastDot == -1 ? resourceName : resourceName.substring(0, lastDot);
            String extension = lastDot == -1 ? "" : resourceName.substring(lastDot);
            for (int i = localeSegments.length - 1; i >= -1; --i) {
                String localeInsert = "";
                for (int j = 0; j <= i; ++j) {
                    localeInsert = localeInsert + "_" + localeSegments[j];
                }
                toReturn = locator.locate(prefix + localeInsert + extension);
                if (toReturn == null) {
                    continue;
                }
                break;
            }
        } else {
            toReturn = locator.locate(resourceName);
        }
        return toReturn;
    }

    private static URL tryFindResource(Locator locator, ResourceContext context, String resourceName, String locale) {
        ClientBundleRequirements reqs;
        URL toReturn = ResourceGeneratorUtil.tryFindResource(locator, resourceName, locale);
        if (toReturn != null && context != null && (reqs = context.getRequirements()) != null) {
            reqs.addResolvedResource(resourceName, toReturn);
        }
        return toReturn;
    }

    private ResourceGeneratorUtil() {
    }

    static {
        ArrayList<Class<Annotation>> classes = new ArrayList<Class<Annotation>>(DEPRECATED_ANNOTATION_NAMES.length);
        for (String name : DEPRECATED_ANNOTATION_NAMES) {
            try {
                Class<?> maybeAnnotation = Class.forName(name, false, ResourceGeneratorUtil.class.getClassLoader());
                Class<Annotation> annotationClass = maybeAnnotation.asSubclass(Annotation.class);
                classes.add(annotationClass);
            }
            catch (ClassCastException e) {
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        DEPRECATED_ANNOTATION_CLASSES = classes.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(classes);
    }

    private static class ResourceOracleLocator
    implements Locator {
        private final Map<String, Resource> resourceMap;

        public ResourceOracleLocator(ResourceOracle oracle) {
            this.resourceMap = oracle.getResourceMap();
        }

        public URL locate(String resourceName) {
            Resource r = this.resourceMap.get(resourceName);
            return r == null ? null : r.getURL();
        }
    }

    private static interface Locator {
        public URL locate(String var1);
    }

    private static class NamedFileLocator
    implements Locator {
        public static final NamedFileLocator INSTANCE = new NamedFileLocator();

        private NamedFileLocator() {
        }

        public URL locate(String resourceName) {
            File f = (File)namedFiles.get(resourceName);
            if (f != null && f.isFile() && f.canRead()) {
                try {
                    return f.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException("Unable to make a URL for file " + f.getName());
                }
            }
            return null;
        }
    }

    private static class ClassLoaderLocator
    implements Locator {
        private final ClassLoader classLoader;

        public ClassLoaderLocator(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public URL locate(String resourceName) {
            return this.classLoader.getResource(resourceName);
        }
    }
}

