/* Generated by re2c */
// re2c $INPUT -o $OUTPUT -igc
/*
  +----------------------------------------------------------------------+
  | PHP Version 5                                                        |
  +----------------------------------------------------------------------+
  | Copyright (c) 1997-2015 The PHP Group                                |
  +----------------------------------------------------------------------+
  | This source file is subject to version 3.01 of the PHP license,      |
  | that is bundled with this package in the file LICENSE, and is        |
  | available through the world-wide-web at the following url:           |
  | http://www.php.net/license/3_01.txt                                  |
  | If you did not receive a copy of the PHP license and are unable to   |
  | obtain it through the world-wide-web, please send a note to          |
  | license@php.net so we can mail you a copy immediately.               |
  +----------------------------------------------------------------------+
  | Author: Jakub Zelenka <bukka@php.net>                                |
  +----------------------------------------------------------------------+
*/

#include "php.h"
#include "php_json_scanner.h"
#include "php_json_scanner_defs.h"
#include "php_json_parser.h"
#include "json_parser.tab.h"

#define	YYCTYPE     php_json_ctype
#define	YYCURSOR    s->cursor
#define	YYLIMIT     s->limit
#define	YYMARKER    s->marker
#define	YYCTXMARKER s->ctxmarker

#define YYGETCONDITION()        s->state
#define YYSETCONDITION(yystate) s->state = yystate

#define	YYFILL(n)

#define PHP_JSON_CONDITION_SET(condition) YYSETCONDITION(yyc##condition)
#define PHP_JSON_CONDITION_GOTO(condition) goto yyc_##condition

#define PHP_JSON_SCANNER_COPY_ESC() php_json_scanner_copy_string(s, 0)
#define PHP_JSON_SCANNER_COPY_UTF() php_json_scanner_copy_string(s, 5)
#define PHP_JSON_SCANNER_COPY_UTF_SP() php_json_scanner_copy_string(s, 11)

#define PHP_JSON_INT_MAX_LENGTH (MAX_LENGTH_OF_LONG - 1)


static void php_json_scanner_copy_string(php_json_scanner *s, int esc_size)
{
	size_t len = s->cursor - s->str_start - esc_size - 1;
	if (len) {
		memcpy(s->pstr, s->str_start, len);
		s->pstr += len;
	}
}

static int php_json_hex_to_int(char code)
{
	if (code >= '0' && code <= '9') {
		return code - '0';
	} else if (code >= 'A' && code <= 'F') {
		return code - ('A' - 10);
	} else if (code >= 'a' && code <= 'f') {
		return code - ('a' - 10);
	} else {
		/* this should never happened (just to suppress compiler warning) */
		return -1;
	}
}

static int php_json_ucs2_to_int_ex(php_json_scanner *s, int size, int start)
{
	int i, code = 0;
	php_json_ctype *pc = s->cursor - start;
	for (i = 0; i < size; i++) {
		code |= php_json_hex_to_int(*(pc--)) << (i * 4);
	}
	return code;
}

static int php_json_ucs2_to_int(php_json_scanner *s, int size)
{
	return php_json_ucs2_to_int_ex(s, size, 1);
}

void php_json_scanner_init(php_json_scanner *s, char *str, size_t str_len, int options)
{
	s->cursor = (php_json_ctype *) str;
	s->limit = (php_json_ctype *) str + str_len;
	s->options = options;
	PHP_JSON_CONDITION_SET(JS);
}

int php_json_scan(php_json_scanner *s)
{
	ZVAL_NULL(&s->value);
	
std:
	s->token = s->cursor;


	{
		YYCTYPE yych;
		unsigned int yyaccept = 0;
		static void *yyctable[3] = {
			&&yyc_JS,
			&&yyc_STR_P1,
			&&yyc_STR_P2,
		};
		goto *yyctable[YYGETCONDITION()];
/* *********************************** */
yyc_JS:
		{
			static const unsigned char yybm[] = {
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,  64,   0,   0,   0,  64,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				 64,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				128, 128, 128, 128, 128, 128, 128, 128, 
				128, 128,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
			};
			yych = *YYCURSOR;
			{
				static void *yytarget[256] = {
					&&yy1,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
					&&yy2,  &&yy4,  &&yy7,  &&yy2,  &&yy2,  &&yy8,  &&yy2,  &&yy2,
					&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
					&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
					&&yy4,  &&yy2,  &&yy9,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
					&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy10, &&yy11, &&yy2,  &&yy2,
					&&yy12, &&yy14, &&yy14, &&yy14, &&yy14, &&yy14, &&yy14, &&yy14,
					&&yy14, &&yy14, &&yy15, &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
					&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
					&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
					&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
					&&yy2,  &&yy2,  &&yy2,  &&yy16, &&yy2,  &&yy17, &&yy2,  &&yy2,
					&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy18, &&yy2,
					&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy19, &&yy2,
					&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy20, &&yy2,  &&yy2,  &&yy2,
					&&yy2,  &&yy2,  &&yy2,  &&yy21, &&yy2,  &&yy22, &&yy2,  &&yy2,
					&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
					&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
					&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
					&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
					&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
					&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
					&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
					&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
					&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
					&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
					&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
					&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
					&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
					&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
					&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,
					&&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2,  &&yy2
				};
				goto *yytarget[yych];
			}
yy1:
			++YYCURSOR;
			{
		if (s->limit < s->cursor) {
			return PHP_JSON_T_EOI;
		} else {
			s->errcode = PHP_JSON_ERROR_SYNTAX;
			return PHP_JSON_T_ERROR;
		}
	}
yy2:
			++YYCURSOR;
yy3:
			{
		s->errcode = PHP_JSON_ERROR_SYNTAX;
		return PHP_JSON_T_ERROR;
	}
yy4:
			yych = *++YYCURSOR;
yy5:
			if (yybm[0+yych] & 64) {
				goto yy4;
			}
yy6:
			{ goto std; }
yy7:
			++YYCURSOR;
			goto yy6;
yy8:
			yych = *++YYCURSOR;
			if (yych == '\n') goto yy7;
			goto yy5;
yy9:
			++YYCURSOR;
			{
		s->str_start = s->cursor;
		s->str_esc = 0;
		PHP_JSON_CONDITION_SET(STR_P1);
		PHP_JSON_CONDITION_GOTO(STR_P1);
	}
yy10:
			++YYCURSOR;
			{ return ','; }
yy11:
			yych = *++YYCURSOR;
			if (yych <= '/') goto yy3;
			if (yych <= '0') goto yy12;
			if (yych <= '9') goto yy14;
			goto yy3;
yy12:
			yyaccept = 0;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych <= 'D') {
				if (yych == '.') goto yy23;
			} else {
				if (yych <= 'E') goto yy25;
				if (yych == 'e') goto yy25;
			}
yy13:
			{
		zend_bool bigint = 0, negative = s->token[0] == '-';
		size_t digits = (size_t) (s->cursor - s->token - negative);
		if (digits >= PHP_JSON_INT_MAX_LENGTH) {
			if (digits == PHP_JSON_INT_MAX_LENGTH) {
				int cmp = strncmp((char *) (s->token + negative), LONG_MIN_DIGITS, PHP_JSON_INT_MAX_LENGTH);
				if (!(cmp < 0 || (cmp == 0 && negative))) {
					bigint = 1;
				}
			} else {
				bigint = 1;
			}
		}
		if (!bigint) {
			ZVAL_LONG(&s->value, ZEND_STRTOL((char *) s->token, NULL, 10));
			return PHP_JSON_T_INT;
		} else if (s->options & PHP_JSON_BIGINT_AS_STRING) {
			ZVAL_STRINGL(&s->value, (char *) s->token, s->cursor - s->token);
			return PHP_JSON_T_STRING;
		} else {
			ZVAL_DOUBLE(&s->value, zend_strtod((char *) s->token, NULL));
			return PHP_JSON_T_DOUBLE;
		}
	}
yy14:
			yyaccept = 0;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yybm[0+yych] & 128) {
				goto yy14;
			}
			if (yych <= 'D') {
				if (yych == '.') goto yy23;
				goto yy13;
			} else {
				if (yych <= 'E') goto yy25;
				if (yych == 'e') goto yy25;
				goto yy13;
			}
yy15:
			++YYCURSOR;
			{ return ':'; }
yy16:
			++YYCURSOR;
			{ return '['; }
yy17:
			++YYCURSOR;
			{ return ']'; }
yy18:
			yyaccept = 1;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych == 'a') goto yy26;
			goto yy3;
yy19:
			yyaccept = 1;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych == 'u') goto yy27;
			goto yy3;
yy20:
			yyaccept = 1;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych == 'r') goto yy28;
			goto yy3;
yy21:
			++YYCURSOR;
			{ return '{'; }
yy22:
			++YYCURSOR;
			{ return '}'; }
yy23:
			yych = *++YYCURSOR;
			if (yych <= '/') goto yy24;
			if (yych <= '9') goto yy29;
yy24:
			YYCURSOR = YYMARKER;
			if (yyaccept <= 1) {
				if (yyaccept == 0) {
					goto yy13;
				} else {
					goto yy3;
				}
			} else {
				goto yy30;
			}
yy25:
			yych = *++YYCURSOR;
			if (yych <= ',') {
				if (yych == '+') goto yy31;
				goto yy24;
			} else {
				if (yych <= '-') goto yy31;
				if (yych <= '/') goto yy24;
				if (yych <= '9') goto yy32;
				goto yy24;
			}
yy26:
			yych = *++YYCURSOR;
			if (yych == 'l') goto yy33;
			goto yy24;
yy27:
			yych = *++YYCURSOR;
			if (yych == 'l') goto yy34;
			goto yy24;
yy28:
			yych = *++YYCURSOR;
			if (yych == 'u') goto yy35;
			goto yy24;
yy29:
			yyaccept = 2;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych <= 'D') {
				if (yych <= '/') goto yy30;
				if (yych <= '9') goto yy29;
			} else {
				if (yych <= 'E') goto yy25;
				if (yych == 'e') goto yy25;
			}
yy30:
			{
		ZVAL_DOUBLE(&s->value, zend_strtod((char *) s->token, NULL));
		return PHP_JSON_T_DOUBLE;
	}
yy31:
			yych = *++YYCURSOR;
			if (yych <= '/') goto yy24;
			if (yych >= ':') goto yy24;
yy32:
			yych = *++YYCURSOR;
			if (yych <= '/') goto yy30;
			if (yych <= '9') goto yy32;
			goto yy30;
yy33:
			yych = *++YYCURSOR;
			if (yych == 's') goto yy36;
			goto yy24;
yy34:
			yych = *++YYCURSOR;
			if (yych == 'l') goto yy37;
			goto yy24;
yy35:
			yych = *++YYCURSOR;
			if (yych == 'e') goto yy38;
			goto yy24;
yy36:
			yych = *++YYCURSOR;
			if (yych == 'e') goto yy39;
			goto yy24;
yy37:
			++YYCURSOR;
			{
		ZVAL_NULL(&s->value);
		return PHP_JSON_T_NUL;
	}
yy38:
			++YYCURSOR;
			{
		ZVAL_TRUE(&s->value);
		return PHP_JSON_T_TRUE;
	}
yy39:
			++YYCURSOR;
			{
		ZVAL_FALSE(&s->value);
		return PHP_JSON_T_FALSE;
	}
		}
/* *********************************** */
yyc_STR_P1:
		yych = *YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy41, &&yy41, &&yy41, &&yy41, &&yy41, &&yy41, &&yy41, &&yy41,
				&&yy41, &&yy41, &&yy41, &&yy41, &&yy41, &&yy41, &&yy41, &&yy41,
				&&yy41, &&yy41, &&yy41, &&yy41, &&yy41, &&yy41, &&yy41, &&yy41,
				&&yy41, &&yy41, &&yy41, &&yy41, &&yy41, &&yy41, &&yy41, &&yy41,
				&&yy42, &&yy42, &&yy43, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42,
				&&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42,
				&&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42,
				&&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42,
				&&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42,
				&&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42,
				&&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42,
				&&yy42, &&yy42, &&yy42, &&yy42, &&yy44, &&yy42, &&yy42, &&yy42,
				&&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42,
				&&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42,
				&&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42,
				&&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42, &&yy42,
				&&yy46, &&yy46, &&yy46, &&yy46, &&yy46, &&yy46, &&yy46, &&yy46,
				&&yy46, &&yy46, &&yy46, &&yy46, &&yy46, &&yy46, &&yy46, &&yy46,
				&&yy46, &&yy46, &&yy46, &&yy46, &&yy46, &&yy46, &&yy46, &&yy46,
				&&yy46, &&yy46, &&yy46, &&yy46, &&yy46, &&yy46, &&yy46, &&yy46,
				&&yy46, &&yy46, &&yy46, &&yy46, &&yy46, &&yy46, &&yy46, &&yy46,
				&&yy46, &&yy46, &&yy46, &&yy46, &&yy46, &&yy46, &&yy46, &&yy46,
				&&yy46, &&yy46, &&yy46, &&yy46, &&yy46, &&yy46, &&yy46, &&yy46,
				&&yy46, &&yy46, &&yy46, &&yy46, &&yy46, &&yy46, &&yy46, &&yy46,
				&&yy46, &&yy46, &&yy48, &&yy48, &&yy48, &&yy48, &&yy48, &&yy48,
				&&yy48, &&yy48, &&yy48, &&yy48, &&yy48, &&yy48, &&yy48, &&yy48,
				&&yy48, &&yy48, &&yy48, &&yy48, &&yy48, &&yy48, &&yy48, &&yy48,
				&&yy48, &&yy48, &&yy48, &&yy48, &&yy48, &&yy48, &&yy48, &&yy48,
				&&yy49, &&yy50, &&yy50, &&yy50, &&yy50, &&yy50, &&yy50, &&yy50,
				&&yy50, &&yy50, &&yy50, &&yy50, &&yy50, &&yy51, &&yy50, &&yy50,
				&&yy52, &&yy53, &&yy53, &&yy53, &&yy54, &&yy46, &&yy46, &&yy46,
				&&yy46, &&yy46, &&yy46, &&yy46, &&yy46, &&yy46, &&yy46, &&yy46
			};
			goto *yytarget[yych];
		}
yy41:
		++YYCURSOR;
		{
		s->errcode = PHP_JSON_ERROR_CTRL_CHAR;
		return PHP_JSON_T_ERROR;
	}
yy42:
		++YYCURSOR;
		{ PHP_JSON_CONDITION_GOTO(STR_P1); }
yy43:
		++YYCURSOR;
		{
		zend_string *str;
		size_t len = s->cursor - s->str_start - s->str_esc - 1;
		if (len == 0) {
			PHP_JSON_CONDITION_SET(JS);
			ZVAL_EMPTY_STRING(&s->value);
			return PHP_JSON_T_ESTRING;
		}
		str = zend_string_alloc(len, 0);
		str->val[len] = '\0';
		ZVAL_STR(&s->value, str);
		if (s->str_esc) {
			s->pstr = (php_json_ctype *) Z_STRVAL(s->value);
			s->cursor = s->str_start;
			PHP_JSON_CONDITION_SET(STR_P2);
			PHP_JSON_CONDITION_GOTO(STR_P2);
		} else {
			memcpy(Z_STRVAL(s->value), s->str_start, len);
			PHP_JSON_CONDITION_SET(JS);
			return PHP_JSON_T_STRING;
		}
	}
yy44:
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45,
				&&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45,
				&&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45,
				&&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45,
				&&yy45, &&yy45, &&yy55, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45,
				&&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy55,
				&&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45,
				&&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45,
				&&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45,
				&&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45,
				&&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45,
				&&yy45, &&yy45, &&yy45, &&yy45, &&yy55, &&yy45, &&yy45, &&yy45,
				&&yy45, &&yy45, &&yy55, &&yy45, &&yy45, &&yy45, &&yy55, &&yy45,
				&&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy55, &&yy45,
				&&yy45, &&yy45, &&yy55, &&yy45, &&yy55, &&yy56, &&yy45, &&yy45,
				&&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45,
				&&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45,
				&&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45,
				&&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45,
				&&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45,
				&&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45,
				&&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45,
				&&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45,
				&&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45,
				&&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45,
				&&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45,
				&&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45,
				&&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45,
				&&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45,
				&&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45,
				&&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45,
				&&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45, &&yy45
			};
			goto *yytarget[yych];
		}
yy45:
		{
		s->errcode = PHP_JSON_ERROR_SYNTAX;
		return PHP_JSON_T_ERROR;
	}
yy46:
		++YYCURSOR;
yy47:
		{
		s->errcode = PHP_JSON_ERROR_UTF8;
		return PHP_JSON_T_ERROR;
	}
yy48:
		yych = *++YYCURSOR;
		if (yych <= 0x7F) goto yy47;
		if (yych <= 0xBF) goto yy42;
		goto yy47;
yy49:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x9F) goto yy47;
		if (yych <= 0xBF) goto yy58;
		goto yy47;
yy50:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x7F) goto yy47;
		if (yych <= 0xBF) goto yy58;
		goto yy47;
yy51:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x7F) goto yy47;
		if (yych <= 0x9F) goto yy58;
		goto yy47;
yy52:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x8F) goto yy47;
		if (yych <= 0xBF) goto yy59;
		goto yy47;
yy53:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x7F) goto yy47;
		if (yych <= 0xBF) goto yy59;
		goto yy47;
yy54:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x7F) goto yy47;
		if (yych <= 0x8F) goto yy59;
		goto yy47;
yy55:
		++YYCURSOR;
		{
		s->str_esc++;
		PHP_JSON_CONDITION_GOTO(STR_P1);
	}
yy56:
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy60, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy61, &&yy61, &&yy61, &&yy62, &&yy61, &&yy61, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy61, &&yy61, &&yy61, &&yy62, &&yy61, &&yy61, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57
			};
			goto *yytarget[yych];
		}
yy57:
		YYCURSOR = YYMARKER;
		if (yyaccept <= 1) {
			if (yyaccept == 0) {
				goto yy45;
			} else {
				goto yy47;
			}
		} else {
			goto yy74;
		}
yy58:
		yych = *++YYCURSOR;
		if (yych <= 0x7F) goto yy57;
		if (yych <= 0xBF) goto yy42;
		goto yy57;
yy59:
		yych = *++YYCURSOR;
		if (yych <= 0x7F) goto yy57;
		if (yych <= 0xBF) goto yy58;
		goto yy57;
yy60:
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy63, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy65, &&yy65, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57
			};
			goto *yytarget[yych];
		}
yy61:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy57;
			if (yych <= '9') goto yy65;
			goto yy57;
		} else {
			if (yych <= 'F') goto yy65;
			if (yych <= '`') goto yy57;
			if (yych <= 'f') goto yy65;
			goto yy57;
		}
yy62:
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
				&&yy66, &&yy66, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy66, &&yy66, &&yy65, &&yy65, &&yy65, &&yy65, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy66, &&yy66, &&yy65, &&yy65, &&yy65, &&yy65, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57
			};
			goto *yytarget[yych];
		}
yy63:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy57;
			if (yych <= '7') goto yy67;
			if (yych <= '9') goto yy68;
			goto yy57;
		} else {
			if (yych <= 'F') goto yy68;
			if (yych <= '`') goto yy57;
			if (yych <= 'f') goto yy68;
			goto yy57;
		}
yy64:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy57;
			if (yych <= '9') goto yy68;
			goto yy57;
		} else {
			if (yych <= 'F') goto yy68;
			if (yych <= '`') goto yy57;
			if (yych <= 'f') goto yy68;
			goto yy57;
		}
yy65:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy57;
			if (yych <= '9') goto yy69;
			goto yy57;
		} else {
			if (yych <= 'F') goto yy69;
			if (yych <= '`') goto yy57;
			if (yych <= 'f') goto yy69;
			goto yy57;
		}
yy66:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy57;
			if (yych <= '9') goto yy70;
			goto yy57;
		} else {
			if (yych <= 'F') goto yy70;
			if (yych <= '`') goto yy57;
			if (yych <= 'f') goto yy70;
			goto yy57;
		}
yy67:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy57;
			if (yych <= '9') goto yy71;
			goto yy57;
		} else {
			if (yych <= 'F') goto yy71;
			if (yych <= '`') goto yy57;
			if (yych <= 'f') goto yy71;
			goto yy57;
		}
yy68:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy57;
			if (yych <= '9') goto yy72;
			goto yy57;
		} else {
			if (yych <= 'F') goto yy72;
			if (yych <= '`') goto yy57;
			if (yych <= 'f') goto yy72;
			goto yy57;
		}
yy69:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy57;
			if (yych <= '9') goto yy73;
			goto yy57;
		} else {
			if (yych <= 'F') goto yy73;
			if (yych <= '`') goto yy57;
			if (yych <= 'f') goto yy73;
			goto yy57;
		}
yy70:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy57;
			if (yych <= '9') goto yy75;
			goto yy57;
		} else {
			if (yych <= 'F') goto yy75;
			if (yych <= '`') goto yy57;
			if (yych <= 'f') goto yy75;
			goto yy57;
		}
yy71:
		++YYCURSOR;
		{
		s->str_esc += 5;
		PHP_JSON_CONDITION_GOTO(STR_P1);
	}
yy72:
		++YYCURSOR;
		{
		s->str_esc += 4;
		PHP_JSON_CONDITION_GOTO(STR_P1);
	}
yy73:
		++YYCURSOR;
yy74:
		{
		s->str_esc += 3;
		PHP_JSON_CONDITION_GOTO(STR_P1);
	}
yy75:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych != '\\') goto yy74;
		yych = *++YYCURSOR;
		if (yych != 'u') goto yy57;
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy76;
		if (yych != 'd') goto yy57;
yy76:
		yych = *++YYCURSOR;
		if (yych <= 'B') goto yy57;
		if (yych <= 'F') goto yy77;
		if (yych <= 'b') goto yy57;
		if (yych >= 'g') goto yy57;
yy77:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy57;
			if (yych >= ':') goto yy57;
		} else {
			if (yych <= 'F') goto yy78;
			if (yych <= '`') goto yy57;
			if (yych >= 'g') goto yy57;
		}
yy78:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy57;
			if (yych >= ':') goto yy57;
		} else {
			if (yych <= 'F') goto yy79;
			if (yych <= '`') goto yy57;
			if (yych >= 'g') goto yy57;
		}
yy79:
		++YYCURSOR;
		{
		s->str_esc += 8;
		PHP_JSON_CONDITION_GOTO(STR_P1);
	}
/* *********************************** */
yyc_STR_P2:
		yych = *YYCURSOR;
		if (yych == '"') goto yy81;
		if (yych == '\\') goto yy82;
		++YYCURSOR;
		{ PHP_JSON_CONDITION_GOTO(STR_P2); }
yy81:
		++YYCURSOR;
		YYSETCONDITION(yycJS);
		{
		PHP_JSON_SCANNER_COPY_ESC();
		return PHP_JSON_T_STRING;
	}
yy82:
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'u') goto yy84;
yy83:
		{
		char esc;
		PHP_JSON_SCANNER_COPY_ESC();
		switch (*s->cursor) {
			case 'b':
				esc = '\b';
				break;
			case 'f':
				esc = '\f';
				break;
			case 'n':
				esc = '\n';
				break;
			case 'r':
				esc = '\r';
				break;
			case 't':
				esc = '\t';
				break;
			case '\\':
			case '/':
			case '"':
				esc = *s->cursor;
				break;
			default:
				s->errcode = PHP_JSON_ERROR_SYNTAX;
				return PHP_JSON_T_ERROR;
		}
		*(s->pstr++) = esc;
		++YYCURSOR;
		s->str_start = s->cursor;
		PHP_JSON_CONDITION_GOTO(STR_P2);
	}
yy84:
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy86, &&yy87, &&yy87, &&yy87, &&yy87, &&yy87, &&yy87, &&yy87,
				&&yy87, &&yy87, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy87, &&yy87, &&yy87, &&yy88, &&yy87, &&yy87, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy87, &&yy87, &&yy87, &&yy88, &&yy87, &&yy87, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85
			};
			goto *yytarget[yych];
		}
yy85:
		YYCURSOR = YYMARKER;
		if (yyaccept == 0) {
			goto yy83;
		} else {
			goto yy100;
		}
yy86:
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy89, &&yy90, &&yy90, &&yy90, &&yy90, &&yy90, &&yy90, &&yy90,
				&&yy91, &&yy91, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy91, &&yy91, &&yy91, &&yy91, &&yy91, &&yy91, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy91, &&yy91, &&yy91, &&yy91, &&yy91, &&yy91, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85
			};
			goto *yytarget[yych];
		}
yy87:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy85;
			if (yych <= '9') goto yy91;
			goto yy85;
		} else {
			if (yych <= 'F') goto yy91;
			if (yych <= '`') goto yy85;
			if (yych <= 'f') goto yy91;
			goto yy85;
		}
yy88:
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy91, &&yy91, &&yy91, &&yy91, &&yy91, &&yy91, &&yy91, &&yy91,
				&&yy92, &&yy92, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy92, &&yy92, &&yy91, &&yy91, &&yy91, &&yy91, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy92, &&yy92, &&yy91, &&yy91, &&yy91, &&yy91, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85
			};
			goto *yytarget[yych];
		}
yy89:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy85;
			if (yych <= '7') goto yy93;
			if (yych <= '9') goto yy94;
			goto yy85;
		} else {
			if (yych <= 'F') goto yy94;
			if (yych <= '`') goto yy85;
			if (yych <= 'f') goto yy94;
			goto yy85;
		}
yy90:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy85;
			if (yych <= '9') goto yy94;
			goto yy85;
		} else {
			if (yych <= 'F') goto yy94;
			if (yych <= '`') goto yy85;
			if (yych <= 'f') goto yy94;
			goto yy85;
		}
yy91:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy85;
			if (yych <= '9') goto yy95;
			goto yy85;
		} else {
			if (yych <= 'F') goto yy95;
			if (yych <= '`') goto yy85;
			if (yych <= 'f') goto yy95;
			goto yy85;
		}
yy92:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy85;
			if (yych <= '9') goto yy96;
			goto yy85;
		} else {
			if (yych <= 'F') goto yy96;
			if (yych <= '`') goto yy85;
			if (yych <= 'f') goto yy96;
			goto yy85;
		}
yy93:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy85;
			if (yych <= '9') goto yy97;
			goto yy85;
		} else {
			if (yych <= 'F') goto yy97;
			if (yych <= '`') goto yy85;
			if (yych <= 'f') goto yy97;
			goto yy85;
		}
yy94:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy85;
			if (yych <= '9') goto yy98;
			goto yy85;
		} else {
			if (yych <= 'F') goto yy98;
			if (yych <= '`') goto yy85;
			if (yych <= 'f') goto yy98;
			goto yy85;
		}
yy95:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy85;
			if (yych <= '9') goto yy99;
			goto yy85;
		} else {
			if (yych <= 'F') goto yy99;
			if (yych <= '`') goto yy85;
			if (yych <= 'f') goto yy99;
			goto yy85;
		}
yy96:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy85;
			if (yych <= '9') goto yy101;
			goto yy85;
		} else {
			if (yych <= 'F') goto yy101;
			if (yych <= '`') goto yy85;
			if (yych <= 'f') goto yy101;
			goto yy85;
		}
yy97:
		++YYCURSOR;
		{
		int utf16 = php_json_ucs2_to_int(s, 2);
		PHP_JSON_SCANNER_COPY_UTF();
		*(s->pstr++) = (char) utf16;
		s->str_start = s->cursor;
		PHP_JSON_CONDITION_GOTO(STR_P2);
	}
yy98:
		++YYCURSOR;
		{
		int utf16 = php_json_ucs2_to_int(s, 3);
		PHP_JSON_SCANNER_COPY_UTF();
		*(s->pstr++) = (char) (0xc0 | (utf16 >> 6));
		*(s->pstr++) = (char) (0x80 | (utf16 & 0x3f));
		s->str_start = s->cursor;
		PHP_JSON_CONDITION_GOTO(STR_P2);
	}
yy99:
		++YYCURSOR;
yy100:
		{
		int utf16 = php_json_ucs2_to_int(s, 4);
		PHP_JSON_SCANNER_COPY_UTF();
		*(s->pstr++) = (char) (0xe0 | (utf16 >> 12));
		*(s->pstr++) = (char) (0x80 | ((utf16 >> 6) & 0x3f));
		*(s->pstr++) = (char) (0x80 | (utf16 & 0x3f));
		s->str_start = s->cursor;
		PHP_JSON_CONDITION_GOTO(STR_P2);
	}
yy101:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych != '\\') goto yy100;
		yych = *++YYCURSOR;
		if (yych != 'u') goto yy85;
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy102;
		if (yych != 'd') goto yy85;
yy102:
		yych = *++YYCURSOR;
		if (yych <= 'B') goto yy85;
		if (yych <= 'F') goto yy103;
		if (yych <= 'b') goto yy85;
		if (yych >= 'g') goto yy85;
yy103:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy85;
			if (yych >= ':') goto yy85;
		} else {
			if (yych <= 'F') goto yy104;
			if (yych <= '`') goto yy85;
			if (yych >= 'g') goto yy85;
		}
yy104:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy85;
			if (yych >= ':') goto yy85;
		} else {
			if (yych <= 'F') goto yy105;
			if (yych <= '`') goto yy85;
			if (yych >= 'g') goto yy85;
		}
yy105:
		++YYCURSOR;
		{
		int utf32, utf16_hi, utf16_lo;
		utf16_hi = php_json_ucs2_to_int(s, 4);
		utf16_lo = php_json_ucs2_to_int_ex(s, 4, 7);
		utf32 = ((utf16_lo & 0x3FF) << 10) + (utf16_hi & 0x3FF) + 0x10000;
		PHP_JSON_SCANNER_COPY_UTF_SP();
		*(s->pstr++) = (char) (0xf0 | (utf32 >> 18));
		*(s->pstr++) = (char) (0x80 | ((utf32 >> 12) & 0x3f));
		*(s->pstr++) = (char) (0x80 | ((utf32 >> 6) & 0x3f));
		*(s->pstr++) = (char) (0x80 | (utf32 & 0x3f));
		s->str_start = s->cursor;
		PHP_JSON_CONDITION_GOTO(STR_P2);
	}
	}


}

real_world/php20150211_json_scanner.re:337:26: warning: unreachable rule in condition 'STR_P1' (shadowed by rules at lines 205, 229, 233, 255, 256) [-Wunreachable-rules]
real_world/php20150211_json_scanner.re:337:26: warning: unreachable rule in condition 'STR_P2' (shadowed by rules at lines 298, 331, 335) [-Wunreachable-rules]
real_world/php20150211_json_scanner.re:100:0: warning: condition numbers may change, use '/*!conditions:re2c*/' directive to generate reliable condition identifiers [-Wcondition-order]
