/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#include <frm_strings.hxx>
#include <property.hxx>

namespace frm
{

//= PropertyInfoService

PropertyInfoService::PropertyMap PropertyInfoService::s_AllKnownProperties;

sal_Int32 PropertyInfoService::getPropertyId(const OUString& _rName)
{
    initialize();

    sal_Int32 nHandle = -1;
    const auto foundProperty = s_AllKnownProperties.find(_rName);
    if (foundProperty != s_AllKnownProperties.end())
        nHandle = foundProperty->second;
    return nHandle;
}


sal_Int32 ConcreteInfoService::getPreferredPropertyId(const OUString& _rName)
{
    return PropertyInfoService::getPropertyId(_rName);
}


void PropertyInfoService::initialize()
{
    if (!s_AllKnownProperties.empty())
        return;

    s_AllKnownProperties.insert({
        { PROPERTY_NAME, PROPERTY_ID_NAME },
        { PROPERTY_TAG, PROPERTY_ID_TAG },
        { PROPERTY_TABINDEX, PROPERTY_ID_TABINDEX },
        { PROPERTY_CLASSID, PROPERTY_ID_CLASSID },
        { PROPERTY_ALIGN, PROPERTY_ID_ALIGN },
        { PROPERTY_FETCHSIZE, PROPERTY_ID_FETCHSIZE },
        { PROPERTY_VALUE, PROPERTY_ID_VALUE },
        { PROPERTY_VALUEMIN, PROPERTY_ID_VALUEMIN },
        { PROPERTY_VALUEMAX, PROPERTY_ID_VALUEMAX },
        { PROPERTY_VALUESTEP, PROPERTY_ID_VALUESTEP },
        { PROPERTY_TEXT, PROPERTY_ID_TEXT },
        { PROPERTY_LABEL, PROPERTY_ID_LABEL },
        { PROPERTY_NAVIGATION, PROPERTY_ID_NAVIGATION },
        { PROPERTY_CYCLE, PROPERTY_ID_CYCLE },
        { PROPERTY_CONTROLSOURCE, PROPERTY_ID_CONTROLSOURCE },
        { PROPERTY_ENABLED, PROPERTY_ID_ENABLED },
        { PROPERTY_ENABLEVISIBLE, PROPERTY_ID_ENABLEVISIBLE },
        { PROPERTY_SPIN, PROPERTY_ID_SPIN },
        { PROPERTY_READONLY, PROPERTY_ID_READONLY },
        { PROPERTY_FILTER, PROPERTY_ID_FILTER },
        { PROPERTY_WIDTH, PROPERTY_ID_WIDTH },
        { PROPERTY_SEARCHABLE, PROPERTY_ID_SEARCHABLE },
        { PROPERTY_MULTILINE, PROPERTY_ID_MULTILINE },
        { PROPERTY_TARGET_URL, PROPERTY_ID_TARGET_URL },
        { PROPERTY_DEFAULTCONTROL, PROPERTY_ID_DEFAULTCONTROL },
        { PROPERTY_MAXTEXTLEN, PROPERTY_ID_MAXTEXTLEN },
        { PROPERTY_SIZE, PROPERTY_ID_SIZE },
        { PROPERTY_DATE, PROPERTY_ID_DATE },
        { PROPERTY_TIME, PROPERTY_ID_TIME },
        { PROPERTY_STATE, PROPERTY_ID_STATE },
        { PROPERTY_TRISTATE, PROPERTY_ID_TRISTATE },
        { PROPERTY_HIDDEN_VALUE, PROPERTY_ID_HIDDEN_VALUE },
        { PROPERTY_TARGET_FRAME, PROPERTY_ID_TARGET_FRAME },
        { PROPERTY_BUTTONTYPE, PROPERTY_ID_BUTTONTYPE },
        { PROPERTY_STRINGITEMLIST, PROPERTY_ID_STRINGITEMLIST },
        { PROPERTY_TYPEDITEMLIST, PROPERTY_ID_TYPEDITEMLIST },
        { PROPERTY_DEFAULT_TEXT, PROPERTY_ID_DEFAULT_TEXT },
        { PROPERTY_DEFAULT_STATE, PROPERTY_ID_DEFAULT_STATE },
        { PROPERTY_DEFAULT_DATE, PROPERTY_ID_DEFAULT_DATE },
        { PROPERTY_DEFAULT_TIME, PROPERTY_ID_DEFAULT_TIME },
        { PROPERTY_DEFAULT_VALUE, PROPERTY_ID_DEFAULT_VALUE },
        { PROPERTY_FORMATKEY, PROPERTY_ID_FORMATKEY },
        { PROPERTY_FORMATSSUPPLIER, PROPERTY_ID_FORMATSSUPPLIER },
        { PROPERTY_SUBMIT_ACTION, PROPERTY_ID_SUBMIT_ACTION },
        { PROPERTY_SUBMIT_TARGET, PROPERTY_ID_SUBMIT_TARGET },
        { PROPERTY_SUBMIT_METHOD, PROPERTY_ID_SUBMIT_METHOD },
        { PROPERTY_SUBMIT_ENCODING, PROPERTY_ID_SUBMIT_ENCODING },
        { PROPERTY_IMAGE_URL, PROPERTY_ID_IMAGE_URL },
        { PROPERTY_GRAPHIC, PROPERTY_ID_GRAPHIC },
        { PROPERTY_EMPTY_IS_NULL, PROPERTY_ID_EMPTY_IS_NULL },
        { PROPERTY_LISTSOURCETYPE, PROPERTY_ID_LISTSOURCETYPE },
        { PROPERTY_LISTSOURCE, PROPERTY_ID_LISTSOURCE },
        { PROPERTY_SELECT_SEQ, PROPERTY_ID_SELECT_SEQ },
        { PROPERTY_VALUE_SEQ, PROPERTY_ID_VALUE_SEQ },
        { PROPERTY_SELECT_VALUE, PROPERTY_ID_SELECT_VALUE },
        { PROPERTY_SELECT_VALUE_SEQ, PROPERTY_ID_SELECT_VALUE_SEQ },
        { PROPERTY_DEFAULT_SELECT_SEQ, PROPERTY_ID_DEFAULT_SELECT_SEQ },
        { PROPERTY_MULTISELECTION, PROPERTY_ID_MULTISELECTION },
        { PROPERTY_DECIMAL_ACCURACY, PROPERTY_ID_DECIMAL_ACCURACY },
        { PROPERTY_EDITMASK, PROPERTY_ID_EDITMASK },
        { PROPERTY_ISREADONLY, PROPERTY_ID_ISREADONLY },
        { PROPERTY_FIELDTYPE, PROPERTY_ID_FIELDTYPE },
        { PROPERTY_DECIMALS, PROPERTY_ID_DECIMALS },
        { PROPERTY_REFVALUE, PROPERTY_ID_REFVALUE },
        { PROPERTY_STRICTFORMAT, PROPERTY_ID_STRICTFORMAT },
        { PROPERTY_DATASOURCE, PROPERTY_ID_DATASOURCE },
        { PROPERTY_ALLOWADDITIONS, PROPERTY_ID_ALLOWADDITIONS },
        { PROPERTY_ALLOWEDITS, PROPERTY_ID_ALLOWEDITS },
        { PROPERTY_ALLOWDELETIONS, PROPERTY_ID_ALLOWDELETIONS },
        { PROPERTY_MASTERFIELDS, PROPERTY_ID_MASTERFIELDS },
        { PROPERTY_ISPASSTHROUGH, PROPERTY_ID_ISPASSTHROUGH },
        { PROPERTY_QUERY, PROPERTY_ID_QUERY },
        { PROPERTY_LITERALMASK, PROPERTY_ID_LITERALMASK },
        { PROPERTY_SHOWTHOUSANDSEP, PROPERTY_ID_SHOWTHOUSANDSEP },
        { PROPERTY_CURRENCYSYMBOL, PROPERTY_ID_CURRENCYSYMBOL },
        { PROPERTY_DATEFORMAT, PROPERTY_ID_DATEFORMAT },
        { PROPERTY_DATEMIN, PROPERTY_ID_DATEMIN },
        { PROPERTY_DATEMAX, PROPERTY_ID_DATEMAX },
        { PROPERTY_DATE_SHOW_CENTURY, PROPERTY_ID_DATE_SHOW_CENTURY },
        { PROPERTY_TIMEFORMAT, PROPERTY_ID_TIMEFORMAT },
        { PROPERTY_TIMEMIN, PROPERTY_ID_TIMEMIN },
        { PROPERTY_TIMEMAX, PROPERTY_ID_TIMEMAX },
        { PROPERTY_LINECOUNT, PROPERTY_ID_LINECOUNT },
        { PROPERTY_BOUNDCOLUMN, PROPERTY_ID_BOUNDCOLUMN },
        { PROPERTY_HASNAVIGATION, PROPERTY_ID_HASNAVIGATION },
        { PROPERTY_FONT, PROPERTY_ID_FONT },
        { PROPERTY_BACKGROUNDCOLOR, PROPERTY_ID_BACKGROUNDCOLOR },
        { PROPERTY_FILLCOLOR, PROPERTY_ID_FILLCOLOR },
        { PROPERTY_TEXTCOLOR, PROPERTY_ID_TEXTCOLOR },
        { PROPERTY_LINECOLOR, PROPERTY_ID_LINECOLOR },
        { PROPERTY_BORDER, PROPERTY_ID_BORDER },
        { PROPERTY_DROPDOWN, PROPERTY_ID_DROPDOWN },
        { PROPERTY_HSCROLL, PROPERTY_ID_HSCROLL },
        { PROPERTY_VSCROLL, PROPERTY_ID_VSCROLL },
        { PROPERTY_TABSTOP, PROPERTY_ID_TABSTOP },
        { PROPERTY_AUTOCOMPLETE, PROPERTY_ID_AUTOCOMPLETE },
        { PROPERTY_HARDLINEBREAKS, PROPERTY_ID_HARDLINEBREAKS },
        { PROPERTY_PRINTABLE, PROPERTY_ID_PRINTABLE },
        { PROPERTY_ECHO_CHAR, PROPERTY_ID_ECHO_CHAR },
        { PROPERTY_ROWHEIGHT, PROPERTY_ID_ROWHEIGHT },
        { PROPERTY_HELPTEXT, PROPERTY_ID_HELPTEXT },
        { PROPERTY_FONT_NAME, PROPERTY_ID_FONT_NAME },
        { PROPERTY_FONT_STYLENAME, PROPERTY_ID_FONT_STYLENAME },
        { PROPERTY_FONT_FAMILY, PROPERTY_ID_FONT_FAMILY },
        { PROPERTY_FONT_CHARSET, PROPERTY_ID_FONT_CHARSET },
        { PROPERTY_FONT_HEIGHT, PROPERTY_ID_FONT_HEIGHT },
        { PROPERTY_FONT_WEIGHT, PROPERTY_ID_FONT_WEIGHT },
        { PROPERTY_FONT_SLANT, PROPERTY_ID_FONT_SLANT },
        { PROPERTY_FONT_UNDERLINE, PROPERTY_ID_FONT_UNDERLINE },
        { PROPERTY_FONT_WORDLINEMODE, PROPERTY_ID_FONT_WORDLINEMODE },
        { PROPERTY_FONT_STRIKEOUT, PROPERTY_ID_FONT_STRIKEOUT },
        { PROPERTY_TEXTLINECOLOR, PROPERTY_ID_TEXTLINECOLOR },
        { PROPERTY_FONTEMPHASISMARK, PROPERTY_ID_FONTEMPHASISMARK },
        { PROPERTY_FONTRELIEF, PROPERTY_ID_FONTRELIEF },
        { PROPERTY_HELPURL, PROPERTY_ID_HELPURL },
        { PROPERTY_RECORDMARKER, PROPERTY_ID_RECORDMARKER },
        { PROPERTY_BOUNDFIELD, PROPERTY_ID_BOUNDFIELD },
        { PROPERTY_INPUT_REQUIRED, PROPERTY_ID_INPUT_REQUIRED },
        { PROPERTY_TREATASNUMERIC, PROPERTY_ID_TREATASNUMERIC },
        { PROPERTY_EFFECTIVE_VALUE, PROPERTY_ID_EFFECTIVE_VALUE },
        { PROPERTY_EFFECTIVE_DEFAULT, PROPERTY_ID_EFFECTIVE_DEFAULT },
        { PROPERTY_EFFECTIVE_MIN, PROPERTY_ID_EFFECTIVE_MIN },
        { PROPERTY_EFFECTIVE_MAX, PROPERTY_ID_EFFECTIVE_MAX },
        { PROPERTY_HIDDEN, PROPERTY_ID_HIDDEN },
        { PROPERTY_FILTERPROPOSAL, PROPERTY_ID_FILTERPROPOSAL },
        { PROPERTY_FIELDSOURCE, PROPERTY_ID_FIELDSOURCE },
        { PROPERTY_TABLENAME, PROPERTY_ID_TABLENAME },
        { PROPERTY_CONTROLLABEL, PROPERTY_ID_CONTROLLABEL },
        { PROPERTY_CURRSYM_POSITION, PROPERTY_ID_CURRSYM_POSITION },
        { PROPERTY_CURSORCOLOR, PROPERTY_ID_CURSORCOLOR },
        { PROPERTY_ALWAYSSHOWCURSOR, PROPERTY_ID_ALWAYSSHOWCURSOR },
        { PROPERTY_DISPLAYSYNCHRON, PROPERTY_ID_DISPLAYSYNCHRON },
        { PROPERTY_ISMODIFIED, PROPERTY_ID_ISMODIFIED },
        { PROPERTY_ISNEW, PROPERTY_ID_ISNEW },
        { PROPERTY_PRIVILEGES, PROPERTY_ID_PRIVILEGES },
        { PROPERTY_DETAILFIELDS, PROPERTY_ID_DETAILFIELDS },
        { PROPERTY_COMMAND, PROPERTY_ID_COMMAND },
        { PROPERTY_COMMANDTYPE, PROPERTY_ID_COMMANDTYPE },
        { PROPERTY_RESULTSET_CONCURRENCY, PROPERTY_ID_RESULTSET_CONCURRENCY },
        { PROPERTY_INSERTONLY, PROPERTY_ID_INSERTONLY },
        { PROPERTY_RESULTSET_TYPE, PROPERTY_ID_RESULTSET_TYPE },
        { PROPERTY_ESCAPE_PROCESSING, PROPERTY_ID_ESCAPE_PROCESSING },
        { PROPERTY_APPLYFILTER, PROPERTY_ID_APPLYFILTER },
        { PROPERTY_ISNULLABLE, PROPERTY_ID_ISNULLABLE },
        { PROPERTY_ACTIVECOMMAND, PROPERTY_ID_ACTIVECOMMAND },
        { PROPERTY_ISCURRENCY, PROPERTY_ID_ISCURRENCY },
        { PROPERTY_URL, PROPERTY_ID_URL },
        { PROPERTY_TITLE, PROPERTY_ID_TITLE },
        { PROPERTY_ACTIVE_CONNECTION, PROPERTY_ID_ACTIVE_CONNECTION },
        { PROPERTY_SCALE, PROPERTY_ID_SCALE },
        { PROPERTY_SORT, PROPERTY_ID_SORT },
        { PROPERTY_PERSISTENCE_MAXTEXTLENGTH, PROPERTY_ID_PERSISTENCE_MAXTEXTLENGTH },
        { PROPERTY_SCROLL_VALUE, PROPERTY_ID_SCROLL_VALUE },
        { PROPERTY_SPIN_VALUE, PROPERTY_ID_SPIN_VALUE },
        { PROPERTY_DEFAULT_SCROLL_VALUE, PROPERTY_ID_DEFAULT_SCROLL_VALUE },
        { PROPERTY_DEFAULT_SPIN_VALUE, PROPERTY_ID_DEFAULT_SPIN_VALUE },
        { PROPERTY_WRITING_MODE , PROPERTY_ID_WRITING_MODE  },
        { PROPERTY_CONTEXT_WRITING_MODE , PROPERTY_ID_CONTEXT_WRITING_MODE  },
        { PROPERTY_GENERATEVBAEVENTS , PROPERTY_ID_GENERATEVBAEVENTS  }
    });
}


}
//... namespace frm .......................................................

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
