; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=armv7-apple-darwin -mcpu=cortex-a8 | FileCheck %s
; Check if the f32 load / store pair are optimized to i32 load / store.
; rdar://8944252

define void @t(i32 %width, ptr nocapture %src, ptr nocapture %dst, i32 %index) nounwind {
; CHECK-LABEL: t:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    cmp r0, #0
; CHECK-NEXT:    bxeq lr
; CHECK-NEXT:  LBB0_1: @ %bb
; CHECK-NEXT:    @ =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    ldr r9, [r1], r3
; CHECK-NEXT:    subs r0, r0, #1
; CHECK-NEXT:    str r9, [r2], #4
; CHECK-NEXT:    bne LBB0_1
; CHECK-NEXT:  @ %bb.2: @ %return
; CHECK-NEXT:    bx lr
entry:
  %0 = icmp eq i32 %width, 0
  br i1 %0, label %return, label %bb

bb:
  %j.05 = phi i32 [ %2, %bb ], [ 0, %entry ]
  %tmp = mul i32 %j.05, %index
  %uglygep = getelementptr i8, ptr %src, i32 %tmp
  %dst_addr.03 = getelementptr float, ptr %dst, i32 %j.05
  %1 = load float, ptr %uglygep, align 4
  store float %1, ptr %dst_addr.03, align 4
  %2 = add i32 %j.05, 1
  %exitcond = icmp eq i32 %2, %width
  br i1 %exitcond, label %return, label %bb

return:
  ret void
}

@a1 = local_unnamed_addr global float 0.000000e+00, align 4
@a2 = local_unnamed_addr global float 0.000000e+00, align 4
@a3 = local_unnamed_addr global float 0.000000e+00, align 4
@a4 = local_unnamed_addr global float 0.000000e+00, align 4
@a5 = local_unnamed_addr global float 0.000000e+00, align 4
@a6 = local_unnamed_addr global float 0.000000e+00, align 4
@a7 = local_unnamed_addr global float 0.000000e+00, align 4
@a8 = local_unnamed_addr global float 0.000000e+00, align 4


declare void @_Z3fooddddddddddddddd(float, float, float, float, float, float, float, float)

; Because this test function is trying to pass float argument by stack,
; it can be optimized to i32 load / store
define signext i32 @test() {
%1 = load float, ptr @a1, align 4
%2 = load float, ptr @a2, align 4
%3 = load float, ptr @a3, align 4
%4 = load float, ptr @a4, align 4
%5 = load float, ptr @a5, align 4
%6 = load float, ptr @a6, align 4
%7 = load float, ptr @a7, align 4
%8 = load float, ptr @a8, align 4
tail call void @_Z3fooddddddddddddddd(float %1, float %2, float %3, float %4, float %5, float %6, float %7, float %8)
ret i32 0
}

; CHECK-LABEL: _test:
; CHECK: ldr r3, [pc, r3]
; CHECK: ldr r2, [pc, r2]
; CHECK: ldr r1, [pc, r1]
; CHECK: ldr r0, [pc, r0]
; CHECK: ldr r9, [pc, r9]
; CHECK: ldr r12, [pc, r12]
; CHECK: ldr lr, [pc, lr]
; CHECK: stm sp, {r9, r12, lr}
; CHECK: ldr r4, [pc, r4]
; CHECK: str r4, [sp, #12]
; CHECK: bl __Z3fooddddddddddddddd
