/***************************************************************************
    Copyright 2009-2010 Frederik Gladhorn <gladhorn@kde.org>
    Copyright 2009-2010 Daniel Laidig <laidig@kde.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PRACTICE_WRITTENPRACTICEWIDGET_H
#define PRACTICE_WRITTENPRACTICEWIDGET_H

#include "abstractwidget.h"

namespace Ui
{
class WrittenPracticeWidget;
}

namespace Practice
{
class LatexRenderer;

class WrittenPracticeWidget : public Practice::AbstractModeWidget
{
    Q_OBJECT

public:
    WrittenPracticeWidget(GuiFrontend *frontend, QWidget *parent = 0, bool isExampleSentenceMode = false);
    virtual QVariant userInput();

    virtual void setQuestion(const QVariant& question);
    virtual void setSolution(const QVariant& solution);

    virtual void setQuestionFont(const QFont& font);
    virtual void setSolutionFont(const QFont& font);
    virtual void setHint(const QVariant& hint);
    virtual void setFeedback(const QVariant& feedback);
    virtual void setFeedbackState(AbstractFrontend::ResultState feedbackState);
    virtual void setResultState(AbstractFrontend::ResultState resultState);

    virtual void setQuestionSound(const KUrl& soundUrl);
    virtual void setSolutionSound(const KUrl& soundUrl);
    virtual void setSolutionPronunciation(const QString& pronunciationText);
    virtual void setQuestionPronunciation(const QString& pronunciationText);

    virtual void setSynonym(const QString& entry);

public slots:
    /** To be called prior to focus change during deletion
        to switch focus away from the KLineEdit answer area
        and prevent a crash.

        @ref bug332596

        @todo When frameworks/kde5 is implemented remove this code
        , if the bug in Qt (returning a pointer to a deleted stylesheet) is fixed.
     */
    virtual void objectDestroyed(QObject *);

    void showQuestion();
    void showSolution();
    void continueClicked();
    void showSynonym();

protected:
    Ui::WrittenPracticeWidget* m_ui;

private:
    QString m_solution;
    QString m_synonym;
    AbstractFrontend::ResultState m_resultState;
    AbstractFrontend::ResultState m_feedbackState;
    QList<QWidget*> synonymWidgets;
    LatexRenderer *m_latexRenderer;
    bool isExampleSentenceMode;
};

}

#endif // PRACTICE_WRITTENPRACTICEWIDGET_H
