/* Stock icons, buttons, and menu items.
   Copyright (C) 1997, 1998 Free Software Foundation
   All rights reserved.

   The Mate Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The Mate Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the Mate Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Author: Eckehard Berns
*/
/*
  @NOTATION@
*/

#ifndef __MATE_STOCK_ICONS_H__
#define __MATE_STOCK_ICONS_H__

#include <glib.h>
#include <gtk/gtk.h>

#ifdef __cplusplus
extern "C" {
#endif

#define MATE_STOCK_TIMER "mate-stock-timer"
#define MATE_STOCK_TIMER_STOP "mate-stock-timer-stop"
#define MATE_STOCK_TRASH "mate-stock-trash"
#define MATE_STOCK_TRASH_FULL "mate-stock-trash-full"

#define MATE_STOCK_SCORES "mate-stock-scores"
#define MATE_STOCK_ABOUT "mate-stock-about"
#define MATE_STOCK_BLANK "mate-stock-blank"

#define MATE_STOCK_VOLUME "mate-stock-volume"
#define MATE_STOCK_MIDI "mate-stock-midi"
#define MATE_STOCK_MIC "mate-stock-mic"
#define MATE_STOCK_LINE_IN "mate-stock-line-in"

#define MATE_STOCK_MAIL "mate-stock-mail"
#define MATE_STOCK_MAIL_RCV "mate-stock-mail-rcv"
#define MATE_STOCK_MAIL_SND "mate-stock-mail-snd"
#define MATE_STOCK_MAIL_RPL "mate-stock-mail-rpl"
#define MATE_STOCK_MAIL_FWD "mate-stock-mail-fwd"
#define MATE_STOCK_MAIL_NEW "mate-stock-mail-new"
#define MATE_STOCK_ATTACH "mate-stock-attach"

#define MATE_STOCK_BOOK_RED "mate-stock-book-red"
#define MATE_STOCK_BOOK_GREEN "mate-stock-book-green"
#define MATE_STOCK_BOOK_BLUE "mate-stock-book-blue"
#define MATE_STOCK_BOOK_YELLOW "mate-stock-book-yellow"
#define MATE_STOCK_BOOK_OPEN "mate-stock-book-open"

#define MATE_STOCK_MULTIPLE_FILE "mate-stock-multiple-file"
#define MATE_STOCK_NOT "mate-stock-not"

#define MATE_STOCK_TABLE_BORDERS "mate-stock-table-borders"
#define MATE_STOCK_TABLE_FILL "mate-stock-table-fill"

#define MATE_STOCK_TEXT_INDENT "mate-stock-text-indent"
#define MATE_STOCK_TEXT_UNINDENT "mate-stock-text-unindent"
#define MATE_STOCK_TEXT_BULLETED_LIST "mate-stock-text-bulleted-list"
#define MATE_STOCK_TEXT_NUMBERED_LIST "mate-stock-text-numbered-list"

#define MATE_STOCK_AUTHENTICATION "mate-stock-authentication"

/* And now for some deprecated items, you should use the GTK_STOCK_
 * equivalents for these.  Note that the BUTTON ones are now defined
 * in mate-dialog.h and also deprecated in favour of the GTK_STOCK_
 * ones */

#ifndef MATE_DISABLE_DEPRECATED

#define MATE_STOCK_PIXMAP_NEW         GTK_STOCK_NEW
#define MATE_STOCK_PIXMAP_OPEN        GTK_STOCK_OPEN
#define MATE_STOCK_PIXMAP_CLOSE       GTK_STOCK_CLOSE
#define MATE_STOCK_PIXMAP_REVERT      GTK_STOCK_REVERT_TO_SAVED
#define MATE_STOCK_PIXMAP_SAVE        GTK_STOCK_SAVE
#define MATE_STOCK_PIXMAP_SAVE_AS     GTK_STOCK_SAVE_AS
#define MATE_STOCK_PIXMAP_CUT         GTK_STOCK_CUT
#define MATE_STOCK_PIXMAP_COPY        GTK_STOCK_COPY
#define MATE_STOCK_PIXMAP_PASTE       GTK_STOCK_PASTE
#define MATE_STOCK_PIXMAP_CLEAR       GTK_STOCK_CLEAR
#define MATE_STOCK_PIXMAP_PROPERTIES  GTK_STOCK_PROPERTIES
#define MATE_STOCK_PIXMAP_PREFERENCES GTK_STOCK_PREFERENCES
#define MATE_STOCK_PIXMAP_HELP        GTK_STOCK_HELP
#define MATE_STOCK_PIXMAP_SCORES      MATE_STOCK_SCORES
#define MATE_STOCK_PIXMAP_PRINT       GTK_STOCK_PRINT
#define MATE_STOCK_PIXMAP_SEARCH      GTK_STOCK_FIND
#define MATE_STOCK_PIXMAP_SRCHRPL     GTK_STOCK_FIND_AND_REPLACE
#define MATE_STOCK_PIXMAP_BACK        GTK_STOCK_GO_BACK
#define MATE_STOCK_PIXMAP_FORWARD     GTK_STOCK_GO_FORWARD
#define MATE_STOCK_PIXMAP_FIRST       GTK_STOCK_GOTO_FIRST
#define MATE_STOCK_PIXMAP_LAST        GTK_STOCK_GOTO_LAST
#define MATE_STOCK_PIXMAP_HOME        GTK_STOCK_HOME
#define MATE_STOCK_PIXMAP_STOP        GTK_STOCK_STOP
#define MATE_STOCK_PIXMAP_REFRESH     GTK_STOCK_REFRESH
#define MATE_STOCK_PIXMAP_UNDO        GTK_STOCK_UNDO
#define MATE_STOCK_PIXMAP_REDO        GTK_STOCK_REDO
#define MATE_STOCK_PIXMAP_TIMER       MATE_STOCK_TIMER
#define MATE_STOCK_PIXMAP_TIMER_STOP  MATE_STOCK_TIMER_STOP
#define MATE_STOCK_PIXMAP_MAIL	       MATE_STOCK_MAIL
#define MATE_STOCK_PIXMAP_MAIL_RCV    MATE_STOCK_MAIL_RCV
#define MATE_STOCK_PIXMAP_MAIL_SND    MATE_STOCK_MAIL_SND
#define MATE_STOCK_PIXMAP_MAIL_RPL    MATE_STOCK_MAIL_RPL
#define MATE_STOCK_PIXMAP_MAIL_FWD    MATE_STOCK_MAIL_FWD
#define MATE_STOCK_PIXMAP_MAIL_NEW    MATE_STOCK_MAIL_NEW
#define MATE_STOCK_PIXMAP_TRASH       MATE_STOCK_TRASH
#define MATE_STOCK_PIXMAP_TRASH_FULL  MATE_STOCK_TRASH_FULL
#define MATE_STOCK_PIXMAP_UNDELETE    GTK_STOCK_UNDELETE
#define MATE_STOCK_PIXMAP_SPELLCHECK  GTK_STOCK_SPELL_CHECK
#define MATE_STOCK_PIXMAP_MIC         MATE_STOCK_MIC
#define MATE_STOCK_PIXMAP_LINE_IN     MATE_STOCK_LINE_IN
#define MATE_STOCK_PIXMAP_CDROM       GTK_STOCK_CDROM
#define MATE_STOCK_PIXMAP_VOLUME      MATE_STOCK_VOLUME
#define MATE_STOCK_PIXMAP_MIDI        MATE_STOCK_MIDI
#define MATE_STOCK_PIXMAP_BOOK_RED    MATE_STOCK_BOOK_RED
#define MATE_STOCK_PIXMAP_BOOK_GREEN  MATE_STOCK_BOOK_GREEN
#define MATE_STOCK_PIXMAP_BOOK_BLUE   MATE_STOCK_BOOK_BLUE
#define MATE_STOCK_PIXMAP_BOOK_YELLOW MATE_STOCK_BOOK_YELLOW
#define MATE_STOCK_PIXMAP_BOOK_OPEN   MATE_STOCK_BOOK_OPEN
#define MATE_STOCK_PIXMAP_ABOUT       MATE_STOCK_ABOUT
#define MATE_STOCK_PIXMAP_QUIT        GTK_STOCK_QUIT
#define MATE_STOCK_PIXMAP_MULTIPLE    MATE_STOCK_MULTIPLE_FILE
#define MATE_STOCK_PIXMAP_NOT         MATE_STOCK_NOT
#define MATE_STOCK_PIXMAP_CONVERT     GTK_STOCK_CONVERT
#define MATE_STOCK_PIXMAP_JUMP_TO     GTK_STOCK_JUMP_TO
#define MATE_STOCK_PIXMAP_UP          GTK_STOCK_GO_UP
#define MATE_STOCK_PIXMAP_DOWN        GTK_STOCK_GO_DOWN
#define MATE_STOCK_PIXMAP_TOP         GTK_STOCK_GOTO_TOP
#define MATE_STOCK_PIXMAP_BOTTOM      GTK_STOCK_GOTO_BOTTOM
#define MATE_STOCK_PIXMAP_ATTACH      MATE_STOCK_ATTACH
#define MATE_STOCK_PIXMAP_INDEX       GTK_STOCK_INDEX
#define MATE_STOCK_PIXMAP_FONT        GTK_STOCK_SELECT_FONT
#define MATE_STOCK_PIXMAP_EXEC        GTK_STOCK_EXECUTE

#define MATE_STOCK_PIXMAP_ALIGN_LEFT    GTK_STOCK_JUSTIFY_LEFT
#define MATE_STOCK_PIXMAP_ALIGN_RIGHT   GTK_STOCK_JUSTIFY_RIGHT
#define MATE_STOCK_PIXMAP_ALIGN_CENTER  GTK_STOCK_JUSTIFY_CENTER
#define MATE_STOCK_PIXMAP_ALIGN_JUSTIFY GTK_STOCK_JUSTIFY_FILL

#define MATE_STOCK_PIXMAP_TEXT_BOLD      GTK_STOCK_BOLD
#define MATE_STOCK_PIXMAP_TEXT_ITALIC    GTK_STOCK_ITALIC
#define MATE_STOCK_PIXMAP_TEXT_UNDERLINE GTK_STOCK_UNDERLINE
#define MATE_STOCK_PIXMAP_TEXT_STRIKEOUT GTK_STOCK_STRIKETHROUGH

#define MATE_STOCK_PIXMAP_TEXT_INDENT    MATE_STOCK_TEXT_INDENT
#define MATE_STOCK_PIXMAP_TEXT_UNINDENT  MATE_STOCK_TEXT_UNINDENT

#define MATE_STOCK_PIXMAP_EXIT        MATE_STOCK_PIXMAP_QUIT

#define MATE_STOCK_PIXMAP_COLORSELECTOR GTK_STOCK_SELECT_COLOR

#define MATE_STOCK_PIXMAP_ADD    GTK_STOCK_ADD
#define MATE_STOCK_PIXMAP_REMOVE GTK_STOCK_REMOVE

#define MATE_STOCK_PIXMAP_TABLE_BORDERS MATE_STOCK_TABLE_BORDERS
#define MATE_STOCK_PIXMAP_TABLE_FILL MATE_STOCK_TABLE_FILL

#define MATE_STOCK_PIXMAP_TEXT_BULLETED_LIST MATE_STOCK_TEXT_BULLETED_LIST
#define MATE_STOCK_PIXMAP_TEXT_NUMBERED_LIST MATE_STOCK_TEXT_NUMBERED_LIST

/*  menus  */

#define MATE_STOCK_MENU_BLANK        MATE_STOCK_BLANK
#define MATE_STOCK_MENU_NEW          GTK_STOCK_NEW
#define MATE_STOCK_MENU_SAVE         GTK_STOCK_SAVE
#define MATE_STOCK_MENU_SAVE_AS      GTK_STOCK_SAVE_AS
#define MATE_STOCK_MENU_REVERT       GTK_STOCK_REVERT_TO_SAVED
#define MATE_STOCK_MENU_OPEN         GTK_STOCK_OPEN
#define MATE_STOCK_MENU_CLOSE        GTK_STOCK_CLOSE
#define MATE_STOCK_MENU_QUIT         GTK_STOCK_QUIT
#define MATE_STOCK_MENU_CUT          GTK_STOCK_CUT
#define MATE_STOCK_MENU_COPY         GTK_STOCK_COPY
#define MATE_STOCK_MENU_PASTE        GTK_STOCK_PASTE
#define MATE_STOCK_MENU_PROP         GTK_STOCK_PROPERTIES
#define MATE_STOCK_MENU_PREF         GTK_STOCK_PREFERENCES
#define MATE_STOCK_MENU_ABOUT        MATE_STOCK_ABOUT
#define MATE_STOCK_MENU_SCORES       MATE_STOCK_SCORES
#define MATE_STOCK_MENU_UNDO         GTK_STOCK_UNDO
#define MATE_STOCK_MENU_REDO         GTK_STOCK_REDO
#define MATE_STOCK_MENU_PRINT        GTK_STOCK_PRINT
#define MATE_STOCK_MENU_SEARCH       GTK_STOCK_FIND
#define MATE_STOCK_MENU_SRCHRPL      GTK_STOCK_FIND_AND_REPLACE
#define MATE_STOCK_MENU_BACK         GTK_STOCK_GO_BACK
#define MATE_STOCK_MENU_FORWARD      GTK_STOCK_GO_FORWARD
#define MATE_STOCK_MENU_FIRST        GTK_STOCK_GOTO_FIRST
#define MATE_STOCK_MENU_LAST         GTK_STOCK_GOTO_LAST
#define MATE_STOCK_MENU_HOME         GTK_STOCK_HOME
#define MATE_STOCK_MENU_STOP         GTK_STOCK_STOP
#define MATE_STOCK_MENU_REFRESH      GTK_STOCK_REFRESH
#define MATE_STOCK_MENU_MAIL         MATE_STOCK_MAIL
#define MATE_STOCK_MENU_MAIL_RCV     MATE_STOCK_MAIL_RCV
#define MATE_STOCK_MENU_MAIL_SND     MATE_STOCK_MAIL_SND
#define MATE_STOCK_MENU_MAIL_RPL     MATE_STOCK_MAIL_RPL
#define MATE_STOCK_MENU_MAIL_FWD     MATE_STOCK_MAIL_FWD
#define MATE_STOCK_MENU_MAIL_NEW     MATE_STOCK_MAIL_NEW
#define MATE_STOCK_MENU_TRASH        MATE_STOCK_TRASH
#define MATE_STOCK_MENU_TRASH_FULL   MATE_STOCK_TRASH_FULL
#define MATE_STOCK_MENU_UNDELETE     GTK_STOCK_UNDELETE
#define MATE_STOCK_MENU_TIMER        MATE_STOCK_TIMER
#define MATE_STOCK_MENU_TIMER_STOP   MATE_STOCK_TIMER_STOP
#define MATE_STOCK_MENU_SPELLCHECK   GTK_STOCK_SPELL_CHECK
#define MATE_STOCK_MENU_MIC          MATE_STOCK_MIC
#define MATE_STOCK_MENU_LINE_IN      MATE_STOCK_LINE_IN
#define MATE_STOCK_MENU_CDROM	      GTK_STOCK_CDROM
#define MATE_STOCK_MENU_VOLUME       MATE_STOCK_VOLUME
#define MATE_STOCK_MENU_MIDI         MATE_STOCK_MIDI
#define MATE_STOCK_MENU_BOOK_RED     MATE_STOCK_BOOK_RED
#define MATE_STOCK_MENU_BOOK_GREEN   MATE_STOCK_BOOK_GREEN
#define MATE_STOCK_MENU_BOOK_BLUE    MATE_STOCK_BOOK_BLUE
#define MATE_STOCK_MENU_BOOK_YELLOW  MATE_STOCK_BOOK_YELLOW
#define MATE_STOCK_MENU_BOOK_OPEN    MATE_STOCK_BOOK_OPEN
#define MATE_STOCK_MENU_CONVERT      GTK_STOCK_CONVERT
#define MATE_STOCK_MENU_JUMP_TO      GTK_STOCK_JUMP_TO
#define MATE_STOCK_MENU_UP           GTK_STOCK_GO_UP
#define MATE_STOCK_MENU_DOWN         GTK_STOCK_GO_DOWN
#define MATE_STOCK_MENU_TOP          GTK_STOCK_GOTO_TOP
#define MATE_STOCK_MENU_BOTTOM       GTK_STOCK_GOTO_BOTTOM
#define MATE_STOCK_MENU_ATTACH       MATE_STOCK_ATTACH
#define MATE_STOCK_MENU_INDEX        GTK_STOCK_INDEX
#define MATE_STOCK_MENU_FONT         GTK_STOCK_SELECT_FONT
#define MATE_STOCK_MENU_EXEC         GTK_STOCK_EXECUTE

#define MATE_STOCK_MENU_ALIGN_LEFT     GTK_STOCK_JUSTIFY_LEFT
#define MATE_STOCK_MENU_ALIGN_RIGHT    GTK_STOCK_JUSTIFY_RIGHT
#define MATE_STOCK_MENU_ALIGN_CENTER   GTK_STOCK_JUSTIFY_CENTER
#define MATE_STOCK_MENU_ALIGN_JUSTIFY  GTK_STOCK_JUSTIFY_FILL

#define MATE_STOCK_MENU_TEXT_BOLD      GTK_STOCK_BOLD
#define MATE_STOCK_MENU_TEXT_ITALIC    GTK_STOCK_ITALIC
#define MATE_STOCK_MENU_TEXT_UNDERLINE GTK_STOCK_UNDERLINE
#define MATE_STOCK_MENU_TEXT_STRIKEOUT GTK_STOCK_STRIKETHROUGH

#define MATE_STOCK_MENU_EXIT     MATE_STOCK_MENU_QUIT

#endif /* MATE_DISABLE_DEPRECATED */

#ifdef __cplusplus
}
#endif

#endif /* MATE_STOCK_ICONS_H */
