package ONVIF::Analytics::Types::NetworkInterfaceConnectionSetting;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %AutoNegotiation_of :ATTR(:get<AutoNegotiation>);
my %Speed_of :ATTR(:get<Speed>);
my %Duplex_of :ATTR(:get<Duplex>);

__PACKAGE__->_factory(
    [ qw(        AutoNegotiation
        Speed
        Duplex

    ) ],
    {
        'AutoNegotiation' => \%AutoNegotiation_of,
        'Speed' => \%Speed_of,
        'Duplex' => \%Duplex_of,
    },
    {
        'AutoNegotiation' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        'Speed' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'Duplex' => 'ONVIF::Analytics::Types::Duplex',
    },
    {

        'AutoNegotiation' => 'AutoNegotiation',
        'Speed' => 'Speed',
        'Duplex' => 'Duplex',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Analytics::Types::NetworkInterfaceConnectionSetting

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
NetworkInterfaceConnectionSetting from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * AutoNegotiation


=item * Speed


=item * Duplex




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Analytics::Types::NetworkInterfaceConnectionSetting
   AutoNegotiation =>  $some_value, # boolean
   Speed =>  $some_value, # int
   Duplex => $some_value, # Duplex
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

