/*
 * @(#)Panex.h
 *
 * Copyright 1996 - 2010  David A. Bagley, bagleyd@tux.org
 *
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the author not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * This program is distributed in the hope that it will be "useful",
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

/* Public header file for Panex */

#ifndef _XtPanex_h
#define _XtPanex_h

/***********************************************************************
 *
 * Panex Widget
 *
 ***********************************************************************/

#ifndef WINVER
#define XtNmono ((char *) "mono")
#define XtNtileColor ((char *) "tileColor")
#define XtNpyramidColor0 ((char *) "pyramidColor0")
#define XtNpyramidColor1 ((char *) "pyramidColor1")
#define XtNdelay ((char *) "delay")
#define XtNsound ((char *) "sound")
#define XtNmoveSound ((char *) "moveSound")
#define XtNdripSound ((char *) "dripSound")
#define XtNtiles ((char *) "tiles")
#define XtNmode ((char *) "mode")
#define XtNuserName ((char *) "userName")
#define XtNscoreFile ((char *) "scoreFile")
#define XtNscoreOnly ((char *) "scoreOnly")
#define XtNversionOnly ((char *) "versionOnly")
#define XtNmenu ((char *) "menu")
#define XtNstart ((char *) "start")
#define XtNcheat ((char *) "cheat")
#define XtNpixmapSize ((char *) "pixmapSize")
#define XtNselectCallback ((char *) "selectCallback")
#define XtCMono ((char *) "Mono")
#define XtCDelay ((char *) "Delay")
#define XtCSound ((char *) "Sound")
#define XtCMoveSound ((char *) "MoveSound")
#define XtCDripSound ((char *) "DripSound")
#define XtCTiles ((char *) "Tiles")
#define XtCMode ((char *) "Mode")
#define XtCUserName ((char *) "UserName")
#define XtCScoreFile ((char *) "ScoreFile")
#define XtCMenu ((char *) "Menu")
#define XtCPixmapSize ((char *) "PixmapSize")

typedef struct _PanexClassRec *PanexWidgetClass;

extern WidgetClass panexWidgetClass;

typedef struct {
	XEvent     *event;
	int         reason;
} panexCallbackStruct;
#endif

#define ACTION_READ 100
#define ACTION_WRITE 101
#define ACTION_EXIT 102
#define ACTION_HIDE 103
#define ACTION_CLEAR_QUERY 104
#define ACTION_RESTORE 105
#define ACTION_RESET 106
#define ACTION_ILLEGAL 107
#define ACTION_BLOCKED 108
#define ACTION_SPACE 109
#define ACTION_MOVED 110
#define ACTION_SOLVED 111
#define ACTION_COMPUTED 112
#define ACTION_UNDO 200
#define ACTION_REDO 201
#define ACTION_CLEAR 202
#define ACTION_SOLVE 203
#define ACTION_MODE 204
#define ACTION_INCREMENT 205
#define ACTION_DECREMENT 206
#define ACTION_SPEED 207
#define ACTION_SLOW 208
#define ACTION_SOUND 209
#define ACTION_DESCRIPTION 900
#define ACTION_FEATURES 901
#define ACTION_REFERENCES 902
#define ACTION_ABOUT 903
#define ACTION_IGNORE 999

#define MIN_TILES 1
#define DEFAULT_TILES 10
#define HANOI 0
#define ALGORITHME 1
#define PANEX 2
#define MAX_MODES 3
#define DEFAULT_MODE PANEX
#ifdef MONOTEST
#define DEFAULT_MONO TRUE
#else
#define DEFAULT_MONO FALSE
#endif
#define DEFAULT_REVERSE FALSE
#define DEFAULT_DELAY 10

#define BOOL_STRING(a) ((a==0)?"false":"true")

typedef struct _PanexRec *PanexWidget;

#endif /* _XtPanex_h */
/* DON'T ADD STUFF AFTER THIS #endif */
