/*
 * Copyright (C) 2000-2020 the xine project
 *
 * This file is part of xine, a unix video player.
 *
 * xine is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * xine is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110, USA
 *
 */
#ifndef HAVE_XITK_INTBOX_H
#define HAVE_XITK_INTBOX_H

typedef struct {
  xitk_new_widget_t     nw;

  int                    min, max, step, value;
  enum {
    INTBOX_FMT_DECIMAL,   /**<<       0,   12345,     -55787, ... */
    INTBOX_FMT_0x,        /**<<     0x0,  0x3039, 0xffff2615, ... */
    INTBOX_FMT_HASH,      /**<<      #0,   #3039,  #ffff2615, ... */
    INTBOX_FMT_SECONDS,   /**<< 0:00:00, 3:25:45,  -15:29:47, ... */
    INTBOX_FMT_MILLISECS  /**<<   0.000,  12.345,    -55.787, ... */
  }                      fmt;
  xitk_state_callback_t  callback;
} xitk_intbox_widget_t;

xitk_widget_t *xitk_noskin_intbox_create (const xitk_intbox_widget_t *ib, int x, int y, int width, int height);
int xitk_intbox_set_value (xitk_widget_t *iw, int value);
int xitk_intbox_get_value (xitk_widget_t *iw);
#endif
