/////////////////////////////////////////////////////////////////////////////
// Name:        wx/gtk/bitmap.h
// Purpose:
// Author:      Robert Roebling
// Copyright:   (c) 1998 Robert Roebling
// Licence:     wxWindows licence
/////////////////////////////////////////////////////////////////////////////

#ifndef _WX_GTK_BITMAP_H_
#define _WX_GTK_BITMAP_H_

#ifdef __WXGTK3__
typedef struct _cairo cairo_t;
typedef struct _cairo_surface cairo_surface_t;
#endif
typedef struct _GdkPixbuf GdkPixbuf;

//-----------------------------------------------------------------------------
// wxMask
//-----------------------------------------------------------------------------

class WXDLLIMPEXP_CORE wxMask: public wxMaskBase
{
public:
    wxMask();
    wxMask(const wxMask& mask);
    wxMask( const wxBitmap& bitmap, const wxColour& colour );
#if wxUSE_PALETTE
    wxMask( const wxBitmap& bitmap, int paletteIndex );
#endif // wxUSE_PALETTE
    wxMask( const wxBitmap& bitmap );
    virtual ~wxMask();
    wxBitmap GetBitmap() const;

    // implementation
#ifdef __WXGTK3__
    wxMask(cairo_surface_t*);
    operator cairo_surface_t*() const;
#else
    wxMask(GdkPixmap*);
    operator GdkPixmap*() const;
#endif

protected:
    virtual void FreeData() wxOVERRIDE;
    virtual bool InitFromColour(const wxBitmap& bitmap, const wxColour& colour) wxOVERRIDE;
    virtual bool InitFromMonoBitmap(const wxBitmap& bitmap) wxOVERRIDE;

private:
#ifdef __WXGTK3__
    cairo_surface_t* m_bitmap;
#else
    GdkPixmap* m_bitmap;
#endif

    wxDECLARE_DYNAMIC_CLASS(wxMask);
};

//-----------------------------------------------------------------------------
// wxBitmap
//-----------------------------------------------------------------------------

class WXDLLIMPEXP_CORE wxBitmap: public wxBitmapBase
{
public:
    wxBitmap() { }
    wxBitmap( int width, int height, int depth = wxBITMAP_SCREEN_DEPTH )
        { Create(width, height, depth); }
    wxBitmap( const wxSize& sz, int depth = wxBITMAP_SCREEN_DEPTH )
        { Create(sz, depth); }
    wxBitmap( int width, int height, const wxDC& dc )
        { Create(width, height, dc); }
    wxBitmap( const char bits[], int width, int height, int depth = 1 );
    wxBitmap( const char* const* bits );
    wxBitmap( const wxString &filename, wxBitmapType type = wxBITMAP_DEFAULT_TYPE );
#if wxUSE_IMAGE
    wxBitmap(const wxImage& image, int depth = wxBITMAP_SCREEN_DEPTH, double scale = 1.0);
    wxBitmap(const wxImage& image, const wxDC& dc);
#endif // wxUSE_IMAGE
    wxBitmap(GdkPixbuf* pixbuf, int depth = 0);
    explicit wxBitmap(const wxCursor& cursor);
    virtual ~wxBitmap();

    bool Create(int width, int height, int depth = wxBITMAP_SCREEN_DEPTH) wxOVERRIDE;
    bool Create(const wxSize& sz, int depth = wxBITMAP_SCREEN_DEPTH) wxOVERRIDE
        { return Create(sz.GetWidth(), sz.GetHeight(), depth); }
#ifdef __WXGTK3__
    bool Create(int width, int height, const wxDC& dc);
    virtual void SetScaleFactor(double scale) wxOVERRIDE;
    virtual double GetScaleFactor() const wxOVERRIDE;
#else
    bool Create(int width, int height, const wxDC& WXUNUSED(dc))
        { return Create(width,height); }
#endif

    virtual int GetHeight() const wxOVERRIDE;
    virtual int GetWidth() const wxOVERRIDE;
    virtual int GetDepth() const wxOVERRIDE;

#if wxUSE_IMAGE
    wxImage ConvertToImage() const wxOVERRIDE;
#endif // wxUSE_IMAGE

    wxMask *GetMask() const wxOVERRIDE;
    void SetMask( wxMask *mask ) wxOVERRIDE;

    wxBitmap GetSubBitmap( const wxRect& rect ) const wxOVERRIDE;

    bool SaveFile(const wxString &name, wxBitmapType type,
                          const wxPalette *palette = NULL) const wxOVERRIDE;
    bool LoadFile(const wxString &name, wxBitmapType type = wxBITMAP_DEFAULT_TYPE) wxOVERRIDE;

#if wxUSE_PALETTE
    wxPalette *GetPalette() const wxOVERRIDE;
    void SetPalette(const wxPalette& palette) wxOVERRIDE;
    wxPalette *GetColourMap() const { return GetPalette(); }
#endif // wxUSE_PALETTE

    static void InitStandardHandlers();

    // implementation
    // --------------

#if WXWIN_COMPATIBILITY_3_0
    wxDEPRECATED(void SetHeight( int height ) wxOVERRIDE);
    wxDEPRECATED(void SetWidth( int width ) wxOVERRIDE);
    wxDEPRECATED(void SetDepth( int depth ) wxOVERRIDE);
#endif

#ifdef __WXGTK3__
    cairo_t* CairoCreate() const;
    void Draw(cairo_t* cr, int x, int y, bool useMask = true, const wxColour* fg = NULL, const wxColour* bg = NULL) const;
    void SetSourceSurface(cairo_t* cr, int x, int y, const wxColour* fg = NULL, const wxColour* bg = NULL) const;
    wxBitmap CreateDisabled() const;
#else
    GdkPixmap *GetPixmap() const;
    bool HasPixmap() const;
    bool HasPixbuf() const;
    wxBitmap(GdkPixmap* pixmap);
#endif
    GdkPixbuf* GetPixbufNoMask() const;
    GdkPixbuf *GetPixbuf() const;

    // raw bitmap access support functions
    void *GetRawData(wxPixelDataBase& data, int bpp);
    void UngetRawData(wxPixelDataBase& data);

    bool HasAlpha() const wxOVERRIDE;

protected:
#if wxUSE_IMAGE
    void InitFromImage(const wxImage& image, int depth, double scale);
#ifndef __WXGTK3__
    bool CreateFromImage(const wxImage& image, int depth);
#endif
#endif // wxUSE_IMAGE

    virtual wxGDIRefData* CreateGDIRefData() const wxOVERRIDE;
    virtual wxGDIRefData* CloneGDIRefData(const wxGDIRefData* data) const wxOVERRIDE;

#ifdef __WXGTK3__
    virtual bool DoCreate(const wxSize& sz, double scale, int depth) wxOVERRIDE;
#endif

private:
#ifndef __WXGTK3__
    void SetPixmap(GdkPixmap* pixmap);
#if wxUSE_IMAGE
    // to be called from CreateFromImage only!
    bool CreateFromImageAsPixmap(const wxImage& image, int depth);
    bool CreateFromImageAsPixbuf(const wxImage& image);
#endif // wxUSE_IMAGE

public:
    // implementation only
    enum Representation
    {
        Pixmap,
        Pixbuf
    };
    // removes other representations from memory, keeping only 'keep'
    // (wxBitmap may keep same bitmap e.g. as both pixmap and pixbuf):
    void PurgeOtherRepresentations(Representation keep);
#endif

    wxDECLARE_DYNAMIC_CLASS(wxBitmap);
};

#endif // _WX_GTK_BITMAP_H_
