/*
 * $Id: rk_read.c,v 2.5.2.1 2000/08/04 05:37:29 kaneda Exp $
 */
/*
WNN6 CLIENT LIBRARY--SOFTWARE LICENSE TERMS AND CONDITIONS


Wnn6 Client Library :
(C) Copyright OMRON Corporation.       1995,1998,2000 all rights reserved.
(C) Copyright OMRON Software Co., Ltd. 1995,1998,2000 all rights reserved.

Wnn Software :
(C) Copyright Kyoto University Research Institute for Mathematical Sciences
     1987, 1988, 1989, 1990, 1991, 1992, 1993
(C) Copyright OMRON Corporation. 1987, 1988, 1989, 1990, 1991, 1992, 1993
(C) Copyright ASCTEC, Inc.  1987, 1988, 1989, 1990, 1991, 1992, 1993

Preamble

These Wnn6 Client Library--Software License Terms and Conditions
 (the "License Agreement") shall state the conditions under which you are
 permitted to copy, distribute or modify the software which can be used
 to create Wnn6 Client Library (the "Wnn6 Client Library").  The License
 Agreement can be freely copied and distributed verbatim, however, you
 shall NOT add, delete or change anything on the License Agreement.

OMRON Corporation and OMRON Software Co., Ltd. (collectively referred to
 as "OMRON") jointly developed the Wnn6 Software (development code name
 is FI-Wnn), based on the Wnn Software.  Starting from November, 1st, 1998,
 OMRON publishes the source code of the Wnn6 Client Library, and OMRON
 permits anyone to copy, distribute or change the Wnn6 Client Library under
 the License Agreement.

Wnn6 Client Library is based on the original version of Wnn developed by
 Kyoto University Research Institute for Mathematical Sciences (KURIMS),
 OMRON Corporation and ASTEC Inc.

Article 1.  Definition.

"Source Code" means the embodiment of the computer code, readable and
 understandable by a programmer of ordinary skills.  It includes related
 source code level system documentation, comments and procedural code.

"Object File" means a file, in substantially binary form, which is directly
 executable by a computer after linking applicable files.

"Library" means a file, composed of several Object Files, which is directly
 executable by a computer after linking applicable files.

"Software" means a set of Source Code including information on its use.

"Wnn6 Client Library" the computer program, originally supplied by OMRON,
 which can be used to create Wnn6 Client Library.

"Executable Module" means a file, created after linking Object Files or
 Library, which is directly executable by a computer.

"User" means anyone who uses the Wnn6 Client Library under the License
 Agreement.

Article 2.  Copyright

2.1  OMRON Corporation and OMRON Software Co., Ltd. jointly own the Wnn6
 Client Library, including, without limitation, its copyright.

2.2  Following words followed by the above copyright notices appear
 in all supporting documentation of software based on Wnn6 Client Library:

  This software is based on the original version of Wnn6 Client Library
  developed by OMRON Corporation and OMRON Software Co., Ltd. and also based on
  the original version of Wnn developed by Kyoto University Research Institute
  for Mathematical Sciences (KURIMS), OMRON Corporation and ASTEC Inc.

Article 3.  Grant

3.1  A User is permitted to make and distribute verbatim copies of
 the Wnn6 Client Library, including verbatim of copies of the License
 Agreement, under the License Agreement.

3.2  A User is permitted to modify the Wnn6 Client Library to create
 Software ("Modified Software") under the License Agreement.  A User
 is also permitted to make or distribute copies of Modified Software,
 including verbatim copies of the License Agreement with the following
 information.  Upon modifying the Wnn6 Client Library, a User MUST insert
 comments--stating the name of the User, the reason for the modifications,
 the date of the modifications, additional terms and conditions on the
 part of the modifications if there is any, and potential risks of using
 the Modified Software if they are known--right after the end of the
 License Agreement (or the last comment, if comments are inserted already).

3.3  A User is permitted to create Library or Executable Modules by
 modifying the Wnn6 Client Library in whole or in part under the License
 Agreement.  A User is also permitted to make or distribute copies of
 Library or Executable Modules with verbatim copies of the License
 Agreement under the License Agreement.  Upon modifying the Wnn6 Client
 Library for creating Library or Executable Modules, except for porting
 a computer, a User MUST add a text file to a package of the Wnn6 Client
 Library, providing information on the name of the User, the reason for
 the modifications, the date of the modifications, additional terms and
 conditions on the part of the modifications if there is any, and potential
 risks associated with using the modified Wnn6 Client Library, Library or
 Executable Modules if they are known.

3.4  A User is permitted to incorporate the Wnn6 Client Library in whole
 or in part into another Software, although its license terms and
 conditions may be different from the License Agreement, if such
 incorporation or use associated with the incorporation does NOT violate
 the License Agreement.

Article 4. Warranty

THE WNN6 CLIENT LIBRARY IS PROVIDED BY OMRON ON AN "AS IS" BAISIS.
  OMRON EXPRESSLY DISLCIAMS ANY AND ALL WRRANTIES, EXPRESS OR IMPLIED,
 INCLUDING, WITHOUT LIMITATION, WARRANTIES OF MERCHANTABILITY AND FITNESS
 FOR A PARTICULAR PURPOSE, IN CONNECTION WITH THE WNN6 CLIENT LIBRARY
 OR THE USE OR OTHER DEALING IN THE WNN6 CLIENT LIBRARY.  IN NO EVENT
 SHALL OMRON BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, PUNITIVE
 OR CONSEQUENTIAL DAMAGES OF ANY KIND WHATSOEVER IN CONNECTION WITH THE
 WNN6 CLIENT LIBRARY OR THE USE OR OTHER DEALING IN THE WNN6 CLIENT
LIBRARY.

***************************************************************************
Wnn6 Client Library :
(C) Copyright OMRON Corporation.       1995,1998,2000 all rights reserved.
(C) Copyright OMRON Software Co., Ltd. 1995,1998,2000 all rights reserved.

Wnn Software :
(C) Copyright Kyoto University Research Institute for Mathematical Sciences
     1987, 1988, 1989, 1990, 1991, 1992, 1993
(C) Copyright OMRON Corporation. 1987, 1988, 1989, 1990, 1991, 1992, 1993
(C) Copyright ASCTEC, Inc.  1987, 1988, 1989, 1990, 1991, 1992, 1993
***************************************************************************

Comments on Modifications:
*/
/***********************************************************************
			rk_read.c
						88. 6.11   
						93.10.19

	rk_main.c ʡѴбɽɤ߹ߤô
***********************************************************************/
/*	Version 3.0
 */
#include "rk_multi.h"
#include <sys/types.h>
#include <sys/stat.h>

letter	onescan();
char	*ename();

extern	letter	*ltrgrow(), *ltrend(), letterpick(), *ltr1cut();
extern	char	*chrcat(), *strend();

static int termsscan(), evalandcpy(), eval1cpy(), partscan(),
  atermscan(), serfun(), hensrc_tourk(), blankpass(),
  modsrcL(), chkL_get_int();
static void ERRLIN(), ERHOPN(),
  ltr1tostr(), ERRHYO(), vchk(), rangeset(), de_bcksla(), 
  listscan(), singleqscan(), doubleqscan();
static void readhyo();
static int evlis();
letter	*rangekettei();
extern void BUGreport(), choosehyo(), readmode();
extern int ltrcmp(), ltrstrcmp(), readfnm(), fixednamep();

#define IHENSU (1 << 24) /* ɽξ̣ХȤǡѿɽ */
#define IKANSU (2 << 24) /*	      	      ؿɽ */
#define IMODNM (3 << 24) /*	      	      ⡼̾ɽ */

#define ENDOF_NestFileArea ((FILE *)~0)
	 /** includeեΥǥץǼꥢΥɥޡ*/


 /**	ɤ߹ߡɤ߹ޤʤEOFˤĤä0֤
	âincludeθƤ롣бɽˤ϶ʸʳΥȥʸ
	ǤϺʤΤȤäƤå롣*/
int
readln(buf, cur_rk)
uns_chr *buf;
ARGS *cur_rk;
{
	register uns_chr *p;
	register int	c;

	if(NULL == *base){
		*buf = '\0';
		return(0);
	}

	p = buf;
	while(1){
		while(EOF == (c = getc(*base))){
			fclose(*base);
			if(NULL == *--base){
				c = EOF;
				break;
			}
		}
		if(c == EOF || c == '\n') break;

		if(is_cntrl(c) && !isspace(c)){
			sprintf(hcurread, "\\%03o", c);
			ERRLIN(21, cur_rk);
		}
		*p++ = c;
	}
	*p = '\0';
	return(p != buf || c != EOF);
}

letter	*memptr, *ltrbufptr, *hensumei, *hen_iki, *term, **henptr;
letter	*dummy;
struct	dat	*datptr;
struct	hensuset
{
	unsigned	regdflg : 1;	/* Ͽѿɽ */
	unsigned	curlinflg : 1;	/* ߹Ԥ˴Фѿɽ */
	unsigned	constflg : 1; /* Ȥ줿Ȥɽ */
	letter		*name;
	letter		*range;
} *hentourkptr, *henorg;

 /** Ϳ줿ե뤬ǥ쥯ȥʤ0֤ */
int
isdir(fnm)
char	*fnm;
{
	struct	stat	statbuf;
/*
	return(stat(fnm, &statbuf) == 0 && (statbuf.st_mode & S_IFDIR));
*/
	return(stat(fnm, &statbuf) == 0 && ((statbuf.st_mode & S_IFMT) == S_IFDIR));
}

 /**	nameͿ줿̾Ѵбɽ򥪡ץ󤹤롣̾ȸʤʤ
	̾fixednamep()ȡˤФƤϡѥ򸫤롣ξ硢
	ץ顢ѥ̾ *dirnamptr֤롣¾ξ
	*dirnamptr˶ʸ롣*errcodˤϼΥ顼ɤ롣
	Ϳ줿ե뤬ǥ쥯ȥλ1ʥѥõ3ˡ
	ե򥪡ץǤʤ2Ʊ4ˡ*/
FILE *
trytoopen(name, dirnamptr, errptr, cur_rk)
char	*name, **dirnamptr;
int	*errptr;
ARGS *cur_rk;
{
	char	**src, taio_fnm[REALFN];
	FILE	*opened;

	*dirnamptr = nulstr;
	*errptr = 0;

	if(fixednamep(name)){
		if(isdir(name)){
			*errptr = 1;
			return(NULL);
		}
		if(NULL == (opened = fopen(name, "r"))){
			*errptr = 2;
			return(NULL);
		}
		if(flags & RK_VERBOS){
			fprintf(stderr, "romkan: using Taio-hyo %s ...\r\n",
				name);
		}
		return(opened);
	} else {
		for(src = pathmeiorg; *src != NULL; src++){
			strcpy(taio_fnm, (*dirnamptr = *src));
			strcat(taio_fnm, name);

			if(isdir(taio_fnm)){
				*errptr = 3;
				return(NULL);
			}
			if(NULL == (opened = fopen(taio_fnm, "r"))) continue;

			 /* Now Taio-hyo found */
			if(flags & RK_VERBOS)
				fprintf(stderr,
					"romkan: using Taio-hyo %s ...\r\n",
					taio_fnm);
			return(opened);
		}
		if(flags & RK_VERBOS){ /* Taio-hyo not found */
			char	*p, *q;

			fprintf(stderr, "no %s in", name);
			for(src = pathmeiorg; *src != NULL; src++){
				fputc(' ', stderr);
				q = *src;
				if(*q == KUGIRI && *(q + 1) == '\0') q++;
				 else q = strend(q);
				for(p = *src; p < q; p++)
					fputc(*p, stderr);
			}
			fprintf(stderr, ".\n");
		}
		*dirnamptr = nulstr;
		*errptr = 4;
		return(NULL);
	}
}

 /** ɽɤ߹ */
void
readdata(memory, data, hensudefhyo, modf, cur_rk)
letter	*memory;	/* бɽɽƬϤϤ */
struct	dat	*data;	/* бɽιԤȤΥǡ */
letter	**hensudefhyo;	/* ѿΥǡ */
char	*modf;		/* ⡼ɽ̾ϤΥѥ̾äƤ */
ARGS *cur_rk;
{
	int	i, j;
	char	*hyomeibgn[HYOMAX];
	 /* ɽ̾ؤΥݥ󥿤 */
	char	hyomeimem_[HYOMEI];
	 /* ɽ̾μºݤʸ */
	char	*pathmeibgn[PTHMAX];
	 /* ѥ̾ؤΥݥ󥿤 */
	char	pathmeimem_[PTHMEI];
	 /* ѥ̾μºݤʸ */
	char	modfnm[REALFN];
	 /* ⡼ɽΥե̾򤳤إԤ ΤˤϤΥѥ̾ */

	memptr = memory;
	datptr = data;
	henptr = hensudefhyo;
	*(pathmeiptr = pathmeiorg = pathmeibgn) = NULL;
	*(pathmeimem = pathmeimem_) = '\0';
	*(hyomeiptr = hyomeiorg = hyomeibgn) = NULL;
	*(hyomeimem = hyomeimem_) = '\0';
	*(modmeiptr = modmeibgn) = NULL;
	*(modmeimem = modmeimem_) = '\0';
	*(dspnamptr = dspnambgn) = NULL;
	*(dspcod = dspcod_) = '\0';
	*(naibu = naibu_) = '\0';

	strcpy(modfnm, modf);
	     /* modfnmͿե̾ѥ̾Ϳ줿顢ǥեȤ
		⡼ɽ̾"mode"ĤʤKUGIRIǥ쥯ȥζڤʸ */

	if(*modfnm == '\0' || *(strend(modfnm)) == KUGIRI){
		strcat(modfnm, "mode");
	} else if(isdir(modfnm)){
		chrcat(modfnm, KUGIRI);
		strcat(modfnm, "mode");
	}

	curdir = nulstr;
	readmode(curfnm = modfnm, cur_rk);

	for(i = 0; hyomeiorg[i] != NULL; i++){
		int	err;

		for(j = 0; j < FILNST; j++) nestfile[j] = NULL;
		nestfile[FILNST - 1] = ENDOF_NestFileArea;
		base = nestfile + 1;

		*base = trytoopen(curfnm = hyomeiorg[i], &curdir, &err, cur_rk);
		if(err){
			switch(err){
				case 1:
				case 3: ERHOPN(1, cur_rk);
				case 2:
				case 4: ERHOPN(0, cur_rk);
			}
		}
		readhyo(i, cur_rk);
	}

	hyo_n[i] . data = NULL;
	choosehyo(cur_rk);
}

 /** ե̾ѥ̾ʬƬ֤*/
char	*ename(s)
char	*s;
{
	char	*p;

	p = strrchr(s, KUGIRI);
	return(p == NULL ? s : p + 1);
}

 /**	ե̾ΥåƬʥѥ̾Ͻˤ'1''3'ǤʤȤʤ
	ʤΤʤ13ܡɽζ̤ɽˤ֤Ǥʤ
	0֤*/
int
filnamchk(s)
char	*s;
{
	char	c;

	c = *(ename(s)) - '0';
	return((1 <= c && c <= 3) ? c : 0);
}

 /**	linbufäƤunsigned charletterˤltrbuf롣
	ɥޡEOLTTRˤʤ롣flg0λϡƬζʸФ*/
void
ustrtoltr(linbuf, ltrbuf, flg, cur_rk)
uns_chr *linbuf;
int	flg;
register letter *ltrbuf;
ARGS *cur_rk;
{
	register letter l;

	if(flg){
		while(l = letterpick(&linbuf, cur_rk), is_eolsp(l)){
			if(l == EOLTTR){
				*ltrbuf = EOLTTR;
				return;
			}
		}
		*ltrbuf++ = l;
	}
	while((*ltrbuf++ = letterpick(&linbuf, cur_rk)) != EOLTTR);
}

 /**	letterʸ˥СȡĤΥݥ󥿤ƱϤǤäƤ
	ưݾڤ뤳ȡ*/
void
ltrtostr(ltrbuf, linbuf)
char	*linbuf;
letter	*ltrbuf;
{
	letter	l;

	while((l = *ltrbuf++) != EOLTTR) ltr1tostr(l, &linbuf);
	*linbuf = '\0';
}

 /** letterʸ˥С */
static void
ltr1tostr(l, sptr)
char	**sptr;
letter	l;
{
	int	i;

	for(i = 0; i < 3 && 0 == (l & (0xff000000)); i++) l <<= 8;
	for(; i < 4; i++){
		*(*sptr)++ = (char)(l >> 24);
		l <<= 8;
	}
}

 /** ѿΡָ߹ԴХե饰פƥꥢ */
void
hen_useflgclr(hensu)
struct	hensuset	*hensu;
{
	for(; hensu -> name != NULL; hensu++)
		hensu -> curlinflg = 0; /* ߹Ԥ̤ */
}

 /** бɽɤ߹ */
static void
readhyo(n, cur_rk)
int	n;
ARGS *cur_rk;
{
	uns_chr linbuf[LINSIZ];
	letter	ltrbuf[LINSIZ], *lp;
	letter	termbuf[SIZALL]; /* 顼θơɽΥʬäƤ*/
	letter	dummybuf[TRMSIZ], hensumei_[VARLEN], hen_iki_[SIZALL];
	struct	hensuset	hensu[VARMAX];
	int	m, hyosw, rsltyp[3];

	hcurread = (char *)linbuf; /* 顼 */
	ltrbufbgn = ltrbuf;

	*(hensumei = hensumei_) = EOLTTR;
	*(hen_iki = hen_iki_) = EOLTTR;
	(henorg = hentourkptr = hensu) -> name = NULL;
	dummy = dummybuf;

	hyo_n[n] . hensudef = henptr;
	hyo_n[n] . data = datptr;

	hyosw = hyoshu[n];
	while(readln(linbuf, cur_rk)){
		hen_useflgclr(henorg);
		ustrtoltr(linbuf, ltrbuf, 1, cur_rk);
		ltrbufptr = ltrbuf;

		for(m = 0; termsscan(&ltrbufptr, term = termbuf, 1, cur_rk); m++){
			 /* mϡܤιܤ򸫤Ƥ뤫ɽ */
			if(*term == ';') break; /*  */
			if(m == 3) ERRLIN(15, cur_rk);
			if(m != 0 && rsltyp[0] == 4) ERRLIN(12, cur_rk);

			datptr -> code[m] = memptr;
			if((rsltyp[m] = evalandcpy(&term, m, cur_rk)) == 4){
				if(m) ERRLIN(14, cur_rk);
			 /* Ϻǽιܤˤʤ
			    funstr[]appearե饰ǤåƤ뤬
			    Τ˰ˤåƤ*/
			} else {
			 /* λˤɽؤΥݥ󥿤Ͽʤʤ */
				totail(memptr);
				memptr++;
			}
		}

		if(m != 0 && rsltyp[0] != 4){
			for( /* m=? */ ; m < 3; m++){
				datptr -> code[m] = nil;
				rsltyp[m] = -1; /* doesn't exist */
			}
			datptr++;

 /* rsltyp: 0=ʸ 1=ʸϢ 2=ǡϢ 3=ǽ 4= -1=¸ߤ */
			switch(hyosw){
		   /* ϡɽƤ¤롣򸡺 */
				case 1:
					if(!(rsltyp[0] == 0 &&
					     rsltyp[1] == 0 && 
					     rsltyp[2] == -1
					    ))
						ERRLIN(17, cur_rk);
					break;
				case 2:
					if(rsltyp[1] == 3 && rsltyp[2] != -1)
						ERRLIN(19, cur_rk);
					break;
				case 3:
					if(!(rsltyp[0] == 0 &&
					     (rsltyp[1] == 0 ||
					      rsltyp[1] == 1) &&
					     rsltyp[2] == -1
					    ))
						ERRLIN(18, cur_rk);
					break;
				default:
					BUGreport(10);
			}

		}
	}

	(datptr++) -> code[0] = NULL;

		/* ѿϿǤޤȤƤ */
	for(lp = hen_iki_; lp < hen_iki; ) *memptr++ = *lp++;
	for(hentourkptr = henorg; hentourkptr -> name != NULL;
	    hentourkptr++){
		if(hentourkptr -> regdflg == 0) ERRHYO(0, cur_rk);
		*henptr++ = memptr - (lp - hentourkptr -> range);
	}
	*henptr++ = NULL;

	/*  fclose(*base); סreadlnǤǤ */
}

 /**	ѴбɽιܰĤ򡢲ᤷơΥǡꥢ˥ԡ롣
	֤ͤϡᤷܤʸʤ0ʳʸϢʤ1ʳ
	ǥǡϢʤ2ǽʤ3ʤ4ʳϥ顼*/
static int
evalandcpy(socp, m, cur_rk)
register letter **socp; /* ܤؤΥݥ󥿡ʤؤΥݥ󥿡*/
int	m;   /* бɽβܤιܤ򸫤Ƥ뤫ɽϥ
		ƤȤ0ϥʤ1ХåեĤʤ2 */
ARGS *cur_rk;
{
#define TYPMAX	5

	char	exist[TYPMAX], total;
	 /* existϡ줾쥿04ινиΥե饰eval1cpy()ȡˡ
	    totalΤȤƤνиե饰ɤ⡢1=̤ 2= ¾
	    ϲ2ӥå0 */
	int	type;

#define TIME_0(flag) ((flag) == 1)
#define TIME_1(flag) ((flag) == 2)
#define TIME_n(flag) (((flag) & 3) == 0)

	total = 1;
	for(type = 0; type < TYPMAX; type++) exist[type] = 1;

	while(!is_eolsp(**socp)){
		if(!(0 <= (type = eval1cpy(socp, m, 0, cur_rk)) && type < TYPMAX))
			BUGreport(3);
		exist[type] <<= 1;
		total <<= 1;
	}

	if(TIME_0(total))
		BUGreport(13); /* ܤʤevalandcpyϼ¹ԤʤȦ */
	if(!TIME_0(exist[3]) || !TIME_0(exist[4])){
		if(TIME_n(total)) ERRLIN(9, cur_rk);
		return(type); /* 34typeͤݻƤȦ */
	}
	if(TIME_1(total) && TIME_1(exist[0])) return(0);
	return(!TIME_0(exist[2]) ? 2 : 1);
}

 /**	бɽιܤιĤᤷΥǡꥢ˥ԡ
	Υסʸ=0 ʸ=1 üؿ=2 ǽ=3 =4ˤ
	֤flg0ʤ顢ƵŪ˸ƤФ줿Ȥ̣ξ硢
	߹Ԥ̤Фѿ򸡽Ф饨顼ޤm0ΤȤϥ
	ʳν򸫤Ƥˤ⡢߹Ԥ̤Фѿ򸡽Ф饨顼*/
static int
eval1cpy(socp, m, flg, cur_rk)
letter	**socp; /* flgʳΰΰ̣evalandcpyƱ */
int	m, flg;
ARGS *cur_rk;
{
	letter	t1buf[TRMSIZ], *t1bufp;

	t1bufp = t1buf;

	*memptr = EOLTTR;
	switch(partscan(socp, t1bufp, cur_rk)){
		case 1: /* ñʸ */
			memptr = ltrgrow(memptr, t1bufp);
			*memptr = EOLTTR;
			return(0);
		case 2: /* ʸ */
			t1bufp++;
			*memptr++ = onescan(&t1bufp, dummy, cur_rk);
			*memptr = EOLTTR;
			return(0);
		case 3: /* ʸ */
			t1bufp++;
			while(*t1bufp != '"'){
				*memptr++ = onescan(&t1bufp, dummy, cur_rk);
			}
			*memptr = EOLTTR;
			return(1);
		case 0: /* ꥹ */
			return(evlis(m, &t1bufp, flg, cur_rk));
			 /* evlis *memptr = EOLTTR; 򤷤Ƥ롣*/
		default:
			BUGreport(4);
			return(-1);
			 /*NOTREACHED*/
	}
	/*NOTREACHED*/
}

#define bitchk(x, n) ((x) & (1 << (n)))

#define get_ltr(lp) (*(lp)++)
#define unget_ltr(l, lp) (*--(lp) = (l))

 /** globalʥݥ󥿤ؤƤletter󤫤ʸäƤ롣*/
letter
get1ltr(cur_rk)
ARGS *cur_rk;
{
	return(get_ltr(lptr));
}

letter
unget1ltr(l, cur_rk)
letter	l;
ARGS *cur_rk;
{
	return(unget_ltr(l, lptr));
}

int
int_get1ltr(cur_rk)
ARGS *cur_rk;
{
    return((int)(get1ltr(cur_rk)));
}

int
int_unget1ltr(c, cur_rk)
letter c;
ARGS *cur_rk;
{
    return((int)(unget1ltr((letter) c, cur_rk)));
}
 /** ȤξʤʤؿηcastǤʤΡ
    (int ()) get1ltrפȽ񤭤 */

 /**	includeե̾letterstring˼ФȤletterν
	ޤ³롣flg & 010ʤ顢'/'Ǥ⽪λ*/
letter
getfrom_dblq(socp, destp, flg, cur_rk)
letter	**socp;
char	**destp;
int	flg;
ARGS *cur_rk;
{
	letter	l;

	while(**socp != EOLTTR && !(flg & 01 && **socp == KUGIRI)){
		if (**socp == '\\') *(*destp)++ = '\\';
		l = onescan(socp, dummy, cur_rk);
		ltr1tostr(l, destp);
	}
	*(*destp)++ = '\0';
	return(**socp);
}

int
getfrom_lptr(sptr, flg, cur_rk)
char	**sptr;
int	flg;
ARGS *cur_rk;
{
	return((int)getfrom_dblq(&lptr, sptr, flg, cur_rk));
}

 /**	ꥹȤᤷɽˤ롣ͤϡΥꥹȤΥפɽ
	ʸѿʸؿ:0 ʸؿ:1 üؿ:2
	ǽ:3 :4 */
static int
evlis(m, socp, flg, cur_rk)
letter	**socp; /* ΰ̣eval1cpy򻲾 */
int	m, flg;
ARGS *cur_rk;
{
	int	fnnum, hennum, i;
	letter	t1buf[TRMSIZ];

	(*socp)++; /* '('򥹥å */
	atermscan(socp, t1buf, 3, cur_rk);

	fnnum = serfun(t1buf);
	if(fnnum != -1 && !bitchk(func[fnnum] . appear, m)) ERRLIN(14, cur_rk);
	 /* mͤˤäơƤϤʤؤνиɤƤ롣*/

	switch(fnnum){ /* defaultνʳ func[fnnum].argnumȤäƤʤ */
		case -1: /* ѿ */
			vchk(t1buf, cur_rk);
			atermscan(socp, dummy, 2, cur_rk); /* ERR */
			hennum = hensrc_tourk(t1buf, ((m==0 && !flg)? 0 : 1), cur_rk);
			*memptr++ = (henorg[hennum] . constflg ? 
				     *(henorg[hennum].range) : hennum|IHENSU);
			break;

		case 0: /* fn No.0 defvar */
			atermscan(socp, t1buf, 3, cur_rk);
			if(*t1buf == '('){
				letter	*soc2, t1buf2[TRMSIZ], t1buf3[TRMSIZ];
				letter	*common_hen;

				atermscan(socp, t1buf3, 3, cur_rk);

				soc2 = t1buf + 1; /* skip '(' */

				atermscan(&soc2, t1buf2, 3, cur_rk);
				vchk(t1buf2, cur_rk);
				if(-1 != serfun(t1buf2)) ERRLIN(11, cur_rk);
				hennum = hensrc_tourk(t1buf2, 2, cur_rk);
				common_hen = rangekettei(hennum, t1buf3, cur_rk);

				while(atermscan(&soc2, t1buf2, 0, cur_rk)){
					vchk(t1buf2, cur_rk);
					if(-1 != serfun(t1buf2)) ERRLIN(11, cur_rk);
					hennum = hensrc_tourk(t1buf2, 2, cur_rk);
					rangeset(hennum, common_hen, cur_rk);
				}
			} else {
				vchk(t1buf, cur_rk);
				if(-1 != serfun(t1buf)) ERRLIN(11, cur_rk);
				hennum = hensrc_tourk(t1buf, 2, cur_rk);
			  /* defvardefconstѿ̾νʣ򤱤뤿 */
				atermscan(socp, t1buf, 3, cur_rk);
				rangekettei(hennum, t1buf, cur_rk);
			}
			atermscan(socp, dummy, 2, cur_rk);
			break;
		case 36: /* fn No.36 defconst */
			atermscan(socp, t1buf, 3, cur_rk);
			vchk(t1buf, cur_rk);
			if(-1 != serfun(t1buf)) ERRLIN(11, cur_rk);

			hennum = hensrc_tourk(t1buf, 6, cur_rk);
			  /* defvardefconstѿ̾ʣ򤱤뤿 */

			rangeset(hennum, hen_iki, cur_rk);

			blankpass(socp, 1, cur_rk);
			if(*(*socp)++ != '\'') ERRLIN(8, cur_rk);
			*hen_iki++ = onescan(socp, dummy, cur_rk);
			(*socp)++; /*'פĤƤ뤳ȤθϺѤǤ*/
			*hen_iki++ = EOLTTR; /* needed? */
			*hen_iki = EOLTTR;

			atermscan(socp, dummy, 2, cur_rk);
			break;

		case 1: /* fn No.1 include */
			{
				char	fnmtmparea[REALFN], *s, *dirnamptr;
				int	dummyc = 0, err;

				blankpass(socp, 1, cur_rk);
				if(3 != partscan(socp, t1buf, cur_rk)) ERRLIN(22, cur_rk);
				atermscan(socp, dummy, 2, cur_rk);
				 /* ;ʬˤERR */

				ltr1cut(lptr = t1buf + 1);
				*(s = fnmtmparea) = '\0';
				err = readfnm(int_get1ltr, int_unget1ltr,
					      getfrom_lptr, &s, &dummyc, cur_rk);

				if(err){
					hcurread = s;
					switch(err){
						case 1:
						case 3: ERRLIN(25, cur_rk);
						case 2: ERRLIN(26, cur_rk);
						case 4: ERRLIN(27, cur_rk);
					}
				}
				de_bcksla(fnmtmparea, fnmtmparea);

				if(*++base == ENDOF_NestFileArea){
					base--;
					ERRLIN(23, cur_rk);
				}
				*base= trytoopen(fnmtmparea, &dirnamptr,&err, cur_rk);
				if(err){
					switch(err){
						case 1:
						case 3:
						case 2:
						case 4: base--;
							ERRLIN(24, cur_rk);
					}
				}
			}
			break;

		 /* ⡼̾Ĥ˼ */
		case 4: /* fn No.46 off,on,switch */
		case 5:
		case 6:
		case 20: /* fn No.20,21 if,unless */
		case 21:
			*memptr++ = fnnum | IKANSU;
			atermscan(socp, t1buf, 3, cur_rk);
			*memptr++ = modsrcL(t1buf, cur_rk) | IMODNM;
			atermscan(socp, t1buf, 2, cur_rk);
			break;

		 /* ⡼̾ʸ ĤĤ˼ */
		case 37: /* fn No.3743 setmodeʤ */
		case 38:
		case 39:
		case 40:
		case 41:
		case 42:
		case 43:
			{
				int	err, n;
				modetyp	stat;

				*memptr++ = fnnum | IKANSU;
				atermscan(socp, t1buf, 3, cur_rk);
				*memptr++ = (n = modsrcL(t1buf, cur_rk))| IMODNM;
				atermscan(socp, t1buf, 3, cur_rk);
				err = chkL_get_int(t1buf, &stat,
							 modesw[n] . moderng);
				if(err != 0) ERRLIN(29, cur_rk);
				*memptr++ = stat;
				atermscan(socp, t1buf, 2, cur_rk);
				break;
			}

		 /* ̡ʰʤΤޤ */
		default: /* toupper,tolower */
			*memptr++ = fnnum | IKANSU;
			*memptr = EOLTTR;
			for(i = 0; i < func[fnnum] . argnum; i++){
				blankpass(socp, 1, cur_rk);
				if(eval1cpy(socp, m, 1, cur_rk) != 0) ERRLIN(13, cur_rk);
			}
			atermscan(socp, dummy, 2, cur_rk); /* ;ʬˤERR */
			break;
	}
	*memptr = EOLTTR;
	return(fnnum == -1 ? 0 : func[fnnum] . fntype);
}

 /** ʸΡ\פȴ */
static void
de_bcksla(s, r)
char	*s, *r;
{
	for(; *s; *r++ = *s++) if(*s == '\\') s++;
	*r = '\0';
}

 /**	defvarshikiˤᤷơѿѰꤹ롣
	ѿκǸ˥ɥޡ롣ͤϡѰǼ
	ؤΥݥ󥿡*/
letter	*
rangekettei(num, shiki, cur_rk)
letter	*shiki;
int	num; /* ѰꤷĤĤѿֹ */
ARGS *cur_rk;
{
	letter	hyoukabuf[TRMSIZ];

	rangeset(num, hen_iki, cur_rk);
	*hen_iki = EOLTTR;

	if(*shiki++ != '(') ERRLIN(8, cur_rk);
	atermscan(&shiki, hyoukabuf, 1, cur_rk);

	if(!ltrstrcmp(hyoukabuf, "all")){
		*hen_iki++ = VARRNG;
		*hen_iki++ = 0;
		*hen_iki++ = LTRHUG; /* Ѱʸ */
		*hen_iki++ = EOLTTR;
		*hen_iki = EOLTTR;
		atermscan(&shiki, dummy, 2, cur_rk); /* ;ʬˤERR */
	} else 
	if(!ltrstrcmp(hyoukabuf, "between")){
		int	i;

		*hen_iki++ = VARRNG;
		while(blankpass(&shiki, 1, cur_rk), *shiki != ')'){
			for(i = 1; i <= 2; i++){
				switch(*shiki){
					case '\'':
						shiki++;
						*hen_iki++ =
						       onescan(&shiki, dummy, cur_rk);
						shiki++;
						break;
					case ')':
					case '"':
					case '(': ERRLIN(8, cur_rk);
					default:
						*hen_iki++ = *shiki++;
				}
				if(i < 2){
					if(!is_eolsp(*shiki)) ERRLIN(8, cur_rk);
					blankpass(&shiki, 1, cur_rk);
				}
			}
		}
		*hen_iki++ = EOLTTR;
		*hen_iki = EOLTTR;
	} else
	if(!ltrstrcmp(hyoukabuf, "list")){
		while(blankpass(&shiki, 1, cur_rk), *shiki != ')'){
			switch(*shiki){
				case '"':
				case '(': ERRLIN(8, cur_rk);
				case '\'':
					shiki++;
					*hen_iki++ = onescan(&shiki, dummy, cur_rk);
					shiki++; /* ˡ'פĤƤ뤫
					 ɤθϤ⤦ѤǤ롣*/
					break;
				default:
					*hen_iki++ = *shiki++;
			}
			if(!is_eolsp(*shiki)) ERRLIN(8, cur_rk);
		}
		*hen_iki++ = EOLTTR;
		*hen_iki = EOLTTR;
	} else {
		ERRLIN(8, cur_rk); /* Ϥ¾ιʸͽǤä */
	}

	return(henorg[num] . range);
}

 /**	numܤѿѰؤ٤ݥ󥿤λؤꤷѿ
	Ͽ֤ˤ롣*/
static void
rangeset(num, range, cur_rk)
letter	*range; /* ѰΥݥ */
int	num;
ARGS *cur_rk;
{
	henorg[num] . range = range;
	henorg[num] . regdflg = 1;
}

 /**	nameǻꤵ줿̾ѿõʤϿѿ̾κǸ
	ɥޡ롣
	flg & 010λ̾ѿ߹Ԥ̤Фʤ饨顼constȤ
	Ͽλˡޤ flg & 020λ̾ѿʤ
	顼defvarνʣåѡˡflg & 040ʤconstȤϿ*/
static int
hensrc_tourk(name, flg, cur_rk)
letter	*name;
int	flg;
ARGS *cur_rk;
{
	int	i;

	for(i = 0; henorg[i] . name != NULL; i++){
		if(ltrcmp(henorg[i] . name, name)) continue;
		 /* found */
		if(flg & 04) ERRLIN(28, cur_rk);
		if(flg & 02 && henorg[i] . regdflg != 0) ERRLIN(10, cur_rk);
		if(flg & 01 && henorg[i] . curlinflg == 0 &&
				 henorg[i] . constflg == 0)
			ERRLIN(5, cur_rk);
		henorg[i] . curlinflg = 1;
		return(i);
	}
	if(henorg + i != hentourkptr) BUGreport(5);

	 /* 褿ȤȤϡФѿȤȡflg & 01
	    0ʤ饨顼*/
	if(flg & 01) ERRLIN(5, cur_rk);
	hentourkptr -> name = hensumei;
	hentourkptr -> curlinflg = 1;
	hentourkptr -> regdflg = 0; /* Фrangedef̤Ȧ */
	hentourkptr -> constflg = ((flg & 04) != 0);
	(++hentourkptr) -> name = NULL;
	hensumei = ltrgrow(hensumei, name);
	*++hensumei = EOLTTR;

	return(i);
}

 /** Ȥ߹ߴؿǽ̾ФƤϤֹ򡢤ǤʤΤʤ-1֤ */
static int
serfun(lp)
register letter *lp; /* ؿǽ̾⤷ѿ̾ */
{
	register int	i;

	for(i = 0; func[i] . fnname != NULL; i++){
		if(! ltrstrcmp(lp, func[i] . fnname)) return(i);
	}
	return(-1);
}

 /** ѿ̾Υå ȥ顼 */
static void
vchk(lp, cur_rk)
letter	*lp;
ARGS *cur_rk;
{
	if(is_digit(*lp)) ERRLIN(3, cur_rk);
	for(; *lp != EOLTTR; lp++){
	  /*	if(is_lower(*lp)) *lp = to_upper(*lp);	*/
		if(!is_alnum(*lp) && *lp != '_') ERRLIN(3, cur_rk);
	}
}

 /**	ܤФФ1֤flg0λϡ')'
	Ĥȥ顼';'Ϥǰܰ*/
static int
termsscan(socp, dest, flg, cur_rk)
register letter **socp, *dest;
	 /* socpλؤƤݥ󥿤ؤƤ꤫Фdest롣
	    θ塢socpؤƤݥ󥿤ʤ롣Υե **scan()
	    ȤؿƤʤäƤ롣*/
int	flg;
ARGS *cur_rk;
{
	letter	*bgn;

	bgn = dest;

	if(blankpass(socp, 0, cur_rk) == 0){
		if(flg && **socp == ';'){
			*dest++ = *(*socp)++;
		} else
		while(!is_eolsp(**socp)){
			if(**socp == ')'){
				if(flg) ERRLIN(0, cur_rk);
				break;
			} else {
				partscan(socp, dest, cur_rk);
				totail(dest);
			}
		}
	}

	*dest = EOLTTR;
	return(bgn != dest);
}

 /**	ꥹȰĤñΰޤȤޤФ1֤
	flg1ΤȤ')'Ĥȥ顼
	flg2ΤȤФ饨顼
	flg3ΤȤФ˼Ԥ饨顼*/
static int
atermscan(socp, dest, flg, cur_rk)
register letter **socp, *dest;
int	flg;
ARGS *cur_rk;
{
	letter	*bgn;
	int	found;

	bgn = dest;

	if(blankpass(socp, 0, cur_rk) == 0){
		if(**socp == '('){
			listscan(socp, dest, cur_rk);
			totail(dest);
		} else {
			while(!is_eolsp(**socp) && **socp != '('){
				if(**socp == ')'){
					if(flg == 1) ERRLIN(0, cur_rk);
					break;
				} else {
					partscan(socp, dest, cur_rk);
					totail(dest);
				}
			}
		}
	}

	*dest = EOLTTR;

	found = (bgn != dest);
	if((!found && (flg == 3)) || (found && (flg == 2))) ERRLIN(7, cur_rk);
	return(found);
}

 /**	ĤФФΤꥹȤʤͤ0ñʸʤ1
	ʸʤ2ʸʤ3*/
static int
partscan(socp, dest, cur_rk)
register letter **socp, *dest;
ARGS *cur_rk;
{
	switch(**socp){
		case '(':
			listscan(socp, dest, cur_rk);
			return(0);
		case '\'':
			singleqscan(socp, dest, cur_rk);
			return(2);
		case '"':
			doubleqscan(socp, dest, cur_rk);
			return(3);
		default:
			*dest++ = *(*socp)++;
			*dest = EOLTTR;
			return(1);
	}
}

 /** 󥰥륯ɽĤФ*/
static void
singleqscan(socp, dest, cur_rk)
letter	**socp, *dest;
ARGS *cur_rk;
{
	*dest++ = *(*socp)++;
	onescan(socp, dest, cur_rk);
	totail(dest);
	if((*dest++ = *(*socp)++) != '\'') ERRLIN(1, cur_rk);

	*dest = EOLTTR;
}

 /** ֥륯ɽĤФ*/
static void
doubleqscan(socp, dest, cur_rk)
letter	**socp, *dest;
ARGS *cur_rk;
{
	*dest++ = *(*socp)++;
	while(**socp != '"'){
		if(**socp == EOLTTR) ERRLIN(1, cur_rk);
		onescan(socp, dest, cur_rk);
		totail(dest);
	}
	*dest++ = *(*socp)++;

	*dest = EOLTTR;
}

 /**	81016ʥѥ饯ºݤΥɤľϤΥå
	ʸȿʳϤФƤñ0֤*/
int
ltov(l)
letter	l;
{
	if(is_upper(l)) return(l - 'A' + 10);
	if(is_lower(l)) return(l - 'a' + 10);
	if(is_digit(l)) return(l - '0'); else return(0);
}

 /** ltovε */
letter	vtol(l)
letter	l;
{
	if(BASEMX <= l) return('*');
	return(l + (l < 10 ? '0' : 'A' - 10));
}

 /**	󥰥롦֥륯ȤǤΰʸФ
	^פˤ륳ȥ륳ɽ\פˤ81016ɽˤ
	б\ɽϡ\odxϿ¤ӡ;ϡפǤ롣*/
letter
onescan(socp, dest, cur_rk)
letter	**socp, *dest;
ARGS *cur_rk;
{
	letter	l, realcode;
	int	digflg;

	switch(realcode = *dest++ = *(*socp)++){
		case '^':
			if(!(' ' <= (l = *(*socp)++) && l < '\177'))
			    ERRLIN(2, cur_rk);
			realcode = ((*dest++ = l) == '?' ? '\177' : l & 0x1f);
			break;
		case '\\':
			digflg = 0;
			switch(**socp){
				case 'n':
					*dest++ = *(*socp)++; realcode = '\n';
					break;
				case 't':
					*dest++ = *(*socp)++; realcode = '\t';
					break;
				case 'b':
					*dest++ = *(*socp)++; realcode = '\b';
					break;
				case 'r':
					*dest++ = *(*socp)++; realcode = '\r';
					break;
				case 'f':
					*dest++ = *(*socp)++; realcode = '\f';
					break;
				case 'e':
				case 'E':
					*dest++ = *(*socp)++; realcode=ESCCHR;
					break;
				case 'o':
					*dest++ = *(*socp)++;
					for(realcode = 0; is_octal(**socp);){
						digflg = 1;
						realcode <<= 3;
						realcode += ltov
						       (*dest++ = *(*socp)++);
					}
					if(!digflg) ERRLIN(2, cur_rk);
					if(**socp== ';') *dest++ = *(*socp)++;
					break;
				case 'x':
					*dest++ = *(*socp)++;
					for(realcode = 0; is_xdigit(**socp);){
						digflg = 1;
						realcode <<= 4;
						realcode += ltov
						       (*dest++ = *(*socp)++);
					}
					if(!digflg) ERRLIN(2, cur_rk);
					if(**socp== ';') *dest++ = *(*socp)++;
					break;
				case 'd':
					*dest++ = *(*socp)++;
					for(realcode = 0; is_digit(**socp);){
						digflg = 1;
						realcode *= 10;
						realcode += ltov
						       (*dest++ = *(*socp)++);
					}
					if(!digflg) ERRLIN(2, cur_rk);
					if(**socp== ';') *dest++ = *(*socp)++;
					break;
				default:
					if(is_octal(**socp)){
						for(realcode = 0;
						    is_octal(**socp);){
							realcode <<= 3;
							realcode += ltov(
							*dest++ = *(*socp)++);
						}
						if(**socp == ';')
							*dest++ = *(*socp)++;
					} else {
						realcode= *dest++= *(*socp)++;
					}
			}
			break;
		default: ;
	}

	*dest = EOLTTR;
	return(realcode);
}
	
 /**	letterƬˤ򥹥åפ롣
	ã顢flg0ΤȤ1֤Ǥʤȥ顼*/
static int
blankpass(pptr, flg, cur_rk)
register letter **pptr;
	 /* letterΥݥ󥿤ؤΥݥ󥿡줬ؤƤΤʤ */
int	flg;
ARGS *cur_rk;
{
	while(is_eolsp(**pptr)){
		if(EOLTTR == **pptr){
			if(flg) ERRLIN(4, cur_rk);
			return(1);
		}
		(*pptr)++;
	}
	return(0);
}

 /** ꥹȰļФ */
static void
listscan(socp, dest, cur_rk)
register letter **socp, *dest;
ARGS *cur_rk;
{
	int	eofreach;

	*dest++ = *(*socp)++; /* = '(' */
	*dest++ = ' ';
	
	while(eofreach = blankpass(socp, 0, cur_rk), **socp != ')'){
		if(eofreach){
			if(! readln((uns_chr *)hcurread, cur_rk)) ERRLIN(20, cur_rk);
			ustrtoltr((uns_chr *)hcurread, (*socp= ltrbufbgn), 1, cur_rk);
			 /* listǹԤڤƤ硢ɲɤ߹ߤ
			    롣uns_chrѤΥХåե⡢letterѤΤΤ⡢
			    ʪƬѤƤΤաޤ
			    顼硢 顼ΰ֤ˤ餺
			    ߹ԤȤɽΤϡǸɤޤ줿ԤΤ*/
		} else {
			termsscan(socp, dest, 0, cur_rk);
			totail(dest);
			*dest++ = ' ';
		}
	}
	*dest++ = *(*socp)++; /* = ')' */
	*dest = EOLTTR;
}

 /** lpǻꤵ줿⡼̾õĤʤȥ顼 */
static int
modsrcL(lp, cur_rk)
letter	*lp;
ARGS *cur_rk;
{
	int	n;

	for(n = 0; modmeibgn[n] != NULL; n++)
		if(!ltrstrcmp(lp, modmeibgn[n])) return(n);

	ERRLIN(16, cur_rk);
	 /*NOTREACHED*/
	return(-1);
}

 /** chk_get_intrk_modread.cˤletter */
static int
chkL_get_int(lp, ip, range)
letter	*lp;
modetyp	*ip;
modetyp range;
{
	int	sgn = 1;
	modetyp	out;

	if(*lp == '-'){
		lp++;
		sgn = -1;
	}
	for(out = 0; *lp != EOLTTR; lp++){
		if(!is_digit(*lp)) return(-1);
#if defined(UX386) || defined(sun386)
		out = out * 10;
#else
		out *= 10;
#endif
		out += ltov(*lp);
	}
	if(range != 0) out %= range;
	if(sgn == -1 && out != 0) out = range - out;
	*ip = out;
	return(0);
}

 /**	ϡɽɤ߹ߤǥä˷ٹ𤹤롼nϥ顼ɡ
	ޤơromkan_initΥ顼ɤȤơlongjmpͳ
	1֤*/

void
ERMOPN(n, cur_rk) /* ⡼ɽץǤʤ */
unsigned int	n;
ARGS *cur_rk;
{
	static	char	*ermes[] = {
 /*  0 */	"Can't open Mode-hyo",
		"Unprintable error"
	};

	if(n >= numberof(ermes)) n = 1;

	fprintf(stderr, "\r\nMode-hyo %s ---\r\n", curfnm);
	fprintf(stderr, "%d: %s.\r\n", n, ermes[n]);
	longjmp(env0, 1);
}

static void
ERHOPN(n, cur_rk) /* ѴбɽץǤʤ */
unsigned int	n;
ARGS *cur_rk;
{
	static	char	*ermes[] = {
 /*  0 */	"Can't open Taio-hyo",
		"Is a directory",
		"Unprintable error"
	};

	if(n >= numberof(ermes)) n = 2;

	fprintf(stderr, "\r\nTaio-hyo %s%s ---\r\n", curdir, curfnm);
	fprintf(stderr, "%d: %s.\r\n", n, ermes[n]);
	longjmp(env0, 1);
}

void
ERRMOD(n, cur_rk) /* ⡼ɽΥ顼 */
unsigned int	n;
ARGS *cur_rk;
{
	static	char	*ermes[] = {
 /*  0 */	"Table incomplete",
		"')' mismatch",
		"Unprintable error",
		"Illegal filename",
		"Illegal modename",
 /*  5 */	"Undefined mode",
		"Illegal content(s) of list",
		"Illegal ^,\\o,\\x or \\d expression",
		"Illegal defmode",
		"Unrecognized keyword",
 /* 10 */	"Incomplete string",
		"Search path specified after filename",
		"Argument must be a string",
		"Can't get home directory",
		"Illegal @-keyword",
 /* 15 */	"User doesn't exist",
		"Illegal character",
		"Defmode or set-path placed wrong"
	};

	if(n >= numberof(ermes)) n = 2;

	fprintf(stderr, "\r\nMode-hyo %s%s ---\r\n%s\r\n",
		curdir, curfnm, mcurread);
	fprintf(stderr, "%d: %s.\r\n", n, ermes[n]);
	fclose(modefile);
	longjmp(env0, 1);
}

static void
ERRLIN(n, cur_rk) /* ѴбɽΥ顼 */
unsigned int	n;
ARGS *cur_rk;
{
	static	char	*ermes[] = {
 /*  0 */	"')' mismatch",
		"Incomplete single-quote or double-quote expression",
		"Illegal ^,\\o,\\x or \\d expression",
		"Illegal variable name",
		"Incomplete line",
 /*  5 */	"Evaluation of unbound variable",
		"Unprintable error",
		"Too many or too few contents of list",
		"Illegal defvar/defconst",
		"Faculity or declaration joined other item(s)",
 /* 10 */	"Duplicate defvar/defconst",
		"Variable/constant name conflicts with Function name",
		"A line contains both declaration and other output item(s)",
		"Argument isn't a letter",
		"Function, faculity or declaration in illegal place",
 /* 15 */	"More than 3 items",
		"Undefined mode",
		"Against the restriction of pre-transform table",
		"Against the restriction of after-transform table",
		"Item comes after faculity",
 /* 20 */	"Incomplete list",
		"Illegal character",
		"Illegal include",
		"Too many levels of 'include' nest",
		"Can't open include file",
 /* 25 */	"Can't get home directory",
		"Illegal @-keyword",
		"User doesn't exist",
		"Constant must be defined before used",
		"Illegal mode status"
	};

	if(n >= numberof(ermes)) n = 6;

	fprintf(stderr, "\r\nTaio-hyo %s%s ---\r\n%s\r\n",
		curdir, curfnm, hcurread);
	fprintf(stderr, "%d: %s.\r\n", n, ermes[n]);

	while(NULL != *base) fclose(*base--);

	longjmp(env0, 1);
}

static void
ERRHYO(n, cur_rk) 
/* ERRLINƱ͡бɽΥ顼ԤθǤʤ
   Τ򸫤ʤȤ狼ʤꡣνꡢ̤ѿνиפΤߡ*/
unsigned int	n;
ARGS *cur_rk;
{
	static	char	*ermes[] = {
 /*  0 */	"Undefined variable was found",
		"Unprintable error"
	};

	if(n >= numberof(ermes)) n = 1;

	fprintf(stderr, "\r\nTaio-hyo %s%s ---\r\n", curdir, curfnm);
	fprintf(stderr, "%d: %s.\r\n", n, ermes[n]);

	while(NULL != *base) fclose(*base--);

	longjmp(env0, 1);
}
