/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2015 Red Hat, Inc., and individual contributors
 * as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.wildfly.client.config;

/**
 * @author <a href="mailto:david.lloyd@redhat.com">David M. Lloyd</a>
 */
final class DrainingXMLStreamReader extends AbstractDelegatingXMLStreamReader {

    DrainingXMLStreamReader(final boolean closeDelegate, final ConfigurationXMLStreamReader delegate) {
        super(closeDelegate, delegate);
    }

    public void close() throws ConfigXMLParseException {
        try {
            while (hasNext()) {
                next();
            }
            super.close();
        } catch (final Throwable t) {
            try {
                super.close();
            } catch (Throwable t2) {
                t.addSuppressed(t2);
            }
            throw t;
        }
    }
}
