module Project_details
  require_relative 'sisu_version'
  include SiSUversion
  def self.name
    'SiSU'
  end
  def self.thor
    "ruby-thor files for the installation/setup of #{name}"
  end
  def self.platform_notice
    "[#{name} is for Linux/Unix Platforms]"
  end
  def self.env
    RbConfig::CONFIG
  end
  def self.host
    env['host']
  end
  def self.dir
    def self.proj
      Project_details.name.downcase
    end
    def self.arch
      env['archdir']
    end
    def self.sitearch
      env['sitearchdir']
    end
    def self.bin
      env['bindir']
    end
    def self.lib
      env['sitelibdir']
    end
    def self.data
      env['datadir']
    end
    def self.share
      "#{env['datadir']}/sisu"
    end
    def self.conf
      env['sysconfdir']
    end
    def self.man
      env['mandir']
    end
    def self.vim
      "#{env['datadir']}/sisu/vim"
    end
    def self.out
      "#{env['localstatedir']}/#{proj}"
    end
    def self.rubylib
      env['LIBRUBYARG_SHARED']
    end
    def self.pwd
      Dir.pwd #ENV['PWD']
    end
    self
  end
  def self.version
    stamp={}
    v="#{dir.pwd}/data/sisu/version.yml"
    if File.exist?(v)
      stamp=YAML::load(File::open(v))
      stamp[:version]
    else ''
    end
  end
  def self.system_info
    ##{Project_details.platform_notice}
    puts <<-WOK
  Host
    host:             #{Project_details.host}
    arch:             #{Project_details.dir.arch}
    sitearch:         #{Project_details.dir.sitearch}
  Directories for installation
    bin:                                          #{Project_details.dir.bin}
    lib (site-ruby):                              #{Project_details.dir.lib}/#{Project_details.dir.proj}/v*
    conf [etc]:                                   #{Project_details.dir.conf}/#{Project_details.dir.proj}
    data (odf, shared images):                    #{Project_details.dir.share}
    vim  (vim syntax, highlighting, ftplugin):    #{Project_details.dir.data}/sisu/vim
    data (README, version_manifest):              #{Project_details.dir.data}/doc/#{Project_details.dir.proj}
    man (manual pages):                           #{Project_details.dir.man}
    output:                                       #{Project_details.dir.out}
      processing:                                 #{Project_details.dir.out}/processing
      www:                                        #{Project_details.dir.out}/www
    rubylib:                                      #{Project_details.dir.rubylib}

    WOK
  end
  def self.gem_env
    system("gem env")
  end
end
module Utils
  def self.answer?(ask)
    resp='redo'
    print ask + " ['yes', 'no' or 'quit']: "
    resp=File.new('/dev/tty').gets.strip #resp=gets.strip
    if    resp == 'yes'        then true
    elsif resp == 'no'         then false
    elsif resp =~/^quit|exit$/ then exit
    else                       puts "[please type: 'yes', 'no' or 'quit']"
                               answer?(ask)
    end
  end
  def self.default_notice # local help not implemented description incorrect
    ans= %{#{Project_details.thor}
    Information on alternative actions is available using:
    [if ruby-thor is installed:]
      "rake help")
    Default action selected - "install #{Project_details.name}" proceed? }
    resp=answer?(ans)
    exit unless resp
  end
  def self.chmod_file(place)
    if place =~/\/bin/; File.chmod(0755,place)
    else                File.chmod(0644,place)
    end
  end
  def self.chmod_util(place)
    if place =~/\/bin/; chmod(0755,place)
    else                chmod(0644,place)
    end
  end
  def self.system_date
    `date "+%Y-%m-%d"`.strip
  end
  def self.system_date_stamp
    `date "+%Yw%W/%u"`.strip
  end
  def self.program_found?(prog)
    found=`which #{prog}` #`whereis #{make}`
    (found =~/bin\/#{prog}\b/) ? :true : :false
  end
end
module Install
                                                           #%% using a directory and its mapping
  def self.setup_find_create(dir_get,dir_put,exclude_files=['\*'],act)               #primary,
    begin
      Find.find("#{Project_details.dir.pwd}/#{dir_get}") do |f|
        stub=f.scan(/#{Project_details.dir.pwd}\/#{dir_get}\/(\S+)/).join
        place="#{dir_put}/#{stub}"
        action=case
        when File.file?(f)
          unless f =~/#{exclude_files.join("|")}/
            cp(f,place)
            Utils.chmod_file(place)
            "->  #{dir_put}/"
          end
        when File.directory?(f)
          FileUtils.mkpath(place) \
            unless FileTest.directory?(place)
          "./#{dir_get}/"
        else '?'
        end
        puts "#{action}#{stub}"
      end
    rescue
      puts "\n\n<< are you root? required for install >>"
    end
  end
  def self.setup_find_cp_r(dir_get,dir_put)                                    #secondary, using recursive copy
    begin
      Find.find("#{Project_details.dir.pwd}/#{dir_get}") do |f|
        stub=f.scan(/#{Project_details.dir.pwd}\/#{dir_get}\/(\S+)/).join
        place="#{dir_put}/#{stub}"
        case
        when File.file?(f)
          cp_r(f,place)
          Utils.chmod_util(place)
        when File.directory?(f)
          mkdir(place) \
            unless FileTest.directory?(place)
        end
      end
    rescue
      puts "\n\n<< are you root? required for install >>"
    end
  end
end
module Version_info
  def self.contents(vi)
    <<-WOK
---
:project: #{vi[:project]}
:version: #{vi[:version]}
:date_stamp: #{vi[:date_stamp]}
:date: "#{vi[:date]}"
    WOK
  end
  def self.git_version_extract
    if FileTest.file?('/usr/bin/git')
      x=`git describe --long --tags 2>&1`.strip.
        gsub(/^[a-z_-]*([0-9.]+)/,'\1').
        gsub(/([^-]*-g)/,'r\1').
        gsub(/-/,'.')
      x=(x=~/^[0-9]+\.[0-9]+\.[0-9]+\.r[0-9]+\.g[0-9a-f]{7}/) \
      ? x
      : nil
    else nil
    end
  end
  def self.version_number_use(vi)
    (git_version_extract.nil?) \
    ? (vi[:version])
    : git_version_extract
  end
  def self.version_number_info(vi)
    (Version_info.version_number_use(vi) != vi[:version_number]) \
    ? (%{#{vi[:version_number]} from git #{Version_info.version_number_use(vi)}})
    : vi[:version_number]
  end
  def self.version_number_info_stable
    vi=Version_info::Current.setting_stable
    (Version_info.version_number_use(vi) != vi[:version_number]) \
    ? (%{#{vi[:version_number]} from git #{Version_info.version_number_use(vi)}})
    : vi[:version_number]
  end
  module Current
    def self.yml_file_path
      'data/sisu/version.yml'
    end
    def self.settings(file)
      v="#{Dir.pwd}/#{file}"
      if File.exist?(v)
        YAML::load(File::open(v))
      else ''
      end
    end
    def self.file_stable
      yml_file_path
    end
    def self.setting_stable
      hsh=settings(file_stable)
      hsh[:version_number]=/([0-9]+\.[0-9]+\.[0-9]+)/.
        match(hsh[:version])[1]
      hsh
    end
    def self.content_stable
      Version_info.contents(setting_stable)
    end
  end
  module Next
    def self.settings(v)
      {
        project:        "#{Project_details.name}",
        version:        "#{v}",
        date:           "#{Utils.system_date}",
        date_stamp:     "#{Utils.system_date_stamp}",
      }
    end
    def self.setting_stable
      settings(SiSU_version)
    end
    def self.content_stable
      Version_info.contents(setting_stable)
    end
  end
  module Update
    def self.version_info_update_commit(filename,vi_hash_current,vi_content_current,vi_hash_next,vi_content_next)
      ans=%{update #{Project_details.name.downcase} version info replacing:
  #{vi_hash_current.sort}
with:
  #{vi_hash_next.sort}

#{vi_content_current} becoming:
#{vi_content_next}
proceed? }
      resp=Utils.answer?(ans)
      if resp
        fn="#{Dir.pwd}/#{filename}"
        if File.writable?("#{Dir.pwd}/.")
          file_version=File.new(fn,'w+')
          file_version << vi_content_next
          file_version.close
        else
          puts %{*WARN* is the file or directory writable? could not create #{filename}}
        end
      end
    end
    def self.update_stable
      version_info_update_commit(
        Version_info::Current.file_stable,
        Version_info::Current.setting_stable,
        Version_info::Current.content_stable,
        Version_info::Next.setting_stable,
        Version_info::Next.content_stable
      )
    end
    def self.changelog_header(vi)
      <<-WOK
-- #{vi[:version]}.orig.tar.xz (#{vi[:date]}:#{vi[:date_stamp].gsub(/20\d\dw/,'')})
http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=log;h=refs/tags/sisu_#{vi[:version]}
http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=log;h=refs/tags/debian/sisu_#{vi[:version]}-1
http://www.jus.uio.no/sisu/pkg/src/sisu_#{vi[:version]}.orig.tar.xz
  sisu_#{vi[:version]}.orig.tar.xz
  sisu_#{vi[:version]}-1.dsc
      WOK
    end
    def self.changelog_header_stable
      changelog_header(Version_info::Current.setting_stable)
    end
  end
  self
end
module GitExtractTaggedVersionBuild
  def upstream
    system(%{ git checkout upstream })
  end
  def self.git_tagged_versions(vb=nil)
    if vb.tag
      v=if  vb.tag =~/sisu_[0-9](?:\.[0-9]){0,2}$/ then vb.tag
      elsif vb.tag =~/^[0-9](?:\.[0-9]){0,2}$/     then 'sisu_' + vb.tag
      else                                              'sisu_'
      end
      system(%{ git tag -l | ag --nocolor '^#{v}' })
    end
  end
  def self.git_checkout_and_build_version(vb)
    begin
      ver=if vb.tag =~/sisu_[0-9]\.[0-9]+\.[0-9]+/ then vb.tag
      elsif  vb.tag =~/^[0-9]\.[0-9]+\.[0-9]+/     then 'sisu_' + vb.tag
      else                                               vb.branch
      end
      install_branch='gem_create_build_stable'
      commands =<<-WOK
        git checkout #{ver} &&
        rake #{install_branch};
      WOK
      puts commands
      system(commands)
    ensure
      system(%{
        git checkout upstream
      })
    end
  end
  def self.git_checkout_and_build_and_install_version(vb)
    begin
      ver=if vb.tag =~/sisu_[0-9]\.[0-9]+\.[0-9]+/ then vb.tag
      elsif  vb.tag =~/^[0-9]\.[0-9]+\.[0-9]+/     then 'sisu_' + vb.tag
      else                                               vb.branch
      end
      install_branch='gem_create_build_install_stable'
      commands =<<-WOK
        git checkout #{ver} &&
        rake #{install_branch};
      WOK
      puts commands
      system(commands)
    ensure
      system(%{
        git checkout upstream
      })
    end
  end
end
module Gemspecs
  def self.info(vi)
    puts <<-WOK
--
name:       #{vi[:project].downcase}
version:    #{vi[:version_number]}
date:       #{vi[:date]}
summary:    #{vi[:project]}
    WOK
  end
  def self.contents(vi)
    #s.summary        = '#{vi[:project]}'
    <<-WOK
Gem::Specification.new do |s|
  s.name           = '#{vi[:project].downcase}'
  s.version        = '#{vi[:version_number]}'
  s.date           = '#{vi[:date]}'
  s.summary        = '#{Version_info.version_number_info(vi)}'
  s.description    = 'documents - structuring, publishing in multiple formats and search'
  s.authors        = ["Ralph Amissah"]
  s.email          = 'ralph.amissah@gmail.com'
  s.files          = Dir['lib/#{Project_details.name.downcase}/*.rb'] +
                     Dir['data/#{Project_details.name.downcase}/version.yml'] +
                     Dir['data/#{Project_details.name.downcase}/image/*'] +
                     Dir['bin/#{Project_details.name.downcase}gem'] +
                     Dir['bin/#{Project_details.name.downcase}']
  s.license        = 'GPL-3.0-or-later'
  s.executables << '#{Project_details.name.downcase}gem' << '#{Project_details.name.downcase}'
end
    WOK
  end
  def self.create(filename,gemspec)
    fn="#{Dir.pwd}/#{filename}.gemspec"
    if File.writable?("#{Dir.pwd}/.")
      file_sisu_gemspec=File.new(fn,'w+')
      file_sisu_gemspec << gemspec
      file_sisu_gemspec.close
    else
      puts %{*WARN* is the file or directory writable? could not create #{filename}}
    end
  end
  def self.build(fn)
    system(%{ gem build #{fn}.gemspec })
  end
  def self.install(fn)
    system(%{
      sudo gem install --no-document --verbose #{fn}.gem
    })
  end
  module Current
    def self.filename_stable
      Project_details.name.downcase \
      + '-' \
      + Version_info::Current.setting_stable[:version_number]
    end
    def self.info_stable
      Gemspecs.info(Version_info::Current.setting_stable)
    end
    def self.current_stable
      Gemspecs.contents(
        Version_info::Current.setting_stable,
      )
    end
    def self.create_stable
      Gemspecs.create(filename_stable,current_stable)
      Gemspecs.create(
        "#{Project_details.name.downcase}-stable",
        current_stable
      )
    end
    def self.build_stable
      Gemspecs.build(filename_stable)
    end
    def self.install_stable
      Gemspecs.install(filename_stable)
    end
  end
  module Next
    def self.filename_stable
      Project_details.name.downcase \
      + '-' \
      + Version_info::Next.setting_stable[:version_number]
    end
    def self.setting_stable
      Gemspecs.contents(
        Version_info::Next.setting_stable,
      )
    end
    def self.create_stable
      Gemspecs.create(filename_stable,setting_stable)
    end
    def self.build_stable
      Gemspecs.build(filename_stable)
    end
    def self.install_stable
      Gemspecs.install(filename_stable)
    end
  end
end
