// -*- Mode: C++; -*-
//
// MacSpecific.cpp
//
// Copyright (C) 2002-2003 Wolfgang Textor, CoDesCo GmbH.
// Parts Copyright (C) 2002-2003 Dieter Kohl, Quark Deutschland GmbH.
//                               Malge Nishant, Quark India, Inc.
//
// You may redistribute and/or modify this software under the terms of
// the GNU Lesser General Public License.
//
// Description:
//    Mac OS specific code needed for port of omniORB.
//
// This work is not endorsed or supported by any of the named companies.

/*
 $Log: $
*/

#ifdef	__MACH__

int sched_yield(void)
{
	return 0;
}

#else

#include <unistd.h>
#include <Processes.h>

/*!!
	We have to define getpid here, since GUSI doesn't define it, and
	CodeWarrior would have provided an inline function.
	
	-- dk 5. Dec. 2002 --
*/
long getpid(void)
{
	long myResult = 0;
	ProcessSerialNumber myProcessNumber;
	OSErr myErr = MacGetCurrentProcess(&myProcessNumber);
	if (myErr == noErr) {
		myResult = myProcessNumber.lowLongOfPSN;
	}
	
	return (myResult);
}


/*!!
	The following is required to be able to link the shared version at all.

	
	-- dk 5. Dec. 2002 --
*/
extern int __aborting;
int __aborting = 0;


#endif
