/////////////////////////////////////////////////////////////////////////////
// $Header: $
//
// Copyright (c) 1999 ConnectTel, Inc. All Rights Reserved.
//  
// MODULE DESCRIPTION:
//
//  RTEMS Init Task for omniORB3 applications. It is impornat to make
//  suere at all rtems resources are allocated properly by the file
//  rtemscfg.h and the network setup match your target. See net_cfg.h
//  for the definition.
//
//  by: Rosimildo da Silva:
//      rdasilva@connecttel.com
//      http://www.connecttel.com
//
// ***********************************************************************
// Some of the code in this module was fragments of messages sent by
// Chris Johns to the rtems-users mail list. I am adding the copyright
// of his file here. I hope this is enough. :-)
//
//  Copyright (C) Objective Design Systems Ltd Pty 1992-1999
//  All rights reserved (R) Objective Design Systems Ltd Pty 1992-1999
//
//  Refer to the file LICENSE for detailed terms of usage and warranty.
//  The LICENSE file must be provided with the file.
//
//  This software with is provided ``as is'' and with NO WARRANTY.
// ***********************************************************************
//
//
// MODIFICATION/HISTORY:
// $Log: $
//
/////////////////////////////////////////////////////////////////////////////

#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>

/* omniORB includes */
#include <omnithread.h>
#include <omniORB3/CORBA.h>
#include <omniORB3/omniORB.h>


#define  CONFIGURE_INIT
extern "C" {
#include "rtemscfg.h"
#include "net_cfg.h"
}

//
// Enable the following define if you want to 
// debug this application using the remote GDB.
// Basically, it stalls the GDB stubs along with
// application.
// NOTE: This is PC386 specific, and should not be
//       enabled for other BSPs.
// #define USE_REMOTE_GDB__
#ifdef USE_REMOTE_GDB__
#include <uart.h>

#define BREAKPOINT() asm("   int $3");
extern int BSPConsolePort;

 /* Init GDB glue  */
void init_remote_gdb( void )
{
  if(BSPConsolePort != BSP_UART_COM2)
    {
      /*
       * If com2 is not used as console use it for
       * debugging
       */

      i386_stub_glue_init(BSP_UART_COM2);
      printf( "Remote GDB using COM2...\n" );

    }
  else
    {
      /* Otherwise use com1 */
      i386_stub_glue_init(BSP_UART_COM1);
      printf( "Remote GDB using COM1...\n" );
    }

  printf( "Remote GDB: setting traps...\n" );
  /* Init GDB stub itself */
  set_debug_traps();

  printf( "Remote GDB: waiting remote connection....\n" );

  /*
   * Init GDB break in capability,
   * has to be called after
   * set_debug_traps
   */
  i386_stub_glue_init_breakin();

  /* Put breakpoint in */
  /* BREAKPOINT();     */
}
#endif  // USE_REMOTE_GDB__


//
// Table of directories to make. Please list here
// and file that you intend to use.
// 

static const char *directories[] =
{
  "/etc",
  0
};

/*
 * /etc/host.conf controls the resovler.
 */

static const char *etc_host_conf[] =
{
  "/etc/host.conf",
  "hosts,bind\n",
  0
};

/*
 * Create enough files to support the networking stack.
 */
 
static int
make_dirs (const char **dir_table)
{
  /*
   * Create the directory.
   */

  while (*dir_table)
  {
    if (mkdir (*dir_table, 0755) < 0)
    {
      printf ("root fs, cannot make `%s' : %s\n", *dir_table, strerror (errno));
      return -1;
    }
//    printf( "mkdir: %s\n",  *dir_table );
    dir_table++;
  }
  return 0;
}


/*
 * Create enough files to support the networking stack.
 */

static int open_and_write_file (const char **file_table)
{
  int    len;
  FILE   *fp;

  if( ( fp= fopen( *file_table  ,"wt" ) ) == NULL )
  {
      fprintf(stderr, "unable to open output file %s\n", *file_table );
      return 0;
  }
  file_table++;
  while( *file_table )
  {
    len = fwrite( *file_table , 1, strlen( *file_table ), fp );
    if( len <= 0 )
	 {
      printf ("root fs, cannot write `%s' : %s\n", *file_table, strerror (errno));
      return 0;
    }
    file_table++;
  }
  fclose( fp );
  return 1;
}

/*
 * Create a root file system.
 */

int
rtems_create_root_fs (void *bcfg)
{
  /*
   * Create the directories.
   */

  if (make_dirs (directories) < 0)
    return -1;

  /*
   * Create a `/etc/hosts' file.
   */

  if( open_and_write_file (etc_hosts) < 0)
    return -1;

  /*
   * Create a `/etc/host.conf' file.
   */

  if( open_and_write_file (etc_host_conf) < 0)
    return -1;

  return 0;
}



/* this is the command line options to be passed to the ORB */

// IMPORTANT: ** CHANGE THIS FOR YOUR TARGET **
// The command line paramters here to be passed to the ORB is
// specific of the setup that use to test. "rps1" is the name
// of the machine where the naming service is running, and 
// 6000 is the port number that I use to start omniNames.
//
char *cc_argv[] = 
{
	"cc_main",              /* always the name of the program */
	"-ORBInitialHost",
   HOST_OMNINAMES_HOST_NAME,   /* machine running omniNames */
	"-ORBInitialPort",
   HOST_OMNINAMES_PORT_NUMBER, /* port number that omniNames uses */
   "-ORBtraceLevel",       /* trace level */
	"20"
};
int cc_argc = sizeof( cc_argv ) / sizeof( cc_argv[ 0 ]  );


//
// this is the user's entry point. It should match the "main()"
// function in a regular C/C+prgram.
//
extern int cc_main(int argc, char **argv);


CORBA::Boolean rtems_transient_handler
( 
   void *cookie, 
   CORBA::ULong retries, 
   const CORBA::TRANSIENT & ex 
)
{
   printf( "Trasient Handler called: %ld\n", retries );
   return 1;
}


CORBA::Boolean rtems_COMM_FAILURE_handler
( 
   void *cookie, 
   CORBA::ULong retries, 
   const CORBA::COMM_FAILURE & ex 
)
{
   printf( "COMM_FAILURE HANDLER called: %ld\n", retries );
   return 1;
}


CORBA::Boolean rtems_SystemException_handler
( 
   void *cookie, 
   CORBA::ULong retries, 
   const CORBA::SystemException & ex 
)
{
   printf( "SystemException HANDLER called: %ld\n", retries );
   return 1;
}


static void installHandlers()
{
  printf( "Installing RTEMS exception handlers\n" );
  omniORB::installTransientExceptionHandler( 0, rtems_transient_handler );  
  omniORB::installCommFailureExceptionHandler( 0, rtems_COMM_FAILURE_handler );  
  omniORB::installSystemExceptionHandler( 0, rtems_SystemException_handler );  
}

/////////////////////////////////////////////////////////////////////////////
// DESCRIPTION: Init task for any omniORB/RTEMS application.
/////////////////////////////////////////////////////////////////////////////
void *POSIX_Init( void *argument )
{

#ifdef USE_REMOTE_GDB__
  init_remote_gdb();
  BREAKPOINT();
#endif

  //
  // This call does some preliminary initalization of the file
  // system, creating all necessary files used by the network
  // TCP/IP stack, such as /etc/hosts, etc.
  //
  rtems_create_root_fs( 0 );

  // RTEMS calls the global Ctor/Dtor in a context that is not
  // a posix thread. Calls to functions such as pthread_self()
  // returns NULL. So, for RTEMS let's make the thread 
  // initialization here. This is Ok as long as the cc_main()
  // routine stays running for the life time of the application.
  omni_thread::init_t omni_thread_init;

  printf( "\n\n*** CORBA omniORB2 - Echo test programs ***\n" );
  /* Make all network initialization */
  rtems_bsdnet_initialize_network();
  printf( "Netowrk Initialization is complete.\n\n" );

  pthread_attr_t attr;
  size_t st = 0;
  pthread_attr_init(&attr);
  pthread_attr_getstacksize( &attr, &st );

  st = _Thread_Executing->Start.Initial_stack.size;

  printf( "Init Task Stack Size is: %d\n", st );

  // Uncomment the following lines if you want disable the 
  // connection management of omniORB. - See documentation
  // omniORB::idleConnectionScanPeriod( omniORB::idleIncoming, 0 );
  // omniORB::idleConnectionScanPeriod( omniORB::idleOutgoing, 0 );

  // install the exception handlers for the omniORB run-time.
  // Check documentation to see how they could be activated
  // and which cases you should use them.

  // installHandlers();

  // Call omniORB example
  cc_main( cc_argc, cc_argv );
  printf( "*** Done ***\n\n\n" );
  pthread_exit( NULL );
  return NULL; /* just so the compiler thinks we returned something */
}


