#===============================================================================
# Copyright 2014 NetApp, Inc. All Rights Reserved,
# contribution by Jorge Mora <mora@netapp.com>
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 2 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#===============================================================================
# Generated by process_xdr.py from packet/nfs/portmap2.x on Thu May 20 14:00:23 2021
"""
PORTMAPv2 decoding module
"""
import nfstest_config as c
from packet.utils import *
from baseobj import BaseObj
from packet.unpack import Unpack
import packet.nfs.portmap2_const as const

# Module constants
__author__    = "Jorge Mora (%s)" % c.NFSTEST_AUTHOR_EMAIL
__copyright__ = "Copyright (C) 2014 NetApp, Inc."
__license__   = "GPL v2"
__version__   = "2.0"

class proto2(Enum):
    """enum proto2"""
    _enumdict = const.proto2

# Procedures
class portmap_proc2(Enum):
    """enum portmap_proc2"""
    _offset   = 9
    _enumdict = const.portmap_proc2

# Program Numbers
class portmap_prog2(Enum):
    """enum portmap_prog2"""
    _enumdict = const.portmap_prog2

class mapping(BaseObj):
    """
       struct mapping {
           portmap_prog2 prog;
           unsigned int  vers;
           proto2        prot;
           unsigned int  port;
       };
    """
    # Class attributes
    _strfmt1  = "prog:{0} vers:{1} proto:{2} port:{3}"
    _attrlist = ("prog", "vers", "prot", "port")

    def __init__(self, unpack):
        self.prog = portmap_prog2(unpack)
        self.vers = unpack.unpack_uint()
        self.prot = proto2(unpack)
        self.port = unpack.unpack_uint()

class SET2args(mapping): pass
class UNSET2args(mapping): pass
class GETPORT2args(mapping): pass

class entry2(BaseObj):
    """
       struct entry2 {
           mapping map;
           entry2  *next;
       };
    """
    # Class attributes
    _strfmt1  = "{0}"
    _attrlist = ("map",)

    def __init__(self, unpack):
        self.map = mapping(unpack)

class DUMP2res(BaseObj):
    """
       struct DUMP2res {
           entry2 *entries;
       };
    """
    # Class attributes
    _strfmt1  = "{0}"
    _attrlist = ("entries",)

    def __init__(self, unpack):
        self.entries = unpack.unpack_list(mapping)

class CALLIT2args(BaseObj):
    """
       struct CALLIT2args {
           portmap_prog2 prog;
           unsigned int  vers;
           unsigned int  proc;
           opaque        args<>;
       };
    """
    # Class attributes
    _strfmt1  = "prog:{0} vers:{1} proc:{2}"
    _attrlist = ("prog", "vers", "proc", "args")

    def __init__(self, unpack):
        self.prog = portmap_prog2(unpack)
        self.vers = unpack.unpack_uint()
        self.proc = unpack.unpack_uint()
        self.args = unpack.unpack_opaque()

class CALLIT2res(BaseObj):
    """
       struct CALLIT2res {
           unsigned int port;
           opaque       res<>;
       };
    """
    # Class attributes
    _strfmt1  = "port:{0} res:{1:#x}"
    _attrlist = ("port", "res")

    def __init__(self, unpack):
        self.port = unpack.unpack_uint()
        self.res  = unpack.unpack_opaque()

class bool_res(BaseObj):
    """
       struct bool_res {
           bool result;
       };
    """
    # Class attributes
    _strfmt1  = "{0}"
    _attrlist = ("result",)

    def __init__(self, unpack):
        self.result = nfs_bool(unpack)

class SET2res(bool_res): pass
class UNSET2res(bool_res): pass

class GETPORT2res(BaseObj):
    """
       struct GETPORT2res {
           unsigned int result;
       };
    """
    # Class attributes
    _strfmt1  = "{0}"
    _attrlist = ("result",)

    def __init__(self, unpack):
        self.result = unpack.unpack_uint()

class PORTMAP2args(RPCload):
    """
       union switch PORTMAP2args (portmap_proc2 procedure) {
           case const.PMAPPROC_NULL:
               void;
           case const.PMAPPROC_SET:
               SET2args opset;
           case const.PMAPPROC_UNSET:
               UNSET2args opunset;
           case const.PMAPPROC_GETPORT:
               GETPORT2args opgetport;
           case const.PMAPPROC_DUMP:
               void;
           case const.PMAPPROC_CALLIT:
               CALLIT2args opcallit;
       };
    """
    # Class attributes
    _strname = "PORTMAP"

    def __init__(self, unpack, procedure):
        self.set_attr("procedure", portmap_proc2(procedure))
        if self.procedure == const.PMAPPROC_NULL:
            self.set_strfmt(2, "NULL()")
        elif self.procedure == const.PMAPPROC_SET:
            self.set_attr("opset", SET2args(unpack), switch=True)
        elif self.procedure == const.PMAPPROC_UNSET:
            self.set_attr("opunset", UNSET2args(unpack), switch=True)
        elif self.procedure == const.PMAPPROC_GETPORT:
            self.set_attr("opgetport", GETPORT2args(unpack), switch=True)
        elif self.procedure == const.PMAPPROC_DUMP:
            self.set_strfmt(2, "DUMP2args()")
        elif self.procedure == const.PMAPPROC_CALLIT:
            self.set_attr("opcallit", CALLIT2args(unpack), switch=True)
        self.argop = self.procedure
        self.op    = self.procedure

class PORTMAP2res(RPCload):
    """
       union switch PORTMAP2res (portmap_proc2 procedure) {
           case const.PMAPPROC_NULL:
               void;
           case const.PMAPPROC_SET:
               SET2res opset;
           case const.PMAPPROC_UNSET:
               UNSET2res opunset;
           case const.PMAPPROC_GETPORT:
               GETPORT2res opgetport;
           case const.PMAPPROC_DUMP:
               DUMP2res opdump;
           case const.PMAPPROC_CALLIT:
               CALLIT2res opcallit;
       };
    """
    # Class attributes
    _strname = "PORTMAP"

    def __init__(self, unpack, procedure):
        self.set_attr("procedure", portmap_proc2(procedure))
        if self.procedure == const.PMAPPROC_NULL:
            self.set_strfmt(2, "NULL()")
        elif self.procedure == const.PMAPPROC_SET:
            self.set_attr("opset", SET2res(unpack), switch=True)
        elif self.procedure == const.PMAPPROC_UNSET:
            self.set_attr("opunset", UNSET2res(unpack), switch=True)
        elif self.procedure == const.PMAPPROC_GETPORT:
            self.set_attr("opgetport", GETPORT2res(unpack), switch=True)
        elif self.procedure == const.PMAPPROC_DUMP:
            self.set_attr("opdump", DUMP2res(unpack), switch=True)
        elif self.procedure == const.PMAPPROC_CALLIT:
            self.set_attr("opcallit", CALLIT2res(unpack), switch=True)
        self.resop = self.procedure
        self.op    = self.procedure
