// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

using System;

namespace System.Runtime.InteropServices
{
    /// <summary>
    ///     The McgWindowsRuntimeVersionAttribute is generated by MCG to indicate what version the code
    ///     generated for a WinRT type is meant to support.   This is distinct from the WinRT Version attribute
    ///     in that the WinRT attribute indicates the minimum version required to use the decorated item.
    ///     This attribute indicates the maximum version that the generated code can be used for.
    ///
    ///     For example, if a WinRT class has a Version(8), and an Activatable(9) attribute, then it would
    ///     get a McgWindowsRuntimeVersionAttribute(9) indicating that it has code to support up to version 9
    ///     of the type (when the activatable attribute was added).
    /// </summary>
    [AttributeUsage(AttributeTargets.Class | AttributeTargets.Delegate | AttributeTargets.Enum | AttributeTargets.Interface | AttributeTargets.Struct, AllowMultiple = false, Inherited = false)]
    public sealed class McgWindowsRuntimeVersionAttribute : Attribute
    {
        public McgWindowsRuntimeVersionAttribute(int version)
        {
        }
    }
}
