#ifndef __INPUT_H__ /* file wrapper */
#define __INPUT_H__
/*
 * Jeffrey Friedl
 * Omron Corporation			ʳ
 * Nagaokakyoshi, Japan			617Ĺ
 *
 * jfriedl@nff.ncl.omron.co.jp
 *
 * This work is placed under the terms of the GNU General Purpose License
 * (the "GNU Copyleft").
 */
#if USE_LOCAL_INPUT

#  define INPUT_BUF_SIZE 100
#  define STDIN 0

    extern int __input_pending__(void);
    extern unsigned char next_raw_input_byte(void);
    extern unsigned char next_cooked_input_byte(void);
    extern int flush_pending_input(void);
    extern void (*input_inactivity_function)();
    extern void ensure_blocking_input(void);

#   define input_pending() (preread_input_pending || __input_pending__())

#else /* don't USE_LOCAL_INPUT */

    static __inline__ input_pending(void)
    {
	return 0;
    }

    static __inline__ unsigned char
    next_raw_input_byte(void)
    {
	unsigned char c;
	read(0, &c, 1);
	return c;
    }

    static __inline__ unsigned char
    next_cooked_input_byte(void)
    {
	unsigned char c;
	set_tty_state_to_cbreak();
	c = next_raw_input_byte();
	reset_tty_state();
	return c;
    }

    static __inline__ int
    flush_pending_input(void)
    {
	return 0;
    }

    static __inline__ void
    ensure_blocking_input(void)
    {
    }


#endif /* USE_LOCAL_INPUT */
#endif /* file wrapper */
