//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef LLDB_PLUGINS_SCRIPTINTERPRETER_PYTHON_INTERFACES_SCRIPTEDFRAMEPYTHONINTERFACE_H
#define LLDB_PLUGINS_SCRIPTINTERPRETER_PYTHON_INTERFACES_SCRIPTEDFRAMEPYTHONINTERFACE_H

#include "lldb/Host/Config.h"

#if LLDB_ENABLE_PYTHON

#include "ScriptedPythonInterface.h"
#include "lldb/Interpreter/Interfaces/ScriptedFrameInterface.h"
#include <optional>

namespace lldb_private {
class ScriptedFramePythonInterface : public ScriptedFrameInterface,
                                     public ScriptedPythonInterface {
public:
  ScriptedFramePythonInterface(ScriptInterpreterPythonImpl &interpreter);

  llvm::Expected<StructuredData::GenericSP>
  CreatePluginObject(llvm::StringRef class_name, ExecutionContext &exe_ctx,
                     StructuredData::DictionarySP args_sp,
                     StructuredData::Generic *script_obj = nullptr) override;

  llvm::SmallVector<AbstractMethodRequirement>
  GetAbstractMethodRequirements() const override {
    return llvm::SmallVector<AbstractMethodRequirement>({{"get_id"}});
  }

  lldb::user_id_t GetID() override;

  lldb::addr_t GetPC() override;

  std::optional<SymbolContext> GetSymbolContext() override;

  std::optional<std::string> GetFunctionName() override;

  std::optional<std::string> GetDisplayFunctionName() override;

  bool IsInlined() override;

  bool IsArtificial() override;

  bool IsHidden() override;

  StructuredData::DictionarySP GetRegisterInfo() override;

  std::optional<std::string> GetRegisterContext() override;

  lldb::ValueObjectListSP GetVariables() override;

  lldb::ValueObjectSP
  GetValueObjectForVariableExpression(llvm::StringRef expr, uint32_t options,
                                      Status &status) override;
};
} // namespace lldb_private

#endif // LLDB_ENABLE_PYTHON
#endif // LLDB_PLUGINS_SCRIPTINTERPRETER_PYTHON_INTERFACES_SCRIPTEDFRAMEPYTHONINTERFACE_H
