//===- AArch64ErrataFix.h ---------------------------------------*- C++ -*-===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef LLD_ELF_AARCH64ERRATAFIX_H
#define LLD_ELF_AARCH64ERRATAFIX_H

#include "lld/Common/LLVM.h"
#include "llvm/ADT/DenseMap.h"
#include <vector>

namespace lld::elf {
struct Ctx;
class Defined;
class InputSection;
class InputSectionDescription;
class Patch843419Section;

class AArch64Err843419Patcher {
public:
  AArch64Err843419Patcher(Ctx &ctx) : ctx(ctx) {}
  // return true if Patches have been added to the OutputSections.
  bool createFixes();

private:
  std::vector<Patch843419Section *>
  patchInputSectionDescription(InputSectionDescription &isd);

  void insertPatches(InputSectionDescription &isd,
                     std::vector<Patch843419Section *> &patches);

  void init();

  Ctx &ctx;
  // A cache mapping InputSections to pairs of section symbols (first) and
  // the mapping symbols (second) defined by the InputSection sorted in order
  // of ascending value with redundant symbols removed. These describe the
  // ranges of code and data in an executable InputSection.
  llvm::DenseMap<InputSection *,
                 std::pair<Defined *, SmallVector<Defined *, 0>>>
      sectionMap;

  bool initialized = false;
};

} // namespace lld::elf

#endif
