; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+zve64x -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV32,RV32I
; RUN: llc -mtriple=riscv64 -mattr=+zve64x -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV64,RV64I
; RUN: llc -mtriple=riscv32 -mattr=+v,+d -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV32,RV32D
; RUN: llc -mtriple=riscv64 -mattr=+v,+d -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV64,RV64D

define <vscale x 1 x i8> @ctlz_nxv1i8(<vscale x 1 x i8> %va) {
; RV32I-LABEL: ctlz_nxv1i8:
; RV32I:       # %bb.0:
; RV32I-NEXT:    vsetvli a0, zero, e8, mf8, ta, mu
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 2
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vxor.vi v8, v8, -1
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    li a0, 85
; RV32I-NEXT:    vand.vx v9, v9, a0
; RV32I-NEXT:    vsub.vv v8, v8, v9
; RV32I-NEXT:    li a0, 51
; RV32I-NEXT:    vand.vx v9, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v9, v8
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v9
; RV32I-NEXT:    vand.vi v8, v8, 15
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ctlz_nxv1i8:
; RV64I:       # %bb.0:
; RV64I-NEXT:    vsetvli a0, zero, e8, mf8, ta, mu
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 2
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vxor.vi v8, v8, -1
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    li a0, 85
; RV64I-NEXT:    vand.vx v9, v9, a0
; RV64I-NEXT:    vsub.vv v8, v8, v9
; RV64I-NEXT:    li a0, 51
; RV64I-NEXT:    vand.vx v9, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v9, v8
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v9
; RV64I-NEXT:    vand.vi v8, v8, 15
; RV64I-NEXT:    ret
;
; RV32D-LABEL: ctlz_nxv1i8:
; RV32D:       # %bb.0:
; RV32D-NEXT:    vsetvli a0, zero, e32, mf2, ta, mu
; RV32D-NEXT:    vzext.vf4 v9, v8
; RV32D-NEXT:    vfcvt.f.xu.v v9, v9
; RV32D-NEXT:    vsrl.vi v9, v9, 23
; RV32D-NEXT:    vsetvli zero, zero, e16, mf4, ta, mu
; RV32D-NEXT:    vnsrl.wx v9, v9, zero
; RV32D-NEXT:    vsetvli zero, zero, e8, mf8, ta, mu
; RV32D-NEXT:    vnsrl.wx v9, v9, zero
; RV32D-NEXT:    li a0, 134
; RV32D-NEXT:    vmseq.vi v0, v8, 0
; RV32D-NEXT:    vrsub.vx v8, v9, a0
; RV32D-NEXT:    vmerge.vim v8, v8, 8, v0
; RV32D-NEXT:    ret
;
; RV64D-LABEL: ctlz_nxv1i8:
; RV64D:       # %bb.0:
; RV64D-NEXT:    vsetvli a0, zero, e32, mf2, ta, mu
; RV64D-NEXT:    vzext.vf4 v9, v8
; RV64D-NEXT:    vfcvt.f.xu.v v9, v9
; RV64D-NEXT:    vsrl.vi v9, v9, 23
; RV64D-NEXT:    vsetvli zero, zero, e16, mf4, ta, mu
; RV64D-NEXT:    vnsrl.wx v9, v9, zero
; RV64D-NEXT:    vsetvli zero, zero, e8, mf8, ta, mu
; RV64D-NEXT:    vnsrl.wx v9, v9, zero
; RV64D-NEXT:    li a0, 134
; RV64D-NEXT:    vmseq.vi v0, v8, 0
; RV64D-NEXT:    vrsub.vx v8, v9, a0
; RV64D-NEXT:    vmerge.vim v8, v8, 8, v0
; RV64D-NEXT:    ret
  %a = call <vscale x 1 x i8> @llvm.ctlz.nxv1i8(<vscale x 1 x i8> %va, i1 false)
  ret <vscale x 1 x i8> %a
}
declare <vscale x 1 x i8> @llvm.ctlz.nxv1i8(<vscale x 1 x i8>, i1)

define <vscale x 2 x i8> @ctlz_nxv2i8(<vscale x 2 x i8> %va) {
; RV32I-LABEL: ctlz_nxv2i8:
; RV32I:       # %bb.0:
; RV32I-NEXT:    vsetvli a0, zero, e8, mf4, ta, mu
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 2
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vxor.vi v8, v8, -1
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    li a0, 85
; RV32I-NEXT:    vand.vx v9, v9, a0
; RV32I-NEXT:    vsub.vv v8, v8, v9
; RV32I-NEXT:    li a0, 51
; RV32I-NEXT:    vand.vx v9, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v9, v8
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v9
; RV32I-NEXT:    vand.vi v8, v8, 15
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ctlz_nxv2i8:
; RV64I:       # %bb.0:
; RV64I-NEXT:    vsetvli a0, zero, e8, mf4, ta, mu
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 2
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vxor.vi v8, v8, -1
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    li a0, 85
; RV64I-NEXT:    vand.vx v9, v9, a0
; RV64I-NEXT:    vsub.vv v8, v8, v9
; RV64I-NEXT:    li a0, 51
; RV64I-NEXT:    vand.vx v9, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v9, v8
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v9
; RV64I-NEXT:    vand.vi v8, v8, 15
; RV64I-NEXT:    ret
;
; RV32D-LABEL: ctlz_nxv2i8:
; RV32D:       # %bb.0:
; RV32D-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; RV32D-NEXT:    vzext.vf4 v9, v8
; RV32D-NEXT:    vfcvt.f.xu.v v9, v9
; RV32D-NEXT:    vsrl.vi v9, v9, 23
; RV32D-NEXT:    vsetvli zero, zero, e16, mf2, ta, mu
; RV32D-NEXT:    vnsrl.wx v9, v9, zero
; RV32D-NEXT:    vsetvli zero, zero, e8, mf4, ta, mu
; RV32D-NEXT:    vnsrl.wx v9, v9, zero
; RV32D-NEXT:    li a0, 134
; RV32D-NEXT:    vmseq.vi v0, v8, 0
; RV32D-NEXT:    vrsub.vx v8, v9, a0
; RV32D-NEXT:    vmerge.vim v8, v8, 8, v0
; RV32D-NEXT:    ret
;
; RV64D-LABEL: ctlz_nxv2i8:
; RV64D:       # %bb.0:
; RV64D-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; RV64D-NEXT:    vzext.vf4 v9, v8
; RV64D-NEXT:    vfcvt.f.xu.v v9, v9
; RV64D-NEXT:    vsrl.vi v9, v9, 23
; RV64D-NEXT:    vsetvli zero, zero, e16, mf2, ta, mu
; RV64D-NEXT:    vnsrl.wx v9, v9, zero
; RV64D-NEXT:    vsetvli zero, zero, e8, mf4, ta, mu
; RV64D-NEXT:    vnsrl.wx v9, v9, zero
; RV64D-NEXT:    li a0, 134
; RV64D-NEXT:    vmseq.vi v0, v8, 0
; RV64D-NEXT:    vrsub.vx v8, v9, a0
; RV64D-NEXT:    vmerge.vim v8, v8, 8, v0
; RV64D-NEXT:    ret
  %a = call <vscale x 2 x i8> @llvm.ctlz.nxv2i8(<vscale x 2 x i8> %va, i1 false)
  ret <vscale x 2 x i8> %a
}
declare <vscale x 2 x i8> @llvm.ctlz.nxv2i8(<vscale x 2 x i8>, i1)

define <vscale x 4 x i8> @ctlz_nxv4i8(<vscale x 4 x i8> %va) {
; RV32I-LABEL: ctlz_nxv4i8:
; RV32I:       # %bb.0:
; RV32I-NEXT:    vsetvli a0, zero, e8, mf2, ta, mu
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 2
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vxor.vi v8, v8, -1
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    li a0, 85
; RV32I-NEXT:    vand.vx v9, v9, a0
; RV32I-NEXT:    vsub.vv v8, v8, v9
; RV32I-NEXT:    li a0, 51
; RV32I-NEXT:    vand.vx v9, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v9, v8
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v9
; RV32I-NEXT:    vand.vi v8, v8, 15
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ctlz_nxv4i8:
; RV64I:       # %bb.0:
; RV64I-NEXT:    vsetvli a0, zero, e8, mf2, ta, mu
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 2
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vxor.vi v8, v8, -1
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    li a0, 85
; RV64I-NEXT:    vand.vx v9, v9, a0
; RV64I-NEXT:    vsub.vv v8, v8, v9
; RV64I-NEXT:    li a0, 51
; RV64I-NEXT:    vand.vx v9, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v9, v8
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v9
; RV64I-NEXT:    vand.vi v8, v8, 15
; RV64I-NEXT:    ret
;
; RV32D-LABEL: ctlz_nxv4i8:
; RV32D:       # %bb.0:
; RV32D-NEXT:    vsetvli a0, zero, e32, m2, ta, mu
; RV32D-NEXT:    vzext.vf4 v10, v8
; RV32D-NEXT:    vfcvt.f.xu.v v10, v10
; RV32D-NEXT:    vsrl.vi v10, v10, 23
; RV32D-NEXT:    vsetvli zero, zero, e16, m1, ta, mu
; RV32D-NEXT:    vnsrl.wx v9, v10, zero
; RV32D-NEXT:    vsetvli zero, zero, e8, mf2, ta, mu
; RV32D-NEXT:    vnsrl.wx v9, v9, zero
; RV32D-NEXT:    li a0, 134
; RV32D-NEXT:    vmseq.vi v0, v8, 0
; RV32D-NEXT:    vrsub.vx v8, v9, a0
; RV32D-NEXT:    vmerge.vim v8, v8, 8, v0
; RV32D-NEXT:    ret
;
; RV64D-LABEL: ctlz_nxv4i8:
; RV64D:       # %bb.0:
; RV64D-NEXT:    vsetvli a0, zero, e32, m2, ta, mu
; RV64D-NEXT:    vzext.vf4 v10, v8
; RV64D-NEXT:    vfcvt.f.xu.v v10, v10
; RV64D-NEXT:    vsrl.vi v10, v10, 23
; RV64D-NEXT:    vsetvli zero, zero, e16, m1, ta, mu
; RV64D-NEXT:    vnsrl.wx v9, v10, zero
; RV64D-NEXT:    vsetvli zero, zero, e8, mf2, ta, mu
; RV64D-NEXT:    vnsrl.wx v9, v9, zero
; RV64D-NEXT:    li a0, 134
; RV64D-NEXT:    vmseq.vi v0, v8, 0
; RV64D-NEXT:    vrsub.vx v8, v9, a0
; RV64D-NEXT:    vmerge.vim v8, v8, 8, v0
; RV64D-NEXT:    ret
  %a = call <vscale x 4 x i8> @llvm.ctlz.nxv4i8(<vscale x 4 x i8> %va, i1 false)
  ret <vscale x 4 x i8> %a
}
declare <vscale x 4 x i8> @llvm.ctlz.nxv4i8(<vscale x 4 x i8>, i1)

define <vscale x 8 x i8> @ctlz_nxv8i8(<vscale x 8 x i8> %va) {
; RV32I-LABEL: ctlz_nxv8i8:
; RV32I:       # %bb.0:
; RV32I-NEXT:    vsetvli a0, zero, e8, m1, ta, mu
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 2
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vxor.vi v8, v8, -1
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    li a0, 85
; RV32I-NEXT:    vand.vx v9, v9, a0
; RV32I-NEXT:    vsub.vv v8, v8, v9
; RV32I-NEXT:    li a0, 51
; RV32I-NEXT:    vand.vx v9, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v9, v8
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v9
; RV32I-NEXT:    vand.vi v8, v8, 15
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ctlz_nxv8i8:
; RV64I:       # %bb.0:
; RV64I-NEXT:    vsetvli a0, zero, e8, m1, ta, mu
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 2
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vxor.vi v8, v8, -1
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    li a0, 85
; RV64I-NEXT:    vand.vx v9, v9, a0
; RV64I-NEXT:    vsub.vv v8, v8, v9
; RV64I-NEXT:    li a0, 51
; RV64I-NEXT:    vand.vx v9, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v9, v8
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v9
; RV64I-NEXT:    vand.vi v8, v8, 15
; RV64I-NEXT:    ret
;
; RV32D-LABEL: ctlz_nxv8i8:
; RV32D:       # %bb.0:
; RV32D-NEXT:    vsetvli a0, zero, e32, m4, ta, mu
; RV32D-NEXT:    vzext.vf4 v12, v8
; RV32D-NEXT:    vfcvt.f.xu.v v12, v12
; RV32D-NEXT:    vsrl.vi v12, v12, 23
; RV32D-NEXT:    vsetvli zero, zero, e16, m2, ta, mu
; RV32D-NEXT:    vnsrl.wx v10, v12, zero
; RV32D-NEXT:    vsetvli zero, zero, e8, m1, ta, mu
; RV32D-NEXT:    vnsrl.wx v9, v10, zero
; RV32D-NEXT:    li a0, 134
; RV32D-NEXT:    vmseq.vi v0, v8, 0
; RV32D-NEXT:    vrsub.vx v8, v9, a0
; RV32D-NEXT:    vmerge.vim v8, v8, 8, v0
; RV32D-NEXT:    ret
;
; RV64D-LABEL: ctlz_nxv8i8:
; RV64D:       # %bb.0:
; RV64D-NEXT:    vsetvli a0, zero, e32, m4, ta, mu
; RV64D-NEXT:    vzext.vf4 v12, v8
; RV64D-NEXT:    vfcvt.f.xu.v v12, v12
; RV64D-NEXT:    vsrl.vi v12, v12, 23
; RV64D-NEXT:    vsetvli zero, zero, e16, m2, ta, mu
; RV64D-NEXT:    vnsrl.wx v10, v12, zero
; RV64D-NEXT:    vsetvli zero, zero, e8, m1, ta, mu
; RV64D-NEXT:    vnsrl.wx v9, v10, zero
; RV64D-NEXT:    li a0, 134
; RV64D-NEXT:    vmseq.vi v0, v8, 0
; RV64D-NEXT:    vrsub.vx v8, v9, a0
; RV64D-NEXT:    vmerge.vim v8, v8, 8, v0
; RV64D-NEXT:    ret
  %a = call <vscale x 8 x i8> @llvm.ctlz.nxv8i8(<vscale x 8 x i8> %va, i1 false)
  ret <vscale x 8 x i8> %a
}
declare <vscale x 8 x i8> @llvm.ctlz.nxv8i8(<vscale x 8 x i8>, i1)

define <vscale x 16 x i8> @ctlz_nxv16i8(<vscale x 16 x i8> %va) {
; RV32I-LABEL: ctlz_nxv16i8:
; RV32I:       # %bb.0:
; RV32I-NEXT:    vsetvli a0, zero, e8, m2, ta, mu
; RV32I-NEXT:    vsrl.vi v10, v8, 1
; RV32I-NEXT:    vor.vv v8, v8, v10
; RV32I-NEXT:    vsrl.vi v10, v8, 2
; RV32I-NEXT:    vor.vv v8, v8, v10
; RV32I-NEXT:    vsrl.vi v10, v8, 4
; RV32I-NEXT:    vor.vv v8, v8, v10
; RV32I-NEXT:    vxor.vi v8, v8, -1
; RV32I-NEXT:    vsrl.vi v10, v8, 1
; RV32I-NEXT:    li a0, 85
; RV32I-NEXT:    vand.vx v10, v10, a0
; RV32I-NEXT:    vsub.vv v8, v8, v10
; RV32I-NEXT:    li a0, 51
; RV32I-NEXT:    vand.vx v10, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v10, v8
; RV32I-NEXT:    vsrl.vi v10, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v10
; RV32I-NEXT:    vand.vi v8, v8, 15
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ctlz_nxv16i8:
; RV64I:       # %bb.0:
; RV64I-NEXT:    vsetvli a0, zero, e8, m2, ta, mu
; RV64I-NEXT:    vsrl.vi v10, v8, 1
; RV64I-NEXT:    vor.vv v8, v8, v10
; RV64I-NEXT:    vsrl.vi v10, v8, 2
; RV64I-NEXT:    vor.vv v8, v8, v10
; RV64I-NEXT:    vsrl.vi v10, v8, 4
; RV64I-NEXT:    vor.vv v8, v8, v10
; RV64I-NEXT:    vxor.vi v8, v8, -1
; RV64I-NEXT:    vsrl.vi v10, v8, 1
; RV64I-NEXT:    li a0, 85
; RV64I-NEXT:    vand.vx v10, v10, a0
; RV64I-NEXT:    vsub.vv v8, v8, v10
; RV64I-NEXT:    li a0, 51
; RV64I-NEXT:    vand.vx v10, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v10, v8
; RV64I-NEXT:    vsrl.vi v10, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v10
; RV64I-NEXT:    vand.vi v8, v8, 15
; RV64I-NEXT:    ret
;
; RV32D-LABEL: ctlz_nxv16i8:
; RV32D:       # %bb.0:
; RV32D-NEXT:    vsetvli a0, zero, e32, m8, ta, mu
; RV32D-NEXT:    vzext.vf4 v16, v8
; RV32D-NEXT:    vfcvt.f.xu.v v16, v16
; RV32D-NEXT:    vsrl.vi v16, v16, 23
; RV32D-NEXT:    vsetvli zero, zero, e16, m4, ta, mu
; RV32D-NEXT:    vnsrl.wx v12, v16, zero
; RV32D-NEXT:    vsetvli zero, zero, e8, m2, ta, mu
; RV32D-NEXT:    vnsrl.wx v10, v12, zero
; RV32D-NEXT:    li a0, 134
; RV32D-NEXT:    vmseq.vi v0, v8, 0
; RV32D-NEXT:    vrsub.vx v8, v10, a0
; RV32D-NEXT:    vmerge.vim v8, v8, 8, v0
; RV32D-NEXT:    ret
;
; RV64D-LABEL: ctlz_nxv16i8:
; RV64D:       # %bb.0:
; RV64D-NEXT:    vsetvli a0, zero, e32, m8, ta, mu
; RV64D-NEXT:    vzext.vf4 v16, v8
; RV64D-NEXT:    vfcvt.f.xu.v v16, v16
; RV64D-NEXT:    vsrl.vi v16, v16, 23
; RV64D-NEXT:    vsetvli zero, zero, e16, m4, ta, mu
; RV64D-NEXT:    vnsrl.wx v12, v16, zero
; RV64D-NEXT:    vsetvli zero, zero, e8, m2, ta, mu
; RV64D-NEXT:    vnsrl.wx v10, v12, zero
; RV64D-NEXT:    li a0, 134
; RV64D-NEXT:    vmseq.vi v0, v8, 0
; RV64D-NEXT:    vrsub.vx v8, v10, a0
; RV64D-NEXT:    vmerge.vim v8, v8, 8, v0
; RV64D-NEXT:    ret
  %a = call <vscale x 16 x i8> @llvm.ctlz.nxv16i8(<vscale x 16 x i8> %va, i1 false)
  ret <vscale x 16 x i8> %a
}
declare <vscale x 16 x i8> @llvm.ctlz.nxv16i8(<vscale x 16 x i8>, i1)

define <vscale x 32 x i8> @ctlz_nxv32i8(<vscale x 32 x i8> %va) {
; CHECK-LABEL: ctlz_nxv32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m4, ta, mu
; CHECK-NEXT:    vsrl.vi v12, v8, 1
; CHECK-NEXT:    vor.vv v8, v8, v12
; CHECK-NEXT:    vsrl.vi v12, v8, 2
; CHECK-NEXT:    vor.vv v8, v8, v12
; CHECK-NEXT:    vsrl.vi v12, v8, 4
; CHECK-NEXT:    vor.vv v8, v8, v12
; CHECK-NEXT:    vxor.vi v8, v8, -1
; CHECK-NEXT:    vsrl.vi v12, v8, 1
; CHECK-NEXT:    li a0, 85
; CHECK-NEXT:    vand.vx v12, v12, a0
; CHECK-NEXT:    vsub.vv v8, v8, v12
; CHECK-NEXT:    li a0, 51
; CHECK-NEXT:    vand.vx v12, v8, a0
; CHECK-NEXT:    vsrl.vi v8, v8, 2
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vadd.vv v8, v12, v8
; CHECK-NEXT:    vsrl.vi v12, v8, 4
; CHECK-NEXT:    vadd.vv v8, v8, v12
; CHECK-NEXT:    vand.vi v8, v8, 15
; CHECK-NEXT:    ret
  %a = call <vscale x 32 x i8> @llvm.ctlz.nxv32i8(<vscale x 32 x i8> %va, i1 false)
  ret <vscale x 32 x i8> %a
}
declare <vscale x 32 x i8> @llvm.ctlz.nxv32i8(<vscale x 32 x i8>, i1)

define <vscale x 64 x i8> @ctlz_nxv64i8(<vscale x 64 x i8> %va) {
; CHECK-LABEL: ctlz_nxv64i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m8, ta, mu
; CHECK-NEXT:    vsrl.vi v16, v8, 1
; CHECK-NEXT:    vor.vv v8, v8, v16
; CHECK-NEXT:    vsrl.vi v16, v8, 2
; CHECK-NEXT:    vor.vv v8, v8, v16
; CHECK-NEXT:    vsrl.vi v16, v8, 4
; CHECK-NEXT:    vor.vv v8, v8, v16
; CHECK-NEXT:    vxor.vi v8, v8, -1
; CHECK-NEXT:    vsrl.vi v16, v8, 1
; CHECK-NEXT:    li a0, 85
; CHECK-NEXT:    vand.vx v16, v16, a0
; CHECK-NEXT:    vsub.vv v8, v8, v16
; CHECK-NEXT:    li a0, 51
; CHECK-NEXT:    vand.vx v16, v8, a0
; CHECK-NEXT:    vsrl.vi v8, v8, 2
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vadd.vv v8, v16, v8
; CHECK-NEXT:    vsrl.vi v16, v8, 4
; CHECK-NEXT:    vadd.vv v8, v8, v16
; CHECK-NEXT:    vand.vi v8, v8, 15
; CHECK-NEXT:    ret
  %a = call <vscale x 64 x i8> @llvm.ctlz.nxv64i8(<vscale x 64 x i8> %va, i1 false)
  ret <vscale x 64 x i8> %a
}
declare <vscale x 64 x i8> @llvm.ctlz.nxv64i8(<vscale x 64 x i8>, i1)

define <vscale x 1 x i16> @ctlz_nxv1i16(<vscale x 1 x i16> %va) {
; RV32I-LABEL: ctlz_nxv1i16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    vsetvli a0, zero, e16, mf4, ta, mu
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 2
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 8
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vxor.vi v8, v8, -1
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    lui a0, 5
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vand.vx v9, v9, a0
; RV32I-NEXT:    vsub.vv v8, v8, v9
; RV32I-NEXT:    lui a0, 3
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vand.vx v9, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v9, v8
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v9
; RV32I-NEXT:    lui a0, 1
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    li a0, 257
; RV32I-NEXT:    vmul.vx v8, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 8
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ctlz_nxv1i16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    vsetvli a0, zero, e16, mf4, ta, mu
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 2
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 8
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vxor.vi v8, v8, -1
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    lui a0, 5
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    vand.vx v9, v9, a0
; RV64I-NEXT:    vsub.vv v8, v8, v9
; RV64I-NEXT:    lui a0, 3
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    vand.vx v9, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v9, v8
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v9
; RV64I-NEXT:    lui a0, 1
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    li a0, 257
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 8
; RV64I-NEXT:    ret
;
; RV32D-LABEL: ctlz_nxv1i16:
; RV32D:       # %bb.0:
; RV32D-NEXT:    vsetvli a0, zero, e16, mf4, ta, mu
; RV32D-NEXT:    vfwcvt.f.xu.v v9, v8
; RV32D-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; RV32D-NEXT:    vsrl.vi v9, v9, 23
; RV32D-NEXT:    vsetvli zero, zero, e16, mf4, ta, mu
; RV32D-NEXT:    vnsrl.wx v9, v9, zero
; RV32D-NEXT:    li a0, 142
; RV32D-NEXT:    vrsub.vx v9, v9, a0
; RV32D-NEXT:    vmseq.vi v0, v8, 0
; RV32D-NEXT:    li a0, 16
; RV32D-NEXT:    vmerge.vxm v8, v9, a0, v0
; RV32D-NEXT:    ret
;
; RV64D-LABEL: ctlz_nxv1i16:
; RV64D:       # %bb.0:
; RV64D-NEXT:    vsetvli a0, zero, e16, mf4, ta, mu
; RV64D-NEXT:    vfwcvt.f.xu.v v9, v8
; RV64D-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; RV64D-NEXT:    vsrl.vi v9, v9, 23
; RV64D-NEXT:    vsetvli zero, zero, e16, mf4, ta, mu
; RV64D-NEXT:    vnsrl.wx v9, v9, zero
; RV64D-NEXT:    li a0, 142
; RV64D-NEXT:    vrsub.vx v9, v9, a0
; RV64D-NEXT:    vmseq.vi v0, v8, 0
; RV64D-NEXT:    li a0, 16
; RV64D-NEXT:    vmerge.vxm v8, v9, a0, v0
; RV64D-NEXT:    ret
  %a = call <vscale x 1 x i16> @llvm.ctlz.nxv1i16(<vscale x 1 x i16> %va, i1 false)
  ret <vscale x 1 x i16> %a
}
declare <vscale x 1 x i16> @llvm.ctlz.nxv1i16(<vscale x 1 x i16>, i1)

define <vscale x 2 x i16> @ctlz_nxv2i16(<vscale x 2 x i16> %va) {
; RV32I-LABEL: ctlz_nxv2i16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    vsetvli a0, zero, e16, mf2, ta, mu
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 2
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 8
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vxor.vi v8, v8, -1
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    lui a0, 5
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vand.vx v9, v9, a0
; RV32I-NEXT:    vsub.vv v8, v8, v9
; RV32I-NEXT:    lui a0, 3
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vand.vx v9, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v9, v8
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v9
; RV32I-NEXT:    lui a0, 1
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    li a0, 257
; RV32I-NEXT:    vmul.vx v8, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 8
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ctlz_nxv2i16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    vsetvli a0, zero, e16, mf2, ta, mu
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 2
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 8
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vxor.vi v8, v8, -1
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    lui a0, 5
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    vand.vx v9, v9, a0
; RV64I-NEXT:    vsub.vv v8, v8, v9
; RV64I-NEXT:    lui a0, 3
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    vand.vx v9, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v9, v8
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v9
; RV64I-NEXT:    lui a0, 1
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    li a0, 257
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 8
; RV64I-NEXT:    ret
;
; RV32D-LABEL: ctlz_nxv2i16:
; RV32D:       # %bb.0:
; RV32D-NEXT:    vsetvli a0, zero, e16, mf2, ta, mu
; RV32D-NEXT:    vfwcvt.f.xu.v v9, v8
; RV32D-NEXT:    vsetvli zero, zero, e32, m1, ta, mu
; RV32D-NEXT:    vsrl.vi v9, v9, 23
; RV32D-NEXT:    vsetvli zero, zero, e16, mf2, ta, mu
; RV32D-NEXT:    vnsrl.wx v9, v9, zero
; RV32D-NEXT:    li a0, 142
; RV32D-NEXT:    vrsub.vx v9, v9, a0
; RV32D-NEXT:    vmseq.vi v0, v8, 0
; RV32D-NEXT:    li a0, 16
; RV32D-NEXT:    vmerge.vxm v8, v9, a0, v0
; RV32D-NEXT:    ret
;
; RV64D-LABEL: ctlz_nxv2i16:
; RV64D:       # %bb.0:
; RV64D-NEXT:    vsetvli a0, zero, e16, mf2, ta, mu
; RV64D-NEXT:    vfwcvt.f.xu.v v9, v8
; RV64D-NEXT:    vsetvli zero, zero, e32, m1, ta, mu
; RV64D-NEXT:    vsrl.vi v9, v9, 23
; RV64D-NEXT:    vsetvli zero, zero, e16, mf2, ta, mu
; RV64D-NEXT:    vnsrl.wx v9, v9, zero
; RV64D-NEXT:    li a0, 142
; RV64D-NEXT:    vrsub.vx v9, v9, a0
; RV64D-NEXT:    vmseq.vi v0, v8, 0
; RV64D-NEXT:    li a0, 16
; RV64D-NEXT:    vmerge.vxm v8, v9, a0, v0
; RV64D-NEXT:    ret
  %a = call <vscale x 2 x i16> @llvm.ctlz.nxv2i16(<vscale x 2 x i16> %va, i1 false)
  ret <vscale x 2 x i16> %a
}
declare <vscale x 2 x i16> @llvm.ctlz.nxv2i16(<vscale x 2 x i16>, i1)

define <vscale x 4 x i16> @ctlz_nxv4i16(<vscale x 4 x i16> %va) {
; RV32I-LABEL: ctlz_nxv4i16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    vsetvli a0, zero, e16, m1, ta, mu
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 2
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 8
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vxor.vi v8, v8, -1
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    lui a0, 5
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vand.vx v9, v9, a0
; RV32I-NEXT:    vsub.vv v8, v8, v9
; RV32I-NEXT:    lui a0, 3
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vand.vx v9, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v9, v8
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v9
; RV32I-NEXT:    lui a0, 1
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    li a0, 257
; RV32I-NEXT:    vmul.vx v8, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 8
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ctlz_nxv4i16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    vsetvli a0, zero, e16, m1, ta, mu
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 2
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 8
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vxor.vi v8, v8, -1
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    lui a0, 5
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    vand.vx v9, v9, a0
; RV64I-NEXT:    vsub.vv v8, v8, v9
; RV64I-NEXT:    lui a0, 3
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    vand.vx v9, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v9, v8
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v9
; RV64I-NEXT:    lui a0, 1
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    li a0, 257
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 8
; RV64I-NEXT:    ret
;
; RV32D-LABEL: ctlz_nxv4i16:
; RV32D:       # %bb.0:
; RV32D-NEXT:    vsetvli a0, zero, e16, m1, ta, mu
; RV32D-NEXT:    vfwcvt.f.xu.v v10, v8
; RV32D-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; RV32D-NEXT:    vsrl.vi v10, v10, 23
; RV32D-NEXT:    vsetvli zero, zero, e16, m1, ta, mu
; RV32D-NEXT:    vnsrl.wx v9, v10, zero
; RV32D-NEXT:    li a0, 142
; RV32D-NEXT:    vrsub.vx v9, v9, a0
; RV32D-NEXT:    vmseq.vi v0, v8, 0
; RV32D-NEXT:    li a0, 16
; RV32D-NEXT:    vmerge.vxm v8, v9, a0, v0
; RV32D-NEXT:    ret
;
; RV64D-LABEL: ctlz_nxv4i16:
; RV64D:       # %bb.0:
; RV64D-NEXT:    vsetvli a0, zero, e16, m1, ta, mu
; RV64D-NEXT:    vfwcvt.f.xu.v v10, v8
; RV64D-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; RV64D-NEXT:    vsrl.vi v10, v10, 23
; RV64D-NEXT:    vsetvli zero, zero, e16, m1, ta, mu
; RV64D-NEXT:    vnsrl.wx v9, v10, zero
; RV64D-NEXT:    li a0, 142
; RV64D-NEXT:    vrsub.vx v9, v9, a0
; RV64D-NEXT:    vmseq.vi v0, v8, 0
; RV64D-NEXT:    li a0, 16
; RV64D-NEXT:    vmerge.vxm v8, v9, a0, v0
; RV64D-NEXT:    ret
  %a = call <vscale x 4 x i16> @llvm.ctlz.nxv4i16(<vscale x 4 x i16> %va, i1 false)
  ret <vscale x 4 x i16> %a
}
declare <vscale x 4 x i16> @llvm.ctlz.nxv4i16(<vscale x 4 x i16>, i1)

define <vscale x 8 x i16> @ctlz_nxv8i16(<vscale x 8 x i16> %va) {
; RV32I-LABEL: ctlz_nxv8i16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    vsetvli a0, zero, e16, m2, ta, mu
; RV32I-NEXT:    vsrl.vi v10, v8, 1
; RV32I-NEXT:    vor.vv v8, v8, v10
; RV32I-NEXT:    vsrl.vi v10, v8, 2
; RV32I-NEXT:    vor.vv v8, v8, v10
; RV32I-NEXT:    vsrl.vi v10, v8, 4
; RV32I-NEXT:    vor.vv v8, v8, v10
; RV32I-NEXT:    vsrl.vi v10, v8, 8
; RV32I-NEXT:    vor.vv v8, v8, v10
; RV32I-NEXT:    vxor.vi v8, v8, -1
; RV32I-NEXT:    vsrl.vi v10, v8, 1
; RV32I-NEXT:    lui a0, 5
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vand.vx v10, v10, a0
; RV32I-NEXT:    vsub.vv v8, v8, v10
; RV32I-NEXT:    lui a0, 3
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vand.vx v10, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v10, v8
; RV32I-NEXT:    vsrl.vi v10, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v10
; RV32I-NEXT:    lui a0, 1
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    li a0, 257
; RV32I-NEXT:    vmul.vx v8, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 8
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ctlz_nxv8i16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    vsetvli a0, zero, e16, m2, ta, mu
; RV64I-NEXT:    vsrl.vi v10, v8, 1
; RV64I-NEXT:    vor.vv v8, v8, v10
; RV64I-NEXT:    vsrl.vi v10, v8, 2
; RV64I-NEXT:    vor.vv v8, v8, v10
; RV64I-NEXT:    vsrl.vi v10, v8, 4
; RV64I-NEXT:    vor.vv v8, v8, v10
; RV64I-NEXT:    vsrl.vi v10, v8, 8
; RV64I-NEXT:    vor.vv v8, v8, v10
; RV64I-NEXT:    vxor.vi v8, v8, -1
; RV64I-NEXT:    vsrl.vi v10, v8, 1
; RV64I-NEXT:    lui a0, 5
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    vand.vx v10, v10, a0
; RV64I-NEXT:    vsub.vv v8, v8, v10
; RV64I-NEXT:    lui a0, 3
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    vand.vx v10, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v10, v8
; RV64I-NEXT:    vsrl.vi v10, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v10
; RV64I-NEXT:    lui a0, 1
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    li a0, 257
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 8
; RV64I-NEXT:    ret
;
; RV32D-LABEL: ctlz_nxv8i16:
; RV32D:       # %bb.0:
; RV32D-NEXT:    vsetvli a0, zero, e16, m2, ta, mu
; RV32D-NEXT:    vfwcvt.f.xu.v v12, v8
; RV32D-NEXT:    vsetvli zero, zero, e32, m4, ta, mu
; RV32D-NEXT:    vsrl.vi v12, v12, 23
; RV32D-NEXT:    vsetvli zero, zero, e16, m2, ta, mu
; RV32D-NEXT:    vnsrl.wx v10, v12, zero
; RV32D-NEXT:    li a0, 142
; RV32D-NEXT:    vrsub.vx v10, v10, a0
; RV32D-NEXT:    vmseq.vi v0, v8, 0
; RV32D-NEXT:    li a0, 16
; RV32D-NEXT:    vmerge.vxm v8, v10, a0, v0
; RV32D-NEXT:    ret
;
; RV64D-LABEL: ctlz_nxv8i16:
; RV64D:       # %bb.0:
; RV64D-NEXT:    vsetvli a0, zero, e16, m2, ta, mu
; RV64D-NEXT:    vfwcvt.f.xu.v v12, v8
; RV64D-NEXT:    vsetvli zero, zero, e32, m4, ta, mu
; RV64D-NEXT:    vsrl.vi v12, v12, 23
; RV64D-NEXT:    vsetvli zero, zero, e16, m2, ta, mu
; RV64D-NEXT:    vnsrl.wx v10, v12, zero
; RV64D-NEXT:    li a0, 142
; RV64D-NEXT:    vrsub.vx v10, v10, a0
; RV64D-NEXT:    vmseq.vi v0, v8, 0
; RV64D-NEXT:    li a0, 16
; RV64D-NEXT:    vmerge.vxm v8, v10, a0, v0
; RV64D-NEXT:    ret
  %a = call <vscale x 8 x i16> @llvm.ctlz.nxv8i16(<vscale x 8 x i16> %va, i1 false)
  ret <vscale x 8 x i16> %a
}
declare <vscale x 8 x i16> @llvm.ctlz.nxv8i16(<vscale x 8 x i16>, i1)

define <vscale x 16 x i16> @ctlz_nxv16i16(<vscale x 16 x i16> %va) {
; RV32I-LABEL: ctlz_nxv16i16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    vsetvli a0, zero, e16, m4, ta, mu
; RV32I-NEXT:    vsrl.vi v12, v8, 1
; RV32I-NEXT:    vor.vv v8, v8, v12
; RV32I-NEXT:    vsrl.vi v12, v8, 2
; RV32I-NEXT:    vor.vv v8, v8, v12
; RV32I-NEXT:    vsrl.vi v12, v8, 4
; RV32I-NEXT:    vor.vv v8, v8, v12
; RV32I-NEXT:    vsrl.vi v12, v8, 8
; RV32I-NEXT:    vor.vv v8, v8, v12
; RV32I-NEXT:    vxor.vi v8, v8, -1
; RV32I-NEXT:    vsrl.vi v12, v8, 1
; RV32I-NEXT:    lui a0, 5
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vand.vx v12, v12, a0
; RV32I-NEXT:    vsub.vv v8, v8, v12
; RV32I-NEXT:    lui a0, 3
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vand.vx v12, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v12, v8
; RV32I-NEXT:    vsrl.vi v12, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v12
; RV32I-NEXT:    lui a0, 1
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    li a0, 257
; RV32I-NEXT:    vmul.vx v8, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 8
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ctlz_nxv16i16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    vsetvli a0, zero, e16, m4, ta, mu
; RV64I-NEXT:    vsrl.vi v12, v8, 1
; RV64I-NEXT:    vor.vv v8, v8, v12
; RV64I-NEXT:    vsrl.vi v12, v8, 2
; RV64I-NEXT:    vor.vv v8, v8, v12
; RV64I-NEXT:    vsrl.vi v12, v8, 4
; RV64I-NEXT:    vor.vv v8, v8, v12
; RV64I-NEXT:    vsrl.vi v12, v8, 8
; RV64I-NEXT:    vor.vv v8, v8, v12
; RV64I-NEXT:    vxor.vi v8, v8, -1
; RV64I-NEXT:    vsrl.vi v12, v8, 1
; RV64I-NEXT:    lui a0, 5
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    vand.vx v12, v12, a0
; RV64I-NEXT:    vsub.vv v8, v8, v12
; RV64I-NEXT:    lui a0, 3
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    vand.vx v12, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v12, v8
; RV64I-NEXT:    vsrl.vi v12, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v12
; RV64I-NEXT:    lui a0, 1
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    li a0, 257
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 8
; RV64I-NEXT:    ret
;
; RV32D-LABEL: ctlz_nxv16i16:
; RV32D:       # %bb.0:
; RV32D-NEXT:    vsetvli a0, zero, e16, m4, ta, mu
; RV32D-NEXT:    vfwcvt.f.xu.v v16, v8
; RV32D-NEXT:    vsetvli zero, zero, e32, m8, ta, mu
; RV32D-NEXT:    vsrl.vi v16, v16, 23
; RV32D-NEXT:    vsetvli zero, zero, e16, m4, ta, mu
; RV32D-NEXT:    vnsrl.wx v12, v16, zero
; RV32D-NEXT:    li a0, 142
; RV32D-NEXT:    vrsub.vx v12, v12, a0
; RV32D-NEXT:    vmseq.vi v0, v8, 0
; RV32D-NEXT:    li a0, 16
; RV32D-NEXT:    vmerge.vxm v8, v12, a0, v0
; RV32D-NEXT:    ret
;
; RV64D-LABEL: ctlz_nxv16i16:
; RV64D:       # %bb.0:
; RV64D-NEXT:    vsetvli a0, zero, e16, m4, ta, mu
; RV64D-NEXT:    vfwcvt.f.xu.v v16, v8
; RV64D-NEXT:    vsetvli zero, zero, e32, m8, ta, mu
; RV64D-NEXT:    vsrl.vi v16, v16, 23
; RV64D-NEXT:    vsetvli zero, zero, e16, m4, ta, mu
; RV64D-NEXT:    vnsrl.wx v12, v16, zero
; RV64D-NEXT:    li a0, 142
; RV64D-NEXT:    vrsub.vx v12, v12, a0
; RV64D-NEXT:    vmseq.vi v0, v8, 0
; RV64D-NEXT:    li a0, 16
; RV64D-NEXT:    vmerge.vxm v8, v12, a0, v0
; RV64D-NEXT:    ret
  %a = call <vscale x 16 x i16> @llvm.ctlz.nxv16i16(<vscale x 16 x i16> %va, i1 false)
  ret <vscale x 16 x i16> %a
}
declare <vscale x 16 x i16> @llvm.ctlz.nxv16i16(<vscale x 16 x i16>, i1)

define <vscale x 32 x i16> @ctlz_nxv32i16(<vscale x 32 x i16> %va) {
; RV32-LABEL: ctlz_nxv32i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16, m8, ta, mu
; RV32-NEXT:    vsrl.vi v16, v8, 1
; RV32-NEXT:    vor.vv v8, v8, v16
; RV32-NEXT:    vsrl.vi v16, v8, 2
; RV32-NEXT:    vor.vv v8, v8, v16
; RV32-NEXT:    vsrl.vi v16, v8, 4
; RV32-NEXT:    vor.vv v8, v8, v16
; RV32-NEXT:    vsrl.vi v16, v8, 8
; RV32-NEXT:    vor.vv v8, v8, v16
; RV32-NEXT:    vxor.vi v8, v8, -1
; RV32-NEXT:    vsrl.vi v16, v8, 1
; RV32-NEXT:    lui a0, 5
; RV32-NEXT:    addi a0, a0, 1365
; RV32-NEXT:    vand.vx v16, v16, a0
; RV32-NEXT:    vsub.vv v8, v8, v16
; RV32-NEXT:    lui a0, 3
; RV32-NEXT:    addi a0, a0, 819
; RV32-NEXT:    vand.vx v16, v8, a0
; RV32-NEXT:    vsrl.vi v8, v8, 2
; RV32-NEXT:    vand.vx v8, v8, a0
; RV32-NEXT:    vadd.vv v8, v16, v8
; RV32-NEXT:    vsrl.vi v16, v8, 4
; RV32-NEXT:    vadd.vv v8, v8, v16
; RV32-NEXT:    lui a0, 1
; RV32-NEXT:    addi a0, a0, -241
; RV32-NEXT:    vand.vx v8, v8, a0
; RV32-NEXT:    li a0, 257
; RV32-NEXT:    vmul.vx v8, v8, a0
; RV32-NEXT:    vsrl.vi v8, v8, 8
; RV32-NEXT:    ret
;
; RV64-LABEL: ctlz_nxv32i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16, m8, ta, mu
; RV64-NEXT:    vsrl.vi v16, v8, 1
; RV64-NEXT:    vor.vv v8, v8, v16
; RV64-NEXT:    vsrl.vi v16, v8, 2
; RV64-NEXT:    vor.vv v8, v8, v16
; RV64-NEXT:    vsrl.vi v16, v8, 4
; RV64-NEXT:    vor.vv v8, v8, v16
; RV64-NEXT:    vsrl.vi v16, v8, 8
; RV64-NEXT:    vor.vv v8, v8, v16
; RV64-NEXT:    vxor.vi v8, v8, -1
; RV64-NEXT:    vsrl.vi v16, v8, 1
; RV64-NEXT:    lui a0, 5
; RV64-NEXT:    addiw a0, a0, 1365
; RV64-NEXT:    vand.vx v16, v16, a0
; RV64-NEXT:    vsub.vv v8, v8, v16
; RV64-NEXT:    lui a0, 3
; RV64-NEXT:    addiw a0, a0, 819
; RV64-NEXT:    vand.vx v16, v8, a0
; RV64-NEXT:    vsrl.vi v8, v8, 2
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vadd.vv v8, v16, v8
; RV64-NEXT:    vsrl.vi v16, v8, 4
; RV64-NEXT:    vadd.vv v8, v8, v16
; RV64-NEXT:    lui a0, 1
; RV64-NEXT:    addiw a0, a0, -241
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    li a0, 257
; RV64-NEXT:    vmul.vx v8, v8, a0
; RV64-NEXT:    vsrl.vi v8, v8, 8
; RV64-NEXT:    ret
  %a = call <vscale x 32 x i16> @llvm.ctlz.nxv32i16(<vscale x 32 x i16> %va, i1 false)
  ret <vscale x 32 x i16> %a
}
declare <vscale x 32 x i16> @llvm.ctlz.nxv32i16(<vscale x 32 x i16>, i1)

define <vscale x 1 x i32> @ctlz_nxv1i32(<vscale x 1 x i32> %va) {
; RV32I-LABEL: ctlz_nxv1i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    vsetvli a0, zero, e32, mf2, ta, mu
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 2
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 8
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 16
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vxor.vi v8, v8, -1
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    lui a0, 349525
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vand.vx v9, v9, a0
; RV32I-NEXT:    vsub.vv v8, v8, v9
; RV32I-NEXT:    lui a0, 209715
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vand.vx v9, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v9, v8
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v9
; RV32I-NEXT:    lui a0, 61681
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    lui a0, 4112
; RV32I-NEXT:    addi a0, a0, 257
; RV32I-NEXT:    vmul.vx v8, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 24
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ctlz_nxv1i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    vsetvli a0, zero, e32, mf2, ta, mu
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 2
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 8
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 16
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vxor.vi v8, v8, -1
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    lui a0, 349525
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    vand.vx v9, v9, a0
; RV64I-NEXT:    vsub.vv v8, v8, v9
; RV64I-NEXT:    lui a0, 209715
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    vand.vx v9, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v9, v8
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v9
; RV64I-NEXT:    lui a0, 61681
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    lui a0, 4112
; RV64I-NEXT:    addiw a0, a0, 257
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 24
; RV64I-NEXT:    ret
;
; RV32D-LABEL: ctlz_nxv1i32:
; RV32D:       # %bb.0:
; RV32D-NEXT:    vsetvli a0, zero, e32, mf2, ta, mu
; RV32D-NEXT:    vfwcvt.f.xu.v v9, v8
; RV32D-NEXT:    li a0, 52
; RV32D-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; RV32D-NEXT:    vsrl.vx v9, v9, a0
; RV32D-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; RV32D-NEXT:    vnsrl.wx v9, v9, zero
; RV32D-NEXT:    li a0, 1054
; RV32D-NEXT:    vrsub.vx v9, v9, a0
; RV32D-NEXT:    vmseq.vi v0, v8, 0
; RV32D-NEXT:    li a0, 32
; RV32D-NEXT:    vmerge.vxm v8, v9, a0, v0
; RV32D-NEXT:    ret
;
; RV64D-LABEL: ctlz_nxv1i32:
; RV64D:       # %bb.0:
; RV64D-NEXT:    vsetvli a0, zero, e32, mf2, ta, mu
; RV64D-NEXT:    vfwcvt.f.xu.v v9, v8
; RV64D-NEXT:    li a0, 52
; RV64D-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; RV64D-NEXT:    vsrl.vx v9, v9, a0
; RV64D-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; RV64D-NEXT:    vnsrl.wx v9, v9, zero
; RV64D-NEXT:    li a0, 1054
; RV64D-NEXT:    vrsub.vx v9, v9, a0
; RV64D-NEXT:    vmseq.vi v0, v8, 0
; RV64D-NEXT:    li a0, 32
; RV64D-NEXT:    vmerge.vxm v8, v9, a0, v0
; RV64D-NEXT:    ret
  %a = call <vscale x 1 x i32> @llvm.ctlz.nxv1i32(<vscale x 1 x i32> %va, i1 false)
  ret <vscale x 1 x i32> %a
}
declare <vscale x 1 x i32> @llvm.ctlz.nxv1i32(<vscale x 1 x i32>, i1)

define <vscale x 2 x i32> @ctlz_nxv2i32(<vscale x 2 x i32> %va) {
; RV32I-LABEL: ctlz_nxv2i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 2
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 8
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 16
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vxor.vi v8, v8, -1
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    lui a0, 349525
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vand.vx v9, v9, a0
; RV32I-NEXT:    vsub.vv v8, v8, v9
; RV32I-NEXT:    lui a0, 209715
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vand.vx v9, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v9, v8
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v9
; RV32I-NEXT:    lui a0, 61681
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    lui a0, 4112
; RV32I-NEXT:    addi a0, a0, 257
; RV32I-NEXT:    vmul.vx v8, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 24
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ctlz_nxv2i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 2
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 8
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 16
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vxor.vi v8, v8, -1
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    lui a0, 349525
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    vand.vx v9, v9, a0
; RV64I-NEXT:    vsub.vv v8, v8, v9
; RV64I-NEXT:    lui a0, 209715
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    vand.vx v9, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v9, v8
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v9
; RV64I-NEXT:    lui a0, 61681
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    lui a0, 4112
; RV64I-NEXT:    addiw a0, a0, 257
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 24
; RV64I-NEXT:    ret
;
; RV32D-LABEL: ctlz_nxv2i32:
; RV32D:       # %bb.0:
; RV32D-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; RV32D-NEXT:    vfwcvt.f.xu.v v10, v8
; RV32D-NEXT:    li a0, 52
; RV32D-NEXT:    vsetvli zero, zero, e64, m2, ta, mu
; RV32D-NEXT:    vsrl.vx v10, v10, a0
; RV32D-NEXT:    vsetvli zero, zero, e32, m1, ta, mu
; RV32D-NEXT:    vnsrl.wx v9, v10, zero
; RV32D-NEXT:    li a0, 1054
; RV32D-NEXT:    vrsub.vx v9, v9, a0
; RV32D-NEXT:    vmseq.vi v0, v8, 0
; RV32D-NEXT:    li a0, 32
; RV32D-NEXT:    vmerge.vxm v8, v9, a0, v0
; RV32D-NEXT:    ret
;
; RV64D-LABEL: ctlz_nxv2i32:
; RV64D:       # %bb.0:
; RV64D-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; RV64D-NEXT:    vfwcvt.f.xu.v v10, v8
; RV64D-NEXT:    li a0, 52
; RV64D-NEXT:    vsetvli zero, zero, e64, m2, ta, mu
; RV64D-NEXT:    vsrl.vx v10, v10, a0
; RV64D-NEXT:    vsetvli zero, zero, e32, m1, ta, mu
; RV64D-NEXT:    vnsrl.wx v9, v10, zero
; RV64D-NEXT:    li a0, 1054
; RV64D-NEXT:    vrsub.vx v9, v9, a0
; RV64D-NEXT:    vmseq.vi v0, v8, 0
; RV64D-NEXT:    li a0, 32
; RV64D-NEXT:    vmerge.vxm v8, v9, a0, v0
; RV64D-NEXT:    ret
  %a = call <vscale x 2 x i32> @llvm.ctlz.nxv2i32(<vscale x 2 x i32> %va, i1 false)
  ret <vscale x 2 x i32> %a
}
declare <vscale x 2 x i32> @llvm.ctlz.nxv2i32(<vscale x 2 x i32>, i1)

define <vscale x 4 x i32> @ctlz_nxv4i32(<vscale x 4 x i32> %va) {
; RV32I-LABEL: ctlz_nxv4i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    vsetvli a0, zero, e32, m2, ta, mu
; RV32I-NEXT:    vsrl.vi v10, v8, 1
; RV32I-NEXT:    vor.vv v8, v8, v10
; RV32I-NEXT:    vsrl.vi v10, v8, 2
; RV32I-NEXT:    vor.vv v8, v8, v10
; RV32I-NEXT:    vsrl.vi v10, v8, 4
; RV32I-NEXT:    vor.vv v8, v8, v10
; RV32I-NEXT:    vsrl.vi v10, v8, 8
; RV32I-NEXT:    vor.vv v8, v8, v10
; RV32I-NEXT:    vsrl.vi v10, v8, 16
; RV32I-NEXT:    vor.vv v8, v8, v10
; RV32I-NEXT:    vxor.vi v8, v8, -1
; RV32I-NEXT:    vsrl.vi v10, v8, 1
; RV32I-NEXT:    lui a0, 349525
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vand.vx v10, v10, a0
; RV32I-NEXT:    vsub.vv v8, v8, v10
; RV32I-NEXT:    lui a0, 209715
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vand.vx v10, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v10, v8
; RV32I-NEXT:    vsrl.vi v10, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v10
; RV32I-NEXT:    lui a0, 61681
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    lui a0, 4112
; RV32I-NEXT:    addi a0, a0, 257
; RV32I-NEXT:    vmul.vx v8, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 24
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ctlz_nxv4i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    vsetvli a0, zero, e32, m2, ta, mu
; RV64I-NEXT:    vsrl.vi v10, v8, 1
; RV64I-NEXT:    vor.vv v8, v8, v10
; RV64I-NEXT:    vsrl.vi v10, v8, 2
; RV64I-NEXT:    vor.vv v8, v8, v10
; RV64I-NEXT:    vsrl.vi v10, v8, 4
; RV64I-NEXT:    vor.vv v8, v8, v10
; RV64I-NEXT:    vsrl.vi v10, v8, 8
; RV64I-NEXT:    vor.vv v8, v8, v10
; RV64I-NEXT:    vsrl.vi v10, v8, 16
; RV64I-NEXT:    vor.vv v8, v8, v10
; RV64I-NEXT:    vxor.vi v8, v8, -1
; RV64I-NEXT:    vsrl.vi v10, v8, 1
; RV64I-NEXT:    lui a0, 349525
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    vand.vx v10, v10, a0
; RV64I-NEXT:    vsub.vv v8, v8, v10
; RV64I-NEXT:    lui a0, 209715
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    vand.vx v10, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v10, v8
; RV64I-NEXT:    vsrl.vi v10, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v10
; RV64I-NEXT:    lui a0, 61681
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    lui a0, 4112
; RV64I-NEXT:    addiw a0, a0, 257
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 24
; RV64I-NEXT:    ret
;
; RV32D-LABEL: ctlz_nxv4i32:
; RV32D:       # %bb.0:
; RV32D-NEXT:    vsetvli a0, zero, e32, m2, ta, mu
; RV32D-NEXT:    vfwcvt.f.xu.v v12, v8
; RV32D-NEXT:    li a0, 52
; RV32D-NEXT:    vsetvli zero, zero, e64, m4, ta, mu
; RV32D-NEXT:    vsrl.vx v12, v12, a0
; RV32D-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; RV32D-NEXT:    vnsrl.wx v10, v12, zero
; RV32D-NEXT:    li a0, 1054
; RV32D-NEXT:    vrsub.vx v10, v10, a0
; RV32D-NEXT:    vmseq.vi v0, v8, 0
; RV32D-NEXT:    li a0, 32
; RV32D-NEXT:    vmerge.vxm v8, v10, a0, v0
; RV32D-NEXT:    ret
;
; RV64D-LABEL: ctlz_nxv4i32:
; RV64D:       # %bb.0:
; RV64D-NEXT:    vsetvli a0, zero, e32, m2, ta, mu
; RV64D-NEXT:    vfwcvt.f.xu.v v12, v8
; RV64D-NEXT:    li a0, 52
; RV64D-NEXT:    vsetvli zero, zero, e64, m4, ta, mu
; RV64D-NEXT:    vsrl.vx v12, v12, a0
; RV64D-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; RV64D-NEXT:    vnsrl.wx v10, v12, zero
; RV64D-NEXT:    li a0, 1054
; RV64D-NEXT:    vrsub.vx v10, v10, a0
; RV64D-NEXT:    vmseq.vi v0, v8, 0
; RV64D-NEXT:    li a0, 32
; RV64D-NEXT:    vmerge.vxm v8, v10, a0, v0
; RV64D-NEXT:    ret
  %a = call <vscale x 4 x i32> @llvm.ctlz.nxv4i32(<vscale x 4 x i32> %va, i1 false)
  ret <vscale x 4 x i32> %a
}
declare <vscale x 4 x i32> @llvm.ctlz.nxv4i32(<vscale x 4 x i32>, i1)

define <vscale x 8 x i32> @ctlz_nxv8i32(<vscale x 8 x i32> %va) {
; RV32I-LABEL: ctlz_nxv8i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    vsetvli a0, zero, e32, m4, ta, mu
; RV32I-NEXT:    vsrl.vi v12, v8, 1
; RV32I-NEXT:    vor.vv v8, v8, v12
; RV32I-NEXT:    vsrl.vi v12, v8, 2
; RV32I-NEXT:    vor.vv v8, v8, v12
; RV32I-NEXT:    vsrl.vi v12, v8, 4
; RV32I-NEXT:    vor.vv v8, v8, v12
; RV32I-NEXT:    vsrl.vi v12, v8, 8
; RV32I-NEXT:    vor.vv v8, v8, v12
; RV32I-NEXT:    vsrl.vi v12, v8, 16
; RV32I-NEXT:    vor.vv v8, v8, v12
; RV32I-NEXT:    vxor.vi v8, v8, -1
; RV32I-NEXT:    vsrl.vi v12, v8, 1
; RV32I-NEXT:    lui a0, 349525
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vand.vx v12, v12, a0
; RV32I-NEXT:    vsub.vv v8, v8, v12
; RV32I-NEXT:    lui a0, 209715
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vand.vx v12, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v12, v8
; RV32I-NEXT:    vsrl.vi v12, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v12
; RV32I-NEXT:    lui a0, 61681
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    lui a0, 4112
; RV32I-NEXT:    addi a0, a0, 257
; RV32I-NEXT:    vmul.vx v8, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 24
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ctlz_nxv8i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    vsetvli a0, zero, e32, m4, ta, mu
; RV64I-NEXT:    vsrl.vi v12, v8, 1
; RV64I-NEXT:    vor.vv v8, v8, v12
; RV64I-NEXT:    vsrl.vi v12, v8, 2
; RV64I-NEXT:    vor.vv v8, v8, v12
; RV64I-NEXT:    vsrl.vi v12, v8, 4
; RV64I-NEXT:    vor.vv v8, v8, v12
; RV64I-NEXT:    vsrl.vi v12, v8, 8
; RV64I-NEXT:    vor.vv v8, v8, v12
; RV64I-NEXT:    vsrl.vi v12, v8, 16
; RV64I-NEXT:    vor.vv v8, v8, v12
; RV64I-NEXT:    vxor.vi v8, v8, -1
; RV64I-NEXT:    vsrl.vi v12, v8, 1
; RV64I-NEXT:    lui a0, 349525
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    vand.vx v12, v12, a0
; RV64I-NEXT:    vsub.vv v8, v8, v12
; RV64I-NEXT:    lui a0, 209715
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    vand.vx v12, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v12, v8
; RV64I-NEXT:    vsrl.vi v12, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v12
; RV64I-NEXT:    lui a0, 61681
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    lui a0, 4112
; RV64I-NEXT:    addiw a0, a0, 257
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 24
; RV64I-NEXT:    ret
;
; RV32D-LABEL: ctlz_nxv8i32:
; RV32D:       # %bb.0:
; RV32D-NEXT:    vsetvli a0, zero, e32, m4, ta, mu
; RV32D-NEXT:    vfwcvt.f.xu.v v16, v8
; RV32D-NEXT:    li a0, 52
; RV32D-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; RV32D-NEXT:    vsrl.vx v16, v16, a0
; RV32D-NEXT:    vsetvli zero, zero, e32, m4, ta, mu
; RV32D-NEXT:    vnsrl.wx v12, v16, zero
; RV32D-NEXT:    li a0, 1054
; RV32D-NEXT:    vrsub.vx v12, v12, a0
; RV32D-NEXT:    vmseq.vi v0, v8, 0
; RV32D-NEXT:    li a0, 32
; RV32D-NEXT:    vmerge.vxm v8, v12, a0, v0
; RV32D-NEXT:    ret
;
; RV64D-LABEL: ctlz_nxv8i32:
; RV64D:       # %bb.0:
; RV64D-NEXT:    vsetvli a0, zero, e32, m4, ta, mu
; RV64D-NEXT:    vfwcvt.f.xu.v v16, v8
; RV64D-NEXT:    li a0, 52
; RV64D-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; RV64D-NEXT:    vsrl.vx v16, v16, a0
; RV64D-NEXT:    vsetvli zero, zero, e32, m4, ta, mu
; RV64D-NEXT:    vnsrl.wx v12, v16, zero
; RV64D-NEXT:    li a0, 1054
; RV64D-NEXT:    vrsub.vx v12, v12, a0
; RV64D-NEXT:    vmseq.vi v0, v8, 0
; RV64D-NEXT:    li a0, 32
; RV64D-NEXT:    vmerge.vxm v8, v12, a0, v0
; RV64D-NEXT:    ret
  %a = call <vscale x 8 x i32> @llvm.ctlz.nxv8i32(<vscale x 8 x i32> %va, i1 false)
  ret <vscale x 8 x i32> %a
}
declare <vscale x 8 x i32> @llvm.ctlz.nxv8i32(<vscale x 8 x i32>, i1)

define <vscale x 16 x i32> @ctlz_nxv16i32(<vscale x 16 x i32> %va) {
; RV32-LABEL: ctlz_nxv16i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32, m8, ta, mu
; RV32-NEXT:    vsrl.vi v16, v8, 1
; RV32-NEXT:    vor.vv v8, v8, v16
; RV32-NEXT:    vsrl.vi v16, v8, 2
; RV32-NEXT:    vor.vv v8, v8, v16
; RV32-NEXT:    vsrl.vi v16, v8, 4
; RV32-NEXT:    vor.vv v8, v8, v16
; RV32-NEXT:    vsrl.vi v16, v8, 8
; RV32-NEXT:    vor.vv v8, v8, v16
; RV32-NEXT:    vsrl.vi v16, v8, 16
; RV32-NEXT:    vor.vv v8, v8, v16
; RV32-NEXT:    vxor.vi v8, v8, -1
; RV32-NEXT:    vsrl.vi v16, v8, 1
; RV32-NEXT:    lui a0, 349525
; RV32-NEXT:    addi a0, a0, 1365
; RV32-NEXT:    vand.vx v16, v16, a0
; RV32-NEXT:    vsub.vv v8, v8, v16
; RV32-NEXT:    lui a0, 209715
; RV32-NEXT:    addi a0, a0, 819
; RV32-NEXT:    vand.vx v16, v8, a0
; RV32-NEXT:    vsrl.vi v8, v8, 2
; RV32-NEXT:    vand.vx v8, v8, a0
; RV32-NEXT:    vadd.vv v8, v16, v8
; RV32-NEXT:    vsrl.vi v16, v8, 4
; RV32-NEXT:    vadd.vv v8, v8, v16
; RV32-NEXT:    lui a0, 61681
; RV32-NEXT:    addi a0, a0, -241
; RV32-NEXT:    vand.vx v8, v8, a0
; RV32-NEXT:    lui a0, 4112
; RV32-NEXT:    addi a0, a0, 257
; RV32-NEXT:    vmul.vx v8, v8, a0
; RV32-NEXT:    vsrl.vi v8, v8, 24
; RV32-NEXT:    ret
;
; RV64-LABEL: ctlz_nxv16i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32, m8, ta, mu
; RV64-NEXT:    vsrl.vi v16, v8, 1
; RV64-NEXT:    vor.vv v8, v8, v16
; RV64-NEXT:    vsrl.vi v16, v8, 2
; RV64-NEXT:    vor.vv v8, v8, v16
; RV64-NEXT:    vsrl.vi v16, v8, 4
; RV64-NEXT:    vor.vv v8, v8, v16
; RV64-NEXT:    vsrl.vi v16, v8, 8
; RV64-NEXT:    vor.vv v8, v8, v16
; RV64-NEXT:    vsrl.vi v16, v8, 16
; RV64-NEXT:    vor.vv v8, v8, v16
; RV64-NEXT:    vxor.vi v8, v8, -1
; RV64-NEXT:    vsrl.vi v16, v8, 1
; RV64-NEXT:    lui a0, 349525
; RV64-NEXT:    addiw a0, a0, 1365
; RV64-NEXT:    vand.vx v16, v16, a0
; RV64-NEXT:    vsub.vv v8, v8, v16
; RV64-NEXT:    lui a0, 209715
; RV64-NEXT:    addiw a0, a0, 819
; RV64-NEXT:    vand.vx v16, v8, a0
; RV64-NEXT:    vsrl.vi v8, v8, 2
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vadd.vv v8, v16, v8
; RV64-NEXT:    vsrl.vi v16, v8, 4
; RV64-NEXT:    vadd.vv v8, v8, v16
; RV64-NEXT:    lui a0, 61681
; RV64-NEXT:    addiw a0, a0, -241
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    lui a0, 4112
; RV64-NEXT:    addiw a0, a0, 257
; RV64-NEXT:    vmul.vx v8, v8, a0
; RV64-NEXT:    vsrl.vi v8, v8, 24
; RV64-NEXT:    ret
  %a = call <vscale x 16 x i32> @llvm.ctlz.nxv16i32(<vscale x 16 x i32> %va, i1 false)
  ret <vscale x 16 x i32> %a
}
declare <vscale x 16 x i32> @llvm.ctlz.nxv16i32(<vscale x 16 x i32>, i1)

define <vscale x 1 x i64> @ctlz_nxv1i64(<vscale x 1 x i64> %va) {
; RV32-LABEL: ctlz_nxv1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    lui a0, 349525
; RV32-NEXT:    addi a0, a0, 1365
; RV32-NEXT:    sw a0, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    lui a0, 209715
; RV32-NEXT:    addi a0, a0, 819
; RV32-NEXT:    sw a0, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    lui a0, 61681
; RV32-NEXT:    addi a0, a0, -241
; RV32-NEXT:    sw a0, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    lui a0, 4112
; RV32-NEXT:    addi a0, a0, 257
; RV32-NEXT:    sw a0, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    vsetvli a0, zero, e64, m1, ta, mu
; RV32-NEXT:    vsrl.vi v9, v8, 1
; RV32-NEXT:    vor.vv v8, v8, v9
; RV32-NEXT:    vsrl.vi v9, v8, 2
; RV32-NEXT:    vor.vv v8, v8, v9
; RV32-NEXT:    vsrl.vi v9, v8, 4
; RV32-NEXT:    vor.vv v8, v8, v9
; RV32-NEXT:    vsrl.vi v9, v8, 8
; RV32-NEXT:    vor.vv v8, v8, v9
; RV32-NEXT:    vsrl.vi v9, v8, 16
; RV32-NEXT:    vor.vv v8, v8, v9
; RV32-NEXT:    li a0, 32
; RV32-NEXT:    vsrl.vx v9, v8, a0
; RV32-NEXT:    vor.vv v8, v8, v9
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vlse64.v v9, (a0), zero
; RV32-NEXT:    vxor.vi v8, v8, -1
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vlse64.v v10, (a0), zero
; RV32-NEXT:    vsrl.vi v11, v8, 1
; RV32-NEXT:    vand.vv v9, v11, v9
; RV32-NEXT:    vsub.vv v8, v8, v9
; RV32-NEXT:    vand.vv v9, v8, v10
; RV32-NEXT:    vsrl.vi v8, v8, 2
; RV32-NEXT:    vand.vv v8, v8, v10
; RV32-NEXT:    vadd.vv v8, v9, v8
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vlse64.v v9, (a0), zero
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vlse64.v v10, (a0), zero
; RV32-NEXT:    vsrl.vi v11, v8, 4
; RV32-NEXT:    vadd.vv v8, v8, v11
; RV32-NEXT:    vand.vv v8, v8, v9
; RV32-NEXT:    vmul.vv v8, v8, v10
; RV32-NEXT:    li a0, 56
; RV32-NEXT:    vsrl.vx v8, v8, a0
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: ctlz_nxv1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64, m1, ta, mu
; RV64-NEXT:    vsrl.vi v9, v8, 1
; RV64-NEXT:    vor.vv v8, v8, v9
; RV64-NEXT:    vsrl.vi v9, v8, 2
; RV64-NEXT:    vor.vv v8, v8, v9
; RV64-NEXT:    vsrl.vi v9, v8, 4
; RV64-NEXT:    vor.vv v8, v8, v9
; RV64-NEXT:    vsrl.vi v9, v8, 8
; RV64-NEXT:    vor.vv v8, v8, v9
; RV64-NEXT:    vsrl.vi v9, v8, 16
; RV64-NEXT:    vor.vv v8, v8, v9
; RV64-NEXT:    li a0, 32
; RV64-NEXT:    vsrl.vx v9, v8, a0
; RV64-NEXT:    vor.vv v8, v8, v9
; RV64-NEXT:    vxor.vi v8, v8, -1
; RV64-NEXT:    lui a0, %hi(.LCPI18_0)
; RV64-NEXT:    ld a0, %lo(.LCPI18_0)(a0)
; RV64-NEXT:    lui a1, %hi(.LCPI18_1)
; RV64-NEXT:    ld a1, %lo(.LCPI18_1)(a1)
; RV64-NEXT:    vsrl.vi v9, v8, 1
; RV64-NEXT:    vand.vx v9, v9, a0
; RV64-NEXT:    vsub.vv v8, v8, v9
; RV64-NEXT:    vand.vx v9, v8, a1
; RV64-NEXT:    vsrl.vi v8, v8, 2
; RV64-NEXT:    vand.vx v8, v8, a1
; RV64-NEXT:    vadd.vv v8, v9, v8
; RV64-NEXT:    lui a0, %hi(.LCPI18_2)
; RV64-NEXT:    ld a0, %lo(.LCPI18_2)(a0)
; RV64-NEXT:    lui a1, %hi(.LCPI18_3)
; RV64-NEXT:    ld a1, %lo(.LCPI18_3)(a1)
; RV64-NEXT:    vsrl.vi v9, v8, 4
; RV64-NEXT:    vadd.vv v8, v8, v9
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vmul.vx v8, v8, a1
; RV64-NEXT:    li a0, 56
; RV64-NEXT:    vsrl.vx v8, v8, a0
; RV64-NEXT:    ret
  %a = call <vscale x 1 x i64> @llvm.ctlz.nxv1i64(<vscale x 1 x i64> %va, i1 false)
  ret <vscale x 1 x i64> %a
}
declare <vscale x 1 x i64> @llvm.ctlz.nxv1i64(<vscale x 1 x i64>, i1)

define <vscale x 2 x i64> @ctlz_nxv2i64(<vscale x 2 x i64> %va) {
; RV32-LABEL: ctlz_nxv2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    lui a0, 349525
; RV32-NEXT:    addi a0, a0, 1365
; RV32-NEXT:    sw a0, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    lui a0, 209715
; RV32-NEXT:    addi a0, a0, 819
; RV32-NEXT:    sw a0, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    lui a0, 61681
; RV32-NEXT:    addi a0, a0, -241
; RV32-NEXT:    sw a0, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    lui a0, 4112
; RV32-NEXT:    addi a0, a0, 257
; RV32-NEXT:    sw a0, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    vsetvli a0, zero, e64, m2, ta, mu
; RV32-NEXT:    vsrl.vi v10, v8, 1
; RV32-NEXT:    vor.vv v8, v8, v10
; RV32-NEXT:    vsrl.vi v10, v8, 2
; RV32-NEXT:    vor.vv v8, v8, v10
; RV32-NEXT:    vsrl.vi v10, v8, 4
; RV32-NEXT:    vor.vv v8, v8, v10
; RV32-NEXT:    vsrl.vi v10, v8, 8
; RV32-NEXT:    vor.vv v8, v8, v10
; RV32-NEXT:    vsrl.vi v10, v8, 16
; RV32-NEXT:    vor.vv v8, v8, v10
; RV32-NEXT:    li a0, 32
; RV32-NEXT:    vsrl.vx v10, v8, a0
; RV32-NEXT:    vor.vv v8, v8, v10
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vlse64.v v10, (a0), zero
; RV32-NEXT:    vxor.vi v8, v8, -1
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vlse64.v v12, (a0), zero
; RV32-NEXT:    vsrl.vi v14, v8, 1
; RV32-NEXT:    vand.vv v10, v14, v10
; RV32-NEXT:    vsub.vv v8, v8, v10
; RV32-NEXT:    vand.vv v10, v8, v12
; RV32-NEXT:    vsrl.vi v8, v8, 2
; RV32-NEXT:    vand.vv v8, v8, v12
; RV32-NEXT:    vadd.vv v8, v10, v8
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vlse64.v v10, (a0), zero
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vlse64.v v12, (a0), zero
; RV32-NEXT:    vsrl.vi v14, v8, 4
; RV32-NEXT:    vadd.vv v8, v8, v14
; RV32-NEXT:    vand.vv v8, v8, v10
; RV32-NEXT:    vmul.vv v8, v8, v12
; RV32-NEXT:    li a0, 56
; RV32-NEXT:    vsrl.vx v8, v8, a0
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: ctlz_nxv2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64, m2, ta, mu
; RV64-NEXT:    vsrl.vi v10, v8, 1
; RV64-NEXT:    vor.vv v8, v8, v10
; RV64-NEXT:    vsrl.vi v10, v8, 2
; RV64-NEXT:    vor.vv v8, v8, v10
; RV64-NEXT:    vsrl.vi v10, v8, 4
; RV64-NEXT:    vor.vv v8, v8, v10
; RV64-NEXT:    vsrl.vi v10, v8, 8
; RV64-NEXT:    vor.vv v8, v8, v10
; RV64-NEXT:    vsrl.vi v10, v8, 16
; RV64-NEXT:    vor.vv v8, v8, v10
; RV64-NEXT:    li a0, 32
; RV64-NEXT:    vsrl.vx v10, v8, a0
; RV64-NEXT:    vor.vv v8, v8, v10
; RV64-NEXT:    vxor.vi v8, v8, -1
; RV64-NEXT:    lui a0, %hi(.LCPI19_0)
; RV64-NEXT:    ld a0, %lo(.LCPI19_0)(a0)
; RV64-NEXT:    lui a1, %hi(.LCPI19_1)
; RV64-NEXT:    ld a1, %lo(.LCPI19_1)(a1)
; RV64-NEXT:    vsrl.vi v10, v8, 1
; RV64-NEXT:    vand.vx v10, v10, a0
; RV64-NEXT:    vsub.vv v8, v8, v10
; RV64-NEXT:    vand.vx v10, v8, a1
; RV64-NEXT:    vsrl.vi v8, v8, 2
; RV64-NEXT:    vand.vx v8, v8, a1
; RV64-NEXT:    vadd.vv v8, v10, v8
; RV64-NEXT:    lui a0, %hi(.LCPI19_2)
; RV64-NEXT:    ld a0, %lo(.LCPI19_2)(a0)
; RV64-NEXT:    lui a1, %hi(.LCPI19_3)
; RV64-NEXT:    ld a1, %lo(.LCPI19_3)(a1)
; RV64-NEXT:    vsrl.vi v10, v8, 4
; RV64-NEXT:    vadd.vv v8, v8, v10
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vmul.vx v8, v8, a1
; RV64-NEXT:    li a0, 56
; RV64-NEXT:    vsrl.vx v8, v8, a0
; RV64-NEXT:    ret
  %a = call <vscale x 2 x i64> @llvm.ctlz.nxv2i64(<vscale x 2 x i64> %va, i1 false)
  ret <vscale x 2 x i64> %a
}
declare <vscale x 2 x i64> @llvm.ctlz.nxv2i64(<vscale x 2 x i64>, i1)

define <vscale x 4 x i64> @ctlz_nxv4i64(<vscale x 4 x i64> %va) {
; RV32-LABEL: ctlz_nxv4i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    lui a0, 349525
; RV32-NEXT:    addi a0, a0, 1365
; RV32-NEXT:    sw a0, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    lui a0, 209715
; RV32-NEXT:    addi a0, a0, 819
; RV32-NEXT:    sw a0, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    lui a0, 61681
; RV32-NEXT:    addi a0, a0, -241
; RV32-NEXT:    sw a0, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    lui a0, 4112
; RV32-NEXT:    addi a0, a0, 257
; RV32-NEXT:    sw a0, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    vsetvli a0, zero, e64, m4, ta, mu
; RV32-NEXT:    vsrl.vi v12, v8, 1
; RV32-NEXT:    vor.vv v8, v8, v12
; RV32-NEXT:    vsrl.vi v12, v8, 2
; RV32-NEXT:    vor.vv v8, v8, v12
; RV32-NEXT:    vsrl.vi v12, v8, 4
; RV32-NEXT:    vor.vv v8, v8, v12
; RV32-NEXT:    vsrl.vi v12, v8, 8
; RV32-NEXT:    vor.vv v8, v8, v12
; RV32-NEXT:    vsrl.vi v12, v8, 16
; RV32-NEXT:    vor.vv v8, v8, v12
; RV32-NEXT:    li a0, 32
; RV32-NEXT:    vsrl.vx v12, v8, a0
; RV32-NEXT:    vor.vv v8, v8, v12
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vlse64.v v12, (a0), zero
; RV32-NEXT:    vxor.vi v8, v8, -1
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vlse64.v v16, (a0), zero
; RV32-NEXT:    vsrl.vi v20, v8, 1
; RV32-NEXT:    vand.vv v12, v20, v12
; RV32-NEXT:    vsub.vv v8, v8, v12
; RV32-NEXT:    vand.vv v12, v8, v16
; RV32-NEXT:    vsrl.vi v8, v8, 2
; RV32-NEXT:    vand.vv v8, v8, v16
; RV32-NEXT:    vadd.vv v8, v12, v8
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vlse64.v v12, (a0), zero
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vlse64.v v16, (a0), zero
; RV32-NEXT:    vsrl.vi v20, v8, 4
; RV32-NEXT:    vadd.vv v8, v8, v20
; RV32-NEXT:    vand.vv v8, v8, v12
; RV32-NEXT:    vmul.vv v8, v8, v16
; RV32-NEXT:    li a0, 56
; RV32-NEXT:    vsrl.vx v8, v8, a0
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: ctlz_nxv4i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64, m4, ta, mu
; RV64-NEXT:    vsrl.vi v12, v8, 1
; RV64-NEXT:    vor.vv v8, v8, v12
; RV64-NEXT:    vsrl.vi v12, v8, 2
; RV64-NEXT:    vor.vv v8, v8, v12
; RV64-NEXT:    vsrl.vi v12, v8, 4
; RV64-NEXT:    vor.vv v8, v8, v12
; RV64-NEXT:    vsrl.vi v12, v8, 8
; RV64-NEXT:    vor.vv v8, v8, v12
; RV64-NEXT:    vsrl.vi v12, v8, 16
; RV64-NEXT:    vor.vv v8, v8, v12
; RV64-NEXT:    li a0, 32
; RV64-NEXT:    vsrl.vx v12, v8, a0
; RV64-NEXT:    vor.vv v8, v8, v12
; RV64-NEXT:    vxor.vi v8, v8, -1
; RV64-NEXT:    lui a0, %hi(.LCPI20_0)
; RV64-NEXT:    ld a0, %lo(.LCPI20_0)(a0)
; RV64-NEXT:    lui a1, %hi(.LCPI20_1)
; RV64-NEXT:    ld a1, %lo(.LCPI20_1)(a1)
; RV64-NEXT:    vsrl.vi v12, v8, 1
; RV64-NEXT:    vand.vx v12, v12, a0
; RV64-NEXT:    vsub.vv v8, v8, v12
; RV64-NEXT:    vand.vx v12, v8, a1
; RV64-NEXT:    vsrl.vi v8, v8, 2
; RV64-NEXT:    vand.vx v8, v8, a1
; RV64-NEXT:    vadd.vv v8, v12, v8
; RV64-NEXT:    lui a0, %hi(.LCPI20_2)
; RV64-NEXT:    ld a0, %lo(.LCPI20_2)(a0)
; RV64-NEXT:    lui a1, %hi(.LCPI20_3)
; RV64-NEXT:    ld a1, %lo(.LCPI20_3)(a1)
; RV64-NEXT:    vsrl.vi v12, v8, 4
; RV64-NEXT:    vadd.vv v8, v8, v12
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vmul.vx v8, v8, a1
; RV64-NEXT:    li a0, 56
; RV64-NEXT:    vsrl.vx v8, v8, a0
; RV64-NEXT:    ret
  %a = call <vscale x 4 x i64> @llvm.ctlz.nxv4i64(<vscale x 4 x i64> %va, i1 false)
  ret <vscale x 4 x i64> %a
}
declare <vscale x 4 x i64> @llvm.ctlz.nxv4i64(<vscale x 4 x i64>, i1)

define <vscale x 8 x i64> @ctlz_nxv8i64(<vscale x 8 x i64> %va) {
; RV32-LABEL: ctlz_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    lui a0, 349525
; RV32-NEXT:    addi a0, a0, 1365
; RV32-NEXT:    sw a0, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    lui a0, 209715
; RV32-NEXT:    addi a0, a0, 819
; RV32-NEXT:    sw a0, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    lui a0, 61681
; RV32-NEXT:    addi a0, a0, -241
; RV32-NEXT:    sw a0, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    lui a0, 4112
; RV32-NEXT:    addi a0, a0, 257
; RV32-NEXT:    sw a0, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    vsetvli a0, zero, e64, m8, ta, mu
; RV32-NEXT:    vsrl.vi v16, v8, 1
; RV32-NEXT:    vor.vv v8, v8, v16
; RV32-NEXT:    vsrl.vi v16, v8, 2
; RV32-NEXT:    vor.vv v8, v8, v16
; RV32-NEXT:    vsrl.vi v16, v8, 4
; RV32-NEXT:    vor.vv v8, v8, v16
; RV32-NEXT:    vsrl.vi v16, v8, 8
; RV32-NEXT:    vor.vv v8, v8, v16
; RV32-NEXT:    vsrl.vi v16, v8, 16
; RV32-NEXT:    vor.vv v8, v8, v16
; RV32-NEXT:    li a0, 32
; RV32-NEXT:    vsrl.vx v16, v8, a0
; RV32-NEXT:    vor.vv v8, v8, v16
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vlse64.v v16, (a0), zero
; RV32-NEXT:    vxor.vi v8, v8, -1
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vlse64.v v24, (a0), zero
; RV32-NEXT:    vsrl.vi v0, v8, 1
; RV32-NEXT:    vand.vv v16, v0, v16
; RV32-NEXT:    vsub.vv v8, v8, v16
; RV32-NEXT:    vand.vv v16, v8, v24
; RV32-NEXT:    vsrl.vi v8, v8, 2
; RV32-NEXT:    vand.vv v8, v8, v24
; RV32-NEXT:    vadd.vv v8, v16, v8
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vlse64.v v16, (a0), zero
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vlse64.v v24, (a0), zero
; RV32-NEXT:    vsrl.vi v0, v8, 4
; RV32-NEXT:    vadd.vv v8, v8, v0
; RV32-NEXT:    vand.vv v8, v8, v16
; RV32-NEXT:    vmul.vv v8, v8, v24
; RV32-NEXT:    li a0, 56
; RV32-NEXT:    vsrl.vx v8, v8, a0
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: ctlz_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64, m8, ta, mu
; RV64-NEXT:    vsrl.vi v16, v8, 1
; RV64-NEXT:    vor.vv v8, v8, v16
; RV64-NEXT:    vsrl.vi v16, v8, 2
; RV64-NEXT:    vor.vv v8, v8, v16
; RV64-NEXT:    vsrl.vi v16, v8, 4
; RV64-NEXT:    vor.vv v8, v8, v16
; RV64-NEXT:    vsrl.vi v16, v8, 8
; RV64-NEXT:    vor.vv v8, v8, v16
; RV64-NEXT:    vsrl.vi v16, v8, 16
; RV64-NEXT:    vor.vv v8, v8, v16
; RV64-NEXT:    li a0, 32
; RV64-NEXT:    vsrl.vx v16, v8, a0
; RV64-NEXT:    vor.vv v8, v8, v16
; RV64-NEXT:    vxor.vi v8, v8, -1
; RV64-NEXT:    lui a0, %hi(.LCPI21_0)
; RV64-NEXT:    ld a0, %lo(.LCPI21_0)(a0)
; RV64-NEXT:    lui a1, %hi(.LCPI21_1)
; RV64-NEXT:    ld a1, %lo(.LCPI21_1)(a1)
; RV64-NEXT:    vsrl.vi v16, v8, 1
; RV64-NEXT:    vand.vx v16, v16, a0
; RV64-NEXT:    vsub.vv v8, v8, v16
; RV64-NEXT:    vand.vx v16, v8, a1
; RV64-NEXT:    vsrl.vi v8, v8, 2
; RV64-NEXT:    vand.vx v8, v8, a1
; RV64-NEXT:    vadd.vv v8, v16, v8
; RV64-NEXT:    lui a0, %hi(.LCPI21_2)
; RV64-NEXT:    ld a0, %lo(.LCPI21_2)(a0)
; RV64-NEXT:    lui a1, %hi(.LCPI21_3)
; RV64-NEXT:    ld a1, %lo(.LCPI21_3)(a1)
; RV64-NEXT:    vsrl.vi v16, v8, 4
; RV64-NEXT:    vadd.vv v8, v8, v16
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vmul.vx v8, v8, a1
; RV64-NEXT:    li a0, 56
; RV64-NEXT:    vsrl.vx v8, v8, a0
; RV64-NEXT:    ret
  %a = call <vscale x 8 x i64> @llvm.ctlz.nxv8i64(<vscale x 8 x i64> %va, i1 false)
  ret <vscale x 8 x i64> %a
}
declare <vscale x 8 x i64> @llvm.ctlz.nxv8i64(<vscale x 8 x i64>, i1)

define <vscale x 1 x i8> @ctlz_zero_undef_nxv1i8(<vscale x 1 x i8> %va) {
; RV32I-LABEL: ctlz_zero_undef_nxv1i8:
; RV32I:       # %bb.0:
; RV32I-NEXT:    vsetvli a0, zero, e8, mf8, ta, mu
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 2
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vxor.vi v8, v8, -1
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    li a0, 85
; RV32I-NEXT:    vand.vx v9, v9, a0
; RV32I-NEXT:    vsub.vv v8, v8, v9
; RV32I-NEXT:    li a0, 51
; RV32I-NEXT:    vand.vx v9, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v9, v8
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v9
; RV32I-NEXT:    vand.vi v8, v8, 15
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ctlz_zero_undef_nxv1i8:
; RV64I:       # %bb.0:
; RV64I-NEXT:    vsetvli a0, zero, e8, mf8, ta, mu
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 2
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vxor.vi v8, v8, -1
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    li a0, 85
; RV64I-NEXT:    vand.vx v9, v9, a0
; RV64I-NEXT:    vsub.vv v8, v8, v9
; RV64I-NEXT:    li a0, 51
; RV64I-NEXT:    vand.vx v9, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v9, v8
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v9
; RV64I-NEXT:    vand.vi v8, v8, 15
; RV64I-NEXT:    ret
;
; RV32D-LABEL: ctlz_zero_undef_nxv1i8:
; RV32D:       # %bb.0:
; RV32D-NEXT:    vsetvli a0, zero, e32, mf2, ta, mu
; RV32D-NEXT:    vzext.vf4 v9, v8
; RV32D-NEXT:    vfcvt.f.xu.v v8, v9
; RV32D-NEXT:    vsrl.vi v8, v8, 23
; RV32D-NEXT:    vsetvli zero, zero, e16, mf4, ta, mu
; RV32D-NEXT:    vnsrl.wx v8, v8, zero
; RV32D-NEXT:    vsetvli zero, zero, e8, mf8, ta, mu
; RV32D-NEXT:    vnsrl.wx v8, v8, zero
; RV32D-NEXT:    li a0, 134
; RV32D-NEXT:    vrsub.vx v8, v8, a0
; RV32D-NEXT:    ret
;
; RV64D-LABEL: ctlz_zero_undef_nxv1i8:
; RV64D:       # %bb.0:
; RV64D-NEXT:    vsetvli a0, zero, e32, mf2, ta, mu
; RV64D-NEXT:    vzext.vf4 v9, v8
; RV64D-NEXT:    vfcvt.f.xu.v v8, v9
; RV64D-NEXT:    vsrl.vi v8, v8, 23
; RV64D-NEXT:    vsetvli zero, zero, e16, mf4, ta, mu
; RV64D-NEXT:    vnsrl.wx v8, v8, zero
; RV64D-NEXT:    vsetvli zero, zero, e8, mf8, ta, mu
; RV64D-NEXT:    vnsrl.wx v8, v8, zero
; RV64D-NEXT:    li a0, 134
; RV64D-NEXT:    vrsub.vx v8, v8, a0
; RV64D-NEXT:    ret
  %a = call <vscale x 1 x i8> @llvm.ctlz.nxv1i8(<vscale x 1 x i8> %va, i1 true)
  ret <vscale x 1 x i8> %a
}

define <vscale x 2 x i8> @ctlz_zero_undef_nxv2i8(<vscale x 2 x i8> %va) {
; RV32I-LABEL: ctlz_zero_undef_nxv2i8:
; RV32I:       # %bb.0:
; RV32I-NEXT:    vsetvli a0, zero, e8, mf4, ta, mu
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 2
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vxor.vi v8, v8, -1
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    li a0, 85
; RV32I-NEXT:    vand.vx v9, v9, a0
; RV32I-NEXT:    vsub.vv v8, v8, v9
; RV32I-NEXT:    li a0, 51
; RV32I-NEXT:    vand.vx v9, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v9, v8
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v9
; RV32I-NEXT:    vand.vi v8, v8, 15
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ctlz_zero_undef_nxv2i8:
; RV64I:       # %bb.0:
; RV64I-NEXT:    vsetvli a0, zero, e8, mf4, ta, mu
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 2
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vxor.vi v8, v8, -1
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    li a0, 85
; RV64I-NEXT:    vand.vx v9, v9, a0
; RV64I-NEXT:    vsub.vv v8, v8, v9
; RV64I-NEXT:    li a0, 51
; RV64I-NEXT:    vand.vx v9, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v9, v8
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v9
; RV64I-NEXT:    vand.vi v8, v8, 15
; RV64I-NEXT:    ret
;
; RV32D-LABEL: ctlz_zero_undef_nxv2i8:
; RV32D:       # %bb.0:
; RV32D-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; RV32D-NEXT:    vzext.vf4 v9, v8
; RV32D-NEXT:    vfcvt.f.xu.v v8, v9
; RV32D-NEXT:    vsrl.vi v8, v8, 23
; RV32D-NEXT:    vsetvli zero, zero, e16, mf2, ta, mu
; RV32D-NEXT:    vnsrl.wx v8, v8, zero
; RV32D-NEXT:    vsetvli zero, zero, e8, mf4, ta, mu
; RV32D-NEXT:    vnsrl.wx v8, v8, zero
; RV32D-NEXT:    li a0, 134
; RV32D-NEXT:    vrsub.vx v8, v8, a0
; RV32D-NEXT:    ret
;
; RV64D-LABEL: ctlz_zero_undef_nxv2i8:
; RV64D:       # %bb.0:
; RV64D-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; RV64D-NEXT:    vzext.vf4 v9, v8
; RV64D-NEXT:    vfcvt.f.xu.v v8, v9
; RV64D-NEXT:    vsrl.vi v8, v8, 23
; RV64D-NEXT:    vsetvli zero, zero, e16, mf2, ta, mu
; RV64D-NEXT:    vnsrl.wx v8, v8, zero
; RV64D-NEXT:    vsetvli zero, zero, e8, mf4, ta, mu
; RV64D-NEXT:    vnsrl.wx v8, v8, zero
; RV64D-NEXT:    li a0, 134
; RV64D-NEXT:    vrsub.vx v8, v8, a0
; RV64D-NEXT:    ret
  %a = call <vscale x 2 x i8> @llvm.ctlz.nxv2i8(<vscale x 2 x i8> %va, i1 true)
  ret <vscale x 2 x i8> %a
}

define <vscale x 4 x i8> @ctlz_zero_undef_nxv4i8(<vscale x 4 x i8> %va) {
; RV32I-LABEL: ctlz_zero_undef_nxv4i8:
; RV32I:       # %bb.0:
; RV32I-NEXT:    vsetvli a0, zero, e8, mf2, ta, mu
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 2
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vxor.vi v8, v8, -1
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    li a0, 85
; RV32I-NEXT:    vand.vx v9, v9, a0
; RV32I-NEXT:    vsub.vv v8, v8, v9
; RV32I-NEXT:    li a0, 51
; RV32I-NEXT:    vand.vx v9, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v9, v8
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v9
; RV32I-NEXT:    vand.vi v8, v8, 15
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ctlz_zero_undef_nxv4i8:
; RV64I:       # %bb.0:
; RV64I-NEXT:    vsetvli a0, zero, e8, mf2, ta, mu
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 2
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vxor.vi v8, v8, -1
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    li a0, 85
; RV64I-NEXT:    vand.vx v9, v9, a0
; RV64I-NEXT:    vsub.vv v8, v8, v9
; RV64I-NEXT:    li a0, 51
; RV64I-NEXT:    vand.vx v9, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v9, v8
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v9
; RV64I-NEXT:    vand.vi v8, v8, 15
; RV64I-NEXT:    ret
;
; RV32D-LABEL: ctlz_zero_undef_nxv4i8:
; RV32D:       # %bb.0:
; RV32D-NEXT:    vsetvli a0, zero, e32, m2, ta, mu
; RV32D-NEXT:    vzext.vf4 v10, v8
; RV32D-NEXT:    vfcvt.f.xu.v v8, v10
; RV32D-NEXT:    vsrl.vi v8, v8, 23
; RV32D-NEXT:    vsetvli zero, zero, e16, m1, ta, mu
; RV32D-NEXT:    vnsrl.wx v10, v8, zero
; RV32D-NEXT:    vsetvli zero, zero, e8, mf2, ta, mu
; RV32D-NEXT:    vnsrl.wx v8, v10, zero
; RV32D-NEXT:    li a0, 134
; RV32D-NEXT:    vrsub.vx v8, v8, a0
; RV32D-NEXT:    ret
;
; RV64D-LABEL: ctlz_zero_undef_nxv4i8:
; RV64D:       # %bb.0:
; RV64D-NEXT:    vsetvli a0, zero, e32, m2, ta, mu
; RV64D-NEXT:    vzext.vf4 v10, v8
; RV64D-NEXT:    vfcvt.f.xu.v v8, v10
; RV64D-NEXT:    vsrl.vi v8, v8, 23
; RV64D-NEXT:    vsetvli zero, zero, e16, m1, ta, mu
; RV64D-NEXT:    vnsrl.wx v10, v8, zero
; RV64D-NEXT:    vsetvli zero, zero, e8, mf2, ta, mu
; RV64D-NEXT:    vnsrl.wx v8, v10, zero
; RV64D-NEXT:    li a0, 134
; RV64D-NEXT:    vrsub.vx v8, v8, a0
; RV64D-NEXT:    ret
  %a = call <vscale x 4 x i8> @llvm.ctlz.nxv4i8(<vscale x 4 x i8> %va, i1 true)
  ret <vscale x 4 x i8> %a
}

define <vscale x 8 x i8> @ctlz_zero_undef_nxv8i8(<vscale x 8 x i8> %va) {
; RV32I-LABEL: ctlz_zero_undef_nxv8i8:
; RV32I:       # %bb.0:
; RV32I-NEXT:    vsetvli a0, zero, e8, m1, ta, mu
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 2
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vxor.vi v8, v8, -1
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    li a0, 85
; RV32I-NEXT:    vand.vx v9, v9, a0
; RV32I-NEXT:    vsub.vv v8, v8, v9
; RV32I-NEXT:    li a0, 51
; RV32I-NEXT:    vand.vx v9, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v9, v8
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v9
; RV32I-NEXT:    vand.vi v8, v8, 15
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ctlz_zero_undef_nxv8i8:
; RV64I:       # %bb.0:
; RV64I-NEXT:    vsetvli a0, zero, e8, m1, ta, mu
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 2
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vxor.vi v8, v8, -1
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    li a0, 85
; RV64I-NEXT:    vand.vx v9, v9, a0
; RV64I-NEXT:    vsub.vv v8, v8, v9
; RV64I-NEXT:    li a0, 51
; RV64I-NEXT:    vand.vx v9, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v9, v8
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v9
; RV64I-NEXT:    vand.vi v8, v8, 15
; RV64I-NEXT:    ret
;
; RV32D-LABEL: ctlz_zero_undef_nxv8i8:
; RV32D:       # %bb.0:
; RV32D-NEXT:    vsetvli a0, zero, e32, m4, ta, mu
; RV32D-NEXT:    vzext.vf4 v12, v8
; RV32D-NEXT:    vfcvt.f.xu.v v8, v12
; RV32D-NEXT:    vsrl.vi v8, v8, 23
; RV32D-NEXT:    vsetvli zero, zero, e16, m2, ta, mu
; RV32D-NEXT:    vnsrl.wx v12, v8, zero
; RV32D-NEXT:    vsetvli zero, zero, e8, m1, ta, mu
; RV32D-NEXT:    vnsrl.wx v8, v12, zero
; RV32D-NEXT:    li a0, 134
; RV32D-NEXT:    vrsub.vx v8, v8, a0
; RV32D-NEXT:    ret
;
; RV64D-LABEL: ctlz_zero_undef_nxv8i8:
; RV64D:       # %bb.0:
; RV64D-NEXT:    vsetvli a0, zero, e32, m4, ta, mu
; RV64D-NEXT:    vzext.vf4 v12, v8
; RV64D-NEXT:    vfcvt.f.xu.v v8, v12
; RV64D-NEXT:    vsrl.vi v8, v8, 23
; RV64D-NEXT:    vsetvli zero, zero, e16, m2, ta, mu
; RV64D-NEXT:    vnsrl.wx v12, v8, zero
; RV64D-NEXT:    vsetvli zero, zero, e8, m1, ta, mu
; RV64D-NEXT:    vnsrl.wx v8, v12, zero
; RV64D-NEXT:    li a0, 134
; RV64D-NEXT:    vrsub.vx v8, v8, a0
; RV64D-NEXT:    ret
  %a = call <vscale x 8 x i8> @llvm.ctlz.nxv8i8(<vscale x 8 x i8> %va, i1 true)
  ret <vscale x 8 x i8> %a
}

define <vscale x 16 x i8> @ctlz_zero_undef_nxv16i8(<vscale x 16 x i8> %va) {
; RV32I-LABEL: ctlz_zero_undef_nxv16i8:
; RV32I:       # %bb.0:
; RV32I-NEXT:    vsetvli a0, zero, e8, m2, ta, mu
; RV32I-NEXT:    vsrl.vi v10, v8, 1
; RV32I-NEXT:    vor.vv v8, v8, v10
; RV32I-NEXT:    vsrl.vi v10, v8, 2
; RV32I-NEXT:    vor.vv v8, v8, v10
; RV32I-NEXT:    vsrl.vi v10, v8, 4
; RV32I-NEXT:    vor.vv v8, v8, v10
; RV32I-NEXT:    vxor.vi v8, v8, -1
; RV32I-NEXT:    vsrl.vi v10, v8, 1
; RV32I-NEXT:    li a0, 85
; RV32I-NEXT:    vand.vx v10, v10, a0
; RV32I-NEXT:    vsub.vv v8, v8, v10
; RV32I-NEXT:    li a0, 51
; RV32I-NEXT:    vand.vx v10, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v10, v8
; RV32I-NEXT:    vsrl.vi v10, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v10
; RV32I-NEXT:    vand.vi v8, v8, 15
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ctlz_zero_undef_nxv16i8:
; RV64I:       # %bb.0:
; RV64I-NEXT:    vsetvli a0, zero, e8, m2, ta, mu
; RV64I-NEXT:    vsrl.vi v10, v8, 1
; RV64I-NEXT:    vor.vv v8, v8, v10
; RV64I-NEXT:    vsrl.vi v10, v8, 2
; RV64I-NEXT:    vor.vv v8, v8, v10
; RV64I-NEXT:    vsrl.vi v10, v8, 4
; RV64I-NEXT:    vor.vv v8, v8, v10
; RV64I-NEXT:    vxor.vi v8, v8, -1
; RV64I-NEXT:    vsrl.vi v10, v8, 1
; RV64I-NEXT:    li a0, 85
; RV64I-NEXT:    vand.vx v10, v10, a0
; RV64I-NEXT:    vsub.vv v8, v8, v10
; RV64I-NEXT:    li a0, 51
; RV64I-NEXT:    vand.vx v10, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v10, v8
; RV64I-NEXT:    vsrl.vi v10, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v10
; RV64I-NEXT:    vand.vi v8, v8, 15
; RV64I-NEXT:    ret
;
; RV32D-LABEL: ctlz_zero_undef_nxv16i8:
; RV32D:       # %bb.0:
; RV32D-NEXT:    vsetvli a0, zero, e32, m8, ta, mu
; RV32D-NEXT:    vzext.vf4 v16, v8
; RV32D-NEXT:    vfcvt.f.xu.v v8, v16
; RV32D-NEXT:    vsrl.vi v8, v8, 23
; RV32D-NEXT:    vsetvli zero, zero, e16, m4, ta, mu
; RV32D-NEXT:    vnsrl.wx v16, v8, zero
; RV32D-NEXT:    vsetvli zero, zero, e8, m2, ta, mu
; RV32D-NEXT:    vnsrl.wx v8, v16, zero
; RV32D-NEXT:    li a0, 134
; RV32D-NEXT:    vrsub.vx v8, v8, a0
; RV32D-NEXT:    ret
;
; RV64D-LABEL: ctlz_zero_undef_nxv16i8:
; RV64D:       # %bb.0:
; RV64D-NEXT:    vsetvli a0, zero, e32, m8, ta, mu
; RV64D-NEXT:    vzext.vf4 v16, v8
; RV64D-NEXT:    vfcvt.f.xu.v v8, v16
; RV64D-NEXT:    vsrl.vi v8, v8, 23
; RV64D-NEXT:    vsetvli zero, zero, e16, m4, ta, mu
; RV64D-NEXT:    vnsrl.wx v16, v8, zero
; RV64D-NEXT:    vsetvli zero, zero, e8, m2, ta, mu
; RV64D-NEXT:    vnsrl.wx v8, v16, zero
; RV64D-NEXT:    li a0, 134
; RV64D-NEXT:    vrsub.vx v8, v8, a0
; RV64D-NEXT:    ret
  %a = call <vscale x 16 x i8> @llvm.ctlz.nxv16i8(<vscale x 16 x i8> %va, i1 true)
  ret <vscale x 16 x i8> %a
}

define <vscale x 32 x i8> @ctlz_zero_undef_nxv32i8(<vscale x 32 x i8> %va) {
; CHECK-LABEL: ctlz_zero_undef_nxv32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m4, ta, mu
; CHECK-NEXT:    vsrl.vi v12, v8, 1
; CHECK-NEXT:    vor.vv v8, v8, v12
; CHECK-NEXT:    vsrl.vi v12, v8, 2
; CHECK-NEXT:    vor.vv v8, v8, v12
; CHECK-NEXT:    vsrl.vi v12, v8, 4
; CHECK-NEXT:    vor.vv v8, v8, v12
; CHECK-NEXT:    vxor.vi v8, v8, -1
; CHECK-NEXT:    vsrl.vi v12, v8, 1
; CHECK-NEXT:    li a0, 85
; CHECK-NEXT:    vand.vx v12, v12, a0
; CHECK-NEXT:    vsub.vv v8, v8, v12
; CHECK-NEXT:    li a0, 51
; CHECK-NEXT:    vand.vx v12, v8, a0
; CHECK-NEXT:    vsrl.vi v8, v8, 2
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vadd.vv v8, v12, v8
; CHECK-NEXT:    vsrl.vi v12, v8, 4
; CHECK-NEXT:    vadd.vv v8, v8, v12
; CHECK-NEXT:    vand.vi v8, v8, 15
; CHECK-NEXT:    ret
  %a = call <vscale x 32 x i8> @llvm.ctlz.nxv32i8(<vscale x 32 x i8> %va, i1 true)
  ret <vscale x 32 x i8> %a
}

define <vscale x 64 x i8> @ctlz_zero_undef_nxv64i8(<vscale x 64 x i8> %va) {
; CHECK-LABEL: ctlz_zero_undef_nxv64i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m8, ta, mu
; CHECK-NEXT:    vsrl.vi v16, v8, 1
; CHECK-NEXT:    vor.vv v8, v8, v16
; CHECK-NEXT:    vsrl.vi v16, v8, 2
; CHECK-NEXT:    vor.vv v8, v8, v16
; CHECK-NEXT:    vsrl.vi v16, v8, 4
; CHECK-NEXT:    vor.vv v8, v8, v16
; CHECK-NEXT:    vxor.vi v8, v8, -1
; CHECK-NEXT:    vsrl.vi v16, v8, 1
; CHECK-NEXT:    li a0, 85
; CHECK-NEXT:    vand.vx v16, v16, a0
; CHECK-NEXT:    vsub.vv v8, v8, v16
; CHECK-NEXT:    li a0, 51
; CHECK-NEXT:    vand.vx v16, v8, a0
; CHECK-NEXT:    vsrl.vi v8, v8, 2
; CHECK-NEXT:    vand.vx v8, v8, a0
; CHECK-NEXT:    vadd.vv v8, v16, v8
; CHECK-NEXT:    vsrl.vi v16, v8, 4
; CHECK-NEXT:    vadd.vv v8, v8, v16
; CHECK-NEXT:    vand.vi v8, v8, 15
; CHECK-NEXT:    ret
  %a = call <vscale x 64 x i8> @llvm.ctlz.nxv64i8(<vscale x 64 x i8> %va, i1 true)
  ret <vscale x 64 x i8> %a
}

define <vscale x 1 x i16> @ctlz_zero_undef_nxv1i16(<vscale x 1 x i16> %va) {
; RV32I-LABEL: ctlz_zero_undef_nxv1i16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    vsetvli a0, zero, e16, mf4, ta, mu
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 2
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 8
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vxor.vi v8, v8, -1
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    lui a0, 5
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vand.vx v9, v9, a0
; RV32I-NEXT:    vsub.vv v8, v8, v9
; RV32I-NEXT:    lui a0, 3
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vand.vx v9, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v9, v8
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v9
; RV32I-NEXT:    lui a0, 1
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    li a0, 257
; RV32I-NEXT:    vmul.vx v8, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 8
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ctlz_zero_undef_nxv1i16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    vsetvli a0, zero, e16, mf4, ta, mu
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 2
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 8
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vxor.vi v8, v8, -1
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    lui a0, 5
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    vand.vx v9, v9, a0
; RV64I-NEXT:    vsub.vv v8, v8, v9
; RV64I-NEXT:    lui a0, 3
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    vand.vx v9, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v9, v8
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v9
; RV64I-NEXT:    lui a0, 1
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    li a0, 257
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 8
; RV64I-NEXT:    ret
;
; RV32D-LABEL: ctlz_zero_undef_nxv1i16:
; RV32D:       # %bb.0:
; RV32D-NEXT:    vsetvli a0, zero, e16, mf4, ta, mu
; RV32D-NEXT:    vfwcvt.f.xu.v v9, v8
; RV32D-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; RV32D-NEXT:    vsrl.vi v8, v9, 23
; RV32D-NEXT:    vsetvli zero, zero, e16, mf4, ta, mu
; RV32D-NEXT:    vnsrl.wx v8, v8, zero
; RV32D-NEXT:    li a0, 142
; RV32D-NEXT:    vrsub.vx v8, v8, a0
; RV32D-NEXT:    ret
;
; RV64D-LABEL: ctlz_zero_undef_nxv1i16:
; RV64D:       # %bb.0:
; RV64D-NEXT:    vsetvli a0, zero, e16, mf4, ta, mu
; RV64D-NEXT:    vfwcvt.f.xu.v v9, v8
; RV64D-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; RV64D-NEXT:    vsrl.vi v8, v9, 23
; RV64D-NEXT:    vsetvli zero, zero, e16, mf4, ta, mu
; RV64D-NEXT:    vnsrl.wx v8, v8, zero
; RV64D-NEXT:    li a0, 142
; RV64D-NEXT:    vrsub.vx v8, v8, a0
; RV64D-NEXT:    ret
  %a = call <vscale x 1 x i16> @llvm.ctlz.nxv1i16(<vscale x 1 x i16> %va, i1 true)
  ret <vscale x 1 x i16> %a
}

define <vscale x 2 x i16> @ctlz_zero_undef_nxv2i16(<vscale x 2 x i16> %va) {
; RV32I-LABEL: ctlz_zero_undef_nxv2i16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    vsetvli a0, zero, e16, mf2, ta, mu
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 2
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 8
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vxor.vi v8, v8, -1
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    lui a0, 5
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vand.vx v9, v9, a0
; RV32I-NEXT:    vsub.vv v8, v8, v9
; RV32I-NEXT:    lui a0, 3
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vand.vx v9, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v9, v8
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v9
; RV32I-NEXT:    lui a0, 1
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    li a0, 257
; RV32I-NEXT:    vmul.vx v8, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 8
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ctlz_zero_undef_nxv2i16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    vsetvli a0, zero, e16, mf2, ta, mu
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 2
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 8
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vxor.vi v8, v8, -1
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    lui a0, 5
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    vand.vx v9, v9, a0
; RV64I-NEXT:    vsub.vv v8, v8, v9
; RV64I-NEXT:    lui a0, 3
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    vand.vx v9, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v9, v8
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v9
; RV64I-NEXT:    lui a0, 1
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    li a0, 257
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 8
; RV64I-NEXT:    ret
;
; RV32D-LABEL: ctlz_zero_undef_nxv2i16:
; RV32D:       # %bb.0:
; RV32D-NEXT:    vsetvli a0, zero, e16, mf2, ta, mu
; RV32D-NEXT:    vfwcvt.f.xu.v v9, v8
; RV32D-NEXT:    vsetvli zero, zero, e32, m1, ta, mu
; RV32D-NEXT:    vsrl.vi v8, v9, 23
; RV32D-NEXT:    vsetvli zero, zero, e16, mf2, ta, mu
; RV32D-NEXT:    vnsrl.wx v8, v8, zero
; RV32D-NEXT:    li a0, 142
; RV32D-NEXT:    vrsub.vx v8, v8, a0
; RV32D-NEXT:    ret
;
; RV64D-LABEL: ctlz_zero_undef_nxv2i16:
; RV64D:       # %bb.0:
; RV64D-NEXT:    vsetvli a0, zero, e16, mf2, ta, mu
; RV64D-NEXT:    vfwcvt.f.xu.v v9, v8
; RV64D-NEXT:    vsetvli zero, zero, e32, m1, ta, mu
; RV64D-NEXT:    vsrl.vi v8, v9, 23
; RV64D-NEXT:    vsetvli zero, zero, e16, mf2, ta, mu
; RV64D-NEXT:    vnsrl.wx v8, v8, zero
; RV64D-NEXT:    li a0, 142
; RV64D-NEXT:    vrsub.vx v8, v8, a0
; RV64D-NEXT:    ret
  %a = call <vscale x 2 x i16> @llvm.ctlz.nxv2i16(<vscale x 2 x i16> %va, i1 true)
  ret <vscale x 2 x i16> %a
}

define <vscale x 4 x i16> @ctlz_zero_undef_nxv4i16(<vscale x 4 x i16> %va) {
; RV32I-LABEL: ctlz_zero_undef_nxv4i16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    vsetvli a0, zero, e16, m1, ta, mu
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 2
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 8
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vxor.vi v8, v8, -1
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    lui a0, 5
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vand.vx v9, v9, a0
; RV32I-NEXT:    vsub.vv v8, v8, v9
; RV32I-NEXT:    lui a0, 3
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vand.vx v9, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v9, v8
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v9
; RV32I-NEXT:    lui a0, 1
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    li a0, 257
; RV32I-NEXT:    vmul.vx v8, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 8
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ctlz_zero_undef_nxv4i16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    vsetvli a0, zero, e16, m1, ta, mu
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 2
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 8
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vxor.vi v8, v8, -1
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    lui a0, 5
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    vand.vx v9, v9, a0
; RV64I-NEXT:    vsub.vv v8, v8, v9
; RV64I-NEXT:    lui a0, 3
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    vand.vx v9, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v9, v8
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v9
; RV64I-NEXT:    lui a0, 1
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    li a0, 257
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 8
; RV64I-NEXT:    ret
;
; RV32D-LABEL: ctlz_zero_undef_nxv4i16:
; RV32D:       # %bb.0:
; RV32D-NEXT:    vsetvli a0, zero, e16, m1, ta, mu
; RV32D-NEXT:    vfwcvt.f.xu.v v10, v8
; RV32D-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; RV32D-NEXT:    vsrl.vi v8, v10, 23
; RV32D-NEXT:    vsetvli zero, zero, e16, m1, ta, mu
; RV32D-NEXT:    vnsrl.wx v10, v8, zero
; RV32D-NEXT:    li a0, 142
; RV32D-NEXT:    vrsub.vx v8, v10, a0
; RV32D-NEXT:    ret
;
; RV64D-LABEL: ctlz_zero_undef_nxv4i16:
; RV64D:       # %bb.0:
; RV64D-NEXT:    vsetvli a0, zero, e16, m1, ta, mu
; RV64D-NEXT:    vfwcvt.f.xu.v v10, v8
; RV64D-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; RV64D-NEXT:    vsrl.vi v8, v10, 23
; RV64D-NEXT:    vsetvli zero, zero, e16, m1, ta, mu
; RV64D-NEXT:    vnsrl.wx v10, v8, zero
; RV64D-NEXT:    li a0, 142
; RV64D-NEXT:    vrsub.vx v8, v10, a0
; RV64D-NEXT:    ret
  %a = call <vscale x 4 x i16> @llvm.ctlz.nxv4i16(<vscale x 4 x i16> %va, i1 true)
  ret <vscale x 4 x i16> %a
}

define <vscale x 8 x i16> @ctlz_zero_undef_nxv8i16(<vscale x 8 x i16> %va) {
; RV32I-LABEL: ctlz_zero_undef_nxv8i16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    vsetvli a0, zero, e16, m2, ta, mu
; RV32I-NEXT:    vsrl.vi v10, v8, 1
; RV32I-NEXT:    vor.vv v8, v8, v10
; RV32I-NEXT:    vsrl.vi v10, v8, 2
; RV32I-NEXT:    vor.vv v8, v8, v10
; RV32I-NEXT:    vsrl.vi v10, v8, 4
; RV32I-NEXT:    vor.vv v8, v8, v10
; RV32I-NEXT:    vsrl.vi v10, v8, 8
; RV32I-NEXT:    vor.vv v8, v8, v10
; RV32I-NEXT:    vxor.vi v8, v8, -1
; RV32I-NEXT:    vsrl.vi v10, v8, 1
; RV32I-NEXT:    lui a0, 5
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vand.vx v10, v10, a0
; RV32I-NEXT:    vsub.vv v8, v8, v10
; RV32I-NEXT:    lui a0, 3
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vand.vx v10, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v10, v8
; RV32I-NEXT:    vsrl.vi v10, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v10
; RV32I-NEXT:    lui a0, 1
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    li a0, 257
; RV32I-NEXT:    vmul.vx v8, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 8
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ctlz_zero_undef_nxv8i16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    vsetvli a0, zero, e16, m2, ta, mu
; RV64I-NEXT:    vsrl.vi v10, v8, 1
; RV64I-NEXT:    vor.vv v8, v8, v10
; RV64I-NEXT:    vsrl.vi v10, v8, 2
; RV64I-NEXT:    vor.vv v8, v8, v10
; RV64I-NEXT:    vsrl.vi v10, v8, 4
; RV64I-NEXT:    vor.vv v8, v8, v10
; RV64I-NEXT:    vsrl.vi v10, v8, 8
; RV64I-NEXT:    vor.vv v8, v8, v10
; RV64I-NEXT:    vxor.vi v8, v8, -1
; RV64I-NEXT:    vsrl.vi v10, v8, 1
; RV64I-NEXT:    lui a0, 5
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    vand.vx v10, v10, a0
; RV64I-NEXT:    vsub.vv v8, v8, v10
; RV64I-NEXT:    lui a0, 3
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    vand.vx v10, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v10, v8
; RV64I-NEXT:    vsrl.vi v10, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v10
; RV64I-NEXT:    lui a0, 1
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    li a0, 257
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 8
; RV64I-NEXT:    ret
;
; RV32D-LABEL: ctlz_zero_undef_nxv8i16:
; RV32D:       # %bb.0:
; RV32D-NEXT:    vsetvli a0, zero, e16, m2, ta, mu
; RV32D-NEXT:    vfwcvt.f.xu.v v12, v8
; RV32D-NEXT:    vsetvli zero, zero, e32, m4, ta, mu
; RV32D-NEXT:    vsrl.vi v8, v12, 23
; RV32D-NEXT:    vsetvli zero, zero, e16, m2, ta, mu
; RV32D-NEXT:    vnsrl.wx v12, v8, zero
; RV32D-NEXT:    li a0, 142
; RV32D-NEXT:    vrsub.vx v8, v12, a0
; RV32D-NEXT:    ret
;
; RV64D-LABEL: ctlz_zero_undef_nxv8i16:
; RV64D:       # %bb.0:
; RV64D-NEXT:    vsetvli a0, zero, e16, m2, ta, mu
; RV64D-NEXT:    vfwcvt.f.xu.v v12, v8
; RV64D-NEXT:    vsetvli zero, zero, e32, m4, ta, mu
; RV64D-NEXT:    vsrl.vi v8, v12, 23
; RV64D-NEXT:    vsetvli zero, zero, e16, m2, ta, mu
; RV64D-NEXT:    vnsrl.wx v12, v8, zero
; RV64D-NEXT:    li a0, 142
; RV64D-NEXT:    vrsub.vx v8, v12, a0
; RV64D-NEXT:    ret
  %a = call <vscale x 8 x i16> @llvm.ctlz.nxv8i16(<vscale x 8 x i16> %va, i1 true)
  ret <vscale x 8 x i16> %a
}

define <vscale x 16 x i16> @ctlz_zero_undef_nxv16i16(<vscale x 16 x i16> %va) {
; RV32I-LABEL: ctlz_zero_undef_nxv16i16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    vsetvli a0, zero, e16, m4, ta, mu
; RV32I-NEXT:    vsrl.vi v12, v8, 1
; RV32I-NEXT:    vor.vv v8, v8, v12
; RV32I-NEXT:    vsrl.vi v12, v8, 2
; RV32I-NEXT:    vor.vv v8, v8, v12
; RV32I-NEXT:    vsrl.vi v12, v8, 4
; RV32I-NEXT:    vor.vv v8, v8, v12
; RV32I-NEXT:    vsrl.vi v12, v8, 8
; RV32I-NEXT:    vor.vv v8, v8, v12
; RV32I-NEXT:    vxor.vi v8, v8, -1
; RV32I-NEXT:    vsrl.vi v12, v8, 1
; RV32I-NEXT:    lui a0, 5
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vand.vx v12, v12, a0
; RV32I-NEXT:    vsub.vv v8, v8, v12
; RV32I-NEXT:    lui a0, 3
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vand.vx v12, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v12, v8
; RV32I-NEXT:    vsrl.vi v12, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v12
; RV32I-NEXT:    lui a0, 1
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    li a0, 257
; RV32I-NEXT:    vmul.vx v8, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 8
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ctlz_zero_undef_nxv16i16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    vsetvli a0, zero, e16, m4, ta, mu
; RV64I-NEXT:    vsrl.vi v12, v8, 1
; RV64I-NEXT:    vor.vv v8, v8, v12
; RV64I-NEXT:    vsrl.vi v12, v8, 2
; RV64I-NEXT:    vor.vv v8, v8, v12
; RV64I-NEXT:    vsrl.vi v12, v8, 4
; RV64I-NEXT:    vor.vv v8, v8, v12
; RV64I-NEXT:    vsrl.vi v12, v8, 8
; RV64I-NEXT:    vor.vv v8, v8, v12
; RV64I-NEXT:    vxor.vi v8, v8, -1
; RV64I-NEXT:    vsrl.vi v12, v8, 1
; RV64I-NEXT:    lui a0, 5
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    vand.vx v12, v12, a0
; RV64I-NEXT:    vsub.vv v8, v8, v12
; RV64I-NEXT:    lui a0, 3
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    vand.vx v12, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v12, v8
; RV64I-NEXT:    vsrl.vi v12, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v12
; RV64I-NEXT:    lui a0, 1
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    li a0, 257
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 8
; RV64I-NEXT:    ret
;
; RV32D-LABEL: ctlz_zero_undef_nxv16i16:
; RV32D:       # %bb.0:
; RV32D-NEXT:    vsetvli a0, zero, e16, m4, ta, mu
; RV32D-NEXT:    vfwcvt.f.xu.v v16, v8
; RV32D-NEXT:    vsetvli zero, zero, e32, m8, ta, mu
; RV32D-NEXT:    vsrl.vi v8, v16, 23
; RV32D-NEXT:    vsetvli zero, zero, e16, m4, ta, mu
; RV32D-NEXT:    vnsrl.wx v16, v8, zero
; RV32D-NEXT:    li a0, 142
; RV32D-NEXT:    vrsub.vx v8, v16, a0
; RV32D-NEXT:    ret
;
; RV64D-LABEL: ctlz_zero_undef_nxv16i16:
; RV64D:       # %bb.0:
; RV64D-NEXT:    vsetvli a0, zero, e16, m4, ta, mu
; RV64D-NEXT:    vfwcvt.f.xu.v v16, v8
; RV64D-NEXT:    vsetvli zero, zero, e32, m8, ta, mu
; RV64D-NEXT:    vsrl.vi v8, v16, 23
; RV64D-NEXT:    vsetvli zero, zero, e16, m4, ta, mu
; RV64D-NEXT:    vnsrl.wx v16, v8, zero
; RV64D-NEXT:    li a0, 142
; RV64D-NEXT:    vrsub.vx v8, v16, a0
; RV64D-NEXT:    ret
  %a = call <vscale x 16 x i16> @llvm.ctlz.nxv16i16(<vscale x 16 x i16> %va, i1 true)
  ret <vscale x 16 x i16> %a
}

define <vscale x 32 x i16> @ctlz_zero_undef_nxv32i16(<vscale x 32 x i16> %va) {
; RV32-LABEL: ctlz_zero_undef_nxv32i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e16, m8, ta, mu
; RV32-NEXT:    vsrl.vi v16, v8, 1
; RV32-NEXT:    vor.vv v8, v8, v16
; RV32-NEXT:    vsrl.vi v16, v8, 2
; RV32-NEXT:    vor.vv v8, v8, v16
; RV32-NEXT:    vsrl.vi v16, v8, 4
; RV32-NEXT:    vor.vv v8, v8, v16
; RV32-NEXT:    vsrl.vi v16, v8, 8
; RV32-NEXT:    vor.vv v8, v8, v16
; RV32-NEXT:    vxor.vi v8, v8, -1
; RV32-NEXT:    vsrl.vi v16, v8, 1
; RV32-NEXT:    lui a0, 5
; RV32-NEXT:    addi a0, a0, 1365
; RV32-NEXT:    vand.vx v16, v16, a0
; RV32-NEXT:    vsub.vv v8, v8, v16
; RV32-NEXT:    lui a0, 3
; RV32-NEXT:    addi a0, a0, 819
; RV32-NEXT:    vand.vx v16, v8, a0
; RV32-NEXT:    vsrl.vi v8, v8, 2
; RV32-NEXT:    vand.vx v8, v8, a0
; RV32-NEXT:    vadd.vv v8, v16, v8
; RV32-NEXT:    vsrl.vi v16, v8, 4
; RV32-NEXT:    vadd.vv v8, v8, v16
; RV32-NEXT:    lui a0, 1
; RV32-NEXT:    addi a0, a0, -241
; RV32-NEXT:    vand.vx v8, v8, a0
; RV32-NEXT:    li a0, 257
; RV32-NEXT:    vmul.vx v8, v8, a0
; RV32-NEXT:    vsrl.vi v8, v8, 8
; RV32-NEXT:    ret
;
; RV64-LABEL: ctlz_zero_undef_nxv32i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e16, m8, ta, mu
; RV64-NEXT:    vsrl.vi v16, v8, 1
; RV64-NEXT:    vor.vv v8, v8, v16
; RV64-NEXT:    vsrl.vi v16, v8, 2
; RV64-NEXT:    vor.vv v8, v8, v16
; RV64-NEXT:    vsrl.vi v16, v8, 4
; RV64-NEXT:    vor.vv v8, v8, v16
; RV64-NEXT:    vsrl.vi v16, v8, 8
; RV64-NEXT:    vor.vv v8, v8, v16
; RV64-NEXT:    vxor.vi v8, v8, -1
; RV64-NEXT:    vsrl.vi v16, v8, 1
; RV64-NEXT:    lui a0, 5
; RV64-NEXT:    addiw a0, a0, 1365
; RV64-NEXT:    vand.vx v16, v16, a0
; RV64-NEXT:    vsub.vv v8, v8, v16
; RV64-NEXT:    lui a0, 3
; RV64-NEXT:    addiw a0, a0, 819
; RV64-NEXT:    vand.vx v16, v8, a0
; RV64-NEXT:    vsrl.vi v8, v8, 2
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vadd.vv v8, v16, v8
; RV64-NEXT:    vsrl.vi v16, v8, 4
; RV64-NEXT:    vadd.vv v8, v8, v16
; RV64-NEXT:    lui a0, 1
; RV64-NEXT:    addiw a0, a0, -241
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    li a0, 257
; RV64-NEXT:    vmul.vx v8, v8, a0
; RV64-NEXT:    vsrl.vi v8, v8, 8
; RV64-NEXT:    ret
  %a = call <vscale x 32 x i16> @llvm.ctlz.nxv32i16(<vscale x 32 x i16> %va, i1 true)
  ret <vscale x 32 x i16> %a
}

define <vscale x 1 x i32> @ctlz_zero_undef_nxv1i32(<vscale x 1 x i32> %va) {
; RV32I-LABEL: ctlz_zero_undef_nxv1i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    vsetvli a0, zero, e32, mf2, ta, mu
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 2
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 8
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 16
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vxor.vi v8, v8, -1
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    lui a0, 349525
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vand.vx v9, v9, a0
; RV32I-NEXT:    vsub.vv v8, v8, v9
; RV32I-NEXT:    lui a0, 209715
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vand.vx v9, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v9, v8
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v9
; RV32I-NEXT:    lui a0, 61681
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    lui a0, 4112
; RV32I-NEXT:    addi a0, a0, 257
; RV32I-NEXT:    vmul.vx v8, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 24
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ctlz_zero_undef_nxv1i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    vsetvli a0, zero, e32, mf2, ta, mu
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 2
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 8
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 16
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vxor.vi v8, v8, -1
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    lui a0, 349525
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    vand.vx v9, v9, a0
; RV64I-NEXT:    vsub.vv v8, v8, v9
; RV64I-NEXT:    lui a0, 209715
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    vand.vx v9, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v9, v8
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v9
; RV64I-NEXT:    lui a0, 61681
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    lui a0, 4112
; RV64I-NEXT:    addiw a0, a0, 257
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 24
; RV64I-NEXT:    ret
;
; RV32D-LABEL: ctlz_zero_undef_nxv1i32:
; RV32D:       # %bb.0:
; RV32D-NEXT:    vsetvli a0, zero, e32, mf2, ta, mu
; RV32D-NEXT:    vfwcvt.f.xu.v v9, v8
; RV32D-NEXT:    li a0, 52
; RV32D-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; RV32D-NEXT:    vsrl.vx v8, v9, a0
; RV32D-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; RV32D-NEXT:    vnsrl.wx v8, v8, zero
; RV32D-NEXT:    li a0, 1054
; RV32D-NEXT:    vrsub.vx v8, v8, a0
; RV32D-NEXT:    ret
;
; RV64D-LABEL: ctlz_zero_undef_nxv1i32:
; RV64D:       # %bb.0:
; RV64D-NEXT:    vsetvli a0, zero, e32, mf2, ta, mu
; RV64D-NEXT:    vfwcvt.f.xu.v v9, v8
; RV64D-NEXT:    li a0, 52
; RV64D-NEXT:    vsetvli zero, zero, e64, m1, ta, mu
; RV64D-NEXT:    vsrl.vx v8, v9, a0
; RV64D-NEXT:    vsetvli zero, zero, e32, mf2, ta, mu
; RV64D-NEXT:    vnsrl.wx v8, v8, zero
; RV64D-NEXT:    li a0, 1054
; RV64D-NEXT:    vrsub.vx v8, v8, a0
; RV64D-NEXT:    ret
  %a = call <vscale x 1 x i32> @llvm.ctlz.nxv1i32(<vscale x 1 x i32> %va, i1 true)
  ret <vscale x 1 x i32> %a
}

define <vscale x 2 x i32> @ctlz_zero_undef_nxv2i32(<vscale x 2 x i32> %va) {
; RV32I-LABEL: ctlz_zero_undef_nxv2i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 2
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 8
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vsrl.vi v9, v8, 16
; RV32I-NEXT:    vor.vv v8, v8, v9
; RV32I-NEXT:    vxor.vi v8, v8, -1
; RV32I-NEXT:    vsrl.vi v9, v8, 1
; RV32I-NEXT:    lui a0, 349525
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vand.vx v9, v9, a0
; RV32I-NEXT:    vsub.vv v8, v8, v9
; RV32I-NEXT:    lui a0, 209715
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vand.vx v9, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v9, v8
; RV32I-NEXT:    vsrl.vi v9, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v9
; RV32I-NEXT:    lui a0, 61681
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    lui a0, 4112
; RV32I-NEXT:    addi a0, a0, 257
; RV32I-NEXT:    vmul.vx v8, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 24
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ctlz_zero_undef_nxv2i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 2
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 8
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vsrl.vi v9, v8, 16
; RV64I-NEXT:    vor.vv v8, v8, v9
; RV64I-NEXT:    vxor.vi v8, v8, -1
; RV64I-NEXT:    vsrl.vi v9, v8, 1
; RV64I-NEXT:    lui a0, 349525
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    vand.vx v9, v9, a0
; RV64I-NEXT:    vsub.vv v8, v8, v9
; RV64I-NEXT:    lui a0, 209715
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    vand.vx v9, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v9, v8
; RV64I-NEXT:    vsrl.vi v9, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v9
; RV64I-NEXT:    lui a0, 61681
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    lui a0, 4112
; RV64I-NEXT:    addiw a0, a0, 257
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 24
; RV64I-NEXT:    ret
;
; RV32D-LABEL: ctlz_zero_undef_nxv2i32:
; RV32D:       # %bb.0:
; RV32D-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; RV32D-NEXT:    vfwcvt.f.xu.v v10, v8
; RV32D-NEXT:    li a0, 52
; RV32D-NEXT:    vsetvli zero, zero, e64, m2, ta, mu
; RV32D-NEXT:    vsrl.vx v8, v10, a0
; RV32D-NEXT:    vsetvli zero, zero, e32, m1, ta, mu
; RV32D-NEXT:    vnsrl.wx v10, v8, zero
; RV32D-NEXT:    li a0, 1054
; RV32D-NEXT:    vrsub.vx v8, v10, a0
; RV32D-NEXT:    ret
;
; RV64D-LABEL: ctlz_zero_undef_nxv2i32:
; RV64D:       # %bb.0:
; RV64D-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; RV64D-NEXT:    vfwcvt.f.xu.v v10, v8
; RV64D-NEXT:    li a0, 52
; RV64D-NEXT:    vsetvli zero, zero, e64, m2, ta, mu
; RV64D-NEXT:    vsrl.vx v8, v10, a0
; RV64D-NEXT:    vsetvli zero, zero, e32, m1, ta, mu
; RV64D-NEXT:    vnsrl.wx v10, v8, zero
; RV64D-NEXT:    li a0, 1054
; RV64D-NEXT:    vrsub.vx v8, v10, a0
; RV64D-NEXT:    ret
  %a = call <vscale x 2 x i32> @llvm.ctlz.nxv2i32(<vscale x 2 x i32> %va, i1 true)
  ret <vscale x 2 x i32> %a
}

define <vscale x 4 x i32> @ctlz_zero_undef_nxv4i32(<vscale x 4 x i32> %va) {
; RV32I-LABEL: ctlz_zero_undef_nxv4i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    vsetvli a0, zero, e32, m2, ta, mu
; RV32I-NEXT:    vsrl.vi v10, v8, 1
; RV32I-NEXT:    vor.vv v8, v8, v10
; RV32I-NEXT:    vsrl.vi v10, v8, 2
; RV32I-NEXT:    vor.vv v8, v8, v10
; RV32I-NEXT:    vsrl.vi v10, v8, 4
; RV32I-NEXT:    vor.vv v8, v8, v10
; RV32I-NEXT:    vsrl.vi v10, v8, 8
; RV32I-NEXT:    vor.vv v8, v8, v10
; RV32I-NEXT:    vsrl.vi v10, v8, 16
; RV32I-NEXT:    vor.vv v8, v8, v10
; RV32I-NEXT:    vxor.vi v8, v8, -1
; RV32I-NEXT:    vsrl.vi v10, v8, 1
; RV32I-NEXT:    lui a0, 349525
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vand.vx v10, v10, a0
; RV32I-NEXT:    vsub.vv v8, v8, v10
; RV32I-NEXT:    lui a0, 209715
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vand.vx v10, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v10, v8
; RV32I-NEXT:    vsrl.vi v10, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v10
; RV32I-NEXT:    lui a0, 61681
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    lui a0, 4112
; RV32I-NEXT:    addi a0, a0, 257
; RV32I-NEXT:    vmul.vx v8, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 24
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ctlz_zero_undef_nxv4i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    vsetvli a0, zero, e32, m2, ta, mu
; RV64I-NEXT:    vsrl.vi v10, v8, 1
; RV64I-NEXT:    vor.vv v8, v8, v10
; RV64I-NEXT:    vsrl.vi v10, v8, 2
; RV64I-NEXT:    vor.vv v8, v8, v10
; RV64I-NEXT:    vsrl.vi v10, v8, 4
; RV64I-NEXT:    vor.vv v8, v8, v10
; RV64I-NEXT:    vsrl.vi v10, v8, 8
; RV64I-NEXT:    vor.vv v8, v8, v10
; RV64I-NEXT:    vsrl.vi v10, v8, 16
; RV64I-NEXT:    vor.vv v8, v8, v10
; RV64I-NEXT:    vxor.vi v8, v8, -1
; RV64I-NEXT:    vsrl.vi v10, v8, 1
; RV64I-NEXT:    lui a0, 349525
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    vand.vx v10, v10, a0
; RV64I-NEXT:    vsub.vv v8, v8, v10
; RV64I-NEXT:    lui a0, 209715
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    vand.vx v10, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v10, v8
; RV64I-NEXT:    vsrl.vi v10, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v10
; RV64I-NEXT:    lui a0, 61681
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    lui a0, 4112
; RV64I-NEXT:    addiw a0, a0, 257
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 24
; RV64I-NEXT:    ret
;
; RV32D-LABEL: ctlz_zero_undef_nxv4i32:
; RV32D:       # %bb.0:
; RV32D-NEXT:    vsetvli a0, zero, e32, m2, ta, mu
; RV32D-NEXT:    vfwcvt.f.xu.v v12, v8
; RV32D-NEXT:    li a0, 52
; RV32D-NEXT:    vsetvli zero, zero, e64, m4, ta, mu
; RV32D-NEXT:    vsrl.vx v8, v12, a0
; RV32D-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; RV32D-NEXT:    vnsrl.wx v12, v8, zero
; RV32D-NEXT:    li a0, 1054
; RV32D-NEXT:    vrsub.vx v8, v12, a0
; RV32D-NEXT:    ret
;
; RV64D-LABEL: ctlz_zero_undef_nxv4i32:
; RV64D:       # %bb.0:
; RV64D-NEXT:    vsetvli a0, zero, e32, m2, ta, mu
; RV64D-NEXT:    vfwcvt.f.xu.v v12, v8
; RV64D-NEXT:    li a0, 52
; RV64D-NEXT:    vsetvli zero, zero, e64, m4, ta, mu
; RV64D-NEXT:    vsrl.vx v8, v12, a0
; RV64D-NEXT:    vsetvli zero, zero, e32, m2, ta, mu
; RV64D-NEXT:    vnsrl.wx v12, v8, zero
; RV64D-NEXT:    li a0, 1054
; RV64D-NEXT:    vrsub.vx v8, v12, a0
; RV64D-NEXT:    ret
  %a = call <vscale x 4 x i32> @llvm.ctlz.nxv4i32(<vscale x 4 x i32> %va, i1 true)
  ret <vscale x 4 x i32> %a
}

define <vscale x 8 x i32> @ctlz_zero_undef_nxv8i32(<vscale x 8 x i32> %va) {
; RV32I-LABEL: ctlz_zero_undef_nxv8i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    vsetvli a0, zero, e32, m4, ta, mu
; RV32I-NEXT:    vsrl.vi v12, v8, 1
; RV32I-NEXT:    vor.vv v8, v8, v12
; RV32I-NEXT:    vsrl.vi v12, v8, 2
; RV32I-NEXT:    vor.vv v8, v8, v12
; RV32I-NEXT:    vsrl.vi v12, v8, 4
; RV32I-NEXT:    vor.vv v8, v8, v12
; RV32I-NEXT:    vsrl.vi v12, v8, 8
; RV32I-NEXT:    vor.vv v8, v8, v12
; RV32I-NEXT:    vsrl.vi v12, v8, 16
; RV32I-NEXT:    vor.vv v8, v8, v12
; RV32I-NEXT:    vxor.vi v8, v8, -1
; RV32I-NEXT:    vsrl.vi v12, v8, 1
; RV32I-NEXT:    lui a0, 349525
; RV32I-NEXT:    addi a0, a0, 1365
; RV32I-NEXT:    vand.vx v12, v12, a0
; RV32I-NEXT:    vsub.vv v8, v8, v12
; RV32I-NEXT:    lui a0, 209715
; RV32I-NEXT:    addi a0, a0, 819
; RV32I-NEXT:    vand.vx v12, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 2
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    vadd.vv v8, v12, v8
; RV32I-NEXT:    vsrl.vi v12, v8, 4
; RV32I-NEXT:    vadd.vv v8, v8, v12
; RV32I-NEXT:    lui a0, 61681
; RV32I-NEXT:    addi a0, a0, -241
; RV32I-NEXT:    vand.vx v8, v8, a0
; RV32I-NEXT:    lui a0, 4112
; RV32I-NEXT:    addi a0, a0, 257
; RV32I-NEXT:    vmul.vx v8, v8, a0
; RV32I-NEXT:    vsrl.vi v8, v8, 24
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ctlz_zero_undef_nxv8i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    vsetvli a0, zero, e32, m4, ta, mu
; RV64I-NEXT:    vsrl.vi v12, v8, 1
; RV64I-NEXT:    vor.vv v8, v8, v12
; RV64I-NEXT:    vsrl.vi v12, v8, 2
; RV64I-NEXT:    vor.vv v8, v8, v12
; RV64I-NEXT:    vsrl.vi v12, v8, 4
; RV64I-NEXT:    vor.vv v8, v8, v12
; RV64I-NEXT:    vsrl.vi v12, v8, 8
; RV64I-NEXT:    vor.vv v8, v8, v12
; RV64I-NEXT:    vsrl.vi v12, v8, 16
; RV64I-NEXT:    vor.vv v8, v8, v12
; RV64I-NEXT:    vxor.vi v8, v8, -1
; RV64I-NEXT:    vsrl.vi v12, v8, 1
; RV64I-NEXT:    lui a0, 349525
; RV64I-NEXT:    addiw a0, a0, 1365
; RV64I-NEXT:    vand.vx v12, v12, a0
; RV64I-NEXT:    vsub.vv v8, v8, v12
; RV64I-NEXT:    lui a0, 209715
; RV64I-NEXT:    addiw a0, a0, 819
; RV64I-NEXT:    vand.vx v12, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 2
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    vadd.vv v8, v12, v8
; RV64I-NEXT:    vsrl.vi v12, v8, 4
; RV64I-NEXT:    vadd.vv v8, v8, v12
; RV64I-NEXT:    lui a0, 61681
; RV64I-NEXT:    addiw a0, a0, -241
; RV64I-NEXT:    vand.vx v8, v8, a0
; RV64I-NEXT:    lui a0, 4112
; RV64I-NEXT:    addiw a0, a0, 257
; RV64I-NEXT:    vmul.vx v8, v8, a0
; RV64I-NEXT:    vsrl.vi v8, v8, 24
; RV64I-NEXT:    ret
;
; RV32D-LABEL: ctlz_zero_undef_nxv8i32:
; RV32D:       # %bb.0:
; RV32D-NEXT:    vsetvli a0, zero, e32, m4, ta, mu
; RV32D-NEXT:    vfwcvt.f.xu.v v16, v8
; RV32D-NEXT:    li a0, 52
; RV32D-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; RV32D-NEXT:    vsrl.vx v8, v16, a0
; RV32D-NEXT:    vsetvli zero, zero, e32, m4, ta, mu
; RV32D-NEXT:    vnsrl.wx v16, v8, zero
; RV32D-NEXT:    li a0, 1054
; RV32D-NEXT:    vrsub.vx v8, v16, a0
; RV32D-NEXT:    ret
;
; RV64D-LABEL: ctlz_zero_undef_nxv8i32:
; RV64D:       # %bb.0:
; RV64D-NEXT:    vsetvli a0, zero, e32, m4, ta, mu
; RV64D-NEXT:    vfwcvt.f.xu.v v16, v8
; RV64D-NEXT:    li a0, 52
; RV64D-NEXT:    vsetvli zero, zero, e64, m8, ta, mu
; RV64D-NEXT:    vsrl.vx v8, v16, a0
; RV64D-NEXT:    vsetvli zero, zero, e32, m4, ta, mu
; RV64D-NEXT:    vnsrl.wx v16, v8, zero
; RV64D-NEXT:    li a0, 1054
; RV64D-NEXT:    vrsub.vx v8, v16, a0
; RV64D-NEXT:    ret
  %a = call <vscale x 8 x i32> @llvm.ctlz.nxv8i32(<vscale x 8 x i32> %va, i1 true)
  ret <vscale x 8 x i32> %a
}

define <vscale x 16 x i32> @ctlz_zero_undef_nxv16i32(<vscale x 16 x i32> %va) {
; RV32-LABEL: ctlz_zero_undef_nxv16i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli a0, zero, e32, m8, ta, mu
; RV32-NEXT:    vsrl.vi v16, v8, 1
; RV32-NEXT:    vor.vv v8, v8, v16
; RV32-NEXT:    vsrl.vi v16, v8, 2
; RV32-NEXT:    vor.vv v8, v8, v16
; RV32-NEXT:    vsrl.vi v16, v8, 4
; RV32-NEXT:    vor.vv v8, v8, v16
; RV32-NEXT:    vsrl.vi v16, v8, 8
; RV32-NEXT:    vor.vv v8, v8, v16
; RV32-NEXT:    vsrl.vi v16, v8, 16
; RV32-NEXT:    vor.vv v8, v8, v16
; RV32-NEXT:    vxor.vi v8, v8, -1
; RV32-NEXT:    vsrl.vi v16, v8, 1
; RV32-NEXT:    lui a0, 349525
; RV32-NEXT:    addi a0, a0, 1365
; RV32-NEXT:    vand.vx v16, v16, a0
; RV32-NEXT:    vsub.vv v8, v8, v16
; RV32-NEXT:    lui a0, 209715
; RV32-NEXT:    addi a0, a0, 819
; RV32-NEXT:    vand.vx v16, v8, a0
; RV32-NEXT:    vsrl.vi v8, v8, 2
; RV32-NEXT:    vand.vx v8, v8, a0
; RV32-NEXT:    vadd.vv v8, v16, v8
; RV32-NEXT:    vsrl.vi v16, v8, 4
; RV32-NEXT:    vadd.vv v8, v8, v16
; RV32-NEXT:    lui a0, 61681
; RV32-NEXT:    addi a0, a0, -241
; RV32-NEXT:    vand.vx v8, v8, a0
; RV32-NEXT:    lui a0, 4112
; RV32-NEXT:    addi a0, a0, 257
; RV32-NEXT:    vmul.vx v8, v8, a0
; RV32-NEXT:    vsrl.vi v8, v8, 24
; RV32-NEXT:    ret
;
; RV64-LABEL: ctlz_zero_undef_nxv16i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e32, m8, ta, mu
; RV64-NEXT:    vsrl.vi v16, v8, 1
; RV64-NEXT:    vor.vv v8, v8, v16
; RV64-NEXT:    vsrl.vi v16, v8, 2
; RV64-NEXT:    vor.vv v8, v8, v16
; RV64-NEXT:    vsrl.vi v16, v8, 4
; RV64-NEXT:    vor.vv v8, v8, v16
; RV64-NEXT:    vsrl.vi v16, v8, 8
; RV64-NEXT:    vor.vv v8, v8, v16
; RV64-NEXT:    vsrl.vi v16, v8, 16
; RV64-NEXT:    vor.vv v8, v8, v16
; RV64-NEXT:    vxor.vi v8, v8, -1
; RV64-NEXT:    vsrl.vi v16, v8, 1
; RV64-NEXT:    lui a0, 349525
; RV64-NEXT:    addiw a0, a0, 1365
; RV64-NEXT:    vand.vx v16, v16, a0
; RV64-NEXT:    vsub.vv v8, v8, v16
; RV64-NEXT:    lui a0, 209715
; RV64-NEXT:    addiw a0, a0, 819
; RV64-NEXT:    vand.vx v16, v8, a0
; RV64-NEXT:    vsrl.vi v8, v8, 2
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vadd.vv v8, v16, v8
; RV64-NEXT:    vsrl.vi v16, v8, 4
; RV64-NEXT:    vadd.vv v8, v8, v16
; RV64-NEXT:    lui a0, 61681
; RV64-NEXT:    addiw a0, a0, -241
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    lui a0, 4112
; RV64-NEXT:    addiw a0, a0, 257
; RV64-NEXT:    vmul.vx v8, v8, a0
; RV64-NEXT:    vsrl.vi v8, v8, 24
; RV64-NEXT:    ret
  %a = call <vscale x 16 x i32> @llvm.ctlz.nxv16i32(<vscale x 16 x i32> %va, i1 true)
  ret <vscale x 16 x i32> %a
}

define <vscale x 1 x i64> @ctlz_zero_undef_nxv1i64(<vscale x 1 x i64> %va) {
; RV32-LABEL: ctlz_zero_undef_nxv1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    lui a0, 349525
; RV32-NEXT:    addi a0, a0, 1365
; RV32-NEXT:    sw a0, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    lui a0, 209715
; RV32-NEXT:    addi a0, a0, 819
; RV32-NEXT:    sw a0, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    lui a0, 61681
; RV32-NEXT:    addi a0, a0, -241
; RV32-NEXT:    sw a0, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    lui a0, 4112
; RV32-NEXT:    addi a0, a0, 257
; RV32-NEXT:    sw a0, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    vsetvli a0, zero, e64, m1, ta, mu
; RV32-NEXT:    vsrl.vi v9, v8, 1
; RV32-NEXT:    vor.vv v8, v8, v9
; RV32-NEXT:    vsrl.vi v9, v8, 2
; RV32-NEXT:    vor.vv v8, v8, v9
; RV32-NEXT:    vsrl.vi v9, v8, 4
; RV32-NEXT:    vor.vv v8, v8, v9
; RV32-NEXT:    vsrl.vi v9, v8, 8
; RV32-NEXT:    vor.vv v8, v8, v9
; RV32-NEXT:    vsrl.vi v9, v8, 16
; RV32-NEXT:    vor.vv v8, v8, v9
; RV32-NEXT:    li a0, 32
; RV32-NEXT:    vsrl.vx v9, v8, a0
; RV32-NEXT:    vor.vv v8, v8, v9
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vlse64.v v9, (a0), zero
; RV32-NEXT:    vxor.vi v8, v8, -1
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vlse64.v v10, (a0), zero
; RV32-NEXT:    vsrl.vi v11, v8, 1
; RV32-NEXT:    vand.vv v9, v11, v9
; RV32-NEXT:    vsub.vv v8, v8, v9
; RV32-NEXT:    vand.vv v9, v8, v10
; RV32-NEXT:    vsrl.vi v8, v8, 2
; RV32-NEXT:    vand.vv v8, v8, v10
; RV32-NEXT:    vadd.vv v8, v9, v8
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vlse64.v v9, (a0), zero
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vlse64.v v10, (a0), zero
; RV32-NEXT:    vsrl.vi v11, v8, 4
; RV32-NEXT:    vadd.vv v8, v8, v11
; RV32-NEXT:    vand.vv v8, v8, v9
; RV32-NEXT:    vmul.vv v8, v8, v10
; RV32-NEXT:    li a0, 56
; RV32-NEXT:    vsrl.vx v8, v8, a0
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: ctlz_zero_undef_nxv1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64, m1, ta, mu
; RV64-NEXT:    vsrl.vi v9, v8, 1
; RV64-NEXT:    vor.vv v8, v8, v9
; RV64-NEXT:    vsrl.vi v9, v8, 2
; RV64-NEXT:    vor.vv v8, v8, v9
; RV64-NEXT:    vsrl.vi v9, v8, 4
; RV64-NEXT:    vor.vv v8, v8, v9
; RV64-NEXT:    vsrl.vi v9, v8, 8
; RV64-NEXT:    vor.vv v8, v8, v9
; RV64-NEXT:    vsrl.vi v9, v8, 16
; RV64-NEXT:    vor.vv v8, v8, v9
; RV64-NEXT:    li a0, 32
; RV64-NEXT:    vsrl.vx v9, v8, a0
; RV64-NEXT:    vor.vv v8, v8, v9
; RV64-NEXT:    vxor.vi v8, v8, -1
; RV64-NEXT:    lui a0, %hi(.LCPI40_0)
; RV64-NEXT:    ld a0, %lo(.LCPI40_0)(a0)
; RV64-NEXT:    lui a1, %hi(.LCPI40_1)
; RV64-NEXT:    ld a1, %lo(.LCPI40_1)(a1)
; RV64-NEXT:    vsrl.vi v9, v8, 1
; RV64-NEXT:    vand.vx v9, v9, a0
; RV64-NEXT:    vsub.vv v8, v8, v9
; RV64-NEXT:    vand.vx v9, v8, a1
; RV64-NEXT:    vsrl.vi v8, v8, 2
; RV64-NEXT:    vand.vx v8, v8, a1
; RV64-NEXT:    vadd.vv v8, v9, v8
; RV64-NEXT:    lui a0, %hi(.LCPI40_2)
; RV64-NEXT:    ld a0, %lo(.LCPI40_2)(a0)
; RV64-NEXT:    lui a1, %hi(.LCPI40_3)
; RV64-NEXT:    ld a1, %lo(.LCPI40_3)(a1)
; RV64-NEXT:    vsrl.vi v9, v8, 4
; RV64-NEXT:    vadd.vv v8, v8, v9
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vmul.vx v8, v8, a1
; RV64-NEXT:    li a0, 56
; RV64-NEXT:    vsrl.vx v8, v8, a0
; RV64-NEXT:    ret
  %a = call <vscale x 1 x i64> @llvm.ctlz.nxv1i64(<vscale x 1 x i64> %va, i1 true)
  ret <vscale x 1 x i64> %a
}

define <vscale x 2 x i64> @ctlz_zero_undef_nxv2i64(<vscale x 2 x i64> %va) {
; RV32-LABEL: ctlz_zero_undef_nxv2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    lui a0, 349525
; RV32-NEXT:    addi a0, a0, 1365
; RV32-NEXT:    sw a0, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    lui a0, 209715
; RV32-NEXT:    addi a0, a0, 819
; RV32-NEXT:    sw a0, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    lui a0, 61681
; RV32-NEXT:    addi a0, a0, -241
; RV32-NEXT:    sw a0, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    lui a0, 4112
; RV32-NEXT:    addi a0, a0, 257
; RV32-NEXT:    sw a0, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    vsetvli a0, zero, e64, m2, ta, mu
; RV32-NEXT:    vsrl.vi v10, v8, 1
; RV32-NEXT:    vor.vv v8, v8, v10
; RV32-NEXT:    vsrl.vi v10, v8, 2
; RV32-NEXT:    vor.vv v8, v8, v10
; RV32-NEXT:    vsrl.vi v10, v8, 4
; RV32-NEXT:    vor.vv v8, v8, v10
; RV32-NEXT:    vsrl.vi v10, v8, 8
; RV32-NEXT:    vor.vv v8, v8, v10
; RV32-NEXT:    vsrl.vi v10, v8, 16
; RV32-NEXT:    vor.vv v8, v8, v10
; RV32-NEXT:    li a0, 32
; RV32-NEXT:    vsrl.vx v10, v8, a0
; RV32-NEXT:    vor.vv v8, v8, v10
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vlse64.v v10, (a0), zero
; RV32-NEXT:    vxor.vi v8, v8, -1
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vlse64.v v12, (a0), zero
; RV32-NEXT:    vsrl.vi v14, v8, 1
; RV32-NEXT:    vand.vv v10, v14, v10
; RV32-NEXT:    vsub.vv v8, v8, v10
; RV32-NEXT:    vand.vv v10, v8, v12
; RV32-NEXT:    vsrl.vi v8, v8, 2
; RV32-NEXT:    vand.vv v8, v8, v12
; RV32-NEXT:    vadd.vv v8, v10, v8
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vlse64.v v10, (a0), zero
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vlse64.v v12, (a0), zero
; RV32-NEXT:    vsrl.vi v14, v8, 4
; RV32-NEXT:    vadd.vv v8, v8, v14
; RV32-NEXT:    vand.vv v8, v8, v10
; RV32-NEXT:    vmul.vv v8, v8, v12
; RV32-NEXT:    li a0, 56
; RV32-NEXT:    vsrl.vx v8, v8, a0
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: ctlz_zero_undef_nxv2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64, m2, ta, mu
; RV64-NEXT:    vsrl.vi v10, v8, 1
; RV64-NEXT:    vor.vv v8, v8, v10
; RV64-NEXT:    vsrl.vi v10, v8, 2
; RV64-NEXT:    vor.vv v8, v8, v10
; RV64-NEXT:    vsrl.vi v10, v8, 4
; RV64-NEXT:    vor.vv v8, v8, v10
; RV64-NEXT:    vsrl.vi v10, v8, 8
; RV64-NEXT:    vor.vv v8, v8, v10
; RV64-NEXT:    vsrl.vi v10, v8, 16
; RV64-NEXT:    vor.vv v8, v8, v10
; RV64-NEXT:    li a0, 32
; RV64-NEXT:    vsrl.vx v10, v8, a0
; RV64-NEXT:    vor.vv v8, v8, v10
; RV64-NEXT:    vxor.vi v8, v8, -1
; RV64-NEXT:    lui a0, %hi(.LCPI41_0)
; RV64-NEXT:    ld a0, %lo(.LCPI41_0)(a0)
; RV64-NEXT:    lui a1, %hi(.LCPI41_1)
; RV64-NEXT:    ld a1, %lo(.LCPI41_1)(a1)
; RV64-NEXT:    vsrl.vi v10, v8, 1
; RV64-NEXT:    vand.vx v10, v10, a0
; RV64-NEXT:    vsub.vv v8, v8, v10
; RV64-NEXT:    vand.vx v10, v8, a1
; RV64-NEXT:    vsrl.vi v8, v8, 2
; RV64-NEXT:    vand.vx v8, v8, a1
; RV64-NEXT:    vadd.vv v8, v10, v8
; RV64-NEXT:    lui a0, %hi(.LCPI41_2)
; RV64-NEXT:    ld a0, %lo(.LCPI41_2)(a0)
; RV64-NEXT:    lui a1, %hi(.LCPI41_3)
; RV64-NEXT:    ld a1, %lo(.LCPI41_3)(a1)
; RV64-NEXT:    vsrl.vi v10, v8, 4
; RV64-NEXT:    vadd.vv v8, v8, v10
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vmul.vx v8, v8, a1
; RV64-NEXT:    li a0, 56
; RV64-NEXT:    vsrl.vx v8, v8, a0
; RV64-NEXT:    ret
  %a = call <vscale x 2 x i64> @llvm.ctlz.nxv2i64(<vscale x 2 x i64> %va, i1 true)
  ret <vscale x 2 x i64> %a
}

define <vscale x 4 x i64> @ctlz_zero_undef_nxv4i64(<vscale x 4 x i64> %va) {
; RV32-LABEL: ctlz_zero_undef_nxv4i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    lui a0, 349525
; RV32-NEXT:    addi a0, a0, 1365
; RV32-NEXT:    sw a0, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    lui a0, 209715
; RV32-NEXT:    addi a0, a0, 819
; RV32-NEXT:    sw a0, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    lui a0, 61681
; RV32-NEXT:    addi a0, a0, -241
; RV32-NEXT:    sw a0, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    lui a0, 4112
; RV32-NEXT:    addi a0, a0, 257
; RV32-NEXT:    sw a0, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    vsetvli a0, zero, e64, m4, ta, mu
; RV32-NEXT:    vsrl.vi v12, v8, 1
; RV32-NEXT:    vor.vv v8, v8, v12
; RV32-NEXT:    vsrl.vi v12, v8, 2
; RV32-NEXT:    vor.vv v8, v8, v12
; RV32-NEXT:    vsrl.vi v12, v8, 4
; RV32-NEXT:    vor.vv v8, v8, v12
; RV32-NEXT:    vsrl.vi v12, v8, 8
; RV32-NEXT:    vor.vv v8, v8, v12
; RV32-NEXT:    vsrl.vi v12, v8, 16
; RV32-NEXT:    vor.vv v8, v8, v12
; RV32-NEXT:    li a0, 32
; RV32-NEXT:    vsrl.vx v12, v8, a0
; RV32-NEXT:    vor.vv v8, v8, v12
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vlse64.v v12, (a0), zero
; RV32-NEXT:    vxor.vi v8, v8, -1
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vlse64.v v16, (a0), zero
; RV32-NEXT:    vsrl.vi v20, v8, 1
; RV32-NEXT:    vand.vv v12, v20, v12
; RV32-NEXT:    vsub.vv v8, v8, v12
; RV32-NEXT:    vand.vv v12, v8, v16
; RV32-NEXT:    vsrl.vi v8, v8, 2
; RV32-NEXT:    vand.vv v8, v8, v16
; RV32-NEXT:    vadd.vv v8, v12, v8
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vlse64.v v12, (a0), zero
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vlse64.v v16, (a0), zero
; RV32-NEXT:    vsrl.vi v20, v8, 4
; RV32-NEXT:    vadd.vv v8, v8, v20
; RV32-NEXT:    vand.vv v8, v8, v12
; RV32-NEXT:    vmul.vv v8, v8, v16
; RV32-NEXT:    li a0, 56
; RV32-NEXT:    vsrl.vx v8, v8, a0
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: ctlz_zero_undef_nxv4i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64, m4, ta, mu
; RV64-NEXT:    vsrl.vi v12, v8, 1
; RV64-NEXT:    vor.vv v8, v8, v12
; RV64-NEXT:    vsrl.vi v12, v8, 2
; RV64-NEXT:    vor.vv v8, v8, v12
; RV64-NEXT:    vsrl.vi v12, v8, 4
; RV64-NEXT:    vor.vv v8, v8, v12
; RV64-NEXT:    vsrl.vi v12, v8, 8
; RV64-NEXT:    vor.vv v8, v8, v12
; RV64-NEXT:    vsrl.vi v12, v8, 16
; RV64-NEXT:    vor.vv v8, v8, v12
; RV64-NEXT:    li a0, 32
; RV64-NEXT:    vsrl.vx v12, v8, a0
; RV64-NEXT:    vor.vv v8, v8, v12
; RV64-NEXT:    vxor.vi v8, v8, -1
; RV64-NEXT:    lui a0, %hi(.LCPI42_0)
; RV64-NEXT:    ld a0, %lo(.LCPI42_0)(a0)
; RV64-NEXT:    lui a1, %hi(.LCPI42_1)
; RV64-NEXT:    ld a1, %lo(.LCPI42_1)(a1)
; RV64-NEXT:    vsrl.vi v12, v8, 1
; RV64-NEXT:    vand.vx v12, v12, a0
; RV64-NEXT:    vsub.vv v8, v8, v12
; RV64-NEXT:    vand.vx v12, v8, a1
; RV64-NEXT:    vsrl.vi v8, v8, 2
; RV64-NEXT:    vand.vx v8, v8, a1
; RV64-NEXT:    vadd.vv v8, v12, v8
; RV64-NEXT:    lui a0, %hi(.LCPI42_2)
; RV64-NEXT:    ld a0, %lo(.LCPI42_2)(a0)
; RV64-NEXT:    lui a1, %hi(.LCPI42_3)
; RV64-NEXT:    ld a1, %lo(.LCPI42_3)(a1)
; RV64-NEXT:    vsrl.vi v12, v8, 4
; RV64-NEXT:    vadd.vv v8, v8, v12
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vmul.vx v8, v8, a1
; RV64-NEXT:    li a0, 56
; RV64-NEXT:    vsrl.vx v8, v8, a0
; RV64-NEXT:    ret
  %a = call <vscale x 4 x i64> @llvm.ctlz.nxv4i64(<vscale x 4 x i64> %va, i1 true)
  ret <vscale x 4 x i64> %a
}

define <vscale x 8 x i64> @ctlz_zero_undef_nxv8i64(<vscale x 8 x i64> %va) {
; RV32-LABEL: ctlz_zero_undef_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    lui a0, 349525
; RV32-NEXT:    addi a0, a0, 1365
; RV32-NEXT:    sw a0, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    lui a0, 209715
; RV32-NEXT:    addi a0, a0, 819
; RV32-NEXT:    sw a0, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    lui a0, 61681
; RV32-NEXT:    addi a0, a0, -241
; RV32-NEXT:    sw a0, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    lui a0, 4112
; RV32-NEXT:    addi a0, a0, 257
; RV32-NEXT:    sw a0, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    vsetvli a0, zero, e64, m8, ta, mu
; RV32-NEXT:    vsrl.vi v16, v8, 1
; RV32-NEXT:    vor.vv v8, v8, v16
; RV32-NEXT:    vsrl.vi v16, v8, 2
; RV32-NEXT:    vor.vv v8, v8, v16
; RV32-NEXT:    vsrl.vi v16, v8, 4
; RV32-NEXT:    vor.vv v8, v8, v16
; RV32-NEXT:    vsrl.vi v16, v8, 8
; RV32-NEXT:    vor.vv v8, v8, v16
; RV32-NEXT:    vsrl.vi v16, v8, 16
; RV32-NEXT:    vor.vv v8, v8, v16
; RV32-NEXT:    li a0, 32
; RV32-NEXT:    vsrl.vx v16, v8, a0
; RV32-NEXT:    vor.vv v8, v8, v16
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vlse64.v v16, (a0), zero
; RV32-NEXT:    vxor.vi v8, v8, -1
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vlse64.v v24, (a0), zero
; RV32-NEXT:    vsrl.vi v0, v8, 1
; RV32-NEXT:    vand.vv v16, v0, v16
; RV32-NEXT:    vsub.vv v8, v8, v16
; RV32-NEXT:    vand.vv v16, v8, v24
; RV32-NEXT:    vsrl.vi v8, v8, 2
; RV32-NEXT:    vand.vv v8, v8, v24
; RV32-NEXT:    vadd.vv v8, v16, v8
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vlse64.v v16, (a0), zero
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vlse64.v v24, (a0), zero
; RV32-NEXT:    vsrl.vi v0, v8, 4
; RV32-NEXT:    vadd.vv v8, v8, v0
; RV32-NEXT:    vand.vv v8, v8, v16
; RV32-NEXT:    vmul.vv v8, v8, v24
; RV32-NEXT:    li a0, 56
; RV32-NEXT:    vsrl.vx v8, v8, a0
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: ctlz_zero_undef_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a0, zero, e64, m8, ta, mu
; RV64-NEXT:    vsrl.vi v16, v8, 1
; RV64-NEXT:    vor.vv v8, v8, v16
; RV64-NEXT:    vsrl.vi v16, v8, 2
; RV64-NEXT:    vor.vv v8, v8, v16
; RV64-NEXT:    vsrl.vi v16, v8, 4
; RV64-NEXT:    vor.vv v8, v8, v16
; RV64-NEXT:    vsrl.vi v16, v8, 8
; RV64-NEXT:    vor.vv v8, v8, v16
; RV64-NEXT:    vsrl.vi v16, v8, 16
; RV64-NEXT:    vor.vv v8, v8, v16
; RV64-NEXT:    li a0, 32
; RV64-NEXT:    vsrl.vx v16, v8, a0
; RV64-NEXT:    vor.vv v8, v8, v16
; RV64-NEXT:    vxor.vi v8, v8, -1
; RV64-NEXT:    lui a0, %hi(.LCPI43_0)
; RV64-NEXT:    ld a0, %lo(.LCPI43_0)(a0)
; RV64-NEXT:    lui a1, %hi(.LCPI43_1)
; RV64-NEXT:    ld a1, %lo(.LCPI43_1)(a1)
; RV64-NEXT:    vsrl.vi v16, v8, 1
; RV64-NEXT:    vand.vx v16, v16, a0
; RV64-NEXT:    vsub.vv v8, v8, v16
; RV64-NEXT:    vand.vx v16, v8, a1
; RV64-NEXT:    vsrl.vi v8, v8, 2
; RV64-NEXT:    vand.vx v8, v8, a1
; RV64-NEXT:    vadd.vv v8, v16, v8
; RV64-NEXT:    lui a0, %hi(.LCPI43_2)
; RV64-NEXT:    ld a0, %lo(.LCPI43_2)(a0)
; RV64-NEXT:    lui a1, %hi(.LCPI43_3)
; RV64-NEXT:    ld a1, %lo(.LCPI43_3)(a1)
; RV64-NEXT:    vsrl.vi v16, v8, 4
; RV64-NEXT:    vadd.vv v8, v8, v16
; RV64-NEXT:    vand.vx v8, v8, a0
; RV64-NEXT:    vmul.vx v8, v8, a1
; RV64-NEXT:    li a0, 56
; RV64-NEXT:    vsrl.vx v8, v8, a0
; RV64-NEXT:    ret
  %a = call <vscale x 8 x i64> @llvm.ctlz.nxv8i64(<vscale x 8 x i64> %va, i1 true)
  ret <vscale x 8 x i64> %a
}
