; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=aarch64-apple- -mcpu=cyclone | FileCheck %s

; The non-byte ones used to fail with "Cannot select"

define <8 x i8> @ctpopv8i8(<8 x i8> %x) nounwind readnone {
; CHECK-LABEL: ctpopv8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cnt v0.8b, v0.8b
; CHECK-NEXT:    ret
  %cnt = tail call <8 x i8> @llvm.ctpop.v8i8(<8 x i8> %x)
  ret <8 x i8> %cnt
}

declare <8 x i8> @llvm.ctpop.v8i8(<8 x i8>) nounwind readnone

define <4 x i16> @ctpopv4i16(<4 x i16> %x) nounwind readnone {
; CHECK-LABEL: ctpopv4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cnt v0.8b, v0.8b
; CHECK-NEXT:    uaddlp v0.4h, v0.8b
; CHECK-NEXT:    ret
  %cnt = tail call <4 x i16> @llvm.ctpop.v4i16(<4 x i16> %x)
  ret <4 x i16> %cnt
}

declare <4 x i16> @llvm.ctpop.v4i16(<4 x i16>) nounwind readnone

define <2 x i32> @ctpopv2i32(<2 x i32> %x) nounwind readnone {
; CHECK-LABEL: ctpopv2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cnt v0.8b, v0.8b
; CHECK-NEXT:    uaddlp v0.4h, v0.8b
; CHECK-NEXT:    uaddlp v0.2s, v0.4h
; CHECK-NEXT:    ret
  %cnt = tail call <2 x i32> @llvm.ctpop.v2i32(<2 x i32> %x)
  ret <2 x i32> %cnt
}

declare <2 x i32> @llvm.ctpop.v2i32(<2 x i32>) nounwind readnone

define <1 x i64> @ctpopv1i64(<1 x i64> %x) nounwind readnone {
; CHECK-LABEL: ctpopv1i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cnt v0.8b, v0.8b
; CHECK-NEXT:    uaddlp v0.4h, v0.8b
; CHECK-NEXT:    uaddlp v0.2s, v0.4h
; CHECK-NEXT:    uaddlp v0.1d, v0.2s
; CHECK-NEXT:    ret
  %cnt = tail call <1 x i64> @llvm.ctpop.v1i64(<1 x i64> %x)
  ret <1 x i64> %cnt
}

declare <1 x i64> @llvm.ctpop.v1i64(<1 x i64>) nounwind readnone

define <16 x i8> @ctpopv16i8(<16 x i8> %x) nounwind readnone {
; CHECK-LABEL: ctpopv16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cnt v0.16b, v0.16b
; CHECK-NEXT:    ret
  %cnt = tail call <16 x i8> @llvm.ctpop.v16i8(<16 x i8> %x)
  ret <16 x i8> %cnt
}

declare <16 x i8> @llvm.ctpop.v16i8(<16 x i8>) nounwind readnone

define <8 x i16> @ctpopv8i16(<8 x i16> %x) nounwind readnone {
; CHECK-LABEL: ctpopv8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cnt v0.16b, v0.16b
; CHECK-NEXT:    uaddlp v0.8h, v0.16b
; CHECK-NEXT:    ret
  %cnt = tail call <8 x i16> @llvm.ctpop.v8i16(<8 x i16> %x)
  ret <8 x i16> %cnt
}

declare <8 x i16> @llvm.ctpop.v8i16(<8 x i16>) nounwind readnone

define <4 x i32> @ctpopv4i32(<4 x i32> %x) nounwind readnone {
; CHECK-LABEL: ctpopv4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cnt v0.16b, v0.16b
; CHECK-NEXT:    uaddlp v0.8h, v0.16b
; CHECK-NEXT:    uaddlp v0.4s, v0.8h
; CHECK-NEXT:    ret
  %cnt = tail call <4 x i32> @llvm.ctpop.v4i32(<4 x i32> %x)
  ret <4 x i32> %cnt
}

declare <4 x i32> @llvm.ctpop.v4i32(<4 x i32>) nounwind readnone

define <2 x i64> @ctpopv2i64(<2 x i64> %x) nounwind readnone {
; CHECK-LABEL: ctpopv2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cnt v0.16b, v0.16b
; CHECK-NEXT:    uaddlp v0.8h, v0.16b
; CHECK-NEXT:    uaddlp v0.4s, v0.8h
; CHECK-NEXT:    uaddlp v0.2d, v0.4s
; CHECK-NEXT:    ret
  %cnt = tail call <2 x i64> @llvm.ctpop.v2i64(<2 x i64> %x)
  ret <2 x i64> %cnt
}

declare <2 x i64> @llvm.ctpop.v2i64(<2 x i64>) nounwind readnone
