#!/bin/bash

if [ ! -d "./test" ]; then
	echo "USAGE: ./tools/test.sh"
	exit 1
fi

function ks_clean()
{
	ks_info "Cleaning..."
	make clean
	rm -f .qmake.stash target_wrapper.sh test
}

function ks_info()
{
	echo
	echo "INFO: $1"
	echo
}

ks_info "Validating src/kshutdown.desktop..."

desktop-file-validate --warn-kde "src/kshutdown.desktop"

set -e

for dir in ./test/*; do
	if [ -d "$dir" ]; then
		ks_info "Testing \"$dir\" directory..."

		pushd "$dir"

		ks_info "Configuring..."
		qmake \
			"CONFIG += testcase" \
			"DEFINES += KS_PURE_QT" \
			"INCLUDEPATH += ../../src" \
			"QT += testlib widgets" \
			"TARGET = test" \
			"VPATH += ../../src" \
			-config debug

		ks_clean

		ks_info "Compiling..."
		make -j2

		ks_info "Running..."
		./test

		ks_clean
		rm -f Makefile

		popd
	fi
done
