/*
 * J7200 Clocks Info
 *
 * Copyright (C) 2022 Texas Instruments Incorporated - https://www.ti.com/
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <tisci.h>
#include <socinfo.h>

struct ti_sci_clocks_info j7200_clocks_info[] = {
	{4, 0, "DEV_A72SS0_CORE0_ARM_CLK_CLK", "Input clock"},
	{4, 1, "DEV_A72SS0_CORE0_MSMC_CLK", "Input clock"},
	{4, 2, "DEV_A72SS0_CORE0_PLL_CTRL_CLK", "Input clock"},
	{202, 2, "DEV_A72SS0_CORE0_0_ARM_CLK_CLK", "Input clock"},
	{203, 0, "DEV_A72SS0_CORE0_1_ARM_CLK_CLK", "Input clock"},
	{2, 0, "DEV_ATL0_VBUS_CLK", "Input clock"},
	{2, 1, "DEV_ATL0_ATL_CLK", "Input muxed clock"},
	{2, 2, "DEV_ATL0_ATL_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT1_CLK", "Parent input clock option to DEV_ATL0_ATL_CLK"},
	{2, 3, "DEV_ATL0_ATL_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_ATL0_ATL_CLK"},
	{2, 6, "DEV_ATL0_ATL_CLK_PARENT_POSTDIV2_16FFT_MAIN_0_HSDIVOUT7_CLK", "Parent input clock option to DEV_ATL0_ATL_CLK"},
	{2, 7, "DEV_ATL0_ATL_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_ATL0_ATL_CLK"},
	{2, 8, "DEV_ATL0_ATL_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_ATL0_ATL_CLK"},
	{2, 10, "DEV_ATL0_ATL_IO_PORT_ATCLK_OUT_1", "Output clock"},
	{2, 11, "DEV_ATL0_ATL_IO_PORT_ATCLK_OUT_3", "Output clock"},
	{2, 12, "DEV_ATL0_ATL_IO_PORT_ATCLK_OUT_2", "Output clock"},
	{2, 13, "DEV_ATL0_ATL_IO_PORT_ATCLK_OUT", "Output clock"},
	{157, 1, "DEV_BOARD0_I2C1_SCL_OUT", "Output clock"},
	{157, 2, "DEV_BOARD0_MCASP0_ACLKR_OUT", "Output clock"},
	{157, 3, "DEV_BOARD0_SPI2_CLK_IN", "Input clock"},
	{157, 4, "DEV_BOARD0_I2C3_SCL_OUT", "Output clock"},
	{157, 5, "DEV_BOARD0_OBSCLK2_IN", "Input clock"},
	{157, 6, "DEV_BOARD0_MCU_I3C0_SCL_IN", "Input clock"},
	{157, 7, "DEV_BOARD0_MCU_HYPERBUS0_CKN_IN", "Input clock"},
	{157, 8, "DEV_BOARD0_I2C4_SCL_OUT", "Output clock"},
	{157, 9, "DEV_BOARD0_RGMII3_TXC_IN", "Input clock"},
	{157, 11, "DEV_BOARD0_EXT_REFCLK1_OUT", "Output clock"},
	{157, 12, "DEV_BOARD0_SPI1_CLK_IN", "Input clock"},
	{157, 13, "DEV_BOARD0_GPMC0_CLKOUT_IN", "Input clock"},
	{157, 14, "DEV_BOARD0_MCU_OBSCLK0_IN", "Input muxed clock"},
	{157, 15, "DEV_BOARD0_MCU_OBSCLK0_IN_PARENT_MCU_OBSCLK_DIV_OUT0", "Parent input clock option to DEV_BOARD0_MCU_OBSCLK0_IN"},
	{157, 16, "DEV_BOARD0_MCU_OBSCLK0_IN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_BOARD0_MCU_OBSCLK0_IN"},
	{157, 31, "DEV_BOARD0_MCU_I3C0_SCL_OUT", "Output clock"},
	{157, 32, "DEV_BOARD0_SPI3_CLK_IN", "Input clock"},
	{157, 33, "DEV_BOARD0_MCASP0_ACLKX_OUT", "Output clock"},
	{157, 34, "DEV_BOARD0_MCASP1_ACLKR_IN", "Input clock"},
	{157, 35, "DEV_BOARD0_CLKOUT_IN", "Input muxed clock"},
	{157, 36, "DEV_BOARD0_CLKOUT_IN_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT0_CLK5", "Parent input clock option to DEV_BOARD0_CLKOUT_IN"},
	{157, 37, "DEV_BOARD0_CLKOUT_IN_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT0_CLK10", "Parent input clock option to DEV_BOARD0_CLKOUT_IN"},
	{157, 38, "DEV_BOARD0_OBSCLK1_IN", "Input clock"},
	{157, 39, "DEV_BOARD0_MCU_RMII1_REF_CLK_OUT", "Output clock"},
	{157, 40, "DEV_BOARD0_GPMC0_CLK_OUT", "Output clock"},
	{157, 41, "DEV_BOARD0_I3C0_SCL_OUT", "Output clock"},
	{157, 43, "DEV_BOARD0_TCK_OUT", "Output clock"},
	{157, 44, "DEV_BOARD0_HFOSC1_CLK_OUT", "Output clock"},
	{157, 45, "DEV_BOARD0_AUDIO_EXT_REFCLK0_OUT", "Output clock"},
	{157, 46, "DEV_BOARD0_I2C6_SCL_OUT", "Output clock"},
	{157, 48, "DEV_BOARD0_I2C5_SCL_OUT", "Output clock"},
	{157, 49, "DEV_BOARD0_MCU_OSPI0_DQS_OUT", "Output clock"},
	{157, 52, "DEV_BOARD0_RGMII2_RXC_OUT", "Output clock"},
	{157, 53, "DEV_BOARD0_MCASP2_ACLKX_IN", "Input clock"},
	{157, 54, "DEV_BOARD0_I2C0_SCL_OUT", "Output clock"},
	{157, 57, "DEV_BOARD0_MCU_HYPERBUS0_CK_IN", "Input clock"},
	{157, 59, "DEV_BOARD0_MCASP1_ACLKX_OUT", "Output clock"},
	{157, 61, "DEV_BOARD0_MCU_CPTS0_RFT_CLK_OUT", "Output clock"},
	{157, 62, "DEV_BOARD0_MDIO0_MDC_IN", "Input clock"},
	{157, 63, "DEV_BOARD0_RGMII1_TXC_IN", "Input clock"},
	{157, 65, "DEV_BOARD0_MMC1_CLK_IN", "Input clock"},
	{157, 66, "DEV_BOARD0_MCASP2_ACLKR_IN", "Input clock"},
	{157, 68, "DEV_BOARD0_WKUP_I2C0_SCL_OUT", "Output clock"},
	{157, 69, "DEV_BOARD0_MCU_CLKOUT0_IN", "Input muxed clock"},
	{157, 70, "DEV_BOARD0_MCU_CLKOUT0_IN_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT0_CLK5", "Parent input clock option to DEV_BOARD0_MCU_CLKOUT0_IN"},
	{157, 71, "DEV_BOARD0_MCU_CLKOUT0_IN_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT0_CLK10", "Parent input clock option to DEV_BOARD0_MCU_CLKOUT0_IN"},
	{157, 73, "DEV_BOARD0_MCASP0_ACLKR_IN", "Input clock"},
	{157, 74, "DEV_BOARD0_MCU_MDIO0_MDC_IN", "Input clock"},
	{157, 77, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN", "Input muxed clock"},
	{157, 78, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_0_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 79, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_1_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 80, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_2_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 90, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_0_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 91, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_1_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 92, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_MCASP_MAIN_2_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 102, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 103, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 104, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 105, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 106, "DEV_BOARD0_AUDIO_EXT_REFCLK1_IN_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK1_IN"},
	{157, 110, "DEV_BOARD0_MCU_OSPI0_CLK_IN", "Input clock"},
	{157, 114, "DEV_BOARD0_MCU_SYSCLKOUT0_IN", "Input clock"},
	{157, 115, "DEV_BOARD0_RGMII1_RXC_OUT", "Output clock"},
	{157, 116, "DEV_BOARD0_LED_CLK_OUT", "Output clock"},
	{157, 118, "DEV_BOARD0_RGMII2_TXC_IN", "Input clock"},
	{157, 119, "DEV_BOARD0_I3C0_SCL_IN", "Input clock"},
	{157, 120, "DEV_BOARD0_MCU_I2C0_SCL_OUT", "Output clock"},
	{157, 122, "DEV_BOARD0_SPI6_CLK_IN", "Input clock"},
	{157, 123, "DEV_BOARD0_WKUP_I2C0_SCL_IN", "Input clock"},
	{157, 124, "DEV_BOARD0_WKUP_LF_CLKIN_OUT", "Output clock"},
	{157, 126, "DEV_BOARD0_MCU_SPI1_CLK_IN", "Input clock"},
	{157, 127, "DEV_BOARD0_MCASP0_ACLKX_IN", "Input clock"},
	{157, 128, "DEV_BOARD0_MCASP1_ACLKX_IN", "Input clock"},
	{157, 130, "DEV_BOARD0_MCU_SPI0_CLK_IN", "Input clock"},
	{157, 131, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN", "Input muxed clock"},
	{157, 132, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_0_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 133, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_1_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 134, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_2_MCASP_AHCLKR_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 144, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_0_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 145, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_1_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 146, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_MCASP_MAIN_2_MCASP_AHCLKX_POUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 156, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 157, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 158, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 159, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 160, "DEV_BOARD0_AUDIO_EXT_REFCLK0_IN_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_BOARD0_AUDIO_EXT_REFCLK0_IN"},
	{157, 164, "DEV_BOARD0_MCU_RGMII1_TXC_IN", "Input clock"},
	{157, 165, "DEV_BOARD0_CPTS0_RFT_CLK_OUT", "Output clock"},
	{157, 166, "DEV_BOARD0_MCU_I2C1_SCL_OUT", "Output clock"},
	{157, 168, "DEV_BOARD0_MCASP2_ACLKR_OUT", "Output clock"},
	{157, 169, "DEV_BOARD0_MCU_I2C0_SCL_IN", "Input clock"},
	{157, 170, "DEV_BOARD0_RMII_REF_CLK_OUT", "Output clock"},
	{157, 171, "DEV_BOARD0_GPMC0_CLK_IN", "Input clock"},
	{157, 172, "DEV_BOARD0_TRC_CLK_IN", "Input clock"},
	{157, 174, "DEV_BOARD0_MCASP2_ACLKX_OUT", "Output clock"},
	{157, 176, "DEV_BOARD0_RGMII4_RXC_OUT", "Output clock"},
	{157, 177, "DEV_BOARD0_SYSCLKOUT0_IN", "Input clock"},
	{157, 178, "DEV_BOARD0_MCASP1_ACLKR_OUT", "Output clock"},
	{157, 179, "DEV_BOARD0_SPI5_CLK_IN", "Input clock"},
	{157, 180, "DEV_BOARD0_MCU_RGMII1_RXC_OUT", "Output clock"},
	{157, 181, "DEV_BOARD0_RGMII3_RXC_OUT", "Output clock"},
	{157, 183, "DEV_BOARD0_SPI0_CLK_IN", "Input clock"},
	{157, 184, "DEV_BOARD0_GPMC0_FCLK_MUX_IN", "Input clock"},
	{157, 185, "DEV_BOARD0_I2C2_SCL_OUT", "Output clock"},
	{157, 186, "DEV_BOARD0_MCU_EXT_REFCLK0_OUT", "Output clock"},
	{157, 187, "DEV_BOARD0_MCU_OSPI0_LBCLKO_IN", "Input clock"},
	{157, 189, "DEV_BOARD0_SPI7_CLK_IN", "Input clock"},
	{157, 190, "DEV_BOARD0_RGMII4_TXC_IN", "Input clock"},
	{157, 191, "DEV_BOARD0_AUDIO_EXT_REFCLK1_OUT", "Output clock"},
	{157, 192, "DEV_BOARD0_OBSCLK0_IN", "Input clock"},
	{157, 193, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 194, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 195, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 196, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 197, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 205, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV0_16FFT_MAIN_12_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 206, "DEV_BOARD0_OBSCLK0_IN_PARENT_OBSCLK1_MUX_OUT0", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 207, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV1_16FFT_MAIN_14_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 219, "DEV_BOARD0_OBSCLK0_IN_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 220, "DEV_BOARD0_OBSCLK0_IN_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 221, "DEV_BOARD0_OBSCLK0_IN_PARENT_BOARD_0_WKUP_LF_CLKIN_OUT", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 222, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT0_CLK_DUP0", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 223, "DEV_BOARD0_OBSCLK0_IN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 224, "DEV_BOARD0_OBSCLK0_IN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{123, 0, "DEV_CMPEVENT_INTRTR0_INTR_CLK", "Input clock"},
	{3, 0, "DEV_COMPUTE_CLUSTER0_DDR32SS_EMIF0_PLL_CTRL_CLK", "Input clock"},
	{3, 2, "DEV_COMPUTE_CLUSTER0_TB_SOC_VBUSP_DBG_CLK", "Input clock"},
	{3, 3, "DEV_COMPUTE_CLUSTER0_TB_SOC_GIC_CLK", "Input clock"},
	{3, 4, "DEV_COMPUTE_CLUSTER0_DDR32SS_EMIF0_DDR_PLL_CLK", "Input clock"},
	{3, 5, "DEV_COMPUTE_CLUSTER0_TB_SOC_VBUSP_CFG_CLK", "Input clock"},
	{3, 6, "DEV_COMPUTE_CLUSTER0_TB_SOC_VBUSP_DMSC_CLK", "Input clock"},
	{17, 4, "DEV_COMPUTE_CLUSTER0_PBIST_WRAP_DIVH_CLK4_CLK_CLK", "Input clock"},
	{19, 0, "DEV_CPSW0_MDIO_MDCLK_O", "Output clock"},
	{19, 1, "DEV_CPSW0_GMII3_MT_CLK", "Input clock"},
	{19, 2, "DEV_CPSW0_GMII2_MR_CLK", "Input clock"},
	{19, 3, "DEV_CPSW0_SERDES4_RXCLK", "Input clock"},
	{19, 4, "DEV_CPSW0_CPTS_GENF0", "Output clock"},
	{19, 5, "DEV_CPSW0_PRE_RGMII4_TCLK", "Output clock"},
	{19, 6, "DEV_CPSW0_RGMII3_RXC_I", "Input clock"},
	{19, 7, "DEV_CPSW0_RGMII4_RXC_I", "Input clock"},
	{19, 8, "DEV_CPSW0_PRE_RGMII3_TCLK", "Output clock"},
	{19, 9, "DEV_CPSW0_RGMII1_RXC_I", "Input clock"},
	{19, 10, "DEV_CPSW0_RGMII_MHZ_250_CLK", "Input clock"},
	{19, 11, "DEV_CPSW0_GMII4_MT_CLK", "Input clock"},
	{19, 13, "DEV_CPSW0_GMII3_MR_CLK", "Input clock"},
	{19, 14, "DEV_CPSW0_SERDES4_RXFCLK", "Input clock"},
	{19, 15, "DEV_CPSW0_CPTS_RFT_CLK", "Input muxed clock"},
	{19, 16, "DEV_CPSW0_CPTS_RFT_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT1_CLK", "Parent input clock option to DEV_CPSW0_CPTS_RFT_CLK"},
	{19, 17, "DEV_CPSW0_CPTS_RFT_CLK_PARENT_POSTDIV2_16FFT_MAIN_0_HSDIVOUT6_CLK", "Parent input clock option to DEV_CPSW0_CPTS_RFT_CLK"},
	{19, 18, "DEV_CPSW0_CPTS_RFT_CLK_PARENT_BOARD_0_MCU_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_CPSW0_CPTS_RFT_CLK"},
	{19, 19, "DEV_CPSW0_CPTS_RFT_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_CPSW0_CPTS_RFT_CLK"},
	{19, 20, "DEV_CPSW0_CPTS_RFT_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_CPSW0_CPTS_RFT_CLK"},
	{19, 21, "DEV_CPSW0_CPTS_RFT_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_CPSW0_CPTS_RFT_CLK"},
	{19, 22, "DEV_CPSW0_CPTS_RFT_CLK_PARENT_WIZ16B8M4CT2_MAIN_1_IP2_LN0_TXMCLK", "Parent input clock option to DEV_CPSW0_CPTS_RFT_CLK"},
	{19, 23, "DEV_CPSW0_CPTS_RFT_CLK_PARENT_WIZ16B8M4CT2_MAIN_1_IP2_LN1_TXMCLK", "Parent input clock option to DEV_CPSW0_CPTS_RFT_CLK"},
	{19, 24, "DEV_CPSW0_CPTS_RFT_CLK_PARENT_WIZ16B8M4CT2_MAIN_1_IP2_LN2_TXMCLK", "Parent input clock option to DEV_CPSW0_CPTS_RFT_CLK"},
	{19, 25, "DEV_CPSW0_CPTS_RFT_CLK_PARENT_WIZ16B8M4CT2_MAIN_1_IP2_LN3_TXMCLK", "Parent input clock option to DEV_CPSW0_CPTS_RFT_CLK"},
	{19, 30, "DEV_CPSW0_CPTS_RFT_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT1_CLK", "Parent input clock option to DEV_CPSW0_CPTS_RFT_CLK"},
	{19, 31, "DEV_CPSW0_CPTS_RFT_CLK_PARENT_K3_PLL_CTRL_WRAP_MAIN_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_CPSW0_CPTS_RFT_CLK"},
	{19, 32, "DEV_CPSW0_SERDES1_TXCLK", "Output clock"},
	{19, 33, "DEV_CPSW0_CPPI_CLK_CLK", "Input clock"},
	{19, 34, "DEV_CPSW0_SERDES2_RXCLK", "Input clock"},
	{19, 35, "DEV_CPSW0_SERDES1_RXFCLK", "Input clock"},
	{19, 36, "DEV_CPSW0_GMII_RFT_CLK", "Input clock"},
	{19, 37, "DEV_CPSW0_SERDES1_TXMCLK", "Input clock"},
	{19, 38, "DEV_CPSW0_SERDES1_REFCLK", "Input clock"},
	{19, 39, "DEV_CPSW0_RMII_MHZ_50_CLK", "Input clock"},
	{19, 40, "DEV_CPSW0_GMII4_MR_CLK", "Input clock"},
	{19, 41, "DEV_CPSW0_RGMII_MHZ_50_CLK", "Input clock"},
	{19, 42, "DEV_CPSW0_SERDES3_TXFCLK", "Input clock"},
	{19, 43, "DEV_CPSW0_SERDES3_RXFCLK", "Input clock"},
	{19, 45, "DEV_CPSW0_PRE_RGMII2_TCLK", "Output clock"},
	{19, 46, "DEV_CPSW0_SERDES2_TXCLK", "Output clock"},
	{19, 47, "DEV_CPSW0_SERDES1_RXCLK", "Input clock"},
	{19, 48, "DEV_CPSW0_SERDES1_TXFCLK", "Input clock"},
	{19, 49, "DEV_CPSW0_RGMII2_RXC_I", "Input clock"},
	{19, 50, "DEV_CPSW0_SERDES2_TXFCLK", "Input clock"},
	{19, 51, "DEV_CPSW0_PRE_RGMII1_TCLK", "Output clock"},
	{19, 52, "DEV_CPSW0_RGMII_MHZ_5_CLK", "Input clock"},
	{19, 53, "DEV_CPSW0_GMII2_MT_CLK", "Input clock"},
	{19, 54, "DEV_CPSW0_SERDES4_TXMCLK", "Input clock"},
	{19, 55, "DEV_CPSW0_SERDES3_TXCLK", "Output clock"},
	{19, 56, "DEV_CPSW0_SERDES2_TXMCLK", "Input clock"},
	{19, 57, "DEV_CPSW0_GMII1_MR_CLK", "Input clock"},
	{19, 58, "DEV_CPSW0_SERDES4_REFCLK", "Input clock"},
	{19, 59, "DEV_CPSW0_SERDES3_TXMCLK", "Input clock"},
	{19, 60, "DEV_CPSW0_SERDES2_REFCLK", "Input clock"},
	{19, 61, "DEV_CPSW0_SERDES3_REFCLK", "Input clock"},
	{19, 62, "DEV_CPSW0_SERDES3_RXCLK", "Input clock"},
	{19, 63, "DEV_CPSW0_GMII1_MT_CLK", "Input clock"},
	{19, 64, "DEV_CPSW0_SERDES2_RXFCLK", "Input clock"},
	{19, 66, "DEV_CPSW0_SERDES4_TXCLK", "Output clock"},
	{19, 67, "DEV_CPSW0_SERDES4_TXFCLK", "Input clock"},
	{26, 0, "DEV_CPSW_TX_RGMII0_IO__RGMII4_TXC__A", "Output clock"},
	{26, 1, "DEV_CPSW_TX_RGMII0_IO__RGMII3_TXC__A", "Output clock"},
	{26, 2, "DEV_CPSW_TX_RGMII0_IO__RGMII2_TXC__A", "Output clock"},
	{26, 3, "DEV_CPSW_TX_RGMII0_IO__RGMII1_TXC__A", "Output clock"},
	{26, 4, "DEV_CPSW_TX_RGMII0_PRE_RGMII2_TCLK", "Input clock"},
	{26, 5, "DEV_CPSW_TX_RGMII0_PRE_RGMII4_TCLK", "Input clock"},
	{26, 6, "DEV_CPSW_TX_RGMII0_PRE_RGMII3_TCLK", "Input clock"},
	{26, 7, "DEV_CPSW_TX_RGMII0_PRE_RGMII1_TCLK", "Input clock"},
	{20, 0, "DEV_CPT2_AGGR0_VCLK_CLK", "Input clock"},
	{21, 0, "DEV_CPT2_AGGR1_VCLK_CLK", "Input clock"},
	{23, 0, "DEV_CPT2_AGGR2_VCLK_CLK", "Input clock"},
	{25, 0, "DEV_CPT2_AGGR3_VCLK_CLK", "Input clock"},
	{30, 0, "DEV_DCC0_DCC_INPUT10_CLK", "Input clock"},
	{30, 1, "DEV_DCC0_DCC_INPUT01_CLK", "Input clock"},
	{30, 2, "DEV_DCC0_DCC_CLKSRC2_CLK", "Input clock"},
	{30, 4, "DEV_DCC0_DCC_CLKSRC0_CLK", "Input clock"},
	{30, 5, "DEV_DCC0_VBUS_CLK", "Input clock"},
	{30, 6, "DEV_DCC0_DCC_CLKSRC4_CLK", "Input clock"},
	{30, 7, "DEV_DCC0_DCC_CLKSRC1_CLK", "Input clock"},
	{30, 8, "DEV_DCC0_DCC_CLKSRC3_CLK", "Input clock"},
	{30, 9, "DEV_DCC0_DCC_INPUT00_CLK", "Input clock"},
	{30, 10, "DEV_DCC0_DCC_CLKSRC5_CLK", "Input clock"},
	{30, 11, "DEV_DCC0_DCC_CLKSRC6_CLK", "Input clock"},
	{30, 12, "DEV_DCC0_DCC_INPUT02_CLK", "Input clock"},
	{31, 0, "DEV_DCC1_DCC_INPUT10_CLK", "Input clock"},
	{31, 1, "DEV_DCC1_DCC_INPUT01_CLK", "Input clock"},
	{31, 2, "DEV_DCC1_DCC_CLKSRC2_CLK", "Input clock"},
	{31, 4, "DEV_DCC1_DCC_CLKSRC0_CLK", "Input clock"},
	{31, 5, "DEV_DCC1_VBUS_CLK", "Input clock"},
	{31, 6, "DEV_DCC1_DCC_CLKSRC4_CLK", "Input clock"},
	{31, 7, "DEV_DCC1_DCC_CLKSRC1_CLK", "Input clock"},
	{31, 8, "DEV_DCC1_DCC_CLKSRC3_CLK", "Input clock"},
	{31, 9, "DEV_DCC1_DCC_INPUT00_CLK", "Input clock"},
	{31, 10, "DEV_DCC1_DCC_CLKSRC5_CLK", "Input clock"},
	{31, 11, "DEV_DCC1_DCC_CLKSRC6_CLK", "Input clock"},
	{31, 12, "DEV_DCC1_DCC_INPUT02_CLK", "Input clock"},
	{32, 0, "DEV_DCC2_DCC_INPUT10_CLK", "Input clock"},
	{32, 1, "DEV_DCC2_DCC_INPUT01_CLK", "Input clock"},
	{32, 2, "DEV_DCC2_DCC_CLKSRC2_CLK", "Input clock"},
	{32, 3, "DEV_DCC2_DCC_CLKSRC7_CLK", "Input clock"},
	{32, 4, "DEV_DCC2_DCC_CLKSRC0_CLK", "Input clock"},
	{32, 5, "DEV_DCC2_VBUS_CLK", "Input clock"},
	{32, 6, "DEV_DCC2_DCC_CLKSRC4_CLK", "Input clock"},
	{32, 8, "DEV_DCC2_DCC_CLKSRC3_CLK", "Input clock"},
	{32, 9, "DEV_DCC2_DCC_INPUT00_CLK", "Input clock"},
	{32, 10, "DEV_DCC2_DCC_CLKSRC5_CLK", "Input clock"},
	{32, 11, "DEV_DCC2_DCC_CLKSRC6_CLK", "Input clock"},
	{32, 12, "DEV_DCC2_DCC_INPUT02_CLK", "Input clock"},
	{33, 0, "DEV_DCC3_DCC_INPUT10_CLK", "Input clock"},
	{33, 1, "DEV_DCC3_DCC_INPUT01_CLK", "Input clock"},
	{33, 2, "DEV_DCC3_DCC_CLKSRC2_CLK", "Input clock"},
	{33, 3, "DEV_DCC3_DCC_CLKSRC7_CLK", "Input clock"},
	{33, 4, "DEV_DCC3_DCC_CLKSRC0_CLK", "Input clock"},
	{33, 5, "DEV_DCC3_VBUS_CLK", "Input clock"},
	{33, 6, "DEV_DCC3_DCC_CLKSRC4_CLK", "Input clock"},
	{33, 8, "DEV_DCC3_DCC_CLKSRC3_CLK", "Input clock"},
	{33, 9, "DEV_DCC3_DCC_INPUT00_CLK", "Input clock"},
	{33, 10, "DEV_DCC3_DCC_CLKSRC5_CLK", "Input clock"},
	{33, 11, "DEV_DCC3_DCC_CLKSRC6_CLK", "Input clock"},
	{33, 12, "DEV_DCC3_DCC_INPUT02_CLK", "Input clock"},
	{34, 0, "DEV_DCC4_DCC_INPUT10_CLK", "Input clock"},
	{34, 1, "DEV_DCC4_DCC_INPUT01_CLK", "Input clock"},
	{34, 2, "DEV_DCC4_DCC_CLKSRC2_CLK", "Input clock"},
	{34, 3, "DEV_DCC4_DCC_CLKSRC7_CLK", "Input clock"},
	{34, 4, "DEV_DCC4_DCC_CLKSRC0_CLK", "Input clock"},
	{34, 5, "DEV_DCC4_VBUS_CLK", "Input clock"},
	{34, 6, "DEV_DCC4_DCC_CLKSRC4_CLK", "Input clock"},
	{34, 7, "DEV_DCC4_DCC_CLKSRC1_CLK", "Input clock"},
	{34, 8, "DEV_DCC4_DCC_CLKSRC3_CLK", "Input clock"},
	{34, 9, "DEV_DCC4_DCC_INPUT00_CLK", "Input clock"},
	{34, 10, "DEV_DCC4_DCC_CLKSRC5_CLK", "Input clock"},
	{34, 11, "DEV_DCC4_DCC_CLKSRC6_CLK", "Input clock"},
	{34, 12, "DEV_DCC4_DCC_INPUT02_CLK", "Input clock"},
	{36, 0, "DEV_DCC5_DCC_INPUT10_CLK", "Input clock"},
	{36, 1, "DEV_DCC5_DCC_INPUT01_CLK", "Input clock"},
	{36, 4, "DEV_DCC5_DCC_CLKSRC0_CLK", "Input clock"},
	{36, 5, "DEV_DCC5_VBUS_CLK", "Input clock"},
	{36, 6, "DEV_DCC5_DCC_CLKSRC4_CLK", "Input clock"},
	{36, 7, "DEV_DCC5_DCC_CLKSRC1_CLK", "Input clock"},
	{36, 9, "DEV_DCC5_DCC_INPUT00_CLK", "Input clock"},
	{36, 11, "DEV_DCC5_DCC_CLKSRC6_CLK", "Input clock"},
	{36, 12, "DEV_DCC5_DCC_INPUT02_CLK", "Input clock"},
	{37, 0, "DEV_DCC6_DCC_INPUT10_CLK", "Input clock"},
	{37, 1, "DEV_DCC6_DCC_INPUT01_CLK", "Input clock"},
	{37, 2, "DEV_DCC6_DCC_CLKSRC2_CLK", "Input clock"},
	{37, 3, "DEV_DCC6_DCC_CLKSRC7_CLK", "Input clock"},
	{37, 4, "DEV_DCC6_DCC_CLKSRC0_CLK", "Input clock"},
	{37, 5, "DEV_DCC6_VBUS_CLK", "Input clock"},
	{37, 6, "DEV_DCC6_DCC_CLKSRC4_CLK", "Input clock"},
	{37, 7, "DEV_DCC6_DCC_CLKSRC1_CLK", "Input clock"},
	{37, 8, "DEV_DCC6_DCC_CLKSRC3_CLK", "Input clock"},
	{37, 9, "DEV_DCC6_DCC_INPUT00_CLK", "Input clock"},
	{37, 10, "DEV_DCC6_DCC_CLKSRC5_CLK", "Input clock"},
	{37, 11, "DEV_DCC6_DCC_CLKSRC6_CLK", "Input clock"},
	{37, 12, "DEV_DCC6_DCC_INPUT02_CLK", "Input clock"},
	{8, 0, "DEV_DDR0_PLL_CTRL_CLK", "Input clock"},
	{8, 5, "DEV_DDR0_DDRSS_DDR_PLL_CLK", "Input clock"},
	{304, 5, "DEV_DEBUGSS_WRAP0_TREXPT_CLK", "Input clock"},
	{304, 9, "DEV_DEBUGSS_WRAP0_CORE_CLK", "Input clock"},
	{304, 25, "DEV_DEBUGSS_WRAP0_JTAG_TCK", "Input clock"},
	{304, 34, "DEV_DEBUGSS_WRAP0_ATB_CLK", "Input clock"},
	{304, 49, "DEV_DEBUGSS_WRAP0_CSTPIU_TRACECLK", "Output clock"},
	{80, 0, "DEV_ECAP0_VBUS_CLK", "Input clock"},
	{81, 0, "DEV_ECAP1_VBUS_CLK", "Input clock"},
	{82, 0, "DEV_ECAP2_VBUS_CLK", "Input clock"},
	{83, 0, "DEV_EHRPWM0_VBUSP_CLK", "Input clock"},
	{84, 0, "DEV_EHRPWM1_VBUSP_CLK", "Input clock"},
	{85, 0, "DEV_EHRPWM2_VBUSP_CLK", "Input clock"},
	{86, 0, "DEV_EHRPWM3_VBUSP_CLK", "Input clock"},
	{87, 0, "DEV_EHRPWM4_VBUSP_CLK", "Input clock"},
	{88, 0, "DEV_EHRPWM5_VBUSP_CLK", "Input clock"},
	{89, 0, "DEV_ELM0_VBUSP_CLK", "Input clock"},
	{94, 0, "DEV_EQEP0_VBUS_CLK", "Input clock"},
	{95, 0, "DEV_EQEP1_VBUS_CLK", "Input clock"},
	{96, 0, "DEV_EQEP2_VBUS_CLK", "Input clock"},
	{97, 0, "DEV_ESM0_CLK", "Input clock"},
	{105, 0, "DEV_GPIO0_MMR_CLK", "Input clock"},
	{107, 0, "DEV_GPIO2_MMR_CLK", "Input clock"},
	{109, 0, "DEV_GPIO4_MMR_CLK", "Input clock"},
	{111, 0, "DEV_GPIO6_MMR_CLK", "Input clock"},
	{131, 0, "DEV_GPIOMUX_INTRTR0_INTR_CLK", "Input clock"},
	{115, 0, "DEV_GPMC0_FUNC_CLK", "Input muxed clock"},
	{115, 1, "DEV_GPMC0_FUNC_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT3_CLK", "Parent input clock option to DEV_GPMC0_FUNC_CLK"},
	{115, 2, "DEV_GPMC0_FUNC_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT1_CLK6", "Parent input clock option to DEV_GPMC0_FUNC_CLK"},
	{115, 3, "DEV_GPMC0_FUNC_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT1_CLK4", "Parent input clock option to DEV_GPMC0_FUNC_CLK"},
	{115, 4, "DEV_GPMC0_FUNC_CLK_PARENT_K3_PLL_CTRL_WRAP_MAIN_0_CHIP_DIV1_CLK_CLK4", "Parent input clock option to DEV_GPMC0_FUNC_CLK"},
	{115, 5, "DEV_GPMC0_VBUSP_CLK", "Input clock"},
	{115, 6, "DEV_GPMC0_PO_GPMC_DEV_CLK", "Output clock"},
	{115, 7, "DEV_GPMC0_PI_GPMC_RET_CLK", "Input clock"},
	{61, 0, "DEV_GTC0_VBUSP_CLK", "Input clock"},
	{61, 1, "DEV_GTC0_GTC_CLK", "Input muxed clock"},
	{61, 2, "DEV_GTC0_GTC_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT1_CLK", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 3, "DEV_GTC0_GTC_CLK_PARENT_POSTDIV2_16FFT_MAIN_0_HSDIVOUT6_CLK", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 4, "DEV_GTC0_GTC_CLK_PARENT_BOARD_0_MCU_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 5, "DEV_GTC0_GTC_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 6, "DEV_GTC0_GTC_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 7, "DEV_GTC0_GTC_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 8, "DEV_GTC0_GTC_CLK_PARENT_WIZ16B8M4CT2_MAIN_1_IP2_LN0_TXMCLK", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 9, "DEV_GTC0_GTC_CLK_PARENT_WIZ16B8M4CT2_MAIN_1_IP2_LN1_TXMCLK", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 10, "DEV_GTC0_GTC_CLK_PARENT_WIZ16B8M4CT2_MAIN_1_IP2_LN2_TXMCLK", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 11, "DEV_GTC0_GTC_CLK_PARENT_WIZ16B8M4CT2_MAIN_1_IP2_LN3_TXMCLK", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 16, "DEV_GTC0_GTC_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT1_CLK", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 17, "DEV_GTC0_GTC_CLK_PARENT_K3_PLL_CTRL_WRAP_MAIN_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{187, 0, "DEV_I2C0_PISCL", "Input clock"},
	{187, 1, "DEV_I2C0_PISYS_CLK", "Input clock"},
	{187, 2, "DEV_I2C0_CLK", "Input clock"},
	{187, 3, "DEV_I2C0_PORSCL", "Output clock"},
	{188, 0, "DEV_I2C1_PISCL", "Input clock"},
	{188, 1, "DEV_I2C1_PISYS_CLK", "Input clock"},
	{188, 2, "DEV_I2C1_CLK", "Input clock"},
	{188, 3, "DEV_I2C1_PORSCL", "Output clock"},
	{189, 0, "DEV_I2C2_PISCL", "Input clock"},
	{189, 1, "DEV_I2C2_PISYS_CLK", "Input clock"},
	{189, 2, "DEV_I2C2_CLK", "Input clock"},
	{189, 3, "DEV_I2C2_PORSCL", "Output clock"},
	{190, 0, "DEV_I2C3_PISCL", "Input clock"},
	{190, 1, "DEV_I2C3_PISYS_CLK", "Input clock"},
	{190, 2, "DEV_I2C3_CLK", "Input clock"},
	{190, 3, "DEV_I2C3_PORSCL", "Output clock"},
	{191, 0, "DEV_I2C4_PISCL", "Input clock"},
	{191, 1, "DEV_I2C4_PISYS_CLK", "Input clock"},
	{191, 2, "DEV_I2C4_CLK", "Input clock"},
	{191, 3, "DEV_I2C4_PORSCL", "Output clock"},
	{192, 0, "DEV_I2C5_PISCL", "Input clock"},
	{192, 1, "DEV_I2C5_PISYS_CLK", "Input clock"},
	{192, 2, "DEV_I2C5_CLK", "Input clock"},
	{192, 3, "DEV_I2C5_PORSCL", "Output clock"},
	{193, 0, "DEV_I2C6_PISCL", "Input clock"},
	{193, 1, "DEV_I2C6_PISYS_CLK", "Input clock"},
	{193, 2, "DEV_I2C6_CLK", "Input clock"},
	{193, 3, "DEV_I2C6_PORSCL", "Output clock"},
	{116, 0, "DEV_I3C0_I3C_SCL_DI", "Input clock"},
	{116, 1, "DEV_I3C0_I3C_SCL_DO", "Output clock"},
	{116, 2, "DEV_I3C0_I3C_PCLK_CLK", "Input clock"},
	{116, 4, "DEV_I3C0_I3C_SCLK_CLK", "Input clock"},
	{127, 0, "DEV_LED0_LED_CLK", "Input clock"},
	{127, 1, "DEV_LED0_VBUS_CLK", "Input clock"},
	{156, 0, "DEV_MCAN0_MCANSS_HCLK_CLK", "Input clock"},
	{156, 2, "DEV_MCAN0_MCANSS_CCLK_CLK", "Input muxed clock"},
	{156, 3, "DEV_MCAN0_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN0_MCANSS_CCLK_CLK"},
	{156, 4, "DEV_MCAN0_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN0_MCANSS_CCLK_CLK"},
	{156, 5, "DEV_MCAN0_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN0_MCANSS_CCLK_CLK"},
	{156, 6, "DEV_MCAN0_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN0_MCANSS_CCLK_CLK"},
	{158, 0, "DEV_MCAN1_MCANSS_HCLK_CLK", "Input clock"},
	{158, 2, "DEV_MCAN1_MCANSS_CCLK_CLK", "Input muxed clock"},
	{158, 3, "DEV_MCAN1_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN1_MCANSS_CCLK_CLK"},
	{158, 4, "DEV_MCAN1_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN1_MCANSS_CCLK_CLK"},
	{158, 5, "DEV_MCAN1_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN1_MCANSS_CCLK_CLK"},
	{158, 6, "DEV_MCAN1_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN1_MCANSS_CCLK_CLK"},
	{168, 0, "DEV_MCAN10_MCANSS_HCLK_CLK", "Input clock"},
	{168, 2, "DEV_MCAN10_MCANSS_CCLK_CLK", "Input muxed clock"},
	{168, 3, "DEV_MCAN10_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN10_MCANSS_CCLK_CLK"},
	{168, 4, "DEV_MCAN10_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN10_MCANSS_CCLK_CLK"},
	{168, 5, "DEV_MCAN10_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN10_MCANSS_CCLK_CLK"},
	{168, 6, "DEV_MCAN10_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN10_MCANSS_CCLK_CLK"},
	{169, 0, "DEV_MCAN11_MCANSS_HCLK_CLK", "Input clock"},
	{169, 2, "DEV_MCAN11_MCANSS_CCLK_CLK", "Input muxed clock"},
	{169, 3, "DEV_MCAN11_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN11_MCANSS_CCLK_CLK"},
	{169, 4, "DEV_MCAN11_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN11_MCANSS_CCLK_CLK"},
	{169, 5, "DEV_MCAN11_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN11_MCANSS_CCLK_CLK"},
	{169, 6, "DEV_MCAN11_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN11_MCANSS_CCLK_CLK"},
	{170, 0, "DEV_MCAN12_MCANSS_HCLK_CLK", "Input clock"},
	{170, 2, "DEV_MCAN12_MCANSS_CCLK_CLK", "Input muxed clock"},
	{170, 3, "DEV_MCAN12_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN12_MCANSS_CCLK_CLK"},
	{170, 4, "DEV_MCAN12_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN12_MCANSS_CCLK_CLK"},
	{170, 5, "DEV_MCAN12_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN12_MCANSS_CCLK_CLK"},
	{170, 6, "DEV_MCAN12_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN12_MCANSS_CCLK_CLK"},
	{171, 0, "DEV_MCAN13_MCANSS_HCLK_CLK", "Input clock"},
	{171, 2, "DEV_MCAN13_MCANSS_CCLK_CLK", "Input muxed clock"},
	{171, 3, "DEV_MCAN13_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN13_MCANSS_CCLK_CLK"},
	{171, 4, "DEV_MCAN13_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN13_MCANSS_CCLK_CLK"},
	{171, 5, "DEV_MCAN13_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN13_MCANSS_CCLK_CLK"},
	{171, 6, "DEV_MCAN13_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN13_MCANSS_CCLK_CLK"},
	{150, 0, "DEV_MCAN14_MCANSS_HCLK_CLK", "Input clock"},
	{150, 2, "DEV_MCAN14_MCANSS_CCLK_CLK", "Input muxed clock"},
	{150, 3, "DEV_MCAN14_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN14_MCANSS_CCLK_CLK"},
	{150, 4, "DEV_MCAN14_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN14_MCANSS_CCLK_CLK"},
	{150, 5, "DEV_MCAN14_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN14_MCANSS_CCLK_CLK"},
	{150, 6, "DEV_MCAN14_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN14_MCANSS_CCLK_CLK"},
	{151, 0, "DEV_MCAN15_MCANSS_HCLK_CLK", "Input clock"},
	{151, 2, "DEV_MCAN15_MCANSS_CCLK_CLK", "Input muxed clock"},
	{151, 3, "DEV_MCAN15_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN15_MCANSS_CCLK_CLK"},
	{151, 4, "DEV_MCAN15_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN15_MCANSS_CCLK_CLK"},
	{151, 5, "DEV_MCAN15_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN15_MCANSS_CCLK_CLK"},
	{151, 6, "DEV_MCAN15_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN15_MCANSS_CCLK_CLK"},
	{152, 0, "DEV_MCAN16_MCANSS_HCLK_CLK", "Input clock"},
	{152, 2, "DEV_MCAN16_MCANSS_CCLK_CLK", "Input muxed clock"},
	{152, 3, "DEV_MCAN16_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN16_MCANSS_CCLK_CLK"},
	{152, 4, "DEV_MCAN16_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN16_MCANSS_CCLK_CLK"},
	{152, 5, "DEV_MCAN16_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN16_MCANSS_CCLK_CLK"},
	{152, 6, "DEV_MCAN16_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN16_MCANSS_CCLK_CLK"},
	{153, 0, "DEV_MCAN17_MCANSS_HCLK_CLK", "Input clock"},
	{153, 2, "DEV_MCAN17_MCANSS_CCLK_CLK", "Input muxed clock"},
	{153, 3, "DEV_MCAN17_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN17_MCANSS_CCLK_CLK"},
	{153, 4, "DEV_MCAN17_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN17_MCANSS_CCLK_CLK"},
	{153, 5, "DEV_MCAN17_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN17_MCANSS_CCLK_CLK"},
	{153, 6, "DEV_MCAN17_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN17_MCANSS_CCLK_CLK"},
	{160, 0, "DEV_MCAN2_MCANSS_HCLK_CLK", "Input clock"},
	{160, 2, "DEV_MCAN2_MCANSS_CCLK_CLK", "Input muxed clock"},
	{160, 3, "DEV_MCAN2_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN2_MCANSS_CCLK_CLK"},
	{160, 4, "DEV_MCAN2_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN2_MCANSS_CCLK_CLK"},
	{160, 5, "DEV_MCAN2_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN2_MCANSS_CCLK_CLK"},
	{160, 6, "DEV_MCAN2_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN2_MCANSS_CCLK_CLK"},
	{161, 0, "DEV_MCAN3_MCANSS_HCLK_CLK", "Input clock"},
	{161, 2, "DEV_MCAN3_MCANSS_CCLK_CLK", "Input muxed clock"},
	{161, 3, "DEV_MCAN3_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN3_MCANSS_CCLK_CLK"},
	{161, 4, "DEV_MCAN3_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN3_MCANSS_CCLK_CLK"},
	{161, 5, "DEV_MCAN3_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN3_MCANSS_CCLK_CLK"},
	{161, 6, "DEV_MCAN3_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN3_MCANSS_CCLK_CLK"},
	{162, 0, "DEV_MCAN4_MCANSS_HCLK_CLK", "Input clock"},
	{162, 2, "DEV_MCAN4_MCANSS_CCLK_CLK", "Input muxed clock"},
	{162, 3, "DEV_MCAN4_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN4_MCANSS_CCLK_CLK"},
	{162, 4, "DEV_MCAN4_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN4_MCANSS_CCLK_CLK"},
	{162, 5, "DEV_MCAN4_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN4_MCANSS_CCLK_CLK"},
	{162, 6, "DEV_MCAN4_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN4_MCANSS_CCLK_CLK"},
	{163, 0, "DEV_MCAN5_MCANSS_HCLK_CLK", "Input clock"},
	{163, 2, "DEV_MCAN5_MCANSS_CCLK_CLK", "Input muxed clock"},
	{163, 3, "DEV_MCAN5_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN5_MCANSS_CCLK_CLK"},
	{163, 4, "DEV_MCAN5_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN5_MCANSS_CCLK_CLK"},
	{163, 5, "DEV_MCAN5_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN5_MCANSS_CCLK_CLK"},
	{163, 6, "DEV_MCAN5_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN5_MCANSS_CCLK_CLK"},
	{164, 0, "DEV_MCAN6_MCANSS_HCLK_CLK", "Input clock"},
	{164, 2, "DEV_MCAN6_MCANSS_CCLK_CLK", "Input muxed clock"},
	{164, 3, "DEV_MCAN6_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN6_MCANSS_CCLK_CLK"},
	{164, 4, "DEV_MCAN6_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN6_MCANSS_CCLK_CLK"},
	{164, 5, "DEV_MCAN6_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN6_MCANSS_CCLK_CLK"},
	{164, 6, "DEV_MCAN6_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN6_MCANSS_CCLK_CLK"},
	{165, 0, "DEV_MCAN7_MCANSS_HCLK_CLK", "Input clock"},
	{165, 2, "DEV_MCAN7_MCANSS_CCLK_CLK", "Input muxed clock"},
	{165, 3, "DEV_MCAN7_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN7_MCANSS_CCLK_CLK"},
	{165, 4, "DEV_MCAN7_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN7_MCANSS_CCLK_CLK"},
	{165, 5, "DEV_MCAN7_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN7_MCANSS_CCLK_CLK"},
	{165, 6, "DEV_MCAN7_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN7_MCANSS_CCLK_CLK"},
	{166, 0, "DEV_MCAN8_MCANSS_HCLK_CLK", "Input clock"},
	{166, 2, "DEV_MCAN8_MCANSS_CCLK_CLK", "Input muxed clock"},
	{166, 3, "DEV_MCAN8_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN8_MCANSS_CCLK_CLK"},
	{166, 4, "DEV_MCAN8_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN8_MCANSS_CCLK_CLK"},
	{166, 5, "DEV_MCAN8_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN8_MCANSS_CCLK_CLK"},
	{166, 6, "DEV_MCAN8_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN8_MCANSS_CCLK_CLK"},
	{167, 0, "DEV_MCAN9_MCANSS_HCLK_CLK", "Input clock"},
	{167, 2, "DEV_MCAN9_MCANSS_CCLK_CLK", "Input muxed clock"},
	{167, 3, "DEV_MCAN9_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCAN9_MCANSS_CCLK_CLK"},
	{167, 4, "DEV_MCAN9_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN9_MCANSS_CCLK_CLK"},
	{167, 5, "DEV_MCAN9_MCANSS_CCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCAN9_MCANSS_CCLK_CLK"},
	{167, 6, "DEV_MCAN9_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN9_MCANSS_CCLK_CLK"},
	{174, 0, "DEV_MCASP0_MCASP_AHCLKX_POUT", "Output clock"},
	{174, 2, "DEV_MCASP0_MCASP_AHCLKR_PIN", "Input muxed clock"},
	{174, 3, "DEV_MCASP0_MCASP_AHCLKR_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKR_PIN"},
	{174, 4, "DEV_MCASP0_MCASP_AHCLKR_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKR_PIN"},
	{174, 5, "DEV_MCASP0_MCASP_AHCLKR_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKR_PIN"},
	{174, 6, "DEV_MCASP0_MCASP_AHCLKR_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKR_PIN"},
	{174, 11, "DEV_MCASP0_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKR_PIN"},
	{174, 12, "DEV_MCASP0_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKR_PIN"},
	{174, 13, "DEV_MCASP0_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKR_PIN"},
	{174, 14, "DEV_MCASP0_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKR_PIN"},
	{174, 19, "DEV_MCASP0_MCASP_ACLKR_PIN", "Input clock"},
	{174, 21, "DEV_MCASP0_MCASP_AHCLKX_PIN", "Input muxed clock"},
	{174, 22, "DEV_MCASP0_MCASP_AHCLKX_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKX_PIN"},
	{174, 23, "DEV_MCASP0_MCASP_AHCLKX_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKX_PIN"},
	{174, 24, "DEV_MCASP0_MCASP_AHCLKX_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKX_PIN"},
	{174, 25, "DEV_MCASP0_MCASP_AHCLKX_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKX_PIN"},
	{174, 30, "DEV_MCASP0_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKX_PIN"},
	{174, 31, "DEV_MCASP0_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKX_PIN"},
	{174, 32, "DEV_MCASP0_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKX_PIN"},
	{174, 33, "DEV_MCASP0_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP0_MCASP_AHCLKX_PIN"},
	{174, 38, "DEV_MCASP0_MCASP_AHCLKR_POUT", "Output clock"},
	{174, 39, "DEV_MCASP0_MCASP_ACLKX_PIN", "Input clock"},
	{174, 40, "DEV_MCASP0_AUX_CLK", "Input muxed clock"},
	{174, 41, "DEV_MCASP0_AUX_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT0_CLK", "Parent input clock option to DEV_MCASP0_AUX_CLK"},
	{174, 42, "DEV_MCASP0_AUX_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCASP0_AUX_CLK"},
	{174, 45, "DEV_MCASP0_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP0_AUX_CLK"},
	{174, 46, "DEV_MCASP0_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP0_AUX_CLK"},
	{174, 47, "DEV_MCASP0_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP0_AUX_CLK"},
	{174, 48, "DEV_MCASP0_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP0_AUX_CLK"},
	{174, 49, "DEV_MCASP0_VBUSP_CLK", "Input clock"},
	{174, 50, "DEV_MCASP0_MCASP_ACLKR_POUT", "Output clock"},
	{174, 51, "DEV_MCASP0_MCASP_ACLKX_POUT", "Output clock"},
	{175, 0, "DEV_MCASP1_MCASP_AHCLKX_POUT", "Output clock"},
	{175, 2, "DEV_MCASP1_MCASP_AHCLKR_PIN", "Input muxed clock"},
	{175, 3, "DEV_MCASP1_MCASP_AHCLKR_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKR_PIN"},
	{175, 4, "DEV_MCASP1_MCASP_AHCLKR_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKR_PIN"},
	{175, 5, "DEV_MCASP1_MCASP_AHCLKR_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKR_PIN"},
	{175, 6, "DEV_MCASP1_MCASP_AHCLKR_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKR_PIN"},
	{175, 11, "DEV_MCASP1_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKR_PIN"},
	{175, 12, "DEV_MCASP1_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKR_PIN"},
	{175, 13, "DEV_MCASP1_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKR_PIN"},
	{175, 14, "DEV_MCASP1_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKR_PIN"},
	{175, 19, "DEV_MCASP1_MCASP_ACLKR_PIN", "Input clock"},
	{175, 21, "DEV_MCASP1_MCASP_AHCLKX_PIN", "Input muxed clock"},
	{175, 22, "DEV_MCASP1_MCASP_AHCLKX_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKX_PIN"},
	{175, 23, "DEV_MCASP1_MCASP_AHCLKX_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKX_PIN"},
	{175, 24, "DEV_MCASP1_MCASP_AHCLKX_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKX_PIN"},
	{175, 25, "DEV_MCASP1_MCASP_AHCLKX_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKX_PIN"},
	{175, 30, "DEV_MCASP1_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKX_PIN"},
	{175, 31, "DEV_MCASP1_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKX_PIN"},
	{175, 32, "DEV_MCASP1_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKX_PIN"},
	{175, 33, "DEV_MCASP1_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP1_MCASP_AHCLKX_PIN"},
	{175, 38, "DEV_MCASP1_MCASP_AHCLKR_POUT", "Output clock"},
	{175, 39, "DEV_MCASP1_MCASP_ACLKX_PIN", "Input clock"},
	{175, 40, "DEV_MCASP1_AUX_CLK", "Input muxed clock"},
	{175, 41, "DEV_MCASP1_AUX_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT0_CLK", "Parent input clock option to DEV_MCASP1_AUX_CLK"},
	{175, 42, "DEV_MCASP1_AUX_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCASP1_AUX_CLK"},
	{175, 45, "DEV_MCASP1_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP1_AUX_CLK"},
	{175, 46, "DEV_MCASP1_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP1_AUX_CLK"},
	{175, 47, "DEV_MCASP1_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP1_AUX_CLK"},
	{175, 48, "DEV_MCASP1_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP1_AUX_CLK"},
	{175, 49, "DEV_MCASP1_VBUSP_CLK", "Input clock"},
	{175, 50, "DEV_MCASP1_MCASP_ACLKR_POUT", "Output clock"},
	{175, 51, "DEV_MCASP1_MCASP_ACLKX_POUT", "Output clock"},
	{176, 0, "DEV_MCASP2_MCASP_AHCLKX_POUT", "Output clock"},
	{176, 2, "DEV_MCASP2_MCASP_AHCLKR_PIN", "Input muxed clock"},
	{176, 3, "DEV_MCASP2_MCASP_AHCLKR_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKR_PIN"},
	{176, 4, "DEV_MCASP2_MCASP_AHCLKR_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKR_PIN"},
	{176, 5, "DEV_MCASP2_MCASP_AHCLKR_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKR_PIN"},
	{176, 6, "DEV_MCASP2_MCASP_AHCLKR_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKR_PIN"},
	{176, 11, "DEV_MCASP2_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKR_PIN"},
	{176, 12, "DEV_MCASP2_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKR_PIN"},
	{176, 13, "DEV_MCASP2_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKR_PIN"},
	{176, 14, "DEV_MCASP2_MCASP_AHCLKR_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKR_PIN"},
	{176, 19, "DEV_MCASP2_MCASP_ACLKR_PIN", "Input clock"},
	{176, 21, "DEV_MCASP2_MCASP_AHCLKX_PIN", "Input muxed clock"},
	{176, 22, "DEV_MCASP2_MCASP_AHCLKX_PIN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKX_PIN"},
	{176, 23, "DEV_MCASP2_MCASP_AHCLKX_PIN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKX_PIN"},
	{176, 24, "DEV_MCASP2_MCASP_AHCLKX_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKX_PIN"},
	{176, 25, "DEV_MCASP2_MCASP_AHCLKX_PIN_PARENT_BOARD_0_AUDIO_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKX_PIN"},
	{176, 30, "DEV_MCASP2_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKX_PIN"},
	{176, 31, "DEV_MCASP2_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKX_PIN"},
	{176, 32, "DEV_MCASP2_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKX_PIN"},
	{176, 33, "DEV_MCASP2_MCASP_AHCLKX_PIN_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP2_MCASP_AHCLKX_PIN"},
	{176, 38, "DEV_MCASP2_MCASP_AHCLKR_POUT", "Output clock"},
	{176, 39, "DEV_MCASP2_MCASP_ACLKX_PIN", "Input clock"},
	{176, 40, "DEV_MCASP2_AUX_CLK", "Input muxed clock"},
	{176, 41, "DEV_MCASP2_AUX_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT0_CLK", "Parent input clock option to DEV_MCASP2_AUX_CLK"},
	{176, 42, "DEV_MCASP2_AUX_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCASP2_AUX_CLK"},
	{176, 45, "DEV_MCASP2_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT", "Parent input clock option to DEV_MCASP2_AUX_CLK"},
	{176, 46, "DEV_MCASP2_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_1", "Parent input clock option to DEV_MCASP2_AUX_CLK"},
	{176, 47, "DEV_MCASP2_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_2", "Parent input clock option to DEV_MCASP2_AUX_CLK"},
	{176, 48, "DEV_MCASP2_AUX_CLK_PARENT_ATL_MAIN_0_ATL_IO_PORT_ATCLK_OUT_3", "Parent input clock option to DEV_MCASP2_AUX_CLK"},
	{176, 49, "DEV_MCASP2_VBUSP_CLK", "Input clock"},
	{176, 50, "DEV_MCASP2_MCASP_ACLKR_POUT", "Output clock"},
	{176, 51, "DEV_MCASP2_MCASP_ACLKX_POUT", "Output clock"},
	{266, 3, "DEV_MCSPI0_VBUSP_CLK", "Input clock"},
	{266, 4, "DEV_MCSPI0_CLKSPIREF_CLK", "Input clock"},
	{266, 5, "DEV_MCSPI0_IO_CLKSPIO_CLK", "Output clock"},
	{267, 3, "DEV_MCSPI1_VBUSP_CLK", "Input clock"},
	{267, 4, "DEV_MCSPI1_CLKSPIREF_CLK", "Input clock"},
	{267, 5, "DEV_MCSPI1_IO_CLKSPIO_CLK", "Output clock"},
	{268, 3, "DEV_MCSPI2_VBUSP_CLK", "Input clock"},
	{268, 4, "DEV_MCSPI2_CLKSPIREF_CLK", "Input clock"},
	{268, 5, "DEV_MCSPI2_IO_CLKSPIO_CLK", "Output clock"},
	{269, 0, "DEV_MCSPI3_IO_CLKSPII_CLK", "Input muxed clock"},
	{269, 1, "DEV_MCSPI3_IO_CLKSPII_CLK_PARENT_SPI_MAIN_3_IO_CLKSPIO_CLK", "Parent input clock option to DEV_MCSPI3_IO_CLKSPII_CLK"},
	{269, 3, "DEV_MCSPI3_VBUSP_CLK", "Input clock"},
	{269, 4, "DEV_MCSPI3_CLKSPIREF_CLK", "Input clock"},
	{269, 5, "DEV_MCSPI3_IO_CLKSPIO_CLK", "Output clock"},
	{270, 0, "DEV_MCSPI4_IO_CLKSPII_CLK", "Input clock"},
	{270, 1, "DEV_MCSPI4_VBUSP_CLK", "Input clock"},
	{270, 2, "DEV_MCSPI4_CLKSPIREF_CLK", "Input clock"},
	{270, 3, "DEV_MCSPI4_IO_CLKSPIO_CLK", "Output clock"},
	{271, 3, "DEV_MCSPI5_VBUSP_CLK", "Input clock"},
	{271, 4, "DEV_MCSPI5_CLKSPIREF_CLK", "Input clock"},
	{271, 5, "DEV_MCSPI5_IO_CLKSPIO_CLK", "Output clock"},
	{272, 3, "DEV_MCSPI6_VBUSP_CLK", "Input clock"},
	{272, 4, "DEV_MCSPI6_CLKSPIREF_CLK", "Input clock"},
	{272, 5, "DEV_MCSPI6_IO_CLKSPIO_CLK", "Output clock"},
	{273, 3, "DEV_MCSPI7_VBUSP_CLK", "Input clock"},
	{273, 4, "DEV_MCSPI7_CLKSPIREF_CLK", "Input clock"},
	{273, 5, "DEV_MCSPI7_IO_CLKSPIO_CLK", "Output clock"},
	{0, 0, "DEV_MCU_ADC0_SYS_CLK", "Input clock"},
	{0, 1, "DEV_MCU_ADC0_ADC_CLK", "Input muxed clock"},
	{0, 2, "DEV_MCU_ADC0_ADC_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_ADC0_ADC_CLK"},
	{0, 3, "DEV_MCU_ADC0_ADC_CLK_PARENT_HSDIV4_16FFT_MCU_1_HSDIVOUT1_CLK", "Parent input clock option to DEV_MCU_ADC0_ADC_CLK"},
	{0, 4, "DEV_MCU_ADC0_ADC_CLK_PARENT_HSDIV1_16FFT_MCU_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_MCU_ADC0_ADC_CLK"},
	{0, 5, "DEV_MCU_ADC0_ADC_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_ADC0_ADC_CLK"},
	{0, 6, "DEV_MCU_ADC0_VBUS_CLK", "Input clock"},
	{1, 0, "DEV_MCU_ADC1_SYS_CLK", "Input clock"},
	{1, 1, "DEV_MCU_ADC1_ADC_CLK", "Input muxed clock"},
	{1, 2, "DEV_MCU_ADC1_ADC_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_ADC1_ADC_CLK"},
	{1, 3, "DEV_MCU_ADC1_ADC_CLK_PARENT_HSDIV4_16FFT_MCU_1_HSDIVOUT1_CLK", "Parent input clock option to DEV_MCU_ADC1_ADC_CLK"},
	{1, 4, "DEV_MCU_ADC1_ADC_CLK_PARENT_HSDIV1_16FFT_MCU_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_MCU_ADC1_ADC_CLK"},
	{1, 5, "DEV_MCU_ADC1_ADC_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_ADC1_ADC_CLK"},
	{1, 6, "DEV_MCU_ADC1_VBUS_CLK", "Input clock"},
	{18, 0, "DEV_MCU_CPSW0_MDIO_MDCLK_O", "Output clock"},
	{18, 2, "DEV_MCU_CPSW0_CPTS_RFT_CLK", "Input muxed clock"},
	{18, 3, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT1_CLK", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{18, 4, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_POSTDIV2_16FFT_MAIN_0_HSDIVOUT6_CLK", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{18, 5, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_BOARD_0_MCU_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{18, 6, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{18, 7, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{18, 8, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{18, 9, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_WIZ16B8M4CT2_MAIN_1_IP2_LN0_TXMCLK", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{18, 10, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_WIZ16B8M4CT2_MAIN_1_IP2_LN1_TXMCLK", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{18, 11, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_WIZ16B8M4CT2_MAIN_1_IP2_LN2_TXMCLK", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{18, 12, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_WIZ16B8M4CT2_MAIN_1_IP2_LN3_TXMCLK", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{18, 17, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT1_CLK", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{18, 18, "DEV_MCU_CPSW0_CPTS_RFT_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK2", "Parent input clock option to DEV_MCU_CPSW0_CPTS_RFT_CLK"},
	{18, 20, "DEV_MCU_CPSW0_GMII1_MR_CLK", "Input clock"},
	{18, 21, "DEV_MCU_CPSW0_CPPI_CLK_CLK", "Input clock"},
	{18, 22, "DEV_MCU_CPSW0_CPTS_GENF0", "Output clock"},
	{18, 24, "DEV_MCU_CPSW0_GMII_RFT_CLK", "Input clock"},
	{18, 27, "DEV_MCU_CPSW0_GMII1_MT_CLK", "Input clock"},
	{18, 28, "DEV_MCU_CPSW0_RGMII1_TXC_O", "Output clock"},
	{18, 29, "DEV_MCU_CPSW0_RMII_MHZ_50_CLK", "Input clock"},
	{18, 30, "DEV_MCU_CPSW0_RGMII_MHZ_5_CLK", "Input clock"},
	{18, 31, "DEV_MCU_CPSW0_RGMII1_RXC_I", "Input clock"},
	{18, 32, "DEV_MCU_CPSW0_RGMII_MHZ_250_CLK", "Input clock"},
	{18, 33, "DEV_MCU_CPSW0_RGMII_MHZ_50_CLK", "Input clock"},
	{24, 0, "DEV_MCU_CPT2_AGGR0_VCLK_CLK", "Input clock"},
	{44, 0, "DEV_MCU_DCC0_DCC_INPUT10_CLK", "Input clock"},
	{44, 1, "DEV_MCU_DCC0_DCC_INPUT01_CLK", "Input clock"},
	{44, 2, "DEV_MCU_DCC0_DCC_CLKSRC2_CLK", "Input clock"},
	{44, 3, "DEV_MCU_DCC0_DCC_CLKSRC7_CLK", "Input clock"},
	{44, 4, "DEV_MCU_DCC0_DCC_CLKSRC0_CLK", "Input clock"},
	{44, 5, "DEV_MCU_DCC0_VBUS_CLK", "Input clock"},
	{44, 6, "DEV_MCU_DCC0_DCC_CLKSRC4_CLK", "Input clock"},
	{44, 7, "DEV_MCU_DCC0_DCC_CLKSRC1_CLK", "Input clock"},
	{44, 8, "DEV_MCU_DCC0_DCC_CLKSRC3_CLK", "Input clock"},
	{44, 9, "DEV_MCU_DCC0_DCC_INPUT00_CLK", "Input clock"},
	{44, 10, "DEV_MCU_DCC0_DCC_CLKSRC5_CLK", "Input clock"},
	{44, 11, "DEV_MCU_DCC0_DCC_CLKSRC6_CLK", "Input clock"},
	{44, 12, "DEV_MCU_DCC0_DCC_INPUT02_CLK", "Input clock"},
	{45, 0, "DEV_MCU_DCC1_DCC_INPUT10_CLK", "Input clock"},
	{45, 1, "DEV_MCU_DCC1_DCC_INPUT01_CLK", "Input clock"},
	{45, 2, "DEV_MCU_DCC1_DCC_CLKSRC2_CLK", "Input clock"},
	{45, 3, "DEV_MCU_DCC1_DCC_CLKSRC7_CLK", "Input clock"},
	{45, 4, "DEV_MCU_DCC1_DCC_CLKSRC0_CLK", "Input clock"},
	{45, 5, "DEV_MCU_DCC1_VBUS_CLK", "Input clock"},
	{45, 6, "DEV_MCU_DCC1_DCC_CLKSRC4_CLK", "Input clock"},
	{45, 7, "DEV_MCU_DCC1_DCC_CLKSRC1_CLK", "Input clock"},
	{45, 8, "DEV_MCU_DCC1_DCC_CLKSRC3_CLK", "Input clock"},
	{45, 9, "DEV_MCU_DCC1_DCC_INPUT00_CLK", "Input clock"},
	{45, 10, "DEV_MCU_DCC1_DCC_CLKSRC5_CLK", "Input clock"},
	{45, 11, "DEV_MCU_DCC1_DCC_CLKSRC6_CLK", "Input clock"},
	{45, 12, "DEV_MCU_DCC1_DCC_INPUT02_CLK", "Input clock"},
	{46, 0, "DEV_MCU_DCC2_DCC_INPUT10_CLK", "Input clock"},
	{46, 1, "DEV_MCU_DCC2_DCC_INPUT01_CLK", "Input clock"},
	{46, 3, "DEV_MCU_DCC2_DCC_CLKSRC7_CLK", "Input clock"},
	{46, 4, "DEV_MCU_DCC2_DCC_CLKSRC0_CLK", "Input clock"},
	{46, 5, "DEV_MCU_DCC2_VBUS_CLK", "Input clock"},
	{46, 7, "DEV_MCU_DCC2_DCC_CLKSRC1_CLK", "Input clock"},
	{46, 8, "DEV_MCU_DCC2_DCC_CLKSRC3_CLK", "Input clock"},
	{46, 9, "DEV_MCU_DCC2_DCC_INPUT00_CLK", "Input clock"},
	{46, 11, "DEV_MCU_DCC2_DCC_CLKSRC6_CLK", "Input clock"},
	{46, 12, "DEV_MCU_DCC2_DCC_INPUT02_CLK", "Input clock"},
	{98, 0, "DEV_MCU_ESM0_CLK", "Input clock"},
	{101, 0, "DEV_MCU_FSS0_FSAS_0_GCLK", "Input clock"},
	{102, 0, "DEV_MCU_FSS0_HYPERBUS1P0_0_HPB_OUT_CLK_N", "Output clock"},
	{102, 1, "DEV_MCU_FSS0_HYPERBUS1P0_0_HPB_CLKX2_INV_CLK", "Input clock"},
	{102, 2, "DEV_MCU_FSS0_HYPERBUS1P0_0_HPB_CLKX1_INV_CLK", "Input clock"},
	{102, 4, "DEV_MCU_FSS0_HYPERBUS1P0_0_CBA_CLK", "Input clock"},
	{102, 5, "DEV_MCU_FSS0_HYPERBUS1P0_0_HPB_CLKX2_CLK", "Input clock"},
	{102, 7, "DEV_MCU_FSS0_HYPERBUS1P0_0_HPB_CLKX1_CLK", "Input clock"},
	{102, 10, "DEV_MCU_FSS0_HYPERBUS1P0_0_HPB_OUT_CLK_P", "Output clock"},
	{103, 0, "DEV_MCU_FSS0_OSPI_0_OSPI_RCLK_CLK", "Input muxed clock"},
	{103, 1, "DEV_MCU_FSS0_OSPI_0_OSPI_RCLK_CLK_PARENT_HSDIV4_16FFT_MCU_1_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCU_FSS0_OSPI_0_OSPI_RCLK_CLK"},
	{103, 2, "DEV_MCU_FSS0_OSPI_0_OSPI_RCLK_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT4_CLK", "Parent input clock option to DEV_MCU_FSS0_OSPI_0_OSPI_RCLK_CLK"},
	{103, 3, "DEV_MCU_FSS0_OSPI_0_OSPI_HCLK_CLK", "Input clock"},
	{103, 4, "DEV_MCU_FSS0_OSPI_0_OSPI_DQS_CLK", "Input clock"},
	{103, 5, "DEV_MCU_FSS0_OSPI_0_OSPI_ICLK_CLK", "Input muxed clock"},
	{103, 6, "DEV_MCU_FSS0_OSPI_0_OSPI_ICLK_CLK_PARENT_BOARD_0_MCU_OSPI0_DQS_OUT", "Parent input clock option to DEV_MCU_FSS0_OSPI_0_OSPI_ICLK_CLK"},
	{103, 7, "DEV_MCU_FSS0_OSPI_0_OSPI_ICLK_CLK_PARENT_FSS_MCU_0_OSPI_0_OSPI_OCLK_CLK", "Parent input clock option to DEV_MCU_FSS0_OSPI_0_OSPI_ICLK_CLK"},
	{103, 8, "DEV_MCU_FSS0_OSPI_0_OSPI_PCLK_CLK", "Input clock"},
	{103, 9, "DEV_MCU_FSS0_OSPI_0_OSPI_OCLK_CLK", "Output clock"},
	{104, 0, "DEV_MCU_FSS0_OSPI_1_OSPI_RCLK_CLK", "Input clock"},
	{104, 1, "DEV_MCU_FSS0_OSPI_1_OSPI_HCLK_CLK", "Input clock"},
	{104, 7, "DEV_MCU_FSS0_OSPI_1_OSPI_PCLK_CLK", "Input clock"},
	{194, 0, "DEV_MCU_I2C0_PISCL", "Input clock"},
	{194, 1, "DEV_MCU_I2C0_PISYS_CLK", "Input clock"},
	{194, 2, "DEV_MCU_I2C0_CLK", "Input clock"},
	{195, 0, "DEV_MCU_I2C1_PISCL", "Input clock"},
	{195, 1, "DEV_MCU_I2C1_PISYS_CLK", "Input clock"},
	{195, 2, "DEV_MCU_I2C1_CLK", "Input clock"},
	{195, 3, "DEV_MCU_I2C1_PORSCL", "Output clock"},
	{117, 0, "DEV_MCU_I3C0_I3C_SCL_DI", "Input clock"},
	{117, 1, "DEV_MCU_I3C0_I3C_SCL_DO", "Output clock"},
	{117, 2, "DEV_MCU_I3C0_I3C_PCLK_CLK", "Input clock"},
	{117, 4, "DEV_MCU_I3C0_I3C_SCLK_CLK", "Input clock"},
	{118, 2, "DEV_MCU_I3C1_I3C_PCLK_CLK", "Input clock"},
	{118, 4, "DEV_MCU_I3C1_I3C_SCLK_CLK", "Input clock"},
	{172, 0, "DEV_MCU_MCAN0_MCANSS_HCLK_CLK", "Input clock"},
	{172, 2, "DEV_MCU_MCAN0_MCANSS_CCLK_CLK", "Input muxed clock"},
	{172, 3, "DEV_MCU_MCAN0_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT3_CLK", "Parent input clock option to DEV_MCU_MCAN0_MCANSS_CCLK_CLK"},
	{172, 4, "DEV_MCU_MCAN0_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_MCAN0_MCANSS_CCLK_CLK"},
	{172, 5, "DEV_MCU_MCAN0_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MCU_1_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCU_MCAN0_MCANSS_CCLK_CLK"},
	{172, 6, "DEV_MCU_MCAN0_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_MCAN0_MCANSS_CCLK_CLK"},
	{173, 0, "DEV_MCU_MCAN1_MCANSS_HCLK_CLK", "Input clock"},
	{173, 2, "DEV_MCU_MCAN1_MCANSS_CCLK_CLK", "Input muxed clock"},
	{173, 3, "DEV_MCU_MCAN1_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT3_CLK", "Parent input clock option to DEV_MCU_MCAN1_MCANSS_CCLK_CLK"},
	{173, 4, "DEV_MCU_MCAN1_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_MCAN1_MCANSS_CCLK_CLK"},
	{173, 5, "DEV_MCU_MCAN1_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MCU_1_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCU_MCAN1_MCANSS_CCLK_CLK"},
	{173, 6, "DEV_MCU_MCAN1_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_MCAN1_MCANSS_CCLK_CLK"},
	{274, 3, "DEV_MCU_MCSPI0_VBUSP_CLK", "Input clock"},
	{274, 4, "DEV_MCU_MCSPI0_CLKSPIREF_CLK", "Input clock"},
	{274, 5, "DEV_MCU_MCSPI0_IO_CLKSPIO_CLK", "Output clock"},
	{275, 0, "DEV_MCU_MCSPI1_IO_CLKSPII_CLK", "Input muxed clock"},
	{275, 1, "DEV_MCU_MCSPI1_IO_CLKSPII_CLK_PARENT_SPI_MAIN_3_IO_CLKSPIO_CLK", "Parent input clock option to DEV_MCU_MCSPI1_IO_CLKSPII_CLK"},
	{275, 3, "DEV_MCU_MCSPI1_VBUSP_CLK", "Input clock"},
	{275, 4, "DEV_MCU_MCSPI1_CLKSPIREF_CLK", "Input clock"},
	{275, 5, "DEV_MCU_MCSPI1_IO_CLKSPIO_CLK", "Output clock"},
	{276, 0, "DEV_MCU_MCSPI2_IO_CLKSPII_CLK", "Input clock"},
	{276, 1, "DEV_MCU_MCSPI2_VBUSP_CLK", "Input clock"},
	{276, 2, "DEV_MCU_MCSPI2_CLKSPIREF_CLK", "Input clock"},
	{276, 3, "DEV_MCU_MCSPI2_IO_CLKSPIO_CLK", "Output clock"},
	{237, 0, "DEV_MCU_NAVSS0_INTR_0_INTR_CLK", "Input clock"},
	{238, 0, "DEV_MCU_NAVSS0_MCRC_0_CLK", "Input clock"},
	{302, 0, "DEV_MCU_NAVSS0_MODSS_VD2CLK", "Input clock"},
	{234, 0, "DEV_MCU_NAVSS0_PROXY0_CLK_CLK", "Input clock"},
	{235, 0, "DEV_MCU_NAVSS0_RINGACC0_SYS_CLK", "Input clock"},
	{236, 0, "DEV_MCU_NAVSS0_UDMAP_0_SYS_CLK", "Input clock"},
	{303, 0, "DEV_MCU_NAVSS0_UDMASS_VD2CLK", "Input clock"},
	{233, 0, "DEV_MCU_NAVSS0_UDMASS_INTA_0_SYS_CLK", "Input clock"},
	{142, 1, "DEV_MCU_PBIST0_CLK7_CLK", "Input clock"},
	{142, 2, "DEV_MCU_PBIST0_CLK3_CLK", "Input clock"},
	{142, 3, "DEV_MCU_PBIST0_CLK5_CLK", "Input clock"},
	{142, 4, "DEV_MCU_PBIST0_CLK1_CLK", "Input clock"},
	{142, 5, "DEV_MCU_PBIST0_CLK8_CLK", "Input clock"},
	{142, 6, "DEV_MCU_PBIST0_CLK6_CLK", "Input clock"},
	{142, 8, "DEV_MCU_PBIST0_CLK4_CLK", "Input clock"},
	{142, 9, "DEV_MCU_PBIST0_CLK2_CLK", "Input clock"},
	{143, 1, "DEV_MCU_PBIST1_CLK7_CLK", "Input clock"},
	{143, 2, "DEV_MCU_PBIST1_CLK3_CLK", "Input clock"},
	{143, 3, "DEV_MCU_PBIST1_CLK5_CLK", "Input clock"},
	{143, 4, "DEV_MCU_PBIST1_CLK1_CLK", "Input clock"},
	{143, 5, "DEV_MCU_PBIST1_CLK8_CLK", "Input clock"},
	{143, 6, "DEV_MCU_PBIST1_CLK6_CLK", "Input clock"},
	{143, 8, "DEV_MCU_PBIST1_CLK4_CLK", "Input clock"},
	{143, 9, "DEV_MCU_PBIST1_CLK2_CLK", "Input clock"},
	{144, 1, "DEV_MCU_PBIST2_CLK7_CLK", "Input clock"},
	{144, 2, "DEV_MCU_PBIST2_CLK3_CLK", "Input clock"},
	{144, 3, "DEV_MCU_PBIST2_CLK5_CLK", "Input clock"},
	{144, 4, "DEV_MCU_PBIST2_CLK1_CLK", "Input clock"},
	{144, 5, "DEV_MCU_PBIST2_CLK8_CLK", "Input clock"},
	{144, 6, "DEV_MCU_PBIST2_CLK6_CLK", "Input clock"},
	{144, 8, "DEV_MCU_PBIST2_CLK4_CLK", "Input clock"},
	{144, 9, "DEV_MCU_PBIST2_CLK2_CLK", "Input clock"},
	{250, 0, "DEV_MCU_R5FSS0_CORE0_CPU_CLK", "Input muxed clock"},
	{250, 1, "DEV_MCU_R5FSS0_CORE0_CPU_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_MCU_R5FSS0_CORE0_CPU_CLK"},
	{250, 2, "DEV_MCU_R5FSS0_CORE0_CPU_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK3", "Parent input clock option to DEV_MCU_R5FSS0_CORE0_CPU_CLK"},
	{250, 3, "DEV_MCU_R5FSS0_CORE0_INTERFACE_CLK", "Input clock"},
	{250, 4, "DEV_MCU_R5FSS0_CORE0_INTERFACE_PHASE", "Input clock"},
	{251, 0, "DEV_MCU_R5FSS0_CORE1_CPU_CLK", "Input muxed clock"},
	{251, 1, "DEV_MCU_R5FSS0_CORE1_CPU_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_MCU_R5FSS0_CORE1_CPU_CLK"},
	{251, 2, "DEV_MCU_R5FSS0_CORE1_CPU_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK3", "Parent input clock option to DEV_MCU_R5FSS0_CORE1_CPU_CLK"},
	{251, 3, "DEV_MCU_R5FSS0_CORE1_INTERFACE_CLK", "Input clock"},
	{251, 4, "DEV_MCU_R5FSS0_CORE1_INTERFACE_PHASE", "Input clock"},
	{262, 0, "DEV_MCU_RTI0_VBUSP_CLK", "Input clock"},
	{262, 1, "DEV_MCU_RTI0_RTI_CLK", "Input muxed clock"},
	{262, 2, "DEV_MCU_RTI0_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_RTI0_RTI_CLK"},
	{262, 3, "DEV_MCU_RTI0_RTI_CLK_PARENT_BOARD_0_WKUP_LF_CLKIN_OUT", "Parent input clock option to DEV_MCU_RTI0_RTI_CLK"},
	{262, 4, "DEV_MCU_RTI0_RTI_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_MCU_RTI0_RTI_CLK"},
	{262, 5, "DEV_MCU_RTI0_RTI_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_MCU_RTI0_RTI_CLK"},
	{263, 0, "DEV_MCU_RTI1_VBUSP_CLK", "Input clock"},
	{263, 1, "DEV_MCU_RTI1_RTI_CLK", "Input muxed clock"},
	{263, 2, "DEV_MCU_RTI1_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_RTI1_RTI_CLK"},
	{263, 3, "DEV_MCU_RTI1_RTI_CLK_PARENT_BOARD_0_WKUP_LF_CLKIN_OUT", "Parent input clock option to DEV_MCU_RTI1_RTI_CLK"},
	{263, 4, "DEV_MCU_RTI1_RTI_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_MCU_RTI1_RTI_CLK"},
	{263, 5, "DEV_MCU_RTI1_RTI_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_MCU_RTI1_RTI_CLK"},
	{265, 0, "DEV_MCU_SA2_UL0_X2_CLK", "Input clock"},
	{265, 1, "DEV_MCU_SA2_UL0_PKA_IN_CLK", "Input clock"},
	{265, 2, "DEV_MCU_SA2_UL0_X1_CLK", "Input clock"},
	{35, 0, "DEV_MCU_TIMER0_TIMER_HCLK_CLK", "Input clock"},
	{35, 1, "DEV_MCU_TIMER0_TIMER_TCLK_CLK", "Input muxed clock"},
	{35, 2, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 3, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK16", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 4, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 5, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 6, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 7, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_BOARD_0_WKUP_LF_CLKIN_OUT", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 8, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_CPSW_2GUSS_MCU_0_CPTS_GENF0", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 9, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 11, "DEV_MCU_TIMER0_TIMER_PWM", "Output clock"},
	{71, 0, "DEV_MCU_TIMER1_TIMER_HCLK_CLK", "Input clock"},
	{71, 1, "DEV_MCU_TIMER1_TIMER_TCLK_CLK", "Input muxed clock"},
	{71, 2, "DEV_MCU_TIMER1_TIMER_TCLK_CLK_PARENT_MCU_TIMER_CLKSEL_OUT1", "Parent input clock option to DEV_MCU_TIMER1_TIMER_TCLK_CLK"},
	{71, 3, "DEV_MCU_TIMER1_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MCU_0_TIMER_PWM", "Parent input clock option to DEV_MCU_TIMER1_TIMER_TCLK_CLK"},
	{308, 0, "DEV_MCU_TIMER1_CLKSEL_VD_CLK", "Input muxed clock"},
	{308, 1, "DEV_MCU_TIMER1_CLKSEL_VD_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_TIMER1_CLKSEL_VD_CLK"},
	{308, 2, "DEV_MCU_TIMER1_CLKSEL_VD_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK16", "Parent input clock option to DEV_MCU_TIMER1_CLKSEL_VD_CLK"},
	{308, 3, "DEV_MCU_TIMER1_CLKSEL_VD_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_MCU_TIMER1_CLKSEL_VD_CLK"},
	{308, 4, "DEV_MCU_TIMER1_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCU_TIMER1_CLKSEL_VD_CLK"},
	{308, 5, "DEV_MCU_TIMER1_CLKSEL_VD_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_TIMER1_CLKSEL_VD_CLK"},
	{308, 6, "DEV_MCU_TIMER1_CLKSEL_VD_CLK_PARENT_BOARD_0_WKUP_LF_CLKIN_OUT", "Parent input clock option to DEV_MCU_TIMER1_CLKSEL_VD_CLK"},
	{308, 7, "DEV_MCU_TIMER1_CLKSEL_VD_CLK_PARENT_CPSW_2GUSS_MCU_0_CPTS_GENF0", "Parent input clock option to DEV_MCU_TIMER1_CLKSEL_VD_CLK"},
	{308, 8, "DEV_MCU_TIMER1_CLKSEL_VD_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_MCU_TIMER1_CLKSEL_VD_CLK"},
	{72, 0, "DEV_MCU_TIMER2_TIMER_HCLK_CLK", "Input clock"},
	{72, 1, "DEV_MCU_TIMER2_TIMER_TCLK_CLK", "Input muxed clock"},
	{72, 2, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{72, 3, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK16", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{72, 4, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{72, 5, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{72, 6, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{72, 7, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_BOARD_0_WKUP_LF_CLKIN_OUT", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{72, 8, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_CPSW_2GUSS_MCU_0_CPTS_GENF0", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{72, 9, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{72, 11, "DEV_MCU_TIMER2_TIMER_PWM", "Output clock"},
	{73, 0, "DEV_MCU_TIMER3_TIMER_HCLK_CLK", "Input clock"},
	{73, 1, "DEV_MCU_TIMER3_TIMER_TCLK_CLK", "Input muxed clock"},
	{73, 2, "DEV_MCU_TIMER3_TIMER_TCLK_CLK_PARENT_MCU_TIMER_CLKSEL_OUT3", "Parent input clock option to DEV_MCU_TIMER3_TIMER_TCLK_CLK"},
	{73, 3, "DEV_MCU_TIMER3_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MCU_2_TIMER_PWM", "Parent input clock option to DEV_MCU_TIMER3_TIMER_TCLK_CLK"},
	{309, 0, "DEV_MCU_TIMER3_CLKSEL_VD_CLK", "Input muxed clock"},
	{309, 1, "DEV_MCU_TIMER3_CLKSEL_VD_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_TIMER3_CLKSEL_VD_CLK"},
	{309, 2, "DEV_MCU_TIMER3_CLKSEL_VD_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK16", "Parent input clock option to DEV_MCU_TIMER3_CLKSEL_VD_CLK"},
	{309, 3, "DEV_MCU_TIMER3_CLKSEL_VD_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_MCU_TIMER3_CLKSEL_VD_CLK"},
	{309, 4, "DEV_MCU_TIMER3_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCU_TIMER3_CLKSEL_VD_CLK"},
	{309, 5, "DEV_MCU_TIMER3_CLKSEL_VD_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_TIMER3_CLKSEL_VD_CLK"},
	{309, 6, "DEV_MCU_TIMER3_CLKSEL_VD_CLK_PARENT_BOARD_0_WKUP_LF_CLKIN_OUT", "Parent input clock option to DEV_MCU_TIMER3_CLKSEL_VD_CLK"},
	{309, 7, "DEV_MCU_TIMER3_CLKSEL_VD_CLK_PARENT_CPSW_2GUSS_MCU_0_CPTS_GENF0", "Parent input clock option to DEV_MCU_TIMER3_CLKSEL_VD_CLK"},
	{309, 8, "DEV_MCU_TIMER3_CLKSEL_VD_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_MCU_TIMER3_CLKSEL_VD_CLK"},
	{74, 0, "DEV_MCU_TIMER4_TIMER_HCLK_CLK", "Input clock"},
	{74, 1, "DEV_MCU_TIMER4_TIMER_TCLK_CLK", "Input muxed clock"},
	{74, 2, "DEV_MCU_TIMER4_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_TIMER4_TIMER_TCLK_CLK"},
	{74, 3, "DEV_MCU_TIMER4_TIMER_TCLK_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK16", "Parent input clock option to DEV_MCU_TIMER4_TIMER_TCLK_CLK"},
	{74, 4, "DEV_MCU_TIMER4_TIMER_TCLK_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_MCU_TIMER4_TIMER_TCLK_CLK"},
	{74, 5, "DEV_MCU_TIMER4_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCU_TIMER4_TIMER_TCLK_CLK"},
	{74, 6, "DEV_MCU_TIMER4_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_TIMER4_TIMER_TCLK_CLK"},
	{74, 7, "DEV_MCU_TIMER4_TIMER_TCLK_CLK_PARENT_BOARD_0_WKUP_LF_CLKIN_OUT", "Parent input clock option to DEV_MCU_TIMER4_TIMER_TCLK_CLK"},
	{74, 8, "DEV_MCU_TIMER4_TIMER_TCLK_CLK_PARENT_CPSW_2GUSS_MCU_0_CPTS_GENF0", "Parent input clock option to DEV_MCU_TIMER4_TIMER_TCLK_CLK"},
	{74, 9, "DEV_MCU_TIMER4_TIMER_TCLK_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_MCU_TIMER4_TIMER_TCLK_CLK"},
	{74, 11, "DEV_MCU_TIMER4_TIMER_PWM", "Output clock"},
	{75, 0, "DEV_MCU_TIMER5_TIMER_HCLK_CLK", "Input clock"},
	{75, 1, "DEV_MCU_TIMER5_TIMER_TCLK_CLK", "Input muxed clock"},
	{75, 2, "DEV_MCU_TIMER5_TIMER_TCLK_CLK_PARENT_MCU_TIMER_CLKSEL_OUT5", "Parent input clock option to DEV_MCU_TIMER5_TIMER_TCLK_CLK"},
	{75, 3, "DEV_MCU_TIMER5_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MCU_4_TIMER_PWM", "Parent input clock option to DEV_MCU_TIMER5_TIMER_TCLK_CLK"},
	{310, 0, "DEV_MCU_TIMER5_CLKSEL_VD_CLK", "Input muxed clock"},
	{310, 1, "DEV_MCU_TIMER5_CLKSEL_VD_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_TIMER5_CLKSEL_VD_CLK"},
	{310, 2, "DEV_MCU_TIMER5_CLKSEL_VD_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK16", "Parent input clock option to DEV_MCU_TIMER5_CLKSEL_VD_CLK"},
	{310, 3, "DEV_MCU_TIMER5_CLKSEL_VD_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_MCU_TIMER5_CLKSEL_VD_CLK"},
	{310, 4, "DEV_MCU_TIMER5_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCU_TIMER5_CLKSEL_VD_CLK"},
	{310, 5, "DEV_MCU_TIMER5_CLKSEL_VD_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_TIMER5_CLKSEL_VD_CLK"},
	{310, 6, "DEV_MCU_TIMER5_CLKSEL_VD_CLK_PARENT_BOARD_0_WKUP_LF_CLKIN_OUT", "Parent input clock option to DEV_MCU_TIMER5_CLKSEL_VD_CLK"},
	{310, 7, "DEV_MCU_TIMER5_CLKSEL_VD_CLK_PARENT_CPSW_2GUSS_MCU_0_CPTS_GENF0", "Parent input clock option to DEV_MCU_TIMER5_CLKSEL_VD_CLK"},
	{310, 8, "DEV_MCU_TIMER5_CLKSEL_VD_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_MCU_TIMER5_CLKSEL_VD_CLK"},
	{76, 0, "DEV_MCU_TIMER6_TIMER_HCLK_CLK", "Input clock"},
	{76, 1, "DEV_MCU_TIMER6_TIMER_TCLK_CLK", "Input muxed clock"},
	{76, 2, "DEV_MCU_TIMER6_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_TIMER6_TIMER_TCLK_CLK"},
	{76, 3, "DEV_MCU_TIMER6_TIMER_TCLK_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK16", "Parent input clock option to DEV_MCU_TIMER6_TIMER_TCLK_CLK"},
	{76, 4, "DEV_MCU_TIMER6_TIMER_TCLK_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_MCU_TIMER6_TIMER_TCLK_CLK"},
	{76, 5, "DEV_MCU_TIMER6_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCU_TIMER6_TIMER_TCLK_CLK"},
	{76, 6, "DEV_MCU_TIMER6_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_TIMER6_TIMER_TCLK_CLK"},
	{76, 7, "DEV_MCU_TIMER6_TIMER_TCLK_CLK_PARENT_BOARD_0_WKUP_LF_CLKIN_OUT", "Parent input clock option to DEV_MCU_TIMER6_TIMER_TCLK_CLK"},
	{76, 8, "DEV_MCU_TIMER6_TIMER_TCLK_CLK_PARENT_CPSW_2GUSS_MCU_0_CPTS_GENF0", "Parent input clock option to DEV_MCU_TIMER6_TIMER_TCLK_CLK"},
	{76, 9, "DEV_MCU_TIMER6_TIMER_TCLK_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_MCU_TIMER6_TIMER_TCLK_CLK"},
	{76, 11, "DEV_MCU_TIMER6_TIMER_PWM", "Output clock"},
	{77, 0, "DEV_MCU_TIMER7_TIMER_HCLK_CLK", "Input clock"},
	{77, 1, "DEV_MCU_TIMER7_TIMER_TCLK_CLK", "Input muxed clock"},
	{77, 2, "DEV_MCU_TIMER7_TIMER_TCLK_CLK_PARENT_MCU_TIMER_CLKSEL_OUT7", "Parent input clock option to DEV_MCU_TIMER7_TIMER_TCLK_CLK"},
	{77, 3, "DEV_MCU_TIMER7_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MCU_6_TIMER_PWM", "Parent input clock option to DEV_MCU_TIMER7_TIMER_TCLK_CLK"},
	{311, 0, "DEV_MCU_TIMER7_CLKSEL_VD_CLK", "Input muxed clock"},
	{311, 1, "DEV_MCU_TIMER7_CLKSEL_VD_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_TIMER7_CLKSEL_VD_CLK"},
	{311, 2, "DEV_MCU_TIMER7_CLKSEL_VD_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK16", "Parent input clock option to DEV_MCU_TIMER7_CLKSEL_VD_CLK"},
	{311, 3, "DEV_MCU_TIMER7_CLKSEL_VD_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_MCU_TIMER7_CLKSEL_VD_CLK"},
	{311, 4, "DEV_MCU_TIMER7_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCU_TIMER7_CLKSEL_VD_CLK"},
	{311, 5, "DEV_MCU_TIMER7_CLKSEL_VD_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_TIMER7_CLKSEL_VD_CLK"},
	{311, 6, "DEV_MCU_TIMER7_CLKSEL_VD_CLK_PARENT_BOARD_0_WKUP_LF_CLKIN_OUT", "Parent input clock option to DEV_MCU_TIMER7_CLKSEL_VD_CLK"},
	{311, 7, "DEV_MCU_TIMER7_CLKSEL_VD_CLK_PARENT_CPSW_2GUSS_MCU_0_CPTS_GENF0", "Parent input clock option to DEV_MCU_TIMER7_CLKSEL_VD_CLK"},
	{311, 8, "DEV_MCU_TIMER7_CLKSEL_VD_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_MCU_TIMER7_CLKSEL_VD_CLK"},
	{78, 0, "DEV_MCU_TIMER8_TIMER_HCLK_CLK", "Input clock"},
	{78, 1, "DEV_MCU_TIMER8_TIMER_TCLK_CLK", "Input muxed clock"},
	{78, 2, "DEV_MCU_TIMER8_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_TIMER8_TIMER_TCLK_CLK"},
	{78, 3, "DEV_MCU_TIMER8_TIMER_TCLK_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK16", "Parent input clock option to DEV_MCU_TIMER8_TIMER_TCLK_CLK"},
	{78, 4, "DEV_MCU_TIMER8_TIMER_TCLK_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_MCU_TIMER8_TIMER_TCLK_CLK"},
	{78, 5, "DEV_MCU_TIMER8_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCU_TIMER8_TIMER_TCLK_CLK"},
	{78, 6, "DEV_MCU_TIMER8_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_TIMER8_TIMER_TCLK_CLK"},
	{78, 7, "DEV_MCU_TIMER8_TIMER_TCLK_CLK_PARENT_BOARD_0_WKUP_LF_CLKIN_OUT", "Parent input clock option to DEV_MCU_TIMER8_TIMER_TCLK_CLK"},
	{78, 8, "DEV_MCU_TIMER8_TIMER_TCLK_CLK_PARENT_CPSW_2GUSS_MCU_0_CPTS_GENF0", "Parent input clock option to DEV_MCU_TIMER8_TIMER_TCLK_CLK"},
	{78, 9, "DEV_MCU_TIMER8_TIMER_TCLK_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_MCU_TIMER8_TIMER_TCLK_CLK"},
	{78, 11, "DEV_MCU_TIMER8_TIMER_PWM", "Output clock"},
	{79, 0, "DEV_MCU_TIMER9_TIMER_HCLK_CLK", "Input clock"},
	{79, 1, "DEV_MCU_TIMER9_TIMER_TCLK_CLK", "Input muxed clock"},
	{79, 2, "DEV_MCU_TIMER9_TIMER_TCLK_CLK_PARENT_MCU_TIMER_CLKSEL_OUT9", "Parent input clock option to DEV_MCU_TIMER9_TIMER_TCLK_CLK"},
	{79, 3, "DEV_MCU_TIMER9_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MCU_8_TIMER_PWM", "Parent input clock option to DEV_MCU_TIMER9_TIMER_TCLK_CLK"},
	{312, 0, "DEV_MCU_TIMER9_CLKSEL_VD_CLK", "Input muxed clock"},
	{312, 1, "DEV_MCU_TIMER9_CLKSEL_VD_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_TIMER9_CLKSEL_VD_CLK"},
	{312, 2, "DEV_MCU_TIMER9_CLKSEL_VD_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK16", "Parent input clock option to DEV_MCU_TIMER9_CLKSEL_VD_CLK"},
	{312, 3, "DEV_MCU_TIMER9_CLKSEL_VD_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_MCU_TIMER9_CLKSEL_VD_CLK"},
	{312, 4, "DEV_MCU_TIMER9_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCU_TIMER9_CLKSEL_VD_CLK"},
	{312, 5, "DEV_MCU_TIMER9_CLKSEL_VD_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_TIMER9_CLKSEL_VD_CLK"},
	{312, 6, "DEV_MCU_TIMER9_CLKSEL_VD_CLK_PARENT_BOARD_0_WKUP_LF_CLKIN_OUT", "Parent input clock option to DEV_MCU_TIMER9_CLKSEL_VD_CLK"},
	{312, 7, "DEV_MCU_TIMER9_CLKSEL_VD_CLK_PARENT_CPSW_2GUSS_MCU_0_CPTS_GENF0", "Parent input clock option to DEV_MCU_TIMER9_CLKSEL_VD_CLK"},
	{312, 8, "DEV_MCU_TIMER9_CLKSEL_VD_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_MCU_TIMER9_CLKSEL_VD_CLK"},
	{149, 2, "DEV_MCU_UART0_FCLK_CLK", "Input muxed clock"},
	{149, 3, "DEV_MCU_UART0_FCLK_CLK_PARENT_HSDIV4_16FFT_MCU_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_MCU_UART0_FCLK_CLK"},
	{149, 4, "DEV_MCU_UART0_FCLK_CLK_PARENT_POSTDIV2_16FFT_MAIN_1_HSDIVOUT5_CLK", "Parent input clock option to DEV_MCU_UART0_FCLK_CLK"},
	{149, 5, "DEV_MCU_UART0_VBUSP_CLK", "Input clock"},
	{91, 0, "DEV_MMCSD0_EMMCSS_VBUS_CLK", "Input clock"},
	{91, 3, "DEV_MMCSD0_EMMCSS_XIN_CLK", "Input muxed clock"},
	{91, 4, "DEV_MMCSD0_EMMCSS_XIN_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT2_CLK", "Parent input clock option to DEV_MMCSD0_EMMCSS_XIN_CLK"},
	{91, 5, "DEV_MMCSD0_EMMCSS_XIN_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT2_CLK", "Parent input clock option to DEV_MMCSD0_EMMCSS_XIN_CLK"},
	{91, 6, "DEV_MMCSD0_EMMCSS_XIN_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT2_CLK", "Parent input clock option to DEV_MMCSD0_EMMCSS_XIN_CLK"},
	{91, 7, "DEV_MMCSD0_EMMCSS_XIN_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT2_CLK_DUP0", "Parent input clock option to DEV_MMCSD0_EMMCSS_XIN_CLK"},
	{92, 0, "DEV_MMCSD1_EMMCSDSS_IO_CLK_I", "Input clock"},
	{92, 1, "DEV_MMCSD1_EMMCSDSS_VBUS_CLK", "Input clock"},
	{92, 2, "DEV_MMCSD1_EMMCSDSS_XIN_CLK", "Input muxed clock"},
	{92, 3, "DEV_MMCSD1_EMMCSDSS_XIN_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT2_CLK", "Parent input clock option to DEV_MMCSD1_EMMCSDSS_XIN_CLK"},
	{92, 4, "DEV_MMCSD1_EMMCSDSS_XIN_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT2_CLK", "Parent input clock option to DEV_MMCSD1_EMMCSDSS_XIN_CLK"},
	{92, 5, "DEV_MMCSD1_EMMCSDSS_XIN_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT2_CLK", "Parent input clock option to DEV_MMCSD1_EMMCSDSS_XIN_CLK"},
	{92, 6, "DEV_MMCSD1_EMMCSDSS_XIN_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT2_CLK_DUP0", "Parent input clock option to DEV_MMCSD1_EMMCSDSS_XIN_CLK"},
	{92, 7, "DEV_MMCSD1_EMMCSDSS_IO_CLK_O", "Output clock"},
	{199, 0, "DEV_NAVSS0_CPTS0_GENF2", "Output clock"},
	{199, 1, "DEV_NAVSS0_CPTS0_GENF3", "Output clock"},
	{199, 2, "DEV_NAVSS0_CPTS0_GENF4", "Output clock"},
	{201, 0, "DEV_NAVSS0_CPTS_0_VBUSP_GCLK", "Input clock"},
	{201, 1, "DEV_NAVSS0_CPTS_0_RCLK", "Input muxed clock"},
	{201, 2, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT1_CLK", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{201, 3, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_POSTDIV2_16FFT_MAIN_0_HSDIVOUT6_CLK", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{201, 4, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_BOARD_0_MCU_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{201, 5, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{201, 6, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{201, 7, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{201, 8, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_WIZ16B8M4CT2_MAIN_1_IP2_LN0_TXMCLK", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{201, 9, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_WIZ16B8M4CT2_MAIN_1_IP2_LN1_TXMCLK", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{201, 10, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_WIZ16B8M4CT2_MAIN_1_IP2_LN2_TXMCLK", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{201, 11, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_WIZ16B8M4CT2_MAIN_1_IP2_LN3_TXMCLK", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{201, 16, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT1_CLK", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{201, 17, "DEV_NAVSS0_CPTS_0_RCLK_PARENT_K3_PLL_CTRL_WRAP_MAIN_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_NAVSS0_CPTS_0_RCLK"},
	{201, 20, "DEV_NAVSS0_CPTS_0_TS_GENF0", "Output clock"},
	{201, 21, "DEV_NAVSS0_CPTS_0_TS_GENF1", "Output clock"},
	{206, 0, "DEV_NAVSS0_DTI_0_CLK_CLK", "Input clock"},
	{213, 0, "DEV_NAVSS0_INTR_ROUTER_0_INTR_CLK", "Input clock"},
	{214, 0, "DEV_NAVSS0_MAILBOX_0_VCLK_CLK", "Input clock"},
	{215, 0, "DEV_NAVSS0_MAILBOX_1_VCLK_CLK", "Input clock"},
	{224, 0, "DEV_NAVSS0_MAILBOX_10_VCLK_CLK", "Input clock"},
	{225, 0, "DEV_NAVSS0_MAILBOX_11_VCLK_CLK", "Input clock"},
	{216, 0, "DEV_NAVSS0_MAILBOX_2_VCLK_CLK", "Input clock"},
	{217, 0, "DEV_NAVSS0_MAILBOX_3_VCLK_CLK", "Input clock"},
	{218, 0, "DEV_NAVSS0_MAILBOX_4_VCLK_CLK", "Input clock"},
	{219, 0, "DEV_NAVSS0_MAILBOX_5_VCLK_CLK", "Input clock"},
	{220, 0, "DEV_NAVSS0_MAILBOX_6_VCLK_CLK", "Input clock"},
	{221, 0, "DEV_NAVSS0_MAILBOX_7_VCLK_CLK", "Input clock"},
	{222, 0, "DEV_NAVSS0_MAILBOX_8_VCLK_CLK", "Input clock"},
	{223, 0, "DEV_NAVSS0_MAILBOX_9_VCLK_CLK", "Input clock"},
	{227, 0, "DEV_NAVSS0_MCRC_0_CLK", "Input clock"},
	{299, 0, "DEV_NAVSS0_MODSS_VD2CLK", "Input clock"},
	{207, 0, "DEV_NAVSS0_MODSS_INTA_0_SYS_CLK", "Input clock"},
	{208, 0, "DEV_NAVSS0_MODSS_INTA_1_SYS_CLK", "Input clock"},
	{210, 0, "DEV_NAVSS0_PROXY_0_CLK_CLK", "Input clock"},
	{211, 0, "DEV_NAVSS0_RINGACC_0_SYS_CLK", "Input clock"},
	{226, 0, "DEV_NAVSS0_SPINLOCK_0_CLK", "Input clock"},
	{228, 0, "DEV_NAVSS0_TBU_0_CLK_CLK", "Input clock"},
	{230, 0, "DEV_NAVSS0_TIMERMGR_0_VCLK_CLK", "Input clock"},
	{230, 1, "DEV_NAVSS0_TIMERMGR_0_EON_TICK_EVT", "Input clock"},
	{231, 0, "DEV_NAVSS0_TIMERMGR_1_VCLK_CLK", "Input clock"},
	{231, 1, "DEV_NAVSS0_TIMERMGR_1_EON_TICK_EVT", "Input clock"},
	{212, 0, "DEV_NAVSS0_UDMAP_0_SYS_CLK", "Input clock"},
	{300, 0, "DEV_NAVSS0_UDMASS_VD2CLK", "Input clock"},
	{209, 0, "DEV_NAVSS0_UDMASS_INTA_0_SYS_CLK", "Input clock"},
	{301, 0, "DEV_NAVSS0_VIRTSS_VD2CLK", "Input clock"},
	{139, 1, "DEV_PBIST0_CLK7_CLK", "Input clock"},
	{139, 2, "DEV_PBIST0_CLK3_CLK", "Input clock"},
	{139, 3, "DEV_PBIST0_CLK5_CLK", "Input clock"},
	{139, 4, "DEV_PBIST0_CLK1_CLK", "Input clock"},
	{139, 5, "DEV_PBIST0_CLK8_CLK", "Input clock"},
	{139, 6, "DEV_PBIST0_CLK6_CLK", "Input clock"},
	{139, 8, "DEV_PBIST0_CLK4_CLK", "Input clock"},
	{139, 9, "DEV_PBIST0_CLK2_CLK", "Input clock"},
	{140, 1, "DEV_PBIST1_CLK7_CLK", "Input clock"},
	{140, 2, "DEV_PBIST1_CLK3_CLK", "Input clock"},
	{140, 3, "DEV_PBIST1_CLK5_CLK", "Input clock"},
	{140, 4, "DEV_PBIST1_CLK1_CLK", "Input clock"},
	{140, 5, "DEV_PBIST1_CLK8_CLK", "Input clock"},
	{140, 6, "DEV_PBIST1_CLK6_CLK", "Input clock"},
	{140, 8, "DEV_PBIST1_CLK4_CLK", "Input clock"},
	{140, 9, "DEV_PBIST1_CLK2_CLK", "Input clock"},
	{141, 1, "DEV_PBIST2_CLK7_CLK", "Input clock"},
	{141, 2, "DEV_PBIST2_CLK3_CLK", "Input clock"},
	{141, 3, "DEV_PBIST2_CLK5_CLK", "Input clock"},
	{141, 4, "DEV_PBIST2_CLK1_CLK", "Input clock"},
	{141, 5, "DEV_PBIST2_CLK8_CLK", "Input clock"},
	{141, 6, "DEV_PBIST2_CLK6_CLK", "Input clock"},
	{141, 8, "DEV_PBIST2_CLK4_CLK", "Input clock"},
	{141, 9, "DEV_PBIST2_CLK2_CLK", "Input clock"},
	{240, 0, "DEV_PCIE1_PCIE_LANE0_TXCLK", "Output clock"},
	{240, 1, "DEV_PCIE1_PCIE_LANE1_TXMCLK", "Input clock"},
	{240, 2, "DEV_PCIE1_PCIE_LANE0_TXMCLK", "Input clock"},
	{240, 3, "DEV_PCIE1_PCIE_LANE0_TXFCLK", "Input clock"},
	{240, 4, "DEV_PCIE1_PCIE_PM_CLK", "Input clock"},
	{240, 5, "DEV_PCIE1_PCIE_LANE3_TXMCLK", "Input clock"},
	{240, 6, "DEV_PCIE1_PCIE_CBA_CLK", "Input clock"},
	{240, 7, "DEV_PCIE1_PCIE_LANE1_REFCLK", "Input clock"},
	{240, 8, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK", "Input muxed clock"},
	{240, 9, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT1_CLK", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{240, 10, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_POSTDIV2_16FFT_MAIN_0_HSDIVOUT6_CLK", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{240, 11, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_BOARD_0_MCU_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{240, 12, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{240, 13, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{240, 14, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{240, 15, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B8M4CT2_MAIN_1_IP2_LN0_TXMCLK", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{240, 16, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B8M4CT2_MAIN_1_IP2_LN1_TXMCLK", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{240, 17, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B8M4CT2_MAIN_1_IP2_LN2_TXMCLK", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{240, 18, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B8M4CT2_MAIN_1_IP2_LN3_TXMCLK", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{240, 23, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_HSDIV4_16FFT_MCU_2_HSDIVOUT1_CLK", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{240, 24, "DEV_PCIE1_PCIE_CPTS_RCLK_CLK_PARENT_K3_PLL_CTRL_WRAP_MAIN_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_PCIE1_PCIE_CPTS_RCLK_CLK"},
	{240, 25, "DEV_PCIE1_PCIE_LANE1_RXFCLK", "Input clock"},
	{240, 27, "DEV_PCIE1_PCIE_LANE2_RXCLK", "Input clock"},
	{240, 28, "DEV_PCIE1_PCIE_LANE2_TXMCLK", "Input clock"},
	{240, 29, "DEV_PCIE1_PCIE_LANE1_TXCLK", "Output clock"},
	{240, 30, "DEV_PCIE1_PCIE_LANE3_TXFCLK", "Input clock"},
	{240, 31, "DEV_PCIE1_PCIE_LANE2_TXFCLK", "Input clock"},
	{240, 32, "DEV_PCIE1_PCIE_LANE1_RXCLK", "Input clock"},
	{240, 33, "DEV_PCIE1_PCIE_LANE2_TXCLK", "Output clock"},
	{240, 34, "DEV_PCIE1_PCIE_LANE1_TXFCLK", "Input clock"},
	{240, 35, "DEV_PCIE1_PCIE_LANE0_REFCLK", "Input clock"},
	{240, 36, "DEV_PCIE1_PCIE_LANE3_RXFCLK", "Input clock"},
	{240, 37, "DEV_PCIE1_PCIE_LANE2_RXFCLK", "Input clock"},
	{240, 38, "DEV_PCIE1_PCIE_LANE3_RXCLK", "Input clock"},
	{240, 39, "DEV_PCIE1_PCIE_LANE3_REFCLK", "Input clock"},
	{240, 40, "DEV_PCIE1_PCIE_LANE2_REFCLK", "Input clock"},
	{240, 41, "DEV_PCIE1_PCIE_LANE0_RXFCLK", "Input clock"},
	{240, 42, "DEV_PCIE1_PCIE_LANE3_TXCLK", "Output clock"},
	{240, 43, "DEV_PCIE1_PCIE_LANE0_RXCLK", "Input clock"},
	{133, 0, "DEV_PSC0_SLOW_CLK", "Input clock"},
	{133, 1, "DEV_PSC0_CLK", "Input clock"},
	{245, 0, "DEV_R5FSS0_CORE0_CPU_CLK", "Input clock"},
	{245, 1, "DEV_R5FSS0_CORE0_INTERFACE_CLK", "Input clock"},
	{245, 2, "DEV_R5FSS0_CORE0_INTERFACE_PHASE", "Input clock"},
	{246, 0, "DEV_R5FSS0_CORE1_CPU_CLK", "Input clock"},
	{246, 1, "DEV_R5FSS0_CORE1_INTERFACE_CLK", "Input clock"},
	{246, 2, "DEV_R5FSS0_CORE1_INTERFACE_PHASE", "Input clock"},
	{252, 0, "DEV_RTI0_VBUSP_CLK", "Input clock"},
	{252, 1, "DEV_RTI0_RTI_CLK", "Input muxed clock"},
	{252, 2, "DEV_RTI0_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI0_RTI_CLK"},
	{252, 3, "DEV_RTI0_RTI_CLK_PARENT_BOARD_0_WKUP_LF_CLKIN_OUT", "Parent input clock option to DEV_RTI0_RTI_CLK"},
	{252, 4, "DEV_RTI0_RTI_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI0_RTI_CLK"},
	{252, 5, "DEV_RTI0_RTI_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI0_RTI_CLK"},
	{252, 6, "DEV_RTI0_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI0_RTI_CLK"},
	{252, 7, "DEV_RTI0_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI0_RTI_CLK"},
	{252, 8, "DEV_RTI0_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI0_RTI_CLK"},
	{252, 9, "DEV_RTI0_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI0_RTI_CLK"},
	{253, 0, "DEV_RTI1_VBUSP_CLK", "Input clock"},
	{253, 1, "DEV_RTI1_RTI_CLK", "Input muxed clock"},
	{253, 2, "DEV_RTI1_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI1_RTI_CLK"},
	{253, 3, "DEV_RTI1_RTI_CLK_PARENT_BOARD_0_WKUP_LF_CLKIN_OUT", "Parent input clock option to DEV_RTI1_RTI_CLK"},
	{253, 4, "DEV_RTI1_RTI_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI1_RTI_CLK"},
	{253, 5, "DEV_RTI1_RTI_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI1_RTI_CLK"},
	{253, 6, "DEV_RTI1_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI1_RTI_CLK"},
	{253, 7, "DEV_RTI1_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI1_RTI_CLK"},
	{253, 8, "DEV_RTI1_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI1_RTI_CLK"},
	{253, 9, "DEV_RTI1_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI1_RTI_CLK"},
	{258, 0, "DEV_RTI28_VBUSP_CLK", "Input clock"},
	{258, 1, "DEV_RTI28_RTI_CLK", "Input muxed clock"},
	{258, 2, "DEV_RTI28_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI28_RTI_CLK"},
	{258, 3, "DEV_RTI28_RTI_CLK_PARENT_BOARD_0_WKUP_LF_CLKIN_OUT", "Parent input clock option to DEV_RTI28_RTI_CLK"},
	{258, 4, "DEV_RTI28_RTI_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI28_RTI_CLK"},
	{258, 5, "DEV_RTI28_RTI_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI28_RTI_CLK"},
	{258, 6, "DEV_RTI28_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI28_RTI_CLK"},
	{258, 7, "DEV_RTI28_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI28_RTI_CLK"},
	{258, 8, "DEV_RTI28_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI28_RTI_CLK"},
	{258, 9, "DEV_RTI28_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI28_RTI_CLK"},
	{259, 0, "DEV_RTI29_VBUSP_CLK", "Input clock"},
	{259, 1, "DEV_RTI29_RTI_CLK", "Input muxed clock"},
	{259, 2, "DEV_RTI29_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI29_RTI_CLK"},
	{259, 3, "DEV_RTI29_RTI_CLK_PARENT_BOARD_0_WKUP_LF_CLKIN_OUT", "Parent input clock option to DEV_RTI29_RTI_CLK"},
	{259, 4, "DEV_RTI29_RTI_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI29_RTI_CLK"},
	{259, 5, "DEV_RTI29_RTI_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI29_RTI_CLK"},
	{259, 6, "DEV_RTI29_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI29_RTI_CLK"},
	{259, 7, "DEV_RTI29_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI29_RTI_CLK"},
	{259, 8, "DEV_RTI29_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI29_RTI_CLK"},
	{259, 9, "DEV_RTI29_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI29_RTI_CLK"},
	{292, 1, "DEV_SERDES_10G1_IP3_LN1_TXFCLK", "Output clock"},
	{292, 3, "DEV_SERDES_10G1_IP2_LN2_REFCLK", "Output clock"},
	{292, 4, "DEV_SERDES_10G1_IP1_LN0_TXMCLK", "Output clock"},
	{292, 6, "DEV_SERDES_10G1_IP3_LN3_RXCLK", "Output clock"},
	{292, 9, "DEV_SERDES_10G1_IP2_LN2_RXCLK", "Output clock"},
	{292, 10, "DEV_SERDES_10G1_IP1_LN0_TXFCLK", "Output clock"},
	{292, 11, "DEV_SERDES_10G1_CLK", "Input clock"},
	{292, 13, "DEV_SERDES_10G1_IP1_LN3_RXCLK", "Output clock"},
	{292, 14, "DEV_SERDES_10G1_IP1_LN1_TXMCLK", "Output clock"},
	{292, 15, "DEV_SERDES_10G1_IP2_LN0_TXFCLK", "Output clock"},
	{292, 16, "DEV_SERDES_10G1_IP2_LN2_TXMCLK", "Output clock"},
	{292, 19, "DEV_SERDES_10G1_IP3_LN1_TXCLK", "Input clock"},
	{292, 21, "DEV_SERDES_10G1_IP2_LN3_RXFCLK", "Output clock"},
	{292, 22, "DEV_SERDES_10G1_IP1_LN2_TXCLK", "Input clock"},
	{292, 24, "DEV_SERDES_10G1_IP2_LN1_RXCLK", "Output clock"},
	{292, 25, "DEV_SERDES_10G1_IP2_LN1_TXCLK", "Input clock"},
	{292, 29, "DEV_SERDES_10G1_IP1_LN2_TXMCLK", "Output clock"},
	{292, 32, "DEV_SERDES_10G1_IP2_LN1_TXMCLK", "Output clock"},
	{292, 33, "DEV_SERDES_10G1_IP2_LN1_TXFCLK", "Output clock"},
	{292, 34, "DEV_SERDES_10G1_IP1_LN1_TXFCLK", "Output clock"},
	{292, 38, "DEV_SERDES_10G1_IP1_LN2_RXCLK", "Output clock"},
	{292, 40, "DEV_SERDES_10G1_IP2_LN1_REFCLK", "Output clock"},
	{292, 41, "DEV_SERDES_10G1_IP2_LN0_TXMCLK", "Output clock"},
	{292, 42, "DEV_SERDES_10G1_IP2_LN3_RXCLK", "Output clock"},
	{292, 43, "DEV_SERDES_10G1_IP2_LN2_TXCLK", "Input clock"},
	{292, 44, "DEV_SERDES_10G1_IP2_LN2_RXFCLK", "Output clock"},
	{292, 45, "DEV_SERDES_10G1_IP1_LN1_RXFCLK", "Output clock"},
	{292, 49, "DEV_SERDES_10G1_IP1_LN0_RXCLK", "Output clock"},
	{292, 52, "DEV_SERDES_10G1_IP1_LN1_RXCLK", "Output clock"},
	{292, 55, "DEV_SERDES_10G1_IP1_LN0_RXFCLK", "Output clock"},
	{292, 56, "DEV_SERDES_10G1_IP3_LN3_TXCLK", "Input clock"},
	{292, 59, "DEV_SERDES_10G1_IP2_LN3_REFCLK", "Output clock"},
	{292, 61, "DEV_SERDES_10G1_IP2_LN0_TXCLK", "Input clock"},
	{292, 62, "DEV_SERDES_10G1_IP2_LN3_TXMCLK", "Output clock"},
	{292, 63, "DEV_SERDES_10G1_IP1_LN1_REFCLK", "Output clock"},
	{292, 65, "DEV_SERDES_10G1_IP1_LN3_TXCLK", "Input clock"},
	{292, 66, "DEV_SERDES_10G1_IP3_LN1_TXMCLK", "Output clock"},
	{292, 67, "DEV_SERDES_10G1_IP2_LN2_TXFCLK", "Output clock"},
	{292, 73, "DEV_SERDES_10G1_IP3_LN1_RXCLK", "Output clock"},
	{292, 74, "DEV_SERDES_10G1_IP3_LN1_REFCLK", "Output clock"},
	{292, 75, "DEV_SERDES_10G1_IP1_LN3_REFCLK", "Output clock"},
	{292, 77, "DEV_SERDES_10G1_IP1_LN0_REFCLK", "Output clock"},
	{292, 80, "DEV_SERDES_10G1_IP1_LN2_REFCLK", "Output clock"},
	{292, 81, "DEV_SERDES_10G1_IP2_LN0_REFCLK", "Output clock"},
	{292, 82, "DEV_SERDES_10G1_IP2_LN0_RXCLK", "Output clock"},
	{292, 85, "DEV_SERDES_10G1_CORE_REF_CLK", "Input muxed clock"},
	{292, 86, "DEV_SERDES_10G1_CORE_REF_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_SERDES_10G1_CORE_REF_CLK"},
	{292, 87, "DEV_SERDES_10G1_CORE_REF_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_SERDES_10G1_CORE_REF_CLK"},
	{292, 88, "DEV_SERDES_10G1_CORE_REF_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT4_CLK", "Parent input clock option to DEV_SERDES_10G1_CORE_REF_CLK"},
	{292, 89, "DEV_SERDES_10G1_CORE_REF_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT4_CLK", "Parent input clock option to DEV_SERDES_10G1_CORE_REF_CLK"},
	{292, 92, "DEV_SERDES_10G1_IP1_LN3_TXMCLK", "Output clock"},
	{292, 95, "DEV_SERDES_10G1_IP2_LN3_TXCLK", "Input clock"},
	{292, 96, "DEV_SERDES_10G1_IP3_LN3_RXFCLK", "Output clock"},
	{292, 98, "DEV_SERDES_10G1_IP3_LN3_REFCLK", "Output clock"},
	{292, 100, "DEV_SERDES_10G1_IP2_LN1_RXFCLK", "Output clock"},
	{292, 102, "DEV_SERDES_10G1_IP3_LN1_RXFCLK", "Output clock"},
	{292, 104, "DEV_SERDES_10G1_IP1_LN1_TXCLK", "Input clock"},
	{292, 107, "DEV_SERDES_10G1_IP3_LN3_TXFCLK", "Output clock"},
	{292, 108, "DEV_SERDES_10G1_IP1_LN3_TXFCLK", "Output clock"},
	{292, 109, "DEV_SERDES_10G1_IP2_LN3_TXFCLK", "Output clock"},
	{292, 111, "DEV_SERDES_10G1_IP1_LN0_TXCLK", "Input clock"},
	{292, 112, "DEV_SERDES_10G1_IP2_LN0_RXFCLK", "Output clock"},
	{292, 113, "DEV_SERDES_10G1_IP1_LN2_RXFCLK", "Output clock"},
	{292, 118, "DEV_SERDES_10G1_IP1_LN2_TXFCLK", "Output clock"},
	{292, 124, "DEV_SERDES_10G1_IP1_LN3_RXFCLK", "Output clock"},
	{292, 126, "DEV_SERDES_10G1_IP3_LN3_TXMCLK", "Output clock"},
	{29, 0, "DEV_STM0_CORE_CLK", "Input clock"},
	{29, 1, "DEV_STM0_VBUSP_CLK", "Input clock"},
	{29, 2, "DEV_STM0_ATB_CLK", "Input clock"},
	{49, 0, "DEV_TIMER0_TIMER_HCLK_CLK", "Input clock"},
	{49, 1, "DEV_TIMER0_TIMER_TCLK_CLK", "Input muxed clock"},
	{49, 2, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{49, 3, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{49, 4, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{49, 5, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{49, 6, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{49, 7, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{49, 8, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{49, 9, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_BOARD_0_WKUP_LF_CLKIN_OUT", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{49, 10, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{49, 11, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{49, 12, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{49, 13, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{49, 14, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{49, 15, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{49, 16, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_CPSW_5XUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{49, 17, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF4", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{49, 26, "DEV_TIMER0_TIMER_PWM", "Output clock"},
	{50, 0, "DEV_TIMER1_TIMER_HCLK_CLK", "Input clock"},
	{50, 1, "DEV_TIMER1_TIMER_TCLK_CLK", "Input muxed clock"},
	{50, 2, "DEV_TIMER1_TIMER_TCLK_CLK_PARENT_MAIN_TIMER_CLKSEL_OUT1", "Parent input clock option to DEV_TIMER1_TIMER_TCLK_CLK"},
	{50, 3, "DEV_TIMER1_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MAIN_0_TIMER_PWM", "Parent input clock option to DEV_TIMER1_TIMER_TCLK_CLK"},
	{60, 0, "DEV_TIMER10_TIMER_HCLK_CLK", "Input clock"},
	{60, 1, "DEV_TIMER10_TIMER_TCLK_CLK", "Input muxed clock"},
	{60, 2, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{60, 3, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{60, 4, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{60, 5, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{60, 6, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{60, 7, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{60, 8, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{60, 9, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_BOARD_0_WKUP_LF_CLKIN_OUT", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{60, 10, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{60, 11, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{60, 12, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{60, 13, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{60, 14, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{60, 15, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{60, 16, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_CPSW_5XUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{60, 17, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF4", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{60, 26, "DEV_TIMER10_TIMER_PWM", "Output clock"},
	{62, 0, "DEV_TIMER11_TIMER_HCLK_CLK", "Input clock"},
	{62, 1, "DEV_TIMER11_TIMER_TCLK_CLK", "Input muxed clock"},
	{62, 2, "DEV_TIMER11_TIMER_TCLK_CLK_PARENT_MAIN_TIMER_CLKSEL_OUT11", "Parent input clock option to DEV_TIMER11_TIMER_TCLK_CLK"},
	{62, 3, "DEV_TIMER11_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MAIN_10_TIMER_PWM", "Parent input clock option to DEV_TIMER11_TIMER_TCLK_CLK"},
	{318, 0, "DEV_TIMER11_CLKSEL_VD_CLK", "Input muxed clock"},
	{318, 1, "DEV_TIMER11_CLKSEL_VD_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER11_CLKSEL_VD_CLK"},
	{318, 2, "DEV_TIMER11_CLKSEL_VD_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER11_CLKSEL_VD_CLK"},
	{318, 3, "DEV_TIMER11_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_TIMER11_CLKSEL_VD_CLK"},
	{318, 4, "DEV_TIMER11_CLKSEL_VD_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER11_CLKSEL_VD_CLK"},
	{318, 5, "DEV_TIMER11_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER11_CLKSEL_VD_CLK"},
	{318, 6, "DEV_TIMER11_CLKSEL_VD_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER11_CLKSEL_VD_CLK"},
	{318, 7, "DEV_TIMER11_CLKSEL_VD_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER11_CLKSEL_VD_CLK"},
	{318, 8, "DEV_TIMER11_CLKSEL_VD_CLK_PARENT_BOARD_0_WKUP_LF_CLKIN_OUT", "Parent input clock option to DEV_TIMER11_CLKSEL_VD_CLK"},
	{318, 9, "DEV_TIMER11_CLKSEL_VD_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER11_CLKSEL_VD_CLK"},
	{318, 10, "DEV_TIMER11_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER11_CLKSEL_VD_CLK"},
	{318, 11, "DEV_TIMER11_CLKSEL_VD_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER11_CLKSEL_VD_CLK"},
	{318, 12, "DEV_TIMER11_CLKSEL_VD_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER11_CLKSEL_VD_CLK"},
	{318, 13, "DEV_TIMER11_CLKSEL_VD_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER11_CLKSEL_VD_CLK"},
	{318, 14, "DEV_TIMER11_CLKSEL_VD_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER11_CLKSEL_VD_CLK"},
	{318, 15, "DEV_TIMER11_CLKSEL_VD_CLK_PARENT_CPSW_5XUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER11_CLKSEL_VD_CLK"},
	{318, 16, "DEV_TIMER11_CLKSEL_VD_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF4", "Parent input clock option to DEV_TIMER11_CLKSEL_VD_CLK"},
	{63, 0, "DEV_TIMER12_TIMER_HCLK_CLK", "Input clock"},
	{63, 1, "DEV_TIMER12_TIMER_TCLK_CLK", "Input muxed clock"},
	{63, 2, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{63, 3, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{63, 4, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{63, 5, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{63, 6, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{63, 7, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{63, 8, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{63, 9, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_BOARD_0_WKUP_LF_CLKIN_OUT", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{63, 10, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{63, 11, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{63, 12, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{63, 13, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{63, 14, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{63, 15, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{63, 16, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_CPSW_5XUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{63, 17, "DEV_TIMER12_TIMER_TCLK_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF4", "Parent input clock option to DEV_TIMER12_TIMER_TCLK_CLK"},
	{63, 26, "DEV_TIMER12_TIMER_PWM", "Output clock"},
	{64, 0, "DEV_TIMER13_TIMER_HCLK_CLK", "Input clock"},
	{64, 1, "DEV_TIMER13_TIMER_TCLK_CLK", "Input muxed clock"},
	{64, 2, "DEV_TIMER13_TIMER_TCLK_CLK_PARENT_MAIN_TIMER_CLKSEL_OUT13", "Parent input clock option to DEV_TIMER13_TIMER_TCLK_CLK"},
	{64, 3, "DEV_TIMER13_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MAIN_12_TIMER_PWM", "Parent input clock option to DEV_TIMER13_TIMER_TCLK_CLK"},
	{319, 0, "DEV_TIMER13_CLKSEL_VD_CLK", "Input muxed clock"},
	{319, 1, "DEV_TIMER13_CLKSEL_VD_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER13_CLKSEL_VD_CLK"},
	{319, 2, "DEV_TIMER13_CLKSEL_VD_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER13_CLKSEL_VD_CLK"},
	{319, 3, "DEV_TIMER13_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_TIMER13_CLKSEL_VD_CLK"},
	{319, 4, "DEV_TIMER13_CLKSEL_VD_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER13_CLKSEL_VD_CLK"},
	{319, 5, "DEV_TIMER13_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER13_CLKSEL_VD_CLK"},
	{319, 6, "DEV_TIMER13_CLKSEL_VD_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER13_CLKSEL_VD_CLK"},
	{319, 7, "DEV_TIMER13_CLKSEL_VD_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER13_CLKSEL_VD_CLK"},
	{319, 8, "DEV_TIMER13_CLKSEL_VD_CLK_PARENT_BOARD_0_WKUP_LF_CLKIN_OUT", "Parent input clock option to DEV_TIMER13_CLKSEL_VD_CLK"},
	{319, 9, "DEV_TIMER13_CLKSEL_VD_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER13_CLKSEL_VD_CLK"},
	{319, 10, "DEV_TIMER13_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER13_CLKSEL_VD_CLK"},
	{319, 11, "DEV_TIMER13_CLKSEL_VD_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER13_CLKSEL_VD_CLK"},
	{319, 12, "DEV_TIMER13_CLKSEL_VD_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER13_CLKSEL_VD_CLK"},
	{319, 13, "DEV_TIMER13_CLKSEL_VD_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER13_CLKSEL_VD_CLK"},
	{319, 14, "DEV_TIMER13_CLKSEL_VD_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER13_CLKSEL_VD_CLK"},
	{319, 15, "DEV_TIMER13_CLKSEL_VD_CLK_PARENT_CPSW_5XUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER13_CLKSEL_VD_CLK"},
	{319, 16, "DEV_TIMER13_CLKSEL_VD_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF4", "Parent input clock option to DEV_TIMER13_CLKSEL_VD_CLK"},
	{65, 0, "DEV_TIMER14_TIMER_HCLK_CLK", "Input clock"},
	{65, 1, "DEV_TIMER14_TIMER_TCLK_CLK", "Input muxed clock"},
	{65, 2, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{65, 3, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{65, 4, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{65, 5, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{65, 6, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{65, 7, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{65, 8, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{65, 9, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_BOARD_0_WKUP_LF_CLKIN_OUT", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{65, 10, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{65, 11, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{65, 12, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{65, 13, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{65, 14, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{65, 15, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{65, 16, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_CPSW_5XUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{65, 17, "DEV_TIMER14_TIMER_TCLK_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF4", "Parent input clock option to DEV_TIMER14_TIMER_TCLK_CLK"},
	{65, 26, "DEV_TIMER14_TIMER_PWM", "Output clock"},
	{66, 0, "DEV_TIMER15_TIMER_HCLK_CLK", "Input clock"},
	{66, 1, "DEV_TIMER15_TIMER_TCLK_CLK", "Input muxed clock"},
	{66, 2, "DEV_TIMER15_TIMER_TCLK_CLK_PARENT_MAIN_TIMER_CLKSEL_OUT15", "Parent input clock option to DEV_TIMER15_TIMER_TCLK_CLK"},
	{66, 3, "DEV_TIMER15_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MAIN_14_TIMER_PWM", "Parent input clock option to DEV_TIMER15_TIMER_TCLK_CLK"},
	{320, 0, "DEV_TIMER15_CLKSEL_VD_CLK", "Input muxed clock"},
	{320, 1, "DEV_TIMER15_CLKSEL_VD_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER15_CLKSEL_VD_CLK"},
	{320, 2, "DEV_TIMER15_CLKSEL_VD_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER15_CLKSEL_VD_CLK"},
	{320, 3, "DEV_TIMER15_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_TIMER15_CLKSEL_VD_CLK"},
	{320, 4, "DEV_TIMER15_CLKSEL_VD_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER15_CLKSEL_VD_CLK"},
	{320, 5, "DEV_TIMER15_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER15_CLKSEL_VD_CLK"},
	{320, 6, "DEV_TIMER15_CLKSEL_VD_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER15_CLKSEL_VD_CLK"},
	{320, 7, "DEV_TIMER15_CLKSEL_VD_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER15_CLKSEL_VD_CLK"},
	{320, 8, "DEV_TIMER15_CLKSEL_VD_CLK_PARENT_BOARD_0_WKUP_LF_CLKIN_OUT", "Parent input clock option to DEV_TIMER15_CLKSEL_VD_CLK"},
	{320, 9, "DEV_TIMER15_CLKSEL_VD_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER15_CLKSEL_VD_CLK"},
	{320, 10, "DEV_TIMER15_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER15_CLKSEL_VD_CLK"},
	{320, 11, "DEV_TIMER15_CLKSEL_VD_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER15_CLKSEL_VD_CLK"},
	{320, 12, "DEV_TIMER15_CLKSEL_VD_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER15_CLKSEL_VD_CLK"},
	{320, 13, "DEV_TIMER15_CLKSEL_VD_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER15_CLKSEL_VD_CLK"},
	{320, 14, "DEV_TIMER15_CLKSEL_VD_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER15_CLKSEL_VD_CLK"},
	{320, 15, "DEV_TIMER15_CLKSEL_VD_CLK_PARENT_CPSW_5XUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER15_CLKSEL_VD_CLK"},
	{320, 16, "DEV_TIMER15_CLKSEL_VD_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF4", "Parent input clock option to DEV_TIMER15_CLKSEL_VD_CLK"},
	{67, 0, "DEV_TIMER16_TIMER_HCLK_CLK", "Input clock"},
	{67, 1, "DEV_TIMER16_TIMER_TCLK_CLK", "Input muxed clock"},
	{67, 2, "DEV_TIMER16_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER16_TIMER_TCLK_CLK"},
	{67, 3, "DEV_TIMER16_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER16_TIMER_TCLK_CLK"},
	{67, 4, "DEV_TIMER16_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_TIMER16_TIMER_TCLK_CLK"},
	{67, 5, "DEV_TIMER16_TIMER_TCLK_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER16_TIMER_TCLK_CLK"},
	{67, 6, "DEV_TIMER16_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER16_TIMER_TCLK_CLK"},
	{67, 7, "DEV_TIMER16_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER16_TIMER_TCLK_CLK"},
	{67, 8, "DEV_TIMER16_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER16_TIMER_TCLK_CLK"},
	{67, 9, "DEV_TIMER16_TIMER_TCLK_CLK_PARENT_BOARD_0_WKUP_LF_CLKIN_OUT", "Parent input clock option to DEV_TIMER16_TIMER_TCLK_CLK"},
	{67, 10, "DEV_TIMER16_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER16_TIMER_TCLK_CLK"},
	{67, 11, "DEV_TIMER16_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER16_TIMER_TCLK_CLK"},
	{67, 12, "DEV_TIMER16_TIMER_TCLK_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER16_TIMER_TCLK_CLK"},
	{67, 13, "DEV_TIMER16_TIMER_TCLK_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER16_TIMER_TCLK_CLK"},
	{67, 14, "DEV_TIMER16_TIMER_TCLK_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER16_TIMER_TCLK_CLK"},
	{67, 15, "DEV_TIMER16_TIMER_TCLK_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER16_TIMER_TCLK_CLK"},
	{67, 16, "DEV_TIMER16_TIMER_TCLK_CLK_PARENT_CPSW_5XUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER16_TIMER_TCLK_CLK"},
	{67, 17, "DEV_TIMER16_TIMER_TCLK_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF4", "Parent input clock option to DEV_TIMER16_TIMER_TCLK_CLK"},
	{67, 26, "DEV_TIMER16_TIMER_PWM", "Output clock"},
	{68, 0, "DEV_TIMER17_TIMER_HCLK_CLK", "Input clock"},
	{68, 1, "DEV_TIMER17_TIMER_TCLK_CLK", "Input muxed clock"},
	{68, 2, "DEV_TIMER17_TIMER_TCLK_CLK_PARENT_MAIN_TIMER_CLKSEL_OUT17", "Parent input clock option to DEV_TIMER17_TIMER_TCLK_CLK"},
	{68, 3, "DEV_TIMER17_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MAIN_16_TIMER_PWM", "Parent input clock option to DEV_TIMER17_TIMER_TCLK_CLK"},
	{321, 0, "DEV_TIMER17_CLKSEL_VD_CLK", "Input muxed clock"},
	{321, 1, "DEV_TIMER17_CLKSEL_VD_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER17_CLKSEL_VD_CLK"},
	{321, 2, "DEV_TIMER17_CLKSEL_VD_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER17_CLKSEL_VD_CLK"},
	{321, 3, "DEV_TIMER17_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_TIMER17_CLKSEL_VD_CLK"},
	{321, 4, "DEV_TIMER17_CLKSEL_VD_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER17_CLKSEL_VD_CLK"},
	{321, 5, "DEV_TIMER17_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER17_CLKSEL_VD_CLK"},
	{321, 6, "DEV_TIMER17_CLKSEL_VD_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER17_CLKSEL_VD_CLK"},
	{321, 7, "DEV_TIMER17_CLKSEL_VD_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER17_CLKSEL_VD_CLK"},
	{321, 8, "DEV_TIMER17_CLKSEL_VD_CLK_PARENT_BOARD_0_WKUP_LF_CLKIN_OUT", "Parent input clock option to DEV_TIMER17_CLKSEL_VD_CLK"},
	{321, 9, "DEV_TIMER17_CLKSEL_VD_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER17_CLKSEL_VD_CLK"},
	{321, 10, "DEV_TIMER17_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER17_CLKSEL_VD_CLK"},
	{321, 11, "DEV_TIMER17_CLKSEL_VD_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER17_CLKSEL_VD_CLK"},
	{321, 12, "DEV_TIMER17_CLKSEL_VD_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER17_CLKSEL_VD_CLK"},
	{321, 13, "DEV_TIMER17_CLKSEL_VD_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER17_CLKSEL_VD_CLK"},
	{321, 14, "DEV_TIMER17_CLKSEL_VD_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER17_CLKSEL_VD_CLK"},
	{321, 15, "DEV_TIMER17_CLKSEL_VD_CLK_PARENT_CPSW_5XUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER17_CLKSEL_VD_CLK"},
	{321, 16, "DEV_TIMER17_CLKSEL_VD_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF4", "Parent input clock option to DEV_TIMER17_CLKSEL_VD_CLK"},
	{69, 0, "DEV_TIMER18_TIMER_HCLK_CLK", "Input clock"},
	{69, 1, "DEV_TIMER18_TIMER_TCLK_CLK", "Input muxed clock"},
	{69, 2, "DEV_TIMER18_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER18_TIMER_TCLK_CLK"},
	{69, 3, "DEV_TIMER18_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER18_TIMER_TCLK_CLK"},
	{69, 4, "DEV_TIMER18_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_TIMER18_TIMER_TCLK_CLK"},
	{69, 5, "DEV_TIMER18_TIMER_TCLK_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER18_TIMER_TCLK_CLK"},
	{69, 6, "DEV_TIMER18_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER18_TIMER_TCLK_CLK"},
	{69, 7, "DEV_TIMER18_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER18_TIMER_TCLK_CLK"},
	{69, 8, "DEV_TIMER18_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER18_TIMER_TCLK_CLK"},
	{69, 9, "DEV_TIMER18_TIMER_TCLK_CLK_PARENT_BOARD_0_WKUP_LF_CLKIN_OUT", "Parent input clock option to DEV_TIMER18_TIMER_TCLK_CLK"},
	{69, 10, "DEV_TIMER18_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER18_TIMER_TCLK_CLK"},
	{69, 11, "DEV_TIMER18_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER18_TIMER_TCLK_CLK"},
	{69, 12, "DEV_TIMER18_TIMER_TCLK_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER18_TIMER_TCLK_CLK"},
	{69, 13, "DEV_TIMER18_TIMER_TCLK_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER18_TIMER_TCLK_CLK"},
	{69, 14, "DEV_TIMER18_TIMER_TCLK_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER18_TIMER_TCLK_CLK"},
	{69, 15, "DEV_TIMER18_TIMER_TCLK_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER18_TIMER_TCLK_CLK"},
	{69, 16, "DEV_TIMER18_TIMER_TCLK_CLK_PARENT_CPSW_5XUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER18_TIMER_TCLK_CLK"},
	{69, 17, "DEV_TIMER18_TIMER_TCLK_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF4", "Parent input clock option to DEV_TIMER18_TIMER_TCLK_CLK"},
	{69, 26, "DEV_TIMER18_TIMER_PWM", "Output clock"},
	{70, 0, "DEV_TIMER19_TIMER_HCLK_CLK", "Input clock"},
	{70, 1, "DEV_TIMER19_TIMER_TCLK_CLK", "Input muxed clock"},
	{70, 2, "DEV_TIMER19_TIMER_TCLK_CLK_PARENT_MAIN_TIMER_CLKSEL_OUT19", "Parent input clock option to DEV_TIMER19_TIMER_TCLK_CLK"},
	{70, 3, "DEV_TIMER19_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MAIN_18_TIMER_PWM", "Parent input clock option to DEV_TIMER19_TIMER_TCLK_CLK"},
	{322, 0, "DEV_TIMER19_CLKSEL_VD_CLK", "Input muxed clock"},
	{322, 1, "DEV_TIMER19_CLKSEL_VD_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER19_CLKSEL_VD_CLK"},
	{322, 2, "DEV_TIMER19_CLKSEL_VD_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER19_CLKSEL_VD_CLK"},
	{322, 3, "DEV_TIMER19_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_TIMER19_CLKSEL_VD_CLK"},
	{322, 4, "DEV_TIMER19_CLKSEL_VD_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER19_CLKSEL_VD_CLK"},
	{322, 5, "DEV_TIMER19_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER19_CLKSEL_VD_CLK"},
	{322, 6, "DEV_TIMER19_CLKSEL_VD_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER19_CLKSEL_VD_CLK"},
	{322, 7, "DEV_TIMER19_CLKSEL_VD_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER19_CLKSEL_VD_CLK"},
	{322, 8, "DEV_TIMER19_CLKSEL_VD_CLK_PARENT_BOARD_0_WKUP_LF_CLKIN_OUT", "Parent input clock option to DEV_TIMER19_CLKSEL_VD_CLK"},
	{322, 9, "DEV_TIMER19_CLKSEL_VD_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER19_CLKSEL_VD_CLK"},
	{322, 10, "DEV_TIMER19_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER19_CLKSEL_VD_CLK"},
	{322, 11, "DEV_TIMER19_CLKSEL_VD_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER19_CLKSEL_VD_CLK"},
	{322, 12, "DEV_TIMER19_CLKSEL_VD_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER19_CLKSEL_VD_CLK"},
	{322, 13, "DEV_TIMER19_CLKSEL_VD_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER19_CLKSEL_VD_CLK"},
	{322, 14, "DEV_TIMER19_CLKSEL_VD_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER19_CLKSEL_VD_CLK"},
	{322, 15, "DEV_TIMER19_CLKSEL_VD_CLK_PARENT_CPSW_5XUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER19_CLKSEL_VD_CLK"},
	{322, 16, "DEV_TIMER19_CLKSEL_VD_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF4", "Parent input clock option to DEV_TIMER19_CLKSEL_VD_CLK"},
	{313, 0, "DEV_TIMER1_CLKSEL_VD_CLK", "Input muxed clock"},
	{313, 1, "DEV_TIMER1_CLKSEL_VD_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER1_CLKSEL_VD_CLK"},
	{313, 2, "DEV_TIMER1_CLKSEL_VD_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER1_CLKSEL_VD_CLK"},
	{313, 3, "DEV_TIMER1_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_TIMER1_CLKSEL_VD_CLK"},
	{313, 4, "DEV_TIMER1_CLKSEL_VD_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER1_CLKSEL_VD_CLK"},
	{313, 5, "DEV_TIMER1_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER1_CLKSEL_VD_CLK"},
	{313, 6, "DEV_TIMER1_CLKSEL_VD_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER1_CLKSEL_VD_CLK"},
	{313, 7, "DEV_TIMER1_CLKSEL_VD_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER1_CLKSEL_VD_CLK"},
	{313, 8, "DEV_TIMER1_CLKSEL_VD_CLK_PARENT_BOARD_0_WKUP_LF_CLKIN_OUT", "Parent input clock option to DEV_TIMER1_CLKSEL_VD_CLK"},
	{313, 9, "DEV_TIMER1_CLKSEL_VD_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER1_CLKSEL_VD_CLK"},
	{313, 10, "DEV_TIMER1_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER1_CLKSEL_VD_CLK"},
	{313, 11, "DEV_TIMER1_CLKSEL_VD_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER1_CLKSEL_VD_CLK"},
	{313, 12, "DEV_TIMER1_CLKSEL_VD_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER1_CLKSEL_VD_CLK"},
	{313, 13, "DEV_TIMER1_CLKSEL_VD_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER1_CLKSEL_VD_CLK"},
	{313, 14, "DEV_TIMER1_CLKSEL_VD_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER1_CLKSEL_VD_CLK"},
	{313, 15, "DEV_TIMER1_CLKSEL_VD_CLK_PARENT_CPSW_5XUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER1_CLKSEL_VD_CLK"},
	{313, 16, "DEV_TIMER1_CLKSEL_VD_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF4", "Parent input clock option to DEV_TIMER1_CLKSEL_VD_CLK"},
	{51, 0, "DEV_TIMER2_TIMER_HCLK_CLK", "Input clock"},
	{51, 1, "DEV_TIMER2_TIMER_TCLK_CLK", "Input muxed clock"},
	{51, 2, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{51, 3, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{51, 4, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{51, 5, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{51, 6, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{51, 7, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{51, 8, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{51, 9, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_BOARD_0_WKUP_LF_CLKIN_OUT", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{51, 10, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{51, 11, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{51, 12, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{51, 13, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{51, 14, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{51, 15, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{51, 16, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_CPSW_5XUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{51, 17, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF4", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{51, 26, "DEV_TIMER2_TIMER_PWM", "Output clock"},
	{52, 0, "DEV_TIMER3_TIMER_HCLK_CLK", "Input clock"},
	{52, 1, "DEV_TIMER3_TIMER_TCLK_CLK", "Input muxed clock"},
	{52, 2, "DEV_TIMER3_TIMER_TCLK_CLK_PARENT_MAIN_TIMER_CLKSEL_OUT3", "Parent input clock option to DEV_TIMER3_TIMER_TCLK_CLK"},
	{52, 3, "DEV_TIMER3_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MAIN_2_TIMER_PWM", "Parent input clock option to DEV_TIMER3_TIMER_TCLK_CLK"},
	{314, 0, "DEV_TIMER3_CLKSEL_VD_CLK", "Input muxed clock"},
	{314, 1, "DEV_TIMER3_CLKSEL_VD_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER3_CLKSEL_VD_CLK"},
	{314, 2, "DEV_TIMER3_CLKSEL_VD_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER3_CLKSEL_VD_CLK"},
	{314, 3, "DEV_TIMER3_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_TIMER3_CLKSEL_VD_CLK"},
	{314, 4, "DEV_TIMER3_CLKSEL_VD_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER3_CLKSEL_VD_CLK"},
	{314, 5, "DEV_TIMER3_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER3_CLKSEL_VD_CLK"},
	{314, 6, "DEV_TIMER3_CLKSEL_VD_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER3_CLKSEL_VD_CLK"},
	{314, 7, "DEV_TIMER3_CLKSEL_VD_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER3_CLKSEL_VD_CLK"},
	{314, 8, "DEV_TIMER3_CLKSEL_VD_CLK_PARENT_BOARD_0_WKUP_LF_CLKIN_OUT", "Parent input clock option to DEV_TIMER3_CLKSEL_VD_CLK"},
	{314, 9, "DEV_TIMER3_CLKSEL_VD_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER3_CLKSEL_VD_CLK"},
	{314, 10, "DEV_TIMER3_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER3_CLKSEL_VD_CLK"},
	{314, 11, "DEV_TIMER3_CLKSEL_VD_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER3_CLKSEL_VD_CLK"},
	{314, 12, "DEV_TIMER3_CLKSEL_VD_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER3_CLKSEL_VD_CLK"},
	{314, 13, "DEV_TIMER3_CLKSEL_VD_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER3_CLKSEL_VD_CLK"},
	{314, 14, "DEV_TIMER3_CLKSEL_VD_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER3_CLKSEL_VD_CLK"},
	{314, 15, "DEV_TIMER3_CLKSEL_VD_CLK_PARENT_CPSW_5XUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER3_CLKSEL_VD_CLK"},
	{314, 16, "DEV_TIMER3_CLKSEL_VD_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF4", "Parent input clock option to DEV_TIMER3_CLKSEL_VD_CLK"},
	{53, 0, "DEV_TIMER4_TIMER_HCLK_CLK", "Input clock"},
	{53, 1, "DEV_TIMER4_TIMER_TCLK_CLK", "Input muxed clock"},
	{53, 2, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{53, 3, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{53, 4, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{53, 5, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{53, 6, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{53, 7, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{53, 8, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{53, 9, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_BOARD_0_WKUP_LF_CLKIN_OUT", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{53, 10, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{53, 11, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{53, 12, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{53, 13, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{53, 14, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{53, 15, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{53, 16, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_CPSW_5XUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{53, 17, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF4", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{53, 26, "DEV_TIMER4_TIMER_PWM", "Output clock"},
	{54, 0, "DEV_TIMER5_TIMER_HCLK_CLK", "Input clock"},
	{54, 1, "DEV_TIMER5_TIMER_TCLK_CLK", "Input muxed clock"},
	{54, 2, "DEV_TIMER5_TIMER_TCLK_CLK_PARENT_MAIN_TIMER_CLKSEL_OUT5", "Parent input clock option to DEV_TIMER5_TIMER_TCLK_CLK"},
	{54, 3, "DEV_TIMER5_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MAIN_4_TIMER_PWM", "Parent input clock option to DEV_TIMER5_TIMER_TCLK_CLK"},
	{315, 0, "DEV_TIMER5_CLKSEL_VD_CLK", "Input muxed clock"},
	{315, 1, "DEV_TIMER5_CLKSEL_VD_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER5_CLKSEL_VD_CLK"},
	{315, 2, "DEV_TIMER5_CLKSEL_VD_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER5_CLKSEL_VD_CLK"},
	{315, 3, "DEV_TIMER5_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_TIMER5_CLKSEL_VD_CLK"},
	{315, 4, "DEV_TIMER5_CLKSEL_VD_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER5_CLKSEL_VD_CLK"},
	{315, 5, "DEV_TIMER5_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER5_CLKSEL_VD_CLK"},
	{315, 6, "DEV_TIMER5_CLKSEL_VD_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER5_CLKSEL_VD_CLK"},
	{315, 7, "DEV_TIMER5_CLKSEL_VD_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER5_CLKSEL_VD_CLK"},
	{315, 8, "DEV_TIMER5_CLKSEL_VD_CLK_PARENT_BOARD_0_WKUP_LF_CLKIN_OUT", "Parent input clock option to DEV_TIMER5_CLKSEL_VD_CLK"},
	{315, 9, "DEV_TIMER5_CLKSEL_VD_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER5_CLKSEL_VD_CLK"},
	{315, 10, "DEV_TIMER5_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER5_CLKSEL_VD_CLK"},
	{315, 11, "DEV_TIMER5_CLKSEL_VD_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER5_CLKSEL_VD_CLK"},
	{315, 12, "DEV_TIMER5_CLKSEL_VD_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER5_CLKSEL_VD_CLK"},
	{315, 13, "DEV_TIMER5_CLKSEL_VD_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER5_CLKSEL_VD_CLK"},
	{315, 14, "DEV_TIMER5_CLKSEL_VD_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER5_CLKSEL_VD_CLK"},
	{315, 15, "DEV_TIMER5_CLKSEL_VD_CLK_PARENT_CPSW_5XUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER5_CLKSEL_VD_CLK"},
	{315, 16, "DEV_TIMER5_CLKSEL_VD_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF4", "Parent input clock option to DEV_TIMER5_CLKSEL_VD_CLK"},
	{55, 0, "DEV_TIMER6_TIMER_HCLK_CLK", "Input clock"},
	{55, 1, "DEV_TIMER6_TIMER_TCLK_CLK", "Input muxed clock"},
	{55, 2, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{55, 3, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{55, 4, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{55, 5, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{55, 6, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{55, 7, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{55, 8, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{55, 9, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_BOARD_0_WKUP_LF_CLKIN_OUT", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{55, 10, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{55, 11, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{55, 12, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{55, 13, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{55, 14, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{55, 15, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{55, 16, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_CPSW_5XUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{55, 17, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF4", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{55, 26, "DEV_TIMER6_TIMER_PWM", "Output clock"},
	{57, 0, "DEV_TIMER7_TIMER_HCLK_CLK", "Input clock"},
	{57, 1, "DEV_TIMER7_TIMER_TCLK_CLK", "Input muxed clock"},
	{57, 2, "DEV_TIMER7_TIMER_TCLK_CLK_PARENT_MAIN_TIMER_CLKSEL_OUT7", "Parent input clock option to DEV_TIMER7_TIMER_TCLK_CLK"},
	{57, 3, "DEV_TIMER7_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MAIN_6_TIMER_PWM", "Parent input clock option to DEV_TIMER7_TIMER_TCLK_CLK"},
	{316, 0, "DEV_TIMER7_CLKSEL_VD_CLK", "Input muxed clock"},
	{316, 1, "DEV_TIMER7_CLKSEL_VD_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER7_CLKSEL_VD_CLK"},
	{316, 2, "DEV_TIMER7_CLKSEL_VD_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER7_CLKSEL_VD_CLK"},
	{316, 3, "DEV_TIMER7_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_TIMER7_CLKSEL_VD_CLK"},
	{316, 4, "DEV_TIMER7_CLKSEL_VD_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER7_CLKSEL_VD_CLK"},
	{316, 5, "DEV_TIMER7_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER7_CLKSEL_VD_CLK"},
	{316, 6, "DEV_TIMER7_CLKSEL_VD_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER7_CLKSEL_VD_CLK"},
	{316, 7, "DEV_TIMER7_CLKSEL_VD_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER7_CLKSEL_VD_CLK"},
	{316, 8, "DEV_TIMER7_CLKSEL_VD_CLK_PARENT_BOARD_0_WKUP_LF_CLKIN_OUT", "Parent input clock option to DEV_TIMER7_CLKSEL_VD_CLK"},
	{316, 9, "DEV_TIMER7_CLKSEL_VD_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER7_CLKSEL_VD_CLK"},
	{316, 10, "DEV_TIMER7_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER7_CLKSEL_VD_CLK"},
	{316, 11, "DEV_TIMER7_CLKSEL_VD_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER7_CLKSEL_VD_CLK"},
	{316, 12, "DEV_TIMER7_CLKSEL_VD_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER7_CLKSEL_VD_CLK"},
	{316, 13, "DEV_TIMER7_CLKSEL_VD_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER7_CLKSEL_VD_CLK"},
	{316, 14, "DEV_TIMER7_CLKSEL_VD_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER7_CLKSEL_VD_CLK"},
	{316, 15, "DEV_TIMER7_CLKSEL_VD_CLK_PARENT_CPSW_5XUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER7_CLKSEL_VD_CLK"},
	{316, 16, "DEV_TIMER7_CLKSEL_VD_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF4", "Parent input clock option to DEV_TIMER7_CLKSEL_VD_CLK"},
	{58, 0, "DEV_TIMER8_TIMER_HCLK_CLK", "Input clock"},
	{58, 1, "DEV_TIMER8_TIMER_TCLK_CLK", "Input muxed clock"},
	{58, 2, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{58, 3, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{58, 4, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{58, 5, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{58, 6, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{58, 7, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{58, 8, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{58, 9, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_BOARD_0_WKUP_LF_CLKIN_OUT", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{58, 10, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{58, 11, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{58, 12, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{58, 13, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{58, 14, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{58, 15, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{58, 16, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_CPSW_5XUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{58, 17, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF4", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{58, 26, "DEV_TIMER8_TIMER_PWM", "Output clock"},
	{59, 0, "DEV_TIMER9_TIMER_HCLK_CLK", "Input clock"},
	{59, 1, "DEV_TIMER9_TIMER_TCLK_CLK", "Input muxed clock"},
	{59, 2, "DEV_TIMER9_TIMER_TCLK_CLK_PARENT_MAIN_TIMER_CLKSEL_OUT9", "Parent input clock option to DEV_TIMER9_TIMER_TCLK_CLK"},
	{59, 3, "DEV_TIMER9_TIMER_TCLK_CLK_PARENT_DMTIMER_DMC1MS_MAIN_8_TIMER_PWM", "Parent input clock option to DEV_TIMER9_TIMER_TCLK_CLK"},
	{317, 0, "DEV_TIMER9_CLKSEL_VD_CLK", "Input muxed clock"},
	{317, 1, "DEV_TIMER9_CLKSEL_VD_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER9_CLKSEL_VD_CLK"},
	{317, 2, "DEV_TIMER9_CLKSEL_VD_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER9_CLKSEL_VD_CLK"},
	{317, 3, "DEV_TIMER9_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_TIMER9_CLKSEL_VD_CLK"},
	{317, 4, "DEV_TIMER9_CLKSEL_VD_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER9_CLKSEL_VD_CLK"},
	{317, 5, "DEV_TIMER9_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_3_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER9_CLKSEL_VD_CLK"},
	{317, 6, "DEV_TIMER9_CLKSEL_VD_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER9_CLKSEL_VD_CLK"},
	{317, 7, "DEV_TIMER9_CLKSEL_VD_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER9_CLKSEL_VD_CLK"},
	{317, 8, "DEV_TIMER9_CLKSEL_VD_CLK_PARENT_BOARD_0_WKUP_LF_CLKIN_OUT", "Parent input clock option to DEV_TIMER9_CLKSEL_VD_CLK"},
	{317, 9, "DEV_TIMER9_CLKSEL_VD_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER9_CLKSEL_VD_CLK"},
	{317, 10, "DEV_TIMER9_CLKSEL_VD_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER9_CLKSEL_VD_CLK"},
	{317, 11, "DEV_TIMER9_CLKSEL_VD_CLK_PARENT_POSTDIV2_16FFT_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER9_CLKSEL_VD_CLK"},
	{317, 12, "DEV_TIMER9_CLKSEL_VD_CLK_PARENT_HSDIV2_16FFT_MAIN_4_HSDIVOUT2_CLK", "Parent input clock option to DEV_TIMER9_CLKSEL_VD_CLK"},
	{317, 13, "DEV_TIMER9_CLKSEL_VD_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF2", "Parent input clock option to DEV_TIMER9_CLKSEL_VD_CLK"},
	{317, 14, "DEV_TIMER9_CLKSEL_VD_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF3", "Parent input clock option to DEV_TIMER9_CLKSEL_VD_CLK"},
	{317, 15, "DEV_TIMER9_CLKSEL_VD_CLK_PARENT_CPSW_5XUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER9_CLKSEL_VD_CLK"},
	{317, 16, "DEV_TIMER9_CLKSEL_VD_CLK_PARENT_NAVSS256VCL_MAIN_0_CPTS0_GENF4", "Parent input clock option to DEV_TIMER9_CLKSEL_VD_CLK"},
	{146, 2, "DEV_UART0_FCLK_CLK", "Input clock"},
	{146, 3, "DEV_UART0_VBUSP_CLK", "Input clock"},
	{278, 2, "DEV_UART1_FCLK_CLK", "Input clock"},
	{278, 3, "DEV_UART1_VBUSP_CLK", "Input clock"},
	{279, 2, "DEV_UART2_FCLK_CLK", "Input clock"},
	{279, 3, "DEV_UART2_VBUSP_CLK", "Input clock"},
	{280, 2, "DEV_UART3_FCLK_CLK", "Input clock"},
	{280, 3, "DEV_UART3_VBUSP_CLK", "Input clock"},
	{281, 2, "DEV_UART4_FCLK_CLK", "Input clock"},
	{281, 3, "DEV_UART4_VBUSP_CLK", "Input clock"},
	{282, 2, "DEV_UART5_FCLK_CLK", "Input clock"},
	{282, 3, "DEV_UART5_VBUSP_CLK", "Input clock"},
	{283, 2, "DEV_UART6_FCLK_CLK", "Input clock"},
	{283, 3, "DEV_UART6_VBUSP_CLK", "Input clock"},
	{284, 2, "DEV_UART7_FCLK_CLK", "Input clock"},
	{284, 3, "DEV_UART7_VBUSP_CLK", "Input clock"},
	{285, 2, "DEV_UART8_FCLK_CLK", "Input clock"},
	{285, 3, "DEV_UART8_VBUSP_CLK", "Input clock"},
	{286, 2, "DEV_UART9_FCLK_CLK", "Input clock"},
	{286, 3, "DEV_UART9_VBUSP_CLK", "Input clock"},
	{288, 0, "DEV_USB0_PIPE_REFCLK", "Input muxed clock"},
	{288, 1, "DEV_USB0_PIPE_REFCLK_PARENT_WIZ16B8M4CT2_MAIN_1_IP3_LN1_REFCLK", "Parent input clock option to DEV_USB0_PIPE_REFCLK"},
	{288, 2, "DEV_USB0_PIPE_REFCLK_PARENT_WIZ16B8M4CT2_MAIN_1_IP3_LN3_REFCLK", "Parent input clock option to DEV_USB0_PIPE_REFCLK"},
	{288, 3, "DEV_USB0_CLK_LPM_CLK", "Input clock"},
	{288, 4, "DEV_USB0_BUF_CLK", "Input clock"},
	{288, 5, "DEV_USB0_PIPE_TXFCLK", "Input clock"},
	{288, 6, "DEV_USB0_USB2_APB_PCLK_CLK", "Input clock"},
	{288, 7, "DEV_USB0_PIPE_RXCLK", "Input clock"},
	{288, 8, "DEV_USB0_PIPE_TXMCLK", "Input clock"},
	{288, 9, "DEV_USB0_PIPE_RXFCLK", "Input clock"},
	{288, 11, "DEV_USB0_PIPE_TXCLK", "Output clock"},
	{288, 12, "DEV_USB0_USB2_REFCLOCK_CLK", "Input muxed clock"},
	{288, 13, "DEV_USB0_USB2_REFCLOCK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_USB0_USB2_REFCLOCK_CLK"},
	{288, 14, "DEV_USB0_USB2_REFCLOCK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_USB0_USB2_REFCLOCK_CLK"},
	{288, 15, "DEV_USB0_PCLK_CLK", "Input clock"},
	{288, 17, "DEV_USB0_ACLK_CLK", "Input clock"},
	{145, 0, "DEV_WKUP_DDPA0_DDPA_CLK", "Input clock"},
	{99, 0, "DEV_WKUP_ESM0_CLK", "Input clock"},
	{113, 0, "DEV_WKUP_GPIO0_MMR_CLK", "Input muxed clock"},
	{113, 1, "DEV_WKUP_GPIO0_MMR_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK6", "Parent input clock option to DEV_WKUP_GPIO0_MMR_CLK"},
	{113, 2, "DEV_WKUP_GPIO0_MMR_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK6_DUP0", "Parent input clock option to DEV_WKUP_GPIO0_MMR_CLK"},
	{113, 3, "DEV_WKUP_GPIO0_MMR_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_WKUP_GPIO0_MMR_CLK"},
	{113, 4, "DEV_WKUP_GPIO0_MMR_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_WKUP_GPIO0_MMR_CLK"},
	{114, 0, "DEV_WKUP_GPIO1_MMR_CLK", "Input muxed clock"},
	{114, 1, "DEV_WKUP_GPIO1_MMR_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK6", "Parent input clock option to DEV_WKUP_GPIO1_MMR_CLK"},
	{114, 2, "DEV_WKUP_GPIO1_MMR_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_CHIP_DIV1_CLK_CLK6_DUP0", "Parent input clock option to DEV_WKUP_GPIO1_MMR_CLK"},
	{114, 3, "DEV_WKUP_GPIO1_MMR_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_WKUP_GPIO1_MMR_CLK"},
	{114, 4, "DEV_WKUP_GPIO1_MMR_CLK_PARENT_J7VC_WAKEUP_16FF_WKUP_0_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_WKUP_GPIO1_MMR_CLK"},
	{197, 0, "DEV_WKUP_I2C0_PISCL", "Input clock"},
	{197, 1, "DEV_WKUP_I2C0_PISYS_CLK", "Input clock"},
	{197, 2, "DEV_WKUP_I2C0_CLK", "Input clock"},
	{197, 3, "DEV_WKUP_I2C0_PORSCL", "Output clock"},
	{132, 0, "DEV_WKUP_PORZ_SYNC0_CLK_12M_RC_CLK", "Input clock"},
	{138, 0, "DEV_WKUP_PSC0_SLOW_CLK", "Input clock"},
	{138, 1, "DEV_WKUP_PSC0_CLK", "Input clock"},
	{287, 2, "DEV_WKUP_UART0_FCLK_CLK", "Input muxed clock"},
	{287, 3, "DEV_WKUP_UART0_FCLK_CLK_PARENT_WKUPUSART_CLK_SEL_OUT0", "Parent input clock option to DEV_WKUP_UART0_FCLK_CLK"},
	{287, 4, "DEV_WKUP_UART0_FCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_WKUP_UART0_FCLK_CLK"},
	{287, 5, "DEV_WKUP_UART0_VBUSP_CLK", "Input clock"},
	{154, 0, "DEV_WKUP_VTM0_FIX_REF2_CLK", "Input clock"},
	{154, 1, "DEV_WKUP_VTM0_VBUSP_CLK", "Input clock"},
	{154, 2, "DEV_WKUP_VTM0_FIX_REF_CLK", "Input clock"},
	{40, 0, "DEV_WKUP_WAKEUP0_PLL_CTRL_WKUP_CLK24_CLK", "Input clock"},
	{40, 1, "DEV_WKUP_WAKEUP0_WKUP_RCOSC_32K_CLK", "Output clock"},
	{40, 2, "DEV_WKUP_WAKEUP0_WKUP_RCOSC_12P5M_CLK", "Output clock"},
};
