# ISOMAP -- Draws ellipses taken from a isophote table.
#
# A SDAS table generated by task ELLIPSE is rebinned in a number of
# intensity levels. Task CONTOUR is used to draw image contours at
# those levels, hidden task MAP creates a set of tables whith the
# ellipse points, and those tables are fed to task SGRAPH for
# overploting on the contour map. A maximum of 10 levels is allowed.
#
#						Ivo Busko   11/89

procedure isomap (image, table, floor, ceiling)

char	image   = ""         {prompt="input image"}
char	table   = ""         {prompt="input table"}
real	floor                {prompt="minimum contouring level"}
real	ceiling              {prompt="maximum contouring level"}
int	nlevels = 3          {min=2, max=10, prompt="number of levels"}
char	device  = "stdgraph" {prompt="graphics device"}

begin
	file	tab, temp, temp2, ima
	char	list, dev, sfunc, sdec, sdeg, smark,seq
	int	ncu, snc
	real	min, max, stp, sflo, scei, sint, szmar
	bool	sverb, sappe, spoin, slabe

	# Check for the presence of pre-requisite packages.
	if (!deftask("tsort")) {
	    print ("Package 'ttools' must be loaded first !\n")
	    bye
	}
	if (!deftask("sgraph")) {
	    print ("Package 'stplot' or 'tbplot' must be loaded first !\n")
	    bye
	}
	if (!deftask("contour")) {
	    print ("Package 'plot'  must be loaded first !\n")
	    bye
	}

	# Read task parameters.
	ima = image
	tab = table
	min = floor
	max = ceiling
	ncu = nlevels
	if (ncu > 10) {
	    print ("Maximum of 10 levels !\n")
	    bye
	}
	stp = (max - min) / (ncu - 1)
	dev = device

	# Save called task parameters.
	sfunc = trebin.function
	sverb = trebin.verbose
	sflo  = contour.floor
	scei  = contour.ceiling
	snc   = contour.ncontours
	sint  = contour.interval
	slabe = contour.label
	sdec  = contour.device
	sappe = dvpar.append
	sdeg  = dvpar.device
	spoin = pltpar.pointmode
	smark = pltpar.marker
	szmar = pltpar.szmarker
	seq   = tcalc.equals

	# Do it.
	tsort (tab, "INTENS")

	temp2 = mktemp ("tmp$treb")		# Get rid of flipping PA
	tcopy (tab, temp2, verbose-)
	tcalc (temp2, "PA", "if PA<0. then PA+180. else PA", datatype="real")

	temp = mktemp ("tmp$treb")
	trebin.function = "linear"
	trebin.verbose  = no
	trebin (temp2, temp, "INTENS", min, max, stp, extrapolate+)

	map (ima, temp, "tp", 0)

	list = "tp.001"
	for (i = 2; i <= ncu; i=i+1) {
	    if (i < 10)
	        list = list // ",tp.00" // i
	    else
	        list = list // ",tp.0" // i
	}
	contour.floor     = min
	contour.ceiling   = max
	contour.ncontours = 0
	contour.interval  = stp
	contour.label     = no
	contour.device    = dev
	contour (ima)

	dvpar.append     = yes
	dvpar.device     = dev
	pltpar.pointmode = no
	pltpar.marker    = "box"
	pltpar.szmarker  = 0.005
	sgraph (list)

	# Restore called task parameters.
	trebin.function   = sfunc
	trebin.verbose    = sverb
	contour.floor     = sflo
	contour.ceiling   = scei
	contour.ncontours = snc
	contour.interval  = sint
	contour.device    = sdec
	contour.label     = slabe
	dvpar.append      = sappe
	dvpar.device      = sdeg
	pltpar.pointmode  = spoin
	pltpar.marker     = smark
	pltpar.szmarker   = szmar
	tcalc.equals      = seq

	# Delete temporary files.
	delete (temp // ".tab", verify = no)
	delete (temp2 // ".tab", verify = no)
	delete ("tp*.0*", verify = no)
end
